/*
 * Copyright (C) 2019-2022, Xilinx, Inc.
 * Copyright (C) 2022-2025, Advanced Micro Devices, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef __FFT_IFFT_DIT_TWIDDLE_LUT_H__
#define __FFT_IFFT_DIT_TWIDDLE_LUT_H__

#include <adf.h>
#include "device_defs.h"

// The values in this file were created using twiddle.c
// namespace xf { namespace dsp { namespace aie { namespace fft {
static constexpr int kMasterTableSize = 2048;
const cint16 twiddle_master_cint16[kMasterTableSize] = {
    {32767, 0},       {32767, -50},     {32767, -101},    {32767, -151},    {32767, -201},    {32767, -251},
    {32767, -302},    {32766, -352},    {32766, -402},    {32765, -452},    {32764, -503},    {32763, -553},
    {32762, -603},    {32761, -653},    {32760, -704},    {32759, -754},    {32758, -804},    {32757, -854},
    {32756, -905},    {32754, -955},    {32753, -1005},   {32751, -1055},   {32749, -1106},   {32748, -1156},
    {32746, -1206},   {32744, -1256},   {32742, -1307},   {32740, -1357},   {32738, -1407},   {32736, -1457},
    {32733, -1507},   {32731, -1558},   {32729, -1608},   {32726, -1658},   {32723, -1708},   {32721, -1758},
    {32718, -1809},   {32715, -1859},   {32712, -1909},   {32709, -1959},   {32706, -2009},   {32703, -2060},
    {32700, -2110},   {32697, -2160},   {32693, -2210},   {32690, -2260},   {32686, -2310},   {32683, -2360},
    {32679, -2411},   {32675, -2461},   {32672, -2511},   {32668, -2561},   {32664, -2611},   {32660, -2661},
    {32656, -2711},   {32651, -2761},   {32647, -2811},   {32643, -2861},   {32638, -2912},   {32634, -2962},
    {32629, -3012},   {32625, -3062},   {32620, -3112},   {32615, -3162},   {32610, -3212},   {32605, -3262},
    {32600, -3312},   {32595, -3362},   {32590, -3412},   {32585, -3462},   {32579, -3512},   {32574, -3562},
    {32568, -3612},   {32563, -3662},   {32557, -3712},   {32551, -3762},   {32546, -3812},   {32540, -3861},
    {32534, -3911},   {32528, -3961},   {32522, -4011},   {32515, -4061},   {32509, -4111},   {32503, -4161},
    {32496, -4211},   {32490, -4260},   {32483, -4310},   {32477, -4360},   {32470, -4410},   {32463, -4460},
    {32456, -4510},   {32449, -4559},   {32442, -4609},   {32435, -4659},   {32428, -4709},   {32421, -4758},
    {32413, -4808},   {32406, -4858},   {32398, -4907},   {32391, -4957},   {32383, -5007},   {32376, -5057},
    {32368, -5106},   {32360, -5156},   {32352, -5205},   {32344, -5255},   {32336, -5305},   {32328, -5354},
    {32319, -5404},   {32311, -5453},   {32303, -5503},   {32294, -5553},   {32286, -5602},   {32277, -5652},
    {32268, -5701},   {32259, -5751},   {32251, -5800},   {32242, -5850},   {32233, -5899},   {32224, -5948},
    {32214, -5998},   {32205, -6047},   {32196, -6097},   {32186, -6146},   {32177, -6195},   {32167, -6245},
    {32158, -6294},   {32148, -6343},   {32138, -6393},   {32129, -6442},   {32119, -6491},   {32109, -6541},
    {32099, -6590},   {32088, -6639},   {32078, -6688},   {32068, -6737},   {32058, -6787},   {32047, -6836},
    {32037, -6885},   {32026, -6934},   {32015, -6983},   {32005, -7032},   {31994, -7081},   {31983, -7130},
    {31972, -7180},   {31961, -7229},   {31950, -7278},   {31938, -7327},   {31927, -7376},   {31916, -7425},
    {31904, -7473},   {31893, -7522},   {31881, -7571},   {31870, -7620},   {31858, -7669},   {31846, -7718},
    {31834, -7767},   {31822, -7816},   {31810, -7864},   {31798, -7913},   {31786, -7962},   {31774, -8011},
    {31761, -8059},   {31749, -8108},   {31737, -8157},   {31724, -8206},   {31711, -8254},   {31699, -8303},
    {31686, -8351},   {31673, -8400},   {31660, -8449},   {31647, -8497},   {31634, -8546},   {31621, -8594},
    {31608, -8643},   {31594, -8691},   {31581, -8740},   {31568, -8788},   {31554, -8836},   {31540, -8885},
    {31527, -8933},   {31513, -8982},   {31499, -9030},   {31485, -9078},   {31471, -9127},   {31457, -9175},
    {31443, -9223},   {31429, -9271},   {31415, -9319},   {31400, -9368},   {31386, -9416},   {31372, -9464},
    {31357, -9512},   {31342, -9560},   {31328, -9608},   {31313, -9656},   {31298, -9704},   {31283, -9752},
    {31268, -9800},   {31253, -9848},   {31238, -9896},   {31223, -9944},   {31207, -9992},   {31192, -10040},
    {31177, -10088},  {31161, -10135},  {31146, -10183},  {31130, -10231},  {31114, -10279},  {31098, -10326},
    {31082, -10374},  {31067, -10422},  {31050, -10469},  {31034, -10517},  {31018, -10565},  {31002, -10612},
    {30986, -10660},  {30969, -10707},  {30953, -10755},  {30936, -10802},  {30920, -10850},  {30903, -10897},
    {30886, -10945},  {30869, -10992},  {30853, -11039},  {30836, -11087},  {30819, -11134},  {30801, -11181},
    {30784, -11228},  {30767, -11276},  {30750, -11323},  {30732, -11370},  {30715, -11417},  {30697, -11464},
    {30680, -11511},  {30662, -11558},  {30644, -11605},  {30626, -11652},  {30608, -11699},  {30590, -11746},
    {30572, -11793},  {30554, -11840},  {30536, -11887},  {30518, -11934},  {30499, -11980},  {30481, -12027},
    {30462, -12074},  {30444, -12121},  {30425, -12167},  {30407, -12214},  {30388, -12261},  {30369, -12307},
    {30350, -12354},  {30331, -12400},  {30312, -12447},  {30293, -12493},  {30274, -12540},  {30254, -12586},
    {30235, -12633},  {30216, -12679},  {30196, -12725},  {30177, -12772},  {30157, -12818},  {30137, -12864},
    {30118, -12910},  {30098, -12957},  {30078, -13003},  {30058, -13049},  {30038, -13095},  {30018, -13141},
    {29997, -13187},  {29977, -13233},  {29957, -13279},  {29936, -13325},  {29916, -13371},  {29895, -13417},
    {29875, -13463},  {29854, -13508},  {29833, -13554},  {29813, -13600},  {29792, -13646},  {29771, -13691},
    {29750, -13737},  {29729, -13783},  {29707, -13828},  {29686, -13874},  {29665, -13919},  {29643, -13965},
    {29622, -14010},  {29600, -14056},  {29579, -14101},  {29557, -14146},  {29535, -14192},  {29514, -14237},
    {29492, -14282},  {29470, -14327},  {29448, -14373},  {29426, -14418},  {29404, -14463},  {29381, -14508},
    {29359, -14553},  {29337, -14598},  {29314, -14643},  {29292, -14688},  {29269, -14733},  {29247, -14778},
    {29224, -14823},  {29201, -14867},  {29178, -14912},  {29155, -14957},  {29132, -15002},  {29109, -15046},
    {29086, -15091},  {29063, -15136},  {29040, -15180},  {29016, -15225},  {28993, -15269},  {28970, -15314},
    {28946, -15358},  {28922, -15402},  {28899, -15447},  {28875, -15491},  {28851, -15535},  {28827, -15580},
    {28803, -15624},  {28779, -15668},  {28755, -15712},  {28731, -15756},  {28707, -15800},  {28683, -15844},
    {28658, -15888},  {28634, -15932},  {28610, -15976},  {28585, -16020},  {28560, -16064},  {28536, -16108},
    {28511, -16151},  {28486, -16195},  {28461, -16239},  {28436, -16282},  {28411, -16326},  {28386, -16369},
    {28361, -16413},  {28336, -16456},  {28311, -16500},  {28285, -16543},  {28260, -16587},  {28234, -16630},
    {28209, -16673},  {28183, -16717},  {28158, -16760},  {28132, -16803},  {28106, -16846},  {28080, -16889},
    {28054, -16932},  {28028, -16975},  {28002, -17018},  {27976, -17061},  {27950, -17104},  {27924, -17147},
    {27897, -17190},  {27871, -17233},  {27844, -17275},  {27818, -17318},  {27791, -17361},  {27765, -17403},
    {27738, -17446},  {27711, -17488},  {27684, -17531},  {27657, -17573},  {27630, -17616},  {27603, -17658},
    {27576, -17700},  {27549, -17743},  {27522, -17785},  {27494, -17827},  {27467, -17869},  {27440, -17911},
    {27412, -17953},  {27384, -17995},  {27357, -18037},  {27329, -18079},  {27301, -18121},  {27273, -18163},
    {27246, -18205},  {27218, -18247},  {27190, -18288},  {27162, -18330},  {27133, -18372},  {27105, -18413},
    {27077, -18455},  {27049, -18496},  {27020, -18538},  {26992, -18579},  {26963, -18621},  {26935, -18662},
    {26906, -18703},  {26877, -18745},  {26848, -18786},  {26820, -18827},  {26791, -18868},  {26762, -18909},
    {26733, -18950},  {26704, -18991},  {26674, -19032},  {26645, -19073},  {26616, -19114},  {26586, -19155},
    {26557, -19195},  {26528, -19236},  {26498, -19277},  {26468, -19317},  {26439, -19358},  {26409, -19399},
    {26379, -19439},  {26349, -19479},  {26320, -19520},  {26290, -19560},  {26259, -19601},  {26229, -19641},
    {26199, -19681},  {26169, -19721},  {26139, -19761},  {26108, -19801},  {26078, -19841},  {26048, -19881},
    {26017, -19921},  {25986, -19961},  {25956, -20001},  {25925, -20041},  {25894, -20081},  {25863, -20120},
    {25833, -20160},  {25802, -20200},  {25771, -20239},  {25739, -20279},  {25708, -20318},  {25677, -20357},
    {25646, -20397},  {25615, -20436},  {25583, -20475},  {25552, -20515},  {25520, -20554},  {25489, -20593},
    {25457, -20632},  {25425, -20671},  {25394, -20710},  {25362, -20749},  {25330, -20788},  {25298, -20827},
    {25266, -20865},  {25234, -20904},  {25202, -20943},  {25170, -20981},  {25138, -21020},  {25105, -21059},
    {25073, -21097},  {25041, -21136},  {25008, -21174},  {24976, -21212},  {24943, -21251},  {24910, -21289},
    {24878, -21327},  {24845, -21365},  {24812, -21403},  {24779, -21441},  {24746, -21479},  {24713, -21517},
    {24680, -21555},  {24647, -21593},  {24614, -21631},  {24581, -21668},  {24548, -21706},  {24514, -21744},
    {24481, -21781},  {24448, -21819},  {24414, -21856},  {24380, -21894},  {24347, -21931},  {24313, -21968},
    {24279, -22006},  {24246, -22043},  {24212, -22080},  {24178, -22117},  {24144, -22154},  {24110, -22191},
    {24076, -22228},  {24042, -22265},  {24008, -22302},  {23973, -22339},  {23939, -22375},  {23905, -22412},
    {23870, -22449},  {23836, -22485},  {23801, -22522},  {23767, -22558},  {23732, -22595},  {23697, -22631},
    {23663, -22668},  {23628, -22704},  {23593, -22740},  {23558, -22776},  {23523, -22812},  {23488, -22848},
    {23453, -22884},  {23418, -22920},  {23383, -22956},  {23348, -22992},  {23312, -23028},  {23277, -23064},
    {23241, -23099},  {23206, -23135},  {23170, -23170},  {23135, -23206},  {23099, -23241},  {23064, -23277},
    {23028, -23312},  {22992, -23348},  {22956, -23383},  {22920, -23418},  {22884, -23453},  {22848, -23488},
    {22812, -23523},  {22776, -23558},  {22740, -23593},  {22704, -23628},  {22668, -23663},  {22631, -23697},
    {22595, -23732},  {22558, -23767},  {22522, -23801},  {22485, -23836},  {22449, -23870},  {22412, -23905},
    {22375, -23939},  {22339, -23973},  {22302, -24008},  {22265, -24042},  {22228, -24076},  {22191, -24110},
    {22154, -24144},  {22117, -24178},  {22080, -24212},  {22043, -24246},  {22006, -24279},  {21968, -24313},
    {21931, -24347},  {21894, -24380},  {21856, -24414},  {21819, -24448},  {21781, -24481},  {21744, -24514},
    {21706, -24548},  {21668, -24581},  {21631, -24614},  {21593, -24647},  {21555, -24680},  {21517, -24713},
    {21479, -24746},  {21441, -24779},  {21403, -24812},  {21365, -24845},  {21327, -24878},  {21289, -24910},
    {21251, -24943},  {21212, -24976},  {21174, -25008},  {21136, -25041},  {21097, -25073},  {21059, -25105},
    {21020, -25138},  {20981, -25170},  {20943, -25202},  {20904, -25234},  {20865, -25266},  {20827, -25298},
    {20788, -25330},  {20749, -25362},  {20710, -25394},  {20671, -25425},  {20632, -25457},  {20593, -25489},
    {20554, -25520},  {20515, -25552},  {20475, -25583},  {20436, -25615},  {20397, -25646},  {20357, -25677},
    {20318, -25708},  {20279, -25739},  {20239, -25771},  {20200, -25802},  {20160, -25833},  {20120, -25863},
    {20081, -25894},  {20041, -25925},  {20001, -25956},  {19961, -25986},  {19921, -26017},  {19881, -26048},
    {19841, -26078},  {19801, -26108},  {19761, -26139},  {19721, -26169},  {19681, -26199},  {19641, -26229},
    {19601, -26259},  {19560, -26290},  {19520, -26320},  {19479, -26349},  {19439, -26379},  {19399, -26409},
    {19358, -26439},  {19317, -26468},  {19277, -26498},  {19236, -26528},  {19195, -26557},  {19155, -26586},
    {19114, -26616},  {19073, -26645},  {19032, -26674},  {18991, -26704},  {18950, -26733},  {18909, -26762},
    {18868, -26791},  {18827, -26820},  {18786, -26848},  {18745, -26877},  {18703, -26906},  {18662, -26935},
    {18621, -26963},  {18579, -26992},  {18538, -27020},  {18496, -27049},  {18455, -27077},  {18413, -27105},
    {18372, -27133},  {18330, -27162},  {18288, -27190},  {18247, -27218},  {18205, -27246},  {18163, -27273},
    {18121, -27301},  {18079, -27329},  {18037, -27357},  {17995, -27384},  {17953, -27412},  {17911, -27440},
    {17869, -27467},  {17827, -27494},  {17785, -27522},  {17743, -27549},  {17700, -27576},  {17658, -27603},
    {17616, -27630},  {17573, -27657},  {17531, -27684},  {17488, -27711},  {17446, -27738},  {17403, -27765},
    {17361, -27791},  {17318, -27818},  {17275, -27844},  {17233, -27871},  {17190, -27897},  {17147, -27924},
    {17104, -27950},  {17061, -27976},  {17018, -28002},  {16975, -28028},  {16932, -28054},  {16889, -28080},
    {16846, -28106},  {16803, -28132},  {16760, -28158},  {16717, -28183},  {16673, -28209},  {16630, -28234},
    {16587, -28260},  {16543, -28285},  {16500, -28311},  {16456, -28336},  {16413, -28361},  {16369, -28386},
    {16326, -28411},  {16282, -28436},  {16239, -28461},  {16195, -28486},  {16151, -28511},  {16108, -28536},
    {16064, -28560},  {16020, -28585},  {15976, -28610},  {15932, -28634},  {15888, -28658},  {15844, -28683},
    {15800, -28707},  {15756, -28731},  {15712, -28755},  {15668, -28779},  {15624, -28803},  {15580, -28827},
    {15535, -28851},  {15491, -28875},  {15447, -28899},  {15402, -28922},  {15358, -28946},  {15314, -28970},
    {15269, -28993},  {15225, -29016},  {15180, -29040},  {15136, -29063},  {15091, -29086},  {15046, -29109},
    {15002, -29132},  {14957, -29155},  {14912, -29178},  {14867, -29201},  {14823, -29224},  {14778, -29247},
    {14733, -29269},  {14688, -29292},  {14643, -29314},  {14598, -29337},  {14553, -29359},  {14508, -29381},
    {14463, -29404},  {14418, -29426},  {14373, -29448},  {14327, -29470},  {14282, -29492},  {14237, -29514},
    {14192, -29535},  {14146, -29557},  {14101, -29579},  {14056, -29600},  {14010, -29622},  {13965, -29643},
    {13919, -29665},  {13874, -29686},  {13828, -29707},  {13783, -29729},  {13737, -29750},  {13691, -29771},
    {13646, -29792},  {13600, -29813},  {13554, -29833},  {13508, -29854},  {13463, -29875},  {13417, -29895},
    {13371, -29916},  {13325, -29936},  {13279, -29957},  {13233, -29977},  {13187, -29997},  {13141, -30018},
    {13095, -30038},  {13049, -30058},  {13003, -30078},  {12957, -30098},  {12910, -30118},  {12864, -30137},
    {12818, -30157},  {12772, -30177},  {12725, -30196},  {12679, -30216},  {12633, -30235},  {12586, -30254},
    {12540, -30274},  {12493, -30293},  {12447, -30312},  {12400, -30331},  {12354, -30350},  {12307, -30369},
    {12261, -30388},  {12214, -30407},  {12167, -30425},  {12121, -30444},  {12074, -30462},  {12027, -30481},
    {11980, -30499},  {11934, -30518},  {11887, -30536},  {11840, -30554},  {11793, -30572},  {11746, -30590},
    {11699, -30608},  {11652, -30626},  {11605, -30644},  {11558, -30662},  {11511, -30680},  {11464, -30697},
    {11417, -30715},  {11370, -30732},  {11323, -30750},  {11276, -30767},  {11228, -30784},  {11181, -30801},
    {11134, -30819},  {11087, -30836},  {11039, -30853},  {10992, -30869},  {10945, -30886},  {10897, -30903},
    {10850, -30920},  {10802, -30936},  {10755, -30953},  {10707, -30969},  {10660, -30986},  {10612, -31002},
    {10565, -31018},  {10517, -31034},  {10469, -31050},  {10422, -31067},  {10374, -31082},  {10326, -31098},
    {10279, -31114},  {10231, -31130},  {10183, -31146},  {10135, -31161},  {10088, -31177},  {10040, -31192},
    {9992, -31207},   {9944, -31223},   {9896, -31238},   {9848, -31253},   {9800, -31268},   {9752, -31283},
    {9704, -31298},   {9656, -31313},   {9608, -31328},   {9560, -31342},   {9512, -31357},   {9464, -31372},
    {9416, -31386},   {9368, -31400},   {9319, -31415},   {9271, -31429},   {9223, -31443},   {9175, -31457},
    {9127, -31471},   {9078, -31485},   {9030, -31499},   {8982, -31513},   {8933, -31527},   {8885, -31540},
    {8836, -31554},   {8788, -31568},   {8740, -31581},   {8691, -31594},   {8643, -31608},   {8594, -31621},
    {8546, -31634},   {8497, -31647},   {8449, -31660},   {8400, -31673},   {8351, -31686},   {8303, -31699},
    {8254, -31711},   {8206, -31724},   {8157, -31737},   {8108, -31749},   {8059, -31761},   {8011, -31774},
    {7962, -31786},   {7913, -31798},   {7864, -31810},   {7816, -31822},   {7767, -31834},   {7718, -31846},
    {7669, -31858},   {7620, -31870},   {7571, -31881},   {7522, -31893},   {7473, -31904},   {7425, -31916},
    {7376, -31927},   {7327, -31938},   {7278, -31950},   {7229, -31961},   {7180, -31972},   {7130, -31983},
    {7081, -31994},   {7032, -32005},   {6983, -32015},   {6934, -32026},   {6885, -32037},   {6836, -32047},
    {6787, -32058},   {6737, -32068},   {6688, -32078},   {6639, -32088},   {6590, -32099},   {6541, -32109},
    {6491, -32119},   {6442, -32129},   {6393, -32138},   {6343, -32148},   {6294, -32158},   {6245, -32167},
    {6195, -32177},   {6146, -32186},   {6097, -32196},   {6047, -32205},   {5998, -32214},   {5948, -32224},
    {5899, -32233},   {5850, -32242},   {5800, -32251},   {5751, -32259},   {5701, -32268},   {5652, -32277},
    {5602, -32286},   {5553, -32294},   {5503, -32303},   {5453, -32311},   {5404, -32319},   {5354, -32328},
    {5305, -32336},   {5255, -32344},   {5205, -32352},   {5156, -32360},   {5106, -32368},   {5057, -32376},
    {5007, -32383},   {4957, -32391},   {4907, -32398},   {4858, -32406},   {4808, -32413},   {4758, -32421},
    {4709, -32428},   {4659, -32435},   {4609, -32442},   {4559, -32449},   {4510, -32456},   {4460, -32463},
    {4410, -32470},   {4360, -32477},   {4310, -32483},   {4260, -32490},   {4211, -32496},   {4161, -32503},
    {4111, -32509},   {4061, -32515},   {4011, -32522},   {3961, -32528},   {3911, -32534},   {3861, -32540},
    {3812, -32546},   {3762, -32551},   {3712, -32557},   {3662, -32563},   {3612, -32568},   {3562, -32574},
    {3512, -32579},   {3462, -32585},   {3412, -32590},   {3362, -32595},   {3312, -32600},   {3262, -32605},
    {3212, -32610},   {3162, -32615},   {3112, -32620},   {3062, -32625},   {3012, -32629},   {2962, -32634},
    {2912, -32638},   {2861, -32643},   {2811, -32647},   {2761, -32651},   {2711, -32656},   {2661, -32660},
    {2611, -32664},   {2561, -32668},   {2511, -32672},   {2461, -32675},   {2411, -32679},   {2360, -32683},
    {2310, -32686},   {2260, -32690},   {2210, -32693},   {2160, -32697},   {2110, -32700},   {2060, -32703},
    {2009, -32706},   {1959, -32709},   {1909, -32712},   {1859, -32715},   {1809, -32718},   {1758, -32721},
    {1708, -32723},   {1658, -32726},   {1608, -32729},   {1558, -32731},   {1507, -32733},   {1457, -32736},
    {1407, -32738},   {1357, -32740},   {1307, -32742},   {1256, -32744},   {1206, -32746},   {1156, -32748},
    {1106, -32749},   {1055, -32751},   {1005, -32753},   {955, -32754},    {905, -32756},    {854, -32757},
    {804, -32758},    {754, -32759},    {704, -32760},    {653, -32761},    {603, -32762},    {553, -32763},
    {503, -32764},    {452, -32765},    {402, -32766},    {352, -32766},    {302, -32767},    {251, -32767},
    {201, -32767},    {151, -32768},    {101, -32768},    {50, -32768},     {0, -32768},      {-50, -32768},
    {-101, -32768},   {-151, -32768},   {-201, -32767},   {-251, -32767},   {-302, -32767},   {-352, -32766},
    {-402, -32766},   {-452, -32765},   {-503, -32764},   {-553, -32763},   {-603, -32762},   {-653, -32761},
    {-704, -32760},   {-754, -32759},   {-804, -32758},   {-854, -32757},   {-905, -32756},   {-955, -32754},
    {-1005, -32753},  {-1055, -32751},  {-1106, -32749},  {-1156, -32748},  {-1206, -32746},  {-1256, -32744},
    {-1307, -32742},  {-1357, -32740},  {-1407, -32738},  {-1457, -32736},  {-1507, -32733},  {-1558, -32731},
    {-1608, -32729},  {-1658, -32726},  {-1708, -32723},  {-1758, -32721},  {-1809, -32718},  {-1859, -32715},
    {-1909, -32712},  {-1959, -32709},  {-2009, -32706},  {-2060, -32703},  {-2110, -32700},  {-2160, -32697},
    {-2210, -32693},  {-2260, -32690},  {-2310, -32686},  {-2360, -32683},  {-2411, -32679},  {-2461, -32675},
    {-2511, -32672},  {-2561, -32668},  {-2611, -32664},  {-2661, -32660},  {-2711, -32656},  {-2761, -32651},
    {-2811, -32647},  {-2861, -32643},  {-2912, -32638},  {-2962, -32634},  {-3012, -32629},  {-3062, -32625},
    {-3112, -32620},  {-3162, -32615},  {-3212, -32610},  {-3262, -32605},  {-3312, -32600},  {-3362, -32595},
    {-3412, -32590},  {-3462, -32585},  {-3512, -32579},  {-3562, -32574},  {-3612, -32568},  {-3662, -32563},
    {-3712, -32557},  {-3762, -32551},  {-3812, -32546},  {-3861, -32540},  {-3911, -32534},  {-3961, -32528},
    {-4011, -32522},  {-4061, -32515},  {-4111, -32509},  {-4161, -32503},  {-4211, -32496},  {-4260, -32490},
    {-4310, -32483},  {-4360, -32477},  {-4410, -32470},  {-4460, -32463},  {-4510, -32456},  {-4559, -32449},
    {-4609, -32442},  {-4659, -32435},  {-4709, -32428},  {-4758, -32421},  {-4808, -32413},  {-4858, -32406},
    {-4907, -32398},  {-4957, -32391},  {-5007, -32383},  {-5057, -32376},  {-5106, -32368},  {-5156, -32360},
    {-5205, -32352},  {-5255, -32344},  {-5305, -32336},  {-5354, -32328},  {-5404, -32319},  {-5453, -32311},
    {-5503, -32303},  {-5553, -32294},  {-5602, -32286},  {-5652, -32277},  {-5701, -32268},  {-5751, -32259},
    {-5800, -32251},  {-5850, -32242},  {-5899, -32233},  {-5948, -32224},  {-5998, -32214},  {-6047, -32205},
    {-6097, -32196},  {-6146, -32186},  {-6195, -32177},  {-6245, -32167},  {-6294, -32158},  {-6343, -32148},
    {-6393, -32138},  {-6442, -32129},  {-6491, -32119},  {-6541, -32109},  {-6590, -32099},  {-6639, -32088},
    {-6688, -32078},  {-6737, -32068},  {-6787, -32058},  {-6836, -32047},  {-6885, -32037},  {-6934, -32026},
    {-6983, -32015},  {-7032, -32005},  {-7081, -31994},  {-7130, -31983},  {-7180, -31972},  {-7229, -31961},
    {-7278, -31950},  {-7327, -31938},  {-7376, -31927},  {-7425, -31916},  {-7473, -31904},  {-7522, -31893},
    {-7571, -31881},  {-7620, -31870},  {-7669, -31858},  {-7718, -31846},  {-7767, -31834},  {-7816, -31822},
    {-7864, -31810},  {-7913, -31798},  {-7962, -31786},  {-8011, -31774},  {-8059, -31761},  {-8108, -31749},
    {-8157, -31737},  {-8206, -31724},  {-8254, -31711},  {-8303, -31699},  {-8351, -31686},  {-8400, -31673},
    {-8449, -31660},  {-8497, -31647},  {-8546, -31634},  {-8594, -31621},  {-8643, -31608},  {-8691, -31594},
    {-8740, -31581},  {-8788, -31568},  {-8836, -31554},  {-8885, -31540},  {-8933, -31527},  {-8982, -31513},
    {-9030, -31499},  {-9078, -31485},  {-9127, -31471},  {-9175, -31457},  {-9223, -31443},  {-9271, -31429},
    {-9319, -31415},  {-9368, -31400},  {-9416, -31386},  {-9464, -31372},  {-9512, -31357},  {-9560, -31342},
    {-9608, -31328},  {-9656, -31313},  {-9704, -31298},  {-9752, -31283},  {-9800, -31268},  {-9848, -31253},
    {-9896, -31238},  {-9944, -31223},  {-9992, -31207},  {-10040, -31192}, {-10088, -31177}, {-10135, -31161},
    {-10183, -31146}, {-10231, -31130}, {-10279, -31114}, {-10326, -31098}, {-10374, -31082}, {-10422, -31067},
    {-10469, -31050}, {-10517, -31034}, {-10565, -31018}, {-10612, -31002}, {-10660, -30986}, {-10707, -30969},
    {-10755, -30953}, {-10802, -30936}, {-10850, -30920}, {-10897, -30903}, {-10945, -30886}, {-10992, -30869},
    {-11039, -30853}, {-11087, -30836}, {-11134, -30819}, {-11181, -30801}, {-11228, -30784}, {-11276, -30767},
    {-11323, -30750}, {-11370, -30732}, {-11417, -30715}, {-11464, -30697}, {-11511, -30680}, {-11558, -30662},
    {-11605, -30644}, {-11652, -30626}, {-11699, -30608}, {-11746, -30590}, {-11793, -30572}, {-11840, -30554},
    {-11887, -30536}, {-11934, -30518}, {-11980, -30499}, {-12027, -30481}, {-12074, -30462}, {-12121, -30444},
    {-12167, -30425}, {-12214, -30407}, {-12261, -30388}, {-12307, -30369}, {-12354, -30350}, {-12400, -30331},
    {-12447, -30312}, {-12493, -30293}, {-12540, -30274}, {-12586, -30254}, {-12633, -30235}, {-12679, -30216},
    {-12725, -30196}, {-12772, -30177}, {-12818, -30157}, {-12864, -30137}, {-12910, -30118}, {-12957, -30098},
    {-13003, -30078}, {-13049, -30058}, {-13095, -30038}, {-13141, -30018}, {-13187, -29997}, {-13233, -29977},
    {-13279, -29957}, {-13325, -29936}, {-13371, -29916}, {-13417, -29895}, {-13463, -29875}, {-13508, -29854},
    {-13554, -29833}, {-13600, -29813}, {-13646, -29792}, {-13691, -29771}, {-13737, -29750}, {-13783, -29729},
    {-13828, -29707}, {-13874, -29686}, {-13919, -29665}, {-13965, -29643}, {-14010, -29622}, {-14056, -29600},
    {-14101, -29579}, {-14146, -29557}, {-14192, -29535}, {-14237, -29514}, {-14282, -29492}, {-14327, -29470},
    {-14373, -29448}, {-14418, -29426}, {-14463, -29404}, {-14508, -29381}, {-14553, -29359}, {-14598, -29337},
    {-14643, -29314}, {-14688, -29292}, {-14733, -29269}, {-14778, -29247}, {-14823, -29224}, {-14867, -29201},
    {-14912, -29178}, {-14957, -29155}, {-15002, -29132}, {-15046, -29109}, {-15091, -29086}, {-15136, -29063},
    {-15180, -29040}, {-15225, -29016}, {-15269, -28993}, {-15314, -28970}, {-15358, -28946}, {-15402, -28922},
    {-15447, -28899}, {-15491, -28875}, {-15535, -28851}, {-15580, -28827}, {-15624, -28803}, {-15668, -28779},
    {-15712, -28755}, {-15756, -28731}, {-15800, -28707}, {-15844, -28683}, {-15888, -28658}, {-15932, -28634},
    {-15976, -28610}, {-16020, -28585}, {-16064, -28560}, {-16108, -28536}, {-16151, -28511}, {-16195, -28486},
    {-16239, -28461}, {-16282, -28436}, {-16326, -28411}, {-16369, -28386}, {-16413, -28361}, {-16456, -28336},
    {-16500, -28311}, {-16543, -28285}, {-16587, -28260}, {-16630, -28234}, {-16673, -28209}, {-16717, -28183},
    {-16760, -28158}, {-16803, -28132}, {-16846, -28106}, {-16889, -28080}, {-16932, -28054}, {-16975, -28028},
    {-17018, -28002}, {-17061, -27976}, {-17104, -27950}, {-17147, -27924}, {-17190, -27897}, {-17233, -27871},
    {-17275, -27844}, {-17318, -27818}, {-17361, -27791}, {-17403, -27765}, {-17446, -27738}, {-17488, -27711},
    {-17531, -27684}, {-17573, -27657}, {-17616, -27630}, {-17658, -27603}, {-17700, -27576}, {-17743, -27549},
    {-17785, -27522}, {-17827, -27494}, {-17869, -27467}, {-17911, -27440}, {-17953, -27412}, {-17995, -27384},
    {-18037, -27357}, {-18079, -27329}, {-18121, -27301}, {-18163, -27273}, {-18205, -27246}, {-18247, -27218},
    {-18288, -27190}, {-18330, -27162}, {-18372, -27133}, {-18413, -27105}, {-18455, -27077}, {-18496, -27049},
    {-18538, -27020}, {-18579, -26992}, {-18621, -26963}, {-18662, -26935}, {-18703, -26906}, {-18745, -26877},
    {-18786, -26848}, {-18827, -26820}, {-18868, -26791}, {-18909, -26762}, {-18950, -26733}, {-18991, -26704},
    {-19032, -26674}, {-19073, -26645}, {-19114, -26616}, {-19155, -26586}, {-19195, -26557}, {-19236, -26528},
    {-19277, -26498}, {-19317, -26468}, {-19358, -26439}, {-19399, -26409}, {-19439, -26379}, {-19479, -26349},
    {-19520, -26320}, {-19560, -26290}, {-19601, -26259}, {-19641, -26229}, {-19681, -26199}, {-19721, -26169},
    {-19761, -26139}, {-19801, -26108}, {-19841, -26078}, {-19881, -26048}, {-19921, -26017}, {-19961, -25986},
    {-20001, -25956}, {-20041, -25925}, {-20081, -25894}, {-20120, -25863}, {-20160, -25833}, {-20200, -25802},
    {-20239, -25771}, {-20279, -25739}, {-20318, -25708}, {-20357, -25677}, {-20397, -25646}, {-20436, -25615},
    {-20475, -25583}, {-20515, -25552}, {-20554, -25520}, {-20593, -25489}, {-20632, -25457}, {-20671, -25425},
    {-20710, -25394}, {-20749, -25362}, {-20788, -25330}, {-20827, -25298}, {-20865, -25266}, {-20904, -25234},
    {-20943, -25202}, {-20981, -25170}, {-21020, -25138}, {-21059, -25105}, {-21097, -25073}, {-21136, -25041},
    {-21174, -25008}, {-21212, -24976}, {-21251, -24943}, {-21289, -24910}, {-21327, -24878}, {-21365, -24845},
    {-21403, -24812}, {-21441, -24779}, {-21479, -24746}, {-21517, -24713}, {-21555, -24680}, {-21593, -24647},
    {-21631, -24614}, {-21668, -24581}, {-21706, -24548}, {-21744, -24514}, {-21781, -24481}, {-21819, -24448},
    {-21856, -24414}, {-21894, -24380}, {-21931, -24347}, {-21968, -24313}, {-22006, -24279}, {-22043, -24246},
    {-22080, -24212}, {-22117, -24178}, {-22154, -24144}, {-22191, -24110}, {-22228, -24076}, {-22265, -24042},
    {-22302, -24008}, {-22339, -23973}, {-22375, -23939}, {-22412, -23905}, {-22449, -23870}, {-22485, -23836},
    {-22522, -23801}, {-22558, -23767}, {-22595, -23732}, {-22631, -23697}, {-22668, -23663}, {-22704, -23628},
    {-22740, -23593}, {-22776, -23558}, {-22812, -23523}, {-22848, -23488}, {-22884, -23453}, {-22920, -23418},
    {-22956, -23383}, {-22992, -23348}, {-23028, -23312}, {-23064, -23277}, {-23099, -23241}, {-23135, -23206},
    {-23170, -23170}, {-23206, -23135}, {-23241, -23099}, {-23277, -23064}, {-23312, -23028}, {-23348, -22992},
    {-23383, -22956}, {-23418, -22920}, {-23453, -22884}, {-23488, -22848}, {-23523, -22812}, {-23558, -22776},
    {-23593, -22740}, {-23628, -22704}, {-23663, -22668}, {-23697, -22631}, {-23732, -22595}, {-23767, -22558},
    {-23801, -22522}, {-23836, -22485}, {-23870, -22449}, {-23905, -22412}, {-23939, -22375}, {-23973, -22339},
    {-24008, -22302}, {-24042, -22265}, {-24076, -22228}, {-24110, -22191}, {-24144, -22154}, {-24178, -22117},
    {-24212, -22080}, {-24246, -22043}, {-24279, -22006}, {-24313, -21968}, {-24347, -21931}, {-24380, -21894},
    {-24414, -21856}, {-24448, -21819}, {-24481, -21781}, {-24514, -21744}, {-24548, -21706}, {-24581, -21668},
    {-24614, -21631}, {-24647, -21593}, {-24680, -21555}, {-24713, -21517}, {-24746, -21479}, {-24779, -21441},
    {-24812, -21403}, {-24845, -21365}, {-24878, -21327}, {-24910, -21289}, {-24943, -21251}, {-24976, -21212},
    {-25008, -21174}, {-25041, -21136}, {-25073, -21097}, {-25105, -21059}, {-25138, -21020}, {-25170, -20981},
    {-25202, -20943}, {-25234, -20904}, {-25266, -20865}, {-25298, -20827}, {-25330, -20788}, {-25362, -20749},
    {-25394, -20710}, {-25425, -20671}, {-25457, -20632}, {-25489, -20593}, {-25520, -20554}, {-25552, -20515},
    {-25583, -20475}, {-25615, -20436}, {-25646, -20397}, {-25677, -20357}, {-25708, -20318}, {-25739, -20279},
    {-25771, -20239}, {-25802, -20200}, {-25833, -20160}, {-25863, -20120}, {-25894, -20081}, {-25925, -20041},
    {-25956, -20001}, {-25986, -19961}, {-26017, -19921}, {-26048, -19881}, {-26078, -19841}, {-26108, -19801},
    {-26139, -19761}, {-26169, -19721}, {-26199, -19681}, {-26229, -19641}, {-26259, -19601}, {-26290, -19560},
    {-26320, -19520}, {-26349, -19479}, {-26379, -19439}, {-26409, -19399}, {-26439, -19358}, {-26468, -19317},
    {-26498, -19277}, {-26528, -19236}, {-26557, -19195}, {-26586, -19155}, {-26616, -19114}, {-26645, -19073},
    {-26674, -19032}, {-26704, -18991}, {-26733, -18950}, {-26762, -18909}, {-26791, -18868}, {-26820, -18827},
    {-26848, -18786}, {-26877, -18745}, {-26906, -18703}, {-26935, -18662}, {-26963, -18621}, {-26992, -18579},
    {-27020, -18538}, {-27049, -18496}, {-27077, -18455}, {-27105, -18413}, {-27133, -18372}, {-27162, -18330},
    {-27190, -18288}, {-27218, -18247}, {-27246, -18205}, {-27273, -18163}, {-27301, -18121}, {-27329, -18079},
    {-27357, -18037}, {-27384, -17995}, {-27412, -17953}, {-27440, -17911}, {-27467, -17869}, {-27494, -17827},
    {-27522, -17785}, {-27549, -17743}, {-27576, -17700}, {-27603, -17658}, {-27630, -17616}, {-27657, -17573},
    {-27684, -17531}, {-27711, -17488}, {-27738, -17446}, {-27765, -17403}, {-27791, -17361}, {-27818, -17318},
    {-27844, -17275}, {-27871, -17233}, {-27897, -17190}, {-27924, -17147}, {-27950, -17104}, {-27976, -17061},
    {-28002, -17018}, {-28028, -16975}, {-28054, -16932}, {-28080, -16889}, {-28106, -16846}, {-28132, -16803},
    {-28158, -16760}, {-28183, -16717}, {-28209, -16673}, {-28234, -16630}, {-28260, -16587}, {-28285, -16543},
    {-28311, -16500}, {-28336, -16456}, {-28361, -16413}, {-28386, -16369}, {-28411, -16326}, {-28436, -16282},
    {-28461, -16239}, {-28486, -16195}, {-28511, -16151}, {-28536, -16108}, {-28560, -16064}, {-28585, -16020},
    {-28610, -15976}, {-28634, -15932}, {-28658, -15888}, {-28683, -15844}, {-28707, -15800}, {-28731, -15756},
    {-28755, -15712}, {-28779, -15668}, {-28803, -15624}, {-28827, -15580}, {-28851, -15535}, {-28875, -15491},
    {-28899, -15447}, {-28922, -15402}, {-28946, -15358}, {-28970, -15314}, {-28993, -15269}, {-29016, -15225},
    {-29040, -15180}, {-29063, -15136}, {-29086, -15091}, {-29109, -15046}, {-29132, -15002}, {-29155, -14957},
    {-29178, -14912}, {-29201, -14867}, {-29224, -14823}, {-29247, -14778}, {-29269, -14733}, {-29292, -14688},
    {-29314, -14643}, {-29337, -14598}, {-29359, -14553}, {-29381, -14508}, {-29404, -14463}, {-29426, -14418},
    {-29448, -14373}, {-29470, -14327}, {-29492, -14282}, {-29514, -14237}, {-29535, -14192}, {-29557, -14146},
    {-29579, -14101}, {-29600, -14056}, {-29622, -14010}, {-29643, -13965}, {-29665, -13919}, {-29686, -13874},
    {-29707, -13828}, {-29729, -13783}, {-29750, -13737}, {-29771, -13691}, {-29792, -13646}, {-29813, -13600},
    {-29833, -13554}, {-29854, -13508}, {-29875, -13463}, {-29895, -13417}, {-29916, -13371}, {-29936, -13325},
    {-29957, -13279}, {-29977, -13233}, {-29997, -13187}, {-30018, -13141}, {-30038, -13095}, {-30058, -13049},
    {-30078, -13003}, {-30098, -12957}, {-30118, -12910}, {-30137, -12864}, {-30157, -12818}, {-30177, -12772},
    {-30196, -12725}, {-30216, -12679}, {-30235, -12633}, {-30254, -12586}, {-30274, -12540}, {-30293, -12493},
    {-30312, -12447}, {-30331, -12400}, {-30350, -12354}, {-30369, -12307}, {-30388, -12261}, {-30407, -12214},
    {-30425, -12167}, {-30444, -12121}, {-30462, -12074}, {-30481, -12027}, {-30499, -11980}, {-30518, -11934},
    {-30536, -11887}, {-30554, -11840}, {-30572, -11793}, {-30590, -11746}, {-30608, -11699}, {-30626, -11652},
    {-30644, -11605}, {-30662, -11558}, {-30680, -11511}, {-30697, -11464}, {-30715, -11417}, {-30732, -11370},
    {-30750, -11323}, {-30767, -11276}, {-30784, -11228}, {-30801, -11181}, {-30819, -11134}, {-30836, -11087},
    {-30853, -11039}, {-30869, -10992}, {-30886, -10945}, {-30903, -10897}, {-30920, -10850}, {-30936, -10802},
    {-30953, -10755}, {-30969, -10707}, {-30986, -10660}, {-31002, -10612}, {-31018, -10565}, {-31034, -10517},
    {-31050, -10469}, {-31067, -10422}, {-31082, -10374}, {-31098, -10326}, {-31114, -10279}, {-31130, -10231},
    {-31146, -10183}, {-31161, -10135}, {-31177, -10088}, {-31192, -10040}, {-31207, -9992},  {-31223, -9944},
    {-31238, -9896},  {-31253, -9848},  {-31268, -9800},  {-31283, -9752},  {-31298, -9704},  {-31313, -9656},
    {-31328, -9608},  {-31342, -9560},  {-31357, -9512},  {-31372, -9464},  {-31386, -9416},  {-31400, -9368},
    {-31415, -9319},  {-31429, -9271},  {-31443, -9223},  {-31457, -9175},  {-31471, -9127},  {-31485, -9078},
    {-31499, -9030},  {-31513, -8982},  {-31527, -8933},  {-31540, -8885},  {-31554, -8836},  {-31568, -8788},
    {-31581, -8740},  {-31594, -8691},  {-31608, -8643},  {-31621, -8594},  {-31634, -8546},  {-31647, -8497},
    {-31660, -8449},  {-31673, -8400},  {-31686, -8351},  {-31699, -8303},  {-31711, -8254},  {-31724, -8206},
    {-31737, -8157},  {-31749, -8108},  {-31761, -8059},  {-31774, -8011},  {-31786, -7962},  {-31798, -7913},
    {-31810, -7864},  {-31822, -7816},  {-31834, -7767},  {-31846, -7718},  {-31858, -7669},  {-31870, -7620},
    {-31881, -7571},  {-31893, -7522},  {-31904, -7473},  {-31916, -7425},  {-31927, -7376},  {-31938, -7327},
    {-31950, -7278},  {-31961, -7229},  {-31972, -7180},  {-31983, -7130},  {-31994, -7081},  {-32005, -7032},
    {-32015, -6983},  {-32026, -6934},  {-32037, -6885},  {-32047, -6836},  {-32058, -6787},  {-32068, -6737},
    {-32078, -6688},  {-32088, -6639},  {-32099, -6590},  {-32109, -6541},  {-32119, -6491},  {-32129, -6442},
    {-32138, -6393},  {-32148, -6343},  {-32158, -6294},  {-32167, -6245},  {-32177, -6195},  {-32186, -6146},
    {-32196, -6097},  {-32205, -6047},  {-32214, -5998},  {-32224, -5948},  {-32233, -5899},  {-32242, -5850},
    {-32251, -5800},  {-32259, -5751},  {-32268, -5701},  {-32277, -5652},  {-32286, -5602},  {-32294, -5553},
    {-32303, -5503},  {-32311, -5453},  {-32319, -5404},  {-32328, -5354},  {-32336, -5305},  {-32344, -5255},
    {-32352, -5205},  {-32360, -5156},  {-32368, -5106},  {-32376, -5057},  {-32383, -5007},  {-32391, -4957},
    {-32398, -4907},  {-32406, -4858},  {-32413, -4808},  {-32421, -4758},  {-32428, -4709},  {-32435, -4659},
    {-32442, -4609},  {-32449, -4559},  {-32456, -4510},  {-32463, -4460},  {-32470, -4410},  {-32477, -4360},
    {-32483, -4310},  {-32490, -4260},  {-32496, -4211},  {-32503, -4161},  {-32509, -4111},  {-32515, -4061},
    {-32522, -4011},  {-32528, -3961},  {-32534, -3911},  {-32540, -3861},  {-32546, -3812},  {-32551, -3762},
    {-32557, -3712},  {-32563, -3662},  {-32568, -3612},  {-32574, -3562},  {-32579, -3512},  {-32585, -3462},
    {-32590, -3412},  {-32595, -3362},  {-32600, -3312},  {-32605, -3262},  {-32610, -3212},  {-32615, -3162},
    {-32620, -3112},  {-32625, -3062},  {-32629, -3012},  {-32634, -2962},  {-32638, -2912},  {-32643, -2861},
    {-32647, -2811},  {-32651, -2761},  {-32656, -2711},  {-32660, -2661},  {-32664, -2611},  {-32668, -2561},
    {-32672, -2511},  {-32675, -2461},  {-32679, -2411},  {-32683, -2360},  {-32686, -2310},  {-32690, -2260},
    {-32693, -2210},  {-32697, -2160},  {-32700, -2110},  {-32703, -2060},  {-32706, -2009},  {-32709, -1959},
    {-32712, -1909},  {-32715, -1859},  {-32718, -1809},  {-32721, -1758},  {-32723, -1708},  {-32726, -1658},
    {-32729, -1608},  {-32731, -1558},  {-32733, -1507},  {-32736, -1457},  {-32738, -1407},  {-32740, -1357},
    {-32742, -1307},  {-32744, -1256},  {-32746, -1206},  {-32748, -1156},  {-32749, -1106},  {-32751, -1055},
    {-32753, -1005},  {-32754, -955},   {-32756, -905},   {-32757, -854},   {-32758, -804},   {-32759, -754},
    {-32760, -704},   {-32761, -653},   {-32762, -603},   {-32763, -553},   {-32764, -503},   {-32765, -452},
    {-32766, -402},   {-32766, -352},   {-32767, -302},   {-32767, -251},   {-32767, -201},   {-32768, -151},
    {-32768, -101},   {-32768, -50}};
const cint32 twiddle_master_cint32[kMasterTableSize] = {{2147483647, 0},
                                                        {2147481121, -3294197},
                                                        {2147473542, -6588387},
                                                        {2147460908, -9882561},
                                                        {2147443222, -13176712},
                                                        {2147420483, -16470832},
                                                        {2147392690, -19764913},
                                                        {2147359845, -23058947},
                                                        {2147321946, -26352928},
                                                        {2147278995, -29646846},
                                                        {2147230991, -32940695},
                                                        {2147177934, -36234466},
                                                        {2147119825, -39528151},
                                                        {2147056664, -42821744},
                                                        {2146988450, -46115236},
                                                        {2146915184, -49408620},
                                                        {2146836866, -52701887},
                                                        {2146753497, -55995030},
                                                        {2146665076, -59288042},
                                                        {2146571603, -62580914},
                                                        {2146473080, -65873638},
                                                        {2146369505, -69166208},
                                                        {2146260881, -72458615},
                                                        {2146147205, -75750851},
                                                        {2146028480, -79042909},
                                                        {2145904705, -82334782},
                                                        {2145775880, -85626460},
                                                        {2145642006, -88917937},
                                                        {2145503083, -92209205},
                                                        {2145359112, -95500255},
                                                        {2145210092, -98791081},
                                                        {2145056025, -102081675},
                                                        {2144896910, -105372028},
                                                        {2144732748, -108662134},
                                                        {2144563539, -111951983},
                                                        {2144389283, -115241570},
                                                        {2144209982, -118530885},
                                                        {2144025635, -121819921},
                                                        {2143836244, -125108670},
                                                        {2143641807, -128397125},
                                                        {2143442326, -131685278},
                                                        {2143237802, -134973122},
                                                        {2143028234, -138260647},
                                                        {2142813624, -141547847},
                                                        {2142593971, -144834714},
                                                        {2142369276, -148121241},
                                                        {2142139541, -151407418},
                                                        {2141904764, -154693240},
                                                        {2141664948, -157978697},
                                                        {2141420092, -161263783},
                                                        {2141170197, -164548489},
                                                        {2140915264, -167832808},
                                                        {2140655293, -171116733},
                                                        {2140390284, -174400254},
                                                        {2140120240, -177683365},
                                                        {2139845159, -180966058},
                                                        {2139565043, -184248325},
                                                        {2139279892, -187530159},
                                                        {2138989708, -190811551},
                                                        {2138694490, -194092495},
                                                        {2138394240, -197372981},
                                                        {2138088958, -200653003},
                                                        {2137778644, -203932553},
                                                        {2137463301, -207211624},
                                                        {2137142927, -210490206},
                                                        {2136817525, -213768293},
                                                        {2136487095, -217045878},
                                                        {2136151637, -220322951},
                                                        {2135811153, -223599506},
                                                        {2135465642, -226875535},
                                                        {2135115107, -230151030},
                                                        {2134759548, -233425984},
                                                        {2134398966, -236700388},
                                                        {2134033361, -239974235},
                                                        {2133662734, -243247518},
                                                        {2133287087, -246520228},
                                                        {2132906420, -249792358},
                                                        {2132520734, -253063900},
                                                        {2132130030, -256334847},
                                                        {2131734309, -259605191},
                                                        {2131333572, -262874923},
                                                        {2130927819, -266144038},
                                                        {2130517052, -269412525},
                                                        {2130101272, -272680379},
                                                        {2129680480, -275947592},
                                                        {2129254676, -279214155},
                                                        {2128823862, -282480061},
                                                        {2128388038, -285745302},
                                                        {2127947206, -289009871},
                                                        {2127501367, -292273760},
                                                        {2127050522, -295536961},
                                                        {2126594672, -298799466},
                                                        {2126133817, -302061269},
                                                        {2125667960, -305322361},
                                                        {2125197100, -308582734},
                                                        {2124721240, -311842381},
                                                        {2124240380, -315101295},
                                                        {2123754522, -318359466},
                                                        {2123263666, -321616889},
                                                        {2122767814, -324873555},
                                                        {2122266967, -328129457},
                                                        {2121761126, -331384586},
                                                        {2121250292, -334638936},
                                                        {2120734467, -337892498},
                                                        {2120213651, -341145265},
                                                        {2119687847, -344397230},
                                                        {2119157054, -347648383},
                                                        {2118621275, -350898719},
                                                        {2118080511, -354148230},
                                                        {2117534762, -357396906},
                                                        {2116984031, -360644742},
                                                        {2116428319, -363891730},
                                                        {2115867626, -367137861},
                                                        {2115301954, -370383128},
                                                        {2114731305, -373627523},
                                                        {2114155680, -376871039},
                                                        {2113575080, -380113669},
                                                        {2112989506, -383355404},
                                                        {2112398960, -386596237},
                                                        {2111803444, -389836160},
                                                        {2111202959, -393075166},
                                                        {2110597505, -396313247},
                                                        {2109987085, -399550396},
                                                        {2109371700, -402786604},
                                                        {2108751352, -406021865},
                                                        {2108126041, -409256170},
                                                        {2107495770, -412489512},
                                                        {2106860540, -415721883},
                                                        {2106220352, -418953276},
                                                        {2105575208, -422183684},
                                                        {2104925109, -425413098},
                                                        {2104270057, -428641511},
                                                        {2103610054, -431868915},
                                                        {2102945101, -435095303},
                                                        {2102275199, -438320667},
                                                        {2101600350, -441545000},
                                                        {2100920556, -444768294},
                                                        {2100235819, -447990541},
                                                        {2099546139, -451211734},
                                                        {2098851519, -454431865},
                                                        {2098151960, -457650927},
                                                        {2097447464, -460868912},
                                                        {2096738032, -464085813},
                                                        {2096023667, -467301622},
                                                        {2095304370, -470516330},
                                                        {2094580142, -473729932},
                                                        {2093850985, -476942419},
                                                        {2093116901, -480153784},
                                                        {2092377892, -483364019},
                                                        {2091633960, -486573117},
                                                        {2090885105, -489781069},
                                                        {2090131331, -492987869},
                                                        {2089372638, -496193509},
                                                        {2088609029, -499397982},
                                                        {2087840505, -502601279},
                                                        {2087067068, -505803394},
                                                        {2086288720, -509004318},
                                                        {2085505463, -512204045},
                                                        {2084717298, -515402566},
                                                        {2083924228, -518599875},
                                                        {2083126254, -521795963},
                                                        {2082323379, -524990824},
                                                        {2081515603, -528184449},
                                                        {2080702930, -531376831},
                                                        {2079885360, -534567963},
                                                        {2079062896, -537757837},
                                                        {2078235540, -540946445},
                                                        {2077403294, -544133781},
                                                        {2076566160, -547319836},
                                                        {2075724139, -550504604},
                                                        {2074877233, -553688076},
                                                        {2074025446, -556870245},
                                                        {2073168777, -560051104},
                                                        {2072307231, -563230645},
                                                        {2071440808, -566408860},
                                                        {2070569511, -569585743},
                                                        {2069693342, -572761285},
                                                        {2068812302, -575935480},
                                                        {2067926394, -579108320},
                                                        {2067035621, -582279796},
                                                        {2066139983, -585449903},
                                                        {2065239484, -588618632},
                                                        {2064334124, -591785976},
                                                        {2063423908, -594951927},
                                                        {2062508835, -598116479},
                                                        {2061588910, -601279623},
                                                        {2060664133, -604441352},
                                                        {2059734508, -607601658},
                                                        {2058800036, -610760536},
                                                        {2057860719, -613917975},
                                                        {2056916560, -617073971},
                                                        {2055967560, -620228514},
                                                        {2055013723, -623381598},
                                                        {2054055050, -626533215},
                                                        {2053091544, -629683357},
                                                        {2052123207, -632832018},
                                                        {2051150040, -635979190},
                                                        {2050172048, -639124865},
                                                        {2049189231, -642269036},
                                                        {2048201592, -645411696},
                                                        {2047209133, -648552838},
                                                        {2046211857, -651692453},
                                                        {2045209767, -654830535},
                                                        {2044202863, -657967075},
                                                        {2043191150, -661102068},
                                                        {2042174628, -664235505},
                                                        {2041153301, -667367379},
                                                        {2040127172, -670497682},
                                                        {2039096241, -673626408},
                                                        {2038060512, -676753549},
                                                        {2037019988, -679879097},
                                                        {2035974670, -683003045},
                                                        {2034924562, -686125387},
                                                        {2033869665, -689246113},
                                                        {2032809982, -692365218},
                                                        {2031745516, -695482694},
                                                        {2030676269, -698598533},
                                                        {2029602243, -701712728},
                                                        {2028523442, -704825272},
                                                        {2027439867, -707936158},
                                                        {2026351522, -711045377},
                                                        {2025258408, -714152924},
                                                        {2024160529, -717258790},
                                                        {2023057887, -720362968},
                                                        {2021950484, -723465451},
                                                        {2020838323, -726566232},
                                                        {2019721407, -729665303},
                                                        {2018599739, -732762657},
                                                        {2017473321, -735858287},
                                                        {2016342155, -738952186},
                                                        {2015206245, -742044345},
                                                        {2014065592, -745134758},
                                                        {2012920201, -748223418},
                                                        {2011770073, -751310318},
                                                        {2010615210, -754395449},
                                                        {2009455617, -757478806},
                                                        {2008291295, -760560380},
                                                        {2007122248, -763640164},
                                                        {2005948478, -766718151},
                                                        {2004769987, -769794334},
                                                        {2003586779, -772868706},
                                                        {2002398857, -775941259},
                                                        {2001206222, -779011986},
                                                        {2000008879, -782080880},
                                                        {1998806829, -785147934},
                                                        {1997600076, -788213141},
                                                        {1996388622, -791276492},
                                                        {1995172471, -794337982},
                                                        {1993951625, -797397602},
                                                        {1992726087, -800455346},
                                                        {1991495860, -803511207},
                                                        {1990260946, -806565177},
                                                        {1989021350, -809617249},
                                                        {1987777073, -812667415},
                                                        {1986528118, -815715670},
                                                        {1985274489, -818762005},
                                                        {1984016189, -821806413},
                                                        {1982753220, -824848888},
                                                        {1981485585, -827889422},
                                                        {1980213288, -830928007},
                                                        {1978936331, -833964638},
                                                        {1977654717, -836999305},
                                                        {1976368450, -840032004},
                                                        {1975077532, -843062726},
                                                        {1973781967, -846091463},
                                                        {1972481757, -849118210},
                                                        {1971176906, -852142959},
                                                        {1969867417, -855165703},
                                                        {1968553292, -858186435},
                                                        {1967234535, -861205147},
                                                        {1965911148, -864221832},
                                                        {1964583136, -867236484},
                                                        {1963250501, -870249095},
                                                        {1961913246, -873259659},
                                                        {1960571375, -876268167},
                                                        {1959224890, -879274614},
                                                        {1957873796, -882278992},
                                                        {1956518093, -885281293},
                                                        {1955157788, -888281512},
                                                        {1953792881, -891279640},
                                                        {1952423377, -894275671},
                                                        {1951049279, -897269597},
                                                        {1949670589, -900261413},
                                                        {1948287312, -903251110},
                                                        {1946899451, -906238681},
                                                        {1945507008, -909224120},
                                                        {1944109987, -912207419},
                                                        {1942708392, -915188572},
                                                        {1941302225, -918167572},
                                                        {1939891490, -921144411},
                                                        {1938476190, -924119082},
                                                        {1937056329, -927091579},
                                                        {1935631910, -930061894},
                                                        {1934202936, -933030021},
                                                        {1932769411, -935995952},
                                                        {1931331338, -938959681},
                                                        {1929888720, -941921200},
                                                        {1928441561, -944880503},
                                                        {1926989864, -947837582},
                                                        {1925533633, -950792431},
                                                        {1924072871, -953745043},
                                                        {1922607581, -956695411},
                                                        {1921137767, -959643527},
                                                        {1919663432, -962589385},
                                                        {1918184581, -965532978},
                                                        {1916701216, -968474300},
                                                        {1915213340, -971413342},
                                                        {1913720958, -974350098},
                                                        {1912224073, -977284562},
                                                        {1910722688, -980216726},
                                                        {1909216806, -983146583},
                                                        {1907706433, -986074127},
                                                        {1906191570, -988999351},
                                                        {1904672222, -991922248},
                                                        {1903148392, -994842810},
                                                        {1901620084, -997761031},
                                                        {1900087301, -1000676905},
                                                        {1898550047, -1003590424},
                                                        {1897008325, -1006501581},
                                                        {1895462140, -1009410370},
                                                        {1893911494, -1012316784},
                                                        {1892356392, -1015220816},
                                                        {1890796837, -1018122458},
                                                        {1889232832, -1021021705},
                                                        {1887664383, -1023918550},
                                                        {1886091491, -1026812985},
                                                        {1884514161, -1029705004},
                                                        {1882932397, -1032594600},
                                                        {1881346202, -1035481766},
                                                        {1879755580, -1038366495},
                                                        {1878160535, -1041248781},
                                                        {1876561070, -1044128617},
                                                        {1874957189, -1047005996},
                                                        {1873348897, -1049880912},
                                                        {1871736196, -1052753357},
                                                        {1870119091, -1055623324},
                                                        {1868497586, -1058490808},
                                                        {1866871683, -1061355801},
                                                        {1865241388, -1064218296},
                                                        {1863606704, -1067078288},
                                                        {1861967634, -1069935768},
                                                        {1860324183, -1072790730},
                                                        {1858676355, -1075643169},
                                                        {1857024153, -1078493076},
                                                        {1855367581, -1081340445},
                                                        {1853706643, -1084185270},
                                                        {1852041343, -1087027544},
                                                        {1850371686, -1089867259},
                                                        {1848697674, -1092704411},
                                                        {1847019312, -1095538991},
                                                        {1845336604, -1098370993},
                                                        {1843649553, -1101200410},
                                                        {1841958164, -1104027237},
                                                        {1840262441, -1106851465},
                                                        {1838562388, -1109673089},
                                                        {1836858008, -1112492101},
                                                        {1835149306, -1115308496},
                                                        {1833436286, -1118122267},
                                                        {1831718951, -1120933406},
                                                        {1829997307, -1123741908},
                                                        {1828271356, -1126547765},
                                                        {1826541103, -1129350972},
                                                        {1824806552, -1132151521},
                                                        {1823067707, -1134949406},
                                                        {1821324572, -1137744621},
                                                        {1819577151, -1140537158},
                                                        {1817825449, -1143327011},
                                                        {1816069469, -1146114174},
                                                        {1814309216, -1148898640},
                                                        {1812544694, -1151680403},
                                                        {1810775906, -1154459456},
                                                        {1809002858, -1157235792},
                                                        {1807225553, -1160009405},
                                                        {1805443995, -1162780288},
                                                        {1803658189, -1165548435},
                                                        {1801868139, -1168313840},
                                                        {1800073849, -1171076495},
                                                        {1798275323, -1173836395},
                                                        {1796472565, -1176593533},
                                                        {1794665580, -1179347902},
                                                        {1792854372, -1182099496},
                                                        {1791038946, -1184848308},
                                                        {1789219305, -1187594332},
                                                        {1787395453, -1190337562},
                                                        {1785567396, -1193077991},
                                                        {1783735137, -1195815612},
                                                        {1781898681, -1198550419},
                                                        {1780058032, -1201282407},
                                                        {1778213194, -1204011567},
                                                        {1776364172, -1206737894},
                                                        {1774510970, -1209461382},
                                                        {1772653593, -1212182024},
                                                        {1770792044, -1214899813},
                                                        {1768926328, -1217614743},
                                                        {1767056450, -1220326809},
                                                        {1765182414, -1223036002},
                                                        {1763304224, -1225742318},
                                                        {1761421885, -1228445750},
                                                        {1759535401, -1231146291},
                                                        {1757644777, -1233843935},
                                                        {1755750017, -1236538675},
                                                        {1753851126, -1239230506},
                                                        {1751948107, -1241919421},
                                                        {1750040966, -1244605414},
                                                        {1748129707, -1247288478},
                                                        {1746214334, -1249968606},
                                                        {1744294853, -1252645794},
                                                        {1742371267, -1255320034},
                                                        {1740443581, -1257991320},
                                                        {1738511799, -1260659646},
                                                        {1736575927, -1263325005},
                                                        {1734635968, -1265987392},
                                                        {1732691928, -1268646800},
                                                        {1730743810, -1271303222},
                                                        {1728791620, -1273956653},
                                                        {1726835361, -1276607086},
                                                        {1724875040, -1279254516},
                                                        {1722910659, -1281898935},
                                                        {1720942225, -1284540337},
                                                        {1718969740, -1287178717},
                                                        {1716993211, -1289814068},
                                                        {1715012642, -1292446384},
                                                        {1713028037, -1295075659},
                                                        {1711039401, -1297701886},
                                                        {1709046739, -1300325060},
                                                        {1707050055, -1302945174},
                                                        {1705049355, -1305562222},
                                                        {1703044642, -1308176198},
                                                        {1701035922, -1310787095},
                                                        {1699023199, -1313394909},
                                                        {1697006479, -1315999631},
                                                        {1694985765, -1318601257},
                                                        {1692961062, -1321199781},
                                                        {1690932376, -1323795195},
                                                        {1688899711, -1326387494},
                                                        {1686863072, -1328976672},
                                                        {1684822463, -1331562723},
                                                        {1682777890, -1334145641},
                                                        {1680729357, -1336725419},
                                                        {1678676870, -1339302052},
                                                        {1676620432, -1341875533},
                                                        {1674560049, -1344445857},
                                                        {1672495725, -1347013017},
                                                        {1670427466, -1349577007},
                                                        {1668355276, -1352137822},
                                                        {1666279161, -1354695455},
                                                        {1664199124, -1357249901},
                                                        {1662115172, -1359801152},
                                                        {1660027308, -1362349204},
                                                        {1657935539, -1364894050},
                                                        {1655839867, -1367435685},
                                                        {1653740300, -1369974101},
                                                        {1651636841, -1372509294},
                                                        {1649529496, -1375041258},
                                                        {1647418269, -1377569986},
                                                        {1645303166, -1380095472},
                                                        {1643184191, -1382617710},
                                                        {1641061349, -1385136696},
                                                        {1638934646, -1387652422},
                                                        {1636804087, -1390164882},
                                                        {1634669676, -1392674072},
                                                        {1632531418, -1395179984},
                                                        {1630389319, -1397682613},
                                                        {1628243383, -1400181954},
                                                        {1626093616, -1402678000},
                                                        {1623940023, -1405170745},
                                                        {1621782608, -1407660183},
                                                        {1619621377, -1410146309},
                                                        {1617456335, -1412629117},
                                                        {1615287487, -1415108601},
                                                        {1613114838, -1417584755},
                                                        {1610938393, -1420057574},
                                                        {1608758157, -1422527051},
                                                        {1606574136, -1424993180},
                                                        {1604386335, -1427455956},
                                                        {1602194758, -1429915374},
                                                        {1599999411, -1432371426},
                                                        {1597800299, -1434824109},
                                                        {1595597428, -1437273414},
                                                        {1593390801, -1439719338},
                                                        {1591180426, -1442161874},
                                                        {1588966306, -1444601017},
                                                        {1586748447, -1447036760},
                                                        {1584526854, -1449469098},
                                                        {1582301533, -1451898025},
                                                        {1580072489, -1454323536},
                                                        {1577839726, -1456745625},
                                                        {1575603251, -1459164286},
                                                        {1573363068, -1461579514},
                                                        {1571119183, -1463991302},
                                                        {1568871601, -1466399645},
                                                        {1566620327, -1468804538},
                                                        {1564365367, -1471205974},
                                                        {1562106725, -1473603949},
                                                        {1559844408, -1475998456},
                                                        {1557578421, -1478389489},
                                                        {1555308768, -1480777044},
                                                        {1553035455, -1483161115},
                                                        {1550758488, -1485541696},
                                                        {1548477872, -1487918781},
                                                        {1546193612, -1490292364},
                                                        {1543905714, -1492662441},
                                                        {1541614183, -1495029006},
                                                        {1539319024, -1497392053},
                                                        {1537020244, -1499751576},
                                                        {1534717846, -1502107570},
                                                        {1532411837, -1504460029},
                                                        {1530102222, -1506808949},
                                                        {1527789007, -1509154322},
                                                        {1525472197, -1511496145},
                                                        {1523151797, -1513834411},
                                                        {1520827813, -1516169114},
                                                        {1518500250, -1518500250},
                                                        {1516169114, -1520827813},
                                                        {1513834411, -1523151797},
                                                        {1511496145, -1525472197},
                                                        {1509154322, -1527789007},
                                                        {1506808949, -1530102222},
                                                        {1504460029, -1532411837},
                                                        {1502107570, -1534717846},
                                                        {1499751576, -1537020244},
                                                        {1497392053, -1539319024},
                                                        {1495029006, -1541614183},
                                                        {1492662441, -1543905714},
                                                        {1490292364, -1546193612},
                                                        {1487918781, -1548477872},
                                                        {1485541696, -1550758488},
                                                        {1483161115, -1553035455},
                                                        {1480777044, -1555308768},
                                                        {1478389489, -1557578421},
                                                        {1475998456, -1559844408},
                                                        {1473603949, -1562106725},
                                                        {1471205974, -1564365367},
                                                        {1468804538, -1566620327},
                                                        {1466399645, -1568871601},
                                                        {1463991302, -1571119183},
                                                        {1461579514, -1573363068},
                                                        {1459164286, -1575603251},
                                                        {1456745625, -1577839726},
                                                        {1454323536, -1580072489},
                                                        {1451898025, -1582301533},
                                                        {1449469098, -1584526854},
                                                        {1447036760, -1586748447},
                                                        {1444601017, -1588966306},
                                                        {1442161874, -1591180426},
                                                        {1439719338, -1593390801},
                                                        {1437273414, -1595597428},
                                                        {1434824109, -1597800299},
                                                        {1432371426, -1599999411},
                                                        {1429915374, -1602194758},
                                                        {1427455956, -1604386335},
                                                        {1424993180, -1606574136},
                                                        {1422527051, -1608758157},
                                                        {1420057574, -1610938393},
                                                        {1417584755, -1613114838},
                                                        {1415108601, -1615287487},
                                                        {1412629117, -1617456335},
                                                        {1410146309, -1619621377},
                                                        {1407660183, -1621782608},
                                                        {1405170745, -1623940023},
                                                        {1402678000, -1626093616},
                                                        {1400181954, -1628243383},
                                                        {1397682613, -1630389319},
                                                        {1395179984, -1632531418},
                                                        {1392674072, -1634669676},
                                                        {1390164882, -1636804087},
                                                        {1387652422, -1638934646},
                                                        {1385136696, -1641061349},
                                                        {1382617710, -1643184191},
                                                        {1380095472, -1645303166},
                                                        {1377569986, -1647418269},
                                                        {1375041258, -1649529496},
                                                        {1372509294, -1651636841},
                                                        {1369974101, -1653740300},
                                                        {1367435685, -1655839867},
                                                        {1364894050, -1657935539},
                                                        {1362349204, -1660027308},
                                                        {1359801152, -1662115172},
                                                        {1357249901, -1664199124},
                                                        {1354695455, -1666279161},
                                                        {1352137822, -1668355276},
                                                        {1349577007, -1670427466},
                                                        {1347013017, -1672495725},
                                                        {1344445857, -1674560049},
                                                        {1341875533, -1676620432},
                                                        {1339302052, -1678676870},
                                                        {1336725419, -1680729357},
                                                        {1334145641, -1682777890},
                                                        {1331562723, -1684822463},
                                                        {1328976672, -1686863072},
                                                        {1326387494, -1688899711},
                                                        {1323795195, -1690932376},
                                                        {1321199781, -1692961062},
                                                        {1318601257, -1694985765},
                                                        {1315999631, -1697006479},
                                                        {1313394909, -1699023199},
                                                        {1310787095, -1701035922},
                                                        {1308176198, -1703044642},
                                                        {1305562222, -1705049355},
                                                        {1302945174, -1707050055},
                                                        {1300325060, -1709046739},
                                                        {1297701886, -1711039401},
                                                        {1295075659, -1713028037},
                                                        {1292446384, -1715012642},
                                                        {1289814068, -1716993211},
                                                        {1287178717, -1718969740},
                                                        {1284540337, -1720942225},
                                                        {1281898935, -1722910659},
                                                        {1279254516, -1724875040},
                                                        {1276607086, -1726835361},
                                                        {1273956653, -1728791620},
                                                        {1271303222, -1730743810},
                                                        {1268646800, -1732691928},
                                                        {1265987392, -1734635968},
                                                        {1263325005, -1736575927},
                                                        {1260659646, -1738511799},
                                                        {1257991320, -1740443581},
                                                        {1255320034, -1742371267},
                                                        {1252645794, -1744294853},
                                                        {1249968606, -1746214334},
                                                        {1247288478, -1748129707},
                                                        {1244605414, -1750040966},
                                                        {1241919421, -1751948107},
                                                        {1239230506, -1753851126},
                                                        {1236538675, -1755750017},
                                                        {1233843935, -1757644777},
                                                        {1231146291, -1759535401},
                                                        {1228445750, -1761421885},
                                                        {1225742318, -1763304224},
                                                        {1223036002, -1765182414},
                                                        {1220326809, -1767056450},
                                                        {1217614743, -1768926328},
                                                        {1214899813, -1770792044},
                                                        {1212182024, -1772653593},
                                                        {1209461382, -1774510970},
                                                        {1206737894, -1776364172},
                                                        {1204011567, -1778213194},
                                                        {1201282407, -1780058032},
                                                        {1198550419, -1781898681},
                                                        {1195815612, -1783735137},
                                                        {1193077991, -1785567396},
                                                        {1190337562, -1787395453},
                                                        {1187594332, -1789219305},
                                                        {1184848308, -1791038946},
                                                        {1182099496, -1792854372},
                                                        {1179347902, -1794665580},
                                                        {1176593533, -1796472565},
                                                        {1173836395, -1798275323},
                                                        {1171076495, -1800073849},
                                                        {1168313840, -1801868139},
                                                        {1165548435, -1803658189},
                                                        {1162780288, -1805443995},
                                                        {1160009405, -1807225553},
                                                        {1157235792, -1809002858},
                                                        {1154459456, -1810775906},
                                                        {1151680403, -1812544694},
                                                        {1148898640, -1814309216},
                                                        {1146114174, -1816069469},
                                                        {1143327011, -1817825449},
                                                        {1140537158, -1819577151},
                                                        {1137744621, -1821324572},
                                                        {1134949406, -1823067707},
                                                        {1132151521, -1824806552},
                                                        {1129350972, -1826541103},
                                                        {1126547765, -1828271356},
                                                        {1123741908, -1829997307},
                                                        {1120933406, -1831718951},
                                                        {1118122267, -1833436286},
                                                        {1115308496, -1835149306},
                                                        {1112492101, -1836858008},
                                                        {1109673089, -1838562388},
                                                        {1106851465, -1840262441},
                                                        {1104027237, -1841958164},
                                                        {1101200410, -1843649553},
                                                        {1098370993, -1845336604},
                                                        {1095538991, -1847019312},
                                                        {1092704411, -1848697674},
                                                        {1089867259, -1850371686},
                                                        {1087027544, -1852041343},
                                                        {1084185270, -1853706643},
                                                        {1081340445, -1855367581},
                                                        {1078493076, -1857024153},
                                                        {1075643169, -1858676355},
                                                        {1072790730, -1860324183},
                                                        {1069935768, -1861967634},
                                                        {1067078288, -1863606704},
                                                        {1064218296, -1865241388},
                                                        {1061355801, -1866871683},
                                                        {1058490808, -1868497586},
                                                        {1055623324, -1870119091},
                                                        {1052753357, -1871736196},
                                                        {1049880912, -1873348897},
                                                        {1047005996, -1874957189},
                                                        {1044128617, -1876561070},
                                                        {1041248781, -1878160535},
                                                        {1038366495, -1879755580},
                                                        {1035481766, -1881346202},
                                                        {1032594600, -1882932397},
                                                        {1029705004, -1884514161},
                                                        {1026812985, -1886091491},
                                                        {1023918550, -1887664383},
                                                        {1021021705, -1889232832},
                                                        {1018122458, -1890796837},
                                                        {1015220816, -1892356392},
                                                        {1012316784, -1893911494},
                                                        {1009410370, -1895462140},
                                                        {1006501581, -1897008325},
                                                        {1003590424, -1898550047},
                                                        {1000676905, -1900087301},
                                                        {997761031, -1901620084},
                                                        {994842810, -1903148392},
                                                        {991922248, -1904672222},
                                                        {988999351, -1906191570},
                                                        {986074127, -1907706433},
                                                        {983146583, -1909216806},
                                                        {980216726, -1910722688},
                                                        {977284562, -1912224073},
                                                        {974350098, -1913720958},
                                                        {971413342, -1915213340},
                                                        {968474300, -1916701216},
                                                        {965532978, -1918184581},
                                                        {962589385, -1919663432},
                                                        {959643527, -1921137767},
                                                        {956695411, -1922607581},
                                                        {953745043, -1924072871},
                                                        {950792431, -1925533633},
                                                        {947837582, -1926989864},
                                                        {944880503, -1928441561},
                                                        {941921200, -1929888720},
                                                        {938959681, -1931331338},
                                                        {935995952, -1932769411},
                                                        {933030021, -1934202936},
                                                        {930061894, -1935631910},
                                                        {927091579, -1937056329},
                                                        {924119082, -1938476190},
                                                        {921144411, -1939891490},
                                                        {918167572, -1941302225},
                                                        {915188572, -1942708392},
                                                        {912207419, -1944109987},
                                                        {909224120, -1945507008},
                                                        {906238681, -1946899451},
                                                        {903251110, -1948287312},
                                                        {900261413, -1949670589},
                                                        {897269597, -1951049279},
                                                        {894275671, -1952423377},
                                                        {891279640, -1953792881},
                                                        {888281512, -1955157788},
                                                        {885281293, -1956518093},
                                                        {882278992, -1957873796},
                                                        {879274614, -1959224890},
                                                        {876268167, -1960571375},
                                                        {873259659, -1961913246},
                                                        {870249095, -1963250501},
                                                        {867236484, -1964583136},
                                                        {864221832, -1965911148},
                                                        {861205147, -1967234535},
                                                        {858186435, -1968553292},
                                                        {855165703, -1969867417},
                                                        {852142959, -1971176906},
                                                        {849118210, -1972481757},
                                                        {846091463, -1973781967},
                                                        {843062726, -1975077532},
                                                        {840032004, -1976368450},
                                                        {836999305, -1977654717},
                                                        {833964638, -1978936331},
                                                        {830928007, -1980213288},
                                                        {827889422, -1981485585},
                                                        {824848888, -1982753220},
                                                        {821806413, -1984016189},
                                                        {818762005, -1985274489},
                                                        {815715670, -1986528118},
                                                        {812667415, -1987777073},
                                                        {809617249, -1989021350},
                                                        {806565177, -1990260946},
                                                        {803511207, -1991495860},
                                                        {800455346, -1992726087},
                                                        {797397602, -1993951625},
                                                        {794337982, -1995172471},
                                                        {791276492, -1996388622},
                                                        {788213141, -1997600076},
                                                        {785147934, -1998806829},
                                                        {782080880, -2000008879},
                                                        {779011986, -2001206222},
                                                        {775941259, -2002398857},
                                                        {772868706, -2003586779},
                                                        {769794334, -2004769987},
                                                        {766718151, -2005948478},
                                                        {763640164, -2007122248},
                                                        {760560380, -2008291295},
                                                        {757478806, -2009455617},
                                                        {754395449, -2010615210},
                                                        {751310318, -2011770073},
                                                        {748223418, -2012920201},
                                                        {745134758, -2014065592},
                                                        {742044345, -2015206245},
                                                        {738952186, -2016342155},
                                                        {735858287, -2017473321},
                                                        {732762657, -2018599739},
                                                        {729665303, -2019721407},
                                                        {726566232, -2020838323},
                                                        {723465451, -2021950484},
                                                        {720362968, -2023057887},
                                                        {717258790, -2024160529},
                                                        {714152924, -2025258408},
                                                        {711045377, -2026351522},
                                                        {707936158, -2027439867},
                                                        {704825272, -2028523442},
                                                        {701712728, -2029602243},
                                                        {698598533, -2030676269},
                                                        {695482694, -2031745516},
                                                        {692365218, -2032809982},
                                                        {689246113, -2033869665},
                                                        {686125387, -2034924562},
                                                        {683003045, -2035974670},
                                                        {679879097, -2037019988},
                                                        {676753549, -2038060512},
                                                        {673626408, -2039096241},
                                                        {670497682, -2040127172},
                                                        {667367379, -2041153301},
                                                        {664235505, -2042174628},
                                                        {661102068, -2043191150},
                                                        {657967075, -2044202863},
                                                        {654830535, -2045209767},
                                                        {651692453, -2046211857},
                                                        {648552838, -2047209133},
                                                        {645411696, -2048201592},
                                                        {642269036, -2049189231},
                                                        {639124865, -2050172048},
                                                        {635979190, -2051150040},
                                                        {632832018, -2052123207},
                                                        {629683357, -2053091544},
                                                        {626533215, -2054055050},
                                                        {623381598, -2055013723},
                                                        {620228514, -2055967560},
                                                        {617073971, -2056916560},
                                                        {613917975, -2057860719},
                                                        {610760536, -2058800036},
                                                        {607601658, -2059734508},
                                                        {604441352, -2060664133},
                                                        {601279623, -2061588910},
                                                        {598116479, -2062508835},
                                                        {594951927, -2063423908},
                                                        {591785976, -2064334124},
                                                        {588618632, -2065239484},
                                                        {585449903, -2066139983},
                                                        {582279796, -2067035621},
                                                        {579108320, -2067926394},
                                                        {575935480, -2068812302},
                                                        {572761285, -2069693342},
                                                        {569585743, -2070569511},
                                                        {566408860, -2071440808},
                                                        {563230645, -2072307231},
                                                        {560051104, -2073168777},
                                                        {556870245, -2074025446},
                                                        {553688076, -2074877233},
                                                        {550504604, -2075724139},
                                                        {547319836, -2076566160},
                                                        {544133781, -2077403294},
                                                        {540946445, -2078235540},
                                                        {537757837, -2079062896},
                                                        {534567963, -2079885360},
                                                        {531376831, -2080702930},
                                                        {528184449, -2081515603},
                                                        {524990824, -2082323379},
                                                        {521795963, -2083126254},
                                                        {518599875, -2083924228},
                                                        {515402566, -2084717298},
                                                        {512204045, -2085505463},
                                                        {509004318, -2086288720},
                                                        {505803394, -2087067068},
                                                        {502601279, -2087840505},
                                                        {499397982, -2088609029},
                                                        {496193509, -2089372638},
                                                        {492987869, -2090131331},
                                                        {489781069, -2090885105},
                                                        {486573117, -2091633960},
                                                        {483364019, -2092377892},
                                                        {480153784, -2093116901},
                                                        {476942419, -2093850985},
                                                        {473729932, -2094580142},
                                                        {470516330, -2095304370},
                                                        {467301622, -2096023667},
                                                        {464085813, -2096738032},
                                                        {460868912, -2097447464},
                                                        {457650927, -2098151960},
                                                        {454431865, -2098851519},
                                                        {451211734, -2099546139},
                                                        {447990541, -2100235819},
                                                        {444768294, -2100920556},
                                                        {441545000, -2101600350},
                                                        {438320667, -2102275199},
                                                        {435095303, -2102945101},
                                                        {431868915, -2103610054},
                                                        {428641511, -2104270057},
                                                        {425413098, -2104925109},
                                                        {422183684, -2105575208},
                                                        {418953276, -2106220352},
                                                        {415721883, -2106860540},
                                                        {412489512, -2107495770},
                                                        {409256170, -2108126041},
                                                        {406021865, -2108751352},
                                                        {402786604, -2109371700},
                                                        {399550396, -2109987085},
                                                        {396313247, -2110597505},
                                                        {393075166, -2111202959},
                                                        {389836160, -2111803444},
                                                        {386596237, -2112398960},
                                                        {383355404, -2112989506},
                                                        {380113669, -2113575080},
                                                        {376871039, -2114155680},
                                                        {373627523, -2114731305},
                                                        {370383128, -2115301954},
                                                        {367137861, -2115867626},
                                                        {363891730, -2116428319},
                                                        {360644742, -2116984031},
                                                        {357396906, -2117534762},
                                                        {354148230, -2118080511},
                                                        {350898719, -2118621275},
                                                        {347648383, -2119157054},
                                                        {344397230, -2119687847},
                                                        {341145265, -2120213651},
                                                        {337892498, -2120734467},
                                                        {334638936, -2121250292},
                                                        {331384586, -2121761126},
                                                        {328129457, -2122266967},
                                                        {324873555, -2122767814},
                                                        {321616889, -2123263666},
                                                        {318359466, -2123754522},
                                                        {315101295, -2124240380},
                                                        {311842381, -2124721240},
                                                        {308582734, -2125197100},
                                                        {305322361, -2125667960},
                                                        {302061269, -2126133817},
                                                        {298799466, -2126594672},
                                                        {295536961, -2127050522},
                                                        {292273760, -2127501367},
                                                        {289009871, -2127947206},
                                                        {285745302, -2128388038},
                                                        {282480061, -2128823862},
                                                        {279214155, -2129254676},
                                                        {275947592, -2129680480},
                                                        {272680379, -2130101272},
                                                        {269412525, -2130517052},
                                                        {266144038, -2130927819},
                                                        {262874923, -2131333572},
                                                        {259605191, -2131734309},
                                                        {256334847, -2132130030},
                                                        {253063900, -2132520734},
                                                        {249792358, -2132906420},
                                                        {246520228, -2133287087},
                                                        {243247518, -2133662734},
                                                        {239974235, -2134033361},
                                                        {236700388, -2134398966},
                                                        {233425984, -2134759548},
                                                        {230151030, -2135115107},
                                                        {226875535, -2135465642},
                                                        {223599506, -2135811153},
                                                        {220322951, -2136151637},
                                                        {217045878, -2136487095},
                                                        {213768293, -2136817525},
                                                        {210490206, -2137142927},
                                                        {207211624, -2137463301},
                                                        {203932553, -2137778644},
                                                        {200653003, -2138088958},
                                                        {197372981, -2138394240},
                                                        {194092495, -2138694490},
                                                        {190811551, -2138989708},
                                                        {187530159, -2139279892},
                                                        {184248325, -2139565043},
                                                        {180966058, -2139845159},
                                                        {177683365, -2140120240},
                                                        {174400254, -2140390284},
                                                        {171116733, -2140655293},
                                                        {167832808, -2140915264},
                                                        {164548489, -2141170197},
                                                        {161263783, -2141420092},
                                                        {157978697, -2141664948},
                                                        {154693240, -2141904764},
                                                        {151407418, -2142139541},
                                                        {148121241, -2142369276},
                                                        {144834714, -2142593971},
                                                        {141547847, -2142813624},
                                                        {138260647, -2143028234},
                                                        {134973122, -2143237802},
                                                        {131685278, -2143442326},
                                                        {128397125, -2143641807},
                                                        {125108670, -2143836244},
                                                        {121819921, -2144025635},
                                                        {118530885, -2144209982},
                                                        {115241570, -2144389283},
                                                        {111951983, -2144563539},
                                                        {108662134, -2144732748},
                                                        {105372028, -2144896910},
                                                        {102081675, -2145056025},
                                                        {98791081, -2145210092},
                                                        {95500255, -2145359112},
                                                        {92209205, -2145503083},
                                                        {88917937, -2145642006},
                                                        {85626460, -2145775880},
                                                        {82334782, -2145904705},
                                                        {79042909, -2146028480},
                                                        {75750851, -2146147205},
                                                        {72458615, -2146260881},
                                                        {69166208, -2146369505},
                                                        {65873638, -2146473080},
                                                        {62580914, -2146571603},
                                                        {59288042, -2146665076},
                                                        {55995030, -2146753497},
                                                        {52701887, -2146836866},
                                                        {49408620, -2146915184},
                                                        {46115236, -2146988450},
                                                        {42821744, -2147056664},
                                                        {39528151, -2147119825},
                                                        {36234466, -2147177934},
                                                        {32940695, -2147230991},
                                                        {29646846, -2147278995},
                                                        {26352928, -2147321946},
                                                        {23058947, -2147359845},
                                                        {19764913, -2147392690},
                                                        {16470832, -2147420483},
                                                        {13176712, -2147443222},
                                                        {9882561, -2147460908},
                                                        {6588387, -2147473542},
                                                        {3294197, -2147481121},
                                                        {0, -2147483648},
                                                        {-3294197, -2147481121},
                                                        {-6588387, -2147473542},
                                                        {-9882561, -2147460908},
                                                        {-13176712, -2147443222},
                                                        {-16470832, -2147420483},
                                                        {-19764913, -2147392690},
                                                        {-23058947, -2147359845},
                                                        {-26352928, -2147321946},
                                                        {-29646846, -2147278995},
                                                        {-32940695, -2147230991},
                                                        {-36234466, -2147177934},
                                                        {-39528151, -2147119825},
                                                        {-42821744, -2147056664},
                                                        {-46115236, -2146988450},
                                                        {-49408620, -2146915184},
                                                        {-52701887, -2146836866},
                                                        {-55995030, -2146753497},
                                                        {-59288042, -2146665076},
                                                        {-62580914, -2146571603},
                                                        {-65873638, -2146473080},
                                                        {-69166208, -2146369505},
                                                        {-72458615, -2146260881},
                                                        {-75750851, -2146147205},
                                                        {-79042909, -2146028480},
                                                        {-82334782, -2145904705},
                                                        {-85626460, -2145775880},
                                                        {-88917937, -2145642006},
                                                        {-92209205, -2145503083},
                                                        {-95500255, -2145359112},
                                                        {-98791081, -2145210092},
                                                        {-102081675, -2145056025},
                                                        {-105372028, -2144896910},
                                                        {-108662134, -2144732748},
                                                        {-111951983, -2144563539},
                                                        {-115241570, -2144389283},
                                                        {-118530885, -2144209982},
                                                        {-121819921, -2144025635},
                                                        {-125108670, -2143836244},
                                                        {-128397125, -2143641807},
                                                        {-131685278, -2143442326},
                                                        {-134973122, -2143237802},
                                                        {-138260647, -2143028234},
                                                        {-141547847, -2142813624},
                                                        {-144834714, -2142593971},
                                                        {-148121241, -2142369276},
                                                        {-151407418, -2142139541},
                                                        {-154693240, -2141904764},
                                                        {-157978697, -2141664948},
                                                        {-161263783, -2141420092},
                                                        {-164548489, -2141170197},
                                                        {-167832808, -2140915264},
                                                        {-171116733, -2140655293},
                                                        {-174400254, -2140390284},
                                                        {-177683365, -2140120240},
                                                        {-180966058, -2139845159},
                                                        {-184248325, -2139565043},
                                                        {-187530159, -2139279892},
                                                        {-190811551, -2138989708},
                                                        {-194092495, -2138694490},
                                                        {-197372981, -2138394240},
                                                        {-200653003, -2138088958},
                                                        {-203932553, -2137778644},
                                                        {-207211624, -2137463301},
                                                        {-210490206, -2137142927},
                                                        {-213768293, -2136817525},
                                                        {-217045878, -2136487095},
                                                        {-220322951, -2136151637},
                                                        {-223599506, -2135811153},
                                                        {-226875535, -2135465642},
                                                        {-230151030, -2135115107},
                                                        {-233425984, -2134759548},
                                                        {-236700388, -2134398966},
                                                        {-239974235, -2134033361},
                                                        {-243247518, -2133662734},
                                                        {-246520228, -2133287087},
                                                        {-249792358, -2132906420},
                                                        {-253063900, -2132520734},
                                                        {-256334847, -2132130030},
                                                        {-259605191, -2131734309},
                                                        {-262874923, -2131333572},
                                                        {-266144038, -2130927819},
                                                        {-269412525, -2130517052},
                                                        {-272680379, -2130101272},
                                                        {-275947592, -2129680480},
                                                        {-279214155, -2129254676},
                                                        {-282480061, -2128823862},
                                                        {-285745302, -2128388038},
                                                        {-289009871, -2127947206},
                                                        {-292273760, -2127501367},
                                                        {-295536961, -2127050522},
                                                        {-298799466, -2126594672},
                                                        {-302061269, -2126133817},
                                                        {-305322361, -2125667960},
                                                        {-308582734, -2125197100},
                                                        {-311842381, -2124721240},
                                                        {-315101295, -2124240380},
                                                        {-318359466, -2123754522},
                                                        {-321616889, -2123263666},
                                                        {-324873555, -2122767814},
                                                        {-328129457, -2122266967},
                                                        {-331384586, -2121761126},
                                                        {-334638936, -2121250292},
                                                        {-337892498, -2120734467},
                                                        {-341145265, -2120213651},
                                                        {-344397230, -2119687847},
                                                        {-347648383, -2119157054},
                                                        {-350898719, -2118621275},
                                                        {-354148230, -2118080511},
                                                        {-357396906, -2117534762},
                                                        {-360644742, -2116984031},
                                                        {-363891730, -2116428319},
                                                        {-367137861, -2115867626},
                                                        {-370383128, -2115301954},
                                                        {-373627523, -2114731305},
                                                        {-376871039, -2114155680},
                                                        {-380113669, -2113575080},
                                                        {-383355404, -2112989506},
                                                        {-386596237, -2112398960},
                                                        {-389836160, -2111803444},
                                                        {-393075166, -2111202959},
                                                        {-396313247, -2110597505},
                                                        {-399550396, -2109987085},
                                                        {-402786604, -2109371700},
                                                        {-406021865, -2108751352},
                                                        {-409256170, -2108126041},
                                                        {-412489512, -2107495770},
                                                        {-415721883, -2106860540},
                                                        {-418953276, -2106220352},
                                                        {-422183684, -2105575208},
                                                        {-425413098, -2104925109},
                                                        {-428641511, -2104270057},
                                                        {-431868915, -2103610054},
                                                        {-435095303, -2102945101},
                                                        {-438320667, -2102275199},
                                                        {-441545000, -2101600350},
                                                        {-444768294, -2100920556},
                                                        {-447990541, -2100235819},
                                                        {-451211734, -2099546139},
                                                        {-454431865, -2098851519},
                                                        {-457650927, -2098151960},
                                                        {-460868912, -2097447464},
                                                        {-464085813, -2096738032},
                                                        {-467301622, -2096023667},
                                                        {-470516330, -2095304370},
                                                        {-473729932, -2094580142},
                                                        {-476942419, -2093850985},
                                                        {-480153784, -2093116901},
                                                        {-483364019, -2092377892},
                                                        {-486573117, -2091633960},
                                                        {-489781069, -2090885105},
                                                        {-492987869, -2090131331},
                                                        {-496193509, -2089372638},
                                                        {-499397982, -2088609029},
                                                        {-502601279, -2087840505},
                                                        {-505803394, -2087067068},
                                                        {-509004318, -2086288720},
                                                        {-512204045, -2085505463},
                                                        {-515402566, -2084717298},
                                                        {-518599875, -2083924228},
                                                        {-521795963, -2083126254},
                                                        {-524990824, -2082323379},
                                                        {-528184449, -2081515603},
                                                        {-531376831, -2080702930},
                                                        {-534567963, -2079885360},
                                                        {-537757837, -2079062896},
                                                        {-540946445, -2078235540},
                                                        {-544133781, -2077403294},
                                                        {-547319836, -2076566160},
                                                        {-550504604, -2075724139},
                                                        {-553688076, -2074877233},
                                                        {-556870245, -2074025446},
                                                        {-560051104, -2073168777},
                                                        {-563230645, -2072307231},
                                                        {-566408860, -2071440808},
                                                        {-569585743, -2070569511},
                                                        {-572761285, -2069693342},
                                                        {-575935480, -2068812302},
                                                        {-579108320, -2067926394},
                                                        {-582279796, -2067035621},
                                                        {-585449903, -2066139983},
                                                        {-588618632, -2065239484},
                                                        {-591785976, -2064334124},
                                                        {-594951927, -2063423908},
                                                        {-598116479, -2062508835},
                                                        {-601279623, -2061588910},
                                                        {-604441352, -2060664133},
                                                        {-607601658, -2059734508},
                                                        {-610760536, -2058800036},
                                                        {-613917975, -2057860719},
                                                        {-617073971, -2056916560},
                                                        {-620228514, -2055967560},
                                                        {-623381598, -2055013723},
                                                        {-626533215, -2054055050},
                                                        {-629683357, -2053091544},
                                                        {-632832018, -2052123207},
                                                        {-635979190, -2051150040},
                                                        {-639124865, -2050172048},
                                                        {-642269036, -2049189231},
                                                        {-645411696, -2048201592},
                                                        {-648552838, -2047209133},
                                                        {-651692453, -2046211857},
                                                        {-654830535, -2045209767},
                                                        {-657967075, -2044202863},
                                                        {-661102068, -2043191150},
                                                        {-664235505, -2042174628},
                                                        {-667367379, -2041153301},
                                                        {-670497682, -2040127172},
                                                        {-673626408, -2039096241},
                                                        {-676753549, -2038060512},
                                                        {-679879097, -2037019988},
                                                        {-683003045, -2035974670},
                                                        {-686125387, -2034924562},
                                                        {-689246113, -2033869665},
                                                        {-692365218, -2032809982},
                                                        {-695482694, -2031745516},
                                                        {-698598533, -2030676269},
                                                        {-701712728, -2029602243},
                                                        {-704825272, -2028523442},
                                                        {-707936158, -2027439867},
                                                        {-711045377, -2026351522},
                                                        {-714152924, -2025258408},
                                                        {-717258790, -2024160529},
                                                        {-720362968, -2023057887},
                                                        {-723465451, -2021950484},
                                                        {-726566232, -2020838323},
                                                        {-729665303, -2019721407},
                                                        {-732762657, -2018599739},
                                                        {-735858287, -2017473321},
                                                        {-738952186, -2016342155},
                                                        {-742044345, -2015206245},
                                                        {-745134758, -2014065592},
                                                        {-748223418, -2012920201},
                                                        {-751310318, -2011770073},
                                                        {-754395449, -2010615210},
                                                        {-757478806, -2009455617},
                                                        {-760560380, -2008291295},
                                                        {-763640164, -2007122248},
                                                        {-766718151, -2005948478},
                                                        {-769794334, -2004769987},
                                                        {-772868706, -2003586779},
                                                        {-775941259, -2002398857},
                                                        {-779011986, -2001206222},
                                                        {-782080880, -2000008879},
                                                        {-785147934, -1998806829},
                                                        {-788213141, -1997600076},
                                                        {-791276492, -1996388622},
                                                        {-794337982, -1995172471},
                                                        {-797397602, -1993951625},
                                                        {-800455346, -1992726087},
                                                        {-803511207, -1991495860},
                                                        {-806565177, -1990260946},
                                                        {-809617249, -1989021350},
                                                        {-812667415, -1987777073},
                                                        {-815715670, -1986528118},
                                                        {-818762005, -1985274489},
                                                        {-821806413, -1984016189},
                                                        {-824848888, -1982753220},
                                                        {-827889422, -1981485585},
                                                        {-830928007, -1980213288},
                                                        {-833964638, -1978936331},
                                                        {-836999305, -1977654717},
                                                        {-840032004, -1976368450},
                                                        {-843062726, -1975077532},
                                                        {-846091463, -1973781967},
                                                        {-849118210, -1972481757},
                                                        {-852142959, -1971176906},
                                                        {-855165703, -1969867417},
                                                        {-858186435, -1968553292},
                                                        {-861205147, -1967234535},
                                                        {-864221832, -1965911148},
                                                        {-867236484, -1964583136},
                                                        {-870249095, -1963250501},
                                                        {-873259659, -1961913246},
                                                        {-876268167, -1960571375},
                                                        {-879274614, -1959224890},
                                                        {-882278992, -1957873796},
                                                        {-885281293, -1956518093},
                                                        {-888281512, -1955157788},
                                                        {-891279640, -1953792881},
                                                        {-894275671, -1952423377},
                                                        {-897269597, -1951049279},
                                                        {-900261413, -1949670589},
                                                        {-903251110, -1948287312},
                                                        {-906238681, -1946899451},
                                                        {-909224120, -1945507008},
                                                        {-912207419, -1944109987},
                                                        {-915188572, -1942708392},
                                                        {-918167572, -1941302225},
                                                        {-921144411, -1939891490},
                                                        {-924119082, -1938476190},
                                                        {-927091579, -1937056329},
                                                        {-930061894, -1935631910},
                                                        {-933030021, -1934202936},
                                                        {-935995952, -1932769411},
                                                        {-938959681, -1931331338},
                                                        {-941921200, -1929888720},
                                                        {-944880503, -1928441561},
                                                        {-947837582, -1926989864},
                                                        {-950792431, -1925533633},
                                                        {-953745043, -1924072871},
                                                        {-956695411, -1922607581},
                                                        {-959643527, -1921137767},
                                                        {-962589385, -1919663432},
                                                        {-965532978, -1918184581},
                                                        {-968474300, -1916701216},
                                                        {-971413342, -1915213340},
                                                        {-974350098, -1913720958},
                                                        {-977284562, -1912224073},
                                                        {-980216726, -1910722688},
                                                        {-983146583, -1909216806},
                                                        {-986074127, -1907706433},
                                                        {-988999351, -1906191570},
                                                        {-991922248, -1904672222},
                                                        {-994842810, -1903148392},
                                                        {-997761031, -1901620084},
                                                        {-1000676905, -1900087301},
                                                        {-1003590424, -1898550047},
                                                        {-1006501581, -1897008325},
                                                        {-1009410370, -1895462140},
                                                        {-1012316784, -1893911494},
                                                        {-1015220816, -1892356392},
                                                        {-1018122458, -1890796837},
                                                        {-1021021705, -1889232832},
                                                        {-1023918550, -1887664383},
                                                        {-1026812985, -1886091491},
                                                        {-1029705004, -1884514161},
                                                        {-1032594600, -1882932397},
                                                        {-1035481766, -1881346202},
                                                        {-1038366495, -1879755580},
                                                        {-1041248781, -1878160535},
                                                        {-1044128617, -1876561070},
                                                        {-1047005996, -1874957189},
                                                        {-1049880912, -1873348897},
                                                        {-1052753357, -1871736196},
                                                        {-1055623324, -1870119091},
                                                        {-1058490808, -1868497586},
                                                        {-1061355801, -1866871683},
                                                        {-1064218296, -1865241388},
                                                        {-1067078288, -1863606704},
                                                        {-1069935768, -1861967634},
                                                        {-1072790730, -1860324183},
                                                        {-1075643169, -1858676355},
                                                        {-1078493076, -1857024153},
                                                        {-1081340445, -1855367581},
                                                        {-1084185270, -1853706643},
                                                        {-1087027544, -1852041343},
                                                        {-1089867259, -1850371686},
                                                        {-1092704411, -1848697674},
                                                        {-1095538991, -1847019312},
                                                        {-1098370993, -1845336604},
                                                        {-1101200410, -1843649553},
                                                        {-1104027237, -1841958164},
                                                        {-1106851465, -1840262441},
                                                        {-1109673089, -1838562388},
                                                        {-1112492101, -1836858008},
                                                        {-1115308496, -1835149306},
                                                        {-1118122267, -1833436286},
                                                        {-1120933406, -1831718951},
                                                        {-1123741908, -1829997307},
                                                        {-1126547765, -1828271356},
                                                        {-1129350972, -1826541103},
                                                        {-1132151521, -1824806552},
                                                        {-1134949406, -1823067707},
                                                        {-1137744621, -1821324572},
                                                        {-1140537158, -1819577151},
                                                        {-1143327011, -1817825449},
                                                        {-1146114174, -1816069469},
                                                        {-1148898640, -1814309216},
                                                        {-1151680403, -1812544694},
                                                        {-1154459456, -1810775906},
                                                        {-1157235792, -1809002858},
                                                        {-1160009405, -1807225553},
                                                        {-1162780288, -1805443995},
                                                        {-1165548435, -1803658189},
                                                        {-1168313840, -1801868139},
                                                        {-1171076495, -1800073849},
                                                        {-1173836395, -1798275323},
                                                        {-1176593533, -1796472565},
                                                        {-1179347902, -1794665580},
                                                        {-1182099496, -1792854372},
                                                        {-1184848308, -1791038946},
                                                        {-1187594332, -1789219305},
                                                        {-1190337562, -1787395453},
                                                        {-1193077991, -1785567396},
                                                        {-1195815612, -1783735137},
                                                        {-1198550419, -1781898681},
                                                        {-1201282407, -1780058032},
                                                        {-1204011567, -1778213194},
                                                        {-1206737894, -1776364172},
                                                        {-1209461382, -1774510970},
                                                        {-1212182024, -1772653593},
                                                        {-1214899813, -1770792044},
                                                        {-1217614743, -1768926328},
                                                        {-1220326809, -1767056450},
                                                        {-1223036002, -1765182414},
                                                        {-1225742318, -1763304224},
                                                        {-1228445750, -1761421885},
                                                        {-1231146291, -1759535401},
                                                        {-1233843935, -1757644777},
                                                        {-1236538675, -1755750017},
                                                        {-1239230506, -1753851126},
                                                        {-1241919421, -1751948107},
                                                        {-1244605414, -1750040966},
                                                        {-1247288478, -1748129707},
                                                        {-1249968606, -1746214334},
                                                        {-1252645794, -1744294853},
                                                        {-1255320034, -1742371267},
                                                        {-1257991320, -1740443581},
                                                        {-1260659646, -1738511799},
                                                        {-1263325005, -1736575927},
                                                        {-1265987392, -1734635968},
                                                        {-1268646800, -1732691928},
                                                        {-1271303222, -1730743810},
                                                        {-1273956653, -1728791620},
                                                        {-1276607086, -1726835361},
                                                        {-1279254516, -1724875040},
                                                        {-1281898935, -1722910659},
                                                        {-1284540337, -1720942225},
                                                        {-1287178717, -1718969740},
                                                        {-1289814068, -1716993211},
                                                        {-1292446384, -1715012642},
                                                        {-1295075659, -1713028037},
                                                        {-1297701886, -1711039401},
                                                        {-1300325060, -1709046739},
                                                        {-1302945174, -1707050055},
                                                        {-1305562222, -1705049355},
                                                        {-1308176198, -1703044642},
                                                        {-1310787095, -1701035922},
                                                        {-1313394909, -1699023199},
                                                        {-1315999631, -1697006479},
                                                        {-1318601257, -1694985765},
                                                        {-1321199781, -1692961062},
                                                        {-1323795195, -1690932376},
                                                        {-1326387494, -1688899711},
                                                        {-1328976672, -1686863072},
                                                        {-1331562723, -1684822463},
                                                        {-1334145641, -1682777890},
                                                        {-1336725419, -1680729357},
                                                        {-1339302052, -1678676870},
                                                        {-1341875533, -1676620432},
                                                        {-1344445857, -1674560049},
                                                        {-1347013017, -1672495725},
                                                        {-1349577007, -1670427466},
                                                        {-1352137822, -1668355276},
                                                        {-1354695455, -1666279161},
                                                        {-1357249901, -1664199124},
                                                        {-1359801152, -1662115172},
                                                        {-1362349204, -1660027308},
                                                        {-1364894050, -1657935539},
                                                        {-1367435685, -1655839867},
                                                        {-1369974101, -1653740300},
                                                        {-1372509294, -1651636841},
                                                        {-1375041258, -1649529496},
                                                        {-1377569986, -1647418269},
                                                        {-1380095472, -1645303166},
                                                        {-1382617710, -1643184191},
                                                        {-1385136696, -1641061349},
                                                        {-1387652422, -1638934646},
                                                        {-1390164882, -1636804087},
                                                        {-1392674072, -1634669676},
                                                        {-1395179984, -1632531418},
                                                        {-1397682613, -1630389319},
                                                        {-1400181954, -1628243383},
                                                        {-1402678000, -1626093616},
                                                        {-1405170745, -1623940023},
                                                        {-1407660183, -1621782608},
                                                        {-1410146309, -1619621377},
                                                        {-1412629117, -1617456335},
                                                        {-1415108601, -1615287487},
                                                        {-1417584755, -1613114838},
                                                        {-1420057574, -1610938393},
                                                        {-1422527051, -1608758157},
                                                        {-1424993180, -1606574136},
                                                        {-1427455956, -1604386335},
                                                        {-1429915374, -1602194758},
                                                        {-1432371426, -1599999411},
                                                        {-1434824109, -1597800299},
                                                        {-1437273414, -1595597428},
                                                        {-1439719338, -1593390801},
                                                        {-1442161874, -1591180426},
                                                        {-1444601017, -1588966306},
                                                        {-1447036760, -1586748447},
                                                        {-1449469098, -1584526854},
                                                        {-1451898025, -1582301533},
                                                        {-1454323536, -1580072489},
                                                        {-1456745625, -1577839726},
                                                        {-1459164286, -1575603251},
                                                        {-1461579514, -1573363068},
                                                        {-1463991302, -1571119183},
                                                        {-1466399645, -1568871601},
                                                        {-1468804538, -1566620327},
                                                        {-1471205974, -1564365367},
                                                        {-1473603949, -1562106725},
                                                        {-1475998456, -1559844408},
                                                        {-1478389489, -1557578421},
                                                        {-1480777044, -1555308768},
                                                        {-1483161115, -1553035455},
                                                        {-1485541696, -1550758488},
                                                        {-1487918781, -1548477872},
                                                        {-1490292364, -1546193612},
                                                        {-1492662441, -1543905714},
                                                        {-1495029006, -1541614183},
                                                        {-1497392053, -1539319024},
                                                        {-1499751576, -1537020244},
                                                        {-1502107570, -1534717846},
                                                        {-1504460029, -1532411837},
                                                        {-1506808949, -1530102222},
                                                        {-1509154322, -1527789007},
                                                        {-1511496145, -1525472197},
                                                        {-1513834411, -1523151797},
                                                        {-1516169114, -1520827813},
                                                        {-1518500250, -1518500250},
                                                        {-1520827813, -1516169114},
                                                        {-1523151797, -1513834411},
                                                        {-1525472197, -1511496145},
                                                        {-1527789007, -1509154322},
                                                        {-1530102222, -1506808949},
                                                        {-1532411837, -1504460029},
                                                        {-1534717846, -1502107570},
                                                        {-1537020244, -1499751576},
                                                        {-1539319024, -1497392053},
                                                        {-1541614183, -1495029006},
                                                        {-1543905714, -1492662441},
                                                        {-1546193612, -1490292364},
                                                        {-1548477872, -1487918781},
                                                        {-1550758488, -1485541696},
                                                        {-1553035455, -1483161115},
                                                        {-1555308768, -1480777044},
                                                        {-1557578421, -1478389489},
                                                        {-1559844408, -1475998456},
                                                        {-1562106725, -1473603949},
                                                        {-1564365367, -1471205974},
                                                        {-1566620327, -1468804538},
                                                        {-1568871601, -1466399645},
                                                        {-1571119183, -1463991302},
                                                        {-1573363068, -1461579514},
                                                        {-1575603251, -1459164286},
                                                        {-1577839726, -1456745625},
                                                        {-1580072489, -1454323536},
                                                        {-1582301533, -1451898025},
                                                        {-1584526854, -1449469098},
                                                        {-1586748447, -1447036760},
                                                        {-1588966306, -1444601017},
                                                        {-1591180426, -1442161874},
                                                        {-1593390801, -1439719338},
                                                        {-1595597428, -1437273414},
                                                        {-1597800299, -1434824109},
                                                        {-1599999411, -1432371426},
                                                        {-1602194758, -1429915374},
                                                        {-1604386335, -1427455956},
                                                        {-1606574136, -1424993180},
                                                        {-1608758157, -1422527051},
                                                        {-1610938393, -1420057574},
                                                        {-1613114838, -1417584755},
                                                        {-1615287487, -1415108601},
                                                        {-1617456335, -1412629117},
                                                        {-1619621377, -1410146309},
                                                        {-1621782608, -1407660183},
                                                        {-1623940023, -1405170745},
                                                        {-1626093616, -1402678000},
                                                        {-1628243383, -1400181954},
                                                        {-1630389319, -1397682613},
                                                        {-1632531418, -1395179984},
                                                        {-1634669676, -1392674072},
                                                        {-1636804087, -1390164882},
                                                        {-1638934646, -1387652422},
                                                        {-1641061349, -1385136696},
                                                        {-1643184191, -1382617710},
                                                        {-1645303166, -1380095472},
                                                        {-1647418269, -1377569986},
                                                        {-1649529496, -1375041258},
                                                        {-1651636841, -1372509294},
                                                        {-1653740300, -1369974101},
                                                        {-1655839867, -1367435685},
                                                        {-1657935539, -1364894050},
                                                        {-1660027308, -1362349204},
                                                        {-1662115172, -1359801152},
                                                        {-1664199124, -1357249901},
                                                        {-1666279161, -1354695455},
                                                        {-1668355276, -1352137822},
                                                        {-1670427466, -1349577007},
                                                        {-1672495725, -1347013017},
                                                        {-1674560049, -1344445857},
                                                        {-1676620432, -1341875533},
                                                        {-1678676870, -1339302052},
                                                        {-1680729357, -1336725419},
                                                        {-1682777890, -1334145641},
                                                        {-1684822463, -1331562723},
                                                        {-1686863072, -1328976672},
                                                        {-1688899711, -1326387494},
                                                        {-1690932376, -1323795195},
                                                        {-1692961062, -1321199781},
                                                        {-1694985765, -1318601257},
                                                        {-1697006479, -1315999631},
                                                        {-1699023199, -1313394909},
                                                        {-1701035922, -1310787095},
                                                        {-1703044642, -1308176198},
                                                        {-1705049355, -1305562222},
                                                        {-1707050055, -1302945174},
                                                        {-1709046739, -1300325060},
                                                        {-1711039401, -1297701886},
                                                        {-1713028037, -1295075659},
                                                        {-1715012642, -1292446384},
                                                        {-1716993211, -1289814068},
                                                        {-1718969740, -1287178717},
                                                        {-1720942225, -1284540337},
                                                        {-1722910659, -1281898935},
                                                        {-1724875040, -1279254516},
                                                        {-1726835361, -1276607086},
                                                        {-1728791620, -1273956653},
                                                        {-1730743810, -1271303222},
                                                        {-1732691928, -1268646800},
                                                        {-1734635968, -1265987392},
                                                        {-1736575927, -1263325005},
                                                        {-1738511799, -1260659646},
                                                        {-1740443581, -1257991320},
                                                        {-1742371267, -1255320034},
                                                        {-1744294853, -1252645794},
                                                        {-1746214334, -1249968606},
                                                        {-1748129707, -1247288478},
                                                        {-1750040966, -1244605414},
                                                        {-1751948107, -1241919421},
                                                        {-1753851126, -1239230506},
                                                        {-1755750017, -1236538675},
                                                        {-1757644777, -1233843935},
                                                        {-1759535401, -1231146291},
                                                        {-1761421885, -1228445750},
                                                        {-1763304224, -1225742318},
                                                        {-1765182414, -1223036002},
                                                        {-1767056450, -1220326809},
                                                        {-1768926328, -1217614743},
                                                        {-1770792044, -1214899813},
                                                        {-1772653593, -1212182024},
                                                        {-1774510970, -1209461382},
                                                        {-1776364172, -1206737894},
                                                        {-1778213194, -1204011567},
                                                        {-1780058032, -1201282407},
                                                        {-1781898681, -1198550419},
                                                        {-1783735137, -1195815612},
                                                        {-1785567396, -1193077991},
                                                        {-1787395453, -1190337562},
                                                        {-1789219305, -1187594332},
                                                        {-1791038946, -1184848308},
                                                        {-1792854372, -1182099496},
                                                        {-1794665580, -1179347902},
                                                        {-1796472565, -1176593533},
                                                        {-1798275323, -1173836395},
                                                        {-1800073849, -1171076495},
                                                        {-1801868139, -1168313840},
                                                        {-1803658189, -1165548435},
                                                        {-1805443995, -1162780288},
                                                        {-1807225553, -1160009405},
                                                        {-1809002858, -1157235792},
                                                        {-1810775906, -1154459456},
                                                        {-1812544694, -1151680403},
                                                        {-1814309216, -1148898640},
                                                        {-1816069469, -1146114174},
                                                        {-1817825449, -1143327011},
                                                        {-1819577151, -1140537158},
                                                        {-1821324572, -1137744621},
                                                        {-1823067707, -1134949406},
                                                        {-1824806552, -1132151521},
                                                        {-1826541103, -1129350972},
                                                        {-1828271356, -1126547765},
                                                        {-1829997307, -1123741908},
                                                        {-1831718951, -1120933406},
                                                        {-1833436286, -1118122267},
                                                        {-1835149306, -1115308496},
                                                        {-1836858008, -1112492101},
                                                        {-1838562388, -1109673089},
                                                        {-1840262441, -1106851465},
                                                        {-1841958164, -1104027237},
                                                        {-1843649553, -1101200410},
                                                        {-1845336604, -1098370993},
                                                        {-1847019312, -1095538991},
                                                        {-1848697674, -1092704411},
                                                        {-1850371686, -1089867259},
                                                        {-1852041343, -1087027544},
                                                        {-1853706643, -1084185270},
                                                        {-1855367581, -1081340445},
                                                        {-1857024153, -1078493076},
                                                        {-1858676355, -1075643169},
                                                        {-1860324183, -1072790730},
                                                        {-1861967634, -1069935768},
                                                        {-1863606704, -1067078288},
                                                        {-1865241388, -1064218296},
                                                        {-1866871683, -1061355801},
                                                        {-1868497586, -1058490808},
                                                        {-1870119091, -1055623324},
                                                        {-1871736196, -1052753357},
                                                        {-1873348897, -1049880912},
                                                        {-1874957189, -1047005996},
                                                        {-1876561070, -1044128617},
                                                        {-1878160535, -1041248781},
                                                        {-1879755580, -1038366495},
                                                        {-1881346202, -1035481766},
                                                        {-1882932397, -1032594600},
                                                        {-1884514161, -1029705004},
                                                        {-1886091491, -1026812985},
                                                        {-1887664383, -1023918550},
                                                        {-1889232832, -1021021705},
                                                        {-1890796837, -1018122458},
                                                        {-1892356392, -1015220816},
                                                        {-1893911494, -1012316784},
                                                        {-1895462140, -1009410370},
                                                        {-1897008325, -1006501581},
                                                        {-1898550047, -1003590424},
                                                        {-1900087301, -1000676905},
                                                        {-1901620084, -997761031},
                                                        {-1903148392, -994842810},
                                                        {-1904672222, -991922248},
                                                        {-1906191570, -988999351},
                                                        {-1907706433, -986074127},
                                                        {-1909216806, -983146583},
                                                        {-1910722688, -980216726},
                                                        {-1912224073, -977284562},
                                                        {-1913720958, -974350098},
                                                        {-1915213340, -971413342},
                                                        {-1916701216, -968474300},
                                                        {-1918184581, -965532978},
                                                        {-1919663432, -962589385},
                                                        {-1921137767, -959643527},
                                                        {-1922607581, -956695411},
                                                        {-1924072871, -953745043},
                                                        {-1925533633, -950792431},
                                                        {-1926989864, -947837582},
                                                        {-1928441561, -944880503},
                                                        {-1929888720, -941921200},
                                                        {-1931331338, -938959681},
                                                        {-1932769411, -935995952},
                                                        {-1934202936, -933030021},
                                                        {-1935631910, -930061894},
                                                        {-1937056329, -927091579},
                                                        {-1938476190, -924119082},
                                                        {-1939891490, -921144411},
                                                        {-1941302225, -918167572},
                                                        {-1942708392, -915188572},
                                                        {-1944109987, -912207419},
                                                        {-1945507008, -909224120},
                                                        {-1946899451, -906238681},
                                                        {-1948287312, -903251110},
                                                        {-1949670589, -900261413},
                                                        {-1951049279, -897269597},
                                                        {-1952423377, -894275671},
                                                        {-1953792881, -891279640},
                                                        {-1955157788, -888281512},
                                                        {-1956518093, -885281293},
                                                        {-1957873796, -882278992},
                                                        {-1959224890, -879274614},
                                                        {-1960571375, -876268167},
                                                        {-1961913246, -873259659},
                                                        {-1963250501, -870249095},
                                                        {-1964583136, -867236484},
                                                        {-1965911148, -864221832},
                                                        {-1967234535, -861205147},
                                                        {-1968553292, -858186435},
                                                        {-1969867417, -855165703},
                                                        {-1971176906, -852142959},
                                                        {-1972481757, -849118210},
                                                        {-1973781967, -846091463},
                                                        {-1975077532, -843062726},
                                                        {-1976368450, -840032004},
                                                        {-1977654717, -836999305},
                                                        {-1978936331, -833964638},
                                                        {-1980213288, -830928007},
                                                        {-1981485585, -827889422},
                                                        {-1982753220, -824848888},
                                                        {-1984016189, -821806413},
                                                        {-1985274489, -818762005},
                                                        {-1986528118, -815715670},
                                                        {-1987777073, -812667415},
                                                        {-1989021350, -809617249},
                                                        {-1990260946, -806565177},
                                                        {-1991495860, -803511207},
                                                        {-1992726087, -800455346},
                                                        {-1993951625, -797397602},
                                                        {-1995172471, -794337982},
                                                        {-1996388622, -791276492},
                                                        {-1997600076, -788213141},
                                                        {-1998806829, -785147934},
                                                        {-2000008879, -782080880},
                                                        {-2001206222, -779011986},
                                                        {-2002398857, -775941259},
                                                        {-2003586779, -772868706},
                                                        {-2004769987, -769794334},
                                                        {-2005948478, -766718151},
                                                        {-2007122248, -763640164},
                                                        {-2008291295, -760560380},
                                                        {-2009455617, -757478806},
                                                        {-2010615210, -754395449},
                                                        {-2011770073, -751310318},
                                                        {-2012920201, -748223418},
                                                        {-2014065592, -745134758},
                                                        {-2015206245, -742044345},
                                                        {-2016342155, -738952186},
                                                        {-2017473321, -735858287},
                                                        {-2018599739, -732762657},
                                                        {-2019721407, -729665303},
                                                        {-2020838323, -726566232},
                                                        {-2021950484, -723465451},
                                                        {-2023057887, -720362968},
                                                        {-2024160529, -717258790},
                                                        {-2025258408, -714152924},
                                                        {-2026351522, -711045377},
                                                        {-2027439867, -707936158},
                                                        {-2028523442, -704825272},
                                                        {-2029602243, -701712728},
                                                        {-2030676269, -698598533},
                                                        {-2031745516, -695482694},
                                                        {-2032809982, -692365218},
                                                        {-2033869665, -689246113},
                                                        {-2034924562, -686125387},
                                                        {-2035974670, -683003045},
                                                        {-2037019988, -679879097},
                                                        {-2038060512, -676753549},
                                                        {-2039096241, -673626408},
                                                        {-2040127172, -670497682},
                                                        {-2041153301, -667367379},
                                                        {-2042174628, -664235505},
                                                        {-2043191150, -661102068},
                                                        {-2044202863, -657967075},
                                                        {-2045209767, -654830535},
                                                        {-2046211857, -651692453},
                                                        {-2047209133, -648552838},
                                                        {-2048201592, -645411696},
                                                        {-2049189231, -642269036},
                                                        {-2050172048, -639124865},
                                                        {-2051150040, -635979190},
                                                        {-2052123207, -632832018},
                                                        {-2053091544, -629683357},
                                                        {-2054055050, -626533215},
                                                        {-2055013723, -623381598},
                                                        {-2055967560, -620228514},
                                                        {-2056916560, -617073971},
                                                        {-2057860719, -613917975},
                                                        {-2058800036, -610760536},
                                                        {-2059734508, -607601658},
                                                        {-2060664133, -604441352},
                                                        {-2061588910, -601279623},
                                                        {-2062508835, -598116479},
                                                        {-2063423908, -594951927},
                                                        {-2064334124, -591785976},
                                                        {-2065239484, -588618632},
                                                        {-2066139983, -585449903},
                                                        {-2067035621, -582279796},
                                                        {-2067926394, -579108320},
                                                        {-2068812302, -575935480},
                                                        {-2069693342, -572761285},
                                                        {-2070569511, -569585743},
                                                        {-2071440808, -566408860},
                                                        {-2072307231, -563230645},
                                                        {-2073168777, -560051104},
                                                        {-2074025446, -556870245},
                                                        {-2074877233, -553688076},
                                                        {-2075724139, -550504604},
                                                        {-2076566160, -547319836},
                                                        {-2077403294, -544133781},
                                                        {-2078235540, -540946445},
                                                        {-2079062896, -537757837},
                                                        {-2079885360, -534567963},
                                                        {-2080702930, -531376831},
                                                        {-2081515603, -528184449},
                                                        {-2082323379, -524990824},
                                                        {-2083126254, -521795963},
                                                        {-2083924228, -518599875},
                                                        {-2084717298, -515402566},
                                                        {-2085505463, -512204045},
                                                        {-2086288720, -509004318},
                                                        {-2087067068, -505803394},
                                                        {-2087840505, -502601279},
                                                        {-2088609029, -499397982},
                                                        {-2089372638, -496193509},
                                                        {-2090131331, -492987869},
                                                        {-2090885105, -489781069},
                                                        {-2091633960, -486573117},
                                                        {-2092377892, -483364019},
                                                        {-2093116901, -480153784},
                                                        {-2093850985, -476942419},
                                                        {-2094580142, -473729932},
                                                        {-2095304370, -470516330},
                                                        {-2096023667, -467301622},
                                                        {-2096738032, -464085813},
                                                        {-2097447464, -460868912},
                                                        {-2098151960, -457650927},
                                                        {-2098851519, -454431865},
                                                        {-2099546139, -451211734},
                                                        {-2100235819, -447990541},
                                                        {-2100920556, -444768294},
                                                        {-2101600350, -441545000},
                                                        {-2102275199, -438320667},
                                                        {-2102945101, -435095303},
                                                        {-2103610054, -431868915},
                                                        {-2104270057, -428641511},
                                                        {-2104925109, -425413098},
                                                        {-2105575208, -422183684},
                                                        {-2106220352, -418953276},
                                                        {-2106860540, -415721883},
                                                        {-2107495770, -412489512},
                                                        {-2108126041, -409256170},
                                                        {-2108751352, -406021865},
                                                        {-2109371700, -402786604},
                                                        {-2109987085, -399550396},
                                                        {-2110597505, -396313247},
                                                        {-2111202959, -393075166},
                                                        {-2111803444, -389836160},
                                                        {-2112398960, -386596237},
                                                        {-2112989506, -383355404},
                                                        {-2113575080, -380113669},
                                                        {-2114155680, -376871039},
                                                        {-2114731305, -373627523},
                                                        {-2115301954, -370383128},
                                                        {-2115867626, -367137861},
                                                        {-2116428319, -363891730},
                                                        {-2116984031, -360644742},
                                                        {-2117534762, -357396906},
                                                        {-2118080511, -354148230},
                                                        {-2118621275, -350898719},
                                                        {-2119157054, -347648383},
                                                        {-2119687847, -344397230},
                                                        {-2120213651, -341145265},
                                                        {-2120734467, -337892498},
                                                        {-2121250292, -334638936},
                                                        {-2121761126, -331384586},
                                                        {-2122266967, -328129457},
                                                        {-2122767814, -324873555},
                                                        {-2123263666, -321616889},
                                                        {-2123754522, -318359466},
                                                        {-2124240380, -315101295},
                                                        {-2124721240, -311842381},
                                                        {-2125197100, -308582734},
                                                        {-2125667960, -305322361},
                                                        {-2126133817, -302061269},
                                                        {-2126594672, -298799466},
                                                        {-2127050522, -295536961},
                                                        {-2127501367, -292273760},
                                                        {-2127947206, -289009871},
                                                        {-2128388038, -285745302},
                                                        {-2128823862, -282480061},
                                                        {-2129254676, -279214155},
                                                        {-2129680480, -275947592},
                                                        {-2130101272, -272680379},
                                                        {-2130517052, -269412525},
                                                        {-2130927819, -266144038},
                                                        {-2131333572, -262874923},
                                                        {-2131734309, -259605191},
                                                        {-2132130030, -256334847},
                                                        {-2132520734, -253063900},
                                                        {-2132906420, -249792358},
                                                        {-2133287087, -246520228},
                                                        {-2133662734, -243247518},
                                                        {-2134033361, -239974235},
                                                        {-2134398966, -236700388},
                                                        {-2134759548, -233425984},
                                                        {-2135115107, -230151030},
                                                        {-2135465642, -226875535},
                                                        {-2135811153, -223599506},
                                                        {-2136151637, -220322951},
                                                        {-2136487095, -217045878},
                                                        {-2136817525, -213768293},
                                                        {-2137142927, -210490206},
                                                        {-2137463301, -207211624},
                                                        {-2137778644, -203932553},
                                                        {-2138088958, -200653003},
                                                        {-2138394240, -197372981},
                                                        {-2138694490, -194092495},
                                                        {-2138989708, -190811551},
                                                        {-2139279892, -187530159},
                                                        {-2139565043, -184248325},
                                                        {-2139845159, -180966058},
                                                        {-2140120240, -177683365},
                                                        {-2140390284, -174400254},
                                                        {-2140655293, -171116733},
                                                        {-2140915264, -167832808},
                                                        {-2141170197, -164548489},
                                                        {-2141420092, -161263783},
                                                        {-2141664948, -157978697},
                                                        {-2141904764, -154693240},
                                                        {-2142139541, -151407418},
                                                        {-2142369276, -148121241},
                                                        {-2142593971, -144834714},
                                                        {-2142813624, -141547847},
                                                        {-2143028234, -138260647},
                                                        {-2143237802, -134973122},
                                                        {-2143442326, -131685278},
                                                        {-2143641807, -128397125},
                                                        {-2143836244, -125108670},
                                                        {-2144025635, -121819921},
                                                        {-2144209982, -118530885},
                                                        {-2144389283, -115241570},
                                                        {-2144563539, -111951983},
                                                        {-2144732748, -108662134},
                                                        {-2144896910, -105372028},
                                                        {-2145056025, -102081675},
                                                        {-2145210092, -98791081},
                                                        {-2145359112, -95500255},
                                                        {-2145503083, -92209205},
                                                        {-2145642006, -88917937},
                                                        {-2145775880, -85626460},
                                                        {-2145904705, -82334782},
                                                        {-2146028480, -79042909},
                                                        {-2146147205, -75750851},
                                                        {-2146260881, -72458615},
                                                        {-2146369505, -69166208},
                                                        {-2146473080, -65873638},
                                                        {-2146571603, -62580914},
                                                        {-2146665076, -59288042},
                                                        {-2146753497, -55995030},
                                                        {-2146836866, -52701887},
                                                        {-2146915184, -49408620},
                                                        {-2146988450, -46115236},
                                                        {-2147056664, -42821744},
                                                        {-2147119825, -39528151},
                                                        {-2147177934, -36234466},
                                                        {-2147230991, -32940695},
                                                        {-2147278995, -29646846},
                                                        {-2147321946, -26352928},
                                                        {-2147359845, -23058947},
                                                        {-2147392690, -19764913},
                                                        {-2147420483, -16470832},
                                                        {-2147443222, -13176712},
                                                        {-2147460908, -9882561},
                                                        {-2147473542, -6588387},
                                                        {-2147481121, -3294197}};
const cfloat twiddle_master_cfloat[kMasterTableSize] = {
    {1.000000000, -0.000000000},  {0.999998808, -0.001533980},  {0.999995291, -0.003067957},
    {0.999989390, -0.004601926},  {0.999981165, -0.006135885},  {0.999970615, -0.007669829},
    {0.999957621, -0.009203754},  {0.999942362, -0.010737659},  {0.999924719, -0.012271538},
    {0.999904692, -0.013805388},  {0.999882340, -0.015339206},  {0.999857664, -0.016872987},
    {0.999830604, -0.018406730},  {0.999801159, -0.019940428},  {0.999769390, -0.021474080},
    {0.999735296, -0.023007682},  {0.999698818, -0.024541229},  {0.999660015, -0.026074719},
    {0.999618828, -0.027608145},  {0.999575317, -0.029141508},  {0.999529421, -0.030674804},
    {0.999481201, -0.032208025},  {0.999430597, -0.033741172},  {0.999377668, -0.035274237},
    {0.999322355, -0.036807224},  {0.999264777, -0.038340122},  {0.999204755, -0.039872926},
    {0.999142408, -0.041405641},  {0.999077737, -0.042938258},  {0.999010682, -0.044470772},
    {0.998941302, -0.046003181},  {0.998869538, -0.047535483},  {0.998795450, -0.049067676},
    {0.998719037, -0.050599750},  {0.998640239, -0.052131705},  {0.998559058, -0.053663537},
    {0.998475552, -0.055195246},  {0.998389721, -0.056726821},  {0.998301566, -0.058258265},
    {0.998211026, -0.059789572},  {0.998118103, -0.061320737},  {0.998022854, -0.062851757},
    {0.997925282, -0.064382628},  {0.997825325, -0.065913349},  {0.997723043, -0.067443922},
    {0.997618437, -0.068974331},  {0.997511446, -0.070504576},  {0.997402132, -0.072034650},
    {0.997290432, -0.073564567},  {0.997176409, -0.075094298},  {0.997060061, -0.076623864},
    {0.996941328, -0.078153245},  {0.996820271, -0.079682440},  {0.996696889, -0.081211448},
    {0.996571124, -0.082740262},  {0.996443033, -0.084268890},  {0.996312618, -0.085797310},
    {0.996179819, -0.087325536},  {0.996044695, -0.088853553},  {0.995907247, -0.090381362},
    {0.995767415, -0.091908954},  {0.995625257, -0.093436338},  {0.995480776, -0.094963498},
    {0.995333910, -0.096490428},  {0.995184720, -0.098017141},  {0.995033205, -0.099543616},
    {0.994879305, -0.101069860},  {0.994723141, -0.102595866},  {0.994564593, -0.104121633},
    {0.994403660, -0.105647154},  {0.994240463, -0.107172422},  {0.994074881, -0.108697444},
    {0.993906975, -0.110222206},  {0.993736744, -0.111746714},  {0.993564129, -0.113270953},
    {0.993389189, -0.114794925},  {0.993211925, -0.116318628},  {0.993032336, -0.117842063},
    {0.992850423, -0.119365215},  {0.992666125, -0.120888084},  {0.992479563, -0.122410677},
    {0.992290616, -0.123932973},  {0.992099285, -0.125454977},  {0.991905689, -0.126976699},
    {0.991709769, -0.128498107},  {0.991511464, -0.130019218},  {0.991310835, -0.131540030},
    {0.991107941, -0.133060530},  {0.990902662, -0.134580702},  {0.990695000, -0.136100575},
    {0.990485072, -0.137620121},  {0.990272820, -0.139139339},  {0.990058184, -0.140658244},
    {0.989841282, -0.142176807},  {0.989621997, -0.143695027},  {0.989400446, -0.145212919},
    {0.989176512, -0.146730468},  {0.988950253, -0.148247674},  {0.988721669, -0.149764538},
    {0.988490820, -0.151281044},  {0.988257587, -0.152797192},  {0.988022029, -0.154312968},
    {0.987784147, -0.155828401},  {0.987543941, -0.157343462},  {0.987301409, -0.158858150},
    {0.987056553, -0.160372451},  {0.986809373, -0.161886394},  {0.986559927, -0.163399950},
    {0.986308098, -0.164913118},  {0.986053944, -0.166425899},  {0.985797524, -0.167938292},
    {0.985538721, -0.169450298},  {0.985277653, -0.170961887},  {0.985014260, -0.172473088},
    {0.984748483, -0.173983872},  {0.984480441, -0.175494254},  {0.984210074, -0.177004218},
    {0.983937442, -0.178513765},  {0.983662426, -0.180022895},  {0.983385086, -0.181531608},
    {0.983105481, -0.183039889},  {0.982823551, -0.184547737},  {0.982539296, -0.186055154},
    {0.982252717, -0.187562123},  {0.981963873, -0.189068660},  {0.981672704, -0.190574750},
    {0.981379211, -0.192080393},  {0.981083393, -0.193585590},  {0.980785251, -0.195090324},
    {0.980484843, -0.196594596},  {0.980182111, -0.198098406},  {0.979877114, -0.199601755},
    {0.979569793, -0.201104641},  {0.979260147, -0.202607036},  {0.978948176, -0.204108968},
    {0.978633940, -0.205610409},  {0.978317380, -0.207111374},  {0.977998495, -0.208611846},
    {0.977677345, -0.210111842},  {0.977353871, -0.211611331},  {0.977028131, -0.213110313},
    {0.976700068, -0.214608818},  {0.976369739, -0.216106802},  {0.976037085, -0.217604280},
    {0.975702107, -0.219101235},  {0.975364864, -0.220597684},  {0.975025356, -0.222093627},
    {0.974683523, -0.223589033},  {0.974339366, -0.225083917},  {0.973992944, -0.226578265},
    {0.973644257, -0.228072077},  {0.973293245, -0.229565367},  {0.972939968, -0.231058106},
    {0.972584367, -0.232550308},  {0.972226501, -0.234041959},  {0.971866310, -0.235533059},
    {0.971503913, -0.237023607},  {0.971139133, -0.238513589},  {0.970772147, -0.240003020},
    {0.970402837, -0.241491884},  {0.970031261, -0.242980182},  {0.969657362, -0.244467899},
    {0.969281256, -0.245955050},  {0.968902826, -0.247441620},  {0.968522072, -0.248927608},
    {0.968139112, -0.250413001},  {0.967753828, -0.251897812},  {0.967366278, -0.253382027},
    {0.966976464, -0.254865646},  {0.966584384, -0.256348670},  {0.966189981, -0.257831097},
    {0.965793371, -0.259312928},  {0.965394437, -0.260794103},  {0.964993238, -0.262274712},
    {0.964589775, -0.263754666},  {0.964184046, -0.265234023},  {0.963776052, -0.266712755},
    {0.963365793, -0.268190861},  {0.962953269, -0.269668311},  {0.962538481, -0.271145165},
    {0.962121427, -0.272621363},  {0.961702049, -0.274096906},  {0.961280465, -0.275571823},
    {0.960856616, -0.277046084},  {0.960430503, -0.278519690},  {0.960002124, -0.279992640},
    {0.959571540, -0.281464934},  {0.959138632, -0.282936573},  {0.958703458, -0.284407526},
    {0.958266079, -0.285877824},  {0.957826436, -0.287347466},  {0.957384527, -0.288816422},
    {0.956940353, -0.290284663},  {0.956493914, -0.291752249},  {0.956045270, -0.293219149},
    {0.955594361, -0.294685364},  {0.955141187, -0.296150893},  {0.954685748, -0.297615707},
    {0.954228103, -0.299079835},  {0.953768194, -0.300543249},  {0.953306019, -0.302005947},
    {0.952841640, -0.303467959},  {0.952374995, -0.304929227},  {0.951906145, -0.306389809},
    {0.951435030, -0.307849646},  {0.950961649, -0.309308767},  {0.950486064, -0.310767144},
    {0.950008273, -0.312224805},  {0.949528158, -0.313681751},  {0.949045897, -0.315137923},
    {0.948561370, -0.316593379},  {0.948074579, -0.318048090},  {0.947585583, -0.319502026},
    {0.947094381, -0.320955247},  {0.946600914, -0.322407693},  {0.946105242, -0.323859364},
    {0.945607305, -0.325310290},  {0.945107222, -0.326760441},  {0.944604814, -0.328209847},
    {0.944100261, -0.329658449},  {0.943593442, -0.331106305},  {0.943084419, -0.332553357},
    {0.942573190, -0.333999664},  {0.942059755, -0.335445136},  {0.941544056, -0.336889863},
    {0.941026151, -0.338333756},  {0.940506041, -0.339776874},  {0.939983726, -0.341219217},
    {0.939459205, -0.342660725},  {0.938932478, -0.344101429},  {0.938403547, -0.345541328},
    {0.937872350, -0.346980423},  {0.937339008, -0.348418683},  {0.936803460, -0.349856138},
    {0.936265647, -0.351292759},  {0.935725689, -0.352728546},  {0.935183525, -0.354163527},
    {0.934639156, -0.355597675},  {0.934092522, -0.357030958},  {0.933543801, -0.358463407},
    {0.932992816, -0.359895051},  {0.932439625, -0.361325800},  {0.931884289, -0.362755716},
    {0.931326687, -0.364184797},  {0.930766940, -0.365612984},  {0.930205047, -0.367040336},
    {0.929640889, -0.368466824},  {0.929074585, -0.369892448},  {0.928506076, -0.371317208},
    {0.927935421, -0.372741073},  {0.927362502, -0.374164075},  {0.926787496, -0.375586182},
    {0.926210225, -0.377007425},  {0.925630808, -0.378427744},  {0.925049245, -0.379847199},
    {0.924465477, -0.381265759},  {0.923879504, -0.382683426},  {0.923291445, -0.384100199},
    {0.922701120, -0.385516047},  {0.922108650, -0.386931002},  {0.921514034, -0.388345033},
    {0.920917213, -0.389758170},  {0.920318305, -0.391170382},  {0.919717133, -0.392581671},
    {0.919113874, -0.393992037},  {0.918508410, -0.395401478},  {0.917900801, -0.396809995},
    {0.917290986, -0.398217559},  {0.916679084, -0.399624199},  {0.916064978, -0.401029885},
    {0.915448725, -0.402434647},  {0.914830327, -0.403838456},  {0.914209783, -0.405241311},
    {0.913587034, -0.406643212},  {0.912962198, -0.408044159},  {0.912335157, -0.409444153},
    {0.911706030, -0.410843164},  {0.911074758, -0.412241220},  {0.910441279, -0.413638324},
    {0.909805715, -0.415034413},  {0.909168005, -0.416429549},  {0.908528090, -0.417823702},
    {0.907886088, -0.419216901},  {0.907242000, -0.420609087},  {0.906595707, -0.422000259},
    {0.905947268, -0.423390478},  {0.905296743, -0.424779683},  {0.904644072, -0.426167876},
    {0.903989315, -0.427555084},  {0.903332353, -0.428941280},  {0.902673304, -0.430326492},
    {0.902012169, -0.431710660},  {0.901348829, -0.433093816},  {0.900683403, -0.434475958},
    {0.900015891, -0.435857087},  {0.899346232, -0.437237173},  {0.898674488, -0.438616246},
    {0.898000598, -0.439994276},  {0.897324562, -0.441371262},  {0.896646500, -0.442747235},
    {0.895966232, -0.444122136},  {0.895283937, -0.445496023},  {0.894599497, -0.446868837},
    {0.893912971, -0.448240608},  {0.893224299, -0.449611336},  {0.892533541, -0.450980991},
    {0.891840696, -0.452349573},  {0.891145766, -0.453717113},  {0.890448749, -0.455083579},
    {0.889749587, -0.456448972},  {0.889048338, -0.457813293},  {0.888345063, -0.459176540},
    {0.887639642, -0.460538715},  {0.886932135, -0.461899787},  {0.886222541, -0.463259786},
    {0.885510862, -0.464618683},  {0.884797096, -0.465976506},  {0.884081244, -0.467333198},
    {0.883363366, -0.468688816},  {0.882643342, -0.470043331},  {0.881921291, -0.471396744},
    {0.881197095, -0.472749025},  {0.880470872, -0.474100202},  {0.879742622, -0.475450277},
    {0.879012227, -0.476799220},  {0.878279805, -0.478147060},  {0.877545297, -0.479493767},
    {0.876808703, -0.480839342},  {0.876070082, -0.482183784},  {0.875329375, -0.483527064},
    {0.874586642, -0.484869242},  {0.873841822, -0.486210287},  {0.873094976, -0.487550169},
    {0.872346044, -0.488888890},  {0.871595085, -0.490226477},  {0.870842040, -0.491562903},
    {0.870086968, -0.492898196},  {0.869329870, -0.494232297},  {0.868570685, -0.495565265},
    {0.867809474, -0.496897042},  {0.867046237, -0.498227656},  {0.866280973, -0.499557108},
    {0.865513623, -0.500885367},  {0.864744246, -0.502212465},  {0.863972843, -0.503538370},
    {0.863199413, -0.504863083},  {0.862423956, -0.506186664},  {0.861646473, -0.507508993},
    {0.860866964, -0.508830130},  {0.860085368, -0.510150075},  {0.859301805, -0.511468828},
    {0.858516216, -0.512786388},  {0.857728601, -0.514102757},  {0.856938958, -0.515417874},
    {0.856147349, -0.516731799},  {0.855353653, -0.518044531},  {0.854557991, -0.519356012},
    {0.853760302, -0.520666242},  {0.852960587, -0.521975279},  {0.852158904, -0.523283124},
    {0.851355195, -0.524589658},  {0.850549459, -0.525895000},  {0.849741757, -0.527199149},
    {0.848932028, -0.528501987},  {0.848120332, -0.529803634},  {0.847306609, -0.531104028},
    {0.846490920, -0.532403111},  {0.845673263, -0.533701003},  {0.844853580, -0.534997642},
    {0.844031870, -0.536292970},  {0.843208253, -0.537587047},  {0.842382610, -0.538879931},
    {0.841554999, -0.540171444},  {0.840725362, -0.541461766},  {0.839893818, -0.542750776},
    {0.839060247, -0.544038534},  {0.838224709, -0.545324981},  {0.837387204, -0.546610177},
    {0.836547732, -0.547894061},  {0.835706294, -0.549176633},  {0.834862888, -0.550457954},
    {0.834017515, -0.551737964},  {0.833170176, -0.553016722},  {0.832320869, -0.554294109},
    {0.831469595, -0.555570245},  {0.830616415, -0.556845009},  {0.829761207, -0.558118522},
    {0.828904092, -0.559390724},  {0.828045070, -0.560661554},  {0.827184021, -0.561931133},
    {0.826321065, -0.563199341},  {0.825456142, -0.564466238},  {0.824589312, -0.565731823},
    {0.823720515, -0.566996038},  {0.822849810, -0.568258941},  {0.821977139, -0.569520533},
    {0.821102500, -0.570780754},  {0.820225954, -0.572039604},  {0.819347501, -0.573297143},
    {0.818467140, -0.574553370},  {0.817584813, -0.575808167},  {0.816700578, -0.577061653},
    {0.815814435, -0.578313768},  {0.814926326, -0.579564571},  {0.814036310, -0.580813944},
    {0.813144386, -0.582062006},  {0.812250614, -0.583308637},  {0.811354876, -0.584553957},
    {0.810457170, -0.585797846},  {0.809557617, -0.587040365},  {0.808656156, -0.588281572},
    {0.807752848, -0.589521289},  {0.806847572, -0.590759695},  {0.805940390, -0.591996670},
    {0.805031359, -0.593232274},  {0.804120362, -0.594466507},  {0.803207517, -0.595699310},
    {0.802292824, -0.596930683},  {0.801376164, -0.598160684},  {0.800457656, -0.599389315},
    {0.799537241, -0.600616455},  {0.798614979, -0.601842225},  {0.797690868, -0.603066623},
    {0.796764791, -0.604289532},  {0.795836926, -0.605511069},  {0.794907153, -0.606731117},
    {0.793975472, -0.607949793},  {0.793041945, -0.609167039},  {0.792106569, -0.610382795},
    {0.791169345, -0.611597180},  {0.790230215, -0.612810075},  {0.789289236, -0.614021540},
    {0.788346410, -0.615231574},  {0.787401736, -0.616440177},  {0.786455214, -0.617647290},
    {0.785506845, -0.618852973},  {0.784556568, -0.620057225},  {0.783604503, -0.621259987},
    {0.782650590, -0.622461259},  {0.781694829, -0.623661101},  {0.780737221, -0.624859512},
    {0.779777765, -0.626056373},  {0.778816521, -0.627251804},  {0.777853429, -0.628445745},
    {0.776888490, -0.629638255},  {0.775921702, -0.630829215},  {0.774953127, -0.632018745},
    {0.773982704, -0.633206785},  {0.773010433, -0.634393275},  {0.772036374, -0.635578334},
    {0.771060526, -0.636761844},  {0.770082831, -0.637943923},  {0.769103348, -0.639124453},
    {0.768122017, -0.640303493},  {0.767138898, -0.641481042},  {0.766153991, -0.642657042},
    {0.765167236, -0.643831551},  {0.764178753, -0.645004511},  {0.763188422, -0.646176040},
    {0.762196302, -0.647345960},  {0.761202395, -0.648514390},  {0.760206699, -0.649681330},
    {0.759209216, -0.650846660},  {0.758209884, -0.652010560},  {0.757208824, -0.653172851},
    {0.756205976, -0.654333591},  {0.755201399, -0.655492842},  {0.754194975, -0.656650543},
    {0.753186822, -0.657806695},  {0.752176821, -0.658961296},  {0.751165152, -0.660114348},
    {0.750151634, -0.661265850},  {0.749136388, -0.662415802},  {0.748119354, -0.663564146},
    {0.747100592, -0.664710999},  {0.746080101, -0.665856242},  {0.745057762, -0.666999936},
    {0.744033754, -0.668142021},  {0.743007958, -0.669282615},  {0.741980433, -0.670421541},
    {0.740951121, -0.671558976},  {0.739920080, -0.672694743},  {0.738887310, -0.673829019},
    {0.737852812, -0.674961627},  {0.736816585, -0.676092684},  {0.735778570, -0.677222192},
    {0.734738886, -0.678350031},  {0.733697414, -0.679476321},  {0.732654274, -0.680601001},
    {0.731609404, -0.681724072},  {0.730562747, -0.682845533},  {0.729514420, -0.683965385},
    {0.728464365, -0.685083687},  {0.727412641, -0.686200321},  {0.726359129, -0.687315345},
    {0.725303948, -0.688428760},  {0.724247098, -0.689540565},  {0.723188460, -0.690650702},
    {0.722128212, -0.691759229},  {0.721066177, -0.692866147},  {0.720002532, -0.693971455},
    {0.718937099, -0.695075095},  {0.717870057, -0.696177125},  {0.716801286, -0.697277486},
    {0.715730846, -0.698376238},  {0.714658678, -0.699473321},  {0.713584840, -0.700568795},
    {0.712509394, -0.701662600},  {0.711432219, -0.702754736},  {0.710353374, -0.703845263},
    {0.709272802, -0.704934061},  {0.708190620, -0.706021249},  {0.707106769, -0.707106769},
    {0.706021249, -0.708190620},  {0.704934061, -0.709272802},  {0.703845263, -0.710353374},
    {0.702754736, -0.711432219},  {0.701662600, -0.712509394},  {0.700568795, -0.713584840},
    {0.699473321, -0.714658678},  {0.698376238, -0.715730846},  {0.697277486, -0.716801286},
    {0.696177125, -0.717870057},  {0.695075095, -0.718937099},  {0.693971455, -0.720002532},
    {0.692866147, -0.721066177},  {0.691759229, -0.722128212},  {0.690650702, -0.723188460},
    {0.689540565, -0.724247098},  {0.688428760, -0.725303948},  {0.687315345, -0.726359129},
    {0.686200321, -0.727412641},  {0.685083687, -0.728464365},  {0.683965385, -0.729514420},
    {0.682845533, -0.730562747},  {0.681724072, -0.731609404},  {0.680601001, -0.732654274},
    {0.679476321, -0.733697414},  {0.678350031, -0.734738886},  {0.677222192, -0.735778570},
    {0.676092684, -0.736816585},  {0.674961627, -0.737852812},  {0.673829019, -0.738887310},
    {0.672694743, -0.739920080},  {0.671558976, -0.740951121},  {0.670421541, -0.741980433},
    {0.669282615, -0.743007958},  {0.668142021, -0.744033754},  {0.666999936, -0.745057762},
    {0.665856242, -0.746080101},  {0.664710999, -0.747100592},  {0.663564146, -0.748119354},
    {0.662415802, -0.749136388},  {0.661265850, -0.750151634},  {0.660114348, -0.751165152},
    {0.658961296, -0.752176821},  {0.657806695, -0.753186822},  {0.656650543, -0.754194975},
    {0.655492842, -0.755201399},  {0.654333591, -0.756205976},  {0.653172851, -0.757208824},
    {0.652010560, -0.758209884},  {0.650846660, -0.759209216},  {0.649681330, -0.760206699},
    {0.648514390, -0.761202395},  {0.647345960, -0.762196302},  {0.646176040, -0.763188422},
    {0.645004511, -0.764178753},  {0.643831551, -0.765167236},  {0.642657042, -0.766153991},
    {0.641481042, -0.767138898},  {0.640303493, -0.768122017},  {0.639124453, -0.769103348},
    {0.637943923, -0.770082831},  {0.636761844, -0.771060526},  {0.635578334, -0.772036374},
    {0.634393275, -0.773010433},  {0.633206785, -0.773982704},  {0.632018745, -0.774953127},
    {0.630829215, -0.775921702},  {0.629638255, -0.776888490},  {0.628445745, -0.777853429},
    {0.627251804, -0.778816521},  {0.626056373, -0.779777765},  {0.624859512, -0.780737221},
    {0.623661101, -0.781694829},  {0.622461259, -0.782650590},  {0.621259987, -0.783604503},
    {0.620057225, -0.784556568},  {0.618852973, -0.785506845},  {0.617647290, -0.786455214},
    {0.616440177, -0.787401736},  {0.615231574, -0.788346410},  {0.614021540, -0.789289236},
    {0.612810075, -0.790230215},  {0.611597180, -0.791169345},  {0.610382795, -0.792106569},
    {0.609167039, -0.793041945},  {0.607949793, -0.793975472},  {0.606731117, -0.794907153},
    {0.605511069, -0.795836926},  {0.604289532, -0.796764791},  {0.603066623, -0.797690868},
    {0.601842225, -0.798614979},  {0.600616455, -0.799537241},  {0.599389315, -0.800457656},
    {0.598160684, -0.801376164},  {0.596930683, -0.802292824},  {0.595699310, -0.803207517},
    {0.594466507, -0.804120362},  {0.593232274, -0.805031359},  {0.591996670, -0.805940390},
    {0.590759695, -0.806847572},  {0.589521289, -0.807752848},  {0.588281572, -0.808656156},
    {0.587040365, -0.809557617},  {0.585797846, -0.810457170},  {0.584553957, -0.811354876},
    {0.583308637, -0.812250614},  {0.582062006, -0.813144386},  {0.580813944, -0.814036310},
    {0.579564571, -0.814926326},  {0.578313768, -0.815814435},  {0.577061653, -0.816700578},
    {0.575808167, -0.817584813},  {0.574553370, -0.818467140},  {0.573297143, -0.819347501},
    {0.572039604, -0.820225954},  {0.570780754, -0.821102500},  {0.569520533, -0.821977139},
    {0.568258941, -0.822849810},  {0.566996038, -0.823720515},  {0.565731823, -0.824589312},
    {0.564466238, -0.825456142},  {0.563199341, -0.826321065},  {0.561931133, -0.827184021},
    {0.560661554, -0.828045070},  {0.559390724, -0.828904092},  {0.558118522, -0.829761207},
    {0.556845009, -0.830616415},  {0.555570245, -0.831469595},  {0.554294109, -0.832320869},
    {0.553016722, -0.833170176},  {0.551737964, -0.834017515},  {0.550457954, -0.834862888},
    {0.549176633, -0.835706294},  {0.547894061, -0.836547732},  {0.546610177, -0.837387204},
    {0.545324981, -0.838224709},  {0.544038534, -0.839060247},  {0.542750776, -0.839893818},
    {0.541461766, -0.840725362},  {0.540171444, -0.841554999},  {0.538879931, -0.842382610},
    {0.537587047, -0.843208253},  {0.536292970, -0.844031870},  {0.534997642, -0.844853580},
    {0.533701003, -0.845673263},  {0.532403111, -0.846490920},  {0.531104028, -0.847306609},
    {0.529803634, -0.848120332},  {0.528501987, -0.848932028},  {0.527199149, -0.849741757},
    {0.525895000, -0.850549459},  {0.524589658, -0.851355195},  {0.523283124, -0.852158904},
    {0.521975279, -0.852960587},  {0.520666242, -0.853760302},  {0.519356012, -0.854557991},
    {0.518044531, -0.855353653},  {0.516731799, -0.856147349},  {0.515417874, -0.856938958},
    {0.514102757, -0.857728601},  {0.512786388, -0.858516216},  {0.511468828, -0.859301805},
    {0.510150075, -0.860085368},  {0.508830130, -0.860866964},  {0.507508993, -0.861646473},
    {0.506186664, -0.862423956},  {0.504863083, -0.863199413},  {0.503538370, -0.863972843},
    {0.502212465, -0.864744246},  {0.500885367, -0.865513623},  {0.499557108, -0.866280973},
    {0.498227656, -0.867046237},  {0.496897042, -0.867809474},  {0.495565265, -0.868570685},
    {0.494232297, -0.869329870},  {0.492898196, -0.870086968},  {0.491562903, -0.870842040},
    {0.490226477, -0.871595085},  {0.488888890, -0.872346044},  {0.487550169, -0.873094976},
    {0.486210287, -0.873841822},  {0.484869242, -0.874586642},  {0.483527064, -0.875329375},
    {0.482183784, -0.876070082},  {0.480839342, -0.876808703},  {0.479493767, -0.877545297},
    {0.478147060, -0.878279805},  {0.476799220, -0.879012227},  {0.475450277, -0.879742622},
    {0.474100202, -0.880470872},  {0.472749025, -0.881197095},  {0.471396744, -0.881921291},
    {0.470043331, -0.882643342},  {0.468688816, -0.883363366},  {0.467333198, -0.884081244},
    {0.465976506, -0.884797096},  {0.464618683, -0.885510862},  {0.463259786, -0.886222541},
    {0.461899787, -0.886932135},  {0.460538715, -0.887639642},  {0.459176540, -0.888345063},
    {0.457813293, -0.889048338},  {0.456448972, -0.889749587},  {0.455083579, -0.890448749},
    {0.453717113, -0.891145766},  {0.452349573, -0.891840696},  {0.450980991, -0.892533541},
    {0.449611336, -0.893224299},  {0.448240608, -0.893912971},  {0.446868837, -0.894599497},
    {0.445496023, -0.895283937},  {0.444122136, -0.895966232},  {0.442747235, -0.896646500},
    {0.441371262, -0.897324562},  {0.439994276, -0.898000598},  {0.438616246, -0.898674488},
    {0.437237173, -0.899346232},  {0.435857087, -0.900015891},  {0.434475958, -0.900683403},
    {0.433093816, -0.901348829},  {0.431710660, -0.902012169},  {0.430326492, -0.902673304},
    {0.428941280, -0.903332353},  {0.427555084, -0.903989315},  {0.426167876, -0.904644072},
    {0.424779683, -0.905296743},  {0.423390478, -0.905947268},  {0.422000259, -0.906595707},
    {0.420609087, -0.907242000},  {0.419216901, -0.907886088},  {0.417823702, -0.908528090},
    {0.416429549, -0.909168005},  {0.415034413, -0.909805715},  {0.413638324, -0.910441279},
    {0.412241220, -0.911074758},  {0.410843164, -0.911706030},  {0.409444153, -0.912335157},
    {0.408044159, -0.912962198},  {0.406643212, -0.913587034},  {0.405241311, -0.914209783},
    {0.403838456, -0.914830327},  {0.402434647, -0.915448725},  {0.401029885, -0.916064978},
    {0.399624199, -0.916679084},  {0.398217559, -0.917290986},  {0.396809995, -0.917900801},
    {0.395401478, -0.918508410},  {0.393992037, -0.919113874},  {0.392581671, -0.919717133},
    {0.391170382, -0.920318305},  {0.389758170, -0.920917213},  {0.388345033, -0.921514034},
    {0.386931002, -0.922108650},  {0.385516047, -0.922701120},  {0.384100199, -0.923291445},
    {0.382683426, -0.923879504},  {0.381265759, -0.924465477},  {0.379847199, -0.925049245},
    {0.378427744, -0.925630808},  {0.377007425, -0.926210225},  {0.375586182, -0.926787496},
    {0.374164075, -0.927362502},  {0.372741073, -0.927935421},  {0.371317208, -0.928506076},
    {0.369892448, -0.929074585},  {0.368466824, -0.929640889},  {0.367040336, -0.930205047},
    {0.365612984, -0.930766940},  {0.364184797, -0.931326687},  {0.362755716, -0.931884289},
    {0.361325800, -0.932439625},  {0.359895051, -0.932992816},  {0.358463407, -0.933543801},
    {0.357030958, -0.934092522},  {0.355597675, -0.934639156},  {0.354163527, -0.935183525},
    {0.352728546, -0.935725689},  {0.351292759, -0.936265647},  {0.349856138, -0.936803460},
    {0.348418683, -0.937339008},  {0.346980423, -0.937872350},  {0.345541328, -0.938403547},
    {0.344101429, -0.938932478},  {0.342660725, -0.939459205},  {0.341219217, -0.939983726},
    {0.339776874, -0.940506041},  {0.338333756, -0.941026151},  {0.336889863, -0.941544056},
    {0.335445136, -0.942059755},  {0.333999664, -0.942573190},  {0.332553357, -0.943084419},
    {0.331106305, -0.943593442},  {0.329658449, -0.944100261},  {0.328209847, -0.944604814},
    {0.326760441, -0.945107222},  {0.325310290, -0.945607305},  {0.323859364, -0.946105242},
    {0.322407693, -0.946600914},  {0.320955247, -0.947094381},  {0.319502026, -0.947585583},
    {0.318048090, -0.948074579},  {0.316593379, -0.948561370},  {0.315137923, -0.949045897},
    {0.313681751, -0.949528158},  {0.312224805, -0.950008273},  {0.310767144, -0.950486064},
    {0.309308767, -0.950961649},  {0.307849646, -0.951435030},  {0.306389809, -0.951906145},
    {0.304929227, -0.952374995},  {0.303467959, -0.952841640},  {0.302005947, -0.953306019},
    {0.300543249, -0.953768194},  {0.299079835, -0.954228103},  {0.297615707, -0.954685748},
    {0.296150893, -0.955141187},  {0.294685364, -0.955594361},  {0.293219149, -0.956045270},
    {0.291752249, -0.956493914},  {0.290284663, -0.956940353},  {0.288816422, -0.957384527},
    {0.287347466, -0.957826436},  {0.285877824, -0.958266079},  {0.284407526, -0.958703458},
    {0.282936573, -0.959138632},  {0.281464934, -0.959571540},  {0.279992640, -0.960002124},
    {0.278519690, -0.960430503},  {0.277046084, -0.960856616},  {0.275571823, -0.961280465},
    {0.274096906, -0.961702049},  {0.272621363, -0.962121427},  {0.271145165, -0.962538481},
    {0.269668311, -0.962953269},  {0.268190861, -0.963365793},  {0.266712755, -0.963776052},
    {0.265234023, -0.964184046},  {0.263754666, -0.964589775},  {0.262274712, -0.964993238},
    {0.260794103, -0.965394437},  {0.259312928, -0.965793371},  {0.257831097, -0.966189981},
    {0.256348670, -0.966584384},  {0.254865646, -0.966976464},  {0.253382027, -0.967366278},
    {0.251897812, -0.967753828},  {0.250413001, -0.968139112},  {0.248927608, -0.968522072},
    {0.247441620, -0.968902826},  {0.245955050, -0.969281256},  {0.244467899, -0.969657362},
    {0.242980182, -0.970031261},  {0.241491884, -0.970402837},  {0.240003020, -0.970772147},
    {0.238513589, -0.971139133},  {0.237023607, -0.971503913},  {0.235533059, -0.971866310},
    {0.234041959, -0.972226501},  {0.232550308, -0.972584367},  {0.231058106, -0.972939968},
    {0.229565367, -0.973293245},  {0.228072077, -0.973644257},  {0.226578265, -0.973992944},
    {0.225083917, -0.974339366},  {0.223589033, -0.974683523},  {0.222093627, -0.975025356},
    {0.220597684, -0.975364864},  {0.219101235, -0.975702107},  {0.217604280, -0.976037085},
    {0.216106802, -0.976369739},  {0.214608818, -0.976700068},  {0.213110313, -0.977028131},
    {0.211611331, -0.977353871},  {0.210111842, -0.977677345},  {0.208611846, -0.977998495},
    {0.207111374, -0.978317380},  {0.205610409, -0.978633940},  {0.204108968, -0.978948176},
    {0.202607036, -0.979260147},  {0.201104641, -0.979569793},  {0.199601755, -0.979877114},
    {0.198098406, -0.980182111},  {0.196594596, -0.980484843},  {0.195090324, -0.980785251},
    {0.193585590, -0.981083393},  {0.192080393, -0.981379211},  {0.190574750, -0.981672704},
    {0.189068660, -0.981963873},  {0.187562123, -0.982252717},  {0.186055154, -0.982539296},
    {0.184547737, -0.982823551},  {0.183039889, -0.983105481},  {0.181531608, -0.983385086},
    {0.180022895, -0.983662426},  {0.178513765, -0.983937442},  {0.177004218, -0.984210074},
    {0.175494254, -0.984480441},  {0.173983872, -0.984748483},  {0.172473088, -0.985014260},
    {0.170961887, -0.985277653},  {0.169450298, -0.985538721},  {0.167938292, -0.985797524},
    {0.166425899, -0.986053944},  {0.164913118, -0.986308098},  {0.163399950, -0.986559927},
    {0.161886394, -0.986809373},  {0.160372451, -0.987056553},  {0.158858150, -0.987301409},
    {0.157343462, -0.987543941},  {0.155828401, -0.987784147},  {0.154312968, -0.988022029},
    {0.152797192, -0.988257587},  {0.151281044, -0.988490820},  {0.149764538, -0.988721669},
    {0.148247674, -0.988950253},  {0.146730468, -0.989176512},  {0.145212919, -0.989400446},
    {0.143695027, -0.989621997},  {0.142176807, -0.989841282},  {0.140658244, -0.990058184},
    {0.139139339, -0.990272820},  {0.137620121, -0.990485072},  {0.136100575, -0.990695000},
    {0.134580702, -0.990902662},  {0.133060530, -0.991107941},  {0.131540030, -0.991310835},
    {0.130019218, -0.991511464},  {0.128498107, -0.991709769},  {0.126976699, -0.991905689},
    {0.125454977, -0.992099285},  {0.123932973, -0.992290616},  {0.122410677, -0.992479563},
    {0.120888084, -0.992666125},  {0.119365215, -0.992850423},  {0.117842063, -0.993032336},
    {0.116318628, -0.993211925},  {0.114794925, -0.993389189},  {0.113270953, -0.993564129},
    {0.111746714, -0.993736744},  {0.110222206, -0.993906975},  {0.108697444, -0.994074881},
    {0.107172422, -0.994240463},  {0.105647154, -0.994403660},  {0.104121633, -0.994564593},
    {0.102595866, -0.994723141},  {0.101069860, -0.994879305},  {0.099543616, -0.995033205},
    {0.098017141, -0.995184720},  {0.096490428, -0.995333910},  {0.094963498, -0.995480776},
    {0.093436338, -0.995625257},  {0.091908954, -0.995767415},  {0.090381362, -0.995907247},
    {0.088853553, -0.996044695},  {0.087325536, -0.996179819},  {0.085797310, -0.996312618},
    {0.084268890, -0.996443033},  {0.082740262, -0.996571124},  {0.081211448, -0.996696889},
    {0.079682440, -0.996820271},  {0.078153245, -0.996941328},  {0.076623864, -0.997060061},
    {0.075094298, -0.997176409},  {0.073564567, -0.997290432},  {0.072034650, -0.997402132},
    {0.070504576, -0.997511446},  {0.068974331, -0.997618437},  {0.067443922, -0.997723043},
    {0.065913349, -0.997825325},  {0.064382628, -0.997925282},  {0.062851757, -0.998022854},
    {0.061320737, -0.998118103},  {0.059789572, -0.998211026},  {0.058258265, -0.998301566},
    {0.056726821, -0.998389721},  {0.055195246, -0.998475552},  {0.053663537, -0.998559058},
    {0.052131705, -0.998640239},  {0.050599750, -0.998719037},  {0.049067676, -0.998795450},
    {0.047535483, -0.998869538},  {0.046003181, -0.998941302},  {0.044470772, -0.999010682},
    {0.042938258, -0.999077737},  {0.041405641, -0.999142408},  {0.039872926, -0.999204755},
    {0.038340122, -0.999264777},  {0.036807224, -0.999322355},  {0.035274237, -0.999377668},
    {0.033741172, -0.999430597},  {0.032208025, -0.999481201},  {0.030674804, -0.999529421},
    {0.029141508, -0.999575317},  {0.027608145, -0.999618828},  {0.026074719, -0.999660015},
    {0.024541229, -0.999698818},  {0.023007682, -0.999735296},  {0.021474080, -0.999769390},
    {0.019940428, -0.999801159},  {0.018406730, -0.999830604},  {0.016872987, -0.999857664},
    {0.015339206, -0.999882340},  {0.013805388, -0.999904692},  {0.012271538, -0.999924719},
    {0.010737659, -0.999942362},  {0.009203754, -0.999957621},  {0.007669829, -0.999970615},
    {0.006135885, -0.999981165},  {0.004601926, -0.999989390},  {0.003067957, -0.999995291},
    {0.001533980, -0.999998808},  {0.000000000, -1.000000000},  {-0.001533980, -0.999998808},
    {-0.003067957, -0.999995291}, {-0.004601926, -0.999989390}, {-0.006135885, -0.999981165},
    {-0.007669829, -0.999970615}, {-0.009203754, -0.999957621}, {-0.010737659, -0.999942362},
    {-0.012271538, -0.999924719}, {-0.013805388, -0.999904692}, {-0.015339206, -0.999882340},
    {-0.016872987, -0.999857664}, {-0.018406730, -0.999830604}, {-0.019940428, -0.999801159},
    {-0.021474080, -0.999769390}, {-0.023007682, -0.999735296}, {-0.024541229, -0.999698818},
    {-0.026074719, -0.999660015}, {-0.027608145, -0.999618828}, {-0.029141508, -0.999575317},
    {-0.030674804, -0.999529421}, {-0.032208025, -0.999481201}, {-0.033741172, -0.999430597},
    {-0.035274237, -0.999377668}, {-0.036807224, -0.999322355}, {-0.038340122, -0.999264777},
    {-0.039872926, -0.999204755}, {-0.041405641, -0.999142408}, {-0.042938258, -0.999077737},
    {-0.044470772, -0.999010682}, {-0.046003181, -0.998941302}, {-0.047535483, -0.998869538},
    {-0.049067676, -0.998795450}, {-0.050599750, -0.998719037}, {-0.052131705, -0.998640239},
    {-0.053663537, -0.998559058}, {-0.055195246, -0.998475552}, {-0.056726821, -0.998389721},
    {-0.058258265, -0.998301566}, {-0.059789572, -0.998211026}, {-0.061320737, -0.998118103},
    {-0.062851757, -0.998022854}, {-0.064382628, -0.997925282}, {-0.065913349, -0.997825325},
    {-0.067443922, -0.997723043}, {-0.068974331, -0.997618437}, {-0.070504576, -0.997511446},
    {-0.072034650, -0.997402132}, {-0.073564567, -0.997290432}, {-0.075094298, -0.997176409},
    {-0.076623864, -0.997060061}, {-0.078153245, -0.996941328}, {-0.079682440, -0.996820271},
    {-0.081211448, -0.996696889}, {-0.082740262, -0.996571124}, {-0.084268890, -0.996443033},
    {-0.085797310, -0.996312618}, {-0.087325536, -0.996179819}, {-0.088853553, -0.996044695},
    {-0.090381362, -0.995907247}, {-0.091908954, -0.995767415}, {-0.093436338, -0.995625257},
    {-0.094963498, -0.995480776}, {-0.096490428, -0.995333910}, {-0.098017141, -0.995184720},
    {-0.099543616, -0.995033205}, {-0.101069860, -0.994879305}, {-0.102595866, -0.994723141},
    {-0.104121633, -0.994564593}, {-0.105647154, -0.994403660}, {-0.107172422, -0.994240463},
    {-0.108697444, -0.994074881}, {-0.110222206, -0.993906975}, {-0.111746714, -0.993736744},
    {-0.113270953, -0.993564129}, {-0.114794925, -0.993389189}, {-0.116318628, -0.993211925},
    {-0.117842063, -0.993032336}, {-0.119365215, -0.992850423}, {-0.120888084, -0.992666125},
    {-0.122410677, -0.992479563}, {-0.123932973, -0.992290616}, {-0.125454977, -0.992099285},
    {-0.126976699, -0.991905689}, {-0.128498107, -0.991709769}, {-0.130019218, -0.991511464},
    {-0.131540030, -0.991310835}, {-0.133060530, -0.991107941}, {-0.134580702, -0.990902662},
    {-0.136100575, -0.990695000}, {-0.137620121, -0.990485072}, {-0.139139339, -0.990272820},
    {-0.140658244, -0.990058184}, {-0.142176807, -0.989841282}, {-0.143695027, -0.989621997},
    {-0.145212919, -0.989400446}, {-0.146730468, -0.989176512}, {-0.148247674, -0.988950253},
    {-0.149764538, -0.988721669}, {-0.151281044, -0.988490820}, {-0.152797192, -0.988257587},
    {-0.154312968, -0.988022029}, {-0.155828401, -0.987784147}, {-0.157343462, -0.987543941},
    {-0.158858150, -0.987301409}, {-0.160372451, -0.987056553}, {-0.161886394, -0.986809373},
    {-0.163399950, -0.986559927}, {-0.164913118, -0.986308098}, {-0.166425899, -0.986053944},
    {-0.167938292, -0.985797524}, {-0.169450298, -0.985538721}, {-0.170961887, -0.985277653},
    {-0.172473088, -0.985014260}, {-0.173983872, -0.984748483}, {-0.175494254, -0.984480441},
    {-0.177004218, -0.984210074}, {-0.178513765, -0.983937442}, {-0.180022895, -0.983662426},
    {-0.181531608, -0.983385086}, {-0.183039889, -0.983105481}, {-0.184547737, -0.982823551},
    {-0.186055154, -0.982539296}, {-0.187562123, -0.982252717}, {-0.189068660, -0.981963873},
    {-0.190574750, -0.981672704}, {-0.192080393, -0.981379211}, {-0.193585590, -0.981083393},
    {-0.195090324, -0.980785251}, {-0.196594596, -0.980484843}, {-0.198098406, -0.980182111},
    {-0.199601755, -0.979877114}, {-0.201104641, -0.979569793}, {-0.202607036, -0.979260147},
    {-0.204108968, -0.978948176}, {-0.205610409, -0.978633940}, {-0.207111374, -0.978317380},
    {-0.208611846, -0.977998495}, {-0.210111842, -0.977677345}, {-0.211611331, -0.977353871},
    {-0.213110313, -0.977028131}, {-0.214608818, -0.976700068}, {-0.216106802, -0.976369739},
    {-0.217604280, -0.976037085}, {-0.219101235, -0.975702107}, {-0.220597684, -0.975364864},
    {-0.222093627, -0.975025356}, {-0.223589033, -0.974683523}, {-0.225083917, -0.974339366},
    {-0.226578265, -0.973992944}, {-0.228072077, -0.973644257}, {-0.229565367, -0.973293245},
    {-0.231058106, -0.972939968}, {-0.232550308, -0.972584367}, {-0.234041959, -0.972226501},
    {-0.235533059, -0.971866310}, {-0.237023607, -0.971503913}, {-0.238513589, -0.971139133},
    {-0.240003020, -0.970772147}, {-0.241491884, -0.970402837}, {-0.242980182, -0.970031261},
    {-0.244467899, -0.969657362}, {-0.245955050, -0.969281256}, {-0.247441620, -0.968902826},
    {-0.248927608, -0.968522072}, {-0.250413001, -0.968139112}, {-0.251897812, -0.967753828},
    {-0.253382027, -0.967366278}, {-0.254865646, -0.966976464}, {-0.256348670, -0.966584384},
    {-0.257831097, -0.966189981}, {-0.259312928, -0.965793371}, {-0.260794103, -0.965394437},
    {-0.262274712, -0.964993238}, {-0.263754666, -0.964589775}, {-0.265234023, -0.964184046},
    {-0.266712755, -0.963776052}, {-0.268190861, -0.963365793}, {-0.269668311, -0.962953269},
    {-0.271145165, -0.962538481}, {-0.272621363, -0.962121427}, {-0.274096906, -0.961702049},
    {-0.275571823, -0.961280465}, {-0.277046084, -0.960856616}, {-0.278519690, -0.960430503},
    {-0.279992640, -0.960002124}, {-0.281464934, -0.959571540}, {-0.282936573, -0.959138632},
    {-0.284407526, -0.958703458}, {-0.285877824, -0.958266079}, {-0.287347466, -0.957826436},
    {-0.288816422, -0.957384527}, {-0.290284663, -0.956940353}, {-0.291752249, -0.956493914},
    {-0.293219149, -0.956045270}, {-0.294685364, -0.955594361}, {-0.296150893, -0.955141187},
    {-0.297615707, -0.954685748}, {-0.299079835, -0.954228103}, {-0.300543249, -0.953768194},
    {-0.302005947, -0.953306019}, {-0.303467959, -0.952841640}, {-0.304929227, -0.952374995},
    {-0.306389809, -0.951906145}, {-0.307849646, -0.951435030}, {-0.309308767, -0.950961649},
    {-0.310767144, -0.950486064}, {-0.312224805, -0.950008273}, {-0.313681751, -0.949528158},
    {-0.315137923, -0.949045897}, {-0.316593379, -0.948561370}, {-0.318048090, -0.948074579},
    {-0.319502026, -0.947585583}, {-0.320955247, -0.947094381}, {-0.322407693, -0.946600914},
    {-0.323859364, -0.946105242}, {-0.325310290, -0.945607305}, {-0.326760441, -0.945107222},
    {-0.328209847, -0.944604814}, {-0.329658449, -0.944100261}, {-0.331106305, -0.943593442},
    {-0.332553357, -0.943084419}, {-0.333999664, -0.942573190}, {-0.335445136, -0.942059755},
    {-0.336889863, -0.941544056}, {-0.338333756, -0.941026151}, {-0.339776874, -0.940506041},
    {-0.341219217, -0.939983726}, {-0.342660725, -0.939459205}, {-0.344101429, -0.938932478},
    {-0.345541328, -0.938403547}, {-0.346980423, -0.937872350}, {-0.348418683, -0.937339008},
    {-0.349856138, -0.936803460}, {-0.351292759, -0.936265647}, {-0.352728546, -0.935725689},
    {-0.354163527, -0.935183525}, {-0.355597675, -0.934639156}, {-0.357030958, -0.934092522},
    {-0.358463407, -0.933543801}, {-0.359895051, -0.932992816}, {-0.361325800, -0.932439625},
    {-0.362755716, -0.931884289}, {-0.364184797, -0.931326687}, {-0.365612984, -0.930766940},
    {-0.367040336, -0.930205047}, {-0.368466824, -0.929640889}, {-0.369892448, -0.929074585},
    {-0.371317208, -0.928506076}, {-0.372741073, -0.927935421}, {-0.374164075, -0.927362502},
    {-0.375586182, -0.926787496}, {-0.377007425, -0.926210225}, {-0.378427744, -0.925630808},
    {-0.379847199, -0.925049245}, {-0.381265759, -0.924465477}, {-0.382683426, -0.923879504},
    {-0.384100199, -0.923291445}, {-0.385516047, -0.922701120}, {-0.386931002, -0.922108650},
    {-0.388345033, -0.921514034}, {-0.389758170, -0.920917213}, {-0.391170382, -0.920318305},
    {-0.392581671, -0.919717133}, {-0.393992037, -0.919113874}, {-0.395401478, -0.918508410},
    {-0.396809995, -0.917900801}, {-0.398217559, -0.917290986}, {-0.399624199, -0.916679084},
    {-0.401029885, -0.916064978}, {-0.402434647, -0.915448725}, {-0.403838456, -0.914830327},
    {-0.405241311, -0.914209783}, {-0.406643212, -0.913587034}, {-0.408044159, -0.912962198},
    {-0.409444153, -0.912335157}, {-0.410843164, -0.911706030}, {-0.412241220, -0.911074758},
    {-0.413638324, -0.910441279}, {-0.415034413, -0.909805715}, {-0.416429549, -0.909168005},
    {-0.417823702, -0.908528090}, {-0.419216901, -0.907886088}, {-0.420609087, -0.907242000},
    {-0.422000259, -0.906595707}, {-0.423390478, -0.905947268}, {-0.424779683, -0.905296743},
    {-0.426167876, -0.904644072}, {-0.427555084, -0.903989315}, {-0.428941280, -0.903332353},
    {-0.430326492, -0.902673304}, {-0.431710660, -0.902012169}, {-0.433093816, -0.901348829},
    {-0.434475958, -0.900683403}, {-0.435857087, -0.900015891}, {-0.437237173, -0.899346232},
    {-0.438616246, -0.898674488}, {-0.439994276, -0.898000598}, {-0.441371262, -0.897324562},
    {-0.442747235, -0.896646500}, {-0.444122136, -0.895966232}, {-0.445496023, -0.895283937},
    {-0.446868837, -0.894599497}, {-0.448240608, -0.893912971}, {-0.449611336, -0.893224299},
    {-0.450980991, -0.892533541}, {-0.452349573, -0.891840696}, {-0.453717113, -0.891145766},
    {-0.455083579, -0.890448749}, {-0.456448972, -0.889749587}, {-0.457813293, -0.889048338},
    {-0.459176540, -0.888345063}, {-0.460538715, -0.887639642}, {-0.461899787, -0.886932135},
    {-0.463259786, -0.886222541}, {-0.464618683, -0.885510862}, {-0.465976506, -0.884797096},
    {-0.467333198, -0.884081244}, {-0.468688816, -0.883363366}, {-0.470043331, -0.882643342},
    {-0.471396744, -0.881921291}, {-0.472749025, -0.881197095}, {-0.474100202, -0.880470872},
    {-0.475450277, -0.879742622}, {-0.476799220, -0.879012227}, {-0.478147060, -0.878279805},
    {-0.479493767, -0.877545297}, {-0.480839342, -0.876808703}, {-0.482183784, -0.876070082},
    {-0.483527064, -0.875329375}, {-0.484869242, -0.874586642}, {-0.486210287, -0.873841822},
    {-0.487550169, -0.873094976}, {-0.488888890, -0.872346044}, {-0.490226477, -0.871595085},
    {-0.491562903, -0.870842040}, {-0.492898196, -0.870086968}, {-0.494232297, -0.869329870},
    {-0.495565265, -0.868570685}, {-0.496897042, -0.867809474}, {-0.498227656, -0.867046237},
    {-0.499557108, -0.866280973}, {-0.500885367, -0.865513623}, {-0.502212465, -0.864744246},
    {-0.503538370, -0.863972843}, {-0.504863083, -0.863199413}, {-0.506186664, -0.862423956},
    {-0.507508993, -0.861646473}, {-0.508830130, -0.860866964}, {-0.510150075, -0.860085368},
    {-0.511468828, -0.859301805}, {-0.512786388, -0.858516216}, {-0.514102757, -0.857728601},
    {-0.515417874, -0.856938958}, {-0.516731799, -0.856147349}, {-0.518044531, -0.855353653},
    {-0.519356012, -0.854557991}, {-0.520666242, -0.853760302}, {-0.521975279, -0.852960587},
    {-0.523283124, -0.852158904}, {-0.524589658, -0.851355195}, {-0.525895000, -0.850549459},
    {-0.527199149, -0.849741757}, {-0.528501987, -0.848932028}, {-0.529803634, -0.848120332},
    {-0.531104028, -0.847306609}, {-0.532403111, -0.846490920}, {-0.533701003, -0.845673263},
    {-0.534997642, -0.844853580}, {-0.536292970, -0.844031870}, {-0.537587047, -0.843208253},
    {-0.538879931, -0.842382610}, {-0.540171444, -0.841554999}, {-0.541461766, -0.840725362},
    {-0.542750776, -0.839893818}, {-0.544038534, -0.839060247}, {-0.545324981, -0.838224709},
    {-0.546610177, -0.837387204}, {-0.547894061, -0.836547732}, {-0.549176633, -0.835706294},
    {-0.550457954, -0.834862888}, {-0.551737964, -0.834017515}, {-0.553016722, -0.833170176},
    {-0.554294109, -0.832320869}, {-0.555570245, -0.831469595}, {-0.556845009, -0.830616415},
    {-0.558118522, -0.829761207}, {-0.559390724, -0.828904092}, {-0.560661554, -0.828045070},
    {-0.561931133, -0.827184021}, {-0.563199341, -0.826321065}, {-0.564466238, -0.825456142},
    {-0.565731823, -0.824589312}, {-0.566996038, -0.823720515}, {-0.568258941, -0.822849810},
    {-0.569520533, -0.821977139}, {-0.570780754, -0.821102500}, {-0.572039604, -0.820225954},
    {-0.573297143, -0.819347501}, {-0.574553370, -0.818467140}, {-0.575808167, -0.817584813},
    {-0.577061653, -0.816700578}, {-0.578313768, -0.815814435}, {-0.579564571, -0.814926326},
    {-0.580813944, -0.814036310}, {-0.582062006, -0.813144386}, {-0.583308637, -0.812250614},
    {-0.584553957, -0.811354876}, {-0.585797846, -0.810457170}, {-0.587040365, -0.809557617},
    {-0.588281572, -0.808656156}, {-0.589521289, -0.807752848}, {-0.590759695, -0.806847572},
    {-0.591996670, -0.805940390}, {-0.593232274, -0.805031359}, {-0.594466507, -0.804120362},
    {-0.595699310, -0.803207517}, {-0.596930683, -0.802292824}, {-0.598160684, -0.801376164},
    {-0.599389315, -0.800457656}, {-0.600616455, -0.799537241}, {-0.601842225, -0.798614979},
    {-0.603066623, -0.797690868}, {-0.604289532, -0.796764791}, {-0.605511069, -0.795836926},
    {-0.606731117, -0.794907153}, {-0.607949793, -0.793975472}, {-0.609167039, -0.793041945},
    {-0.610382795, -0.792106569}, {-0.611597180, -0.791169345}, {-0.612810075, -0.790230215},
    {-0.614021540, -0.789289236}, {-0.615231574, -0.788346410}, {-0.616440177, -0.787401736},
    {-0.617647290, -0.786455214}, {-0.618852973, -0.785506845}, {-0.620057225, -0.784556568},
    {-0.621259987, -0.783604503}, {-0.622461259, -0.782650590}, {-0.623661101, -0.781694829},
    {-0.624859512, -0.780737221}, {-0.626056373, -0.779777765}, {-0.627251804, -0.778816521},
    {-0.628445745, -0.777853429}, {-0.629638255, -0.776888490}, {-0.630829215, -0.775921702},
    {-0.632018745, -0.774953127}, {-0.633206785, -0.773982704}, {-0.634393275, -0.773010433},
    {-0.635578334, -0.772036374}, {-0.636761844, -0.771060526}, {-0.637943923, -0.770082831},
    {-0.639124453, -0.769103348}, {-0.640303493, -0.768122017}, {-0.641481042, -0.767138898},
    {-0.642657042, -0.766153991}, {-0.643831551, -0.765167236}, {-0.645004511, -0.764178753},
    {-0.646176040, -0.763188422}, {-0.647345960, -0.762196302}, {-0.648514390, -0.761202395},
    {-0.649681330, -0.760206699}, {-0.650846660, -0.759209216}, {-0.652010560, -0.758209884},
    {-0.653172851, -0.757208824}, {-0.654333591, -0.756205976}, {-0.655492842, -0.755201399},
    {-0.656650543, -0.754194975}, {-0.657806695, -0.753186822}, {-0.658961296, -0.752176821},
    {-0.660114348, -0.751165152}, {-0.661265850, -0.750151634}, {-0.662415802, -0.749136388},
    {-0.663564146, -0.748119354}, {-0.664710999, -0.747100592}, {-0.665856242, -0.746080101},
    {-0.666999936, -0.745057762}, {-0.668142021, -0.744033754}, {-0.669282615, -0.743007958},
    {-0.670421541, -0.741980433}, {-0.671558976, -0.740951121}, {-0.672694743, -0.739920080},
    {-0.673829019, -0.738887310}, {-0.674961627, -0.737852812}, {-0.676092684, -0.736816585},
    {-0.677222192, -0.735778570}, {-0.678350031, -0.734738886}, {-0.679476321, -0.733697414},
    {-0.680601001, -0.732654274}, {-0.681724072, -0.731609404}, {-0.682845533, -0.730562747},
    {-0.683965385, -0.729514420}, {-0.685083687, -0.728464365}, {-0.686200321, -0.727412641},
    {-0.687315345, -0.726359129}, {-0.688428760, -0.725303948}, {-0.689540565, -0.724247098},
    {-0.690650702, -0.723188460}, {-0.691759229, -0.722128212}, {-0.692866147, -0.721066177},
    {-0.693971455, -0.720002532}, {-0.695075095, -0.718937099}, {-0.696177125, -0.717870057},
    {-0.697277486, -0.716801286}, {-0.698376238, -0.715730846}, {-0.699473321, -0.714658678},
    {-0.700568795, -0.713584840}, {-0.701662600, -0.712509394}, {-0.702754736, -0.711432219},
    {-0.703845263, -0.710353374}, {-0.704934061, -0.709272802}, {-0.706021249, -0.708190620},
    {-0.707106769, -0.707106769}, {-0.708190620, -0.706021249}, {-0.709272802, -0.704934061},
    {-0.710353374, -0.703845263}, {-0.711432219, -0.702754736}, {-0.712509394, -0.701662600},
    {-0.713584840, -0.700568795}, {-0.714658678, -0.699473321}, {-0.715730846, -0.698376238},
    {-0.716801286, -0.697277486}, {-0.717870057, -0.696177125}, {-0.718937099, -0.695075095},
    {-0.720002532, -0.693971455}, {-0.721066177, -0.692866147}, {-0.722128212, -0.691759229},
    {-0.723188460, -0.690650702}, {-0.724247098, -0.689540565}, {-0.725303948, -0.688428760},
    {-0.726359129, -0.687315345}, {-0.727412641, -0.686200321}, {-0.728464365, -0.685083687},
    {-0.729514420, -0.683965385}, {-0.730562747, -0.682845533}, {-0.731609404, -0.681724072},
    {-0.732654274, -0.680601001}, {-0.733697414, -0.679476321}, {-0.734738886, -0.678350031},
    {-0.735778570, -0.677222192}, {-0.736816585, -0.676092684}, {-0.737852812, -0.674961627},
    {-0.738887310, -0.673829019}, {-0.739920080, -0.672694743}, {-0.740951121, -0.671558976},
    {-0.741980433, -0.670421541}, {-0.743007958, -0.669282615}, {-0.744033754, -0.668142021},
    {-0.745057762, -0.666999936}, {-0.746080101, -0.665856242}, {-0.747100592, -0.664710999},
    {-0.748119354, -0.663564146}, {-0.749136388, -0.662415802}, {-0.750151634, -0.661265850},
    {-0.751165152, -0.660114348}, {-0.752176821, -0.658961296}, {-0.753186822, -0.657806695},
    {-0.754194975, -0.656650543}, {-0.755201399, -0.655492842}, {-0.756205976, -0.654333591},
    {-0.757208824, -0.653172851}, {-0.758209884, -0.652010560}, {-0.759209216, -0.650846660},
    {-0.760206699, -0.649681330}, {-0.761202395, -0.648514390}, {-0.762196302, -0.647345960},
    {-0.763188422, -0.646176040}, {-0.764178753, -0.645004511}, {-0.765167236, -0.643831551},
    {-0.766153991, -0.642657042}, {-0.767138898, -0.641481042}, {-0.768122017, -0.640303493},
    {-0.769103348, -0.639124453}, {-0.770082831, -0.637943923}, {-0.771060526, -0.636761844},
    {-0.772036374, -0.635578334}, {-0.773010433, -0.634393275}, {-0.773982704, -0.633206785},
    {-0.774953127, -0.632018745}, {-0.775921702, -0.630829215}, {-0.776888490, -0.629638255},
    {-0.777853429, -0.628445745}, {-0.778816521, -0.627251804}, {-0.779777765, -0.626056373},
    {-0.780737221, -0.624859512}, {-0.781694829, -0.623661101}, {-0.782650590, -0.622461259},
    {-0.783604503, -0.621259987}, {-0.784556568, -0.620057225}, {-0.785506845, -0.618852973},
    {-0.786455214, -0.617647290}, {-0.787401736, -0.616440177}, {-0.788346410, -0.615231574},
    {-0.789289236, -0.614021540}, {-0.790230215, -0.612810075}, {-0.791169345, -0.611597180},
    {-0.792106569, -0.610382795}, {-0.793041945, -0.609167039}, {-0.793975472, -0.607949793},
    {-0.794907153, -0.606731117}, {-0.795836926, -0.605511069}, {-0.796764791, -0.604289532},
    {-0.797690868, -0.603066623}, {-0.798614979, -0.601842225}, {-0.799537241, -0.600616455},
    {-0.800457656, -0.599389315}, {-0.801376164, -0.598160684}, {-0.802292824, -0.596930683},
    {-0.803207517, -0.595699310}, {-0.804120362, -0.594466507}, {-0.805031359, -0.593232274},
    {-0.805940390, -0.591996670}, {-0.806847572, -0.590759695}, {-0.807752848, -0.589521289},
    {-0.808656156, -0.588281572}, {-0.809557617, -0.587040365}, {-0.810457170, -0.585797846},
    {-0.811354876, -0.584553957}, {-0.812250614, -0.583308637}, {-0.813144386, -0.582062006},
    {-0.814036310, -0.580813944}, {-0.814926326, -0.579564571}, {-0.815814435, -0.578313768},
    {-0.816700578, -0.577061653}, {-0.817584813, -0.575808167}, {-0.818467140, -0.574553370},
    {-0.819347501, -0.573297143}, {-0.820225954, -0.572039604}, {-0.821102500, -0.570780754},
    {-0.821977139, -0.569520533}, {-0.822849810, -0.568258941}, {-0.823720515, -0.566996038},
    {-0.824589312, -0.565731823}, {-0.825456142, -0.564466238}, {-0.826321065, -0.563199341},
    {-0.827184021, -0.561931133}, {-0.828045070, -0.560661554}, {-0.828904092, -0.559390724},
    {-0.829761207, -0.558118522}, {-0.830616415, -0.556845009}, {-0.831469595, -0.555570245},
    {-0.832320869, -0.554294109}, {-0.833170176, -0.553016722}, {-0.834017515, -0.551737964},
    {-0.834862888, -0.550457954}, {-0.835706294, -0.549176633}, {-0.836547732, -0.547894061},
    {-0.837387204, -0.546610177}, {-0.838224709, -0.545324981}, {-0.839060247, -0.544038534},
    {-0.839893818, -0.542750776}, {-0.840725362, -0.541461766}, {-0.841554999, -0.540171444},
    {-0.842382610, -0.538879931}, {-0.843208253, -0.537587047}, {-0.844031870, -0.536292970},
    {-0.844853580, -0.534997642}, {-0.845673263, -0.533701003}, {-0.846490920, -0.532403111},
    {-0.847306609, -0.531104028}, {-0.848120332, -0.529803634}, {-0.848932028, -0.528501987},
    {-0.849741757, -0.527199149}, {-0.850549459, -0.525895000}, {-0.851355195, -0.524589658},
    {-0.852158904, -0.523283124}, {-0.852960587, -0.521975279}, {-0.853760302, -0.520666242},
    {-0.854557991, -0.519356012}, {-0.855353653, -0.518044531}, {-0.856147349, -0.516731799},
    {-0.856938958, -0.515417874}, {-0.857728601, -0.514102757}, {-0.858516216, -0.512786388},
    {-0.859301805, -0.511468828}, {-0.860085368, -0.510150075}, {-0.860866964, -0.508830130},
    {-0.861646473, -0.507508993}, {-0.862423956, -0.506186664}, {-0.863199413, -0.504863083},
    {-0.863972843, -0.503538370}, {-0.864744246, -0.502212465}, {-0.865513623, -0.500885367},
    {-0.866280973, -0.499557108}, {-0.867046237, -0.498227656}, {-0.867809474, -0.496897042},
    {-0.868570685, -0.495565265}, {-0.869329870, -0.494232297}, {-0.870086968, -0.492898196},
    {-0.870842040, -0.491562903}, {-0.871595085, -0.490226477}, {-0.872346044, -0.488888890},
    {-0.873094976, -0.487550169}, {-0.873841822, -0.486210287}, {-0.874586642, -0.484869242},
    {-0.875329375, -0.483527064}, {-0.876070082, -0.482183784}, {-0.876808703, -0.480839342},
    {-0.877545297, -0.479493767}, {-0.878279805, -0.478147060}, {-0.879012227, -0.476799220},
    {-0.879742622, -0.475450277}, {-0.880470872, -0.474100202}, {-0.881197095, -0.472749025},
    {-0.881921291, -0.471396744}, {-0.882643342, -0.470043331}, {-0.883363366, -0.468688816},
    {-0.884081244, -0.467333198}, {-0.884797096, -0.465976506}, {-0.885510862, -0.464618683},
    {-0.886222541, -0.463259786}, {-0.886932135, -0.461899787}, {-0.887639642, -0.460538715},
    {-0.888345063, -0.459176540}, {-0.889048338, -0.457813293}, {-0.889749587, -0.456448972},
    {-0.890448749, -0.455083579}, {-0.891145766, -0.453717113}, {-0.891840696, -0.452349573},
    {-0.892533541, -0.450980991}, {-0.893224299, -0.449611336}, {-0.893912971, -0.448240608},
    {-0.894599497, -0.446868837}, {-0.895283937, -0.445496023}, {-0.895966232, -0.444122136},
    {-0.896646500, -0.442747235}, {-0.897324562, -0.441371262}, {-0.898000598, -0.439994276},
    {-0.898674488, -0.438616246}, {-0.899346232, -0.437237173}, {-0.900015891, -0.435857087},
    {-0.900683403, -0.434475958}, {-0.901348829, -0.433093816}, {-0.902012169, -0.431710660},
    {-0.902673304, -0.430326492}, {-0.903332353, -0.428941280}, {-0.903989315, -0.427555084},
    {-0.904644072, -0.426167876}, {-0.905296743, -0.424779683}, {-0.905947268, -0.423390478},
    {-0.906595707, -0.422000259}, {-0.907242000, -0.420609087}, {-0.907886088, -0.419216901},
    {-0.908528090, -0.417823702}, {-0.909168005, -0.416429549}, {-0.909805715, -0.415034413},
    {-0.910441279, -0.413638324}, {-0.911074758, -0.412241220}, {-0.911706030, -0.410843164},
    {-0.912335157, -0.409444153}, {-0.912962198, -0.408044159}, {-0.913587034, -0.406643212},
    {-0.914209783, -0.405241311}, {-0.914830327, -0.403838456}, {-0.915448725, -0.402434647},
    {-0.916064978, -0.401029885}, {-0.916679084, -0.399624199}, {-0.917290986, -0.398217559},
    {-0.917900801, -0.396809995}, {-0.918508410, -0.395401478}, {-0.919113874, -0.393992037},
    {-0.919717133, -0.392581671}, {-0.920318305, -0.391170382}, {-0.920917213, -0.389758170},
    {-0.921514034, -0.388345033}, {-0.922108650, -0.386931002}, {-0.922701120, -0.385516047},
    {-0.923291445, -0.384100199}, {-0.923879504, -0.382683426}, {-0.924465477, -0.381265759},
    {-0.925049245, -0.379847199}, {-0.925630808, -0.378427744}, {-0.926210225, -0.377007425},
    {-0.926787496, -0.375586182}, {-0.927362502, -0.374164075}, {-0.927935421, -0.372741073},
    {-0.928506076, -0.371317208}, {-0.929074585, -0.369892448}, {-0.929640889, -0.368466824},
    {-0.930205047, -0.367040336}, {-0.930766940, -0.365612984}, {-0.931326687, -0.364184797},
    {-0.931884289, -0.362755716}, {-0.932439625, -0.361325800}, {-0.932992816, -0.359895051},
    {-0.933543801, -0.358463407}, {-0.934092522, -0.357030958}, {-0.934639156, -0.355597675},
    {-0.935183525, -0.354163527}, {-0.935725689, -0.352728546}, {-0.936265647, -0.351292759},
    {-0.936803460, -0.349856138}, {-0.937339008, -0.348418683}, {-0.937872350, -0.346980423},
    {-0.938403547, -0.345541328}, {-0.938932478, -0.344101429}, {-0.939459205, -0.342660725},
    {-0.939983726, -0.341219217}, {-0.940506041, -0.339776874}, {-0.941026151, -0.338333756},
    {-0.941544056, -0.336889863}, {-0.942059755, -0.335445136}, {-0.942573190, -0.333999664},
    {-0.943084419, -0.332553357}, {-0.943593442, -0.331106305}, {-0.944100261, -0.329658449},
    {-0.944604814, -0.328209847}, {-0.945107222, -0.326760441}, {-0.945607305, -0.325310290},
    {-0.946105242, -0.323859364}, {-0.946600914, -0.322407693}, {-0.947094381, -0.320955247},
    {-0.947585583, -0.319502026}, {-0.948074579, -0.318048090}, {-0.948561370, -0.316593379},
    {-0.949045897, -0.315137923}, {-0.949528158, -0.313681751}, {-0.950008273, -0.312224805},
    {-0.950486064, -0.310767144}, {-0.950961649, -0.309308767}, {-0.951435030, -0.307849646},
    {-0.951906145, -0.306389809}, {-0.952374995, -0.304929227}, {-0.952841640, -0.303467959},
    {-0.953306019, -0.302005947}, {-0.953768194, -0.300543249}, {-0.954228103, -0.299079835},
    {-0.954685748, -0.297615707}, {-0.955141187, -0.296150893}, {-0.955594361, -0.294685364},
    {-0.956045270, -0.293219149}, {-0.956493914, -0.291752249}, {-0.956940353, -0.290284663},
    {-0.957384527, -0.288816422}, {-0.957826436, -0.287347466}, {-0.958266079, -0.285877824},
    {-0.958703458, -0.284407526}, {-0.959138632, -0.282936573}, {-0.959571540, -0.281464934},
    {-0.960002124, -0.279992640}, {-0.960430503, -0.278519690}, {-0.960856616, -0.277046084},
    {-0.961280465, -0.275571823}, {-0.961702049, -0.274096906}, {-0.962121427, -0.272621363},
    {-0.962538481, -0.271145165}, {-0.962953269, -0.269668311}, {-0.963365793, -0.268190861},
    {-0.963776052, -0.266712755}, {-0.964184046, -0.265234023}, {-0.964589775, -0.263754666},
    {-0.964993238, -0.262274712}, {-0.965394437, -0.260794103}, {-0.965793371, -0.259312928},
    {-0.966189981, -0.257831097}, {-0.966584384, -0.256348670}, {-0.966976464, -0.254865646},
    {-0.967366278, -0.253382027}, {-0.967753828, -0.251897812}, {-0.968139112, -0.250413001},
    {-0.968522072, -0.248927608}, {-0.968902826, -0.247441620}, {-0.969281256, -0.245955050},
    {-0.969657362, -0.244467899}, {-0.970031261, -0.242980182}, {-0.970402837, -0.241491884},
    {-0.970772147, -0.240003020}, {-0.971139133, -0.238513589}, {-0.971503913, -0.237023607},
    {-0.971866310, -0.235533059}, {-0.972226501, -0.234041959}, {-0.972584367, -0.232550308},
    {-0.972939968, -0.231058106}, {-0.973293245, -0.229565367}, {-0.973644257, -0.228072077},
    {-0.973992944, -0.226578265}, {-0.974339366, -0.225083917}, {-0.974683523, -0.223589033},
    {-0.975025356, -0.222093627}, {-0.975364864, -0.220597684}, {-0.975702107, -0.219101235},
    {-0.976037085, -0.217604280}, {-0.976369739, -0.216106802}, {-0.976700068, -0.214608818},
    {-0.977028131, -0.213110313}, {-0.977353871, -0.211611331}, {-0.977677345, -0.210111842},
    {-0.977998495, -0.208611846}, {-0.978317380, -0.207111374}, {-0.978633940, -0.205610409},
    {-0.978948176, -0.204108968}, {-0.979260147, -0.202607036}, {-0.979569793, -0.201104641},
    {-0.979877114, -0.199601755}, {-0.980182111, -0.198098406}, {-0.980484843, -0.196594596},
    {-0.980785251, -0.195090324}, {-0.981083393, -0.193585590}, {-0.981379211, -0.192080393},
    {-0.981672704, -0.190574750}, {-0.981963873, -0.189068660}, {-0.982252717, -0.187562123},
    {-0.982539296, -0.186055154}, {-0.982823551, -0.184547737}, {-0.983105481, -0.183039889},
    {-0.983385086, -0.181531608}, {-0.983662426, -0.180022895}, {-0.983937442, -0.178513765},
    {-0.984210074, -0.177004218}, {-0.984480441, -0.175494254}, {-0.984748483, -0.173983872},
    {-0.985014260, -0.172473088}, {-0.985277653, -0.170961887}, {-0.985538721, -0.169450298},
    {-0.985797524, -0.167938292}, {-0.986053944, -0.166425899}, {-0.986308098, -0.164913118},
    {-0.986559927, -0.163399950}, {-0.986809373, -0.161886394}, {-0.987056553, -0.160372451},
    {-0.987301409, -0.158858150}, {-0.987543941, -0.157343462}, {-0.987784147, -0.155828401},
    {-0.988022029, -0.154312968}, {-0.988257587, -0.152797192}, {-0.988490820, -0.151281044},
    {-0.988721669, -0.149764538}, {-0.988950253, -0.148247674}, {-0.989176512, -0.146730468},
    {-0.989400446, -0.145212919}, {-0.989621997, -0.143695027}, {-0.989841282, -0.142176807},
    {-0.990058184, -0.140658244}, {-0.990272820, -0.139139339}, {-0.990485072, -0.137620121},
    {-0.990695000, -0.136100575}, {-0.990902662, -0.134580702}, {-0.991107941, -0.133060530},
    {-0.991310835, -0.131540030}, {-0.991511464, -0.130019218}, {-0.991709769, -0.128498107},
    {-0.991905689, -0.126976699}, {-0.992099285, -0.125454977}, {-0.992290616, -0.123932973},
    {-0.992479563, -0.122410677}, {-0.992666125, -0.120888084}, {-0.992850423, -0.119365215},
    {-0.993032336, -0.117842063}, {-0.993211925, -0.116318628}, {-0.993389189, -0.114794925},
    {-0.993564129, -0.113270953}, {-0.993736744, -0.111746714}, {-0.993906975, -0.110222206},
    {-0.994074881, -0.108697444}, {-0.994240463, -0.107172422}, {-0.994403660, -0.105647154},
    {-0.994564593, -0.104121633}, {-0.994723141, -0.102595866}, {-0.994879305, -0.101069860},
    {-0.995033205, -0.099543616}, {-0.995184720, -0.098017141}, {-0.995333910, -0.096490428},
    {-0.995480776, -0.094963498}, {-0.995625257, -0.093436338}, {-0.995767415, -0.091908954},
    {-0.995907247, -0.090381362}, {-0.996044695, -0.088853553}, {-0.996179819, -0.087325536},
    {-0.996312618, -0.085797310}, {-0.996443033, -0.084268890}, {-0.996571124, -0.082740262},
    {-0.996696889, -0.081211448}, {-0.996820271, -0.079682440}, {-0.996941328, -0.078153245},
    {-0.997060061, -0.076623864}, {-0.997176409, -0.075094298}, {-0.997290432, -0.073564567},
    {-0.997402132, -0.072034650}, {-0.997511446, -0.070504576}, {-0.997618437, -0.068974331},
    {-0.997723043, -0.067443922}, {-0.997825325, -0.065913349}, {-0.997925282, -0.064382628},
    {-0.998022854, -0.062851757}, {-0.998118103, -0.061320737}, {-0.998211026, -0.059789572},
    {-0.998301566, -0.058258265}, {-0.998389721, -0.056726821}, {-0.998475552, -0.055195246},
    {-0.998559058, -0.053663537}, {-0.998640239, -0.052131705}, {-0.998719037, -0.050599750},
    {-0.998795450, -0.049067676}, {-0.998869538, -0.047535483}, {-0.998941302, -0.046003181},
    {-0.999010682, -0.044470772}, {-0.999077737, -0.042938258}, {-0.999142408, -0.041405641},
    {-0.999204755, -0.039872926}, {-0.999264777, -0.038340122}, {-0.999322355, -0.036807224},
    {-0.999377668, -0.035274237}, {-0.999430597, -0.033741172}, {-0.999481201, -0.032208025},
    {-0.999529421, -0.030674804}, {-0.999575317, -0.029141508}, {-0.999618828, -0.027608145},
    {-0.999660015, -0.026074719}, {-0.999698818, -0.024541229}, {-0.999735296, -0.023007682},
    {-0.999769390, -0.021474080}, {-0.999801159, -0.019940428}, {-0.999830604, -0.018406730},
    {-0.999857664, -0.016872987}, {-0.999882340, -0.015339206}, {-0.999904692, -0.013805388},
    {-0.999924719, -0.012271538}, {-0.999942362, -0.010737659}, {-0.999957621, -0.009203754},
    {-0.999970615, -0.007669829}, {-0.999981165, -0.006135885}, {-0.999989390, -0.004601926},
    {-0.999995291, -0.003067957}, {-0.999998808, -0.001533980}};

alignas(32) const cint16 tw3_twiddle_master_cint16[1024] = { // 3rd twiddle required by radix 4 stage
    {32766, 0},       {32766, -151},    {32765, -302},    {32765, -453},    {32763, -603},    {32759, -754},
    {32755, -905},    {32750, -1056},   {32746, -1206},   {32741, -1357},   {32734, -1508},   {32725, -1659},
    {32718, -1809},   {32709, -1960},   {32700, -2111},   {32689, -2260},   {32680, -2411},   {32668, -2561},
    {32656, -2712},   {32642, -2862},   {32629, -3012},   {32615, -3162},   {32599, -3313},   {32585, -3462},
    {32568, -3613},   {32552, -3762},   {32534, -3912},   {32516, -4062},   {32496, -4211},   {32477, -4361},
    {32456, -4510},   {32435, -4660},   {32414, -4809},   {32391, -4958},   {32367, -5107},   {32344, -5255},
    {32319, -5405},   {32294, -5554},   {32268, -5702},   {32242, -5849},   {32215, -5998},   {32186, -6147},
    {32157, -6295},   {32129, -6442},   {32098, -6590},   {32068, -6738},   {32036, -6885},   {32005, -7033},
    {31971, -7180},   {31938, -7327},   {31904, -7474},   {31870, -7621},   {31835, -7767},   {31799, -7914},
    {31761, -8060},   {31724, -8206},   {31686, -8351},   {31647, -8497},   {31608, -8644},   {31568, -8789},
    {31526, -8934},   {31486, -9079},   {31443, -9223},   {31400, -9368},   {31356, -9513},   {31313, -9657},
    {31268, -9801},   {31222, -9944},   {31177, -10089},  {31131, -10232},  {31082, -10375},  {31035, -10517},
    {30985, -10661},  {30937, -10804},  {30886, -10946},  {30835, -11087},  {30784, -11229},  {30733, -11370},
    {30680, -11512},  {30626, -11652},  {30573, -11794},  {30517, -11933},  {30463, -12075},  {30406, -12215},
    {30350, -12354},  {30293, -12494},  {30235, -12633},  {30177, -12772},  {30118, -12911},  {30058, -13049},
    {29997, -13188},  {29936, -13325},  {29874, -13463},  {29812, -13600},  {29750, -13737},  {29686, -13874},
    {29622, -14010},  {29557, -14147},  {29491, -14282},  {29426, -14418},  {29359, -14553},  {29292, -14689},
    {29224, -14823},  {29156, -14957},  {29086, -15091},  {29016, -15225},  {28946, -15358},  {28875, -15492},
    {28803, -15625},  {28732, -15756},  {28659, -15889},  {28584, -16021},  {28512, -16152},  {28437, -16283},
    {28361, -16413},  {28285, -16544},  {28210, -16674},  {28132, -16804},  {28055, -16933},  {27976, -17061},
    {27896, -17190},  {27818, -17318},  {27738, -17446},  {27656, -17574},  {27576, -17700},  {27494, -17828},
    {27412, -17954},  {27329, -18080},  {27245, -18206},  {27162, -18331},  {27077, -18455},  {26992, -18581},
    {26907, -18704},  {26819, -18828},  {26733, -18951},  {26645, -19073},  {26558, -19197},  {26468, -19318},
    {26380, -19440},  {26289, -19561},  {26199, -19682},  {26109, -19802},  {26017, -19921},  {25926, -20041},
    {25833, -20161},  {25740, -20280},  {25646, -20398},  {25551, -20515},  {25457, -20633},  {25362, -20750},
    {25266, -20865},  {25170, -20982},  {25073, -21097},  {24976, -21213},  {24878, -21327},  {24779, -21442},
    {24680, -21556},  {24581, -21669},  {24481, -21781},  {24380, -21894},  {24280, -22006},  {24178, -22118},
    {24075, -22228},  {23973, -22339},  {23871, -22449},  {23766, -22559},  {23663, -22668},  {23558, -22777},
    {23453, -22884},  {23347, -22993},  {23241, -23100},  {23135, -23206},  {23028, -23313},  {22921, -23419},
    {22813, -23524},  {22704, -23628},  {22595, -23733},  {22486, -23836},  {22376, -23939},  {22265, -24042},
    {22154, -24145},  {22042, -24246},  {21931, -24348},  {21819, -24448},  {21705, -24549},  {21592, -24648},
    {21479, -24746},  {21365, -24846},  {21251, -24943},  {21135, -25041},  {21020, -25138},  {20904, -25235},
    {20788, -25331},  {20671, -25425},  {20554, -25521},  {20436, -25615},  {20318, -25709},  {20199, -25802},
    {20081, -25894},  {19961, -25987},  {19842, -26078},  {19722, -26170},  {19600, -26260},  {19479, -26350},
    {19358, -26439},  {19236, -26528},  {19115, -26616},  {18991, -26704},  {18868, -26792},  {18744, -26877},
    {18620, -26963},  {18497, -27049},  {18372, -27133},  {18247, -27218},  {18121, -27302},  {17995, -27385},
    {17870, -27468},  {17743, -27549},  {17615, -27631},  {17488, -27711},  {17361, -27792},  {17232, -27871},
    {17104, -27951},  {16975, -28029},  {16847, -28107},  {16717, -28184},  {16587, -28261},  {16457, -28336},
    {16326, -28411},  {16195, -28487},  {16064, -28562},  {15932, -28635},  {15800, -28708},  {15668, -28779},
    {15535, -28852},  {15402, -28923},  {15269, -28993},  {15136, -29063},  {15002, -29132},  {14867, -29201},
    {14732, -29270},  {14598, -29337},  {14463, -29404},  {14327, -29471},  {14192, -29536},  {14056, -29600},
    {13918, -29665},  {13782, -29729},  {13645, -29792},  {13509, -29855},  {13371, -29917},  {13233, -29977},
    {13095, -30038},  {12957, -30098},  {12817, -30158},  {12679, -30216},  {12540, -30274},  {12400, -30331},
    {12260, -30388},  {12121, -30445},  {11980, -30499},  {11840, -30555},  {11699, -30609},  {11558, -30663},
    {11418, -30715},  {11276, -30768},  {11134, -30819},  {10991, -30870},  {10850, -30921},  {10707, -30970},
    {10564, -31018},  {10422, -31067},  {10279, -31115},  {10135, -31161},  {9992, -31208},   {9847, -31253},
    {9704, -31299},   {9561, -31343},   {9416, -31386},   {9271, -31430},   {9126, -31472},   {8982, -31514},
    {8837, -31555},   {8691, -31595},   {8546, -31634},   {8400, -31674},   {8255, -31712},   {8107, -31749},
    {7962, -31787},   {7815, -31823},   {7669, -31859},   {7523, -31893},   {7375, -31927},   {7229, -31962},
    {7082, -31994},   {6934, -32027},   {6786, -32059},   {6640, -32089},   {6491, -32120},   {6343, -32148},
    {6195, -32177},   {6047, -32206},   {5899, -32233},   {5751, -32260},   {5602, -32287},   {5454, -32312},
    {5304, -32337},   {5156, -32360},   {5007, -32383},   {4858, -32406},   {4708, -32428},   {4559, -32450},
    {4410, -32471},   {4260, -32490},   {4111, -32510},   {3961, -32528},   {3812, -32546},   {3662, -32564},
    {3512, -32580},   {3361, -32595},   {3212, -32611},   {3062, -32625},   {2911, -32638},   {2760, -32652},
    {2610, -32664},   {2460, -32676},   {2310, -32686},   {2160, -32697},   {2010, -32707},   {1859, -32716},
    {1709, -32723},   {1558, -32731},   {1408, -32739},   {1256, -32745},   {1105, -32749},   {955, -32755},
    {804, -32758},    {653, -32762},    {502, -32764},    {352, -32766},    {201, -32768},    {51, -32768},
    {-100, -32768},   {-250, -32767},   {-402, -32766},   {-552, -32763},   {-704, -32762},   {-855, -32756},
    {-1005, -32753},  {-1156, -32748},  {-1306, -32743},  {-1457, -32736},  {-1608, -32729},  {-1758, -32721},
    {-1909, -32712},  {-2060, -32704},  {-2210, -32694},  {-2360, -32683},  {-2511, -32672},  {-2661, -32661},
    {-2812, -32648},  {-2962, -32635},  {-3112, -32620},  {-3262, -32606},  {-3412, -32591},  {-3562, -32575},
    {-3711, -32558},  {-3861, -32540},  {-4012, -32522},  {-4161, -32503},  {-4311, -32483},  {-4460, -32464},
    {-4609, -32443},  {-4759, -32421},  {-4907, -32400},  {-5056, -32376},  {-5205, -32353},  {-5354, -32328},
    {-5503, -32303},  {-5651, -32277},  {-5800, -32251},  {-5948, -32224},  {-6097, -32196},  {-6244, -32168},
    {-6393, -32140},  {-6541, -32110},  {-6687, -32079},  {-6835, -32048},  {-6984, -32015},  {-7130, -31983},
    {-7278, -31950},  {-7424, -31917},  {-7571, -31881},  {-7717, -31846},  {-7865, -31811},  {-8011, -31775},
    {-8157, -31737},  {-8303, -31700},  {-8449, -31660},  {-8594, -31622},  {-8740, -31582},  {-8884, -31541},
    {-9030, -31500},  {-9174, -31459},  {-9319, -31415},  {-9464, -31372},  {-9608, -31328},  {-9753, -31283},
    {-9895, -31238},  {-10040, -31193}, {-10183, -31147}, {-10326, -31098}, {-10470, -31051}, {-10613, -31002},
    {-10755, -30953}, {-10897, -30903}, {-11039, -30853}, {-11181, -30802}, {-11324, -30750}, {-11464, -30697},
    {-11605, -30644}, {-11746, -30591}, {-11887, -30537}, {-12027, -30481}, {-12167, -30426}, {-12307, -30370},
    {-12446, -30313}, {-12586, -30255}, {-12726, -30197}, {-12864, -30137}, {-13003, -30079}, {-13141, -30017},
    {-13279, -29958}, {-13417, -29896}, {-13554, -29834}, {-13692, -29771}, {-13828, -29707}, {-13964, -29643},
    {-14101, -29580}, {-14237, -29515}, {-14372, -29448}, {-14509, -29382}, {-14643, -29314}, {-14778, -29248},
    {-14912, -29179}, {-15046, -29109}, {-15180, -29041}, {-15314, -28970}, {-15446, -28899}, {-15580, -28828},
    {-15712, -28755}, {-15844, -28684}, {-15976, -28610}, {-16107, -28537}, {-16239, -28462}, {-16370, -28386},
    {-16500, -28311}, {-16631, -28236}, {-16760, -28158}, {-16889, -28081}, {-17019, -28002}, {-17148, -27924},
    {-17275, -27845}, {-17403, -27764}, {-17530, -27684}, {-17658, -27604}, {-17785, -27521}, {-17911, -27440},
    {-18037, -27357}, {-18163, -27273}, {-18288, -27190}, {-18413, -27106}, {-18538, -27021}, {-18663, -26935},
    {-18785, -26849}, {-18909, -26763}, {-19031, -26675}, {-19155, -26586}, {-19277, -26499}, {-19398, -26409},
    {-19520, -26320}, {-19641, -26230}, {-19761, -26139}, {-19881, -26048}, {-20001, -25956}, {-20120, -25864},
    {-20239, -25771}, {-20357, -25678}, {-20475, -25584}, {-20593, -25488}, {-20709, -25394}, {-20826, -25299},
    {-20943, -25202}, {-21058, -25106}, {-21174, -25009}, {-21288, -24911}, {-21404, -24813}, {-21517, -24713},
    {-21631, -24615}, {-21744, -24515}, {-21856, -24415}, {-21968, -24314}, {-22080, -24212}, {-22191, -24111},
    {-22302, -24008}, {-22411, -23905}, {-22522, -23802}, {-22631, -23699}, {-22741, -23594}, {-22849, -23489},
    {-22956, -23382}, {-23063, -23278}, {-23170, -23170}, {-23277, -23064}, {-23382, -22956}, {-23489, -22849},
    {-23593, -22741}, {-23698, -22631}, {-23801, -22522}, {-23905, -22412}, {-24007, -22302}, {-24110, -22191},
    {-24212, -22081}, {-24313, -21968}, {-24414, -21857}, {-24515, -21744}, {-24615, -21632}, {-24712, -21518},
    {-24813, -21404}, {-24910, -21289}, {-25008, -21174}, {-25105, -21058}, {-25201, -20944}, {-25299, -20827},
    {-25393, -20710}, {-25488, -20594}, {-25584, -20475}, {-25678, -20358}, {-25771, -20240}, {-25864, -20121},
    {-25955, -20002}, {-26048, -19881}, {-26139, -19761}, {-26230, -19641}, {-26319, -19521}, {-26409, -19398},
    {-26498, -19277}, {-26586, -19155}, {-26674, -19032}, {-26762, -18910}, {-26849, -18786}, {-26934, -18663},
    {-27021, -18539}, {-27105, -18413}, {-27189, -18289}, {-27273, -18164}, {-27356, -18038}, {-27439, -17911},
    {-27521, -17785}, {-27603, -17658}, {-27684, -17531}, {-27764, -17404}, {-27844, -17276}, {-27923, -17148},
    {-28002, -17020}, {-28081, -16889}, {-28157, -16760}, {-28235, -16631}, {-28311, -16501}, {-28386, -16370},
    {-28462, -16239}, {-28536, -16108}, {-28609, -15976}, {-28683, -15844}, {-28755, -15712}, {-28827, -15581},
    {-28899, -15447}, {-28970, -15315}, {-29041, -15181}, {-29109, -15047}, {-29179, -14913}, {-29247, -14779},
    {-29314, -14644}, {-29382, -14509}, {-29448, -14372}, {-29515, -14237}, {-29579, -14101}, {-29643, -13965},
    {-29707, -13829}, {-29770, -13692}, {-29834, -13554}, {-29895, -13418}, {-29957, -13279}, {-30017, -13141},
    {-30078, -13004}, {-30137, -12865}, {-30196, -12726}, {-30254, -12586}, {-30312, -12447}, {-30370, -12307},
    {-30425, -12167}, {-30480, -12028}, {-30536, -11887}, {-30590, -11746}, {-30644, -11605}, {-30697, -11465},
    {-30749, -11324}, {-30802, -11181}, {-30853, -11040}, {-30903, -10898}, {-30952, -10756}, {-31002, -10613},
    {-31051, -10470}, {-31097, -10326}, {-31146, -10184}, {-31193, -10040}, {-31238, -9896},  {-31282, -9753},
    {-31327, -9609},  {-31371, -9464},  {-31415, -9320},  {-31458, -9175},  {-31500, -9030},  {-31541, -8885},
    {-31582, -8740},  {-31622, -8595},  {-31659, -8450},  {-31699, -8304},  {-31737, -8157},  {-31774, -8011},
    {-31810, -7865},  {-31846, -7718},  {-31881, -7572},  {-31916, -7424},  {-31949, -7278},  {-31982, -7130},
    {-32015, -6984},  {-32048, -6836},  {-32078, -6688},  {-32109, -6541},  {-32139, -6393},  {-32167, -6245},
    {-32195, -6097},  {-32223, -5949},  {-32251, -5801},  {-32277, -5652},  {-32303, -5503},  {-32328, -5354},
    {-32352, -5206},  {-32375, -5057},  {-32399, -4908},  {-32421, -4759},  {-32443, -4609},  {-32463, -4460},
    {-32483, -4311},  {-32503, -4161},  {-32522, -4012},  {-32540, -3862},  {-32557, -3712},  {-32574, -3562},
    {-32590, -3413},  {-32606, -3262},  {-32619, -3112},  {-32634, -2962},  {-32647, -2812},  {-32661, -2661},
    {-32672, -2511},  {-32683, -2360},  {-32693, -2210},  {-32703, -2060},  {-32712, -1909},  {-32720, -1759},
    {-32729, -1608},  {-32735, -1458},  {-32742, -1307},  {-32747, -1157},  {-32752, -1005},  {-32756, -855},
    {-32761, -705},   {-32763, -553},   {-32766, -403},   {-32767, -251},   {-32767, -101},   {-32767, 50},
    {-32767, 200},    {-32766, 352},    {-32764, 501},    {-32762, 653},    {-32758, 804},    {-32754, 954},
    {-32749, 1105},   {-32744, 1256},   {-32738, 1407},   {-32730, 1557},   {-32723, 1708},   {-32716, 1859},
    {-32706, 2009},   {-32696, 2160},   {-32686, 2309},   {-32676, 2460},   {-32663, 2610},   {-32651, 2760},
    {-32638, 2911},   {-32624, 3061},   {-32611, 3211},   {-32595, 3361},   {-32579, 3512},   {-32563, 3661},
    {-32545, 3811},   {-32528, 3961},   {-32509, 4110},   {-32490, 4260},   {-32470, 4409},   {-32449, 4559},
    {-32428, 4708},   {-32406, 4857},   {-32383, 5006},   {-32360, 5156},   {-32336, 5304},   {-32311, 5453},
    {-32286, 5601},   {-32259, 5751},   {-32232, 5898},   {-32206, 6047},   {-32177, 6195},   {-32148, 6342},
    {-32119, 6491},   {-32089, 6639},   {-32058, 6786},   {-32026, 6934},   {-31993, 7081},   {-31961, 7228},
    {-31927, 7374},   {-31892, 7522},   {-31858, 7669},   {-31823, 7814},   {-31786, 7962},   {-31749, 8107},
    {-31712, 8254},   {-31674, 8399},   {-31634, 8545},   {-31595, 8691},   {-31555, 8837},   {-31513, 8981},
    {-31472, 9126},   {-31429, 9271},   {-31385, 9415},   {-31342, 9560},   {-31299, 9703},   {-31253, 9847},
    {-31207, 9991},   {-31161, 10134},  {-31114, 10279},  {-31067, 10421},  {-31018, 10564},  {-30970, 10707},
    {-30920, 10849},  {-30869, 10991},  {-30819, 11134},  {-30767, 11275},  {-30715, 11417},  {-30662, 11558},
    {-30608, 11699},  {-30554, 11839},  {-30499, 11980},  {-30444, 12120},  {-30388, 12260},  {-30330, 12400},
    {-30273, 12539},  {-30215, 12678},  {-30157, 12817},  {-30097, 12957},  {-30037, 13094},  {-29977, 13233},
    {-29916, 13370},  {-29855, 13508},  {-29791, 13645},  {-29729, 13781},  {-29665, 13918},  {-29600, 14055},
    {-29535, 14191},  {-29470, 14327},  {-29404, 14462},  {-29337, 14597},  {-29269, 14732},  {-29201, 14867},
    {-29132, 15001},  {-29062, 15135},  {-28993, 15269},  {-28923, 15402},  {-28851, 15535},  {-28779, 15667},
    {-28707, 15800},  {-28634, 15932},  {-28561, 16063},  {-28487, 16194},  {-28411, 16325},  {-28336, 16456},
    {-28261, 16586},  {-28184, 16716},  {-28106, 16846},  {-28028, 16975},  {-27950, 17103},  {-27871, 17232},
    {-27791, 17360},  {-27711, 17488},  {-27630, 17615},  {-27549, 17743},  {-27468, 17869},  {-27385, 17995},
    {-27302, 18121},  {-27217, 18246},  {-27132, 18371},  {-27049, 18497},  {-26963, 18620},  {-26877, 18743},
    {-26791, 18868},  {-26703, 18991},  {-26616, 19114},  {-26527, 19236},  {-26439, 19358},  {-26350, 19479},
    {-26259, 19599},  {-26169, 19721},  {-26078, 19841},  {-25986, 19960},  {-25894, 20080},  {-25802, 20199},
    {-25708, 20317},  {-25615, 20436},  {-25520, 20553},  {-25425, 20671},  {-25330, 20788},  {-25234, 20904},
    {-25137, 21020},  {-25040, 21135},  {-24943, 21251},  {-24845, 21365},  {-24746, 21479},  {-24648, 21592},
    {-24548, 21705},  {-24447, 21818},  {-24347, 21930},  {-24246, 22042},  {-24144, 22154},  {-24042, 22264},
    {-23938, 22375},  {-23836, 22485},  {-23732, 22594},  {-23628, 22703},  {-23523, 22812},  {-23418, 22920},
    {-23313, 23027},  {-23206, 23134},  {-23100, 23240},  {-22992, 23347},  {-22884, 23453},  {-22777, 23557},
    {-22667, 23662},  {-22559, 23766},  {-22449, 23870},  {-22338, 23973},  {-22228, 24075},  {-22117, 24177},
    {-22006, 24279},  {-21893, 24380},  {-21781, 24480},  {-21669, 24580},  {-21555, 24679},  {-21441, 24778},
    {-21327, 24877},  {-21213, 24976},  {-21097, 25072},  {-20981, 25169},  {-20865, 25265},  {-20750, 25362},
    {-20633, 25456},  {-20515, 25551},  {-20398, 25645},  {-20279, 25739},  {-20160, 25832},  {-20040, 25925},
    {-19921, 26017},  {-19801, 26109},  {-19681, 26199},  {-19560, 26289},  {-19440, 26379},  {-19318, 26468},
    {-19196, 26557},  {-19073, 26644},  {-18950, 26732},  {-18827, 26819},  {-18703, 26906},  {-18580, 26991},
    {-18454, 27077},  {-18331, 27161},  {-18205, 27245},  {-18079, 27329},  {-17954, 27412},  {-17828, 27493},
    {-17700, 27576},  {-17573, 27656},  {-17446, 27737},  {-17318, 27817},  {-17190, 27896},  {-17061, 27976},
    {-16932, 28054},  {-16803, 28132},  {-16673, 28209},  {-16544, 28285},  {-16412, 28360},  {-16283, 28436},
    {-16151, 28511},  {-16021, 28584},  {-15889, 28659},  {-15756, 28731},  {-15624, 28803},  {-15491, 28875},
    {-15358, 28945},  {-15224, 29016},  {-15091, 29086},  {-14957, 29155},  {-14823, 29224},  {-14689, 29291},
    {-14553, 29358},  {-14417, 29425},  {-14281, 29491},  {-14146, 29557},  {-14010, 29621},  {-13874, 29686},
    {-13737, 29749},  {-13600, 29812},  {-13463, 29874},  {-13325, 29936},  {-13187, 29997},  {-13049, 30057},
    {-12911, 30117},  {-12772, 30177},  {-12633, 30234},  {-12493, 30292},  {-12354, 30349},  {-12214, 30406},
    {-12074, 30462},  {-11933, 30517},  {-11793, 30572},  {-11652, 30626},  {-11511, 30679},  {-11369, 30732},
    {-11229, 30784},  {-11086, 30834},  {-10945, 30885},  {-10803, 30936},  {-10660, 30985},  {-10517, 31034},
    {-10374, 31081},  {-10231, 31130},  {-10088, 31177},  {-9944, 31222},   {-9801, 31268},   {-9656, 31313},
    {-9512, 31356},   {-9368, 31400},   {-9223, 31443},   {-9079, 31485},   {-8934, 31526},   {-8789, 31567},
    {-8643, 31607},   {-8497, 31647},   {-8351, 31686},   {-8205, 31723},   {-8059, 31761},   {-7913, 31798},
    {-7766, 31834},   {-7620, 31870},   {-7474, 31904},   {-7326, 31937},   {-7180, 31971},   {-7032, 32004},
    {-6884, 32035},   {-6738, 32067},   {-6590, 32098},   {-6442, 32128},   {-6295, 32157},   {-6147, 32186},
    {-5997, 32214},   {-5849, 32241},   {-5702, 32268},   {-5553, 32293},   {-5404, 32318},   {-5255, 32343},
    {-5106, 32367},   {-4957, 32390},   {-4808, 32413},   {-4659, 32435},   {-4509, 32455},   {-4360, 32476},
    {-4210, 32496},   {-4061, 32515},   {-3912, 32533},   {-3761, 32551},   {-3612, 32568},   {-3462, 32584},
    {-3312, 32599},   {-3162, 32615},   {-3011, 32629},   {-2862, 32642},   {-2712, 32656},   {-2560, 32667},
    {-2411, 32679},   {-2260, 32689},   {-2110, 32699},   {-1959, 32708},   {-1808, 32717},   {-1659, 32725},
    {-1508, 32733},   {-1357, 32740},   {-1206, 32746},   {-1056, 32750},   {-905, 32755},    {-754, 32759},
    {-603, 32762},    {-453, 32765},    {-302, 32766},    {-151, 32767}};

//}}}}

#endif //__FFT_IFFT_DIT_TWIDDLE_LUT_H__
