#
# Copyright (C) 2019-2022, Xilinx, Inc.
# Copyright (C) 2022-2025, Advanced Micro Devices, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
def getPhaseAlias(dataTypeStr, coefTypeStr, interpolationFactor, decimationFactor, api):
    phaseLookupTable = {
        ("int16", "int16", 1, 1, 0): 1,
        ("int16", "int16", 2, 1, 0): 1,
        ("int16", "int16", 3, 1, 0): 3,
        ("int16", "int16", 4, 1, 0): 1,
        ("int16", "int16", 5, 1, 0): 5,
        ("int16", "int16", 6, 1, 0): 3,
        ("int16", "int16", 7, 1, 0): 7,
        ("int16", "int16", 8, 1, 0): 2,
        ("int16", "int16", 9, 1, 0): 9,
        ("int16", "int16", 10, 1, 0): 5,
        ("int16", "int16", 11, 1, 0): 11,
        ("int16", "int16", 12, 1, 0): 3,
        ("int16", "int16", 13, 1, 0): 13,
        ("int16", "int16", 14, 1, 0): 7,
        ("int16", "int16", 15, 1, 0): 15,
        ("int16", "int16", 16, 1, 0): 4,
        ("int16", "int16", 1, 2, 0): 1,
        ("int16", "int16", 2, 2, 0): 1,
        ("int16", "int16", 3, 2, 0): 3,
        ("int16", "int16", 4, 2, 0): 1,
        ("int16", "int16", 5, 2, 0): 5,
        ("int16", "int16", 6, 2, 0): 3,
        ("int16", "int16", 7, 2, 0): 7,
        ("int16", "int16", 8, 2, 0): 1,
        ("int16", "int16", 9, 2, 0): 9,
        ("int16", "int16", 10, 2, 0): 5,
        ("int16", "int16", 11, 2, 0): 11,
        ("int16", "int16", 12, 2, 0): 3,
        ("int16", "int16", 13, 2, 0): 13,
        ("int16", "int16", 14, 2, 0): 7,
        ("int16", "int16", 15, 2, 0): 15,
        ("int16", "int16", 16, 2, 0): 2,
        ("int16", "int16", 1, 3, 0): 1,
        ("int16", "int16", 2, 3, 0): 1,
        ("int16", "int16", 3, 3, 0): 3,
        ("int16", "int16", 4, 3, 0): 1,
        ("int16", "int16", 5, 3, 0): 5,
        ("int16", "int16", 6, 3, 0): 3,
        ("int16", "int16", 7, 3, 0): 7,
        ("int16", "int16", 8, 3, 0): 2,
        ("int16", "int16", 9, 3, 0): 9,
        ("int16", "int16", 10, 3, 0): 5,
        ("int16", "int16", 11, 3, 0): 11,
        ("int16", "int16", 12, 3, 0): 3,
        ("int16", "int16", 13, 3, 0): 13,
        ("int16", "int16", 14, 3, 0): 7,
        ("int16", "int16", 15, 3, 0): 15,
        ("int16", "int16", 16, 3, 0): 4,
        ("int16", "int16", 1, 4, 0): 1,
        ("int16", "int16", 2, 4, 0): 1,
        ("int16", "int16", 3, 4, 0): 3,
        ("int16", "int16", 4, 4, 0): 1,
        ("int16", "int16", 5, 4, 0): 5,
        ("int16", "int16", 6, 4, 0): 3,
        ("int16", "int16", 7, 4, 0): 7,
        ("int16", "int16", 8, 4, 0): 1,
        ("int16", "int16", 9, 4, 0): 9,
        ("int16", "int16", 10, 4, 0): 5,
        ("int16", "int16", 11, 4, 0): 11,
        ("int16", "int16", 12, 4, 0): 3,
        ("int16", "int16", 13, 4, 0): 13,
        ("int16", "int16", 14, 4, 0): 7,
        ("int16", "int16", 15, 4, 0): 15,
        ("int16", "int16", 16, 4, 0): 1,
        ("int16", "int16", 1, 5, 0): 1,
        ("int16", "int16", 2, 5, 0): 1,
        ("int16", "int16", 3, 5, 0): 3,
        ("int16", "int16", 4, 5, 0): 1,
        ("int16", "int16", 5, 5, 0): 5,
        ("int16", "int16", 6, 5, 0): 3,
        ("int16", "int16", 7, 5, 0): 7,
        ("int16", "int16", 8, 5, 0): 2,
        ("int16", "int16", 9, 5, 0): 9,
        ("int16", "int16", 10, 5, 0): 5,
        ("int16", "int16", 11, 5, 0): 11,
        ("int16", "int16", 12, 5, 0): 3,
        ("int16", "int16", 13, 5, 0): 13,
        ("int16", "int16", 14, 5, 0): 7,
        ("int16", "int16", 15, 5, 0): 15,
        ("int16", "int16", 16, 5, 0): 4,
        ("int16", "int16", 1, 6, 0): 1,
        ("int16", "int16", 2, 6, 0): 1,
        ("int16", "int16", 3, 6, 0): 3,
        ("int16", "int16", 4, 6, 0): 1,
        ("int16", "int16", 5, 6, 0): 5,
        ("int16", "int16", 6, 6, 0): 3,
        ("int16", "int16", 7, 6, 0): 7,
        ("int16", "int16", 8, 6, 0): 1,
        ("int16", "int16", 9, 6, 0): 9,
        ("int16", "int16", 10, 6, 0): 5,
        ("int16", "int16", 11, 6, 0): 11,
        ("int16", "int16", 12, 6, 0): 3,
        ("int16", "int16", 13, 6, 0): 13,
        ("int16", "int16", 14, 6, 0): 7,
        ("int16", "int16", 15, 6, 0): 15,
        ("int16", "int16", 16, 6, 0): 2,
        ("int16", "int16", 1, 7, 0): 1,
        ("int16", "int16", 2, 7, 0): 1,
        ("int16", "int16", 3, 7, 0): 3,
        ("int16", "int16", 4, 7, 0): 1,
        ("int16", "int16", 5, 7, 0): 5,
        ("int16", "int16", 6, 7, 0): 3,
        ("int16", "int16", 7, 7, 0): 7,
        ("int16", "int16", 8, 7, 0): 2,
        ("int16", "int16", 9, 7, 0): 9,
        ("int16", "int16", 10, 7, 0): 5,
        ("int16", "int16", 11, 7, 0): 11,
        ("int16", "int16", 12, 7, 0): 3,
        ("int16", "int16", 13, 7, 0): 13,
        ("int16", "int16", 14, 7, 0): 7,
        ("int16", "int16", 15, 7, 0): 15,
        ("int16", "int16", 16, 7, 0): 4,
        ("int16", "int16", 1, 8, 0): 1,
        ("int16", "int16", 2, 8, 0): 1,
        ("int16", "int16", 3, 8, 0): 3,
        ("int16", "int16", 4, 8, 0): 1,
        ("int16", "int16", 5, 8, 0): 5,
        ("int16", "int16", 6, 8, 0): 3,
        ("int16", "int16", 7, 8, 0): 7,
        ("int16", "int16", 8, 8, 0): 1,
        ("int16", "int16", 9, 8, 0): 9,
        ("int16", "int16", 10, 8, 0): 5,
        ("int16", "int16", 11, 8, 0): 11,
        ("int16", "int16", 12, 8, 0): 3,
        ("int16", "int16", 13, 8, 0): 13,
        ("int16", "int16", 14, 8, 0): 7,
        ("int16", "int16", 15, 8, 0): 15,
        ("int16", "int16", 16, 8, 0): 1,
        ("int16", "int16", 1, 9, 0): 1,
        ("int16", "int16", 2, 9, 0): 1,
        ("int16", "int16", 3, 9, 0): 3,
        ("int16", "int16", 4, 9, 0): 1,
        ("int16", "int16", 5, 9, 0): 5,
        ("int16", "int16", 6, 9, 0): 3,
        ("int16", "int16", 7, 9, 0): 7,
        ("int16", "int16", 8, 9, 0): 2,
        ("int16", "int16", 9, 9, 0): 9,
        ("int16", "int16", 10, 9, 0): 5,
        ("int16", "int16", 11, 9, 0): 11,
        ("int16", "int16", 12, 9, 0): 3,
        ("int16", "int16", 13, 9, 0): 13,
        ("int16", "int16", 14, 9, 0): 7,
        ("int16", "int16", 15, 9, 0): 15,
        ("int16", "int16", 16, 9, 0): 4,
        ("int16", "int16", 1, 10, 0): 1,
        ("int16", "int16", 2, 10, 0): 1,
        ("int16", "int16", 3, 10, 0): 3,
        ("int16", "int16", 4, 10, 0): 1,
        ("int16", "int16", 5, 10, 0): 5,
        ("int16", "int16", 6, 10, 0): 3,
        ("int16", "int16", 7, 10, 0): 7,
        ("int16", "int16", 8, 10, 0): 1,
        ("int16", "int16", 9, 10, 0): 9,
        ("int16", "int16", 10, 10, 0): 5,
        ("int16", "int16", 11, 10, 0): 11,
        ("int16", "int16", 12, 10, 0): 3,
        ("int16", "int16", 13, 10, 0): 13,
        ("int16", "int16", 14, 10, 0): 7,
        ("int16", "int16", 15, 10, 0): 15,
        ("int16", "int16", 16, 10, 0): 2,
        ("int16", "int16", 1, 11, 0): 1,
        ("int16", "int16", 2, 11, 0): 1,
        ("int16", "int16", 3, 11, 0): 3,
        ("int16", "int16", 4, 11, 0): 1,
        ("int16", "int16", 5, 11, 0): 5,
        ("int16", "int16", 6, 11, 0): 3,
        ("int16", "int16", 7, 11, 0): 7,
        ("int16", "int16", 8, 11, 0): 2,
        ("int16", "int16", 9, 11, 0): 9,
        ("int16", "int16", 10, 11, 0): 5,
        ("int16", "int16", 11, 11, 0): 11,
        ("int16", "int16", 12, 11, 0): 3,
        ("int16", "int16", 13, 11, 0): 13,
        ("int16", "int16", 14, 11, 0): 7,
        ("int16", "int16", 15, 11, 0): 15,
        ("int16", "int16", 16, 11, 0): 4,
        ("int16", "int16", 1, 12, 0): 1,
        ("int16", "int16", 2, 12, 0): 1,
        ("int16", "int16", 3, 12, 0): 3,
        ("int16", "int16", 4, 12, 0): 1,
        ("int16", "int16", 5, 12, 0): 5,
        ("int16", "int16", 6, 12, 0): 3,
        ("int16", "int16", 7, 12, 0): 7,
        ("int16", "int16", 8, 12, 0): 1,
        ("int16", "int16", 9, 12, 0): 9,
        ("int16", "int16", 10, 12, 0): 5,
        ("int16", "int16", 11, 12, 0): 11,
        ("int16", "int16", 12, 12, 0): 3,
        ("int16", "int16", 13, 12, 0): 13,
        ("int16", "int16", 14, 12, 0): 7,
        ("int16", "int16", 15, 12, 0): 15,
        ("int16", "int16", 16, 12, 0): 1,
        ("int16", "int16", 1, 13, 0): 1,
        ("int16", "int16", 2, 13, 0): 1,
        ("int16", "int16", 3, 13, 0): 3,
        ("int16", "int16", 4, 13, 0): 1,
        ("int16", "int16", 5, 13, 0): 5,
        ("int16", "int16", 6, 13, 0): 3,
        ("int16", "int16", 7, 13, 0): 7,
        ("int16", "int16", 8, 13, 0): 2,
        ("int16", "int16", 9, 13, 0): 9,
        ("int16", "int16", 10, 13, 0): 5,
        ("int16", "int16", 11, 13, 0): 11,
        ("int16", "int16", 12, 13, 0): 3,
        ("int16", "int16", 13, 13, 0): 13,
        ("int16", "int16", 14, 13, 0): 7,
        ("int16", "int16", 15, 13, 0): 15,
        ("int16", "int16", 16, 13, 0): 4,
        ("int16", "int16", 1, 14, 0): 1,
        ("int16", "int16", 2, 14, 0): 1,
        ("int16", "int16", 3, 14, 0): 3,
        ("int16", "int16", 4, 14, 0): 1,
        ("int16", "int16", 5, 14, 0): 5,
        ("int16", "int16", 6, 14, 0): 3,
        ("int16", "int16", 7, 14, 0): 7,
        ("int16", "int16", 8, 14, 0): 1,
        ("int16", "int16", 9, 14, 0): 9,
        ("int16", "int16", 10, 14, 0): 5,
        ("int16", "int16", 11, 14, 0): 11,
        ("int16", "int16", 12, 14, 0): 3,
        ("int16", "int16", 13, 14, 0): 13,
        ("int16", "int16", 14, 14, 0): 7,
        ("int16", "int16", 15, 14, 0): 15,
        ("int16", "int16", 16, 14, 0): 2,
        ("int16", "int16", 1, 15, 0): 1,
        ("int16", "int16", 2, 15, 0): 1,
        ("int16", "int16", 3, 15, 0): 3,
        ("int16", "int16", 4, 15, 0): 1,
        ("int16", "int16", 5, 15, 0): 5,
        ("int16", "int16", 6, 15, 0): 3,
        ("int16", "int16", 7, 15, 0): 7,
        ("int16", "int16", 8, 15, 0): 2,
        ("int16", "int16", 9, 15, 0): 9,
        ("int16", "int16", 10, 15, 0): 5,
        ("int16", "int16", 11, 15, 0): 11,
        ("int16", "int16", 12, 15, 0): 3,
        ("int16", "int16", 13, 15, 0): 13,
        ("int16", "int16", 14, 15, 0): 7,
        ("int16", "int16", 15, 15, 0): 15,
        ("int16", "int16", 16, 15, 0): 4,
        ("int16", "int16", 1, 16, 0): 1,
        ("int16", "int16", 2, 16, 0): 1,
        ("int16", "int16", 3, 16, 0): 3,
        ("int16", "int16", 4, 16, 0): 1,
        ("int16", "int16", 5, 16, 0): 5,
        ("int16", "int16", 6, 16, 0): 3,
        ("int16", "int16", 7, 16, 0): 7,
        ("int16", "int16", 8, 16, 0): 1,
        ("int16", "int16", 9, 16, 0): 9,
        ("int16", "int16", 10, 16, 0): 5,
        ("int16", "int16", 11, 16, 0): 11,
        ("int16", "int16", 12, 16, 0): 3,
        ("int16", "int16", 13, 16, 0): 13,
        ("int16", "int16", 14, 16, 0): 7,
        ("int16", "int16", 15, 16, 0): 15,
        ("int16", "int16", 16, 16, 0): 1,
        ("int16", "int16", 1, 1, 1): 1,
        ("int16", "int16", 2, 1, 1): 1,
        ("int16", "int16", 3, 1, 1): 3,
        ("int16", "int16", 4, 1, 1): 2,
        ("int16", "int16", 5, 1, 1): 5,
        ("int16", "int16", 6, 1, 1): 3,
        ("int16", "int16", 7, 1, 1): 7,
        ("int16", "int16", 8, 1, 1): 4,
        ("int16", "int16", 9, 1, 1): 9,
        ("int16", "int16", 10, 1, 1): 5,
        ("int16", "int16", 11, 1, 1): 11,
        ("int16", "int16", 12, 1, 1): 6,
        ("int16", "int16", 13, 1, 1): 13,
        ("int16", "int16", 14, 1, 1): 7,
        ("int16", "int16", 15, 1, 1): 15,
        ("int16", "int16", 16, 1, 1): 8,
        ("int16", "int16", 1, 2, 1): 1,
        ("int16", "int16", 2, 2, 1): 1,
        ("int16", "int16", 3, 2, 1): 3,
        ("int16", "int16", 4, 2, 1): 1,
        ("int16", "int16", 5, 2, 1): 5,
        ("int16", "int16", 6, 2, 1): 3,
        ("int16", "int16", 7, 2, 1): 7,
        ("int16", "int16", 8, 2, 1): 2,
        ("int16", "int16", 9, 2, 1): 9,
        ("int16", "int16", 10, 2, 1): 5,
        ("int16", "int16", 11, 2, 1): 11,
        ("int16", "int16", 12, 2, 1): 3,
        ("int16", "int16", 13, 2, 1): 13,
        ("int16", "int16", 14, 2, 1): 7,
        ("int16", "int16", 15, 2, 1): 15,
        ("int16", "int16", 16, 2, 1): 4,
        ("int16", "int16", 1, 3, 1): 1,
        ("int16", "int16", 2, 3, 1): 1,
        ("int16", "int16", 3, 3, 1): 3,
        ("int16", "int16", 4, 3, 1): 2,
        ("int16", "int16", 5, 3, 1): 5,
        ("int16", "int16", 6, 3, 1): 3,
        ("int16", "int16", 7, 3, 1): 7,
        ("int16", "int16", 8, 3, 1): 4,
        ("int16", "int16", 9, 3, 1): 9,
        ("int16", "int16", 10, 3, 1): 5,
        ("int16", "int16", 11, 3, 1): 11,
        ("int16", "int16", 12, 3, 1): 6,
        ("int16", "int16", 13, 3, 1): 13,
        ("int16", "int16", 14, 3, 1): 7,
        ("int16", "int16", 15, 3, 1): 15,
        ("int16", "int16", 16, 3, 1): 8,
        ("int16", "int16", 1, 4, 1): 1,
        ("int16", "int16", 2, 4, 1): 1,
        ("int16", "int16", 3, 4, 1): 3,
        ("int16", "int16", 4, 4, 1): 1,
        ("int16", "int16", 5, 4, 1): 5,
        ("int16", "int16", 6, 4, 1): 3,
        ("int16", "int16", 7, 4, 1): 7,
        ("int16", "int16", 8, 4, 1): 1,
        ("int16", "int16", 9, 4, 1): 9,
        ("int16", "int16", 10, 4, 1): 5,
        ("int16", "int16", 11, 4, 1): 11,
        ("int16", "int16", 12, 4, 1): 3,
        ("int16", "int16", 13, 4, 1): 13,
        ("int16", "int16", 14, 4, 1): 7,
        ("int16", "int16", 15, 4, 1): 15,
        ("int16", "int16", 16, 4, 1): 2,
        ("int16", "int16", 1, 5, 1): 1,
        ("int16", "int16", 2, 5, 1): 1,
        ("int16", "int16", 3, 5, 1): 3,
        ("int16", "int16", 4, 5, 1): 2,
        ("int16", "int16", 5, 5, 1): 5,
        ("int16", "int16", 6, 5, 1): 3,
        ("int16", "int16", 7, 5, 1): 7,
        ("int16", "int16", 8, 5, 1): 4,
        ("int16", "int16", 9, 5, 1): 9,
        ("int16", "int16", 10, 5, 1): 5,
        ("int16", "int16", 11, 5, 1): 11,
        ("int16", "int16", 12, 5, 1): 6,
        ("int16", "int16", 13, 5, 1): 13,
        ("int16", "int16", 14, 5, 1): 7,
        ("int16", "int16", 15, 5, 1): 15,
        ("int16", "int16", 16, 5, 1): 8,
        ("int16", "int16", 1, 6, 1): 1,
        ("int16", "int16", 2, 6, 1): 1,
        ("int16", "int16", 3, 6, 1): 3,
        ("int16", "int16", 4, 6, 1): 1,
        ("int16", "int16", 5, 6, 1): 5,
        ("int16", "int16", 6, 6, 1): 3,
        ("int16", "int16", 7, 6, 1): 7,
        ("int16", "int16", 8, 6, 1): 2,
        ("int16", "int16", 9, 6, 1): 9,
        ("int16", "int16", 10, 6, 1): 5,
        ("int16", "int16", 11, 6, 1): 11,
        ("int16", "int16", 12, 6, 1): 3,
        ("int16", "int16", 13, 6, 1): 13,
        ("int16", "int16", 14, 6, 1): 7,
        ("int16", "int16", 15, 6, 1): 15,
        ("int16", "int16", 16, 6, 1): 4,
        ("int16", "int16", 1, 7, 1): 1,
        ("int16", "int16", 2, 7, 1): 1,
        ("int16", "int16", 3, 7, 1): 3,
        ("int16", "int16", 4, 7, 1): 2,
        ("int16", "int16", 5, 7, 1): 5,
        ("int16", "int16", 6, 7, 1): 3,
        ("int16", "int16", 7, 7, 1): 7,
        ("int16", "int16", 8, 7, 1): 4,
        ("int16", "int16", 9, 7, 1): 9,
        ("int16", "int16", 10, 7, 1): 5,
        ("int16", "int16", 11, 7, 1): 11,
        ("int16", "int16", 12, 7, 1): 6,
        ("int16", "int16", 13, 7, 1): 13,
        ("int16", "int16", 14, 7, 1): 7,
        ("int16", "int16", 15, 7, 1): 15,
        ("int16", "int16", 16, 7, 1): 8,
        ("int16", "int16", 1, 8, 1): 1,
        ("int16", "int16", 2, 8, 1): 1,
        ("int16", "int16", 3, 8, 1): 3,
        ("int16", "int16", 4, 8, 1): 1,
        ("int16", "int16", 5, 8, 1): 5,
        ("int16", "int16", 6, 8, 1): 3,
        ("int16", "int16", 7, 8, 1): 7,
        ("int16", "int16", 8, 8, 1): 1,
        ("int16", "int16", 9, 8, 1): 9,
        ("int16", "int16", 10, 8, 1): 5,
        ("int16", "int16", 11, 8, 1): 11,
        ("int16", "int16", 12, 8, 1): 3,
        ("int16", "int16", 13, 8, 1): 13,
        ("int16", "int16", 14, 8, 1): 7,
        ("int16", "int16", 15, 8, 1): 15,
        ("int16", "int16", 16, 8, 1): 1,
        ("int16", "int16", 1, 9, 1): 1,
        ("int16", "int16", 2, 9, 1): 1,
        ("int16", "int16", 3, 9, 1): 3,
        ("int16", "int16", 4, 9, 1): 2,
        ("int16", "int16", 5, 9, 1): 5,
        ("int16", "int16", 6, 9, 1): 3,
        ("int16", "int16", 7, 9, 1): 7,
        ("int16", "int16", 8, 9, 1): 4,
        ("int16", "int16", 9, 9, 1): 9,
        ("int16", "int16", 10, 9, 1): 5,
        ("int16", "int16", 11, 9, 1): 11,
        ("int16", "int16", 12, 9, 1): 6,
        ("int16", "int16", 13, 9, 1): 13,
        ("int16", "int16", 14, 9, 1): 7,
        ("int16", "int16", 15, 9, 1): 15,
        ("int16", "int16", 16, 9, 1): 8,
        ("int16", "int16", 1, 10, 1): 1,
        ("int16", "int16", 2, 10, 1): 1,
        ("int16", "int16", 3, 10, 1): 3,
        ("int16", "int16", 4, 10, 1): 1,
        ("int16", "int16", 5, 10, 1): 5,
        ("int16", "int16", 6, 10, 1): 3,
        ("int16", "int16", 7, 10, 1): 7,
        ("int16", "int16", 8, 10, 1): 2,
        ("int16", "int16", 9, 10, 1): 9,
        ("int16", "int16", 10, 10, 1): 5,
        ("int16", "int16", 11, 10, 1): 11,
        ("int16", "int16", 12, 10, 1): 3,
        ("int16", "int16", 13, 10, 1): 13,
        ("int16", "int16", 14, 10, 1): 7,
        ("int16", "int16", 15, 10, 1): 15,
        ("int16", "int16", 16, 10, 1): 4,
        ("int16", "int16", 1, 11, 1): 1,
        ("int16", "int16", 2, 11, 1): 1,
        ("int16", "int16", 3, 11, 1): 3,
        ("int16", "int16", 4, 11, 1): 2,
        ("int16", "int16", 5, 11, 1): 5,
        ("int16", "int16", 6, 11, 1): 3,
        ("int16", "int16", 7, 11, 1): 7,
        ("int16", "int16", 8, 11, 1): 4,
        ("int16", "int16", 9, 11, 1): 9,
        ("int16", "int16", 10, 11, 1): 5,
        ("int16", "int16", 11, 11, 1): 11,
        ("int16", "int16", 12, 11, 1): 6,
        ("int16", "int16", 13, 11, 1): 13,
        ("int16", "int16", 14, 11, 1): 7,
        ("int16", "int16", 15, 11, 1): 15,
        ("int16", "int16", 16, 11, 1): 8,
        ("int16", "int16", 1, 12, 1): 1,
        ("int16", "int16", 2, 12, 1): 1,
        ("int16", "int16", 3, 12, 1): 3,
        ("int16", "int16", 4, 12, 1): 1,
        ("int16", "int16", 5, 12, 1): 5,
        ("int16", "int16", 6, 12, 1): 3,
        ("int16", "int16", 7, 12, 1): 7,
        ("int16", "int16", 8, 12, 1): 1,
        ("int16", "int16", 9, 12, 1): 9,
        ("int16", "int16", 10, 12, 1): 5,
        ("int16", "int16", 11, 12, 1): 11,
        ("int16", "int16", 12, 12, 1): 3,
        ("int16", "int16", 13, 12, 1): 13,
        ("int16", "int16", 14, 12, 1): 7,
        ("int16", "int16", 15, 12, 1): 15,
        ("int16", "int16", 16, 12, 1): 2,
        ("int16", "int16", 1, 13, 1): 1,
        ("int16", "int16", 2, 13, 1): 1,
        ("int16", "int16", 3, 13, 1): 3,
        ("int16", "int16", 4, 13, 1): 2,
        ("int16", "int16", 5, 13, 1): 5,
        ("int16", "int16", 6, 13, 1): 3,
        ("int16", "int16", 7, 13, 1): 7,
        ("int16", "int16", 8, 13, 1): 4,
        ("int16", "int16", 9, 13, 1): 9,
        ("int16", "int16", 10, 13, 1): 5,
        ("int16", "int16", 11, 13, 1): 11,
        ("int16", "int16", 12, 13, 1): 6,
        ("int16", "int16", 13, 13, 1): 13,
        ("int16", "int16", 14, 13, 1): 7,
        ("int16", "int16", 15, 13, 1): 15,
        ("int16", "int16", 16, 13, 1): 8,
        ("int16", "int16", 1, 14, 1): 1,
        ("int16", "int16", 2, 14, 1): 1,
        ("int16", "int16", 3, 14, 1): 3,
        ("int16", "int16", 4, 14, 1): 1,
        ("int16", "int16", 5, 14, 1): 5,
        ("int16", "int16", 6, 14, 1): 3,
        ("int16", "int16", 7, 14, 1): 7,
        ("int16", "int16", 8, 14, 1): 2,
        ("int16", "int16", 9, 14, 1): 9,
        ("int16", "int16", 10, 14, 1): 5,
        ("int16", "int16", 11, 14, 1): 11,
        ("int16", "int16", 12, 14, 1): 3,
        ("int16", "int16", 13, 14, 1): 13,
        ("int16", "int16", 14, 14, 1): 7,
        ("int16", "int16", 15, 14, 1): 15,
        ("int16", "int16", 16, 14, 1): 4,
        ("int16", "int16", 1, 15, 1): 1,
        ("int16", "int16", 2, 15, 1): 1,
        ("int16", "int16", 3, 15, 1): 3,
        ("int16", "int16", 4, 15, 1): 2,
        ("int16", "int16", 5, 15, 1): 5,
        ("int16", "int16", 6, 15, 1): 3,
        ("int16", "int16", 7, 15, 1): 7,
        ("int16", "int16", 8, 15, 1): 4,
        ("int16", "int16", 9, 15, 1): 9,
        ("int16", "int16", 10, 15, 1): 5,
        ("int16", "int16", 11, 15, 1): 11,
        ("int16", "int16", 12, 15, 1): 6,
        ("int16", "int16", 13, 15, 1): 13,
        ("int16", "int16", 14, 15, 1): 7,
        ("int16", "int16", 15, 15, 1): 15,
        ("int16", "int16", 16, 15, 1): 8,
        ("int16", "int16", 1, 16, 1): 1,
        ("int16", "int16", 2, 16, 1): 1,
        ("int16", "int16", 3, 16, 1): 3,
        ("int16", "int16", 4, 16, 1): 1,
        ("int16", "int16", 5, 16, 1): 5,
        ("int16", "int16", 6, 16, 1): 3,
        ("int16", "int16", 7, 16, 1): 7,
        ("int16", "int16", 8, 16, 1): 1,
        ("int16", "int16", 9, 16, 1): 9,
        ("int16", "int16", 10, 16, 1): 5,
        ("int16", "int16", 11, 16, 1): 11,
        ("int16", "int16", 12, 16, 1): 3,
        ("int16", "int16", 13, 16, 1): 13,
        ("int16", "int16", 14, 16, 1): 7,
        ("int16", "int16", 15, 16, 1): 15,
        ("int16", "int16", 16, 16, 1): 1,
        ("cint16", "int16", 1, 1, 0): 1,
        ("cint16", "int16", 2, 1, 0): 1,
        ("cint16", "int16", 3, 1, 0): 3,
        ("cint16", "int16", 4, 1, 0): 1,
        ("cint16", "int16", 5, 1, 0): 5,
        ("cint16", "int16", 6, 1, 0): 3,
        ("cint16", "int16", 7, 1, 0): 7,
        ("cint16", "int16", 8, 1, 0): 2,
        ("cint16", "int16", 9, 1, 0): 9,
        ("cint16", "int16", 10, 1, 0): 5,
        ("cint16", "int16", 11, 1, 0): 11,
        ("cint16", "int16", 12, 1, 0): 3,
        ("cint16", "int16", 13, 1, 0): 13,
        ("cint16", "int16", 14, 1, 0): 7,
        ("cint16", "int16", 15, 1, 0): 15,
        ("cint16", "int16", 16, 1, 0): 4,
        ("cint16", "int16", 1, 2, 0): 1,
        ("cint16", "int16", 2, 2, 0): 1,
        ("cint16", "int16", 3, 2, 0): 3,
        ("cint16", "int16", 4, 2, 0): 1,
        ("cint16", "int16", 5, 2, 0): 5,
        ("cint16", "int16", 6, 2, 0): 3,
        ("cint16", "int16", 7, 2, 0): 7,
        ("cint16", "int16", 8, 2, 0): 1,
        ("cint16", "int16", 9, 2, 0): 9,
        ("cint16", "int16", 10, 2, 0): 5,
        ("cint16", "int16", 11, 2, 0): 11,
        ("cint16", "int16", 12, 2, 0): 3,
        ("cint16", "int16", 13, 2, 0): 13,
        ("cint16", "int16", 14, 2, 0): 7,
        ("cint16", "int16", 15, 2, 0): 15,
        ("cint16", "int16", 16, 2, 0): 2,
        ("cint16", "int16", 1, 3, 0): 1,
        ("cint16", "int16", 2, 3, 0): 1,
        ("cint16", "int16", 3, 3, 0): 3,
        ("cint16", "int16", 4, 3, 0): 1,
        ("cint16", "int16", 5, 3, 0): 5,
        ("cint16", "int16", 6, 3, 0): 3,
        ("cint16", "int16", 7, 3, 0): 7,
        ("cint16", "int16", 8, 3, 0): 2,
        ("cint16", "int16", 9, 3, 0): 9,
        ("cint16", "int16", 10, 3, 0): 5,
        ("cint16", "int16", 11, 3, 0): 11,
        ("cint16", "int16", 12, 3, 0): 3,
        ("cint16", "int16", 13, 3, 0): 13,
        ("cint16", "int16", 14, 3, 0): 7,
        ("cint16", "int16", 15, 3, 0): 15,
        ("cint16", "int16", 16, 3, 0): 4,
        ("cint16", "int16", 1, 4, 0): 1,
        ("cint16", "int16", 2, 4, 0): 1,
        ("cint16", "int16", 3, 4, 0): 3,
        ("cint16", "int16", 4, 4, 0): 1,
        ("cint16", "int16", 5, 4, 0): 5,
        ("cint16", "int16", 6, 4, 0): 3,
        ("cint16", "int16", 7, 4, 0): 7,
        ("cint16", "int16", 8, 4, 0): 1,
        ("cint16", "int16", 9, 4, 0): 9,
        ("cint16", "int16", 10, 4, 0): 5,
        ("cint16", "int16", 11, 4, 0): 11,
        ("cint16", "int16", 12, 4, 0): 3,
        ("cint16", "int16", 13, 4, 0): 13,
        ("cint16", "int16", 14, 4, 0): 7,
        ("cint16", "int16", 15, 4, 0): 15,
        ("cint16", "int16", 16, 4, 0): 1,
        ("cint16", "int16", 1, 5, 0): 1,
        ("cint16", "int16", 2, 5, 0): 1,
        ("cint16", "int16", 3, 5, 0): 3,
        ("cint16", "int16", 4, 5, 0): 1,
        ("cint16", "int16", 5, 5, 0): 5,
        ("cint16", "int16", 6, 5, 0): 3,
        ("cint16", "int16", 7, 5, 0): 7,
        ("cint16", "int16", 8, 5, 0): 2,
        ("cint16", "int16", 9, 5, 0): 9,
        ("cint16", "int16", 10, 5, 0): 5,
        ("cint16", "int16", 11, 5, 0): 11,
        ("cint16", "int16", 12, 5, 0): 3,
        ("cint16", "int16", 13, 5, 0): 13,
        ("cint16", "int16", 14, 5, 0): 7,
        ("cint16", "int16", 15, 5, 0): 15,
        ("cint16", "int16", 16, 5, 0): 4,
        ("cint16", "int16", 1, 6, 0): 1,
        ("cint16", "int16", 2, 6, 0): 1,
        ("cint16", "int16", 3, 6, 0): 3,
        ("cint16", "int16", 4, 6, 0): 1,
        ("cint16", "int16", 5, 6, 0): 5,
        ("cint16", "int16", 6, 6, 0): 3,
        ("cint16", "int16", 7, 6, 0): 7,
        ("cint16", "int16", 8, 6, 0): 1,
        ("cint16", "int16", 9, 6, 0): 9,
        ("cint16", "int16", 10, 6, 0): 5,
        ("cint16", "int16", 11, 6, 0): 11,
        ("cint16", "int16", 12, 6, 0): 3,
        ("cint16", "int16", 13, 6, 0): 13,
        ("cint16", "int16", 14, 6, 0): 7,
        ("cint16", "int16", 15, 6, 0): 15,
        ("cint16", "int16", 16, 6, 0): 2,
        ("cint16", "int16", 1, 7, 0): 1,
        ("cint16", "int16", 2, 7, 0): 1,
        ("cint16", "int16", 3, 7, 0): 3,
        ("cint16", "int16", 4, 7, 0): 1,
        ("cint16", "int16", 5, 7, 0): 5,
        ("cint16", "int16", 6, 7, 0): 3,
        ("cint16", "int16", 7, 7, 0): 7,
        ("cint16", "int16", 8, 7, 0): 2,
        ("cint16", "int16", 9, 7, 0): 9,
        ("cint16", "int16", 10, 7, 0): 5,
        ("cint16", "int16", 11, 7, 0): 11,
        ("cint16", "int16", 12, 7, 0): 3,
        ("cint16", "int16", 13, 7, 0): 13,
        ("cint16", "int16", 14, 7, 0): 7,
        ("cint16", "int16", 15, 7, 0): 15,
        ("cint16", "int16", 16, 7, 0): 4,
        ("cint16", "int16", 1, 8, 0): 1,
        ("cint16", "int16", 2, 8, 0): 1,
        ("cint16", "int16", 3, 8, 0): 3,
        ("cint16", "int16", 4, 8, 0): 1,
        ("cint16", "int16", 5, 8, 0): 5,
        ("cint16", "int16", 6, 8, 0): 3,
        ("cint16", "int16", 7, 8, 0): 7,
        ("cint16", "int16", 8, 8, 0): 1,
        ("cint16", "int16", 9, 8, 0): 9,
        ("cint16", "int16", 10, 8, 0): 5,
        ("cint16", "int16", 11, 8, 0): 11,
        ("cint16", "int16", 12, 8, 0): 3,
        ("cint16", "int16", 13, 8, 0): 13,
        ("cint16", "int16", 14, 8, 0): 7,
        ("cint16", "int16", 15, 8, 0): 15,
        ("cint16", "int16", 16, 8, 0): 1,
        ("cint16", "int16", 1, 9, 0): 1,
        ("cint16", "int16", 2, 9, 0): 1,
        ("cint16", "int16", 3, 9, 0): 3,
        ("cint16", "int16", 4, 9, 0): 1,
        ("cint16", "int16", 5, 9, 0): 5,
        ("cint16", "int16", 6, 9, 0): 3,
        ("cint16", "int16", 7, 9, 0): 7,
        ("cint16", "int16", 8, 9, 0): 2,
        ("cint16", "int16", 9, 9, 0): 9,
        ("cint16", "int16", 10, 9, 0): 5,
        ("cint16", "int16", 11, 9, 0): 11,
        ("cint16", "int16", 12, 9, 0): 3,
        ("cint16", "int16", 13, 9, 0): 13,
        ("cint16", "int16", 14, 9, 0): 7,
        ("cint16", "int16", 15, 9, 0): 15,
        ("cint16", "int16", 16, 9, 0): 4,
        ("cint16", "int16", 1, 10, 0): 1,
        ("cint16", "int16", 2, 10, 0): 1,
        ("cint16", "int16", 3, 10, 0): 3,
        ("cint16", "int16", 4, 10, 0): 1,
        ("cint16", "int16", 5, 10, 0): 5,
        ("cint16", "int16", 6, 10, 0): 3,
        ("cint16", "int16", 7, 10, 0): 7,
        ("cint16", "int16", 8, 10, 0): 1,
        ("cint16", "int16", 9, 10, 0): 9,
        ("cint16", "int16", 10, 10, 0): 5,
        ("cint16", "int16", 11, 10, 0): 11,
        ("cint16", "int16", 12, 10, 0): 3,
        ("cint16", "int16", 13, 10, 0): 13,
        ("cint16", "int16", 14, 10, 0): 7,
        ("cint16", "int16", 15, 10, 0): 15,
        ("cint16", "int16", 16, 10, 0): 2,
        ("cint16", "int16", 1, 11, 0): 1,
        ("cint16", "int16", 2, 11, 0): 1,
        ("cint16", "int16", 3, 11, 0): 3,
        ("cint16", "int16", 4, 11, 0): 1,
        ("cint16", "int16", 5, 11, 0): 5,
        ("cint16", "int16", 6, 11, 0): 3,
        ("cint16", "int16", 7, 11, 0): 7,
        ("cint16", "int16", 8, 11, 0): 2,
        ("cint16", "int16", 9, 11, 0): 9,
        ("cint16", "int16", 10, 11, 0): 5,
        ("cint16", "int16", 11, 11, 0): 11,
        ("cint16", "int16", 12, 11, 0): 3,
        ("cint16", "int16", 13, 11, 0): 13,
        ("cint16", "int16", 14, 11, 0): 7,
        ("cint16", "int16", 15, 11, 0): 15,
        ("cint16", "int16", 16, 11, 0): 4,
        ("cint16", "int16", 1, 12, 0): 1,
        ("cint16", "int16", 2, 12, 0): 1,
        ("cint16", "int16", 3, 12, 0): 3,
        ("cint16", "int16", 4, 12, 0): 1,
        ("cint16", "int16", 5, 12, 0): 5,
        ("cint16", "int16", 6, 12, 0): 3,
        ("cint16", "int16", 7, 12, 0): 7,
        ("cint16", "int16", 8, 12, 0): 1,
        ("cint16", "int16", 9, 12, 0): 9,
        ("cint16", "int16", 10, 12, 0): 5,
        ("cint16", "int16", 11, 12, 0): 11,
        ("cint16", "int16", 12, 12, 0): 3,
        ("cint16", "int16", 13, 12, 0): 13,
        ("cint16", "int16", 14, 12, 0): 7,
        ("cint16", "int16", 15, 12, 0): 15,
        ("cint16", "int16", 16, 12, 0): 1,
        ("cint16", "int16", 1, 13, 0): 1,
        ("cint16", "int16", 2, 13, 0): 1,
        ("cint16", "int16", 3, 13, 0): 3,
        ("cint16", "int16", 4, 13, 0): 1,
        ("cint16", "int16", 5, 13, 0): 5,
        ("cint16", "int16", 6, 13, 0): 3,
        ("cint16", "int16", 7, 13, 0): 7,
        ("cint16", "int16", 8, 13, 0): 2,
        ("cint16", "int16", 9, 13, 0): 9,
        ("cint16", "int16", 10, 13, 0): 5,
        ("cint16", "int16", 11, 13, 0): 11,
        ("cint16", "int16", 12, 13, 0): 3,
        ("cint16", "int16", 13, 13, 0): 13,
        ("cint16", "int16", 14, 13, 0): 7,
        ("cint16", "int16", 15, 13, 0): 15,
        ("cint16", "int16", 16, 13, 0): 4,
        ("cint16", "int16", 1, 14, 0): 1,
        ("cint16", "int16", 2, 14, 0): 1,
        ("cint16", "int16", 3, 14, 0): 3,
        ("cint16", "int16", 4, 14, 0): 1,
        ("cint16", "int16", 5, 14, 0): 5,
        ("cint16", "int16", 6, 14, 0): 3,
        ("cint16", "int16", 7, 14, 0): 7,
        ("cint16", "int16", 8, 14, 0): 1,
        ("cint16", "int16", 9, 14, 0): 9,
        ("cint16", "int16", 10, 14, 0): 5,
        ("cint16", "int16", 11, 14, 0): 11,
        ("cint16", "int16", 12, 14, 0): 3,
        ("cint16", "int16", 13, 14, 0): 13,
        ("cint16", "int16", 14, 14, 0): 7,
        ("cint16", "int16", 15, 14, 0): 15,
        ("cint16", "int16", 16, 14, 0): 2,
        ("cint16", "int16", 1, 15, 0): 1,
        ("cint16", "int16", 2, 15, 0): 1,
        ("cint16", "int16", 3, 15, 0): 3,
        ("cint16", "int16", 4, 15, 0): 1,
        ("cint16", "int16", 5, 15, 0): 5,
        ("cint16", "int16", 6, 15, 0): 3,
        ("cint16", "int16", 7, 15, 0): 7,
        ("cint16", "int16", 8, 15, 0): 2,
        ("cint16", "int16", 9, 15, 0): 9,
        ("cint16", "int16", 10, 15, 0): 5,
        ("cint16", "int16", 11, 15, 0): 11,
        ("cint16", "int16", 12, 15, 0): 3,
        ("cint16", "int16", 13, 15, 0): 13,
        ("cint16", "int16", 14, 15, 0): 7,
        ("cint16", "int16", 15, 15, 0): 15,
        ("cint16", "int16", 16, 15, 0): 4,
        ("cint16", "int16", 1, 16, 0): 1,
        ("cint16", "int16", 2, 16, 0): 1,
        ("cint16", "int16", 3, 16, 0): 3,
        ("cint16", "int16", 4, 16, 0): 1,
        ("cint16", "int16", 5, 16, 0): 5,
        ("cint16", "int16", 6, 16, 0): 3,
        ("cint16", "int16", 7, 16, 0): 7,
        ("cint16", "int16", 8, 16, 0): 1,
        ("cint16", "int16", 9, 16, 0): 9,
        ("cint16", "int16", 10, 16, 0): 5,
        ("cint16", "int16", 11, 16, 0): 11,
        ("cint16", "int16", 12, 16, 0): 3,
        ("cint16", "int16", 13, 16, 0): 13,
        ("cint16", "int16", 14, 16, 0): 7,
        ("cint16", "int16", 15, 16, 0): 15,
        ("cint16", "int16", 16, 16, 0): 1,
        ("cint16", "int16", 1, 1, 1): 1,
        ("cint16", "int16", 2, 1, 1): 1,
        ("cint16", "int16", 3, 1, 1): 3,
        ("cint16", "int16", 4, 1, 1): 2,
        ("cint16", "int16", 5, 1, 1): 5,
        ("cint16", "int16", 6, 1, 1): 3,
        ("cint16", "int16", 7, 1, 1): 7,
        ("cint16", "int16", 8, 1, 1): 4,
        ("cint16", "int16", 9, 1, 1): 9,
        ("cint16", "int16", 10, 1, 1): 5,
        ("cint16", "int16", 11, 1, 1): 11,
        ("cint16", "int16", 12, 1, 1): 6,
        ("cint16", "int16", 13, 1, 1): 13,
        ("cint16", "int16", 14, 1, 1): 7,
        ("cint16", "int16", 15, 1, 1): 15,
        ("cint16", "int16", 16, 1, 1): 8,
        ("cint16", "int16", 1, 2, 1): 1,
        ("cint16", "int16", 2, 2, 1): 1,
        ("cint16", "int16", 3, 2, 1): 3,
        ("cint16", "int16", 4, 2, 1): 1,
        ("cint16", "int16", 5, 2, 1): 5,
        ("cint16", "int16", 6, 2, 1): 3,
        ("cint16", "int16", 7, 2, 1): 7,
        ("cint16", "int16", 8, 2, 1): 2,
        ("cint16", "int16", 9, 2, 1): 9,
        ("cint16", "int16", 10, 2, 1): 5,
        ("cint16", "int16", 11, 2, 1): 11,
        ("cint16", "int16", 12, 2, 1): 3,
        ("cint16", "int16", 13, 2, 1): 13,
        ("cint16", "int16", 14, 2, 1): 7,
        ("cint16", "int16", 15, 2, 1): 15,
        ("cint16", "int16", 16, 2, 1): 4,
        ("cint16", "int16", 1, 3, 1): 1,
        ("cint16", "int16", 2, 3, 1): 1,
        ("cint16", "int16", 3, 3, 1): 3,
        ("cint16", "int16", 4, 3, 1): 2,
        ("cint16", "int16", 5, 3, 1): 5,
        ("cint16", "int16", 6, 3, 1): 3,
        ("cint16", "int16", 7, 3, 1): 7,
        ("cint16", "int16", 8, 3, 1): 4,
        ("cint16", "int16", 9, 3, 1): 9,
        ("cint16", "int16", 10, 3, 1): 5,
        ("cint16", "int16", 11, 3, 1): 11,
        ("cint16", "int16", 12, 3, 1): 6,
        ("cint16", "int16", 13, 3, 1): 13,
        ("cint16", "int16", 14, 3, 1): 7,
        ("cint16", "int16", 15, 3, 1): 15,
        ("cint16", "int16", 16, 3, 1): 8,
        ("cint16", "int16", 1, 4, 1): 1,
        ("cint16", "int16", 2, 4, 1): 1,
        ("cint16", "int16", 3, 4, 1): 3,
        ("cint16", "int16", 4, 4, 1): 1,
        ("cint16", "int16", 5, 4, 1): 5,
        ("cint16", "int16", 6, 4, 1): 3,
        ("cint16", "int16", 7, 4, 1): 7,
        ("cint16", "int16", 8, 4, 1): 1,
        ("cint16", "int16", 9, 4, 1): 9,
        ("cint16", "int16", 10, 4, 1): 5,
        ("cint16", "int16", 11, 4, 1): 11,
        ("cint16", "int16", 12, 4, 1): 3,
        ("cint16", "int16", 13, 4, 1): 13,
        ("cint16", "int16", 14, 4, 1): 7,
        ("cint16", "int16", 15, 4, 1): 15,
        ("cint16", "int16", 16, 4, 1): 2,
        ("cint16", "int16", 1, 5, 1): 1,
        ("cint16", "int16", 2, 5, 1): 1,
        ("cint16", "int16", 3, 5, 1): 3,
        ("cint16", "int16", 4, 5, 1): 2,
        ("cint16", "int16", 5, 5, 1): 5,
        ("cint16", "int16", 6, 5, 1): 3,
        ("cint16", "int16", 7, 5, 1): 7,
        ("cint16", "int16", 8, 5, 1): 4,
        ("cint16", "int16", 9, 5, 1): 9,
        ("cint16", "int16", 10, 5, 1): 5,
        ("cint16", "int16", 11, 5, 1): 11,
        ("cint16", "int16", 12, 5, 1): 6,
        ("cint16", "int16", 13, 5, 1): 13,
        ("cint16", "int16", 14, 5, 1): 7,
        ("cint16", "int16", 15, 5, 1): 15,
        ("cint16", "int16", 16, 5, 1): 8,
        ("cint16", "int16", 1, 6, 1): 1,
        ("cint16", "int16", 2, 6, 1): 1,
        ("cint16", "int16", 3, 6, 1): 3,
        ("cint16", "int16", 4, 6, 1): 1,
        ("cint16", "int16", 5, 6, 1): 5,
        ("cint16", "int16", 6, 6, 1): 3,
        ("cint16", "int16", 7, 6, 1): 7,
        ("cint16", "int16", 8, 6, 1): 2,
        ("cint16", "int16", 9, 6, 1): 9,
        ("cint16", "int16", 10, 6, 1): 5,
        ("cint16", "int16", 11, 6, 1): 11,
        ("cint16", "int16", 12, 6, 1): 3,
        ("cint16", "int16", 13, 6, 1): 13,
        ("cint16", "int16", 14, 6, 1): 7,
        ("cint16", "int16", 15, 6, 1): 15,
        ("cint16", "int16", 16, 6, 1): 4,
        ("cint16", "int16", 1, 7, 1): 1,
        ("cint16", "int16", 2, 7, 1): 1,
        ("cint16", "int16", 3, 7, 1): 3,
        ("cint16", "int16", 4, 7, 1): 2,
        ("cint16", "int16", 5, 7, 1): 5,
        ("cint16", "int16", 6, 7, 1): 3,
        ("cint16", "int16", 7, 7, 1): 7,
        ("cint16", "int16", 8, 7, 1): 4,
        ("cint16", "int16", 9, 7, 1): 9,
        ("cint16", "int16", 10, 7, 1): 5,
        ("cint16", "int16", 11, 7, 1): 11,
        ("cint16", "int16", 12, 7, 1): 6,
        ("cint16", "int16", 13, 7, 1): 13,
        ("cint16", "int16", 14, 7, 1): 7,
        ("cint16", "int16", 15, 7, 1): 15,
        ("cint16", "int16", 16, 7, 1): 8,
        ("cint16", "int16", 1, 8, 1): 1,
        ("cint16", "int16", 2, 8, 1): 1,
        ("cint16", "int16", 3, 8, 1): 3,
        ("cint16", "int16", 4, 8, 1): 1,
        ("cint16", "int16", 5, 8, 1): 5,
        ("cint16", "int16", 6, 8, 1): 3,
        ("cint16", "int16", 7, 8, 1): 7,
        ("cint16", "int16", 8, 8, 1): 1,
        ("cint16", "int16", 9, 8, 1): 9,
        ("cint16", "int16", 10, 8, 1): 5,
        ("cint16", "int16", 11, 8, 1): 11,
        ("cint16", "int16", 12, 8, 1): 3,
        ("cint16", "int16", 13, 8, 1): 13,
        ("cint16", "int16", 14, 8, 1): 7,
        ("cint16", "int16", 15, 8, 1): 15,
        ("cint16", "int16", 16, 8, 1): 2,
        ("cint16", "int16", 1, 9, 1): 1,
        ("cint16", "int16", 2, 9, 1): 1,
        ("cint16", "int16", 3, 9, 1): 3,
        ("cint16", "int16", 4, 9, 1): 2,
        ("cint16", "int16", 5, 9, 1): 5,
        ("cint16", "int16", 6, 9, 1): 3,
        ("cint16", "int16", 7, 9, 1): 7,
        ("cint16", "int16", 8, 9, 1): 4,
        ("cint16", "int16", 9, 9, 1): 9,
        ("cint16", "int16", 10, 9, 1): 5,
        ("cint16", "int16", 11, 9, 1): 11,
        ("cint16", "int16", 12, 9, 1): 6,
        ("cint16", "int16", 13, 9, 1): 13,
        ("cint16", "int16", 14, 9, 1): 7,
        ("cint16", "int16", 15, 9, 1): 15,
        ("cint16", "int16", 16, 9, 1): 8,
        ("cint16", "int16", 1, 10, 1): 1,
        ("cint16", "int16", 2, 10, 1): 1,
        ("cint16", "int16", 3, 10, 1): 3,
        ("cint16", "int16", 4, 10, 1): 1,
        ("cint16", "int16", 5, 10, 1): 5,
        ("cint16", "int16", 6, 10, 1): 3,
        ("cint16", "int16", 7, 10, 1): 7,
        ("cint16", "int16", 8, 10, 1): 2,
        ("cint16", "int16", 9, 10, 1): 9,
        ("cint16", "int16", 10, 10, 1): 5,
        ("cint16", "int16", 11, 10, 1): 11,
        ("cint16", "int16", 12, 10, 1): 3,
        ("cint16", "int16", 13, 10, 1): 13,
        ("cint16", "int16", 14, 10, 1): 7,
        ("cint16", "int16", 15, 10, 1): 15,
        ("cint16", "int16", 16, 10, 1): 4,
        ("cint16", "int16", 1, 11, 1): 1,
        ("cint16", "int16", 2, 11, 1): 1,
        ("cint16", "int16", 3, 11, 1): 3,
        ("cint16", "int16", 4, 11, 1): 2,
        ("cint16", "int16", 5, 11, 1): 5,
        ("cint16", "int16", 6, 11, 1): 3,
        ("cint16", "int16", 7, 11, 1): 7,
        ("cint16", "int16", 8, 11, 1): 4,
        ("cint16", "int16", 9, 11, 1): 9,
        ("cint16", "int16", 10, 11, 1): 5,
        ("cint16", "int16", 11, 11, 1): 11,
        ("cint16", "int16", 12, 11, 1): 6,
        ("cint16", "int16", 13, 11, 1): 13,
        ("cint16", "int16", 14, 11, 1): 7,
        ("cint16", "int16", 15, 11, 1): 15,
        ("cint16", "int16", 16, 11, 1): 8,
        ("cint16", "int16", 1, 12, 1): 1,
        ("cint16", "int16", 2, 12, 1): 1,
        ("cint16", "int16", 3, 12, 1): 3,
        ("cint16", "int16", 4, 12, 1): 1,
        ("cint16", "int16", 5, 12, 1): 5,
        ("cint16", "int16", 6, 12, 1): 3,
        ("cint16", "int16", 7, 12, 1): 7,
        ("cint16", "int16", 8, 12, 1): 1,
        ("cint16", "int16", 9, 12, 1): 9,
        ("cint16", "int16", 10, 12, 1): 5,
        ("cint16", "int16", 11, 12, 1): 11,
        ("cint16", "int16", 12, 12, 1): 3,
        ("cint16", "int16", 13, 12, 1): 13,
        ("cint16", "int16", 14, 12, 1): 7,
        ("cint16", "int16", 15, 12, 1): 15,
        ("cint16", "int16", 16, 12, 1): 2,
        ("cint16", "int16", 1, 13, 1): 1,
        ("cint16", "int16", 2, 13, 1): 1,
        ("cint16", "int16", 3, 13, 1): 3,
        ("cint16", "int16", 4, 13, 1): 2,
        ("cint16", "int16", 5, 13, 1): 5,
        ("cint16", "int16", 6, 13, 1): 3,
        ("cint16", "int16", 7, 13, 1): 7,
        ("cint16", "int16", 8, 13, 1): 4,
        ("cint16", "int16", 9, 13, 1): 9,
        ("cint16", "int16", 10, 13, 1): 5,
        ("cint16", "int16", 11, 13, 1): 11,
        ("cint16", "int16", 12, 13, 1): 6,
        ("cint16", "int16", 13, 13, 1): 13,
        ("cint16", "int16", 14, 13, 1): 7,
        ("cint16", "int16", 15, 13, 1): 15,
        ("cint16", "int16", 16, 13, 1): 8,
        ("cint16", "int16", 1, 14, 1): 1,
        ("cint16", "int16", 2, 14, 1): 1,
        ("cint16", "int16", 3, 14, 1): 3,
        ("cint16", "int16", 4, 14, 1): 1,
        ("cint16", "int16", 5, 14, 1): 5,
        ("cint16", "int16", 6, 14, 1): 3,
        ("cint16", "int16", 7, 14, 1): 7,
        ("cint16", "int16", 8, 14, 1): 2,
        ("cint16", "int16", 9, 14, 1): 9,
        ("cint16", "int16", 10, 14, 1): 5,
        ("cint16", "int16", 11, 14, 1): 11,
        ("cint16", "int16", 12, 14, 1): 3,
        ("cint16", "int16", 13, 14, 1): 13,
        ("cint16", "int16", 14, 14, 1): 7,
        ("cint16", "int16", 15, 14, 1): 15,
        ("cint16", "int16", 16, 14, 1): 4,
        ("cint16", "int16", 1, 15, 1): 1,
        ("cint16", "int16", 2, 15, 1): 1,
        ("cint16", "int16", 3, 15, 1): 3,
        ("cint16", "int16", 4, 15, 1): 2,
        ("cint16", "int16", 5, 15, 1): 5,
        ("cint16", "int16", 6, 15, 1): 3,
        ("cint16", "int16", 7, 15, 1): 7,
        ("cint16", "int16", 8, 15, 1): 4,
        ("cint16", "int16", 9, 15, 1): 9,
        ("cint16", "int16", 10, 15, 1): 5,
        ("cint16", "int16", 11, 15, 1): 11,
        ("cint16", "int16", 12, 15, 1): 6,
        ("cint16", "int16", 13, 15, 1): 13,
        ("cint16", "int16", 14, 15, 1): 7,
        ("cint16", "int16", 15, 15, 1): 15,
        ("cint16", "int16", 16, 15, 1): 8,
        ("cint16", "int16", 1, 16, 1): 1,
        ("cint16", "int16", 2, 16, 1): 1,
        ("cint16", "int16", 3, 16, 1): 3,
        ("cint16", "int16", 4, 16, 1): 1,
        ("cint16", "int16", 5, 16, 1): 5,
        ("cint16", "int16", 6, 16, 1): 3,
        ("cint16", "int16", 7, 16, 1): 7,
        ("cint16", "int16", 8, 16, 1): 1,
        ("cint16", "int16", 9, 16, 1): 9,
        ("cint16", "int16", 10, 16, 1): 5,
        ("cint16", "int16", 11, 16, 1): 11,
        ("cint16", "int16", 12, 16, 1): 3,
        ("cint16", "int16", 13, 16, 1): 13,
        ("cint16", "int16", 14, 16, 1): 7,
        ("cint16", "int16", 15, 16, 1): 15,
        ("cint16", "int16", 16, 16, 1): 2,
        ("cint16", "cint16", 1, 1, 0): 1,
        ("cint16", "cint16", 2, 1, 0): 1,
        ("cint16", "cint16", 3, 1, 0): 3,
        ("cint16", "cint16", 4, 1, 0): 1,
        ("cint16", "cint16", 5, 1, 0): 5,
        ("cint16", "cint16", 6, 1, 0): 3,
        ("cint16", "cint16", 7, 1, 0): 7,
        ("cint16", "cint16", 8, 1, 0): 2,
        ("cint16", "cint16", 9, 1, 0): 9,
        ("cint16", "cint16", 10, 1, 0): 5,
        ("cint16", "cint16", 11, 1, 0): 11,
        ("cint16", "cint16", 12, 1, 0): 3,
        ("cint16", "cint16", 13, 1, 0): 13,
        ("cint16", "cint16", 14, 1, 0): 7,
        ("cint16", "cint16", 15, 1, 0): 15,
        ("cint16", "cint16", 16, 1, 0): 4,
        ("cint16", "cint16", 1, 2, 0): 1,
        ("cint16", "cint16", 2, 2, 0): 1,
        ("cint16", "cint16", 3, 2, 0): 3,
        ("cint16", "cint16", 4, 2, 0): 1,
        ("cint16", "cint16", 5, 2, 0): 5,
        ("cint16", "cint16", 6, 2, 0): 3,
        ("cint16", "cint16", 7, 2, 0): 7,
        ("cint16", "cint16", 8, 2, 0): 1,
        ("cint16", "cint16", 9, 2, 0): 9,
        ("cint16", "cint16", 10, 2, 0): 5,
        ("cint16", "cint16", 11, 2, 0): 11,
        ("cint16", "cint16", 12, 2, 0): 3,
        ("cint16", "cint16", 13, 2, 0): 13,
        ("cint16", "cint16", 14, 2, 0): 7,
        ("cint16", "cint16", 15, 2, 0): 15,
        ("cint16", "cint16", 16, 2, 0): 2,
        ("cint16", "cint16", 1, 3, 0): 1,
        ("cint16", "cint16", 2, 3, 0): 1,
        ("cint16", "cint16", 3, 3, 0): 3,
        ("cint16", "cint16", 4, 3, 0): 1,
        ("cint16", "cint16", 5, 3, 0): 5,
        ("cint16", "cint16", 6, 3, 0): 3,
        ("cint16", "cint16", 7, 3, 0): 7,
        ("cint16", "cint16", 8, 3, 0): 2,
        ("cint16", "cint16", 9, 3, 0): 9,
        ("cint16", "cint16", 10, 3, 0): 5,
        ("cint16", "cint16", 11, 3, 0): 11,
        ("cint16", "cint16", 12, 3, 0): 3,
        ("cint16", "cint16", 13, 3, 0): 13,
        ("cint16", "cint16", 14, 3, 0): 7,
        ("cint16", "cint16", 15, 3, 0): 15,
        ("cint16", "cint16", 16, 3, 0): 4,
        ("cint16", "cint16", 1, 4, 0): 1,
        ("cint16", "cint16", 2, 4, 0): 1,
        ("cint16", "cint16", 3, 4, 0): 3,
        ("cint16", "cint16", 4, 4, 0): 1,
        ("cint16", "cint16", 5, 4, 0): 5,
        ("cint16", "cint16", 6, 4, 0): 3,
        ("cint16", "cint16", 7, 4, 0): 7,
        ("cint16", "cint16", 8, 4, 0): 1,
        ("cint16", "cint16", 9, 4, 0): 9,
        ("cint16", "cint16", 10, 4, 0): 5,
        ("cint16", "cint16", 11, 4, 0): 11,
        ("cint16", "cint16", 12, 4, 0): 3,
        ("cint16", "cint16", 13, 4, 0): 13,
        ("cint16", "cint16", 14, 4, 0): 7,
        ("cint16", "cint16", 15, 4, 0): 15,
        ("cint16", "cint16", 16, 4, 0): 1,
        ("cint16", "cint16", 1, 5, 0): 1,
        ("cint16", "cint16", 2, 5, 0): 1,
        ("cint16", "cint16", 3, 5, 0): 3,
        ("cint16", "cint16", 4, 5, 0): 1,
        ("cint16", "cint16", 5, 5, 0): 5,
        ("cint16", "cint16", 6, 5, 0): 3,
        ("cint16", "cint16", 7, 5, 0): 7,
        ("cint16", "cint16", 8, 5, 0): 2,
        ("cint16", "cint16", 9, 5, 0): 9,
        ("cint16", "cint16", 10, 5, 0): 5,
        ("cint16", "cint16", 11, 5, 0): 11,
        ("cint16", "cint16", 12, 5, 0): 3,
        ("cint16", "cint16", 13, 5, 0): 13,
        ("cint16", "cint16", 14, 5, 0): 7,
        ("cint16", "cint16", 15, 5, 0): 15,
        ("cint16", "cint16", 16, 5, 0): 4,
        ("cint16", "cint16", 1, 6, 0): 1,
        ("cint16", "cint16", 2, 6, 0): 1,
        ("cint16", "cint16", 3, 6, 0): 3,
        ("cint16", "cint16", 4, 6, 0): 1,
        ("cint16", "cint16", 5, 6, 0): 5,
        ("cint16", "cint16", 6, 6, 0): 3,
        ("cint16", "cint16", 7, 6, 0): 7,
        ("cint16", "cint16", 8, 6, 0): 1,
        ("cint16", "cint16", 9, 6, 0): 9,
        ("cint16", "cint16", 10, 6, 0): 5,
        ("cint16", "cint16", 11, 6, 0): 11,
        ("cint16", "cint16", 12, 6, 0): 3,
        ("cint16", "cint16", 13, 6, 0): 13,
        ("cint16", "cint16", 14, 6, 0): 7,
        ("cint16", "cint16", 15, 6, 0): 15,
        ("cint16", "cint16", 16, 6, 0): 2,
        ("cint16", "cint16", 1, 7, 0): 1,
        ("cint16", "cint16", 2, 7, 0): 1,
        ("cint16", "cint16", 3, 7, 0): 3,
        ("cint16", "cint16", 4, 7, 0): 1,
        ("cint16", "cint16", 5, 7, 0): 5,
        ("cint16", "cint16", 6, 7, 0): 3,
        ("cint16", "cint16", 7, 7, 0): 7,
        ("cint16", "cint16", 8, 7, 0): 2,
        ("cint16", "cint16", 9, 7, 0): 9,
        ("cint16", "cint16", 10, 7, 0): 5,
        ("cint16", "cint16", 11, 7, 0): 11,
        ("cint16", "cint16", 12, 7, 0): 3,
        ("cint16", "cint16", 13, 7, 0): 13,
        ("cint16", "cint16", 14, 7, 0): 7,
        ("cint16", "cint16", 15, 7, 0): 15,
        ("cint16", "cint16", 16, 7, 0): 4,
        ("cint16", "cint16", 1, 8, 0): 1,
        ("cint16", "cint16", 2, 8, 0): 1,
        ("cint16", "cint16", 3, 8, 0): 3,
        ("cint16", "cint16", 4, 8, 0): 1,
        ("cint16", "cint16", 5, 8, 0): 5,
        ("cint16", "cint16", 6, 8, 0): 3,
        ("cint16", "cint16", 7, 8, 0): 7,
        ("cint16", "cint16", 8, 8, 0): 1,
        ("cint16", "cint16", 9, 8, 0): 9,
        ("cint16", "cint16", 10, 8, 0): 5,
        ("cint16", "cint16", 11, 8, 0): 11,
        ("cint16", "cint16", 12, 8, 0): 3,
        ("cint16", "cint16", 13, 8, 0): 13,
        ("cint16", "cint16", 14, 8, 0): 7,
        ("cint16", "cint16", 15, 8, 0): 15,
        ("cint16", "cint16", 16, 8, 0): 1,
        ("cint16", "cint16", 1, 9, 0): 1,
        ("cint16", "cint16", 2, 9, 0): 1,
        ("cint16", "cint16", 3, 9, 0): 3,
        ("cint16", "cint16", 4, 9, 0): 1,
        ("cint16", "cint16", 5, 9, 0): 5,
        ("cint16", "cint16", 6, 9, 0): 3,
        ("cint16", "cint16", 7, 9, 0): 7,
        ("cint16", "cint16", 8, 9, 0): 2,
        ("cint16", "cint16", 9, 9, 0): 9,
        ("cint16", "cint16", 10, 9, 0): 5,
        ("cint16", "cint16", 11, 9, 0): 11,
        ("cint16", "cint16", 12, 9, 0): 3,
        ("cint16", "cint16", 13, 9, 0): 13,
        ("cint16", "cint16", 14, 9, 0): 7,
        ("cint16", "cint16", 15, 9, 0): 15,
        ("cint16", "cint16", 16, 9, 0): 4,
        ("cint16", "cint16", 1, 10, 0): 1,
        ("cint16", "cint16", 2, 10, 0): 1,
        ("cint16", "cint16", 3, 10, 0): 3,
        ("cint16", "cint16", 4, 10, 0): 1,
        ("cint16", "cint16", 5, 10, 0): 5,
        ("cint16", "cint16", 6, 10, 0): 3,
        ("cint16", "cint16", 7, 10, 0): 7,
        ("cint16", "cint16", 8, 10, 0): 1,
        ("cint16", "cint16", 9, 10, 0): 9,
        ("cint16", "cint16", 10, 10, 0): 5,
        ("cint16", "cint16", 11, 10, 0): 11,
        ("cint16", "cint16", 12, 10, 0): 3,
        ("cint16", "cint16", 13, 10, 0): 13,
        ("cint16", "cint16", 14, 10, 0): 7,
        ("cint16", "cint16", 15, 10, 0): 15,
        ("cint16", "cint16", 16, 10, 0): 2,
        ("cint16", "cint16", 1, 11, 0): 1,
        ("cint16", "cint16", 2, 11, 0): 1,
        ("cint16", "cint16", 3, 11, 0): 3,
        ("cint16", "cint16", 4, 11, 0): 1,
        ("cint16", "cint16", 5, 11, 0): 5,
        ("cint16", "cint16", 6, 11, 0): 3,
        ("cint16", "cint16", 7, 11, 0): 7,
        ("cint16", "cint16", 8, 11, 0): 2,
        ("cint16", "cint16", 9, 11, 0): 9,
        ("cint16", "cint16", 10, 11, 0): 5,
        ("cint16", "cint16", 11, 11, 0): 11,
        ("cint16", "cint16", 12, 11, 0): 3,
        ("cint16", "cint16", 13, 11, 0): 13,
        ("cint16", "cint16", 14, 11, 0): 7,
        ("cint16", "cint16", 15, 11, 0): 15,
        ("cint16", "cint16", 16, 11, 0): 4,
        ("cint16", "cint16", 1, 12, 0): 1,
        ("cint16", "cint16", 2, 12, 0): 1,
        ("cint16", "cint16", 3, 12, 0): 3,
        ("cint16", "cint16", 4, 12, 0): 1,
        ("cint16", "cint16", 5, 12, 0): 5,
        ("cint16", "cint16", 6, 12, 0): 3,
        ("cint16", "cint16", 7, 12, 0): 7,
        ("cint16", "cint16", 8, 12, 0): 1,
        ("cint16", "cint16", 9, 12, 0): 9,
        ("cint16", "cint16", 10, 12, 0): 5,
        ("cint16", "cint16", 11, 12, 0): 11,
        ("cint16", "cint16", 12, 12, 0): 3,
        ("cint16", "cint16", 13, 12, 0): 13,
        ("cint16", "cint16", 14, 12, 0): 7,
        ("cint16", "cint16", 15, 12, 0): 15,
        ("cint16", "cint16", 16, 12, 0): 1,
        ("cint16", "cint16", 1, 13, 0): 1,
        ("cint16", "cint16", 2, 13, 0): 1,
        ("cint16", "cint16", 3, 13, 0): 3,
        ("cint16", "cint16", 4, 13, 0): 1,
        ("cint16", "cint16", 5, 13, 0): 5,
        ("cint16", "cint16", 6, 13, 0): 3,
        ("cint16", "cint16", 7, 13, 0): 7,
        ("cint16", "cint16", 8, 13, 0): 2,
        ("cint16", "cint16", 9, 13, 0): 9,
        ("cint16", "cint16", 10, 13, 0): 5,
        ("cint16", "cint16", 11, 13, 0): 11,
        ("cint16", "cint16", 12, 13, 0): 3,
        ("cint16", "cint16", 13, 13, 0): 13,
        ("cint16", "cint16", 14, 13, 0): 7,
        ("cint16", "cint16", 15, 13, 0): 15,
        ("cint16", "cint16", 16, 13, 0): 4,
        ("cint16", "cint16", 1, 14, 0): 1,
        ("cint16", "cint16", 2, 14, 0): 1,
        ("cint16", "cint16", 3, 14, 0): 3,
        ("cint16", "cint16", 4, 14, 0): 1,
        ("cint16", "cint16", 5, 14, 0): 5,
        ("cint16", "cint16", 6, 14, 0): 3,
        ("cint16", "cint16", 7, 14, 0): 7,
        ("cint16", "cint16", 8, 14, 0): 1,
        ("cint16", "cint16", 9, 14, 0): 9,
        ("cint16", "cint16", 10, 14, 0): 5,
        ("cint16", "cint16", 11, 14, 0): 11,
        ("cint16", "cint16", 12, 14, 0): 3,
        ("cint16", "cint16", 13, 14, 0): 13,
        ("cint16", "cint16", 14, 14, 0): 7,
        ("cint16", "cint16", 15, 14, 0): 15,
        ("cint16", "cint16", 16, 14, 0): 2,
        ("cint16", "cint16", 1, 15, 0): 1,
        ("cint16", "cint16", 2, 15, 0): 1,
        ("cint16", "cint16", 3, 15, 0): 3,
        ("cint16", "cint16", 4, 15, 0): 1,
        ("cint16", "cint16", 5, 15, 0): 5,
        ("cint16", "cint16", 6, 15, 0): 3,
        ("cint16", "cint16", 7, 15, 0): 7,
        ("cint16", "cint16", 8, 15, 0): 2,
        ("cint16", "cint16", 9, 15, 0): 9,
        ("cint16", "cint16", 10, 15, 0): 5,
        ("cint16", "cint16", 11, 15, 0): 11,
        ("cint16", "cint16", 12, 15, 0): 3,
        ("cint16", "cint16", 13, 15, 0): 13,
        ("cint16", "cint16", 14, 15, 0): 7,
        ("cint16", "cint16", 15, 15, 0): 15,
        ("cint16", "cint16", 16, 15, 0): 4,
        ("cint16", "cint16", 1, 16, 0): 1,
        ("cint16", "cint16", 2, 16, 0): 1,
        ("cint16", "cint16", 3, 16, 0): 3,
        ("cint16", "cint16", 4, 16, 0): 1,
        ("cint16", "cint16", 5, 16, 0): 5,
        ("cint16", "cint16", 6, 16, 0): 3,
        ("cint16", "cint16", 7, 16, 0): 7,
        ("cint16", "cint16", 8, 16, 0): 1,
        ("cint16", "cint16", 9, 16, 0): 9,
        ("cint16", "cint16", 10, 16, 0): 5,
        ("cint16", "cint16", 11, 16, 0): 11,
        ("cint16", "cint16", 12, 16, 0): 3,
        ("cint16", "cint16", 13, 16, 0): 13,
        ("cint16", "cint16", 14, 16, 0): 7,
        ("cint16", "cint16", 15, 16, 0): 15,
        ("cint16", "cint16", 16, 16, 0): 1,
        ("cint16", "cint16", 1, 1, 1): 1,
        ("cint16", "cint16", 2, 1, 1): 1,
        ("cint16", "cint16", 3, 1, 1): 3,
        ("cint16", "cint16", 4, 1, 1): 2,
        ("cint16", "cint16", 5, 1, 1): 5,
        ("cint16", "cint16", 6, 1, 1): 3,
        ("cint16", "cint16", 7, 1, 1): 7,
        ("cint16", "cint16", 8, 1, 1): 4,
        ("cint16", "cint16", 9, 1, 1): 9,
        ("cint16", "cint16", 10, 1, 1): 5,
        ("cint16", "cint16", 11, 1, 1): 11,
        ("cint16", "cint16", 12, 1, 1): 6,
        ("cint16", "cint16", 13, 1, 1): 13,
        ("cint16", "cint16", 14, 1, 1): 7,
        ("cint16", "cint16", 15, 1, 1): 15,
        ("cint16", "cint16", 16, 1, 1): 8,
        ("cint16", "cint16", 1, 2, 1): 1,
        ("cint16", "cint16", 2, 2, 1): 1,
        ("cint16", "cint16", 3, 2, 1): 3,
        ("cint16", "cint16", 4, 2, 1): 1,
        ("cint16", "cint16", 5, 2, 1): 5,
        ("cint16", "cint16", 6, 2, 1): 3,
        ("cint16", "cint16", 7, 2, 1): 7,
        ("cint16", "cint16", 8, 2, 1): 2,
        ("cint16", "cint16", 9, 2, 1): 9,
        ("cint16", "cint16", 10, 2, 1): 5,
        ("cint16", "cint16", 11, 2, 1): 11,
        ("cint16", "cint16", 12, 2, 1): 3,
        ("cint16", "cint16", 13, 2, 1): 13,
        ("cint16", "cint16", 14, 2, 1): 7,
        ("cint16", "cint16", 15, 2, 1): 15,
        ("cint16", "cint16", 16, 2, 1): 4,
        ("cint16", "cint16", 1, 3, 1): 1,
        ("cint16", "cint16", 2, 3, 1): 1,
        ("cint16", "cint16", 3, 3, 1): 3,
        ("cint16", "cint16", 4, 3, 1): 2,
        ("cint16", "cint16", 5, 3, 1): 5,
        ("cint16", "cint16", 6, 3, 1): 3,
        ("cint16", "cint16", 7, 3, 1): 7,
        ("cint16", "cint16", 8, 3, 1): 4,
        ("cint16", "cint16", 9, 3, 1): 9,
        ("cint16", "cint16", 10, 3, 1): 5,
        ("cint16", "cint16", 11, 3, 1): 11,
        ("cint16", "cint16", 12, 3, 1): 6,
        ("cint16", "cint16", 13, 3, 1): 13,
        ("cint16", "cint16", 14, 3, 1): 7,
        ("cint16", "cint16", 15, 3, 1): 15,
        ("cint16", "cint16", 16, 3, 1): 8,
        ("cint16", "cint16", 1, 4, 1): 1,
        ("cint16", "cint16", 2, 4, 1): 1,
        ("cint16", "cint16", 3, 4, 1): 3,
        ("cint16", "cint16", 4, 4, 1): 1,
        ("cint16", "cint16", 5, 4, 1): 5,
        ("cint16", "cint16", 6, 4, 1): 3,
        ("cint16", "cint16", 7, 4, 1): 7,
        ("cint16", "cint16", 8, 4, 1): 1,
        ("cint16", "cint16", 9, 4, 1): 9,
        ("cint16", "cint16", 10, 4, 1): 5,
        ("cint16", "cint16", 11, 4, 1): 11,
        ("cint16", "cint16", 12, 4, 1): 3,
        ("cint16", "cint16", 13, 4, 1): 13,
        ("cint16", "cint16", 14, 4, 1): 7,
        ("cint16", "cint16", 15, 4, 1): 15,
        ("cint16", "cint16", 16, 4, 1): 2,
        ("cint16", "cint16", 1, 5, 1): 1,
        ("cint16", "cint16", 2, 5, 1): 1,
        ("cint16", "cint16", 3, 5, 1): 3,
        ("cint16", "cint16", 4, 5, 1): 2,
        ("cint16", "cint16", 5, 5, 1): 5,
        ("cint16", "cint16", 6, 5, 1): 3,
        ("cint16", "cint16", 7, 5, 1): 7,
        ("cint16", "cint16", 8, 5, 1): 4,
        ("cint16", "cint16", 9, 5, 1): 9,
        ("cint16", "cint16", 10, 5, 1): 5,
        ("cint16", "cint16", 11, 5, 1): 11,
        ("cint16", "cint16", 12, 5, 1): 6,
        ("cint16", "cint16", 13, 5, 1): 13,
        ("cint16", "cint16", 14, 5, 1): 7,
        ("cint16", "cint16", 15, 5, 1): 15,
        ("cint16", "cint16", 16, 5, 1): 8,
        ("cint16", "cint16", 1, 6, 1): 1,
        ("cint16", "cint16", 2, 6, 1): 1,
        ("cint16", "cint16", 3, 6, 1): 3,
        ("cint16", "cint16", 4, 6, 1): 1,
        ("cint16", "cint16", 5, 6, 1): 5,
        ("cint16", "cint16", 6, 6, 1): 3,
        ("cint16", "cint16", 7, 6, 1): 7,
        ("cint16", "cint16", 8, 6, 1): 2,
        ("cint16", "cint16", 9, 6, 1): 9,
        ("cint16", "cint16", 10, 6, 1): 5,
        ("cint16", "cint16", 11, 6, 1): 11,
        ("cint16", "cint16", 12, 6, 1): 3,
        ("cint16", "cint16", 13, 6, 1): 13,
        ("cint16", "cint16", 14, 6, 1): 7,
        ("cint16", "cint16", 15, 6, 1): 15,
        ("cint16", "cint16", 16, 6, 1): 4,
        ("cint16", "cint16", 1, 7, 1): 1,
        ("cint16", "cint16", 2, 7, 1): 1,
        ("cint16", "cint16", 3, 7, 1): 3,
        ("cint16", "cint16", 4, 7, 1): 2,
        ("cint16", "cint16", 5, 7, 1): 5,
        ("cint16", "cint16", 6, 7, 1): 3,
        ("cint16", "cint16", 7, 7, 1): 7,
        ("cint16", "cint16", 8, 7, 1): 4,
        ("cint16", "cint16", 9, 7, 1): 9,
        ("cint16", "cint16", 10, 7, 1): 5,
        ("cint16", "cint16", 11, 7, 1): 11,
        ("cint16", "cint16", 12, 7, 1): 6,
        ("cint16", "cint16", 13, 7, 1): 13,
        ("cint16", "cint16", 14, 7, 1): 7,
        ("cint16", "cint16", 15, 7, 1): 15,
        ("cint16", "cint16", 16, 7, 1): 8,
        ("cint16", "cint16", 1, 8, 1): 1,
        ("cint16", "cint16", 2, 8, 1): 1,
        ("cint16", "cint16", 3, 8, 1): 3,
        ("cint16", "cint16", 4, 8, 1): 1,
        ("cint16", "cint16", 5, 8, 1): 5,
        ("cint16", "cint16", 6, 8, 1): 3,
        ("cint16", "cint16", 7, 8, 1): 7,
        ("cint16", "cint16", 8, 8, 1): 1,
        ("cint16", "cint16", 9, 8, 1): 9,
        ("cint16", "cint16", 10, 8, 1): 5,
        ("cint16", "cint16", 11, 8, 1): 11,
        ("cint16", "cint16", 12, 8, 1): 3,
        ("cint16", "cint16", 13, 8, 1): 13,
        ("cint16", "cint16", 14, 8, 1): 7,
        ("cint16", "cint16", 15, 8, 1): 15,
        ("cint16", "cint16", 16, 8, 1): 2,
        ("cint16", "cint16", 1, 9, 1): 1,
        ("cint16", "cint16", 2, 9, 1): 1,
        ("cint16", "cint16", 3, 9, 1): 3,
        ("cint16", "cint16", 4, 9, 1): 2,
        ("cint16", "cint16", 5, 9, 1): 5,
        ("cint16", "cint16", 6, 9, 1): 3,
        ("cint16", "cint16", 7, 9, 1): 7,
        ("cint16", "cint16", 8, 9, 1): 4,
        ("cint16", "cint16", 9, 9, 1): 9,
        ("cint16", "cint16", 10, 9, 1): 5,
        ("cint16", "cint16", 11, 9, 1): 11,
        ("cint16", "cint16", 12, 9, 1): 6,
        ("cint16", "cint16", 13, 9, 1): 13,
        ("cint16", "cint16", 14, 9, 1): 7,
        ("cint16", "cint16", 15, 9, 1): 15,
        ("cint16", "cint16", 16, 9, 1): 8,
        ("cint16", "cint16", 1, 10, 1): 1,
        ("cint16", "cint16", 2, 10, 1): 1,
        ("cint16", "cint16", 3, 10, 1): 3,
        ("cint16", "cint16", 4, 10, 1): 1,
        ("cint16", "cint16", 5, 10, 1): 5,
        ("cint16", "cint16", 6, 10, 1): 3,
        ("cint16", "cint16", 7, 10, 1): 7,
        ("cint16", "cint16", 8, 10, 1): 2,
        ("cint16", "cint16", 9, 10, 1): 9,
        ("cint16", "cint16", 10, 10, 1): 5,
        ("cint16", "cint16", 11, 10, 1): 11,
        ("cint16", "cint16", 12, 10, 1): 3,
        ("cint16", "cint16", 13, 10, 1): 13,
        ("cint16", "cint16", 14, 10, 1): 7,
        ("cint16", "cint16", 15, 10, 1): 15,
        ("cint16", "cint16", 16, 10, 1): 4,
        ("cint16", "cint16", 1, 11, 1): 1,
        ("cint16", "cint16", 2, 11, 1): 1,
        ("cint16", "cint16", 3, 11, 1): 3,
        ("cint16", "cint16", 4, 11, 1): 2,
        ("cint16", "cint16", 5, 11, 1): 5,
        ("cint16", "cint16", 6, 11, 1): 3,
        ("cint16", "cint16", 7, 11, 1): 7,
        ("cint16", "cint16", 8, 11, 1): 4,
        ("cint16", "cint16", 9, 11, 1): 9,
        ("cint16", "cint16", 10, 11, 1): 5,
        ("cint16", "cint16", 11, 11, 1): 11,
        ("cint16", "cint16", 12, 11, 1): 6,
        ("cint16", "cint16", 13, 11, 1): 13,
        ("cint16", "cint16", 14, 11, 1): 7,
        ("cint16", "cint16", 15, 11, 1): 15,
        ("cint16", "cint16", 16, 11, 1): 8,
        ("cint16", "cint16", 1, 12, 1): 1,
        ("cint16", "cint16", 2, 12, 1): 1,
        ("cint16", "cint16", 3, 12, 1): 3,
        ("cint16", "cint16", 4, 12, 1): 1,
        ("cint16", "cint16", 5, 12, 1): 5,
        ("cint16", "cint16", 6, 12, 1): 3,
        ("cint16", "cint16", 7, 12, 1): 7,
        ("cint16", "cint16", 8, 12, 1): 1,
        ("cint16", "cint16", 9, 12, 1): 9,
        ("cint16", "cint16", 10, 12, 1): 5,
        ("cint16", "cint16", 11, 12, 1): 11,
        ("cint16", "cint16", 12, 12, 1): 3,
        ("cint16", "cint16", 13, 12, 1): 13,
        ("cint16", "cint16", 14, 12, 1): 7,
        ("cint16", "cint16", 15, 12, 1): 15,
        ("cint16", "cint16", 16, 12, 1): 2,
        ("cint16", "cint16", 1, 13, 1): 1,
        ("cint16", "cint16", 2, 13, 1): 1,
        ("cint16", "cint16", 3, 13, 1): 3,
        ("cint16", "cint16", 4, 13, 1): 2,
        ("cint16", "cint16", 5, 13, 1): 5,
        ("cint16", "cint16", 6, 13, 1): 3,
        ("cint16", "cint16", 7, 13, 1): 7,
        ("cint16", "cint16", 8, 13, 1): 4,
        ("cint16", "cint16", 9, 13, 1): 9,
        ("cint16", "cint16", 10, 13, 1): 5,
        ("cint16", "cint16", 11, 13, 1): 11,
        ("cint16", "cint16", 12, 13, 1): 6,
        ("cint16", "cint16", 13, 13, 1): 13,
        ("cint16", "cint16", 14, 13, 1): 7,
        ("cint16", "cint16", 15, 13, 1): 15,
        ("cint16", "cint16", 16, 13, 1): 8,
        ("cint16", "cint16", 1, 14, 1): 1,
        ("cint16", "cint16", 2, 14, 1): 1,
        ("cint16", "cint16", 3, 14, 1): 3,
        ("cint16", "cint16", 4, 14, 1): 1,
        ("cint16", "cint16", 5, 14, 1): 5,
        ("cint16", "cint16", 6, 14, 1): 3,
        ("cint16", "cint16", 7, 14, 1): 7,
        ("cint16", "cint16", 8, 14, 1): 2,
        ("cint16", "cint16", 9, 14, 1): 9,
        ("cint16", "cint16", 10, 14, 1): 5,
        ("cint16", "cint16", 11, 14, 1): 11,
        ("cint16", "cint16", 12, 14, 1): 3,
        ("cint16", "cint16", 13, 14, 1): 13,
        ("cint16", "cint16", 14, 14, 1): 7,
        ("cint16", "cint16", 15, 14, 1): 15,
        ("cint16", "cint16", 16, 14, 1): 4,
        ("cint16", "cint16", 1, 15, 1): 1,
        ("cint16", "cint16", 2, 15, 1): 1,
        ("cint16", "cint16", 3, 15, 1): 3,
        ("cint16", "cint16", 4, 15, 1): 2,
        ("cint16", "cint16", 5, 15, 1): 5,
        ("cint16", "cint16", 6, 15, 1): 3,
        ("cint16", "cint16", 7, 15, 1): 7,
        ("cint16", "cint16", 8, 15, 1): 4,
        ("cint16", "cint16", 9, 15, 1): 9,
        ("cint16", "cint16", 10, 15, 1): 5,
        ("cint16", "cint16", 11, 15, 1): 11,
        ("cint16", "cint16", 12, 15, 1): 6,
        ("cint16", "cint16", 13, 15, 1): 13,
        ("cint16", "cint16", 14, 15, 1): 7,
        ("cint16", "cint16", 15, 15, 1): 15,
        ("cint16", "cint16", 16, 15, 1): 8,
        ("cint16", "cint16", 1, 16, 1): 1,
        ("cint16", "cint16", 2, 16, 1): 1,
        ("cint16", "cint16", 3, 16, 1): 3,
        ("cint16", "cint16", 4, 16, 1): 1,
        ("cint16", "cint16", 5, 16, 1): 5,
        ("cint16", "cint16", 6, 16, 1): 3,
        ("cint16", "cint16", 7, 16, 1): 7,
        ("cint16", "cint16", 8, 16, 1): 1,
        ("cint16", "cint16", 9, 16, 1): 9,
        ("cint16", "cint16", 10, 16, 1): 5,
        ("cint16", "cint16", 11, 16, 1): 11,
        ("cint16", "cint16", 12, 16, 1): 3,
        ("cint16", "cint16", 13, 16, 1): 13,
        ("cint16", "cint16", 14, 16, 1): 7,
        ("cint16", "cint16", 15, 16, 1): 15,
        ("cint16", "cint16", 16, 16, 1): 2,
        ("int32", "int16", 1, 1, 0): 1,
        ("int32", "int16", 2, 1, 0): 1,
        ("int32", "int16", 3, 1, 0): 3,
        ("int32", "int16", 4, 1, 0): 1,
        ("int32", "int16", 5, 1, 0): 5,
        ("int32", "int16", 6, 1, 0): 3,
        ("int32", "int16", 7, 1, 0): 7,
        ("int32", "int16", 8, 1, 0): 2,
        ("int32", "int16", 9, 1, 0): 9,
        ("int32", "int16", 10, 1, 0): 5,
        ("int32", "int16", 11, 1, 0): 11,
        ("int32", "int16", 12, 1, 0): 3,
        ("int32", "int16", 13, 1, 0): 13,
        ("int32", "int16", 14, 1, 0): 7,
        ("int32", "int16", 15, 1, 0): 15,
        ("int32", "int16", 16, 1, 0): 4,
        ("int32", "int16", 1, 2, 0): 1,
        ("int32", "int16", 2, 2, 0): 1,
        ("int32", "int16", 3, 2, 0): 3,
        ("int32", "int16", 4, 2, 0): 1,
        ("int32", "int16", 5, 2, 0): 5,
        ("int32", "int16", 6, 2, 0): 3,
        ("int32", "int16", 7, 2, 0): 7,
        ("int32", "int16", 8, 2, 0): 1,
        ("int32", "int16", 9, 2, 0): 9,
        ("int32", "int16", 10, 2, 0): 5,
        ("int32", "int16", 11, 2, 0): 11,
        ("int32", "int16", 12, 2, 0): 3,
        ("int32", "int16", 13, 2, 0): 13,
        ("int32", "int16", 14, 2, 0): 7,
        ("int32", "int16", 15, 2, 0): 15,
        ("int32", "int16", 16, 2, 0): 2,
        ("int32", "int16", 1, 3, 0): 1,
        ("int32", "int16", 2, 3, 0): 1,
        ("int32", "int16", 3, 3, 0): 3,
        ("int32", "int16", 4, 3, 0): 1,
        ("int32", "int16", 5, 3, 0): 5,
        ("int32", "int16", 6, 3, 0): 3,
        ("int32", "int16", 7, 3, 0): 7,
        ("int32", "int16", 8, 3, 0): 2,
        ("int32", "int16", 9, 3, 0): 9,
        ("int32", "int16", 10, 3, 0): 5,
        ("int32", "int16", 11, 3, 0): 11,
        ("int32", "int16", 12, 3, 0): 3,
        ("int32", "int16", 13, 3, 0): 13,
        ("int32", "int16", 14, 3, 0): 7,
        ("int32", "int16", 15, 3, 0): 15,
        ("int32", "int16", 16, 3, 0): 4,
        ("int32", "int16", 1, 4, 0): 1,
        ("int32", "int16", 2, 4, 0): 1,
        ("int32", "int16", 3, 4, 0): 3,
        ("int32", "int16", 4, 4, 0): 1,
        ("int32", "int16", 5, 4, 0): 5,
        ("int32", "int16", 6, 4, 0): 3,
        ("int32", "int16", 7, 4, 0): 7,
        ("int32", "int16", 8, 4, 0): 1,
        ("int32", "int16", 9, 4, 0): 9,
        ("int32", "int16", 10, 4, 0): 5,
        ("int32", "int16", 11, 4, 0): 11,
        ("int32", "int16", 12, 4, 0): 3,
        ("int32", "int16", 13, 4, 0): 13,
        ("int32", "int16", 14, 4, 0): 7,
        ("int32", "int16", 15, 4, 0): 15,
        ("int32", "int16", 16, 4, 0): 1,
        ("int32", "int16", 1, 5, 0): 1,
        ("int32", "int16", 2, 5, 0): 1,
        ("int32", "int16", 3, 5, 0): 3,
        ("int32", "int16", 4, 5, 0): 1,
        ("int32", "int16", 5, 5, 0): 5,
        ("int32", "int16", 6, 5, 0): 3,
        ("int32", "int16", 7, 5, 0): 7,
        ("int32", "int16", 8, 5, 0): 2,
        ("int32", "int16", 9, 5, 0): 9,
        ("int32", "int16", 10, 5, 0): 5,
        ("int32", "int16", 11, 5, 0): 11,
        ("int32", "int16", 12, 5, 0): 3,
        ("int32", "int16", 13, 5, 0): 13,
        ("int32", "int16", 14, 5, 0): 7,
        ("int32", "int16", 15, 5, 0): 15,
        ("int32", "int16", 16, 5, 0): 4,
        ("int32", "int16", 1, 6, 0): 1,
        ("int32", "int16", 2, 6, 0): 1,
        ("int32", "int16", 3, 6, 0): 3,
        ("int32", "int16", 4, 6, 0): 1,
        ("int32", "int16", 5, 6, 0): 5,
        ("int32", "int16", 6, 6, 0): 3,
        ("int32", "int16", 7, 6, 0): 7,
        ("int32", "int16", 8, 6, 0): 1,
        ("int32", "int16", 9, 6, 0): 9,
        ("int32", "int16", 10, 6, 0): 5,
        ("int32", "int16", 11, 6, 0): 11,
        ("int32", "int16", 12, 6, 0): 3,
        ("int32", "int16", 13, 6, 0): 13,
        ("int32", "int16", 14, 6, 0): 7,
        ("int32", "int16", 15, 6, 0): 15,
        ("int32", "int16", 16, 6, 0): 2,
        ("int32", "int16", 1, 7, 0): 1,
        ("int32", "int16", 2, 7, 0): 1,
        ("int32", "int16", 3, 7, 0): 3,
        ("int32", "int16", 4, 7, 0): 1,
        ("int32", "int16", 5, 7, 0): 5,
        ("int32", "int16", 6, 7, 0): 3,
        ("int32", "int16", 7, 7, 0): 7,
        ("int32", "int16", 8, 7, 0): 2,
        ("int32", "int16", 9, 7, 0): 9,
        ("int32", "int16", 10, 7, 0): 5,
        ("int32", "int16", 11, 7, 0): 11,
        ("int32", "int16", 12, 7, 0): 3,
        ("int32", "int16", 13, 7, 0): 13,
        ("int32", "int16", 14, 7, 0): 7,
        ("int32", "int16", 15, 7, 0): 15,
        ("int32", "int16", 16, 7, 0): 4,
        ("int32", "int16", 1, 8, 0): 1,
        ("int32", "int16", 2, 8, 0): 1,
        ("int32", "int16", 3, 8, 0): 3,
        ("int32", "int16", 4, 8, 0): 1,
        ("int32", "int16", 5, 8, 0): 5,
        ("int32", "int16", 6, 8, 0): 3,
        ("int32", "int16", 7, 8, 0): 7,
        ("int32", "int16", 8, 8, 0): 1,
        ("int32", "int16", 9, 8, 0): 9,
        ("int32", "int16", 10, 8, 0): 5,
        ("int32", "int16", 11, 8, 0): 11,
        ("int32", "int16", 12, 8, 0): 3,
        ("int32", "int16", 13, 8, 0): 13,
        ("int32", "int16", 14, 8, 0): 7,
        ("int32", "int16", 15, 8, 0): 15,
        ("int32", "int16", 16, 8, 0): 1,
        ("int32", "int16", 1, 9, 0): 1,
        ("int32", "int16", 2, 9, 0): 1,
        ("int32", "int16", 3, 9, 0): 3,
        ("int32", "int16", 4, 9, 0): 1,
        ("int32", "int16", 5, 9, 0): 5,
        ("int32", "int16", 6, 9, 0): 3,
        ("int32", "int16", 7, 9, 0): 7,
        ("int32", "int16", 8, 9, 0): 2,
        ("int32", "int16", 9, 9, 0): 9,
        ("int32", "int16", 10, 9, 0): 5,
        ("int32", "int16", 11, 9, 0): 11,
        ("int32", "int16", 12, 9, 0): 3,
        ("int32", "int16", 13, 9, 0): 13,
        ("int32", "int16", 14, 9, 0): 7,
        ("int32", "int16", 15, 9, 0): 15,
        ("int32", "int16", 16, 9, 0): 4,
        ("int32", "int16", 1, 10, 0): 1,
        ("int32", "int16", 2, 10, 0): 1,
        ("int32", "int16", 3, 10, 0): 3,
        ("int32", "int16", 4, 10, 0): 1,
        ("int32", "int16", 5, 10, 0): 5,
        ("int32", "int16", 6, 10, 0): 3,
        ("int32", "int16", 7, 10, 0): 7,
        ("int32", "int16", 8, 10, 0): 1,
        ("int32", "int16", 9, 10, 0): 9,
        ("int32", "int16", 10, 10, 0): 5,
        ("int32", "int16", 11, 10, 0): 11,
        ("int32", "int16", 12, 10, 0): 3,
        ("int32", "int16", 13, 10, 0): 13,
        ("int32", "int16", 14, 10, 0): 7,
        ("int32", "int16", 15, 10, 0): 15,
        ("int32", "int16", 16, 10, 0): 2,
        ("int32", "int16", 1, 11, 0): 1,
        ("int32", "int16", 2, 11, 0): 1,
        ("int32", "int16", 3, 11, 0): 3,
        ("int32", "int16", 4, 11, 0): 1,
        ("int32", "int16", 5, 11, 0): 5,
        ("int32", "int16", 6, 11, 0): 3,
        ("int32", "int16", 7, 11, 0): 7,
        ("int32", "int16", 8, 11, 0): 2,
        ("int32", "int16", 9, 11, 0): 9,
        ("int32", "int16", 10, 11, 0): 5,
        ("int32", "int16", 11, 11, 0): 11,
        ("int32", "int16", 12, 11, 0): 3,
        ("int32", "int16", 13, 11, 0): 13,
        ("int32", "int16", 14, 11, 0): 7,
        ("int32", "int16", 15, 11, 0): 15,
        ("int32", "int16", 16, 11, 0): 4,
        ("int32", "int16", 1, 12, 0): 1,
        ("int32", "int16", 2, 12, 0): 1,
        ("int32", "int16", 3, 12, 0): 3,
        ("int32", "int16", 4, 12, 0): 1,
        ("int32", "int16", 5, 12, 0): 5,
        ("int32", "int16", 6, 12, 0): 3,
        ("int32", "int16", 7, 12, 0): 7,
        ("int32", "int16", 8, 12, 0): 1,
        ("int32", "int16", 9, 12, 0): 9,
        ("int32", "int16", 10, 12, 0): 5,
        ("int32", "int16", 11, 12, 0): 11,
        ("int32", "int16", 12, 12, 0): 3,
        ("int32", "int16", 13, 12, 0): 13,
        ("int32", "int16", 14, 12, 0): 7,
        ("int32", "int16", 15, 12, 0): 15,
        ("int32", "int16", 16, 12, 0): 1,
        ("int32", "int16", 1, 13, 0): 1,
        ("int32", "int16", 2, 13, 0): 1,
        ("int32", "int16", 3, 13, 0): 3,
        ("int32", "int16", 4, 13, 0): 1,
        ("int32", "int16", 5, 13, 0): 5,
        ("int32", "int16", 6, 13, 0): 3,
        ("int32", "int16", 7, 13, 0): 7,
        ("int32", "int16", 8, 13, 0): 2,
        ("int32", "int16", 9, 13, 0): 9,
        ("int32", "int16", 10, 13, 0): 5,
        ("int32", "int16", 11, 13, 0): 11,
        ("int32", "int16", 12, 13, 0): 3,
        ("int32", "int16", 13, 13, 0): 13,
        ("int32", "int16", 14, 13, 0): 7,
        ("int32", "int16", 15, 13, 0): 15,
        ("int32", "int16", 16, 13, 0): 4,
        ("int32", "int16", 1, 14, 0): 1,
        ("int32", "int16", 2, 14, 0): 1,
        ("int32", "int16", 3, 14, 0): 3,
        ("int32", "int16", 4, 14, 0): 1,
        ("int32", "int16", 5, 14, 0): 5,
        ("int32", "int16", 6, 14, 0): 3,
        ("int32", "int16", 7, 14, 0): 7,
        ("int32", "int16", 8, 14, 0): 1,
        ("int32", "int16", 9, 14, 0): 9,
        ("int32", "int16", 10, 14, 0): 5,
        ("int32", "int16", 11, 14, 0): 11,
        ("int32", "int16", 12, 14, 0): 3,
        ("int32", "int16", 13, 14, 0): 13,
        ("int32", "int16", 14, 14, 0): 7,
        ("int32", "int16", 15, 14, 0): 15,
        ("int32", "int16", 16, 14, 0): 2,
        ("int32", "int16", 1, 15, 0): 1,
        ("int32", "int16", 2, 15, 0): 1,
        ("int32", "int16", 3, 15, 0): 3,
        ("int32", "int16", 4, 15, 0): 1,
        ("int32", "int16", 5, 15, 0): 5,
        ("int32", "int16", 6, 15, 0): 3,
        ("int32", "int16", 7, 15, 0): 7,
        ("int32", "int16", 8, 15, 0): 2,
        ("int32", "int16", 9, 15, 0): 9,
        ("int32", "int16", 10, 15, 0): 5,
        ("int32", "int16", 11, 15, 0): 11,
        ("int32", "int16", 12, 15, 0): 3,
        ("int32", "int16", 13, 15, 0): 13,
        ("int32", "int16", 14, 15, 0): 7,
        ("int32", "int16", 15, 15, 0): 15,
        ("int32", "int16", 16, 15, 0): 4,
        ("int32", "int16", 1, 16, 0): 1,
        ("int32", "int16", 2, 16, 0): 1,
        ("int32", "int16", 3, 16, 0): 3,
        ("int32", "int16", 4, 16, 0): 1,
        ("int32", "int16", 5, 16, 0): 5,
        ("int32", "int16", 6, 16, 0): 3,
        ("int32", "int16", 7, 16, 0): 7,
        ("int32", "int16", 8, 16, 0): 1,
        ("int32", "int16", 9, 16, 0): 9,
        ("int32", "int16", 10, 16, 0): 5,
        ("int32", "int16", 11, 16, 0): 11,
        ("int32", "int16", 12, 16, 0): 3,
        ("int32", "int16", 13, 16, 0): 13,
        ("int32", "int16", 14, 16, 0): 7,
        ("int32", "int16", 15, 16, 0): 15,
        ("int32", "int16", 16, 16, 0): 1,
        ("int32", "int16", 1, 1, 1): 1,
        ("int32", "int16", 2, 1, 1): 1,
        ("int32", "int16", 3, 1, 1): 3,
        ("int32", "int16", 4, 1, 1): 2,
        ("int32", "int16", 5, 1, 1): 5,
        ("int32", "int16", 6, 1, 1): 3,
        ("int32", "int16", 7, 1, 1): 7,
        ("int32", "int16", 8, 1, 1): 4,
        ("int32", "int16", 9, 1, 1): 9,
        ("int32", "int16", 10, 1, 1): 5,
        ("int32", "int16", 11, 1, 1): 11,
        ("int32", "int16", 12, 1, 1): 6,
        ("int32", "int16", 13, 1, 1): 13,
        ("int32", "int16", 14, 1, 1): 7,
        ("int32", "int16", 15, 1, 1): 15,
        ("int32", "int16", 16, 1, 1): 8,
        ("int32", "int16", 1, 2, 1): 1,
        ("int32", "int16", 2, 2, 1): 1,
        ("int32", "int16", 3, 2, 1): 3,
        ("int32", "int16", 4, 2, 1): 1,
        ("int32", "int16", 5, 2, 1): 5,
        ("int32", "int16", 6, 2, 1): 3,
        ("int32", "int16", 7, 2, 1): 7,
        ("int32", "int16", 8, 2, 1): 2,
        ("int32", "int16", 9, 2, 1): 9,
        ("int32", "int16", 10, 2, 1): 5,
        ("int32", "int16", 11, 2, 1): 11,
        ("int32", "int16", 12, 2, 1): 3,
        ("int32", "int16", 13, 2, 1): 13,
        ("int32", "int16", 14, 2, 1): 7,
        ("int32", "int16", 15, 2, 1): 15,
        ("int32", "int16", 16, 2, 1): 4,
        ("int32", "int16", 1, 3, 1): 1,
        ("int32", "int16", 2, 3, 1): 1,
        ("int32", "int16", 3, 3, 1): 3,
        ("int32", "int16", 4, 3, 1): 2,
        ("int32", "int16", 5, 3, 1): 5,
        ("int32", "int16", 6, 3, 1): 3,
        ("int32", "int16", 7, 3, 1): 7,
        ("int32", "int16", 8, 3, 1): 4,
        ("int32", "int16", 9, 3, 1): 9,
        ("int32", "int16", 10, 3, 1): 5,
        ("int32", "int16", 11, 3, 1): 11,
        ("int32", "int16", 12, 3, 1): 6,
        ("int32", "int16", 13, 3, 1): 13,
        ("int32", "int16", 14, 3, 1): 7,
        ("int32", "int16", 15, 3, 1): 15,
        ("int32", "int16", 16, 3, 1): 8,
        ("int32", "int16", 1, 4, 1): 1,
        ("int32", "int16", 2, 4, 1): 1,
        ("int32", "int16", 3, 4, 1): 3,
        ("int32", "int16", 4, 4, 1): 1,
        ("int32", "int16", 5, 4, 1): 5,
        ("int32", "int16", 6, 4, 1): 3,
        ("int32", "int16", 7, 4, 1): 7,
        ("int32", "int16", 8, 4, 1): 1,
        ("int32", "int16", 9, 4, 1): 9,
        ("int32", "int16", 10, 4, 1): 5,
        ("int32", "int16", 11, 4, 1): 11,
        ("int32", "int16", 12, 4, 1): 3,
        ("int32", "int16", 13, 4, 1): 13,
        ("int32", "int16", 14, 4, 1): 7,
        ("int32", "int16", 15, 4, 1): 15,
        ("int32", "int16", 16, 4, 1): 2,
        ("int32", "int16", 1, 5, 1): 1,
        ("int32", "int16", 2, 5, 1): 1,
        ("int32", "int16", 3, 5, 1): 3,
        ("int32", "int16", 4, 5, 1): 2,
        ("int32", "int16", 5, 5, 1): 5,
        ("int32", "int16", 6, 5, 1): 3,
        ("int32", "int16", 7, 5, 1): 7,
        ("int32", "int16", 8, 5, 1): 4,
        ("int32", "int16", 9, 5, 1): 9,
        ("int32", "int16", 10, 5, 1): 5,
        ("int32", "int16", 11, 5, 1): 11,
        ("int32", "int16", 12, 5, 1): 6,
        ("int32", "int16", 13, 5, 1): 13,
        ("int32", "int16", 14, 5, 1): 7,
        ("int32", "int16", 15, 5, 1): 15,
        ("int32", "int16", 16, 5, 1): 8,
        ("int32", "int16", 1, 6, 1): 1,
        ("int32", "int16", 2, 6, 1): 1,
        ("int32", "int16", 3, 6, 1): 3,
        ("int32", "int16", 4, 6, 1): 1,
        ("int32", "int16", 5, 6, 1): 5,
        ("int32", "int16", 6, 6, 1): 3,
        ("int32", "int16", 7, 6, 1): 7,
        ("int32", "int16", 8, 6, 1): 2,
        ("int32", "int16", 9, 6, 1): 9,
        ("int32", "int16", 10, 6, 1): 5,
        ("int32", "int16", 11, 6, 1): 11,
        ("int32", "int16", 12, 6, 1): 3,
        ("int32", "int16", 13, 6, 1): 13,
        ("int32", "int16", 14, 6, 1): 7,
        ("int32", "int16", 15, 6, 1): 15,
        ("int32", "int16", 16, 6, 1): 4,
        ("int32", "int16", 1, 7, 1): 1,
        ("int32", "int16", 2, 7, 1): 1,
        ("int32", "int16", 3, 7, 1): 3,
        ("int32", "int16", 4, 7, 1): 2,
        ("int32", "int16", 5, 7, 1): 5,
        ("int32", "int16", 6, 7, 1): 3,
        ("int32", "int16", 7, 7, 1): 7,
        ("int32", "int16", 8, 7, 1): 4,
        ("int32", "int16", 9, 7, 1): 9,
        ("int32", "int16", 10, 7, 1): 5,
        ("int32", "int16", 11, 7, 1): 11,
        ("int32", "int16", 12, 7, 1): 6,
        ("int32", "int16", 13, 7, 1): 13,
        ("int32", "int16", 14, 7, 1): 7,
        ("int32", "int16", 15, 7, 1): 15,
        ("int32", "int16", 16, 7, 1): 8,
        ("int32", "int16", 1, 8, 1): 1,
        ("int32", "int16", 2, 8, 1): 1,
        ("int32", "int16", 3, 8, 1): 3,
        ("int32", "int16", 4, 8, 1): 1,
        ("int32", "int16", 5, 8, 1): 5,
        ("int32", "int16", 6, 8, 1): 3,
        ("int32", "int16", 7, 8, 1): 7,
        ("int32", "int16", 8, 8, 1): 1,
        ("int32", "int16", 9, 8, 1): 9,
        ("int32", "int16", 10, 8, 1): 5,
        ("int32", "int16", 11, 8, 1): 11,
        ("int32", "int16", 12, 8, 1): 3,
        ("int32", "int16", 13, 8, 1): 13,
        ("int32", "int16", 14, 8, 1): 7,
        ("int32", "int16", 15, 8, 1): 15,
        ("int32", "int16", 16, 8, 1): 2,
        ("int32", "int16", 1, 9, 1): 1,
        ("int32", "int16", 2, 9, 1): 1,
        ("int32", "int16", 3, 9, 1): 3,
        ("int32", "int16", 4, 9, 1): 2,
        ("int32", "int16", 5, 9, 1): 5,
        ("int32", "int16", 6, 9, 1): 3,
        ("int32", "int16", 7, 9, 1): 7,
        ("int32", "int16", 8, 9, 1): 4,
        ("int32", "int16", 9, 9, 1): 9,
        ("int32", "int16", 10, 9, 1): 5,
        ("int32", "int16", 11, 9, 1): 11,
        ("int32", "int16", 12, 9, 1): 6,
        ("int32", "int16", 13, 9, 1): 13,
        ("int32", "int16", 14, 9, 1): 7,
        ("int32", "int16", 15, 9, 1): 15,
        ("int32", "int16", 16, 9, 1): 8,
        ("int32", "int16", 1, 10, 1): 1,
        ("int32", "int16", 2, 10, 1): 1,
        ("int32", "int16", 3, 10, 1): 3,
        ("int32", "int16", 4, 10, 1): 1,
        ("int32", "int16", 5, 10, 1): 5,
        ("int32", "int16", 6, 10, 1): 3,
        ("int32", "int16", 7, 10, 1): 7,
        ("int32", "int16", 8, 10, 1): 2,
        ("int32", "int16", 9, 10, 1): 9,
        ("int32", "int16", 10, 10, 1): 5,
        ("int32", "int16", 11, 10, 1): 11,
        ("int32", "int16", 12, 10, 1): 3,
        ("int32", "int16", 13, 10, 1): 13,
        ("int32", "int16", 14, 10, 1): 7,
        ("int32", "int16", 15, 10, 1): 15,
        ("int32", "int16", 16, 10, 1): 4,
        ("int32", "int16", 1, 11, 1): 1,
        ("int32", "int16", 2, 11, 1): 1,
        ("int32", "int16", 3, 11, 1): 3,
        ("int32", "int16", 4, 11, 1): 2,
        ("int32", "int16", 5, 11, 1): 5,
        ("int32", "int16", 6, 11, 1): 3,
        ("int32", "int16", 7, 11, 1): 7,
        ("int32", "int16", 8, 11, 1): 4,
        ("int32", "int16", 9, 11, 1): 9,
        ("int32", "int16", 10, 11, 1): 5,
        ("int32", "int16", 11, 11, 1): 11,
        ("int32", "int16", 12, 11, 1): 6,
        ("int32", "int16", 13, 11, 1): 13,
        ("int32", "int16", 14, 11, 1): 7,
        ("int32", "int16", 15, 11, 1): 15,
        ("int32", "int16", 16, 11, 1): 8,
        ("int32", "int16", 1, 12, 1): 1,
        ("int32", "int16", 2, 12, 1): 1,
        ("int32", "int16", 3, 12, 1): 3,
        ("int32", "int16", 4, 12, 1): 1,
        ("int32", "int16", 5, 12, 1): 5,
        ("int32", "int16", 6, 12, 1): 3,
        ("int32", "int16", 7, 12, 1): 7,
        ("int32", "int16", 8, 12, 1): 1,
        ("int32", "int16", 9, 12, 1): 9,
        ("int32", "int16", 10, 12, 1): 5,
        ("int32", "int16", 11, 12, 1): 11,
        ("int32", "int16", 12, 12, 1): 3,
        ("int32", "int16", 13, 12, 1): 13,
        ("int32", "int16", 14, 12, 1): 7,
        ("int32", "int16", 15, 12, 1): 15,
        ("int32", "int16", 16, 12, 1): 2,
        ("int32", "int16", 1, 13, 1): 1,
        ("int32", "int16", 2, 13, 1): 1,
        ("int32", "int16", 3, 13, 1): 3,
        ("int32", "int16", 4, 13, 1): 2,
        ("int32", "int16", 5, 13, 1): 5,
        ("int32", "int16", 6, 13, 1): 3,
        ("int32", "int16", 7, 13, 1): 7,
        ("int32", "int16", 8, 13, 1): 4,
        ("int32", "int16", 9, 13, 1): 9,
        ("int32", "int16", 10, 13, 1): 5,
        ("int32", "int16", 11, 13, 1): 11,
        ("int32", "int16", 12, 13, 1): 6,
        ("int32", "int16", 13, 13, 1): 13,
        ("int32", "int16", 14, 13, 1): 7,
        ("int32", "int16", 15, 13, 1): 15,
        ("int32", "int16", 16, 13, 1): 8,
        ("int32", "int16", 1, 14, 1): 1,
        ("int32", "int16", 2, 14, 1): 1,
        ("int32", "int16", 3, 14, 1): 3,
        ("int32", "int16", 4, 14, 1): 1,
        ("int32", "int16", 5, 14, 1): 5,
        ("int32", "int16", 6, 14, 1): 3,
        ("int32", "int16", 7, 14, 1): 7,
        ("int32", "int16", 8, 14, 1): 2,
        ("int32", "int16", 9, 14, 1): 9,
        ("int32", "int16", 10, 14, 1): 5,
        ("int32", "int16", 11, 14, 1): 11,
        ("int32", "int16", 12, 14, 1): 3,
        ("int32", "int16", 13, 14, 1): 13,
        ("int32", "int16", 14, 14, 1): 7,
        ("int32", "int16", 15, 14, 1): 15,
        ("int32", "int16", 16, 14, 1): 4,
        ("int32", "int16", 1, 15, 1): 1,
        ("int32", "int16", 2, 15, 1): 1,
        ("int32", "int16", 3, 15, 1): 3,
        ("int32", "int16", 4, 15, 1): 2,
        ("int32", "int16", 5, 15, 1): 5,
        ("int32", "int16", 6, 15, 1): 3,
        ("int32", "int16", 7, 15, 1): 7,
        ("int32", "int16", 8, 15, 1): 4,
        ("int32", "int16", 9, 15, 1): 9,
        ("int32", "int16", 10, 15, 1): 5,
        ("int32", "int16", 11, 15, 1): 11,
        ("int32", "int16", 12, 15, 1): 6,
        ("int32", "int16", 13, 15, 1): 13,
        ("int32", "int16", 14, 15, 1): 7,
        ("int32", "int16", 15, 15, 1): 15,
        ("int32", "int16", 16, 15, 1): 8,
        ("int32", "int16", 1, 16, 1): 1,
        ("int32", "int16", 2, 16, 1): 1,
        ("int32", "int16", 3, 16, 1): 3,
        ("int32", "int16", 4, 16, 1): 1,
        ("int32", "int16", 5, 16, 1): 5,
        ("int32", "int16", 6, 16, 1): 3,
        ("int32", "int16", 7, 16, 1): 7,
        ("int32", "int16", 8, 16, 1): 1,
        ("int32", "int16", 9, 16, 1): 9,
        ("int32", "int16", 10, 16, 1): 5,
        ("int32", "int16", 11, 16, 1): 11,
        ("int32", "int16", 12, 16, 1): 3,
        ("int32", "int16", 13, 16, 1): 13,
        ("int32", "int16", 14, 16, 1): 7,
        ("int32", "int16", 15, 16, 1): 15,
        ("int32", "int16", 16, 16, 1): 2,
        ("cint16", "int32", 1, 1, 0): 1,
        ("cint16", "int32", 2, 1, 0): 1,
        ("cint16", "int32", 3, 1, 0): 3,
        ("cint16", "int32", 4, 1, 0): 1,
        ("cint16", "int32", 5, 1, 0): 5,
        ("cint16", "int32", 6, 1, 0): 3,
        ("cint16", "int32", 7, 1, 0): 7,
        ("cint16", "int32", 8, 1, 0): 2,
        ("cint16", "int32", 9, 1, 0): 9,
        ("cint16", "int32", 10, 1, 0): 5,
        ("cint16", "int32", 11, 1, 0): 11,
        ("cint16", "int32", 12, 1, 0): 3,
        ("cint16", "int32", 13, 1, 0): 13,
        ("cint16", "int32", 14, 1, 0): 7,
        ("cint16", "int32", 15, 1, 0): 15,
        ("cint16", "int32", 16, 1, 0): 4,
        ("cint16", "int32", 1, 2, 0): 1,
        ("cint16", "int32", 2, 2, 0): 1,
        ("cint16", "int32", 3, 2, 0): 3,
        ("cint16", "int32", 4, 2, 0): 1,
        ("cint16", "int32", 5, 2, 0): 5,
        ("cint16", "int32", 6, 2, 0): 3,
        ("cint16", "int32", 7, 2, 0): 7,
        ("cint16", "int32", 8, 2, 0): 1,
        ("cint16", "int32", 9, 2, 0): 9,
        ("cint16", "int32", 10, 2, 0): 5,
        ("cint16", "int32", 11, 2, 0): 11,
        ("cint16", "int32", 12, 2, 0): 3,
        ("cint16", "int32", 13, 2, 0): 13,
        ("cint16", "int32", 14, 2, 0): 7,
        ("cint16", "int32", 15, 2, 0): 15,
        ("cint16", "int32", 16, 2, 0): 2,
        ("cint16", "int32", 1, 3, 0): 1,
        ("cint16", "int32", 2, 3, 0): 1,
        ("cint16", "int32", 3, 3, 0): 3,
        ("cint16", "int32", 4, 3, 0): 1,
        ("cint16", "int32", 5, 3, 0): 5,
        ("cint16", "int32", 6, 3, 0): 3,
        ("cint16", "int32", 7, 3, 0): 7,
        ("cint16", "int32", 8, 3, 0): 2,
        ("cint16", "int32", 9, 3, 0): 9,
        ("cint16", "int32", 10, 3, 0): 5,
        ("cint16", "int32", 11, 3, 0): 11,
        ("cint16", "int32", 12, 3, 0): 3,
        ("cint16", "int32", 13, 3, 0): 13,
        ("cint16", "int32", 14, 3, 0): 7,
        ("cint16", "int32", 15, 3, 0): 15,
        ("cint16", "int32", 16, 3, 0): 4,
        ("cint16", "int32", 1, 4, 0): 1,
        ("cint16", "int32", 2, 4, 0): 1,
        ("cint16", "int32", 3, 4, 0): 3,
        ("cint16", "int32", 4, 4, 0): 1,
        ("cint16", "int32", 5, 4, 0): 5,
        ("cint16", "int32", 6, 4, 0): 3,
        ("cint16", "int32", 7, 4, 0): 7,
        ("cint16", "int32", 8, 4, 0): 1,
        ("cint16", "int32", 9, 4, 0): 9,
        ("cint16", "int32", 10, 4, 0): 5,
        ("cint16", "int32", 11, 4, 0): 11,
        ("cint16", "int32", 12, 4, 0): 3,
        ("cint16", "int32", 13, 4, 0): 13,
        ("cint16", "int32", 14, 4, 0): 7,
        ("cint16", "int32", 15, 4, 0): 15,
        ("cint16", "int32", 16, 4, 0): 1,
        ("cint16", "int32", 1, 5, 0): 1,
        ("cint16", "int32", 2, 5, 0): 1,
        ("cint16", "int32", 3, 5, 0): 3,
        ("cint16", "int32", 4, 5, 0): 1,
        ("cint16", "int32", 5, 5, 0): 5,
        ("cint16", "int32", 6, 5, 0): 3,
        ("cint16", "int32", 7, 5, 0): 7,
        ("cint16", "int32", 8, 5, 0): 2,
        ("cint16", "int32", 9, 5, 0): 9,
        ("cint16", "int32", 10, 5, 0): 5,
        ("cint16", "int32", 11, 5, 0): 11,
        ("cint16", "int32", 12, 5, 0): 3,
        ("cint16", "int32", 13, 5, 0): 13,
        ("cint16", "int32", 14, 5, 0): 7,
        ("cint16", "int32", 15, 5, 0): 15,
        ("cint16", "int32", 16, 5, 0): 4,
        ("cint16", "int32", 1, 6, 0): 1,
        ("cint16", "int32", 2, 6, 0): 1,
        ("cint16", "int32", 3, 6, 0): 3,
        ("cint16", "int32", 4, 6, 0): 1,
        ("cint16", "int32", 5, 6, 0): 5,
        ("cint16", "int32", 6, 6, 0): 3,
        ("cint16", "int32", 7, 6, 0): 7,
        ("cint16", "int32", 8, 6, 0): 1,
        ("cint16", "int32", 9, 6, 0): 9,
        ("cint16", "int32", 10, 6, 0): 5,
        ("cint16", "int32", 11, 6, 0): 11,
        ("cint16", "int32", 12, 6, 0): 3,
        ("cint16", "int32", 13, 6, 0): 13,
        ("cint16", "int32", 14, 6, 0): 7,
        ("cint16", "int32", 15, 6, 0): 15,
        ("cint16", "int32", 16, 6, 0): 2,
        ("cint16", "int32", 1, 7, 0): 1,
        ("cint16", "int32", 2, 7, 0): 1,
        ("cint16", "int32", 3, 7, 0): 3,
        ("cint16", "int32", 4, 7, 0): 1,
        ("cint16", "int32", 5, 7, 0): 5,
        ("cint16", "int32", 6, 7, 0): 3,
        ("cint16", "int32", 7, 7, 0): 7,
        ("cint16", "int32", 8, 7, 0): 2,
        ("cint16", "int32", 9, 7, 0): 9,
        ("cint16", "int32", 10, 7, 0): 5,
        ("cint16", "int32", 11, 7, 0): 11,
        ("cint16", "int32", 12, 7, 0): 3,
        ("cint16", "int32", 13, 7, 0): 13,
        ("cint16", "int32", 14, 7, 0): 7,
        ("cint16", "int32", 15, 7, 0): 15,
        ("cint16", "int32", 16, 7, 0): 4,
        ("cint16", "int32", 1, 8, 0): 1,
        ("cint16", "int32", 2, 8, 0): 1,
        ("cint16", "int32", 3, 8, 0): 3,
        ("cint16", "int32", 4, 8, 0): 1,
        ("cint16", "int32", 5, 8, 0): 5,
        ("cint16", "int32", 6, 8, 0): 3,
        ("cint16", "int32", 7, 8, 0): 7,
        ("cint16", "int32", 8, 8, 0): 1,
        ("cint16", "int32", 9, 8, 0): 9,
        ("cint16", "int32", 10, 8, 0): 5,
        ("cint16", "int32", 11, 8, 0): 11,
        ("cint16", "int32", 12, 8, 0): 3,
        ("cint16", "int32", 13, 8, 0): 13,
        ("cint16", "int32", 14, 8, 0): 7,
        ("cint16", "int32", 15, 8, 0): 15,
        ("cint16", "int32", 16, 8, 0): 1,
        ("cint16", "int32", 1, 9, 0): 1,
        ("cint16", "int32", 2, 9, 0): 1,
        ("cint16", "int32", 3, 9, 0): 3,
        ("cint16", "int32", 4, 9, 0): 1,
        ("cint16", "int32", 5, 9, 0): 5,
        ("cint16", "int32", 6, 9, 0): 3,
        ("cint16", "int32", 7, 9, 0): 7,
        ("cint16", "int32", 8, 9, 0): 2,
        ("cint16", "int32", 9, 9, 0): 9,
        ("cint16", "int32", 10, 9, 0): 5,
        ("cint16", "int32", 11, 9, 0): 11,
        ("cint16", "int32", 12, 9, 0): 3,
        ("cint16", "int32", 13, 9, 0): 13,
        ("cint16", "int32", 14, 9, 0): 7,
        ("cint16", "int32", 15, 9, 0): 15,
        ("cint16", "int32", 16, 9, 0): 4,
        ("cint16", "int32", 1, 10, 0): 1,
        ("cint16", "int32", 2, 10, 0): 1,
        ("cint16", "int32", 3, 10, 0): 3,
        ("cint16", "int32", 4, 10, 0): 1,
        ("cint16", "int32", 5, 10, 0): 5,
        ("cint16", "int32", 6, 10, 0): 3,
        ("cint16", "int32", 7, 10, 0): 7,
        ("cint16", "int32", 8, 10, 0): 1,
        ("cint16", "int32", 9, 10, 0): 9,
        ("cint16", "int32", 10, 10, 0): 5,
        ("cint16", "int32", 11, 10, 0): 11,
        ("cint16", "int32", 12, 10, 0): 3,
        ("cint16", "int32", 13, 10, 0): 13,
        ("cint16", "int32", 14, 10, 0): 7,
        ("cint16", "int32", 15, 10, 0): 15,
        ("cint16", "int32", 16, 10, 0): 2,
        ("cint16", "int32", 1, 11, 0): 1,
        ("cint16", "int32", 2, 11, 0): 1,
        ("cint16", "int32", 3, 11, 0): 3,
        ("cint16", "int32", 4, 11, 0): 1,
        ("cint16", "int32", 5, 11, 0): 5,
        ("cint16", "int32", 6, 11, 0): 3,
        ("cint16", "int32", 7, 11, 0): 7,
        ("cint16", "int32", 8, 11, 0): 2,
        ("cint16", "int32", 9, 11, 0): 9,
        ("cint16", "int32", 10, 11, 0): 5,
        ("cint16", "int32", 11, 11, 0): 11,
        ("cint16", "int32", 12, 11, 0): 3,
        ("cint16", "int32", 13, 11, 0): 13,
        ("cint16", "int32", 14, 11, 0): 7,
        ("cint16", "int32", 15, 11, 0): 15,
        ("cint16", "int32", 16, 11, 0): 4,
        ("cint16", "int32", 1, 12, 0): 1,
        ("cint16", "int32", 2, 12, 0): 1,
        ("cint16", "int32", 3, 12, 0): 3,
        ("cint16", "int32", 4, 12, 0): 1,
        ("cint16", "int32", 5, 12, 0): 5,
        ("cint16", "int32", 6, 12, 0): 3,
        ("cint16", "int32", 7, 12, 0): 7,
        ("cint16", "int32", 8, 12, 0): 1,
        ("cint16", "int32", 9, 12, 0): 9,
        ("cint16", "int32", 10, 12, 0): 5,
        ("cint16", "int32", 11, 12, 0): 11,
        ("cint16", "int32", 12, 12, 0): 3,
        ("cint16", "int32", 13, 12, 0): 13,
        ("cint16", "int32", 14, 12, 0): 7,
        ("cint16", "int32", 15, 12, 0): 15,
        ("cint16", "int32", 16, 12, 0): 1,
        ("cint16", "int32", 1, 13, 0): 1,
        ("cint16", "int32", 2, 13, 0): 1,
        ("cint16", "int32", 3, 13, 0): 3,
        ("cint16", "int32", 4, 13, 0): 1,
        ("cint16", "int32", 5, 13, 0): 5,
        ("cint16", "int32", 6, 13, 0): 3,
        ("cint16", "int32", 7, 13, 0): 7,
        ("cint16", "int32", 8, 13, 0): 2,
        ("cint16", "int32", 9, 13, 0): 9,
        ("cint16", "int32", 10, 13, 0): 5,
        ("cint16", "int32", 11, 13, 0): 11,
        ("cint16", "int32", 12, 13, 0): 3,
        ("cint16", "int32", 13, 13, 0): 13,
        ("cint16", "int32", 14, 13, 0): 7,
        ("cint16", "int32", 15, 13, 0): 15,
        ("cint16", "int32", 16, 13, 0): 4,
        ("cint16", "int32", 1, 14, 0): 1,
        ("cint16", "int32", 2, 14, 0): 1,
        ("cint16", "int32", 3, 14, 0): 3,
        ("cint16", "int32", 4, 14, 0): 1,
        ("cint16", "int32", 5, 14, 0): 5,
        ("cint16", "int32", 6, 14, 0): 3,
        ("cint16", "int32", 7, 14, 0): 7,
        ("cint16", "int32", 8, 14, 0): 1,
        ("cint16", "int32", 9, 14, 0): 9,
        ("cint16", "int32", 10, 14, 0): 5,
        ("cint16", "int32", 11, 14, 0): 11,
        ("cint16", "int32", 12, 14, 0): 3,
        ("cint16", "int32", 13, 14, 0): 13,
        ("cint16", "int32", 14, 14, 0): 7,
        ("cint16", "int32", 15, 14, 0): 15,
        ("cint16", "int32", 16, 14, 0): 2,
        ("cint16", "int32", 1, 15, 0): 1,
        ("cint16", "int32", 2, 15, 0): 1,
        ("cint16", "int32", 3, 15, 0): 3,
        ("cint16", "int32", 4, 15, 0): 1,
        ("cint16", "int32", 5, 15, 0): 5,
        ("cint16", "int32", 6, 15, 0): 3,
        ("cint16", "int32", 7, 15, 0): 7,
        ("cint16", "int32", 8, 15, 0): 2,
        ("cint16", "int32", 9, 15, 0): 9,
        ("cint16", "int32", 10, 15, 0): 5,
        ("cint16", "int32", 11, 15, 0): 11,
        ("cint16", "int32", 12, 15, 0): 3,
        ("cint16", "int32", 13, 15, 0): 13,
        ("cint16", "int32", 14, 15, 0): 7,
        ("cint16", "int32", 15, 15, 0): 15,
        ("cint16", "int32", 16, 15, 0): 4,
        ("cint16", "int32", 1, 16, 0): 1,
        ("cint16", "int32", 2, 16, 0): 1,
        ("cint16", "int32", 3, 16, 0): 3,
        ("cint16", "int32", 4, 16, 0): 1,
        ("cint16", "int32", 5, 16, 0): 5,
        ("cint16", "int32", 6, 16, 0): 3,
        ("cint16", "int32", 7, 16, 0): 7,
        ("cint16", "int32", 8, 16, 0): 1,
        ("cint16", "int32", 9, 16, 0): 9,
        ("cint16", "int32", 10, 16, 0): 5,
        ("cint16", "int32", 11, 16, 0): 11,
        ("cint16", "int32", 12, 16, 0): 3,
        ("cint16", "int32", 13, 16, 0): 13,
        ("cint16", "int32", 14, 16, 0): 7,
        ("cint16", "int32", 15, 16, 0): 15,
        ("cint16", "int32", 16, 16, 0): 1,
        ("cint16", "int32", 1, 1, 1): 1,
        ("cint16", "int32", 2, 1, 1): 1,
        ("cint16", "int32", 3, 1, 1): 3,
        ("cint16", "int32", 4, 1, 1): 2,
        ("cint16", "int32", 5, 1, 1): 5,
        ("cint16", "int32", 6, 1, 1): 3,
        ("cint16", "int32", 7, 1, 1): 7,
        ("cint16", "int32", 8, 1, 1): 4,
        ("cint16", "int32", 9, 1, 1): 9,
        ("cint16", "int32", 10, 1, 1): 5,
        ("cint16", "int32", 11, 1, 1): 11,
        ("cint16", "int32", 12, 1, 1): 6,
        ("cint16", "int32", 13, 1, 1): 13,
        ("cint16", "int32", 14, 1, 1): 7,
        ("cint16", "int32", 15, 1, 1): 15,
        ("cint16", "int32", 16, 1, 1): 8,
        ("cint16", "int32", 1, 2, 1): 1,
        ("cint16", "int32", 2, 2, 1): 1,
        ("cint16", "int32", 3, 2, 1): 3,
        ("cint16", "int32", 4, 2, 1): 1,
        ("cint16", "int32", 5, 2, 1): 5,
        ("cint16", "int32", 6, 2, 1): 3,
        ("cint16", "int32", 7, 2, 1): 7,
        ("cint16", "int32", 8, 2, 1): 2,
        ("cint16", "int32", 9, 2, 1): 9,
        ("cint16", "int32", 10, 2, 1): 5,
        ("cint16", "int32", 11, 2, 1): 11,
        ("cint16", "int32", 12, 2, 1): 3,
        ("cint16", "int32", 13, 2, 1): 13,
        ("cint16", "int32", 14, 2, 1): 7,
        ("cint16", "int32", 15, 2, 1): 15,
        ("cint16", "int32", 16, 2, 1): 4,
        ("cint16", "int32", 1, 3, 1): 1,
        ("cint16", "int32", 2, 3, 1): 1,
        ("cint16", "int32", 3, 3, 1): 3,
        ("cint16", "int32", 4, 3, 1): 2,
        ("cint16", "int32", 5, 3, 1): 5,
        ("cint16", "int32", 6, 3, 1): 3,
        ("cint16", "int32", 7, 3, 1): 7,
        ("cint16", "int32", 8, 3, 1): 4,
        ("cint16", "int32", 9, 3, 1): 9,
        ("cint16", "int32", 10, 3, 1): 5,
        ("cint16", "int32", 11, 3, 1): 11,
        ("cint16", "int32", 12, 3, 1): 6,
        ("cint16", "int32", 13, 3, 1): 13,
        ("cint16", "int32", 14, 3, 1): 7,
        ("cint16", "int32", 15, 3, 1): 15,
        ("cint16", "int32", 16, 3, 1): 8,
        ("cint16", "int32", 1, 4, 1): 1,
        ("cint16", "int32", 2, 4, 1): 1,
        ("cint16", "int32", 3, 4, 1): 3,
        ("cint16", "int32", 4, 4, 1): 1,
        ("cint16", "int32", 5, 4, 1): 5,
        ("cint16", "int32", 6, 4, 1): 3,
        ("cint16", "int32", 7, 4, 1): 7,
        ("cint16", "int32", 8, 4, 1): 1,
        ("cint16", "int32", 9, 4, 1): 9,
        ("cint16", "int32", 10, 4, 1): 5,
        ("cint16", "int32", 11, 4, 1): 11,
        ("cint16", "int32", 12, 4, 1): 3,
        ("cint16", "int32", 13, 4, 1): 13,
        ("cint16", "int32", 14, 4, 1): 7,
        ("cint16", "int32", 15, 4, 1): 15,
        ("cint16", "int32", 16, 4, 1): 2,
        ("cint16", "int32", 1, 5, 1): 1,
        ("cint16", "int32", 2, 5, 1): 1,
        ("cint16", "int32", 3, 5, 1): 3,
        ("cint16", "int32", 4, 5, 1): 2,
        ("cint16", "int32", 5, 5, 1): 5,
        ("cint16", "int32", 6, 5, 1): 3,
        ("cint16", "int32", 7, 5, 1): 7,
        ("cint16", "int32", 8, 5, 1): 4,
        ("cint16", "int32", 9, 5, 1): 9,
        ("cint16", "int32", 10, 5, 1): 5,
        ("cint16", "int32", 11, 5, 1): 11,
        ("cint16", "int32", 12, 5, 1): 6,
        ("cint16", "int32", 13, 5, 1): 13,
        ("cint16", "int32", 14, 5, 1): 7,
        ("cint16", "int32", 15, 5, 1): 15,
        ("cint16", "int32", 16, 5, 1): 8,
        ("cint16", "int32", 1, 6, 1): 1,
        ("cint16", "int32", 2, 6, 1): 1,
        ("cint16", "int32", 3, 6, 1): 3,
        ("cint16", "int32", 4, 6, 1): 1,
        ("cint16", "int32", 5, 6, 1): 5,
        ("cint16", "int32", 6, 6, 1): 3,
        ("cint16", "int32", 7, 6, 1): 7,
        ("cint16", "int32", 8, 6, 1): 2,
        ("cint16", "int32", 9, 6, 1): 9,
        ("cint16", "int32", 10, 6, 1): 5,
        ("cint16", "int32", 11, 6, 1): 11,
        ("cint16", "int32", 12, 6, 1): 3,
        ("cint16", "int32", 13, 6, 1): 13,
        ("cint16", "int32", 14, 6, 1): 7,
        ("cint16", "int32", 15, 6, 1): 15,
        ("cint16", "int32", 16, 6, 1): 4,
        ("cint16", "int32", 1, 7, 1): 1,
        ("cint16", "int32", 2, 7, 1): 1,
        ("cint16", "int32", 3, 7, 1): 3,
        ("cint16", "int32", 4, 7, 1): 2,
        ("cint16", "int32", 5, 7, 1): 5,
        ("cint16", "int32", 6, 7, 1): 3,
        ("cint16", "int32", 7, 7, 1): 7,
        ("cint16", "int32", 8, 7, 1): 4,
        ("cint16", "int32", 9, 7, 1): 9,
        ("cint16", "int32", 10, 7, 1): 5,
        ("cint16", "int32", 11, 7, 1): 11,
        ("cint16", "int32", 12, 7, 1): 6,
        ("cint16", "int32", 13, 7, 1): 13,
        ("cint16", "int32", 14, 7, 1): 7,
        ("cint16", "int32", 15, 7, 1): 15,
        ("cint16", "int32", 16, 7, 1): 8,
        ("cint16", "int32", 1, 8, 1): 1,
        ("cint16", "int32", 2, 8, 1): 1,
        ("cint16", "int32", 3, 8, 1): 3,
        ("cint16", "int32", 4, 8, 1): 1,
        ("cint16", "int32", 5, 8, 1): 5,
        ("cint16", "int32", 6, 8, 1): 3,
        ("cint16", "int32", 7, 8, 1): 7,
        ("cint16", "int32", 8, 8, 1): 1,
        ("cint16", "int32", 9, 8, 1): 9,
        ("cint16", "int32", 10, 8, 1): 5,
        ("cint16", "int32", 11, 8, 1): 11,
        ("cint16", "int32", 12, 8, 1): 3,
        ("cint16", "int32", 13, 8, 1): 13,
        ("cint16", "int32", 14, 8, 1): 7,
        ("cint16", "int32", 15, 8, 1): 15,
        ("cint16", "int32", 16, 8, 1): 2,
        ("cint16", "int32", 1, 9, 1): 1,
        ("cint16", "int32", 2, 9, 1): 1,
        ("cint16", "int32", 3, 9, 1): 3,
        ("cint16", "int32", 4, 9, 1): 2,
        ("cint16", "int32", 5, 9, 1): 5,
        ("cint16", "int32", 6, 9, 1): 3,
        ("cint16", "int32", 7, 9, 1): 7,
        ("cint16", "int32", 8, 9, 1): 4,
        ("cint16", "int32", 9, 9, 1): 9,
        ("cint16", "int32", 10, 9, 1): 5,
        ("cint16", "int32", 11, 9, 1): 11,
        ("cint16", "int32", 12, 9, 1): 6,
        ("cint16", "int32", 13, 9, 1): 13,
        ("cint16", "int32", 14, 9, 1): 7,
        ("cint16", "int32", 15, 9, 1): 15,
        ("cint16", "int32", 16, 9, 1): 8,
        ("cint16", "int32", 1, 10, 1): 1,
        ("cint16", "int32", 2, 10, 1): 1,
        ("cint16", "int32", 3, 10, 1): 3,
        ("cint16", "int32", 4, 10, 1): 1,
        ("cint16", "int32", 5, 10, 1): 5,
        ("cint16", "int32", 6, 10, 1): 3,
        ("cint16", "int32", 7, 10, 1): 7,
        ("cint16", "int32", 8, 10, 1): 2,
        ("cint16", "int32", 9, 10, 1): 9,
        ("cint16", "int32", 10, 10, 1): 5,
        ("cint16", "int32", 11, 10, 1): 11,
        ("cint16", "int32", 12, 10, 1): 3,
        ("cint16", "int32", 13, 10, 1): 13,
        ("cint16", "int32", 14, 10, 1): 7,
        ("cint16", "int32", 15, 10, 1): 15,
        ("cint16", "int32", 16, 10, 1): 4,
        ("cint16", "int32", 1, 11, 1): 1,
        ("cint16", "int32", 2, 11, 1): 1,
        ("cint16", "int32", 3, 11, 1): 3,
        ("cint16", "int32", 4, 11, 1): 2,
        ("cint16", "int32", 5, 11, 1): 5,
        ("cint16", "int32", 6, 11, 1): 3,
        ("cint16", "int32", 7, 11, 1): 7,
        ("cint16", "int32", 8, 11, 1): 4,
        ("cint16", "int32", 9, 11, 1): 9,
        ("cint16", "int32", 10, 11, 1): 5,
        ("cint16", "int32", 11, 11, 1): 11,
        ("cint16", "int32", 12, 11, 1): 6,
        ("cint16", "int32", 13, 11, 1): 13,
        ("cint16", "int32", 14, 11, 1): 7,
        ("cint16", "int32", 15, 11, 1): 15,
        ("cint16", "int32", 16, 11, 1): 8,
        ("cint16", "int32", 1, 12, 1): 1,
        ("cint16", "int32", 2, 12, 1): 1,
        ("cint16", "int32", 3, 12, 1): 3,
        ("cint16", "int32", 4, 12, 1): 1,
        ("cint16", "int32", 5, 12, 1): 5,
        ("cint16", "int32", 6, 12, 1): 3,
        ("cint16", "int32", 7, 12, 1): 7,
        ("cint16", "int32", 8, 12, 1): 1,
        ("cint16", "int32", 9, 12, 1): 9,
        ("cint16", "int32", 10, 12, 1): 5,
        ("cint16", "int32", 11, 12, 1): 11,
        ("cint16", "int32", 12, 12, 1): 3,
        ("cint16", "int32", 13, 12, 1): 13,
        ("cint16", "int32", 14, 12, 1): 7,
        ("cint16", "int32", 15, 12, 1): 15,
        ("cint16", "int32", 16, 12, 1): 2,
        ("cint16", "int32", 1, 13, 1): 1,
        ("cint16", "int32", 2, 13, 1): 1,
        ("cint16", "int32", 3, 13, 1): 3,
        ("cint16", "int32", 4, 13, 1): 2,
        ("cint16", "int32", 5, 13, 1): 5,
        ("cint16", "int32", 6, 13, 1): 3,
        ("cint16", "int32", 7, 13, 1): 7,
        ("cint16", "int32", 8, 13, 1): 4,
        ("cint16", "int32", 9, 13, 1): 9,
        ("cint16", "int32", 10, 13, 1): 5,
        ("cint16", "int32", 11, 13, 1): 11,
        ("cint16", "int32", 12, 13, 1): 6,
        ("cint16", "int32", 13, 13, 1): 13,
        ("cint16", "int32", 14, 13, 1): 7,
        ("cint16", "int32", 15, 13, 1): 15,
        ("cint16", "int32", 16, 13, 1): 8,
        ("cint16", "int32", 1, 14, 1): 1,
        ("cint16", "int32", 2, 14, 1): 1,
        ("cint16", "int32", 3, 14, 1): 3,
        ("cint16", "int32", 4, 14, 1): 1,
        ("cint16", "int32", 5, 14, 1): 5,
        ("cint16", "int32", 6, 14, 1): 3,
        ("cint16", "int32", 7, 14, 1): 7,
        ("cint16", "int32", 8, 14, 1): 2,
        ("cint16", "int32", 9, 14, 1): 9,
        ("cint16", "int32", 10, 14, 1): 5,
        ("cint16", "int32", 11, 14, 1): 11,
        ("cint16", "int32", 12, 14, 1): 3,
        ("cint16", "int32", 13, 14, 1): 13,
        ("cint16", "int32", 14, 14, 1): 7,
        ("cint16", "int32", 15, 14, 1): 15,
        ("cint16", "int32", 16, 14, 1): 4,
        ("cint16", "int32", 1, 15, 1): 1,
        ("cint16", "int32", 2, 15, 1): 1,
        ("cint16", "int32", 3, 15, 1): 3,
        ("cint16", "int32", 4, 15, 1): 2,
        ("cint16", "int32", 5, 15, 1): 5,
        ("cint16", "int32", 6, 15, 1): 3,
        ("cint16", "int32", 7, 15, 1): 7,
        ("cint16", "int32", 8, 15, 1): 4,
        ("cint16", "int32", 9, 15, 1): 9,
        ("cint16", "int32", 10, 15, 1): 5,
        ("cint16", "int32", 11, 15, 1): 11,
        ("cint16", "int32", 12, 15, 1): 6,
        ("cint16", "int32", 13, 15, 1): 13,
        ("cint16", "int32", 14, 15, 1): 7,
        ("cint16", "int32", 15, 15, 1): 15,
        ("cint16", "int32", 16, 15, 1): 8,
        ("cint16", "int32", 1, 16, 1): 1,
        ("cint16", "int32", 2, 16, 1): 1,
        ("cint16", "int32", 3, 16, 1): 3,
        ("cint16", "int32", 4, 16, 1): 1,
        ("cint16", "int32", 5, 16, 1): 5,
        ("cint16", "int32", 6, 16, 1): 3,
        ("cint16", "int32", 7, 16, 1): 7,
        ("cint16", "int32", 8, 16, 1): 1,
        ("cint16", "int32", 9, 16, 1): 9,
        ("cint16", "int32", 10, 16, 1): 5,
        ("cint16", "int32", 11, 16, 1): 11,
        ("cint16", "int32", 12, 16, 1): 3,
        ("cint16", "int32", 13, 16, 1): 13,
        ("cint16", "int32", 14, 16, 1): 7,
        ("cint16", "int32", 15, 16, 1): 15,
        ("cint16", "int32", 16, 16, 1): 2,
        ("cint16", "cint32", 1, 1, 0): 1,
        ("cint16", "cint32", 2, 1, 0): 1,
        ("cint16", "cint32", 3, 1, 0): 3,
        ("cint16", "cint32", 4, 1, 0): 1,
        ("cint16", "cint32", 5, 1, 0): 5,
        ("cint16", "cint32", 6, 1, 0): 3,
        ("cint16", "cint32", 7, 1, 0): 7,
        ("cint16", "cint32", 8, 1, 0): 2,
        ("cint16", "cint32", 9, 1, 0): 9,
        ("cint16", "cint32", 10, 1, 0): 5,
        ("cint16", "cint32", 11, 1, 0): 11,
        ("cint16", "cint32", 12, 1, 0): 3,
        ("cint16", "cint32", 13, 1, 0): 13,
        ("cint16", "cint32", 14, 1, 0): 7,
        ("cint16", "cint32", 15, 1, 0): 15,
        ("cint16", "cint32", 16, 1, 0): 4,
        ("cint16", "cint32", 1, 2, 0): 1,
        ("cint16", "cint32", 2, 2, 0): 1,
        ("cint16", "cint32", 3, 2, 0): 3,
        ("cint16", "cint32", 4, 2, 0): 1,
        ("cint16", "cint32", 5, 2, 0): 5,
        ("cint16", "cint32", 6, 2, 0): 3,
        ("cint16", "cint32", 7, 2, 0): 7,
        ("cint16", "cint32", 8, 2, 0): 1,
        ("cint16", "cint32", 9, 2, 0): 9,
        ("cint16", "cint32", 10, 2, 0): 5,
        ("cint16", "cint32", 11, 2, 0): 11,
        ("cint16", "cint32", 12, 2, 0): 3,
        ("cint16", "cint32", 13, 2, 0): 13,
        ("cint16", "cint32", 14, 2, 0): 7,
        ("cint16", "cint32", 15, 2, 0): 15,
        ("cint16", "cint32", 16, 2, 0): 2,
        ("cint16", "cint32", 1, 3, 0): 1,
        ("cint16", "cint32", 2, 3, 0): 1,
        ("cint16", "cint32", 3, 3, 0): 3,
        ("cint16", "cint32", 4, 3, 0): 1,
        ("cint16", "cint32", 5, 3, 0): 5,
        ("cint16", "cint32", 6, 3, 0): 3,
        ("cint16", "cint32", 7, 3, 0): 7,
        ("cint16", "cint32", 8, 3, 0): 2,
        ("cint16", "cint32", 9, 3, 0): 9,
        ("cint16", "cint32", 10, 3, 0): 5,
        ("cint16", "cint32", 11, 3, 0): 11,
        ("cint16", "cint32", 12, 3, 0): 3,
        ("cint16", "cint32", 13, 3, 0): 13,
        ("cint16", "cint32", 14, 3, 0): 7,
        ("cint16", "cint32", 15, 3, 0): 15,
        ("cint16", "cint32", 16, 3, 0): 4,
        ("cint16", "cint32", 1, 4, 0): 1,
        ("cint16", "cint32", 2, 4, 0): 1,
        ("cint16", "cint32", 3, 4, 0): 3,
        ("cint16", "cint32", 4, 4, 0): 1,
        ("cint16", "cint32", 5, 4, 0): 5,
        ("cint16", "cint32", 6, 4, 0): 3,
        ("cint16", "cint32", 7, 4, 0): 7,
        ("cint16", "cint32", 8, 4, 0): 1,
        ("cint16", "cint32", 9, 4, 0): 9,
        ("cint16", "cint32", 10, 4, 0): 5,
        ("cint16", "cint32", 11, 4, 0): 11,
        ("cint16", "cint32", 12, 4, 0): 3,
        ("cint16", "cint32", 13, 4, 0): 13,
        ("cint16", "cint32", 14, 4, 0): 7,
        ("cint16", "cint32", 15, 4, 0): 15,
        ("cint16", "cint32", 16, 4, 0): 1,
        ("cint16", "cint32", 1, 5, 0): 1,
        ("cint16", "cint32", 2, 5, 0): 1,
        ("cint16", "cint32", 3, 5, 0): 3,
        ("cint16", "cint32", 4, 5, 0): 1,
        ("cint16", "cint32", 5, 5, 0): 5,
        ("cint16", "cint32", 6, 5, 0): 3,
        ("cint16", "cint32", 7, 5, 0): 7,
        ("cint16", "cint32", 8, 5, 0): 2,
        ("cint16", "cint32", 9, 5, 0): 9,
        ("cint16", "cint32", 10, 5, 0): 5,
        ("cint16", "cint32", 11, 5, 0): 11,
        ("cint16", "cint32", 12, 5, 0): 3,
        ("cint16", "cint32", 13, 5, 0): 13,
        ("cint16", "cint32", 14, 5, 0): 7,
        ("cint16", "cint32", 15, 5, 0): 15,
        ("cint16", "cint32", 16, 5, 0): 4,
        ("cint16", "cint32", 1, 6, 0): 1,
        ("cint16", "cint32", 2, 6, 0): 1,
        ("cint16", "cint32", 3, 6, 0): 3,
        ("cint16", "cint32", 4, 6, 0): 1,
        ("cint16", "cint32", 5, 6, 0): 5,
        ("cint16", "cint32", 6, 6, 0): 3,
        ("cint16", "cint32", 7, 6, 0): 7,
        ("cint16", "cint32", 8, 6, 0): 1,
        ("cint16", "cint32", 9, 6, 0): 9,
        ("cint16", "cint32", 10, 6, 0): 5,
        ("cint16", "cint32", 11, 6, 0): 11,
        ("cint16", "cint32", 12, 6, 0): 3,
        ("cint16", "cint32", 13, 6, 0): 13,
        ("cint16", "cint32", 14, 6, 0): 7,
        ("cint16", "cint32", 15, 6, 0): 15,
        ("cint16", "cint32", 16, 6, 0): 2,
        ("cint16", "cint32", 1, 7, 0): 1,
        ("cint16", "cint32", 2, 7, 0): 1,
        ("cint16", "cint32", 3, 7, 0): 3,
        ("cint16", "cint32", 4, 7, 0): 1,
        ("cint16", "cint32", 5, 7, 0): 5,
        ("cint16", "cint32", 6, 7, 0): 3,
        ("cint16", "cint32", 7, 7, 0): 7,
        ("cint16", "cint32", 8, 7, 0): 2,
        ("cint16", "cint32", 9, 7, 0): 9,
        ("cint16", "cint32", 10, 7, 0): 5,
        ("cint16", "cint32", 11, 7, 0): 11,
        ("cint16", "cint32", 12, 7, 0): 3,
        ("cint16", "cint32", 13, 7, 0): 13,
        ("cint16", "cint32", 14, 7, 0): 7,
        ("cint16", "cint32", 15, 7, 0): 15,
        ("cint16", "cint32", 16, 7, 0): 4,
        ("cint16", "cint32", 1, 8, 0): 1,
        ("cint16", "cint32", 2, 8, 0): 1,
        ("cint16", "cint32", 3, 8, 0): 3,
        ("cint16", "cint32", 4, 8, 0): 1,
        ("cint16", "cint32", 5, 8, 0): 5,
        ("cint16", "cint32", 6, 8, 0): 3,
        ("cint16", "cint32", 7, 8, 0): 7,
        ("cint16", "cint32", 8, 8, 0): 1,
        ("cint16", "cint32", 9, 8, 0): 9,
        ("cint16", "cint32", 10, 8, 0): 5,
        ("cint16", "cint32", 11, 8, 0): 11,
        ("cint16", "cint32", 12, 8, 0): 3,
        ("cint16", "cint32", 13, 8, 0): 13,
        ("cint16", "cint32", 14, 8, 0): 7,
        ("cint16", "cint32", 15, 8, 0): 15,
        ("cint16", "cint32", 16, 8, 0): 1,
        ("cint16", "cint32", 1, 9, 0): 1,
        ("cint16", "cint32", 2, 9, 0): 1,
        ("cint16", "cint32", 3, 9, 0): 3,
        ("cint16", "cint32", 4, 9, 0): 1,
        ("cint16", "cint32", 5, 9, 0): 5,
        ("cint16", "cint32", 6, 9, 0): 3,
        ("cint16", "cint32", 7, 9, 0): 7,
        ("cint16", "cint32", 8, 9, 0): 2,
        ("cint16", "cint32", 9, 9, 0): 9,
        ("cint16", "cint32", 10, 9, 0): 5,
        ("cint16", "cint32", 11, 9, 0): 11,
        ("cint16", "cint32", 12, 9, 0): 3,
        ("cint16", "cint32", 13, 9, 0): 13,
        ("cint16", "cint32", 14, 9, 0): 7,
        ("cint16", "cint32", 15, 9, 0): 15,
        ("cint16", "cint32", 16, 9, 0): 4,
        ("cint16", "cint32", 1, 10, 0): 1,
        ("cint16", "cint32", 2, 10, 0): 1,
        ("cint16", "cint32", 3, 10, 0): 3,
        ("cint16", "cint32", 4, 10, 0): 1,
        ("cint16", "cint32", 5, 10, 0): 5,
        ("cint16", "cint32", 6, 10, 0): 3,
        ("cint16", "cint32", 7, 10, 0): 7,
        ("cint16", "cint32", 8, 10, 0): 1,
        ("cint16", "cint32", 9, 10, 0): 9,
        ("cint16", "cint32", 10, 10, 0): 5,
        ("cint16", "cint32", 11, 10, 0): 11,
        ("cint16", "cint32", 12, 10, 0): 3,
        ("cint16", "cint32", 13, 10, 0): 13,
        ("cint16", "cint32", 14, 10, 0): 7,
        ("cint16", "cint32", 15, 10, 0): 15,
        ("cint16", "cint32", 16, 10, 0): 2,
        ("cint16", "cint32", 1, 11, 0): 1,
        ("cint16", "cint32", 2, 11, 0): 1,
        ("cint16", "cint32", 3, 11, 0): 3,
        ("cint16", "cint32", 4, 11, 0): 1,
        ("cint16", "cint32", 5, 11, 0): 5,
        ("cint16", "cint32", 6, 11, 0): 3,
        ("cint16", "cint32", 7, 11, 0): 7,
        ("cint16", "cint32", 8, 11, 0): 2,
        ("cint16", "cint32", 9, 11, 0): 9,
        ("cint16", "cint32", 10, 11, 0): 5,
        ("cint16", "cint32", 11, 11, 0): 11,
        ("cint16", "cint32", 12, 11, 0): 3,
        ("cint16", "cint32", 13, 11, 0): 13,
        ("cint16", "cint32", 14, 11, 0): 7,
        ("cint16", "cint32", 15, 11, 0): 15,
        ("cint16", "cint32", 16, 11, 0): 4,
        ("cint16", "cint32", 1, 12, 0): 1,
        ("cint16", "cint32", 2, 12, 0): 1,
        ("cint16", "cint32", 3, 12, 0): 3,
        ("cint16", "cint32", 4, 12, 0): 1,
        ("cint16", "cint32", 5, 12, 0): 5,
        ("cint16", "cint32", 6, 12, 0): 3,
        ("cint16", "cint32", 7, 12, 0): 7,
        ("cint16", "cint32", 8, 12, 0): 1,
        ("cint16", "cint32", 9, 12, 0): 9,
        ("cint16", "cint32", 10, 12, 0): 5,
        ("cint16", "cint32", 11, 12, 0): 11,
        ("cint16", "cint32", 12, 12, 0): 3,
        ("cint16", "cint32", 13, 12, 0): 13,
        ("cint16", "cint32", 14, 12, 0): 7,
        ("cint16", "cint32", 15, 12, 0): 15,
        ("cint16", "cint32", 16, 12, 0): 1,
        ("cint16", "cint32", 1, 13, 0): 1,
        ("cint16", "cint32", 2, 13, 0): 1,
        ("cint16", "cint32", 3, 13, 0): 3,
        ("cint16", "cint32", 4, 13, 0): 1,
        ("cint16", "cint32", 5, 13, 0): 5,
        ("cint16", "cint32", 6, 13, 0): 3,
        ("cint16", "cint32", 7, 13, 0): 7,
        ("cint16", "cint32", 8, 13, 0): 2,
        ("cint16", "cint32", 9, 13, 0): 9,
        ("cint16", "cint32", 10, 13, 0): 5,
        ("cint16", "cint32", 11, 13, 0): 11,
        ("cint16", "cint32", 12, 13, 0): 3,
        ("cint16", "cint32", 13, 13, 0): 13,
        ("cint16", "cint32", 14, 13, 0): 7,
        ("cint16", "cint32", 15, 13, 0): 15,
        ("cint16", "cint32", 16, 13, 0): 4,
        ("cint16", "cint32", 1, 14, 0): 1,
        ("cint16", "cint32", 2, 14, 0): 1,
        ("cint16", "cint32", 3, 14, 0): 3,
        ("cint16", "cint32", 4, 14, 0): 1,
        ("cint16", "cint32", 5, 14, 0): 5,
        ("cint16", "cint32", 6, 14, 0): 3,
        ("cint16", "cint32", 7, 14, 0): 7,
        ("cint16", "cint32", 8, 14, 0): 1,
        ("cint16", "cint32", 9, 14, 0): 9,
        ("cint16", "cint32", 10, 14, 0): 5,
        ("cint16", "cint32", 11, 14, 0): 11,
        ("cint16", "cint32", 12, 14, 0): 3,
        ("cint16", "cint32", 13, 14, 0): 13,
        ("cint16", "cint32", 14, 14, 0): 7,
        ("cint16", "cint32", 15, 14, 0): 15,
        ("cint16", "cint32", 16, 14, 0): 2,
        ("cint16", "cint32", 1, 15, 0): 1,
        ("cint16", "cint32", 2, 15, 0): 1,
        ("cint16", "cint32", 3, 15, 0): 3,
        ("cint16", "cint32", 4, 15, 0): 1,
        ("cint16", "cint32", 5, 15, 0): 5,
        ("cint16", "cint32", 6, 15, 0): 3,
        ("cint16", "cint32", 7, 15, 0): 7,
        ("cint16", "cint32", 8, 15, 0): 2,
        ("cint16", "cint32", 9, 15, 0): 9,
        ("cint16", "cint32", 10, 15, 0): 5,
        ("cint16", "cint32", 11, 15, 0): 11,
        ("cint16", "cint32", 12, 15, 0): 3,
        ("cint16", "cint32", 13, 15, 0): 13,
        ("cint16", "cint32", 14, 15, 0): 7,
        ("cint16", "cint32", 15, 15, 0): 15,
        ("cint16", "cint32", 16, 15, 0): 4,
        ("cint16", "cint32", 1, 16, 0): 1,
        ("cint16", "cint32", 2, 16, 0): 1,
        ("cint16", "cint32", 3, 16, 0): 3,
        ("cint16", "cint32", 4, 16, 0): 1,
        ("cint16", "cint32", 5, 16, 0): 5,
        ("cint16", "cint32", 6, 16, 0): 3,
        ("cint16", "cint32", 7, 16, 0): 7,
        ("cint16", "cint32", 8, 16, 0): 1,
        ("cint16", "cint32", 9, 16, 0): 9,
        ("cint16", "cint32", 10, 16, 0): 5,
        ("cint16", "cint32", 11, 16, 0): 11,
        ("cint16", "cint32", 12, 16, 0): 3,
        ("cint16", "cint32", 13, 16, 0): 13,
        ("cint16", "cint32", 14, 16, 0): 7,
        ("cint16", "cint32", 15, 16, 0): 15,
        ("cint16", "cint32", 16, 16, 0): 1,
        ("cint16", "cint32", 1, 1, 1): 1,
        ("cint16", "cint32", 2, 1, 1): 1,
        ("cint16", "cint32", 3, 1, 1): 3,
        ("cint16", "cint32", 4, 1, 1): 2,
        ("cint16", "cint32", 5, 1, 1): 5,
        ("cint16", "cint32", 6, 1, 1): 3,
        ("cint16", "cint32", 7, 1, 1): 7,
        ("cint16", "cint32", 8, 1, 1): 4,
        ("cint16", "cint32", 9, 1, 1): 9,
        ("cint16", "cint32", 10, 1, 1): 5,
        ("cint16", "cint32", 11, 1, 1): 11,
        ("cint16", "cint32", 12, 1, 1): 6,
        ("cint16", "cint32", 13, 1, 1): 13,
        ("cint16", "cint32", 14, 1, 1): 7,
        ("cint16", "cint32", 15, 1, 1): 15,
        ("cint16", "cint32", 16, 1, 1): 8,
        ("cint16", "cint32", 1, 2, 1): 1,
        ("cint16", "cint32", 2, 2, 1): 1,
        ("cint16", "cint32", 3, 2, 1): 3,
        ("cint16", "cint32", 4, 2, 1): 1,
        ("cint16", "cint32", 5, 2, 1): 5,
        ("cint16", "cint32", 6, 2, 1): 3,
        ("cint16", "cint32", 7, 2, 1): 7,
        ("cint16", "cint32", 8, 2, 1): 2,
        ("cint16", "cint32", 9, 2, 1): 9,
        ("cint16", "cint32", 10, 2, 1): 5,
        ("cint16", "cint32", 11, 2, 1): 11,
        ("cint16", "cint32", 12, 2, 1): 3,
        ("cint16", "cint32", 13, 2, 1): 13,
        ("cint16", "cint32", 14, 2, 1): 7,
        ("cint16", "cint32", 15, 2, 1): 15,
        ("cint16", "cint32", 16, 2, 1): 4,
        ("cint16", "cint32", 1, 3, 1): 1,
        ("cint16", "cint32", 2, 3, 1): 1,
        ("cint16", "cint32", 3, 3, 1): 3,
        ("cint16", "cint32", 4, 3, 1): 2,
        ("cint16", "cint32", 5, 3, 1): 5,
        ("cint16", "cint32", 6, 3, 1): 3,
        ("cint16", "cint32", 7, 3, 1): 7,
        ("cint16", "cint32", 8, 3, 1): 4,
        ("cint16", "cint32", 9, 3, 1): 9,
        ("cint16", "cint32", 10, 3, 1): 5,
        ("cint16", "cint32", 11, 3, 1): 11,
        ("cint16", "cint32", 12, 3, 1): 6,
        ("cint16", "cint32", 13, 3, 1): 13,
        ("cint16", "cint32", 14, 3, 1): 7,
        ("cint16", "cint32", 15, 3, 1): 15,
        ("cint16", "cint32", 16, 3, 1): 8,
        ("cint16", "cint32", 1, 4, 1): 1,
        ("cint16", "cint32", 2, 4, 1): 1,
        ("cint16", "cint32", 3, 4, 1): 3,
        ("cint16", "cint32", 4, 4, 1): 1,
        ("cint16", "cint32", 5, 4, 1): 5,
        ("cint16", "cint32", 6, 4, 1): 3,
        ("cint16", "cint32", 7, 4, 1): 7,
        ("cint16", "cint32", 8, 4, 1): 1,
        ("cint16", "cint32", 9, 4, 1): 9,
        ("cint16", "cint32", 10, 4, 1): 5,
        ("cint16", "cint32", 11, 4, 1): 11,
        ("cint16", "cint32", 12, 4, 1): 3,
        ("cint16", "cint32", 13, 4, 1): 13,
        ("cint16", "cint32", 14, 4, 1): 7,
        ("cint16", "cint32", 15, 4, 1): 15,
        ("cint16", "cint32", 16, 4, 1): 2,
        ("cint16", "cint32", 1, 5, 1): 1,
        ("cint16", "cint32", 2, 5, 1): 1,
        ("cint16", "cint32", 3, 5, 1): 3,
        ("cint16", "cint32", 4, 5, 1): 2,
        ("cint16", "cint32", 5, 5, 1): 5,
        ("cint16", "cint32", 6, 5, 1): 3,
        ("cint16", "cint32", 7, 5, 1): 7,
        ("cint16", "cint32", 8, 5, 1): 4,
        ("cint16", "cint32", 9, 5, 1): 9,
        ("cint16", "cint32", 10, 5, 1): 5,
        ("cint16", "cint32", 11, 5, 1): 11,
        ("cint16", "cint32", 12, 5, 1): 6,
        ("cint16", "cint32", 13, 5, 1): 13,
        ("cint16", "cint32", 14, 5, 1): 7,
        ("cint16", "cint32", 15, 5, 1): 15,
        ("cint16", "cint32", 16, 5, 1): 8,
        ("cint16", "cint32", 1, 6, 1): 1,
        ("cint16", "cint32", 2, 6, 1): 1,
        ("cint16", "cint32", 3, 6, 1): 3,
        ("cint16", "cint32", 4, 6, 1): 1,
        ("cint16", "cint32", 5, 6, 1): 5,
        ("cint16", "cint32", 6, 6, 1): 3,
        ("cint16", "cint32", 7, 6, 1): 7,
        ("cint16", "cint32", 8, 6, 1): 2,
        ("cint16", "cint32", 9, 6, 1): 9,
        ("cint16", "cint32", 10, 6, 1): 5,
        ("cint16", "cint32", 11, 6, 1): 11,
        ("cint16", "cint32", 12, 6, 1): 3,
        ("cint16", "cint32", 13, 6, 1): 13,
        ("cint16", "cint32", 14, 6, 1): 7,
        ("cint16", "cint32", 15, 6, 1): 15,
        ("cint16", "cint32", 16, 6, 1): 4,
        ("cint16", "cint32", 1, 7, 1): 1,
        ("cint16", "cint32", 2, 7, 1): 1,
        ("cint16", "cint32", 3, 7, 1): 3,
        ("cint16", "cint32", 4, 7, 1): 2,
        ("cint16", "cint32", 5, 7, 1): 5,
        ("cint16", "cint32", 6, 7, 1): 3,
        ("cint16", "cint32", 7, 7, 1): 7,
        ("cint16", "cint32", 8, 7, 1): 4,
        ("cint16", "cint32", 9, 7, 1): 9,
        ("cint16", "cint32", 10, 7, 1): 5,
        ("cint16", "cint32", 11, 7, 1): 11,
        ("cint16", "cint32", 12, 7, 1): 6,
        ("cint16", "cint32", 13, 7, 1): 13,
        ("cint16", "cint32", 14, 7, 1): 7,
        ("cint16", "cint32", 15, 7, 1): 15,
        ("cint16", "cint32", 16, 7, 1): 8,
        ("cint16", "cint32", 1, 8, 1): 1,
        ("cint16", "cint32", 2, 8, 1): 1,
        ("cint16", "cint32", 3, 8, 1): 3,
        ("cint16", "cint32", 4, 8, 1): 1,
        ("cint16", "cint32", 5, 8, 1): 5,
        ("cint16", "cint32", 6, 8, 1): 3,
        ("cint16", "cint32", 7, 8, 1): 7,
        ("cint16", "cint32", 8, 8, 1): 1,
        ("cint16", "cint32", 9, 8, 1): 9,
        ("cint16", "cint32", 10, 8, 1): 5,
        ("cint16", "cint32", 11, 8, 1): 11,
        ("cint16", "cint32", 12, 8, 1): 3,
        ("cint16", "cint32", 13, 8, 1): 13,
        ("cint16", "cint32", 14, 8, 1): 7,
        ("cint16", "cint32", 15, 8, 1): 15,
        ("cint16", "cint32", 16, 8, 1): 2,
        ("cint16", "cint32", 1, 9, 1): 1,
        ("cint16", "cint32", 2, 9, 1): 1,
        ("cint16", "cint32", 3, 9, 1): 3,
        ("cint16", "cint32", 4, 9, 1): 2,
        ("cint16", "cint32", 5, 9, 1): 5,
        ("cint16", "cint32", 6, 9, 1): 3,
        ("cint16", "cint32", 7, 9, 1): 7,
        ("cint16", "cint32", 8, 9, 1): 4,
        ("cint16", "cint32", 9, 9, 1): 9,
        ("cint16", "cint32", 10, 9, 1): 5,
        ("cint16", "cint32", 11, 9, 1): 11,
        ("cint16", "cint32", 12, 9, 1): 6,
        ("cint16", "cint32", 13, 9, 1): 13,
        ("cint16", "cint32", 14, 9, 1): 7,
        ("cint16", "cint32", 15, 9, 1): 15,
        ("cint16", "cint32", 16, 9, 1): 8,
        ("cint16", "cint32", 1, 10, 1): 1,
        ("cint16", "cint32", 2, 10, 1): 1,
        ("cint16", "cint32", 3, 10, 1): 3,
        ("cint16", "cint32", 4, 10, 1): 1,
        ("cint16", "cint32", 5, 10, 1): 5,
        ("cint16", "cint32", 6, 10, 1): 3,
        ("cint16", "cint32", 7, 10, 1): 7,
        ("cint16", "cint32", 8, 10, 1): 2,
        ("cint16", "cint32", 9, 10, 1): 9,
        ("cint16", "cint32", 10, 10, 1): 5,
        ("cint16", "cint32", 11, 10, 1): 11,
        ("cint16", "cint32", 12, 10, 1): 3,
        ("cint16", "cint32", 13, 10, 1): 13,
        ("cint16", "cint32", 14, 10, 1): 7,
        ("cint16", "cint32", 15, 10, 1): 15,
        ("cint16", "cint32", 16, 10, 1): 4,
        ("cint16", "cint32", 1, 11, 1): 1,
        ("cint16", "cint32", 2, 11, 1): 1,
        ("cint16", "cint32", 3, 11, 1): 3,
        ("cint16", "cint32", 4, 11, 1): 2,
        ("cint16", "cint32", 5, 11, 1): 5,
        ("cint16", "cint32", 6, 11, 1): 3,
        ("cint16", "cint32", 7, 11, 1): 7,
        ("cint16", "cint32", 8, 11, 1): 4,
        ("cint16", "cint32", 9, 11, 1): 9,
        ("cint16", "cint32", 10, 11, 1): 5,
        ("cint16", "cint32", 11, 11, 1): 11,
        ("cint16", "cint32", 12, 11, 1): 6,
        ("cint16", "cint32", 13, 11, 1): 13,
        ("cint16", "cint32", 14, 11, 1): 7,
        ("cint16", "cint32", 15, 11, 1): 15,
        ("cint16", "cint32", 16, 11, 1): 8,
        ("cint16", "cint32", 1, 12, 1): 1,
        ("cint16", "cint32", 2, 12, 1): 1,
        ("cint16", "cint32", 3, 12, 1): 3,
        ("cint16", "cint32", 4, 12, 1): 1,
        ("cint16", "cint32", 5, 12, 1): 5,
        ("cint16", "cint32", 6, 12, 1): 3,
        ("cint16", "cint32", 7, 12, 1): 7,
        ("cint16", "cint32", 8, 12, 1): 1,
        ("cint16", "cint32", 9, 12, 1): 9,
        ("cint16", "cint32", 10, 12, 1): 5,
        ("cint16", "cint32", 11, 12, 1): 11,
        ("cint16", "cint32", 12, 12, 1): 3,
        ("cint16", "cint32", 13, 12, 1): 13,
        ("cint16", "cint32", 14, 12, 1): 7,
        ("cint16", "cint32", 15, 12, 1): 15,
        ("cint16", "cint32", 16, 12, 1): 2,
        ("cint16", "cint32", 1, 13, 1): 1,
        ("cint16", "cint32", 2, 13, 1): 1,
        ("cint16", "cint32", 3, 13, 1): 3,
        ("cint16", "cint32", 4, 13, 1): 2,
        ("cint16", "cint32", 5, 13, 1): 5,
        ("cint16", "cint32", 6, 13, 1): 3,
        ("cint16", "cint32", 7, 13, 1): 7,
        ("cint16", "cint32", 8, 13, 1): 4,
        ("cint16", "cint32", 9, 13, 1): 9,
        ("cint16", "cint32", 10, 13, 1): 5,
        ("cint16", "cint32", 11, 13, 1): 11,
        ("cint16", "cint32", 12, 13, 1): 6,
        ("cint16", "cint32", 13, 13, 1): 13,
        ("cint16", "cint32", 14, 13, 1): 7,
        ("cint16", "cint32", 15, 13, 1): 15,
        ("cint16", "cint32", 16, 13, 1): 8,
        ("cint16", "cint32", 1, 14, 1): 1,
        ("cint16", "cint32", 2, 14, 1): 1,
        ("cint16", "cint32", 3, 14, 1): 3,
        ("cint16", "cint32", 4, 14, 1): 1,
        ("cint16", "cint32", 5, 14, 1): 5,
        ("cint16", "cint32", 6, 14, 1): 3,
        ("cint16", "cint32", 7, 14, 1): 7,
        ("cint16", "cint32", 8, 14, 1): 2,
        ("cint16", "cint32", 9, 14, 1): 9,
        ("cint16", "cint32", 10, 14, 1): 5,
        ("cint16", "cint32", 11, 14, 1): 11,
        ("cint16", "cint32", 12, 14, 1): 3,
        ("cint16", "cint32", 13, 14, 1): 13,
        ("cint16", "cint32", 14, 14, 1): 7,
        ("cint16", "cint32", 15, 14, 1): 15,
        ("cint16", "cint32", 16, 14, 1): 4,
        ("cint16", "cint32", 1, 15, 1): 1,
        ("cint16", "cint32", 2, 15, 1): 1,
        ("cint16", "cint32", 3, 15, 1): 3,
        ("cint16", "cint32", 4, 15, 1): 2,
        ("cint16", "cint32", 5, 15, 1): 5,
        ("cint16", "cint32", 6, 15, 1): 3,
        ("cint16", "cint32", 7, 15, 1): 7,
        ("cint16", "cint32", 8, 15, 1): 4,
        ("cint16", "cint32", 9, 15, 1): 9,
        ("cint16", "cint32", 10, 15, 1): 5,
        ("cint16", "cint32", 11, 15, 1): 11,
        ("cint16", "cint32", 12, 15, 1): 6,
        ("cint16", "cint32", 13, 15, 1): 13,
        ("cint16", "cint32", 14, 15, 1): 7,
        ("cint16", "cint32", 15, 15, 1): 15,
        ("cint16", "cint32", 16, 15, 1): 8,
        ("cint16", "cint32", 1, 16, 1): 1,
        ("cint16", "cint32", 2, 16, 1): 1,
        ("cint16", "cint32", 3, 16, 1): 3,
        ("cint16", "cint32", 4, 16, 1): 1,
        ("cint16", "cint32", 5, 16, 1): 5,
        ("cint16", "cint32", 6, 16, 1): 3,
        ("cint16", "cint32", 7, 16, 1): 7,
        ("cint16", "cint32", 8, 16, 1): 1,
        ("cint16", "cint32", 9, 16, 1): 9,
        ("cint16", "cint32", 10, 16, 1): 5,
        ("cint16", "cint32", 11, 16, 1): 11,
        ("cint16", "cint32", 12, 16, 1): 3,
        ("cint16", "cint32", 13, 16, 1): 13,
        ("cint16", "cint32", 14, 16, 1): 7,
        ("cint16", "cint32", 15, 16, 1): 15,
        ("cint16", "cint32", 16, 16, 1): 2,
        ("int16", "int32", 1, 1, 0): 1,
        ("int16", "int32", 2, 1, 0): 1,
        ("int16", "int32", 3, 1, 0): 3,
        ("int16", "int32", 4, 1, 0): 2,
        ("int16", "int32", 5, 1, 0): 5,
        ("int16", "int32", 6, 1, 0): 3,
        ("int16", "int32", 7, 1, 0): 7,
        ("int16", "int32", 8, 1, 0): 4,
        ("int16", "int32", 9, 1, 0): 9,
        ("int16", "int32", 10, 1, 0): 5,
        ("int16", "int32", 11, 1, 0): 11,
        ("int16", "int32", 12, 1, 0): 6,
        ("int16", "int32", 13, 1, 0): 13,
        ("int16", "int32", 14, 1, 0): 7,
        ("int16", "int32", 15, 1, 0): 15,
        ("int16", "int32", 16, 1, 0): 8,
        ("int16", "int32", 1, 2, 0): 1,
        ("int16", "int32", 2, 2, 0): 1,
        ("int16", "int32", 3, 2, 0): 3,
        ("int16", "int32", 4, 2, 0): 1,
        ("int16", "int32", 5, 2, 0): 5,
        ("int16", "int32", 6, 2, 0): 3,
        ("int16", "int32", 7, 2, 0): 7,
        ("int16", "int32", 8, 2, 0): 2,
        ("int16", "int32", 9, 2, 0): 9,
        ("int16", "int32", 10, 2, 0): 5,
        ("int16", "int32", 11, 2, 0): 11,
        ("int16", "int32", 12, 2, 0): 3,
        ("int16", "int32", 13, 2, 0): 13,
        ("int16", "int32", 14, 2, 0): 7,
        ("int16", "int32", 15, 2, 0): 15,
        ("int16", "int32", 16, 2, 0): 4,
        ("int16", "int32", 1, 3, 0): 1,
        ("int16", "int32", 2, 3, 0): 1,
        ("int16", "int32", 3, 3, 0): 3,
        ("int16", "int32", 4, 3, 0): 2,
        ("int16", "int32", 5, 3, 0): 5,
        ("int16", "int32", 6, 3, 0): 3,
        ("int16", "int32", 7, 3, 0): 7,
        ("int16", "int32", 8, 3, 0): 4,
        ("int16", "int32", 9, 3, 0): 9,
        ("int16", "int32", 10, 3, 0): 5,
        ("int16", "int32", 11, 3, 0): 11,
        ("int16", "int32", 12, 3, 0): 6,
        ("int16", "int32", 13, 3, 0): 13,
        ("int16", "int32", 14, 3, 0): 7,
        ("int16", "int32", 15, 3, 0): 15,
        ("int16", "int32", 16, 3, 0): 8,
        ("int16", "int32", 1, 4, 0): 1,
        ("int16", "int32", 2, 4, 0): 1,
        ("int16", "int32", 3, 4, 0): 3,
        ("int16", "int32", 4, 4, 0): 1,
        ("int16", "int32", 5, 4, 0): 5,
        ("int16", "int32", 6, 4, 0): 3,
        ("int16", "int32", 7, 4, 0): 7,
        ("int16", "int32", 8, 4, 0): 1,
        ("int16", "int32", 9, 4, 0): 9,
        ("int16", "int32", 10, 4, 0): 5,
        ("int16", "int32", 11, 4, 0): 11,
        ("int16", "int32", 12, 4, 0): 3,
        ("int16", "int32", 13, 4, 0): 13,
        ("int16", "int32", 14, 4, 0): 7,
        ("int16", "int32", 15, 4, 0): 15,
        ("int16", "int32", 16, 4, 0): 2,
        ("int16", "int32", 1, 5, 0): 1,
        ("int16", "int32", 2, 5, 0): 1,
        ("int16", "int32", 3, 5, 0): 3,
        ("int16", "int32", 4, 5, 0): 2,
        ("int16", "int32", 5, 5, 0): 5,
        ("int16", "int32", 6, 5, 0): 3,
        ("int16", "int32", 7, 5, 0): 7,
        ("int16", "int32", 8, 5, 0): 4,
        ("int16", "int32", 9, 5, 0): 9,
        ("int16", "int32", 10, 5, 0): 5,
        ("int16", "int32", 11, 5, 0): 11,
        ("int16", "int32", 12, 5, 0): 6,
        ("int16", "int32", 13, 5, 0): 13,
        ("int16", "int32", 14, 5, 0): 7,
        ("int16", "int32", 15, 5, 0): 15,
        ("int16", "int32", 16, 5, 0): 8,
        ("int16", "int32", 1, 6, 0): 1,
        ("int16", "int32", 2, 6, 0): 1,
        ("int16", "int32", 3, 6, 0): 3,
        ("int16", "int32", 4, 6, 0): 1,
        ("int16", "int32", 5, 6, 0): 5,
        ("int16", "int32", 6, 6, 0): 3,
        ("int16", "int32", 7, 6, 0): 7,
        ("int16", "int32", 8, 6, 0): 2,
        ("int16", "int32", 9, 6, 0): 9,
        ("int16", "int32", 10, 6, 0): 5,
        ("int16", "int32", 11, 6, 0): 11,
        ("int16", "int32", 12, 6, 0): 3,
        ("int16", "int32", 13, 6, 0): 13,
        ("int16", "int32", 14, 6, 0): 7,
        ("int16", "int32", 15, 6, 0): 15,
        ("int16", "int32", 16, 6, 0): 4,
        ("int16", "int32", 1, 7, 0): 1,
        ("int16", "int32", 2, 7, 0): 1,
        ("int16", "int32", 3, 7, 0): 3,
        ("int16", "int32", 4, 7, 0): 2,
        ("int16", "int32", 5, 7, 0): 5,
        ("int16", "int32", 6, 7, 0): 3,
        ("int16", "int32", 7, 7, 0): 7,
        ("int16", "int32", 8, 7, 0): 4,
        ("int16", "int32", 9, 7, 0): 9,
        ("int16", "int32", 10, 7, 0): 5,
        ("int16", "int32", 11, 7, 0): 11,
        ("int16", "int32", 12, 7, 0): 6,
        ("int16", "int32", 13, 7, 0): 13,
        ("int16", "int32", 14, 7, 0): 7,
        ("int16", "int32", 15, 7, 0): 15,
        ("int16", "int32", 16, 7, 0): 8,
        ("int16", "int32", 1, 8, 0): 1,
        ("int16", "int32", 2, 8, 0): 1,
        ("int16", "int32", 3, 8, 0): 3,
        ("int16", "int32", 4, 8, 0): 1,
        ("int16", "int32", 5, 8, 0): 5,
        ("int16", "int32", 6, 8, 0): 3,
        ("int16", "int32", 7, 8, 0): 7,
        ("int16", "int32", 8, 8, 0): 1,
        ("int16", "int32", 9, 8, 0): 9,
        ("int16", "int32", 10, 8, 0): 5,
        ("int16", "int32", 11, 8, 0): 11,
        ("int16", "int32", 12, 8, 0): 3,
        ("int16", "int32", 13, 8, 0): 13,
        ("int16", "int32", 14, 8, 0): 7,
        ("int16", "int32", 15, 8, 0): 15,
        ("int16", "int32", 16, 8, 0): 1,
        ("int16", "int32", 1, 9, 0): 1,
        ("int16", "int32", 2, 9, 0): 1,
        ("int16", "int32", 3, 9, 0): 3,
        ("int16", "int32", 4, 9, 0): 2,
        ("int16", "int32", 5, 9, 0): 5,
        ("int16", "int32", 6, 9, 0): 3,
        ("int16", "int32", 7, 9, 0): 7,
        ("int16", "int32", 8, 9, 0): 4,
        ("int16", "int32", 9, 9, 0): 9,
        ("int16", "int32", 10, 9, 0): 5,
        ("int16", "int32", 11, 9, 0): 11,
        ("int16", "int32", 12, 9, 0): 6,
        ("int16", "int32", 13, 9, 0): 13,
        ("int16", "int32", 14, 9, 0): 7,
        ("int16", "int32", 15, 9, 0): 15,
        ("int16", "int32", 16, 9, 0): 8,
        ("int16", "int32", 1, 10, 0): 1,
        ("int16", "int32", 2, 10, 0): 1,
        ("int16", "int32", 3, 10, 0): 3,
        ("int16", "int32", 4, 10, 0): 1,
        ("int16", "int32", 5, 10, 0): 5,
        ("int16", "int32", 6, 10, 0): 3,
        ("int16", "int32", 7, 10, 0): 7,
        ("int16", "int32", 8, 10, 0): 2,
        ("int16", "int32", 9, 10, 0): 9,
        ("int16", "int32", 10, 10, 0): 5,
        ("int16", "int32", 11, 10, 0): 11,
        ("int16", "int32", 12, 10, 0): 3,
        ("int16", "int32", 13, 10, 0): 13,
        ("int16", "int32", 14, 10, 0): 7,
        ("int16", "int32", 15, 10, 0): 15,
        ("int16", "int32", 16, 10, 0): 4,
        ("int16", "int32", 1, 11, 0): 1,
        ("int16", "int32", 2, 11, 0): 1,
        ("int16", "int32", 3, 11, 0): 3,
        ("int16", "int32", 4, 11, 0): 2,
        ("int16", "int32", 5, 11, 0): 5,
        ("int16", "int32", 6, 11, 0): 3,
        ("int16", "int32", 7, 11, 0): 7,
        ("int16", "int32", 8, 11, 0): 4,
        ("int16", "int32", 9, 11, 0): 9,
        ("int16", "int32", 10, 11, 0): 5,
        ("int16", "int32", 11, 11, 0): 11,
        ("int16", "int32", 12, 11, 0): 6,
        ("int16", "int32", 13, 11, 0): 13,
        ("int16", "int32", 14, 11, 0): 7,
        ("int16", "int32", 15, 11, 0): 15,
        ("int16", "int32", 16, 11, 0): 8,
        ("int16", "int32", 1, 12, 0): 1,
        ("int16", "int32", 2, 12, 0): 1,
        ("int16", "int32", 3, 12, 0): 3,
        ("int16", "int32", 4, 12, 0): 1,
        ("int16", "int32", 5, 12, 0): 5,
        ("int16", "int32", 6, 12, 0): 3,
        ("int16", "int32", 7, 12, 0): 7,
        ("int16", "int32", 8, 12, 0): 1,
        ("int16", "int32", 9, 12, 0): 9,
        ("int16", "int32", 10, 12, 0): 5,
        ("int16", "int32", 11, 12, 0): 11,
        ("int16", "int32", 12, 12, 0): 3,
        ("int16", "int32", 13, 12, 0): 13,
        ("int16", "int32", 14, 12, 0): 7,
        ("int16", "int32", 15, 12, 0): 15,
        ("int16", "int32", 16, 12, 0): 2,
        ("int16", "int32", 1, 13, 0): 1,
        ("int16", "int32", 2, 13, 0): 1,
        ("int16", "int32", 3, 13, 0): 3,
        ("int16", "int32", 4, 13, 0): 2,
        ("int16", "int32", 5, 13, 0): 5,
        ("int16", "int32", 6, 13, 0): 3,
        ("int16", "int32", 7, 13, 0): 7,
        ("int16", "int32", 8, 13, 0): 4,
        ("int16", "int32", 9, 13, 0): 9,
        ("int16", "int32", 10, 13, 0): 5,
        ("int16", "int32", 11, 13, 0): 11,
        ("int16", "int32", 12, 13, 0): 6,
        ("int16", "int32", 13, 13, 0): 13,
        ("int16", "int32", 14, 13, 0): 7,
        ("int16", "int32", 15, 13, 0): 15,
        ("int16", "int32", 16, 13, 0): 8,
        ("int16", "int32", 1, 14, 0): 1,
        ("int16", "int32", 2, 14, 0): 1,
        ("int16", "int32", 3, 14, 0): 3,
        ("int16", "int32", 4, 14, 0): 1,
        ("int16", "int32", 5, 14, 0): 5,
        ("int16", "int32", 6, 14, 0): 3,
        ("int16", "int32", 7, 14, 0): 7,
        ("int16", "int32", 8, 14, 0): 2,
        ("int16", "int32", 9, 14, 0): 9,
        ("int16", "int32", 10, 14, 0): 5,
        ("int16", "int32", 11, 14, 0): 11,
        ("int16", "int32", 12, 14, 0): 3,
        ("int16", "int32", 13, 14, 0): 13,
        ("int16", "int32", 14, 14, 0): 7,
        ("int16", "int32", 15, 14, 0): 15,
        ("int16", "int32", 16, 14, 0): 4,
        ("int16", "int32", 1, 15, 0): 1,
        ("int16", "int32", 2, 15, 0): 1,
        ("int16", "int32", 3, 15, 0): 3,
        ("int16", "int32", 4, 15, 0): 2,
        ("int16", "int32", 5, 15, 0): 5,
        ("int16", "int32", 6, 15, 0): 3,
        ("int16", "int32", 7, 15, 0): 7,
        ("int16", "int32", 8, 15, 0): 4,
        ("int16", "int32", 9, 15, 0): 9,
        ("int16", "int32", 10, 15, 0): 5,
        ("int16", "int32", 11, 15, 0): 11,
        ("int16", "int32", 12, 15, 0): 6,
        ("int16", "int32", 13, 15, 0): 13,
        ("int16", "int32", 14, 15, 0): 7,
        ("int16", "int32", 15, 15, 0): 15,
        ("int16", "int32", 16, 15, 0): 8,
        ("int16", "int32", 1, 16, 0): 1,
        ("int16", "int32", 2, 16, 0): 1,
        ("int16", "int32", 3, 16, 0): 3,
        ("int16", "int32", 4, 16, 0): 1,
        ("int16", "int32", 5, 16, 0): 5,
        ("int16", "int32", 6, 16, 0): 3,
        ("int16", "int32", 7, 16, 0): 7,
        ("int16", "int32", 8, 16, 0): 1,
        ("int16", "int32", 9, 16, 0): 9,
        ("int16", "int32", 10, 16, 0): 5,
        ("int16", "int32", 11, 16, 0): 11,
        ("int16", "int32", 12, 16, 0): 3,
        ("int16", "int32", 13, 16, 0): 13,
        ("int16", "int32", 14, 16, 0): 7,
        ("int16", "int32", 15, 16, 0): 15,
        ("int16", "int32", 16, 16, 0): 1,
        ("int16", "int32", 1, 1, 1): 1,
        ("int16", "int32", 2, 1, 1): 2,
        ("int16", "int32", 3, 1, 1): 3,
        ("int16", "int32", 4, 1, 1): 4,
        ("int16", "int32", 5, 1, 1): 5,
        ("int16", "int32", 6, 1, 1): 6,
        ("int16", "int32", 7, 1, 1): 7,
        ("int16", "int32", 8, 1, 1): 8,
        ("int16", "int32", 9, 1, 1): 9,
        ("int16", "int32", 10, 1, 1): 10,
        ("int16", "int32", 11, 1, 1): 11,
        ("int16", "int32", 12, 1, 1): 12,
        ("int16", "int32", 13, 1, 1): 13,
        ("int16", "int32", 14, 1, 1): 14,
        ("int16", "int32", 15, 1, 1): 15,
        ("int16", "int32", 16, 1, 1): 16,
        ("int16", "int32", 1, 2, 1): 1,
        ("int16", "int32", 2, 2, 1): 1,
        ("int16", "int32", 3, 2, 1): 3,
        ("int16", "int32", 4, 2, 1): 2,
        ("int16", "int32", 5, 2, 1): 5,
        ("int16", "int32", 6, 2, 1): 3,
        ("int16", "int32", 7, 2, 1): 7,
        ("int16", "int32", 8, 2, 1): 4,
        ("int16", "int32", 9, 2, 1): 9,
        ("int16", "int32", 10, 2, 1): 5,
        ("int16", "int32", 11, 2, 1): 11,
        ("int16", "int32", 12, 2, 1): 6,
        ("int16", "int32", 13, 2, 1): 13,
        ("int16", "int32", 14, 2, 1): 7,
        ("int16", "int32", 15, 2, 1): 15,
        ("int16", "int32", 16, 2, 1): 8,
        ("int16", "int32", 1, 3, 1): 1,
        ("int16", "int32", 2, 3, 1): 2,
        ("int16", "int32", 3, 3, 1): 3,
        ("int16", "int32", 4, 3, 1): 4,
        ("int16", "int32", 5, 3, 1): 5,
        ("int16", "int32", 6, 3, 1): 6,
        ("int16", "int32", 7, 3, 1): 7,
        ("int16", "int32", 8, 3, 1): 8,
        ("int16", "int32", 9, 3, 1): 9,
        ("int16", "int32", 10, 3, 1): 10,
        ("int16", "int32", 11, 3, 1): 11,
        ("int16", "int32", 12, 3, 1): 12,
        ("int16", "int32", 13, 3, 1): 13,
        ("int16", "int32", 14, 3, 1): 14,
        ("int16", "int32", 15, 3, 1): 15,
        ("int16", "int32", 16, 3, 1): 16,
        ("int16", "int32", 1, 4, 1): 1,
        ("int16", "int32", 2, 4, 1): 1,
        ("int16", "int32", 3, 4, 1): 3,
        ("int16", "int32", 4, 4, 1): 1,
        ("int16", "int32", 5, 4, 1): 5,
        ("int16", "int32", 6, 4, 1): 3,
        ("int16", "int32", 7, 4, 1): 7,
        ("int16", "int32", 8, 4, 1): 2,
        ("int16", "int32", 9, 4, 1): 9,
        ("int16", "int32", 10, 4, 1): 5,
        ("int16", "int32", 11, 4, 1): 11,
        ("int16", "int32", 12, 4, 1): 3,
        ("int16", "int32", 13, 4, 1): 13,
        ("int16", "int32", 14, 4, 1): 7,
        ("int16", "int32", 15, 4, 1): 15,
        ("int16", "int32", 16, 4, 1): 4,
        ("int16", "int32", 1, 5, 1): 1,
        ("int16", "int32", 2, 5, 1): 2,
        ("int16", "int32", 3, 5, 1): 3,
        ("int16", "int32", 4, 5, 1): 4,
        ("int16", "int32", 5, 5, 1): 5,
        ("int16", "int32", 6, 5, 1): 6,
        ("int16", "int32", 7, 5, 1): 7,
        ("int16", "int32", 8, 5, 1): 8,
        ("int16", "int32", 9, 5, 1): 9,
        ("int16", "int32", 10, 5, 1): 10,
        ("int16", "int32", 11, 5, 1): 11,
        ("int16", "int32", 12, 5, 1): 12,
        ("int16", "int32", 13, 5, 1): 13,
        ("int16", "int32", 14, 5, 1): 14,
        ("int16", "int32", 15, 5, 1): 15,
        ("int16", "int32", 16, 5, 1): 16,
        ("int16", "int32", 1, 6, 1): 1,
        ("int16", "int32", 2, 6, 1): 1,
        ("int16", "int32", 3, 6, 1): 3,
        ("int16", "int32", 4, 6, 1): 2,
        ("int16", "int32", 5, 6, 1): 5,
        ("int16", "int32", 6, 6, 1): 3,
        ("int16", "int32", 7, 6, 1): 7,
        ("int16", "int32", 8, 6, 1): 4,
        ("int16", "int32", 9, 6, 1): 9,
        ("int16", "int32", 10, 6, 1): 5,
        ("int16", "int32", 11, 6, 1): 11,
        ("int16", "int32", 12, 6, 1): 6,
        ("int16", "int32", 13, 6, 1): 13,
        ("int16", "int32", 14, 6, 1): 7,
        ("int16", "int32", 15, 6, 1): 15,
        ("int16", "int32", 16, 6, 1): 8,
        ("int16", "int32", 1, 7, 1): 1,
        ("int16", "int32", 2, 7, 1): 2,
        ("int16", "int32", 3, 7, 1): 3,
        ("int16", "int32", 4, 7, 1): 4,
        ("int16", "int32", 5, 7, 1): 5,
        ("int16", "int32", 6, 7, 1): 6,
        ("int16", "int32", 7, 7, 1): 7,
        ("int16", "int32", 8, 7, 1): 8,
        ("int16", "int32", 9, 7, 1): 9,
        ("int16", "int32", 10, 7, 1): 10,
        ("int16", "int32", 11, 7, 1): 11,
        ("int16", "int32", 12, 7, 1): 12,
        ("int16", "int32", 13, 7, 1): 13,
        ("int16", "int32", 14, 7, 1): 14,
        ("int16", "int32", 15, 7, 1): 15,
        ("int16", "int32", 16, 7, 1): 16,
        ("int16", "int32", 1, 8, 1): 1,
        ("int16", "int32", 2, 8, 1): 1,
        ("int16", "int32", 3, 8, 1): 3,
        ("int16", "int32", 4, 8, 1): 1,
        ("int16", "int32", 5, 8, 1): 5,
        ("int16", "int32", 6, 8, 1): 3,
        ("int16", "int32", 7, 8, 1): 7,
        ("int16", "int32", 8, 8, 1): 1,
        ("int16", "int32", 9, 8, 1): 9,
        ("int16", "int32", 10, 8, 1): 5,
        ("int16", "int32", 11, 8, 1): 11,
        ("int16", "int32", 12, 8, 1): 3,
        ("int16", "int32", 13, 8, 1): 13,
        ("int16", "int32", 14, 8, 1): 7,
        ("int16", "int32", 15, 8, 1): 15,
        ("int16", "int32", 16, 8, 1): 2,
        ("int16", "int32", 1, 9, 1): 1,
        ("int16", "int32", 2, 9, 1): 2,
        ("int16", "int32", 3, 9, 1): 3,
        ("int16", "int32", 4, 9, 1): 4,
        ("int16", "int32", 5, 9, 1): 5,
        ("int16", "int32", 6, 9, 1): 6,
        ("int16", "int32", 7, 9, 1): 7,
        ("int16", "int32", 8, 9, 1): 8,
        ("int16", "int32", 9, 9, 1): 9,
        ("int16", "int32", 10, 9, 1): 10,
        ("int16", "int32", 11, 9, 1): 11,
        ("int16", "int32", 12, 9, 1): 12,
        ("int16", "int32", 13, 9, 1): 13,
        ("int16", "int32", 14, 9, 1): 14,
        ("int16", "int32", 15, 9, 1): 15,
        ("int16", "int32", 16, 9, 1): 16,
        ("int16", "int32", 1, 10, 1): 1,
        ("int16", "int32", 2, 10, 1): 1,
        ("int16", "int32", 3, 10, 1): 3,
        ("int16", "int32", 4, 10, 1): 2,
        ("int16", "int32", 5, 10, 1): 5,
        ("int16", "int32", 6, 10, 1): 3,
        ("int16", "int32", 7, 10, 1): 7,
        ("int16", "int32", 8, 10, 1): 4,
        ("int16", "int32", 9, 10, 1): 9,
        ("int16", "int32", 10, 10, 1): 5,
        ("int16", "int32", 11, 10, 1): 11,
        ("int16", "int32", 12, 10, 1): 6,
        ("int16", "int32", 13, 10, 1): 13,
        ("int16", "int32", 14, 10, 1): 7,
        ("int16", "int32", 15, 10, 1): 15,
        ("int16", "int32", 16, 10, 1): 8,
        ("int16", "int32", 1, 11, 1): 1,
        ("int16", "int32", 2, 11, 1): 2,
        ("int16", "int32", 3, 11, 1): 3,
        ("int16", "int32", 4, 11, 1): 4,
        ("int16", "int32", 5, 11, 1): 5,
        ("int16", "int32", 6, 11, 1): 6,
        ("int16", "int32", 7, 11, 1): 7,
        ("int16", "int32", 8, 11, 1): 8,
        ("int16", "int32", 9, 11, 1): 9,
        ("int16", "int32", 10, 11, 1): 10,
        ("int16", "int32", 11, 11, 1): 11,
        ("int16", "int32", 12, 11, 1): 12,
        ("int16", "int32", 13, 11, 1): 13,
        ("int16", "int32", 14, 11, 1): 14,
        ("int16", "int32", 15, 11, 1): 15,
        ("int16", "int32", 16, 11, 1): 16,
        ("int16", "int32", 1, 12, 1): 1,
        ("int16", "int32", 2, 12, 1): 1,
        ("int16", "int32", 3, 12, 1): 3,
        ("int16", "int32", 4, 12, 1): 1,
        ("int16", "int32", 5, 12, 1): 5,
        ("int16", "int32", 6, 12, 1): 3,
        ("int16", "int32", 7, 12, 1): 7,
        ("int16", "int32", 8, 12, 1): 2,
        ("int16", "int32", 9, 12, 1): 9,
        ("int16", "int32", 10, 12, 1): 5,
        ("int16", "int32", 11, 12, 1): 11,
        ("int16", "int32", 12, 12, 1): 3,
        ("int16", "int32", 13, 12, 1): 13,
        ("int16", "int32", 14, 12, 1): 7,
        ("int16", "int32", 15, 12, 1): 15,
        ("int16", "int32", 16, 12, 1): 4,
        ("int16", "int32", 1, 13, 1): 1,
        ("int16", "int32", 2, 13, 1): 2,
        ("int16", "int32", 3, 13, 1): 3,
        ("int16", "int32", 4, 13, 1): 4,
        ("int16", "int32", 5, 13, 1): 5,
        ("int16", "int32", 6, 13, 1): 6,
        ("int16", "int32", 7, 13, 1): 7,
        ("int16", "int32", 8, 13, 1): 8,
        ("int16", "int32", 9, 13, 1): 9,
        ("int16", "int32", 10, 13, 1): 10,
        ("int16", "int32", 11, 13, 1): 11,
        ("int16", "int32", 12, 13, 1): 12,
        ("int16", "int32", 13, 13, 1): 13,
        ("int16", "int32", 14, 13, 1): 14,
        ("int16", "int32", 15, 13, 1): 15,
        ("int16", "int32", 16, 13, 1): 16,
        ("int16", "int32", 1, 14, 1): 1,
        ("int16", "int32", 2, 14, 1): 1,
        ("int16", "int32", 3, 14, 1): 3,
        ("int16", "int32", 4, 14, 1): 2,
        ("int16", "int32", 5, 14, 1): 5,
        ("int16", "int32", 6, 14, 1): 3,
        ("int16", "int32", 7, 14, 1): 7,
        ("int16", "int32", 8, 14, 1): 4,
        ("int16", "int32", 9, 14, 1): 9,
        ("int16", "int32", 10, 14, 1): 5,
        ("int16", "int32", 11, 14, 1): 11,
        ("int16", "int32", 12, 14, 1): 6,
        ("int16", "int32", 13, 14, 1): 13,
        ("int16", "int32", 14, 14, 1): 7,
        ("int16", "int32", 15, 14, 1): 15,
        ("int16", "int32", 16, 14, 1): 8,
        ("int16", "int32", 1, 15, 1): 1,
        ("int16", "int32", 2, 15, 1): 2,
        ("int16", "int32", 3, 15, 1): 3,
        ("int16", "int32", 4, 15, 1): 4,
        ("int16", "int32", 5, 15, 1): 5,
        ("int16", "int32", 6, 15, 1): 6,
        ("int16", "int32", 7, 15, 1): 7,
        ("int16", "int32", 8, 15, 1): 8,
        ("int16", "int32", 9, 15, 1): 9,
        ("int16", "int32", 10, 15, 1): 10,
        ("int16", "int32", 11, 15, 1): 11,
        ("int16", "int32", 12, 15, 1): 12,
        ("int16", "int32", 13, 15, 1): 13,
        ("int16", "int32", 14, 15, 1): 14,
        ("int16", "int32", 15, 15, 1): 15,
        ("int16", "int32", 16, 15, 1): 16,
        ("int16", "int32", 1, 16, 1): 1,
        ("int16", "int32", 2, 16, 1): 1,
        ("int16", "int32", 3, 16, 1): 3,
        ("int16", "int32", 4, 16, 1): 1,
        ("int16", "int32", 5, 16, 1): 5,
        ("int16", "int32", 6, 16, 1): 3,
        ("int16", "int32", 7, 16, 1): 7,
        ("int16", "int32", 8, 16, 1): 1,
        ("int16", "int32", 9, 16, 1): 9,
        ("int16", "int32", 10, 16, 1): 5,
        ("int16", "int32", 11, 16, 1): 11,
        ("int16", "int32", 12, 16, 1): 3,
        ("int16", "int32", 13, 16, 1): 13,
        ("int16", "int32", 14, 16, 1): 7,
        ("int16", "int32", 15, 16, 1): 15,
        ("int16", "int32", 16, 16, 1): 2,
        ("int32", "int32", 1, 1, 0): 1,
        ("int32", "int32", 2, 1, 0): 1,
        ("int32", "int32", 3, 1, 0): 3,
        ("int32", "int32", 4, 1, 0): 1,
        ("int32", "int32", 5, 1, 0): 5,
        ("int32", "int32", 6, 1, 0): 3,
        ("int32", "int32", 7, 1, 0): 7,
        ("int32", "int32", 8, 1, 0): 2,
        ("int32", "int32", 9, 1, 0): 9,
        ("int32", "int32", 10, 1, 0): 5,
        ("int32", "int32", 11, 1, 0): 11,
        ("int32", "int32", 12, 1, 0): 3,
        ("int32", "int32", 13, 1, 0): 13,
        ("int32", "int32", 14, 1, 0): 7,
        ("int32", "int32", 15, 1, 0): 15,
        ("int32", "int32", 16, 1, 0): 4,
        ("int32", "int32", 1, 2, 0): 1,
        ("int32", "int32", 2, 2, 0): 1,
        ("int32", "int32", 3, 2, 0): 3,
        ("int32", "int32", 4, 2, 0): 1,
        ("int32", "int32", 5, 2, 0): 5,
        ("int32", "int32", 6, 2, 0): 3,
        ("int32", "int32", 7, 2, 0): 7,
        ("int32", "int32", 8, 2, 0): 1,
        ("int32", "int32", 9, 2, 0): 9,
        ("int32", "int32", 10, 2, 0): 5,
        ("int32", "int32", 11, 2, 0): 11,
        ("int32", "int32", 12, 2, 0): 3,
        ("int32", "int32", 13, 2, 0): 13,
        ("int32", "int32", 14, 2, 0): 7,
        ("int32", "int32", 15, 2, 0): 15,
        ("int32", "int32", 16, 2, 0): 2,
        ("int32", "int32", 1, 3, 0): 1,
        ("int32", "int32", 2, 3, 0): 1,
        ("int32", "int32", 3, 3, 0): 3,
        ("int32", "int32", 4, 3, 0): 1,
        ("int32", "int32", 5, 3, 0): 5,
        ("int32", "int32", 6, 3, 0): 3,
        ("int32", "int32", 7, 3, 0): 7,
        ("int32", "int32", 8, 3, 0): 2,
        ("int32", "int32", 9, 3, 0): 9,
        ("int32", "int32", 10, 3, 0): 5,
        ("int32", "int32", 11, 3, 0): 11,
        ("int32", "int32", 12, 3, 0): 3,
        ("int32", "int32", 13, 3, 0): 13,
        ("int32", "int32", 14, 3, 0): 7,
        ("int32", "int32", 15, 3, 0): 15,
        ("int32", "int32", 16, 3, 0): 4,
        ("int32", "int32", 1, 4, 0): 1,
        ("int32", "int32", 2, 4, 0): 1,
        ("int32", "int32", 3, 4, 0): 3,
        ("int32", "int32", 4, 4, 0): 1,
        ("int32", "int32", 5, 4, 0): 5,
        ("int32", "int32", 6, 4, 0): 3,
        ("int32", "int32", 7, 4, 0): 7,
        ("int32", "int32", 8, 4, 0): 1,
        ("int32", "int32", 9, 4, 0): 9,
        ("int32", "int32", 10, 4, 0): 5,
        ("int32", "int32", 11, 4, 0): 11,
        ("int32", "int32", 12, 4, 0): 3,
        ("int32", "int32", 13, 4, 0): 13,
        ("int32", "int32", 14, 4, 0): 7,
        ("int32", "int32", 15, 4, 0): 15,
        ("int32", "int32", 16, 4, 0): 1,
        ("int32", "int32", 1, 5, 0): 1,
        ("int32", "int32", 2, 5, 0): 1,
        ("int32", "int32", 3, 5, 0): 3,
        ("int32", "int32", 4, 5, 0): 1,
        ("int32", "int32", 5, 5, 0): 5,
        ("int32", "int32", 6, 5, 0): 3,
        ("int32", "int32", 7, 5, 0): 7,
        ("int32", "int32", 8, 5, 0): 2,
        ("int32", "int32", 9, 5, 0): 9,
        ("int32", "int32", 10, 5, 0): 5,
        ("int32", "int32", 11, 5, 0): 11,
        ("int32", "int32", 12, 5, 0): 3,
        ("int32", "int32", 13, 5, 0): 13,
        ("int32", "int32", 14, 5, 0): 7,
        ("int32", "int32", 15, 5, 0): 15,
        ("int32", "int32", 16, 5, 0): 4,
        ("int32", "int32", 1, 6, 0): 1,
        ("int32", "int32", 2, 6, 0): 1,
        ("int32", "int32", 3, 6, 0): 3,
        ("int32", "int32", 4, 6, 0): 1,
        ("int32", "int32", 5, 6, 0): 5,
        ("int32", "int32", 6, 6, 0): 3,
        ("int32", "int32", 7, 6, 0): 7,
        ("int32", "int32", 8, 6, 0): 1,
        ("int32", "int32", 9, 6, 0): 9,
        ("int32", "int32", 10, 6, 0): 5,
        ("int32", "int32", 11, 6, 0): 11,
        ("int32", "int32", 12, 6, 0): 3,
        ("int32", "int32", 13, 6, 0): 13,
        ("int32", "int32", 14, 6, 0): 7,
        ("int32", "int32", 15, 6, 0): 15,
        ("int32", "int32", 16, 6, 0): 2,
        ("int32", "int32", 1, 7, 0): 1,
        ("int32", "int32", 2, 7, 0): 1,
        ("int32", "int32", 3, 7, 0): 3,
        ("int32", "int32", 4, 7, 0): 1,
        ("int32", "int32", 5, 7, 0): 5,
        ("int32", "int32", 6, 7, 0): 3,
        ("int32", "int32", 7, 7, 0): 7,
        ("int32", "int32", 8, 7, 0): 2,
        ("int32", "int32", 9, 7, 0): 9,
        ("int32", "int32", 10, 7, 0): 5,
        ("int32", "int32", 11, 7, 0): 11,
        ("int32", "int32", 12, 7, 0): 3,
        ("int32", "int32", 13, 7, 0): 13,
        ("int32", "int32", 14, 7, 0): 7,
        ("int32", "int32", 15, 7, 0): 15,
        ("int32", "int32", 16, 7, 0): 4,
        ("int32", "int32", 1, 8, 0): 1,
        ("int32", "int32", 2, 8, 0): 1,
        ("int32", "int32", 3, 8, 0): 3,
        ("int32", "int32", 4, 8, 0): 1,
        ("int32", "int32", 5, 8, 0): 5,
        ("int32", "int32", 6, 8, 0): 3,
        ("int32", "int32", 7, 8, 0): 7,
        ("int32", "int32", 8, 8, 0): 1,
        ("int32", "int32", 9, 8, 0): 9,
        ("int32", "int32", 10, 8, 0): 5,
        ("int32", "int32", 11, 8, 0): 11,
        ("int32", "int32", 12, 8, 0): 3,
        ("int32", "int32", 13, 8, 0): 13,
        ("int32", "int32", 14, 8, 0): 7,
        ("int32", "int32", 15, 8, 0): 15,
        ("int32", "int32", 16, 8, 0): 1,
        ("int32", "int32", 1, 9, 0): 1,
        ("int32", "int32", 2, 9, 0): 1,
        ("int32", "int32", 3, 9, 0): 3,
        ("int32", "int32", 4, 9, 0): 1,
        ("int32", "int32", 5, 9, 0): 5,
        ("int32", "int32", 6, 9, 0): 3,
        ("int32", "int32", 7, 9, 0): 7,
        ("int32", "int32", 8, 9, 0): 2,
        ("int32", "int32", 9, 9, 0): 9,
        ("int32", "int32", 10, 9, 0): 5,
        ("int32", "int32", 11, 9, 0): 11,
        ("int32", "int32", 12, 9, 0): 3,
        ("int32", "int32", 13, 9, 0): 13,
        ("int32", "int32", 14, 9, 0): 7,
        ("int32", "int32", 15, 9, 0): 15,
        ("int32", "int32", 16, 9, 0): 4,
        ("int32", "int32", 1, 10, 0): 1,
        ("int32", "int32", 2, 10, 0): 1,
        ("int32", "int32", 3, 10, 0): 3,
        ("int32", "int32", 4, 10, 0): 1,
        ("int32", "int32", 5, 10, 0): 5,
        ("int32", "int32", 6, 10, 0): 3,
        ("int32", "int32", 7, 10, 0): 7,
        ("int32", "int32", 8, 10, 0): 1,
        ("int32", "int32", 9, 10, 0): 9,
        ("int32", "int32", 10, 10, 0): 5,
        ("int32", "int32", 11, 10, 0): 11,
        ("int32", "int32", 12, 10, 0): 3,
        ("int32", "int32", 13, 10, 0): 13,
        ("int32", "int32", 14, 10, 0): 7,
        ("int32", "int32", 15, 10, 0): 15,
        ("int32", "int32", 16, 10, 0): 2,
        ("int32", "int32", 1, 11, 0): 1,
        ("int32", "int32", 2, 11, 0): 1,
        ("int32", "int32", 3, 11, 0): 3,
        ("int32", "int32", 4, 11, 0): 1,
        ("int32", "int32", 5, 11, 0): 5,
        ("int32", "int32", 6, 11, 0): 3,
        ("int32", "int32", 7, 11, 0): 7,
        ("int32", "int32", 8, 11, 0): 2,
        ("int32", "int32", 9, 11, 0): 9,
        ("int32", "int32", 10, 11, 0): 5,
        ("int32", "int32", 11, 11, 0): 11,
        ("int32", "int32", 12, 11, 0): 3,
        ("int32", "int32", 13, 11, 0): 13,
        ("int32", "int32", 14, 11, 0): 7,
        ("int32", "int32", 15, 11, 0): 15,
        ("int32", "int32", 16, 11, 0): 4,
        ("int32", "int32", 1, 12, 0): 1,
        ("int32", "int32", 2, 12, 0): 1,
        ("int32", "int32", 3, 12, 0): 3,
        ("int32", "int32", 4, 12, 0): 1,
        ("int32", "int32", 5, 12, 0): 5,
        ("int32", "int32", 6, 12, 0): 3,
        ("int32", "int32", 7, 12, 0): 7,
        ("int32", "int32", 8, 12, 0): 1,
        ("int32", "int32", 9, 12, 0): 9,
        ("int32", "int32", 10, 12, 0): 5,
        ("int32", "int32", 11, 12, 0): 11,
        ("int32", "int32", 12, 12, 0): 3,
        ("int32", "int32", 13, 12, 0): 13,
        ("int32", "int32", 14, 12, 0): 7,
        ("int32", "int32", 15, 12, 0): 15,
        ("int32", "int32", 16, 12, 0): 1,
        ("int32", "int32", 1, 13, 0): 1,
        ("int32", "int32", 2, 13, 0): 1,
        ("int32", "int32", 3, 13, 0): 3,
        ("int32", "int32", 4, 13, 0): 1,
        ("int32", "int32", 5, 13, 0): 5,
        ("int32", "int32", 6, 13, 0): 3,
        ("int32", "int32", 7, 13, 0): 7,
        ("int32", "int32", 8, 13, 0): 2,
        ("int32", "int32", 9, 13, 0): 9,
        ("int32", "int32", 10, 13, 0): 5,
        ("int32", "int32", 11, 13, 0): 11,
        ("int32", "int32", 12, 13, 0): 3,
        ("int32", "int32", 13, 13, 0): 13,
        ("int32", "int32", 14, 13, 0): 7,
        ("int32", "int32", 15, 13, 0): 15,
        ("int32", "int32", 16, 13, 0): 4,
        ("int32", "int32", 1, 14, 0): 1,
        ("int32", "int32", 2, 14, 0): 1,
        ("int32", "int32", 3, 14, 0): 3,
        ("int32", "int32", 4, 14, 0): 1,
        ("int32", "int32", 5, 14, 0): 5,
        ("int32", "int32", 6, 14, 0): 3,
        ("int32", "int32", 7, 14, 0): 7,
        ("int32", "int32", 8, 14, 0): 1,
        ("int32", "int32", 9, 14, 0): 9,
        ("int32", "int32", 10, 14, 0): 5,
        ("int32", "int32", 11, 14, 0): 11,
        ("int32", "int32", 12, 14, 0): 3,
        ("int32", "int32", 13, 14, 0): 13,
        ("int32", "int32", 14, 14, 0): 7,
        ("int32", "int32", 15, 14, 0): 15,
        ("int32", "int32", 16, 14, 0): 2,
        ("int32", "int32", 1, 15, 0): 1,
        ("int32", "int32", 2, 15, 0): 1,
        ("int32", "int32", 3, 15, 0): 3,
        ("int32", "int32", 4, 15, 0): 1,
        ("int32", "int32", 5, 15, 0): 5,
        ("int32", "int32", 6, 15, 0): 3,
        ("int32", "int32", 7, 15, 0): 7,
        ("int32", "int32", 8, 15, 0): 2,
        ("int32", "int32", 9, 15, 0): 9,
        ("int32", "int32", 10, 15, 0): 5,
        ("int32", "int32", 11, 15, 0): 11,
        ("int32", "int32", 12, 15, 0): 3,
        ("int32", "int32", 13, 15, 0): 13,
        ("int32", "int32", 14, 15, 0): 7,
        ("int32", "int32", 15, 15, 0): 15,
        ("int32", "int32", 16, 15, 0): 4,
        ("int32", "int32", 1, 16, 0): 1,
        ("int32", "int32", 2, 16, 0): 1,
        ("int32", "int32", 3, 16, 0): 3,
        ("int32", "int32", 4, 16, 0): 1,
        ("int32", "int32", 5, 16, 0): 5,
        ("int32", "int32", 6, 16, 0): 3,
        ("int32", "int32", 7, 16, 0): 7,
        ("int32", "int32", 8, 16, 0): 1,
        ("int32", "int32", 9, 16, 0): 9,
        ("int32", "int32", 10, 16, 0): 5,
        ("int32", "int32", 11, 16, 0): 11,
        ("int32", "int32", 12, 16, 0): 3,
        ("int32", "int32", 13, 16, 0): 13,
        ("int32", "int32", 14, 16, 0): 7,
        ("int32", "int32", 15, 16, 0): 15,
        ("int32", "int32", 16, 16, 0): 1,
        ("int32", "int32", 1, 1, 1): 1,
        ("int32", "int32", 2, 1, 1): 1,
        ("int32", "int32", 3, 1, 1): 3,
        ("int32", "int32", 4, 1, 1): 2,
        ("int32", "int32", 5, 1, 1): 5,
        ("int32", "int32", 6, 1, 1): 3,
        ("int32", "int32", 7, 1, 1): 7,
        ("int32", "int32", 8, 1, 1): 4,
        ("int32", "int32", 9, 1, 1): 9,
        ("int32", "int32", 10, 1, 1): 5,
        ("int32", "int32", 11, 1, 1): 11,
        ("int32", "int32", 12, 1, 1): 6,
        ("int32", "int32", 13, 1, 1): 13,
        ("int32", "int32", 14, 1, 1): 7,
        ("int32", "int32", 15, 1, 1): 15,
        ("int32", "int32", 16, 1, 1): 8,
        ("int32", "int32", 1, 2, 1): 1,
        ("int32", "int32", 2, 2, 1): 1,
        ("int32", "int32", 3, 2, 1): 3,
        ("int32", "int32", 4, 2, 1): 1,
        ("int32", "int32", 5, 2, 1): 5,
        ("int32", "int32", 6, 2, 1): 3,
        ("int32", "int32", 7, 2, 1): 7,
        ("int32", "int32", 8, 2, 1): 2,
        ("int32", "int32", 9, 2, 1): 9,
        ("int32", "int32", 10, 2, 1): 5,
        ("int32", "int32", 11, 2, 1): 11,
        ("int32", "int32", 12, 2, 1): 3,
        ("int32", "int32", 13, 2, 1): 13,
        ("int32", "int32", 14, 2, 1): 7,
        ("int32", "int32", 15, 2, 1): 15,
        ("int32", "int32", 16, 2, 1): 4,
        ("int32", "int32", 1, 3, 1): 1,
        ("int32", "int32", 2, 3, 1): 1,
        ("int32", "int32", 3, 3, 1): 3,
        ("int32", "int32", 4, 3, 1): 2,
        ("int32", "int32", 5, 3, 1): 5,
        ("int32", "int32", 6, 3, 1): 3,
        ("int32", "int32", 7, 3, 1): 7,
        ("int32", "int32", 8, 3, 1): 4,
        ("int32", "int32", 9, 3, 1): 9,
        ("int32", "int32", 10, 3, 1): 5,
        ("int32", "int32", 11, 3, 1): 11,
        ("int32", "int32", 12, 3, 1): 6,
        ("int32", "int32", 13, 3, 1): 13,
        ("int32", "int32", 14, 3, 1): 7,
        ("int32", "int32", 15, 3, 1): 15,
        ("int32", "int32", 16, 3, 1): 8,
        ("int32", "int32", 1, 4, 1): 1,
        ("int32", "int32", 2, 4, 1): 1,
        ("int32", "int32", 3, 4, 1): 3,
        ("int32", "int32", 4, 4, 1): 1,
        ("int32", "int32", 5, 4, 1): 5,
        ("int32", "int32", 6, 4, 1): 3,
        ("int32", "int32", 7, 4, 1): 7,
        ("int32", "int32", 8, 4, 1): 1,
        ("int32", "int32", 9, 4, 1): 9,
        ("int32", "int32", 10, 4, 1): 5,
        ("int32", "int32", 11, 4, 1): 11,
        ("int32", "int32", 12, 4, 1): 3,
        ("int32", "int32", 13, 4, 1): 13,
        ("int32", "int32", 14, 4, 1): 7,
        ("int32", "int32", 15, 4, 1): 15,
        ("int32", "int32", 16, 4, 1): 2,
        ("int32", "int32", 1, 5, 1): 1,
        ("int32", "int32", 2, 5, 1): 1,
        ("int32", "int32", 3, 5, 1): 3,
        ("int32", "int32", 4, 5, 1): 2,
        ("int32", "int32", 5, 5, 1): 5,
        ("int32", "int32", 6, 5, 1): 3,
        ("int32", "int32", 7, 5, 1): 7,
        ("int32", "int32", 8, 5, 1): 4,
        ("int32", "int32", 9, 5, 1): 9,
        ("int32", "int32", 10, 5, 1): 5,
        ("int32", "int32", 11, 5, 1): 11,
        ("int32", "int32", 12, 5, 1): 6,
        ("int32", "int32", 13, 5, 1): 13,
        ("int32", "int32", 14, 5, 1): 7,
        ("int32", "int32", 15, 5, 1): 15,
        ("int32", "int32", 16, 5, 1): 8,
        ("int32", "int32", 1, 6, 1): 1,
        ("int32", "int32", 2, 6, 1): 1,
        ("int32", "int32", 3, 6, 1): 3,
        ("int32", "int32", 4, 6, 1): 1,
        ("int32", "int32", 5, 6, 1): 5,
        ("int32", "int32", 6, 6, 1): 3,
        ("int32", "int32", 7, 6, 1): 7,
        ("int32", "int32", 8, 6, 1): 2,
        ("int32", "int32", 9, 6, 1): 9,
        ("int32", "int32", 10, 6, 1): 5,
        ("int32", "int32", 11, 6, 1): 11,
        ("int32", "int32", 12, 6, 1): 3,
        ("int32", "int32", 13, 6, 1): 13,
        ("int32", "int32", 14, 6, 1): 7,
        ("int32", "int32", 15, 6, 1): 15,
        ("int32", "int32", 16, 6, 1): 4,
        ("int32", "int32", 1, 7, 1): 1,
        ("int32", "int32", 2, 7, 1): 1,
        ("int32", "int32", 3, 7, 1): 3,
        ("int32", "int32", 4, 7, 1): 2,
        ("int32", "int32", 5, 7, 1): 5,
        ("int32", "int32", 6, 7, 1): 3,
        ("int32", "int32", 7, 7, 1): 7,
        ("int32", "int32", 8, 7, 1): 4,
        ("int32", "int32", 9, 7, 1): 9,
        ("int32", "int32", 10, 7, 1): 5,
        ("int32", "int32", 11, 7, 1): 11,
        ("int32", "int32", 12, 7, 1): 6,
        ("int32", "int32", 13, 7, 1): 13,
        ("int32", "int32", 14, 7, 1): 7,
        ("int32", "int32", 15, 7, 1): 15,
        ("int32", "int32", 16, 7, 1): 8,
        ("int32", "int32", 1, 8, 1): 1,
        ("int32", "int32", 2, 8, 1): 1,
        ("int32", "int32", 3, 8, 1): 3,
        ("int32", "int32", 4, 8, 1): 1,
        ("int32", "int32", 5, 8, 1): 5,
        ("int32", "int32", 6, 8, 1): 3,
        ("int32", "int32", 7, 8, 1): 7,
        ("int32", "int32", 8, 8, 1): 1,
        ("int32", "int32", 9, 8, 1): 9,
        ("int32", "int32", 10, 8, 1): 5,
        ("int32", "int32", 11, 8, 1): 11,
        ("int32", "int32", 12, 8, 1): 3,
        ("int32", "int32", 13, 8, 1): 13,
        ("int32", "int32", 14, 8, 1): 7,
        ("int32", "int32", 15, 8, 1): 15,
        ("int32", "int32", 16, 8, 1): 2,
        ("int32", "int32", 1, 9, 1): 1,
        ("int32", "int32", 2, 9, 1): 1,
        ("int32", "int32", 3, 9, 1): 3,
        ("int32", "int32", 4, 9, 1): 2,
        ("int32", "int32", 5, 9, 1): 5,
        ("int32", "int32", 6, 9, 1): 3,
        ("int32", "int32", 7, 9, 1): 7,
        ("int32", "int32", 8, 9, 1): 4,
        ("int32", "int32", 9, 9, 1): 9,
        ("int32", "int32", 10, 9, 1): 5,
        ("int32", "int32", 11, 9, 1): 11,
        ("int32", "int32", 12, 9, 1): 6,
        ("int32", "int32", 13, 9, 1): 13,
        ("int32", "int32", 14, 9, 1): 7,
        ("int32", "int32", 15, 9, 1): 15,
        ("int32", "int32", 16, 9, 1): 8,
        ("int32", "int32", 1, 10, 1): 1,
        ("int32", "int32", 2, 10, 1): 1,
        ("int32", "int32", 3, 10, 1): 3,
        ("int32", "int32", 4, 10, 1): 1,
        ("int32", "int32", 5, 10, 1): 5,
        ("int32", "int32", 6, 10, 1): 3,
        ("int32", "int32", 7, 10, 1): 7,
        ("int32", "int32", 8, 10, 1): 2,
        ("int32", "int32", 9, 10, 1): 9,
        ("int32", "int32", 10, 10, 1): 5,
        ("int32", "int32", 11, 10, 1): 11,
        ("int32", "int32", 12, 10, 1): 3,
        ("int32", "int32", 13, 10, 1): 13,
        ("int32", "int32", 14, 10, 1): 7,
        ("int32", "int32", 15, 10, 1): 15,
        ("int32", "int32", 16, 10, 1): 4,
        ("int32", "int32", 1, 11, 1): 1,
        ("int32", "int32", 2, 11, 1): 1,
        ("int32", "int32", 3, 11, 1): 3,
        ("int32", "int32", 4, 11, 1): 2,
        ("int32", "int32", 5, 11, 1): 5,
        ("int32", "int32", 6, 11, 1): 3,
        ("int32", "int32", 7, 11, 1): 7,
        ("int32", "int32", 8, 11, 1): 4,
        ("int32", "int32", 9, 11, 1): 9,
        ("int32", "int32", 10, 11, 1): 5,
        ("int32", "int32", 11, 11, 1): 11,
        ("int32", "int32", 12, 11, 1): 6,
        ("int32", "int32", 13, 11, 1): 13,
        ("int32", "int32", 14, 11, 1): 7,
        ("int32", "int32", 15, 11, 1): 15,
        ("int32", "int32", 16, 11, 1): 8,
        ("int32", "int32", 1, 12, 1): 1,
        ("int32", "int32", 2, 12, 1): 1,
        ("int32", "int32", 3, 12, 1): 3,
        ("int32", "int32", 4, 12, 1): 1,
        ("int32", "int32", 5, 12, 1): 5,
        ("int32", "int32", 6, 12, 1): 3,
        ("int32", "int32", 7, 12, 1): 7,
        ("int32", "int32", 8, 12, 1): 1,
        ("int32", "int32", 9, 12, 1): 9,
        ("int32", "int32", 10, 12, 1): 5,
        ("int32", "int32", 11, 12, 1): 11,
        ("int32", "int32", 12, 12, 1): 3,
        ("int32", "int32", 13, 12, 1): 13,
        ("int32", "int32", 14, 12, 1): 7,
        ("int32", "int32", 15, 12, 1): 15,
        ("int32", "int32", 16, 12, 1): 2,
        ("int32", "int32", 1, 13, 1): 1,
        ("int32", "int32", 2, 13, 1): 1,
        ("int32", "int32", 3, 13, 1): 3,
        ("int32", "int32", 4, 13, 1): 2,
        ("int32", "int32", 5, 13, 1): 5,
        ("int32", "int32", 6, 13, 1): 3,
        ("int32", "int32", 7, 13, 1): 7,
        ("int32", "int32", 8, 13, 1): 4,
        ("int32", "int32", 9, 13, 1): 9,
        ("int32", "int32", 10, 13, 1): 5,
        ("int32", "int32", 11, 13, 1): 11,
        ("int32", "int32", 12, 13, 1): 6,
        ("int32", "int32", 13, 13, 1): 13,
        ("int32", "int32", 14, 13, 1): 7,
        ("int32", "int32", 15, 13, 1): 15,
        ("int32", "int32", 16, 13, 1): 8,
        ("int32", "int32", 1, 14, 1): 1,
        ("int32", "int32", 2, 14, 1): 1,
        ("int32", "int32", 3, 14, 1): 3,
        ("int32", "int32", 4, 14, 1): 1,
        ("int32", "int32", 5, 14, 1): 5,
        ("int32", "int32", 6, 14, 1): 3,
        ("int32", "int32", 7, 14, 1): 7,
        ("int32", "int32", 8, 14, 1): 2,
        ("int32", "int32", 9, 14, 1): 9,
        ("int32", "int32", 10, 14, 1): 5,
        ("int32", "int32", 11, 14, 1): 11,
        ("int32", "int32", 12, 14, 1): 3,
        ("int32", "int32", 13, 14, 1): 13,
        ("int32", "int32", 14, 14, 1): 7,
        ("int32", "int32", 15, 14, 1): 15,
        ("int32", "int32", 16, 14, 1): 4,
        ("int32", "int32", 1, 15, 1): 1,
        ("int32", "int32", 2, 15, 1): 1,
        ("int32", "int32", 3, 15, 1): 3,
        ("int32", "int32", 4, 15, 1): 2,
        ("int32", "int32", 5, 15, 1): 5,
        ("int32", "int32", 6, 15, 1): 3,
        ("int32", "int32", 7, 15, 1): 7,
        ("int32", "int32", 8, 15, 1): 4,
        ("int32", "int32", 9, 15, 1): 9,
        ("int32", "int32", 10, 15, 1): 5,
        ("int32", "int32", 11, 15, 1): 11,
        ("int32", "int32", 12, 15, 1): 6,
        ("int32", "int32", 13, 15, 1): 13,
        ("int32", "int32", 14, 15, 1): 7,
        ("int32", "int32", 15, 15, 1): 15,
        ("int32", "int32", 16, 15, 1): 8,
        ("int32", "int32", 1, 16, 1): 1,
        ("int32", "int32", 2, 16, 1): 1,
        ("int32", "int32", 3, 16, 1): 3,
        ("int32", "int32", 4, 16, 1): 1,
        ("int32", "int32", 5, 16, 1): 5,
        ("int32", "int32", 6, 16, 1): 3,
        ("int32", "int32", 7, 16, 1): 7,
        ("int32", "int32", 8, 16, 1): 1,
        ("int32", "int32", 9, 16, 1): 9,
        ("int32", "int32", 10, 16, 1): 5,
        ("int32", "int32", 11, 16, 1): 11,
        ("int32", "int32", 12, 16, 1): 3,
        ("int32", "int32", 13, 16, 1): 13,
        ("int32", "int32", 14, 16, 1): 7,
        ("int32", "int32", 15, 16, 1): 15,
        ("int32", "int32", 16, 16, 1): 2,
        ("cint32", "int16", 1, 1, 0): 1,
        ("cint32", "int16", 2, 1, 0): 1,
        ("cint32", "int16", 3, 1, 0): 3,
        ("cint32", "int16", 4, 1, 0): 1,
        ("cint32", "int16", 5, 1, 0): 5,
        ("cint32", "int16", 6, 1, 0): 3,
        ("cint32", "int16", 7, 1, 0): 7,
        ("cint32", "int16", 8, 1, 0): 1,
        ("cint32", "int16", 9, 1, 0): 9,
        ("cint32", "int16", 10, 1, 0): 5,
        ("cint32", "int16", 11, 1, 0): 11,
        ("cint32", "int16", 12, 1, 0): 3,
        ("cint32", "int16", 13, 1, 0): 13,
        ("cint32", "int16", 14, 1, 0): 7,
        ("cint32", "int16", 15, 1, 0): 15,
        ("cint32", "int16", 16, 1, 0): 2,
        ("cint32", "int16", 1, 2, 0): 1,
        ("cint32", "int16", 2, 2, 0): 1,
        ("cint32", "int16", 3, 2, 0): 3,
        ("cint32", "int16", 4, 2, 0): 1,
        ("cint32", "int16", 5, 2, 0): 5,
        ("cint32", "int16", 6, 2, 0): 3,
        ("cint32", "int16", 7, 2, 0): 7,
        ("cint32", "int16", 8, 2, 0): 1,
        ("cint32", "int16", 9, 2, 0): 9,
        ("cint32", "int16", 10, 2, 0): 5,
        ("cint32", "int16", 11, 2, 0): 11,
        ("cint32", "int16", 12, 2, 0): 3,
        ("cint32", "int16", 13, 2, 0): 13,
        ("cint32", "int16", 14, 2, 0): 7,
        ("cint32", "int16", 15, 2, 0): 15,
        ("cint32", "int16", 16, 2, 0): 1,
        ("cint32", "int16", 1, 3, 0): 1,
        ("cint32", "int16", 2, 3, 0): 1,
        ("cint32", "int16", 3, 3, 0): 3,
        ("cint32", "int16", 4, 3, 0): 1,
        ("cint32", "int16", 5, 3, 0): 5,
        ("cint32", "int16", 6, 3, 0): 3,
        ("cint32", "int16", 7, 3, 0): 7,
        ("cint32", "int16", 8, 3, 0): 1,
        ("cint32", "int16", 9, 3, 0): 9,
        ("cint32", "int16", 10, 3, 0): 5,
        ("cint32", "int16", 11, 3, 0): 11,
        ("cint32", "int16", 12, 3, 0): 3,
        ("cint32", "int16", 13, 3, 0): 13,
        ("cint32", "int16", 14, 3, 0): 7,
        ("cint32", "int16", 15, 3, 0): 15,
        ("cint32", "int16", 16, 3, 0): 2,
        ("cint32", "int16", 1, 4, 0): 1,
        ("cint32", "int16", 2, 4, 0): 1,
        ("cint32", "int16", 3, 4, 0): 3,
        ("cint32", "int16", 4, 4, 0): 1,
        ("cint32", "int16", 5, 4, 0): 5,
        ("cint32", "int16", 6, 4, 0): 3,
        ("cint32", "int16", 7, 4, 0): 7,
        ("cint32", "int16", 8, 4, 0): 1,
        ("cint32", "int16", 9, 4, 0): 9,
        ("cint32", "int16", 10, 4, 0): 5,
        ("cint32", "int16", 11, 4, 0): 11,
        ("cint32", "int16", 12, 4, 0): 3,
        ("cint32", "int16", 13, 4, 0): 13,
        ("cint32", "int16", 14, 4, 0): 7,
        ("cint32", "int16", 15, 4, 0): 15,
        ("cint32", "int16", 16, 4, 0): 1,
        ("cint32", "int16", 1, 5, 0): 1,
        ("cint32", "int16", 2, 5, 0): 1,
        ("cint32", "int16", 3, 5, 0): 3,
        ("cint32", "int16", 4, 5, 0): 1,
        ("cint32", "int16", 5, 5, 0): 5,
        ("cint32", "int16", 6, 5, 0): 3,
        ("cint32", "int16", 7, 5, 0): 7,
        ("cint32", "int16", 8, 5, 0): 1,
        ("cint32", "int16", 9, 5, 0): 9,
        ("cint32", "int16", 10, 5, 0): 5,
        ("cint32", "int16", 11, 5, 0): 11,
        ("cint32", "int16", 12, 5, 0): 3,
        ("cint32", "int16", 13, 5, 0): 13,
        ("cint32", "int16", 14, 5, 0): 7,
        ("cint32", "int16", 15, 5, 0): 15,
        ("cint32", "int16", 16, 5, 0): 2,
        ("cint32", "int16", 1, 6, 0): 1,
        ("cint32", "int16", 2, 6, 0): 1,
        ("cint32", "int16", 3, 6, 0): 3,
        ("cint32", "int16", 4, 6, 0): 1,
        ("cint32", "int16", 5, 6, 0): 5,
        ("cint32", "int16", 6, 6, 0): 3,
        ("cint32", "int16", 7, 6, 0): 7,
        ("cint32", "int16", 8, 6, 0): 1,
        ("cint32", "int16", 9, 6, 0): 9,
        ("cint32", "int16", 10, 6, 0): 5,
        ("cint32", "int16", 11, 6, 0): 11,
        ("cint32", "int16", 12, 6, 0): 3,
        ("cint32", "int16", 13, 6, 0): 13,
        ("cint32", "int16", 14, 6, 0): 7,
        ("cint32", "int16", 15, 6, 0): 15,
        ("cint32", "int16", 16, 6, 0): 1,
        ("cint32", "int16", 1, 7, 0): 1,
        ("cint32", "int16", 2, 7, 0): 1,
        ("cint32", "int16", 3, 7, 0): 3,
        ("cint32", "int16", 4, 7, 0): 1,
        ("cint32", "int16", 5, 7, 0): 5,
        ("cint32", "int16", 6, 7, 0): 3,
        ("cint32", "int16", 7, 7, 0): 7,
        ("cint32", "int16", 8, 7, 0): 1,
        ("cint32", "int16", 9, 7, 0): 9,
        ("cint32", "int16", 10, 7, 0): 5,
        ("cint32", "int16", 11, 7, 0): 11,
        ("cint32", "int16", 12, 7, 0): 3,
        ("cint32", "int16", 13, 7, 0): 13,
        ("cint32", "int16", 14, 7, 0): 7,
        ("cint32", "int16", 15, 7, 0): 15,
        ("cint32", "int16", 16, 7, 0): 2,
        ("cint32", "int16", 1, 8, 0): 1,
        ("cint32", "int16", 2, 8, 0): 1,
        ("cint32", "int16", 3, 8, 0): 3,
        ("cint32", "int16", 4, 8, 0): 1,
        ("cint32", "int16", 5, 8, 0): 5,
        ("cint32", "int16", 6, 8, 0): 3,
        ("cint32", "int16", 7, 8, 0): 7,
        ("cint32", "int16", 8, 8, 0): 1,
        ("cint32", "int16", 9, 8, 0): 9,
        ("cint32", "int16", 10, 8, 0): 5,
        ("cint32", "int16", 11, 8, 0): 11,
        ("cint32", "int16", 12, 8, 0): 3,
        ("cint32", "int16", 13, 8, 0): 13,
        ("cint32", "int16", 14, 8, 0): 7,
        ("cint32", "int16", 15, 8, 0): 15,
        ("cint32", "int16", 16, 8, 0): 1,
        ("cint32", "int16", 1, 9, 0): 1,
        ("cint32", "int16", 2, 9, 0): 1,
        ("cint32", "int16", 3, 9, 0): 3,
        ("cint32", "int16", 4, 9, 0): 1,
        ("cint32", "int16", 5, 9, 0): 5,
        ("cint32", "int16", 6, 9, 0): 3,
        ("cint32", "int16", 7, 9, 0): 7,
        ("cint32", "int16", 8, 9, 0): 1,
        ("cint32", "int16", 9, 9, 0): 9,
        ("cint32", "int16", 10, 9, 0): 5,
        ("cint32", "int16", 11, 9, 0): 11,
        ("cint32", "int16", 12, 9, 0): 3,
        ("cint32", "int16", 13, 9, 0): 13,
        ("cint32", "int16", 14, 9, 0): 7,
        ("cint32", "int16", 15, 9, 0): 15,
        ("cint32", "int16", 16, 9, 0): 2,
        ("cint32", "int16", 1, 10, 0): 1,
        ("cint32", "int16", 2, 10, 0): 1,
        ("cint32", "int16", 3, 10, 0): 3,
        ("cint32", "int16", 4, 10, 0): 1,
        ("cint32", "int16", 5, 10, 0): 5,
        ("cint32", "int16", 6, 10, 0): 3,
        ("cint32", "int16", 7, 10, 0): 7,
        ("cint32", "int16", 8, 10, 0): 1,
        ("cint32", "int16", 9, 10, 0): 9,
        ("cint32", "int16", 10, 10, 0): 5,
        ("cint32", "int16", 11, 10, 0): 11,
        ("cint32", "int16", 12, 10, 0): 3,
        ("cint32", "int16", 13, 10, 0): 13,
        ("cint32", "int16", 14, 10, 0): 7,
        ("cint32", "int16", 15, 10, 0): 15,
        ("cint32", "int16", 16, 10, 0): 1,
        ("cint32", "int16", 1, 11, 0): 1,
        ("cint32", "int16", 2, 11, 0): 1,
        ("cint32", "int16", 3, 11, 0): 3,
        ("cint32", "int16", 4, 11, 0): 1,
        ("cint32", "int16", 5, 11, 0): 5,
        ("cint32", "int16", 6, 11, 0): 3,
        ("cint32", "int16", 7, 11, 0): 7,
        ("cint32", "int16", 8, 11, 0): 1,
        ("cint32", "int16", 9, 11, 0): 9,
        ("cint32", "int16", 10, 11, 0): 5,
        ("cint32", "int16", 11, 11, 0): 11,
        ("cint32", "int16", 12, 11, 0): 3,
        ("cint32", "int16", 13, 11, 0): 13,
        ("cint32", "int16", 14, 11, 0): 7,
        ("cint32", "int16", 15, 11, 0): 15,
        ("cint32", "int16", 16, 11, 0): 2,
        ("cint32", "int16", 1, 12, 0): 1,
        ("cint32", "int16", 2, 12, 0): 1,
        ("cint32", "int16", 3, 12, 0): 3,
        ("cint32", "int16", 4, 12, 0): 1,
        ("cint32", "int16", 5, 12, 0): 5,
        ("cint32", "int16", 6, 12, 0): 3,
        ("cint32", "int16", 7, 12, 0): 7,
        ("cint32", "int16", 8, 12, 0): 1,
        ("cint32", "int16", 9, 12, 0): 9,
        ("cint32", "int16", 10, 12, 0): 5,
        ("cint32", "int16", 11, 12, 0): 11,
        ("cint32", "int16", 12, 12, 0): 3,
        ("cint32", "int16", 13, 12, 0): 13,
        ("cint32", "int16", 14, 12, 0): 7,
        ("cint32", "int16", 15, 12, 0): 15,
        ("cint32", "int16", 16, 12, 0): 1,
        ("cint32", "int16", 1, 13, 0): 1,
        ("cint32", "int16", 2, 13, 0): 1,
        ("cint32", "int16", 3, 13, 0): 3,
        ("cint32", "int16", 4, 13, 0): 1,
        ("cint32", "int16", 5, 13, 0): 5,
        ("cint32", "int16", 6, 13, 0): 3,
        ("cint32", "int16", 7, 13, 0): 7,
        ("cint32", "int16", 8, 13, 0): 1,
        ("cint32", "int16", 9, 13, 0): 9,
        ("cint32", "int16", 10, 13, 0): 5,
        ("cint32", "int16", 11, 13, 0): 11,
        ("cint32", "int16", 12, 13, 0): 3,
        ("cint32", "int16", 13, 13, 0): 13,
        ("cint32", "int16", 14, 13, 0): 7,
        ("cint32", "int16", 15, 13, 0): 15,
        ("cint32", "int16", 16, 13, 0): 2,
        ("cint32", "int16", 1, 14, 0): 1,
        ("cint32", "int16", 2, 14, 0): 1,
        ("cint32", "int16", 3, 14, 0): 3,
        ("cint32", "int16", 4, 14, 0): 1,
        ("cint32", "int16", 5, 14, 0): 5,
        ("cint32", "int16", 6, 14, 0): 3,
        ("cint32", "int16", 7, 14, 0): 7,
        ("cint32", "int16", 8, 14, 0): 1,
        ("cint32", "int16", 9, 14, 0): 9,
        ("cint32", "int16", 10, 14, 0): 5,
        ("cint32", "int16", 11, 14, 0): 11,
        ("cint32", "int16", 12, 14, 0): 3,
        ("cint32", "int16", 13, 14, 0): 13,
        ("cint32", "int16", 14, 14, 0): 7,
        ("cint32", "int16", 15, 14, 0): 15,
        ("cint32", "int16", 16, 14, 0): 1,
        ("cint32", "int16", 1, 15, 0): 1,
        ("cint32", "int16", 2, 15, 0): 1,
        ("cint32", "int16", 3, 15, 0): 3,
        ("cint32", "int16", 4, 15, 0): 1,
        ("cint32", "int16", 5, 15, 0): 5,
        ("cint32", "int16", 6, 15, 0): 3,
        ("cint32", "int16", 7, 15, 0): 7,
        ("cint32", "int16", 8, 15, 0): 1,
        ("cint32", "int16", 9, 15, 0): 9,
        ("cint32", "int16", 10, 15, 0): 5,
        ("cint32", "int16", 11, 15, 0): 11,
        ("cint32", "int16", 12, 15, 0): 3,
        ("cint32", "int16", 13, 15, 0): 13,
        ("cint32", "int16", 14, 15, 0): 7,
        ("cint32", "int16", 15, 15, 0): 15,
        ("cint32", "int16", 16, 15, 0): 2,
        ("cint32", "int16", 1, 16, 0): 1,
        ("cint32", "int16", 2, 16, 0): 1,
        ("cint32", "int16", 3, 16, 0): 3,
        ("cint32", "int16", 4, 16, 0): 1,
        ("cint32", "int16", 5, 16, 0): 5,
        ("cint32", "int16", 6, 16, 0): 3,
        ("cint32", "int16", 7, 16, 0): 7,
        ("cint32", "int16", 8, 16, 0): 1,
        ("cint32", "int16", 9, 16, 0): 9,
        ("cint32", "int16", 10, 16, 0): 5,
        ("cint32", "int16", 11, 16, 0): 11,
        ("cint32", "int16", 12, 16, 0): 3,
        ("cint32", "int16", 13, 16, 0): 13,
        ("cint32", "int16", 14, 16, 0): 7,
        ("cint32", "int16", 15, 16, 0): 15,
        ("cint32", "int16", 16, 16, 0): 1,
        ("cint32", "int16", 1, 1, 1): 1,
        ("cint32", "int16", 2, 1, 1): 1,
        ("cint32", "int16", 3, 1, 1): 3,
        ("cint32", "int16", 4, 1, 1): 1,
        ("cint32", "int16", 5, 1, 1): 5,
        ("cint32", "int16", 6, 1, 1): 3,
        ("cint32", "int16", 7, 1, 1): 7,
        ("cint32", "int16", 8, 1, 1): 2,
        ("cint32", "int16", 9, 1, 1): 9,
        ("cint32", "int16", 10, 1, 1): 5,
        ("cint32", "int16", 11, 1, 1): 11,
        ("cint32", "int16", 12, 1, 1): 3,
        ("cint32", "int16", 13, 1, 1): 13,
        ("cint32", "int16", 14, 1, 1): 7,
        ("cint32", "int16", 15, 1, 1): 15,
        ("cint32", "int16", 16, 1, 1): 4,
        ("cint32", "int16", 1, 2, 1): 1,
        ("cint32", "int16", 2, 2, 1): 1,
        ("cint32", "int16", 3, 2, 1): 3,
        ("cint32", "int16", 4, 2, 1): 1,
        ("cint32", "int16", 5, 2, 1): 5,
        ("cint32", "int16", 6, 2, 1): 3,
        ("cint32", "int16", 7, 2, 1): 7,
        ("cint32", "int16", 8, 2, 1): 1,
        ("cint32", "int16", 9, 2, 1): 9,
        ("cint32", "int16", 10, 2, 1): 5,
        ("cint32", "int16", 11, 2, 1): 11,
        ("cint32", "int16", 12, 2, 1): 3,
        ("cint32", "int16", 13, 2, 1): 13,
        ("cint32", "int16", 14, 2, 1): 7,
        ("cint32", "int16", 15, 2, 1): 15,
        ("cint32", "int16", 16, 2, 1): 2,
        ("cint32", "int16", 1, 3, 1): 1,
        ("cint32", "int16", 2, 3, 1): 1,
        ("cint32", "int16", 3, 3, 1): 3,
        ("cint32", "int16", 4, 3, 1): 1,
        ("cint32", "int16", 5, 3, 1): 5,
        ("cint32", "int16", 6, 3, 1): 3,
        ("cint32", "int16", 7, 3, 1): 7,
        ("cint32", "int16", 8, 3, 1): 2,
        ("cint32", "int16", 9, 3, 1): 9,
        ("cint32", "int16", 10, 3, 1): 5,
        ("cint32", "int16", 11, 3, 1): 11,
        ("cint32", "int16", 12, 3, 1): 3,
        ("cint32", "int16", 13, 3, 1): 13,
        ("cint32", "int16", 14, 3, 1): 7,
        ("cint32", "int16", 15, 3, 1): 15,
        ("cint32", "int16", 16, 3, 1): 4,
        ("cint32", "int16", 1, 4, 1): 1,
        ("cint32", "int16", 2, 4, 1): 1,
        ("cint32", "int16", 3, 4, 1): 3,
        ("cint32", "int16", 4, 4, 1): 1,
        ("cint32", "int16", 5, 4, 1): 5,
        ("cint32", "int16", 6, 4, 1): 3,
        ("cint32", "int16", 7, 4, 1): 7,
        ("cint32", "int16", 8, 4, 1): 1,
        ("cint32", "int16", 9, 4, 1): 9,
        ("cint32", "int16", 10, 4, 1): 5,
        ("cint32", "int16", 11, 4, 1): 11,
        ("cint32", "int16", 12, 4, 1): 3,
        ("cint32", "int16", 13, 4, 1): 13,
        ("cint32", "int16", 14, 4, 1): 7,
        ("cint32", "int16", 15, 4, 1): 15,
        ("cint32", "int16", 16, 4, 1): 2,
        ("cint32", "int16", 1, 5, 1): 1,
        ("cint32", "int16", 2, 5, 1): 1,
        ("cint32", "int16", 3, 5, 1): 3,
        ("cint32", "int16", 4, 5, 1): 1,
        ("cint32", "int16", 5, 5, 1): 5,
        ("cint32", "int16", 6, 5, 1): 3,
        ("cint32", "int16", 7, 5, 1): 7,
        ("cint32", "int16", 8, 5, 1): 2,
        ("cint32", "int16", 9, 5, 1): 9,
        ("cint32", "int16", 10, 5, 1): 5,
        ("cint32", "int16", 11, 5, 1): 11,
        ("cint32", "int16", 12, 5, 1): 3,
        ("cint32", "int16", 13, 5, 1): 13,
        ("cint32", "int16", 14, 5, 1): 7,
        ("cint32", "int16", 15, 5, 1): 15,
        ("cint32", "int16", 16, 5, 1): 4,
        ("cint32", "int16", 1, 6, 1): 1,
        ("cint32", "int16", 2, 6, 1): 1,
        ("cint32", "int16", 3, 6, 1): 3,
        ("cint32", "int16", 4, 6, 1): 1,
        ("cint32", "int16", 5, 6, 1): 5,
        ("cint32", "int16", 6, 6, 1): 3,
        ("cint32", "int16", 7, 6, 1): 7,
        ("cint32", "int16", 8, 6, 1): 1,
        ("cint32", "int16", 9, 6, 1): 9,
        ("cint32", "int16", 10, 6, 1): 5,
        ("cint32", "int16", 11, 6, 1): 11,
        ("cint32", "int16", 12, 6, 1): 3,
        ("cint32", "int16", 13, 6, 1): 13,
        ("cint32", "int16", 14, 6, 1): 7,
        ("cint32", "int16", 15, 6, 1): 15,
        ("cint32", "int16", 16, 6, 1): 2,
        ("cint32", "int16", 1, 7, 1): 1,
        ("cint32", "int16", 2, 7, 1): 1,
        ("cint32", "int16", 3, 7, 1): 3,
        ("cint32", "int16", 4, 7, 1): 1,
        ("cint32", "int16", 5, 7, 1): 5,
        ("cint32", "int16", 6, 7, 1): 3,
        ("cint32", "int16", 7, 7, 1): 7,
        ("cint32", "int16", 8, 7, 1): 2,
        ("cint32", "int16", 9, 7, 1): 9,
        ("cint32", "int16", 10, 7, 1): 5,
        ("cint32", "int16", 11, 7, 1): 11,
        ("cint32", "int16", 12, 7, 1): 3,
        ("cint32", "int16", 13, 7, 1): 13,
        ("cint32", "int16", 14, 7, 1): 7,
        ("cint32", "int16", 15, 7, 1): 15,
        ("cint32", "int16", 16, 7, 1): 4,
        ("cint32", "int16", 1, 8, 1): 1,
        ("cint32", "int16", 2, 8, 1): 1,
        ("cint32", "int16", 3, 8, 1): 3,
        ("cint32", "int16", 4, 8, 1): 1,
        ("cint32", "int16", 5, 8, 1): 5,
        ("cint32", "int16", 6, 8, 1): 3,
        ("cint32", "int16", 7, 8, 1): 7,
        ("cint32", "int16", 8, 8, 1): 1,
        ("cint32", "int16", 9, 8, 1): 9,
        ("cint32", "int16", 10, 8, 1): 5,
        ("cint32", "int16", 11, 8, 1): 11,
        ("cint32", "int16", 12, 8, 1): 3,
        ("cint32", "int16", 13, 8, 1): 13,
        ("cint32", "int16", 14, 8, 1): 7,
        ("cint32", "int16", 15, 8, 1): 15,
        ("cint32", "int16", 16, 8, 1): 2,
        ("cint32", "int16", 1, 9, 1): 1,
        ("cint32", "int16", 2, 9, 1): 1,
        ("cint32", "int16", 3, 9, 1): 3,
        ("cint32", "int16", 4, 9, 1): 1,
        ("cint32", "int16", 5, 9, 1): 5,
        ("cint32", "int16", 6, 9, 1): 3,
        ("cint32", "int16", 7, 9, 1): 7,
        ("cint32", "int16", 8, 9, 1): 2,
        ("cint32", "int16", 9, 9, 1): 9,
        ("cint32", "int16", 10, 9, 1): 5,
        ("cint32", "int16", 11, 9, 1): 11,
        ("cint32", "int16", 12, 9, 1): 3,
        ("cint32", "int16", 13, 9, 1): 13,
        ("cint32", "int16", 14, 9, 1): 7,
        ("cint32", "int16", 15, 9, 1): 15,
        ("cint32", "int16", 16, 9, 1): 4,
        ("cint32", "int16", 1, 10, 1): 1,
        ("cint32", "int16", 2, 10, 1): 1,
        ("cint32", "int16", 3, 10, 1): 3,
        ("cint32", "int16", 4, 10, 1): 1,
        ("cint32", "int16", 5, 10, 1): 5,
        ("cint32", "int16", 6, 10, 1): 3,
        ("cint32", "int16", 7, 10, 1): 7,
        ("cint32", "int16", 8, 10, 1): 1,
        ("cint32", "int16", 9, 10, 1): 9,
        ("cint32", "int16", 10, 10, 1): 5,
        ("cint32", "int16", 11, 10, 1): 11,
        ("cint32", "int16", 12, 10, 1): 3,
        ("cint32", "int16", 13, 10, 1): 13,
        ("cint32", "int16", 14, 10, 1): 7,
        ("cint32", "int16", 15, 10, 1): 15,
        ("cint32", "int16", 16, 10, 1): 2,
        ("cint32", "int16", 1, 11, 1): 1,
        ("cint32", "int16", 2, 11, 1): 1,
        ("cint32", "int16", 3, 11, 1): 3,
        ("cint32", "int16", 4, 11, 1): 1,
        ("cint32", "int16", 5, 11, 1): 5,
        ("cint32", "int16", 6, 11, 1): 3,
        ("cint32", "int16", 7, 11, 1): 7,
        ("cint32", "int16", 8, 11, 1): 2,
        ("cint32", "int16", 9, 11, 1): 9,
        ("cint32", "int16", 10, 11, 1): 5,
        ("cint32", "int16", 11, 11, 1): 11,
        ("cint32", "int16", 12, 11, 1): 3,
        ("cint32", "int16", 13, 11, 1): 13,
        ("cint32", "int16", 14, 11, 1): 7,
        ("cint32", "int16", 15, 11, 1): 15,
        ("cint32", "int16", 16, 11, 1): 4,
        ("cint32", "int16", 1, 12, 1): 1,
        ("cint32", "int16", 2, 12, 1): 1,
        ("cint32", "int16", 3, 12, 1): 3,
        ("cint32", "int16", 4, 12, 1): 1,
        ("cint32", "int16", 5, 12, 1): 5,
        ("cint32", "int16", 6, 12, 1): 3,
        ("cint32", "int16", 7, 12, 1): 7,
        ("cint32", "int16", 8, 12, 1): 1,
        ("cint32", "int16", 9, 12, 1): 9,
        ("cint32", "int16", 10, 12, 1): 5,
        ("cint32", "int16", 11, 12, 1): 11,
        ("cint32", "int16", 12, 12, 1): 3,
        ("cint32", "int16", 13, 12, 1): 13,
        ("cint32", "int16", 14, 12, 1): 7,
        ("cint32", "int16", 15, 12, 1): 15,
        ("cint32", "int16", 16, 12, 1): 2,
        ("cint32", "int16", 1, 13, 1): 1,
        ("cint32", "int16", 2, 13, 1): 1,
        ("cint32", "int16", 3, 13, 1): 3,
        ("cint32", "int16", 4, 13, 1): 1,
        ("cint32", "int16", 5, 13, 1): 5,
        ("cint32", "int16", 6, 13, 1): 3,
        ("cint32", "int16", 7, 13, 1): 7,
        ("cint32", "int16", 8, 13, 1): 2,
        ("cint32", "int16", 9, 13, 1): 9,
        ("cint32", "int16", 10, 13, 1): 5,
        ("cint32", "int16", 11, 13, 1): 11,
        ("cint32", "int16", 12, 13, 1): 3,
        ("cint32", "int16", 13, 13, 1): 13,
        ("cint32", "int16", 14, 13, 1): 7,
        ("cint32", "int16", 15, 13, 1): 15,
        ("cint32", "int16", 16, 13, 1): 4,
        ("cint32", "int16", 1, 14, 1): 1,
        ("cint32", "int16", 2, 14, 1): 1,
        ("cint32", "int16", 3, 14, 1): 3,
        ("cint32", "int16", 4, 14, 1): 1,
        ("cint32", "int16", 5, 14, 1): 5,
        ("cint32", "int16", 6, 14, 1): 3,
        ("cint32", "int16", 7, 14, 1): 7,
        ("cint32", "int16", 8, 14, 1): 1,
        ("cint32", "int16", 9, 14, 1): 9,
        ("cint32", "int16", 10, 14, 1): 5,
        ("cint32", "int16", 11, 14, 1): 11,
        ("cint32", "int16", 12, 14, 1): 3,
        ("cint32", "int16", 13, 14, 1): 13,
        ("cint32", "int16", 14, 14, 1): 7,
        ("cint32", "int16", 15, 14, 1): 15,
        ("cint32", "int16", 16, 14, 1): 2,
        ("cint32", "int16", 1, 15, 1): 1,
        ("cint32", "int16", 2, 15, 1): 1,
        ("cint32", "int16", 3, 15, 1): 3,
        ("cint32", "int16", 4, 15, 1): 1,
        ("cint32", "int16", 5, 15, 1): 5,
        ("cint32", "int16", 6, 15, 1): 3,
        ("cint32", "int16", 7, 15, 1): 7,
        ("cint32", "int16", 8, 15, 1): 2,
        ("cint32", "int16", 9, 15, 1): 9,
        ("cint32", "int16", 10, 15, 1): 5,
        ("cint32", "int16", 11, 15, 1): 11,
        ("cint32", "int16", 12, 15, 1): 3,
        ("cint32", "int16", 13, 15, 1): 13,
        ("cint32", "int16", 14, 15, 1): 7,
        ("cint32", "int16", 15, 15, 1): 15,
        ("cint32", "int16", 16, 15, 1): 4,
        ("cint32", "int16", 1, 16, 1): 1,
        ("cint32", "int16", 2, 16, 1): 1,
        ("cint32", "int16", 3, 16, 1): 3,
        ("cint32", "int16", 4, 16, 1): 1,
        ("cint32", "int16", 5, 16, 1): 5,
        ("cint32", "int16", 6, 16, 1): 3,
        ("cint32", "int16", 7, 16, 1): 7,
        ("cint32", "int16", 8, 16, 1): 1,
        ("cint32", "int16", 9, 16, 1): 9,
        ("cint32", "int16", 10, 16, 1): 5,
        ("cint32", "int16", 11, 16, 1): 11,
        ("cint32", "int16", 12, 16, 1): 3,
        ("cint32", "int16", 13, 16, 1): 13,
        ("cint32", "int16", 14, 16, 1): 7,
        ("cint32", "int16", 15, 16, 1): 15,
        ("cint32", "int16", 16, 16, 1): 2,
        ("cint32", "cint16", 1, 1, 0): 1,
        ("cint32", "cint16", 2, 1, 0): 1,
        ("cint32", "cint16", 3, 1, 0): 3,
        ("cint32", "cint16", 4, 1, 0): 1,
        ("cint32", "cint16", 5, 1, 0): 5,
        ("cint32", "cint16", 6, 1, 0): 3,
        ("cint32", "cint16", 7, 1, 0): 7,
        ("cint32", "cint16", 8, 1, 0): 1,
        ("cint32", "cint16", 9, 1, 0): 9,
        ("cint32", "cint16", 10, 1, 0): 5,
        ("cint32", "cint16", 11, 1, 0): 11,
        ("cint32", "cint16", 12, 1, 0): 3,
        ("cint32", "cint16", 13, 1, 0): 13,
        ("cint32", "cint16", 14, 1, 0): 7,
        ("cint32", "cint16", 15, 1, 0): 15,
        ("cint32", "cint16", 16, 1, 0): 2,
        ("cint32", "cint16", 1, 2, 0): 1,
        ("cint32", "cint16", 2, 2, 0): 1,
        ("cint32", "cint16", 3, 2, 0): 3,
        ("cint32", "cint16", 4, 2, 0): 1,
        ("cint32", "cint16", 5, 2, 0): 5,
        ("cint32", "cint16", 6, 2, 0): 3,
        ("cint32", "cint16", 7, 2, 0): 7,
        ("cint32", "cint16", 8, 2, 0): 1,
        ("cint32", "cint16", 9, 2, 0): 9,
        ("cint32", "cint16", 10, 2, 0): 5,
        ("cint32", "cint16", 11, 2, 0): 11,
        ("cint32", "cint16", 12, 2, 0): 3,
        ("cint32", "cint16", 13, 2, 0): 13,
        ("cint32", "cint16", 14, 2, 0): 7,
        ("cint32", "cint16", 15, 2, 0): 15,
        ("cint32", "cint16", 16, 2, 0): 1,
        ("cint32", "cint16", 1, 3, 0): 1,
        ("cint32", "cint16", 2, 3, 0): 1,
        ("cint32", "cint16", 3, 3, 0): 3,
        ("cint32", "cint16", 4, 3, 0): 1,
        ("cint32", "cint16", 5, 3, 0): 5,
        ("cint32", "cint16", 6, 3, 0): 3,
        ("cint32", "cint16", 7, 3, 0): 7,
        ("cint32", "cint16", 8, 3, 0): 1,
        ("cint32", "cint16", 9, 3, 0): 9,
        ("cint32", "cint16", 10, 3, 0): 5,
        ("cint32", "cint16", 11, 3, 0): 11,
        ("cint32", "cint16", 12, 3, 0): 3,
        ("cint32", "cint16", 13, 3, 0): 13,
        ("cint32", "cint16", 14, 3, 0): 7,
        ("cint32", "cint16", 15, 3, 0): 15,
        ("cint32", "cint16", 16, 3, 0): 2,
        ("cint32", "cint16", 1, 4, 0): 1,
        ("cint32", "cint16", 2, 4, 0): 1,
        ("cint32", "cint16", 3, 4, 0): 3,
        ("cint32", "cint16", 4, 4, 0): 1,
        ("cint32", "cint16", 5, 4, 0): 5,
        ("cint32", "cint16", 6, 4, 0): 3,
        ("cint32", "cint16", 7, 4, 0): 7,
        ("cint32", "cint16", 8, 4, 0): 1,
        ("cint32", "cint16", 9, 4, 0): 9,
        ("cint32", "cint16", 10, 4, 0): 5,
        ("cint32", "cint16", 11, 4, 0): 11,
        ("cint32", "cint16", 12, 4, 0): 3,
        ("cint32", "cint16", 13, 4, 0): 13,
        ("cint32", "cint16", 14, 4, 0): 7,
        ("cint32", "cint16", 15, 4, 0): 15,
        ("cint32", "cint16", 16, 4, 0): 1,
        ("cint32", "cint16", 1, 5, 0): 1,
        ("cint32", "cint16", 2, 5, 0): 1,
        ("cint32", "cint16", 3, 5, 0): 3,
        ("cint32", "cint16", 4, 5, 0): 1,
        ("cint32", "cint16", 5, 5, 0): 5,
        ("cint32", "cint16", 6, 5, 0): 3,
        ("cint32", "cint16", 7, 5, 0): 7,
        ("cint32", "cint16", 8, 5, 0): 1,
        ("cint32", "cint16", 9, 5, 0): 9,
        ("cint32", "cint16", 10, 5, 0): 5,
        ("cint32", "cint16", 11, 5, 0): 11,
        ("cint32", "cint16", 12, 5, 0): 3,
        ("cint32", "cint16", 13, 5, 0): 13,
        ("cint32", "cint16", 14, 5, 0): 7,
        ("cint32", "cint16", 15, 5, 0): 15,
        ("cint32", "cint16", 16, 5, 0): 2,
        ("cint32", "cint16", 1, 6, 0): 1,
        ("cint32", "cint16", 2, 6, 0): 1,
        ("cint32", "cint16", 3, 6, 0): 3,
        ("cint32", "cint16", 4, 6, 0): 1,
        ("cint32", "cint16", 5, 6, 0): 5,
        ("cint32", "cint16", 6, 6, 0): 3,
        ("cint32", "cint16", 7, 6, 0): 7,
        ("cint32", "cint16", 8, 6, 0): 1,
        ("cint32", "cint16", 9, 6, 0): 9,
        ("cint32", "cint16", 10, 6, 0): 5,
        ("cint32", "cint16", 11, 6, 0): 11,
        ("cint32", "cint16", 12, 6, 0): 3,
        ("cint32", "cint16", 13, 6, 0): 13,
        ("cint32", "cint16", 14, 6, 0): 7,
        ("cint32", "cint16", 15, 6, 0): 15,
        ("cint32", "cint16", 16, 6, 0): 1,
        ("cint32", "cint16", 1, 7, 0): 1,
        ("cint32", "cint16", 2, 7, 0): 1,
        ("cint32", "cint16", 3, 7, 0): 3,
        ("cint32", "cint16", 4, 7, 0): 1,
        ("cint32", "cint16", 5, 7, 0): 5,
        ("cint32", "cint16", 6, 7, 0): 3,
        ("cint32", "cint16", 7, 7, 0): 7,
        ("cint32", "cint16", 8, 7, 0): 1,
        ("cint32", "cint16", 9, 7, 0): 9,
        ("cint32", "cint16", 10, 7, 0): 5,
        ("cint32", "cint16", 11, 7, 0): 11,
        ("cint32", "cint16", 12, 7, 0): 3,
        ("cint32", "cint16", 13, 7, 0): 13,
        ("cint32", "cint16", 14, 7, 0): 7,
        ("cint32", "cint16", 15, 7, 0): 15,
        ("cint32", "cint16", 16, 7, 0): 2,
        ("cint32", "cint16", 1, 8, 0): 1,
        ("cint32", "cint16", 2, 8, 0): 1,
        ("cint32", "cint16", 3, 8, 0): 3,
        ("cint32", "cint16", 4, 8, 0): 1,
        ("cint32", "cint16", 5, 8, 0): 5,
        ("cint32", "cint16", 6, 8, 0): 3,
        ("cint32", "cint16", 7, 8, 0): 7,
        ("cint32", "cint16", 8, 8, 0): 1,
        ("cint32", "cint16", 9, 8, 0): 9,
        ("cint32", "cint16", 10, 8, 0): 5,
        ("cint32", "cint16", 11, 8, 0): 11,
        ("cint32", "cint16", 12, 8, 0): 3,
        ("cint32", "cint16", 13, 8, 0): 13,
        ("cint32", "cint16", 14, 8, 0): 7,
        ("cint32", "cint16", 15, 8, 0): 15,
        ("cint32", "cint16", 16, 8, 0): 1,
        ("cint32", "cint16", 1, 9, 0): 1,
        ("cint32", "cint16", 2, 9, 0): 1,
        ("cint32", "cint16", 3, 9, 0): 3,
        ("cint32", "cint16", 4, 9, 0): 1,
        ("cint32", "cint16", 5, 9, 0): 5,
        ("cint32", "cint16", 6, 9, 0): 3,
        ("cint32", "cint16", 7, 9, 0): 7,
        ("cint32", "cint16", 8, 9, 0): 1,
        ("cint32", "cint16", 9, 9, 0): 9,
        ("cint32", "cint16", 10, 9, 0): 5,
        ("cint32", "cint16", 11, 9, 0): 11,
        ("cint32", "cint16", 12, 9, 0): 3,
        ("cint32", "cint16", 13, 9, 0): 13,
        ("cint32", "cint16", 14, 9, 0): 7,
        ("cint32", "cint16", 15, 9, 0): 15,
        ("cint32", "cint16", 16, 9, 0): 2,
        ("cint32", "cint16", 1, 10, 0): 1,
        ("cint32", "cint16", 2, 10, 0): 1,
        ("cint32", "cint16", 3, 10, 0): 3,
        ("cint32", "cint16", 4, 10, 0): 1,
        ("cint32", "cint16", 5, 10, 0): 5,
        ("cint32", "cint16", 6, 10, 0): 3,
        ("cint32", "cint16", 7, 10, 0): 7,
        ("cint32", "cint16", 8, 10, 0): 1,
        ("cint32", "cint16", 9, 10, 0): 9,
        ("cint32", "cint16", 10, 10, 0): 5,
        ("cint32", "cint16", 11, 10, 0): 11,
        ("cint32", "cint16", 12, 10, 0): 3,
        ("cint32", "cint16", 13, 10, 0): 13,
        ("cint32", "cint16", 14, 10, 0): 7,
        ("cint32", "cint16", 15, 10, 0): 15,
        ("cint32", "cint16", 16, 10, 0): 1,
        ("cint32", "cint16", 1, 11, 0): 1,
        ("cint32", "cint16", 2, 11, 0): 1,
        ("cint32", "cint16", 3, 11, 0): 3,
        ("cint32", "cint16", 4, 11, 0): 1,
        ("cint32", "cint16", 5, 11, 0): 5,
        ("cint32", "cint16", 6, 11, 0): 3,
        ("cint32", "cint16", 7, 11, 0): 7,
        ("cint32", "cint16", 8, 11, 0): 1,
        ("cint32", "cint16", 9, 11, 0): 9,
        ("cint32", "cint16", 10, 11, 0): 5,
        ("cint32", "cint16", 11, 11, 0): 11,
        ("cint32", "cint16", 12, 11, 0): 3,
        ("cint32", "cint16", 13, 11, 0): 13,
        ("cint32", "cint16", 14, 11, 0): 7,
        ("cint32", "cint16", 15, 11, 0): 15,
        ("cint32", "cint16", 16, 11, 0): 2,
        ("cint32", "cint16", 1, 12, 0): 1,
        ("cint32", "cint16", 2, 12, 0): 1,
        ("cint32", "cint16", 3, 12, 0): 3,
        ("cint32", "cint16", 4, 12, 0): 1,
        ("cint32", "cint16", 5, 12, 0): 5,
        ("cint32", "cint16", 6, 12, 0): 3,
        ("cint32", "cint16", 7, 12, 0): 7,
        ("cint32", "cint16", 8, 12, 0): 1,
        ("cint32", "cint16", 9, 12, 0): 9,
        ("cint32", "cint16", 10, 12, 0): 5,
        ("cint32", "cint16", 11, 12, 0): 11,
        ("cint32", "cint16", 12, 12, 0): 3,
        ("cint32", "cint16", 13, 12, 0): 13,
        ("cint32", "cint16", 14, 12, 0): 7,
        ("cint32", "cint16", 15, 12, 0): 15,
        ("cint32", "cint16", 16, 12, 0): 1,
        ("cint32", "cint16", 1, 13, 0): 1,
        ("cint32", "cint16", 2, 13, 0): 1,
        ("cint32", "cint16", 3, 13, 0): 3,
        ("cint32", "cint16", 4, 13, 0): 1,
        ("cint32", "cint16", 5, 13, 0): 5,
        ("cint32", "cint16", 6, 13, 0): 3,
        ("cint32", "cint16", 7, 13, 0): 7,
        ("cint32", "cint16", 8, 13, 0): 1,
        ("cint32", "cint16", 9, 13, 0): 9,
        ("cint32", "cint16", 10, 13, 0): 5,
        ("cint32", "cint16", 11, 13, 0): 11,
        ("cint32", "cint16", 12, 13, 0): 3,
        ("cint32", "cint16", 13, 13, 0): 13,
        ("cint32", "cint16", 14, 13, 0): 7,
        ("cint32", "cint16", 15, 13, 0): 15,
        ("cint32", "cint16", 16, 13, 0): 2,
        ("cint32", "cint16", 1, 14, 0): 1,
        ("cint32", "cint16", 2, 14, 0): 1,
        ("cint32", "cint16", 3, 14, 0): 3,
        ("cint32", "cint16", 4, 14, 0): 1,
        ("cint32", "cint16", 5, 14, 0): 5,
        ("cint32", "cint16", 6, 14, 0): 3,
        ("cint32", "cint16", 7, 14, 0): 7,
        ("cint32", "cint16", 8, 14, 0): 1,
        ("cint32", "cint16", 9, 14, 0): 9,
        ("cint32", "cint16", 10, 14, 0): 5,
        ("cint32", "cint16", 11, 14, 0): 11,
        ("cint32", "cint16", 12, 14, 0): 3,
        ("cint32", "cint16", 13, 14, 0): 13,
        ("cint32", "cint16", 14, 14, 0): 7,
        ("cint32", "cint16", 15, 14, 0): 15,
        ("cint32", "cint16", 16, 14, 0): 1,
        ("cint32", "cint16", 1, 15, 0): 1,
        ("cint32", "cint16", 2, 15, 0): 1,
        ("cint32", "cint16", 3, 15, 0): 3,
        ("cint32", "cint16", 4, 15, 0): 1,
        ("cint32", "cint16", 5, 15, 0): 5,
        ("cint32", "cint16", 6, 15, 0): 3,
        ("cint32", "cint16", 7, 15, 0): 7,
        ("cint32", "cint16", 8, 15, 0): 1,
        ("cint32", "cint16", 9, 15, 0): 9,
        ("cint32", "cint16", 10, 15, 0): 5,
        ("cint32", "cint16", 11, 15, 0): 11,
        ("cint32", "cint16", 12, 15, 0): 3,
        ("cint32", "cint16", 13, 15, 0): 13,
        ("cint32", "cint16", 14, 15, 0): 7,
        ("cint32", "cint16", 15, 15, 0): 15,
        ("cint32", "cint16", 16, 15, 0): 2,
        ("cint32", "cint16", 1, 16, 0): 1,
        ("cint32", "cint16", 2, 16, 0): 1,
        ("cint32", "cint16", 3, 16, 0): 3,
        ("cint32", "cint16", 4, 16, 0): 1,
        ("cint32", "cint16", 5, 16, 0): 5,
        ("cint32", "cint16", 6, 16, 0): 3,
        ("cint32", "cint16", 7, 16, 0): 7,
        ("cint32", "cint16", 8, 16, 0): 1,
        ("cint32", "cint16", 9, 16, 0): 9,
        ("cint32", "cint16", 10, 16, 0): 5,
        ("cint32", "cint16", 11, 16, 0): 11,
        ("cint32", "cint16", 12, 16, 0): 3,
        ("cint32", "cint16", 13, 16, 0): 13,
        ("cint32", "cint16", 14, 16, 0): 7,
        ("cint32", "cint16", 15, 16, 0): 15,
        ("cint32", "cint16", 16, 16, 0): 1,
        ("cint32", "cint16", 1, 1, 1): 1,
        ("cint32", "cint16", 2, 1, 1): 1,
        ("cint32", "cint16", 3, 1, 1): 3,
        ("cint32", "cint16", 4, 1, 1): 1,
        ("cint32", "cint16", 5, 1, 1): 5,
        ("cint32", "cint16", 6, 1, 1): 3,
        ("cint32", "cint16", 7, 1, 1): 7,
        ("cint32", "cint16", 8, 1, 1): 2,
        ("cint32", "cint16", 9, 1, 1): 9,
        ("cint32", "cint16", 10, 1, 1): 5,
        ("cint32", "cint16", 11, 1, 1): 11,
        ("cint32", "cint16", 12, 1, 1): 3,
        ("cint32", "cint16", 13, 1, 1): 13,
        ("cint32", "cint16", 14, 1, 1): 7,
        ("cint32", "cint16", 15, 1, 1): 15,
        ("cint32", "cint16", 16, 1, 1): 4,
        ("cint32", "cint16", 1, 2, 1): 1,
        ("cint32", "cint16", 2, 2, 1): 1,
        ("cint32", "cint16", 3, 2, 1): 3,
        ("cint32", "cint16", 4, 2, 1): 1,
        ("cint32", "cint16", 5, 2, 1): 5,
        ("cint32", "cint16", 6, 2, 1): 3,
        ("cint32", "cint16", 7, 2, 1): 7,
        ("cint32", "cint16", 8, 2, 1): 1,
        ("cint32", "cint16", 9, 2, 1): 9,
        ("cint32", "cint16", 10, 2, 1): 5,
        ("cint32", "cint16", 11, 2, 1): 11,
        ("cint32", "cint16", 12, 2, 1): 3,
        ("cint32", "cint16", 13, 2, 1): 13,
        ("cint32", "cint16", 14, 2, 1): 7,
        ("cint32", "cint16", 15, 2, 1): 15,
        ("cint32", "cint16", 16, 2, 1): 2,
        ("cint32", "cint16", 1, 3, 1): 1,
        ("cint32", "cint16", 2, 3, 1): 1,
        ("cint32", "cint16", 3, 3, 1): 3,
        ("cint32", "cint16", 4, 3, 1): 1,
        ("cint32", "cint16", 5, 3, 1): 5,
        ("cint32", "cint16", 6, 3, 1): 3,
        ("cint32", "cint16", 7, 3, 1): 7,
        ("cint32", "cint16", 8, 3, 1): 2,
        ("cint32", "cint16", 9, 3, 1): 9,
        ("cint32", "cint16", 10, 3, 1): 5,
        ("cint32", "cint16", 11, 3, 1): 11,
        ("cint32", "cint16", 12, 3, 1): 3,
        ("cint32", "cint16", 13, 3, 1): 13,
        ("cint32", "cint16", 14, 3, 1): 7,
        ("cint32", "cint16", 15, 3, 1): 15,
        ("cint32", "cint16", 16, 3, 1): 4,
        ("cint32", "cint16", 1, 4, 1): 1,
        ("cint32", "cint16", 2, 4, 1): 1,
        ("cint32", "cint16", 3, 4, 1): 3,
        ("cint32", "cint16", 4, 4, 1): 1,
        ("cint32", "cint16", 5, 4, 1): 5,
        ("cint32", "cint16", 6, 4, 1): 3,
        ("cint32", "cint16", 7, 4, 1): 7,
        ("cint32", "cint16", 8, 4, 1): 1,
        ("cint32", "cint16", 9, 4, 1): 9,
        ("cint32", "cint16", 10, 4, 1): 5,
        ("cint32", "cint16", 11, 4, 1): 11,
        ("cint32", "cint16", 12, 4, 1): 3,
        ("cint32", "cint16", 13, 4, 1): 13,
        ("cint32", "cint16", 14, 4, 1): 7,
        ("cint32", "cint16", 15, 4, 1): 15,
        ("cint32", "cint16", 16, 4, 1): 2,
        ("cint32", "cint16", 1, 5, 1): 1,
        ("cint32", "cint16", 2, 5, 1): 1,
        ("cint32", "cint16", 3, 5, 1): 3,
        ("cint32", "cint16", 4, 5, 1): 1,
        ("cint32", "cint16", 5, 5, 1): 5,
        ("cint32", "cint16", 6, 5, 1): 3,
        ("cint32", "cint16", 7, 5, 1): 7,
        ("cint32", "cint16", 8, 5, 1): 2,
        ("cint32", "cint16", 9, 5, 1): 9,
        ("cint32", "cint16", 10, 5, 1): 5,
        ("cint32", "cint16", 11, 5, 1): 11,
        ("cint32", "cint16", 12, 5, 1): 3,
        ("cint32", "cint16", 13, 5, 1): 13,
        ("cint32", "cint16", 14, 5, 1): 7,
        ("cint32", "cint16", 15, 5, 1): 15,
        ("cint32", "cint16", 16, 5, 1): 4,
        ("cint32", "cint16", 1, 6, 1): 1,
        ("cint32", "cint16", 2, 6, 1): 1,
        ("cint32", "cint16", 3, 6, 1): 3,
        ("cint32", "cint16", 4, 6, 1): 1,
        ("cint32", "cint16", 5, 6, 1): 5,
        ("cint32", "cint16", 6, 6, 1): 3,
        ("cint32", "cint16", 7, 6, 1): 7,
        ("cint32", "cint16", 8, 6, 1): 1,
        ("cint32", "cint16", 9, 6, 1): 9,
        ("cint32", "cint16", 10, 6, 1): 5,
        ("cint32", "cint16", 11, 6, 1): 11,
        ("cint32", "cint16", 12, 6, 1): 3,
        ("cint32", "cint16", 13, 6, 1): 13,
        ("cint32", "cint16", 14, 6, 1): 7,
        ("cint32", "cint16", 15, 6, 1): 15,
        ("cint32", "cint16", 16, 6, 1): 2,
        ("cint32", "cint16", 1, 7, 1): 1,
        ("cint32", "cint16", 2, 7, 1): 1,
        ("cint32", "cint16", 3, 7, 1): 3,
        ("cint32", "cint16", 4, 7, 1): 1,
        ("cint32", "cint16", 5, 7, 1): 5,
        ("cint32", "cint16", 6, 7, 1): 3,
        ("cint32", "cint16", 7, 7, 1): 7,
        ("cint32", "cint16", 8, 7, 1): 2,
        ("cint32", "cint16", 9, 7, 1): 9,
        ("cint32", "cint16", 10, 7, 1): 5,
        ("cint32", "cint16", 11, 7, 1): 11,
        ("cint32", "cint16", 12, 7, 1): 3,
        ("cint32", "cint16", 13, 7, 1): 13,
        ("cint32", "cint16", 14, 7, 1): 7,
        ("cint32", "cint16", 15, 7, 1): 15,
        ("cint32", "cint16", 16, 7, 1): 4,
        ("cint32", "cint16", 1, 8, 1): 1,
        ("cint32", "cint16", 2, 8, 1): 1,
        ("cint32", "cint16", 3, 8, 1): 3,
        ("cint32", "cint16", 4, 8, 1): 1,
        ("cint32", "cint16", 5, 8, 1): 5,
        ("cint32", "cint16", 6, 8, 1): 3,
        ("cint32", "cint16", 7, 8, 1): 7,
        ("cint32", "cint16", 8, 8, 1): 1,
        ("cint32", "cint16", 9, 8, 1): 9,
        ("cint32", "cint16", 10, 8, 1): 5,
        ("cint32", "cint16", 11, 8, 1): 11,
        ("cint32", "cint16", 12, 8, 1): 3,
        ("cint32", "cint16", 13, 8, 1): 13,
        ("cint32", "cint16", 14, 8, 1): 7,
        ("cint32", "cint16", 15, 8, 1): 15,
        ("cint32", "cint16", 16, 8, 1): 2,
        ("cint32", "cint16", 1, 9, 1): 1,
        ("cint32", "cint16", 2, 9, 1): 1,
        ("cint32", "cint16", 3, 9, 1): 3,
        ("cint32", "cint16", 4, 9, 1): 1,
        ("cint32", "cint16", 5, 9, 1): 5,
        ("cint32", "cint16", 6, 9, 1): 3,
        ("cint32", "cint16", 7, 9, 1): 7,
        ("cint32", "cint16", 8, 9, 1): 2,
        ("cint32", "cint16", 9, 9, 1): 9,
        ("cint32", "cint16", 10, 9, 1): 5,
        ("cint32", "cint16", 11, 9, 1): 11,
        ("cint32", "cint16", 12, 9, 1): 3,
        ("cint32", "cint16", 13, 9, 1): 13,
        ("cint32", "cint16", 14, 9, 1): 7,
        ("cint32", "cint16", 15, 9, 1): 15,
        ("cint32", "cint16", 16, 9, 1): 4,
        ("cint32", "cint16", 1, 10, 1): 1,
        ("cint32", "cint16", 2, 10, 1): 1,
        ("cint32", "cint16", 3, 10, 1): 3,
        ("cint32", "cint16", 4, 10, 1): 1,
        ("cint32", "cint16", 5, 10, 1): 5,
        ("cint32", "cint16", 6, 10, 1): 3,
        ("cint32", "cint16", 7, 10, 1): 7,
        ("cint32", "cint16", 8, 10, 1): 1,
        ("cint32", "cint16", 9, 10, 1): 9,
        ("cint32", "cint16", 10, 10, 1): 5,
        ("cint32", "cint16", 11, 10, 1): 11,
        ("cint32", "cint16", 12, 10, 1): 3,
        ("cint32", "cint16", 13, 10, 1): 13,
        ("cint32", "cint16", 14, 10, 1): 7,
        ("cint32", "cint16", 15, 10, 1): 15,
        ("cint32", "cint16", 16, 10, 1): 2,
        ("cint32", "cint16", 1, 11, 1): 1,
        ("cint32", "cint16", 2, 11, 1): 1,
        ("cint32", "cint16", 3, 11, 1): 3,
        ("cint32", "cint16", 4, 11, 1): 1,
        ("cint32", "cint16", 5, 11, 1): 5,
        ("cint32", "cint16", 6, 11, 1): 3,
        ("cint32", "cint16", 7, 11, 1): 7,
        ("cint32", "cint16", 8, 11, 1): 2,
        ("cint32", "cint16", 9, 11, 1): 9,
        ("cint32", "cint16", 10, 11, 1): 5,
        ("cint32", "cint16", 11, 11, 1): 11,
        ("cint32", "cint16", 12, 11, 1): 3,
        ("cint32", "cint16", 13, 11, 1): 13,
        ("cint32", "cint16", 14, 11, 1): 7,
        ("cint32", "cint16", 15, 11, 1): 15,
        ("cint32", "cint16", 16, 11, 1): 4,
        ("cint32", "cint16", 1, 12, 1): 1,
        ("cint32", "cint16", 2, 12, 1): 1,
        ("cint32", "cint16", 3, 12, 1): 3,
        ("cint32", "cint16", 4, 12, 1): 1,
        ("cint32", "cint16", 5, 12, 1): 5,
        ("cint32", "cint16", 6, 12, 1): 3,
        ("cint32", "cint16", 7, 12, 1): 7,
        ("cint32", "cint16", 8, 12, 1): 1,
        ("cint32", "cint16", 9, 12, 1): 9,
        ("cint32", "cint16", 10, 12, 1): 5,
        ("cint32", "cint16", 11, 12, 1): 11,
        ("cint32", "cint16", 12, 12, 1): 3,
        ("cint32", "cint16", 13, 12, 1): 13,
        ("cint32", "cint16", 14, 12, 1): 7,
        ("cint32", "cint16", 15, 12, 1): 15,
        ("cint32", "cint16", 16, 12, 1): 2,
        ("cint32", "cint16", 1, 13, 1): 1,
        ("cint32", "cint16", 2, 13, 1): 1,
        ("cint32", "cint16", 3, 13, 1): 3,
        ("cint32", "cint16", 4, 13, 1): 1,
        ("cint32", "cint16", 5, 13, 1): 5,
        ("cint32", "cint16", 6, 13, 1): 3,
        ("cint32", "cint16", 7, 13, 1): 7,
        ("cint32", "cint16", 8, 13, 1): 2,
        ("cint32", "cint16", 9, 13, 1): 9,
        ("cint32", "cint16", 10, 13, 1): 5,
        ("cint32", "cint16", 11, 13, 1): 11,
        ("cint32", "cint16", 12, 13, 1): 3,
        ("cint32", "cint16", 13, 13, 1): 13,
        ("cint32", "cint16", 14, 13, 1): 7,
        ("cint32", "cint16", 15, 13, 1): 15,
        ("cint32", "cint16", 16, 13, 1): 4,
        ("cint32", "cint16", 1, 14, 1): 1,
        ("cint32", "cint16", 2, 14, 1): 1,
        ("cint32", "cint16", 3, 14, 1): 3,
        ("cint32", "cint16", 4, 14, 1): 1,
        ("cint32", "cint16", 5, 14, 1): 5,
        ("cint32", "cint16", 6, 14, 1): 3,
        ("cint32", "cint16", 7, 14, 1): 7,
        ("cint32", "cint16", 8, 14, 1): 1,
        ("cint32", "cint16", 9, 14, 1): 9,
        ("cint32", "cint16", 10, 14, 1): 5,
        ("cint32", "cint16", 11, 14, 1): 11,
        ("cint32", "cint16", 12, 14, 1): 3,
        ("cint32", "cint16", 13, 14, 1): 13,
        ("cint32", "cint16", 14, 14, 1): 7,
        ("cint32", "cint16", 15, 14, 1): 15,
        ("cint32", "cint16", 16, 14, 1): 2,
        ("cint32", "cint16", 1, 15, 1): 1,
        ("cint32", "cint16", 2, 15, 1): 1,
        ("cint32", "cint16", 3, 15, 1): 3,
        ("cint32", "cint16", 4, 15, 1): 1,
        ("cint32", "cint16", 5, 15, 1): 5,
        ("cint32", "cint16", 6, 15, 1): 3,
        ("cint32", "cint16", 7, 15, 1): 7,
        ("cint32", "cint16", 8, 15, 1): 2,
        ("cint32", "cint16", 9, 15, 1): 9,
        ("cint32", "cint16", 10, 15, 1): 5,
        ("cint32", "cint16", 11, 15, 1): 11,
        ("cint32", "cint16", 12, 15, 1): 3,
        ("cint32", "cint16", 13, 15, 1): 13,
        ("cint32", "cint16", 14, 15, 1): 7,
        ("cint32", "cint16", 15, 15, 1): 15,
        ("cint32", "cint16", 16, 15, 1): 4,
        ("cint32", "cint16", 1, 16, 1): 1,
        ("cint32", "cint16", 2, 16, 1): 1,
        ("cint32", "cint16", 3, 16, 1): 3,
        ("cint32", "cint16", 4, 16, 1): 1,
        ("cint32", "cint16", 5, 16, 1): 5,
        ("cint32", "cint16", 6, 16, 1): 3,
        ("cint32", "cint16", 7, 16, 1): 7,
        ("cint32", "cint16", 8, 16, 1): 1,
        ("cint32", "cint16", 9, 16, 1): 9,
        ("cint32", "cint16", 10, 16, 1): 5,
        ("cint32", "cint16", 11, 16, 1): 11,
        ("cint32", "cint16", 12, 16, 1): 3,
        ("cint32", "cint16", 13, 16, 1): 13,
        ("cint32", "cint16", 14, 16, 1): 7,
        ("cint32", "cint16", 15, 16, 1): 15,
        ("cint32", "cint16", 16, 16, 1): 2,
        ("cint32", "int32", 1, 1, 0): 1,
        ("cint32", "int32", 2, 1, 0): 1,
        ("cint32", "int32", 3, 1, 0): 3,
        ("cint32", "int32", 4, 1, 0): 1,
        ("cint32", "int32", 5, 1, 0): 5,
        ("cint32", "int32", 6, 1, 0): 3,
        ("cint32", "int32", 7, 1, 0): 7,
        ("cint32", "int32", 8, 1, 0): 1,
        ("cint32", "int32", 9, 1, 0): 9,
        ("cint32", "int32", 10, 1, 0): 5,
        ("cint32", "int32", 11, 1, 0): 11,
        ("cint32", "int32", 12, 1, 0): 3,
        ("cint32", "int32", 13, 1, 0): 13,
        ("cint32", "int32", 14, 1, 0): 7,
        ("cint32", "int32", 15, 1, 0): 15,
        ("cint32", "int32", 16, 1, 0): 2,
        ("cint32", "int32", 1, 2, 0): 1,
        ("cint32", "int32", 2, 2, 0): 1,
        ("cint32", "int32", 3, 2, 0): 3,
        ("cint32", "int32", 4, 2, 0): 1,
        ("cint32", "int32", 5, 2, 0): 5,
        ("cint32", "int32", 6, 2, 0): 3,
        ("cint32", "int32", 7, 2, 0): 7,
        ("cint32", "int32", 8, 2, 0): 1,
        ("cint32", "int32", 9, 2, 0): 9,
        ("cint32", "int32", 10, 2, 0): 5,
        ("cint32", "int32", 11, 2, 0): 11,
        ("cint32", "int32", 12, 2, 0): 3,
        ("cint32", "int32", 13, 2, 0): 13,
        ("cint32", "int32", 14, 2, 0): 7,
        ("cint32", "int32", 15, 2, 0): 15,
        ("cint32", "int32", 16, 2, 0): 1,
        ("cint32", "int32", 1, 3, 0): 1,
        ("cint32", "int32", 2, 3, 0): 1,
        ("cint32", "int32", 3, 3, 0): 3,
        ("cint32", "int32", 4, 3, 0): 1,
        ("cint32", "int32", 5, 3, 0): 5,
        ("cint32", "int32", 6, 3, 0): 3,
        ("cint32", "int32", 7, 3, 0): 7,
        ("cint32", "int32", 8, 3, 0): 1,
        ("cint32", "int32", 9, 3, 0): 9,
        ("cint32", "int32", 10, 3, 0): 5,
        ("cint32", "int32", 11, 3, 0): 11,
        ("cint32", "int32", 12, 3, 0): 3,
        ("cint32", "int32", 13, 3, 0): 13,
        ("cint32", "int32", 14, 3, 0): 7,
        ("cint32", "int32", 15, 3, 0): 15,
        ("cint32", "int32", 16, 3, 0): 2,
        ("cint32", "int32", 1, 4, 0): 1,
        ("cint32", "int32", 2, 4, 0): 1,
        ("cint32", "int32", 3, 4, 0): 3,
        ("cint32", "int32", 4, 4, 0): 1,
        ("cint32", "int32", 5, 4, 0): 5,
        ("cint32", "int32", 6, 4, 0): 3,
        ("cint32", "int32", 7, 4, 0): 7,
        ("cint32", "int32", 8, 4, 0): 1,
        ("cint32", "int32", 9, 4, 0): 9,
        ("cint32", "int32", 10, 4, 0): 5,
        ("cint32", "int32", 11, 4, 0): 11,
        ("cint32", "int32", 12, 4, 0): 3,
        ("cint32", "int32", 13, 4, 0): 13,
        ("cint32", "int32", 14, 4, 0): 7,
        ("cint32", "int32", 15, 4, 0): 15,
        ("cint32", "int32", 16, 4, 0): 1,
        ("cint32", "int32", 1, 5, 0): 1,
        ("cint32", "int32", 2, 5, 0): 1,
        ("cint32", "int32", 3, 5, 0): 3,
        ("cint32", "int32", 4, 5, 0): 1,
        ("cint32", "int32", 5, 5, 0): 5,
        ("cint32", "int32", 6, 5, 0): 3,
        ("cint32", "int32", 7, 5, 0): 7,
        ("cint32", "int32", 8, 5, 0): 1,
        ("cint32", "int32", 9, 5, 0): 9,
        ("cint32", "int32", 10, 5, 0): 5,
        ("cint32", "int32", 11, 5, 0): 11,
        ("cint32", "int32", 12, 5, 0): 3,
        ("cint32", "int32", 13, 5, 0): 13,
        ("cint32", "int32", 14, 5, 0): 7,
        ("cint32", "int32", 15, 5, 0): 15,
        ("cint32", "int32", 16, 5, 0): 2,
        ("cint32", "int32", 1, 6, 0): 1,
        ("cint32", "int32", 2, 6, 0): 1,
        ("cint32", "int32", 3, 6, 0): 3,
        ("cint32", "int32", 4, 6, 0): 1,
        ("cint32", "int32", 5, 6, 0): 5,
        ("cint32", "int32", 6, 6, 0): 3,
        ("cint32", "int32", 7, 6, 0): 7,
        ("cint32", "int32", 8, 6, 0): 1,
        ("cint32", "int32", 9, 6, 0): 9,
        ("cint32", "int32", 10, 6, 0): 5,
        ("cint32", "int32", 11, 6, 0): 11,
        ("cint32", "int32", 12, 6, 0): 3,
        ("cint32", "int32", 13, 6, 0): 13,
        ("cint32", "int32", 14, 6, 0): 7,
        ("cint32", "int32", 15, 6, 0): 15,
        ("cint32", "int32", 16, 6, 0): 1,
        ("cint32", "int32", 1, 7, 0): 1,
        ("cint32", "int32", 2, 7, 0): 1,
        ("cint32", "int32", 3, 7, 0): 3,
        ("cint32", "int32", 4, 7, 0): 1,
        ("cint32", "int32", 5, 7, 0): 5,
        ("cint32", "int32", 6, 7, 0): 3,
        ("cint32", "int32", 7, 7, 0): 7,
        ("cint32", "int32", 8, 7, 0): 1,
        ("cint32", "int32", 9, 7, 0): 9,
        ("cint32", "int32", 10, 7, 0): 5,
        ("cint32", "int32", 11, 7, 0): 11,
        ("cint32", "int32", 12, 7, 0): 3,
        ("cint32", "int32", 13, 7, 0): 13,
        ("cint32", "int32", 14, 7, 0): 7,
        ("cint32", "int32", 15, 7, 0): 15,
        ("cint32", "int32", 16, 7, 0): 2,
        ("cint32", "int32", 1, 8, 0): 1,
        ("cint32", "int32", 2, 8, 0): 1,
        ("cint32", "int32", 3, 8, 0): 3,
        ("cint32", "int32", 4, 8, 0): 1,
        ("cint32", "int32", 5, 8, 0): 5,
        ("cint32", "int32", 6, 8, 0): 3,
        ("cint32", "int32", 7, 8, 0): 7,
        ("cint32", "int32", 8, 8, 0): 1,
        ("cint32", "int32", 9, 8, 0): 9,
        ("cint32", "int32", 10, 8, 0): 5,
        ("cint32", "int32", 11, 8, 0): 11,
        ("cint32", "int32", 12, 8, 0): 3,
        ("cint32", "int32", 13, 8, 0): 13,
        ("cint32", "int32", 14, 8, 0): 7,
        ("cint32", "int32", 15, 8, 0): 15,
        ("cint32", "int32", 16, 8, 0): 1,
        ("cint32", "int32", 1, 9, 0): 1,
        ("cint32", "int32", 2, 9, 0): 1,
        ("cint32", "int32", 3, 9, 0): 3,
        ("cint32", "int32", 4, 9, 0): 1,
        ("cint32", "int32", 5, 9, 0): 5,
        ("cint32", "int32", 6, 9, 0): 3,
        ("cint32", "int32", 7, 9, 0): 7,
        ("cint32", "int32", 8, 9, 0): 1,
        ("cint32", "int32", 9, 9, 0): 9,
        ("cint32", "int32", 10, 9, 0): 5,
        ("cint32", "int32", 11, 9, 0): 11,
        ("cint32", "int32", 12, 9, 0): 3,
        ("cint32", "int32", 13, 9, 0): 13,
        ("cint32", "int32", 14, 9, 0): 7,
        ("cint32", "int32", 15, 9, 0): 15,
        ("cint32", "int32", 16, 9, 0): 2,
        ("cint32", "int32", 1, 10, 0): 1,
        ("cint32", "int32", 2, 10, 0): 1,
        ("cint32", "int32", 3, 10, 0): 3,
        ("cint32", "int32", 4, 10, 0): 1,
        ("cint32", "int32", 5, 10, 0): 5,
        ("cint32", "int32", 6, 10, 0): 3,
        ("cint32", "int32", 7, 10, 0): 7,
        ("cint32", "int32", 8, 10, 0): 1,
        ("cint32", "int32", 9, 10, 0): 9,
        ("cint32", "int32", 10, 10, 0): 5,
        ("cint32", "int32", 11, 10, 0): 11,
        ("cint32", "int32", 12, 10, 0): 3,
        ("cint32", "int32", 13, 10, 0): 13,
        ("cint32", "int32", 14, 10, 0): 7,
        ("cint32", "int32", 15, 10, 0): 15,
        ("cint32", "int32", 16, 10, 0): 1,
        ("cint32", "int32", 1, 11, 0): 1,
        ("cint32", "int32", 2, 11, 0): 1,
        ("cint32", "int32", 3, 11, 0): 3,
        ("cint32", "int32", 4, 11, 0): 1,
        ("cint32", "int32", 5, 11, 0): 5,
        ("cint32", "int32", 6, 11, 0): 3,
        ("cint32", "int32", 7, 11, 0): 7,
        ("cint32", "int32", 8, 11, 0): 1,
        ("cint32", "int32", 9, 11, 0): 9,
        ("cint32", "int32", 10, 11, 0): 5,
        ("cint32", "int32", 11, 11, 0): 11,
        ("cint32", "int32", 12, 11, 0): 3,
        ("cint32", "int32", 13, 11, 0): 13,
        ("cint32", "int32", 14, 11, 0): 7,
        ("cint32", "int32", 15, 11, 0): 15,
        ("cint32", "int32", 16, 11, 0): 2,
        ("cint32", "int32", 1, 12, 0): 1,
        ("cint32", "int32", 2, 12, 0): 1,
        ("cint32", "int32", 3, 12, 0): 3,
        ("cint32", "int32", 4, 12, 0): 1,
        ("cint32", "int32", 5, 12, 0): 5,
        ("cint32", "int32", 6, 12, 0): 3,
        ("cint32", "int32", 7, 12, 0): 7,
        ("cint32", "int32", 8, 12, 0): 1,
        ("cint32", "int32", 9, 12, 0): 9,
        ("cint32", "int32", 10, 12, 0): 5,
        ("cint32", "int32", 11, 12, 0): 11,
        ("cint32", "int32", 12, 12, 0): 3,
        ("cint32", "int32", 13, 12, 0): 13,
        ("cint32", "int32", 14, 12, 0): 7,
        ("cint32", "int32", 15, 12, 0): 15,
        ("cint32", "int32", 16, 12, 0): 1,
        ("cint32", "int32", 1, 13, 0): 1,
        ("cint32", "int32", 2, 13, 0): 1,
        ("cint32", "int32", 3, 13, 0): 3,
        ("cint32", "int32", 4, 13, 0): 1,
        ("cint32", "int32", 5, 13, 0): 5,
        ("cint32", "int32", 6, 13, 0): 3,
        ("cint32", "int32", 7, 13, 0): 7,
        ("cint32", "int32", 8, 13, 0): 1,
        ("cint32", "int32", 9, 13, 0): 9,
        ("cint32", "int32", 10, 13, 0): 5,
        ("cint32", "int32", 11, 13, 0): 11,
        ("cint32", "int32", 12, 13, 0): 3,
        ("cint32", "int32", 13, 13, 0): 13,
        ("cint32", "int32", 14, 13, 0): 7,
        ("cint32", "int32", 15, 13, 0): 15,
        ("cint32", "int32", 16, 13, 0): 2,
        ("cint32", "int32", 1, 14, 0): 1,
        ("cint32", "int32", 2, 14, 0): 1,
        ("cint32", "int32", 3, 14, 0): 3,
        ("cint32", "int32", 4, 14, 0): 1,
        ("cint32", "int32", 5, 14, 0): 5,
        ("cint32", "int32", 6, 14, 0): 3,
        ("cint32", "int32", 7, 14, 0): 7,
        ("cint32", "int32", 8, 14, 0): 1,
        ("cint32", "int32", 9, 14, 0): 9,
        ("cint32", "int32", 10, 14, 0): 5,
        ("cint32", "int32", 11, 14, 0): 11,
        ("cint32", "int32", 12, 14, 0): 3,
        ("cint32", "int32", 13, 14, 0): 13,
        ("cint32", "int32", 14, 14, 0): 7,
        ("cint32", "int32", 15, 14, 0): 15,
        ("cint32", "int32", 16, 14, 0): 1,
        ("cint32", "int32", 1, 15, 0): 1,
        ("cint32", "int32", 2, 15, 0): 1,
        ("cint32", "int32", 3, 15, 0): 3,
        ("cint32", "int32", 4, 15, 0): 1,
        ("cint32", "int32", 5, 15, 0): 5,
        ("cint32", "int32", 6, 15, 0): 3,
        ("cint32", "int32", 7, 15, 0): 7,
        ("cint32", "int32", 8, 15, 0): 1,
        ("cint32", "int32", 9, 15, 0): 9,
        ("cint32", "int32", 10, 15, 0): 5,
        ("cint32", "int32", 11, 15, 0): 11,
        ("cint32", "int32", 12, 15, 0): 3,
        ("cint32", "int32", 13, 15, 0): 13,
        ("cint32", "int32", 14, 15, 0): 7,
        ("cint32", "int32", 15, 15, 0): 15,
        ("cint32", "int32", 16, 15, 0): 2,
        ("cint32", "int32", 1, 16, 0): 1,
        ("cint32", "int32", 2, 16, 0): 1,
        ("cint32", "int32", 3, 16, 0): 3,
        ("cint32", "int32", 4, 16, 0): 1,
        ("cint32", "int32", 5, 16, 0): 5,
        ("cint32", "int32", 6, 16, 0): 3,
        ("cint32", "int32", 7, 16, 0): 7,
        ("cint32", "int32", 8, 16, 0): 1,
        ("cint32", "int32", 9, 16, 0): 9,
        ("cint32", "int32", 10, 16, 0): 5,
        ("cint32", "int32", 11, 16, 0): 11,
        ("cint32", "int32", 12, 16, 0): 3,
        ("cint32", "int32", 13, 16, 0): 13,
        ("cint32", "int32", 14, 16, 0): 7,
        ("cint32", "int32", 15, 16, 0): 15,
        ("cint32", "int32", 16, 16, 0): 1,
        ("cint32", "int32", 1, 1, 1): 1,
        ("cint32", "int32", 2, 1, 1): 1,
        ("cint32", "int32", 3, 1, 1): 3,
        ("cint32", "int32", 4, 1, 1): 1,
        ("cint32", "int32", 5, 1, 1): 5,
        ("cint32", "int32", 6, 1, 1): 3,
        ("cint32", "int32", 7, 1, 1): 7,
        ("cint32", "int32", 8, 1, 1): 2,
        ("cint32", "int32", 9, 1, 1): 9,
        ("cint32", "int32", 10, 1, 1): 5,
        ("cint32", "int32", 11, 1, 1): 11,
        ("cint32", "int32", 12, 1, 1): 3,
        ("cint32", "int32", 13, 1, 1): 13,
        ("cint32", "int32", 14, 1, 1): 7,
        ("cint32", "int32", 15, 1, 1): 15,
        ("cint32", "int32", 16, 1, 1): 4,
        ("cint32", "int32", 1, 2, 1): 1,
        ("cint32", "int32", 2, 2, 1): 1,
        ("cint32", "int32", 3, 2, 1): 3,
        ("cint32", "int32", 4, 2, 1): 1,
        ("cint32", "int32", 5, 2, 1): 5,
        ("cint32", "int32", 6, 2, 1): 3,
        ("cint32", "int32", 7, 2, 1): 7,
        ("cint32", "int32", 8, 2, 1): 1,
        ("cint32", "int32", 9, 2, 1): 9,
        ("cint32", "int32", 10, 2, 1): 5,
        ("cint32", "int32", 11, 2, 1): 11,
        ("cint32", "int32", 12, 2, 1): 3,
        ("cint32", "int32", 13, 2, 1): 13,
        ("cint32", "int32", 14, 2, 1): 7,
        ("cint32", "int32", 15, 2, 1): 15,
        ("cint32", "int32", 16, 2, 1): 2,
        ("cint32", "int32", 1, 3, 1): 1,
        ("cint32", "int32", 2, 3, 1): 1,
        ("cint32", "int32", 3, 3, 1): 3,
        ("cint32", "int32", 4, 3, 1): 1,
        ("cint32", "int32", 5, 3, 1): 5,
        ("cint32", "int32", 6, 3, 1): 3,
        ("cint32", "int32", 7, 3, 1): 7,
        ("cint32", "int32", 8, 3, 1): 2,
        ("cint32", "int32", 9, 3, 1): 9,
        ("cint32", "int32", 10, 3, 1): 5,
        ("cint32", "int32", 11, 3, 1): 11,
        ("cint32", "int32", 12, 3, 1): 3,
        ("cint32", "int32", 13, 3, 1): 13,
        ("cint32", "int32", 14, 3, 1): 7,
        ("cint32", "int32", 15, 3, 1): 15,
        ("cint32", "int32", 16, 3, 1): 4,
        ("cint32", "int32", 1, 4, 1): 1,
        ("cint32", "int32", 2, 4, 1): 1,
        ("cint32", "int32", 3, 4, 1): 3,
        ("cint32", "int32", 4, 4, 1): 1,
        ("cint32", "int32", 5, 4, 1): 5,
        ("cint32", "int32", 6, 4, 1): 3,
        ("cint32", "int32", 7, 4, 1): 7,
        ("cint32", "int32", 8, 4, 1): 1,
        ("cint32", "int32", 9, 4, 1): 9,
        ("cint32", "int32", 10, 4, 1): 5,
        ("cint32", "int32", 11, 4, 1): 11,
        ("cint32", "int32", 12, 4, 1): 3,
        ("cint32", "int32", 13, 4, 1): 13,
        ("cint32", "int32", 14, 4, 1): 7,
        ("cint32", "int32", 15, 4, 1): 15,
        ("cint32", "int32", 16, 4, 1): 2,
        ("cint32", "int32", 1, 5, 1): 1,
        ("cint32", "int32", 2, 5, 1): 1,
        ("cint32", "int32", 3, 5, 1): 3,
        ("cint32", "int32", 4, 5, 1): 1,
        ("cint32", "int32", 5, 5, 1): 5,
        ("cint32", "int32", 6, 5, 1): 3,
        ("cint32", "int32", 7, 5, 1): 7,
        ("cint32", "int32", 8, 5, 1): 2,
        ("cint32", "int32", 9, 5, 1): 9,
        ("cint32", "int32", 10, 5, 1): 5,
        ("cint32", "int32", 11, 5, 1): 11,
        ("cint32", "int32", 12, 5, 1): 3,
        ("cint32", "int32", 13, 5, 1): 13,
        ("cint32", "int32", 14, 5, 1): 7,
        ("cint32", "int32", 15, 5, 1): 15,
        ("cint32", "int32", 16, 5, 1): 4,
        ("cint32", "int32", 1, 6, 1): 1,
        ("cint32", "int32", 2, 6, 1): 1,
        ("cint32", "int32", 3, 6, 1): 3,
        ("cint32", "int32", 4, 6, 1): 1,
        ("cint32", "int32", 5, 6, 1): 5,
        ("cint32", "int32", 6, 6, 1): 3,
        ("cint32", "int32", 7, 6, 1): 7,
        ("cint32", "int32", 8, 6, 1): 1,
        ("cint32", "int32", 9, 6, 1): 9,
        ("cint32", "int32", 10, 6, 1): 5,
        ("cint32", "int32", 11, 6, 1): 11,
        ("cint32", "int32", 12, 6, 1): 3,
        ("cint32", "int32", 13, 6, 1): 13,
        ("cint32", "int32", 14, 6, 1): 7,
        ("cint32", "int32", 15, 6, 1): 15,
        ("cint32", "int32", 16, 6, 1): 2,
        ("cint32", "int32", 1, 7, 1): 1,
        ("cint32", "int32", 2, 7, 1): 1,
        ("cint32", "int32", 3, 7, 1): 3,
        ("cint32", "int32", 4, 7, 1): 1,
        ("cint32", "int32", 5, 7, 1): 5,
        ("cint32", "int32", 6, 7, 1): 3,
        ("cint32", "int32", 7, 7, 1): 7,
        ("cint32", "int32", 8, 7, 1): 2,
        ("cint32", "int32", 9, 7, 1): 9,
        ("cint32", "int32", 10, 7, 1): 5,
        ("cint32", "int32", 11, 7, 1): 11,
        ("cint32", "int32", 12, 7, 1): 3,
        ("cint32", "int32", 13, 7, 1): 13,
        ("cint32", "int32", 14, 7, 1): 7,
        ("cint32", "int32", 15, 7, 1): 15,
        ("cint32", "int32", 16, 7, 1): 4,
        ("cint32", "int32", 1, 8, 1): 1,
        ("cint32", "int32", 2, 8, 1): 1,
        ("cint32", "int32", 3, 8, 1): 3,
        ("cint32", "int32", 4, 8, 1): 1,
        ("cint32", "int32", 5, 8, 1): 5,
        ("cint32", "int32", 6, 8, 1): 3,
        ("cint32", "int32", 7, 8, 1): 7,
        ("cint32", "int32", 8, 8, 1): 1,
        ("cint32", "int32", 9, 8, 1): 9,
        ("cint32", "int32", 10, 8, 1): 5,
        ("cint32", "int32", 11, 8, 1): 11,
        ("cint32", "int32", 12, 8, 1): 3,
        ("cint32", "int32", 13, 8, 1): 13,
        ("cint32", "int32", 14, 8, 1): 7,
        ("cint32", "int32", 15, 8, 1): 15,
        ("cint32", "int32", 16, 8, 1): 2,
        ("cint32", "int32", 1, 9, 1): 1,
        ("cint32", "int32", 2, 9, 1): 1,
        ("cint32", "int32", 3, 9, 1): 3,
        ("cint32", "int32", 4, 9, 1): 1,
        ("cint32", "int32", 5, 9, 1): 5,
        ("cint32", "int32", 6, 9, 1): 3,
        ("cint32", "int32", 7, 9, 1): 7,
        ("cint32", "int32", 8, 9, 1): 2,
        ("cint32", "int32", 9, 9, 1): 9,
        ("cint32", "int32", 10, 9, 1): 5,
        ("cint32", "int32", 11, 9, 1): 11,
        ("cint32", "int32", 12, 9, 1): 3,
        ("cint32", "int32", 13, 9, 1): 13,
        ("cint32", "int32", 14, 9, 1): 7,
        ("cint32", "int32", 15, 9, 1): 15,
        ("cint32", "int32", 16, 9, 1): 4,
        ("cint32", "int32", 1, 10, 1): 1,
        ("cint32", "int32", 2, 10, 1): 1,
        ("cint32", "int32", 3, 10, 1): 3,
        ("cint32", "int32", 4, 10, 1): 1,
        ("cint32", "int32", 5, 10, 1): 5,
        ("cint32", "int32", 6, 10, 1): 3,
        ("cint32", "int32", 7, 10, 1): 7,
        ("cint32", "int32", 8, 10, 1): 1,
        ("cint32", "int32", 9, 10, 1): 9,
        ("cint32", "int32", 10, 10, 1): 5,
        ("cint32", "int32", 11, 10, 1): 11,
        ("cint32", "int32", 12, 10, 1): 3,
        ("cint32", "int32", 13, 10, 1): 13,
        ("cint32", "int32", 14, 10, 1): 7,
        ("cint32", "int32", 15, 10, 1): 15,
        ("cint32", "int32", 16, 10, 1): 2,
        ("cint32", "int32", 1, 11, 1): 1,
        ("cint32", "int32", 2, 11, 1): 1,
        ("cint32", "int32", 3, 11, 1): 3,
        ("cint32", "int32", 4, 11, 1): 1,
        ("cint32", "int32", 5, 11, 1): 5,
        ("cint32", "int32", 6, 11, 1): 3,
        ("cint32", "int32", 7, 11, 1): 7,
        ("cint32", "int32", 8, 11, 1): 2,
        ("cint32", "int32", 9, 11, 1): 9,
        ("cint32", "int32", 10, 11, 1): 5,
        ("cint32", "int32", 11, 11, 1): 11,
        ("cint32", "int32", 12, 11, 1): 3,
        ("cint32", "int32", 13, 11, 1): 13,
        ("cint32", "int32", 14, 11, 1): 7,
        ("cint32", "int32", 15, 11, 1): 15,
        ("cint32", "int32", 16, 11, 1): 4,
        ("cint32", "int32", 1, 12, 1): 1,
        ("cint32", "int32", 2, 12, 1): 1,
        ("cint32", "int32", 3, 12, 1): 3,
        ("cint32", "int32", 4, 12, 1): 1,
        ("cint32", "int32", 5, 12, 1): 5,
        ("cint32", "int32", 6, 12, 1): 3,
        ("cint32", "int32", 7, 12, 1): 7,
        ("cint32", "int32", 8, 12, 1): 1,
        ("cint32", "int32", 9, 12, 1): 9,
        ("cint32", "int32", 10, 12, 1): 5,
        ("cint32", "int32", 11, 12, 1): 11,
        ("cint32", "int32", 12, 12, 1): 3,
        ("cint32", "int32", 13, 12, 1): 13,
        ("cint32", "int32", 14, 12, 1): 7,
        ("cint32", "int32", 15, 12, 1): 15,
        ("cint32", "int32", 16, 12, 1): 2,
        ("cint32", "int32", 1, 13, 1): 1,
        ("cint32", "int32", 2, 13, 1): 1,
        ("cint32", "int32", 3, 13, 1): 3,
        ("cint32", "int32", 4, 13, 1): 1,
        ("cint32", "int32", 5, 13, 1): 5,
        ("cint32", "int32", 6, 13, 1): 3,
        ("cint32", "int32", 7, 13, 1): 7,
        ("cint32", "int32", 8, 13, 1): 2,
        ("cint32", "int32", 9, 13, 1): 9,
        ("cint32", "int32", 10, 13, 1): 5,
        ("cint32", "int32", 11, 13, 1): 11,
        ("cint32", "int32", 12, 13, 1): 3,
        ("cint32", "int32", 13, 13, 1): 13,
        ("cint32", "int32", 14, 13, 1): 7,
        ("cint32", "int32", 15, 13, 1): 15,
        ("cint32", "int32", 16, 13, 1): 4,
        ("cint32", "int32", 1, 14, 1): 1,
        ("cint32", "int32", 2, 14, 1): 1,
        ("cint32", "int32", 3, 14, 1): 3,
        ("cint32", "int32", 4, 14, 1): 1,
        ("cint32", "int32", 5, 14, 1): 5,
        ("cint32", "int32", 6, 14, 1): 3,
        ("cint32", "int32", 7, 14, 1): 7,
        ("cint32", "int32", 8, 14, 1): 1,
        ("cint32", "int32", 9, 14, 1): 9,
        ("cint32", "int32", 10, 14, 1): 5,
        ("cint32", "int32", 11, 14, 1): 11,
        ("cint32", "int32", 12, 14, 1): 3,
        ("cint32", "int32", 13, 14, 1): 13,
        ("cint32", "int32", 14, 14, 1): 7,
        ("cint32", "int32", 15, 14, 1): 15,
        ("cint32", "int32", 16, 14, 1): 2,
        ("cint32", "int32", 1, 15, 1): 1,
        ("cint32", "int32", 2, 15, 1): 1,
        ("cint32", "int32", 3, 15, 1): 3,
        ("cint32", "int32", 4, 15, 1): 1,
        ("cint32", "int32", 5, 15, 1): 5,
        ("cint32", "int32", 6, 15, 1): 3,
        ("cint32", "int32", 7, 15, 1): 7,
        ("cint32", "int32", 8, 15, 1): 2,
        ("cint32", "int32", 9, 15, 1): 9,
        ("cint32", "int32", 10, 15, 1): 5,
        ("cint32", "int32", 11, 15, 1): 11,
        ("cint32", "int32", 12, 15, 1): 3,
        ("cint32", "int32", 13, 15, 1): 13,
        ("cint32", "int32", 14, 15, 1): 7,
        ("cint32", "int32", 15, 15, 1): 15,
        ("cint32", "int32", 16, 15, 1): 4,
        ("cint32", "int32", 1, 16, 1): 1,
        ("cint32", "int32", 2, 16, 1): 1,
        ("cint32", "int32", 3, 16, 1): 3,
        ("cint32", "int32", 4, 16, 1): 1,
        ("cint32", "int32", 5, 16, 1): 5,
        ("cint32", "int32", 6, 16, 1): 3,
        ("cint32", "int32", 7, 16, 1): 7,
        ("cint32", "int32", 8, 16, 1): 1,
        ("cint32", "int32", 9, 16, 1): 9,
        ("cint32", "int32", 10, 16, 1): 5,
        ("cint32", "int32", 11, 16, 1): 11,
        ("cint32", "int32", 12, 16, 1): 3,
        ("cint32", "int32", 13, 16, 1): 13,
        ("cint32", "int32", 14, 16, 1): 7,
        ("cint32", "int32", 15, 16, 1): 15,
        ("cint32", "int32", 16, 16, 1): 2,
        ("cint32", "cint32", 1, 1, 0): 1,
        ("cint32", "cint32", 2, 1, 0): 1,
        ("cint32", "cint32", 3, 1, 0): 3,
        ("cint32", "cint32", 4, 1, 0): 1,
        ("cint32", "cint32", 5, 1, 0): 5,
        ("cint32", "cint32", 6, 1, 0): 3,
        ("cint32", "cint32", 7, 1, 0): 7,
        ("cint32", "cint32", 8, 1, 0): 1,
        ("cint32", "cint32", 9, 1, 0): 9,
        ("cint32", "cint32", 10, 1, 0): 5,
        ("cint32", "cint32", 11, 1, 0): 11,
        ("cint32", "cint32", 12, 1, 0): 3,
        ("cint32", "cint32", 13, 1, 0): 13,
        ("cint32", "cint32", 14, 1, 0): 7,
        ("cint32", "cint32", 15, 1, 0): 15,
        ("cint32", "cint32", 16, 1, 0): 2,
        ("cint32", "cint32", 1, 2, 0): 1,
        ("cint32", "cint32", 2, 2, 0): 1,
        ("cint32", "cint32", 3, 2, 0): 3,
        ("cint32", "cint32", 4, 2, 0): 1,
        ("cint32", "cint32", 5, 2, 0): 5,
        ("cint32", "cint32", 6, 2, 0): 3,
        ("cint32", "cint32", 7, 2, 0): 7,
        ("cint32", "cint32", 8, 2, 0): 1,
        ("cint32", "cint32", 9, 2, 0): 9,
        ("cint32", "cint32", 10, 2, 0): 5,
        ("cint32", "cint32", 11, 2, 0): 11,
        ("cint32", "cint32", 12, 2, 0): 3,
        ("cint32", "cint32", 13, 2, 0): 13,
        ("cint32", "cint32", 14, 2, 0): 7,
        ("cint32", "cint32", 15, 2, 0): 15,
        ("cint32", "cint32", 16, 2, 0): 1,
        ("cint32", "cint32", 1, 3, 0): 1,
        ("cint32", "cint32", 2, 3, 0): 1,
        ("cint32", "cint32", 3, 3, 0): 3,
        ("cint32", "cint32", 4, 3, 0): 1,
        ("cint32", "cint32", 5, 3, 0): 5,
        ("cint32", "cint32", 6, 3, 0): 3,
        ("cint32", "cint32", 7, 3, 0): 7,
        ("cint32", "cint32", 8, 3, 0): 1,
        ("cint32", "cint32", 9, 3, 0): 9,
        ("cint32", "cint32", 10, 3, 0): 5,
        ("cint32", "cint32", 11, 3, 0): 11,
        ("cint32", "cint32", 12, 3, 0): 3,
        ("cint32", "cint32", 13, 3, 0): 13,
        ("cint32", "cint32", 14, 3, 0): 7,
        ("cint32", "cint32", 15, 3, 0): 15,
        ("cint32", "cint32", 16, 3, 0): 2,
        ("cint32", "cint32", 1, 4, 0): 1,
        ("cint32", "cint32", 2, 4, 0): 1,
        ("cint32", "cint32", 3, 4, 0): 3,
        ("cint32", "cint32", 4, 4, 0): 1,
        ("cint32", "cint32", 5, 4, 0): 5,
        ("cint32", "cint32", 6, 4, 0): 3,
        ("cint32", "cint32", 7, 4, 0): 7,
        ("cint32", "cint32", 8, 4, 0): 1,
        ("cint32", "cint32", 9, 4, 0): 9,
        ("cint32", "cint32", 10, 4, 0): 5,
        ("cint32", "cint32", 11, 4, 0): 11,
        ("cint32", "cint32", 12, 4, 0): 3,
        ("cint32", "cint32", 13, 4, 0): 13,
        ("cint32", "cint32", 14, 4, 0): 7,
        ("cint32", "cint32", 15, 4, 0): 15,
        ("cint32", "cint32", 16, 4, 0): 1,
        ("cint32", "cint32", 1, 5, 0): 1,
        ("cint32", "cint32", 2, 5, 0): 1,
        ("cint32", "cint32", 3, 5, 0): 3,
        ("cint32", "cint32", 4, 5, 0): 1,
        ("cint32", "cint32", 5, 5, 0): 5,
        ("cint32", "cint32", 6, 5, 0): 3,
        ("cint32", "cint32", 7, 5, 0): 7,
        ("cint32", "cint32", 8, 5, 0): 1,
        ("cint32", "cint32", 9, 5, 0): 9,
        ("cint32", "cint32", 10, 5, 0): 5,
        ("cint32", "cint32", 11, 5, 0): 11,
        ("cint32", "cint32", 12, 5, 0): 3,
        ("cint32", "cint32", 13, 5, 0): 13,
        ("cint32", "cint32", 14, 5, 0): 7,
        ("cint32", "cint32", 15, 5, 0): 15,
        ("cint32", "cint32", 16, 5, 0): 2,
        ("cint32", "cint32", 1, 6, 0): 1,
        ("cint32", "cint32", 2, 6, 0): 1,
        ("cint32", "cint32", 3, 6, 0): 3,
        ("cint32", "cint32", 4, 6, 0): 1,
        ("cint32", "cint32", 5, 6, 0): 5,
        ("cint32", "cint32", 6, 6, 0): 3,
        ("cint32", "cint32", 7, 6, 0): 7,
        ("cint32", "cint32", 8, 6, 0): 1,
        ("cint32", "cint32", 9, 6, 0): 9,
        ("cint32", "cint32", 10, 6, 0): 5,
        ("cint32", "cint32", 11, 6, 0): 11,
        ("cint32", "cint32", 12, 6, 0): 3,
        ("cint32", "cint32", 13, 6, 0): 13,
        ("cint32", "cint32", 14, 6, 0): 7,
        ("cint32", "cint32", 15, 6, 0): 15,
        ("cint32", "cint32", 16, 6, 0): 1,
        ("cint32", "cint32", 1, 7, 0): 1,
        ("cint32", "cint32", 2, 7, 0): 1,
        ("cint32", "cint32", 3, 7, 0): 3,
        ("cint32", "cint32", 4, 7, 0): 1,
        ("cint32", "cint32", 5, 7, 0): 5,
        ("cint32", "cint32", 6, 7, 0): 3,
        ("cint32", "cint32", 7, 7, 0): 7,
        ("cint32", "cint32", 8, 7, 0): 1,
        ("cint32", "cint32", 9, 7, 0): 9,
        ("cint32", "cint32", 10, 7, 0): 5,
        ("cint32", "cint32", 11, 7, 0): 11,
        ("cint32", "cint32", 12, 7, 0): 3,
        ("cint32", "cint32", 13, 7, 0): 13,
        ("cint32", "cint32", 14, 7, 0): 7,
        ("cint32", "cint32", 15, 7, 0): 15,
        ("cint32", "cint32", 16, 7, 0): 2,
        ("cint32", "cint32", 1, 8, 0): 1,
        ("cint32", "cint32", 2, 8, 0): 1,
        ("cint32", "cint32", 3, 8, 0): 3,
        ("cint32", "cint32", 4, 8, 0): 1,
        ("cint32", "cint32", 5, 8, 0): 5,
        ("cint32", "cint32", 6, 8, 0): 3,
        ("cint32", "cint32", 7, 8, 0): 7,
        ("cint32", "cint32", 8, 8, 0): 1,
        ("cint32", "cint32", 9, 8, 0): 9,
        ("cint32", "cint32", 10, 8, 0): 5,
        ("cint32", "cint32", 11, 8, 0): 11,
        ("cint32", "cint32", 12, 8, 0): 3,
        ("cint32", "cint32", 13, 8, 0): 13,
        ("cint32", "cint32", 14, 8, 0): 7,
        ("cint32", "cint32", 15, 8, 0): 15,
        ("cint32", "cint32", 16, 8, 0): 1,
        ("cint32", "cint32", 1, 9, 0): 1,
        ("cint32", "cint32", 2, 9, 0): 1,
        ("cint32", "cint32", 3, 9, 0): 3,
        ("cint32", "cint32", 4, 9, 0): 1,
        ("cint32", "cint32", 5, 9, 0): 5,
        ("cint32", "cint32", 6, 9, 0): 3,
        ("cint32", "cint32", 7, 9, 0): 7,
        ("cint32", "cint32", 8, 9, 0): 1,
        ("cint32", "cint32", 9, 9, 0): 9,
        ("cint32", "cint32", 10, 9, 0): 5,
        ("cint32", "cint32", 11, 9, 0): 11,
        ("cint32", "cint32", 12, 9, 0): 3,
        ("cint32", "cint32", 13, 9, 0): 13,
        ("cint32", "cint32", 14, 9, 0): 7,
        ("cint32", "cint32", 15, 9, 0): 15,
        ("cint32", "cint32", 16, 9, 0): 2,
        ("cint32", "cint32", 1, 10, 0): 1,
        ("cint32", "cint32", 2, 10, 0): 1,
        ("cint32", "cint32", 3, 10, 0): 3,
        ("cint32", "cint32", 4, 10, 0): 1,
        ("cint32", "cint32", 5, 10, 0): 5,
        ("cint32", "cint32", 6, 10, 0): 3,
        ("cint32", "cint32", 7, 10, 0): 7,
        ("cint32", "cint32", 8, 10, 0): 1,
        ("cint32", "cint32", 9, 10, 0): 9,
        ("cint32", "cint32", 10, 10, 0): 5,
        ("cint32", "cint32", 11, 10, 0): 11,
        ("cint32", "cint32", 12, 10, 0): 3,
        ("cint32", "cint32", 13, 10, 0): 13,
        ("cint32", "cint32", 14, 10, 0): 7,
        ("cint32", "cint32", 15, 10, 0): 15,
        ("cint32", "cint32", 16, 10, 0): 1,
        ("cint32", "cint32", 1, 11, 0): 1,
        ("cint32", "cint32", 2, 11, 0): 1,
        ("cint32", "cint32", 3, 11, 0): 3,
        ("cint32", "cint32", 4, 11, 0): 1,
        ("cint32", "cint32", 5, 11, 0): 5,
        ("cint32", "cint32", 6, 11, 0): 3,
        ("cint32", "cint32", 7, 11, 0): 7,
        ("cint32", "cint32", 8, 11, 0): 1,
        ("cint32", "cint32", 9, 11, 0): 9,
        ("cint32", "cint32", 10, 11, 0): 5,
        ("cint32", "cint32", 11, 11, 0): 11,
        ("cint32", "cint32", 12, 11, 0): 3,
        ("cint32", "cint32", 13, 11, 0): 13,
        ("cint32", "cint32", 14, 11, 0): 7,
        ("cint32", "cint32", 15, 11, 0): 15,
        ("cint32", "cint32", 16, 11, 0): 2,
        ("cint32", "cint32", 1, 12, 0): 1,
        ("cint32", "cint32", 2, 12, 0): 1,
        ("cint32", "cint32", 3, 12, 0): 3,
        ("cint32", "cint32", 4, 12, 0): 1,
        ("cint32", "cint32", 5, 12, 0): 5,
        ("cint32", "cint32", 6, 12, 0): 3,
        ("cint32", "cint32", 7, 12, 0): 7,
        ("cint32", "cint32", 8, 12, 0): 1,
        ("cint32", "cint32", 9, 12, 0): 9,
        ("cint32", "cint32", 10, 12, 0): 5,
        ("cint32", "cint32", 11, 12, 0): 11,
        ("cint32", "cint32", 12, 12, 0): 3,
        ("cint32", "cint32", 13, 12, 0): 13,
        ("cint32", "cint32", 14, 12, 0): 7,
        ("cint32", "cint32", 15, 12, 0): 15,
        ("cint32", "cint32", 16, 12, 0): 1,
        ("cint32", "cint32", 1, 13, 0): 1,
        ("cint32", "cint32", 2, 13, 0): 1,
        ("cint32", "cint32", 3, 13, 0): 3,
        ("cint32", "cint32", 4, 13, 0): 1,
        ("cint32", "cint32", 5, 13, 0): 5,
        ("cint32", "cint32", 6, 13, 0): 3,
        ("cint32", "cint32", 7, 13, 0): 7,
        ("cint32", "cint32", 8, 13, 0): 1,
        ("cint32", "cint32", 9, 13, 0): 9,
        ("cint32", "cint32", 10, 13, 0): 5,
        ("cint32", "cint32", 11, 13, 0): 11,
        ("cint32", "cint32", 12, 13, 0): 3,
        ("cint32", "cint32", 13, 13, 0): 13,
        ("cint32", "cint32", 14, 13, 0): 7,
        ("cint32", "cint32", 15, 13, 0): 15,
        ("cint32", "cint32", 16, 13, 0): 2,
        ("cint32", "cint32", 1, 14, 0): 1,
        ("cint32", "cint32", 2, 14, 0): 1,
        ("cint32", "cint32", 3, 14, 0): 3,
        ("cint32", "cint32", 4, 14, 0): 1,
        ("cint32", "cint32", 5, 14, 0): 5,
        ("cint32", "cint32", 6, 14, 0): 3,
        ("cint32", "cint32", 7, 14, 0): 7,
        ("cint32", "cint32", 8, 14, 0): 1,
        ("cint32", "cint32", 9, 14, 0): 9,
        ("cint32", "cint32", 10, 14, 0): 5,
        ("cint32", "cint32", 11, 14, 0): 11,
        ("cint32", "cint32", 12, 14, 0): 3,
        ("cint32", "cint32", 13, 14, 0): 13,
        ("cint32", "cint32", 14, 14, 0): 7,
        ("cint32", "cint32", 15, 14, 0): 15,
        ("cint32", "cint32", 16, 14, 0): 1,
        ("cint32", "cint32", 1, 15, 0): 1,
        ("cint32", "cint32", 2, 15, 0): 1,
        ("cint32", "cint32", 3, 15, 0): 3,
        ("cint32", "cint32", 4, 15, 0): 1,
        ("cint32", "cint32", 5, 15, 0): 5,
        ("cint32", "cint32", 6, 15, 0): 3,
        ("cint32", "cint32", 7, 15, 0): 7,
        ("cint32", "cint32", 8, 15, 0): 1,
        ("cint32", "cint32", 9, 15, 0): 9,
        ("cint32", "cint32", 10, 15, 0): 5,
        ("cint32", "cint32", 11, 15, 0): 11,
        ("cint32", "cint32", 12, 15, 0): 3,
        ("cint32", "cint32", 13, 15, 0): 13,
        ("cint32", "cint32", 14, 15, 0): 7,
        ("cint32", "cint32", 15, 15, 0): 15,
        ("cint32", "cint32", 16, 15, 0): 2,
        ("cint32", "cint32", 1, 16, 0): 1,
        ("cint32", "cint32", 2, 16, 0): 1,
        ("cint32", "cint32", 3, 16, 0): 3,
        ("cint32", "cint32", 4, 16, 0): 1,
        ("cint32", "cint32", 5, 16, 0): 5,
        ("cint32", "cint32", 6, 16, 0): 3,
        ("cint32", "cint32", 7, 16, 0): 7,
        ("cint32", "cint32", 8, 16, 0): 1,
        ("cint32", "cint32", 9, 16, 0): 9,
        ("cint32", "cint32", 10, 16, 0): 5,
        ("cint32", "cint32", 11, 16, 0): 11,
        ("cint32", "cint32", 12, 16, 0): 3,
        ("cint32", "cint32", 13, 16, 0): 13,
        ("cint32", "cint32", 14, 16, 0): 7,
        ("cint32", "cint32", 15, 16, 0): 15,
        ("cint32", "cint32", 16, 16, 0): 1,
        ("cint32", "cint32", 1, 1, 1): 1,
        ("cint32", "cint32", 2, 1, 1): 1,
        ("cint32", "cint32", 3, 1, 1): 3,
        ("cint32", "cint32", 4, 1, 1): 1,
        ("cint32", "cint32", 5, 1, 1): 5,
        ("cint32", "cint32", 6, 1, 1): 3,
        ("cint32", "cint32", 7, 1, 1): 7,
        ("cint32", "cint32", 8, 1, 1): 2,
        ("cint32", "cint32", 9, 1, 1): 9,
        ("cint32", "cint32", 10, 1, 1): 5,
        ("cint32", "cint32", 11, 1, 1): 11,
        ("cint32", "cint32", 12, 1, 1): 3,
        ("cint32", "cint32", 13, 1, 1): 13,
        ("cint32", "cint32", 14, 1, 1): 7,
        ("cint32", "cint32", 15, 1, 1): 15,
        ("cint32", "cint32", 16, 1, 1): 4,
        ("cint32", "cint32", 1, 2, 1): 1,
        ("cint32", "cint32", 2, 2, 1): 1,
        ("cint32", "cint32", 3, 2, 1): 3,
        ("cint32", "cint32", 4, 2, 1): 1,
        ("cint32", "cint32", 5, 2, 1): 5,
        ("cint32", "cint32", 6, 2, 1): 3,
        ("cint32", "cint32", 7, 2, 1): 7,
        ("cint32", "cint32", 8, 2, 1): 1,
        ("cint32", "cint32", 9, 2, 1): 9,
        ("cint32", "cint32", 10, 2, 1): 5,
        ("cint32", "cint32", 11, 2, 1): 11,
        ("cint32", "cint32", 12, 2, 1): 3,
        ("cint32", "cint32", 13, 2, 1): 13,
        ("cint32", "cint32", 14, 2, 1): 7,
        ("cint32", "cint32", 15, 2, 1): 15,
        ("cint32", "cint32", 16, 2, 1): 2,
        ("cint32", "cint32", 1, 3, 1): 1,
        ("cint32", "cint32", 2, 3, 1): 1,
        ("cint32", "cint32", 3, 3, 1): 3,
        ("cint32", "cint32", 4, 3, 1): 1,
        ("cint32", "cint32", 5, 3, 1): 5,
        ("cint32", "cint32", 6, 3, 1): 3,
        ("cint32", "cint32", 7, 3, 1): 7,
        ("cint32", "cint32", 8, 3, 1): 2,
        ("cint32", "cint32", 9, 3, 1): 9,
        ("cint32", "cint32", 10, 3, 1): 5,
        ("cint32", "cint32", 11, 3, 1): 11,
        ("cint32", "cint32", 12, 3, 1): 3,
        ("cint32", "cint32", 13, 3, 1): 13,
        ("cint32", "cint32", 14, 3, 1): 7,
        ("cint32", "cint32", 15, 3, 1): 15,
        ("cint32", "cint32", 16, 3, 1): 4,
        ("cint32", "cint32", 1, 4, 1): 1,
        ("cint32", "cint32", 2, 4, 1): 1,
        ("cint32", "cint32", 3, 4, 1): 3,
        ("cint32", "cint32", 4, 4, 1): 1,
        ("cint32", "cint32", 5, 4, 1): 5,
        ("cint32", "cint32", 6, 4, 1): 3,
        ("cint32", "cint32", 7, 4, 1): 7,
        ("cint32", "cint32", 8, 4, 1): 1,
        ("cint32", "cint32", 9, 4, 1): 9,
        ("cint32", "cint32", 10, 4, 1): 5,
        ("cint32", "cint32", 11, 4, 1): 11,
        ("cint32", "cint32", 12, 4, 1): 3,
        ("cint32", "cint32", 13, 4, 1): 13,
        ("cint32", "cint32", 14, 4, 1): 7,
        ("cint32", "cint32", 15, 4, 1): 15,
        ("cint32", "cint32", 16, 4, 1): 2,
        ("cint32", "cint32", 1, 5, 1): 1,
        ("cint32", "cint32", 2, 5, 1): 1,
        ("cint32", "cint32", 3, 5, 1): 3,
        ("cint32", "cint32", 4, 5, 1): 1,
        ("cint32", "cint32", 5, 5, 1): 5,
        ("cint32", "cint32", 6, 5, 1): 3,
        ("cint32", "cint32", 7, 5, 1): 7,
        ("cint32", "cint32", 8, 5, 1): 2,
        ("cint32", "cint32", 9, 5, 1): 9,
        ("cint32", "cint32", 10, 5, 1): 5,
        ("cint32", "cint32", 11, 5, 1): 11,
        ("cint32", "cint32", 12, 5, 1): 3,
        ("cint32", "cint32", 13, 5, 1): 13,
        ("cint32", "cint32", 14, 5, 1): 7,
        ("cint32", "cint32", 15, 5, 1): 15,
        ("cint32", "cint32", 16, 5, 1): 4,
        ("cint32", "cint32", 1, 6, 1): 1,
        ("cint32", "cint32", 2, 6, 1): 1,
        ("cint32", "cint32", 3, 6, 1): 3,
        ("cint32", "cint32", 4, 6, 1): 1,
        ("cint32", "cint32", 5, 6, 1): 5,
        ("cint32", "cint32", 6, 6, 1): 3,
        ("cint32", "cint32", 7, 6, 1): 7,
        ("cint32", "cint32", 8, 6, 1): 1,
        ("cint32", "cint32", 9, 6, 1): 9,
        ("cint32", "cint32", 10, 6, 1): 5,
        ("cint32", "cint32", 11, 6, 1): 11,
        ("cint32", "cint32", 12, 6, 1): 3,
        ("cint32", "cint32", 13, 6, 1): 13,
        ("cint32", "cint32", 14, 6, 1): 7,
        ("cint32", "cint32", 15, 6, 1): 15,
        ("cint32", "cint32", 16, 6, 1): 2,
        ("cint32", "cint32", 1, 7, 1): 1,
        ("cint32", "cint32", 2, 7, 1): 1,
        ("cint32", "cint32", 3, 7, 1): 3,
        ("cint32", "cint32", 4, 7, 1): 1,
        ("cint32", "cint32", 5, 7, 1): 5,
        ("cint32", "cint32", 6, 7, 1): 3,
        ("cint32", "cint32", 7, 7, 1): 7,
        ("cint32", "cint32", 8, 7, 1): 2,
        ("cint32", "cint32", 9, 7, 1): 9,
        ("cint32", "cint32", 10, 7, 1): 5,
        ("cint32", "cint32", 11, 7, 1): 11,
        ("cint32", "cint32", 12, 7, 1): 3,
        ("cint32", "cint32", 13, 7, 1): 13,
        ("cint32", "cint32", 14, 7, 1): 7,
        ("cint32", "cint32", 15, 7, 1): 15,
        ("cint32", "cint32", 16, 7, 1): 4,
        ("cint32", "cint32", 1, 8, 1): 1,
        ("cint32", "cint32", 2, 8, 1): 1,
        ("cint32", "cint32", 3, 8, 1): 3,
        ("cint32", "cint32", 4, 8, 1): 1,
        ("cint32", "cint32", 5, 8, 1): 5,
        ("cint32", "cint32", 6, 8, 1): 3,
        ("cint32", "cint32", 7, 8, 1): 7,
        ("cint32", "cint32", 8, 8, 1): 1,
        ("cint32", "cint32", 9, 8, 1): 9,
        ("cint32", "cint32", 10, 8, 1): 5,
        ("cint32", "cint32", 11, 8, 1): 11,
        ("cint32", "cint32", 12, 8, 1): 3,
        ("cint32", "cint32", 13, 8, 1): 13,
        ("cint32", "cint32", 14, 8, 1): 7,
        ("cint32", "cint32", 15, 8, 1): 15,
        ("cint32", "cint32", 16, 8, 1): 2,
        ("cint32", "cint32", 1, 9, 1): 1,
        ("cint32", "cint32", 2, 9, 1): 1,
        ("cint32", "cint32", 3, 9, 1): 3,
        ("cint32", "cint32", 4, 9, 1): 1,
        ("cint32", "cint32", 5, 9, 1): 5,
        ("cint32", "cint32", 6, 9, 1): 3,
        ("cint32", "cint32", 7, 9, 1): 7,
        ("cint32", "cint32", 8, 9, 1): 2,
        ("cint32", "cint32", 9, 9, 1): 9,
        ("cint32", "cint32", 10, 9, 1): 5,
        ("cint32", "cint32", 11, 9, 1): 11,
        ("cint32", "cint32", 12, 9, 1): 3,
        ("cint32", "cint32", 13, 9, 1): 13,
        ("cint32", "cint32", 14, 9, 1): 7,
        ("cint32", "cint32", 15, 9, 1): 15,
        ("cint32", "cint32", 16, 9, 1): 4,
        ("cint32", "cint32", 1, 10, 1): 1,
        ("cint32", "cint32", 2, 10, 1): 1,
        ("cint32", "cint32", 3, 10, 1): 3,
        ("cint32", "cint32", 4, 10, 1): 1,
        ("cint32", "cint32", 5, 10, 1): 5,
        ("cint32", "cint32", 6, 10, 1): 3,
        ("cint32", "cint32", 7, 10, 1): 7,
        ("cint32", "cint32", 8, 10, 1): 1,
        ("cint32", "cint32", 9, 10, 1): 9,
        ("cint32", "cint32", 10, 10, 1): 5,
        ("cint32", "cint32", 11, 10, 1): 11,
        ("cint32", "cint32", 12, 10, 1): 3,
        ("cint32", "cint32", 13, 10, 1): 13,
        ("cint32", "cint32", 14, 10, 1): 7,
        ("cint32", "cint32", 15, 10, 1): 15,
        ("cint32", "cint32", 16, 10, 1): 2,
        ("cint32", "cint32", 1, 11, 1): 1,
        ("cint32", "cint32", 2, 11, 1): 1,
        ("cint32", "cint32", 3, 11, 1): 3,
        ("cint32", "cint32", 4, 11, 1): 1,
        ("cint32", "cint32", 5, 11, 1): 5,
        ("cint32", "cint32", 6, 11, 1): 3,
        ("cint32", "cint32", 7, 11, 1): 7,
        ("cint32", "cint32", 8, 11, 1): 2,
        ("cint32", "cint32", 9, 11, 1): 9,
        ("cint32", "cint32", 10, 11, 1): 5,
        ("cint32", "cint32", 11, 11, 1): 11,
        ("cint32", "cint32", 12, 11, 1): 3,
        ("cint32", "cint32", 13, 11, 1): 13,
        ("cint32", "cint32", 14, 11, 1): 7,
        ("cint32", "cint32", 15, 11, 1): 15,
        ("cint32", "cint32", 16, 11, 1): 4,
        ("cint32", "cint32", 1, 12, 1): 1,
        ("cint32", "cint32", 2, 12, 1): 1,
        ("cint32", "cint32", 3, 12, 1): 3,
        ("cint32", "cint32", 4, 12, 1): 1,
        ("cint32", "cint32", 5, 12, 1): 5,
        ("cint32", "cint32", 6, 12, 1): 3,
        ("cint32", "cint32", 7, 12, 1): 7,
        ("cint32", "cint32", 8, 12, 1): 1,
        ("cint32", "cint32", 9, 12, 1): 9,
        ("cint32", "cint32", 10, 12, 1): 5,
        ("cint32", "cint32", 11, 12, 1): 11,
        ("cint32", "cint32", 12, 12, 1): 3,
        ("cint32", "cint32", 13, 12, 1): 13,
        ("cint32", "cint32", 14, 12, 1): 7,
        ("cint32", "cint32", 15, 12, 1): 15,
        ("cint32", "cint32", 16, 12, 1): 2,
        ("cint32", "cint32", 1, 13, 1): 1,
        ("cint32", "cint32", 2, 13, 1): 1,
        ("cint32", "cint32", 3, 13, 1): 3,
        ("cint32", "cint32", 4, 13, 1): 1,
        ("cint32", "cint32", 5, 13, 1): 5,
        ("cint32", "cint32", 6, 13, 1): 3,
        ("cint32", "cint32", 7, 13, 1): 7,
        ("cint32", "cint32", 8, 13, 1): 2,
        ("cint32", "cint32", 9, 13, 1): 9,
        ("cint32", "cint32", 10, 13, 1): 5,
        ("cint32", "cint32", 11, 13, 1): 11,
        ("cint32", "cint32", 12, 13, 1): 3,
        ("cint32", "cint32", 13, 13, 1): 13,
        ("cint32", "cint32", 14, 13, 1): 7,
        ("cint32", "cint32", 15, 13, 1): 15,
        ("cint32", "cint32", 16, 13, 1): 4,
        ("cint32", "cint32", 1, 14, 1): 1,
        ("cint32", "cint32", 2, 14, 1): 1,
        ("cint32", "cint32", 3, 14, 1): 3,
        ("cint32", "cint32", 4, 14, 1): 1,
        ("cint32", "cint32", 5, 14, 1): 5,
        ("cint32", "cint32", 6, 14, 1): 3,
        ("cint32", "cint32", 7, 14, 1): 7,
        ("cint32", "cint32", 8, 14, 1): 1,
        ("cint32", "cint32", 9, 14, 1): 9,
        ("cint32", "cint32", 10, 14, 1): 5,
        ("cint32", "cint32", 11, 14, 1): 11,
        ("cint32", "cint32", 12, 14, 1): 3,
        ("cint32", "cint32", 13, 14, 1): 13,
        ("cint32", "cint32", 14, 14, 1): 7,
        ("cint32", "cint32", 15, 14, 1): 15,
        ("cint32", "cint32", 16, 14, 1): 2,
        ("cint32", "cint32", 1, 15, 1): 1,
        ("cint32", "cint32", 2, 15, 1): 1,
        ("cint32", "cint32", 3, 15, 1): 3,
        ("cint32", "cint32", 4, 15, 1): 1,
        ("cint32", "cint32", 5, 15, 1): 5,
        ("cint32", "cint32", 6, 15, 1): 3,
        ("cint32", "cint32", 7, 15, 1): 7,
        ("cint32", "cint32", 8, 15, 1): 2,
        ("cint32", "cint32", 9, 15, 1): 9,
        ("cint32", "cint32", 10, 15, 1): 5,
        ("cint32", "cint32", 11, 15, 1): 11,
        ("cint32", "cint32", 12, 15, 1): 3,
        ("cint32", "cint32", 13, 15, 1): 13,
        ("cint32", "cint32", 14, 15, 1): 7,
        ("cint32", "cint32", 15, 15, 1): 15,
        ("cint32", "cint32", 16, 15, 1): 4,
        ("cint32", "cint32", 1, 16, 1): 1,
        ("cint32", "cint32", 2, 16, 1): 1,
        ("cint32", "cint32", 3, 16, 1): 3,
        ("cint32", "cint32", 4, 16, 1): 1,
        ("cint32", "cint32", 5, 16, 1): 5,
        ("cint32", "cint32", 6, 16, 1): 3,
        ("cint32", "cint32", 7, 16, 1): 7,
        ("cint32", "cint32", 8, 16, 1): 1,
        ("cint32", "cint32", 9, 16, 1): 9,
        ("cint32", "cint32", 10, 16, 1): 5,
        ("cint32", "cint32", 11, 16, 1): 11,
        ("cint32", "cint32", 12, 16, 1): 3,
        ("cint32", "cint32", 13, 16, 1): 13,
        ("cint32", "cint32", 14, 16, 1): 7,
        ("cint32", "cint32", 15, 16, 1): 15,
        ("cint32", "cint32", 16, 16, 1): 2,
        ("float", "float", 1, 1, 0): 1,
        ("float", "float", 2, 1, 0): 1,
        ("float", "float", 3, 1, 0): 3,
        ("float", "float", 4, 1, 0): 1,
        ("float", "float", 5, 1, 0): 5,
        ("float", "float", 6, 1, 0): 3,
        ("float", "float", 7, 1, 0): 7,
        ("float", "float", 8, 1, 0): 2,
        ("float", "float", 9, 1, 0): 9,
        ("float", "float", 10, 1, 0): 5,
        ("float", "float", 11, 1, 0): 11,
        ("float", "float", 12, 1, 0): 3,
        ("float", "float", 13, 1, 0): 13,
        ("float", "float", 14, 1, 0): 7,
        ("float", "float", 15, 1, 0): 15,
        ("float", "float", 16, 1, 0): 4,
        ("float", "float", 1, 2, 0): 1,
        ("float", "float", 2, 2, 0): 1,
        ("float", "float", 3, 2, 0): 3,
        ("float", "float", 4, 2, 0): 1,
        ("float", "float", 5, 2, 0): 5,
        ("float", "float", 6, 2, 0): 3,
        ("float", "float", 7, 2, 0): 7,
        ("float", "float", 8, 2, 0): 1,
        ("float", "float", 9, 2, 0): 9,
        ("float", "float", 10, 2, 0): 5,
        ("float", "float", 11, 2, 0): 11,
        ("float", "float", 12, 2, 0): 3,
        ("float", "float", 13, 2, 0): 13,
        ("float", "float", 14, 2, 0): 7,
        ("float", "float", 15, 2, 0): 15,
        ("float", "float", 16, 2, 0): 2,
        ("float", "float", 1, 3, 0): 1,
        ("float", "float", 2, 3, 0): 1,
        ("float", "float", 3, 3, 0): 3,
        ("float", "float", 4, 3, 0): 1,
        ("float", "float", 5, 3, 0): 5,
        ("float", "float", 6, 3, 0): 3,
        ("float", "float", 7, 3, 0): 7,
        ("float", "float", 8, 3, 0): 2,
        ("float", "float", 9, 3, 0): 9,
        ("float", "float", 10, 3, 0): 5,
        ("float", "float", 11, 3, 0): 11,
        ("float", "float", 12, 3, 0): 3,
        ("float", "float", 13, 3, 0): 13,
        ("float", "float", 14, 3, 0): 7,
        ("float", "float", 15, 3, 0): 15,
        ("float", "float", 16, 3, 0): 4,
        ("float", "float", 1, 4, 0): 1,
        ("float", "float", 2, 4, 0): 1,
        ("float", "float", 3, 4, 0): 3,
        ("float", "float", 4, 4, 0): 1,
        ("float", "float", 5, 4, 0): 5,
        ("float", "float", 6, 4, 0): 3,
        ("float", "float", 7, 4, 0): 7,
        ("float", "float", 8, 4, 0): 1,
        ("float", "float", 9, 4, 0): 9,
        ("float", "float", 10, 4, 0): 5,
        ("float", "float", 11, 4, 0): 11,
        ("float", "float", 12, 4, 0): 3,
        ("float", "float", 13, 4, 0): 13,
        ("float", "float", 14, 4, 0): 7,
        ("float", "float", 15, 4, 0): 15,
        ("float", "float", 16, 4, 0): 1,
        ("float", "float", 1, 5, 0): 1,
        ("float", "float", 2, 5, 0): 1,
        ("float", "float", 3, 5, 0): 3,
        ("float", "float", 4, 5, 0): 1,
        ("float", "float", 5, 5, 0): 5,
        ("float", "float", 6, 5, 0): 3,
        ("float", "float", 7, 5, 0): 7,
        ("float", "float", 8, 5, 0): 2,
        ("float", "float", 9, 5, 0): 9,
        ("float", "float", 10, 5, 0): 5,
        ("float", "float", 11, 5, 0): 11,
        ("float", "float", 12, 5, 0): 3,
        ("float", "float", 13, 5, 0): 13,
        ("float", "float", 14, 5, 0): 7,
        ("float", "float", 15, 5, 0): 15,
        ("float", "float", 16, 5, 0): 4,
        ("float", "float", 1, 6, 0): 1,
        ("float", "float", 2, 6, 0): 1,
        ("float", "float", 3, 6, 0): 3,
        ("float", "float", 4, 6, 0): 1,
        ("float", "float", 5, 6, 0): 5,
        ("float", "float", 6, 6, 0): 3,
        ("float", "float", 7, 6, 0): 7,
        ("float", "float", 8, 6, 0): 1,
        ("float", "float", 9, 6, 0): 9,
        ("float", "float", 10, 6, 0): 5,
        ("float", "float", 11, 6, 0): 11,
        ("float", "float", 12, 6, 0): 3,
        ("float", "float", 13, 6, 0): 13,
        ("float", "float", 14, 6, 0): 7,
        ("float", "float", 15, 6, 0): 15,
        ("float", "float", 16, 6, 0): 2,
        ("float", "float", 1, 7, 0): 1,
        ("float", "float", 2, 7, 0): 1,
        ("float", "float", 3, 7, 0): 3,
        ("float", "float", 4, 7, 0): 1,
        ("float", "float", 5, 7, 0): 5,
        ("float", "float", 6, 7, 0): 3,
        ("float", "float", 7, 7, 0): 7,
        ("float", "float", 8, 7, 0): 2,
        ("float", "float", 9, 7, 0): 9,
        ("float", "float", 10, 7, 0): 5,
        ("float", "float", 11, 7, 0): 11,
        ("float", "float", 12, 7, 0): 3,
        ("float", "float", 13, 7, 0): 13,
        ("float", "float", 14, 7, 0): 7,
        ("float", "float", 15, 7, 0): 15,
        ("float", "float", 16, 7, 0): 4,
        ("float", "float", 1, 8, 0): 1,
        ("float", "float", 2, 8, 0): 1,
        ("float", "float", 3, 8, 0): 3,
        ("float", "float", 4, 8, 0): 1,
        ("float", "float", 5, 8, 0): 5,
        ("float", "float", 6, 8, 0): 3,
        ("float", "float", 7, 8, 0): 7,
        ("float", "float", 8, 8, 0): 1,
        ("float", "float", 9, 8, 0): 9,
        ("float", "float", 10, 8, 0): 5,
        ("float", "float", 11, 8, 0): 11,
        ("float", "float", 12, 8, 0): 3,
        ("float", "float", 13, 8, 0): 13,
        ("float", "float", 14, 8, 0): 7,
        ("float", "float", 15, 8, 0): 15,
        ("float", "float", 16, 8, 0): 1,
        ("float", "float", 1, 9, 0): 1,
        ("float", "float", 2, 9, 0): 1,
        ("float", "float", 3, 9, 0): 3,
        ("float", "float", 4, 9, 0): 1,
        ("float", "float", 5, 9, 0): 5,
        ("float", "float", 6, 9, 0): 3,
        ("float", "float", 7, 9, 0): 7,
        ("float", "float", 8, 9, 0): 2,
        ("float", "float", 9, 9, 0): 9,
        ("float", "float", 10, 9, 0): 5,
        ("float", "float", 11, 9, 0): 11,
        ("float", "float", 12, 9, 0): 3,
        ("float", "float", 13, 9, 0): 13,
        ("float", "float", 14, 9, 0): 7,
        ("float", "float", 15, 9, 0): 15,
        ("float", "float", 16, 9, 0): 4,
        ("float", "float", 1, 10, 0): 1,
        ("float", "float", 2, 10, 0): 1,
        ("float", "float", 3, 10, 0): 3,
        ("float", "float", 4, 10, 0): 1,
        ("float", "float", 5, 10, 0): 5,
        ("float", "float", 6, 10, 0): 3,
        ("float", "float", 7, 10, 0): 7,
        ("float", "float", 8, 10, 0): 1,
        ("float", "float", 9, 10, 0): 9,
        ("float", "float", 10, 10, 0): 5,
        ("float", "float", 11, 10, 0): 11,
        ("float", "float", 12, 10, 0): 3,
        ("float", "float", 13, 10, 0): 13,
        ("float", "float", 14, 10, 0): 7,
        ("float", "float", 15, 10, 0): 15,
        ("float", "float", 16, 10, 0): 2,
        ("float", "float", 1, 11, 0): 1,
        ("float", "float", 2, 11, 0): 1,
        ("float", "float", 3, 11, 0): 3,
        ("float", "float", 4, 11, 0): 1,
        ("float", "float", 5, 11, 0): 5,
        ("float", "float", 6, 11, 0): 3,
        ("float", "float", 7, 11, 0): 7,
        ("float", "float", 8, 11, 0): 2,
        ("float", "float", 9, 11, 0): 9,
        ("float", "float", 10, 11, 0): 5,
        ("float", "float", 11, 11, 0): 11,
        ("float", "float", 12, 11, 0): 3,
        ("float", "float", 13, 11, 0): 13,
        ("float", "float", 14, 11, 0): 7,
        ("float", "float", 15, 11, 0): 15,
        ("float", "float", 16, 11, 0): 4,
        ("float", "float", 1, 12, 0): 1,
        ("float", "float", 2, 12, 0): 1,
        ("float", "float", 3, 12, 0): 3,
        ("float", "float", 4, 12, 0): 1,
        ("float", "float", 5, 12, 0): 5,
        ("float", "float", 6, 12, 0): 3,
        ("float", "float", 7, 12, 0): 7,
        ("float", "float", 8, 12, 0): 1,
        ("float", "float", 9, 12, 0): 9,
        ("float", "float", 10, 12, 0): 5,
        ("float", "float", 11, 12, 0): 11,
        ("float", "float", 12, 12, 0): 3,
        ("float", "float", 13, 12, 0): 13,
        ("float", "float", 14, 12, 0): 7,
        ("float", "float", 15, 12, 0): 15,
        ("float", "float", 16, 12, 0): 1,
        ("float", "float", 1, 13, 0): 1,
        ("float", "float", 2, 13, 0): 1,
        ("float", "float", 3, 13, 0): 3,
        ("float", "float", 4, 13, 0): 1,
        ("float", "float", 5, 13, 0): 5,
        ("float", "float", 6, 13, 0): 3,
        ("float", "float", 7, 13, 0): 7,
        ("float", "float", 8, 13, 0): 2,
        ("float", "float", 9, 13, 0): 9,
        ("float", "float", 10, 13, 0): 5,
        ("float", "float", 11, 13, 0): 11,
        ("float", "float", 12, 13, 0): 3,
        ("float", "float", 13, 13, 0): 13,
        ("float", "float", 14, 13, 0): 7,
        ("float", "float", 15, 13, 0): 15,
        ("float", "float", 16, 13, 0): 4,
        ("float", "float", 1, 14, 0): 1,
        ("float", "float", 2, 14, 0): 1,
        ("float", "float", 3, 14, 0): 3,
        ("float", "float", 4, 14, 0): 1,
        ("float", "float", 5, 14, 0): 5,
        ("float", "float", 6, 14, 0): 3,
        ("float", "float", 7, 14, 0): 7,
        ("float", "float", 8, 14, 0): 1,
        ("float", "float", 9, 14, 0): 9,
        ("float", "float", 10, 14, 0): 5,
        ("float", "float", 11, 14, 0): 11,
        ("float", "float", 12, 14, 0): 3,
        ("float", "float", 13, 14, 0): 13,
        ("float", "float", 14, 14, 0): 7,
        ("float", "float", 15, 14, 0): 15,
        ("float", "float", 16, 14, 0): 2,
        ("float", "float", 1, 15, 0): 1,
        ("float", "float", 2, 15, 0): 1,
        ("float", "float", 3, 15, 0): 3,
        ("float", "float", 4, 15, 0): 1,
        ("float", "float", 5, 15, 0): 5,
        ("float", "float", 6, 15, 0): 3,
        ("float", "float", 7, 15, 0): 7,
        ("float", "float", 8, 15, 0): 2,
        ("float", "float", 9, 15, 0): 9,
        ("float", "float", 10, 15, 0): 5,
        ("float", "float", 11, 15, 0): 11,
        ("float", "float", 12, 15, 0): 3,
        ("float", "float", 13, 15, 0): 13,
        ("float", "float", 14, 15, 0): 7,
        ("float", "float", 15, 15, 0): 15,
        ("float", "float", 16, 15, 0): 4,
        ("float", "float", 1, 16, 0): 1,
        ("float", "float", 2, 16, 0): 1,
        ("float", "float", 3, 16, 0): 3,
        ("float", "float", 4, 16, 0): 1,
        ("float", "float", 5, 16, 0): 5,
        ("float", "float", 6, 16, 0): 3,
        ("float", "float", 7, 16, 0): 7,
        ("float", "float", 8, 16, 0): 1,
        ("float", "float", 9, 16, 0): 9,
        ("float", "float", 10, 16, 0): 5,
        ("float", "float", 11, 16, 0): 11,
        ("float", "float", 12, 16, 0): 3,
        ("float", "float", 13, 16, 0): 13,
        ("float", "float", 14, 16, 0): 7,
        ("float", "float", 15, 16, 0): 15,
        ("float", "float", 16, 16, 0): 1,
        ("float", "float", 1, 1, 1): 1,
        ("float", "float", 2, 1, 1): 1,
        ("float", "float", 3, 1, 1): 3,
        ("float", "float", 4, 1, 1): 2,
        ("float", "float", 5, 1, 1): 5,
        ("float", "float", 6, 1, 1): 3,
        ("float", "float", 7, 1, 1): 7,
        ("float", "float", 8, 1, 1): 4,
        ("float", "float", 9, 1, 1): 9,
        ("float", "float", 10, 1, 1): 5,
        ("float", "float", 11, 1, 1): 11,
        ("float", "float", 12, 1, 1): 6,
        ("float", "float", 13, 1, 1): 13,
        ("float", "float", 14, 1, 1): 7,
        ("float", "float", 15, 1, 1): 15,
        ("float", "float", 16, 1, 1): 8,
        ("float", "float", 1, 2, 1): 1,
        ("float", "float", 2, 2, 1): 1,
        ("float", "float", 3, 2, 1): 3,
        ("float", "float", 4, 2, 1): 1,
        ("float", "float", 5, 2, 1): 5,
        ("float", "float", 6, 2, 1): 3,
        ("float", "float", 7, 2, 1): 7,
        ("float", "float", 8, 2, 1): 2,
        ("float", "float", 9, 2, 1): 9,
        ("float", "float", 10, 2, 1): 5,
        ("float", "float", 11, 2, 1): 11,
        ("float", "float", 12, 2, 1): 3,
        ("float", "float", 13, 2, 1): 13,
        ("float", "float", 14, 2, 1): 7,
        ("float", "float", 15, 2, 1): 15,
        ("float", "float", 16, 2, 1): 4,
        ("float", "float", 1, 3, 1): 1,
        ("float", "float", 2, 3, 1): 1,
        ("float", "float", 3, 3, 1): 3,
        ("float", "float", 4, 3, 1): 2,
        ("float", "float", 5, 3, 1): 5,
        ("float", "float", 6, 3, 1): 3,
        ("float", "float", 7, 3, 1): 7,
        ("float", "float", 8, 3, 1): 4,
        ("float", "float", 9, 3, 1): 9,
        ("float", "float", 10, 3, 1): 5,
        ("float", "float", 11, 3, 1): 11,
        ("float", "float", 12, 3, 1): 6,
        ("float", "float", 13, 3, 1): 13,
        ("float", "float", 14, 3, 1): 7,
        ("float", "float", 15, 3, 1): 15,
        ("float", "float", 16, 3, 1): 8,
        ("float", "float", 1, 4, 1): 1,
        ("float", "float", 2, 4, 1): 1,
        ("float", "float", 3, 4, 1): 3,
        ("float", "float", 4, 4, 1): 1,
        ("float", "float", 5, 4, 1): 5,
        ("float", "float", 6, 4, 1): 3,
        ("float", "float", 7, 4, 1): 7,
        ("float", "float", 8, 4, 1): 1,
        ("float", "float", 9, 4, 1): 9,
        ("float", "float", 10, 4, 1): 5,
        ("float", "float", 11, 4, 1): 11,
        ("float", "float", 12, 4, 1): 3,
        ("float", "float", 13, 4, 1): 13,
        ("float", "float", 14, 4, 1): 7,
        ("float", "float", 15, 4, 1): 15,
        ("float", "float", 16, 4, 1): 2,
        ("float", "float", 1, 5, 1): 1,
        ("float", "float", 2, 5, 1): 1,
        ("float", "float", 3, 5, 1): 3,
        ("float", "float", 4, 5, 1): 2,
        ("float", "float", 5, 5, 1): 5,
        ("float", "float", 6, 5, 1): 3,
        ("float", "float", 7, 5, 1): 7,
        ("float", "float", 8, 5, 1): 4,
        ("float", "float", 9, 5, 1): 9,
        ("float", "float", 10, 5, 1): 5,
        ("float", "float", 11, 5, 1): 11,
        ("float", "float", 12, 5, 1): 6,
        ("float", "float", 13, 5, 1): 13,
        ("float", "float", 14, 5, 1): 7,
        ("float", "float", 15, 5, 1): 15,
        ("float", "float", 16, 5, 1): 8,
        ("float", "float", 1, 6, 1): 1,
        ("float", "float", 2, 6, 1): 1,
        ("float", "float", 3, 6, 1): 3,
        ("float", "float", 4, 6, 1): 1,
        ("float", "float", 5, 6, 1): 5,
        ("float", "float", 6, 6, 1): 3,
        ("float", "float", 7, 6, 1): 7,
        ("float", "float", 8, 6, 1): 2,
        ("float", "float", 9, 6, 1): 9,
        ("float", "float", 10, 6, 1): 5,
        ("float", "float", 11, 6, 1): 11,
        ("float", "float", 12, 6, 1): 3,
        ("float", "float", 13, 6, 1): 13,
        ("float", "float", 14, 6, 1): 7,
        ("float", "float", 15, 6, 1): 15,
        ("float", "float", 16, 6, 1): 4,
        ("float", "float", 1, 7, 1): 1,
        ("float", "float", 2, 7, 1): 1,
        ("float", "float", 3, 7, 1): 3,
        ("float", "float", 4, 7, 1): 2,
        ("float", "float", 5, 7, 1): 5,
        ("float", "float", 6, 7, 1): 3,
        ("float", "float", 7, 7, 1): 7,
        ("float", "float", 8, 7, 1): 4,
        ("float", "float", 9, 7, 1): 9,
        ("float", "float", 10, 7, 1): 5,
        ("float", "float", 11, 7, 1): 11,
        ("float", "float", 12, 7, 1): 6,
        ("float", "float", 13, 7, 1): 13,
        ("float", "float", 14, 7, 1): 7,
        ("float", "float", 15, 7, 1): 15,
        ("float", "float", 16, 7, 1): 8,
        ("float", "float", 1, 8, 1): 1,
        ("float", "float", 2, 8, 1): 1,
        ("float", "float", 3, 8, 1): 3,
        ("float", "float", 4, 8, 1): 1,
        ("float", "float", 5, 8, 1): 5,
        ("float", "float", 6, 8, 1): 3,
        ("float", "float", 7, 8, 1): 7,
        ("float", "float", 8, 8, 1): 1,
        ("float", "float", 9, 8, 1): 9,
        ("float", "float", 10, 8, 1): 5,
        ("float", "float", 11, 8, 1): 11,
        ("float", "float", 12, 8, 1): 3,
        ("float", "float", 13, 8, 1): 13,
        ("float", "float", 14, 8, 1): 7,
        ("float", "float", 15, 8, 1): 15,
        ("float", "float", 16, 8, 1): 2,
        ("float", "float", 1, 9, 1): 1,
        ("float", "float", 2, 9, 1): 1,
        ("float", "float", 3, 9, 1): 3,
        ("float", "float", 4, 9, 1): 2,
        ("float", "float", 5, 9, 1): 5,
        ("float", "float", 6, 9, 1): 3,
        ("float", "float", 7, 9, 1): 7,
        ("float", "float", 8, 9, 1): 4,
        ("float", "float", 9, 9, 1): 9,
        ("float", "float", 10, 9, 1): 5,
        ("float", "float", 11, 9, 1): 11,
        ("float", "float", 12, 9, 1): 6,
        ("float", "float", 13, 9, 1): 13,
        ("float", "float", 14, 9, 1): 7,
        ("float", "float", 15, 9, 1): 15,
        ("float", "float", 16, 9, 1): 8,
        ("float", "float", 1, 10, 1): 1,
        ("float", "float", 2, 10, 1): 1,
        ("float", "float", 3, 10, 1): 3,
        ("float", "float", 4, 10, 1): 1,
        ("float", "float", 5, 10, 1): 5,
        ("float", "float", 6, 10, 1): 3,
        ("float", "float", 7, 10, 1): 7,
        ("float", "float", 8, 10, 1): 2,
        ("float", "float", 9, 10, 1): 9,
        ("float", "float", 10, 10, 1): 5,
        ("float", "float", 11, 10, 1): 11,
        ("float", "float", 12, 10, 1): 3,
        ("float", "float", 13, 10, 1): 13,
        ("float", "float", 14, 10, 1): 7,
        ("float", "float", 15, 10, 1): 15,
        ("float", "float", 16, 10, 1): 4,
        ("float", "float", 1, 11, 1): 1,
        ("float", "float", 2, 11, 1): 1,
        ("float", "float", 3, 11, 1): 3,
        ("float", "float", 4, 11, 1): 2,
        ("float", "float", 5, 11, 1): 5,
        ("float", "float", 6, 11, 1): 3,
        ("float", "float", 7, 11, 1): 7,
        ("float", "float", 8, 11, 1): 4,
        ("float", "float", 9, 11, 1): 9,
        ("float", "float", 10, 11, 1): 5,
        ("float", "float", 11, 11, 1): 11,
        ("float", "float", 12, 11, 1): 6,
        ("float", "float", 13, 11, 1): 13,
        ("float", "float", 14, 11, 1): 7,
        ("float", "float", 15, 11, 1): 15,
        ("float", "float", 16, 11, 1): 8,
        ("float", "float", 1, 12, 1): 1,
        ("float", "float", 2, 12, 1): 1,
        ("float", "float", 3, 12, 1): 3,
        ("float", "float", 4, 12, 1): 1,
        ("float", "float", 5, 12, 1): 5,
        ("float", "float", 6, 12, 1): 3,
        ("float", "float", 7, 12, 1): 7,
        ("float", "float", 8, 12, 1): 1,
        ("float", "float", 9, 12, 1): 9,
        ("float", "float", 10, 12, 1): 5,
        ("float", "float", 11, 12, 1): 11,
        ("float", "float", 12, 12, 1): 3,
        ("float", "float", 13, 12, 1): 13,
        ("float", "float", 14, 12, 1): 7,
        ("float", "float", 15, 12, 1): 15,
        ("float", "float", 16, 12, 1): 2,
        ("float", "float", 1, 13, 1): 1,
        ("float", "float", 2, 13, 1): 1,
        ("float", "float", 3, 13, 1): 3,
        ("float", "float", 4, 13, 1): 2,
        ("float", "float", 5, 13, 1): 5,
        ("float", "float", 6, 13, 1): 3,
        ("float", "float", 7, 13, 1): 7,
        ("float", "float", 8, 13, 1): 4,
        ("float", "float", 9, 13, 1): 9,
        ("float", "float", 10, 13, 1): 5,
        ("float", "float", 11, 13, 1): 11,
        ("float", "float", 12, 13, 1): 6,
        ("float", "float", 13, 13, 1): 13,
        ("float", "float", 14, 13, 1): 7,
        ("float", "float", 15, 13, 1): 15,
        ("float", "float", 16, 13, 1): 8,
        ("float", "float", 1, 14, 1): 1,
        ("float", "float", 2, 14, 1): 1,
        ("float", "float", 3, 14, 1): 3,
        ("float", "float", 4, 14, 1): 1,
        ("float", "float", 5, 14, 1): 5,
        ("float", "float", 6, 14, 1): 3,
        ("float", "float", 7, 14, 1): 7,
        ("float", "float", 8, 14, 1): 2,
        ("float", "float", 9, 14, 1): 9,
        ("float", "float", 10, 14, 1): 5,
        ("float", "float", 11, 14, 1): 11,
        ("float", "float", 12, 14, 1): 3,
        ("float", "float", 13, 14, 1): 13,
        ("float", "float", 14, 14, 1): 7,
        ("float", "float", 15, 14, 1): 15,
        ("float", "float", 16, 14, 1): 4,
        ("float", "float", 1, 15, 1): 1,
        ("float", "float", 2, 15, 1): 1,
        ("float", "float", 3, 15, 1): 3,
        ("float", "float", 4, 15, 1): 2,
        ("float", "float", 5, 15, 1): 5,
        ("float", "float", 6, 15, 1): 3,
        ("float", "float", 7, 15, 1): 7,
        ("float", "float", 8, 15, 1): 4,
        ("float", "float", 9, 15, 1): 9,
        ("float", "float", 10, 15, 1): 5,
        ("float", "float", 11, 15, 1): 11,
        ("float", "float", 12, 15, 1): 6,
        ("float", "float", 13, 15, 1): 13,
        ("float", "float", 14, 15, 1): 7,
        ("float", "float", 15, 15, 1): 15,
        ("float", "float", 16, 15, 1): 8,
        ("float", "float", 1, 16, 1): 1,
        ("float", "float", 2, 16, 1): 1,
        ("float", "float", 3, 16, 1): 3,
        ("float", "float", 4, 16, 1): 1,
        ("float", "float", 5, 16, 1): 5,
        ("float", "float", 6, 16, 1): 3,
        ("float", "float", 7, 16, 1): 7,
        ("float", "float", 8, 16, 1): 1,
        ("float", "float", 9, 16, 1): 9,
        ("float", "float", 10, 16, 1): 5,
        ("float", "float", 11, 16, 1): 11,
        ("float", "float", 12, 16, 1): 3,
        ("float", "float", 13, 16, 1): 13,
        ("float", "float", 14, 16, 1): 7,
        ("float", "float", 15, 16, 1): 15,
        ("float", "float", 16, 16, 1): 2,
        ("cfloat", "float", 1, 1, 0): 1,
        ("cfloat", "float", 2, 1, 0): 1,
        ("cfloat", "float", 3, 1, 0): 3,
        ("cfloat", "float", 4, 1, 0): 1,
        ("cfloat", "float", 5, 1, 0): 5,
        ("cfloat", "float", 6, 1, 0): 3,
        ("cfloat", "float", 7, 1, 0): 7,
        ("cfloat", "float", 8, 1, 0): 1,
        ("cfloat", "float", 9, 1, 0): 9,
        ("cfloat", "float", 10, 1, 0): 5,
        ("cfloat", "float", 11, 1, 0): 11,
        ("cfloat", "float", 12, 1, 0): 3,
        ("cfloat", "float", 13, 1, 0): 13,
        ("cfloat", "float", 14, 1, 0): 7,
        ("cfloat", "float", 15, 1, 0): 15,
        ("cfloat", "float", 16, 1, 0): 2,
        ("cfloat", "float", 1, 2, 0): 1,
        ("cfloat", "float", 2, 2, 0): 1,
        ("cfloat", "float", 3, 2, 0): 3,
        ("cfloat", "float", 4, 2, 0): 1,
        ("cfloat", "float", 5, 2, 0): 5,
        ("cfloat", "float", 6, 2, 0): 3,
        ("cfloat", "float", 7, 2, 0): 7,
        ("cfloat", "float", 8, 2, 0): 1,
        ("cfloat", "float", 9, 2, 0): 9,
        ("cfloat", "float", 10, 2, 0): 5,
        ("cfloat", "float", 11, 2, 0): 11,
        ("cfloat", "float", 12, 2, 0): 3,
        ("cfloat", "float", 13, 2, 0): 13,
        ("cfloat", "float", 14, 2, 0): 7,
        ("cfloat", "float", 15, 2, 0): 15,
        ("cfloat", "float", 16, 2, 0): 1,
        ("cfloat", "float", 1, 3, 0): 1,
        ("cfloat", "float", 2, 3, 0): 1,
        ("cfloat", "float", 3, 3, 0): 3,
        ("cfloat", "float", 4, 3, 0): 1,
        ("cfloat", "float", 5, 3, 0): 5,
        ("cfloat", "float", 6, 3, 0): 3,
        ("cfloat", "float", 7, 3, 0): 7,
        ("cfloat", "float", 8, 3, 0): 1,
        ("cfloat", "float", 9, 3, 0): 9,
        ("cfloat", "float", 10, 3, 0): 5,
        ("cfloat", "float", 11, 3, 0): 11,
        ("cfloat", "float", 12, 3, 0): 3,
        ("cfloat", "float", 13, 3, 0): 13,
        ("cfloat", "float", 14, 3, 0): 7,
        ("cfloat", "float", 15, 3, 0): 15,
        ("cfloat", "float", 16, 3, 0): 2,
        ("cfloat", "float", 1, 4, 0): 1,
        ("cfloat", "float", 2, 4, 0): 1,
        ("cfloat", "float", 3, 4, 0): 3,
        ("cfloat", "float", 4, 4, 0): 1,
        ("cfloat", "float", 5, 4, 0): 5,
        ("cfloat", "float", 6, 4, 0): 3,
        ("cfloat", "float", 7, 4, 0): 7,
        ("cfloat", "float", 8, 4, 0): 1,
        ("cfloat", "float", 9, 4, 0): 9,
        ("cfloat", "float", 10, 4, 0): 5,
        ("cfloat", "float", 11, 4, 0): 11,
        ("cfloat", "float", 12, 4, 0): 3,
        ("cfloat", "float", 13, 4, 0): 13,
        ("cfloat", "float", 14, 4, 0): 7,
        ("cfloat", "float", 15, 4, 0): 15,
        ("cfloat", "float", 16, 4, 0): 1,
        ("cfloat", "float", 1, 5, 0): 1,
        ("cfloat", "float", 2, 5, 0): 1,
        ("cfloat", "float", 3, 5, 0): 3,
        ("cfloat", "float", 4, 5, 0): 1,
        ("cfloat", "float", 5, 5, 0): 5,
        ("cfloat", "float", 6, 5, 0): 3,
        ("cfloat", "float", 7, 5, 0): 7,
        ("cfloat", "float", 8, 5, 0): 1,
        ("cfloat", "float", 9, 5, 0): 9,
        ("cfloat", "float", 10, 5, 0): 5,
        ("cfloat", "float", 11, 5, 0): 11,
        ("cfloat", "float", 12, 5, 0): 3,
        ("cfloat", "float", 13, 5, 0): 13,
        ("cfloat", "float", 14, 5, 0): 7,
        ("cfloat", "float", 15, 5, 0): 15,
        ("cfloat", "float", 16, 5, 0): 2,
        ("cfloat", "float", 1, 6, 0): 1,
        ("cfloat", "float", 2, 6, 0): 1,
        ("cfloat", "float", 3, 6, 0): 3,
        ("cfloat", "float", 4, 6, 0): 1,
        ("cfloat", "float", 5, 6, 0): 5,
        ("cfloat", "float", 6, 6, 0): 3,
        ("cfloat", "float", 7, 6, 0): 7,
        ("cfloat", "float", 8, 6, 0): 1,
        ("cfloat", "float", 9, 6, 0): 9,
        ("cfloat", "float", 10, 6, 0): 5,
        ("cfloat", "float", 11, 6, 0): 11,
        ("cfloat", "float", 12, 6, 0): 3,
        ("cfloat", "float", 13, 6, 0): 13,
        ("cfloat", "float", 14, 6, 0): 7,
        ("cfloat", "float", 15, 6, 0): 15,
        ("cfloat", "float", 16, 6, 0): 1,
        ("cfloat", "float", 1, 7, 0): 1,
        ("cfloat", "float", 2, 7, 0): 1,
        ("cfloat", "float", 3, 7, 0): 3,
        ("cfloat", "float", 4, 7, 0): 1,
        ("cfloat", "float", 5, 7, 0): 5,
        ("cfloat", "float", 6, 7, 0): 3,
        ("cfloat", "float", 7, 7, 0): 7,
        ("cfloat", "float", 8, 7, 0): 1,
        ("cfloat", "float", 9, 7, 0): 9,
        ("cfloat", "float", 10, 7, 0): 5,
        ("cfloat", "float", 11, 7, 0): 11,
        ("cfloat", "float", 12, 7, 0): 3,
        ("cfloat", "float", 13, 7, 0): 13,
        ("cfloat", "float", 14, 7, 0): 7,
        ("cfloat", "float", 15, 7, 0): 15,
        ("cfloat", "float", 16, 7, 0): 2,
        ("cfloat", "float", 1, 8, 0): 1,
        ("cfloat", "float", 2, 8, 0): 1,
        ("cfloat", "float", 3, 8, 0): 3,
        ("cfloat", "float", 4, 8, 0): 1,
        ("cfloat", "float", 5, 8, 0): 5,
        ("cfloat", "float", 6, 8, 0): 3,
        ("cfloat", "float", 7, 8, 0): 7,
        ("cfloat", "float", 8, 8, 0): 1,
        ("cfloat", "float", 9, 8, 0): 9,
        ("cfloat", "float", 10, 8, 0): 5,
        ("cfloat", "float", 11, 8, 0): 11,
        ("cfloat", "float", 12, 8, 0): 3,
        ("cfloat", "float", 13, 8, 0): 13,
        ("cfloat", "float", 14, 8, 0): 7,
        ("cfloat", "float", 15, 8, 0): 15,
        ("cfloat", "float", 16, 8, 0): 1,
        ("cfloat", "float", 1, 9, 0): 1,
        ("cfloat", "float", 2, 9, 0): 1,
        ("cfloat", "float", 3, 9, 0): 3,
        ("cfloat", "float", 4, 9, 0): 1,
        ("cfloat", "float", 5, 9, 0): 5,
        ("cfloat", "float", 6, 9, 0): 3,
        ("cfloat", "float", 7, 9, 0): 7,
        ("cfloat", "float", 8, 9, 0): 1,
        ("cfloat", "float", 9, 9, 0): 9,
        ("cfloat", "float", 10, 9, 0): 5,
        ("cfloat", "float", 11, 9, 0): 11,
        ("cfloat", "float", 12, 9, 0): 3,
        ("cfloat", "float", 13, 9, 0): 13,
        ("cfloat", "float", 14, 9, 0): 7,
        ("cfloat", "float", 15, 9, 0): 15,
        ("cfloat", "float", 16, 9, 0): 2,
        ("cfloat", "float", 1, 10, 0): 1,
        ("cfloat", "float", 2, 10, 0): 1,
        ("cfloat", "float", 3, 10, 0): 3,
        ("cfloat", "float", 4, 10, 0): 1,
        ("cfloat", "float", 5, 10, 0): 5,
        ("cfloat", "float", 6, 10, 0): 3,
        ("cfloat", "float", 7, 10, 0): 7,
        ("cfloat", "float", 8, 10, 0): 1,
        ("cfloat", "float", 9, 10, 0): 9,
        ("cfloat", "float", 10, 10, 0): 5,
        ("cfloat", "float", 11, 10, 0): 11,
        ("cfloat", "float", 12, 10, 0): 3,
        ("cfloat", "float", 13, 10, 0): 13,
        ("cfloat", "float", 14, 10, 0): 7,
        ("cfloat", "float", 15, 10, 0): 15,
        ("cfloat", "float", 16, 10, 0): 1,
        ("cfloat", "float", 1, 11, 0): 1,
        ("cfloat", "float", 2, 11, 0): 1,
        ("cfloat", "float", 3, 11, 0): 3,
        ("cfloat", "float", 4, 11, 0): 1,
        ("cfloat", "float", 5, 11, 0): 5,
        ("cfloat", "float", 6, 11, 0): 3,
        ("cfloat", "float", 7, 11, 0): 7,
        ("cfloat", "float", 8, 11, 0): 1,
        ("cfloat", "float", 9, 11, 0): 9,
        ("cfloat", "float", 10, 11, 0): 5,
        ("cfloat", "float", 11, 11, 0): 11,
        ("cfloat", "float", 12, 11, 0): 3,
        ("cfloat", "float", 13, 11, 0): 13,
        ("cfloat", "float", 14, 11, 0): 7,
        ("cfloat", "float", 15, 11, 0): 15,
        ("cfloat", "float", 16, 11, 0): 2,
        ("cfloat", "float", 1, 12, 0): 1,
        ("cfloat", "float", 2, 12, 0): 1,
        ("cfloat", "float", 3, 12, 0): 3,
        ("cfloat", "float", 4, 12, 0): 1,
        ("cfloat", "float", 5, 12, 0): 5,
        ("cfloat", "float", 6, 12, 0): 3,
        ("cfloat", "float", 7, 12, 0): 7,
        ("cfloat", "float", 8, 12, 0): 1,
        ("cfloat", "float", 9, 12, 0): 9,
        ("cfloat", "float", 10, 12, 0): 5,
        ("cfloat", "float", 11, 12, 0): 11,
        ("cfloat", "float", 12, 12, 0): 3,
        ("cfloat", "float", 13, 12, 0): 13,
        ("cfloat", "float", 14, 12, 0): 7,
        ("cfloat", "float", 15, 12, 0): 15,
        ("cfloat", "float", 16, 12, 0): 1,
        ("cfloat", "float", 1, 13, 0): 1,
        ("cfloat", "float", 2, 13, 0): 1,
        ("cfloat", "float", 3, 13, 0): 3,
        ("cfloat", "float", 4, 13, 0): 1,
        ("cfloat", "float", 5, 13, 0): 5,
        ("cfloat", "float", 6, 13, 0): 3,
        ("cfloat", "float", 7, 13, 0): 7,
        ("cfloat", "float", 8, 13, 0): 1,
        ("cfloat", "float", 9, 13, 0): 9,
        ("cfloat", "float", 10, 13, 0): 5,
        ("cfloat", "float", 11, 13, 0): 11,
        ("cfloat", "float", 12, 13, 0): 3,
        ("cfloat", "float", 13, 13, 0): 13,
        ("cfloat", "float", 14, 13, 0): 7,
        ("cfloat", "float", 15, 13, 0): 15,
        ("cfloat", "float", 16, 13, 0): 2,
        ("cfloat", "float", 1, 14, 0): 1,
        ("cfloat", "float", 2, 14, 0): 1,
        ("cfloat", "float", 3, 14, 0): 3,
        ("cfloat", "float", 4, 14, 0): 1,
        ("cfloat", "float", 5, 14, 0): 5,
        ("cfloat", "float", 6, 14, 0): 3,
        ("cfloat", "float", 7, 14, 0): 7,
        ("cfloat", "float", 8, 14, 0): 1,
        ("cfloat", "float", 9, 14, 0): 9,
        ("cfloat", "float", 10, 14, 0): 5,
        ("cfloat", "float", 11, 14, 0): 11,
        ("cfloat", "float", 12, 14, 0): 3,
        ("cfloat", "float", 13, 14, 0): 13,
        ("cfloat", "float", 14, 14, 0): 7,
        ("cfloat", "float", 15, 14, 0): 15,
        ("cfloat", "float", 16, 14, 0): 1,
        ("cfloat", "float", 1, 15, 0): 1,
        ("cfloat", "float", 2, 15, 0): 1,
        ("cfloat", "float", 3, 15, 0): 3,
        ("cfloat", "float", 4, 15, 0): 1,
        ("cfloat", "float", 5, 15, 0): 5,
        ("cfloat", "float", 6, 15, 0): 3,
        ("cfloat", "float", 7, 15, 0): 7,
        ("cfloat", "float", 8, 15, 0): 1,
        ("cfloat", "float", 9, 15, 0): 9,
        ("cfloat", "float", 10, 15, 0): 5,
        ("cfloat", "float", 11, 15, 0): 11,
        ("cfloat", "float", 12, 15, 0): 3,
        ("cfloat", "float", 13, 15, 0): 13,
        ("cfloat", "float", 14, 15, 0): 7,
        ("cfloat", "float", 15, 15, 0): 15,
        ("cfloat", "float", 16, 15, 0): 2,
        ("cfloat", "float", 1, 16, 0): 1,
        ("cfloat", "float", 2, 16, 0): 1,
        ("cfloat", "float", 3, 16, 0): 3,
        ("cfloat", "float", 4, 16, 0): 1,
        ("cfloat", "float", 5, 16, 0): 5,
        ("cfloat", "float", 6, 16, 0): 3,
        ("cfloat", "float", 7, 16, 0): 7,
        ("cfloat", "float", 8, 16, 0): 1,
        ("cfloat", "float", 9, 16, 0): 9,
        ("cfloat", "float", 10, 16, 0): 5,
        ("cfloat", "float", 11, 16, 0): 11,
        ("cfloat", "float", 12, 16, 0): 3,
        ("cfloat", "float", 13, 16, 0): 13,
        ("cfloat", "float", 14, 16, 0): 7,
        ("cfloat", "float", 15, 16, 0): 15,
        ("cfloat", "float", 16, 16, 0): 1,
        ("cfloat", "float", 1, 1, 1): 1,
        ("cfloat", "float", 2, 1, 1): 1,
        ("cfloat", "float", 3, 1, 1): 3,
        ("cfloat", "float", 4, 1, 1): 1,
        ("cfloat", "float", 5, 1, 1): 5,
        ("cfloat", "float", 6, 1, 1): 3,
        ("cfloat", "float", 7, 1, 1): 7,
        ("cfloat", "float", 8, 1, 1): 2,
        ("cfloat", "float", 9, 1, 1): 9,
        ("cfloat", "float", 10, 1, 1): 5,
        ("cfloat", "float", 11, 1, 1): 11,
        ("cfloat", "float", 12, 1, 1): 3,
        ("cfloat", "float", 13, 1, 1): 13,
        ("cfloat", "float", 14, 1, 1): 7,
        ("cfloat", "float", 15, 1, 1): 15,
        ("cfloat", "float", 16, 1, 1): 4,
        ("cfloat", "float", 1, 2, 1): 1,
        ("cfloat", "float", 2, 2, 1): 1,
        ("cfloat", "float", 3, 2, 1): 3,
        ("cfloat", "float", 4, 2, 1): 1,
        ("cfloat", "float", 5, 2, 1): 5,
        ("cfloat", "float", 6, 2, 1): 3,
        ("cfloat", "float", 7, 2, 1): 7,
        ("cfloat", "float", 8, 2, 1): 1,
        ("cfloat", "float", 9, 2, 1): 9,
        ("cfloat", "float", 10, 2, 1): 5,
        ("cfloat", "float", 11, 2, 1): 11,
        ("cfloat", "float", 12, 2, 1): 3,
        ("cfloat", "float", 13, 2, 1): 13,
        ("cfloat", "float", 14, 2, 1): 7,
        ("cfloat", "float", 15, 2, 1): 15,
        ("cfloat", "float", 16, 2, 1): 2,
        ("cfloat", "float", 1, 3, 1): 1,
        ("cfloat", "float", 2, 3, 1): 1,
        ("cfloat", "float", 3, 3, 1): 3,
        ("cfloat", "float", 4, 3, 1): 1,
        ("cfloat", "float", 5, 3, 1): 5,
        ("cfloat", "float", 6, 3, 1): 3,
        ("cfloat", "float", 7, 3, 1): 7,
        ("cfloat", "float", 8, 3, 1): 2,
        ("cfloat", "float", 9, 3, 1): 9,
        ("cfloat", "float", 10, 3, 1): 5,
        ("cfloat", "float", 11, 3, 1): 11,
        ("cfloat", "float", 12, 3, 1): 3,
        ("cfloat", "float", 13, 3, 1): 13,
        ("cfloat", "float", 14, 3, 1): 7,
        ("cfloat", "float", 15, 3, 1): 15,
        ("cfloat", "float", 16, 3, 1): 4,
        ("cfloat", "float", 1, 4, 1): 1,
        ("cfloat", "float", 2, 4, 1): 1,
        ("cfloat", "float", 3, 4, 1): 3,
        ("cfloat", "float", 4, 4, 1): 1,
        ("cfloat", "float", 5, 4, 1): 5,
        ("cfloat", "float", 6, 4, 1): 3,
        ("cfloat", "float", 7, 4, 1): 7,
        ("cfloat", "float", 8, 4, 1): 1,
        ("cfloat", "float", 9, 4, 1): 9,
        ("cfloat", "float", 10, 4, 1): 5,
        ("cfloat", "float", 11, 4, 1): 11,
        ("cfloat", "float", 12, 4, 1): 3,
        ("cfloat", "float", 13, 4, 1): 13,
        ("cfloat", "float", 14, 4, 1): 7,
        ("cfloat", "float", 15, 4, 1): 15,
        ("cfloat", "float", 16, 4, 1): 2,
        ("cfloat", "float", 1, 5, 1): 1,
        ("cfloat", "float", 2, 5, 1): 1,
        ("cfloat", "float", 3, 5, 1): 3,
        ("cfloat", "float", 4, 5, 1): 1,
        ("cfloat", "float", 5, 5, 1): 5,
        ("cfloat", "float", 6, 5, 1): 3,
        ("cfloat", "float", 7, 5, 1): 7,
        ("cfloat", "float", 8, 5, 1): 2,
        ("cfloat", "float", 9, 5, 1): 9,
        ("cfloat", "float", 10, 5, 1): 5,
        ("cfloat", "float", 11, 5, 1): 11,
        ("cfloat", "float", 12, 5, 1): 3,
        ("cfloat", "float", 13, 5, 1): 13,
        ("cfloat", "float", 14, 5, 1): 7,
        ("cfloat", "float", 15, 5, 1): 15,
        ("cfloat", "float", 16, 5, 1): 4,
        ("cfloat", "float", 1, 6, 1): 1,
        ("cfloat", "float", 2, 6, 1): 1,
        ("cfloat", "float", 3, 6, 1): 3,
        ("cfloat", "float", 4, 6, 1): 1,
        ("cfloat", "float", 5, 6, 1): 5,
        ("cfloat", "float", 6, 6, 1): 3,
        ("cfloat", "float", 7, 6, 1): 7,
        ("cfloat", "float", 8, 6, 1): 1,
        ("cfloat", "float", 9, 6, 1): 9,
        ("cfloat", "float", 10, 6, 1): 5,
        ("cfloat", "float", 11, 6, 1): 11,
        ("cfloat", "float", 12, 6, 1): 3,
        ("cfloat", "float", 13, 6, 1): 13,
        ("cfloat", "float", 14, 6, 1): 7,
        ("cfloat", "float", 15, 6, 1): 15,
        ("cfloat", "float", 16, 6, 1): 2,
        ("cfloat", "float", 1, 7, 1): 1,
        ("cfloat", "float", 2, 7, 1): 1,
        ("cfloat", "float", 3, 7, 1): 3,
        ("cfloat", "float", 4, 7, 1): 1,
        ("cfloat", "float", 5, 7, 1): 5,
        ("cfloat", "float", 6, 7, 1): 3,
        ("cfloat", "float", 7, 7, 1): 7,
        ("cfloat", "float", 8, 7, 1): 2,
        ("cfloat", "float", 9, 7, 1): 9,
        ("cfloat", "float", 10, 7, 1): 5,
        ("cfloat", "float", 11, 7, 1): 11,
        ("cfloat", "float", 12, 7, 1): 3,
        ("cfloat", "float", 13, 7, 1): 13,
        ("cfloat", "float", 14, 7, 1): 7,
        ("cfloat", "float", 15, 7, 1): 15,
        ("cfloat", "float", 16, 7, 1): 4,
        ("cfloat", "float", 1, 8, 1): 1,
        ("cfloat", "float", 2, 8, 1): 1,
        ("cfloat", "float", 3, 8, 1): 3,
        ("cfloat", "float", 4, 8, 1): 1,
        ("cfloat", "float", 5, 8, 1): 5,
        ("cfloat", "float", 6, 8, 1): 3,
        ("cfloat", "float", 7, 8, 1): 7,
        ("cfloat", "float", 8, 8, 1): 1,
        ("cfloat", "float", 9, 8, 1): 9,
        ("cfloat", "float", 10, 8, 1): 5,
        ("cfloat", "float", 11, 8, 1): 11,
        ("cfloat", "float", 12, 8, 1): 3,
        ("cfloat", "float", 13, 8, 1): 13,
        ("cfloat", "float", 14, 8, 1): 7,
        ("cfloat", "float", 15, 8, 1): 15,
        ("cfloat", "float", 16, 8, 1): 2,
        ("cfloat", "float", 1, 9, 1): 1,
        ("cfloat", "float", 2, 9, 1): 1,
        ("cfloat", "float", 3, 9, 1): 3,
        ("cfloat", "float", 4, 9, 1): 1,
        ("cfloat", "float", 5, 9, 1): 5,
        ("cfloat", "float", 6, 9, 1): 3,
        ("cfloat", "float", 7, 9, 1): 7,
        ("cfloat", "float", 8, 9, 1): 2,
        ("cfloat", "float", 9, 9, 1): 9,
        ("cfloat", "float", 10, 9, 1): 5,
        ("cfloat", "float", 11, 9, 1): 11,
        ("cfloat", "float", 12, 9, 1): 3,
        ("cfloat", "float", 13, 9, 1): 13,
        ("cfloat", "float", 14, 9, 1): 7,
        ("cfloat", "float", 15, 9, 1): 15,
        ("cfloat", "float", 16, 9, 1): 4,
        ("cfloat", "float", 1, 10, 1): 1,
        ("cfloat", "float", 2, 10, 1): 1,
        ("cfloat", "float", 3, 10, 1): 3,
        ("cfloat", "float", 4, 10, 1): 1,
        ("cfloat", "float", 5, 10, 1): 5,
        ("cfloat", "float", 6, 10, 1): 3,
        ("cfloat", "float", 7, 10, 1): 7,
        ("cfloat", "float", 8, 10, 1): 1,
        ("cfloat", "float", 9, 10, 1): 9,
        ("cfloat", "float", 10, 10, 1): 5,
        ("cfloat", "float", 11, 10, 1): 11,
        ("cfloat", "float", 12, 10, 1): 3,
        ("cfloat", "float", 13, 10, 1): 13,
        ("cfloat", "float", 14, 10, 1): 7,
        ("cfloat", "float", 15, 10, 1): 15,
        ("cfloat", "float", 16, 10, 1): 2,
        ("cfloat", "float", 1, 11, 1): 1,
        ("cfloat", "float", 2, 11, 1): 1,
        ("cfloat", "float", 3, 11, 1): 3,
        ("cfloat", "float", 4, 11, 1): 1,
        ("cfloat", "float", 5, 11, 1): 5,
        ("cfloat", "float", 6, 11, 1): 3,
        ("cfloat", "float", 7, 11, 1): 7,
        ("cfloat", "float", 8, 11, 1): 2,
        ("cfloat", "float", 9, 11, 1): 9,
        ("cfloat", "float", 10, 11, 1): 5,
        ("cfloat", "float", 11, 11, 1): 11,
        ("cfloat", "float", 12, 11, 1): 3,
        ("cfloat", "float", 13, 11, 1): 13,
        ("cfloat", "float", 14, 11, 1): 7,
        ("cfloat", "float", 15, 11, 1): 15,
        ("cfloat", "float", 16, 11, 1): 4,
        ("cfloat", "float", 1, 12, 1): 1,
        ("cfloat", "float", 2, 12, 1): 1,
        ("cfloat", "float", 3, 12, 1): 3,
        ("cfloat", "float", 4, 12, 1): 1,
        ("cfloat", "float", 5, 12, 1): 5,
        ("cfloat", "float", 6, 12, 1): 3,
        ("cfloat", "float", 7, 12, 1): 7,
        ("cfloat", "float", 8, 12, 1): 1,
        ("cfloat", "float", 9, 12, 1): 9,
        ("cfloat", "float", 10, 12, 1): 5,
        ("cfloat", "float", 11, 12, 1): 11,
        ("cfloat", "float", 12, 12, 1): 3,
        ("cfloat", "float", 13, 12, 1): 13,
        ("cfloat", "float", 14, 12, 1): 7,
        ("cfloat", "float", 15, 12, 1): 15,
        ("cfloat", "float", 16, 12, 1): 2,
        ("cfloat", "float", 1, 13, 1): 1,
        ("cfloat", "float", 2, 13, 1): 1,
        ("cfloat", "float", 3, 13, 1): 3,
        ("cfloat", "float", 4, 13, 1): 1,
        ("cfloat", "float", 5, 13, 1): 5,
        ("cfloat", "float", 6, 13, 1): 3,
        ("cfloat", "float", 7, 13, 1): 7,
        ("cfloat", "float", 8, 13, 1): 2,
        ("cfloat", "float", 9, 13, 1): 9,
        ("cfloat", "float", 10, 13, 1): 5,
        ("cfloat", "float", 11, 13, 1): 11,
        ("cfloat", "float", 12, 13, 1): 3,
        ("cfloat", "float", 13, 13, 1): 13,
        ("cfloat", "float", 14, 13, 1): 7,
        ("cfloat", "float", 15, 13, 1): 15,
        ("cfloat", "float", 16, 13, 1): 4,
        ("cfloat", "float", 1, 14, 1): 1,
        ("cfloat", "float", 2, 14, 1): 1,
        ("cfloat", "float", 3, 14, 1): 3,
        ("cfloat", "float", 4, 14, 1): 1,
        ("cfloat", "float", 5, 14, 1): 5,
        ("cfloat", "float", 6, 14, 1): 3,
        ("cfloat", "float", 7, 14, 1): 7,
        ("cfloat", "float", 8, 14, 1): 1,
        ("cfloat", "float", 9, 14, 1): 9,
        ("cfloat", "float", 10, 14, 1): 5,
        ("cfloat", "float", 11, 14, 1): 11,
        ("cfloat", "float", 12, 14, 1): 3,
        ("cfloat", "float", 13, 14, 1): 13,
        ("cfloat", "float", 14, 14, 1): 7,
        ("cfloat", "float", 15, 14, 1): 15,
        ("cfloat", "float", 16, 14, 1): 2,
        ("cfloat", "float", 1, 15, 1): 1,
        ("cfloat", "float", 2, 15, 1): 1,
        ("cfloat", "float", 3, 15, 1): 3,
        ("cfloat", "float", 4, 15, 1): 1,
        ("cfloat", "float", 5, 15, 1): 5,
        ("cfloat", "float", 6, 15, 1): 3,
        ("cfloat", "float", 7, 15, 1): 7,
        ("cfloat", "float", 8, 15, 1): 2,
        ("cfloat", "float", 9, 15, 1): 9,
        ("cfloat", "float", 10, 15, 1): 5,
        ("cfloat", "float", 11, 15, 1): 11,
        ("cfloat", "float", 12, 15, 1): 3,
        ("cfloat", "float", 13, 15, 1): 13,
        ("cfloat", "float", 14, 15, 1): 7,
        ("cfloat", "float", 15, 15, 1): 15,
        ("cfloat", "float", 16, 15, 1): 4,
        ("cfloat", "float", 1, 16, 1): 1,
        ("cfloat", "float", 2, 16, 1): 1,
        ("cfloat", "float", 3, 16, 1): 3,
        ("cfloat", "float", 4, 16, 1): 1,
        ("cfloat", "float", 5, 16, 1): 5,
        ("cfloat", "float", 6, 16, 1): 3,
        ("cfloat", "float", 7, 16, 1): 7,
        ("cfloat", "float", 8, 16, 1): 1,
        ("cfloat", "float", 9, 16, 1): 9,
        ("cfloat", "float", 10, 16, 1): 5,
        ("cfloat", "float", 11, 16, 1): 11,
        ("cfloat", "float", 12, 16, 1): 3,
        ("cfloat", "float", 13, 16, 1): 13,
        ("cfloat", "float", 14, 16, 1): 7,
        ("cfloat", "float", 15, 16, 1): 15,
        ("cfloat", "float", 16, 16, 1): 2,
        ("cfloat", "cfloat", 1, 1, 0): 1,
        ("cfloat", "cfloat", 2, 1, 0): 1,
        ("cfloat", "cfloat", 3, 1, 0): 3,
        ("cfloat", "cfloat", 4, 1, 0): 1,
        ("cfloat", "cfloat", 5, 1, 0): 5,
        ("cfloat", "cfloat", 6, 1, 0): 3,
        ("cfloat", "cfloat", 7, 1, 0): 7,
        ("cfloat", "cfloat", 8, 1, 0): 1,
        ("cfloat", "cfloat", 9, 1, 0): 9,
        ("cfloat", "cfloat", 10, 1, 0): 5,
        ("cfloat", "cfloat", 11, 1, 0): 11,
        ("cfloat", "cfloat", 12, 1, 0): 3,
        ("cfloat", "cfloat", 13, 1, 0): 13,
        ("cfloat", "cfloat", 14, 1, 0): 7,
        ("cfloat", "cfloat", 15, 1, 0): 15,
        ("cfloat", "cfloat", 16, 1, 0): 2,
        ("cfloat", "cfloat", 1, 2, 0): 1,
        ("cfloat", "cfloat", 2, 2, 0): 1,
        ("cfloat", "cfloat", 3, 2, 0): 3,
        ("cfloat", "cfloat", 4, 2, 0): 1,
        ("cfloat", "cfloat", 5, 2, 0): 5,
        ("cfloat", "cfloat", 6, 2, 0): 3,
        ("cfloat", "cfloat", 7, 2, 0): 7,
        ("cfloat", "cfloat", 8, 2, 0): 1,
        ("cfloat", "cfloat", 9, 2, 0): 9,
        ("cfloat", "cfloat", 10, 2, 0): 5,
        ("cfloat", "cfloat", 11, 2, 0): 11,
        ("cfloat", "cfloat", 12, 2, 0): 3,
        ("cfloat", "cfloat", 13, 2, 0): 13,
        ("cfloat", "cfloat", 14, 2, 0): 7,
        ("cfloat", "cfloat", 15, 2, 0): 15,
        ("cfloat", "cfloat", 16, 2, 0): 1,
        ("cfloat", "cfloat", 1, 3, 0): 1,
        ("cfloat", "cfloat", 2, 3, 0): 1,
        ("cfloat", "cfloat", 3, 3, 0): 3,
        ("cfloat", "cfloat", 4, 3, 0): 1,
        ("cfloat", "cfloat", 5, 3, 0): 5,
        ("cfloat", "cfloat", 6, 3, 0): 3,
        ("cfloat", "cfloat", 7, 3, 0): 7,
        ("cfloat", "cfloat", 8, 3, 0): 1,
        ("cfloat", "cfloat", 9, 3, 0): 9,
        ("cfloat", "cfloat", 10, 3, 0): 5,
        ("cfloat", "cfloat", 11, 3, 0): 11,
        ("cfloat", "cfloat", 12, 3, 0): 3,
        ("cfloat", "cfloat", 13, 3, 0): 13,
        ("cfloat", "cfloat", 14, 3, 0): 7,
        ("cfloat", "cfloat", 15, 3, 0): 15,
        ("cfloat", "cfloat", 16, 3, 0): 2,
        ("cfloat", "cfloat", 1, 4, 0): 1,
        ("cfloat", "cfloat", 2, 4, 0): 1,
        ("cfloat", "cfloat", 3, 4, 0): 3,
        ("cfloat", "cfloat", 4, 4, 0): 1,
        ("cfloat", "cfloat", 5, 4, 0): 5,
        ("cfloat", "cfloat", 6, 4, 0): 3,
        ("cfloat", "cfloat", 7, 4, 0): 7,
        ("cfloat", "cfloat", 8, 4, 0): 1,
        ("cfloat", "cfloat", 9, 4, 0): 9,
        ("cfloat", "cfloat", 10, 4, 0): 5,
        ("cfloat", "cfloat", 11, 4, 0): 11,
        ("cfloat", "cfloat", 12, 4, 0): 3,
        ("cfloat", "cfloat", 13, 4, 0): 13,
        ("cfloat", "cfloat", 14, 4, 0): 7,
        ("cfloat", "cfloat", 15, 4, 0): 15,
        ("cfloat", "cfloat", 16, 4, 0): 1,
        ("cfloat", "cfloat", 1, 5, 0): 1,
        ("cfloat", "cfloat", 2, 5, 0): 1,
        ("cfloat", "cfloat", 3, 5, 0): 3,
        ("cfloat", "cfloat", 4, 5, 0): 1,
        ("cfloat", "cfloat", 5, 5, 0): 5,
        ("cfloat", "cfloat", 6, 5, 0): 3,
        ("cfloat", "cfloat", 7, 5, 0): 7,
        ("cfloat", "cfloat", 8, 5, 0): 1,
        ("cfloat", "cfloat", 9, 5, 0): 9,
        ("cfloat", "cfloat", 10, 5, 0): 5,
        ("cfloat", "cfloat", 11, 5, 0): 11,
        ("cfloat", "cfloat", 12, 5, 0): 3,
        ("cfloat", "cfloat", 13, 5, 0): 13,
        ("cfloat", "cfloat", 14, 5, 0): 7,
        ("cfloat", "cfloat", 15, 5, 0): 15,
        ("cfloat", "cfloat", 16, 5, 0): 2,
        ("cfloat", "cfloat", 1, 6, 0): 1,
        ("cfloat", "cfloat", 2, 6, 0): 1,
        ("cfloat", "cfloat", 3, 6, 0): 3,
        ("cfloat", "cfloat", 4, 6, 0): 1,
        ("cfloat", "cfloat", 5, 6, 0): 5,
        ("cfloat", "cfloat", 6, 6, 0): 3,
        ("cfloat", "cfloat", 7, 6, 0): 7,
        ("cfloat", "cfloat", 8, 6, 0): 1,
        ("cfloat", "cfloat", 9, 6, 0): 9,
        ("cfloat", "cfloat", 10, 6, 0): 5,
        ("cfloat", "cfloat", 11, 6, 0): 11,
        ("cfloat", "cfloat", 12, 6, 0): 3,
        ("cfloat", "cfloat", 13, 6, 0): 13,
        ("cfloat", "cfloat", 14, 6, 0): 7,
        ("cfloat", "cfloat", 15, 6, 0): 15,
        ("cfloat", "cfloat", 16, 6, 0): 1,
        ("cfloat", "cfloat", 1, 7, 0): 1,
        ("cfloat", "cfloat", 2, 7, 0): 1,
        ("cfloat", "cfloat", 3, 7, 0): 3,
        ("cfloat", "cfloat", 4, 7, 0): 1,
        ("cfloat", "cfloat", 5, 7, 0): 5,
        ("cfloat", "cfloat", 6, 7, 0): 3,
        ("cfloat", "cfloat", 7, 7, 0): 7,
        ("cfloat", "cfloat", 8, 7, 0): 1,
        ("cfloat", "cfloat", 9, 7, 0): 9,
        ("cfloat", "cfloat", 10, 7, 0): 5,
        ("cfloat", "cfloat", 11, 7, 0): 11,
        ("cfloat", "cfloat", 12, 7, 0): 3,
        ("cfloat", "cfloat", 13, 7, 0): 13,
        ("cfloat", "cfloat", 14, 7, 0): 7,
        ("cfloat", "cfloat", 15, 7, 0): 15,
        ("cfloat", "cfloat", 16, 7, 0): 2,
        ("cfloat", "cfloat", 1, 8, 0): 1,
        ("cfloat", "cfloat", 2, 8, 0): 1,
        ("cfloat", "cfloat", 3, 8, 0): 3,
        ("cfloat", "cfloat", 4, 8, 0): 1,
        ("cfloat", "cfloat", 5, 8, 0): 5,
        ("cfloat", "cfloat", 6, 8, 0): 3,
        ("cfloat", "cfloat", 7, 8, 0): 7,
        ("cfloat", "cfloat", 8, 8, 0): 1,
        ("cfloat", "cfloat", 9, 8, 0): 9,
        ("cfloat", "cfloat", 10, 8, 0): 5,
        ("cfloat", "cfloat", 11, 8, 0): 11,
        ("cfloat", "cfloat", 12, 8, 0): 3,
        ("cfloat", "cfloat", 13, 8, 0): 13,
        ("cfloat", "cfloat", 14, 8, 0): 7,
        ("cfloat", "cfloat", 15, 8, 0): 15,
        ("cfloat", "cfloat", 16, 8, 0): 1,
        ("cfloat", "cfloat", 1, 9, 0): 1,
        ("cfloat", "cfloat", 2, 9, 0): 1,
        ("cfloat", "cfloat", 3, 9, 0): 3,
        ("cfloat", "cfloat", 4, 9, 0): 1,
        ("cfloat", "cfloat", 5, 9, 0): 5,
        ("cfloat", "cfloat", 6, 9, 0): 3,
        ("cfloat", "cfloat", 7, 9, 0): 7,
        ("cfloat", "cfloat", 8, 9, 0): 1,
        ("cfloat", "cfloat", 9, 9, 0): 9,
        ("cfloat", "cfloat", 10, 9, 0): 5,
        ("cfloat", "cfloat", 11, 9, 0): 11,
        ("cfloat", "cfloat", 12, 9, 0): 3,
        ("cfloat", "cfloat", 13, 9, 0): 13,
        ("cfloat", "cfloat", 14, 9, 0): 7,
        ("cfloat", "cfloat", 15, 9, 0): 15,
        ("cfloat", "cfloat", 16, 9, 0): 2,
        ("cfloat", "cfloat", 1, 10, 0): 1,
        ("cfloat", "cfloat", 2, 10, 0): 1,
        ("cfloat", "cfloat", 3, 10, 0): 3,
        ("cfloat", "cfloat", 4, 10, 0): 1,
        ("cfloat", "cfloat", 5, 10, 0): 5,
        ("cfloat", "cfloat", 6, 10, 0): 3,
        ("cfloat", "cfloat", 7, 10, 0): 7,
        ("cfloat", "cfloat", 8, 10, 0): 1,
        ("cfloat", "cfloat", 9, 10, 0): 9,
        ("cfloat", "cfloat", 10, 10, 0): 5,
        ("cfloat", "cfloat", 11, 10, 0): 11,
        ("cfloat", "cfloat", 12, 10, 0): 3,
        ("cfloat", "cfloat", 13, 10, 0): 13,
        ("cfloat", "cfloat", 14, 10, 0): 7,
        ("cfloat", "cfloat", 15, 10, 0): 15,
        ("cfloat", "cfloat", 16, 10, 0): 1,
        ("cfloat", "cfloat", 1, 11, 0): 1,
        ("cfloat", "cfloat", 2, 11, 0): 1,
        ("cfloat", "cfloat", 3, 11, 0): 3,
        ("cfloat", "cfloat", 4, 11, 0): 1,
        ("cfloat", "cfloat", 5, 11, 0): 5,
        ("cfloat", "cfloat", 6, 11, 0): 3,
        ("cfloat", "cfloat", 7, 11, 0): 7,
        ("cfloat", "cfloat", 8, 11, 0): 1,
        ("cfloat", "cfloat", 9, 11, 0): 9,
        ("cfloat", "cfloat", 10, 11, 0): 5,
        ("cfloat", "cfloat", 11, 11, 0): 11,
        ("cfloat", "cfloat", 12, 11, 0): 3,
        ("cfloat", "cfloat", 13, 11, 0): 13,
        ("cfloat", "cfloat", 14, 11, 0): 7,
        ("cfloat", "cfloat", 15, 11, 0): 15,
        ("cfloat", "cfloat", 16, 11, 0): 2,
        ("cfloat", "cfloat", 1, 12, 0): 1,
        ("cfloat", "cfloat", 2, 12, 0): 1,
        ("cfloat", "cfloat", 3, 12, 0): 3,
        ("cfloat", "cfloat", 4, 12, 0): 1,
        ("cfloat", "cfloat", 5, 12, 0): 5,
        ("cfloat", "cfloat", 6, 12, 0): 3,
        ("cfloat", "cfloat", 7, 12, 0): 7,
        ("cfloat", "cfloat", 8, 12, 0): 1,
        ("cfloat", "cfloat", 9, 12, 0): 9,
        ("cfloat", "cfloat", 10, 12, 0): 5,
        ("cfloat", "cfloat", 11, 12, 0): 11,
        ("cfloat", "cfloat", 12, 12, 0): 3,
        ("cfloat", "cfloat", 13, 12, 0): 13,
        ("cfloat", "cfloat", 14, 12, 0): 7,
        ("cfloat", "cfloat", 15, 12, 0): 15,
        ("cfloat", "cfloat", 16, 12, 0): 1,
        ("cfloat", "cfloat", 1, 13, 0): 1,
        ("cfloat", "cfloat", 2, 13, 0): 1,
        ("cfloat", "cfloat", 3, 13, 0): 3,
        ("cfloat", "cfloat", 4, 13, 0): 1,
        ("cfloat", "cfloat", 5, 13, 0): 5,
        ("cfloat", "cfloat", 6, 13, 0): 3,
        ("cfloat", "cfloat", 7, 13, 0): 7,
        ("cfloat", "cfloat", 8, 13, 0): 1,
        ("cfloat", "cfloat", 9, 13, 0): 9,
        ("cfloat", "cfloat", 10, 13, 0): 5,
        ("cfloat", "cfloat", 11, 13, 0): 11,
        ("cfloat", "cfloat", 12, 13, 0): 3,
        ("cfloat", "cfloat", 13, 13, 0): 13,
        ("cfloat", "cfloat", 14, 13, 0): 7,
        ("cfloat", "cfloat", 15, 13, 0): 15,
        ("cfloat", "cfloat", 16, 13, 0): 2,
        ("cfloat", "cfloat", 1, 14, 0): 1,
        ("cfloat", "cfloat", 2, 14, 0): 1,
        ("cfloat", "cfloat", 3, 14, 0): 3,
        ("cfloat", "cfloat", 4, 14, 0): 1,
        ("cfloat", "cfloat", 5, 14, 0): 5,
        ("cfloat", "cfloat", 6, 14, 0): 3,
        ("cfloat", "cfloat", 7, 14, 0): 7,
        ("cfloat", "cfloat", 8, 14, 0): 1,
        ("cfloat", "cfloat", 9, 14, 0): 9,
        ("cfloat", "cfloat", 10, 14, 0): 5,
        ("cfloat", "cfloat", 11, 14, 0): 11,
        ("cfloat", "cfloat", 12, 14, 0): 3,
        ("cfloat", "cfloat", 13, 14, 0): 13,
        ("cfloat", "cfloat", 14, 14, 0): 7,
        ("cfloat", "cfloat", 15, 14, 0): 15,
        ("cfloat", "cfloat", 16, 14, 0): 1,
        ("cfloat", "cfloat", 1, 15, 0): 1,
        ("cfloat", "cfloat", 2, 15, 0): 1,
        ("cfloat", "cfloat", 3, 15, 0): 3,
        ("cfloat", "cfloat", 4, 15, 0): 1,
        ("cfloat", "cfloat", 5, 15, 0): 5,
        ("cfloat", "cfloat", 6, 15, 0): 3,
        ("cfloat", "cfloat", 7, 15, 0): 7,
        ("cfloat", "cfloat", 8, 15, 0): 1,
        ("cfloat", "cfloat", 9, 15, 0): 9,
        ("cfloat", "cfloat", 10, 15, 0): 5,
        ("cfloat", "cfloat", 11, 15, 0): 11,
        ("cfloat", "cfloat", 12, 15, 0): 3,
        ("cfloat", "cfloat", 13, 15, 0): 13,
        ("cfloat", "cfloat", 14, 15, 0): 7,
        ("cfloat", "cfloat", 15, 15, 0): 15,
        ("cfloat", "cfloat", 16, 15, 0): 2,
        ("cfloat", "cfloat", 1, 16, 0): 1,
        ("cfloat", "cfloat", 2, 16, 0): 1,
        ("cfloat", "cfloat", 3, 16, 0): 3,
        ("cfloat", "cfloat", 4, 16, 0): 1,
        ("cfloat", "cfloat", 5, 16, 0): 5,
        ("cfloat", "cfloat", 6, 16, 0): 3,
        ("cfloat", "cfloat", 7, 16, 0): 7,
        ("cfloat", "cfloat", 8, 16, 0): 1,
        ("cfloat", "cfloat", 9, 16, 0): 9,
        ("cfloat", "cfloat", 10, 16, 0): 5,
        ("cfloat", "cfloat", 11, 16, 0): 11,
        ("cfloat", "cfloat", 12, 16, 0): 3,
        ("cfloat", "cfloat", 13, 16, 0): 13,
        ("cfloat", "cfloat", 14, 16, 0): 7,
        ("cfloat", "cfloat", 15, 16, 0): 15,
        ("cfloat", "cfloat", 16, 16, 0): 1,
        ("cfloat", "cfloat", 1, 1, 1): 1,
        ("cfloat", "cfloat", 2, 1, 1): 1,
        ("cfloat", "cfloat", 3, 1, 1): 3,
        ("cfloat", "cfloat", 4, 1, 1): 1,
        ("cfloat", "cfloat", 5, 1, 1): 5,
        ("cfloat", "cfloat", 6, 1, 1): 3,
        ("cfloat", "cfloat", 7, 1, 1): 7,
        ("cfloat", "cfloat", 8, 1, 1): 2,
        ("cfloat", "cfloat", 9, 1, 1): 9,
        ("cfloat", "cfloat", 10, 1, 1): 5,
        ("cfloat", "cfloat", 11, 1, 1): 11,
        ("cfloat", "cfloat", 12, 1, 1): 3,
        ("cfloat", "cfloat", 13, 1, 1): 13,
        ("cfloat", "cfloat", 14, 1, 1): 7,
        ("cfloat", "cfloat", 15, 1, 1): 15,
        ("cfloat", "cfloat", 16, 1, 1): 4,
        ("cfloat", "cfloat", 1, 2, 1): 1,
        ("cfloat", "cfloat", 2, 2, 1): 1,
        ("cfloat", "cfloat", 3, 2, 1): 3,
        ("cfloat", "cfloat", 4, 2, 1): 1,
        ("cfloat", "cfloat", 5, 2, 1): 5,
        ("cfloat", "cfloat", 6, 2, 1): 3,
        ("cfloat", "cfloat", 7, 2, 1): 7,
        ("cfloat", "cfloat", 8, 2, 1): 1,
        ("cfloat", "cfloat", 9, 2, 1): 9,
        ("cfloat", "cfloat", 10, 2, 1): 5,
        ("cfloat", "cfloat", 11, 2, 1): 11,
        ("cfloat", "cfloat", 12, 2, 1): 3,
        ("cfloat", "cfloat", 13, 2, 1): 13,
        ("cfloat", "cfloat", 14, 2, 1): 7,
        ("cfloat", "cfloat", 15, 2, 1): 15,
        ("cfloat", "cfloat", 16, 2, 1): 2,
        ("cfloat", "cfloat", 1, 3, 1): 1,
        ("cfloat", "cfloat", 2, 3, 1): 1,
        ("cfloat", "cfloat", 3, 3, 1): 3,
        ("cfloat", "cfloat", 4, 3, 1): 1,
        ("cfloat", "cfloat", 5, 3, 1): 5,
        ("cfloat", "cfloat", 6, 3, 1): 3,
        ("cfloat", "cfloat", 7, 3, 1): 7,
        ("cfloat", "cfloat", 8, 3, 1): 2,
        ("cfloat", "cfloat", 9, 3, 1): 9,
        ("cfloat", "cfloat", 10, 3, 1): 5,
        ("cfloat", "cfloat", 11, 3, 1): 11,
        ("cfloat", "cfloat", 12, 3, 1): 3,
        ("cfloat", "cfloat", 13, 3, 1): 13,
        ("cfloat", "cfloat", 14, 3, 1): 7,
        ("cfloat", "cfloat", 15, 3, 1): 15,
        ("cfloat", "cfloat", 16, 3, 1): 4,
        ("cfloat", "cfloat", 1, 4, 1): 1,
        ("cfloat", "cfloat", 2, 4, 1): 1,
        ("cfloat", "cfloat", 3, 4, 1): 3,
        ("cfloat", "cfloat", 4, 4, 1): 1,
        ("cfloat", "cfloat", 5, 4, 1): 5,
        ("cfloat", "cfloat", 6, 4, 1): 3,
        ("cfloat", "cfloat", 7, 4, 1): 7,
        ("cfloat", "cfloat", 8, 4, 1): 1,
        ("cfloat", "cfloat", 9, 4, 1): 9,
        ("cfloat", "cfloat", 10, 4, 1): 5,
        ("cfloat", "cfloat", 11, 4, 1): 11,
        ("cfloat", "cfloat", 12, 4, 1): 3,
        ("cfloat", "cfloat", 13, 4, 1): 13,
        ("cfloat", "cfloat", 14, 4, 1): 7,
        ("cfloat", "cfloat", 15, 4, 1): 15,
        ("cfloat", "cfloat", 16, 4, 1): 2,
        ("cfloat", "cfloat", 1, 5, 1): 1,
        ("cfloat", "cfloat", 2, 5, 1): 1,
        ("cfloat", "cfloat", 3, 5, 1): 3,
        ("cfloat", "cfloat", 4, 5, 1): 1,
        ("cfloat", "cfloat", 5, 5, 1): 5,
        ("cfloat", "cfloat", 6, 5, 1): 3,
        ("cfloat", "cfloat", 7, 5, 1): 7,
        ("cfloat", "cfloat", 8, 5, 1): 2,
        ("cfloat", "cfloat", 9, 5, 1): 9,
        ("cfloat", "cfloat", 10, 5, 1): 5,
        ("cfloat", "cfloat", 11, 5, 1): 11,
        ("cfloat", "cfloat", 12, 5, 1): 3,
        ("cfloat", "cfloat", 13, 5, 1): 13,
        ("cfloat", "cfloat", 14, 5, 1): 7,
        ("cfloat", "cfloat", 15, 5, 1): 15,
        ("cfloat", "cfloat", 16, 5, 1): 4,
        ("cfloat", "cfloat", 1, 6, 1): 1,
        ("cfloat", "cfloat", 2, 6, 1): 1,
        ("cfloat", "cfloat", 3, 6, 1): 3,
        ("cfloat", "cfloat", 4, 6, 1): 1,
        ("cfloat", "cfloat", 5, 6, 1): 5,
        ("cfloat", "cfloat", 6, 6, 1): 3,
        ("cfloat", "cfloat", 7, 6, 1): 7,
        ("cfloat", "cfloat", 8, 6, 1): 1,
        ("cfloat", "cfloat", 9, 6, 1): 9,
        ("cfloat", "cfloat", 10, 6, 1): 5,
        ("cfloat", "cfloat", 11, 6, 1): 11,
        ("cfloat", "cfloat", 12, 6, 1): 3,
        ("cfloat", "cfloat", 13, 6, 1): 13,
        ("cfloat", "cfloat", 14, 6, 1): 7,
        ("cfloat", "cfloat", 15, 6, 1): 15,
        ("cfloat", "cfloat", 16, 6, 1): 2,
        ("cfloat", "cfloat", 1, 7, 1): 1,
        ("cfloat", "cfloat", 2, 7, 1): 1,
        ("cfloat", "cfloat", 3, 7, 1): 3,
        ("cfloat", "cfloat", 4, 7, 1): 1,
        ("cfloat", "cfloat", 5, 7, 1): 5,
        ("cfloat", "cfloat", 6, 7, 1): 3,
        ("cfloat", "cfloat", 7, 7, 1): 7,
        ("cfloat", "cfloat", 8, 7, 1): 2,
        ("cfloat", "cfloat", 9, 7, 1): 9,
        ("cfloat", "cfloat", 10, 7, 1): 5,
        ("cfloat", "cfloat", 11, 7, 1): 11,
        ("cfloat", "cfloat", 12, 7, 1): 3,
        ("cfloat", "cfloat", 13, 7, 1): 13,
        ("cfloat", "cfloat", 14, 7, 1): 7,
        ("cfloat", "cfloat", 15, 7, 1): 15,
        ("cfloat", "cfloat", 16, 7, 1): 4,
        ("cfloat", "cfloat", 1, 8, 1): 1,
        ("cfloat", "cfloat", 2, 8, 1): 1,
        ("cfloat", "cfloat", 3, 8, 1): 3,
        ("cfloat", "cfloat", 4, 8, 1): 1,
        ("cfloat", "cfloat", 5, 8, 1): 5,
        ("cfloat", "cfloat", 6, 8, 1): 3,
        ("cfloat", "cfloat", 7, 8, 1): 7,
        ("cfloat", "cfloat", 8, 8, 1): 1,
        ("cfloat", "cfloat", 9, 8, 1): 9,
        ("cfloat", "cfloat", 10, 8, 1): 5,
        ("cfloat", "cfloat", 11, 8, 1): 11,
        ("cfloat", "cfloat", 12, 8, 1): 3,
        ("cfloat", "cfloat", 13, 8, 1): 13,
        ("cfloat", "cfloat", 14, 8, 1): 7,
        ("cfloat", "cfloat", 15, 8, 1): 15,
        ("cfloat", "cfloat", 16, 8, 1): 2,
        ("cfloat", "cfloat", 1, 9, 1): 1,
        ("cfloat", "cfloat", 2, 9, 1): 1,
        ("cfloat", "cfloat", 3, 9, 1): 3,
        ("cfloat", "cfloat", 4, 9, 1): 1,
        ("cfloat", "cfloat", 5, 9, 1): 5,
        ("cfloat", "cfloat", 6, 9, 1): 3,
        ("cfloat", "cfloat", 7, 9, 1): 7,
        ("cfloat", "cfloat", 8, 9, 1): 2,
        ("cfloat", "cfloat", 9, 9, 1): 9,
        ("cfloat", "cfloat", 10, 9, 1): 5,
        ("cfloat", "cfloat", 11, 9, 1): 11,
        ("cfloat", "cfloat", 12, 9, 1): 3,
        ("cfloat", "cfloat", 13, 9, 1): 13,
        ("cfloat", "cfloat", 14, 9, 1): 7,
        ("cfloat", "cfloat", 15, 9, 1): 15,
        ("cfloat", "cfloat", 16, 9, 1): 4,
        ("cfloat", "cfloat", 1, 10, 1): 1,
        ("cfloat", "cfloat", 2, 10, 1): 1,
        ("cfloat", "cfloat", 3, 10, 1): 3,
        ("cfloat", "cfloat", 4, 10, 1): 1,
        ("cfloat", "cfloat", 5, 10, 1): 5,
        ("cfloat", "cfloat", 6, 10, 1): 3,
        ("cfloat", "cfloat", 7, 10, 1): 7,
        ("cfloat", "cfloat", 8, 10, 1): 1,
        ("cfloat", "cfloat", 9, 10, 1): 9,
        ("cfloat", "cfloat", 10, 10, 1): 5,
        ("cfloat", "cfloat", 11, 10, 1): 11,
        ("cfloat", "cfloat", 12, 10, 1): 3,
        ("cfloat", "cfloat", 13, 10, 1): 13,
        ("cfloat", "cfloat", 14, 10, 1): 7,
        ("cfloat", "cfloat", 15, 10, 1): 15,
        ("cfloat", "cfloat", 16, 10, 1): 2,
        ("cfloat", "cfloat", 1, 11, 1): 1,
        ("cfloat", "cfloat", 2, 11, 1): 1,
        ("cfloat", "cfloat", 3, 11, 1): 3,
        ("cfloat", "cfloat", 4, 11, 1): 1,
        ("cfloat", "cfloat", 5, 11, 1): 5,
        ("cfloat", "cfloat", 6, 11, 1): 3,
        ("cfloat", "cfloat", 7, 11, 1): 7,
        ("cfloat", "cfloat", 8, 11, 1): 2,
        ("cfloat", "cfloat", 9, 11, 1): 9,
        ("cfloat", "cfloat", 10, 11, 1): 5,
        ("cfloat", "cfloat", 11, 11, 1): 11,
        ("cfloat", "cfloat", 12, 11, 1): 3,
        ("cfloat", "cfloat", 13, 11, 1): 13,
        ("cfloat", "cfloat", 14, 11, 1): 7,
        ("cfloat", "cfloat", 15, 11, 1): 15,
        ("cfloat", "cfloat", 16, 11, 1): 4,
        ("cfloat", "cfloat", 1, 12, 1): 1,
        ("cfloat", "cfloat", 2, 12, 1): 1,
        ("cfloat", "cfloat", 3, 12, 1): 3,
        ("cfloat", "cfloat", 4, 12, 1): 1,
        ("cfloat", "cfloat", 5, 12, 1): 5,
        ("cfloat", "cfloat", 6, 12, 1): 3,
        ("cfloat", "cfloat", 7, 12, 1): 7,
        ("cfloat", "cfloat", 8, 12, 1): 1,
        ("cfloat", "cfloat", 9, 12, 1): 9,
        ("cfloat", "cfloat", 10, 12, 1): 5,
        ("cfloat", "cfloat", 11, 12, 1): 11,
        ("cfloat", "cfloat", 12, 12, 1): 3,
        ("cfloat", "cfloat", 13, 12, 1): 13,
        ("cfloat", "cfloat", 14, 12, 1): 7,
        ("cfloat", "cfloat", 15, 12, 1): 15,
        ("cfloat", "cfloat", 16, 12, 1): 2,
        ("cfloat", "cfloat", 1, 13, 1): 1,
        ("cfloat", "cfloat", 2, 13, 1): 1,
        ("cfloat", "cfloat", 3, 13, 1): 3,
        ("cfloat", "cfloat", 4, 13, 1): 1,
        ("cfloat", "cfloat", 5, 13, 1): 5,
        ("cfloat", "cfloat", 6, 13, 1): 3,
        ("cfloat", "cfloat", 7, 13, 1): 7,
        ("cfloat", "cfloat", 8, 13, 1): 2,
        ("cfloat", "cfloat", 9, 13, 1): 9,
        ("cfloat", "cfloat", 10, 13, 1): 5,
        ("cfloat", "cfloat", 11, 13, 1): 11,
        ("cfloat", "cfloat", 12, 13, 1): 3,
        ("cfloat", "cfloat", 13, 13, 1): 13,
        ("cfloat", "cfloat", 14, 13, 1): 7,
        ("cfloat", "cfloat", 15, 13, 1): 15,
        ("cfloat", "cfloat", 16, 13, 1): 4,
        ("cfloat", "cfloat", 1, 14, 1): 1,
        ("cfloat", "cfloat", 2, 14, 1): 1,
        ("cfloat", "cfloat", 3, 14, 1): 3,
        ("cfloat", "cfloat", 4, 14, 1): 1,
        ("cfloat", "cfloat", 5, 14, 1): 5,
        ("cfloat", "cfloat", 6, 14, 1): 3,
        ("cfloat", "cfloat", 7, 14, 1): 7,
        ("cfloat", "cfloat", 8, 14, 1): 1,
        ("cfloat", "cfloat", 9, 14, 1): 9,
        ("cfloat", "cfloat", 10, 14, 1): 5,
        ("cfloat", "cfloat", 11, 14, 1): 11,
        ("cfloat", "cfloat", 12, 14, 1): 3,
        ("cfloat", "cfloat", 13, 14, 1): 13,
        ("cfloat", "cfloat", 14, 14, 1): 7,
        ("cfloat", "cfloat", 15, 14, 1): 15,
        ("cfloat", "cfloat", 16, 14, 1): 2,
        ("cfloat", "cfloat", 1, 15, 1): 1,
        ("cfloat", "cfloat", 2, 15, 1): 1,
        ("cfloat", "cfloat", 3, 15, 1): 3,
        ("cfloat", "cfloat", 4, 15, 1): 1,
        ("cfloat", "cfloat", 5, 15, 1): 5,
        ("cfloat", "cfloat", 6, 15, 1): 3,
        ("cfloat", "cfloat", 7, 15, 1): 7,
        ("cfloat", "cfloat", 8, 15, 1): 2,
        ("cfloat", "cfloat", 9, 15, 1): 9,
        ("cfloat", "cfloat", 10, 15, 1): 5,
        ("cfloat", "cfloat", 11, 15, 1): 11,
        ("cfloat", "cfloat", 12, 15, 1): 3,
        ("cfloat", "cfloat", 13, 15, 1): 13,
        ("cfloat", "cfloat", 14, 15, 1): 7,
        ("cfloat", "cfloat", 15, 15, 1): 15,
        ("cfloat", "cfloat", 16, 15, 1): 4,
        ("cfloat", "cfloat", 1, 16, 1): 1,
        ("cfloat", "cfloat", 2, 16, 1): 1,
        ("cfloat", "cfloat", 3, 16, 1): 3,
        ("cfloat", "cfloat", 4, 16, 1): 1,
        ("cfloat", "cfloat", 5, 16, 1): 5,
        ("cfloat", "cfloat", 6, 16, 1): 3,
        ("cfloat", "cfloat", 7, 16, 1): 7,
        ("cfloat", "cfloat", 8, 16, 1): 1,
        ("cfloat", "cfloat", 9, 16, 1): 9,
        ("cfloat", "cfloat", 10, 16, 1): 5,
        ("cfloat", "cfloat", 11, 16, 1): 11,
        ("cfloat", "cfloat", 12, 16, 1): 3,
        ("cfloat", "cfloat", 13, 16, 1): 13,
        ("cfloat", "cfloat", 14, 16, 1): 7,
        ("cfloat", "cfloat", 15, 16, 1): 15,
        ("cfloat", "cfloat", 16, 16, 1): 2,
    }
    return phaseLookupTable[
        (dataTypeStr, coefTypeStr, interpolationFactor, decimationFactor, api)
    ]
