###########################################################################################
#   Script to generate the solution for solution "Configuring the DDRMC"                  #
#   solution directory: <$TRAINING_PATH>/mem1_cfg/ddrmc                                   #
#	Vivado version: 2025.1                                                                #
###########################################################################################


#!/usr/bin/tclsh
variable hostOS [lindex $tcl_platform(os) 0]
if { $hostOS == "Windows" } {
    set TRAINING_PATH "C:\\training"
    set xilinxPath "C:\\Xilinx"
} else {
    set TRAINING_PATH "/home/amd/training"
    set xilinxPath "/opt/xilinx"
}

start_gui
create_project cfg_ddr4 $::env(TRAINING_PATH)/mem1_cfg/ddrmc/solution -part xcvc1902-vsva2197-2MP-e-S -force
#set_property board_part xilinx.com:vck190:part0:3.1 [current_project]
set_property coreContainer.enable 1 [current_project]

source generate_block_design_lpddr4.tcl
source generate_block_design_ddr4.tcl

current_bd_design [get_bd_designs ddr4]
regenerate_bd_layout
current_bd_design [get_bd_designs lpddr4]
regenerate_bd_layout