###########################################################################################
#   Script to generate the solution for solution "Configuring the DDRMC5"                 #
#   solution directory: <$TRAINING_PATH>/mem1_cfg/ddrmc5                                  #
#	Vivado version: 2025.1                                                                #
###########################################################################################



#!/usr/bin/tclsh
variable hostOS [lindex $tcl_platform(os) 0]
if { $hostOS == "Windows" } {
    set TRAINING_PATH "C:\\training"
    set xilinxPath "C:\\Xilinx"
} else {
    set TRAINING_PATH "/home/amd/training"
    set xilinxPath "/opt/xilinx"
}

start_gui
create_project cfg_ddr5 $::env(TRAINING_PATH)/mem1_cfg/ddrmc5/solution -part xc2ve3858-ssva2112-2MP-e-S -force
#set_property board_part xilinx.com:vek385:part0:1.0 [current_project]
set_property coreContainer.enable 1 [current_project]

source generate_block_design_lpddr5.tcl
source generate_block_design_ddr5.tcl

current_bd_design [get_bd_designs lpddr5]
regenerate_bd_layout
current_bd_design [get_bd_designs ddr5]
regenerate_bd_layout