

#<copyright-disclaimer-start>
#<copyright-disclaimer-start>
#  **************************************************************************************************************
#  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
#  * DISCLAIMER                                                                                                 *
#  * The information contained herein is for informational purposes only, and is subject to change              *
#  * without notice. While every precaution has been taken in the preparation of this document, it              *
#  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
#  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
#  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
#  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
#  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
#  * hardware, software or other products described herein.  No license, including implied or                   *
#  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
#  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
#  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
#  *                                                                                                            *
#  **************************************************************************************************************
#<copyright-disclaimer-end>
#<copyright-disclaimer-end> 


###########################################################################################
#   Script to generate the solution for lab "Implementing the DDRMC"                      #
#   Lab directory: <$TRAINING_PATH>/mem3_imp/ddrmc                                        #
#	Vivado version: 2025.1                                                                #
#   Lab step 2                                                                            #
###########################################################################################

# +++ Starting Point loaded in previous lab step

# +++ Step 2.1: Add and configure CIPS
update_compile_order -fileset sources_1
open_bd_design { $TRAINING_PATH/mem3_imp/ddrmc/solution/mif_ddr4.srcs/sources_1/bd/ddr4/ddr4.bd}
startgroup
create_bd_cell -type ip -vlnv xilinx.com:ip:versal_cips:3.4 versal_cips_0
endgroup
apply_bd_automation -rule xilinx.com:bd_rule:cips -config { board_preset {No} boot_config {Custom} configure_noc {Add new AXI NoC} debug_config {Custom} design_flow {PL Subsystem} mc_type {None} num_mc_ddr {None} num_mc_lpddr {None} pl_clocks {None} pl_resets {None}}  [get_bd_cells versal_cips_0]
set_property CONFIG.PS_PMC_CONFIG { \
  DESIGN_MODE {0} \
  PS_BOARD_INTERFACE {Custom} \
  PS_NUM_FABRIC_RESETS {1} \
  PS_USE_PMCPL_CLK0 {0} \
  PS_USE_PMCPL_CLK1 {0} \
  PS_USE_PMCPL_CLK2 {0} \
  PS_USE_PMCPL_CLK3 {0} \
  SMON_ALARMS {Set_Alarms_On} \
  SMON_ENABLE_TEMP_AVERAGING {0} \
  SMON_TEMP_AVERAGING_SAMPLES {0} \
} [get_bd_cells versal_cips_0]
puts "+++ lab step 2.1 finished +++"


# +++ Step 2.2: Modify reset and clocking
delete_bd_objs [get_bd_nets sim_clk_gen_0_clk] [get_bd_cells sim_clk_gen_0]
connect_bd_net [get_bd_pins versal_cips_0/pl0_resetn] [get_bd_pins clk_wiz/resetn]
startgroup
set_property -dict [list \
  CONFIG.PRIM_IN_FREQ {200.000} \
  CONFIG.PRIM_SOURCE {Differential_clock_capable_pin} \
] [get_bd_cells clk_wiz]
endgroup
apply_bd_automation -rule xilinx.com:bd_rule:board -config { Manual_Source {Auto}}  [get_bd_intf_pins clk_wiz/CLK_IN1_D]
set_property name lpddr4_sma_clk1 [get_bd_intf_ports diff_clock_rtl_0]
regenerate_bd_layout

puts "+++ lab step 2.2 finished +++"

# +++ Step 2.3: Validate ans generate the block design
validate_bd_design
make_wrapper -files [get_files $TRAINING_PATH/mem3_imp/ddrmc/solution/mif_ddr4.srcs/sources_1/bd/ddr4/ddr4.bd] -top
generate_target all [get_files  $TRAINING_PATH/mem3_imp/ddrmc/solution/mif_ddr4.srcs/sources_1/bd/ddr4/ddr4.bd]
catch { config_ip_cache -export [get_ips -all ddr4_axi_noc_0_0] }
catch { config_ip_cache -export [get_ips -all ddr4_clk_wiz_0] }
export_ip_user_files -of_objects [get_files $TRAINING_PATH/mem3_imp/ddrmc/solution/mif_ddr4.srcs/sources_1/bd/ddr4/ddr4.bd] -no_script -sync -force -quiet
create_ip_run [get_files -of_objects [get_fileset sources_1] $TRAINING_PATH/mem3_imp/ddrmc/solution/mif_ddr4.srcs/sources_1/bd/ddr4/ddr4.bd]
launch_runs ddr4_axi_noc_0_0_synth_1 ddr4_clk_wiz_0_synth_1 -jobs 20
wait_on_run ddr4_axi_noc_0_0_synth_1
wait_on_run ddr4_clk_wiz_0_synth_1
export_simulation -lib_map_path [list {modelsim=$TRAINING_PATH/mem3_imp/ddrmc/solution/mif_ddr4.cache/compile_simlib/modelsim} {questa=$TRAINING_PATH/mem3_imp/ddrmc/solution/mif_ddr4.cache/compile_simlib/questa} {riviera=$TRAINING_PATH/mem3_imp/ddrmc/solution/mif_ddr4.cache/compile_simlib/riviera} {activehdl=$TRAINING_PATH/mem3_imp/ddrmc/solution/mif_ddr4.cache/compile_simlib/activehdl}] -of_objects [get_files $TRAINING_PATH/mem3_imp/ddrmc/solution/mif_ddr4.srcs/sources_1/bd/ddr4/ddr4.bd] -directory $TRAINING_PATH/mem3_imp/ddrmc/solution/mif_ddr4.ip_user_files/sim_scripts -ip_user_files_dir $TRAINING_PATH/mem3_imp/ddrmc/solution/mif_ddr4.ip_user_files -ipstatic_source_dir $TRAINING_PATH/mem3_imp/ddrmc/solution/mif_ddr4.ip_user_files/ipstatic -use_ip_compiled_libs -force -quiet
puts "+++ lab step 2.3 finished +++"

# +++ Step 2 finished
puts "+++ lab step 2 all finished +++"
