###########################################################################################
#   Script to generate the starting point for lab "DDRMC Performance Tuning" - Design 2   #
#   Lab directory: <$TRAINING_PATH>/mem4_dpt                                              #
#	Vivado version: 2025.1                                                                #
#   Lab step 2                                                                            #
#   Generation of block design                                                            #
###########################################################################################


#<copyright-disclaimer-start>
#<copyright-disclaimer-start>
#  **************************************************************************************************************
#  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
#  * DISCLAIMER                                                                                                 *
#  * The information contained herein is for informational purposes only, and is subject to change              *
#  * without notice. While every precaution has been taken in the preparation of this document, it              *
#  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
#  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
#  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
#  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
#  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
#  * hardware, software or other products described herein.  No license, including implied or                   *
#  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
#  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
#  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
#  *                                                                                                            *
#  **************************************************************************************************************
#<copyright-disclaimer-end>
#<copyright-disclaimer-end> 



################################################################
# This is a generated script based on design: ddr4_dpt
#
# Though there are limitations about the generated script,
# the main purpose of this utility is to make learning
# IP Integrator Tcl commands easier.
################################################################

namespace eval _tcl {
proc get_script_folder {} {
   set script_path [file normalize [info script]]
   set script_folder [file dirname $script_path]
   return $script_folder
}
}
variable script_folder
set script_folder [_tcl::get_script_folder]

################################################################
# Check if script is running in correct Vivado version.
################################################################
set scripts_vivado_version 2025.1
set current_vivado_version [version -short]

if { [string first $scripts_vivado_version $current_vivado_version] == -1 } {
   puts ""
   if { [string compare $scripts_vivado_version $current_vivado_version] > 0 } {
      catch {common::send_gid_msg -ssname BD::TCL -id 2042 -severity "ERROR" " This script was generated using Vivado <$scripts_vivado_version> and is being run in <$current_vivado_version> of Vivado. Sourcing the script failed since it was created with a future version of Vivado."}

   } else {
     catch {common::send_gid_msg -ssname BD::TCL -id 2041 -severity "ERROR" "This script was generated using Vivado <$scripts_vivado_version> and is being run in <$current_vivado_version> of Vivado. Please run the script in Vivado <$scripts_vivado_version> then open the design in Vivado <$current_vivado_version>. Upgrade the design by running \"Tools => Report => Report IP Status...\", then run write_bd_tcl to create an updated script."}

   }

   return 1
}

################################################################
# START
################################################################

# To test this script, run the following commands from Vivado Tcl console:
# source ddr4_dpt_script.tcl

# If there is no project opened, this script will create a
# project, but make sure you do not have an existing project
# <./myproj/project_1.xpr> in the current working folder.

set list_projs [get_projects -quiet]
if { $list_projs eq "" } {
   create_project project_1 myproj -part xcvc1902-vsva2197-2MP-e-S
   set_property BOARD_PART xilinx.com:vck190:part0:3.1 [current_project]
}


# CHANGE DESIGN NAME HERE
variable design_name
set design_name ddr4_dpt

# If you do not already have an existing IP Integrator design open,
# you can create a design using the following command:
#    create_bd_design $design_name

# Creating design if needed
set errMsg ""
set nRet 0

set cur_design [current_bd_design -quiet]
set list_cells [get_bd_cells -quiet]

if { ${design_name} eq "" } {
   # USE CASES:
   #    1) Design_name not set

   set errMsg "Please set the variable <design_name> to a non-empty value."
   set nRet 1

} elseif { ${cur_design} ne "" && ${list_cells} eq "" } {
   # USE CASES:
   #    2): Current design opened AND is empty AND names same.
   #    3): Current design opened AND is empty AND names diff; design_name NOT in project.
   #    4): Current design opened AND is empty AND names diff; design_name exists in project.

   if { $cur_design ne $design_name } {
      common::send_gid_msg -ssname BD::TCL -id 2001 -severity "INFO" "Changing value of <design_name> from <$design_name> to <$cur_design> since current design is empty."
      set design_name [get_property NAME $cur_design]
   }
   common::send_gid_msg -ssname BD::TCL -id 2002 -severity "INFO" "Constructing design in IPI design <$cur_design>..."

} elseif { ${cur_design} ne "" && $list_cells ne "" && $cur_design eq $design_name } {
   # USE CASES:
   #    5) Current design opened AND has components AND same names.

   set errMsg "Design <$design_name> already exists in your project, please set the variable <design_name> to another value."
   set nRet 1
} elseif { [get_files -quiet ${design_name}.bd] ne "" } {
   # USE CASES: 
   #    6) Current opened design, has components, but diff names, design_name exists in project.
   #    7) No opened design, design_name exists in project.

   set errMsg "Design <$design_name> already exists in your project, please set the variable <design_name> to another value."
   set nRet 2

} else {
   # USE CASES:
   #    8) No opened design, design_name not in project.
   #    9) Current opened design, has components, but diff names, design_name not in project.

   common::send_gid_msg -ssname BD::TCL -id 2003 -severity "INFO" "Currently there is no design <$design_name> in project, so creating one..."

   create_bd_design $design_name

   common::send_gid_msg -ssname BD::TCL -id 2004 -severity "INFO" "Making design <$design_name> as current_bd_design."
   current_bd_design $design_name

}

common::send_gid_msg -ssname BD::TCL -id 2005 -severity "INFO" "Currently the variable <design_name> is equal to \"$design_name\"."

if { $nRet != 0 } {
   catch {common::send_gid_msg -ssname BD::TCL -id 2006 -severity "ERROR" $errMsg}
   return $nRet
}

set bCheckIPsPassed 1
##################################################################
# CHECK IPs
##################################################################
set bCheckIPs 1
if { $bCheckIPs == 1 } {
   set list_check_ips "\ 
xilinx.com:ip:axi_noc:1.1\
xilinx.com:ip:clk_gen_sim:1.0\
xilinx.com:ip:perf_axi_tg:1.0\
xilinx.com:ip:sim_trig:1.0\
xilinx.com:ip:axi_pmon:1.0\
xilinx.com:ip:proc_sys_reset:5.0\
xilinx.com:ip:sim_clk_gen:1.0\
"

   set list_ips_missing ""
   common::send_gid_msg -ssname BD::TCL -id 2011 -severity "INFO" "Checking if the following IPs exist in the project's IP catalog: $list_check_ips ."

   foreach ip_vlnv $list_check_ips {
      set ip_obj [get_ipdefs -all $ip_vlnv]
      if { $ip_obj eq "" } {
         lappend list_ips_missing $ip_vlnv
      }
   }

   if { $list_ips_missing ne "" } {
      catch {common::send_gid_msg -ssname BD::TCL -id 2012 -severity "ERROR" "The following IPs are not found in the IP Catalog:\n  $list_ips_missing\n\nResolution: Please add the repository containing the IP(s) to the project." }
      set bCheckIPsPassed 0
   }

}

if { $bCheckIPsPassed != 1 } {
  common::send_gid_msg -ssname BD::TCL -id 2023 -severity "WARNING" "Will not continue with creation of design due to the error(s) above."
  return 3
}

##################################################################
# DESIGN PROCs
##################################################################



# Procedure to create entire design; Provide argument to make
# procedure reusable. If parentCell is "", will use root.
proc create_root_design { parentCell } {

  variable script_folder
  variable design_name

  if { $parentCell eq "" } {
     set parentCell [get_bd_cells /]
  }

  # Get object for parentCell
  set parentObj [get_bd_cells $parentCell]
  if { $parentObj == "" } {
     catch {common::send_gid_msg -ssname BD::TCL -id 2090 -severity "ERROR" "Unable to find parent cell <$parentCell>!"}
     return
  }

  # Make sure parentObj is hier blk
  set parentType [get_property TYPE $parentObj]
  if { $parentType ne "hier" } {
     catch {common::send_gid_msg -ssname BD::TCL -id 2091 -severity "ERROR" "Parent <$parentObj> has TYPE = <$parentType>. Expected to be <hier>."}
     return
  }

  # Save current instance; Restore later
  set oldCurInst [current_bd_instance .]

  # Set parent object as current
  current_bd_instance $parentObj


  # Create interface ports
  set ch0_lpddr4_c0 [ create_bd_intf_port -mode Master -vlnv xilinx.com:interface:lpddr4_rtl:1.0 ch0_lpddr4_c0 ]

  set ch1_lpddr4_c0 [ create_bd_intf_port -mode Master -vlnv xilinx.com:interface:lpddr4_rtl:1.0 ch1_lpddr4_c0 ]

  set lpddr4_sma_clk1 [ create_bd_intf_port -mode Slave -vlnv xilinx.com:interface:diff_clock_rtl:1.0 lpddr4_sma_clk1 ]

  set ch0_lpddr4_c1 [ create_bd_intf_port -mode Master -vlnv xilinx.com:interface:lpddr4_rtl:1.0 ch0_lpddr4_c1 ]

  set ch1_lpddr4_c1 [ create_bd_intf_port -mode Master -vlnv xilinx.com:interface:lpddr4_rtl:1.0 ch1_lpddr4_c1 ]

  set lpddr4_sma_clk2 [ create_bd_intf_port -mode Slave -vlnv xilinx.com:interface:diff_clock_rtl:1.0 lpddr4_sma_clk2 ]


  # Create ports

  # Create instance: axi_noc_0, and set properties
  set axi_noc_0 [ create_bd_cell -type ip -vlnv xilinx.com:ip:axi_noc:1.1 axi_noc_0 ]
  set_property -dict [list \
    CONFIG.CH0_LPDDR4_0_BOARD_INTERFACE {ch0_lpddr4_c0} \
    CONFIG.CH1_LPDDR4_0_BOARD_INTERFACE {ch1_lpddr4_c0} \
    CONFIG.MC1_FLIPPED_PINOUT {true} \
    CONFIG.MC_CHANNEL_INTERLEAVING {false} \
    CONFIG.MC_CHAN_REGION0 {DDR_CH1} \
    CONFIG.MC_DM_WIDTH {4} \
    CONFIG.MC_DQS_WIDTH {4} \
    CONFIG.MC_DQ_WIDTH {32} \
    CONFIG.MC_EN_INTR_RESP {TRUE} \
    CONFIG.MC_SYSTEM_CLOCK {Differential} \
    CONFIG.NUM_CLKS {1} \
    CONFIG.NUM_MC {1} \
    CONFIG.NUM_MCP {4} \
    CONFIG.NUM_MI {0} \
    CONFIG.NUM_SI {4} \
    CONFIG.SI_SIDEBAND_PINS {0} \
    CONFIG.sys_clk0_BOARD_INTERFACE {lpddr4_sma_clk1} \
  ] $axi_noc_0


  set_property -dict [ list \
   CONFIG.CONNECTIONS {MC_0 {read_bw {2770} write_bw {2770} read_avg_burst {100} write_avg_burst {100}}} \
   CONFIG.NOC_PARAMS {} \
   CONFIG.CATEGORY {pl} \
 ] [get_bd_intf_pins /axi_noc_0/S00_AXI]

  set_property -dict [ list \
   CONFIG.CONNECTIONS {MC_1 {read_bw {2770} write_bw {2770} read_avg_burst {100} write_avg_burst {100}}} \
   CONFIG.NOC_PARAMS {} \
   CONFIG.CATEGORY {pl} \
 ] [get_bd_intf_pins /axi_noc_0/S01_AXI]

  set_property -dict [ list \
   CONFIG.CONNECTIONS {MC_2 {read_bw {2770} write_bw {2770} read_avg_burst {100} write_avg_burst {100}}} \
   CONFIG.NOC_PARAMS {} \
   CONFIG.CATEGORY {pl} \
 ] [get_bd_intf_pins /axi_noc_0/S02_AXI]

  set_property -dict [ list \
   CONFIG.CONNECTIONS {MC_3 {read_bw {2770} write_bw {2770} read_avg_burst {100} write_avg_burst {100}}} \
   CONFIG.NOC_PARAMS {} \
   CONFIG.CATEGORY {pl} \
 ] [get_bd_intf_pins /axi_noc_0/S03_AXI]

  set_property -dict [ list \
   CONFIG.ASSOCIATED_BUSIF {S00_AXI:S01_AXI:S02_AXI:S03_AXI} \
 ] [get_bd_pins /axi_noc_0/aclk0]

  # Create instance: axi_noc_1, and set properties
  set axi_noc_1 [ create_bd_cell -type ip -vlnv xilinx.com:ip:axi_noc:1.1 axi_noc_1 ]
  set_property -dict [list \
    CONFIG.CH0_LPDDR4_0_BOARD_INTERFACE {ch0_lpddr4_c1} \
    CONFIG.CH1_LPDDR4_0_BOARD_INTERFACE {ch1_lpddr4_c1} \
    CONFIG.MC1_FLIPPED_PINOUT {true} \
    CONFIG.MC_CHANNEL_INTERLEAVING {false} \
    CONFIG.MC_CHAN_REGION0 {DDR_CH2} \
    CONFIG.MC_DM_WIDTH {4} \
    CONFIG.MC_DQS_WIDTH {4} \
    CONFIG.MC_DQ_WIDTH {32} \
    CONFIG.MC_EN_INTR_RESP {TRUE} \
    CONFIG.MC_SYSTEM_CLOCK {Differential} \
    CONFIG.NUM_CLKS {1} \
    CONFIG.NUM_MC {1} \
    CONFIG.NUM_MCP {3} \
    CONFIG.NUM_MI {0} \
    CONFIG.NUM_SI {3} \
    CONFIG.SI_SIDEBAND_PINS {0} \
    CONFIG.sys_clk0_BOARD_INTERFACE {lpddr4_sma_clk2} \
  ] $axi_noc_1


  set_property -dict [ list \
   CONFIG.CONNECTIONS {MC_0 {read_bw {2770} write_bw {2770} read_avg_burst {100} write_avg_burst {100}}} \
   CONFIG.NOC_PARAMS {} \
   CONFIG.CATEGORY {pl} \
 ] [get_bd_intf_pins /axi_noc_1/S00_AXI]

  set_property -dict [ list \
   CONFIG.CONNECTIONS {MC_1 {read_bw {100} write_bw {2800} read_avg_burst {100} write_avg_burst {100}}} \
   CONFIG.NOC_PARAMS {} \
   CONFIG.CATEGORY {pl} \
 ] [get_bd_intf_pins /axi_noc_1/S01_AXI]

  set_property -dict [ list \
   CONFIG.CONNECTIONS {MC_2 {read_bw {100} write_bw {2800} read_avg_burst {100} write_avg_burst {100}}} \
   CONFIG.NOC_PARAMS {} \
   CONFIG.CATEGORY {pl} \
 ] [get_bd_intf_pins /axi_noc_1/S02_AXI]

  set_property -dict [ list \
   CONFIG.ASSOCIATED_BUSIF {S00_AXI:S01_AXI:S02_AXI} \
 ] [get_bd_pins /axi_noc_1/aclk0]

  # Create instance: noc_clk_gen, and set properties
  set noc_clk_gen [ create_bd_cell -type ip -vlnv xilinx.com:ip:clk_gen_sim:1.0 noc_clk_gen ]
  set_property -dict [list \
    CONFIG.USER_AXI_CLK_0_FREQ {250.000} \
    CONFIG.USER_NUM_OF_SYS_CLK {2} \
    CONFIG.USER_SYS_CLK0_FREQ {200.321} \
    CONFIG.USER_SYS_CLK1_FREQ {200.321} \
  ] $noc_clk_gen


  # Create instance: noc_tg_0, and set properties
  set noc_tg_0 [ create_bd_cell -type ip -vlnv xilinx.com:ip:perf_axi_tg:1.0 noc_tg_0 ]
   if {[string equal -nocase [file separator] "/"]} {
    set file_path {/home/amd/training/mem4_dpt/user_files/multple_tgs.csv}
    } else {
    set file_path {c:/training/mem4_dpt/user_files/multple_tgs.csv}
  }
  set_property -dict [list \
    CONFIG.IS_CONN_SLAVE_AXI_NOC {true} \
    CONFIG.USER_C_AXI_CLK_PERIOD {4000} \
    CONFIG.USER_C_AXI_READ_BASEADDR {0x0000050000000000} \
    CONFIG.USER_C_AXI_READ_HIGHADDR {0x00000500FFFFFFFF} \
    CONFIG.USER_C_AXI_SLAVE_DATA_WIDTH {128} \
    CONFIG.USER_C_AXI_WDATA_WIDTH {512} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR {0x0000050000000000} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR_SLV {0x050000000000} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR {0x00000500FFFFFFFF} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR_SLV {0x0500FFFFFFFF} \
    CONFIG.USER_EN_VIO_STATUS_MONITOR {FALSE} \
    CONFIG.USER_NO_OF_SLAVE_CONNECTED {1} \
    CONFIG.USER_PERF_TG {SYNTHESIZABLE} \
    CONFIG.USER_SYNTH_DEFINED_PATTERN_CSV $file_path \
    CONFIG.USER_TRAFFIC_SHAPING_EN {FALSE} \
  ] $noc_tg_0

  set_property -dict [list \
    CONFIG.IS_CONN_SLAVE_AXI_NOC.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_CLK_PERIOD.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_READ_BASEADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_READ_HIGHADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_SLAVE_DATA_WIDTH.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR_SLV.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR_SLV.VALUE_MODE {auto} \
    CONFIG.USER_NO_OF_SLAVE_CONNECTED.VALUE_MODE {auto} \
  ] $noc_tg_0


  # Create instance: noc_sim_trig, and set properties
  set noc_sim_trig [ create_bd_cell -type ip -vlnv xilinx.com:ip:sim_trig:1.0 noc_sim_trig ]
  set_property CONFIG.USER_NUM_AXI_TG {7} $noc_sim_trig


  # Create instance: noc_tg_pmon_0, and set properties
  set noc_tg_pmon_0 [ create_bd_cell -type ip -vlnv xilinx.com:ip:axi_pmon:1.0 noc_tg_pmon_0 ]
  set_property CONFIG.USER_PARAM_AXI_TG_ID {0} $noc_tg_pmon_0


  # Create instance: noc_tg_1, and set properties
  set noc_tg_1 [ create_bd_cell -type ip -vlnv xilinx.com:ip:perf_axi_tg:1.0 noc_tg_1 ]
  set_property -dict [list \
    CONFIG.IS_CONN_SLAVE_AXI_NOC {true} \
    CONFIG.USER_C_AXI_CLK_PERIOD {4000} \
    CONFIG.USER_C_AXI_READ_BASEADDR {0x0000050000000000} \
    CONFIG.USER_C_AXI_READ_HIGHADDR {0x00000500FFFFFFFF} \
    CONFIG.USER_C_AXI_SLAVE_DATA_WIDTH {128} \
    CONFIG.USER_C_AXI_WDATA_WIDTH {512} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR {0x0000050000000000} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR_SLV {0x050000000000} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR {0x00000500FFFFFFFF} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR_SLV {0x0500FFFFFFFF} \
    CONFIG.USER_EN_VIO_STATUS_MONITOR {FALSE} \
    CONFIG.USER_NO_OF_SLAVE_CONNECTED {1} \
    CONFIG.USER_PERF_TG {SYNTHESIZABLE} \
    CONFIG.USER_SYNTH_DEFINED_PATTERN_CSV $file_path \
    CONFIG.USER_TRAFFIC_SHAPING_EN {FALSE} \
  ] $noc_tg_1

  set_property -dict [list \
    CONFIG.IS_CONN_SLAVE_AXI_NOC.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_CLK_PERIOD.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_READ_BASEADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_READ_HIGHADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_SLAVE_DATA_WIDTH.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR_SLV.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR_SLV.VALUE_MODE {auto} \
    CONFIG.USER_NO_OF_SLAVE_CONNECTED.VALUE_MODE {auto} \
  ] $noc_tg_1


  # Create instance: noc_tg_pmon_1, and set properties
  set noc_tg_pmon_1 [ create_bd_cell -type ip -vlnv xilinx.com:ip:axi_pmon:1.0 noc_tg_pmon_1 ]
  set_property CONFIG.USER_PARAM_AXI_TG_ID {1} $noc_tg_pmon_1


  # Create instance: noc_tg_2, and set properties
  set noc_tg_2 [ create_bd_cell -type ip -vlnv xilinx.com:ip:perf_axi_tg:1.0 noc_tg_2 ]
  set_property -dict [list \
    CONFIG.IS_CONN_SLAVE_AXI_NOC {true} \
    CONFIG.USER_C_AXI_CLK_PERIOD {4000} \
    CONFIG.USER_C_AXI_READ_BASEADDR {0x0000050000000000} \
    CONFIG.USER_C_AXI_READ_HIGHADDR {0x00000500FFFFFFFF} \
    CONFIG.USER_C_AXI_SLAVE_DATA_WIDTH {128} \
    CONFIG.USER_C_AXI_WDATA_WIDTH {512} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR {0x0000050000000000} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR_SLV {0x050000000000} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR {0x00000500FFFFFFFF} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR_SLV {0x0500FFFFFFFF} \
    CONFIG.USER_EN_VIO_STATUS_MONITOR {FALSE} \
    CONFIG.USER_NO_OF_SLAVE_CONNECTED {1} \
    CONFIG.USER_PARAM_SRC_ID {2} \
    CONFIG.USER_PERF_TG {SYNTHESIZABLE} \
    CONFIG.USER_SYNTH_DEFINED_PATTERN_CSV $file_path \
    CONFIG.USER_TRAFFIC_SHAPING_EN {FALSE} \
  ] $noc_tg_2

  set_property -dict [list \
    CONFIG.IS_CONN_SLAVE_AXI_NOC.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_CLK_PERIOD.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_READ_BASEADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_READ_HIGHADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_SLAVE_DATA_WIDTH.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR_SLV.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR_SLV.VALUE_MODE {auto} \
    CONFIG.USER_NO_OF_SLAVE_CONNECTED.VALUE_MODE {auto} \
  ] $noc_tg_2


  # Create instance: noc_tg_pmon_2, and set properties
  set noc_tg_pmon_2 [ create_bd_cell -type ip -vlnv xilinx.com:ip:axi_pmon:1.0 noc_tg_pmon_2 ]
  set_property CONFIG.USER_PARAM_AXI_TG_ID {2} $noc_tg_pmon_2


  # Create instance: noc_tg_3, and set properties
  set noc_tg_3 [ create_bd_cell -type ip -vlnv xilinx.com:ip:perf_axi_tg:1.0 noc_tg_3 ]
  set_property -dict [list \
    CONFIG.IS_CONN_SLAVE_AXI_NOC {true} \
    CONFIG.USER_C_AXI_CLK_PERIOD {4000} \
    CONFIG.USER_C_AXI_READ_BASEADDR {0x0000050000000000} \
    CONFIG.USER_C_AXI_READ_HIGHADDR {0x00000500FFFFFFFF} \
    CONFIG.USER_C_AXI_SLAVE_DATA_WIDTH {128} \
    CONFIG.USER_C_AXI_WDATA_WIDTH {512} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR {0x0000050000000000} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR_SLV {0x050000000000} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR {0x00000500FFFFFFFF} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR_SLV {0x0500FFFFFFFF} \
    CONFIG.USER_EN_VIO_STATUS_MONITOR {FALSE} \
    CONFIG.USER_NO_OF_SLAVE_CONNECTED {1} \
    CONFIG.USER_PARAM_SRC_ID {3} \
    CONFIG.USER_PERF_TG {SYNTHESIZABLE} \
    CONFIG.USER_SYNTH_DEFINED_PATTERN_CSV $file_path \
    CONFIG.USER_TRAFFIC_SHAPING_EN {FALSE} \
  ] $noc_tg_3

  set_property -dict [list \
    CONFIG.IS_CONN_SLAVE_AXI_NOC.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_CLK_PERIOD.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_READ_BASEADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_READ_HIGHADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_SLAVE_DATA_WIDTH.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR_SLV.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR_SLV.VALUE_MODE {auto} \
    CONFIG.USER_NO_OF_SLAVE_CONNECTED.VALUE_MODE {auto} \
  ] $noc_tg_3


  # Create instance: noc_tg_pmon_3, and set properties
  set noc_tg_pmon_3 [ create_bd_cell -type ip -vlnv xilinx.com:ip:axi_pmon:1.0 noc_tg_pmon_3 ]
  set_property CONFIG.USER_PARAM_AXI_TG_ID {3} $noc_tg_pmon_3


  # Create instance: noc_tg_4, and set properties
  set noc_tg_4 [ create_bd_cell -type ip -vlnv xilinx.com:ip:perf_axi_tg:1.0 noc_tg_4 ]
  set_property -dict [list \
    CONFIG.IS_CONN_SLAVE_AXI_NOC {true} \
    CONFIG.USER_C_AXI_CLK_PERIOD {4000} \
    CONFIG.USER_C_AXI_READ_BASEADDR {0x0000060000000000} \
    CONFIG.USER_C_AXI_READ_HIGHADDR {0x00000600FFFFFFFF} \
    CONFIG.USER_C_AXI_SLAVE_DATA_WIDTH {128} \
    CONFIG.USER_C_AXI_WDATA_WIDTH {512} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR {0x0000060000000000} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR_SLV {0x060000000000} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR {0x00000600FFFFFFFF} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR_SLV {0x0600FFFFFFFF} \
    CONFIG.USER_EN_VIO_STATUS_MONITOR {FALSE} \
    CONFIG.USER_NO_OF_SLAVE_CONNECTED {1} \
    CONFIG.USER_PARAM_SRC_ID {4} \
    CONFIG.USER_PERF_TG {SYNTHESIZABLE} \
    CONFIG.USER_SYNTH_DEFINED_PATTERN_CSV $file_path \
    CONFIG.USER_TRAFFIC_SHAPING_EN {FALSE} \
  ] $noc_tg_4

  set_property -dict [list \
    CONFIG.IS_CONN_SLAVE_AXI_NOC.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_CLK_PERIOD.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_READ_BASEADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_READ_HIGHADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_SLAVE_DATA_WIDTH.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR_SLV.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR_SLV.VALUE_MODE {auto} \
    CONFIG.USER_NO_OF_SLAVE_CONNECTED.VALUE_MODE {auto} \
  ] $noc_tg_4


  # Create instance: noc_tg_pmon_4, and set properties
  set noc_tg_pmon_4 [ create_bd_cell -type ip -vlnv xilinx.com:ip:axi_pmon:1.0 noc_tg_pmon_4 ]
  set_property CONFIG.USER_PARAM_AXI_TG_ID {4} $noc_tg_pmon_4


  # Create instance: noc_tg_5, and set properties
  set noc_tg_5 [ create_bd_cell -type ip -vlnv xilinx.com:ip:perf_axi_tg:1.0 noc_tg_5 ]
  set_property -dict [list \
    CONFIG.IS_CONN_SLAVE_AXI_NOC {true} \
    CONFIG.USER_C_AXI_CLK_PERIOD {4000} \
    CONFIG.USER_C_AXI_READ_BASEADDR {0x0000060000000000} \
    CONFIG.USER_C_AXI_READ_HIGHADDR {0x00000600FFFFFFFF} \
    CONFIG.USER_C_AXI_SLAVE_DATA_WIDTH {128} \
    CONFIG.USER_C_AXI_WDATA_WIDTH {512} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR {0x0000060000000000} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR_SLV {0x060000000000} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR {0x00000600FFFFFFFF} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR_SLV {0x0600FFFFFFFF} \
    CONFIG.USER_EN_VIO_STATUS_MONITOR {FALSE} \
    CONFIG.USER_NO_OF_SLAVE_CONNECTED {1} \
    CONFIG.USER_PARAM_SRC_ID {5} \
    CONFIG.USER_PERF_TG {SYNTHESIZABLE} \
    CONFIG.USER_SYNTH_DEFINED_PATTERN_CSV $file_path \
    CONFIG.USER_TRAFFIC_SHAPING_EN {FALSE} \
  ] $noc_tg_5

  set_property -dict [list \
    CONFIG.IS_CONN_SLAVE_AXI_NOC.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_CLK_PERIOD.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_READ_BASEADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_READ_HIGHADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_SLAVE_DATA_WIDTH.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR_SLV.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR_SLV.VALUE_MODE {auto} \
    CONFIG.USER_NO_OF_SLAVE_CONNECTED.VALUE_MODE {auto} \
  ] $noc_tg_5


  # Create instance: noc_tg_pmon_5, and set properties
  set noc_tg_pmon_5 [ create_bd_cell -type ip -vlnv xilinx.com:ip:axi_pmon:1.0 noc_tg_pmon_5 ]
  set_property CONFIG.USER_PARAM_AXI_TG_ID {5} $noc_tg_pmon_5


  # Create instance: noc_tg_6, and set properties
  set noc_tg_6 [ create_bd_cell -type ip -vlnv xilinx.com:ip:perf_axi_tg:1.0 noc_tg_6 ]
  set_property -dict [list \
    CONFIG.IS_CONN_SLAVE_AXI_NOC {true} \
    CONFIG.USER_C_AXI_CLK_PERIOD {4000} \
    CONFIG.USER_C_AXI_READ_BASEADDR {0x0000060000000000} \
    CONFIG.USER_C_AXI_READ_HIGHADDR {0x00000600FFFFFFFF} \
    CONFIG.USER_C_AXI_SLAVE_DATA_WIDTH {128} \
    CONFIG.USER_C_AXI_WDATA_WIDTH {512} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR {0x0000060000000000} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR_SLV {0x060000000000} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR {0x00000600FFFFFFFF} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR_SLV {0x0600FFFFFFFF} \
    CONFIG.USER_EN_VIO_STATUS_MONITOR {FALSE} \
    CONFIG.USER_NO_OF_SLAVE_CONNECTED {1} \
    CONFIG.USER_PARAM_SRC_ID {6} \
    CONFIG.USER_PERF_TG {SYNTHESIZABLE} \
    CONFIG.USER_SYNTH_DEFINED_PATTERN_CSV $file_path \
    CONFIG.USER_TRAFFIC_SHAPING_EN {FALSE} \
  ] $noc_tg_6

  set_property -dict [list \
    CONFIG.IS_CONN_SLAVE_AXI_NOC.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_CLK_PERIOD.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_READ_BASEADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_READ_HIGHADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_SLAVE_DATA_WIDTH.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_BASEADDR_SLV.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR.VALUE_MODE {auto} \
    CONFIG.USER_C_AXI_WRITE_HIGHADDR_SLV.VALUE_MODE {auto} \
    CONFIG.USER_NO_OF_SLAVE_CONNECTED.VALUE_MODE {auto} \
  ] $noc_tg_6


  # Create instance: noc_tg_pmon_6, and set properties
  set noc_tg_pmon_6 [ create_bd_cell -type ip -vlnv xilinx.com:ip:axi_pmon:1.0 noc_tg_pmon_6 ]
  set_property CONFIG.USER_PARAM_AXI_TG_ID {6} $noc_tg_pmon_6


  # Create instance: rst_clk_wiz_100M, and set properties
  set rst_clk_wiz_100M [ create_bd_cell -type ip -vlnv xilinx.com:ip:proc_sys_reset:5.0 rst_clk_wiz_100M ]

  # Create instance: sim_clk_gen_0, and set properties
  set sim_clk_gen_0 [ create_bd_cell -type ip -vlnv xilinx.com:ip:sim_clk_gen:1.0 sim_clk_gen_0 ]
  set_property CONFIG.FREQ_HZ {250000000} $sim_clk_gen_0


  # Create interface connections
  connect_bd_intf_net -intf_net SYS_CLK0_IN_1 [get_bd_intf_ports lpddr4_sma_clk1] [get_bd_intf_pins noc_clk_gen/SYS_CLK0_IN]
  connect_bd_intf_net -intf_net SYS_CLK1_IN_1 [get_bd_intf_ports lpddr4_sma_clk2] [get_bd_intf_pins noc_clk_gen/SYS_CLK1_IN]
  connect_bd_intf_net -intf_net axi_noc_0_CH0_LPDDR4_0 [get_bd_intf_ports ch0_lpddr4_c0] [get_bd_intf_pins axi_noc_0/CH0_LPDDR4_0]
  connect_bd_intf_net -intf_net axi_noc_0_CH1_LPDDR4_0 [get_bd_intf_ports ch1_lpddr4_c0] [get_bd_intf_pins axi_noc_0/CH1_LPDDR4_0]
  connect_bd_intf_net -intf_net axi_noc_1_CH0_LPDDR4_0 [get_bd_intf_ports ch0_lpddr4_c1] [get_bd_intf_pins axi_noc_1/CH0_LPDDR4_0]
  connect_bd_intf_net -intf_net axi_noc_1_CH1_LPDDR4_0 [get_bd_intf_ports ch1_lpddr4_c1] [get_bd_intf_pins axi_noc_1/CH1_LPDDR4_0]
  connect_bd_intf_net -intf_net noc_clk_gen_SYS_CLK0 [get_bd_intf_pins axi_noc_0/sys_clk0] [get_bd_intf_pins noc_clk_gen/SYS_CLK0]
  connect_bd_intf_net -intf_net noc_clk_gen_SYS_CLK1 [get_bd_intf_pins axi_noc_1/sys_clk0] [get_bd_intf_pins noc_clk_gen/SYS_CLK1]
  connect_bd_intf_net -intf_net noc_tg_1_M_AXI [get_bd_intf_pins noc_tg_1/M_AXI] [get_bd_intf_pins axi_noc_0/S01_AXI]
connect_bd_intf_net -intf_net [get_bd_intf_nets noc_tg_1_M_AXI] [get_bd_intf_pins noc_tg_1/M_AXI] [get_bd_intf_pins noc_tg_pmon_1/S_AXI]
  set_property SIM_ATTRIBUTE.MARK_SIM "true" [get_bd_intf_nets /noc_tg_1_M_AXI]
  connect_bd_intf_net -intf_net noc_tg_2_M_AXI [get_bd_intf_pins noc_tg_3/M_AXI] [get_bd_intf_pins axi_noc_0/S03_AXI]
connect_bd_intf_net -intf_net [get_bd_intf_nets noc_tg_2_M_AXI] [get_bd_intf_pins noc_tg_3/M_AXI] [get_bd_intf_pins noc_tg_pmon_3/S_AXI]
  set_property SIM_ATTRIBUTE.MARK_SIM "true" [get_bd_intf_nets /noc_tg_2_M_AXI]
  connect_bd_intf_net -intf_net noc_tg_3_M_AXI [get_bd_intf_pins noc_tg_2/M_AXI] [get_bd_intf_pins axi_noc_0/S02_AXI]
connect_bd_intf_net -intf_net [get_bd_intf_nets noc_tg_3_M_AXI] [get_bd_intf_pins noc_tg_2/M_AXI] [get_bd_intf_pins noc_tg_pmon_2/S_AXI]
  set_property SIM_ATTRIBUTE.MARK_SIM "true" [get_bd_intf_nets /noc_tg_3_M_AXI]
  connect_bd_intf_net -intf_net noc_tg_4_M_AXI [get_bd_intf_pins noc_tg_5/M_AXI] [get_bd_intf_pins axi_noc_1/S01_AXI]
connect_bd_intf_net -intf_net [get_bd_intf_nets noc_tg_4_M_AXI] [get_bd_intf_pins noc_tg_5/M_AXI] [get_bd_intf_pins noc_tg_pmon_5/S_AXI]
  set_property SIM_ATTRIBUTE.MARK_SIM "true" [get_bd_intf_nets /noc_tg_4_M_AXI]
  connect_bd_intf_net -intf_net noc_tg_5_M_AXI [get_bd_intf_pins noc_tg_6/M_AXI] [get_bd_intf_pins axi_noc_1/S02_AXI]
connect_bd_intf_net -intf_net [get_bd_intf_nets noc_tg_5_M_AXI] [get_bd_intf_pins noc_tg_6/M_AXI] [get_bd_intf_pins noc_tg_pmon_6/S_AXI]
  set_property SIM_ATTRIBUTE.MARK_SIM "true" [get_bd_intf_nets /noc_tg_5_M_AXI]
  connect_bd_intf_net -intf_net noc_tg_6_M_AXI [get_bd_intf_pins noc_tg_4/M_AXI] [get_bd_intf_pins axi_noc_1/S00_AXI]
connect_bd_intf_net -intf_net [get_bd_intf_nets noc_tg_6_M_AXI] [get_bd_intf_pins noc_tg_4/M_AXI] [get_bd_intf_pins noc_tg_pmon_4/S_AXI]
  set_property SIM_ATTRIBUTE.MARK_SIM "true" [get_bd_intf_nets /noc_tg_6_M_AXI]
  connect_bd_intf_net -intf_net noc_tg_M_AXI [get_bd_intf_pins noc_tg_0/M_AXI] [get_bd_intf_pins axi_noc_0/S00_AXI]
connect_bd_intf_net -intf_net [get_bd_intf_nets noc_tg_M_AXI] [get_bd_intf_pins noc_tg_0/M_AXI] [get_bd_intf_pins noc_tg_pmon_0/S_AXI]
  set_property SIM_ATTRIBUTE.MARK_SIM "true" [get_bd_intf_nets /noc_tg_M_AXI]

  # Create port connections
  connect_bd_net -net clk_wiz_clk_out1  [get_bd_pins sim_clk_gen_0/clk] \
  [get_bd_pins noc_clk_gen/axi_clk_in_0] \
  [get_bd_pins rst_clk_wiz_100M/slowest_sync_clk]
  connect_bd_net -net noc_clk_gen_axi_clk_0  [get_bd_pins noc_clk_gen/axi_clk_0] \
  [get_bd_pins noc_sim_trig/pclk] \
  [get_bd_pins noc_tg_0/clk] \
  [get_bd_pins axi_noc_0/aclk0] \
  [get_bd_pins noc_tg_1/clk] \
  [get_bd_pins noc_tg_3/clk] \
  [get_bd_pins noc_tg_2/clk] \
  [get_bd_pins noc_tg_5/clk] \
  [get_bd_pins axi_noc_1/aclk0] \
  [get_bd_pins noc_tg_6/clk] \
  [get_bd_pins noc_tg_4/clk] \
  [get_bd_pins noc_tg_pmon_0/axi_aclk] \
  [get_bd_pins noc_tg_pmon_1/axi_aclk] \
  [get_bd_pins noc_tg_pmon_3/axi_aclk] \
  [get_bd_pins noc_tg_pmon_2/axi_aclk] \
  [get_bd_pins noc_tg_pmon_4/axi_aclk] \
  [get_bd_pins noc_tg_pmon_6/axi_aclk] \
  [get_bd_pins noc_tg_pmon_5/axi_aclk]
  connect_bd_net -net noc_clk_gen_axi_rst_0_n  [get_bd_pins noc_clk_gen/axi_rst_0_n] \
  [get_bd_pins noc_sim_trig/rst_n] \
  [get_bd_pins noc_tg_0/tg_rst_n] \
  [get_bd_pins noc_tg_1/tg_rst_n] \
  [get_bd_pins noc_tg_3/tg_rst_n] \
  [get_bd_pins noc_tg_2/tg_rst_n] \
  [get_bd_pins noc_tg_5/tg_rst_n] \
  [get_bd_pins noc_tg_6/tg_rst_n] \
  [get_bd_pins noc_tg_4/tg_rst_n] \
  [get_bd_pins noc_tg_pmon_0/axi_arst_n] \
  [get_bd_pins noc_tg_pmon_1/axi_arst_n] \
  [get_bd_pins noc_tg_pmon_3/axi_arst_n] \
  [get_bd_pins noc_tg_pmon_2/axi_arst_n] \
  [get_bd_pins noc_tg_pmon_4/axi_arst_n] \
  [get_bd_pins noc_tg_pmon_6/axi_arst_n] \
  [get_bd_pins noc_tg_pmon_5/axi_arst_n]
  connect_bd_net -net noc_sim_trig_trig_00  [get_bd_pins noc_sim_trig/trig_00] \
  [get_bd_pins noc_tg_0/axi_tg_start]
  connect_bd_net -net noc_sim_trig_trig_01  [get_bd_pins noc_sim_trig/trig_01] \
  [get_bd_pins noc_tg_1/axi_tg_start]
  connect_bd_net -net noc_sim_trig_trig_02  [get_bd_pins noc_sim_trig/trig_02] \
  [get_bd_pins noc_tg_2/axi_tg_start]
  connect_bd_net -net noc_sim_trig_trig_03  [get_bd_pins noc_sim_trig/trig_03] \
  [get_bd_pins noc_tg_3/axi_tg_start]
  connect_bd_net -net noc_sim_trig_trig_04  [get_bd_pins noc_sim_trig/trig_04] \
  [get_bd_pins noc_tg_4/axi_tg_start]
  connect_bd_net -net noc_sim_trig_trig_05  [get_bd_pins noc_sim_trig/trig_05] \
  [get_bd_pins noc_tg_5/axi_tg_start]
  connect_bd_net -net noc_sim_trig_trig_06  [get_bd_pins noc_sim_trig/trig_06] \
  [get_bd_pins noc_tg_6/axi_tg_start]
  connect_bd_net -net noc_tg_1_axi_tg_done  [get_bd_pins noc_tg_1/axi_tg_done] \
  [get_bd_pins noc_sim_trig/all_done_01]
  connect_bd_net -net noc_tg_2_axi_tg_done  [get_bd_pins noc_tg_2/axi_tg_done] \
  [get_bd_pins noc_sim_trig/all_done_02]
  connect_bd_net -net noc_tg_3_axi_tg_done  [get_bd_pins noc_tg_3/axi_tg_done] \
  [get_bd_pins noc_sim_trig/all_done_03]
  connect_bd_net -net noc_tg_4_axi_tg_done  [get_bd_pins noc_tg_4/axi_tg_done] \
  [get_bd_pins noc_sim_trig/all_done_04]
  connect_bd_net -net noc_tg_5_axi_tg_done  [get_bd_pins noc_tg_5/axi_tg_done] \
  [get_bd_pins noc_sim_trig/all_done_05]
  connect_bd_net -net noc_tg_6_axi_tg_done  [get_bd_pins noc_tg_6/axi_tg_done] \
  [get_bd_pins noc_sim_trig/all_done_06]
  connect_bd_net -net noc_tg_axi_tg_done  [get_bd_pins noc_tg_0/axi_tg_done] \
  [get_bd_pins noc_sim_trig/all_done_00]
  connect_bd_net -net rst_clk_wiz_100M_peripheral_aresetn  [get_bd_pins rst_clk_wiz_100M/peripheral_aresetn] \
  [get_bd_pins noc_clk_gen/axi_rst_in_0_n]
  connect_bd_net -net sim_clk_gen_0_sync_rst  [get_bd_pins sim_clk_gen_0/sync_rst] \
  [get_bd_pins rst_clk_wiz_100M/ext_reset_in]

  # Create address segments
  assign_bd_address -offset 0x050000000000 -range 0x000100000000 -target_address_space [get_bd_addr_spaces noc_tg_0/Data] [get_bd_addr_segs axi_noc_0/S00_AXI/C0_DDR_CH1] -force
  assign_bd_address -offset 0x050000000000 -range 0x000100000000 -target_address_space [get_bd_addr_spaces noc_tg_1/Data] [get_bd_addr_segs axi_noc_0/S01_AXI/C1_DDR_CH1] -force
  assign_bd_address -offset 0x050000000000 -range 0x000100000000 -target_address_space [get_bd_addr_spaces noc_tg_2/Data] [get_bd_addr_segs axi_noc_0/S02_AXI/C2_DDR_CH1] -force
  assign_bd_address -offset 0x050000000000 -range 0x000100000000 -target_address_space [get_bd_addr_spaces noc_tg_3/Data] [get_bd_addr_segs axi_noc_0/S03_AXI/C3_DDR_CH1] -force
  assign_bd_address -offset 0x060000000000 -range 0x000100000000 -target_address_space [get_bd_addr_spaces noc_tg_4/Data] [get_bd_addr_segs axi_noc_1/S00_AXI/C0_DDR_CH2] -force
  assign_bd_address -offset 0x060000000000 -range 0x000100000000 -target_address_space [get_bd_addr_spaces noc_tg_5/Data] [get_bd_addr_segs axi_noc_1/S01_AXI/C1_DDR_CH2] -force
  assign_bd_address -offset 0x060000000000 -range 0x000100000000 -target_address_space [get_bd_addr_spaces noc_tg_6/Data] [get_bd_addr_segs axi_noc_1/S02_AXI/C2_DDR_CH2] -force


  # Restore current instance
  current_bd_instance $oldCurInst

  validate_bd_design
  save_bd_design
}
# End of create_root_design()


##################################################################
# MAIN FLOW
##################################################################

create_root_design ""


