###########################################################################################
#   Script to generate the starting point for lab "Debugging the DDRMC"                   #
#   Lab directory: <$TRAINING_PATH>/mem5_dbg                                              #
#	Vivado version: 2025.1                                                                #
#   Lab step 1                                                                            #
#   Note: start this script in folder $TRAINING_PATH/mem5_dbg/ddrmc/scripts               #
#         $TRAINING_PATH is either c:\training or /home/amd/training                      #
###########################################################################################


#<copyright-disclaimer-start>
#<copyright-disclaimer-start>
#  **************************************************************************************************************
#  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
#  * DISCLAIMER                                                                                                 *
#  * The information contained herein is for informational purposes only, and is subject to change              *
#  * without notice. While every precaution has been taken in the preparation of this document, it              *
#  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
#  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
#  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
#  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
#  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
#  * hardware, software or other products described herein.  No license, including implied or                   *
#  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
#  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
#  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
#  *                                                                                                            *
#  **************************************************************************************************************
#<copyright-disclaimer-end>
#<copyright-disclaimer-end> 

#!/usr/bin/tclsh
variable hostOS [lindex $tcl_platform(os) 0]
if { $hostOS == "Windows" } {
    set TRAINING_PATH "C:\\training"
    set xilinxPath "C:\\Xilinx"
} else {
    set TRAINING_PATH "/home/amd/training"
    set xilinxPath "/opt/xilinx"
}


create_project mif_ddr4 $::env(TRAINING_PATH)/mem5_dbg/ddrmc/lab -part xcvc1902-vsva2197-2MP-e-S -force
set_property board_part xilinx.com:vck190:part0:3.2 [current_project]
set_property coreContainer.enable 1 [current_project]

cd $::env(TRAINING_PATH)/mem5_dbg/ddrmc/scripts

source generate_block_design.tcl

# Make wrapper file
make_wrapper -files [get_files $::env(TRAINING_PATH)/mem5_dbg/ddrmc/lab/mif_ddr4.srcs/sources_1/bd/ddr4_lpddr4/ddr4_lpddr4.bd] -top
add_files -norecurse $::env(TRAINING_PATH)/mem5_dbg/ddrmc/lab/mif_ddr4.gen/sources_1/bd/ddr4_lpddr4/hdl/ddr4_lpddr4_wrapper.v
update_compile_order -fileset sources_1

regenerate_bd_layout

puts " +++ Starting point for this lab created +++";
