//<copyright-disclaimer-start>
//  * © 2024 Advanced Micro Devices, Inc. All rights reserve
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
///////////////////////////////////////////////////////////////////////////
//  *                                                                                                            *                                                
//  * DISCLAIMER                                                                                                 *
//  * The information contained herein is for informational purposes only, and is subject to change              *
//  * without notice. While every precaution has been taken in the preparation of this document, it              *
//  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
//  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
//  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
//  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
//  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
//  * hardware, software or other products described herein.  No license, including implied or                   *
//  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
//  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
//  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
//  *                                                                                                            *
//  **************************************************************************************************************
//<copyright-disclaimer-end>

#include <stdio.h>
#include "platform.h"
#include "xil_printf.h"
#include "xil_io.h"
#include "xparameters.h"

#define DDR4_BASEADDR   0x0
#define LPDDR4_BASEADDR 0x050000000000

int main()
{

    init_platform();

    xil_printf("Versal Multiple DDRMCs Example Design\n\r");
    xil_printf("DDR4 Write Access \r\n");
    for(int i=0; i<10; i++)
    {
    	Xil_Out64(DDR4_BASEADDR + (8 * i),i);
    	xil_printf("0x%p  :  0x%x\r\n",DDR4_BASEADDR + (8 * i),i);
    }

    xil_printf("DDR4 Read Access \r\n");
    for(int i=0; i<10; i++)
    {
		xil_printf("0x%p  :  0x%x\r\n",DDR4_BASEADDR + (8 * i),Xil_In64(DDR4_BASEADDR + (8 * i)));
	}

    xil_printf("LPDDR4 Write Access \r\n");
     for(int i=0; i<10; i++)
    {
    	Xil_Out64(LPDDR4_BASEADDR + (8 * i),i);
     	xil_printf("0x%p  :  0x%x\r\n",LPDDR4_BASEADDR + (8 * i),i);
     }

    xil_printf("LPDDR4 Read Access \r\n");
    for(int i=0; i<10; i++)
    {
		xil_printf("0x%p  :  0x%x\r\n",LPDDR4_BASEADDR + (8 * i),Xil_In64(LPDDR4_BASEADDR + (8 * i)));
	}

    cleanup_platform();
    return 0;
}
