//<copyright-disclaimer-start>
//  **************************************************************************************************************
//  * © 2026 Advanced Micro Devices, Inc. All rights reserved.                                                   *
//  * DISCLAIMER                                                                                                 *
//  * The information contained herein is for informational purposes only, and is subject to change              *
//  * without notice. While every precaution has been taken in the preparation of this document, it              *
//  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
//  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
//  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
//  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
//  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
//  * hardware, software or other products described herein.  No license, including implied or                   *
//  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
//  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
//  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
//  *                                                                                                            *
//  **************************************************************************************************************
//<copyright-disclaimer-end>


#pragma once

#include "include.h"
#include <adf.h>
using namespace adf;

void weighted_sum(input_buffer<int32,extents<NUM_SAM>> & in, output_buffer<int32,extents<NUM_SAM>> & out);
void weighted_sum_with_margin(input_buffer<int32,extents<NUM_SAM>,margin<MARGIN>> & in, output_buffer<int32,extents<NUM_SAM>> & out);
void vectorized_weighted_sum_with_margin(input_buffer<int32,extents<NUM_SAM>,margin<MARGIN>> & restrict in, output_buffer<int32,extents<NUM_SAM>> & restrict out);

void average_div(input_buffer<int32,extents<NUM_SAM>> & in, output_buffer<int32,extents<NUM_SAM>> & out);
void vectorized_average_div(input_buffer<int32,extents<NUM_SAM>> & restrict in, output_buffer<int32, extents<NUM_SAM>> & restrict out);
