//<copyright-disclaimer-start>
//  **************************************************************************************************************
//  * © 2026 Advanced Micro Devices, Inc. All rights reserved.                                                   *
//  * DISCLAIMER                                                                                                 *
//  * The information contained herein is for informational purposes only, and is subject to change              *
//  * without notice. While every precaution has been taken in the preparation of this document, it              *
//  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
//  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
//  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
//  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
//  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
//  * hardware, software or other products described herein.  No license, including implied or                   *
//  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
//  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
//  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
//  *                                                                                                            *
//  **************************************************************************************************************
//<copyright-disclaimer-end>


#pragma once

#include <adf.h>
#include "include.h"
#include "aie_kernels.h"
#include "configuration.h"

using namespace adf;

/*
 * ADF dataflow graph to compute weighted moving average of 
 * the last 8 samples in a stream of numbers
 */

class GraphScalar : public adf::graph
{
private:
	kernel k1;
	kernel k2;

public:
	input_plio pl_in;
	output_plio pl_out;

	GraphScalar()
	{
		//Create PLIO ports
		pl_in = input_plio::create("PLIO_In0", plio_32_bits, SCALAR_INPUT_FILE, 250.0);
		pl_out = output_plio::create("PLIO_Out0", plio_32_bits, SCALAR_OUTPUT_FILE, 250.0);

		// create kernels
	#ifndef WITH_MARGIN
		k1 = kernel::create(weighted_sum);
	#else
		k1 = kernel::create(weighted_sum_with_margin);
	#endif
		k2 = kernel::create(average_div);

		// create nets to connect kernels and IO ports
	#ifndef WITH_MARGIN
		connect<> net0 (pl_in.out[0], k1.in[0]);
	#else
		connect<> net0 (pl_in.out[0], k1.in[0]);
	#endif

		connect<> net1 (k1.out[0], k2.in[0]);
		connect<> net2 (k2.out[0], pl_out.in[0]);

		// specify kernel sources
		source(k1) = "kernels/weighted_sum.cc";
		source(k2) = "kernels/average_div.cc";

	#ifdef LOCATION_CONSTRAINT
		// specify kernel location
		location <kernel> (k1) = tile (22,0);
		location <kernel> (k2) = tile (23,4);
	#endif

	#ifndef RUNTIME_RATIO
		// specify kernel run times
		runtime<ratio>(k1) = 0.4;
		runtime<ratio>(k2) = 0.4;
	#else
		// specify kernel run times
		runtime<ratio>(k1) = 0.6;
		runtime<ratio>(k2) = 0.6;
	#endif
	}
};

#ifdef VECTORIZED_KERNEL

class GraphVector : public adf::graph
{
private:
	kernel k1;
	kernel k2;

public:
	input_plio pl_in;
	output_plio pl_out;

	GraphVector()
	{
		pl_in = input_plio::create("PLIO_In1", plio_32_bits, VECTOR_INPUT_FILE, 250.0);
		pl_out = output_plio::create("PLIO_Out1", plio_32_bits, VECTOR_OUTPUT_FILE, 250.0);

		// create kernels
		k1 = kernel::create(vectorized_weighted_sum_with_margin);
		k2 = kernel::create(vectorized_average_div);

		// create nets to connect kernels and IO ports
		connect<> net0 (pl_in.out[0], k1.in[0]);
		connect<> net1 (k1.out[0], k2.in[0]);
		connect<> net2 (k2.out[0], pl_out.in[0]);

		// specify kernel sources
		source(k1) = "kernels/weighted_sum.cc";
		source(k2) = "kernels/average_div.cc";

	#ifdef LOCATION_CONSTRAINT
		// specify kernel location
		location <kernel> (k1) = tile (27,5);
		location <kernel> (k2) = tile (26,5);
	#endif

	#ifndef RUNTIME_RATIO
		// specify kernel run times
		runtime<ratio>(k1) = 0.4;
		runtime<ratio>(k2) = 0.4;
	#else
		// specify kernel run times
		runtime<ratio>(k1) = 0.6;
		runtime<ratio>(k2) = 0.6;
	#endif
	}
};
#endif  // VECTORIZED_KERNEL

