/*
 * Copyright (C) 2019-2022, Xilinx, Inc.
 * Copyright (C) 2022-2025, Advanced Micro Devices, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#if __SUPPORTS_CFLOAT__ == 1
alignas(__ALIGN_BYTE_SIZE__) const cfloat sincosLUTFloat1[1024] = {
    {1.000000000, 0.000000000},   {0.999981165, 0.006135885},   {0.999924719, 0.012271538},
    {0.999830604, 0.018406730},   {0.999698818, 0.024541229},   {0.999529421, 0.030674804},
    {0.999322355, 0.036807224},   {0.999077737, 0.042938258},   {0.998795450, 0.049067676},
    {0.998475552, 0.055195246},   {0.998118103, 0.061320737},   {0.997723043, 0.067443922},
    {0.997290432, 0.073564567},   {0.996820271, 0.079682440},   {0.996312618, 0.085797310},
    {0.995767415, 0.091908954},   {0.995184720, 0.098017141},   {0.994564593, 0.104121633},
    {0.993906975, 0.110222206},   {0.993211925, 0.116318628},   {0.992479563, 0.122410677},
    {0.991709769, 0.128498107},   {0.990902662, 0.134580702},   {0.990058184, 0.140658244},
    {0.989176512, 0.146730468},   {0.988257587, 0.152797192},   {0.987301409, 0.158858150},
    {0.986308098, 0.164913118},   {0.985277653, 0.170961887},   {0.984210074, 0.177004218},
    {0.983105481, 0.183039889},   {0.981963873, 0.189068660},   {0.980785251, 0.195090324},
    {0.979569793, 0.201104641},   {0.978317380, 0.207111374},   {0.977028131, 0.213110313},
    {0.975702107, 0.219101235},   {0.974339366, 0.225083917},   {0.972939968, 0.231058106},
    {0.971503913, 0.237023607},   {0.970031261, 0.242980182},   {0.968522072, 0.248927608},
    {0.966976464, 0.254865646},   {0.965394437, 0.260794103},   {0.963776052, 0.266712755},
    {0.962121427, 0.272621363},   {0.960430503, 0.278519690},   {0.958703458, 0.284407526},
    {0.956940353, 0.290284663},   {0.955141187, 0.296150893},   {0.953306019, 0.302005947},
    {0.951435030, 0.307849646},   {0.949528158, 0.313681751},   {0.947585583, 0.319502026},
    {0.945607305, 0.325310290},   {0.943593442, 0.331106305},   {0.941544056, 0.336889863},
    {0.939459205, 0.342660725},   {0.937339008, 0.348418683},   {0.935183525, 0.354163527},
    {0.932992816, 0.359895051},   {0.930766940, 0.365612984},   {0.928506076, 0.371317208},
    {0.926210225, 0.377007425},   {0.923879504, 0.382683426},   {0.921514034, 0.388345033},
    {0.919113874, 0.393992037},   {0.916679084, 0.399624199},   {0.914209783, 0.405241311},
    {0.911706030, 0.410843164},   {0.909168005, 0.416429549},   {0.906595707, 0.422000259},
    {0.903989315, 0.427555084},   {0.901348829, 0.433093816},   {0.898674488, 0.438616246},
    {0.895966232, 0.444122136},   {0.893224299, 0.449611336},   {0.890448749, 0.455083579},
    {0.887639642, 0.460538715},   {0.884797096, 0.465976506},   {0.881921291, 0.471396744},
    {0.879012227, 0.476799220},   {0.876070082, 0.482183784},   {0.873094976, 0.487550169},
    {0.870086968, 0.492898196},   {0.867046237, 0.498227656},   {0.863972843, 0.503538370},
    {0.860866964, 0.508830130},   {0.857728601, 0.514102757},   {0.854557991, 0.519356012},
    {0.851355195, 0.524589658},   {0.848120332, 0.529803634},   {0.844853580, 0.534997642},
    {0.841554999, 0.540171444},   {0.838224709, 0.545324981},   {0.834862888, 0.550457954},
    {0.831469595, 0.555570245},   {0.828045070, 0.560661554},   {0.824589312, 0.565731823},
    {0.821102500, 0.570780754},   {0.817584813, 0.575808167},   {0.814036310, 0.580813944},
    {0.810457170, 0.585797846},   {0.806847572, 0.590759695},   {0.803207517, 0.595699310},
    {0.799537241, 0.600616455},   {0.795836926, 0.605511069},   {0.792106569, 0.610382795},
    {0.788346410, 0.615231574},   {0.784556568, 0.620057225},   {0.780737221, 0.624859512},
    {0.776888490, 0.629638255},   {0.773010433, 0.634393275},   {0.769103348, 0.639124453},
    {0.765167236, 0.643831551},   {0.761202395, 0.648514390},   {0.757208824, 0.653172851},
    {0.753186822, 0.657806695},   {0.749136388, 0.662415802},   {0.745057762, 0.666999936},
    {0.740951121, 0.671558976},   {0.736816585, 0.676092684},   {0.732654274, 0.680601001},
    {0.728464365, 0.685083687},   {0.724247098, 0.689540565},   {0.720002532, 0.693971455},
    {0.715730846, 0.698376238},   {0.711432219, 0.702754736},   {0.707106769, 0.707106769},
    {0.702754736, 0.711432219},   {0.698376238, 0.715730846},   {0.693971455, 0.720002532},
    {0.689540565, 0.724247098},   {0.685083687, 0.728464365},   {0.680601001, 0.732654274},
    {0.676092684, 0.736816585},   {0.671558976, 0.740951121},   {0.666999936, 0.745057762},
    {0.662415802, 0.749136388},   {0.657806695, 0.753186822},   {0.653172851, 0.757208824},
    {0.648514390, 0.761202395},   {0.643831551, 0.765167236},   {0.639124453, 0.769103348},
    {0.634393275, 0.773010433},   {0.629638255, 0.776888490},   {0.624859512, 0.780737221},
    {0.620057225, 0.784556568},   {0.615231574, 0.788346410},   {0.610382795, 0.792106569},
    {0.605511069, 0.795836926},   {0.600616455, 0.799537241},   {0.595699310, 0.803207517},
    {0.590759695, 0.806847572},   {0.585797846, 0.810457170},   {0.580813944, 0.814036310},
    {0.575808167, 0.817584813},   {0.570780754, 0.821102500},   {0.565731823, 0.824589312},
    {0.560661554, 0.828045070},   {0.555570245, 0.831469595},   {0.550457954, 0.834862888},
    {0.545324981, 0.838224709},   {0.540171444, 0.841554999},   {0.534997642, 0.844853580},
    {0.529803634, 0.848120332},   {0.524589658, 0.851355195},   {0.519356012, 0.854557991},
    {0.514102757, 0.857728601},   {0.508830130, 0.860866964},   {0.503538370, 0.863972843},
    {0.498227656, 0.867046237},   {0.492898196, 0.870086968},   {0.487550169, 0.873094976},
    {0.482183784, 0.876070082},   {0.476799220, 0.879012227},   {0.471396744, 0.881921291},
    {0.465976506, 0.884797096},   {0.460538715, 0.887639642},   {0.455083579, 0.890448749},
    {0.449611336, 0.893224299},   {0.444122136, 0.895966232},   {0.438616246, 0.898674488},
    {0.433093816, 0.901348829},   {0.427555084, 0.903989315},   {0.422000259, 0.906595707},
    {0.416429549, 0.909168005},   {0.410843164, 0.911706030},   {0.405241311, 0.914209783},
    {0.399624199, 0.916679084},   {0.393992037, 0.919113874},   {0.388345033, 0.921514034},
    {0.382683426, 0.923879504},   {0.377007425, 0.926210225},   {0.371317208, 0.928506076},
    {0.365612984, 0.930766940},   {0.359895051, 0.932992816},   {0.354163527, 0.935183525},
    {0.348418683, 0.937339008},   {0.342660725, 0.939459205},   {0.336889863, 0.941544056},
    {0.331106305, 0.943593442},   {0.325310290, 0.945607305},   {0.319502026, 0.947585583},
    {0.313681751, 0.949528158},   {0.307849646, 0.951435030},   {0.302005947, 0.953306019},
    {0.296150893, 0.955141187},   {0.290284663, 0.956940353},   {0.284407526, 0.958703458},
    {0.278519690, 0.960430503},   {0.272621363, 0.962121427},   {0.266712755, 0.963776052},
    {0.260794103, 0.965394437},   {0.254865646, 0.966976464},   {0.248927608, 0.968522072},
    {0.242980182, 0.970031261},   {0.237023607, 0.971503913},   {0.231058106, 0.972939968},
    {0.225083917, 0.974339366},   {0.219101235, 0.975702107},   {0.213110313, 0.977028131},
    {0.207111374, 0.978317380},   {0.201104641, 0.979569793},   {0.195090324, 0.980785251},
    {0.189068660, 0.981963873},   {0.183039889, 0.983105481},   {0.177004218, 0.984210074},
    {0.170961887, 0.985277653},   {0.164913118, 0.986308098},   {0.158858150, 0.987301409},
    {0.152797192, 0.988257587},   {0.146730468, 0.989176512},   {0.140658244, 0.990058184},
    {0.134580702, 0.990902662},   {0.128498107, 0.991709769},   {0.122410677, 0.992479563},
    {0.116318628, 0.993211925},   {0.110222206, 0.993906975},   {0.104121633, 0.994564593},
    {0.098017141, 0.995184720},   {0.091908954, 0.995767415},   {0.085797310, 0.996312618},
    {0.079682440, 0.996820271},   {0.073564567, 0.997290432},   {0.067443922, 0.997723043},
    {0.061320737, 0.998118103},   {0.055195246, 0.998475552},   {0.049067676, 0.998795450},
    {0.042938258, 0.999077737},   {0.036807224, 0.999322355},   {0.030674804, 0.999529421},
    {0.024541229, 0.999698818},   {0.018406730, 0.999830604},   {0.012271538, 0.999924719},
    {0.006135885, 0.999981165},   {0.000000000, 1.000000000},   {-0.006135885, 0.999981165},
    {-0.012271538, 0.999924719},  {-0.018406730, 0.999830604},  {-0.024541229, 0.999698818},
    {-0.030674804, 0.999529421},  {-0.036807224, 0.999322355},  {-0.042938258, 0.999077737},
    {-0.049067676, 0.998795450},  {-0.055195246, 0.998475552},  {-0.061320737, 0.998118103},
    {-0.067443922, 0.997723043},  {-0.073564567, 0.997290432},  {-0.079682440, 0.996820271},
    {-0.085797310, 0.996312618},  {-0.091908954, 0.995767415},  {-0.098017141, 0.995184720},
    {-0.104121633, 0.994564593},  {-0.110222206, 0.993906975},  {-0.116318628, 0.993211925},
    {-0.122410677, 0.992479563},  {-0.128498107, 0.991709769},  {-0.134580702, 0.990902662},
    {-0.140658244, 0.990058184},  {-0.146730468, 0.989176512},  {-0.152797192, 0.988257587},
    {-0.158858150, 0.987301409},  {-0.164913118, 0.986308098},  {-0.170961887, 0.985277653},
    {-0.177004218, 0.984210074},  {-0.183039889, 0.983105481},  {-0.189068660, 0.981963873},
    {-0.195090324, 0.980785251},  {-0.201104641, 0.979569793},  {-0.207111374, 0.978317380},
    {-0.213110313, 0.977028131},  {-0.219101235, 0.975702107},  {-0.225083917, 0.974339366},
    {-0.231058106, 0.972939968},  {-0.237023607, 0.971503913},  {-0.242980182, 0.970031261},
    {-0.248927608, 0.968522072},  {-0.254865646, 0.966976464},  {-0.260794103, 0.965394437},
    {-0.266712755, 0.963776052},  {-0.272621363, 0.962121427},  {-0.278519690, 0.960430503},
    {-0.284407526, 0.958703458},  {-0.290284663, 0.956940353},  {-0.296150893, 0.955141187},
    {-0.302005947, 0.953306019},  {-0.307849646, 0.951435030},  {-0.313681751, 0.949528158},
    {-0.319502026, 0.947585583},  {-0.325310290, 0.945607305},  {-0.331106305, 0.943593442},
    {-0.336889863, 0.941544056},  {-0.342660725, 0.939459205},  {-0.348418683, 0.937339008},
    {-0.354163527, 0.935183525},  {-0.359895051, 0.932992816},  {-0.365612984, 0.930766940},
    {-0.371317208, 0.928506076},  {-0.377007425, 0.926210225},  {-0.382683426, 0.923879504},
    {-0.388345033, 0.921514034},  {-0.393992037, 0.919113874},  {-0.399624199, 0.916679084},
    {-0.405241311, 0.914209783},  {-0.410843164, 0.911706030},  {-0.416429549, 0.909168005},
    {-0.422000259, 0.906595707},  {-0.427555084, 0.903989315},  {-0.433093816, 0.901348829},
    {-0.438616246, 0.898674488},  {-0.444122136, 0.895966232},  {-0.449611336, 0.893224299},
    {-0.455083579, 0.890448749},  {-0.460538715, 0.887639642},  {-0.465976506, 0.884797096},
    {-0.471396744, 0.881921291},  {-0.476799220, 0.879012227},  {-0.482183784, 0.876070082},
    {-0.487550169, 0.873094976},  {-0.492898196, 0.870086968},  {-0.498227656, 0.867046237},
    {-0.503538370, 0.863972843},  {-0.508830130, 0.860866964},  {-0.514102757, 0.857728601},
    {-0.519356012, 0.854557991},  {-0.524589658, 0.851355195},  {-0.529803634, 0.848120332},
    {-0.534997642, 0.844853580},  {-0.540171444, 0.841554999},  {-0.545324981, 0.838224709},
    {-0.550457954, 0.834862888},  {-0.555570245, 0.831469595},  {-0.560661554, 0.828045070},
    {-0.565731823, 0.824589312},  {-0.570780754, 0.821102500},  {-0.575808167, 0.817584813},
    {-0.580813944, 0.814036310},  {-0.585797846, 0.810457170},  {-0.590759695, 0.806847572},
    {-0.595699310, 0.803207517},  {-0.600616455, 0.799537241},  {-0.605511069, 0.795836926},
    {-0.610382795, 0.792106569},  {-0.615231574, 0.788346410},  {-0.620057225, 0.784556568},
    {-0.624859512, 0.780737221},  {-0.629638255, 0.776888490},  {-0.634393275, 0.773010433},
    {-0.639124453, 0.769103348},  {-0.643831551, 0.765167236},  {-0.648514390, 0.761202395},
    {-0.653172851, 0.757208824},  {-0.657806695, 0.753186822},  {-0.662415802, 0.749136388},
    {-0.666999936, 0.745057762},  {-0.671558976, 0.740951121},  {-0.676092684, 0.736816585},
    {-0.680601001, 0.732654274},  {-0.685083687, 0.728464365},  {-0.689540565, 0.724247098},
    {-0.693971455, 0.720002532},  {-0.698376238, 0.715730846},  {-0.702754736, 0.711432219},
    {-0.707106769, 0.707106769},  {-0.711432219, 0.702754736},  {-0.715730846, 0.698376238},
    {-0.720002532, 0.693971455},  {-0.724247098, 0.689540565},  {-0.728464365, 0.685083687},
    {-0.732654274, 0.680601001},  {-0.736816585, 0.676092684},  {-0.740951121, 0.671558976},
    {-0.745057762, 0.666999936},  {-0.749136388, 0.662415802},  {-0.753186822, 0.657806695},
    {-0.757208824, 0.653172851},  {-0.761202395, 0.648514390},  {-0.765167236, 0.643831551},
    {-0.769103348, 0.639124453},  {-0.773010433, 0.634393275},  {-0.776888490, 0.629638255},
    {-0.780737221, 0.624859512},  {-0.784556568, 0.620057225},  {-0.788346410, 0.615231574},
    {-0.792106569, 0.610382795},  {-0.795836926, 0.605511069},  {-0.799537241, 0.600616455},
    {-0.803207517, 0.595699310},  {-0.806847572, 0.590759695},  {-0.810457170, 0.585797846},
    {-0.814036310, 0.580813944},  {-0.817584813, 0.575808167},  {-0.821102500, 0.570780754},
    {-0.824589312, 0.565731823},  {-0.828045070, 0.560661554},  {-0.831469595, 0.555570245},
    {-0.834862888, 0.550457954},  {-0.838224709, 0.545324981},  {-0.841554999, 0.540171444},
    {-0.844853580, 0.534997642},  {-0.848120332, 0.529803634},  {-0.851355195, 0.524589658},
    {-0.854557991, 0.519356012},  {-0.857728601, 0.514102757},  {-0.860866964, 0.508830130},
    {-0.863972843, 0.503538370},  {-0.867046237, 0.498227656},  {-0.870086968, 0.492898196},
    {-0.873094976, 0.487550169},  {-0.876070082, 0.482183784},  {-0.879012227, 0.476799220},
    {-0.881921291, 0.471396744},  {-0.884797096, 0.465976506},  {-0.887639642, 0.460538715},
    {-0.890448749, 0.455083579},  {-0.893224299, 0.449611336},  {-0.895966232, 0.444122136},
    {-0.898674488, 0.438616246},  {-0.901348829, 0.433093816},  {-0.903989315, 0.427555084},
    {-0.906595707, 0.422000259},  {-0.909168005, 0.416429549},  {-0.911706030, 0.410843164},
    {-0.914209783, 0.405241311},  {-0.916679084, 0.399624199},  {-0.919113874, 0.393992037},
    {-0.921514034, 0.388345033},  {-0.923879504, 0.382683426},  {-0.926210225, 0.377007425},
    {-0.928506076, 0.371317208},  {-0.930766940, 0.365612984},  {-0.932992816, 0.359895051},
    {-0.935183525, 0.354163527},  {-0.937339008, 0.348418683},  {-0.939459205, 0.342660725},
    {-0.941544056, 0.336889863},  {-0.943593442, 0.331106305},  {-0.945607305, 0.325310290},
    {-0.947585583, 0.319502026},  {-0.949528158, 0.313681751},  {-0.951435030, 0.307849646},
    {-0.953306019, 0.302005947},  {-0.955141187, 0.296150893},  {-0.956940353, 0.290284663},
    {-0.958703458, 0.284407526},  {-0.960430503, 0.278519690},  {-0.962121427, 0.272621363},
    {-0.963776052, 0.266712755},  {-0.965394437, 0.260794103},  {-0.966976464, 0.254865646},
    {-0.968522072, 0.248927608},  {-0.970031261, 0.242980182},  {-0.971503913, 0.237023607},
    {-0.972939968, 0.231058106},  {-0.974339366, 0.225083917},  {-0.975702107, 0.219101235},
    {-0.977028131, 0.213110313},  {-0.978317380, 0.207111374},  {-0.979569793, 0.201104641},
    {-0.980785251, 0.195090324},  {-0.981963873, 0.189068660},  {-0.983105481, 0.183039889},
    {-0.984210074, 0.177004218},  {-0.985277653, 0.170961887},  {-0.986308098, 0.164913118},
    {-0.987301409, 0.158858150},  {-0.988257587, 0.152797192},  {-0.989176512, 0.146730468},
    {-0.990058184, 0.140658244},  {-0.990902662, 0.134580702},  {-0.991709769, 0.128498107},
    {-0.992479563, 0.122410677},  {-0.993211925, 0.116318628},  {-0.993906975, 0.110222206},
    {-0.994564593, 0.104121633},  {-0.995184720, 0.098017141},  {-0.995767415, 0.091908954},
    {-0.996312618, 0.085797310},  {-0.996820271, 0.079682440},  {-0.997290432, 0.073564567},
    {-0.997723043, 0.067443922},  {-0.998118103, 0.061320737},  {-0.998475552, 0.055195246},
    {-0.998795450, 0.049067676},  {-0.999077737, 0.042938258},  {-0.999322355, 0.036807224},
    {-0.999529421, 0.030674804},  {-0.999698818, 0.024541229},  {-0.999830604, 0.018406730},
    {-0.999924719, 0.012271538},  {-0.999981165, 0.006135885},  {-1.000000000, 0.000000000},
    {-0.999981165, -0.006135885}, {-0.999924719, -0.012271538}, {-0.999830604, -0.018406730},
    {-0.999698818, -0.024541229}, {-0.999529421, -0.030674804}, {-0.999322355, -0.036807224},
    {-0.999077737, -0.042938258}, {-0.998795450, -0.049067676}, {-0.998475552, -0.055195246},
    {-0.998118103, -0.061320737}, {-0.997723043, -0.067443922}, {-0.997290432, -0.073564567},
    {-0.996820271, -0.079682440}, {-0.996312618, -0.085797310}, {-0.995767415, -0.091908954},
    {-0.995184720, -0.098017141}, {-0.994564593, -0.104121633}, {-0.993906975, -0.110222206},
    {-0.993211925, -0.116318628}, {-0.992479563, -0.122410677}, {-0.991709769, -0.128498107},
    {-0.990902662, -0.134580702}, {-0.990058184, -0.140658244}, {-0.989176512, -0.146730468},
    {-0.988257587, -0.152797192}, {-0.987301409, -0.158858150}, {-0.986308098, -0.164913118},
    {-0.985277653, -0.170961887}, {-0.984210074, -0.177004218}, {-0.983105481, -0.183039889},
    {-0.981963873, -0.189068660}, {-0.980785251, -0.195090324}, {-0.979569793, -0.201104641},
    {-0.978317380, -0.207111374}, {-0.977028131, -0.213110313}, {-0.975702107, -0.219101235},
    {-0.974339366, -0.225083917}, {-0.972939968, -0.231058106}, {-0.971503913, -0.237023607},
    {-0.970031261, -0.242980182}, {-0.968522072, -0.248927608}, {-0.966976464, -0.254865646},
    {-0.965394437, -0.260794103}, {-0.963776052, -0.266712755}, {-0.962121427, -0.272621363},
    {-0.960430503, -0.278519690}, {-0.958703458, -0.284407526}, {-0.956940353, -0.290284663},
    {-0.955141187, -0.296150893}, {-0.953306019, -0.302005947}, {-0.951435030, -0.307849646},
    {-0.949528158, -0.313681751}, {-0.947585583, -0.319502026}, {-0.945607305, -0.325310290},
    {-0.943593442, -0.331106305}, {-0.941544056, -0.336889863}, {-0.939459205, -0.342660725},
    {-0.937339008, -0.348418683}, {-0.935183525, -0.354163527}, {-0.932992816, -0.359895051},
    {-0.930766940, -0.365612984}, {-0.928506076, -0.371317208}, {-0.926210225, -0.377007425},
    {-0.923879504, -0.382683426}, {-0.921514034, -0.388345033}, {-0.919113874, -0.393992037},
    {-0.916679084, -0.399624199}, {-0.914209783, -0.405241311}, {-0.911706030, -0.410843164},
    {-0.909168005, -0.416429549}, {-0.906595707, -0.422000259}, {-0.903989315, -0.427555084},
    {-0.901348829, -0.433093816}, {-0.898674488, -0.438616246}, {-0.895966232, -0.444122136},
    {-0.893224299, -0.449611336}, {-0.890448749, -0.455083579}, {-0.887639642, -0.460538715},
    {-0.884797096, -0.465976506}, {-0.881921291, -0.471396744}, {-0.879012227, -0.476799220},
    {-0.876070082, -0.482183784}, {-0.873094976, -0.487550169}, {-0.870086968, -0.492898196},
    {-0.867046237, -0.498227656}, {-0.863972843, -0.503538370}, {-0.860866964, -0.508830130},
    {-0.857728601, -0.514102757}, {-0.854557991, -0.519356012}, {-0.851355195, -0.524589658},
    {-0.848120332, -0.529803634}, {-0.844853580, -0.534997642}, {-0.841554999, -0.540171444},
    {-0.838224709, -0.545324981}, {-0.834862888, -0.550457954}, {-0.831469595, -0.555570245},
    {-0.828045070, -0.560661554}, {-0.824589312, -0.565731823}, {-0.821102500, -0.570780754},
    {-0.817584813, -0.575808167}, {-0.814036310, -0.580813944}, {-0.810457170, -0.585797846},
    {-0.806847572, -0.590759695}, {-0.803207517, -0.595699310}, {-0.799537241, -0.600616455},
    {-0.795836926, -0.605511069}, {-0.792106569, -0.610382795}, {-0.788346410, -0.615231574},
    {-0.784556568, -0.620057225}, {-0.780737221, -0.624859512}, {-0.776888490, -0.629638255},
    {-0.773010433, -0.634393275}, {-0.769103348, -0.639124453}, {-0.765167236, -0.643831551},
    {-0.761202395, -0.648514390}, {-0.757208824, -0.653172851}, {-0.753186822, -0.657806695},
    {-0.749136388, -0.662415802}, {-0.745057762, -0.666999936}, {-0.740951121, -0.671558976},
    {-0.736816585, -0.676092684}, {-0.732654274, -0.680601001}, {-0.728464365, -0.685083687},
    {-0.724247098, -0.689540565}, {-0.720002532, -0.693971455}, {-0.715730846, -0.698376238},
    {-0.711432219, -0.702754736}, {-0.707106769, -0.707106769}, {-0.702754736, -0.711432219},
    {-0.698376238, -0.715730846}, {-0.693971455, -0.720002532}, {-0.689540565, -0.724247098},
    {-0.685083687, -0.728464365}, {-0.680601001, -0.732654274}, {-0.676092684, -0.736816585},
    {-0.671558976, -0.740951121}, {-0.666999936, -0.745057762}, {-0.662415802, -0.749136388},
    {-0.657806695, -0.753186822}, {-0.653172851, -0.757208824}, {-0.648514390, -0.761202395},
    {-0.643831551, -0.765167236}, {-0.639124453, -0.769103348}, {-0.634393275, -0.773010433},
    {-0.629638255, -0.776888490}, {-0.624859512, -0.780737221}, {-0.620057225, -0.784556568},
    {-0.615231574, -0.788346410}, {-0.610382795, -0.792106569}, {-0.605511069, -0.795836926},
    {-0.600616455, -0.799537241}, {-0.595699310, -0.803207517}, {-0.590759695, -0.806847572},
    {-0.585797846, -0.810457170}, {-0.580813944, -0.814036310}, {-0.575808167, -0.817584813},
    {-0.570780754, -0.821102500}, {-0.565731823, -0.824589312}, {-0.560661554, -0.828045070},
    {-0.555570245, -0.831469595}, {-0.550457954, -0.834862888}, {-0.545324981, -0.838224709},
    {-0.540171444, -0.841554999}, {-0.534997642, -0.844853580}, {-0.529803634, -0.848120332},
    {-0.524589658, -0.851355195}, {-0.519356012, -0.854557991}, {-0.514102757, -0.857728601},
    {-0.508830130, -0.860866964}, {-0.503538370, -0.863972843}, {-0.498227656, -0.867046237},
    {-0.492898196, -0.870086968}, {-0.487550169, -0.873094976}, {-0.482183784, -0.876070082},
    {-0.476799220, -0.879012227}, {-0.471396744, -0.881921291}, {-0.465976506, -0.884797096},
    {-0.460538715, -0.887639642}, {-0.455083579, -0.890448749}, {-0.449611336, -0.893224299},
    {-0.444122136, -0.895966232}, {-0.438616246, -0.898674488}, {-0.433093816, -0.901348829},
    {-0.427555084, -0.903989315}, {-0.422000259, -0.906595707}, {-0.416429549, -0.909168005},
    {-0.410843164, -0.911706030}, {-0.405241311, -0.914209783}, {-0.399624199, -0.916679084},
    {-0.393992037, -0.919113874}, {-0.388345033, -0.921514034}, {-0.382683426, -0.923879504},
    {-0.377007425, -0.926210225}, {-0.371317208, -0.928506076}, {-0.365612984, -0.930766940},
    {-0.359895051, -0.932992816}, {-0.354163527, -0.935183525}, {-0.348418683, -0.937339008},
    {-0.342660725, -0.939459205}, {-0.336889863, -0.941544056}, {-0.331106305, -0.943593442},
    {-0.325310290, -0.945607305}, {-0.319502026, -0.947585583}, {-0.313681751, -0.949528158},
    {-0.307849646, -0.951435030}, {-0.302005947, -0.953306019}, {-0.296150893, -0.955141187},
    {-0.290284663, -0.956940353}, {-0.284407526, -0.958703458}, {-0.278519690, -0.960430503},
    {-0.272621363, -0.962121427}, {-0.266712755, -0.963776052}, {-0.260794103, -0.965394437},
    {-0.254865646, -0.966976464}, {-0.248927608, -0.968522072}, {-0.242980182, -0.970031261},
    {-0.237023607, -0.971503913}, {-0.231058106, -0.972939968}, {-0.225083917, -0.974339366},
    {-0.219101235, -0.975702107}, {-0.213110313, -0.977028131}, {-0.207111374, -0.978317380},
    {-0.201104641, -0.979569793}, {-0.195090324, -0.980785251}, {-0.189068660, -0.981963873},
    {-0.183039889, -0.983105481}, {-0.177004218, -0.984210074}, {-0.170961887, -0.985277653},
    {-0.164913118, -0.986308098}, {-0.158858150, -0.987301409}, {-0.152797192, -0.988257587},
    {-0.146730468, -0.989176512}, {-0.140658244, -0.990058184}, {-0.134580702, -0.990902662},
    {-0.128498107, -0.991709769}, {-0.122410677, -0.992479563}, {-0.116318628, -0.993211925},
    {-0.110222206, -0.993906975}, {-0.104121633, -0.994564593}, {-0.098017141, -0.995184720},
    {-0.091908954, -0.995767415}, {-0.085797310, -0.996312618}, {-0.079682440, -0.996820271},
    {-0.073564567, -0.997290432}, {-0.067443922, -0.997723043}, {-0.061320737, -0.998118103},
    {-0.055195246, -0.998475552}, {-0.049067676, -0.998795450}, {-0.042938258, -0.999077737},
    {-0.036807224, -0.999322355}, {-0.030674804, -0.999529421}, {-0.024541229, -0.999698818},
    {-0.018406730, -0.999830604}, {-0.012271538, -0.999924719}, {-0.006135885, -0.999981165},
    {-0.000000000, -1.000000000}, {0.006135885, -0.999981165},  {0.012271538, -0.999924719},
    {0.018406730, -0.999830604},  {0.024541229, -0.999698818},  {0.030674804, -0.999529421},
    {0.036807224, -0.999322355},  {0.042938258, -0.999077737},  {0.049067676, -0.998795450},
    {0.055195246, -0.998475552},  {0.061320737, -0.998118103},  {0.067443922, -0.997723043},
    {0.073564567, -0.997290432},  {0.079682440, -0.996820271},  {0.085797310, -0.996312618},
    {0.091908954, -0.995767415},  {0.098017141, -0.995184720},  {0.104121633, -0.994564593},
    {0.110222206, -0.993906975},  {0.116318628, -0.993211925},  {0.122410677, -0.992479563},
    {0.128498107, -0.991709769},  {0.134580702, -0.990902662},  {0.140658244, -0.990058184},
    {0.146730468, -0.989176512},  {0.152797192, -0.988257587},  {0.158858150, -0.987301409},
    {0.164913118, -0.986308098},  {0.170961887, -0.985277653},  {0.177004218, -0.984210074},
    {0.183039889, -0.983105481},  {0.189068660, -0.981963873},  {0.195090324, -0.980785251},
    {0.201104641, -0.979569793},  {0.207111374, -0.978317380},  {0.213110313, -0.977028131},
    {0.219101235, -0.975702107},  {0.225083917, -0.974339366},  {0.231058106, -0.972939968},
    {0.237023607, -0.971503913},  {0.242980182, -0.970031261},  {0.248927608, -0.968522072},
    {0.254865646, -0.966976464},  {0.260794103, -0.965394437},  {0.266712755, -0.963776052},
    {0.272621363, -0.962121427},  {0.278519690, -0.960430503},  {0.284407526, -0.958703458},
    {0.290284663, -0.956940353},  {0.296150893, -0.955141187},  {0.302005947, -0.953306019},
    {0.307849646, -0.951435030},  {0.313681751, -0.949528158},  {0.319502026, -0.947585583},
    {0.325310290, -0.945607305},  {0.331106305, -0.943593442},  {0.336889863, -0.941544056},
    {0.342660725, -0.939459205},  {0.348418683, -0.937339008},  {0.354163527, -0.935183525},
    {0.359895051, -0.932992816},  {0.365612984, -0.930766940},  {0.371317208, -0.928506076},
    {0.377007425, -0.926210225},  {0.382683426, -0.923879504},  {0.388345033, -0.921514034},
    {0.393992037, -0.919113874},  {0.399624199, -0.916679084},  {0.405241311, -0.914209783},
    {0.410843164, -0.911706030},  {0.416429549, -0.909168005},  {0.422000259, -0.906595707},
    {0.427555084, -0.903989315},  {0.433093816, -0.901348829},  {0.438616246, -0.898674488},
    {0.444122136, -0.895966232},  {0.449611336, -0.893224299},  {0.455083579, -0.890448749},
    {0.460538715, -0.887639642},  {0.465976506, -0.884797096},  {0.471396744, -0.881921291},
    {0.476799220, -0.879012227},  {0.482183784, -0.876070082},  {0.487550169, -0.873094976},
    {0.492898196, -0.870086968},  {0.498227656, -0.867046237},  {0.503538370, -0.863972843},
    {0.508830130, -0.860866964},  {0.514102757, -0.857728601},  {0.519356012, -0.854557991},
    {0.524589658, -0.851355195},  {0.529803634, -0.848120332},  {0.534997642, -0.844853580},
    {0.540171444, -0.841554999},  {0.545324981, -0.838224709},  {0.550457954, -0.834862888},
    {0.555570245, -0.831469595},  {0.560661554, -0.828045070},  {0.565731823, -0.824589312},
    {0.570780754, -0.821102500},  {0.575808167, -0.817584813},  {0.580813944, -0.814036310},
    {0.585797846, -0.810457170},  {0.590759695, -0.806847572},  {0.595699310, -0.803207517},
    {0.600616455, -0.799537241},  {0.605511069, -0.795836926},  {0.610382795, -0.792106569},
    {0.615231574, -0.788346410},  {0.620057225, -0.784556568},  {0.624859512, -0.780737221},
    {0.629638255, -0.776888490},  {0.634393275, -0.773010433},  {0.639124453, -0.769103348},
    {0.643831551, -0.765167236},  {0.648514390, -0.761202395},  {0.653172851, -0.757208824},
    {0.657806695, -0.753186822},  {0.662415802, -0.749136388},  {0.666999936, -0.745057762},
    {0.671558976, -0.740951121},  {0.676092684, -0.736816585},  {0.680601001, -0.732654274},
    {0.685083687, -0.728464365},  {0.689540565, -0.724247098},  {0.693971455, -0.720002532},
    {0.698376238, -0.715730846},  {0.702754736, -0.711432219},  {0.707106769, -0.707106769},
    {0.711432219, -0.702754736},  {0.715730846, -0.698376238},  {0.720002532, -0.693971455},
    {0.724247098, -0.689540565},  {0.728464365, -0.685083687},  {0.732654274, -0.680601001},
    {0.736816585, -0.676092684},  {0.740951121, -0.671558976},  {0.745057762, -0.666999936},
    {0.749136388, -0.662415802},  {0.753186822, -0.657806695},  {0.757208824, -0.653172851},
    {0.761202395, -0.648514390},  {0.765167236, -0.643831551},  {0.769103348, -0.639124453},
    {0.773010433, -0.634393275},  {0.776888490, -0.629638255},  {0.780737221, -0.624859512},
    {0.784556568, -0.620057225},  {0.788346410, -0.615231574},  {0.792106569, -0.610382795},
    {0.795836926, -0.605511069},  {0.799537241, -0.600616455},  {0.803207517, -0.595699310},
    {0.806847572, -0.590759695},  {0.810457170, -0.585797846},  {0.814036310, -0.580813944},
    {0.817584813, -0.575808167},  {0.821102500, -0.570780754},  {0.824589312, -0.565731823},
    {0.828045070, -0.560661554},  {0.831469595, -0.555570245},  {0.834862888, -0.550457954},
    {0.838224709, -0.545324981},  {0.841554999, -0.540171444},  {0.844853580, -0.534997642},
    {0.848120332, -0.529803634},  {0.851355195, -0.524589658},  {0.854557991, -0.519356012},
    {0.857728601, -0.514102757},  {0.860866964, -0.508830130},  {0.863972843, -0.503538370},
    {0.867046237, -0.498227656},  {0.870086968, -0.492898196},  {0.873094976, -0.487550169},
    {0.876070082, -0.482183784},  {0.879012227, -0.476799220},  {0.881921291, -0.471396744},
    {0.884797096, -0.465976506},  {0.887639642, -0.460538715},  {0.890448749, -0.455083579},
    {0.893224299, -0.449611336},  {0.895966232, -0.444122136},  {0.898674488, -0.438616246},
    {0.901348829, -0.433093816},  {0.903989315, -0.427555084},  {0.906595707, -0.422000259},
    {0.909168005, -0.416429549},  {0.911706030, -0.410843164},  {0.914209783, -0.405241311},
    {0.916679084, -0.399624199},  {0.919113874, -0.393992037},  {0.921514034, -0.388345033},
    {0.923879504, -0.382683426},  {0.926210225, -0.377007425},  {0.928506076, -0.371317208},
    {0.930766940, -0.365612984},  {0.932992816, -0.359895051},  {0.935183525, -0.354163527},
    {0.937339008, -0.348418683},  {0.939459205, -0.342660725},  {0.941544056, -0.336889863},
    {0.943593442, -0.331106305},  {0.945607305, -0.325310290},  {0.947585583, -0.319502026},
    {0.949528158, -0.313681751},  {0.951435030, -0.307849646},  {0.953306019, -0.302005947},
    {0.955141187, -0.296150893},  {0.956940353, -0.290284663},  {0.958703458, -0.284407526},
    {0.960430503, -0.278519690},  {0.962121427, -0.272621363},  {0.963776052, -0.266712755},
    {0.965394437, -0.260794103},  {0.966976464, -0.254865646},  {0.968522072, -0.248927608},
    {0.970031261, -0.242980182},  {0.971503913, -0.237023607},  {0.972939968, -0.231058106},
    {0.974339366, -0.225083917},  {0.975702107, -0.219101235},  {0.977028131, -0.213110313},
    {0.978317380, -0.207111374},  {0.979569793, -0.201104641},  {0.980785251, -0.195090324},
    {0.981963873, -0.189068660},  {0.983105481, -0.183039889},  {0.984210074, -0.177004218},
    {0.985277653, -0.170961887},  {0.986308098, -0.164913118},  {0.987301409, -0.158858150},
    {0.988257587, -0.152797192},  {0.989176512, -0.146730468},  {0.990058184, -0.140658244},
    {0.990902662, -0.134580702},  {0.991709769, -0.128498107},  {0.992479563, -0.122410677},
    {0.993211925, -0.116318628},  {0.993906975, -0.110222206},  {0.994564593, -0.104121633},
    {0.995184720, -0.098017141},  {0.995767415, -0.091908954},  {0.996312618, -0.085797310},
    {0.996820271, -0.079682440},  {0.997290432, -0.073564567},  {0.997723043, -0.067443922},
    {0.998118103, -0.061320737},  {0.998475552, -0.055195246},  {0.998795450, -0.049067676},
    {0.999077737, -0.042938258},  {0.999322355, -0.036807224},  {0.999529421, -0.030674804},
    {0.999698818, -0.024541229},  {0.999830604, -0.018406730},  {0.999924719, -0.012271538},
    {0.999981165, -0.006135885}};

alignas(__ALIGN_BYTE_SIZE__) const cfloat sincosLUTFloat2[1024] = {
    {1.000000000, 0.000000000}, {1.000000000, 0.000005992}, {1.000000000, 0.000011984}, {1.000000000, 0.000017976},
    {1.000000000, 0.000023968}, {1.000000000, 0.000029961}, {1.000000000, 0.000035953}, {1.000000000, 0.000041945},
    {1.000000000, 0.000047937}, {1.000000000, 0.000053929}, {1.000000000, 0.000059921}, {1.000000000, 0.000065913},
    {1.000000000, 0.000071905}, {1.000000000, 0.000077897}, {1.000000000, 0.000083890}, {1.000000000, 0.000089882},
    {1.000000000, 0.000095874}, {1.000000000, 0.000101866}, {1.000000000, 0.000107858}, {1.000000000, 0.000113850},
    {1.000000000, 0.000119842}, {1.000000000, 0.000125834}, {1.000000000, 0.000131826}, {1.000000000, 0.000137819},
    {1.000000000, 0.000143811}, {1.000000000, 0.000149803}, {1.000000000, 0.000155795}, {1.000000000, 0.000161787},
    {1.000000000, 0.000167779}, {1.000000000, 0.000173771}, {1.000000000, 0.000179763}, {1.000000000, 0.000185755},
    {1.000000000, 0.000191748}, {1.000000000, 0.000197740}, {1.000000000, 0.000203732}, {1.000000000, 0.000209724},
    {1.000000000, 0.000215716}, {1.000000000, 0.000221708}, {1.000000000, 0.000227700}, {1.000000000, 0.000233692},
    {1.000000000, 0.000239684}, {0.999999940, 0.000245677}, {0.999999940, 0.000251669}, {0.999999940, 0.000257661},
    {0.999999940, 0.000263653}, {0.999999940, 0.000269645}, {0.999999940, 0.000275637}, {0.999999940, 0.000281629},
    {0.999999940, 0.000287621}, {0.999999940, 0.000293613}, {0.999999940, 0.000299606}, {0.999999940, 0.000305598},
    {0.999999940, 0.000311590}, {0.999999940, 0.000317582}, {0.999999940, 0.000323574}, {0.999999940, 0.000329566},
    {0.999999940, 0.000335558}, {0.999999940, 0.000341550}, {0.999999940, 0.000347543}, {0.999999940, 0.000353535},
    {0.999999940, 0.000359527}, {0.999999940, 0.000365519}, {0.999999940, 0.000371511}, {0.999999940, 0.000377503},
    {0.999999940, 0.000383495}, {0.999999940, 0.000389487}, {0.999999940, 0.000395479}, {0.999999940, 0.000401472},
    {0.999999940, 0.000407464}, {0.999999940, 0.000413456}, {0.999999940, 0.000419448}, {0.999999881, 0.000425440},
    {0.999999881, 0.000431432}, {0.999999881, 0.000437424}, {0.999999881, 0.000443416}, {0.999999881, 0.000449408},
    {0.999999881, 0.000455401}, {0.999999881, 0.000461393}, {0.999999881, 0.000467385}, {0.999999881, 0.000473377},
    {0.999999881, 0.000479369}, {0.999999881, 0.000485361}, {0.999999881, 0.000491353}, {0.999999881, 0.000497345},
    {0.999999881, 0.000503337}, {0.999999881, 0.000509330}, {0.999999881, 0.000515322}, {0.999999881, 0.000521314},
    {0.999999881, 0.000527306}, {0.999999881, 0.000533298}, {0.999999881, 0.000539290}, {0.999999881, 0.000545282},
    {0.999999821, 0.000551274}, {0.999999821, 0.000557266}, {0.999999821, 0.000563259}, {0.999999821, 0.000569251},
    {0.999999821, 0.000575243}, {0.999999821, 0.000581235}, {0.999999821, 0.000587227}, {0.999999821, 0.000593219},
    {0.999999821, 0.000599211}, {0.999999821, 0.000605203}, {0.999999821, 0.000611195}, {0.999999821, 0.000617188},
    {0.999999821, 0.000623180}, {0.999999821, 0.000629172}, {0.999999821, 0.000635164}, {0.999999821, 0.000641156},
    {0.999999762, 0.000647148}, {0.999999762, 0.000653140}, {0.999999762, 0.000659132}, {0.999999762, 0.000665124},
    {0.999999762, 0.000671117}, {0.999999762, 0.000677109}, {0.999999762, 0.000683101}, {0.999999762, 0.000689093},
    {0.999999762, 0.000695085}, {0.999999762, 0.000701077}, {0.999999762, 0.000707069}, {0.999999762, 0.000713061},
    {0.999999762, 0.000719053}, {0.999999762, 0.000725046}, {0.999999762, 0.000731038}, {0.999999702, 0.000737030},
    {0.999999702, 0.000743022}, {0.999999702, 0.000749014}, {0.999999702, 0.000755006}, {0.999999702, 0.000760998},
    {0.999999702, 0.000766990}, {0.999999702, 0.000772982}, {0.999999702, 0.000778975}, {0.999999702, 0.000784967},
    {0.999999702, 0.000790959}, {0.999999702, 0.000796951}, {0.999999702, 0.000802943}, {0.999999702, 0.000808935},
    {0.999999642, 0.000814927}, {0.999999642, 0.000820919}, {0.999999642, 0.000826911}, {0.999999642, 0.000832904},
    {0.999999642, 0.000838896}, {0.999999642, 0.000844888}, {0.999999642, 0.000850880}, {0.999999642, 0.000856872},
    {0.999999642, 0.000862864}, {0.999999642, 0.000868856}, {0.999999642, 0.000874848}, {0.999999583, 0.000880840},
    {0.999999583, 0.000886833}, {0.999999583, 0.000892825}, {0.999999583, 0.000898817}, {0.999999583, 0.000904809},
    {0.999999583, 0.000910801}, {0.999999583, 0.000916793}, {0.999999583, 0.000922785}, {0.999999583, 0.000928777},
    {0.999999583, 0.000934769}, {0.999999583, 0.000940762}, {0.999999523, 0.000946754}, {0.999999523, 0.000952746},
    {0.999999523, 0.000958738}, {0.999999523, 0.000964730}, {0.999999523, 0.000970722}, {0.999999523, 0.000976714},
    {0.999999523, 0.000982706}, {0.999999523, 0.000988698}, {0.999999523, 0.000994690}, {0.999999523, 0.001000683},
    {0.999999464, 0.001006675}, {0.999999464, 0.001012667}, {0.999999464, 0.001018659}, {0.999999464, 0.001024651},
    {0.999999464, 0.001030643}, {0.999999464, 0.001036635}, {0.999999464, 0.001042627}, {0.999999464, 0.001048620},
    {0.999999464, 0.001054612}, {0.999999464, 0.001060604}, {0.999999404, 0.001066596}, {0.999999404, 0.001072588},
    {0.999999404, 0.001078580}, {0.999999404, 0.001084572}, {0.999999404, 0.001090564}, {0.999999404, 0.001096556},
    {0.999999404, 0.001102548}, {0.999999404, 0.001108541}, {0.999999404, 0.001114533}, {0.999999344, 0.001120525},
    {0.999999344, 0.001126517}, {0.999999344, 0.001132509}, {0.999999344, 0.001138501}, {0.999999344, 0.001144493},
    {0.999999344, 0.001150485}, {0.999999344, 0.001156477}, {0.999999344, 0.001162470}, {0.999999344, 0.001168462},
    {0.999999285, 0.001174454}, {0.999999285, 0.001180446}, {0.999999285, 0.001186438}, {0.999999285, 0.001192430},
    {0.999999285, 0.001198422}, {0.999999285, 0.001204414}, {0.999999285, 0.001210406}, {0.999999285, 0.001216399},
    {0.999999225, 0.001222391}, {0.999999225, 0.001228383}, {0.999999225, 0.001234375}, {0.999999225, 0.001240367},
    {0.999999225, 0.001246359}, {0.999999225, 0.001252351}, {0.999999225, 0.001258343}, {0.999999225, 0.001264335},
    {0.999999166, 0.001270327}, {0.999999166, 0.001276320}, {0.999999166, 0.001282312}, {0.999999166, 0.001288304},
    {0.999999166, 0.001294296}, {0.999999166, 0.001300288}, {0.999999166, 0.001306280}, {0.999999166, 0.001312272},
    {0.999999106, 0.001318264}, {0.999999106, 0.001324256}, {0.999999106, 0.001330249}, {0.999999106, 0.001336241},
    {0.999999106, 0.001342233}, {0.999999106, 0.001348225}, {0.999999106, 0.001354217}, {0.999999046, 0.001360209},
    {0.999999046, 0.001366201}, {0.999999046, 0.001372193}, {0.999999046, 0.001378185}, {0.999999046, 0.001384177},
    {0.999999046, 0.001390170}, {0.999999046, 0.001396162}, {0.999999046, 0.001402154}, {0.999998987, 0.001408146},
    {0.999998987, 0.001414138}, {0.999998987, 0.001420130}, {0.999998987, 0.001426122}, {0.999998987, 0.001432114},
    {0.999998987, 0.001438107}, {0.999998987, 0.001444099}, {0.999998927, 0.001450091}, {0.999998927, 0.001456083},
    {0.999998927, 0.001462075}, {0.999998927, 0.001468067}, {0.999998927, 0.001474059}, {0.999998927, 0.001480051},
    {0.999998868, 0.001486043}, {0.999998868, 0.001492035}, {0.999998868, 0.001498028}, {0.999998868, 0.001504020},
    {0.999998868, 0.001510012}, {0.999998868, 0.001516004}, {0.999998868, 0.001521996}, {0.999998808, 0.001527988},
    {0.999998808, 0.001533980}, {0.999998808, 0.001539972}, {0.999998808, 0.001545964}, {0.999998808, 0.001551957},
    {0.999998808, 0.001557949}, {0.999998748, 0.001563941}, {0.999998748, 0.001569933}, {0.999998748, 0.001575925},
    {0.999998748, 0.001581917}, {0.999998748, 0.001587909}, {0.999998748, 0.001593901}, {0.999998748, 0.001599893},
    {0.999998689, 0.001605885}, {0.999998689, 0.001611878}, {0.999998689, 0.001617870}, {0.999998689, 0.001623862},
    {0.999998689, 0.001629854}, {0.999998689, 0.001635846}, {0.999998629, 0.001641838}, {0.999998629, 0.001647830},
    {0.999998629, 0.001653822}, {0.999998629, 0.001659814}, {0.999998629, 0.001665807}, {0.999998629, 0.001671799},
    {0.999998569, 0.001677791}, {0.999998569, 0.001683783}, {0.999998569, 0.001689775}, {0.999998569, 0.001695767},
    {0.999998569, 0.001701759}, {0.999998569, 0.001707751}, {0.999998510, 0.001713743}, {0.999998510, 0.001719735},
    {0.999998510, 0.001725728}, {0.999998510, 0.001731720}, {0.999998510, 0.001737712}, {0.999998450, 0.001743704},
    {0.999998450, 0.001749696}, {0.999998450, 0.001755688}, {0.999998450, 0.001761680}, {0.999998450, 0.001767672},
    {0.999998450, 0.001773664}, {0.999998391, 0.001779657}, {0.999998391, 0.001785649}, {0.999998391, 0.001791641},
    {0.999998391, 0.001797633}, {0.999998391, 0.001803625}, {0.999998391, 0.001809617}, {0.999998331, 0.001815609},
    {0.999998331, 0.001821601}, {0.999998331, 0.001827593}, {0.999998331, 0.001833585}, {0.999998331, 0.001839577},
    {0.999998271, 0.001845570}, {0.999998271, 0.001851562}, {0.999998271, 0.001857554}, {0.999998271, 0.001863546},
    {0.999998271, 0.001869538}, {0.999998212, 0.001875530}, {0.999998212, 0.001881522}, {0.999998212, 0.001887514},
    {0.999998212, 0.001893506}, {0.999998212, 0.001899499}, {0.999998212, 0.001905491}, {0.999998152, 0.001911483},
    {0.999998152, 0.001917475}, {0.999998152, 0.001923467}, {0.999998152, 0.001929459}, {0.999998152, 0.001935451},
    {0.999998093, 0.001941443}, {0.999998093, 0.001947435}, {0.999998093, 0.001953427}, {0.999998093, 0.001959420},
    {0.999998093, 0.001965412}, {0.999998033, 0.001971404}, {0.999998033, 0.001977396}, {0.999998033, 0.001983388},
    {0.999998033, 0.001989380}, {0.999998033, 0.001995372}, {0.999997973, 0.002001364}, {0.999997973, 0.002007356},
    {0.999997973, 0.002013349}, {0.999997973, 0.002019341}, {0.999997973, 0.002025333}, {0.999997914, 0.002031325},
    {0.999997914, 0.002037317}, {0.999997914, 0.002043309}, {0.999997914, 0.002049301}, {0.999997914, 0.002055293},
    {0.999997854, 0.002061285}, {0.999997854, 0.002067277}, {0.999997854, 0.002073269}, {0.999997854, 0.002079261},
    {0.999997854, 0.002085254}, {0.999997795, 0.002091246}, {0.999997795, 0.002097238}, {0.999997795, 0.002103230},
    {0.999997795, 0.002109222}, {0.999997735, 0.002115214}, {0.999997735, 0.002121206}, {0.999997735, 0.002127198},
    {0.999997735, 0.002133190}, {0.999997735, 0.002139183}, {0.999997675, 0.002145175}, {0.999997675, 0.002151167},
    {0.999997675, 0.002157159}, {0.999997675, 0.002163151}, {0.999997675, 0.002169143}, {0.999997616, 0.002175135},
    {0.999997616, 0.002181127}, {0.999997616, 0.002187119}, {0.999997616, 0.002193111}, {0.999997556, 0.002199104},
    {0.999997556, 0.002205095}, {0.999997556, 0.002211088}, {0.999997556, 0.002217080}, {0.999997556, 0.002223072},
    {0.999997497, 0.002229064}, {0.999997497, 0.002235056}, {0.999997497, 0.002241048}, {0.999997497, 0.002247040},
    {0.999997437, 0.002253032}, {0.999997437, 0.002259024}, {0.999997437, 0.002265017}, {0.999997437, 0.002271009},
    {0.999997437, 0.002277001}, {0.999997377, 0.002282993}, {0.999997377, 0.002288985}, {0.999997377, 0.002294977},
    {0.999997377, 0.002300969}, {0.999997318, 0.002306961}, {0.999997318, 0.002312953}, {0.999997318, 0.002318945},
    {0.999997318, 0.002324938}, {0.999997258, 0.002330930}, {0.999997258, 0.002336922}, {0.999997258, 0.002342914},
    {0.999997258, 0.002348906}, {0.999997199, 0.002354898}, {0.999997199, 0.002360890}, {0.999997199, 0.002366882},
    {0.999997199, 0.002372874}, {0.999997199, 0.002378866}, {0.999997139, 0.002384858}, {0.999997139, 0.002390851},
    {0.999997139, 0.002396843}, {0.999997139, 0.002402835}, {0.999997079, 0.002408827}, {0.999997079, 0.002414819},
    {0.999997079, 0.002420811}, {0.999997079, 0.002426803}, {0.999997020, 0.002432795}, {0.999997020, 0.002438787},
    {0.999997020, 0.002444780}, {0.999997020, 0.002450772}, {0.999996960, 0.002456764}, {0.999996960, 0.002462756},
    {0.999996960, 0.002468748}, {0.999996960, 0.002474740}, {0.999996901, 0.002480732}, {0.999996901, 0.002486724},
    {0.999996901, 0.002492716}, {0.999996901, 0.002498708}, {0.999996841, 0.002504700}, {0.999996841, 0.002510692},
    {0.999996841, 0.002516685}, {0.999996841, 0.002522677}, {0.999996781, 0.002528669}, {0.999996781, 0.002534661},
    {0.999996781, 0.002540653}, {0.999996781, 0.002546645}, {0.999996722, 0.002552637}, {0.999996722, 0.002558629},
    {0.999996722, 0.002564621}, {0.999996722, 0.002570614}, {0.999996662, 0.002576605}, {0.999996662, 0.002582598},
    {0.999996662, 0.002588590}, {0.999996662, 0.002594582}, {0.999996603, 0.002600574}, {0.999996603, 0.002606566},
    {0.999996603, 0.002612558}, {0.999996543, 0.002618550}, {0.999996543, 0.002624542}, {0.999996543, 0.002630534},
    {0.999996543, 0.002636526}, {0.999996483, 0.002642519}, {0.999996483, 0.002648511}, {0.999996483, 0.002654503},
    {0.999996483, 0.002660495}, {0.999996424, 0.002666487}, {0.999996424, 0.002672479}, {0.999996424, 0.002678471},
    {0.999996424, 0.002684463}, {0.999996364, 0.002690455}, {0.999996364, 0.002696447}, {0.999996364, 0.002702439},
    {0.999996305, 0.002708432}, {0.999996305, 0.002714424}, {0.999996305, 0.002720416}, {0.999996305, 0.002726408},
    {0.999996245, 0.002732400}, {0.999996245, 0.002738392}, {0.999996245, 0.002744384}, {0.999996245, 0.002750376},
    {0.999996185, 0.002756368}, {0.999996185, 0.002762360}, {0.999996185, 0.002768352}, {0.999996126, 0.002774345},
    {0.999996126, 0.002780337}, {0.999996126, 0.002786329}, {0.999996126, 0.002792321}, {0.999996066, 0.002798313},
    {0.999996066, 0.002804305}, {0.999996066, 0.002810297}, {0.999996006, 0.002816289}, {0.999996006, 0.002822281},
    {0.999996006, 0.002828273}, {0.999996006, 0.002834265}, {0.999995947, 0.002840257}, {0.999995947, 0.002846250},
    {0.999995947, 0.002852242}, {0.999995887, 0.002858234}, {0.999995887, 0.002864226}, {0.999995887, 0.002870218},
    {0.999995887, 0.002876210}, {0.999995828, 0.002882202}, {0.999995828, 0.002888194}, {0.999995828, 0.002894186},
    {0.999995768, 0.002900178}, {0.999995768, 0.002906170}, {0.999995768, 0.002912163}, {0.999995768, 0.002918155},
    {0.999995708, 0.002924147}, {0.999995708, 0.002930139}, {0.999995708, 0.002936131}, {0.999995649, 0.002942123},
    {0.999995649, 0.002948115}, {0.999995649, 0.002954107}, {0.999995589, 0.002960099}, {0.999995589, 0.002966091},
    {0.999995589, 0.002972083}, {0.999995589, 0.002978076}, {0.999995530, 0.002984068}, {0.999995530, 0.002990060},
    {0.999995530, 0.002996052}, {0.999995470, 0.003002044}, {0.999995470, 0.003008036}, {0.999995470, 0.003014028},
    {0.999995410, 0.003020020}, {0.999995410, 0.003026012}, {0.999995410, 0.003032004}, {0.999995410, 0.003037996},
    {0.999995351, 0.003043988}, {0.999995351, 0.003049981}, {0.999995351, 0.003055973}, {0.999995291, 0.003061965},
    {0.999995291, 0.003067957}, {0.999995291, 0.003073949}, {0.999995232, 0.003079941}, {0.999995232, 0.003085933},
    {0.999995232, 0.003091925}, {0.999995172, 0.003097917}, {0.999995172, 0.003103909}, {0.999995172, 0.003109901},
    {0.999995172, 0.003115893}, {0.999995112, 0.003121885}, {0.999995112, 0.003127878}, {0.999995112, 0.003133870},
    {0.999995053, 0.003139862}, {0.999995053, 0.003145854}, {0.999995053, 0.003151846}, {0.999994993, 0.003157838},
    {0.999994993, 0.003163830}, {0.999994993, 0.003169822}, {0.999994934, 0.003175814}, {0.999994934, 0.003181806},
    {0.999994934, 0.003187798}, {0.999994874, 0.003193791}, {0.999994874, 0.003199783}, {0.999994874, 0.003205775},
    {0.999994814, 0.003211767}, {0.999994814, 0.003217759}, {0.999994814, 0.003223751}, {0.999994755, 0.003229743},
    {0.999994755, 0.003235735}, {0.999994755, 0.003241727}, {0.999994755, 0.003247719}, {0.999994695, 0.003253711},
    {0.999994695, 0.003259704}, {0.999994695, 0.003265695}, {0.999994636, 0.003271688}, {0.999994636, 0.003277680},
    {0.999994636, 0.003283672}, {0.999994576, 0.003289664}, {0.999994576, 0.003295656}, {0.999994576, 0.003301648},
    {0.999994516, 0.003307640}, {0.999994516, 0.003313632}, {0.999994516, 0.003319624}, {0.999994457, 0.003325616},
    {0.999994457, 0.003331608}, {0.999994457, 0.003337601}, {0.999994397, 0.003343593}, {0.999994397, 0.003349585},
    {0.999994397, 0.003355577}, {0.999994338, 0.003361569}, {0.999994338, 0.003367561}, {0.999994338, 0.003373553},
    {0.999994278, 0.003379545}, {0.999994278, 0.003385537}, {0.999994278, 0.003391529}, {0.999994218, 0.003397521},
    {0.999994218, 0.003403513}, {0.999994159, 0.003409505}, {0.999994159, 0.003415497}, {0.999994159, 0.003421490},
    {0.999994099, 0.003427482}, {0.999994099, 0.003433474}, {0.999994099, 0.003439466}, {0.999994040, 0.003445458},
    {0.999994040, 0.003451450}, {0.999994040, 0.003457442}, {0.999993980, 0.003463434}, {0.999993980, 0.003469426},
    {0.999993980, 0.003475418}, {0.999993920, 0.003481410}, {0.999993920, 0.003487402}, {0.999993920, 0.003493394},
    {0.999993861, 0.003499387}, {0.999993861, 0.003505378}, {0.999993861, 0.003511371}, {0.999993801, 0.003517363},
    {0.999993801, 0.003523355}, {0.999993801, 0.003529347}, {0.999993742, 0.003535339}, {0.999993742, 0.003541331},
    {0.999993682, 0.003547323}, {0.999993682, 0.003553315}, {0.999993682, 0.003559307}, {0.999993622, 0.003565299},
    {0.999993622, 0.003571291}, {0.999993622, 0.003577284}, {0.999993563, 0.003583275}, {0.999993563, 0.003589268},
    {0.999993563, 0.003595260}, {0.999993503, 0.003601252}, {0.999993503, 0.003607244}, {0.999993443, 0.003613236},
    {0.999993443, 0.003619228}, {0.999993443, 0.003625220}, {0.999993384, 0.003631212}, {0.999993384, 0.003637204},
    {0.999993384, 0.003643196}, {0.999993324, 0.003649188}, {0.999993324, 0.003655181}, {0.999993324, 0.003661172},
    {0.999993265, 0.003667165}, {0.999993265, 0.003673157}, {0.999993205, 0.003679149}, {0.999993205, 0.003685141},
    {0.999993205, 0.003691133}, {0.999993145, 0.003697125}, {0.999993145, 0.003703117}, {0.999993145, 0.003709109},
    {0.999993086, 0.003715101}, {0.999993086, 0.003721093}, {0.999993026, 0.003727085}, {0.999993026, 0.003733077},
    {0.999993026, 0.003739069}, {0.999992967, 0.003745062}, {0.999992967, 0.003751054}, {0.999992967, 0.003757046},
    {0.999992907, 0.003763038}, {0.999992907, 0.003769030}, {0.999992847, 0.003775022}, {0.999992847, 0.003781014},
    {0.999992847, 0.003787006}, {0.999992788, 0.003792998}, {0.999992788, 0.003798990}, {0.999992788, 0.003804982},
    {0.999992728, 0.003810974}, {0.999992728, 0.003816966}, {0.999992669, 0.003822958}, {0.999992669, 0.003828950},
    {0.999992669, 0.003834943}, {0.999992609, 0.003840935}, {0.999992609, 0.003846927}, {0.999992549, 0.003852919},
    {0.999992549, 0.003858911}, {0.999992549, 0.003864903}, {0.999992490, 0.003870895}, {0.999992490, 0.003876887},
    {0.999992490, 0.003882879}, {0.999992430, 0.003888871}, {0.999992430, 0.003894863}, {0.999992371, 0.003900855},
    {0.999992371, 0.003906847}, {0.999992371, 0.003912840}, {0.999992311, 0.003918832}, {0.999992311, 0.003924823},
    {0.999992251, 0.003930815}, {0.999992251, 0.003936808}, {0.999992251, 0.003942800}, {0.999992192, 0.003948792},
    {0.999992192, 0.003954784}, {0.999992132, 0.003960776}, {0.999992132, 0.003966768}, {0.999992132, 0.003972760},
    {0.999992073, 0.003978752}, {0.999992073, 0.003984744}, {0.999992013, 0.003990736}, {0.999992013, 0.003996728},
    {0.999992013, 0.004002721}, {0.999991953, 0.004008713}, {0.999991953, 0.004014704}, {0.999991894, 0.004020697},
    {0.999991894, 0.004026689}, {0.999991894, 0.004032681}, {0.999991834, 0.004038673}, {0.999991834, 0.004044665},
    {0.999991775, 0.004050657}, {0.999991775, 0.004056649}, {0.999991775, 0.004062641}, {0.999991715, 0.004068633},
    {0.999991715, 0.004074625}, {0.999991655, 0.004080617}, {0.999991655, 0.004086609}, {0.999991596, 0.004092602},
    {0.999991596, 0.004098593}, {0.999991596, 0.004104585}, {0.999991536, 0.004110578}, {0.999991536, 0.004116570},
    {0.999991477, 0.004122562}, {0.999991477, 0.004128554}, {0.999991477, 0.004134546}, {0.999991417, 0.004140538},
    {0.999991417, 0.004146530}, {0.999991357, 0.004152522}, {0.999991357, 0.004158514}, {0.999991357, 0.004164506},
    {0.999991298, 0.004170498}, {0.999991298, 0.004176490}, {0.999991238, 0.004182482}, {0.999991238, 0.004188474},
    {0.999991179, 0.004194466}, {0.999991179, 0.004200459}, {0.999991179, 0.004206451}, {0.999991119, 0.004212443},
    {0.999991119, 0.004218434}, {0.999991059, 0.004224427}, {0.999991059, 0.004230419}, {0.999991000, 0.004236411},
    {0.999991000, 0.004242403}, {0.999991000, 0.004248395}, {0.999990940, 0.004254387}, {0.999990940, 0.004260379},
    {0.999990880, 0.004266371}, {0.999990880, 0.004272363}, {0.999990821, 0.004278355}, {0.999990821, 0.004284347},
    {0.999990821, 0.004290340}, {0.999990761, 0.004296331}, {0.999990761, 0.004302323}, {0.999990702, 0.004308315},
    {0.999990702, 0.004314308}, {0.999990642, 0.004320300}, {0.999990642, 0.004326292}, {0.999990642, 0.004332284},
    {0.999990582, 0.004338276}, {0.999990582, 0.004344268}, {0.999990523, 0.004350260}, {0.999990523, 0.004356252},
    {0.999990463, 0.004362244}, {0.999990463, 0.004368236}, {0.999990404, 0.004374228}, {0.999990404, 0.004380220},
    {0.999990404, 0.004386212}, {0.999990344, 0.004392204}, {0.999990344, 0.004398196}, {0.999990284, 0.004404189},
    {0.999990284, 0.004410180}, {0.999990225, 0.004416172}, {0.999990225, 0.004422165}, {0.999990225, 0.004428157},
    {0.999990165, 0.004434149}, {0.999990165, 0.004440141}, {0.999990106, 0.004446133}, {0.999990106, 0.004452125},
    {0.999990046, 0.004458117}, {0.999990046, 0.004464109}, {0.999989986, 0.004470101}, {0.999989986, 0.004476093},
    {0.999989927, 0.004482085}, {0.999989927, 0.004488077}, {0.999989927, 0.004494069}, {0.999989867, 0.004500061},
    {0.999989867, 0.004506053}, {0.999989808, 0.004512046}, {0.999989808, 0.004518037}, {0.999989748, 0.004524029},
    {0.999989748, 0.004530021}, {0.999989688, 0.004536014}, {0.999989688, 0.004542006}, {0.999989629, 0.004547998},
    {0.999989629, 0.004553990}, {0.999989629, 0.004559982}, {0.999989569, 0.004565974}, {0.999989569, 0.004571966},
    {0.999989510, 0.004577958}, {0.999989510, 0.004583950}, {0.999989450, 0.004589942}, {0.999989450, 0.004595934},
    {0.999989390, 0.004601926}, {0.999989390, 0.004607918}, {0.999989331, 0.004613910}, {0.999989331, 0.004619902},
    {0.999989271, 0.004625894}, {0.999989271, 0.004631886}, {0.999989271, 0.004637878}, {0.999989212, 0.004643871},
    {0.999989212, 0.004649863}, {0.999989152, 0.004655855}, {0.999989152, 0.004661846}, {0.999989092, 0.004667839},
    {0.999989092, 0.004673831}, {0.999989033, 0.004679823}, {0.999989033, 0.004685815}, {0.999988973, 0.004691807},
    {0.999988973, 0.004697799}, {0.999988914, 0.004703791}, {0.999988914, 0.004709783}, {0.999988854, 0.004715775},
    {0.999988854, 0.004721767}, {0.999988794, 0.004727759}, {0.999988794, 0.004733751}, {0.999988794, 0.004739743},
    {0.999988735, 0.004745735}, {0.999988735, 0.004751727}, {0.999988675, 0.004757719}, {0.999988675, 0.004763711},
    {0.999988616, 0.004769703}, {0.999988616, 0.004775696}, {0.999988556, 0.004781688}, {0.999988556, 0.004787680},
    {0.999988496, 0.004793671}, {0.999988496, 0.004799664}, {0.999988437, 0.004805656}, {0.999988437, 0.004811648},
    {0.999988377, 0.004817640}, {0.999988377, 0.004823632}, {0.999988317, 0.004829624}, {0.999988317, 0.004835616},
    {0.999988258, 0.004841608}, {0.999988258, 0.004847600}, {0.999988198, 0.004853592}, {0.999988198, 0.004859584},
    {0.999988139, 0.004865576}, {0.999988139, 0.004871568}, {0.999988079, 0.004877560}, {0.999988079, 0.004883552},
    {0.999988019, 0.004889544}, {0.999988019, 0.004895536}, {0.999987960, 0.004901528}, {0.999987960, 0.004907520},
    {0.999987900, 0.004913513}, {0.999987900, 0.004919504}, {0.999987841, 0.004925496}, {0.999987841, 0.004931489},
    {0.999987781, 0.004937481}, {0.999987781, 0.004943473}, {0.999987781, 0.004949464}, {0.999987721, 0.004955457},
    {0.999987721, 0.004961449}, {0.999987662, 0.004967441}, {0.999987662, 0.004973433}, {0.999987602, 0.004979425},
    {0.999987602, 0.004985417}, {0.999987543, 0.004991409}, {0.999987543, 0.004997401}, {0.999987483, 0.005003393},
    {0.999987423, 0.005009385}, {0.999987423, 0.005015377}, {0.999987364, 0.005021369}, {0.999987364, 0.005027361},
    {0.999987304, 0.005033353}, {0.999987304, 0.005039345}, {0.999987245, 0.005045337}, {0.999987245, 0.005051329},
    {0.999987185, 0.005057321}, {0.999987185, 0.005063314}, {0.999987125, 0.005069306}, {0.999987125, 0.005075297},
    {0.999987066, 0.005081289}, {0.999987066, 0.005087282}, {0.999987006, 0.005093274}, {0.999987006, 0.005099265},
    {0.999986947, 0.005105257}, {0.999986947, 0.005111250}, {0.999986887, 0.005117242}, {0.999986887, 0.005123234},
    {0.999986827, 0.005129226}, {0.999986827, 0.005135218}, {0.999986768, 0.005141210}, {0.999986768, 0.005147202},
    {0.999986708, 0.005153194}, {0.999986708, 0.005159186}, {0.999986649, 0.005165178}, {0.999986649, 0.005171170},
    {0.999986589, 0.005177162}, {0.999986589, 0.005183154}, {0.999986529, 0.005189146}, {0.999986529, 0.005195138},
    {0.999986470, 0.005201130}, {0.999986470, 0.005207122}, {0.999986410, 0.005213114}, {0.999986410, 0.005219106},
    {0.999986351, 0.005225098}, {0.999986291, 0.005231090}, {0.999986291, 0.005237082}, {0.999986231, 0.005243074},
    {0.999986231, 0.005249066}, {0.999986172, 0.005255058}, {0.999986172, 0.005261051}, {0.999986112, 0.005267043},
    {0.999986112, 0.005273034}, {0.999986053, 0.005279026}, {0.999986053, 0.005285019}, {0.999985993, 0.005291011},
    {0.999985993, 0.005297003}, {0.999985933, 0.005302995}, {0.999985933, 0.005308987}, {0.999985874, 0.005314979},
    {0.999985814, 0.005320971}, {0.999985814, 0.005326963}, {0.999985754, 0.005332955}, {0.999985754, 0.005338947},
    {0.999985695, 0.005344939}, {0.999985695, 0.005350931}, {0.999985635, 0.005356923}, {0.999985635, 0.005362915},
    {0.999985576, 0.005368907}, {0.999985576, 0.005374899}, {0.999985516, 0.005380891}, {0.999985516, 0.005386883},
    {0.999985456, 0.005392875}, {0.999985397, 0.005398867}, {0.999985397, 0.005404859}, {0.999985337, 0.005410851},
    {0.999985337, 0.005416843}, {0.999985278, 0.005422835}, {0.999985278, 0.005428827}, {0.999985218, 0.005434819},
    {0.999985218, 0.005440811}, {0.999985158, 0.005446803}, {0.999985158, 0.005452795}, {0.999985099, 0.005458788},
    {0.999985039, 0.005464779}, {0.999985039, 0.005470771}, {0.999984980, 0.005476763}, {0.999984980, 0.005482756},
    {0.999984920, 0.005488747}, {0.999984920, 0.005494739}, {0.999984860, 0.005500732}, {0.999984860, 0.005506724},
    {0.999984801, 0.005512715}, {0.999984801, 0.005518707}, {0.999984741, 0.005524700}, {0.999984682, 0.005530692},
    {0.999984682, 0.005536684}, {0.999984622, 0.005542675}, {0.999984622, 0.005548668}, {0.999984562, 0.005554660},
    {0.999984562, 0.005560652}, {0.999984503, 0.005566644}, {0.999984443, 0.005572636}, {0.999984443, 0.005578628},
    {0.999984384, 0.005584620}, {0.999984384, 0.005590612}, {0.999984324, 0.005596604}, {0.999984324, 0.005602596},
    {0.999984264, 0.005608588}, {0.999984264, 0.005614580}, {0.999984205, 0.005620572}, {0.999984145, 0.005626564},
    {0.999984145, 0.005632556}, {0.999984086, 0.005638548}, {0.999984086, 0.005644540}, {0.999984026, 0.005650532},
    {0.999984026, 0.005656524}, {0.999983966, 0.005662516}, {0.999983907, 0.005668508}, {0.999983907, 0.005674500},
    {0.999983847, 0.005680492}, {0.999983847, 0.005686484}, {0.999983788, 0.005692476}, {0.999983788, 0.005698468},
    {0.999983728, 0.005704460}, {0.999983668, 0.005710452}, {0.999983668, 0.005716444}, {0.999983609, 0.005722436},
    {0.999983609, 0.005728428}, {0.999983549, 0.005734420}, {0.999983549, 0.005740412}, {0.999983490, 0.005746404},
    {0.999983430, 0.005752396}, {0.999983430, 0.005758388}, {0.999983370, 0.005764380}, {0.999983370, 0.005770372},
    {0.999983311, 0.005776364}, {0.999983311, 0.005782356}, {0.999983251, 0.005788348}, {0.999983191, 0.005794340},
    {0.999983191, 0.005800332}, {0.999983132, 0.005806325}, {0.999983132, 0.005812316}, {0.999983072, 0.005818308},
    {0.999983013, 0.005824300}, {0.999983013, 0.005830293}, {0.999982953, 0.005836284}, {0.999982953, 0.005842276},
    {0.999982893, 0.005848269}, {0.999982893, 0.005854261}, {0.999982834, 0.005860252}, {0.999982774, 0.005866244},
    {0.999982774, 0.005872237}, {0.999982715, 0.005878229}, {0.999982715, 0.005884220}, {0.999982655, 0.005890212},
    {0.999982595, 0.005896205}, {0.999982595, 0.005902196}, {0.999982536, 0.005908188}, {0.999982536, 0.005914181},
    {0.999982476, 0.005920173}, {0.999982417, 0.005926164}, {0.999982417, 0.005932156}, {0.999982357, 0.005938149},
    {0.999982357, 0.005944141}, {0.999982297, 0.005950132}, {0.999982238, 0.005956125}, {0.999982238, 0.005962117},
    {0.999982178, 0.005968109}, {0.999982178, 0.005974100}, {0.999982119, 0.005980093}, {0.999982059, 0.005986085},
    {0.999982059, 0.005992077}, {0.999981999, 0.005998068}, {0.999981999, 0.006004061}, {0.999981940, 0.006010053},
    {0.999981880, 0.006016044}, {0.999981880, 0.006022037}, {0.999981821, 0.006028029}, {0.999981821, 0.006034021},
    {0.999981761, 0.006040012}, {0.999981701, 0.006046005}, {0.999981701, 0.006051997}, {0.999981642, 0.006057989},
    {0.999981642, 0.006063981}, {0.999981582, 0.006069973}, {0.999981523, 0.006075965}, {0.999981523, 0.006081956},
    {0.999981463, 0.006087949}, {0.999981403, 0.006093941}, {0.999981403, 0.006099933}, {0.999981344, 0.006105924},
    {0.999981344, 0.006111917}, {0.999981284, 0.006117909}, {0.999981225, 0.006123901}, {0.999981225, 0.006129893}};

alignas(__ALIGN_BYTE_SIZE__) const cfloat sincosLUTFloat3[1024] = {
    {1.000000000, 0.000000000}, {1.000000000, 0.000000006}, {1.000000000, 0.000000012}, {1.000000000, 0.000000018},
    {1.000000000, 0.000000023}, {1.000000000, 0.000000029}, {1.000000000, 0.000000035}, {1.000000000, 0.000000041},
    {1.000000000, 0.000000047}, {1.000000000, 0.000000053}, {1.000000000, 0.000000059}, {1.000000000, 0.000000064},
    {1.000000000, 0.000000070}, {1.000000000, 0.000000076}, {1.000000000, 0.000000082}, {1.000000000, 0.000000088},
    {1.000000000, 0.000000094}, {1.000000000, 0.000000099}, {1.000000000, 0.000000105}, {1.000000000, 0.000000111},
    {1.000000000, 0.000000117}, {1.000000000, 0.000000123}, {1.000000000, 0.000000129}, {1.000000000, 0.000000135},
    {1.000000000, 0.000000140}, {1.000000000, 0.000000146}, {1.000000000, 0.000000152}, {1.000000000, 0.000000158},
    {1.000000000, 0.000000164}, {1.000000000, 0.000000170}, {1.000000000, 0.000000176}, {1.000000000, 0.000000181},
    {1.000000000, 0.000000187}, {1.000000000, 0.000000193}, {1.000000000, 0.000000199}, {1.000000000, 0.000000205},
    {1.000000000, 0.000000211}, {1.000000000, 0.000000217}, {1.000000000, 0.000000222}, {1.000000000, 0.000000228},
    {1.000000000, 0.000000234}, {1.000000000, 0.000000240}, {1.000000000, 0.000000246}, {1.000000000, 0.000000252},
    {1.000000000, 0.000000257}, {1.000000000, 0.000000263}, {1.000000000, 0.000000269}, {1.000000000, 0.000000275},
    {1.000000000, 0.000000281}, {1.000000000, 0.000000287}, {1.000000000, 0.000000293}, {1.000000000, 0.000000298},
    {1.000000000, 0.000000304}, {1.000000000, 0.000000310}, {1.000000000, 0.000000316}, {1.000000000, 0.000000322},
    {1.000000000, 0.000000328}, {1.000000000, 0.000000334}, {1.000000000, 0.000000339}, {1.000000000, 0.000000345},
    {1.000000000, 0.000000351}, {1.000000000, 0.000000357}, {1.000000000, 0.000000363}, {1.000000000, 0.000000369},
    {1.000000000, 0.000000375}, {1.000000000, 0.000000380}, {1.000000000, 0.000000386}, {1.000000000, 0.000000392},
    {1.000000000, 0.000000398}, {1.000000000, 0.000000404}, {1.000000000, 0.000000410}, {1.000000000, 0.000000415},
    {1.000000000, 0.000000421}, {1.000000000, 0.000000427}, {1.000000000, 0.000000433}, {1.000000000, 0.000000439},
    {1.000000000, 0.000000445}, {1.000000000, 0.000000451}, {1.000000000, 0.000000456}, {1.000000000, 0.000000462},
    {1.000000000, 0.000000468}, {1.000000000, 0.000000474}, {1.000000000, 0.000000480}, {1.000000000, 0.000000486},
    {1.000000000, 0.000000492}, {1.000000000, 0.000000497}, {1.000000000, 0.000000503}, {1.000000000, 0.000000509},
    {1.000000000, 0.000000515}, {1.000000000, 0.000000521}, {1.000000000, 0.000000527}, {1.000000000, 0.000000533},
    {1.000000000, 0.000000538}, {1.000000000, 0.000000544}, {1.000000000, 0.000000550}, {1.000000000, 0.000000556},
    {1.000000000, 0.000000562}, {1.000000000, 0.000000568}, {1.000000000, 0.000000573}, {1.000000000, 0.000000579},
    {1.000000000, 0.000000585}, {1.000000000, 0.000000591}, {1.000000000, 0.000000597}, {1.000000000, 0.000000603},
    {1.000000000, 0.000000609}, {1.000000000, 0.000000614}, {1.000000000, 0.000000620}, {1.000000000, 0.000000626},
    {1.000000000, 0.000000632}, {1.000000000, 0.000000638}, {1.000000000, 0.000000644}, {1.000000000, 0.000000650},
    {1.000000000, 0.000000655}, {1.000000000, 0.000000661}, {1.000000000, 0.000000667}, {1.000000000, 0.000000673},
    {1.000000000, 0.000000679}, {1.000000000, 0.000000685}, {1.000000000, 0.000000690}, {1.000000000, 0.000000696},
    {1.000000000, 0.000000702}, {1.000000000, 0.000000708}, {1.000000000, 0.000000714}, {1.000000000, 0.000000720},
    {1.000000000, 0.000000726}, {1.000000000, 0.000000731}, {1.000000000, 0.000000737}, {1.000000000, 0.000000743},
    {1.000000000, 0.000000749}, {1.000000000, 0.000000755}, {1.000000000, 0.000000761}, {1.000000000, 0.000000767},
    {1.000000000, 0.000000772}, {1.000000000, 0.000000778}, {1.000000000, 0.000000784}, {1.000000000, 0.000000790},
    {1.000000000, 0.000000796}, {1.000000000, 0.000000802}, {1.000000000, 0.000000808}, {1.000000000, 0.000000813},
    {1.000000000, 0.000000819}, {1.000000000, 0.000000825}, {1.000000000, 0.000000831}, {1.000000000, 0.000000837},
    {1.000000000, 0.000000843}, {1.000000000, 0.000000848}, {1.000000000, 0.000000854}, {1.000000000, 0.000000860},
    {1.000000000, 0.000000866}, {1.000000000, 0.000000872}, {1.000000000, 0.000000878}, {1.000000000, 0.000000884},
    {1.000000000, 0.000000889}, {1.000000000, 0.000000895}, {1.000000000, 0.000000901}, {1.000000000, 0.000000907},
    {1.000000000, 0.000000913}, {1.000000000, 0.000000919}, {1.000000000, 0.000000925}, {1.000000000, 0.000000930},
    {1.000000000, 0.000000936}, {1.000000000, 0.000000942}, {1.000000000, 0.000000948}, {1.000000000, 0.000000954},
    {1.000000000, 0.000000960}, {1.000000000, 0.000000966}, {1.000000000, 0.000000971}, {1.000000000, 0.000000977},
    {1.000000000, 0.000000983}, {1.000000000, 0.000000989}, {1.000000000, 0.000000995}, {1.000000000, 0.000001001},
    {1.000000000, 0.000001006}, {1.000000000, 0.000001012}, {1.000000000, 0.000001018}, {1.000000000, 0.000001024},
    {1.000000000, 0.000001030}, {1.000000000, 0.000001036}, {1.000000000, 0.000001042}, {1.000000000, 0.000001047},
    {1.000000000, 0.000001053}, {1.000000000, 0.000001059}, {1.000000000, 0.000001065}, {1.000000000, 0.000001071},
    {1.000000000, 0.000001077}, {1.000000000, 0.000001083}, {1.000000000, 0.000001088}, {1.000000000, 0.000001094},
    {1.000000000, 0.000001100}, {1.000000000, 0.000001106}, {1.000000000, 0.000001112}, {1.000000000, 0.000001118},
    {1.000000000, 0.000001124}, {1.000000000, 0.000001129}, {1.000000000, 0.000001135}, {1.000000000, 0.000001141},
    {1.000000000, 0.000001147}, {1.000000000, 0.000001153}, {1.000000000, 0.000001159}, {1.000000000, 0.000001164},
    {1.000000000, 0.000001170}, {1.000000000, 0.000001176}, {1.000000000, 0.000001182}, {1.000000000, 0.000001188},
    {1.000000000, 0.000001194}, {1.000000000, 0.000001200}, {1.000000000, 0.000001205}, {1.000000000, 0.000001211},
    {1.000000000, 0.000001217}, {1.000000000, 0.000001223}, {1.000000000, 0.000001229}, {1.000000000, 0.000001235},
    {1.000000000, 0.000001241}, {1.000000000, 0.000001246}, {1.000000000, 0.000001252}, {1.000000000, 0.000001258},
    {1.000000000, 0.000001264}, {1.000000000, 0.000001270}, {1.000000000, 0.000001276}, {1.000000000, 0.000001282},
    {1.000000000, 0.000001287}, {1.000000000, 0.000001293}, {1.000000000, 0.000001299}, {1.000000000, 0.000001305},
    {1.000000000, 0.000001311}, {1.000000000, 0.000001317}, {1.000000000, 0.000001322}, {1.000000000, 0.000001328},
    {1.000000000, 0.000001334}, {1.000000000, 0.000001340}, {1.000000000, 0.000001346}, {1.000000000, 0.000001352},
    {1.000000000, 0.000001358}, {1.000000000, 0.000001363}, {1.000000000, 0.000001369}, {1.000000000, 0.000001375},
    {1.000000000, 0.000001381}, {1.000000000, 0.000001387}, {1.000000000, 0.000001393}, {1.000000000, 0.000001399},
    {1.000000000, 0.000001404}, {1.000000000, 0.000001410}, {1.000000000, 0.000001416}, {1.000000000, 0.000001422},
    {1.000000000, 0.000001428}, {1.000000000, 0.000001434}, {1.000000000, 0.000001440}, {1.000000000, 0.000001445},
    {1.000000000, 0.000001451}, {1.000000000, 0.000001457}, {1.000000000, 0.000001463}, {1.000000000, 0.000001469},
    {1.000000000, 0.000001475}, {1.000000000, 0.000001480}, {1.000000000, 0.000001486}, {1.000000000, 0.000001492},
    {1.000000000, 0.000001498}, {1.000000000, 0.000001504}, {1.000000000, 0.000001510}, {1.000000000, 0.000001516},
    {1.000000000, 0.000001521}, {1.000000000, 0.000001527}, {1.000000000, 0.000001533}, {1.000000000, 0.000001539},
    {1.000000000, 0.000001545}, {1.000000000, 0.000001551}, {1.000000000, 0.000001557}, {1.000000000, 0.000001562},
    {1.000000000, 0.000001568}, {1.000000000, 0.000001574}, {1.000000000, 0.000001580}, {1.000000000, 0.000001586},
    {1.000000000, 0.000001592}, {1.000000000, 0.000001598}, {1.000000000, 0.000001603}, {1.000000000, 0.000001609},
    {1.000000000, 0.000001615}, {1.000000000, 0.000001621}, {1.000000000, 0.000001627}, {1.000000000, 0.000001633},
    {1.000000000, 0.000001638}, {1.000000000, 0.000001644}, {1.000000000, 0.000001650}, {1.000000000, 0.000001656},
    {1.000000000, 0.000001662}, {1.000000000, 0.000001668}, {1.000000000, 0.000001674}, {1.000000000, 0.000001679},
    {1.000000000, 0.000001685}, {1.000000000, 0.000001691}, {1.000000000, 0.000001697}, {1.000000000, 0.000001703},
    {1.000000000, 0.000001709}, {1.000000000, 0.000001715}, {1.000000000, 0.000001720}, {1.000000000, 0.000001726},
    {1.000000000, 0.000001732}, {1.000000000, 0.000001738}, {1.000000000, 0.000001744}, {1.000000000, 0.000001750},
    {1.000000000, 0.000001756}, {1.000000000, 0.000001761}, {1.000000000, 0.000001767}, {1.000000000, 0.000001773},
    {1.000000000, 0.000001779}, {1.000000000, 0.000001785}, {1.000000000, 0.000001791}, {1.000000000, 0.000001796},
    {1.000000000, 0.000001802}, {1.000000000, 0.000001808}, {1.000000000, 0.000001814}, {1.000000000, 0.000001820},
    {1.000000000, 0.000001826}, {1.000000000, 0.000001832}, {1.000000000, 0.000001837}, {1.000000000, 0.000001843},
    {1.000000000, 0.000001849}, {1.000000000, 0.000001855}, {1.000000000, 0.000001861}, {1.000000000, 0.000001867},
    {1.000000000, 0.000001873}, {1.000000000, 0.000001878}, {1.000000000, 0.000001884}, {1.000000000, 0.000001890},
    {1.000000000, 0.000001896}, {1.000000000, 0.000001902}, {1.000000000, 0.000001908}, {1.000000000, 0.000001913},
    {1.000000000, 0.000001919}, {1.000000000, 0.000001925}, {1.000000000, 0.000001931}, {1.000000000, 0.000001937},
    {1.000000000, 0.000001943}, {1.000000000, 0.000001949}, {1.000000000, 0.000001954}, {1.000000000, 0.000001960},
    {1.000000000, 0.000001966}, {1.000000000, 0.000001972}, {1.000000000, 0.000001978}, {1.000000000, 0.000001984},
    {1.000000000, 0.000001990}, {1.000000000, 0.000001995}, {1.000000000, 0.000002001}, {1.000000000, 0.000002007},
    {1.000000000, 0.000002013}, {1.000000000, 0.000002019}, {1.000000000, 0.000002025}, {1.000000000, 0.000002031},
    {1.000000000, 0.000002036}, {1.000000000, 0.000002042}, {1.000000000, 0.000002048}, {1.000000000, 0.000002054},
    {1.000000000, 0.000002060}, {1.000000000, 0.000002066}, {1.000000000, 0.000002071}, {1.000000000, 0.000002077},
    {1.000000000, 0.000002083}, {1.000000000, 0.000002089}, {1.000000000, 0.000002095}, {1.000000000, 0.000002101},
    {1.000000000, 0.000002107}, {1.000000000, 0.000002112}, {1.000000000, 0.000002118}, {1.000000000, 0.000002124},
    {1.000000000, 0.000002130}, {1.000000000, 0.000002136}, {1.000000000, 0.000002142}, {1.000000000, 0.000002148},
    {1.000000000, 0.000002153}, {1.000000000, 0.000002159}, {1.000000000, 0.000002165}, {1.000000000, 0.000002171},
    {1.000000000, 0.000002177}, {1.000000000, 0.000002183}, {1.000000000, 0.000002189}, {1.000000000, 0.000002194},
    {1.000000000, 0.000002200}, {1.000000000, 0.000002206}, {1.000000000, 0.000002212}, {1.000000000, 0.000002218},
    {1.000000000, 0.000002224}, {1.000000000, 0.000002229}, {1.000000000, 0.000002235}, {1.000000000, 0.000002241},
    {1.000000000, 0.000002247}, {1.000000000, 0.000002253}, {1.000000000, 0.000002259}, {1.000000000, 0.000002265},
    {1.000000000, 0.000002270}, {1.000000000, 0.000002276}, {1.000000000, 0.000002282}, {1.000000000, 0.000002288},
    {1.000000000, 0.000002294}, {1.000000000, 0.000002300}, {1.000000000, 0.000002306}, {1.000000000, 0.000002311},
    {1.000000000, 0.000002317}, {1.000000000, 0.000002323}, {1.000000000, 0.000002329}, {1.000000000, 0.000002335},
    {1.000000000, 0.000002341}, {1.000000000, 0.000002347}, {1.000000000, 0.000002352}, {1.000000000, 0.000002358},
    {1.000000000, 0.000002364}, {1.000000000, 0.000002370}, {1.000000000, 0.000002376}, {1.000000000, 0.000002382},
    {1.000000000, 0.000002387}, {1.000000000, 0.000002393}, {1.000000000, 0.000002399}, {1.000000000, 0.000002405},
    {1.000000000, 0.000002411}, {1.000000000, 0.000002417}, {1.000000000, 0.000002423}, {1.000000000, 0.000002428},
    {1.000000000, 0.000002434}, {1.000000000, 0.000002440}, {1.000000000, 0.000002446}, {1.000000000, 0.000002452},
    {1.000000000, 0.000002458}, {1.000000000, 0.000002464}, {1.000000000, 0.000002469}, {1.000000000, 0.000002475},
    {1.000000000, 0.000002481}, {1.000000000, 0.000002487}, {1.000000000, 0.000002493}, {1.000000000, 0.000002499},
    {1.000000000, 0.000002505}, {1.000000000, 0.000002510}, {1.000000000, 0.000002516}, {1.000000000, 0.000002522},
    {1.000000000, 0.000002528}, {1.000000000, 0.000002534}, {1.000000000, 0.000002540}, {1.000000000, 0.000002545},
    {1.000000000, 0.000002551}, {1.000000000, 0.000002557}, {1.000000000, 0.000002563}, {1.000000000, 0.000002569},
    {1.000000000, 0.000002575}, {1.000000000, 0.000002581}, {1.000000000, 0.000002586}, {1.000000000, 0.000002592},
    {1.000000000, 0.000002598}, {1.000000000, 0.000002604}, {1.000000000, 0.000002610}, {1.000000000, 0.000002616},
    {1.000000000, 0.000002622}, {1.000000000, 0.000002627}, {1.000000000, 0.000002633}, {1.000000000, 0.000002639},
    {1.000000000, 0.000002645}, {1.000000000, 0.000002651}, {1.000000000, 0.000002657}, {1.000000000, 0.000002663},
    {1.000000000, 0.000002668}, {1.000000000, 0.000002674}, {1.000000000, 0.000002680}, {1.000000000, 0.000002686},
    {1.000000000, 0.000002692}, {1.000000000, 0.000002698}, {1.000000000, 0.000002703}, {1.000000000, 0.000002709},
    {1.000000000, 0.000002715}, {1.000000000, 0.000002721}, {1.000000000, 0.000002727}, {1.000000000, 0.000002733},
    {1.000000000, 0.000002739}, {1.000000000, 0.000002744}, {1.000000000, 0.000002750}, {1.000000000, 0.000002756},
    {1.000000000, 0.000002762}, {1.000000000, 0.000002768}, {1.000000000, 0.000002774}, {1.000000000, 0.000002780},
    {1.000000000, 0.000002785}, {1.000000000, 0.000002791}, {1.000000000, 0.000002797}, {1.000000000, 0.000002803},
    {1.000000000, 0.000002809}, {1.000000000, 0.000002815}, {1.000000000, 0.000002821}, {1.000000000, 0.000002826},
    {1.000000000, 0.000002832}, {1.000000000, 0.000002838}, {1.000000000, 0.000002844}, {1.000000000, 0.000002850},
    {1.000000000, 0.000002856}, {1.000000000, 0.000002861}, {1.000000000, 0.000002867}, {1.000000000, 0.000002873},
    {1.000000000, 0.000002879}, {1.000000000, 0.000002885}, {1.000000000, 0.000002891}, {1.000000000, 0.000002897},
    {1.000000000, 0.000002902}, {1.000000000, 0.000002908}, {1.000000000, 0.000002914}, {1.000000000, 0.000002920},
    {1.000000000, 0.000002926}, {1.000000000, 0.000002932}, {1.000000000, 0.000002938}, {1.000000000, 0.000002943},
    {1.000000000, 0.000002949}, {1.000000000, 0.000002955}, {1.000000000, 0.000002961}, {1.000000000, 0.000002967},
    {1.000000000, 0.000002973}, {1.000000000, 0.000002979}, {1.000000000, 0.000002984}, {1.000000000, 0.000002990},
    {1.000000000, 0.000002996}, {1.000000000, 0.000003002}, {1.000000000, 0.000003008}, {1.000000000, 0.000003014},
    {1.000000000, 0.000003019}, {1.000000000, 0.000003025}, {1.000000000, 0.000003031}, {1.000000000, 0.000003037},
    {1.000000000, 0.000003043}, {1.000000000, 0.000003049}, {1.000000000, 0.000003055}, {1.000000000, 0.000003060},
    {1.000000000, 0.000003066}, {1.000000000, 0.000003072}, {1.000000000, 0.000003078}, {1.000000000, 0.000003084},
    {1.000000000, 0.000003090}, {1.000000000, 0.000003096}, {1.000000000, 0.000003101}, {1.000000000, 0.000003107},
    {1.000000000, 0.000003113}, {1.000000000, 0.000003119}, {1.000000000, 0.000003125}, {1.000000000, 0.000003131},
    {1.000000000, 0.000003136}, {1.000000000, 0.000003142}, {1.000000000, 0.000003148}, {1.000000000, 0.000003154},
    {1.000000000, 0.000003160}, {1.000000000, 0.000003166}, {1.000000000, 0.000003172}, {1.000000000, 0.000003177},
    {1.000000000, 0.000003183}, {1.000000000, 0.000003189}, {1.000000000, 0.000003195}, {1.000000000, 0.000003201},
    {1.000000000, 0.000003207}, {1.000000000, 0.000003213}, {1.000000000, 0.000003218}, {1.000000000, 0.000003224},
    {1.000000000, 0.000003230}, {1.000000000, 0.000003236}, {1.000000000, 0.000003242}, {1.000000000, 0.000003248},
    {1.000000000, 0.000003254}, {1.000000000, 0.000003259}, {1.000000000, 0.000003265}, {1.000000000, 0.000003271},
    {1.000000000, 0.000003277}, {1.000000000, 0.000003283}, {1.000000000, 0.000003289}, {1.000000000, 0.000003294},
    {1.000000000, 0.000003300}, {1.000000000, 0.000003306}, {1.000000000, 0.000003312}, {1.000000000, 0.000003318},
    {1.000000000, 0.000003324}, {1.000000000, 0.000003330}, {1.000000000, 0.000003335}, {1.000000000, 0.000003341},
    {1.000000000, 0.000003347}, {1.000000000, 0.000003353}, {1.000000000, 0.000003359}, {1.000000000, 0.000003365},
    {1.000000000, 0.000003371}, {1.000000000, 0.000003376}, {1.000000000, 0.000003382}, {1.000000000, 0.000003388},
    {1.000000000, 0.000003394}, {1.000000000, 0.000003400}, {1.000000000, 0.000003406}, {1.000000000, 0.000003412},
    {1.000000000, 0.000003417}, {1.000000000, 0.000003423}, {1.000000000, 0.000003429}, {1.000000000, 0.000003435},
    {1.000000000, 0.000003441}, {1.000000000, 0.000003447}, {1.000000000, 0.000003452}, {1.000000000, 0.000003458},
    {1.000000000, 0.000003464}, {1.000000000, 0.000003470}, {1.000000000, 0.000003476}, {1.000000000, 0.000003482},
    {1.000000000, 0.000003488}, {1.000000000, 0.000003493}, {1.000000000, 0.000003499}, {1.000000000, 0.000003505},
    {1.000000000, 0.000003511}, {1.000000000, 0.000003517}, {1.000000000, 0.000003523}, {1.000000000, 0.000003529},
    {1.000000000, 0.000003534}, {1.000000000, 0.000003540}, {1.000000000, 0.000003546}, {1.000000000, 0.000003552},
    {1.000000000, 0.000003558}, {1.000000000, 0.000003564}, {1.000000000, 0.000003570}, {1.000000000, 0.000003575},
    {1.000000000, 0.000003581}, {1.000000000, 0.000003587}, {1.000000000, 0.000003593}, {1.000000000, 0.000003599},
    {1.000000000, 0.000003605}, {1.000000000, 0.000003610}, {1.000000000, 0.000003616}, {1.000000000, 0.000003622},
    {1.000000000, 0.000003628}, {1.000000000, 0.000003634}, {1.000000000, 0.000003640}, {1.000000000, 0.000003646},
    {1.000000000, 0.000003651}, {1.000000000, 0.000003657}, {1.000000000, 0.000003663}, {1.000000000, 0.000003669},
    {1.000000000, 0.000003675}, {1.000000000, 0.000003681}, {1.000000000, 0.000003687}, {1.000000000, 0.000003692},
    {1.000000000, 0.000003698}, {1.000000000, 0.000003704}, {1.000000000, 0.000003710}, {1.000000000, 0.000003716},
    {1.000000000, 0.000003722}, {1.000000000, 0.000003728}, {1.000000000, 0.000003733}, {1.000000000, 0.000003739},
    {1.000000000, 0.000003745}, {1.000000000, 0.000003751}, {1.000000000, 0.000003757}, {1.000000000, 0.000003763},
    {1.000000000, 0.000003768}, {1.000000000, 0.000003774}, {1.000000000, 0.000003780}, {1.000000000, 0.000003786},
    {1.000000000, 0.000003792}, {1.000000000, 0.000003798}, {1.000000000, 0.000003804}, {1.000000000, 0.000003809},
    {1.000000000, 0.000003815}, {1.000000000, 0.000003821}, {1.000000000, 0.000003827}, {1.000000000, 0.000003833},
    {1.000000000, 0.000003839}, {1.000000000, 0.000003845}, {1.000000000, 0.000003850}, {1.000000000, 0.000003856},
    {1.000000000, 0.000003862}, {1.000000000, 0.000003868}, {1.000000000, 0.000003874}, {1.000000000, 0.000003880},
    {1.000000000, 0.000003886}, {1.000000000, 0.000003891}, {1.000000000, 0.000003897}, {1.000000000, 0.000003903},
    {1.000000000, 0.000003909}, {1.000000000, 0.000003915}, {1.000000000, 0.000003921}, {1.000000000, 0.000003926},
    {1.000000000, 0.000003932}, {1.000000000, 0.000003938}, {1.000000000, 0.000003944}, {1.000000000, 0.000003950},
    {1.000000000, 0.000003956}, {1.000000000, 0.000003962}, {1.000000000, 0.000003967}, {1.000000000, 0.000003973},
    {1.000000000, 0.000003979}, {1.000000000, 0.000003985}, {1.000000000, 0.000003991}, {1.000000000, 0.000003997},
    {1.000000000, 0.000004003}, {1.000000000, 0.000004008}, {1.000000000, 0.000004014}, {1.000000000, 0.000004020},
    {1.000000000, 0.000004026}, {1.000000000, 0.000004032}, {1.000000000, 0.000004038}, {1.000000000, 0.000004044},
    {1.000000000, 0.000004049}, {1.000000000, 0.000004055}, {1.000000000, 0.000004061}, {1.000000000, 0.000004067},
    {1.000000000, 0.000004073}, {1.000000000, 0.000004079}, {1.000000000, 0.000004084}, {1.000000000, 0.000004090},
    {1.000000000, 0.000004096}, {1.000000000, 0.000004102}, {1.000000000, 0.000004108}, {1.000000000, 0.000004114},
    {1.000000000, 0.000004120}, {1.000000000, 0.000004125}, {1.000000000, 0.000004131}, {1.000000000, 0.000004137},
    {1.000000000, 0.000004143}, {1.000000000, 0.000004149}, {1.000000000, 0.000004155}, {1.000000000, 0.000004161},
    {1.000000000, 0.000004166}, {1.000000000, 0.000004172}, {1.000000000, 0.000004178}, {1.000000000, 0.000004184},
    {1.000000000, 0.000004190}, {1.000000000, 0.000004196}, {1.000000000, 0.000004202}, {1.000000000, 0.000004207},
    {1.000000000, 0.000004213}, {1.000000000, 0.000004219}, {1.000000000, 0.000004225}, {1.000000000, 0.000004231},
    {1.000000000, 0.000004237}, {1.000000000, 0.000004242}, {1.000000000, 0.000004248}, {1.000000000, 0.000004254},
    {1.000000000, 0.000004260}, {1.000000000, 0.000004266}, {1.000000000, 0.000004272}, {1.000000000, 0.000004278},
    {1.000000000, 0.000004283}, {1.000000000, 0.000004289}, {1.000000000, 0.000004295}, {1.000000000, 0.000004301},
    {1.000000000, 0.000004307}, {1.000000000, 0.000004313}, {1.000000000, 0.000004319}, {1.000000000, 0.000004324},
    {1.000000000, 0.000004330}, {1.000000000, 0.000004336}, {1.000000000, 0.000004342}, {1.000000000, 0.000004348},
    {1.000000000, 0.000004354}, {1.000000000, 0.000004359}, {1.000000000, 0.000004365}, {1.000000000, 0.000004371},
    {1.000000000, 0.000004377}, {1.000000000, 0.000004383}, {1.000000000, 0.000004389}, {1.000000000, 0.000004395},
    {1.000000000, 0.000004400}, {1.000000000, 0.000004406}, {1.000000000, 0.000004412}, {1.000000000, 0.000004418},
    {1.000000000, 0.000004424}, {1.000000000, 0.000004430}, {1.000000000, 0.000004436}, {1.000000000, 0.000004441},
    {1.000000000, 0.000004447}, {1.000000000, 0.000004453}, {1.000000000, 0.000004459}, {1.000000000, 0.000004465},
    {1.000000000, 0.000004471}, {1.000000000, 0.000004477}, {1.000000000, 0.000004482}, {1.000000000, 0.000004488},
    {1.000000000, 0.000004494}, {1.000000000, 0.000004500}, {1.000000000, 0.000004506}, {1.000000000, 0.000004512},
    {1.000000000, 0.000004517}, {1.000000000, 0.000004523}, {1.000000000, 0.000004529}, {1.000000000, 0.000004535},
    {1.000000000, 0.000004541}, {1.000000000, 0.000004547}, {1.000000000, 0.000004553}, {1.000000000, 0.000004558},
    {1.000000000, 0.000004564}, {1.000000000, 0.000004570}, {1.000000000, 0.000004576}, {1.000000000, 0.000004582},
    {1.000000000, 0.000004588}, {1.000000000, 0.000004594}, {1.000000000, 0.000004599}, {1.000000000, 0.000004605},
    {1.000000000, 0.000004611}, {1.000000000, 0.000004617}, {1.000000000, 0.000004623}, {1.000000000, 0.000004629},
    {1.000000000, 0.000004635}, {1.000000000, 0.000004640}, {1.000000000, 0.000004646}, {1.000000000, 0.000004652},
    {1.000000000, 0.000004658}, {1.000000000, 0.000004664}, {1.000000000, 0.000004670}, {1.000000000, 0.000004675},
    {1.000000000, 0.000004681}, {1.000000000, 0.000004687}, {1.000000000, 0.000004693}, {1.000000000, 0.000004699},
    {1.000000000, 0.000004705}, {1.000000000, 0.000004711}, {1.000000000, 0.000004716}, {1.000000000, 0.000004722},
    {1.000000000, 0.000004728}, {1.000000000, 0.000004734}, {1.000000000, 0.000004740}, {1.000000000, 0.000004746},
    {1.000000000, 0.000004752}, {1.000000000, 0.000004757}, {1.000000000, 0.000004763}, {1.000000000, 0.000004769},
    {1.000000000, 0.000004775}, {1.000000000, 0.000004781}, {1.000000000, 0.000004787}, {1.000000000, 0.000004793},
    {1.000000000, 0.000004798}, {1.000000000, 0.000004804}, {1.000000000, 0.000004810}, {1.000000000, 0.000004816},
    {1.000000000, 0.000004822}, {1.000000000, 0.000004828}, {1.000000000, 0.000004833}, {1.000000000, 0.000004839},
    {1.000000000, 0.000004845}, {1.000000000, 0.000004851}, {1.000000000, 0.000004857}, {1.000000000, 0.000004863},
    {1.000000000, 0.000004869}, {1.000000000, 0.000004874}, {1.000000000, 0.000004880}, {1.000000000, 0.000004886},
    {1.000000000, 0.000004892}, {1.000000000, 0.000004898}, {1.000000000, 0.000004904}, {1.000000000, 0.000004910},
    {1.000000000, 0.000004915}, {1.000000000, 0.000004921}, {1.000000000, 0.000004927}, {1.000000000, 0.000004933},
    {1.000000000, 0.000004939}, {1.000000000, 0.000004945}, {1.000000000, 0.000004951}, {1.000000000, 0.000004956},
    {1.000000000, 0.000004962}, {1.000000000, 0.000004968}, {1.000000000, 0.000004974}, {1.000000000, 0.000004980},
    {1.000000000, 0.000004986}, {1.000000000, 0.000004991}, {1.000000000, 0.000004997}, {1.000000000, 0.000005003},
    {1.000000000, 0.000005009}, {1.000000000, 0.000005015}, {1.000000000, 0.000005021}, {1.000000000, 0.000005027},
    {1.000000000, 0.000005032}, {1.000000000, 0.000005038}, {1.000000000, 0.000005044}, {1.000000000, 0.000005050},
    {1.000000000, 0.000005056}, {1.000000000, 0.000005062}, {1.000000000, 0.000005068}, {1.000000000, 0.000005073},
    {1.000000000, 0.000005079}, {1.000000000, 0.000005085}, {1.000000000, 0.000005091}, {1.000000000, 0.000005097},
    {1.000000000, 0.000005103}, {1.000000000, 0.000005109}, {1.000000000, 0.000005114}, {1.000000000, 0.000005120},
    {1.000000000, 0.000005126}, {1.000000000, 0.000005132}, {1.000000000, 0.000005138}, {1.000000000, 0.000005144},
    {1.000000000, 0.000005149}, {1.000000000, 0.000005155}, {1.000000000, 0.000005161}, {1.000000000, 0.000005167},
    {1.000000000, 0.000005173}, {1.000000000, 0.000005179}, {1.000000000, 0.000005185}, {1.000000000, 0.000005190},
    {1.000000000, 0.000005196}, {1.000000000, 0.000005202}, {1.000000000, 0.000005208}, {1.000000000, 0.000005214},
    {1.000000000, 0.000005220}, {1.000000000, 0.000005226}, {1.000000000, 0.000005231}, {1.000000000, 0.000005237},
    {1.000000000, 0.000005243}, {1.000000000, 0.000005249}, {1.000000000, 0.000005255}, {1.000000000, 0.000005261},
    {1.000000000, 0.000005267}, {1.000000000, 0.000005272}, {1.000000000, 0.000005278}, {1.000000000, 0.000005284},
    {1.000000000, 0.000005290}, {1.000000000, 0.000005296}, {1.000000000, 0.000005302}, {1.000000000, 0.000005307},
    {1.000000000, 0.000005313}, {1.000000000, 0.000005319}, {1.000000000, 0.000005325}, {1.000000000, 0.000005331},
    {1.000000000, 0.000005337}, {1.000000000, 0.000005343}, {1.000000000, 0.000005348}, {1.000000000, 0.000005354},
    {1.000000000, 0.000005360}, {1.000000000, 0.000005366}, {1.000000000, 0.000005372}, {1.000000000, 0.000005378},
    {1.000000000, 0.000005384}, {1.000000000, 0.000005389}, {1.000000000, 0.000005395}, {1.000000000, 0.000005401},
    {1.000000000, 0.000005407}, {1.000000000, 0.000005413}, {1.000000000, 0.000005419}, {1.000000000, 0.000005425},
    {1.000000000, 0.000005430}, {1.000000000, 0.000005436}, {1.000000000, 0.000005442}, {1.000000000, 0.000005448},
    {1.000000000, 0.000005454}, {1.000000000, 0.000005460}, {1.000000000, 0.000005465}, {1.000000000, 0.000005471},
    {1.000000000, 0.000005477}, {1.000000000, 0.000005483}, {1.000000000, 0.000005489}, {1.000000000, 0.000005495},
    {1.000000000, 0.000005501}, {1.000000000, 0.000005506}, {1.000000000, 0.000005512}, {1.000000000, 0.000005518},
    {1.000000000, 0.000005524}, {1.000000000, 0.000005530}, {1.000000000, 0.000005536}, {1.000000000, 0.000005542},
    {1.000000000, 0.000005547}, {1.000000000, 0.000005553}, {1.000000000, 0.000005559}, {1.000000000, 0.000005565},
    {1.000000000, 0.000005571}, {1.000000000, 0.000005577}, {1.000000000, 0.000005582}, {1.000000000, 0.000005588},
    {1.000000000, 0.000005594}, {1.000000000, 0.000005600}, {1.000000000, 0.000005606}, {1.000000000, 0.000005612},
    {1.000000000, 0.000005618}, {1.000000000, 0.000005623}, {1.000000000, 0.000005629}, {1.000000000, 0.000005635},
    {1.000000000, 0.000005641}, {1.000000000, 0.000005647}, {1.000000000, 0.000005653}, {1.000000000, 0.000005659},
    {1.000000000, 0.000005664}, {1.000000000, 0.000005670}, {1.000000000, 0.000005676}, {1.000000000, 0.000005682},
    {1.000000000, 0.000005688}, {1.000000000, 0.000005694}, {1.000000000, 0.000005700}, {1.000000000, 0.000005705},
    {1.000000000, 0.000005711}, {1.000000000, 0.000005717}, {1.000000000, 0.000005723}, {1.000000000, 0.000005729},
    {1.000000000, 0.000005735}, {1.000000000, 0.000005740}, {1.000000000, 0.000005746}, {1.000000000, 0.000005752},
    {1.000000000, 0.000005758}, {1.000000000, 0.000005764}, {1.000000000, 0.000005770}, {1.000000000, 0.000005776},
    {1.000000000, 0.000005781}, {1.000000000, 0.000005787}, {1.000000000, 0.000005793}, {1.000000000, 0.000005799},
    {1.000000000, 0.000005805}, {1.000000000, 0.000005811}, {1.000000000, 0.000005817}, {1.000000000, 0.000005822},
    {1.000000000, 0.000005828}, {1.000000000, 0.000005834}, {1.000000000, 0.000005840}, {1.000000000, 0.000005846},
    {1.000000000, 0.000005852}, {1.000000000, 0.000005858}, {1.000000000, 0.000005863}, {1.000000000, 0.000005869},
    {1.000000000, 0.000005875}, {1.000000000, 0.000005881}, {1.000000000, 0.000005887}, {1.000000000, 0.000005893},
    {1.000000000, 0.000005898}, {1.000000000, 0.000005904}, {1.000000000, 0.000005910}, {1.000000000, 0.000005916},
    {1.000000000, 0.000005922}, {1.000000000, 0.000005928}, {1.000000000, 0.000005934}, {1.000000000, 0.000005939},
    {1.000000000, 0.000005945}, {1.000000000, 0.000005951}, {1.000000000, 0.000005957}, {1.000000000, 0.000005963},
    {1.000000000, 0.000005969}, {1.000000000, 0.000005975}, {1.000000000, 0.000005980}, {1.000000000, 0.000005986}};
#endif