/*
 * Copyright (C) 2019-2022, Xilinx, Inc.
 * Copyright (C) 2022-2025, Advanced Micro Devices, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef __FFT_R4_TWIDDLE_LUT_DIT_H__
#define __FFT_R4_TWIDDLE_LUT_DIT_H__

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_r4_1_2[8] = {{32766, 0}, {-32768, 0}, {0, 0}, {0, 0},
                                                               {0, 0},     {0, 0},      {0, 0}, {0, 0}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_r4_2_4[8] = {{32766, 0}, {-23170, -23170}, {0, 0}, {0, 0},
                                                               {0, 0},     {0, 0},           {0, 0}, {0, 0}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_r4_4_8[8] = {
    {32766, 0}, {12540, -30274}, {-23170, -23170}, {-30273, 12539}, {0, 0}, {0, 0}, {0, 0}, {0, 0}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_r4_8_16[8] = {{32766, 0},      {27245, -18206},  {12540, -30274},
                                                                {-6393, -32140}, {-23170, -23170}, {-32139, -6393},
                                                                {-30273, 12539}, {-18205, 27245}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_r4_16_32[16] = {
    {32766, 0},      {31356, -9513},   {27245, -18206},  {20788, -25331},  {12540, -30274}, {3212, -32611},
    {-6393, -32140}, {-15446, -28899}, {-23170, -23170}, {-28899, -15447}, {-32139, -6393}, {-32611, 3211},
    {-30273, 12539}, {-25330, 20788},  {-18205, 27245},  {-9512, 31356}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_r4_32_64[32] = {
    {32766, 0},       {32414, -4809},   {31356, -9513},   {29622, -14010},  {27245, -18206},  {24280, -22006},
    {20788, -25331},  {16847, -28107},  {12540, -30274},  {7962, -31787},   {3212, -32611},   {-1608, -32729},
    {-6393, -32140},  {-11039, -30853}, {-15446, -28899}, {-19520, -26320}, {-23170, -23170}, {-26319, -19521},
    {-28899, -15447}, {-30853, -11040}, {-32139, -6393},  {-32729, -1608},  {-32611, 3211},   {-31786, 7962},
    {-30273, 12539},  {-28106, 16846},  {-25330, 20788},  {-22006, 24279},  {-18205, 27245},  {-14010, 29621},
    {-9512, 31356},   {-4808, 32413}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_r4_64_128[64] = {
    {32766, 0},       {32680, -2411},   {32414, -4809},   {31971, -7180},   {31356, -9513},   {30573, -11794},
    {29622, -14010},  {28512, -16152},  {27245, -18206},  {25833, -20161},  {24280, -22006},  {22595, -23733},
    {20788, -25331},  {18868, -26792},  {16847, -28107},  {14732, -29270},  {12540, -30274},  {10279, -31115},
    {7962, -31787},   {5602, -32287},   {3212, -32611},   {804, -32758},    {-1608, -32729},  {-4012, -32522},
    {-6393, -32140},  {-8740, -31582},  {-11039, -30853}, {-13279, -29958}, {-15446, -28899}, {-17530, -27684},
    {-19520, -26320}, {-21404, -24813}, {-23170, -23170}, {-24813, -21404}, {-26319, -19521}, {-27684, -17531},
    {-28899, -15447}, {-29957, -13279}, {-30853, -11040}, {-31582, -8740},  {-32139, -6393},  {-32522, -4012},
    {-32729, -1608},  {-32758, 804},    {-32611, 3211},   {-32286, 5601},   {-31786, 7962},   {-31114, 10279},
    {-30273, 12539},  {-29269, 14732},  {-28106, 16846},  {-26791, 18868},  {-25330, 20788},  {-23732, 22594},
    {-22006, 24279},  {-20160, 25832},  {-18205, 27245},  {-16151, 28511},  {-14010, 29621},  {-11793, 30572},
    {-9512, 31356},   {-7180, 31971},   {-4808, 32413},   {-2411, 32679}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_r4_128_256[128] = {
    {32766, 0},       {32746, -1206},   {32680, -2411},   {32568, -3613},   {32414, -4809},   {32215, -5998},
    {31971, -7180},   {31686, -8351},   {31356, -9513},   {30985, -10661},  {30573, -11794},  {30118, -12911},
    {29622, -14010},  {29086, -15091},  {28512, -16152},  {27896, -17190},  {27245, -18206},  {26558, -19197},
    {25833, -20161},  {25073, -21097},  {24280, -22006},  {23453, -22884},  {22595, -23733},  {21705, -24549},
    {20788, -25331},  {19842, -26078},  {18868, -26792},  {17870, -27468},  {16847, -28107},  {15800, -28708},
    {14732, -29270},  {13645, -29792},  {12540, -30274},  {11418, -30715},  {10279, -31115},  {9126, -31472},
    {7962, -31787},   {6786, -32059},   {5602, -32287},   {4410, -32471},   {3212, -32611},   {2010, -32707},
    {804, -32758},    {-402, -32766},   {-1608, -32729},  {-2812, -32648},  {-4012, -32522},  {-5205, -32353},
    {-6393, -32140},  {-7571, -31881},  {-8740, -31582},  {-9895, -31238},  {-11039, -30853}, {-12167, -30426},
    {-13279, -29958}, {-14372, -29448}, {-15446, -28899}, {-16500, -28311}, {-17530, -27684}, {-18538, -27021},
    {-19520, -26320}, {-20475, -25584}, {-21404, -24813}, {-22302, -24008}, {-23170, -23170}, {-24007, -22302},
    {-24813, -21404}, {-25584, -20475}, {-26319, -19521}, {-27021, -18539}, {-27684, -17531}, {-28311, -16501},
    {-28899, -15447}, {-29448, -14372}, {-29957, -13279}, {-30425, -12167}, {-30853, -11040}, {-31238, -9896},
    {-31582, -8740},  {-31881, -7572},  {-32139, -6393},  {-32352, -5206},  {-32522, -4012},  {-32647, -2812},
    {-32729, -1608},  {-32766, -403},   {-32758, 804},    {-32706, 2009},   {-32611, 3211},   {-32470, 4409},
    {-32286, 5601},   {-32058, 6786},   {-31786, 7962},   {-31472, 9126},   {-31114, 10279},  {-30715, 11417},
    {-30273, 12539},  {-29791, 13645},  {-29269, 14732},  {-28707, 15800},  {-28106, 16846},  {-27468, 17869},
    {-26791, 18868},  {-26078, 19841},  {-25330, 20788},  {-24548, 21705},  {-23732, 22594},  {-22884, 23453},
    {-22006, 24279},  {-21097, 25072},  {-20160, 25832},  {-19196, 26557},  {-18205, 27245},  {-17190, 27896},
    {-16151, 28511},  {-15091, 29086},  {-14010, 29621},  {-12911, 30117},  {-11793, 30572},  {-10660, 30985},
    {-9512, 31356},   {-8351, 31686},   {-7180, 31971},   {-5997, 32214},   {-4808, 32413},   {-3612, 32568},
    {-2411, 32679},   {-1206, 32746}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_r4_256_512[256] = {
    {32766, 0},       {32763, -603},    {32746, -1206},   {32718, -1809},   {32680, -2411},   {32629, -3012},
    {32568, -3613},   {32496, -4211},   {32414, -4809},   {32319, -5405},   {32215, -5998},   {32098, -6590},
    {31971, -7180},   {31835, -7767},   {31686, -8351},   {31526, -8934},   {31356, -9513},   {31177, -10089},
    {30985, -10661},  {30784, -11229},  {30573, -11794},  {30350, -12354},  {30118, -12911},  {29874, -13463},
    {29622, -14010},  {29359, -14553},  {29086, -15091},  {28803, -15625},  {28512, -16152},  {28210, -16674},
    {27896, -17190},  {27576, -17700},  {27245, -18206},  {26907, -18704},  {26558, -19197},  {26199, -19682},
    {25833, -20161},  {25457, -20633},  {25073, -21097},  {24680, -21556},  {24280, -22006},  {23871, -22449},
    {23453, -22884},  {23028, -23313},  {22595, -23733},  {22154, -24145},  {21705, -24549},  {21251, -24943},
    {20788, -25331},  {20318, -25709},  {19842, -26078},  {19358, -26439},  {18868, -26792},  {18372, -27133},
    {17870, -27468},  {17361, -27792},  {16847, -28107},  {16326, -28411},  {15800, -28708},  {15269, -28993},
    {14732, -29270},  {14192, -29536},  {13645, -29792},  {13095, -30038},  {12540, -30274},  {11980, -30499},
    {11418, -30715},  {10850, -30921},  {10279, -31115},  {9704, -31299},   {9126, -31472},   {8546, -31634},
    {7962, -31787},   {7375, -31927},   {6786, -32059},   {6195, -32177},   {5602, -32287},   {5007, -32383},
    {4410, -32471},   {3812, -32546},   {3212, -32611},   {2610, -32664},   {2010, -32707},   {1408, -32739},
    {804, -32758},    {201, -32768},    {-402, -32766},   {-1005, -32753},  {-1608, -32729},  {-2210, -32694},
    {-2812, -32648},  {-3412, -32591},  {-4012, -32522},  {-4609, -32443},  {-5205, -32353},  {-5800, -32251},
    {-6393, -32140},  {-6984, -32015},  {-7571, -31881},  {-8157, -31737},  {-8740, -31582},  {-9319, -31415},
    {-9895, -31238},  {-10470, -31051}, {-11039, -30853}, {-11605, -30644}, {-12167, -30426}, {-12726, -30197},
    {-13279, -29958}, {-13828, -29707}, {-14372, -29448}, {-14912, -29179}, {-15446, -28899}, {-15976, -28610},
    {-16500, -28311}, {-17019, -28002}, {-17530, -27684}, {-18037, -27357}, {-18538, -27021}, {-19031, -26675},
    {-19520, -26320}, {-20001, -25956}, {-20475, -25584}, {-20943, -25202}, {-21404, -24813}, {-21856, -24415},
    {-22302, -24008}, {-22741, -23594}, {-23170, -23170}, {-23593, -22741}, {-24007, -22302}, {-24414, -21857},
    {-24813, -21404}, {-25201, -20944}, {-25584, -20475}, {-25955, -20002}, {-26319, -19521}, {-26674, -19032},
    {-27021, -18539}, {-27356, -18038}, {-27684, -17531}, {-28002, -17020}, {-28311, -16501}, {-28609, -15976},
    {-28899, -15447}, {-29179, -14913}, {-29448, -14372}, {-29707, -13829}, {-29957, -13279}, {-30196, -12726},
    {-30425, -12167}, {-30644, -11605}, {-30853, -11040}, {-31051, -10470}, {-31238, -9896},  {-31415, -9320},
    {-31582, -8740},  {-31737, -8157},  {-31881, -7572},  {-32015, -6984},  {-32139, -6393},  {-32251, -5801},
    {-32352, -5206},  {-32443, -4609},  {-32522, -4012},  {-32590, -3413},  {-32647, -2812},  {-32693, -2210},
    {-32729, -1608},  {-32752, -1005},  {-32766, -403},   {-32767, 200},    {-32758, 804},    {-32738, 1407},
    {-32706, 2009},   {-32663, 2610},   {-32611, 3211},   {-32545, 3811},   {-32470, 4409},   {-32383, 5006},
    {-32286, 5601},   {-32177, 6195},   {-32058, 6786},   {-31927, 7374},   {-31786, 7962},   {-31634, 8545},
    {-31472, 9126},   {-31299, 9703},   {-31114, 10279},  {-30920, 10849},  {-30715, 11417},  {-30499, 11980},
    {-30273, 12539},  {-30037, 13094},  {-29791, 13645},  {-29535, 14191},  {-29269, 14732},  {-28993, 15269},
    {-28707, 15800},  {-28411, 16325},  {-28106, 16846},  {-27791, 17360},  {-27468, 17869},  {-27132, 18371},
    {-26791, 18868},  {-26439, 19358},  {-26078, 19841},  {-25708, 20317},  {-25330, 20788},  {-24943, 21251},
    {-24548, 21705},  {-24144, 22154},  {-23732, 22594},  {-23313, 23027},  {-22884, 23453},  {-22449, 23870},
    {-22006, 24279},  {-21555, 24679},  {-21097, 25072},  {-20633, 25456},  {-20160, 25832},  {-19681, 26199},
    {-19196, 26557},  {-18703, 26906},  {-18205, 27245},  {-17700, 27576},  {-17190, 27896},  {-16673, 28209},
    {-16151, 28511},  {-15624, 28803},  {-15091, 29086},  {-14553, 29358},  {-14010, 29621},  {-13463, 29874},
    {-12911, 30117},  {-12354, 30349},  {-11793, 30572},  {-11229, 30784},  {-10660, 30985},  {-10088, 31177},
    {-9512, 31356},   {-8934, 31526},   {-8351, 31686},   {-7766, 31834},   {-7180, 31971},   {-6590, 32098},
    {-5997, 32214},   {-5404, 32318},   {-4808, 32413},   {-4210, 32496},   {-3612, 32568},   {-3011, 32629},
    {-2411, 32679},   {-1808, 32717},   {-1206, 32746},   {-603, 32762}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_r4_512_1024[512] = {
    {32766, 0},       {32765, -302},    {32763, -603},    {32755, -905},    {32746, -1206},   {32734, -1508},
    {32718, -1809},   {32700, -2111},   {32680, -2411},   {32656, -2712},   {32629, -3012},   {32599, -3313},
    {32568, -3613},   {32534, -3912},   {32496, -4211},   {32456, -4510},   {32414, -4809},   {32367, -5107},
    {32319, -5405},   {32268, -5702},   {32215, -5998},   {32157, -6295},   {32098, -6590},   {32036, -6885},
    {31971, -7180},   {31904, -7474},   {31835, -7767},   {31761, -8060},   {31686, -8351},   {31608, -8644},
    {31526, -8934},   {31443, -9223},   {31356, -9513},   {31268, -9801},   {31177, -10089},  {31082, -10375},
    {30985, -10661},  {30886, -10946},  {30784, -11229},  {30680, -11512},  {30573, -11794},  {30463, -12075},
    {30350, -12354},  {30235, -12633},  {30118, -12911},  {29997, -13188},  {29874, -13463},  {29750, -13737},
    {29622, -14010},  {29491, -14282},  {29359, -14553},  {29224, -14823},  {29086, -15091},  {28946, -15358},
    {28803, -15625},  {28659, -15889},  {28512, -16152},  {28361, -16413},  {28210, -16674},  {28055, -16933},
    {27896, -17190},  {27738, -17446},  {27576, -17700},  {27412, -17954},  {27245, -18206},  {27077, -18455},
    {26907, -18704},  {26733, -18951},  {26558, -19197},  {26380, -19440},  {26199, -19682},  {26017, -19921},
    {25833, -20161},  {25646, -20398},  {25457, -20633},  {25266, -20865},  {25073, -21097},  {24878, -21327},
    {24680, -21556},  {24481, -21781},  {24280, -22006},  {24075, -22228},  {23871, -22449},  {23663, -22668},
    {23453, -22884},  {23241, -23100},  {23028, -23313},  {22813, -23524},  {22595, -23733},  {22376, -23939},
    {22154, -24145},  {21931, -24348},  {21705, -24549},  {21479, -24746},  {21251, -24943},  {21020, -25138},
    {20788, -25331},  {20554, -25521},  {20318, -25709},  {20081, -25894},  {19842, -26078},  {19600, -26260},
    {19358, -26439},  {19115, -26616},  {18868, -26792},  {18620, -26963},  {18372, -27133},  {18121, -27302},
    {17870, -27468},  {17615, -27631},  {17361, -27792},  {17104, -27951},  {16847, -28107},  {16587, -28261},
    {16326, -28411},  {16064, -28562},  {15800, -28708},  {15535, -28852},  {15269, -28993},  {15002, -29132},
    {14732, -29270},  {14463, -29404},  {14192, -29536},  {13918, -29665},  {13645, -29792},  {13371, -29917},
    {13095, -30038},  {12817, -30158},  {12540, -30274},  {12260, -30388},  {11980, -30499},  {11699, -30609},
    {11418, -30715},  {11134, -30819},  {10850, -30921},  {10564, -31018},  {10279, -31115},  {9992, -31208},
    {9704, -31299},   {9416, -31386},   {9126, -31472},   {8837, -31555},   {8546, -31634},   {8255, -31712},
    {7962, -31787},   {7669, -31859},   {7375, -31927},   {7082, -31994},   {6786, -32059},   {6491, -32120},
    {6195, -32177},   {5899, -32233},   {5602, -32287},   {5304, -32337},   {5007, -32383},   {4708, -32428},
    {4410, -32471},   {4111, -32510},   {3812, -32546},   {3512, -32580},   {3212, -32611},   {2911, -32638},
    {2610, -32664},   {2310, -32686},   {2010, -32707},   {1709, -32723},   {1408, -32739},   {1105, -32749},
    {804, -32758},    {502, -32764},    {201, -32768},    {-100, -32768},   {-402, -32766},   {-704, -32762},
    {-1005, -32753},  {-1306, -32743},  {-1608, -32729},  {-1909, -32712},  {-2210, -32694},  {-2511, -32672},
    {-2812, -32648},  {-3112, -32620},  {-3412, -32591},  {-3711, -32558},  {-4012, -32522},  {-4311, -32483},
    {-4609, -32443},  {-4907, -32400},  {-5205, -32353},  {-5503, -32303},  {-5800, -32251},  {-6097, -32196},
    {-6393, -32140},  {-6687, -32079},  {-6984, -32015},  {-7278, -31950},  {-7571, -31881},  {-7865, -31811},
    {-8157, -31737},  {-8449, -31660},  {-8740, -31582},  {-9030, -31500},  {-9319, -31415},  {-9608, -31328},
    {-9895, -31238},  {-10183, -31147}, {-10470, -31051}, {-10755, -30953}, {-11039, -30853}, {-11324, -30750},
    {-11605, -30644}, {-11887, -30537}, {-12167, -30426}, {-12446, -30313}, {-12726, -30197}, {-13003, -30079},
    {-13279, -29958}, {-13554, -29834}, {-13828, -29707}, {-14101, -29580}, {-14372, -29448}, {-14643, -29314},
    {-14912, -29179}, {-15180, -29041}, {-15446, -28899}, {-15712, -28755}, {-15976, -28610}, {-16239, -28462},
    {-16500, -28311}, {-16760, -28158}, {-17019, -28002}, {-17275, -27845}, {-17530, -27684}, {-17785, -27521},
    {-18037, -27357}, {-18288, -27190}, {-18538, -27021}, {-18785, -26849}, {-19031, -26675}, {-19277, -26499},
    {-19520, -26320}, {-19761, -26139}, {-20001, -25956}, {-20239, -25771}, {-20475, -25584}, {-20709, -25394},
    {-20943, -25202}, {-21174, -25009}, {-21404, -24813}, {-21631, -24615}, {-21856, -24415}, {-22080, -24212},
    {-22302, -24008}, {-22522, -23802}, {-22741, -23594}, {-22956, -23382}, {-23170, -23170}, {-23382, -22956},
    {-23593, -22741}, {-23801, -22522}, {-24007, -22302}, {-24212, -22081}, {-24414, -21857}, {-24615, -21632},
    {-24813, -21404}, {-25008, -21174}, {-25201, -20944}, {-25393, -20710}, {-25584, -20475}, {-25771, -20240},
    {-25955, -20002}, {-26139, -19761}, {-26319, -19521}, {-26498, -19277}, {-26674, -19032}, {-26849, -18786},
    {-27021, -18539}, {-27189, -18289}, {-27356, -18038}, {-27521, -17785}, {-27684, -17531}, {-27844, -17276},
    {-28002, -17020}, {-28157, -16760}, {-28311, -16501}, {-28462, -16239}, {-28609, -15976}, {-28755, -15712},
    {-28899, -15447}, {-29041, -15181}, {-29179, -14913}, {-29314, -14644}, {-29448, -14372}, {-29579, -14101},
    {-29707, -13829}, {-29834, -13554}, {-29957, -13279}, {-30078, -13004}, {-30196, -12726}, {-30312, -12447},
    {-30425, -12167}, {-30536, -11887}, {-30644, -11605}, {-30749, -11324}, {-30853, -11040}, {-30952, -10756},
    {-31051, -10470}, {-31146, -10184}, {-31238, -9896},  {-31327, -9609},  {-31415, -9320},  {-31500, -9030},
    {-31582, -8740},  {-31659, -8450},  {-31737, -8157},  {-31810, -7865},  {-31881, -7572},  {-31949, -7278},
    {-32015, -6984},  {-32078, -6688},  {-32139, -6393},  {-32195, -6097},  {-32251, -5801},  {-32303, -5503},
    {-32352, -5206},  {-32399, -4908},  {-32443, -4609},  {-32483, -4311},  {-32522, -4012},  {-32557, -3712},
    {-32590, -3413},  {-32619, -3112},  {-32647, -2812},  {-32672, -2511},  {-32693, -2210},  {-32712, -1909},
    {-32729, -1608},  {-32742, -1307},  {-32752, -1005},  {-32761, -705},   {-32766, -403},   {-32767, -101},
    {-32767, 200},    {-32764, 501},    {-32758, 804},    {-32749, 1105},   {-32738, 1407},   {-32723, 1708},
    {-32706, 2009},   {-32686, 2309},   {-32663, 2610},   {-32638, 2911},   {-32611, 3211},   {-32579, 3512},
    {-32545, 3811},   {-32509, 4110},   {-32470, 4409},   {-32428, 4708},   {-32383, 5006},   {-32336, 5304},
    {-32286, 5601},   {-32232, 5898},   {-32177, 6195},   {-32119, 6491},   {-32058, 6786},   {-31993, 7081},
    {-31927, 7374},   {-31858, 7669},   {-31786, 7962},   {-31712, 8254},   {-31634, 8545},   {-31555, 8837},
    {-31472, 9126},   {-31385, 9415},   {-31299, 9703},   {-31207, 9991},   {-31114, 10279},  {-31018, 10564},
    {-30920, 10849},  {-30819, 11134},  {-30715, 11417},  {-30608, 11699},  {-30499, 11980},  {-30388, 12260},
    {-30273, 12539},  {-30157, 12817},  {-30037, 13094},  {-29916, 13370},  {-29791, 13645},  {-29665, 13918},
    {-29535, 14191},  {-29404, 14462},  {-29269, 14732},  {-29132, 15001},  {-28993, 15269},  {-28851, 15535},
    {-28707, 15800},  {-28561, 16063},  {-28411, 16325},  {-28261, 16586},  {-28106, 16846},  {-27950, 17103},
    {-27791, 17360},  {-27630, 17615},  {-27468, 17869},  {-27302, 18121},  {-27132, 18371},  {-26963, 18620},
    {-26791, 18868},  {-26616, 19114},  {-26439, 19358},  {-26259, 19599},  {-26078, 19841},  {-25894, 20080},
    {-25708, 20317},  {-25520, 20553},  {-25330, 20788},  {-25137, 21020},  {-24943, 21251},  {-24746, 21479},
    {-24548, 21705},  {-24347, 21930},  {-24144, 22154},  {-23938, 22375},  {-23732, 22594},  {-23523, 22812},
    {-23313, 23027},  {-23100, 23240},  {-22884, 23453},  {-22667, 23662},  {-22449, 23870},  {-22228, 24075},
    {-22006, 24279},  {-21781, 24480},  {-21555, 24679},  {-21327, 24877},  {-21097, 25072},  {-20865, 25265},
    {-20633, 25456},  {-20398, 25645},  {-20160, 25832},  {-19921, 26017},  {-19681, 26199},  {-19440, 26379},
    {-19196, 26557},  {-18950, 26732},  {-18703, 26906},  {-18454, 27077},  {-18205, 27245},  {-17954, 27412},
    {-17700, 27576},  {-17446, 27737},  {-17190, 27896},  {-16932, 28054},  {-16673, 28209},  {-16412, 28360},
    {-16151, 28511},  {-15889, 28659},  {-15624, 28803},  {-15358, 28945},  {-15091, 29086},  {-14823, 29224},
    {-14553, 29358},  {-14281, 29491},  {-14010, 29621},  {-13737, 29749},  {-13463, 29874},  {-13187, 29997},
    {-12911, 30117},  {-12633, 30234},  {-12354, 30349},  {-12074, 30462},  {-11793, 30572},  {-11511, 30679},
    {-11229, 30784},  {-10945, 30885},  {-10660, 30985},  {-10374, 31081},  {-10088, 31177},  {-9801, 31268},
    {-9512, 31356},   {-9223, 31443},   {-8934, 31526},   {-8643, 31607},   {-8351, 31686},   {-8059, 31761},
    {-7766, 31834},   {-7474, 31904},   {-7180, 31971},   {-6884, 32035},   {-6590, 32098},   {-6295, 32157},
    {-5997, 32214},   {-5702, 32268},   {-5404, 32318},   {-5106, 32367},   {-4808, 32413},   {-4509, 32455},
    {-4210, 32496},   {-3912, 32533},   {-3612, 32568},   {-3312, 32599},   {-3011, 32629},   {-2712, 32656},
    {-2411, 32679},   {-2110, 32699},   {-1808, 32717},   {-1508, 32733},   {-1206, 32746},   {-905, 32755},
    {-603, 32762},    {-302, 32766}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_r4_1024_2048[1024] = {
    {32766, 0},       {32766, -151},    {32765, -302},    {32765, -453},    {32763, -603},    {32759, -754},
    {32755, -905},    {32750, -1056},   {32746, -1206},   {32741, -1357},   {32734, -1508},   {32725, -1659},
    {32718, -1809},   {32709, -1960},   {32700, -2111},   {32689, -2260},   {32680, -2411},   {32668, -2561},
    {32656, -2712},   {32642, -2862},   {32629, -3012},   {32615, -3162},   {32599, -3313},   {32585, -3462},
    {32568, -3613},   {32552, -3762},   {32534, -3912},   {32516, -4062},   {32496, -4211},   {32477, -4361},
    {32456, -4510},   {32435, -4660},   {32414, -4809},   {32391, -4958},   {32367, -5107},   {32344, -5255},
    {32319, -5405},   {32294, -5554},   {32268, -5702},   {32242, -5849},   {32215, -5998},   {32186, -6147},
    {32157, -6295},   {32129, -6442},   {32098, -6590},   {32068, -6738},   {32036, -6885},   {32005, -7033},
    {31971, -7180},   {31938, -7327},   {31904, -7474},   {31870, -7621},   {31835, -7767},   {31799, -7914},
    {31761, -8060},   {31724, -8206},   {31686, -8351},   {31647, -8497},   {31608, -8644},   {31568, -8789},
    {31526, -8934},   {31486, -9079},   {31443, -9223},   {31400, -9368},   {31356, -9513},   {31313, -9657},
    {31268, -9801},   {31222, -9944},   {31177, -10089},  {31131, -10232},  {31082, -10375},  {31035, -10517},
    {30985, -10661},  {30937, -10804},  {30886, -10946},  {30835, -11087},  {30784, -11229},  {30733, -11370},
    {30680, -11512},  {30626, -11652},  {30573, -11794},  {30517, -11933},  {30463, -12075},  {30406, -12215},
    {30350, -12354},  {30293, -12494},  {30235, -12633},  {30177, -12772},  {30118, -12911},  {30058, -13049},
    {29997, -13188},  {29936, -13325},  {29874, -13463},  {29812, -13600},  {29750, -13737},  {29686, -13874},
    {29622, -14010},  {29557, -14147},  {29491, -14282},  {29426, -14418},  {29359, -14553},  {29292, -14689},
    {29224, -14823},  {29156, -14957},  {29086, -15091},  {29016, -15225},  {28946, -15358},  {28875, -15492},
    {28803, -15625},  {28732, -15756},  {28659, -15889},  {28584, -16021},  {28512, -16152},  {28437, -16283},
    {28361, -16413},  {28285, -16544},  {28210, -16674},  {28132, -16804},  {28055, -16933},  {27976, -17061},
    {27896, -17190},  {27818, -17318},  {27738, -17446},  {27656, -17574},  {27576, -17700},  {27494, -17828},
    {27412, -17954},  {27329, -18080},  {27245, -18206},  {27162, -18331},  {27077, -18455},  {26992, -18581},
    {26907, -18704},  {26819, -18828},  {26733, -18951},  {26645, -19073},  {26558, -19197},  {26468, -19318},
    {26380, -19440},  {26289, -19561},  {26199, -19682},  {26109, -19802},  {26017, -19921},  {25926, -20041},
    {25833, -20161},  {25740, -20280},  {25646, -20398},  {25551, -20515},  {25457, -20633},  {25362, -20750},
    {25266, -20865},  {25170, -20982},  {25073, -21097},  {24976, -21213},  {24878, -21327},  {24779, -21442},
    {24680, -21556},  {24581, -21669},  {24481, -21781},  {24380, -21894},  {24280, -22006},  {24178, -22118},
    {24075, -22228},  {23973, -22339},  {23871, -22449},  {23766, -22559},  {23663, -22668},  {23558, -22777},
    {23453, -22884},  {23347, -22993},  {23241, -23100},  {23135, -23206},  {23028, -23313},  {22921, -23419},
    {22813, -23524},  {22704, -23628},  {22595, -23733},  {22486, -23836},  {22376, -23939},  {22265, -24042},
    {22154, -24145},  {22042, -24246},  {21931, -24348},  {21819, -24448},  {21705, -24549},  {21592, -24648},
    {21479, -24746},  {21365, -24846},  {21251, -24943},  {21135, -25041},  {21020, -25138},  {20904, -25235},
    {20788, -25331},  {20671, -25425},  {20554, -25521},  {20436, -25615},  {20318, -25709},  {20199, -25802},
    {20081, -25894},  {19961, -25987},  {19842, -26078},  {19722, -26170},  {19600, -26260},  {19479, -26350},
    {19358, -26439},  {19236, -26528},  {19115, -26616},  {18991, -26704},  {18868, -26792},  {18744, -26877},
    {18620, -26963},  {18497, -27049},  {18372, -27133},  {18247, -27218},  {18121, -27302},  {17995, -27385},
    {17870, -27468},  {17743, -27549},  {17615, -27631},  {17488, -27711},  {17361, -27792},  {17232, -27871},
    {17104, -27951},  {16975, -28029},  {16847, -28107},  {16717, -28184},  {16587, -28261},  {16457, -28336},
    {16326, -28411},  {16195, -28487},  {16064, -28562},  {15932, -28635},  {15800, -28708},  {15668, -28779},
    {15535, -28852},  {15402, -28923},  {15269, -28993},  {15136, -29063},  {15002, -29132},  {14867, -29201},
    {14732, -29270},  {14598, -29337},  {14463, -29404},  {14327, -29471},  {14192, -29536},  {14056, -29600},
    {13918, -29665},  {13782, -29729},  {13645, -29792},  {13509, -29855},  {13371, -29917},  {13233, -29977},
    {13095, -30038},  {12957, -30098},  {12817, -30158},  {12679, -30216},  {12540, -30274},  {12400, -30331},
    {12260, -30388},  {12121, -30445},  {11980, -30499},  {11840, -30555},  {11699, -30609},  {11558, -30663},
    {11418, -30715},  {11276, -30768},  {11134, -30819},  {10991, -30870},  {10850, -30921},  {10707, -30970},
    {10564, -31018},  {10422, -31067},  {10279, -31115},  {10135, -31161},  {9992, -31208},   {9847, -31253},
    {9704, -31299},   {9561, -31343},   {9416, -31386},   {9271, -31430},   {9126, -31472},   {8982, -31514},
    {8837, -31555},   {8691, -31595},   {8546, -31634},   {8400, -31674},   {8255, -31712},   {8107, -31749},
    {7962, -31787},   {7815, -31823},   {7669, -31859},   {7523, -31893},   {7375, -31927},   {7229, -31962},
    {7082, -31994},   {6934, -32027},   {6786, -32059},   {6640, -32089},   {6491, -32120},   {6343, -32148},
    {6195, -32177},   {6047, -32206},   {5899, -32233},   {5751, -32260},   {5602, -32287},   {5454, -32312},
    {5304, -32337},   {5156, -32360},   {5007, -32383},   {4858, -32406},   {4708, -32428},   {4559, -32450},
    {4410, -32471},   {4260, -32490},   {4111, -32510},   {3961, -32528},   {3812, -32546},   {3662, -32564},
    {3512, -32580},   {3361, -32595},   {3212, -32611},   {3062, -32625},   {2911, -32638},   {2760, -32652},
    {2610, -32664},   {2460, -32676},   {2310, -32686},   {2160, -32697},   {2010, -32707},   {1859, -32716},
    {1709, -32723},   {1558, -32731},   {1408, -32739},   {1256, -32745},   {1105, -32749},   {955, -32755},
    {804, -32758},    {653, -32762},    {502, -32764},    {352, -32766},    {201, -32768},    {51, -32768},
    {-100, -32768},   {-250, -32767},   {-402, -32766},   {-552, -32763},   {-704, -32762},   {-855, -32756},
    {-1005, -32753},  {-1156, -32748},  {-1306, -32743},  {-1457, -32736},  {-1608, -32729},  {-1758, -32721},
    {-1909, -32712},  {-2060, -32704},  {-2210, -32694},  {-2360, -32683},  {-2511, -32672},  {-2661, -32661},
    {-2812, -32648},  {-2962, -32635},  {-3112, -32620},  {-3262, -32606},  {-3412, -32591},  {-3562, -32575},
    {-3711, -32558},  {-3861, -32540},  {-4012, -32522},  {-4161, -32503},  {-4311, -32483},  {-4460, -32464},
    {-4609, -32443},  {-4759, -32421},  {-4907, -32400},  {-5056, -32376},  {-5205, -32353},  {-5354, -32328},
    {-5503, -32303},  {-5651, -32277},  {-5800, -32251},  {-5948, -32224},  {-6097, -32196},  {-6244, -32168},
    {-6393, -32140},  {-6541, -32110},  {-6687, -32079},  {-6835, -32048},  {-6984, -32015},  {-7130, -31983},
    {-7278, -31950},  {-7424, -31917},  {-7571, -31881},  {-7717, -31846},  {-7865, -31811},  {-8011, -31775},
    {-8157, -31737},  {-8303, -31700},  {-8449, -31660},  {-8594, -31622},  {-8740, -31582},  {-8884, -31541},
    {-9030, -31500},  {-9174, -31459},  {-9319, -31415},  {-9464, -31372},  {-9608, -31328},  {-9753, -31283},
    {-9895, -31238},  {-10040, -31193}, {-10183, -31147}, {-10326, -31098}, {-10470, -31051}, {-10613, -31002},
    {-10755, -30953}, {-10897, -30903}, {-11039, -30853}, {-11181, -30802}, {-11324, -30750}, {-11464, -30697},
    {-11605, -30644}, {-11746, -30591}, {-11887, -30537}, {-12027, -30481}, {-12167, -30426}, {-12307, -30370},
    {-12446, -30313}, {-12586, -30255}, {-12726, -30197}, {-12864, -30137}, {-13003, -30079}, {-13141, -30017},
    {-13279, -29958}, {-13417, -29896}, {-13554, -29834}, {-13692, -29771}, {-13828, -29707}, {-13964, -29643},
    {-14101, -29580}, {-14237, -29515}, {-14372, -29448}, {-14509, -29382}, {-14643, -29314}, {-14778, -29248},
    {-14912, -29179}, {-15046, -29109}, {-15180, -29041}, {-15314, -28970}, {-15446, -28899}, {-15580, -28828},
    {-15712, -28755}, {-15844, -28684}, {-15976, -28610}, {-16107, -28537}, {-16239, -28462}, {-16370, -28386},
    {-16500, -28311}, {-16631, -28236}, {-16760, -28158}, {-16889, -28081}, {-17019, -28002}, {-17148, -27924},
    {-17275, -27845}, {-17403, -27764}, {-17530, -27684}, {-17658, -27604}, {-17785, -27521}, {-17911, -27440},
    {-18037, -27357}, {-18163, -27273}, {-18288, -27190}, {-18413, -27106}, {-18538, -27021}, {-18663, -26935},
    {-18785, -26849}, {-18909, -26763}, {-19031, -26675}, {-19155, -26586}, {-19277, -26499}, {-19398, -26409},
    {-19520, -26320}, {-19641, -26230}, {-19761, -26139}, {-19881, -26048}, {-20001, -25956}, {-20120, -25864},
    {-20239, -25771}, {-20357, -25678}, {-20475, -25584}, {-20593, -25488}, {-20709, -25394}, {-20826, -25299},
    {-20943, -25202}, {-21058, -25106}, {-21174, -25009}, {-21288, -24911}, {-21404, -24813}, {-21517, -24713},
    {-21631, -24615}, {-21744, -24515}, {-21856, -24415}, {-21968, -24314}, {-22080, -24212}, {-22191, -24111},
    {-22302, -24008}, {-22411, -23905}, {-22522, -23802}, {-22631, -23699}, {-22741, -23594}, {-22849, -23489},
    {-22956, -23382}, {-23063, -23278}, {-23170, -23170}, {-23277, -23064}, {-23382, -22956}, {-23489, -22849},
    {-23593, -22741}, {-23698, -22631}, {-23801, -22522}, {-23905, -22412}, {-24007, -22302}, {-24110, -22191},
    {-24212, -22081}, {-24313, -21968}, {-24414, -21857}, {-24515, -21744}, {-24615, -21632}, {-24712, -21518},
    {-24813, -21404}, {-24910, -21289}, {-25008, -21174}, {-25105, -21058}, {-25201, -20944}, {-25299, -20827},
    {-25393, -20710}, {-25488, -20594}, {-25584, -20475}, {-25678, -20358}, {-25771, -20240}, {-25864, -20121},
    {-25955, -20002}, {-26048, -19881}, {-26139, -19761}, {-26230, -19641}, {-26319, -19521}, {-26409, -19398},
    {-26498, -19277}, {-26586, -19155}, {-26674, -19032}, {-26762, -18910}, {-26849, -18786}, {-26934, -18663},
    {-27021, -18539}, {-27105, -18413}, {-27189, -18289}, {-27273, -18164}, {-27356, -18038}, {-27439, -17911},
    {-27521, -17785}, {-27603, -17658}, {-27684, -17531}, {-27764, -17404}, {-27844, -17276}, {-27923, -17148},
    {-28002, -17020}, {-28081, -16889}, {-28157, -16760}, {-28235, -16631}, {-28311, -16501}, {-28386, -16370},
    {-28462, -16239}, {-28536, -16108}, {-28609, -15976}, {-28683, -15844}, {-28755, -15712}, {-28827, -15581},
    {-28899, -15447}, {-28970, -15315}, {-29041, -15181}, {-29109, -15047}, {-29179, -14913}, {-29247, -14779},
    {-29314, -14644}, {-29382, -14509}, {-29448, -14372}, {-29515, -14237}, {-29579, -14101}, {-29643, -13965},
    {-29707, -13829}, {-29770, -13692}, {-29834, -13554}, {-29895, -13418}, {-29957, -13279}, {-30017, -13141},
    {-30078, -13004}, {-30137, -12865}, {-30196, -12726}, {-30254, -12586}, {-30312, -12447}, {-30370, -12307},
    {-30425, -12167}, {-30480, -12028}, {-30536, -11887}, {-30590, -11746}, {-30644, -11605}, {-30697, -11465},
    {-30749, -11324}, {-30802, -11181}, {-30853, -11040}, {-30903, -10898}, {-30952, -10756}, {-31002, -10613},
    {-31051, -10470}, {-31097, -10326}, {-31146, -10184}, {-31193, -10040}, {-31238, -9896},  {-31282, -9753},
    {-31327, -9609},  {-31371, -9464},  {-31415, -9320},  {-31458, -9175},  {-31500, -9030},  {-31541, -8885},
    {-31582, -8740},  {-31622, -8595},  {-31659, -8450},  {-31699, -8304},  {-31737, -8157},  {-31774, -8011},
    {-31810, -7865},  {-31846, -7718},  {-31881, -7572},  {-31916, -7424},  {-31949, -7278},  {-31982, -7130},
    {-32015, -6984},  {-32048, -6836},  {-32078, -6688},  {-32109, -6541},  {-32139, -6393},  {-32167, -6245},
    {-32195, -6097},  {-32223, -5949},  {-32251, -5801},  {-32277, -5652},  {-32303, -5503},  {-32328, -5354},
    {-32352, -5206},  {-32375, -5057},  {-32399, -4908},  {-32421, -4759},  {-32443, -4609},  {-32463, -4460},
    {-32483, -4311},  {-32503, -4161},  {-32522, -4012},  {-32540, -3862},  {-32557, -3712},  {-32574, -3562},
    {-32590, -3413},  {-32606, -3262},  {-32619, -3112},  {-32634, -2962},  {-32647, -2812},  {-32661, -2661},
    {-32672, -2511},  {-32683, -2360},  {-32693, -2210},  {-32703, -2060},  {-32712, -1909},  {-32720, -1759},
    {-32729, -1608},  {-32735, -1458},  {-32742, -1307},  {-32747, -1157},  {-32752, -1005},  {-32756, -855},
    {-32761, -705},   {-32763, -553},   {-32766, -403},   {-32767, -251},   {-32767, -101},   {-32767, 50},
    {-32767, 200},    {-32766, 352},    {-32764, 501},    {-32762, 653},    {-32758, 804},    {-32754, 954},
    {-32749, 1105},   {-32744, 1256},   {-32738, 1407},   {-32730, 1557},   {-32723, 1708},   {-32716, 1859},
    {-32706, 2009},   {-32696, 2160},   {-32686, 2309},   {-32676, 2460},   {-32663, 2610},   {-32651, 2760},
    {-32638, 2911},   {-32624, 3061},   {-32611, 3211},   {-32595, 3361},   {-32579, 3512},   {-32563, 3661},
    {-32545, 3811},   {-32528, 3961},   {-32509, 4110},   {-32490, 4260},   {-32470, 4409},   {-32449, 4559},
    {-32428, 4708},   {-32406, 4857},   {-32383, 5006},   {-32360, 5156},   {-32336, 5304},   {-32311, 5453},
    {-32286, 5601},   {-32259, 5751},   {-32232, 5898},   {-32206, 6047},   {-32177, 6195},   {-32148, 6342},
    {-32119, 6491},   {-32089, 6639},   {-32058, 6786},   {-32026, 6934},   {-31993, 7081},   {-31961, 7228},
    {-31927, 7374},   {-31892, 7522},   {-31858, 7669},   {-31823, 7814},   {-31786, 7962},   {-31749, 8107},
    {-31712, 8254},   {-31674, 8399},   {-31634, 8545},   {-31595, 8691},   {-31555, 8837},   {-31513, 8981},
    {-31472, 9126},   {-31429, 9271},   {-31385, 9415},   {-31342, 9560},   {-31299, 9703},   {-31253, 9847},
    {-31207, 9991},   {-31161, 10134},  {-31114, 10279},  {-31067, 10421},  {-31018, 10564},  {-30970, 10707},
    {-30920, 10849},  {-30869, 10991},  {-30819, 11134},  {-30767, 11275},  {-30715, 11417},  {-30662, 11558},
    {-30608, 11699},  {-30554, 11839},  {-30499, 11980},  {-30444, 12120},  {-30388, 12260},  {-30330, 12400},
    {-30273, 12539},  {-30215, 12678},  {-30157, 12817},  {-30097, 12957},  {-30037, 13094},  {-29977, 13233},
    {-29916, 13370},  {-29855, 13508},  {-29791, 13645},  {-29729, 13781},  {-29665, 13918},  {-29600, 14055},
    {-29535, 14191},  {-29470, 14327},  {-29404, 14462},  {-29337, 14597},  {-29269, 14732},  {-29201, 14867},
    {-29132, 15001},  {-29062, 15135},  {-28993, 15269},  {-28923, 15402},  {-28851, 15535},  {-28779, 15667},
    {-28707, 15800},  {-28634, 15932},  {-28561, 16063},  {-28487, 16194},  {-28411, 16325},  {-28336, 16456},
    {-28261, 16586},  {-28184, 16716},  {-28106, 16846},  {-28028, 16975},  {-27950, 17103},  {-27871, 17232},
    {-27791, 17360},  {-27711, 17488},  {-27630, 17615},  {-27549, 17743},  {-27468, 17869},  {-27385, 17995},
    {-27302, 18121},  {-27217, 18246},  {-27132, 18371},  {-27049, 18497},  {-26963, 18620},  {-26877, 18743},
    {-26791, 18868},  {-26703, 18991},  {-26616, 19114},  {-26527, 19236},  {-26439, 19358},  {-26350, 19479},
    {-26259, 19599},  {-26169, 19721},  {-26078, 19841},  {-25986, 19960},  {-25894, 20080},  {-25802, 20199},
    {-25708, 20317},  {-25615, 20436},  {-25520, 20553},  {-25425, 20671},  {-25330, 20788},  {-25234, 20904},
    {-25137, 21020},  {-25040, 21135},  {-24943, 21251},  {-24845, 21365},  {-24746, 21479},  {-24648, 21592},
    {-24548, 21705},  {-24447, 21818},  {-24347, 21930},  {-24246, 22042},  {-24144, 22154},  {-24042, 22264},
    {-23938, 22375},  {-23836, 22485},  {-23732, 22594},  {-23628, 22703},  {-23523, 22812},  {-23418, 22920},
    {-23313, 23027},  {-23206, 23134},  {-23100, 23240},  {-22992, 23347},  {-22884, 23453},  {-22777, 23557},
    {-22667, 23662},  {-22559, 23766},  {-22449, 23870},  {-22338, 23973},  {-22228, 24075},  {-22117, 24177},
    {-22006, 24279},  {-21893, 24380},  {-21781, 24480},  {-21669, 24580},  {-21555, 24679},  {-21441, 24778},
    {-21327, 24877},  {-21213, 24976},  {-21097, 25072},  {-20981, 25169},  {-20865, 25265},  {-20750, 25362},
    {-20633, 25456},  {-20515, 25551},  {-20398, 25645},  {-20279, 25739},  {-20160, 25832},  {-20040, 25925},
    {-19921, 26017},  {-19801, 26109},  {-19681, 26199},  {-19560, 26289},  {-19440, 26379},  {-19318, 26468},
    {-19196, 26557},  {-19073, 26644},  {-18950, 26732},  {-18827, 26819},  {-18703, 26906},  {-18580, 26991},
    {-18454, 27077},  {-18331, 27161},  {-18205, 27245},  {-18079, 27329},  {-17954, 27412},  {-17828, 27493},
    {-17700, 27576},  {-17573, 27656},  {-17446, 27737},  {-17318, 27817},  {-17190, 27896},  {-17061, 27976},
    {-16932, 28054},  {-16803, 28132},  {-16673, 28209},  {-16544, 28285},  {-16412, 28360},  {-16283, 28436},
    {-16151, 28511},  {-16021, 28584},  {-15889, 28659},  {-15756, 28731},  {-15624, 28803},  {-15491, 28875},
    {-15358, 28945},  {-15224, 29016},  {-15091, 29086},  {-14957, 29155},  {-14823, 29224},  {-14689, 29291},
    {-14553, 29358},  {-14417, 29425},  {-14281, 29491},  {-14146, 29557},  {-14010, 29621},  {-13874, 29686},
    {-13737, 29749},  {-13600, 29812},  {-13463, 29874},  {-13325, 29936},  {-13187, 29997},  {-13049, 30057},
    {-12911, 30117},  {-12772, 30177},  {-12633, 30234},  {-12493, 30292},  {-12354, 30349},  {-12214, 30406},
    {-12074, 30462},  {-11933, 30517},  {-11793, 30572},  {-11652, 30626},  {-11511, 30679},  {-11369, 30732},
    {-11229, 30784},  {-11086, 30834},  {-10945, 30885},  {-10803, 30936},  {-10660, 30985},  {-10517, 31034},
    {-10374, 31081},  {-10231, 31130},  {-10088, 31177},  {-9944, 31222},   {-9801, 31268},   {-9656, 31313},
    {-9512, 31356},   {-9368, 31400},   {-9223, 31443},   {-9079, 31485},   {-8934, 31526},   {-8789, 31567},
    {-8643, 31607},   {-8497, 31647},   {-8351, 31686},   {-8205, 31723},   {-8059, 31761},   {-7913, 31798},
    {-7766, 31834},   {-7620, 31870},   {-7474, 31904},   {-7326, 31937},   {-7180, 31971},   {-7032, 32004},
    {-6884, 32035},   {-6738, 32067},   {-6590, 32098},   {-6442, 32128},   {-6295, 32157},   {-6147, 32186},
    {-5997, 32214},   {-5849, 32241},   {-5702, 32268},   {-5553, 32293},   {-5404, 32318},   {-5255, 32343},
    {-5106, 32367},   {-4957, 32390},   {-4808, 32413},   {-4659, 32435},   {-4509, 32455},   {-4360, 32476},
    {-4210, 32496},   {-4061, 32515},   {-3912, 32533},   {-3761, 32551},   {-3612, 32568},   {-3462, 32584},
    {-3312, 32599},   {-3162, 32615},   {-3011, 32629},   {-2862, 32642},   {-2712, 32656},   {-2560, 32667},
    {-2411, 32679},   {-2260, 32689},   {-2110, 32699},   {-1959, 32708},   {-1808, 32717},   {-1659, 32725},
    {-1508, 32733},   {-1357, 32740},   {-1206, 32746},   {-1056, 32750},   {-905, 32755},    {-754, 32759},
    {-603, 32762},    {-453, 32765},    {-302, 32766},    {-151, 32767}};

#endif //__FFT_R4_TWIDDLE_LUT_DIT_H__
