/*
 * Copyright (C) 2019-2022, Xilinx, Inc.
 * Copyright (C) 2022-2025, Advanced Micro Devices, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef __FFT_R4_TWIDDLE_LUT_DIT_ALL_H__
#define __FFT_R4_TWIDDLE_LUT_DIT_ALL_H__

// DO NOT HAND EDIT THIS FILE. IT WAS CREATED using ../tests/inc/twiddle_32.c

alignas(__ALIGN_BYTE_SIZE__) const cint32 fft_lut_cint32_r4_1_2[8] = {
    {2147483647, 0}, {-2147483648, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}};

alignas(__ALIGN_BYTE_SIZE__) const cint32 fft_lut_cint32_r4_2_4[8] = {
    {2147483647, 0}, {-1518500250, -1518500250}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}};

alignas(__ALIGN_BYTE_SIZE__) const cint32 fft_lut_cint32_r4_4_8[8] = {{2147483647, 0},
                                                                      {821806413, -1984016189},
                                                                      {-1518500250, -1518500250},
                                                                      {-1984016189, 821806413},
                                                                      {0, 0},
                                                                      {0, 0},
                                                                      {0, 0},
                                                                      {0, 0}};

alignas(__ALIGN_BYTE_SIZE__) const cint32 fft_lut_cint32_r4_8_16[8] = {
    {2147483647, 0},           {1785567396, -1193077991},  {821806413, -1984016189},
    {-418953276, -2106220352}, {-1518500250, -1518500250}, {-2106220352, -418953276},
    {-1984016189, 821806413},  {-1193077991, 1785567396}};

alignas(__ALIGN_BYTE_SIZE__) const cint32 fft_lut_cint32_r4_16_32[16] = {{2147483647, 0},
                                                                         {2055013723, -623381598},
                                                                         {1785567396, -1193077991},
                                                                         {1362349204, -1660027308},
                                                                         {821806413, -1984016189},
                                                                         {210490206, -2137142927},
                                                                         {-418953276, -2106220352},
                                                                         {-1012316784, -1893911494},
                                                                         {-1518500250, -1518500250},
                                                                         {-1893911494, -1012316784},
                                                                         {-2106220352, -418953276},
                                                                         {-2137142927, 210490206},
                                                                         {-1984016189, 821806413},
                                                                         {-1660027308, 1362349204},
                                                                         {-1193077991, 1785567396},
                                                                         {-623381598, 2055013723}};

alignas(__ALIGN_BYTE_SIZE__) const cint32 fft_lut_cint32_r4_32_64[32] = {{2147483647, 0},
                                                                         {2124240380, -315101295},
                                                                         {2055013723, -623381598},
                                                                         {1941302225, -918167572},
                                                                         {1785567396, -1193077991},
                                                                         {1591180426, -1442161874},
                                                                         {1362349204, -1660027308},
                                                                         {1104027237, -1841958164},
                                                                         {821806413, -1984016189},
                                                                         {521795963, -2083126254},
                                                                         {210490206, -2137142927},
                                                                         {-105372028, -2144896910},
                                                                         {-418953276, -2106220352},
                                                                         {-723465451, -2021950484},
                                                                         {-1012316784, -1893911494},
                                                                         {-1279254516, -1724875040},
                                                                         {-1518500250, -1518500250},
                                                                         {-1724875040, -1279254516},
                                                                         {-1893911494, -1012316784},
                                                                         {-2021950484, -723465451},
                                                                         {-2106220352, -418953276},
                                                                         {-2144896910, -105372028},
                                                                         {-2137142927, 210490206},
                                                                         {-2083126254, 521795963},
                                                                         {-1984016189, 821806413},
                                                                         {-1841958164, 1104027237},
                                                                         {-1660027308, 1362349204},
                                                                         {-1442161874, 1591180426},
                                                                         {-1193077991, 1785567396},
                                                                         {-918167572, 1941302225},
                                                                         {-623381598, 2055013723},
                                                                         {-315101295, 2124240380}};

alignas(__ALIGN_BYTE_SIZE__) const cint32 fft_lut_cint32_r4_64_128[64] = {{2147483647, 0},
                                                                          {2141664948, -157978697},
                                                                          {2124240380, -315101295},
                                                                          {2095304370, -470516330},
                                                                          {2055013723, -623381598},
                                                                          {2003586779, -772868706},
                                                                          {1941302225, -918167572},
                                                                          {1868497586, -1058490808},
                                                                          {1785567396, -1193077991},
                                                                          {1692961062, -1321199781},
                                                                          {1591180426, -1442161874},
                                                                          {1480777044, -1555308768},
                                                                          {1362349204, -1660027308},
                                                                          {1236538675, -1755750017},
                                                                          {1104027237, -1841958164},
                                                                          {965532978, -1918184581},
                                                                          {821806413, -1984016189},
                                                                          {673626408, -2039096241},
                                                                          {521795963, -2083126254},
                                                                          {367137861, -2115867626},
                                                                          {210490206, -2137142927},
                                                                          {52701887, -2146836866},
                                                                          {-105372028, -2144896910},
                                                                          {-262874923, -2131333572},
                                                                          {-418953276, -2106220352},
                                                                          {-572761285, -2069693342},
                                                                          {-723465451, -2021950484},
                                                                          {-870249095, -1963250501},
                                                                          {-1012316784, -1893911494},
                                                                          {-1148898640, -1814309216},
                                                                          {-1279254516, -1724875040},
                                                                          {-1402678000, -1626093616},
                                                                          {-1518500250, -1518500250},
                                                                          {-1626093616, -1402678000},
                                                                          {-1724875040, -1279254516},
                                                                          {-1814309216, -1148898640},
                                                                          {-1893911494, -1012316784},
                                                                          {-1963250501, -870249095},
                                                                          {-2021950484, -723465451},
                                                                          {-2069693342, -572761285},
                                                                          {-2106220352, -418953276},
                                                                          {-2131333572, -262874923},
                                                                          {-2144896910, -105372028},
                                                                          {-2146836866, 52701887},
                                                                          {-2137142927, 210490206},
                                                                          {-2115867626, 367137861},
                                                                          {-2083126254, 521795963},
                                                                          {-2039096241, 673626408},
                                                                          {-1984016189, 821806413},
                                                                          {-1918184581, 965532978},
                                                                          {-1841958164, 1104027237},
                                                                          {-1755750017, 1236538675},
                                                                          {-1660027308, 1362349204},
                                                                          {-1555308768, 1480777044},
                                                                          {-1442161874, 1591180426},
                                                                          {-1321199781, 1692961062},
                                                                          {-1193077991, 1785567396},
                                                                          {-1058490808, 1868497586},
                                                                          {-918167572, 1941302225},
                                                                          {-772868706, 2003586779},
                                                                          {-623381598, 2055013723},
                                                                          {-470516330, 2095304370},
                                                                          {-315101295, 2124240380},
                                                                          {-157978697, 2141664948}};

alignas(__ALIGN_BYTE_SIZE__) const cint32 fft_lut_cint32_r4_128_256[128] = {{2147483647, 0},
                                                                            {2146028480, -79042909},
                                                                            {2141664948, -157978697},
                                                                            {2134398966, -236700388},
                                                                            {2124240380, -315101295},
                                                                            {2111202959, -393075166},
                                                                            {2095304370, -470516330},
                                                                            {2076566160, -547319836},
                                                                            {2055013723, -623381598},
                                                                            {2030676269, -698598533},
                                                                            {2003586779, -772868706},
                                                                            {1973781967, -846091463},
                                                                            {1941302225, -918167572},
                                                                            {1906191570, -988999351},
                                                                            {1868497586, -1058490808},
                                                                            {1828271356, -1126547765},
                                                                            {1785567396, -1193077991},
                                                                            {1740443581, -1257991320},
                                                                            {1692961062, -1321199781},
                                                                            {1643184191, -1382617710},
                                                                            {1591180426, -1442161874},
                                                                            {1537020244, -1499751576},
                                                                            {1480777044, -1555308768},
                                                                            {1422527051, -1608758157},
                                                                            {1362349204, -1660027308},
                                                                            {1300325060, -1709046739},
                                                                            {1236538675, -1755750017},
                                                                            {1171076495, -1800073849},
                                                                            {1104027237, -1841958164},
                                                                            {1035481766, -1881346202},
                                                                            {965532978, -1918184581},
                                                                            {894275671, -1952423377},
                                                                            {821806413, -1984016189},
                                                                            {748223418, -2012920201},
                                                                            {673626408, -2039096241},
                                                                            {598116479, -2062508835},
                                                                            {521795963, -2083126254},
                                                                            {444768294, -2100920556},
                                                                            {367137861, -2115867626},
                                                                            {289009871, -2127947206},
                                                                            {210490206, -2137142927},
                                                                            {131685278, -2143442326},
                                                                            {52701887, -2146836866},
                                                                            {-26352928, -2147321946},
                                                                            {-105372028, -2144896910},
                                                                            {-184248325, -2139565043},
                                                                            {-262874923, -2131333572},
                                                                            {-341145265, -2120213651},
                                                                            {-418953276, -2106220352},
                                                                            {-496193509, -2089372638},
                                                                            {-572761285, -2069693342},
                                                                            {-648552838, -2047209133},
                                                                            {-723465451, -2021950484},
                                                                            {-797397602, -1993951625},
                                                                            {-870249095, -1963250501},
                                                                            {-941921200, -1929888720},
                                                                            {-1012316784, -1893911494},
                                                                            {-1081340445, -1855367581},
                                                                            {-1148898640, -1814309216},
                                                                            {-1214899813, -1770792044},
                                                                            {-1279254516, -1724875040},
                                                                            {-1341875533, -1676620432},
                                                                            {-1402678000, -1626093616},
                                                                            {-1461579514, -1573363068},
                                                                            {-1518500250, -1518500250},
                                                                            {-1573363068, -1461579514},
                                                                            {-1626093616, -1402678000},
                                                                            {-1676620432, -1341875533},
                                                                            {-1724875040, -1279254516},
                                                                            {-1770792044, -1214899813},
                                                                            {-1814309216, -1148898640},
                                                                            {-1855367581, -1081340445},
                                                                            {-1893911494, -1012316784},
                                                                            {-1929888720, -941921200},
                                                                            {-1963250501, -870249095},
                                                                            {-1993951625, -797397602},
                                                                            {-2021950484, -723465451},
                                                                            {-2047209133, -648552838},
                                                                            {-2069693342, -572761285},
                                                                            {-2089372638, -496193509},
                                                                            {-2106220352, -418953276},
                                                                            {-2120213651, -341145265},
                                                                            {-2131333572, -262874923},
                                                                            {-2139565043, -184248325},
                                                                            {-2144896910, -105372028},
                                                                            {-2147321946, -26352928},
                                                                            {-2146836866, 52701887},
                                                                            {-2143442326, 131685278},
                                                                            {-2137142927, 210490206},
                                                                            {-2127947206, 289009871},
                                                                            {-2115867626, 367137861},
                                                                            {-2100920556, 444768294},
                                                                            {-2083126254, 521795963},
                                                                            {-2062508835, 598116479},
                                                                            {-2039096241, 673626408},
                                                                            {-2012920201, 748223418},
                                                                            {-1984016189, 821806413},
                                                                            {-1952423377, 894275671},
                                                                            {-1918184581, 965532978},
                                                                            {-1881346202, 1035481766},
                                                                            {-1841958164, 1104027237},
                                                                            {-1800073849, 1171076495},
                                                                            {-1755750017, 1236538675},
                                                                            {-1709046739, 1300325060},
                                                                            {-1660027308, 1362349204},
                                                                            {-1608758157, 1422527051},
                                                                            {-1555308768, 1480777044},
                                                                            {-1499751576, 1537020244},
                                                                            {-1442161874, 1591180426},
                                                                            {-1382617710, 1643184191},
                                                                            {-1321199781, 1692961062},
                                                                            {-1257991320, 1740443581},
                                                                            {-1193077991, 1785567396},
                                                                            {-1126547765, 1828271356},
                                                                            {-1058490808, 1868497586},
                                                                            {-988999351, 1906191570},
                                                                            {-918167572, 1941302225},
                                                                            {-846091463, 1973781967},
                                                                            {-772868706, 2003586779},
                                                                            {-698598533, 2030676269},
                                                                            {-623381598, 2055013723},
                                                                            {-547319836, 2076566160},
                                                                            {-470516330, 2095304370},
                                                                            {-393075166, 2111202959},
                                                                            {-315101295, 2124240380},
                                                                            {-236700388, 2134398966},
                                                                            {-157978697, 2141664948},
                                                                            {-79042909, 2146028480}};

alignas(__ALIGN_BYTE_SIZE__) const cint32 fft_lut_cint32_r4_256_512[256] = {{2147483647, 0},
                                                                            {2147119825, -39528151},
                                                                            {2146028480, -79042909},
                                                                            {2144209982, -118530885},
                                                                            {2141664948, -157978697},
                                                                            {2138394240, -197372981},
                                                                            {2134398966, -236700388},
                                                                            {2129680480, -275947592},
                                                                            {2124240380, -315101295},
                                                                            {2118080511, -354148230},
                                                                            {2111202959, -393075166},
                                                                            {2103610054, -431868915},
                                                                            {2095304370, -470516330},
                                                                            {2086288720, -509004318},
                                                                            {2076566160, -547319836},
                                                                            {2066139983, -585449903},
                                                                            {2055013723, -623381598},
                                                                            {2043191150, -661102068},
                                                                            {2030676269, -698598533},
                                                                            {2017473321, -735858287},
                                                                            {2003586779, -772868706},
                                                                            {1989021350, -809617249},
                                                                            {1973781967, -846091463},
                                                                            {1957873796, -882278992},
                                                                            {1941302225, -918167572},
                                                                            {1924072871, -953745043},
                                                                            {1906191570, -988999351},
                                                                            {1887664383, -1023918550},
                                                                            {1868497586, -1058490808},
                                                                            {1848697674, -1092704411},
                                                                            {1828271356, -1126547765},
                                                                            {1807225553, -1160009405},
                                                                            {1785567396, -1193077991},
                                                                            {1763304224, -1225742318},
                                                                            {1740443581, -1257991320},
                                                                            {1716993211, -1289814068},
                                                                            {1692961062, -1321199781},
                                                                            {1668355276, -1352137822},
                                                                            {1643184191, -1382617710},
                                                                            {1617456335, -1412629117},
                                                                            {1591180426, -1442161874},
                                                                            {1564365367, -1471205974},
                                                                            {1537020244, -1499751576},
                                                                            {1509154322, -1527789007},
                                                                            {1480777044, -1555308768},
                                                                            {1451898025, -1582301533},
                                                                            {1422527051, -1608758157},
                                                                            {1392674072, -1634669676},
                                                                            {1362349204, -1660027308},
                                                                            {1331562723, -1684822463},
                                                                            {1300325060, -1709046739},
                                                                            {1268646800, -1732691928},
                                                                            {1236538675, -1755750017},
                                                                            {1204011567, -1778213194},
                                                                            {1171076495, -1800073849},
                                                                            {1137744621, -1821324572},
                                                                            {1104027237, -1841958164},
                                                                            {1069935768, -1861967634},
                                                                            {1035481766, -1881346202},
                                                                            {1000676905, -1900087301},
                                                                            {965532978, -1918184581},
                                                                            {930061894, -1935631910},
                                                                            {894275671, -1952423377},
                                                                            {858186435, -1968553292},
                                                                            {821806413, -1984016189},
                                                                            {785147934, -1998806829},
                                                                            {748223418, -2012920201},
                                                                            {711045377, -2026351522},
                                                                            {673626408, -2039096241},
                                                                            {635979190, -2051150040},
                                                                            {598116479, -2062508835},
                                                                            {560051104, -2073168777},
                                                                            {521795963, -2083126254},
                                                                            {483364019, -2092377892},
                                                                            {444768294, -2100920556},
                                                                            {406021865, -2108751352},
                                                                            {367137861, -2115867626},
                                                                            {328129457, -2122266967},
                                                                            {289009871, -2127947206},
                                                                            {249792358, -2132906420},
                                                                            {210490206, -2137142927},
                                                                            {171116733, -2140655293},
                                                                            {131685278, -2143442326},
                                                                            {92209205, -2145503083},
                                                                            {52701887, -2146836866},
                                                                            {13176712, -2147443222},
                                                                            {-26352928, -2147321946},
                                                                            {-65873638, -2146473080},
                                                                            {-105372028, -2144896910},
                                                                            {-144834714, -2142593971},
                                                                            {-184248325, -2139565043},
                                                                            {-223599506, -2135811153},
                                                                            {-262874923, -2131333572},
                                                                            {-302061269, -2126133817},
                                                                            {-341145265, -2120213651},
                                                                            {-380113669, -2113575080},
                                                                            {-418953276, -2106220352},
                                                                            {-457650927, -2098151960},
                                                                            {-496193509, -2089372638},
                                                                            {-534567963, -2079885360},
                                                                            {-572761285, -2069693342},
                                                                            {-610760536, -2058800036},
                                                                            {-648552838, -2047209133},
                                                                            {-686125387, -2034924562},
                                                                            {-723465451, -2021950484},
                                                                            {-760560380, -2008291295},
                                                                            {-797397602, -1993951625},
                                                                            {-833964638, -1978936331},
                                                                            {-870249095, -1963250501},
                                                                            {-906238681, -1946899451},
                                                                            {-941921200, -1929888720},
                                                                            {-977284562, -1912224073},
                                                                            {-1012316784, -1893911494},
                                                                            {-1047005996, -1874957189},
                                                                            {-1081340445, -1855367581},
                                                                            {-1115308496, -1835149306},
                                                                            {-1148898640, -1814309216},
                                                                            {-1182099496, -1792854372},
                                                                            {-1214899813, -1770792044},
                                                                            {-1247288478, -1748129707},
                                                                            {-1279254516, -1724875040},
                                                                            {-1310787095, -1701035922},
                                                                            {-1341875533, -1676620432},
                                                                            {-1372509294, -1651636841},
                                                                            {-1402678000, -1626093616},
                                                                            {-1432371426, -1599999411},
                                                                            {-1461579514, -1573363068},
                                                                            {-1490292364, -1546193612},
                                                                            {-1518500250, -1518500250},
                                                                            {-1546193612, -1490292364},
                                                                            {-1573363068, -1461579514},
                                                                            {-1599999411, -1432371426},
                                                                            {-1626093616, -1402678000},
                                                                            {-1651636841, -1372509294},
                                                                            {-1676620432, -1341875533},
                                                                            {-1701035922, -1310787095},
                                                                            {-1724875040, -1279254516},
                                                                            {-1748129707, -1247288478},
                                                                            {-1770792044, -1214899813},
                                                                            {-1792854372, -1182099496},
                                                                            {-1814309216, -1148898640},
                                                                            {-1835149306, -1115308496},
                                                                            {-1855367581, -1081340445},
                                                                            {-1874957189, -1047005996},
                                                                            {-1893911494, -1012316784},
                                                                            {-1912224073, -977284562},
                                                                            {-1929888720, -941921200},
                                                                            {-1946899451, -906238681},
                                                                            {-1963250501, -870249095},
                                                                            {-1978936331, -833964638},
                                                                            {-1993951625, -797397602},
                                                                            {-2008291295, -760560380},
                                                                            {-2021950484, -723465451},
                                                                            {-2034924562, -686125387},
                                                                            {-2047209133, -648552838},
                                                                            {-2058800036, -610760536},
                                                                            {-2069693342, -572761285},
                                                                            {-2079885360, -534567963},
                                                                            {-2089372638, -496193509},
                                                                            {-2098151960, -457650927},
                                                                            {-2106220352, -418953276},
                                                                            {-2113575080, -380113669},
                                                                            {-2120213651, -341145265},
                                                                            {-2126133817, -302061269},
                                                                            {-2131333572, -262874923},
                                                                            {-2135811153, -223599506},
                                                                            {-2139565043, -184248325},
                                                                            {-2142593971, -144834714},
                                                                            {-2144896910, -105372028},
                                                                            {-2146473080, -65873638},
                                                                            {-2147321946, -26352928},
                                                                            {-2147443222, 13176712},
                                                                            {-2146836866, 52701887},
                                                                            {-2145503083, 92209205},
                                                                            {-2143442326, 131685278},
                                                                            {-2140655293, 171116733},
                                                                            {-2137142927, 210490206},
                                                                            {-2132906420, 249792358},
                                                                            {-2127947206, 289009871},
                                                                            {-2122266967, 328129457},
                                                                            {-2115867626, 367137861},
                                                                            {-2108751352, 406021865},
                                                                            {-2100920556, 444768294},
                                                                            {-2092377892, 483364019},
                                                                            {-2083126254, 521795963},
                                                                            {-2073168777, 560051104},
                                                                            {-2062508835, 598116479},
                                                                            {-2051150040, 635979190},
                                                                            {-2039096241, 673626408},
                                                                            {-2026351522, 711045377},
                                                                            {-2012920201, 748223418},
                                                                            {-1998806829, 785147934},
                                                                            {-1984016189, 821806413},
                                                                            {-1968553292, 858186435},
                                                                            {-1952423377, 894275671},
                                                                            {-1935631910, 930061894},
                                                                            {-1918184581, 965532978},
                                                                            {-1900087301, 1000676905},
                                                                            {-1881346202, 1035481766},
                                                                            {-1861967634, 1069935768},
                                                                            {-1841958164, 1104027237},
                                                                            {-1821324572, 1137744621},
                                                                            {-1800073849, 1171076495},
                                                                            {-1778213194, 1204011567},
                                                                            {-1755750017, 1236538675},
                                                                            {-1732691928, 1268646800},
                                                                            {-1709046739, 1300325060},
                                                                            {-1684822463, 1331562723},
                                                                            {-1660027308, 1362349204},
                                                                            {-1634669676, 1392674072},
                                                                            {-1608758157, 1422527051},
                                                                            {-1582301533, 1451898025},
                                                                            {-1555308768, 1480777044},
                                                                            {-1527789007, 1509154322},
                                                                            {-1499751576, 1537020244},
                                                                            {-1471205974, 1564365367},
                                                                            {-1442161874, 1591180426},
                                                                            {-1412629117, 1617456335},
                                                                            {-1382617710, 1643184191},
                                                                            {-1352137822, 1668355276},
                                                                            {-1321199781, 1692961062},
                                                                            {-1289814068, 1716993211},
                                                                            {-1257991320, 1740443581},
                                                                            {-1225742318, 1763304224},
                                                                            {-1193077991, 1785567396},
                                                                            {-1160009405, 1807225553},
                                                                            {-1126547765, 1828271356},
                                                                            {-1092704411, 1848697674},
                                                                            {-1058490808, 1868497586},
                                                                            {-1023918550, 1887664383},
                                                                            {-988999351, 1906191570},
                                                                            {-953745043, 1924072871},
                                                                            {-918167572, 1941302225},
                                                                            {-882278992, 1957873796},
                                                                            {-846091463, 1973781967},
                                                                            {-809617249, 1989021350},
                                                                            {-772868706, 2003586779},
                                                                            {-735858287, 2017473321},
                                                                            {-698598533, 2030676269},
                                                                            {-661102068, 2043191150},
                                                                            {-623381598, 2055013723},
                                                                            {-585449903, 2066139983},
                                                                            {-547319836, 2076566160},
                                                                            {-509004318, 2086288720},
                                                                            {-470516330, 2095304370},
                                                                            {-431868915, 2103610054},
                                                                            {-393075166, 2111202959},
                                                                            {-354148230, 2118080511},
                                                                            {-315101295, 2124240380},
                                                                            {-275947592, 2129680480},
                                                                            {-236700388, 2134398966},
                                                                            {-197372981, 2138394240},
                                                                            {-157978697, 2141664948},
                                                                            {-118530885, 2144209982},
                                                                            {-79042909, 2146028480},
                                                                            {-39528151, 2147119825}};

alignas(__ALIGN_BYTE_SIZE__) const cint32 fft_lut_cint32_r4_512_1024[512] = {{2147483647, 0},
                                                                             {2147392690, -19764913},
                                                                             {2147119825, -39528151},
                                                                             {2146665076, -59288042},
                                                                             {2146028480, -79042909},
                                                                             {2145210092, -98791081},
                                                                             {2144209982, -118530885},
                                                                             {2143028234, -138260647},
                                                                             {2141664948, -157978697},
                                                                             {2140120240, -177683365},
                                                                             {2138394240, -197372981},
                                                                             {2136487095, -217045878},
                                                                             {2134398966, -236700388},
                                                                             {2132130030, -256334847},
                                                                             {2129680480, -275947592},
                                                                             {2127050522, -295536961},
                                                                             {2124240380, -315101295},
                                                                             {2121250292, -334638936},
                                                                             {2118080511, -354148230},
                                                                             {2114731305, -373627523},
                                                                             {2111202959, -393075166},
                                                                             {2107495770, -412489512},
                                                                             {2103610054, -431868915},
                                                                             {2099546139, -451211734},
                                                                             {2095304370, -470516330},
                                                                             {2090885105, -489781069},
                                                                             {2086288720, -509004318},
                                                                             {2081515603, -528184449},
                                                                             {2076566160, -547319836},
                                                                             {2071440808, -566408860},
                                                                             {2066139983, -585449903},
                                                                             {2060664133, -604441352},
                                                                             {2055013723, -623381598},
                                                                             {2049189231, -642269036},
                                                                             {2043191150, -661102068},
                                                                             {2037019988, -679879097},
                                                                             {2030676269, -698598533},
                                                                             {2024160529, -717258790},
                                                                             {2017473321, -735858287},
                                                                             {2010615210, -754395449},
                                                                             {2003586779, -772868706},
                                                                             {1996388622, -791276492},
                                                                             {1989021350, -809617249},
                                                                             {1981485585, -827889422},
                                                                             {1973781967, -846091463},
                                                                             {1965911148, -864221832},
                                                                             {1957873796, -882278992},
                                                                             {1949670589, -900261413},
                                                                             {1941302225, -918167572},
                                                                             {1932769411, -935995952},
                                                                             {1924072871, -953745043},
                                                                             {1915213340, -971413342},
                                                                             {1906191570, -988999351},
                                                                             {1897008325, -1006501581},
                                                                             {1887664383, -1023918550},
                                                                             {1878160535, -1041248781},
                                                                             {1868497586, -1058490808},
                                                                             {1858676355, -1075643169},
                                                                             {1848697674, -1092704411},
                                                                             {1838562388, -1109673089},
                                                                             {1828271356, -1126547765},
                                                                             {1817825449, -1143327011},
                                                                             {1807225553, -1160009405},
                                                                             {1796472565, -1176593533},
                                                                             {1785567396, -1193077991},
                                                                             {1774510970, -1209461382},
                                                                             {1763304224, -1225742318},
                                                                             {1751948107, -1241919421},
                                                                             {1740443581, -1257991320},
                                                                             {1728791620, -1273956653},
                                                                             {1716993211, -1289814068},
                                                                             {1705049355, -1305562222},
                                                                             {1692961062, -1321199781},
                                                                             {1680729357, -1336725419},
                                                                             {1668355276, -1352137822},
                                                                             {1655839867, -1367435685},
                                                                             {1643184191, -1382617710},
                                                                             {1630389319, -1397682613},
                                                                             {1617456335, -1412629117},
                                                                             {1604386335, -1427455956},
                                                                             {1591180426, -1442161874},
                                                                             {1577839726, -1456745625},
                                                                             {1564365367, -1471205974},
                                                                             {1550758488, -1485541696},
                                                                             {1537020244, -1499751576},
                                                                             {1523151797, -1513834411},
                                                                             {1509154322, -1527789007},
                                                                             {1495029006, -1541614183},
                                                                             {1480777044, -1555308768},
                                                                             {1466399645, -1568871601},
                                                                             {1451898025, -1582301533},
                                                                             {1437273414, -1595597428},
                                                                             {1422527051, -1608758157},
                                                                             {1407660183, -1621782608},
                                                                             {1392674072, -1634669676},
                                                                             {1377569986, -1647418269},
                                                                             {1362349204, -1660027308},
                                                                             {1347013017, -1672495725},
                                                                             {1331562723, -1684822463},
                                                                             {1315999631, -1697006479},
                                                                             {1300325060, -1709046739},
                                                                             {1284540337, -1720942225},
                                                                             {1268646800, -1732691928},
                                                                             {1252645794, -1744294853},
                                                                             {1236538675, -1755750017},
                                                                             {1220326809, -1767056450},
                                                                             {1204011567, -1778213194},
                                                                             {1187594332, -1789219305},
                                                                             {1171076495, -1800073849},
                                                                             {1154459456, -1810775906},
                                                                             {1137744621, -1821324572},
                                                                             {1120933406, -1831718951},
                                                                             {1104027237, -1841958164},
                                                                             {1087027544, -1852041343},
                                                                             {1069935768, -1861967634},
                                                                             {1052753357, -1871736196},
                                                                             {1035481766, -1881346202},
                                                                             {1018122458, -1890796837},
                                                                             {1000676905, -1900087301},
                                                                             {983146583, -1909216806},
                                                                             {965532978, -1918184581},
                                                                             {947837582, -1926989864},
                                                                             {930061894, -1935631910},
                                                                             {912207419, -1944109987},
                                                                             {894275671, -1952423377},
                                                                             {876268167, -1960571375},
                                                                             {858186435, -1968553292},
                                                                             {840032004, -1976368450},
                                                                             {821806413, -1984016189},
                                                                             {803511207, -1991495860},
                                                                             {785147934, -1998806829},
                                                                             {766718151, -2005948478},
                                                                             {748223418, -2012920201},
                                                                             {729665303, -2019721407},
                                                                             {711045377, -2026351522},
                                                                             {692365218, -2032809982},
                                                                             {673626408, -2039096241},
                                                                             {654830535, -2045209767},
                                                                             {635979190, -2051150040},
                                                                             {617073971, -2056916560},
                                                                             {598116479, -2062508835},
                                                                             {579108320, -2067926394},
                                                                             {560051104, -2073168777},
                                                                             {540946445, -2078235540},
                                                                             {521795963, -2083126254},
                                                                             {502601279, -2087840505},
                                                                             {483364019, -2092377892},
                                                                             {464085813, -2096738032},
                                                                             {444768294, -2100920556},
                                                                             {425413098, -2104925109},
                                                                             {406021865, -2108751352},
                                                                             {386596237, -2112398960},
                                                                             {367137861, -2115867626},
                                                                             {347648383, -2119157054},
                                                                             {328129457, -2122266967},
                                                                             {308582734, -2125197100},
                                                                             {289009871, -2127947206},
                                                                             {269412525, -2130517052},
                                                                             {249792358, -2132906420},
                                                                             {230151030, -2135115107},
                                                                             {210490206, -2137142927},
                                                                             {190811551, -2138989708},
                                                                             {171116733, -2140655293},
                                                                             {151407418, -2142139541},
                                                                             {131685278, -2143442326},
                                                                             {111951983, -2144563539},
                                                                             {92209205, -2145503083},
                                                                             {72458615, -2146260881},
                                                                             {52701887, -2146836866},
                                                                             {32940695, -2147230991},
                                                                             {13176712, -2147443222},
                                                                             {-6588387, -2147473542},
                                                                             {-26352928, -2147321946},
                                                                             {-46115236, -2146988450},
                                                                             {-65873638, -2146473080},
                                                                             {-85626460, -2145775880},
                                                                             {-105372028, -2144896910},
                                                                             {-125108670, -2143836244},
                                                                             {-144834714, -2142593971},
                                                                             {-164548489, -2141170197},
                                                                             {-184248325, -2139565043},
                                                                             {-203932553, -2137778644},
                                                                             {-223599506, -2135811153},
                                                                             {-243247518, -2133662734},
                                                                             {-262874923, -2131333572},
                                                                             {-282480061, -2128823862},
                                                                             {-302061269, -2126133817},
                                                                             {-321616889, -2123263666},
                                                                             {-341145265, -2120213651},
                                                                             {-360644742, -2116984031},
                                                                             {-380113669, -2113575080},
                                                                             {-399550396, -2109987085},
                                                                             {-418953276, -2106220352},
                                                                             {-438320667, -2102275199},
                                                                             {-457650927, -2098151960},
                                                                             {-476942419, -2093850985},
                                                                             {-496193509, -2089372638},
                                                                             {-515402566, -2084717298},
                                                                             {-534567963, -2079885360},
                                                                             {-553688076, -2074877233},
                                                                             {-572761285, -2069693342},
                                                                             {-591785976, -2064334124},
                                                                             {-610760536, -2058800036},
                                                                             {-629683357, -2053091544},
                                                                             {-648552838, -2047209133},
                                                                             {-667367379, -2041153301},
                                                                             {-686125387, -2034924562},
                                                                             {-704825272, -2028523442},
                                                                             {-723465451, -2021950484},
                                                                             {-742044345, -2015206245},
                                                                             {-760560380, -2008291295},
                                                                             {-779011986, -2001206222},
                                                                             {-797397602, -1993951625},
                                                                             {-815715670, -1986528118},
                                                                             {-833964638, -1978936331},
                                                                             {-852142959, -1971176906},
                                                                             {-870249095, -1963250501},
                                                                             {-888281512, -1955157788},
                                                                             {-906238681, -1946899451},
                                                                             {-924119082, -1938476190},
                                                                             {-941921200, -1929888720},
                                                                             {-959643527, -1921137767},
                                                                             {-977284562, -1912224073},
                                                                             {-994842810, -1903148392},
                                                                             {-1012316784, -1893911494},
                                                                             {-1029705004, -1884514161},
                                                                             {-1047005996, -1874957189},
                                                                             {-1064218296, -1865241388},
                                                                             {-1081340445, -1855367581},
                                                                             {-1098370993, -1845336604},
                                                                             {-1115308496, -1835149306},
                                                                             {-1132151521, -1824806552},
                                                                             {-1148898640, -1814309216},
                                                                             {-1165548435, -1803658189},
                                                                             {-1182099496, -1792854372},
                                                                             {-1198550419, -1781898681},
                                                                             {-1214899813, -1770792044},
                                                                             {-1231146291, -1759535401},
                                                                             {-1247288478, -1748129707},
                                                                             {-1263325005, -1736575927},
                                                                             {-1279254516, -1724875040},
                                                                             {-1295075659, -1713028037},
                                                                             {-1310787095, -1701035922},
                                                                             {-1326387494, -1688899711},
                                                                             {-1341875533, -1676620432},
                                                                             {-1357249901, -1664199124},
                                                                             {-1372509294, -1651636841},
                                                                             {-1387652422, -1638934646},
                                                                             {-1402678000, -1626093616},
                                                                             {-1417584755, -1613114838},
                                                                             {-1432371426, -1599999411},
                                                                             {-1447036760, -1586748447},
                                                                             {-1461579514, -1573363068},
                                                                             {-1475998456, -1559844408},
                                                                             {-1490292364, -1546193612},
                                                                             {-1504460029, -1532411837},
                                                                             {-1518500250, -1518500250},
                                                                             {-1532411837, -1504460029},
                                                                             {-1546193612, -1490292364},
                                                                             {-1559844408, -1475998456},
                                                                             {-1573363068, -1461579514},
                                                                             {-1586748447, -1447036760},
                                                                             {-1599999411, -1432371426},
                                                                             {-1613114838, -1417584755},
                                                                             {-1626093616, -1402678000},
                                                                             {-1638934646, -1387652422},
                                                                             {-1651636841, -1372509294},
                                                                             {-1664199124, -1357249901},
                                                                             {-1676620432, -1341875533},
                                                                             {-1688899711, -1326387494},
                                                                             {-1701035922, -1310787095},
                                                                             {-1713028037, -1295075659},
                                                                             {-1724875040, -1279254516},
                                                                             {-1736575927, -1263325005},
                                                                             {-1748129707, -1247288478},
                                                                             {-1759535401, -1231146291},
                                                                             {-1770792044, -1214899813},
                                                                             {-1781898681, -1198550419},
                                                                             {-1792854372, -1182099496},
                                                                             {-1803658189, -1165548435},
                                                                             {-1814309216, -1148898640},
                                                                             {-1824806552, -1132151521},
                                                                             {-1835149306, -1115308496},
                                                                             {-1845336604, -1098370993},
                                                                             {-1855367581, -1081340445},
                                                                             {-1865241388, -1064218296},
                                                                             {-1874957189, -1047005996},
                                                                             {-1884514161, -1029705004},
                                                                             {-1893911494, -1012316784},
                                                                             {-1903148392, -994842810},
                                                                             {-1912224073, -977284562},
                                                                             {-1921137767, -959643527},
                                                                             {-1929888720, -941921200},
                                                                             {-1938476190, -924119082},
                                                                             {-1946899451, -906238681},
                                                                             {-1955157788, -888281512},
                                                                             {-1963250501, -870249095},
                                                                             {-1971176906, -852142959},
                                                                             {-1978936331, -833964638},
                                                                             {-1986528118, -815715670},
                                                                             {-1993951625, -797397602},
                                                                             {-2001206222, -779011986},
                                                                             {-2008291295, -760560380},
                                                                             {-2015206245, -742044345},
                                                                             {-2021950484, -723465451},
                                                                             {-2028523442, -704825272},
                                                                             {-2034924562, -686125387},
                                                                             {-2041153301, -667367379},
                                                                             {-2047209133, -648552838},
                                                                             {-2053091544, -629683357},
                                                                             {-2058800036, -610760536},
                                                                             {-2064334124, -591785976},
                                                                             {-2069693342, -572761285},
                                                                             {-2074877233, -553688076},
                                                                             {-2079885360, -534567963},
                                                                             {-2084717298, -515402566},
                                                                             {-2089372638, -496193509},
                                                                             {-2093850985, -476942419},
                                                                             {-2098151960, -457650927},
                                                                             {-2102275199, -438320667},
                                                                             {-2106220352, -418953276},
                                                                             {-2109987085, -399550396},
                                                                             {-2113575080, -380113669},
                                                                             {-2116984031, -360644742},
                                                                             {-2120213651, -341145265},
                                                                             {-2123263666, -321616889},
                                                                             {-2126133817, -302061269},
                                                                             {-2128823862, -282480061},
                                                                             {-2131333572, -262874923},
                                                                             {-2133662734, -243247518},
                                                                             {-2135811153, -223599506},
                                                                             {-2137778644, -203932553},
                                                                             {-2139565043, -184248325},
                                                                             {-2141170197, -164548489},
                                                                             {-2142593971, -144834714},
                                                                             {-2143836244, -125108670},
                                                                             {-2144896910, -105372028},
                                                                             {-2145775880, -85626460},
                                                                             {-2146473080, -65873638},
                                                                             {-2146988450, -46115236},
                                                                             {-2147321946, -26352928},
                                                                             {-2147473542, -6588387},
                                                                             {-2147443222, 13176712},
                                                                             {-2147230991, 32940695},
                                                                             {-2146836866, 52701887},
                                                                             {-2146260881, 72458615},
                                                                             {-2145503083, 92209205},
                                                                             {-2144563539, 111951983},
                                                                             {-2143442326, 131685278},
                                                                             {-2142139541, 151407418},
                                                                             {-2140655293, 171116733},
                                                                             {-2138989708, 190811551},
                                                                             {-2137142927, 210490206},
                                                                             {-2135115107, 230151030},
                                                                             {-2132906420, 249792358},
                                                                             {-2130517052, 269412525},
                                                                             {-2127947206, 289009871},
                                                                             {-2125197100, 308582734},
                                                                             {-2122266967, 328129457},
                                                                             {-2119157054, 347648383},
                                                                             {-2115867626, 367137861},
                                                                             {-2112398960, 386596237},
                                                                             {-2108751352, 406021865},
                                                                             {-2104925109, 425413098},
                                                                             {-2100920556, 444768294},
                                                                             {-2096738032, 464085813},
                                                                             {-2092377892, 483364019},
                                                                             {-2087840505, 502601279},
                                                                             {-2083126254, 521795963},
                                                                             {-2078235540, 540946445},
                                                                             {-2073168777, 560051104},
                                                                             {-2067926394, 579108320},
                                                                             {-2062508835, 598116479},
                                                                             {-2056916560, 617073971},
                                                                             {-2051150040, 635979190},
                                                                             {-2045209767, 654830535},
                                                                             {-2039096241, 673626408},
                                                                             {-2032809982, 692365218},
                                                                             {-2026351522, 711045377},
                                                                             {-2019721407, 729665303},
                                                                             {-2012920201, 748223418},
                                                                             {-2005948478, 766718151},
                                                                             {-1998806829, 785147934},
                                                                             {-1991495860, 803511207},
                                                                             {-1984016189, 821806413},
                                                                             {-1976368450, 840032004},
                                                                             {-1968553292, 858186435},
                                                                             {-1960571375, 876268167},
                                                                             {-1952423377, 894275671},
                                                                             {-1944109987, 912207419},
                                                                             {-1935631910, 930061894},
                                                                             {-1926989864, 947837582},
                                                                             {-1918184581, 965532978},
                                                                             {-1909216806, 983146583},
                                                                             {-1900087301, 1000676905},
                                                                             {-1890796837, 1018122458},
                                                                             {-1881346202, 1035481766},
                                                                             {-1871736196, 1052753357},
                                                                             {-1861967634, 1069935768},
                                                                             {-1852041343, 1087027544},
                                                                             {-1841958164, 1104027237},
                                                                             {-1831718951, 1120933406},
                                                                             {-1821324572, 1137744621},
                                                                             {-1810775906, 1154459456},
                                                                             {-1800073849, 1171076495},
                                                                             {-1789219305, 1187594332},
                                                                             {-1778213194, 1204011567},
                                                                             {-1767056450, 1220326809},
                                                                             {-1755750017, 1236538675},
                                                                             {-1744294853, 1252645794},
                                                                             {-1732691928, 1268646800},
                                                                             {-1720942225, 1284540337},
                                                                             {-1709046739, 1300325060},
                                                                             {-1697006479, 1315999631},
                                                                             {-1684822463, 1331562723},
                                                                             {-1672495725, 1347013017},
                                                                             {-1660027308, 1362349204},
                                                                             {-1647418269, 1377569986},
                                                                             {-1634669676, 1392674072},
                                                                             {-1621782608, 1407660183},
                                                                             {-1608758157, 1422527051},
                                                                             {-1595597428, 1437273414},
                                                                             {-1582301533, 1451898025},
                                                                             {-1568871601, 1466399645},
                                                                             {-1555308768, 1480777044},
                                                                             {-1541614183, 1495029006},
                                                                             {-1527789007, 1509154322},
                                                                             {-1513834411, 1523151797},
                                                                             {-1499751576, 1537020244},
                                                                             {-1485541696, 1550758488},
                                                                             {-1471205974, 1564365367},
                                                                             {-1456745625, 1577839726},
                                                                             {-1442161874, 1591180426},
                                                                             {-1427455956, 1604386335},
                                                                             {-1412629117, 1617456335},
                                                                             {-1397682613, 1630389319},
                                                                             {-1382617710, 1643184191},
                                                                             {-1367435685, 1655839867},
                                                                             {-1352137822, 1668355276},
                                                                             {-1336725419, 1680729357},
                                                                             {-1321199781, 1692961062},
                                                                             {-1305562222, 1705049355},
                                                                             {-1289814068, 1716993211},
                                                                             {-1273956653, 1728791620},
                                                                             {-1257991320, 1740443581},
                                                                             {-1241919421, 1751948107},
                                                                             {-1225742318, 1763304224},
                                                                             {-1209461382, 1774510970},
                                                                             {-1193077991, 1785567396},
                                                                             {-1176593533, 1796472565},
                                                                             {-1160009405, 1807225553},
                                                                             {-1143327011, 1817825449},
                                                                             {-1126547765, 1828271356},
                                                                             {-1109673089, 1838562388},
                                                                             {-1092704411, 1848697674},
                                                                             {-1075643169, 1858676355},
                                                                             {-1058490808, 1868497586},
                                                                             {-1041248781, 1878160535},
                                                                             {-1023918550, 1887664383},
                                                                             {-1006501581, 1897008325},
                                                                             {-988999351, 1906191570},
                                                                             {-971413342, 1915213340},
                                                                             {-953745043, 1924072871},
                                                                             {-935995952, 1932769411},
                                                                             {-918167572, 1941302225},
                                                                             {-900261413, 1949670589},
                                                                             {-882278992, 1957873796},
                                                                             {-864221832, 1965911148},
                                                                             {-846091463, 1973781967},
                                                                             {-827889422, 1981485585},
                                                                             {-809617249, 1989021350},
                                                                             {-791276492, 1996388622},
                                                                             {-772868706, 2003586779},
                                                                             {-754395449, 2010615210},
                                                                             {-735858287, 2017473321},
                                                                             {-717258790, 2024160529},
                                                                             {-698598533, 2030676269},
                                                                             {-679879097, 2037019988},
                                                                             {-661102068, 2043191150},
                                                                             {-642269036, 2049189231},
                                                                             {-623381598, 2055013723},
                                                                             {-604441352, 2060664133},
                                                                             {-585449903, 2066139983},
                                                                             {-566408860, 2071440808},
                                                                             {-547319836, 2076566160},
                                                                             {-528184449, 2081515603},
                                                                             {-509004318, 2086288720},
                                                                             {-489781069, 2090885105},
                                                                             {-470516330, 2095304370},
                                                                             {-451211734, 2099546139},
                                                                             {-431868915, 2103610054},
                                                                             {-412489512, 2107495770},
                                                                             {-393075166, 2111202959},
                                                                             {-373627523, 2114731305},
                                                                             {-354148230, 2118080511},
                                                                             {-334638936, 2121250292},
                                                                             {-315101295, 2124240380},
                                                                             {-295536961, 2127050522},
                                                                             {-275947592, 2129680480},
                                                                             {-256334847, 2132130030},
                                                                             {-236700388, 2134398966},
                                                                             {-217045878, 2136487095},
                                                                             {-197372981, 2138394240},
                                                                             {-177683365, 2140120240},
                                                                             {-157978697, 2141664948},
                                                                             {-138260647, 2143028234},
                                                                             {-118530885, 2144209982},
                                                                             {-98791081, 2145210092},
                                                                             {-79042909, 2146028480},
                                                                             {-59288042, 2146665076},
                                                                             {-39528151, 2147119825},
                                                                             {-19764913, 2147392690}};

alignas(__ALIGN_BYTE_SIZE__) const cint32 fft_lut_cint32_r4_1024_2048[1024] = {{2147483647, 0},
                                                                               {2147460908, -9882561},
                                                                               {2147392690, -19764913},
                                                                               {2147278995, -29646846},
                                                                               {2147119825, -39528151},
                                                                               {2146915184, -49408620},
                                                                               {2146665076, -59288042},
                                                                               {2146369505, -69166208},
                                                                               {2146028480, -79042909},
                                                                               {2145642006, -88917937},
                                                                               {2145210092, -98791081},
                                                                               {2144732748, -108662134},
                                                                               {2144209982, -118530885},
                                                                               {2143641807, -128397125},
                                                                               {2143028234, -138260647},
                                                                               {2142369276, -148121241},
                                                                               {2141664948, -157978697},
                                                                               {2140915264, -167832808},
                                                                               {2140120240, -177683365},
                                                                               {2139279892, -187530159},
                                                                               {2138394240, -197372981},
                                                                               {2137463301, -207211624},
                                                                               {2136487095, -217045878},
                                                                               {2135465642, -226875535},
                                                                               {2134398966, -236700388},
                                                                               {2133287087, -246520228},
                                                                               {2132130030, -256334847},
                                                                               {2130927819, -266144038},
                                                                               {2129680480, -275947592},
                                                                               {2128388038, -285745302},
                                                                               {2127050522, -295536961},
                                                                               {2125667960, -305322361},
                                                                               {2124240380, -315101295},
                                                                               {2122767814, -324873555},
                                                                               {2121250292, -334638936},
                                                                               {2119687847, -344397230},
                                                                               {2118080511, -354148230},
                                                                               {2116428319, -363891730},
                                                                               {2114731305, -373627523},
                                                                               {2112989506, -383355404},
                                                                               {2111202959, -393075166},
                                                                               {2109371700, -402786604},
                                                                               {2107495770, -412489512},
                                                                               {2105575208, -422183684},
                                                                               {2103610054, -431868915},
                                                                               {2101600350, -441545000},
                                                                               {2099546139, -451211734},
                                                                               {2097447464, -460868912},
                                                                               {2095304370, -470516330},
                                                                               {2093116901, -480153784},
                                                                               {2090885105, -489781069},
                                                                               {2088609029, -499397982},
                                                                               {2086288720, -509004318},
                                                                               {2083924228, -518599875},
                                                                               {2081515603, -528184449},
                                                                               {2079062896, -537757837},
                                                                               {2076566160, -547319836},
                                                                               {2074025446, -556870245},
                                                                               {2071440808, -566408860},
                                                                               {2068812302, -575935480},
                                                                               {2066139983, -585449903},
                                                                               {2063423908, -594951927},
                                                                               {2060664133, -604441352},
                                                                               {2057860719, -613917975},
                                                                               {2055013723, -623381598},
                                                                               {2052123207, -632832018},
                                                                               {2049189231, -642269036},
                                                                               {2046211857, -651692453},
                                                                               {2043191150, -661102068},
                                                                               {2040127172, -670497682},
                                                                               {2037019988, -679879097},
                                                                               {2033869665, -689246113},
                                                                               {2030676269, -698598533},
                                                                               {2027439867, -707936158},
                                                                               {2024160529, -717258790},
                                                                               {2020838323, -726566232},
                                                                               {2017473321, -735858287},
                                                                               {2014065592, -745134758},
                                                                               {2010615210, -754395449},
                                                                               {2007122248, -763640164},
                                                                               {2003586779, -772868706},
                                                                               {2000008879, -782080880},
                                                                               {1996388622, -791276492},
                                                                               {1992726087, -800455346},
                                                                               {1989021350, -809617249},
                                                                               {1985274489, -818762005},
                                                                               {1981485585, -827889422},
                                                                               {1977654717, -836999305},
                                                                               {1973781967, -846091463},
                                                                               {1969867417, -855165703},
                                                                               {1965911148, -864221832},
                                                                               {1961913246, -873259659},
                                                                               {1957873796, -882278992},
                                                                               {1953792881, -891279640},
                                                                               {1949670589, -900261413},
                                                                               {1945507008, -909224120},
                                                                               {1941302225, -918167572},
                                                                               {1937056329, -927091579},
                                                                               {1932769411, -935995952},
                                                                               {1928441561, -944880503},
                                                                               {1924072871, -953745043},
                                                                               {1919663432, -962589385},
                                                                               {1915213340, -971413342},
                                                                               {1910722688, -980216726},
                                                                               {1906191570, -988999351},
                                                                               {1901620084, -997761031},
                                                                               {1897008325, -1006501581},
                                                                               {1892356392, -1015220816},
                                                                               {1887664383, -1023918550},
                                                                               {1882932397, -1032594600},
                                                                               {1878160535, -1041248781},
                                                                               {1873348897, -1049880912},
                                                                               {1868497586, -1058490808},
                                                                               {1863606704, -1067078288},
                                                                               {1858676355, -1075643169},
                                                                               {1853706643, -1084185270},
                                                                               {1848697674, -1092704411},
                                                                               {1843649553, -1101200410},
                                                                               {1838562388, -1109673089},
                                                                               {1833436286, -1118122267},
                                                                               {1828271356, -1126547765},
                                                                               {1823067707, -1134949406},
                                                                               {1817825449, -1143327011},
                                                                               {1812544694, -1151680403},
                                                                               {1807225553, -1160009405},
                                                                               {1801868139, -1168313840},
                                                                               {1796472565, -1176593533},
                                                                               {1791038946, -1184848308},
                                                                               {1785567396, -1193077991},
                                                                               {1780058032, -1201282407},
                                                                               {1774510970, -1209461382},
                                                                               {1768926328, -1217614743},
                                                                               {1763304224, -1225742318},
                                                                               {1757644777, -1233843935},
                                                                               {1751948107, -1241919421},
                                                                               {1746214334, -1249968606},
                                                                               {1740443581, -1257991320},
                                                                               {1734635968, -1265987392},
                                                                               {1728791620, -1273956653},
                                                                               {1722910659, -1281898935},
                                                                               {1716993211, -1289814068},
                                                                               {1711039401, -1297701886},
                                                                               {1705049355, -1305562222},
                                                                               {1699023199, -1313394909},
                                                                               {1692961062, -1321199781},
                                                                               {1686863072, -1328976672},
                                                                               {1680729357, -1336725419},
                                                                               {1674560049, -1344445857},
                                                                               {1668355276, -1352137822},
                                                                               {1662115172, -1359801152},
                                                                               {1655839867, -1367435685},
                                                                               {1649529496, -1375041258},
                                                                               {1643184191, -1382617710},
                                                                               {1636804087, -1390164882},
                                                                               {1630389319, -1397682613},
                                                                               {1623940023, -1405170745},
                                                                               {1617456335, -1412629117},
                                                                               {1610938393, -1420057574},
                                                                               {1604386335, -1427455956},
                                                                               {1597800299, -1434824109},
                                                                               {1591180426, -1442161874},
                                                                               {1584526854, -1449469098},
                                                                               {1577839726, -1456745625},
                                                                               {1571119183, -1463991302},
                                                                               {1564365367, -1471205974},
                                                                               {1557578421, -1478389489},
                                                                               {1550758488, -1485541696},
                                                                               {1543905714, -1492662441},
                                                                               {1537020244, -1499751576},
                                                                               {1530102222, -1506808949},
                                                                               {1523151797, -1513834411},
                                                                               {1516169114, -1520827813},
                                                                               {1509154322, -1527789007},
                                                                               {1502107570, -1534717846},
                                                                               {1495029006, -1541614183},
                                                                               {1487918781, -1548477872},
                                                                               {1480777044, -1555308768},
                                                                               {1473603949, -1562106725},
                                                                               {1466399645, -1568871601},
                                                                               {1459164286, -1575603251},
                                                                               {1451898025, -1582301533},
                                                                               {1444601017, -1588966306},
                                                                               {1437273414, -1595597428},
                                                                               {1429915374, -1602194758},
                                                                               {1422527051, -1608758157},
                                                                               {1415108601, -1615287487},
                                                                               {1407660183, -1621782608},
                                                                               {1400181954, -1628243383},
                                                                               {1392674072, -1634669676},
                                                                               {1385136696, -1641061349},
                                                                               {1377569986, -1647418269},
                                                                               {1369974101, -1653740300},
                                                                               {1362349204, -1660027308},
                                                                               {1354695455, -1666279161},
                                                                               {1347013017, -1672495725},
                                                                               {1339302052, -1678676870},
                                                                               {1331562723, -1684822463},
                                                                               {1323795195, -1690932376},
                                                                               {1315999631, -1697006479},
                                                                               {1308176198, -1703044642},
                                                                               {1300325060, -1709046739},
                                                                               {1292446384, -1715012642},
                                                                               {1284540337, -1720942225},
                                                                               {1276607086, -1726835361},
                                                                               {1268646800, -1732691928},
                                                                               {1260659646, -1738511799},
                                                                               {1252645794, -1744294853},
                                                                               {1244605414, -1750040966},
                                                                               {1236538675, -1755750017},
                                                                               {1228445750, -1761421885},
                                                                               {1220326809, -1767056450},
                                                                               {1212182024, -1772653593},
                                                                               {1204011567, -1778213194},
                                                                               {1195815612, -1783735137},
                                                                               {1187594332, -1789219305},
                                                                               {1179347902, -1794665580},
                                                                               {1171076495, -1800073849},
                                                                               {1162780288, -1805443995},
                                                                               {1154459456, -1810775906},
                                                                               {1146114174, -1816069469},
                                                                               {1137744621, -1821324572},
                                                                               {1129350972, -1826541103},
                                                                               {1120933406, -1831718951},
                                                                               {1112492101, -1836858008},
                                                                               {1104027237, -1841958164},
                                                                               {1095538991, -1847019312},
                                                                               {1087027544, -1852041343},
                                                                               {1078493076, -1857024153},
                                                                               {1069935768, -1861967634},
                                                                               {1061355801, -1866871683},
                                                                               {1052753357, -1871736196},
                                                                               {1044128617, -1876561070},
                                                                               {1035481766, -1881346202},
                                                                               {1026812985, -1886091491},
                                                                               {1018122458, -1890796837},
                                                                               {1009410370, -1895462140},
                                                                               {1000676905, -1900087301},
                                                                               {991922248, -1904672222},
                                                                               {983146583, -1909216806},
                                                                               {974350098, -1913720958},
                                                                               {965532978, -1918184581},
                                                                               {956695411, -1922607581},
                                                                               {947837582, -1926989864},
                                                                               {938959681, -1931331338},
                                                                               {930061894, -1935631910},
                                                                               {921144411, -1939891490},
                                                                               {912207419, -1944109987},
                                                                               {903251110, -1948287312},
                                                                               {894275671, -1952423377},
                                                                               {885281293, -1956518093},
                                                                               {876268167, -1960571375},
                                                                               {867236484, -1964583136},
                                                                               {858186435, -1968553292},
                                                                               {849118210, -1972481757},
                                                                               {840032004, -1976368450},
                                                                               {830928007, -1980213288},
                                                                               {821806413, -1984016189},
                                                                               {812667415, -1987777073},
                                                                               {803511207, -1991495860},
                                                                               {794337982, -1995172471},
                                                                               {785147934, -1998806829},
                                                                               {775941259, -2002398857},
                                                                               {766718151, -2005948478},
                                                                               {757478806, -2009455617},
                                                                               {748223418, -2012920201},
                                                                               {738952186, -2016342155},
                                                                               {729665303, -2019721407},
                                                                               {720362968, -2023057887},
                                                                               {711045377, -2026351522},
                                                                               {701712728, -2029602243},
                                                                               {692365218, -2032809982},
                                                                               {683003045, -2035974670},
                                                                               {673626408, -2039096241},
                                                                               {664235505, -2042174628},
                                                                               {654830535, -2045209767},
                                                                               {645411696, -2048201592},
                                                                               {635979190, -2051150040},
                                                                               {626533215, -2054055050},
                                                                               {617073971, -2056916560},
                                                                               {607601658, -2059734508},
                                                                               {598116479, -2062508835},
                                                                               {588618632, -2065239484},
                                                                               {579108320, -2067926394},
                                                                               {569585743, -2070569511},
                                                                               {560051104, -2073168777},
                                                                               {550504604, -2075724139},
                                                                               {540946445, -2078235540},
                                                                               {531376831, -2080702930},
                                                                               {521795963, -2083126254},
                                                                               {512204045, -2085505463},
                                                                               {502601279, -2087840505},
                                                                               {492987869, -2090131331},
                                                                               {483364019, -2092377892},
                                                                               {473729932, -2094580142},
                                                                               {464085813, -2096738032},
                                                                               {454431865, -2098851519},
                                                                               {444768294, -2100920556},
                                                                               {435095303, -2102945101},
                                                                               {425413098, -2104925109},
                                                                               {415721883, -2106860540},
                                                                               {406021865, -2108751352},
                                                                               {396313247, -2110597505},
                                                                               {386596237, -2112398960},
                                                                               {376871039, -2114155680},
                                                                               {367137861, -2115867626},
                                                                               {357396906, -2117534762},
                                                                               {347648383, -2119157054},
                                                                               {337892498, -2120734467},
                                                                               {328129457, -2122266967},
                                                                               {318359466, -2123754522},
                                                                               {308582734, -2125197100},
                                                                               {298799466, -2126594672},
                                                                               {289009871, -2127947206},
                                                                               {279214155, -2129254676},
                                                                               {269412525, -2130517052},
                                                                               {259605191, -2131734309},
                                                                               {249792358, -2132906420},
                                                                               {239974235, -2134033361},
                                                                               {230151030, -2135115107},
                                                                               {220322951, -2136151637},
                                                                               {210490206, -2137142927},
                                                                               {200653003, -2138088958},
                                                                               {190811551, -2138989708},
                                                                               {180966058, -2139845159},
                                                                               {171116733, -2140655293},
                                                                               {161263783, -2141420092},
                                                                               {151407418, -2142139541},
                                                                               {141547847, -2142813624},
                                                                               {131685278, -2143442326},
                                                                               {121819921, -2144025635},
                                                                               {111951983, -2144563539},
                                                                               {102081675, -2145056025},
                                                                               {92209205, -2145503083},
                                                                               {82334782, -2145904705},
                                                                               {72458615, -2146260881},
                                                                               {62580914, -2146571603},
                                                                               {52701887, -2146836866},
                                                                               {42821744, -2147056664},
                                                                               {32940695, -2147230991},
                                                                               {23058947, -2147359845},
                                                                               {13176712, -2147443222},
                                                                               {3294197, -2147481121},
                                                                               {-6588387, -2147473542},
                                                                               {-16470832, -2147420483},
                                                                               {-26352928, -2147321946},
                                                                               {-36234466, -2147177934},
                                                                               {-46115236, -2146988450},
                                                                               {-55995030, -2146753497},
                                                                               {-65873638, -2146473080},
                                                                               {-75750851, -2146147205},
                                                                               {-85626460, -2145775880},
                                                                               {-95500255, -2145359112},
                                                                               {-105372028, -2144896910},
                                                                               {-115241570, -2144389283},
                                                                               {-125108670, -2143836244},
                                                                               {-134973122, -2143237802},
                                                                               {-144834714, -2142593971},
                                                                               {-154693240, -2141904764},
                                                                               {-164548489, -2141170197},
                                                                               {-174400254, -2140390284},
                                                                               {-184248325, -2139565043},
                                                                               {-194092495, -2138694490},
                                                                               {-203932553, -2137778644},
                                                                               {-213768293, -2136817525},
                                                                               {-223599506, -2135811153},
                                                                               {-233425984, -2134759548},
                                                                               {-243247518, -2133662734},
                                                                               {-253063900, -2132520734},
                                                                               {-262874923, -2131333572},
                                                                               {-272680379, -2130101272},
                                                                               {-282480061, -2128823862},
                                                                               {-292273760, -2127501367},
                                                                               {-302061269, -2126133817},
                                                                               {-311842381, -2124721240},
                                                                               {-321616889, -2123263666},
                                                                               {-331384586, -2121761126},
                                                                               {-341145265, -2120213651},
                                                                               {-350898719, -2118621275},
                                                                               {-360644742, -2116984031},
                                                                               {-370383128, -2115301954},
                                                                               {-380113669, -2113575080},
                                                                               {-389836160, -2111803444},
                                                                               {-399550396, -2109987085},
                                                                               {-409256170, -2108126041},
                                                                               {-418953276, -2106220352},
                                                                               {-428641511, -2104270057},
                                                                               {-438320667, -2102275199},
                                                                               {-447990541, -2100235819},
                                                                               {-457650927, -2098151960},
                                                                               {-467301622, -2096023667},
                                                                               {-476942419, -2093850985},
                                                                               {-486573117, -2091633960},
                                                                               {-496193509, -2089372638},
                                                                               {-505803394, -2087067068},
                                                                               {-515402566, -2084717298},
                                                                               {-524990824, -2082323379},
                                                                               {-534567963, -2079885360},
                                                                               {-544133781, -2077403294},
                                                                               {-553688076, -2074877233},
                                                                               {-563230645, -2072307231},
                                                                               {-572761285, -2069693342},
                                                                               {-582279796, -2067035621},
                                                                               {-591785976, -2064334124},
                                                                               {-601279623, -2061588910},
                                                                               {-610760536, -2058800036},
                                                                               {-620228514, -2055967560},
                                                                               {-629683357, -2053091544},
                                                                               {-639124865, -2050172048},
                                                                               {-648552838, -2047209133},
                                                                               {-657967075, -2044202863},
                                                                               {-667367379, -2041153301},
                                                                               {-676753549, -2038060512},
                                                                               {-686125387, -2034924562},
                                                                               {-695482694, -2031745516},
                                                                               {-704825272, -2028523442},
                                                                               {-714152924, -2025258408},
                                                                               {-723465451, -2021950484},
                                                                               {-732762657, -2018599739},
                                                                               {-742044345, -2015206245},
                                                                               {-751310318, -2011770073},
                                                                               {-760560380, -2008291295},
                                                                               {-769794334, -2004769987},
                                                                               {-779011986, -2001206222},
                                                                               {-788213141, -1997600076},
                                                                               {-797397602, -1993951625},
                                                                               {-806565177, -1990260946},
                                                                               {-815715670, -1986528118},
                                                                               {-824848888, -1982753220},
                                                                               {-833964638, -1978936331},
                                                                               {-843062726, -1975077532},
                                                                               {-852142959, -1971176906},
                                                                               {-861205147, -1967234535},
                                                                               {-870249095, -1963250501},
                                                                               {-879274614, -1959224890},
                                                                               {-888281512, -1955157788},
                                                                               {-897269597, -1951049279},
                                                                               {-906238681, -1946899451},
                                                                               {-915188572, -1942708392},
                                                                               {-924119082, -1938476190},
                                                                               {-933030021, -1934202936},
                                                                               {-941921200, -1929888720},
                                                                               {-950792431, -1925533633},
                                                                               {-959643527, -1921137767},
                                                                               {-968474300, -1916701216},
                                                                               {-977284562, -1912224073},
                                                                               {-986074127, -1907706433},
                                                                               {-994842810, -1903148392},
                                                                               {-1003590424, -1898550047},
                                                                               {-1012316784, -1893911494},
                                                                               {-1021021705, -1889232832},
                                                                               {-1029705004, -1884514161},
                                                                               {-1038366495, -1879755580},
                                                                               {-1047005996, -1874957189},
                                                                               {-1055623324, -1870119091},
                                                                               {-1064218296, -1865241388},
                                                                               {-1072790730, -1860324183},
                                                                               {-1081340445, -1855367581},
                                                                               {-1089867259, -1850371686},
                                                                               {-1098370993, -1845336604},
                                                                               {-1106851465, -1840262441},
                                                                               {-1115308496, -1835149306},
                                                                               {-1123741908, -1829997307},
                                                                               {-1132151521, -1824806552},
                                                                               {-1140537158, -1819577151},
                                                                               {-1148898640, -1814309216},
                                                                               {-1157235792, -1809002858},
                                                                               {-1165548435, -1803658189},
                                                                               {-1173836395, -1798275323},
                                                                               {-1182099496, -1792854372},
                                                                               {-1190337562, -1787395453},
                                                                               {-1198550419, -1781898681},
                                                                               {-1206737894, -1776364172},
                                                                               {-1214899813, -1770792044},
                                                                               {-1223036002, -1765182414},
                                                                               {-1231146291, -1759535401},
                                                                               {-1239230506, -1753851126},
                                                                               {-1247288478, -1748129707},
                                                                               {-1255320034, -1742371267},
                                                                               {-1263325005, -1736575927},
                                                                               {-1271303222, -1730743810},
                                                                               {-1279254516, -1724875040},
                                                                               {-1287178717, -1718969740},
                                                                               {-1295075659, -1713028037},
                                                                               {-1302945174, -1707050055},
                                                                               {-1310787095, -1701035922},
                                                                               {-1318601257, -1694985765},
                                                                               {-1326387494, -1688899711},
                                                                               {-1334145641, -1682777890},
                                                                               {-1341875533, -1676620432},
                                                                               {-1349577007, -1670427466},
                                                                               {-1357249901, -1664199124},
                                                                               {-1364894050, -1657935539},
                                                                               {-1372509294, -1651636841},
                                                                               {-1380095472, -1645303166},
                                                                               {-1387652422, -1638934646},
                                                                               {-1395179984, -1632531418},
                                                                               {-1402678000, -1626093616},
                                                                               {-1410146309, -1619621377},
                                                                               {-1417584755, -1613114838},
                                                                               {-1424993180, -1606574136},
                                                                               {-1432371426, -1599999411},
                                                                               {-1439719338, -1593390801},
                                                                               {-1447036760, -1586748447},
                                                                               {-1454323536, -1580072489},
                                                                               {-1461579514, -1573363068},
                                                                               {-1468804538, -1566620327},
                                                                               {-1475998456, -1559844408},
                                                                               {-1483161115, -1553035455},
                                                                               {-1490292364, -1546193612},
                                                                               {-1497392053, -1539319024},
                                                                               {-1504460029, -1532411837},
                                                                               {-1511496145, -1525472197},
                                                                               {-1518500250, -1518500250},
                                                                               {-1525472197, -1511496145},
                                                                               {-1532411837, -1504460029},
                                                                               {-1539319024, -1497392053},
                                                                               {-1546193612, -1490292364},
                                                                               {-1553035455, -1483161115},
                                                                               {-1559844408, -1475998456},
                                                                               {-1566620327, -1468804538},
                                                                               {-1573363068, -1461579514},
                                                                               {-1580072489, -1454323536},
                                                                               {-1586748447, -1447036760},
                                                                               {-1593390801, -1439719338},
                                                                               {-1599999411, -1432371426},
                                                                               {-1606574136, -1424993180},
                                                                               {-1613114838, -1417584755},
                                                                               {-1619621377, -1410146309},
                                                                               {-1626093616, -1402678000},
                                                                               {-1632531418, -1395179984},
                                                                               {-1638934646, -1387652422},
                                                                               {-1645303166, -1380095472},
                                                                               {-1651636841, -1372509294},
                                                                               {-1657935539, -1364894050},
                                                                               {-1664199124, -1357249901},
                                                                               {-1670427466, -1349577007},
                                                                               {-1676620432, -1341875533},
                                                                               {-1682777890, -1334145641},
                                                                               {-1688899711, -1326387494},
                                                                               {-1694985765, -1318601257},
                                                                               {-1701035922, -1310787095},
                                                                               {-1707050055, -1302945174},
                                                                               {-1713028037, -1295075659},
                                                                               {-1718969740, -1287178717},
                                                                               {-1724875040, -1279254516},
                                                                               {-1730743810, -1271303222},
                                                                               {-1736575927, -1263325005},
                                                                               {-1742371267, -1255320034},
                                                                               {-1748129707, -1247288478},
                                                                               {-1753851126, -1239230506},
                                                                               {-1759535401, -1231146291},
                                                                               {-1765182414, -1223036002},
                                                                               {-1770792044, -1214899813},
                                                                               {-1776364172, -1206737894},
                                                                               {-1781898681, -1198550419},
                                                                               {-1787395453, -1190337562},
                                                                               {-1792854372, -1182099496},
                                                                               {-1798275323, -1173836395},
                                                                               {-1803658189, -1165548435},
                                                                               {-1809002858, -1157235792},
                                                                               {-1814309216, -1148898640},
                                                                               {-1819577151, -1140537158},
                                                                               {-1824806552, -1132151521},
                                                                               {-1829997307, -1123741908},
                                                                               {-1835149306, -1115308496},
                                                                               {-1840262441, -1106851465},
                                                                               {-1845336604, -1098370993},
                                                                               {-1850371686, -1089867259},
                                                                               {-1855367581, -1081340445},
                                                                               {-1860324183, -1072790730},
                                                                               {-1865241388, -1064218296},
                                                                               {-1870119091, -1055623324},
                                                                               {-1874957189, -1047005996},
                                                                               {-1879755580, -1038366495},
                                                                               {-1884514161, -1029705004},
                                                                               {-1889232832, -1021021705},
                                                                               {-1893911494, -1012316784},
                                                                               {-1898550047, -1003590424},
                                                                               {-1903148392, -994842810},
                                                                               {-1907706433, -986074127},
                                                                               {-1912224073, -977284562},
                                                                               {-1916701216, -968474300},
                                                                               {-1921137767, -959643527},
                                                                               {-1925533633, -950792431},
                                                                               {-1929888720, -941921200},
                                                                               {-1934202936, -933030021},
                                                                               {-1938476190, -924119082},
                                                                               {-1942708392, -915188572},
                                                                               {-1946899451, -906238681},
                                                                               {-1951049279, -897269597},
                                                                               {-1955157788, -888281512},
                                                                               {-1959224890, -879274614},
                                                                               {-1963250501, -870249095},
                                                                               {-1967234535, -861205147},
                                                                               {-1971176906, -852142959},
                                                                               {-1975077532, -843062726},
                                                                               {-1978936331, -833964638},
                                                                               {-1982753220, -824848888},
                                                                               {-1986528118, -815715670},
                                                                               {-1990260946, -806565177},
                                                                               {-1993951625, -797397602},
                                                                               {-1997600076, -788213141},
                                                                               {-2001206222, -779011986},
                                                                               {-2004769987, -769794334},
                                                                               {-2008291295, -760560380},
                                                                               {-2011770073, -751310318},
                                                                               {-2015206245, -742044345},
                                                                               {-2018599739, -732762657},
                                                                               {-2021950484, -723465451},
                                                                               {-2025258408, -714152924},
                                                                               {-2028523442, -704825272},
                                                                               {-2031745516, -695482694},
                                                                               {-2034924562, -686125387},
                                                                               {-2038060512, -676753549},
                                                                               {-2041153301, -667367379},
                                                                               {-2044202863, -657967075},
                                                                               {-2047209133, -648552838},
                                                                               {-2050172048, -639124865},
                                                                               {-2053091544, -629683357},
                                                                               {-2055967560, -620228514},
                                                                               {-2058800036, -610760536},
                                                                               {-2061588910, -601279623},
                                                                               {-2064334124, -591785976},
                                                                               {-2067035621, -582279796},
                                                                               {-2069693342, -572761285},
                                                                               {-2072307231, -563230645},
                                                                               {-2074877233, -553688076},
                                                                               {-2077403294, -544133781},
                                                                               {-2079885360, -534567963},
                                                                               {-2082323379, -524990824},
                                                                               {-2084717298, -515402566},
                                                                               {-2087067068, -505803394},
                                                                               {-2089372638, -496193509},
                                                                               {-2091633960, -486573117},
                                                                               {-2093850985, -476942419},
                                                                               {-2096023667, -467301622},
                                                                               {-2098151960, -457650927},
                                                                               {-2100235819, -447990541},
                                                                               {-2102275199, -438320667},
                                                                               {-2104270057, -428641511},
                                                                               {-2106220352, -418953276},
                                                                               {-2108126041, -409256170},
                                                                               {-2109987085, -399550396},
                                                                               {-2111803444, -389836160},
                                                                               {-2113575080, -380113669},
                                                                               {-2115301954, -370383128},
                                                                               {-2116984031, -360644742},
                                                                               {-2118621275, -350898719},
                                                                               {-2120213651, -341145265},
                                                                               {-2121761126, -331384586},
                                                                               {-2123263666, -321616889},
                                                                               {-2124721240, -311842381},
                                                                               {-2126133817, -302061269},
                                                                               {-2127501367, -292273760},
                                                                               {-2128823862, -282480061},
                                                                               {-2130101272, -272680379},
                                                                               {-2131333572, -262874923},
                                                                               {-2132520734, -253063900},
                                                                               {-2133662734, -243247518},
                                                                               {-2134759548, -233425984},
                                                                               {-2135811153, -223599506},
                                                                               {-2136817525, -213768293},
                                                                               {-2137778644, -203932553},
                                                                               {-2138694490, -194092495},
                                                                               {-2139565043, -184248325},
                                                                               {-2140390284, -174400254},
                                                                               {-2141170197, -164548489},
                                                                               {-2141904764, -154693240},
                                                                               {-2142593971, -144834714},
                                                                               {-2143237802, -134973122},
                                                                               {-2143836244, -125108670},
                                                                               {-2144389283, -115241570},
                                                                               {-2144896910, -105372028},
                                                                               {-2145359112, -95500255},
                                                                               {-2145775880, -85626460},
                                                                               {-2146147205, -75750851},
                                                                               {-2146473080, -65873638},
                                                                               {-2146753497, -55995030},
                                                                               {-2146988450, -46115236},
                                                                               {-2147177934, -36234466},
                                                                               {-2147321946, -26352928},
                                                                               {-2147420483, -16470832},
                                                                               {-2147473542, -6588387},
                                                                               {-2147481121, 3294197},
                                                                               {-2147443222, 13176712},
                                                                               {-2147359845, 23058947},
                                                                               {-2147230991, 32940695},
                                                                               {-2147056664, 42821744},
                                                                               {-2146836866, 52701887},
                                                                               {-2146571603, 62580914},
                                                                               {-2146260881, 72458615},
                                                                               {-2145904705, 82334782},
                                                                               {-2145503083, 92209205},
                                                                               {-2145056025, 102081675},
                                                                               {-2144563539, 111951983},
                                                                               {-2144025635, 121819921},
                                                                               {-2143442326, 131685278},
                                                                               {-2142813624, 141547847},
                                                                               {-2142139541, 151407418},
                                                                               {-2141420092, 161263783},
                                                                               {-2140655293, 171116733},
                                                                               {-2139845159, 180966058},
                                                                               {-2138989708, 190811551},
                                                                               {-2138088958, 200653003},
                                                                               {-2137142927, 210490206},
                                                                               {-2136151637, 220322951},
                                                                               {-2135115107, 230151030},
                                                                               {-2134033361, 239974235},
                                                                               {-2132906420, 249792358},
                                                                               {-2131734309, 259605191},
                                                                               {-2130517052, 269412525},
                                                                               {-2129254676, 279214155},
                                                                               {-2127947206, 289009871},
                                                                               {-2126594672, 298799466},
                                                                               {-2125197100, 308582734},
                                                                               {-2123754522, 318359466},
                                                                               {-2122266967, 328129457},
                                                                               {-2120734467, 337892498},
                                                                               {-2119157054, 347648383},
                                                                               {-2117534762, 357396906},
                                                                               {-2115867626, 367137861},
                                                                               {-2114155680, 376871039},
                                                                               {-2112398960, 386596237},
                                                                               {-2110597505, 396313247},
                                                                               {-2108751352, 406021865},
                                                                               {-2106860540, 415721883},
                                                                               {-2104925109, 425413098},
                                                                               {-2102945101, 435095303},
                                                                               {-2100920556, 444768294},
                                                                               {-2098851519, 454431865},
                                                                               {-2096738032, 464085813},
                                                                               {-2094580142, 473729932},
                                                                               {-2092377892, 483364019},
                                                                               {-2090131331, 492987869},
                                                                               {-2087840505, 502601279},
                                                                               {-2085505463, 512204045},
                                                                               {-2083126254, 521795963},
                                                                               {-2080702930, 531376831},
                                                                               {-2078235540, 540946445},
                                                                               {-2075724139, 550504604},
                                                                               {-2073168777, 560051104},
                                                                               {-2070569511, 569585743},
                                                                               {-2067926394, 579108320},
                                                                               {-2065239484, 588618632},
                                                                               {-2062508835, 598116479},
                                                                               {-2059734508, 607601658},
                                                                               {-2056916560, 617073971},
                                                                               {-2054055050, 626533215},
                                                                               {-2051150040, 635979190},
                                                                               {-2048201592, 645411696},
                                                                               {-2045209767, 654830535},
                                                                               {-2042174628, 664235505},
                                                                               {-2039096241, 673626408},
                                                                               {-2035974670, 683003045},
                                                                               {-2032809982, 692365218},
                                                                               {-2029602243, 701712728},
                                                                               {-2026351522, 711045377},
                                                                               {-2023057887, 720362968},
                                                                               {-2019721407, 729665303},
                                                                               {-2016342155, 738952186},
                                                                               {-2012920201, 748223418},
                                                                               {-2009455617, 757478806},
                                                                               {-2005948478, 766718151},
                                                                               {-2002398857, 775941259},
                                                                               {-1998806829, 785147934},
                                                                               {-1995172471, 794337982},
                                                                               {-1991495860, 803511207},
                                                                               {-1987777073, 812667415},
                                                                               {-1984016189, 821806413},
                                                                               {-1980213288, 830928007},
                                                                               {-1976368450, 840032004},
                                                                               {-1972481757, 849118210},
                                                                               {-1968553292, 858186435},
                                                                               {-1964583136, 867236484},
                                                                               {-1960571375, 876268167},
                                                                               {-1956518093, 885281293},
                                                                               {-1952423377, 894275671},
                                                                               {-1948287312, 903251110},
                                                                               {-1944109987, 912207419},
                                                                               {-1939891490, 921144411},
                                                                               {-1935631910, 930061894},
                                                                               {-1931331338, 938959681},
                                                                               {-1926989864, 947837582},
                                                                               {-1922607581, 956695411},
                                                                               {-1918184581, 965532978},
                                                                               {-1913720958, 974350098},
                                                                               {-1909216806, 983146583},
                                                                               {-1904672222, 991922248},
                                                                               {-1900087301, 1000676905},
                                                                               {-1895462140, 1009410370},
                                                                               {-1890796837, 1018122458},
                                                                               {-1886091491, 1026812985},
                                                                               {-1881346202, 1035481766},
                                                                               {-1876561070, 1044128617},
                                                                               {-1871736196, 1052753357},
                                                                               {-1866871683, 1061355801},
                                                                               {-1861967634, 1069935768},
                                                                               {-1857024153, 1078493076},
                                                                               {-1852041343, 1087027544},
                                                                               {-1847019312, 1095538991},
                                                                               {-1841958164, 1104027237},
                                                                               {-1836858008, 1112492101},
                                                                               {-1831718951, 1120933406},
                                                                               {-1826541103, 1129350972},
                                                                               {-1821324572, 1137744621},
                                                                               {-1816069469, 1146114174},
                                                                               {-1810775906, 1154459456},
                                                                               {-1805443995, 1162780288},
                                                                               {-1800073849, 1171076495},
                                                                               {-1794665580, 1179347902},
                                                                               {-1789219305, 1187594332},
                                                                               {-1783735137, 1195815612},
                                                                               {-1778213194, 1204011567},
                                                                               {-1772653593, 1212182024},
                                                                               {-1767056450, 1220326809},
                                                                               {-1761421885, 1228445750},
                                                                               {-1755750017, 1236538675},
                                                                               {-1750040966, 1244605414},
                                                                               {-1744294853, 1252645794},
                                                                               {-1738511799, 1260659646},
                                                                               {-1732691928, 1268646800},
                                                                               {-1726835361, 1276607086},
                                                                               {-1720942225, 1284540337},
                                                                               {-1715012642, 1292446384},
                                                                               {-1709046739, 1300325060},
                                                                               {-1703044642, 1308176198},
                                                                               {-1697006479, 1315999631},
                                                                               {-1690932376, 1323795195},
                                                                               {-1684822463, 1331562723},
                                                                               {-1678676870, 1339302052},
                                                                               {-1672495725, 1347013017},
                                                                               {-1666279161, 1354695455},
                                                                               {-1660027308, 1362349204},
                                                                               {-1653740300, 1369974101},
                                                                               {-1647418269, 1377569986},
                                                                               {-1641061349, 1385136696},
                                                                               {-1634669676, 1392674072},
                                                                               {-1628243383, 1400181954},
                                                                               {-1621782608, 1407660183},
                                                                               {-1615287487, 1415108601},
                                                                               {-1608758157, 1422527051},
                                                                               {-1602194758, 1429915374},
                                                                               {-1595597428, 1437273414},
                                                                               {-1588966306, 1444601017},
                                                                               {-1582301533, 1451898025},
                                                                               {-1575603251, 1459164286},
                                                                               {-1568871601, 1466399645},
                                                                               {-1562106725, 1473603949},
                                                                               {-1555308768, 1480777044},
                                                                               {-1548477872, 1487918781},
                                                                               {-1541614183, 1495029006},
                                                                               {-1534717846, 1502107570},
                                                                               {-1527789007, 1509154322},
                                                                               {-1520827813, 1516169114},
                                                                               {-1513834411, 1523151797},
                                                                               {-1506808949, 1530102222},
                                                                               {-1499751576, 1537020244},
                                                                               {-1492662441, 1543905714},
                                                                               {-1485541696, 1550758488},
                                                                               {-1478389489, 1557578421},
                                                                               {-1471205974, 1564365367},
                                                                               {-1463991302, 1571119183},
                                                                               {-1456745625, 1577839726},
                                                                               {-1449469098, 1584526854},
                                                                               {-1442161874, 1591180426},
                                                                               {-1434824109, 1597800299},
                                                                               {-1427455956, 1604386335},
                                                                               {-1420057574, 1610938393},
                                                                               {-1412629117, 1617456335},
                                                                               {-1405170745, 1623940023},
                                                                               {-1397682613, 1630389319},
                                                                               {-1390164882, 1636804087},
                                                                               {-1382617710, 1643184191},
                                                                               {-1375041258, 1649529496},
                                                                               {-1367435685, 1655839867},
                                                                               {-1359801152, 1662115172},
                                                                               {-1352137822, 1668355276},
                                                                               {-1344445857, 1674560049},
                                                                               {-1336725419, 1680729357},
                                                                               {-1328976672, 1686863072},
                                                                               {-1321199781, 1692961062},
                                                                               {-1313394909, 1699023199},
                                                                               {-1305562222, 1705049355},
                                                                               {-1297701886, 1711039401},
                                                                               {-1289814068, 1716993211},
                                                                               {-1281898935, 1722910659},
                                                                               {-1273956653, 1728791620},
                                                                               {-1265987392, 1734635968},
                                                                               {-1257991320, 1740443581},
                                                                               {-1249968606, 1746214334},
                                                                               {-1241919421, 1751948107},
                                                                               {-1233843935, 1757644777},
                                                                               {-1225742318, 1763304224},
                                                                               {-1217614743, 1768926328},
                                                                               {-1209461382, 1774510970},
                                                                               {-1201282407, 1780058032},
                                                                               {-1193077991, 1785567396},
                                                                               {-1184848308, 1791038946},
                                                                               {-1176593533, 1796472565},
                                                                               {-1168313840, 1801868139},
                                                                               {-1160009405, 1807225553},
                                                                               {-1151680403, 1812544694},
                                                                               {-1143327011, 1817825449},
                                                                               {-1134949406, 1823067707},
                                                                               {-1126547765, 1828271356},
                                                                               {-1118122267, 1833436286},
                                                                               {-1109673089, 1838562388},
                                                                               {-1101200410, 1843649553},
                                                                               {-1092704411, 1848697674},
                                                                               {-1084185270, 1853706643},
                                                                               {-1075643169, 1858676355},
                                                                               {-1067078288, 1863606704},
                                                                               {-1058490808, 1868497586},
                                                                               {-1049880912, 1873348897},
                                                                               {-1041248781, 1878160535},
                                                                               {-1032594600, 1882932397},
                                                                               {-1023918550, 1887664383},
                                                                               {-1015220816, 1892356392},
                                                                               {-1006501581, 1897008325},
                                                                               {-997761031, 1901620084},
                                                                               {-988999351, 1906191570},
                                                                               {-980216726, 1910722688},
                                                                               {-971413342, 1915213340},
                                                                               {-962589385, 1919663432},
                                                                               {-953745043, 1924072871},
                                                                               {-944880503, 1928441561},
                                                                               {-935995952, 1932769411},
                                                                               {-927091579, 1937056329},
                                                                               {-918167572, 1941302225},
                                                                               {-909224120, 1945507008},
                                                                               {-900261413, 1949670589},
                                                                               {-891279640, 1953792881},
                                                                               {-882278992, 1957873796},
                                                                               {-873259659, 1961913246},
                                                                               {-864221832, 1965911148},
                                                                               {-855165703, 1969867417},
                                                                               {-846091463, 1973781967},
                                                                               {-836999305, 1977654717},
                                                                               {-827889422, 1981485585},
                                                                               {-818762005, 1985274489},
                                                                               {-809617249, 1989021350},
                                                                               {-800455346, 1992726087},
                                                                               {-791276492, 1996388622},
                                                                               {-782080880, 2000008879},
                                                                               {-772868706, 2003586779},
                                                                               {-763640164, 2007122248},
                                                                               {-754395449, 2010615210},
                                                                               {-745134758, 2014065592},
                                                                               {-735858287, 2017473321},
                                                                               {-726566232, 2020838323},
                                                                               {-717258790, 2024160529},
                                                                               {-707936158, 2027439867},
                                                                               {-698598533, 2030676269},
                                                                               {-689246113, 2033869665},
                                                                               {-679879097, 2037019988},
                                                                               {-670497682, 2040127172},
                                                                               {-661102068, 2043191150},
                                                                               {-651692453, 2046211857},
                                                                               {-642269036, 2049189231},
                                                                               {-632832018, 2052123207},
                                                                               {-623381598, 2055013723},
                                                                               {-613917975, 2057860719},
                                                                               {-604441352, 2060664133},
                                                                               {-594951927, 2063423908},
                                                                               {-585449903, 2066139983},
                                                                               {-575935480, 2068812302},
                                                                               {-566408860, 2071440808},
                                                                               {-556870245, 2074025446},
                                                                               {-547319836, 2076566160},
                                                                               {-537757837, 2079062896},
                                                                               {-528184449, 2081515603},
                                                                               {-518599875, 2083924228},
                                                                               {-509004318, 2086288720},
                                                                               {-499397982, 2088609029},
                                                                               {-489781069, 2090885105},
                                                                               {-480153784, 2093116901},
                                                                               {-470516330, 2095304370},
                                                                               {-460868912, 2097447464},
                                                                               {-451211734, 2099546139},
                                                                               {-441545000, 2101600350},
                                                                               {-431868915, 2103610054},
                                                                               {-422183684, 2105575208},
                                                                               {-412489512, 2107495770},
                                                                               {-402786604, 2109371700},
                                                                               {-393075166, 2111202959},
                                                                               {-383355404, 2112989506},
                                                                               {-373627523, 2114731305},
                                                                               {-363891730, 2116428319},
                                                                               {-354148230, 2118080511},
                                                                               {-344397230, 2119687847},
                                                                               {-334638936, 2121250292},
                                                                               {-324873555, 2122767814},
                                                                               {-315101295, 2124240380},
                                                                               {-305322361, 2125667960},
                                                                               {-295536961, 2127050522},
                                                                               {-285745302, 2128388038},
                                                                               {-275947592, 2129680480},
                                                                               {-266144038, 2130927819},
                                                                               {-256334847, 2132130030},
                                                                               {-246520228, 2133287087},
                                                                               {-236700388, 2134398966},
                                                                               {-226875535, 2135465642},
                                                                               {-217045878, 2136487095},
                                                                               {-207211624, 2137463301},
                                                                               {-197372981, 2138394240},
                                                                               {-187530159, 2139279892},
                                                                               {-177683365, 2140120240},
                                                                               {-167832808, 2140915264},
                                                                               {-157978697, 2141664948},
                                                                               {-148121241, 2142369276},
                                                                               {-138260647, 2143028234},
                                                                               {-128397125, 2143641807},
                                                                               {-118530885, 2144209982},
                                                                               {-108662134, 2144732748},
                                                                               {-98791081, 2145210092},
                                                                               {-88917937, 2145642006},
                                                                               {-79042909, 2146028480},
                                                                               {-69166208, 2146369505},
                                                                               {-59288042, 2146665076},
                                                                               {-49408620, 2146915184},
                                                                               {-39528151, 2147119825},
                                                                               {-29646846, 2147278995},
                                                                               {-19764913, 2147392690},
                                                                               {-9882561, 2147460908}};

alignas(__ALIGN_BYTE_SIZE__) const cint32 fft_lut_cint31_r4_1_2[8] = {
    {1073741824, 0}, {-1073741824, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}};

alignas(__ALIGN_BYTE_SIZE__) const cint32 fft_lut_cint31_r4_2_4[8] = {
    {1073741824, 0}, {-759250125, -759250125}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}};

alignas(__ALIGN_BYTE_SIZE__) const cint32 fft_lut_cint31_r4_4_8[8] = {
    {1073741824, 0}, {410903207, -992008094}, {-759250125, -759250125}, {-992008094, 410903207}, {0, 0}, {0, 0}, {0, 0},
    {0, 0}};

alignas(__ALIGN_BYTE_SIZE__) const cint32 fft_lut_cint31_r4_8_16[8] = {
    {1073741824, 0},          {892783698, -596538995},   {410903207, -992008094}, {-209476638, -1053110176},
    {-759250125, -759250125}, {-1053110176, -209476638}, {-992008094, 410903207}, {-596538995, 892783698}};

alignas(__ALIGN_BYTE_SIZE__) const cint32 fft_lut_cint31_r4_16_32[16] = {
    {1073741824, 0},          {1027506862, -311690799}, {892783698, -596538995},   {681174602, -830013654},
    {410903207, -992008094},  {105245103, -1068571464}, {-209476638, -1053110176}, {-506158392, -946955747},
    {-759250125, -759250125}, {-946955747, -506158392}, {-1053110176, -209476638}, {-1068571464, 105245103},
    {-992008094, 410903207},  {-830013654, 681174602},  {-596538995, 892783698},   {-311690799, 1027506862}};

alignas(__ALIGN_BYTE_SIZE__) const cint32 fft_lut_cint31_r4_32_64[32] = {
    {1073741824, 0},           {1062120190, -157550647},  {1027506862, -311690799}, {970651112, -459083786},
    {892783698, -596538995},   {795590213, -721080937},   {681174602, -830013654},  {552013618, -920979082},
    {410903207, -992008094},   {260897982, -1041563127},  {105245103, -1068571464}, {-52686014, -1072448455},
    {-209476638, -1053110176}, {-361732726, -1010975242}, {-506158392, -946955747}, {-639627258, -862437520},
    {-759250125, -759250125},  {-862437520, -639627258},  {-946955747, -506158392}, {-1010975242, -361732726},
    {-1053110176, -209476638}, {-1072448455, -52686014},  {-1068571464, 105245103}, {-1041563127, 260897982},
    {-992008094, 410903207},   {-920979082, 552013618},   {-830013654, 681174602},  {-721080937, 795590213},
    {-596538995, 892783698},   {-459083786, 970651112},   {-311690799, 1027506862}, {-157550647, 1062120190}};

alignas(__ALIGN_BYTE_SIZE__) const cint32 fft_lut_cint31_r4_64_128[64] = {
    {1073741824, 0},           {1070832474, -78989349},   {1062120190, -157550647},  {1047652185, -235258165},
    {1027506862, -311690799},  {1001793390, -386434353},  {970651112, -459083786},   {934248793, -529245404},
    {892783698, -596538995},   {846480531, -660599890},   {795590213, -721080937},   {740388522, -777654384},
    {681174602, -830013654},   {618269338, -877875009},   {552013618, -920979082},   {482766489, -959092290},
    {410903207, -992008094},   {336813204, -1019548121},  {260897982, -1041563127},  {183568930, -1057933813},
    {105245103, -1068571464},  {26350943, -1073418433},   {-52686014, -1072448455},  {-131437462, -1065666786},
    {-209476638, -1053110176}, {-286380643, -1034846671}, {-361732726, -1010975242}, {-435124548, -981625251},
    {-506158392, -946955747},  {-574449320, -907154608},  {-639627258, -862437520},  {-701339000, -813046808},
    {-759250125, -759250125},  {-813046808, -701339000},  {-862437520, -639627258},  {-907154608, -574449320},
    {-946955747, -506158392},  {-981625251, -435124548},  {-1010975242, -361732726}, {-1034846671, -286380643},
    {-1053110176, -209476638}, {-1065666786, -131437462}, {-1072448455, -52686014},  {-1073418433, 26350943},
    {-1068571464, 105245103},  {-1057933813, 183568930},  {-1041563127, 260897982},  {-1019548121, 336813204},
    {-992008094, 410903207},   {-959092290, 482766489},   {-920979082, 552013618},   {-877875009, 618269338},
    {-830013654, 681174602},   {-777654384, 740388522},   {-721080937, 795590213},   {-660599890, 846480531},
    {-596538995, 892783698},   {-529245404, 934248793},   {-459083786, 970651112},   {-386434353, 1001793390},
    {-311690799, 1027506862},  {-235258165, 1047652185},  {-157550647, 1062120190},  {-78989349, 1070832474}};

alignas(__ALIGN_BYTE_SIZE__) const cint32 fft_lut_cint31_r4_128_256[128] = {
    {1073741824, 0},           {1073014240, -39521455},   {1070832474, -78989349},   {1067199483, -118350194},
    {1062120190, -157550647},  {1055601479, -196537583},  {1047652185, -235258165},  {1038283080, -273659918},
    {1027506862, -311690799},  {1015338134, -349299266},  {1001793390, -386434353},  {986890984, -423045732},
    {970651112, -459083786},   {953095785, -494499676},   {934248793, -529245404},   {914135678, -563273883},
    {892783698, -596538995},   {870221790, -628995660},   {846480531, -660599890},   {821592095, -691308855},
    {795590213, -721080937},   {768510122, -749875788},   {740388522, -777654384},   {711263525, -804379079},
    {681174602, -830013654},   {650162530, -854523370},   {618269338, -877875009},   {585538248, -900036924},
    {552013618, -920979082},   {517740883, -940673101},   {482766489, -959092290},   {447137835, -976211688},
    {410903207, -992008094},   {374111709, -1006460100},  {336813204, -1019548121},  {299058239, -1031254418},
    {260897982, -1041563127},  {222384147, -1050460278},  {183568930, -1057933813},  {144504935, -1063973603},
    {105245103, -1068571464},  {65842639, -1071721163},   {26350943, -1073418433},   {-13176464, -1073660973},
    {-52686014, -1072448455},  {-92124163, -1069782521},  {-131437462, -1065666786}, {-170572633, -1060106826},
    {-209476638, -1053110176}, {-248096755, -1044686319}, {-286380643, -1034846671}, {-324276419, -1023604567},
    {-361732726, -1010975242}, {-398698801, -996975812},  {-435124548, -981625251},  {-470960600, -964944360},
    {-506158392, -946955747},  {-540670223, -927683790},  {-574449320, -907154608},  {-607449906, -885396022},
    {-639627258, -862437520},  {-670937767, -838310216},  {-701339000, -813046808},  {-730789757, -786681534},
    {-759250125, -759250125},  {-786681534, -730789757},  {-813046808, -701339000},  {-838310216, -670937767},
    {-862437520, -639627258},  {-885396022, -607449906},  {-907154608, -574449320},  {-927683790, -540670223},
    {-946955747, -506158392},  {-964944360, -470960600},  {-981625251, -435124548},  {-996975812, -398698801},
    {-1010975242, -361732726}, {-1023604567, -324276419}, {-1034846671, -286380643}, {-1044686319, -248096755},
    {-1053110176, -209476638}, {-1060106826, -170572633}, {-1065666786, -131437462}, {-1069782521, -92124163},
    {-1072448455, -52686014},  {-1073660973, -13176464},  {-1073418433, 26350943},   {-1071721163, 65842639},
    {-1068571464, 105245103},  {-1063973603, 144504935},  {-1057933813, 183568930},  {-1050460278, 222384147},
    {-1041563127, 260897982},  {-1031254418, 299058239},  {-1019548121, 336813204},  {-1006460100, 374111709},
    {-992008094, 410903207},   {-976211688, 447137835},   {-959092290, 482766489},   {-940673101, 517740883},
    {-920979082, 552013618},   {-900036924, 585538248},   {-877875009, 618269338},   {-854523370, 650162530},
    {-830013654, 681174602},   {-804379079, 711263525},   {-777654384, 740388522},   {-749875788, 768510122},
    {-721080937, 795590213},   {-691308855, 821592095},   {-660599890, 846480531},   {-628995660, 870221790},
    {-596538995, 892783698},   {-563273883, 914135678},   {-529245404, 934248793},   {-494499676, 953095785},
    {-459083786, 970651112},   {-423045732, 986890984},   {-386434353, 1001793390},  {-349299266, 1015338134},
    {-311690799, 1027506862},  {-273659918, 1038283080},  {-235258165, 1047652185},  {-196537583, 1055601479},
    {-157550647, 1062120190},  {-118350194, 1067199483},  {-78989349, 1070832474},   {-39521455, 1073014240}};

alignas(__ALIGN_BYTE_SIZE__) const cint32 fft_lut_cint31_r4_256_512[256] = {
    {1073741824, 0},           {1073559913, -19764076},   {1073014240, -39521455},   {1072104991, -59265442},
    {1070832474, -78989349},   {1069197120, -98686491},   {1067199483, -118350194},  {1064840240, -137973796},
    {1062120190, -157550647},  {1059040255, -177074115},  {1055601479, -196537583},  {1051805027, -215934457},
    {1047652185, -235258165},  {1043144360, -254502159},  {1038283080, -273659918},  {1033069992, -292724951},
    {1027506862, -311690799},  {1021595575, -330551034},  {1015338134, -349299266},  {1008736660, -367929144},
    {1001793390, -386434353},  {994510675, -404808624},   {986890984, -423045732},   {978936898, -441139496},
    {970651112, -459083786},   {962036435, -476872522},   {953095785, -494499676},   {943832191, -511959275},
    {934248793, -529245404},   {924348837, -546352205},   {914135678, -563273883},   {903612776, -580004702},
    {892783698, -596538995},   {881652112, -612871159},   {870221790, -628995660},   {858496606, -644907034},
    {846480531, -660599890},   {834177638, -676068911},   {821592095, -691308855},   {808728167, -706314559},
    {795590213, -721080937},   {782182683, -735602987},   {768510122, -749875788},   {754577161, -763894504},
    {740388522, -777654384},   {725949013, -791150767},   {711263525, -804379079},   {696337036, -817334838},
    {681174602, -830013654},   {665781362, -842411232},   {650162530, -854523370},   {634323400, -866345964},
    {618269338, -877875009},   {602005783, -889106597},   {585538248, -900036924},   {568872310, -910662286},
    {552013618, -920979082},   {534967884, -930983817},   {517740883, -940673101},   {500338453, -950043650},
    {482766489, -959092290},   {465030947, -967815955},   {447137835, -976211688},   {429093217, -984276646},
    {410903207, -992008094},   {392573967, -999403415},   {374111709, -1006460100},  {355522689, -1013175761},
    {336813204, -1019548121},  {317989595, -1025575020},  {299058239, -1031254418},  {280025552, -1036584389},
    {260897982, -1041563127},  {241682010, -1046188946},  {222384147, -1050460278},  {203010932, -1054375676},
    {183568930, -1057933813},  {164064728, -1061133483},  {144504935, -1063973603},  {124896179, -1066453210},
    {105245103, -1068571464},  {85558366, -1070327646},   {65842639, -1071721163},   {46104602, -1072751542},
    {26350943, -1073418433},   {6588356, -1073721611},    {-13176464, -1073660973},  {-32936819, -1073236540},
    {-52686014, -1072448455},  {-72417357, -1071296985},  {-92124163, -1069782521},  {-111799753, -1067905576},
    {-131437462, -1065666786}, {-151030634, -1063066909}, {-170572633, -1060106826}, {-190056834, -1056787540},
    {-209476638, -1053110176}, {-228825464, -1049075980}, {-248096755, -1044686319}, {-267283981, -1039942680},
    {-286380643, -1034846671}, {-305380268, -1029400018}, {-324276419, -1023604567}, {-343062693, -1017462281},
    {-361732726, -1010975242}, {-380280190, -1004145648}, {-398698801, -996975812},  {-416982319, -989468165},
    {-435124548, -981625251},  {-453119340, -973449725},  {-470960600, -964944360},  {-488642281, -956112036},
    {-506158392, -946955747},  {-523502998, -937478595},  {-540670223, -927683790},  {-557654248, -917574653},
    {-574449320, -907154608},  {-591049748, -896427186},  {-607449906, -885396022},  {-623644239, -874064853},
    {-639627258, -862437520},  {-655393548, -850517961},  {-670937767, -838310216},  {-686254647, -825818421},
    {-701339000, -813046808},  {-716185713, -799999706},  {-730789757, -786681534},  {-745146182, -773096806},
    {-759250125, -759250125},  {-773096806, -745146182},  {-786681534, -730789757},  {-799999706, -716185713},
    {-813046808, -701339000},  {-825818421, -686254647},  {-838310216, -670937767},  {-850517961, -655393548},
    {-862437520, -639627258},  {-874064853, -623644239},  {-885396022, -607449906},  {-896427186, -591049748},
    {-907154608, -574449320},  {-917574653, -557654248},  {-927683790, -540670223},  {-937478595, -523502998},
    {-946955747, -506158392},  {-956112036, -488642281},  {-964944360, -470960600},  {-973449725, -453119340},
    {-981625251, -435124548},  {-989468165, -416982319},  {-996975812, -398698801},  {-1004145648, -380280190},
    {-1010975242, -361732726}, {-1017462281, -343062693}, {-1023604567, -324276419}, {-1029400018, -305380268},
    {-1034846671, -286380643}, {-1039942680, -267283981}, {-1044686319, -248096755}, {-1049075980, -228825464},
    {-1053110176, -209476638}, {-1056787540, -190056834}, {-1060106826, -170572633}, {-1063066909, -151030634},
    {-1065666786, -131437462}, {-1067905576, -111799753}, {-1069782521, -92124163},  {-1071296985, -72417357},
    {-1072448455, -52686014},  {-1073236540, -32936819},  {-1073660973, -13176464},  {-1073721611, 6588356},
    {-1073418433, 26350943},   {-1072751542, 46104602},   {-1071721163, 65842639},   {-1070327646, 85558366},
    {-1068571464, 105245103},  {-1066453210, 124896179},  {-1063973603, 144504935},  {-1061133483, 164064728},
    {-1057933813, 183568930},  {-1054375676, 203010932},  {-1050460278, 222384147},  {-1046188946, 241682010},
    {-1041563127, 260897982},  {-1036584389, 280025552},  {-1031254418, 299058239},  {-1025575020, 317989595},
    {-1019548121, 336813204},  {-1013175761, 355522689},  {-1006460100, 374111709},  {-999403415, 392573967},
    {-992008094, 410903207},   {-984276646, 429093217},   {-976211688, 447137835},   {-967815955, 465030947},
    {-959092290, 482766489},   {-950043650, 500338453},   {-940673101, 517740883},   {-930983817, 534967884},
    {-920979082, 552013618},   {-910662286, 568872310},   {-900036924, 585538248},   {-889106597, 602005783},
    {-877875009, 618269338},   {-866345964, 634323400},   {-854523370, 650162530},   {-842411232, 665781362},
    {-830013654, 681174602},   {-817334838, 696337036},   {-804379079, 711263525},   {-791150767, 725949013},
    {-777654384, 740388522},   {-763894504, 754577161},   {-749875788, 768510122},   {-735602987, 782182683},
    {-721080937, 795590213},   {-706314559, 808728167},   {-691308855, 821592095},   {-676068911, 834177638},
    {-660599890, 846480531},   {-644907034, 858496606},   {-628995660, 870221790},   {-612871159, 881652112},
    {-596538995, 892783698},   {-580004702, 903612776},   {-563273883, 914135678},   {-546352205, 924348837},
    {-529245404, 934248793},   {-511959275, 943832191},   {-494499676, 953095785},   {-476872522, 962036435},
    {-459083786, 970651112},   {-441139496, 978936898},   {-423045732, 986890984},   {-404808624, 994510675},
    {-386434353, 1001793390},  {-367929144, 1008736660},  {-349299266, 1015338134},  {-330551034, 1021595575},
    {-311690799, 1027506862},  {-292724951, 1033069992},  {-273659918, 1038283080},  {-254502159, 1043144360},
    {-235258165, 1047652185},  {-215934457, 1051805027},  {-196537583, 1055601479},  {-177074115, 1059040255},
    {-157550647, 1062120190},  {-137973796, 1064840240},  {-118350194, 1067199483},  {-98686491, 1069197120},
    {-78989349, 1070832474},   {-59265442, 1072104991},   {-39521455, 1073014240},   {-19764076, 1073559913}};

alignas(__ALIGN_BYTE_SIZE__) const cint32 fft_lut_cint31_r4_512_1024[512] = {
    {1073741824, 0},           {1073696345, -9882456},    {1073559913, -19764076},   {1073332538, -29644021},
    {1073014240, -39521455},   {1072605046, -49395541},   {1072104991, -59265442},   {1071514117, -69130324},
    {1070832474, -78989349},   {1070060120, -88841683},   {1069197120, -98686491},   {1068243547, -108522939},
    {1067199483, -118350194},  {1066065015, -128167423},  {1064840240, -137973796},  {1063525261, -147768480},
    {1062120190, -157550647},  {1060625146, -167319468},  {1059040255, -177074115},  {1057365653, -186813762},
    {1055601479, -196537583},  {1053747885, -206244756},  {1051805027, -215934457},  {1049773069, -225605867},
    {1047652185, -235258165},  {1045442553, -244890535},  {1043144360, -254502159},  {1040757802, -264092224},
    {1038283080, -273659918},  {1035720404, -283204430},  {1033069992, -292724951},  {1030332067, -302220676},
    {1027506862, -311690799},  {1024594615, -321134518},  {1021595575, -330551034},  {1018509994, -339939549},
    {1015338134, -349299266},  {1012080264, -358629395},  {1008736660, -367929144},  {1005307605, -377197725},
    {1001793390, -386434353},  {998194311, -395638246},   {994510675, -404808624},   {990742793, -413944711},
    {986890984, -423045732},   {982955574, -432110916},   {978936898, -441139496},   {974835295, -450130706},
    {970651112, -459083786},   {966384706, -467997976},   {962036435, -476872522},   {957606670, -485706671},
    {953095785, -494499676},   {948504163, -503250791},   {943832191, -511959275},   {939080267, -520624391},
    {934248793, -529245404},   {929338177, -537821584},   {924348837, -546352205},   {919281194, -554836544},
    {914135678, -563273883},   {908912725, -571663506},   {903612776, -580004702},   {898236282, -588296766},
    {892783698, -596538995},   {887255485, -604730691},   {881652112, -612871159},   {875974054, -620959711},
    {870221790, -628995660},   {864395810, -636978327},   {858496606, -644907034},   {852524677, -652781111},
    {846480531, -660599890},   {840364679, -668362709},   {834177638, -676068911},   {827919934, -683717842},
    {821592095, -691308855},   {815194659, -698841307},   {808728167, -706314559},   {802193167, -713727978},
    {795590213, -721080937},   {788919863, -728372813},   {782182683, -735602987},   {775379244, -742770848},
    {768510122, -749875788},   {761575898, -756917205},   {754577161, -763894504},   {747514503, -770807092},
    {740388522, -777654384},   {733199822, -784435800},   {725949013, -791150767},   {718636707, -797798714},
    {711263525, -804379079},   {703830092, -810891304},   {696337036, -817334838},   {688784993, -823709135},
    {681174602, -830013654},   {673506508, -836247863},   {665781362, -842411232},   {657999816, -848503239},
    {650162530, -854523370},   {642270169, -860471112},   {634323400, -866345964},   {626322897, -872147426},
    {618269338, -877875009},   {610163404, -883528225},   {602005783, -889106597},   {593797166, -894609652},
    {585538248, -900036924},   {577229728, -905387953},   {568872310, -910662286},   {560466703, -915859476},
    {552013618, -920979082},   {543513772, -926020672},   {534967884, -930983817},   {526376678, -935868098},
    {517740883, -940673101},   {509061229, -945398418},   {500338453, -950043650},   {491573292, -954608403},
    {482766489, -959092290},   {473918791, -963494932},   {465030947, -967815955},   {456103710, -972054994},
    {447137835, -976211688},   {438134084, -980285688},   {429093217, -984276646},   {420016002, -988184225},
    {410903207, -992008094},   {401755603, -995747930},   {392573967, -999403415},   {383359076, -1002974239},
    {374111709, -1006460100},  {364832652, -1009860704},  {355522689, -1013175761},  {346182609, -1016404991},
    {336813204, -1019548121},  {327415267, -1022604883},  {317989595, -1025575020},  {308536985, -1028458280},
    {299058239, -1031254418},  {289554160, -1033963197},  {280025552, -1036584389},  {270473223, -1039117770},
    {260897982, -1041563127},  {251300640, -1043920252},  {241682010, -1046188946},  {232042906, -1048369016},
    {222384147, -1050460278},  {212706549, -1052462555},  {203010932, -1054375676},  {193298119, -1056199480},
    {183568930, -1057933813},  {173824192, -1059578527},  {164064728, -1061133483},  {154291367, -1062598550},
    {144504935, -1063973603},  {134706263, -1065258526},  {124896179, -1066453210},  {115075515, -1067557554},
    {105245103, -1068571464},  {95405776, -1069494854},   {85558366, -1070327646},   {75703709, -1071069770},
    {65842639, -1071721163},   {55975992, -1072281769},   {46104602, -1072751542},   {36229307, -1073130440},
    {26350943, -1073418433},   {16470347, -1073615496},   {6588356, -1073721611},    {-3294193, -1073736771},
    {-13176464, -1073660973},  {-23057618, -1073494225},  {-32936819, -1073236540},  {-42813230, -1072887940},
    {-52686014, -1072448455},  {-62554335, -1071918122},  {-72417357, -1071296985},  {-82274245, -1070585099},
    {-92124163, -1069782521},  {-101966277, -1068889322}, {-111799753, -1067905576}, {-121623759, -1066831367},
    {-131437462, -1065666786}, {-141240030, -1064411931}, {-151030634, -1063066909}, {-160808445, -1061631833},
    {-170572633, -1060106826}, {-180322371, -1058492016}, {-190056834, -1056787540}, {-199775198, -1054993543},
    {-209476638, -1053110176}, {-219160334, -1051137599}, {-228825464, -1049075980}, {-238471210, -1046925492},
    {-248096755, -1044686319}, {-257701283, -1042358649}, {-267283981, -1039942680}, {-276844038, -1037438617},
    {-286380643, -1034846671}, {-295892988, -1032167062}, {-305380268, -1029400018}, {-314841679, -1026545772},
    {-324276419, -1023604567}, {-333683689, -1020576651}, {-343062693, -1017462281}, {-352412636, -1014261721},
    {-361732726, -1010975242}, {-371022173, -1007603122}, {-380280190, -1004145648}, {-389505993, -1000603111},
    {-398698801, -996975812},  {-407857835, -993264059},  {-416982319, -989468165},  {-426071480, -985588453},
    {-435124548, -981625251},  {-444140756, -977578894},  {-453119340, -973449725},  {-462059541, -969238095},
    {-470960600, -964944360},  {-479821764, -960568883},  {-488642281, -956112036},  {-497421405, -951574196},
    {-506158392, -946955747},  {-514852502, -942257081},  {-523502998, -937478595},  {-532109148, -932620694},
    {-540670223, -927683790},  {-549185496, -922668302},  {-557654248, -917574653},  {-566075761, -912403276},
    {-574449320, -907154608},  {-582774218, -901829095},  {-591049748, -896427186},  {-599275210, -890949341},
    {-607449906, -885396022},  {-615573145, -879767701},  {-623644239, -874064853},  {-631662503, -868287963},
    {-639627258, -862437520},  {-647537830, -856514019},  {-655393548, -850517961},  {-663193747, -844449856},
    {-670937767, -838310216},  {-678624950, -832099562},  {-686254647, -825818421},  {-693826211, -819467323},
    {-701339000, -813046808},  {-708792378, -806557419},  {-716185713, -799999706},  {-723518380, -793374223},
    {-730789757, -786681534},  {-737999228, -779922204},  {-745146182, -773096806},  {-752230015, -766205919},
    {-759250125, -759250125},  {-766205919, -752230015},  {-773096806, -745146182},  {-779922204, -737999228},
    {-786681534, -730789757},  {-793374223, -723518380},  {-799999706, -716185713},  {-806557419, -708792378},
    {-813046808, -701339000},  {-819467323, -693826211},  {-825818421, -686254647},  {-832099562, -678624950},
    {-838310216, -670937767},  {-844449856, -663193747},  {-850517961, -655393548},  {-856514019, -647537830},
    {-862437520, -639627258},  {-868287963, -631662503},  {-874064853, -623644239},  {-879767701, -615573145},
    {-885396022, -607449906},  {-890949341, -599275210},  {-896427186, -591049748},  {-901829095, -582774218},
    {-907154608, -574449320},  {-912403276, -566075761},  {-917574653, -557654248},  {-922668302, -549185496},
    {-927683790, -540670223},  {-932620694, -532109148},  {-937478595, -523502998},  {-942257081, -514852502},
    {-946955747, -506158392},  {-951574196, -497421405},  {-956112036, -488642281},  {-960568883, -479821764},
    {-964944360, -470960600},  {-969238095, -462059541},  {-973449725, -453119340},  {-977578894, -444140756},
    {-981625251, -435124548},  {-985588453, -426071480},  {-989468165, -416982319},  {-993264059, -407857835},
    {-996975812, -398698801},  {-1000603111, -389505993}, {-1004145648, -380280190}, {-1007603122, -371022173},
    {-1010975242, -361732726}, {-1014261721, -352412636}, {-1017462281, -343062693}, {-1020576651, -333683689},
    {-1023604567, -324276419}, {-1026545772, -314841679}, {-1029400018, -305380268}, {-1032167062, -295892988},
    {-1034846671, -286380643}, {-1037438617, -276844038}, {-1039942680, -267283981}, {-1042358649, -257701283},
    {-1044686319, -248096755}, {-1046925492, -238471210}, {-1049075980, -228825464}, {-1051137599, -219160334},
    {-1053110176, -209476638}, {-1054993543, -199775198}, {-1056787540, -190056834}, {-1058492016, -180322371},
    {-1060106826, -170572633}, {-1061631833, -160808445}, {-1063066909, -151030634}, {-1064411931, -141240030},
    {-1065666786, -131437462}, {-1066831367, -121623759}, {-1067905576, -111799753}, {-1068889322, -101966277},
    {-1069782521, -92124163},  {-1070585099, -82274245},  {-1071296985, -72417357},  {-1071918122, -62554335},
    {-1072448455, -52686014},  {-1072887940, -42813230},  {-1073236540, -32936819},  {-1073494225, -23057618},
    {-1073660973, -13176464},  {-1073736771, -3294193},   {-1073721611, 6588356},    {-1073615496, 16470347},
    {-1073418433, 26350943},   {-1073130440, 36229307},   {-1072751542, 46104602},   {-1072281769, 55975992},
    {-1071721163, 65842639},   {-1071069770, 75703709},   {-1070327646, 85558366},   {-1069494854, 95405776},
    {-1068571464, 105245103},  {-1067557554, 115075515},  {-1066453210, 124896179},  {-1065258526, 134706263},
    {-1063973603, 144504935},  {-1062598550, 154291367},  {-1061133483, 164064728},  {-1059578527, 173824192},
    {-1057933813, 183568930},  {-1056199480, 193298119},  {-1054375676, 203010932},  {-1052462555, 212706549},
    {-1050460278, 222384147},  {-1048369016, 232042906},  {-1046188946, 241682010},  {-1043920252, 251300640},
    {-1041563127, 260897982},  {-1039117770, 270473223},  {-1036584389, 280025552},  {-1033963197, 289554160},
    {-1031254418, 299058239},  {-1028458280, 308536985},  {-1025575020, 317989595},  {-1022604883, 327415267},
    {-1019548121, 336813204},  {-1016404991, 346182609},  {-1013175761, 355522689},  {-1009860704, 364832652},
    {-1006460100, 374111709},  {-1002974239, 383359076},  {-999403415, 392573967},   {-995747930, 401755603},
    {-992008094, 410903207},   {-988184225, 420016002},   {-984276646, 429093217},   {-980285688, 438134084},
    {-976211688, 447137835},   {-972054994, 456103710},   {-967815955, 465030947},   {-963494932, 473918791},
    {-959092290, 482766489},   {-954608403, 491573292},   {-950043650, 500338453},   {-945398418, 509061229},
    {-940673101, 517740883},   {-935868098, 526376678},   {-930983817, 534967884},   {-926020672, 543513772},
    {-920979082, 552013618},   {-915859476, 560466703},   {-910662286, 568872310},   {-905387953, 577229728},
    {-900036924, 585538248},   {-894609652, 593797166},   {-889106597, 602005783},   {-883528225, 610163404},
    {-877875009, 618269338},   {-872147426, 626322897},   {-866345964, 634323400},   {-860471112, 642270169},
    {-854523370, 650162530},   {-848503239, 657999816},   {-842411232, 665781362},   {-836247863, 673506508},
    {-830013654, 681174602},   {-823709135, 688784993},   {-817334838, 696337036},   {-810891304, 703830092},
    {-804379079, 711263525},   {-797798714, 718636707},   {-791150767, 725949013},   {-784435800, 733199822},
    {-777654384, 740388522},   {-770807092, 747514503},   {-763894504, 754577161},   {-756917205, 761575898},
    {-749875788, 768510122},   {-742770848, 775379244},   {-735602987, 782182683},   {-728372813, 788919863},
    {-721080937, 795590213},   {-713727978, 802193167},   {-706314559, 808728167},   {-698841307, 815194659},
    {-691308855, 821592095},   {-683717842, 827919934},   {-676068911, 834177638},   {-668362709, 840364679},
    {-660599890, 846480531},   {-652781111, 852524677},   {-644907034, 858496606},   {-636978327, 864395810},
    {-628995660, 870221790},   {-620959711, 875974054},   {-612871159, 881652112},   {-604730691, 887255485},
    {-596538995, 892783698},   {-588296766, 898236282},   {-580004702, 903612776},   {-571663506, 908912725},
    {-563273883, 914135678},   {-554836544, 919281194},   {-546352205, 924348837},   {-537821584, 929338177},
    {-529245404, 934248793},   {-520624391, 939080267},   {-511959275, 943832191},   {-503250791, 948504163},
    {-494499676, 953095785},   {-485706671, 957606670},   {-476872522, 962036435},   {-467997976, 966384706},
    {-459083786, 970651112},   {-450130706, 974835295},   {-441139496, 978936898},   {-432110916, 982955574},
    {-423045732, 986890984},   {-413944711, 990742793},   {-404808624, 994510675},   {-395638246, 998194311},
    {-386434353, 1001793390},  {-377197725, 1005307605},  {-367929144, 1008736660},  {-358629395, 1012080264},
    {-349299266, 1015338134},  {-339939549, 1018509994},  {-330551034, 1021595575},  {-321134518, 1024594615},
    {-311690799, 1027506862},  {-302220676, 1030332067},  {-292724951, 1033069992},  {-283204430, 1035720404},
    {-273659918, 1038283080},  {-264092224, 1040757802},  {-254502159, 1043144360},  {-244890535, 1045442553},
    {-235258165, 1047652185},  {-225605867, 1049773069},  {-215934457, 1051805027},  {-206244756, 1053747885},
    {-196537583, 1055601479},  {-186813762, 1057365653},  {-177074115, 1059040255},  {-167319468, 1060625146},
    {-157550647, 1062120190},  {-147768480, 1063525261},  {-137973796, 1064840240},  {-128167423, 1066065015},
    {-118350194, 1067199483},  {-108522939, 1068243547},  {-98686491, 1069197120},   {-88841683, 1070060120},
    {-78989349, 1070832474},   {-69130324, 1071514117},   {-59265442, 1072104991},   {-49395541, 1072605046},
    {-39521455, 1073014240},   {-29644021, 1073332538},   {-19764076, 1073559913},   {-9882456, 1073696345}};

alignas(__ALIGN_BYTE_SIZE__) const cint32 fft_lut_cint31_r4_1024_2048[1024] = {
    {1073741824, 0},           {1073730454, -4941281},    {1073696345, -9882456},    {1073639498, -14823423},
    {1073559913, -19764076},   {1073457592, -24704310},   {1073332538, -29644021},   {1073184753, -34583104},
    {1073014240, -39521455},   {1072821003, -44458968},   {1072605046, -49395541},   {1072366374, -54331067},
    {1072104991, -59265442},   {1071820903, -64198563},   {1071514117, -69130324},   {1071184638, -74060620},
    {1070832474, -78989349},   {1070457632, -83916404},   {1070060120, -88841683},   {1069639946, -93765079},
    {1069197120, -98686491},   {1068731650, -103605812},  {1068243547, -108522939},  {1067732821, -113437768},
    {1067199483, -118350194},  {1066643544, -123260114},  {1066065015, -128167423},  {1065463909, -133072019},
    {1064840240, -137973796},  {1064194019, -142872651},  {1063525261, -147768480},  {1062833980, -152661180},
    {1062120190, -157550647},  {1061383907, -162436778},  {1060625146, -167319468},  {1059843923, -172198615},
    {1059040255, -177074115},  {1058214159, -181945865},  {1057365653, -186813762},  {1056494753, -191677702},
    {1055601479, -196537583},  {1054685850, -201393302},  {1053747885, -206244756},  {1052787604, -211091842},
    {1051805027, -215934457},  {1050800175, -220772500},  {1049773069, -225605867},  {1048723732, -230434456},
    {1047652185, -235258165},  {1046558451, -240076892},  {1045442553, -244890535},  {1044304514, -249698991},
    {1043144360, -254502159},  {1041962114, -259299937},  {1040757802, -264092224},  {1039531448, -268878918},
    {1038283080, -273659918},  {1037012723, -278435122},  {1035720404, -283204430},  {1034406151, -287967740},
    {1033069992, -292724951},  {1031711954, -297475964},  {1030332067, -302220676},  {1028930359, -306958988},
    {1027506862, -311690799},  {1026061603, -316416009},  {1024594615, -321134518},  {1023105929, -325846226},
    {1021595575, -330551034},  {1020063586, -335248841},  {1018509994, -339939549},  {1016934832, -344623057},
    {1015338134, -349299266},  {1013719934, -353968079},  {1012080264, -358629395},  {1010419162, -363283116},
    {1008736660, -367929144},  {1007032796, -372567379},  {1005307605, -377197725},  {1003561124, -381820082},
    {1001793390, -386434353},  {1000004439, -391040440},  {998194311, -395638246},   {996363043, -400227673},
    {994510675, -404808624},   {992637245, -409381002},   {990742793, -413944711},   {988827359, -418499653},
    {986890984, -423045732},   {984933708, -427582852},   {982955574, -432110916},   {980956623, -436629829},
    {978936898, -441139496},   {976896441, -445639820},   {974835295, -450130706},   {972753504, -454612060},
    {970651112, -459083786},   {968528165, -463545789},   {966384706, -467997976},   {964220780, -472440251},
    {962036435, -476872522},   {959831716, -481294693},   {957606670, -485706671},   {955361344, -490108363},
    {953095785, -494499676},   {950810042, -498880516},   {948504163, -503250791},   {946178196, -507610408},
    {943832191, -511959275},   {941466198, -516297300},   {939080267, -520624391},   {936674448, -524940456},
    {934248793, -529245404},   {931803352, -533539144},   {929338177, -537821584},   {926853322, -542092635},
    {924348837, -546352205},   {921824777, -550600205},   {919281194, -554836544},   {916718143, -559061133},
    {914135678, -563273883},   {911533853, -567474703},   {908912725, -571663506},   {906272347, -575840202},
    {903612776, -580004702},   {900934069, -584156920},   {898236282, -588296766},   {895519473, -592424154},
    {892783698, -596538995},   {890029016, -600641203},   {887255485, -604730691},   {884463164, -608807372},
    {881652112, -612871159},   {878822389, -616921967},   {875974054, -620959711},   {873107167, -624984303},
    {870221790, -628995660},   {867317984, -632993696},   {864395810, -636978327},   {861455330, -640949467},
    {858496606, -644907034},   {855519701, -648850943},   {852524677, -652781111},   {849511600, -656697454},
    {846480531, -660599890},   {843431536, -664488336},   {840364679, -668362709},   {837280024, -672222928},
    {834177638, -676068911},   {831057586, -679900576},   {827919934, -683717842},   {824764748, -687520629},
    {821592095, -691308855},   {818402043, -695082441},   {815194659, -698841307},   {811970011, -702585372},
    {808728167, -706314559},   {805469196, -710028787},   {802193167, -713727978},   {798900150, -717412054},
    {795590213, -721080937},   {792263427, -724734549},   {788919863, -728372813},   {785559591, -731995651},
    {782182683, -735602987},   {778789210, -739194745},   {775379244, -742770848},   {771952857, -746331221},
    {768510122, -749875788},   {765051111, -753404474},   {761575898, -756917205},   {758084557, -760413906},
    {754577161, -763894504},   {751053785, -767358923},   {747514503, -770807092},   {743959390, -774238936},
    {740388522, -777654384},   {736801974, -781053363},   {733199822, -784435800},   {729582143, -787801625},
    {725949013, -791150767},   {722300508, -794483153},   {718636707, -797798714},   {714957687, -801097379},
    {711263525, -804379079},   {707554301, -807643743},   {703830092, -810891304},   {700090977, -814121692},
    {696337036, -817334838},   {692568348, -820530675},   {688784993, -823709135},   {684987051, -826870150},
    {681174602, -830013654},   {677347728, -833139580},   {673506508, -836247863},   {669651026, -839338435},
    {665781362, -842411232},   {661897597, -845466188},   {657999816, -848503239},   {654088099, -851522321},
    {650162530, -854523370},   {646223192, -857506321},   {642270169, -860471112},   {638303543, -863417681},
    {634323400, -866345964},   {630329823, -869255900},   {626322897, -872147426},   {622302707, -875020483},
    {618269338, -877875009},   {614222875, -880710943},   {610163404, -883528225},   {606091012, -886326796},
    {602005783, -889106597},   {597907806, -891867569},   {593797166, -894609652},   {589673951, -897332790},
    {585538248, -900036924},   {581390144, -902721998},   {577229728, -905387953},   {573057087, -908034735},
    {568872310, -910662286},   {564675486, -913270551},   {560466703, -915859476},   {556246051, -918429004},
    {552013618, -920979082},   {547769495, -923509656},   {543513772, -926020672},   {539246538, -928512076},
    {534967884, -930983817},   {530677900, -933435842},   {526376678, -935868098},   {522064309, -938280535},
    {517740883, -940673101},   {513406493, -943045745},   {509061229, -945398418},   {504705185, -947731070},
    {500338453, -950043650},   {495961124, -952336111},   {491573292, -954608403},   {487175049, -956860479},
    {482766489, -959092290},   {478347705, -961303790},   {473918791, -963494932},   {469479840, -965665669},
    {465030947, -967815955},   {460572205, -969945745},   {456103710, -972054994},   {451625555, -974143656},
    {447137835, -976211688},   {442640647, -978259047},   {438134084, -980285688},   {433618242, -982291568},
    {429093217, -984276646},   {424559105, -986240879},   {420016002, -988184225},   {415464004, -990106644},
    {410903207, -992008094},   {406333708, -993888536},   {401755603, -995747930},   {397168991, -997586236},
    {392573967, -999403415},   {387970630, -1001199428},  {383359076, -1002974239},  {378739403, -1004727809},
    {374111709, -1006460100},  {369476093, -1008171077},  {364832652, -1009860704},  {360181484, -1011528943},
    {355522689, -1013175761},  {350856364, -1014801122},  {346182609, -1016404991},  {341501523, -1017987335},
    {336813204, -1019548121},  {332117752, -1021087314},  {327415267, -1022604883},  {322705848, -1024100796},
    {317989595, -1025575020},  {313266607, -1027027525},  {308536985, -1028458280},  {303800829, -1029867254},
    {299058239, -1031254418},  {294309316, -1032619742},  {289554160, -1033963197},  {284792871, -1035284755},
    {280025552, -1036584389},  {275252302, -1037862069},  {270473223, -1039117770},  {265688415, -1040351465},
    {260897982, -1041563127},  {256102022, -1042752731},  {251300640, -1043920252},  {246493935, -1045065665},
    {241682010, -1046188946},  {236864966, -1047290071},  {232042906, -1048369016},  {227215933, -1049425759},
    {222384147, -1050460278},  {217547651, -1051472550},  {212706549, -1052462555},  {207860942, -1053430270},
    {203010932, -1054375676},  {198156624, -1055298753},  {193298119, -1056199480},  {188435520, -1057077840},
    {183568930, -1057933813},  {178698453, -1058767381},  {173824192, -1059578527},  {168946249, -1060367233},
    {164064728, -1061133483},  {159179733, -1061877261},  {154291367, -1062598550},  {149399733, -1063297336},
    {144504935, -1063973603},  {139607077, -1064627338},  {134706263, -1065258526},  {129802595, -1065867154},
    {124896179, -1066453210},  {119987118, -1067016680},  {115075515, -1067557554},  {110161476, -1068075818},
    {105245103, -1068571464},  {100326502, -1069044479},  {95405776, -1069494854},   {90483029, -1069922579},
    {85558366, -1070327646},   {80631892, -1070710046},   {75703709, -1071069770},   {70773924, -1071406812},
    {65842639, -1071721163},   {60909960, -1072012818},   {55975992, -1072281769},   {51040837, -1072528012},
    {46104602, -1072751542},   {41167391, -1072952352},   {36229307, -1073130440},   {31290457, -1073285802},
    {26350943, -1073418433},   {21410872, -1073528332},   {16470347, -1073615496},   {11529474, -1073679922},
    {6588356, -1073721611},    {1647099, -1073740561},    {-3294193, -1073736771},   {-8235416, -1073710241},
    {-13176464, -1073660973},  {-18117233, -1073588967},  {-23057618, -1073494225},  {-27997515, -1073376748},
    {-32936819, -1073236540},  {-37875426, -1073073603},  {-42813230, -1072887940},  {-47750128, -1072679556},
    {-52686014, -1072448455},  {-57620785, -1072194642},  {-62554335, -1071918122},  {-67486561, -1071618901},
    {-72417357, -1071296985},  {-77346620, -1070952382},  {-82274245, -1070585099},  {-87200127, -1070195142},
    {-92124163, -1069782521},  {-97046247, -1069347245},  {-101966277, -1068889322}, {-106884147, -1068408763},
    {-111799753, -1067905576}, {-116712992, -1067379774}, {-121623759, -1066831367}, {-126531950, -1066260367},
    {-131437462, -1065666786}, {-136340190, -1065050636}, {-141240030, -1064411931}, {-146136880, -1063750684},
    {-151030634, -1063066909}, {-155921191, -1062360620}, {-160808445, -1061631833}, {-165692293, -1060880563},
    {-170572633, -1060106826}, {-175449360, -1059310638}, {-180322371, -1058492016}, {-185191564, -1057650977},
    {-190056834, -1056787540}, {-194918080, -1055901722}, {-199775198, -1054993543}, {-204628085, -1054063021},
    {-209476638, -1053110176}, {-214320755, -1052135029}, {-219160334, -1051137599}, {-223995270, -1050117909},
    {-228825464, -1049075980}, {-233650811, -1048011834}, {-238471210, -1046925492}, {-243286558, -1045816980},
    {-248096755, -1044686319}, {-252901697, -1043533534}, {-257701283, -1042358649}, {-262495412, -1041161689},
    {-267283981, -1039942680}, {-272066891, -1038701647}, {-276844038, -1037438617}, {-281615322, -1036153615},
    {-286380643, -1034846671}, {-291139898, -1033517810}, {-295892988, -1032167062}, {-300639811, -1030794455},
    {-305380268, -1029400018}, {-310114257, -1027983780}, {-314841679, -1026545772}, {-319562433, -1025086024},
    {-324276419, -1023604567}, {-328983538, -1022101432}, {-333683689, -1020576651}, {-338376774, -1019030256},
    {-343062693, -1017462281}, {-347741347, -1015872758}, {-352412636, -1014261721}, {-357076462, -1012629204},
    {-361732726, -1010975242}, {-366381329, -1009299870}, {-371022173, -1007603122}, {-375655159, -1005885036},
    {-380280190, -1004145648}, {-384897167, -1002384994}, {-389505993, -1000603111}, {-394106570, -998800038},
    {-398698801, -996975812},  {-403282588, -995130473},  {-407857835, -993264059},  {-412424444, -991376610},
    {-416982319, -989468165},  {-421531363, -987538766},  {-426071480, -985588453},  {-430602573, -983617267},
    {-435124548, -981625251},  {-439637307, -979612445},  {-444140756, -977578894},  {-448634799, -975524639},
    {-453119340, -973449725},  {-457594286, -971354196},  {-462059541, -969238095},  {-466515010, -967101468},
    {-470960600, -964944360},  {-475396216, -962766816},  {-479821764, -960568883},  {-484237150, -958350608},
    {-488642281, -956112036},  {-493037064, -953853216},  {-497421405, -951574196},  {-501795212, -949275023},
    {-506158392, -946955747},  {-510510853, -944616416},  {-514852502, -942257081},  {-519183248, -939877790},
    {-523502998, -937478595},  {-527811662, -935059546},  {-532109148, -932620694},  {-536395365, -930162092},
    {-540670223, -927683790},  {-544933630, -925185843},  {-549185496, -922668302},  {-553425732, -920131221},
    {-557654248, -917574653},  {-561870954, -914998653},  {-566075761, -912403276},  {-570268579, -909788576},
    {-574449320, -907154608},  {-578617896, -904501429},  {-582774218, -901829095},  {-586918198, -899137661},
    {-591049748, -896427186},  {-595168781, -893697727},  {-599275210, -890949341},  {-603368947, -888182086},
    {-607449906, -885396022},  {-611518001, -882591207},  {-615573145, -879767701},  {-619615253, -876925563},
    {-623644239, -874064853},  {-627660017, -871185633},  {-631662503, -868287963},  {-635651611, -865371905},
    {-639627258, -862437520},  {-643589359, -859484870},  {-647537830, -856514019},  {-651472587, -853525028},
    {-655393548, -850517961},  {-659300629, -847492882},  {-663193747, -844449856},  {-667072820, -841388945},
    {-670937767, -838310216},  {-674788504, -835213733},  {-678624950, -832099562},  {-682447025, -828967769},
    {-686254647, -825818421},  {-690047736, -822651583},  {-693826211, -819467323},  {-697589992, -816265709},
    {-701339000, -813046808},  {-705073155, -809810688},  {-708792378, -806557419},  {-712496590, -803287068},
    {-716185713, -799999706},  {-719859669, -796695401},  {-723518380, -793374223},  {-727161768, -790036244},
    {-730789757, -786681534},  {-734402269, -783310163},  {-737999228, -779922204},  {-741580558, -776517728},
    {-745146182, -773096806},  {-748696026, -769659512},  {-752230015, -766205919},  {-755748072, -762736098},
    {-759250125, -759250125},  {-762736098, -755748072},  {-766205919, -752230015},  {-769659512, -748696026},
    {-773096806, -745146182},  {-776517728, -741580558},  {-779922204, -737999228},  {-783310163, -734402269},
    {-786681534, -730789757},  {-790036244, -727161768},  {-793374223, -723518380},  {-796695401, -719859669},
    {-799999706, -716185713},  {-803287068, -712496590},  {-806557419, -708792378},  {-809810688, -705073155},
    {-813046808, -701339000},  {-816265709, -697589992},  {-819467323, -693826211},  {-822651583, -690047736},
    {-825818421, -686254647},  {-828967769, -682447025},  {-832099562, -678624950},  {-835213733, -674788504},
    {-838310216, -670937767},  {-841388945, -667072820},  {-844449856, -663193747},  {-847492882, -659300629},
    {-850517961, -655393548},  {-853525028, -651472587},  {-856514019, -647537830},  {-859484870, -643589359},
    {-862437520, -639627258},  {-865371905, -635651611},  {-868287963, -631662503},  {-871185633, -627660017},
    {-874064853, -623644239},  {-876925563, -619615253},  {-879767701, -615573145},  {-882591207, -611518001},
    {-885396022, -607449906},  {-888182086, -603368947},  {-890949341, -599275210},  {-893697727, -595168781},
    {-896427186, -591049748},  {-899137661, -586918198},  {-901829095, -582774218},  {-904501429, -578617896},
    {-907154608, -574449320},  {-909788576, -570268579},  {-912403276, -566075761},  {-914998653, -561870954},
    {-917574653, -557654248},  {-920131221, -553425732},  {-922668302, -549185496},  {-925185843, -544933630},
    {-927683790, -540670223},  {-930162092, -536395365},  {-932620694, -532109148},  {-935059546, -527811662},
    {-937478595, -523502998},  {-939877790, -519183248},  {-942257081, -514852502},  {-944616416, -510510853},
    {-946955747, -506158392},  {-949275023, -501795212},  {-951574196, -497421405},  {-953853216, -493037064},
    {-956112036, -488642281},  {-958350608, -484237150},  {-960568883, -479821764},  {-962766816, -475396216},
    {-964944360, -470960600},  {-967101468, -466515010},  {-969238095, -462059541},  {-971354196, -457594286},
    {-973449725, -453119340},  {-975524639, -448634799},  {-977578894, -444140756},  {-979612445, -439637307},
    {-981625251, -435124548},  {-983617267, -430602573},  {-985588453, -426071480},  {-987538766, -421531363},
    {-989468165, -416982319},  {-991376610, -412424444},  {-993264059, -407857835},  {-995130473, -403282588},
    {-996975812, -398698801},  {-998800038, -394106570},  {-1000603111, -389505993}, {-1002384994, -384897167},
    {-1004145648, -380280190}, {-1005885036, -375655159}, {-1007603122, -371022173}, {-1009299870, -366381329},
    {-1010975242, -361732726}, {-1012629204, -357076462}, {-1014261721, -352412636}, {-1015872758, -347741347},
    {-1017462281, -343062693}, {-1019030256, -338376774}, {-1020576651, -333683689}, {-1022101432, -328983538},
    {-1023604567, -324276419}, {-1025086024, -319562433}, {-1026545772, -314841679}, {-1027983780, -310114257},
    {-1029400018, -305380268}, {-1030794455, -300639811}, {-1032167062, -295892988}, {-1033517810, -291139898},
    {-1034846671, -286380643}, {-1036153615, -281615322}, {-1037438617, -276844038}, {-1038701647, -272066891},
    {-1039942680, -267283981}, {-1041161689, -262495412}, {-1042358649, -257701283}, {-1043533534, -252901697},
    {-1044686319, -248096755}, {-1045816980, -243286558}, {-1046925492, -238471210}, {-1048011834, -233650811},
    {-1049075980, -228825464}, {-1050117909, -223995270}, {-1051137599, -219160334}, {-1052135029, -214320755},
    {-1053110176, -209476638}, {-1054063021, -204628085}, {-1054993543, -199775198}, {-1055901722, -194918080},
    {-1056787540, -190056834}, {-1057650977, -185191564}, {-1058492016, -180322371}, {-1059310638, -175449360},
    {-1060106826, -170572633}, {-1060880563, -165692293}, {-1061631833, -160808445}, {-1062360620, -155921191},
    {-1063066909, -151030634}, {-1063750684, -146136880}, {-1064411931, -141240030}, {-1065050636, -136340190},
    {-1065666786, -131437462}, {-1066260367, -126531950}, {-1066831367, -121623759}, {-1067379774, -116712992},
    {-1067905576, -111799753}, {-1068408763, -106884147}, {-1068889322, -101966277}, {-1069347245, -97046247},
    {-1069782521, -92124163},  {-1070195142, -87200127},  {-1070585099, -82274245},  {-1070952382, -77346620},
    {-1071296985, -72417357},  {-1071618901, -67486561},  {-1071918122, -62554335},  {-1072194642, -57620785},
    {-1072448455, -52686014},  {-1072679556, -47750128},  {-1072887940, -42813230},  {-1073073603, -37875426},
    {-1073236540, -32936819},  {-1073376748, -27997515},  {-1073494225, -23057618},  {-1073588967, -18117233},
    {-1073660973, -13176464},  {-1073710241, -8235416},   {-1073736771, -3294193},   {-1073740561, 1647099},
    {-1073721611, 6588356},    {-1073679922, 11529474},   {-1073615496, 16470347},   {-1073528332, 21410872},
    {-1073418433, 26350943},   {-1073285802, 31290457},   {-1073130440, 36229307},   {-1072952352, 41167391},
    {-1072751542, 46104602},   {-1072528012, 51040837},   {-1072281769, 55975992},   {-1072012818, 60909960},
    {-1071721163, 65842639},   {-1071406812, 70773924},   {-1071069770, 75703709},   {-1070710046, 80631892},
    {-1070327646, 85558366},   {-1069922579, 90483029},   {-1069494854, 95405776},   {-1069044479, 100326502},
    {-1068571464, 105245103},  {-1068075818, 110161476},  {-1067557554, 115075515},  {-1067016680, 119987118},
    {-1066453210, 124896179},  {-1065867154, 129802595},  {-1065258526, 134706263},  {-1064627338, 139607077},
    {-1063973603, 144504935},  {-1063297336, 149399733},  {-1062598550, 154291367},  {-1061877261, 159179733},
    {-1061133483, 164064728},  {-1060367233, 168946249},  {-1059578527, 173824192},  {-1058767381, 178698453},
    {-1057933813, 183568930},  {-1057077840, 188435520},  {-1056199480, 193298119},  {-1055298753, 198156624},
    {-1054375676, 203010932},  {-1053430270, 207860942},  {-1052462555, 212706549},  {-1051472550, 217547651},
    {-1050460278, 222384147},  {-1049425759, 227215933},  {-1048369016, 232042906},  {-1047290071, 236864966},
    {-1046188946, 241682010},  {-1045065665, 246493935},  {-1043920252, 251300640},  {-1042752731, 256102022},
    {-1041563127, 260897982},  {-1040351465, 265688415},  {-1039117770, 270473223},  {-1037862069, 275252302},
    {-1036584389, 280025552},  {-1035284755, 284792871},  {-1033963197, 289554160},  {-1032619742, 294309316},
    {-1031254418, 299058239},  {-1029867254, 303800829},  {-1028458280, 308536985},  {-1027027525, 313266607},
    {-1025575020, 317989595},  {-1024100796, 322705848},  {-1022604883, 327415267},  {-1021087314, 332117752},
    {-1019548121, 336813204},  {-1017987335, 341501523},  {-1016404991, 346182609},  {-1014801122, 350856364},
    {-1013175761, 355522689},  {-1011528943, 360181484},  {-1009860704, 364832652},  {-1008171077, 369476093},
    {-1006460100, 374111709},  {-1004727809, 378739403},  {-1002974239, 383359076},  {-1001199428, 387970630},
    {-999403415, 392573967},   {-997586236, 397168991},   {-995747930, 401755603},   {-993888536, 406333708},
    {-992008094, 410903207},   {-990106644, 415464004},   {-988184225, 420016002},   {-986240879, 424559105},
    {-984276646, 429093217},   {-982291568, 433618242},   {-980285688, 438134084},   {-978259047, 442640647},
    {-976211688, 447137835},   {-974143656, 451625555},   {-972054994, 456103710},   {-969945745, 460572205},
    {-967815955, 465030947},   {-965665669, 469479840},   {-963494932, 473918791},   {-961303790, 478347705},
    {-959092290, 482766489},   {-956860479, 487175049},   {-954608403, 491573292},   {-952336111, 495961124},
    {-950043650, 500338453},   {-947731070, 504705185},   {-945398418, 509061229},   {-943045745, 513406493},
    {-940673101, 517740883},   {-938280535, 522064309},   {-935868098, 526376678},   {-933435842, 530677900},
    {-930983817, 534967884},   {-928512076, 539246538},   {-926020672, 543513772},   {-923509656, 547769495},
    {-920979082, 552013618},   {-918429004, 556246051},   {-915859476, 560466703},   {-913270551, 564675486},
    {-910662286, 568872310},   {-908034735, 573057087},   {-905387953, 577229728},   {-902721998, 581390144},
    {-900036924, 585538248},   {-897332790, 589673951},   {-894609652, 593797166},   {-891867569, 597907806},
    {-889106597, 602005783},   {-886326796, 606091012},   {-883528225, 610163404},   {-880710943, 614222875},
    {-877875009, 618269338},   {-875020483, 622302707},   {-872147426, 626322897},   {-869255900, 630329823},
    {-866345964, 634323400},   {-863417681, 638303543},   {-860471112, 642270169},   {-857506321, 646223192},
    {-854523370, 650162530},   {-851522321, 654088099},   {-848503239, 657999816},   {-845466188, 661897597},
    {-842411232, 665781362},   {-839338435, 669651026},   {-836247863, 673506508},   {-833139580, 677347728},
    {-830013654, 681174602},   {-826870150, 684987051},   {-823709135, 688784993},   {-820530675, 692568348},
    {-817334838, 696337036},   {-814121692, 700090977},   {-810891304, 703830092},   {-807643743, 707554301},
    {-804379079, 711263525},   {-801097379, 714957687},   {-797798714, 718636707},   {-794483153, 722300508},
    {-791150767, 725949013},   {-787801625, 729582143},   {-784435800, 733199822},   {-781053363, 736801974},
    {-777654384, 740388522},   {-774238936, 743959390},   {-770807092, 747514503},   {-767358923, 751053785},
    {-763894504, 754577161},   {-760413906, 758084557},   {-756917205, 761575898},   {-753404474, 765051111},
    {-749875788, 768510122},   {-746331221, 771952857},   {-742770848, 775379244},   {-739194745, 778789210},
    {-735602987, 782182683},   {-731995651, 785559591},   {-728372813, 788919863},   {-724734549, 792263427},
    {-721080937, 795590213},   {-717412054, 798900150},   {-713727978, 802193167},   {-710028787, 805469196},
    {-706314559, 808728167},   {-702585372, 811970011},   {-698841307, 815194659},   {-695082441, 818402043},
    {-691308855, 821592095},   {-687520629, 824764748},   {-683717842, 827919934},   {-679900576, 831057586},
    {-676068911, 834177638},   {-672222928, 837280024},   {-668362709, 840364679},   {-664488336, 843431536},
    {-660599890, 846480531},   {-656697454, 849511600},   {-652781111, 852524677},   {-648850943, 855519701},
    {-644907034, 858496606},   {-640949467, 861455330},   {-636978327, 864395810},   {-632993696, 867317984},
    {-628995660, 870221790},   {-624984303, 873107167},   {-620959711, 875974054},   {-616921967, 878822389},
    {-612871159, 881652112},   {-608807372, 884463164},   {-604730691, 887255485},   {-600641203, 890029016},
    {-596538995, 892783698},   {-592424154, 895519473},   {-588296766, 898236282},   {-584156920, 900934069},
    {-580004702, 903612776},   {-575840202, 906272347},   {-571663506, 908912725},   {-567474703, 911533853},
    {-563273883, 914135678},   {-559061133, 916718143},   {-554836544, 919281194},   {-550600205, 921824777},
    {-546352205, 924348837},   {-542092635, 926853322},   {-537821584, 929338177},   {-533539144, 931803352},
    {-529245404, 934248793},   {-524940456, 936674448},   {-520624391, 939080267},   {-516297300, 941466198},
    {-511959275, 943832191},   {-507610408, 946178196},   {-503250791, 948504163},   {-498880516, 950810042},
    {-494499676, 953095785},   {-490108363, 955361344},   {-485706671, 957606670},   {-481294693, 959831716},
    {-476872522, 962036435},   {-472440251, 964220780},   {-467997976, 966384706},   {-463545789, 968528165},
    {-459083786, 970651112},   {-454612060, 972753504},   {-450130706, 974835295},   {-445639820, 976896441},
    {-441139496, 978936898},   {-436629829, 980956623},   {-432110916, 982955574},   {-427582852, 984933708},
    {-423045732, 986890984},   {-418499653, 988827359},   {-413944711, 990742793},   {-409381002, 992637245},
    {-404808624, 994510675},   {-400227673, 996363043},   {-395638246, 998194311},   {-391040440, 1000004439},
    {-386434353, 1001793390},  {-381820082, 1003561124},  {-377197725, 1005307605},  {-372567379, 1007032796},
    {-367929144, 1008736660},  {-363283116, 1010419162},  {-358629395, 1012080264},  {-353968079, 1013719934},
    {-349299266, 1015338134},  {-344623057, 1016934832},  {-339939549, 1018509994},  {-335248841, 1020063586},
    {-330551034, 1021595575},  {-325846226, 1023105929},  {-321134518, 1024594615},  {-316416009, 1026061603},
    {-311690799, 1027506862},  {-306958988, 1028930359},  {-302220676, 1030332067},  {-297475964, 1031711954},
    {-292724951, 1033069992},  {-287967740, 1034406151},  {-283204430, 1035720404},  {-278435122, 1037012723},
    {-273659918, 1038283080},  {-268878918, 1039531448},  {-264092224, 1040757802},  {-259299937, 1041962114},
    {-254502159, 1043144360},  {-249698991, 1044304514},  {-244890535, 1045442553},  {-240076892, 1046558451},
    {-235258165, 1047652185},  {-230434456, 1048723732},  {-225605867, 1049773069},  {-220772500, 1050800175},
    {-215934457, 1051805027},  {-211091842, 1052787604},  {-206244756, 1053747885},  {-201393302, 1054685850},
    {-196537583, 1055601479},  {-191677702, 1056494753},  {-186813762, 1057365653},  {-181945865, 1058214159},
    {-177074115, 1059040255},  {-172198615, 1059843923},  {-167319468, 1060625146},  {-162436778, 1061383907},
    {-157550647, 1062120190},  {-152661180, 1062833980},  {-147768480, 1063525261},  {-142872651, 1064194019},
    {-137973796, 1064840240},  {-133072019, 1065463909},  {-128167423, 1066065015},  {-123260114, 1066643544},
    {-118350194, 1067199483},  {-113437768, 1067732821},  {-108522939, 1068243547},  {-103605812, 1068731650},
    {-98686491, 1069197120},   {-93765079, 1069639946},   {-88841683, 1070060120},   {-83916404, 1070457632},
    {-78989349, 1070832474},   {-74060620, 1071184638},   {-69130324, 1071514117},   {-64198563, 1071820903},
    {-59265442, 1072104991},   {-54331067, 1072366374},   {-49395541, 1072605046},   {-44458968, 1072821003},
    {-39521455, 1073014240},   {-34583104, 1073184753},   {-29644021, 1073332538},   {-24704310, 1073457592},
    {-19764076, 1073559913},   {-14823423, 1073639498},   {-9882456, 1073696345},    {-4941281, 1073730454}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_cint16_r4_1_2[8] = {{32767, 0}, {-32768, 0}, {0, 0}, {0, 0},
                                                                      {0, 0},     {0, 0},      {0, 0}, {0, 0}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_cint16_r4_2_4[8] = {{32767, 0}, {-23170, -23170}, {0, 0}, {0, 0},
                                                                      {0, 0},     {0, 0},           {0, 0}, {0, 0}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_cint16_r4_4_8[8] = {
    {32767, 0}, {12540, -30274}, {-23170, -23170}, {-30274, 12540}, {0, 0}, {0, 0}, {0, 0}, {0, 0}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_cint16_r4_8_16[8] = {
    {32767, 0},       {27246, -18205}, {12540, -30274}, {-6393, -32138},
    {-23170, -23170}, {-32138, -6393}, {-30274, 12540}, {-18205, 27246}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_cint16_r4_16_32[16] = {
    {32767, 0},      {31357, -9512},   {27246, -18205},  {20788, -25330},  {12540, -30274}, {3212, -32610},
    {-6393, -32138}, {-15447, -28899}, {-23170, -23170}, {-28899, -15447}, {-32138, -6393}, {-32610, 3212},
    {-30274, 12540}, {-25330, 20788},  {-18205, 27246},  {-9512, 31357}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_cint16_r4_32_64[32] = {
    {32767, 0},       {32413, -4808},   {31357, -9512},   {29622, -14010},  {27246, -18205},  {24279, -22006},
    {20788, -25330},  {16846, -28106},  {12540, -30274},  {7962, -31786},   {3212, -32610},   {-1608, -32729},
    {-6393, -32138},  {-11039, -30853}, {-15447, -28899}, {-19520, -26320}, {-23170, -23170}, {-26320, -19520},
    {-28899, -15447}, {-30853, -11039}, {-32138, -6393},  {-32729, -1608},  {-32610, 3212},   {-31786, 7962},
    {-30274, 12540},  {-28106, 16846},  {-25330, 20788},  {-22006, 24279},  {-18205, 27246},  {-14010, 29622},
    {-9512, 31357},   {-4808, 32413}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_cint16_r4_64_128[64] = {
    {32767, 0},       {32679, -2411},   {32413, -4808},   {31972, -7180},   {31357, -9512},   {30572, -11793},
    {29622, -14010},  {28511, -16151},  {27246, -18205},  {25833, -20160},  {24279, -22006},  {22595, -23732},
    {20788, -25330},  {18868, -26791},  {16846, -28106},  {14733, -29269},  {12540, -30274},  {10279, -31114},
    {7962, -31786},   {5602, -32286},   {3212, -32610},   {804, -32758},    {-1608, -32729},  {-4011, -32522},
    {-6393, -32138},  {-8740, -31581},  {-11039, -30853}, {-13279, -29957}, {-15447, -28899}, {-17531, -27684},
    {-19520, -26320}, {-21403, -24812}, {-23170, -23170}, {-24812, -21403}, {-26320, -19520}, {-27684, -17531},
    {-28899, -15447}, {-29957, -13279}, {-30853, -11039}, {-31581, -8740},  {-32138, -6393},  {-32522, -4011},
    {-32729, -1608},  {-32758, 804},    {-32610, 3212},   {-32286, 5602},   {-31786, 7962},   {-31114, 10279},
    {-30274, 12540},  {-29269, 14733},  {-28106, 16846},  {-26791, 18868},  {-25330, 20788},  {-23732, 22595},
    {-22006, 24279},  {-20160, 25833},  {-18205, 27246},  {-16151, 28511},  {-14010, 29622},  {-11793, 30572},
    {-9512, 31357},   {-7180, 31972},   {-4808, 32413},   {-2411, 32679}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_cint16_r4_128_256[128] = {
    {32767, 0},       {32746, -1206},   {32679, -2411},   {32568, -3612},   {32413, -4808},   {32214, -5998},
    {31972, -7180},   {31686, -8351},   {31357, -9512},   {30986, -10660},  {30572, -11793},  {30118, -12910},
    {29622, -14010},  {29086, -15091},  {28511, -16151},  {27897, -17190},  {27246, -18205},  {26557, -19195},
    {25833, -20160},  {25073, -21097},  {24279, -22006},  {23453, -22884},  {22595, -23732},  {21706, -24548},
    {20788, -25330},  {19841, -26078},  {18868, -26791},  {17869, -27467},  {16846, -28106},  {15800, -28707},
    {14733, -29269},  {13646, -29792},  {12540, -30274},  {11417, -30715},  {10279, -31114},  {9127, -31471},
    {7962, -31786},   {6787, -32058},   {5602, -32286},   {4410, -32470},   {3212, -32610},   {2009, -32706},
    {804, -32758},    {-402, -32766},   {-1608, -32729},  {-2811, -32647},  {-4011, -32522},  {-5205, -32352},
    {-6393, -32138},  {-7571, -31881},  {-8740, -31581},  {-9896, -31238},  {-11039, -30853}, {-12167, -30425},
    {-13279, -29957}, {-14373, -29448}, {-15447, -28899}, {-16500, -28311}, {-17531, -27684}, {-18538, -27020},
    {-19520, -26320}, {-20475, -25583}, {-21403, -24812}, {-22302, -24008}, {-23170, -23170}, {-24008, -22302},
    {-24812, -21403}, {-25583, -20475}, {-26320, -19520}, {-27020, -18538}, {-27684, -17531}, {-28311, -16500},
    {-28899, -15447}, {-29448, -14373}, {-29957, -13279}, {-30425, -12167}, {-30853, -11039}, {-31238, -9896},
    {-31581, -8740},  {-31881, -7571},  {-32138, -6393},  {-32352, -5205},  {-32522, -4011},  {-32647, -2811},
    {-32729, -1608},  {-32766, -402},   {-32758, 804},    {-32706, 2009},   {-32610, 3212},   {-32470, 4410},
    {-32286, 5602},   {-32058, 6787},   {-31786, 7962},   {-31471, 9127},   {-31114, 10279},  {-30715, 11417},
    {-30274, 12540},  {-29792, 13646},  {-29269, 14733},  {-28707, 15800},  {-28106, 16846},  {-27467, 17869},
    {-26791, 18868},  {-26078, 19841},  {-25330, 20788},  {-24548, 21706},  {-23732, 22595},  {-22884, 23453},
    {-22006, 24279},  {-21097, 25073},  {-20160, 25833},  {-19195, 26557},  {-18205, 27246},  {-17190, 27897},
    {-16151, 28511},  {-15091, 29086},  {-14010, 29622},  {-12910, 30118},  {-11793, 30572},  {-10660, 30986},
    {-9512, 31357},   {-8351, 31686},   {-7180, 31972},   {-5998, 32214},   {-4808, 32413},   {-3612, 32568},
    {-2411, 32679},   {-1206, 32746}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_cint16_r4_256_512[256] = {
    {32767, 0},       {32762, -603},    {32746, -1206},   {32718, -1809},   {32679, -2411},   {32629, -3012},
    {32568, -3612},   {32496, -4211},   {32413, -4808},   {32319, -5404},   {32214, -5998},   {32099, -6590},
    {31972, -7180},   {31834, -7767},   {31686, -8351},   {31527, -8933},   {31357, -9512},   {31177, -10088},
    {30986, -10660},  {30784, -11228},  {30572, -11793},  {30350, -12354},  {30118, -12910},  {29875, -13463},
    {29622, -14010},  {29359, -14553},  {29086, -15091},  {28803, -15624},  {28511, -16151},  {28209, -16673},
    {27897, -17190},  {27576, -17700},  {27246, -18205},  {26906, -18703},  {26557, -19195},  {26199, -19681},
    {25833, -20160},  {25457, -20632},  {25073, -21097},  {24680, -21555},  {24279, -22006},  {23870, -22449},
    {23453, -22884},  {23028, -23312},  {22595, -23732},  {22154, -24144},  {21706, -24548},  {21251, -24943},
    {20788, -25330},  {20318, -25708},  {19841, -26078},  {19358, -26439},  {18868, -26791},  {18372, -27133},
    {17869, -27467},  {17361, -27791},  {16846, -28106},  {16326, -28411},  {15800, -28707},  {15269, -28993},
    {14733, -29269},  {14192, -29535},  {13646, -29792},  {13095, -30038},  {12540, -30274},  {11980, -30499},
    {11417, -30715},  {10850, -30920},  {10279, -31114},  {9704, -31298},   {9127, -31471},   {8546, -31634},
    {7962, -31786},   {7376, -31927},   {6787, -32058},   {6195, -32177},   {5602, -32286},   {5007, -32383},
    {4410, -32470},   {3812, -32546},   {3212, -32610},   {2611, -32664},   {2009, -32706},   {1407, -32738},
    {804, -32758},    {201, -32767},    {-402, -32766},   {-1005, -32753},  {-1608, -32729},  {-2210, -32693},
    {-2811, -32647},  {-3412, -32590},  {-4011, -32522},  {-4609, -32442},  {-5205, -32352},  {-5800, -32251},
    {-6393, -32138},  {-6983, -32015},  {-7571, -31881},  {-8157, -31737},  {-8740, -31581},  {-9319, -31415},
    {-9896, -31238},  {-10469, -31050}, {-11039, -30853}, {-11605, -30644}, {-12167, -30425}, {-12725, -30196},
    {-13279, -29957}, {-13828, -29707}, {-14373, -29448}, {-14912, -29178}, {-15447, -28899}, {-15976, -28610},
    {-16500, -28311}, {-17018, -28002}, {-17531, -27684}, {-18037, -27357}, {-18538, -27020}, {-19032, -26674},
    {-19520, -26320}, {-20001, -25956}, {-20475, -25583}, {-20943, -25202}, {-21403, -24812}, {-21856, -24414},
    {-22302, -24008}, {-22740, -23593}, {-23170, -23170}, {-23593, -22740}, {-24008, -22302}, {-24414, -21856},
    {-24812, -21403}, {-25202, -20943}, {-25583, -20475}, {-25956, -20001}, {-26320, -19520}, {-26674, -19032},
    {-27020, -18538}, {-27357, -18037}, {-27684, -17531}, {-28002, -17018}, {-28311, -16500}, {-28610, -15976},
    {-28899, -15447}, {-29178, -14912}, {-29448, -14373}, {-29707, -13828}, {-29957, -13279}, {-30196, -12725},
    {-30425, -12167}, {-30644, -11605}, {-30853, -11039}, {-31050, -10469}, {-31238, -9896},  {-31415, -9319},
    {-31581, -8740},  {-31737, -8157},  {-31881, -7571},  {-32015, -6983},  {-32138, -6393},  {-32251, -5800},
    {-32352, -5205},  {-32442, -4609},  {-32522, -4011},  {-32590, -3412},  {-32647, -2811},  {-32693, -2210},
    {-32729, -1608},  {-32753, -1005},  {-32766, -402},   {-32767, 201},    {-32758, 804},    {-32738, 1407},
    {-32706, 2009},   {-32664, 2611},   {-32610, 3212},   {-32546, 3812},   {-32470, 4410},   {-32383, 5007},
    {-32286, 5602},   {-32177, 6195},   {-32058, 6787},   {-31927, 7376},   {-31786, 7962},   {-31634, 8546},
    {-31471, 9127},   {-31298, 9704},   {-31114, 10279},  {-30920, 10850},  {-30715, 11417},  {-30499, 11980},
    {-30274, 12540},  {-30038, 13095},  {-29792, 13646},  {-29535, 14192},  {-29269, 14733},  {-28993, 15269},
    {-28707, 15800},  {-28411, 16326},  {-28106, 16846},  {-27791, 17361},  {-27467, 17869},  {-27133, 18372},
    {-26791, 18868},  {-26439, 19358},  {-26078, 19841},  {-25708, 20318},  {-25330, 20788},  {-24943, 21251},
    {-24548, 21706},  {-24144, 22154},  {-23732, 22595},  {-23312, 23028},  {-22884, 23453},  {-22449, 23870},
    {-22006, 24279},  {-21555, 24680},  {-21097, 25073},  {-20632, 25457},  {-20160, 25833},  {-19681, 26199},
    {-19195, 26557},  {-18703, 26906},  {-18205, 27246},  {-17700, 27576},  {-17190, 27897},  {-16673, 28209},
    {-16151, 28511},  {-15624, 28803},  {-15091, 29086},  {-14553, 29359},  {-14010, 29622},  {-13463, 29875},
    {-12910, 30118},  {-12354, 30350},  {-11793, 30572},  {-11228, 30784},  {-10660, 30986},  {-10088, 31177},
    {-9512, 31357},   {-8933, 31527},   {-8351, 31686},   {-7767, 31834},   {-7180, 31972},   {-6590, 32099},
    {-5998, 32214},   {-5404, 32319},   {-4808, 32413},   {-4211, 32496},   {-3612, 32568},   {-3012, 32629},
    {-2411, 32679},   {-1809, 32718},   {-1206, 32746},   {-603, 32762}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_cint16_r4_512_1024[512] = {
    {32767, 0},       {32767, -302},    {32762, -603},    {32756, -905},    {32746, -1206},   {32733, -1507},
    {32718, -1809},   {32700, -2110},   {32679, -2411},   {32656, -2711},   {32629, -3012},   {32600, -3312},
    {32568, -3612},   {32534, -3911},   {32496, -4211},   {32456, -4510},   {32413, -4808},   {32368, -5106},
    {32319, -5404},   {32268, -5701},   {32214, -5998},   {32158, -6294},   {32099, -6590},   {32037, -6885},
    {31972, -7180},   {31904, -7473},   {31834, -7767},   {31761, -8059},   {31686, -8351},   {31608, -8643},
    {31527, -8933},   {31443, -9223},   {31357, -9512},   {31268, -9800},   {31177, -10088},  {31082, -10374},
    {30986, -10660},  {30886, -10945},  {30784, -11228},  {30680, -11511},  {30572, -11793},  {30462, -12074},
    {30350, -12354},  {30235, -12633},  {30118, -12910},  {29997, -13187},  {29875, -13463},  {29750, -13737},
    {29622, -14010},  {29492, -14282},  {29359, -14553},  {29224, -14823},  {29086, -15091},  {28946, -15358},
    {28803, -15624},  {28658, -15888},  {28511, -16151},  {28361, -16413},  {28209, -16673},  {28054, -16932},
    {27897, -17190},  {27738, -17446},  {27576, -17700},  {27412, -17953},  {27246, -18205},  {27077, -18455},
    {26906, -18703},  {26733, -18950},  {26557, -19195},  {26379, -19439},  {26199, -19681},  {26017, -19921},
    {25833, -20160},  {25646, -20397},  {25457, -20632},  {25266, -20865},  {25073, -21097},  {24878, -21327},
    {24680, -21555},  {24481, -21781},  {24279, -22006},  {24076, -22228},  {23870, -22449},  {23663, -22668},
    {23453, -22884},  {23241, -23099},  {23028, -23312},  {22812, -23523},  {22595, -23732},  {22375, -23939},
    {22154, -24144},  {21931, -24347},  {21706, -24548},  {21479, -24746},  {21251, -24943},  {21020, -25138},
    {20788, -25330},  {20554, -25520},  {20318, -25708},  {20081, -25894},  {19841, -26078},  {19601, -26259},
    {19358, -26439},  {19114, -26616},  {18868, -26791},  {18621, -26963},  {18372, -27133},  {18121, -27301},
    {17869, -27467},  {17616, -27630},  {17361, -27791},  {17104, -27950},  {16846, -28106},  {16587, -28260},
    {16326, -28411},  {16064, -28560},  {15800, -28707},  {15535, -28851},  {15269, -28993},  {15002, -29132},
    {14733, -29269},  {14463, -29404},  {14192, -29535},  {13919, -29665},  {13646, -29792},  {13371, -29916},
    {13095, -30038},  {12818, -30157},  {12540, -30274},  {12261, -30388},  {11980, -30499},  {11699, -30608},
    {11417, -30715},  {11134, -30819},  {10850, -30920},  {10565, -31018},  {10279, -31114},  {9992, -31207},
    {9704, -31298},   {9416, -31386},   {9127, -31471},   {8836, -31554},   {8546, -31634},   {8254, -31711},
    {7962, -31786},   {7669, -31858},   {7376, -31927},   {7081, -31994},   {6787, -32058},   {6491, -32119},
    {6195, -32177},   {5899, -32233},   {5602, -32286},   {5305, -32336},   {5007, -32383},   {4709, -32428},
    {4410, -32470},   {4111, -32509},   {3812, -32546},   {3512, -32579},   {3212, -32610},   {2912, -32638},
    {2611, -32664},   {2310, -32686},   {2009, -32706},   {1708, -32723},   {1407, -32738},   {1106, -32749},
    {804, -32758},    {503, -32764},    {201, -32767},    {-101, -32768},   {-402, -32766},   {-704, -32760},
    {-1005, -32753},  {-1307, -32742},  {-1608, -32729},  {-1909, -32712},  {-2210, -32693},  {-2511, -32672},
    {-2811, -32647},  {-3112, -32620},  {-3412, -32590},  {-3712, -32557},  {-4011, -32522},  {-4310, -32483},
    {-4609, -32442},  {-4907, -32398},  {-5205, -32352},  {-5503, -32303},  {-5800, -32251},  {-6097, -32196},
    {-6393, -32138},  {-6688, -32078},  {-6983, -32015},  {-7278, -31950},  {-7571, -31881},  {-7864, -31810},
    {-8157, -31737},  {-8449, -31660},  {-8740, -31581},  {-9030, -31499},  {-9319, -31415},  {-9608, -31328},
    {-9896, -31238},  {-10183, -31146}, {-10469, -31050}, {-10755, -30953}, {-11039, -30853}, {-11323, -30750},
    {-11605, -30644}, {-11887, -30536}, {-12167, -30425}, {-12447, -30312}, {-12725, -30196}, {-13003, -30078},
    {-13279, -29957}, {-13554, -29833}, {-13828, -29707}, {-14101, -29579}, {-14373, -29448}, {-14643, -29314},
    {-14912, -29178}, {-15180, -29040}, {-15447, -28899}, {-15712, -28755}, {-15976, -28610}, {-16239, -28461},
    {-16500, -28311}, {-16760, -28158}, {-17018, -28002}, {-17275, -27844}, {-17531, -27684}, {-17785, -27522},
    {-18037, -27357}, {-18288, -27190}, {-18538, -27020}, {-18786, -26848}, {-19032, -26674}, {-19277, -26498},
    {-19520, -26320}, {-19761, -26139}, {-20001, -25956}, {-20239, -25771}, {-20475, -25583}, {-20710, -25394},
    {-20943, -25202}, {-21174, -25008}, {-21403, -24812}, {-21631, -24614}, {-21856, -24414}, {-22080, -24212},
    {-22302, -24008}, {-22522, -23801}, {-22740, -23593}, {-22956, -23383}, {-23170, -23170}, {-23383, -22956},
    {-23593, -22740}, {-23801, -22522}, {-24008, -22302}, {-24212, -22080}, {-24414, -21856}, {-24614, -21631},
    {-24812, -21403}, {-25008, -21174}, {-25202, -20943}, {-25394, -20710}, {-25583, -20475}, {-25771, -20239},
    {-25956, -20001}, {-26139, -19761}, {-26320, -19520}, {-26498, -19277}, {-26674, -19032}, {-26848, -18786},
    {-27020, -18538}, {-27190, -18288}, {-27357, -18037}, {-27522, -17785}, {-27684, -17531}, {-27844, -17275},
    {-28002, -17018}, {-28158, -16760}, {-28311, -16500}, {-28461, -16239}, {-28610, -15976}, {-28755, -15712},
    {-28899, -15447}, {-29040, -15180}, {-29178, -14912}, {-29314, -14643}, {-29448, -14373}, {-29579, -14101},
    {-29707, -13828}, {-29833, -13554}, {-29957, -13279}, {-30078, -13003}, {-30196, -12725}, {-30312, -12447},
    {-30425, -12167}, {-30536, -11887}, {-30644, -11605}, {-30750, -11323}, {-30853, -11039}, {-30953, -10755},
    {-31050, -10469}, {-31146, -10183}, {-31238, -9896},  {-31328, -9608},  {-31415, -9319},  {-31499, -9030},
    {-31581, -8740},  {-31660, -8449},  {-31737, -8157},  {-31810, -7864},  {-31881, -7571},  {-31950, -7278},
    {-32015, -6983},  {-32078, -6688},  {-32138, -6393},  {-32196, -6097},  {-32251, -5800},  {-32303, -5503},
    {-32352, -5205},  {-32398, -4907},  {-32442, -4609},  {-32483, -4310},  {-32522, -4011},  {-32557, -3712},
    {-32590, -3412},  {-32620, -3112},  {-32647, -2811},  {-32672, -2511},  {-32693, -2210},  {-32712, -1909},
    {-32729, -1608},  {-32742, -1307},  {-32753, -1005},  {-32760, -704},   {-32766, -402},   {-32768, -101},
    {-32767, 201},    {-32764, 503},    {-32758, 804},    {-32749, 1106},   {-32738, 1407},   {-32723, 1708},
    {-32706, 2009},   {-32686, 2310},   {-32664, 2611},   {-32638, 2912},   {-32610, 3212},   {-32579, 3512},
    {-32546, 3812},   {-32509, 4111},   {-32470, 4410},   {-32428, 4709},   {-32383, 5007},   {-32336, 5305},
    {-32286, 5602},   {-32233, 5899},   {-32177, 6195},   {-32119, 6491},   {-32058, 6787},   {-31994, 7081},
    {-31927, 7376},   {-31858, 7669},   {-31786, 7962},   {-31711, 8254},   {-31634, 8546},   {-31554, 8836},
    {-31471, 9127},   {-31386, 9416},   {-31298, 9704},   {-31207, 9992},   {-31114, 10279},  {-31018, 10565},
    {-30920, 10850},  {-30819, 11134},  {-30715, 11417},  {-30608, 11699},  {-30499, 11980},  {-30388, 12261},
    {-30274, 12540},  {-30157, 12818},  {-30038, 13095},  {-29916, 13371},  {-29792, 13646},  {-29665, 13919},
    {-29535, 14192},  {-29404, 14463},  {-29269, 14733},  {-29132, 15002},  {-28993, 15269},  {-28851, 15535},
    {-28707, 15800},  {-28560, 16064},  {-28411, 16326},  {-28260, 16587},  {-28106, 16846},  {-27950, 17104},
    {-27791, 17361},  {-27630, 17616},  {-27467, 17869},  {-27301, 18121},  {-27133, 18372},  {-26963, 18621},
    {-26791, 18868},  {-26616, 19114},  {-26439, 19358},  {-26259, 19601},  {-26078, 19841},  {-25894, 20081},
    {-25708, 20318},  {-25520, 20554},  {-25330, 20788},  {-25138, 21020},  {-24943, 21251},  {-24746, 21479},
    {-24548, 21706},  {-24347, 21931},  {-24144, 22154},  {-23939, 22375},  {-23732, 22595},  {-23523, 22812},
    {-23312, 23028},  {-23099, 23241},  {-22884, 23453},  {-22668, 23663},  {-22449, 23870},  {-22228, 24076},
    {-22006, 24279},  {-21781, 24481},  {-21555, 24680},  {-21327, 24878},  {-21097, 25073},  {-20865, 25266},
    {-20632, 25457},  {-20397, 25646},  {-20160, 25833},  {-19921, 26017},  {-19681, 26199},  {-19439, 26379},
    {-19195, 26557},  {-18950, 26733},  {-18703, 26906},  {-18455, 27077},  {-18205, 27246},  {-17953, 27412},
    {-17700, 27576},  {-17446, 27738},  {-17190, 27897},  {-16932, 28054},  {-16673, 28209},  {-16413, 28361},
    {-16151, 28511},  {-15888, 28658},  {-15624, 28803},  {-15358, 28946},  {-15091, 29086},  {-14823, 29224},
    {-14553, 29359},  {-14282, 29492},  {-14010, 29622},  {-13737, 29750},  {-13463, 29875},  {-13187, 29997},
    {-12910, 30118},  {-12633, 30235},  {-12354, 30350},  {-12074, 30462},  {-11793, 30572},  {-11511, 30680},
    {-11228, 30784},  {-10945, 30886},  {-10660, 30986},  {-10374, 31082},  {-10088, 31177},  {-9800, 31268},
    {-9512, 31357},   {-9223, 31443},   {-8933, 31527},   {-8643, 31608},   {-8351, 31686},   {-8059, 31761},
    {-7767, 31834},   {-7473, 31904},   {-7180, 31972},   {-6885, 32037},   {-6590, 32099},   {-6294, 32158},
    {-5998, 32214},   {-5701, 32268},   {-5404, 32319},   {-5106, 32368},   {-4808, 32413},   {-4510, 32456},
    {-4211, 32496},   {-3911, 32534},   {-3612, 32568},   {-3312, 32600},   {-3012, 32629},   {-2711, 32656},
    {-2411, 32679},   {-2110, 32700},   {-1809, 32718},   {-1507, 32733},   {-1206, 32746},   {-905, 32756},
    {-603, 32762},    {-302, 32767}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_cint16_r4_1024_2048[1024] = {
    {32767, 0},       {32767, -151},    {32767, -302},    {32765, -452},    {32762, -603},    {32759, -754},
    {32756, -905},    {32751, -1055},   {32746, -1206},   {32740, -1357},   {32733, -1507},   {32726, -1658},
    {32718, -1809},   {32709, -1959},   {32700, -2110},   {32690, -2260},   {32679, -2411},   {32668, -2561},
    {32656, -2711},   {32643, -2861},   {32629, -3012},   {32615, -3162},   {32600, -3312},   {32585, -3462},
    {32568, -3612},   {32551, -3762},   {32534, -3911},   {32515, -4061},   {32496, -4211},   {32477, -4360},
    {32456, -4510},   {32435, -4659},   {32413, -4808},   {32391, -4957},   {32368, -5106},   {32344, -5255},
    {32319, -5404},   {32294, -5553},   {32268, -5701},   {32242, -5850},   {32214, -5998},   {32186, -6146},
    {32158, -6294},   {32129, -6442},   {32099, -6590},   {32068, -6737},   {32037, -6885},   {32005, -7032},
    {31972, -7180},   {31938, -7327},   {31904, -7473},   {31870, -7620},   {31834, -7767},   {31798, -7913},
    {31761, -8059},   {31724, -8206},   {31686, -8351},   {31647, -8497},   {31608, -8643},   {31568, -8788},
    {31527, -8933},   {31485, -9078},   {31443, -9223},   {31400, -9368},   {31357, -9512},   {31313, -9656},
    {31268, -9800},   {31223, -9944},   {31177, -10088},  {31130, -10231},  {31082, -10374},  {31034, -10517},
    {30986, -10660},  {30936, -10802},  {30886, -10945},  {30836, -11087},  {30784, -11228},  {30732, -11370},
    {30680, -11511},  {30626, -11652},  {30572, -11793},  {30518, -11934},  {30462, -12074},  {30407, -12214},
    {30350, -12354},  {30293, -12493},  {30235, -12633},  {30177, -12772},  {30118, -12910},  {30058, -13049},
    {29997, -13187},  {29936, -13325},  {29875, -13463},  {29813, -13600},  {29750, -13737},  {29686, -13874},
    {29622, -14010},  {29557, -14146},  {29492, -14282},  {29426, -14418},  {29359, -14553},  {29292, -14688},
    {29224, -14823},  {29155, -14957},  {29086, -15091},  {29016, -15225},  {28946, -15358},  {28875, -15491},
    {28803, -15624},  {28731, -15756},  {28658, -15888},  {28585, -16020},  {28511, -16151},  {28436, -16282},
    {28361, -16413},  {28285, -16543},  {28209, -16673},  {28132, -16803},  {28054, -16932},  {27976, -17061},
    {27897, -17190},  {27818, -17318},  {27738, -17446},  {27657, -17573},  {27576, -17700},  {27494, -17827},
    {27412, -17953},  {27329, -18079},  {27246, -18205},  {27162, -18330},  {27077, -18455},  {26992, -18579},
    {26906, -18703},  {26820, -18827},  {26733, -18950},  {26645, -19073},  {26557, -19195},  {26468, -19317},
    {26379, -19439},  {26290, -19560},  {26199, -19681},  {26108, -19801},  {26017, -19921},  {25925, -20041},
    {25833, -20160},  {25739, -20279},  {25646, -20397},  {25552, -20515},  {25457, -20632},  {25362, -20749},
    {25266, -20865},  {25170, -20981},  {25073, -21097},  {24976, -21212},  {24878, -21327},  {24779, -21441},
    {24680, -21555},  {24581, -21668},  {24481, -21781},  {24380, -21894},  {24279, -22006},  {24178, -22117},
    {24076, -22228},  {23973, -22339},  {23870, -22449},  {23767, -22558},  {23663, -22668},  {23558, -22776},
    {23453, -22884},  {23348, -22992},  {23241, -23099},  {23135, -23206},  {23028, -23312},  {22920, -23418},
    {22812, -23523},  {22704, -23628},  {22595, -23732},  {22485, -23836},  {22375, -23939},  {22265, -24042},
    {22154, -24144},  {22043, -24246},  {21931, -24347},  {21819, -24448},  {21706, -24548},  {21593, -24647},
    {21479, -24746},  {21365, -24845},  {21251, -24943},  {21136, -25041},  {21020, -25138},  {20904, -25234},
    {20788, -25330},  {20671, -25425},  {20554, -25520},  {20436, -25615},  {20318, -25708},  {20200, -25802},
    {20081, -25894},  {19961, -25986},  {19841, -26078},  {19721, -26169},  {19601, -26259},  {19479, -26349},
    {19358, -26439},  {19236, -26528},  {19114, -26616},  {18991, -26704},  {18868, -26791},  {18745, -26877},
    {18621, -26963},  {18496, -27049},  {18372, -27133},  {18247, -27218},  {18121, -27301},  {17995, -27384},
    {17869, -27467},  {17743, -27549},  {17616, -27630},  {17488, -27711},  {17361, -27791},  {17233, -27871},
    {17104, -27950},  {16975, -28028},  {16846, -28106},  {16717, -28183},  {16587, -28260},  {16456, -28336},
    {16326, -28411},  {16195, -28486},  {16064, -28560},  {15932, -28634},  {15800, -28707},  {15668, -28779},
    {15535, -28851},  {15402, -28922},  {15269, -28993},  {15136, -29063},  {15002, -29132},  {14867, -29201},
    {14733, -29269},  {14598, -29337},  {14463, -29404},  {14327, -29470},  {14192, -29535},  {14056, -29600},
    {13919, -29665},  {13783, -29729},  {13646, -29792},  {13508, -29854},  {13371, -29916},  {13233, -29977},
    {13095, -30038},  {12957, -30098},  {12818, -30157},  {12679, -30216},  {12540, -30274},  {12400, -30331},
    {12261, -30388},  {12121, -30444},  {11980, -30499},  {11840, -30554},  {11699, -30608},  {11558, -30662},
    {11417, -30715},  {11276, -30767},  {11134, -30819},  {10992, -30869},  {10850, -30920},  {10707, -30969},
    {10565, -31018},  {10422, -31067},  {10279, -31114},  {10135, -31161},  {9992, -31207},   {9848, -31253},
    {9704, -31298},   {9560, -31342},   {9416, -31386},   {9271, -31429},   {9127, -31471},   {8982, -31513},
    {8836, -31554},   {8691, -31594},   {8546, -31634},   {8400, -31673},   {8254, -31711},   {8108, -31749},
    {7962, -31786},   {7816, -31822},   {7669, -31858},   {7522, -31893},   {7376, -31927},   {7229, -31961},
    {7081, -31994},   {6934, -32026},   {6787, -32058},   {6639, -32088},   {6491, -32119},   {6343, -32148},
    {6195, -32177},   {6047, -32205},   {5899, -32233},   {5751, -32259},   {5602, -32286},   {5453, -32311},
    {5305, -32336},   {5156, -32360},   {5007, -32383},   {4858, -32406},   {4709, -32428},   {4559, -32449},
    {4410, -32470},   {4260, -32490},   {4111, -32509},   {3961, -32528},   {3812, -32546},   {3662, -32563},
    {3512, -32579},   {3362, -32595},   {3212, -32610},   {3062, -32625},   {2912, -32638},   {2761, -32651},
    {2611, -32664},   {2461, -32675},   {2310, -32686},   {2160, -32697},   {2009, -32706},   {1859, -32715},
    {1708, -32723},   {1558, -32731},   {1407, -32738},   {1256, -32744},   {1106, -32749},   {955, -32754},
    {804, -32758},    {653, -32761},    {503, -32764},    {352, -32766},    {201, -32767},    {50, -32768},
    {-101, -32768},   {-251, -32767},   {-402, -32766},   {-553, -32763},   {-704, -32760},   {-854, -32757},
    {-1005, -32753},  {-1156, -32748},  {-1307, -32742},  {-1457, -32736},  {-1608, -32729},  {-1758, -32721},
    {-1909, -32712},  {-2060, -32703},  {-2210, -32693},  {-2360, -32683},  {-2511, -32672},  {-2661, -32660},
    {-2811, -32647},  {-2962, -32634},  {-3112, -32620},  {-3262, -32605},  {-3412, -32590},  {-3562, -32574},
    {-3712, -32557},  {-3861, -32540},  {-4011, -32522},  {-4161, -32503},  {-4310, -32483},  {-4460, -32463},
    {-4609, -32442},  {-4758, -32421},  {-4907, -32398},  {-5057, -32376},  {-5205, -32352},  {-5354, -32328},
    {-5503, -32303},  {-5652, -32277},  {-5800, -32251},  {-5948, -32224},  {-6097, -32196},  {-6245, -32167},
    {-6393, -32138},  {-6541, -32109},  {-6688, -32078},  {-6836, -32047},  {-6983, -32015},  {-7130, -31983},
    {-7278, -31950},  {-7425, -31916},  {-7571, -31881},  {-7718, -31846},  {-7864, -31810},  {-8011, -31774},
    {-8157, -31737},  {-8303, -31699},  {-8449, -31660},  {-8594, -31621},  {-8740, -31581},  {-8885, -31540},
    {-9030, -31499},  {-9175, -31457},  {-9319, -31415},  {-9464, -31372},  {-9608, -31328},  {-9752, -31283},
    {-9896, -31238},  {-10040, -31192}, {-10183, -31146}, {-10326, -31098}, {-10469, -31050}, {-10612, -31002},
    {-10755, -30953}, {-10897, -30903}, {-11039, -30853}, {-11181, -30801}, {-11323, -30750}, {-11464, -30697},
    {-11605, -30644}, {-11746, -30590}, {-11887, -30536}, {-12027, -30481}, {-12167, -30425}, {-12307, -30369},
    {-12447, -30312}, {-12586, -30254}, {-12725, -30196}, {-12864, -30137}, {-13003, -30078}, {-13141, -30018},
    {-13279, -29957}, {-13417, -29895}, {-13554, -29833}, {-13691, -29771}, {-13828, -29707}, {-13965, -29643},
    {-14101, -29579}, {-14237, -29514}, {-14373, -29448}, {-14508, -29381}, {-14643, -29314}, {-14778, -29247},
    {-14912, -29178}, {-15046, -29109}, {-15180, -29040}, {-15314, -28970}, {-15447, -28899}, {-15580, -28827},
    {-15712, -28755}, {-15844, -28683}, {-15976, -28610}, {-16108, -28536}, {-16239, -28461}, {-16369, -28386},
    {-16500, -28311}, {-16630, -28234}, {-16760, -28158}, {-16889, -28080}, {-17018, -28002}, {-17147, -27924},
    {-17275, -27844}, {-17403, -27765}, {-17531, -27684}, {-17658, -27603}, {-17785, -27522}, {-17911, -27440},
    {-18037, -27357}, {-18163, -27273}, {-18288, -27190}, {-18413, -27105}, {-18538, -27020}, {-18662, -26935},
    {-18786, -26848}, {-18909, -26762}, {-19032, -26674}, {-19155, -26586}, {-19277, -26498}, {-19399, -26409},
    {-19520, -26320}, {-19641, -26229}, {-19761, -26139}, {-19881, -26048}, {-20001, -25956}, {-20120, -25863},
    {-20239, -25771}, {-20357, -25677}, {-20475, -25583}, {-20593, -25489}, {-20710, -25394}, {-20827, -25298},
    {-20943, -25202}, {-21059, -25105}, {-21174, -25008}, {-21289, -24910}, {-21403, -24812}, {-21517, -24713},
    {-21631, -24614}, {-21744, -24514}, {-21856, -24414}, {-21968, -24313}, {-22080, -24212}, {-22191, -24110},
    {-22302, -24008}, {-22412, -23905}, {-22522, -23801}, {-22631, -23697}, {-22740, -23593}, {-22848, -23488},
    {-22956, -23383}, {-23064, -23277}, {-23170, -23170}, {-23277, -23064}, {-23383, -22956}, {-23488, -22848},
    {-23593, -22740}, {-23697, -22631}, {-23801, -22522}, {-23905, -22412}, {-24008, -22302}, {-24110, -22191},
    {-24212, -22080}, {-24313, -21968}, {-24414, -21856}, {-24514, -21744}, {-24614, -21631}, {-24713, -21517},
    {-24812, -21403}, {-24910, -21289}, {-25008, -21174}, {-25105, -21059}, {-25202, -20943}, {-25298, -20827},
    {-25394, -20710}, {-25489, -20593}, {-25583, -20475}, {-25677, -20357}, {-25771, -20239}, {-25863, -20120},
    {-25956, -20001}, {-26048, -19881}, {-26139, -19761}, {-26229, -19641}, {-26320, -19520}, {-26409, -19399},
    {-26498, -19277}, {-26586, -19155}, {-26674, -19032}, {-26762, -18909}, {-26848, -18786}, {-26935, -18662},
    {-27020, -18538}, {-27105, -18413}, {-27190, -18288}, {-27273, -18163}, {-27357, -18037}, {-27440, -17911},
    {-27522, -17785}, {-27603, -17658}, {-27684, -17531}, {-27765, -17403}, {-27844, -17275}, {-27924, -17147},
    {-28002, -17018}, {-28080, -16889}, {-28158, -16760}, {-28234, -16630}, {-28311, -16500}, {-28386, -16369},
    {-28461, -16239}, {-28536, -16108}, {-28610, -15976}, {-28683, -15844}, {-28755, -15712}, {-28827, -15580},
    {-28899, -15447}, {-28970, -15314}, {-29040, -15180}, {-29109, -15046}, {-29178, -14912}, {-29247, -14778},
    {-29314, -14643}, {-29381, -14508}, {-29448, -14373}, {-29514, -14237}, {-29579, -14101}, {-29643, -13965},
    {-29707, -13828}, {-29771, -13691}, {-29833, -13554}, {-29895, -13417}, {-29957, -13279}, {-30018, -13141},
    {-30078, -13003}, {-30137, -12864}, {-30196, -12725}, {-30254, -12586}, {-30312, -12447}, {-30369, -12307},
    {-30425, -12167}, {-30481, -12027}, {-30536, -11887}, {-30590, -11746}, {-30644, -11605}, {-30697, -11464},
    {-30750, -11323}, {-30801, -11181}, {-30853, -11039}, {-30903, -10897}, {-30953, -10755}, {-31002, -10612},
    {-31050, -10469}, {-31098, -10326}, {-31146, -10183}, {-31192, -10040}, {-31238, -9896},  {-31283, -9752},
    {-31328, -9608},  {-31372, -9464},  {-31415, -9319},  {-31457, -9175},  {-31499, -9030},  {-31540, -8885},
    {-31581, -8740},  {-31621, -8594},  {-31660, -8449},  {-31699, -8303},  {-31737, -8157},  {-31774, -8011},
    {-31810, -7864},  {-31846, -7718},  {-31881, -7571},  {-31916, -7425},  {-31950, -7278},  {-31983, -7130},
    {-32015, -6983},  {-32047, -6836},  {-32078, -6688},  {-32109, -6541},  {-32138, -6393},  {-32167, -6245},
    {-32196, -6097},  {-32224, -5948},  {-32251, -5800},  {-32277, -5652},  {-32303, -5503},  {-32328, -5354},
    {-32352, -5205},  {-32376, -5057},  {-32398, -4907},  {-32421, -4758},  {-32442, -4609},  {-32463, -4460},
    {-32483, -4310},  {-32503, -4161},  {-32522, -4011},  {-32540, -3861},  {-32557, -3712},  {-32574, -3562},
    {-32590, -3412},  {-32605, -3262},  {-32620, -3112},  {-32634, -2962},  {-32647, -2811},  {-32660, -2661},
    {-32672, -2511},  {-32683, -2360},  {-32693, -2210},  {-32703, -2060},  {-32712, -1909},  {-32721, -1758},
    {-32729, -1608},  {-32736, -1457},  {-32742, -1307},  {-32748, -1156},  {-32753, -1005},  {-32757, -854},
    {-32760, -704},   {-32763, -553},   {-32766, -402},   {-32767, -251},   {-32768, -101},   {-32768, 50},
    {-32767, 201},    {-32766, 352},    {-32764, 503},    {-32761, 653},    {-32758, 804},    {-32754, 955},
    {-32749, 1106},   {-32744, 1256},   {-32738, 1407},   {-32731, 1558},   {-32723, 1708},   {-32715, 1859},
    {-32706, 2009},   {-32697, 2160},   {-32686, 2310},   {-32675, 2461},   {-32664, 2611},   {-32651, 2761},
    {-32638, 2912},   {-32625, 3062},   {-32610, 3212},   {-32595, 3362},   {-32579, 3512},   {-32563, 3662},
    {-32546, 3812},   {-32528, 3961},   {-32509, 4111},   {-32490, 4260},   {-32470, 4410},   {-32449, 4559},
    {-32428, 4709},   {-32406, 4858},   {-32383, 5007},   {-32360, 5156},   {-32336, 5305},   {-32311, 5453},
    {-32286, 5602},   {-32259, 5751},   {-32233, 5899},   {-32205, 6047},   {-32177, 6195},   {-32148, 6343},
    {-32119, 6491},   {-32088, 6639},   {-32058, 6787},   {-32026, 6934},   {-31994, 7081},   {-31961, 7229},
    {-31927, 7376},   {-31893, 7522},   {-31858, 7669},   {-31822, 7816},   {-31786, 7962},   {-31749, 8108},
    {-31711, 8254},   {-31673, 8400},   {-31634, 8546},   {-31594, 8691},   {-31554, 8836},   {-31513, 8982},
    {-31471, 9127},   {-31429, 9271},   {-31386, 9416},   {-31342, 9560},   {-31298, 9704},   {-31253, 9848},
    {-31207, 9992},   {-31161, 10135},  {-31114, 10279},  {-31067, 10422},  {-31018, 10565},  {-30969, 10707},
    {-30920, 10850},  {-30869, 10992},  {-30819, 11134},  {-30767, 11276},  {-30715, 11417},  {-30662, 11558},
    {-30608, 11699},  {-30554, 11840},  {-30499, 11980},  {-30444, 12121},  {-30388, 12261},  {-30331, 12400},
    {-30274, 12540},  {-30216, 12679},  {-30157, 12818},  {-30098, 12957},  {-30038, 13095},  {-29977, 13233},
    {-29916, 13371},  {-29854, 13508},  {-29792, 13646},  {-29729, 13783},  {-29665, 13919},  {-29600, 14056},
    {-29535, 14192},  {-29470, 14327},  {-29404, 14463},  {-29337, 14598},  {-29269, 14733},  {-29201, 14867},
    {-29132, 15002},  {-29063, 15136},  {-28993, 15269},  {-28922, 15402},  {-28851, 15535},  {-28779, 15668},
    {-28707, 15800},  {-28634, 15932},  {-28560, 16064},  {-28486, 16195},  {-28411, 16326},  {-28336, 16456},
    {-28260, 16587},  {-28183, 16717},  {-28106, 16846},  {-28028, 16975},  {-27950, 17104},  {-27871, 17233},
    {-27791, 17361},  {-27711, 17488},  {-27630, 17616},  {-27549, 17743},  {-27467, 17869},  {-27384, 17995},
    {-27301, 18121},  {-27218, 18247},  {-27133, 18372},  {-27049, 18496},  {-26963, 18621},  {-26877, 18745},
    {-26791, 18868},  {-26704, 18991},  {-26616, 19114},  {-26528, 19236},  {-26439, 19358},  {-26349, 19479},
    {-26259, 19601},  {-26169, 19721},  {-26078, 19841},  {-25986, 19961},  {-25894, 20081},  {-25802, 20200},
    {-25708, 20318},  {-25615, 20436},  {-25520, 20554},  {-25425, 20671},  {-25330, 20788},  {-25234, 20904},
    {-25138, 21020},  {-25041, 21136},  {-24943, 21251},  {-24845, 21365},  {-24746, 21479},  {-24647, 21593},
    {-24548, 21706},  {-24448, 21819},  {-24347, 21931},  {-24246, 22043},  {-24144, 22154},  {-24042, 22265},
    {-23939, 22375},  {-23836, 22485},  {-23732, 22595},  {-23628, 22704},  {-23523, 22812},  {-23418, 22920},
    {-23312, 23028},  {-23206, 23135},  {-23099, 23241},  {-22992, 23348},  {-22884, 23453},  {-22776, 23558},
    {-22668, 23663},  {-22558, 23767},  {-22449, 23870},  {-22339, 23973},  {-22228, 24076},  {-22117, 24178},
    {-22006, 24279},  {-21894, 24380},  {-21781, 24481},  {-21668, 24581},  {-21555, 24680},  {-21441, 24779},
    {-21327, 24878},  {-21212, 24976},  {-21097, 25073},  {-20981, 25170},  {-20865, 25266},  {-20749, 25362},
    {-20632, 25457},  {-20515, 25552},  {-20397, 25646},  {-20279, 25739},  {-20160, 25833},  {-20041, 25925},
    {-19921, 26017},  {-19801, 26108},  {-19681, 26199},  {-19560, 26290},  {-19439, 26379},  {-19317, 26468},
    {-19195, 26557},  {-19073, 26645},  {-18950, 26733},  {-18827, 26820},  {-18703, 26906},  {-18579, 26992},
    {-18455, 27077},  {-18330, 27162},  {-18205, 27246},  {-18079, 27329},  {-17953, 27412},  {-17827, 27494},
    {-17700, 27576},  {-17573, 27657},  {-17446, 27738},  {-17318, 27818},  {-17190, 27897},  {-17061, 27976},
    {-16932, 28054},  {-16803, 28132},  {-16673, 28209},  {-16543, 28285},  {-16413, 28361},  {-16282, 28436},
    {-16151, 28511},  {-16020, 28585},  {-15888, 28658},  {-15756, 28731},  {-15624, 28803},  {-15491, 28875},
    {-15358, 28946},  {-15225, 29016},  {-15091, 29086},  {-14957, 29155},  {-14823, 29224},  {-14688, 29292},
    {-14553, 29359},  {-14418, 29426},  {-14282, 29492},  {-14146, 29557},  {-14010, 29622},  {-13874, 29686},
    {-13737, 29750},  {-13600, 29813},  {-13463, 29875},  {-13325, 29936},  {-13187, 29997},  {-13049, 30058},
    {-12910, 30118},  {-12772, 30177},  {-12633, 30235},  {-12493, 30293},  {-12354, 30350},  {-12214, 30407},
    {-12074, 30462},  {-11934, 30518},  {-11793, 30572},  {-11652, 30626},  {-11511, 30680},  {-11370, 30732},
    {-11228, 30784},  {-11087, 30836},  {-10945, 30886},  {-10802, 30936},  {-10660, 30986},  {-10517, 31034},
    {-10374, 31082},  {-10231, 31130},  {-10088, 31177},  {-9944, 31223},   {-9800, 31268},   {-9656, 31313},
    {-9512, 31357},   {-9368, 31400},   {-9223, 31443},   {-9078, 31485},   {-8933, 31527},   {-8788, 31568},
    {-8643, 31608},   {-8497, 31647},   {-8351, 31686},   {-8206, 31724},   {-8059, 31761},   {-7913, 31798},
    {-7767, 31834},   {-7620, 31870},   {-7473, 31904},   {-7327, 31938},   {-7180, 31972},   {-7032, 32005},
    {-6885, 32037},   {-6737, 32068},   {-6590, 32099},   {-6442, 32129},   {-6294, 32158},   {-6146, 32186},
    {-5998, 32214},   {-5850, 32242},   {-5701, 32268},   {-5553, 32294},   {-5404, 32319},   {-5255, 32344},
    {-5106, 32368},   {-4957, 32391},   {-4808, 32413},   {-4659, 32435},   {-4510, 32456},   {-4360, 32477},
    {-4211, 32496},   {-4061, 32515},   {-3911, 32534},   {-3762, 32551},   {-3612, 32568},   {-3462, 32585},
    {-3312, 32600},   {-3162, 32615},   {-3012, 32629},   {-2861, 32643},   {-2711, 32656},   {-2561, 32668},
    {-2411, 32679},   {-2260, 32690},   {-2110, 32700},   {-1959, 32709},   {-1809, 32718},   {-1658, 32726},
    {-1507, 32733},   {-1357, 32740},   {-1206, 32746},   {-1055, 32751},   {-905, 32756},    {-754, 32759},
    {-603, 32762},    {-452, 32765},    {-302, 32767},    {-151, 32767}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_cint15_r4_1_2[8] = {{16384, 0}, {-16384, 0}, {0, 0}, {0, 0},
                                                                      {0, 0},     {0, 0},      {0, 0}, {0, 0}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_cint15_r4_2_4[8] = {{16384, 0}, {-11585, -11585}, {0, 0}, {0, 0},
                                                                      {0, 0},     {0, 0},           {0, 0}, {0, 0}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_cint15_r4_4_8[8] = {
    {16384, 0}, {6270, -15137}, {-11585, -11585}, {-15137, 6270}, {0, 0}, {0, 0}, {0, 0}, {0, 0}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_cint15_r4_8_16[8] = {
    {16384, 0},       {13623, -9102},  {6270, -15137}, {-3196, -16069},
    {-11585, -11585}, {-16069, -3196}, {-15137, 6270}, {-9102, 13623}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_cint15_r4_16_32[16] = {
    {16384, 0},      {15679, -4756},  {13623, -9102},   {10394, -12665}, {6270, -15137},  {1606, -16305},
    {-3196, -16069}, {-7723, -14449}, {-11585, -11585}, {-14449, -7723}, {-16069, -3196}, {-16305, 1606},
    {-15137, 6270},  {-12665, 10394}, {-9102, 13623},   {-4756, 15679}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_cint15_r4_32_64[32] = {
    {16384, 0},      {16207, -2404},  {15679, -4756},  {14811, -7005},  {13623, -9102},   {12140, -11003},
    {10394, -12665}, {8423, -14053},  {6270, -15137},  {3981, -15893},  {1606, -16305},   {-804, -16364},
    {-3196, -16069}, {-5520, -15426}, {-7723, -14449}, {-9760, -13160}, {-11585, -11585}, {-13160, -9760},
    {-14449, -7723}, {-15426, -5520}, {-16069, -3196}, {-16364, -804},  {-16305, 1606},   {-15893, 3981},
    {-15137, 6270},  {-14053, 8423},  {-12665, 10394}, {-11003, 12140}, {-9102, 13623},   {-7005, 14811},
    {-4756, 15679},  {-2404, 16207}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_cint15_r4_64_128[64] = {
    {16384, 0},      {16340, -1205},   {16207, -2404},   {15986, -3590},   {15679, -4756},  {15286, -5897},
    {14811, -7005},  {14256, -8076},   {13623, -9102},   {12916, -10080},  {12140, -11003}, {11297, -11866},
    {10394, -12665}, {9434, -13395},   {8423, -14053},   {7366, -14635},   {6270, -15137},  {5139, -15557},
    {3981, -15893},  {2801, -16143},   {1606, -16305},   {402, -16379},    {-804, -16364},  {-2006, -16261},
    {-3196, -16069}, {-4370, -15791},  {-5520, -15426},  {-6639, -14978},  {-7723, -14449}, {-8765, -13842},
    {-9760, -13160}, {-10702, -12406}, {-11585, -11585}, {-12406, -10702}, {-13160, -9760}, {-13842, -8765},
    {-14449, -7723}, {-14978, -6639},  {-15426, -5520},  {-15791, -4370},  {-16069, -3196}, {-16261, -2006},
    {-16364, -804},  {-16379, 402},    {-16305, 1606},   {-16143, 2801},   {-15893, 3981},  {-15557, 5139},
    {-15137, 6270},  {-14635, 7366},   {-14053, 8423},   {-13395, 9434},   {-12665, 10394}, {-11866, 11297},
    {-11003, 12140}, {-10080, 12916},  {-9102, 13623},   {-8076, 14256},   {-7005, 14811},  {-5897, 15286},
    {-4756, 15679},  {-3590, 15986},   {-2404, 16207},   {-1205, 16340}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_cint15_r4_128_256[128] = {
    {16384, 0},       {16373, -603},    {16340, -1205},   {16284, -1806},   {16207, -2404},   {16107, -2999},
    {15986, -3590},   {15843, -4176},   {15679, -4756},   {15493, -5330},   {15286, -5897},   {15059, -6455},
    {14811, -7005},   {14543, -7545},   {14256, -8076},   {13949, -8595},   {13623, -9102},   {13279, -9598},
    {12916, -10080},  {12537, -10549},  {12140, -11003},  {11727, -11442},  {11297, -11866},  {10853, -12274},
    {10394, -12665},  {9921, -13039},   {9434, -13395},   {8935, -13733},   {8423, -14053},   {7900, -14354},
    {7366, -14635},   {6823, -14896},   {6270, -15137},   {5708, -15357},   {5139, -15557},   {4563, -15736},
    {3981, -15893},   {3393, -16029},   {2801, -16143},   {2205, -16235},   {1606, -16305},   {1005, -16353},
    {402, -16379},    {-201, -16383},   {-804, -16364},   {-1406, -16324},  {-2006, -16261},  {-2603, -16176},
    {-3196, -16069},  {-3786, -15941},  {-4370, -15791},  {-4948, -15619},  {-5520, -15426},  {-6084, -15213},
    {-6639, -14978},  {-7186, -14724},  {-7723, -14449},  {-8250, -14155},  {-8765, -13842},  {-9269, -13510},
    {-9760, -13160},  {-10238, -12792}, {-10702, -12406}, {-11151, -12004}, {-11585, -11585}, {-12004, -11151},
    {-12406, -10702}, {-12792, -10238}, {-13160, -9760},  {-13510, -9269},  {-13842, -8765},  {-14155, -8250},
    {-14449, -7723},  {-14724, -7186},  {-14978, -6639},  {-15213, -6084},  {-15426, -5520},  {-15619, -4948},
    {-15791, -4370},  {-15941, -3786},  {-16069, -3196},  {-16176, -2603},  {-16261, -2006},  {-16324, -1406},
    {-16364, -804},   {-16383, -201},   {-16379, 402},    {-16353, 1005},   {-16305, 1606},   {-16235, 2205},
    {-16143, 2801},   {-16029, 3393},   {-15893, 3981},   {-15736, 4563},   {-15557, 5139},   {-15357, 5708},
    {-15137, 6270},   {-14896, 6823},   {-14635, 7366},   {-14354, 7900},   {-14053, 8423},   {-13733, 8935},
    {-13395, 9434},   {-13039, 9921},   {-12665, 10394},  {-12274, 10853},  {-11866, 11297},  {-11442, 11727},
    {-11003, 12140},  {-10549, 12537},  {-10080, 12916},  {-9598, 13279},   {-9102, 13623},   {-8595, 13949},
    {-8076, 14256},   {-7545, 14543},   {-7005, 14811},   {-6455, 15059},   {-5897, 15286},   {-5330, 15493},
    {-4756, 15679},   {-4176, 15843},   {-3590, 15986},   {-2999, 16107},   {-2404, 16207},   {-1806, 16284},
    {-1205, 16340},   {-603, 16373}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_cint15_r4_256_512[256] = {
    {16384, 0},       {16381, -302},    {16373, -603},    {16359, -904},    {16340, -1205},   {16315, -1506},
    {16284, -1806},   {16248, -2105},   {16207, -2404},   {16160, -2702},   {16107, -2999},   {16049, -3295},
    {15986, -3590},   {15917, -3883},   {15843, -4176},   {15763, -4467},   {15679, -4756},   {15588, -5044},
    {15493, -5330},   {15392, -5614},   {15286, -5897},   {15175, -6177},   {15059, -6455},   {14937, -6731},
    {14811, -7005},   {14680, -7276},   {14543, -7545},   {14402, -7812},   {14256, -8076},   {14104, -8337},
    {13949, -8595},   {13788, -8850},   {13623, -9102},   {13453, -9352},   {13279, -9598},   {13100, -9841},
    {12916, -10080},  {12729, -10316},  {12537, -10549},  {12340, -10778},  {12140, -11003},  {11935, -11224},
    {11727, -11442},  {11514, -11656},  {11297, -11866},  {11077, -12072},  {10853, -12274},  {10625, -12472},
    {10394, -12665},  {10159, -12854},  {9921, -13039},   {9679, -13219},   {9434, -13395},   {9186, -13567},
    {8935, -13733},   {8680, -13896},   {8423, -14053},   {8163, -14206},   {7900, -14354},   {7635, -14497},
    {7366, -14635},   {7096, -14768},   {6823, -14896},   {6547, -15019},   {6270, -15137},   {5990, -15250},
    {5708, -15357},   {5425, -15460},   {5139, -15557},   {4852, -15649},   {4563, -15736},   {4273, -15817},
    {3981, -15893},   {3688, -15964},   {3393, -16029},   {3098, -16088},   {2801, -16143},   {2503, -16192},
    {2205, -16235},   {1906, -16273},   {1606, -16305},   {1306, -16332},   {1005, -16353},   {704, -16369},
    {402, -16379},    {101, -16384},    {-201, -16383},   {-503, -16376},   {-804, -16364},   {-1105, -16347},
    {-1406, -16324},  {-1706, -16295},  {-2006, -16261},  {-2305, -16221},  {-2603, -16176},  {-2900, -16125},
    {-3196, -16069},  {-3492, -16008},  {-3786, -15941},  {-4078, -15868},  {-4370, -15791},  {-4660, -15707},
    {-4948, -15619},  {-5235, -15525},  {-5520, -15426},  {-5803, -15322},  {-6084, -15213},  {-6363, -15098},
    {-6639, -14978},  {-6914, -14854},  {-7186, -14724},  {-7456, -14589},  {-7723, -14449},  {-7988, -14305},
    {-8250, -14155},  {-8509, -14001},  {-8765, -13842},  {-9019, -13678},  {-9269, -13510},  {-9516, -13337},
    {-9760, -13160},  {-10001, -12978}, {-10238, -12792}, {-10471, -12601}, {-10702, -12406}, {-10928, -12207},
    {-11151, -12004}, {-11370, -11797}, {-11585, -11585}, {-11797, -11370}, {-12004, -11151}, {-12207, -10928},
    {-12406, -10702}, {-12601, -10471}, {-12792, -10238}, {-12978, -10001}, {-13160, -9760},  {-13337, -9516},
    {-13510, -9269},  {-13678, -9019},  {-13842, -8765},  {-14001, -8509},  {-14155, -8250},  {-14305, -7988},
    {-14449, -7723},  {-14589, -7456},  {-14724, -7186},  {-14854, -6914},  {-14978, -6639},  {-15098, -6363},
    {-15213, -6084},  {-15322, -5803},  {-15426, -5520},  {-15525, -5235},  {-15619, -4948},  {-15707, -4660},
    {-15791, -4370},  {-15868, -4078},  {-15941, -3786},  {-16008, -3492},  {-16069, -3196},  {-16125, -2900},
    {-16176, -2603},  {-16221, -2305},  {-16261, -2006},  {-16295, -1706},  {-16324, -1406},  {-16347, -1105},
    {-16364, -804},   {-16376, -503},   {-16383, -201},   {-16384, 101},    {-16379, 402},    {-16369, 704},
    {-16353, 1005},   {-16332, 1306},   {-16305, 1606},   {-16273, 1906},   {-16235, 2205},   {-16192, 2503},
    {-16143, 2801},   {-16088, 3098},   {-16029, 3393},   {-15964, 3688},   {-15893, 3981},   {-15817, 4273},
    {-15736, 4563},   {-15649, 4852},   {-15557, 5139},   {-15460, 5425},   {-15357, 5708},   {-15250, 5990},
    {-15137, 6270},   {-15019, 6547},   {-14896, 6823},   {-14768, 7096},   {-14635, 7366},   {-14497, 7635},
    {-14354, 7900},   {-14206, 8163},   {-14053, 8423},   {-13896, 8680},   {-13733, 8935},   {-13567, 9186},
    {-13395, 9434},   {-13219, 9679},   {-13039, 9921},   {-12854, 10159},  {-12665, 10394},  {-12472, 10625},
    {-12274, 10853},  {-12072, 11077},  {-11866, 11297},  {-11656, 11514},  {-11442, 11727},  {-11224, 11935},
    {-11003, 12140},  {-10778, 12340},  {-10549, 12537},  {-10316, 12729},  {-10080, 12916},  {-9841, 13100},
    {-9598, 13279},   {-9352, 13453},   {-9102, 13623},   {-8850, 13788},   {-8595, 13949},   {-8337, 14104},
    {-8076, 14256},   {-7812, 14402},   {-7545, 14543},   {-7276, 14680},   {-7005, 14811},   {-6731, 14937},
    {-6455, 15059},   {-6177, 15175},   {-5897, 15286},   {-5614, 15392},   {-5330, 15493},   {-5044, 15588},
    {-4756, 15679},   {-4467, 15763},   {-4176, 15843},   {-3883, 15917},   {-3590, 15986},   {-3295, 16049},
    {-2999, 16107},   {-2702, 16160},   {-2404, 16207},   {-2105, 16248},   {-1806, 16284},   {-1506, 16315},
    {-1205, 16340},   {-904, 16359},    {-603, 16373},    {-302, 16381}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_cint15_r4_512_1024[512] = {
    {16384, 0},       {16383, -151},    {16381, -302},    {16378, -452},    {16373, -603},    {16367, -754},
    {16359, -904},    {16350, -1055},   {16340, -1205},   {16328, -1356},   {16315, -1506},   {16300, -1656},
    {16284, -1806},   {16267, -1956},   {16248, -2105},   {16228, -2255},   {16207, -2404},   {16184, -2553},
    {16160, -2702},   {16134, -2851},   {16107, -2999},   {16079, -3147},   {16049, -3295},   {16018, -3442},
    {15986, -3590},   {15952, -3737},   {15917, -3883},   {15881, -4030},   {15843, -4176},   {15804, -4321},
    {15763, -4467},   {15722, -4612},   {15679, -4756},   {15634, -4900},   {15588, -5044},   {15541, -5187},
    {15493, -5330},   {15443, -5472},   {15392, -5614},   {15340, -5756},   {15286, -5897},   {15231, -6037},
    {15175, -6177},   {15118, -6316},   {15059, -6455},   {14999, -6593},   {14937, -6731},   {14875, -6868},
    {14811, -7005},   {14746, -7141},   {14680, -7276},   {14612, -7411},   {14543, -7545},   {14473, -7679},
    {14402, -7812},   {14329, -7944},   {14256, -8076},   {14181, -8207},   {14104, -8337},   {14027, -8466},
    {13949, -8595},   {13869, -8723},   {13788, -8850},   {13706, -8977},   {13623, -9102},   {13538, -9227},
    {13453, -9352},   {13366, -9475},   {13279, -9598},   {13190, -9720},   {13100, -9841},   {13008, -9961},
    {12916, -10080},  {12823, -10198},  {12729, -10316},  {12633, -10433},  {12537, -10549},  {12439, -10663},
    {12340, -10778},  {12240, -10891},  {12140, -11003},  {12038, -11114},  {11935, -11224},  {11831, -11334},
    {11727, -11442},  {11621, -11550},  {11514, -11656},  {11406, -11762},  {11297, -11866},  {11188, -11970},
    {11077, -12072},  {10966, -12173},  {10853, -12274},  {10740, -12373},  {10625, -12472},  {10510, -12569},
    {10394, -12665},  {10277, -12760},  {10159, -12854},  {10040, -12947},  {9921, -13039},   {9800, -13130},
    {9679, -13219},   {9557, -13308},   {9434, -13395},   {9310, -13482},   {9186, -13567},   {9061, -13651},
    {8935, -13733},   {8808, -13815},   {8680, -13896},   {8552, -13975},   {8423, -14053},   {8293, -14130},
    {8163, -14206},   {8032, -14280},   {7900, -14354},   {7768, -14426},   {7635, -14497},   {7501, -14566},
    {7366, -14635},   {7231, -14702},   {7096, -14768},   {6960, -14832},   {6823, -14896},   {6685, -14958},
    {6547, -15019},   {6409, -15078},   {6270, -15137},   {6130, -15194},   {5990, -15250},   {5850, -15304},
    {5708, -15357},   {5567, -15409},   {5425, -15460},   {5282, -15509},   {5139, -15557},   {4996, -15604},
    {4852, -15649},   {4708, -15693},   {4563, -15736},   {4418, -15777},   {4273, -15817},   {4127, -15856},
    {3981, -15893},   {3835, -15929},   {3688, -15964},   {3541, -15997},   {3393, -16029},   {3246, -16059},
    {3098, -16088},   {2949, -16116},   {2801, -16143},   {2652, -16168},   {2503, -16192},   {2354, -16214},
    {2205, -16235},   {2055, -16255},   {1906, -16273},   {1756, -16290},   {1606, -16305},   {1456, -16319},
    {1306, -16332},   {1155, -16343},   {1005, -16353},   {854, -16362},    {704, -16369},    {553, -16375},
    {402, -16379},    {251, -16382},    {101, -16384},    {-50, -16384},    {-201, -16383},   {-352, -16380},
    {-503, -16376},   {-653, -16371},   {-804, -16364},   {-955, -16356},   {-1105, -16347},  {-1255, -16336},
    {-1406, -16324},  {-1556, -16310},  {-1706, -16295},  {-1856, -16279},  {-2006, -16261},  {-2155, -16242},
    {-2305, -16221},  {-2454, -16199},  {-2603, -16176},  {-2752, -16151},  {-2900, -16125},  {-3048, -16098},
    {-3196, -16069},  {-3344, -16039},  {-3492, -16008},  {-3639, -15975},  {-3786, -15941},  {-3932, -15905},
    {-4078, -15868},  {-4224, -15830},  {-4370, -15791},  {-4515, -15750},  {-4660, -15707},  {-4804, -15664},
    {-4948, -15619},  {-5092, -15573},  {-5235, -15525},  {-5377, -15476},  {-5520, -15426},  {-5661, -15375},
    {-5803, -15322},  {-5943, -15268},  {-6084, -15213},  {-6223, -15156},  {-6363, -15098},  {-6501, -15039},
    {-6639, -14978},  {-6777, -14917},  {-6914, -14854},  {-7050, -14789},  {-7186, -14724},  {-7321, -14657},
    {-7456, -14589},  {-7590, -14520},  {-7723, -14449},  {-7856, -14378},  {-7988, -14305},  {-8119, -14231},
    {-8250, -14155},  {-8380, -14079},  {-8509, -14001},  {-8638, -13922},  {-8765, -13842},  {-8892, -13761},
    {-9019, -13678},  {-9144, -13595},  {-9269, -13510},  {-9393, -13424},  {-9516, -13337},  {-9638, -13249},
    {-9760, -13160},  {-9881, -13069},  {-10001, -12978}, {-10120, -12885}, {-10238, -12792}, {-10355, -12697},
    {-10471, -12601}, {-10587, -12504}, {-10702, -12406}, {-10815, -12307}, {-10928, -12207}, {-11040, -12106},
    {-11151, -12004}, {-11261, -11901}, {-11370, -11797}, {-11478, -11691}, {-11585, -11585}, {-11691, -11478},
    {-11797, -11370}, {-11901, -11261}, {-12004, -11151}, {-12106, -11040}, {-12207, -10928}, {-12307, -10815},
    {-12406, -10702}, {-12504, -10587}, {-12601, -10471}, {-12697, -10355}, {-12792, -10238}, {-12885, -10120},
    {-12978, -10001}, {-13069, -9881},  {-13160, -9760},  {-13249, -9638},  {-13337, -9516},  {-13424, -9393},
    {-13510, -9269},  {-13595, -9144},  {-13678, -9019},  {-13761, -8892},  {-13842, -8765},  {-13922, -8638},
    {-14001, -8509},  {-14079, -8380},  {-14155, -8250},  {-14231, -8119},  {-14305, -7988},  {-14378, -7856},
    {-14449, -7723},  {-14520, -7590},  {-14589, -7456},  {-14657, -7321},  {-14724, -7186},  {-14789, -7050},
    {-14854, -6914},  {-14917, -6777},  {-14978, -6639},  {-15039, -6501},  {-15098, -6363},  {-15156, -6223},
    {-15213, -6084},  {-15268, -5943},  {-15322, -5803},  {-15375, -5661},  {-15426, -5520},  {-15476, -5377},
    {-15525, -5235},  {-15573, -5092},  {-15619, -4948},  {-15664, -4804},  {-15707, -4660},  {-15750, -4515},
    {-15791, -4370},  {-15830, -4224},  {-15868, -4078},  {-15905, -3932},  {-15941, -3786},  {-15975, -3639},
    {-16008, -3492},  {-16039, -3344},  {-16069, -3196},  {-16098, -3048},  {-16125, -2900},  {-16151, -2752},
    {-16176, -2603},  {-16199, -2454},  {-16221, -2305},  {-16242, -2155},  {-16261, -2006},  {-16279, -1856},
    {-16295, -1706},  {-16310, -1556},  {-16324, -1406},  {-16336, -1255},  {-16347, -1105},  {-16356, -955},
    {-16364, -804},   {-16371, -653},   {-16376, -503},   {-16380, -352},   {-16383, -201},   {-16384, -50},
    {-16384, 101},    {-16382, 251},    {-16379, 402},    {-16375, 553},    {-16369, 704},    {-16362, 854},
    {-16353, 1005},   {-16343, 1155},   {-16332, 1306},   {-16319, 1456},   {-16305, 1606},   {-16290, 1756},
    {-16273, 1906},   {-16255, 2055},   {-16235, 2205},   {-16214, 2354},   {-16192, 2503},   {-16168, 2652},
    {-16143, 2801},   {-16116, 2949},   {-16088, 3098},   {-16059, 3246},   {-16029, 3393},   {-15997, 3541},
    {-15964, 3688},   {-15929, 3835},   {-15893, 3981},   {-15856, 4127},   {-15817, 4273},   {-15777, 4418},
    {-15736, 4563},   {-15693, 4708},   {-15649, 4852},   {-15604, 4996},   {-15557, 5139},   {-15509, 5282},
    {-15460, 5425},   {-15409, 5567},   {-15357, 5708},   {-15304, 5850},   {-15250, 5990},   {-15194, 6130},
    {-15137, 6270},   {-15078, 6409},   {-15019, 6547},   {-14958, 6685},   {-14896, 6823},   {-14832, 6960},
    {-14768, 7096},   {-14702, 7231},   {-14635, 7366},   {-14566, 7501},   {-14497, 7635},   {-14426, 7768},
    {-14354, 7900},   {-14280, 8032},   {-14206, 8163},   {-14130, 8293},   {-14053, 8423},   {-13975, 8552},
    {-13896, 8680},   {-13815, 8808},   {-13733, 8935},   {-13651, 9061},   {-13567, 9186},   {-13482, 9310},
    {-13395, 9434},   {-13308, 9557},   {-13219, 9679},   {-13130, 9800},   {-13039, 9921},   {-12947, 10040},
    {-12854, 10159},  {-12760, 10277},  {-12665, 10394},  {-12569, 10510},  {-12472, 10625},  {-12373, 10740},
    {-12274, 10853},  {-12173, 10966},  {-12072, 11077},  {-11970, 11188},  {-11866, 11297},  {-11762, 11406},
    {-11656, 11514},  {-11550, 11621},  {-11442, 11727},  {-11334, 11831},  {-11224, 11935},  {-11114, 12038},
    {-11003, 12140},  {-10891, 12240},  {-10778, 12340},  {-10663, 12439},  {-10549, 12537},  {-10433, 12633},
    {-10316, 12729},  {-10198, 12823},  {-10080, 12916},  {-9961, 13008},   {-9841, 13100},   {-9720, 13190},
    {-9598, 13279},   {-9475, 13366},   {-9352, 13453},   {-9227, 13538},   {-9102, 13623},   {-8977, 13706},
    {-8850, 13788},   {-8723, 13869},   {-8595, 13949},   {-8466, 14027},   {-8337, 14104},   {-8207, 14181},
    {-8076, 14256},   {-7944, 14329},   {-7812, 14402},   {-7679, 14473},   {-7545, 14543},   {-7411, 14612},
    {-7276, 14680},   {-7141, 14746},   {-7005, 14811},   {-6868, 14875},   {-6731, 14937},   {-6593, 14999},
    {-6455, 15059},   {-6316, 15118},   {-6177, 15175},   {-6037, 15231},   {-5897, 15286},   {-5756, 15340},
    {-5614, 15392},   {-5472, 15443},   {-5330, 15493},   {-5187, 15541},   {-5044, 15588},   {-4900, 15634},
    {-4756, 15679},   {-4612, 15722},   {-4467, 15763},   {-4321, 15804},   {-4176, 15843},   {-4030, 15881},
    {-3883, 15917},   {-3737, 15952},   {-3590, 15986},   {-3442, 16018},   {-3295, 16049},   {-3147, 16079},
    {-2999, 16107},   {-2851, 16134},   {-2702, 16160},   {-2553, 16184},   {-2404, 16207},   {-2255, 16228},
    {-2105, 16248},   {-1956, 16267},   {-1806, 16284},   {-1656, 16300},   {-1506, 16315},   {-1356, 16328},
    {-1205, 16340},   {-1055, 16350},   {-904, 16359},    {-754, 16367},    {-603, 16373},    {-452, 16378},
    {-302, 16381},    {-151, 16383}};

alignas(__ALIGN_BYTE_SIZE__) const cint16 fft_lut_cint15_r4_1024_2048[1024] = {
    {16384, 0},       {16384, -75},     {16383, -151},    {16382, -226},    {16381, -302},    {16380, -377},
    {16378, -452},    {16375, -528},    {16373, -603},    {16370, -678},    {16367, -754},    {16363, -829},
    {16359, -904},    {16355, -980},    {16350, -1055},   {16345, -1130},   {16340, -1205},   {16334, -1280},
    {16328, -1356},   {16321, -1431},   {16315, -1506},   {16308, -1581},   {16300, -1656},   {16292, -1731},
    {16284, -1806},   {16276, -1881},   {16267, -1956},   {16258, -2031},   {16248, -2105},   {16238, -2180},
    {16228, -2255},   {16218, -2329},   {16207, -2404},   {16195, -2479},   {16184, -2553},   {16172, -2628},
    {16160, -2702},   {16147, -2776},   {16134, -2851},   {16121, -2925},   {16107, -2999},   {16093, -3073},
    {16079, -3147},   {16064, -3221},   {16049, -3295},   {16034, -3369},   {16018, -3442},   {16002, -3516},
    {15986, -3590},   {15969, -3663},   {15952, -3737},   {15935, -3810},   {15917, -3883},   {15899, -3957},
    {15881, -4030},   {15862, -4103},   {15843, -4176},   {15824, -4249},   {15804, -4321},   {15784, -4394},
    {15763, -4467},   {15743, -4539},   {15722, -4612},   {15700, -4684},   {15679, -4756},   {15656, -4828},
    {15634, -4900},   {15611, -4972},   {15588, -5044},   {15565, -5115},   {15541, -5187},   {15517, -5259},
    {15493, -5330},   {15468, -5401},   {15443, -5472},   {15418, -5543},   {15392, -5614},   {15366, -5685},
    {15340, -5756},   {15313, -5826},   {15286, -5897},   {15259, -5967},   {15231, -6037},   {15203, -6107},
    {15175, -6177},   {15146, -6247},   {15118, -6316},   {15088, -6386},   {15059, -6455},   {15029, -6524},
    {14999, -6593},   {14968, -6662},   {14937, -6731},   {14906, -6800},   {14875, -6868},   {14843, -6937},
    {14811, -7005},   {14779, -7073},   {14746, -7141},   {14713, -7209},   {14680, -7276},   {14646, -7344},
    {14612, -7411},   {14578, -7478},   {14543, -7545},   {14508, -7612},   {14473, -7679},   {14438, -7746},
    {14402, -7812},   {14366, -7878},   {14329, -7944},   {14293, -8010},   {14256, -8076},   {14218, -8141},
    {14181, -8207},   {14143, -8272},   {14104, -8337},   {14066, -8401},   {14027, -8466},   {13988, -8531},
    {13949, -8595},   {13909, -8659},   {13869, -8723},   {13829, -8787},   {13788, -8850},   {13747, -8914},
    {13706, -8977},   {13665, -9040},   {13623, -9102},   {13581, -9165},   {13538, -9227},   {13496, -9290},
    {13453, -9352},   {13410, -9413},   {13366, -9475},   {13323, -9537},   {13279, -9598},   {13234, -9659},
    {13190, -9720},   {13145, -9780},   {13100, -9841},   {13054, -9901},   {13008, -9961},   {12963, -10020},
    {12916, -10080},  {12870, -10139},  {12823, -10198},  {12776, -10257},  {12729, -10316},  {12681, -10374},
    {12633, -10433},  {12585, -10491},  {12537, -10549},  {12488, -10606},  {12439, -10663},  {12390, -10721},
    {12340, -10778},  {12290, -10834},  {12240, -10891},  {12190, -10947},  {12140, -11003},  {12089, -11059},
    {12038, -11114},  {11987, -11169},  {11935, -11224},  {11883, -11279},  {11831, -11334},  {11779, -11388},
    {11727, -11442},  {11674, -11496},  {11621, -11550},  {11567, -11603},  {11514, -11656},  {11460, -11709},
    {11406, -11762},  {11352, -11814},  {11297, -11866},  {11243, -11918},  {11188, -11970},  {11133, -12021},
    {11077, -12072},  {11021, -12123},  {10966, -12173},  {10909, -12224},  {10853, -12274},  {10796, -12324},
    {10740, -12373},  {10683, -12423},  {10625, -12472},  {10568, -12520},  {10510, -12569},  {10452, -12617},
    {10394, -12665},  {10336, -12713},  {10277, -12760},  {10218, -12807},  {10159, -12854},  {10100, -12901},
    {10040, -12947},  {9981, -12993},   {9921, -13039},   {9861, -13085},   {9800, -13130},   {9740, -13175},
    {9679, -13219},   {9618, -13264},   {9557, -13308},   {9496, -13352},   {9434, -13395},   {9372, -13439},
    {9310, -13482},   {9248, -13524},   {9186, -13567},   {9123, -13609},   {9061, -13651},   {8998, -13692},
    {8935, -13733},   {8871, -13774},   {8808, -13815},   {8744, -13856},   {8680, -13896},   {8616, -13935},
    {8552, -13975},   {8488, -14014},   {8423, -14053},   {8358, -14092},   {8293, -14130},   {8228, -14168},
    {8163, -14206},   {8098, -14243},   {8032, -14280},   {7966, -14317},   {7900, -14354},   {7834, -14390},
    {7768, -14426},   {7701, -14461},   {7635, -14497},   {7568, -14531},   {7501, -14566},   {7434, -14601},
    {7366, -14635},   {7299, -14668},   {7231, -14702},   {7164, -14735},   {7096, -14768},   {7028, -14800},
    {6960, -14832},   {6891, -14864},   {6823, -14896},   {6754, -14927},   {6685, -14958},   {6616, -14989},
    {6547, -15019},   {6478, -15049},   {6409, -15078},   {6339, -15108},   {6270, -15137},   {6200, -15166},
    {6130, -15194},   {6060, -15222},   {5990, -15250},   {5920, -15277},   {5850, -15304},   {5779, -15331},
    {5708, -15357},   {5638, -15383},   {5567, -15409},   {5496, -15435},   {5425, -15460},   {5354, -15485},
    {5282, -15509},   {5211, -15533},   {5139, -15557},   {5068, -15581},   {4996, -15604},   {4924, -15627},
    {4852, -15649},   {4780, -15671},   {4708, -15693},   {4636, -15715},   {4563, -15736},   {4491, -15757},
    {4418, -15777},   {4346, -15797},   {4273, -15817},   {4200, -15837},   {4127, -15856},   {4054, -15875},
    {3981, -15893},   {3908, -15911},   {3835, -15929},   {3761, -15946},   {3688, -15964},   {3614, -15980},
    {3541, -15997},   {3467, -16013},   {3393, -16029},   {3320, -16044},   {3246, -16059},   {3172, -16074},
    {3098, -16088},   {3024, -16103},   {2949, -16116},   {2875, -16130},   {2801, -16143},   {2727, -16156},
    {2652, -16168},   {2578, -16180},   {2503, -16192},   {2429, -16203},   {2354, -16214},   {2280, -16225},
    {2205, -16235},   {2130, -16245},   {2055, -16255},   {1981, -16264},   {1906, -16273},   {1831, -16281},
    {1756, -16290},   {1681, -16298},   {1606, -16305},   {1531, -16312},   {1456, -16319},   {1381, -16326},
    {1306, -16332},   {1230, -16338},   {1155, -16343},   {1080, -16348},   {1005, -16353},   {929, -16358},
    {854, -16362},    {779, -16365},    {704, -16369},    {628, -16372},    {553, -16375},    {477, -16377},
    {402, -16379},    {327, -16381},    {251, -16382},    {176, -16383},    {101, -16384},    {25, -16384},
    {-50, -16384},    {-126, -16384},   {-201, -16383},   {-276, -16382},   {-352, -16380},   {-427, -16378},
    {-503, -16376},   {-578, -16374},   {-653, -16371},   {-729, -16368},   {-804, -16364},   {-879, -16360},
    {-955, -16356},   {-1030, -16352},  {-1105, -16347},  {-1180, -16341},  {-1255, -16336},  {-1331, -16330},
    {-1406, -16324},  {-1481, -16317},  {-1556, -16310},  {-1631, -16303},  {-1706, -16295},  {-1781, -16287},
    {-1856, -16279},  {-1931, -16270},  {-2006, -16261},  {-2080, -16251},  {-2155, -16242},  {-2230, -16232},
    {-2305, -16221},  {-2379, -16210},  {-2454, -16199},  {-2528, -16188},  {-2603, -16176},  {-2677, -16164},
    {-2752, -16151},  {-2826, -16138},  {-2900, -16125},  {-2974, -16112},  {-3048, -16098},  {-3122, -16084},
    {-3196, -16069},  {-3270, -16054},  {-3344, -16039},  {-3418, -16024},  {-3492, -16008},  {-3565, -15991},
    {-3639, -15975},  {-3712, -15958},  {-3786, -15941},  {-3859, -15923},  {-3932, -15905},  {-4005, -15887},
    {-4078, -15868},  {-4151, -15849},  {-4224, -15830},  {-4297, -15810},  {-4370, -15791},  {-4442, -15770},
    {-4515, -15750},  {-4587, -15729},  {-4660, -15707},  {-4732, -15686},  {-4804, -15664},  {-4876, -15642},
    {-4948, -15619},  {-5020, -15596},  {-5092, -15573},  {-5163, -15549},  {-5235, -15525},  {-5306, -15501},
    {-5377, -15476},  {-5449, -15451},  {-5520, -15426},  {-5591, -15401},  {-5661, -15375},  {-5732, -15349},
    {-5803, -15322},  {-5873, -15295},  {-5943, -15268},  {-6014, -15240},  {-6084, -15213},  {-6154, -15184},
    {-6223, -15156},  {-6293, -15127},  {-6363, -15098},  {-6432, -15069},  {-6501, -15039},  {-6570, -15009},
    {-6639, -14978},  {-6708, -14948},  {-6777, -14917},  {-6846, -14885},  {-6914, -14854},  {-6982, -14822},
    {-7050, -14789},  {-7118, -14757},  {-7186, -14724},  {-7254, -14691},  {-7321, -14657},  {-7389, -14623},
    {-7456, -14589},  {-7523, -14555},  {-7590, -14520},  {-7657, -14485},  {-7723, -14449},  {-7790, -14414},
    {-7856, -14378},  {-7922, -14341},  {-7988, -14305},  {-8054, -14268},  {-8119, -14231},  {-8185, -14193},
    {-8250, -14155},  {-8315, -14117},  {-8380, -14079},  {-8445, -14040},  {-8509, -14001},  {-8573, -13962},
    {-8638, -13922},  {-8702, -13882},  {-8765, -13842},  {-8829, -13802},  {-8892, -13761},  {-8956, -13720},
    {-9019, -13678},  {-9082, -13637},  {-9144, -13595},  {-9207, -13553},  {-9269, -13510},  {-9331, -13467},
    {-9393, -13424},  {-9455, -13381},  {-9516, -13337},  {-9577, -13293},  {-9638, -13249},  {-9699, -13205},
    {-9760, -13160},  {-9820, -13115},  {-9881, -13069},  {-9941, -13024},  {-10001, -12978}, {-10060, -12932},
    {-10120, -12885}, {-10179, -12839}, {-10238, -12792}, {-10296, -12744}, {-10355, -12697}, {-10413, -12649},
    {-10471, -12601}, {-10529, -12553}, {-10587, -12504}, {-10644, -12455}, {-10702, -12406}, {-10759, -12357},
    {-10815, -12307}, {-10872, -12257}, {-10928, -12207}, {-10984, -12157}, {-11040, -12106}, {-11096, -12055},
    {-11151, -12004}, {-11206, -11952}, {-11261, -11901}, {-11316, -11849}, {-11370, -11797}, {-11424, -11744},
    {-11478, -11691}, {-11532, -11638}, {-11585, -11585}, {-11638, -11532}, {-11691, -11478}, {-11744, -11424},
    {-11797, -11370}, {-11849, -11316}, {-11901, -11261}, {-11952, -11206}, {-12004, -11151}, {-12055, -11096},
    {-12106, -11040}, {-12157, -10984}, {-12207, -10928}, {-12257, -10872}, {-12307, -10815}, {-12357, -10759},
    {-12406, -10702}, {-12455, -10644}, {-12504, -10587}, {-12553, -10529}, {-12601, -10471}, {-12649, -10413},
    {-12697, -10355}, {-12744, -10296}, {-12792, -10238}, {-12839, -10179}, {-12885, -10120}, {-12932, -10060},
    {-12978, -10001}, {-13024, -9941},  {-13069, -9881},  {-13115, -9820},  {-13160, -9760},  {-13205, -9699},
    {-13249, -9638},  {-13293, -9577},  {-13337, -9516},  {-13381, -9455},  {-13424, -9393},  {-13467, -9331},
    {-13510, -9269},  {-13553, -9207},  {-13595, -9144},  {-13637, -9082},  {-13678, -9019},  {-13720, -8956},
    {-13761, -8892},  {-13802, -8829},  {-13842, -8765},  {-13882, -8702},  {-13922, -8638},  {-13962, -8573},
    {-14001, -8509},  {-14040, -8445},  {-14079, -8380},  {-14117, -8315},  {-14155, -8250},  {-14193, -8185},
    {-14231, -8119},  {-14268, -8054},  {-14305, -7988},  {-14341, -7922},  {-14378, -7856},  {-14414, -7790},
    {-14449, -7723},  {-14485, -7657},  {-14520, -7590},  {-14555, -7523},  {-14589, -7456},  {-14623, -7389},
    {-14657, -7321},  {-14691, -7254},  {-14724, -7186},  {-14757, -7118},  {-14789, -7050},  {-14822, -6982},
    {-14854, -6914},  {-14885, -6846},  {-14917, -6777},  {-14948, -6708},  {-14978, -6639},  {-15009, -6570},
    {-15039, -6501},  {-15069, -6432},  {-15098, -6363},  {-15127, -6293},  {-15156, -6223},  {-15184, -6154},
    {-15213, -6084},  {-15240, -6014},  {-15268, -5943},  {-15295, -5873},  {-15322, -5803},  {-15349, -5732},
    {-15375, -5661},  {-15401, -5591},  {-15426, -5520},  {-15451, -5449},  {-15476, -5377},  {-15501, -5306},
    {-15525, -5235},  {-15549, -5163},  {-15573, -5092},  {-15596, -5020},  {-15619, -4948},  {-15642, -4876},
    {-15664, -4804},  {-15686, -4732},  {-15707, -4660},  {-15729, -4587},  {-15750, -4515},  {-15770, -4442},
    {-15791, -4370},  {-15810, -4297},  {-15830, -4224},  {-15849, -4151},  {-15868, -4078},  {-15887, -4005},
    {-15905, -3932},  {-15923, -3859},  {-15941, -3786},  {-15958, -3712},  {-15975, -3639},  {-15991, -3565},
    {-16008, -3492},  {-16024, -3418},  {-16039, -3344},  {-16054, -3270},  {-16069, -3196},  {-16084, -3122},
    {-16098, -3048},  {-16112, -2974},  {-16125, -2900},  {-16138, -2826},  {-16151, -2752},  {-16164, -2677},
    {-16176, -2603},  {-16188, -2528},  {-16199, -2454},  {-16210, -2379},  {-16221, -2305},  {-16232, -2230},
    {-16242, -2155},  {-16251, -2080},  {-16261, -2006},  {-16270, -1931},  {-16279, -1856},  {-16287, -1781},
    {-16295, -1706},  {-16303, -1631},  {-16310, -1556},  {-16317, -1481},  {-16324, -1406},  {-16330, -1331},
    {-16336, -1255},  {-16341, -1180},  {-16347, -1105},  {-16352, -1030},  {-16356, -955},   {-16360, -879},
    {-16364, -804},   {-16368, -729},   {-16371, -653},   {-16374, -578},   {-16376, -503},   {-16378, -427},
    {-16380, -352},   {-16382, -276},   {-16383, -201},   {-16384, -126},   {-16384, -50},    {-16384, 25},
    {-16384, 101},    {-16383, 176},    {-16382, 251},    {-16381, 327},    {-16379, 402},    {-16377, 477},
    {-16375, 553},    {-16372, 628},    {-16369, 704},    {-16365, 779},    {-16362, 854},    {-16358, 929},
    {-16353, 1005},   {-16348, 1080},   {-16343, 1155},   {-16338, 1230},   {-16332, 1306},   {-16326, 1381},
    {-16319, 1456},   {-16312, 1531},   {-16305, 1606},   {-16298, 1681},   {-16290, 1756},   {-16281, 1831},
    {-16273, 1906},   {-16264, 1981},   {-16255, 2055},   {-16245, 2130},   {-16235, 2205},   {-16225, 2280},
    {-16214, 2354},   {-16203, 2429},   {-16192, 2503},   {-16180, 2578},   {-16168, 2652},   {-16156, 2727},
    {-16143, 2801},   {-16130, 2875},   {-16116, 2949},   {-16103, 3024},   {-16088, 3098},   {-16074, 3172},
    {-16059, 3246},   {-16044, 3320},   {-16029, 3393},   {-16013, 3467},   {-15997, 3541},   {-15980, 3614},
    {-15964, 3688},   {-15946, 3761},   {-15929, 3835},   {-15911, 3908},   {-15893, 3981},   {-15875, 4054},
    {-15856, 4127},   {-15837, 4200},   {-15817, 4273},   {-15797, 4346},   {-15777, 4418},   {-15757, 4491},
    {-15736, 4563},   {-15715, 4636},   {-15693, 4708},   {-15671, 4780},   {-15649, 4852},   {-15627, 4924},
    {-15604, 4996},   {-15581, 5068},   {-15557, 5139},   {-15533, 5211},   {-15509, 5282},   {-15485, 5354},
    {-15460, 5425},   {-15435, 5496},   {-15409, 5567},   {-15383, 5638},   {-15357, 5708},   {-15331, 5779},
    {-15304, 5850},   {-15277, 5920},   {-15250, 5990},   {-15222, 6060},   {-15194, 6130},   {-15166, 6200},
    {-15137, 6270},   {-15108, 6339},   {-15078, 6409},   {-15049, 6478},   {-15019, 6547},   {-14989, 6616},
    {-14958, 6685},   {-14927, 6754},   {-14896, 6823},   {-14864, 6891},   {-14832, 6960},   {-14800, 7028},
    {-14768, 7096},   {-14735, 7164},   {-14702, 7231},   {-14668, 7299},   {-14635, 7366},   {-14601, 7434},
    {-14566, 7501},   {-14531, 7568},   {-14497, 7635},   {-14461, 7701},   {-14426, 7768},   {-14390, 7834},
    {-14354, 7900},   {-14317, 7966},   {-14280, 8032},   {-14243, 8098},   {-14206, 8163},   {-14168, 8228},
    {-14130, 8293},   {-14092, 8358},   {-14053, 8423},   {-14014, 8488},   {-13975, 8552},   {-13935, 8616},
    {-13896, 8680},   {-13856, 8744},   {-13815, 8808},   {-13774, 8871},   {-13733, 8935},   {-13692, 8998},
    {-13651, 9061},   {-13609, 9123},   {-13567, 9186},   {-13524, 9248},   {-13482, 9310},   {-13439, 9372},
    {-13395, 9434},   {-13352, 9496},   {-13308, 9557},   {-13264, 9618},   {-13219, 9679},   {-13175, 9740},
    {-13130, 9800},   {-13085, 9861},   {-13039, 9921},   {-12993, 9981},   {-12947, 10040},  {-12901, 10100},
    {-12854, 10159},  {-12807, 10218},  {-12760, 10277},  {-12713, 10336},  {-12665, 10394},  {-12617, 10452},
    {-12569, 10510},  {-12520, 10568},  {-12472, 10625},  {-12423, 10683},  {-12373, 10740},  {-12324, 10796},
    {-12274, 10853},  {-12224, 10909},  {-12173, 10966},  {-12123, 11021},  {-12072, 11077},  {-12021, 11133},
    {-11970, 11188},  {-11918, 11243},  {-11866, 11297},  {-11814, 11352},  {-11762, 11406},  {-11709, 11460},
    {-11656, 11514},  {-11603, 11567},  {-11550, 11621},  {-11496, 11674},  {-11442, 11727},  {-11388, 11779},
    {-11334, 11831},  {-11279, 11883},  {-11224, 11935},  {-11169, 11987},  {-11114, 12038},  {-11059, 12089},
    {-11003, 12140},  {-10947, 12190},  {-10891, 12240},  {-10834, 12290},  {-10778, 12340},  {-10721, 12390},
    {-10663, 12439},  {-10606, 12488},  {-10549, 12537},  {-10491, 12585},  {-10433, 12633},  {-10374, 12681},
    {-10316, 12729},  {-10257, 12776},  {-10198, 12823},  {-10139, 12870},  {-10080, 12916},  {-10020, 12963},
    {-9961, 13008},   {-9901, 13054},   {-9841, 13100},   {-9780, 13145},   {-9720, 13190},   {-9659, 13234},
    {-9598, 13279},   {-9537, 13323},   {-9475, 13366},   {-9413, 13410},   {-9352, 13453},   {-9290, 13496},
    {-9227, 13538},   {-9165, 13581},   {-9102, 13623},   {-9040, 13665},   {-8977, 13706},   {-8914, 13747},
    {-8850, 13788},   {-8787, 13829},   {-8723, 13869},   {-8659, 13909},   {-8595, 13949},   {-8531, 13988},
    {-8466, 14027},   {-8401, 14066},   {-8337, 14104},   {-8272, 14143},   {-8207, 14181},   {-8141, 14218},
    {-8076, 14256},   {-8010, 14293},   {-7944, 14329},   {-7878, 14366},   {-7812, 14402},   {-7746, 14438},
    {-7679, 14473},   {-7612, 14508},   {-7545, 14543},   {-7478, 14578},   {-7411, 14612},   {-7344, 14646},
    {-7276, 14680},   {-7209, 14713},   {-7141, 14746},   {-7073, 14779},   {-7005, 14811},   {-6937, 14843},
    {-6868, 14875},   {-6800, 14906},   {-6731, 14937},   {-6662, 14968},   {-6593, 14999},   {-6524, 15029},
    {-6455, 15059},   {-6386, 15088},   {-6316, 15118},   {-6247, 15146},   {-6177, 15175},   {-6107, 15203},
    {-6037, 15231},   {-5967, 15259},   {-5897, 15286},   {-5826, 15313},   {-5756, 15340},   {-5685, 15366},
    {-5614, 15392},   {-5543, 15418},   {-5472, 15443},   {-5401, 15468},   {-5330, 15493},   {-5259, 15517},
    {-5187, 15541},   {-5115, 15565},   {-5044, 15588},   {-4972, 15611},   {-4900, 15634},   {-4828, 15656},
    {-4756, 15679},   {-4684, 15700},   {-4612, 15722},   {-4539, 15743},   {-4467, 15763},   {-4394, 15784},
    {-4321, 15804},   {-4249, 15824},   {-4176, 15843},   {-4103, 15862},   {-4030, 15881},   {-3957, 15899},
    {-3883, 15917},   {-3810, 15935},   {-3737, 15952},   {-3663, 15969},   {-3590, 15986},   {-3516, 16002},
    {-3442, 16018},   {-3369, 16034},   {-3295, 16049},   {-3221, 16064},   {-3147, 16079},   {-3073, 16093},
    {-2999, 16107},   {-2925, 16121},   {-2851, 16134},   {-2776, 16147},   {-2702, 16160},   {-2628, 16172},
    {-2553, 16184},   {-2479, 16195},   {-2404, 16207},   {-2329, 16218},   {-2255, 16228},   {-2180, 16238},
    {-2105, 16248},   {-2031, 16258},   {-1956, 16267},   {-1881, 16276},   {-1806, 16284},   {-1731, 16292},
    {-1656, 16300},   {-1581, 16308},   {-1506, 16315},   {-1431, 16321},   {-1356, 16328},   {-1280, 16334},
    {-1205, 16340},   {-1130, 16345},   {-1055, 16350},   {-980, 16355},    {-904, 16359},    {-829, 16363},
    {-754, 16367},    {-678, 16370},    {-603, 16373},    {-528, 16375},    {-452, 16378},    {-377, 16380},
    {-302, 16381},    {-226, 16382},    {-151, 16383},    {-75, 16384}};

#endif //__FFT_R4_TWIDDLE_LUT_DIT_ALL_H__
