/*
 * Copyright (C) 2019-2022, Xilinx, Inc.
 * Copyright (C) 2022-2025, Advanced Micro Devices, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef __FFT_TWIDDLE_LUT_DIT_CFLOAT_H__
#define __FFT_TWIDDLE_LUT_DIT_CFLOAT_H__

#include "fft_com_inc.h"
// DO NOT HAND EDIT THIS FILE. IT WAS CREATED using L1/tests/inc/twiddle.c

alignas(__ALIGN_BYTE_SIZE__) const cfloat fft_lut_tw2048_cfloat[2048] = {
    {1.000000000, -0.000000000},  {0.999998808, -0.001533980},  {0.999995291, -0.003067957},
    {0.999989390, -0.004601926},  {0.999981165, -0.006135885},  {0.999970615, -0.007669829},
    {0.999957621, -0.009203754},  {0.999942362, -0.010737659},  {0.999924719, -0.012271538},
    {0.999904692, -0.013805388},  {0.999882340, -0.015339206},  {0.999857664, -0.016872987},
    {0.999830604, -0.018406730},  {0.999801159, -0.019940428},  {0.999769390, -0.021474080},
    {0.999735296, -0.023007682},  {0.999698818, -0.024541229},  {0.999660015, -0.026074719},
    {0.999618828, -0.027608145},  {0.999575317, -0.029141508},  {0.999529421, -0.030674804},
    {0.999481201, -0.032208025},  {0.999430597, -0.033741172},  {0.999377668, -0.035274237},
    {0.999322355, -0.036807224},  {0.999264777, -0.038340122},  {0.999204755, -0.039872926},
    {0.999142408, -0.041405641},  {0.999077737, -0.042938258},  {0.999010682, -0.044470772},
    {0.998941302, -0.046003181},  {0.998869538, -0.047535483},  {0.998795450, -0.049067676},
    {0.998719037, -0.050599750},  {0.998640239, -0.052131705},  {0.998559058, -0.053663537},
    {0.998475552, -0.055195246},  {0.998389721, -0.056726821},  {0.998301566, -0.058258265},
    {0.998211026, -0.059789572},  {0.998118103, -0.061320737},  {0.998022854, -0.062851757},
    {0.997925282, -0.064382628},  {0.997825325, -0.065913349},  {0.997723043, -0.067443922},
    {0.997618437, -0.068974331},  {0.997511446, -0.070504576},  {0.997402132, -0.072034650},
    {0.997290432, -0.073564567},  {0.997176409, -0.075094298},  {0.997060061, -0.076623864},
    {0.996941328, -0.078153245},  {0.996820271, -0.079682440},  {0.996696889, -0.081211448},
    {0.996571124, -0.082740262},  {0.996443033, -0.084268890},  {0.996312618, -0.085797310},
    {0.996179819, -0.087325536},  {0.996044695, -0.088853553},  {0.995907247, -0.090381362},
    {0.995767415, -0.091908954},  {0.995625257, -0.093436338},  {0.995480776, -0.094963498},
    {0.995333910, -0.096490428},  {0.995184720, -0.098017141},  {0.995033205, -0.099543616},
    {0.994879305, -0.101069860},  {0.994723141, -0.102595866},  {0.994564593, -0.104121633},
    {0.994403660, -0.105647154},  {0.994240463, -0.107172422},  {0.994074881, -0.108697444},
    {0.993906975, -0.110222206},  {0.993736744, -0.111746714},  {0.993564129, -0.113270953},
    {0.993389189, -0.114794925},  {0.993211925, -0.116318628},  {0.993032336, -0.117842063},
    {0.992850423, -0.119365215},  {0.992666125, -0.120888084},  {0.992479563, -0.122410677},
    {0.992290616, -0.123932973},  {0.992099285, -0.125454977},  {0.991905689, -0.126976699},
    {0.991709769, -0.128498107},  {0.991511464, -0.130019218},  {0.991310835, -0.131540030},
    {0.991107941, -0.133060530},  {0.990902662, -0.134580702},  {0.990695000, -0.136100575},
    {0.990485072, -0.137620121},  {0.990272820, -0.139139339},  {0.990058184, -0.140658244},
    {0.989841282, -0.142176807},  {0.989621997, -0.143695027},  {0.989400446, -0.145212919},
    {0.989176512, -0.146730468},  {0.988950253, -0.148247674},  {0.988721669, -0.149764538},
    {0.988490820, -0.151281044},  {0.988257587, -0.152797192},  {0.988022029, -0.154312968},
    {0.987784147, -0.155828401},  {0.987543941, -0.157343462},  {0.987301409, -0.158858150},
    {0.987056553, -0.160372451},  {0.986809373, -0.161886394},  {0.986559927, -0.163399950},
    {0.986308098, -0.164913118},  {0.986053944, -0.166425899},  {0.985797524, -0.167938292},
    {0.985538721, -0.169450298},  {0.985277653, -0.170961887},  {0.985014260, -0.172473088},
    {0.984748483, -0.173983872},  {0.984480441, -0.175494254},  {0.984210074, -0.177004218},
    {0.983937442, -0.178513765},  {0.983662426, -0.180022895},  {0.983385086, -0.181531608},
    {0.983105481, -0.183039889},  {0.982823551, -0.184547737},  {0.982539296, -0.186055154},
    {0.982252717, -0.187562123},  {0.981963873, -0.189068660},  {0.981672704, -0.190574750},
    {0.981379211, -0.192080393},  {0.981083393, -0.193585590},  {0.980785251, -0.195090324},
    {0.980484843, -0.196594596},  {0.980182111, -0.198098406},  {0.979877114, -0.199601755},
    {0.979569793, -0.201104641},  {0.979260147, -0.202607036},  {0.978948176, -0.204108968},
    {0.978633940, -0.205610409},  {0.978317380, -0.207111374},  {0.977998495, -0.208611846},
    {0.977677345, -0.210111842},  {0.977353871, -0.211611331},  {0.977028131, -0.213110313},
    {0.976700068, -0.214608818},  {0.976369739, -0.216106802},  {0.976037085, -0.217604280},
    {0.975702107, -0.219101235},  {0.975364864, -0.220597684},  {0.975025356, -0.222093627},
    {0.974683523, -0.223589033},  {0.974339366, -0.225083917},  {0.973992944, -0.226578265},
    {0.973644257, -0.228072077},  {0.973293245, -0.229565367},  {0.972939968, -0.231058106},
    {0.972584367, -0.232550308},  {0.972226501, -0.234041959},  {0.971866310, -0.235533059},
    {0.971503913, -0.237023607},  {0.971139133, -0.238513589},  {0.970772147, -0.240003020},
    {0.970402837, -0.241491884},  {0.970031261, -0.242980182},  {0.969657362, -0.244467899},
    {0.969281256, -0.245955050},  {0.968902826, -0.247441620},  {0.968522072, -0.248927608},
    {0.968139112, -0.250413001},  {0.967753828, -0.251897812},  {0.967366278, -0.253382027},
    {0.966976464, -0.254865646},  {0.966584384, -0.256348670},  {0.966189981, -0.257831097},
    {0.965793371, -0.259312928},  {0.965394437, -0.260794103},  {0.964993238, -0.262274712},
    {0.964589775, -0.263754666},  {0.964184046, -0.265234023},  {0.963776052, -0.266712755},
    {0.963365793, -0.268190861},  {0.962953269, -0.269668311},  {0.962538481, -0.271145165},
    {0.962121427, -0.272621363},  {0.961702049, -0.274096906},  {0.961280465, -0.275571823},
    {0.960856616, -0.277046084},  {0.960430503, -0.278519690},  {0.960002124, -0.279992640},
    {0.959571540, -0.281464934},  {0.959138632, -0.282936573},  {0.958703458, -0.284407526},
    {0.958266079, -0.285877824},  {0.957826436, -0.287347466},  {0.957384527, -0.288816422},
    {0.956940353, -0.290284663},  {0.956493914, -0.291752249},  {0.956045270, -0.293219149},
    {0.955594361, -0.294685364},  {0.955141187, -0.296150893},  {0.954685748, -0.297615707},
    {0.954228103, -0.299079835},  {0.953768194, -0.300543249},  {0.953306019, -0.302005947},
    {0.952841640, -0.303467959},  {0.952374995, -0.304929227},  {0.951906145, -0.306389809},
    {0.951435030, -0.307849646},  {0.950961649, -0.309308767},  {0.950486064, -0.310767144},
    {0.950008273, -0.312224805},  {0.949528158, -0.313681751},  {0.949045897, -0.315137923},
    {0.948561370, -0.316593379},  {0.948074579, -0.318048090},  {0.947585583, -0.319502026},
    {0.947094381, -0.320955247},  {0.946600914, -0.322407693},  {0.946105242, -0.323859364},
    {0.945607305, -0.325310290},  {0.945107222, -0.326760441},  {0.944604814, -0.328209847},
    {0.944100261, -0.329658449},  {0.943593442, -0.331106305},  {0.943084419, -0.332553357},
    {0.942573190, -0.333999664},  {0.942059755, -0.335445136},  {0.941544056, -0.336889863},
    {0.941026151, -0.338333756},  {0.940506041, -0.339776874},  {0.939983726, -0.341219217},
    {0.939459205, -0.342660725},  {0.938932478, -0.344101429},  {0.938403547, -0.345541328},
    {0.937872350, -0.346980423},  {0.937339008, -0.348418683},  {0.936803460, -0.349856138},
    {0.936265647, -0.351292759},  {0.935725689, -0.352728546},  {0.935183525, -0.354163527},
    {0.934639156, -0.355597675},  {0.934092522, -0.357030958},  {0.933543801, -0.358463407},
    {0.932992816, -0.359895051},  {0.932439625, -0.361325800},  {0.931884289, -0.362755716},
    {0.931326687, -0.364184797},  {0.930766940, -0.365612984},  {0.930205047, -0.367040336},
    {0.929640889, -0.368466824},  {0.929074585, -0.369892448},  {0.928506076, -0.371317208},
    {0.927935421, -0.372741073},  {0.927362502, -0.374164075},  {0.926787496, -0.375586182},
    {0.926210225, -0.377007425},  {0.925630808, -0.378427744},  {0.925049245, -0.379847199},
    {0.924465477, -0.381265759},  {0.923879504, -0.382683426},  {0.923291445, -0.384100199},
    {0.922701120, -0.385516047},  {0.922108650, -0.386931002},  {0.921514034, -0.388345033},
    {0.920917213, -0.389758170},  {0.920318305, -0.391170382},  {0.919717133, -0.392581671},
    {0.919113874, -0.393992037},  {0.918508410, -0.395401478},  {0.917900801, -0.396809995},
    {0.917290986, -0.398217559},  {0.916679084, -0.399624199},  {0.916064978, -0.401029885},
    {0.915448725, -0.402434647},  {0.914830327, -0.403838456},  {0.914209783, -0.405241311},
    {0.913587034, -0.406643212},  {0.912962198, -0.408044159},  {0.912335157, -0.409444153},
    {0.911706030, -0.410843164},  {0.911074758, -0.412241220},  {0.910441279, -0.413638324},
    {0.909805715, -0.415034413},  {0.909168005, -0.416429549},  {0.908528090, -0.417823702},
    {0.907886088, -0.419216901},  {0.907242000, -0.420609087},  {0.906595707, -0.422000259},
    {0.905947268, -0.423390478},  {0.905296743, -0.424779683},  {0.904644072, -0.426167876},
    {0.903989315, -0.427555084},  {0.903332353, -0.428941280},  {0.902673304, -0.430326492},
    {0.902012169, -0.431710660},  {0.901348829, -0.433093816},  {0.900683403, -0.434475958},
    {0.900015891, -0.435857087},  {0.899346232, -0.437237173},  {0.898674488, -0.438616246},
    {0.898000598, -0.439994276},  {0.897324562, -0.441371262},  {0.896646500, -0.442747235},
    {0.895966232, -0.444122136},  {0.895283937, -0.445496023},  {0.894599497, -0.446868837},
    {0.893912971, -0.448240608},  {0.893224299, -0.449611336},  {0.892533541, -0.450980991},
    {0.891840696, -0.452349573},  {0.891145766, -0.453717113},  {0.890448749, -0.455083579},
    {0.889749587, -0.456448972},  {0.889048338, -0.457813293},  {0.888345063, -0.459176540},
    {0.887639642, -0.460538715},  {0.886932135, -0.461899787},  {0.886222541, -0.463259786},
    {0.885510862, -0.464618683},  {0.884797096, -0.465976506},  {0.884081244, -0.467333198},
    {0.883363366, -0.468688816},  {0.882643342, -0.470043331},  {0.881921291, -0.471396744},
    {0.881197095, -0.472749025},  {0.880470872, -0.474100202},  {0.879742622, -0.475450277},
    {0.879012227, -0.476799220},  {0.878279805, -0.478147060},  {0.877545297, -0.479493767},
    {0.876808703, -0.480839342},  {0.876070082, -0.482183784},  {0.875329375, -0.483527064},
    {0.874586642, -0.484869242},  {0.873841822, -0.486210287},  {0.873094976, -0.487550169},
    {0.872346044, -0.488888890},  {0.871595085, -0.490226477},  {0.870842040, -0.491562903},
    {0.870086968, -0.492898196},  {0.869329870, -0.494232297},  {0.868570685, -0.495565265},
    {0.867809474, -0.496897042},  {0.867046237, -0.498227656},  {0.866280973, -0.499557108},
    {0.865513623, -0.500885367},  {0.864744246, -0.502212465},  {0.863972843, -0.503538370},
    {0.863199413, -0.504863083},  {0.862423956, -0.506186664},  {0.861646473, -0.507508993},
    {0.860866964, -0.508830130},  {0.860085368, -0.510150075},  {0.859301805, -0.511468828},
    {0.858516216, -0.512786388},  {0.857728601, -0.514102757},  {0.856938958, -0.515417874},
    {0.856147349, -0.516731799},  {0.855353653, -0.518044531},  {0.854557991, -0.519356012},
    {0.853760302, -0.520666242},  {0.852960587, -0.521975279},  {0.852158904, -0.523283124},
    {0.851355195, -0.524589658},  {0.850549459, -0.525895000},  {0.849741757, -0.527199149},
    {0.848932028, -0.528501987},  {0.848120332, -0.529803634},  {0.847306609, -0.531104028},
    {0.846490920, -0.532403111},  {0.845673263, -0.533701003},  {0.844853580, -0.534997642},
    {0.844031870, -0.536292970},  {0.843208253, -0.537587047},  {0.842382610, -0.538879931},
    {0.841554999, -0.540171444},  {0.840725362, -0.541461766},  {0.839893818, -0.542750776},
    {0.839060247, -0.544038534},  {0.838224709, -0.545324981},  {0.837387204, -0.546610177},
    {0.836547732, -0.547894061},  {0.835706294, -0.549176633},  {0.834862888, -0.550457954},
    {0.834017515, -0.551737964},  {0.833170176, -0.553016722},  {0.832320869, -0.554294109},
    {0.831469595, -0.555570245},  {0.830616415, -0.556845009},  {0.829761207, -0.558118522},
    {0.828904092, -0.559390724},  {0.828045070, -0.560661554},  {0.827184021, -0.561931133},
    {0.826321065, -0.563199341},  {0.825456142, -0.564466238},  {0.824589312, -0.565731823},
    {0.823720515, -0.566996038},  {0.822849810, -0.568258941},  {0.821977139, -0.569520533},
    {0.821102500, -0.570780754},  {0.820225954, -0.572039604},  {0.819347501, -0.573297143},
    {0.818467140, -0.574553370},  {0.817584813, -0.575808167},  {0.816700578, -0.577061653},
    {0.815814435, -0.578313768},  {0.814926326, -0.579564571},  {0.814036310, -0.580813944},
    {0.813144386, -0.582062006},  {0.812250614, -0.583308637},  {0.811354876, -0.584553957},
    {0.810457170, -0.585797846},  {0.809557617, -0.587040365},  {0.808656156, -0.588281572},
    {0.807752848, -0.589521289},  {0.806847572, -0.590759695},  {0.805940390, -0.591996670},
    {0.805031359, -0.593232274},  {0.804120362, -0.594466507},  {0.803207517, -0.595699310},
    {0.802292824, -0.596930683},  {0.801376164, -0.598160684},  {0.800457656, -0.599389315},
    {0.799537241, -0.600616455},  {0.798614979, -0.601842225},  {0.797690868, -0.603066623},
    {0.796764791, -0.604289532},  {0.795836926, -0.605511069},  {0.794907153, -0.606731117},
    {0.793975472, -0.607949793},  {0.793041945, -0.609167039},  {0.792106569, -0.610382795},
    {0.791169345, -0.611597180},  {0.790230215, -0.612810075},  {0.789289236, -0.614021540},
    {0.788346410, -0.615231574},  {0.787401736, -0.616440177},  {0.786455214, -0.617647290},
    {0.785506845, -0.618852973},  {0.784556568, -0.620057225},  {0.783604503, -0.621259987},
    {0.782650590, -0.622461259},  {0.781694829, -0.623661101},  {0.780737221, -0.624859512},
    {0.779777765, -0.626056373},  {0.778816521, -0.627251804},  {0.777853429, -0.628445745},
    {0.776888490, -0.629638255},  {0.775921702, -0.630829215},  {0.774953127, -0.632018745},
    {0.773982704, -0.633206785},  {0.773010433, -0.634393275},  {0.772036374, -0.635578334},
    {0.771060526, -0.636761844},  {0.770082831, -0.637943923},  {0.769103348, -0.639124453},
    {0.768122017, -0.640303493},  {0.767138898, -0.641481042},  {0.766153991, -0.642657042},
    {0.765167236, -0.643831551},  {0.764178753, -0.645004511},  {0.763188422, -0.646176040},
    {0.762196302, -0.647345960},  {0.761202395, -0.648514390},  {0.760206699, -0.649681330},
    {0.759209216, -0.650846660},  {0.758209884, -0.652010560},  {0.757208824, -0.653172851},
    {0.756205976, -0.654333591},  {0.755201399, -0.655492842},  {0.754194975, -0.656650543},
    {0.753186822, -0.657806695},  {0.752176821, -0.658961296},  {0.751165152, -0.660114348},
    {0.750151634, -0.661265850},  {0.749136388, -0.662415802},  {0.748119354, -0.663564146},
    {0.747100592, -0.664710999},  {0.746080101, -0.665856242},  {0.745057762, -0.666999936},
    {0.744033754, -0.668142021},  {0.743007958, -0.669282615},  {0.741980433, -0.670421541},
    {0.740951121, -0.671558976},  {0.739920080, -0.672694743},  {0.738887310, -0.673829019},
    {0.737852812, -0.674961627},  {0.736816585, -0.676092684},  {0.735778570, -0.677222192},
    {0.734738886, -0.678350031},  {0.733697414, -0.679476321},  {0.732654274, -0.680601001},
    {0.731609404, -0.681724072},  {0.730562747, -0.682845533},  {0.729514420, -0.683965385},
    {0.728464365, -0.685083687},  {0.727412641, -0.686200321},  {0.726359129, -0.687315345},
    {0.725303948, -0.688428760},  {0.724247098, -0.689540565},  {0.723188460, -0.690650702},
    {0.722128212, -0.691759229},  {0.721066177, -0.692866147},  {0.720002532, -0.693971455},
    {0.718937099, -0.695075095},  {0.717870057, -0.696177125},  {0.716801286, -0.697277486},
    {0.715730846, -0.698376238},  {0.714658678, -0.699473321},  {0.713584840, -0.700568795},
    {0.712509394, -0.701662600},  {0.711432219, -0.702754736},  {0.710353374, -0.703845263},
    {0.709272802, -0.704934061},  {0.708190620, -0.706021249},  {0.707106769, -0.707106769},
    {0.706021249, -0.708190620},  {0.704934061, -0.709272802},  {0.703845263, -0.710353374},
    {0.702754736, -0.711432219},  {0.701662600, -0.712509394},  {0.700568795, -0.713584840},
    {0.699473321, -0.714658678},  {0.698376238, -0.715730846},  {0.697277486, -0.716801286},
    {0.696177125, -0.717870057},  {0.695075095, -0.718937099},  {0.693971455, -0.720002532},
    {0.692866147, -0.721066177},  {0.691759229, -0.722128212},  {0.690650702, -0.723188460},
    {0.689540565, -0.724247098},  {0.688428760, -0.725303948},  {0.687315345, -0.726359129},
    {0.686200321, -0.727412641},  {0.685083687, -0.728464365},  {0.683965385, -0.729514420},
    {0.682845533, -0.730562747},  {0.681724072, -0.731609404},  {0.680601001, -0.732654274},
    {0.679476321, -0.733697414},  {0.678350031, -0.734738886},  {0.677222192, -0.735778570},
    {0.676092684, -0.736816585},  {0.674961627, -0.737852812},  {0.673829019, -0.738887310},
    {0.672694743, -0.739920080},  {0.671558976, -0.740951121},  {0.670421541, -0.741980433},
    {0.669282615, -0.743007958},  {0.668142021, -0.744033754},  {0.666999936, -0.745057762},
    {0.665856242, -0.746080101},  {0.664710999, -0.747100592},  {0.663564146, -0.748119354},
    {0.662415802, -0.749136388},  {0.661265850, -0.750151634},  {0.660114348, -0.751165152},
    {0.658961296, -0.752176821},  {0.657806695, -0.753186822},  {0.656650543, -0.754194975},
    {0.655492842, -0.755201399},  {0.654333591, -0.756205976},  {0.653172851, -0.757208824},
    {0.652010560, -0.758209884},  {0.650846660, -0.759209216},  {0.649681330, -0.760206699},
    {0.648514390, -0.761202395},  {0.647345960, -0.762196302},  {0.646176040, -0.763188422},
    {0.645004511, -0.764178753},  {0.643831551, -0.765167236},  {0.642657042, -0.766153991},
    {0.641481042, -0.767138898},  {0.640303493, -0.768122017},  {0.639124453, -0.769103348},
    {0.637943923, -0.770082831},  {0.636761844, -0.771060526},  {0.635578334, -0.772036374},
    {0.634393275, -0.773010433},  {0.633206785, -0.773982704},  {0.632018745, -0.774953127},
    {0.630829215, -0.775921702},  {0.629638255, -0.776888490},  {0.628445745, -0.777853429},
    {0.627251804, -0.778816521},  {0.626056373, -0.779777765},  {0.624859512, -0.780737221},
    {0.623661101, -0.781694829},  {0.622461259, -0.782650590},  {0.621259987, -0.783604503},
    {0.620057225, -0.784556568},  {0.618852973, -0.785506845},  {0.617647290, -0.786455214},
    {0.616440177, -0.787401736},  {0.615231574, -0.788346410},  {0.614021540, -0.789289236},
    {0.612810075, -0.790230215},  {0.611597180, -0.791169345},  {0.610382795, -0.792106569},
    {0.609167039, -0.793041945},  {0.607949793, -0.793975472},  {0.606731117, -0.794907153},
    {0.605511069, -0.795836926},  {0.604289532, -0.796764791},  {0.603066623, -0.797690868},
    {0.601842225, -0.798614979},  {0.600616455, -0.799537241},  {0.599389315, -0.800457656},
    {0.598160684, -0.801376164},  {0.596930683, -0.802292824},  {0.595699310, -0.803207517},
    {0.594466507, -0.804120362},  {0.593232274, -0.805031359},  {0.591996670, -0.805940390},
    {0.590759695, -0.806847572},  {0.589521289, -0.807752848},  {0.588281572, -0.808656156},
    {0.587040365, -0.809557617},  {0.585797846, -0.810457170},  {0.584553957, -0.811354876},
    {0.583308637, -0.812250614},  {0.582062006, -0.813144386},  {0.580813944, -0.814036310},
    {0.579564571, -0.814926326},  {0.578313768, -0.815814435},  {0.577061653, -0.816700578},
    {0.575808167, -0.817584813},  {0.574553370, -0.818467140},  {0.573297143, -0.819347501},
    {0.572039604, -0.820225954},  {0.570780754, -0.821102500},  {0.569520533, -0.821977139},
    {0.568258941, -0.822849810},  {0.566996038, -0.823720515},  {0.565731823, -0.824589312},
    {0.564466238, -0.825456142},  {0.563199341, -0.826321065},  {0.561931133, -0.827184021},
    {0.560661554, -0.828045070},  {0.559390724, -0.828904092},  {0.558118522, -0.829761207},
    {0.556845009, -0.830616415},  {0.555570245, -0.831469595},  {0.554294109, -0.832320869},
    {0.553016722, -0.833170176},  {0.551737964, -0.834017515},  {0.550457954, -0.834862888},
    {0.549176633, -0.835706294},  {0.547894061, -0.836547732},  {0.546610177, -0.837387204},
    {0.545324981, -0.838224709},  {0.544038534, -0.839060247},  {0.542750776, -0.839893818},
    {0.541461766, -0.840725362},  {0.540171444, -0.841554999},  {0.538879931, -0.842382610},
    {0.537587047, -0.843208253},  {0.536292970, -0.844031870},  {0.534997642, -0.844853580},
    {0.533701003, -0.845673263},  {0.532403111, -0.846490920},  {0.531104028, -0.847306609},
    {0.529803634, -0.848120332},  {0.528501987, -0.848932028},  {0.527199149, -0.849741757},
    {0.525895000, -0.850549459},  {0.524589658, -0.851355195},  {0.523283124, -0.852158904},
    {0.521975279, -0.852960587},  {0.520666242, -0.853760302},  {0.519356012, -0.854557991},
    {0.518044531, -0.855353653},  {0.516731799, -0.856147349},  {0.515417874, -0.856938958},
    {0.514102757, -0.857728601},  {0.512786388, -0.858516216},  {0.511468828, -0.859301805},
    {0.510150075, -0.860085368},  {0.508830130, -0.860866964},  {0.507508993, -0.861646473},
    {0.506186664, -0.862423956},  {0.504863083, -0.863199413},  {0.503538370, -0.863972843},
    {0.502212465, -0.864744246},  {0.500885367, -0.865513623},  {0.499557108, -0.866280973},
    {0.498227656, -0.867046237},  {0.496897042, -0.867809474},  {0.495565265, -0.868570685},
    {0.494232297, -0.869329870},  {0.492898196, -0.870086968},  {0.491562903, -0.870842040},
    {0.490226477, -0.871595085},  {0.488888890, -0.872346044},  {0.487550169, -0.873094976},
    {0.486210287, -0.873841822},  {0.484869242, -0.874586642},  {0.483527064, -0.875329375},
    {0.482183784, -0.876070082},  {0.480839342, -0.876808703},  {0.479493767, -0.877545297},
    {0.478147060, -0.878279805},  {0.476799220, -0.879012227},  {0.475450277, -0.879742622},
    {0.474100202, -0.880470872},  {0.472749025, -0.881197095},  {0.471396744, -0.881921291},
    {0.470043331, -0.882643342},  {0.468688816, -0.883363366},  {0.467333198, -0.884081244},
    {0.465976506, -0.884797096},  {0.464618683, -0.885510862},  {0.463259786, -0.886222541},
    {0.461899787, -0.886932135},  {0.460538715, -0.887639642},  {0.459176540, -0.888345063},
    {0.457813293, -0.889048338},  {0.456448972, -0.889749587},  {0.455083579, -0.890448749},
    {0.453717113, -0.891145766},  {0.452349573, -0.891840696},  {0.450980991, -0.892533541},
    {0.449611336, -0.893224299},  {0.448240608, -0.893912971},  {0.446868837, -0.894599497},
    {0.445496023, -0.895283937},  {0.444122136, -0.895966232},  {0.442747235, -0.896646500},
    {0.441371262, -0.897324562},  {0.439994276, -0.898000598},  {0.438616246, -0.898674488},
    {0.437237173, -0.899346232},  {0.435857087, -0.900015891},  {0.434475958, -0.900683403},
    {0.433093816, -0.901348829},  {0.431710660, -0.902012169},  {0.430326492, -0.902673304},
    {0.428941280, -0.903332353},  {0.427555084, -0.903989315},  {0.426167876, -0.904644072},
    {0.424779683, -0.905296743},  {0.423390478, -0.905947268},  {0.422000259, -0.906595707},
    {0.420609087, -0.907242000},  {0.419216901, -0.907886088},  {0.417823702, -0.908528090},
    {0.416429549, -0.909168005},  {0.415034413, -0.909805715},  {0.413638324, -0.910441279},
    {0.412241220, -0.911074758},  {0.410843164, -0.911706030},  {0.409444153, -0.912335157},
    {0.408044159, -0.912962198},  {0.406643212, -0.913587034},  {0.405241311, -0.914209783},
    {0.403838456, -0.914830327},  {0.402434647, -0.915448725},  {0.401029885, -0.916064978},
    {0.399624199, -0.916679084},  {0.398217559, -0.917290986},  {0.396809995, -0.917900801},
    {0.395401478, -0.918508410},  {0.393992037, -0.919113874},  {0.392581671, -0.919717133},
    {0.391170382, -0.920318305},  {0.389758170, -0.920917213},  {0.388345033, -0.921514034},
    {0.386931002, -0.922108650},  {0.385516047, -0.922701120},  {0.384100199, -0.923291445},
    {0.382683426, -0.923879504},  {0.381265759, -0.924465477},  {0.379847199, -0.925049245},
    {0.378427744, -0.925630808},  {0.377007425, -0.926210225},  {0.375586182, -0.926787496},
    {0.374164075, -0.927362502},  {0.372741073, -0.927935421},  {0.371317208, -0.928506076},
    {0.369892448, -0.929074585},  {0.368466824, -0.929640889},  {0.367040336, -0.930205047},
    {0.365612984, -0.930766940},  {0.364184797, -0.931326687},  {0.362755716, -0.931884289},
    {0.361325800, -0.932439625},  {0.359895051, -0.932992816},  {0.358463407, -0.933543801},
    {0.357030958, -0.934092522},  {0.355597675, -0.934639156},  {0.354163527, -0.935183525},
    {0.352728546, -0.935725689},  {0.351292759, -0.936265647},  {0.349856138, -0.936803460},
    {0.348418683, -0.937339008},  {0.346980423, -0.937872350},  {0.345541328, -0.938403547},
    {0.344101429, -0.938932478},  {0.342660725, -0.939459205},  {0.341219217, -0.939983726},
    {0.339776874, -0.940506041},  {0.338333756, -0.941026151},  {0.336889863, -0.941544056},
    {0.335445136, -0.942059755},  {0.333999664, -0.942573190},  {0.332553357, -0.943084419},
    {0.331106305, -0.943593442},  {0.329658449, -0.944100261},  {0.328209847, -0.944604814},
    {0.326760441, -0.945107222},  {0.325310290, -0.945607305},  {0.323859364, -0.946105242},
    {0.322407693, -0.946600914},  {0.320955247, -0.947094381},  {0.319502026, -0.947585583},
    {0.318048090, -0.948074579},  {0.316593379, -0.948561370},  {0.315137923, -0.949045897},
    {0.313681751, -0.949528158},  {0.312224805, -0.950008273},  {0.310767144, -0.950486064},
    {0.309308767, -0.950961649},  {0.307849646, -0.951435030},  {0.306389809, -0.951906145},
    {0.304929227, -0.952374995},  {0.303467959, -0.952841640},  {0.302005947, -0.953306019},
    {0.300543249, -0.953768194},  {0.299079835, -0.954228103},  {0.297615707, -0.954685748},
    {0.296150893, -0.955141187},  {0.294685364, -0.955594361},  {0.293219149, -0.956045270},
    {0.291752249, -0.956493914},  {0.290284663, -0.956940353},  {0.288816422, -0.957384527},
    {0.287347466, -0.957826436},  {0.285877824, -0.958266079},  {0.284407526, -0.958703458},
    {0.282936573, -0.959138632},  {0.281464934, -0.959571540},  {0.279992640, -0.960002124},
    {0.278519690, -0.960430503},  {0.277046084, -0.960856616},  {0.275571823, -0.961280465},
    {0.274096906, -0.961702049},  {0.272621363, -0.962121427},  {0.271145165, -0.962538481},
    {0.269668311, -0.962953269},  {0.268190861, -0.963365793},  {0.266712755, -0.963776052},
    {0.265234023, -0.964184046},  {0.263754666, -0.964589775},  {0.262274712, -0.964993238},
    {0.260794103, -0.965394437},  {0.259312928, -0.965793371},  {0.257831097, -0.966189981},
    {0.256348670, -0.966584384},  {0.254865646, -0.966976464},  {0.253382027, -0.967366278},
    {0.251897812, -0.967753828},  {0.250413001, -0.968139112},  {0.248927608, -0.968522072},
    {0.247441620, -0.968902826},  {0.245955050, -0.969281256},  {0.244467899, -0.969657362},
    {0.242980182, -0.970031261},  {0.241491884, -0.970402837},  {0.240003020, -0.970772147},
    {0.238513589, -0.971139133},  {0.237023607, -0.971503913},  {0.235533059, -0.971866310},
    {0.234041959, -0.972226501},  {0.232550308, -0.972584367},  {0.231058106, -0.972939968},
    {0.229565367, -0.973293245},  {0.228072077, -0.973644257},  {0.226578265, -0.973992944},
    {0.225083917, -0.974339366},  {0.223589033, -0.974683523},  {0.222093627, -0.975025356},
    {0.220597684, -0.975364864},  {0.219101235, -0.975702107},  {0.217604280, -0.976037085},
    {0.216106802, -0.976369739},  {0.214608818, -0.976700068},  {0.213110313, -0.977028131},
    {0.211611331, -0.977353871},  {0.210111842, -0.977677345},  {0.208611846, -0.977998495},
    {0.207111374, -0.978317380},  {0.205610409, -0.978633940},  {0.204108968, -0.978948176},
    {0.202607036, -0.979260147},  {0.201104641, -0.979569793},  {0.199601755, -0.979877114},
    {0.198098406, -0.980182111},  {0.196594596, -0.980484843},  {0.195090324, -0.980785251},
    {0.193585590, -0.981083393},  {0.192080393, -0.981379211},  {0.190574750, -0.981672704},
    {0.189068660, -0.981963873},  {0.187562123, -0.982252717},  {0.186055154, -0.982539296},
    {0.184547737, -0.982823551},  {0.183039889, -0.983105481},  {0.181531608, -0.983385086},
    {0.180022895, -0.983662426},  {0.178513765, -0.983937442},  {0.177004218, -0.984210074},
    {0.175494254, -0.984480441},  {0.173983872, -0.984748483},  {0.172473088, -0.985014260},
    {0.170961887, -0.985277653},  {0.169450298, -0.985538721},  {0.167938292, -0.985797524},
    {0.166425899, -0.986053944},  {0.164913118, -0.986308098},  {0.163399950, -0.986559927},
    {0.161886394, -0.986809373},  {0.160372451, -0.987056553},  {0.158858150, -0.987301409},
    {0.157343462, -0.987543941},  {0.155828401, -0.987784147},  {0.154312968, -0.988022029},
    {0.152797192, -0.988257587},  {0.151281044, -0.988490820},  {0.149764538, -0.988721669},
    {0.148247674, -0.988950253},  {0.146730468, -0.989176512},  {0.145212919, -0.989400446},
    {0.143695027, -0.989621997},  {0.142176807, -0.989841282},  {0.140658244, -0.990058184},
    {0.139139339, -0.990272820},  {0.137620121, -0.990485072},  {0.136100575, -0.990695000},
    {0.134580702, -0.990902662},  {0.133060530, -0.991107941},  {0.131540030, -0.991310835},
    {0.130019218, -0.991511464},  {0.128498107, -0.991709769},  {0.126976699, -0.991905689},
    {0.125454977, -0.992099285},  {0.123932973, -0.992290616},  {0.122410677, -0.992479563},
    {0.120888084, -0.992666125},  {0.119365215, -0.992850423},  {0.117842063, -0.993032336},
    {0.116318628, -0.993211925},  {0.114794925, -0.993389189},  {0.113270953, -0.993564129},
    {0.111746714, -0.993736744},  {0.110222206, -0.993906975},  {0.108697444, -0.994074881},
    {0.107172422, -0.994240463},  {0.105647154, -0.994403660},  {0.104121633, -0.994564593},
    {0.102595866, -0.994723141},  {0.101069860, -0.994879305},  {0.099543616, -0.995033205},
    {0.098017141, -0.995184720},  {0.096490428, -0.995333910},  {0.094963498, -0.995480776},
    {0.093436338, -0.995625257},  {0.091908954, -0.995767415},  {0.090381362, -0.995907247},
    {0.088853553, -0.996044695},  {0.087325536, -0.996179819},  {0.085797310, -0.996312618},
    {0.084268890, -0.996443033},  {0.082740262, -0.996571124},  {0.081211448, -0.996696889},
    {0.079682440, -0.996820271},  {0.078153245, -0.996941328},  {0.076623864, -0.997060061},
    {0.075094298, -0.997176409},  {0.073564567, -0.997290432},  {0.072034650, -0.997402132},
    {0.070504576, -0.997511446},  {0.068974331, -0.997618437},  {0.067443922, -0.997723043},
    {0.065913349, -0.997825325},  {0.064382628, -0.997925282},  {0.062851757, -0.998022854},
    {0.061320737, -0.998118103},  {0.059789572, -0.998211026},  {0.058258265, -0.998301566},
    {0.056726821, -0.998389721},  {0.055195246, -0.998475552},  {0.053663537, -0.998559058},
    {0.052131705, -0.998640239},  {0.050599750, -0.998719037},  {0.049067676, -0.998795450},
    {0.047535483, -0.998869538},  {0.046003181, -0.998941302},  {0.044470772, -0.999010682},
    {0.042938258, -0.999077737},  {0.041405641, -0.999142408},  {0.039872926, -0.999204755},
    {0.038340122, -0.999264777},  {0.036807224, -0.999322355},  {0.035274237, -0.999377668},
    {0.033741172, -0.999430597},  {0.032208025, -0.999481201},  {0.030674804, -0.999529421},
    {0.029141508, -0.999575317},  {0.027608145, -0.999618828},  {0.026074719, -0.999660015},
    {0.024541229, -0.999698818},  {0.023007682, -0.999735296},  {0.021474080, -0.999769390},
    {0.019940428, -0.999801159},  {0.018406730, -0.999830604},  {0.016872987, -0.999857664},
    {0.015339206, -0.999882340},  {0.013805388, -0.999904692},  {0.012271538, -0.999924719},
    {0.010737659, -0.999942362},  {0.009203754, -0.999957621},  {0.007669829, -0.999970615},
    {0.006135885, -0.999981165},  {0.004601926, -0.999989390},  {0.003067957, -0.999995291},
    {0.001533980, -0.999998808},  {0.000000000, -1.000000000},  {-0.001533980, -0.999998808},
    {-0.003067957, -0.999995291}, {-0.004601926, -0.999989390}, {-0.006135885, -0.999981165},
    {-0.007669829, -0.999970615}, {-0.009203754, -0.999957621}, {-0.010737659, -0.999942362},
    {-0.012271538, -0.999924719}, {-0.013805388, -0.999904692}, {-0.015339206, -0.999882340},
    {-0.016872987, -0.999857664}, {-0.018406730, -0.999830604}, {-0.019940428, -0.999801159},
    {-0.021474080, -0.999769390}, {-0.023007682, -0.999735296}, {-0.024541229, -0.999698818},
    {-0.026074719, -0.999660015}, {-0.027608145, -0.999618828}, {-0.029141508, -0.999575317},
    {-0.030674804, -0.999529421}, {-0.032208025, -0.999481201}, {-0.033741172, -0.999430597},
    {-0.035274237, -0.999377668}, {-0.036807224, -0.999322355}, {-0.038340122, -0.999264777},
    {-0.039872926, -0.999204755}, {-0.041405641, -0.999142408}, {-0.042938258, -0.999077737},
    {-0.044470772, -0.999010682}, {-0.046003181, -0.998941302}, {-0.047535483, -0.998869538},
    {-0.049067676, -0.998795450}, {-0.050599750, -0.998719037}, {-0.052131705, -0.998640239},
    {-0.053663537, -0.998559058}, {-0.055195246, -0.998475552}, {-0.056726821, -0.998389721},
    {-0.058258265, -0.998301566}, {-0.059789572, -0.998211026}, {-0.061320737, -0.998118103},
    {-0.062851757, -0.998022854}, {-0.064382628, -0.997925282}, {-0.065913349, -0.997825325},
    {-0.067443922, -0.997723043}, {-0.068974331, -0.997618437}, {-0.070504576, -0.997511446},
    {-0.072034650, -0.997402132}, {-0.073564567, -0.997290432}, {-0.075094298, -0.997176409},
    {-0.076623864, -0.997060061}, {-0.078153245, -0.996941328}, {-0.079682440, -0.996820271},
    {-0.081211448, -0.996696889}, {-0.082740262, -0.996571124}, {-0.084268890, -0.996443033},
    {-0.085797310, -0.996312618}, {-0.087325536, -0.996179819}, {-0.088853553, -0.996044695},
    {-0.090381362, -0.995907247}, {-0.091908954, -0.995767415}, {-0.093436338, -0.995625257},
    {-0.094963498, -0.995480776}, {-0.096490428, -0.995333910}, {-0.098017141, -0.995184720},
    {-0.099543616, -0.995033205}, {-0.101069860, -0.994879305}, {-0.102595866, -0.994723141},
    {-0.104121633, -0.994564593}, {-0.105647154, -0.994403660}, {-0.107172422, -0.994240463},
    {-0.108697444, -0.994074881}, {-0.110222206, -0.993906975}, {-0.111746714, -0.993736744},
    {-0.113270953, -0.993564129}, {-0.114794925, -0.993389189}, {-0.116318628, -0.993211925},
    {-0.117842063, -0.993032336}, {-0.119365215, -0.992850423}, {-0.120888084, -0.992666125},
    {-0.122410677, -0.992479563}, {-0.123932973, -0.992290616}, {-0.125454977, -0.992099285},
    {-0.126976699, -0.991905689}, {-0.128498107, -0.991709769}, {-0.130019218, -0.991511464},
    {-0.131540030, -0.991310835}, {-0.133060530, -0.991107941}, {-0.134580702, -0.990902662},
    {-0.136100575, -0.990695000}, {-0.137620121, -0.990485072}, {-0.139139339, -0.990272820},
    {-0.140658244, -0.990058184}, {-0.142176807, -0.989841282}, {-0.143695027, -0.989621997},
    {-0.145212919, -0.989400446}, {-0.146730468, -0.989176512}, {-0.148247674, -0.988950253},
    {-0.149764538, -0.988721669}, {-0.151281044, -0.988490820}, {-0.152797192, -0.988257587},
    {-0.154312968, -0.988022029}, {-0.155828401, -0.987784147}, {-0.157343462, -0.987543941},
    {-0.158858150, -0.987301409}, {-0.160372451, -0.987056553}, {-0.161886394, -0.986809373},
    {-0.163399950, -0.986559927}, {-0.164913118, -0.986308098}, {-0.166425899, -0.986053944},
    {-0.167938292, -0.985797524}, {-0.169450298, -0.985538721}, {-0.170961887, -0.985277653},
    {-0.172473088, -0.985014260}, {-0.173983872, -0.984748483}, {-0.175494254, -0.984480441},
    {-0.177004218, -0.984210074}, {-0.178513765, -0.983937442}, {-0.180022895, -0.983662426},
    {-0.181531608, -0.983385086}, {-0.183039889, -0.983105481}, {-0.184547737, -0.982823551},
    {-0.186055154, -0.982539296}, {-0.187562123, -0.982252717}, {-0.189068660, -0.981963873},
    {-0.190574750, -0.981672704}, {-0.192080393, -0.981379211}, {-0.193585590, -0.981083393},
    {-0.195090324, -0.980785251}, {-0.196594596, -0.980484843}, {-0.198098406, -0.980182111},
    {-0.199601755, -0.979877114}, {-0.201104641, -0.979569793}, {-0.202607036, -0.979260147},
    {-0.204108968, -0.978948176}, {-0.205610409, -0.978633940}, {-0.207111374, -0.978317380},
    {-0.208611846, -0.977998495}, {-0.210111842, -0.977677345}, {-0.211611331, -0.977353871},
    {-0.213110313, -0.977028131}, {-0.214608818, -0.976700068}, {-0.216106802, -0.976369739},
    {-0.217604280, -0.976037085}, {-0.219101235, -0.975702107}, {-0.220597684, -0.975364864},
    {-0.222093627, -0.975025356}, {-0.223589033, -0.974683523}, {-0.225083917, -0.974339366},
    {-0.226578265, -0.973992944}, {-0.228072077, -0.973644257}, {-0.229565367, -0.973293245},
    {-0.231058106, -0.972939968}, {-0.232550308, -0.972584367}, {-0.234041959, -0.972226501},
    {-0.235533059, -0.971866310}, {-0.237023607, -0.971503913}, {-0.238513589, -0.971139133},
    {-0.240003020, -0.970772147}, {-0.241491884, -0.970402837}, {-0.242980182, -0.970031261},
    {-0.244467899, -0.969657362}, {-0.245955050, -0.969281256}, {-0.247441620, -0.968902826},
    {-0.248927608, -0.968522072}, {-0.250413001, -0.968139112}, {-0.251897812, -0.967753828},
    {-0.253382027, -0.967366278}, {-0.254865646, -0.966976464}, {-0.256348670, -0.966584384},
    {-0.257831097, -0.966189981}, {-0.259312928, -0.965793371}, {-0.260794103, -0.965394437},
    {-0.262274712, -0.964993238}, {-0.263754666, -0.964589775}, {-0.265234023, -0.964184046},
    {-0.266712755, -0.963776052}, {-0.268190861, -0.963365793}, {-0.269668311, -0.962953269},
    {-0.271145165, -0.962538481}, {-0.272621363, -0.962121427}, {-0.274096906, -0.961702049},
    {-0.275571823, -0.961280465}, {-0.277046084, -0.960856616}, {-0.278519690, -0.960430503},
    {-0.279992640, -0.960002124}, {-0.281464934, -0.959571540}, {-0.282936573, -0.959138632},
    {-0.284407526, -0.958703458}, {-0.285877824, -0.958266079}, {-0.287347466, -0.957826436},
    {-0.288816422, -0.957384527}, {-0.290284663, -0.956940353}, {-0.291752249, -0.956493914},
    {-0.293219149, -0.956045270}, {-0.294685364, -0.955594361}, {-0.296150893, -0.955141187},
    {-0.297615707, -0.954685748}, {-0.299079835, -0.954228103}, {-0.300543249, -0.953768194},
    {-0.302005947, -0.953306019}, {-0.303467959, -0.952841640}, {-0.304929227, -0.952374995},
    {-0.306389809, -0.951906145}, {-0.307849646, -0.951435030}, {-0.309308767, -0.950961649},
    {-0.310767144, -0.950486064}, {-0.312224805, -0.950008273}, {-0.313681751, -0.949528158},
    {-0.315137923, -0.949045897}, {-0.316593379, -0.948561370}, {-0.318048090, -0.948074579},
    {-0.319502026, -0.947585583}, {-0.320955247, -0.947094381}, {-0.322407693, -0.946600914},
    {-0.323859364, -0.946105242}, {-0.325310290, -0.945607305}, {-0.326760441, -0.945107222},
    {-0.328209847, -0.944604814}, {-0.329658449, -0.944100261}, {-0.331106305, -0.943593442},
    {-0.332553357, -0.943084419}, {-0.333999664, -0.942573190}, {-0.335445136, -0.942059755},
    {-0.336889863, -0.941544056}, {-0.338333756, -0.941026151}, {-0.339776874, -0.940506041},
    {-0.341219217, -0.939983726}, {-0.342660725, -0.939459205}, {-0.344101429, -0.938932478},
    {-0.345541328, -0.938403547}, {-0.346980423, -0.937872350}, {-0.348418683, -0.937339008},
    {-0.349856138, -0.936803460}, {-0.351292759, -0.936265647}, {-0.352728546, -0.935725689},
    {-0.354163527, -0.935183525}, {-0.355597675, -0.934639156}, {-0.357030958, -0.934092522},
    {-0.358463407, -0.933543801}, {-0.359895051, -0.932992816}, {-0.361325800, -0.932439625},
    {-0.362755716, -0.931884289}, {-0.364184797, -0.931326687}, {-0.365612984, -0.930766940},
    {-0.367040336, -0.930205047}, {-0.368466824, -0.929640889}, {-0.369892448, -0.929074585},
    {-0.371317208, -0.928506076}, {-0.372741073, -0.927935421}, {-0.374164075, -0.927362502},
    {-0.375586182, -0.926787496}, {-0.377007425, -0.926210225}, {-0.378427744, -0.925630808},
    {-0.379847199, -0.925049245}, {-0.381265759, -0.924465477}, {-0.382683426, -0.923879504},
    {-0.384100199, -0.923291445}, {-0.385516047, -0.922701120}, {-0.386931002, -0.922108650},
    {-0.388345033, -0.921514034}, {-0.389758170, -0.920917213}, {-0.391170382, -0.920318305},
    {-0.392581671, -0.919717133}, {-0.393992037, -0.919113874}, {-0.395401478, -0.918508410},
    {-0.396809995, -0.917900801}, {-0.398217559, -0.917290986}, {-0.399624199, -0.916679084},
    {-0.401029885, -0.916064978}, {-0.402434647, -0.915448725}, {-0.403838456, -0.914830327},
    {-0.405241311, -0.914209783}, {-0.406643212, -0.913587034}, {-0.408044159, -0.912962198},
    {-0.409444153, -0.912335157}, {-0.410843164, -0.911706030}, {-0.412241220, -0.911074758},
    {-0.413638324, -0.910441279}, {-0.415034413, -0.909805715}, {-0.416429549, -0.909168005},
    {-0.417823702, -0.908528090}, {-0.419216901, -0.907886088}, {-0.420609087, -0.907242000},
    {-0.422000259, -0.906595707}, {-0.423390478, -0.905947268}, {-0.424779683, -0.905296743},
    {-0.426167876, -0.904644072}, {-0.427555084, -0.903989315}, {-0.428941280, -0.903332353},
    {-0.430326492, -0.902673304}, {-0.431710660, -0.902012169}, {-0.433093816, -0.901348829},
    {-0.434475958, -0.900683403}, {-0.435857087, -0.900015891}, {-0.437237173, -0.899346232},
    {-0.438616246, -0.898674488}, {-0.439994276, -0.898000598}, {-0.441371262, -0.897324562},
    {-0.442747235, -0.896646500}, {-0.444122136, -0.895966232}, {-0.445496023, -0.895283937},
    {-0.446868837, -0.894599497}, {-0.448240608, -0.893912971}, {-0.449611336, -0.893224299},
    {-0.450980991, -0.892533541}, {-0.452349573, -0.891840696}, {-0.453717113, -0.891145766},
    {-0.455083579, -0.890448749}, {-0.456448972, -0.889749587}, {-0.457813293, -0.889048338},
    {-0.459176540, -0.888345063}, {-0.460538715, -0.887639642}, {-0.461899787, -0.886932135},
    {-0.463259786, -0.886222541}, {-0.464618683, -0.885510862}, {-0.465976506, -0.884797096},
    {-0.467333198, -0.884081244}, {-0.468688816, -0.883363366}, {-0.470043331, -0.882643342},
    {-0.471396744, -0.881921291}, {-0.472749025, -0.881197095}, {-0.474100202, -0.880470872},
    {-0.475450277, -0.879742622}, {-0.476799220, -0.879012227}, {-0.478147060, -0.878279805},
    {-0.479493767, -0.877545297}, {-0.480839342, -0.876808703}, {-0.482183784, -0.876070082},
    {-0.483527064, -0.875329375}, {-0.484869242, -0.874586642}, {-0.486210287, -0.873841822},
    {-0.487550169, -0.873094976}, {-0.488888890, -0.872346044}, {-0.490226477, -0.871595085},
    {-0.491562903, -0.870842040}, {-0.492898196, -0.870086968}, {-0.494232297, -0.869329870},
    {-0.495565265, -0.868570685}, {-0.496897042, -0.867809474}, {-0.498227656, -0.867046237},
    {-0.499557108, -0.866280973}, {-0.500885367, -0.865513623}, {-0.502212465, -0.864744246},
    {-0.503538370, -0.863972843}, {-0.504863083, -0.863199413}, {-0.506186664, -0.862423956},
    {-0.507508993, -0.861646473}, {-0.508830130, -0.860866964}, {-0.510150075, -0.860085368},
    {-0.511468828, -0.859301805}, {-0.512786388, -0.858516216}, {-0.514102757, -0.857728601},
    {-0.515417874, -0.856938958}, {-0.516731799, -0.856147349}, {-0.518044531, -0.855353653},
    {-0.519356012, -0.854557991}, {-0.520666242, -0.853760302}, {-0.521975279, -0.852960587},
    {-0.523283124, -0.852158904}, {-0.524589658, -0.851355195}, {-0.525895000, -0.850549459},
    {-0.527199149, -0.849741757}, {-0.528501987, -0.848932028}, {-0.529803634, -0.848120332},
    {-0.531104028, -0.847306609}, {-0.532403111, -0.846490920}, {-0.533701003, -0.845673263},
    {-0.534997642, -0.844853580}, {-0.536292970, -0.844031870}, {-0.537587047, -0.843208253},
    {-0.538879931, -0.842382610}, {-0.540171444, -0.841554999}, {-0.541461766, -0.840725362},
    {-0.542750776, -0.839893818}, {-0.544038534, -0.839060247}, {-0.545324981, -0.838224709},
    {-0.546610177, -0.837387204}, {-0.547894061, -0.836547732}, {-0.549176633, -0.835706294},
    {-0.550457954, -0.834862888}, {-0.551737964, -0.834017515}, {-0.553016722, -0.833170176},
    {-0.554294109, -0.832320869}, {-0.555570245, -0.831469595}, {-0.556845009, -0.830616415},
    {-0.558118522, -0.829761207}, {-0.559390724, -0.828904092}, {-0.560661554, -0.828045070},
    {-0.561931133, -0.827184021}, {-0.563199341, -0.826321065}, {-0.564466238, -0.825456142},
    {-0.565731823, -0.824589312}, {-0.566996038, -0.823720515}, {-0.568258941, -0.822849810},
    {-0.569520533, -0.821977139}, {-0.570780754, -0.821102500}, {-0.572039604, -0.820225954},
    {-0.573297143, -0.819347501}, {-0.574553370, -0.818467140}, {-0.575808167, -0.817584813},
    {-0.577061653, -0.816700578}, {-0.578313768, -0.815814435}, {-0.579564571, -0.814926326},
    {-0.580813944, -0.814036310}, {-0.582062006, -0.813144386}, {-0.583308637, -0.812250614},
    {-0.584553957, -0.811354876}, {-0.585797846, -0.810457170}, {-0.587040365, -0.809557617},
    {-0.588281572, -0.808656156}, {-0.589521289, -0.807752848}, {-0.590759695, -0.806847572},
    {-0.591996670, -0.805940390}, {-0.593232274, -0.805031359}, {-0.594466507, -0.804120362},
    {-0.595699310, -0.803207517}, {-0.596930683, -0.802292824}, {-0.598160684, -0.801376164},
    {-0.599389315, -0.800457656}, {-0.600616455, -0.799537241}, {-0.601842225, -0.798614979},
    {-0.603066623, -0.797690868}, {-0.604289532, -0.796764791}, {-0.605511069, -0.795836926},
    {-0.606731117, -0.794907153}, {-0.607949793, -0.793975472}, {-0.609167039, -0.793041945},
    {-0.610382795, -0.792106569}, {-0.611597180, -0.791169345}, {-0.612810075, -0.790230215},
    {-0.614021540, -0.789289236}, {-0.615231574, -0.788346410}, {-0.616440177, -0.787401736},
    {-0.617647290, -0.786455214}, {-0.618852973, -0.785506845}, {-0.620057225, -0.784556568},
    {-0.621259987, -0.783604503}, {-0.622461259, -0.782650590}, {-0.623661101, -0.781694829},
    {-0.624859512, -0.780737221}, {-0.626056373, -0.779777765}, {-0.627251804, -0.778816521},
    {-0.628445745, -0.777853429}, {-0.629638255, -0.776888490}, {-0.630829215, -0.775921702},
    {-0.632018745, -0.774953127}, {-0.633206785, -0.773982704}, {-0.634393275, -0.773010433},
    {-0.635578334, -0.772036374}, {-0.636761844, -0.771060526}, {-0.637943923, -0.770082831},
    {-0.639124453, -0.769103348}, {-0.640303493, -0.768122017}, {-0.641481042, -0.767138898},
    {-0.642657042, -0.766153991}, {-0.643831551, -0.765167236}, {-0.645004511, -0.764178753},
    {-0.646176040, -0.763188422}, {-0.647345960, -0.762196302}, {-0.648514390, -0.761202395},
    {-0.649681330, -0.760206699}, {-0.650846660, -0.759209216}, {-0.652010560, -0.758209884},
    {-0.653172851, -0.757208824}, {-0.654333591, -0.756205976}, {-0.655492842, -0.755201399},
    {-0.656650543, -0.754194975}, {-0.657806695, -0.753186822}, {-0.658961296, -0.752176821},
    {-0.660114348, -0.751165152}, {-0.661265850, -0.750151634}, {-0.662415802, -0.749136388},
    {-0.663564146, -0.748119354}, {-0.664710999, -0.747100592}, {-0.665856242, -0.746080101},
    {-0.666999936, -0.745057762}, {-0.668142021, -0.744033754}, {-0.669282615, -0.743007958},
    {-0.670421541, -0.741980433}, {-0.671558976, -0.740951121}, {-0.672694743, -0.739920080},
    {-0.673829019, -0.738887310}, {-0.674961627, -0.737852812}, {-0.676092684, -0.736816585},
    {-0.677222192, -0.735778570}, {-0.678350031, -0.734738886}, {-0.679476321, -0.733697414},
    {-0.680601001, -0.732654274}, {-0.681724072, -0.731609404}, {-0.682845533, -0.730562747},
    {-0.683965385, -0.729514420}, {-0.685083687, -0.728464365}, {-0.686200321, -0.727412641},
    {-0.687315345, -0.726359129}, {-0.688428760, -0.725303948}, {-0.689540565, -0.724247098},
    {-0.690650702, -0.723188460}, {-0.691759229, -0.722128212}, {-0.692866147, -0.721066177},
    {-0.693971455, -0.720002532}, {-0.695075095, -0.718937099}, {-0.696177125, -0.717870057},
    {-0.697277486, -0.716801286}, {-0.698376238, -0.715730846}, {-0.699473321, -0.714658678},
    {-0.700568795, -0.713584840}, {-0.701662600, -0.712509394}, {-0.702754736, -0.711432219},
    {-0.703845263, -0.710353374}, {-0.704934061, -0.709272802}, {-0.706021249, -0.708190620},
    {-0.707106769, -0.707106769}, {-0.708190620, -0.706021249}, {-0.709272802, -0.704934061},
    {-0.710353374, -0.703845263}, {-0.711432219, -0.702754736}, {-0.712509394, -0.701662600},
    {-0.713584840, -0.700568795}, {-0.714658678, -0.699473321}, {-0.715730846, -0.698376238},
    {-0.716801286, -0.697277486}, {-0.717870057, -0.696177125}, {-0.718937099, -0.695075095},
    {-0.720002532, -0.693971455}, {-0.721066177, -0.692866147}, {-0.722128212, -0.691759229},
    {-0.723188460, -0.690650702}, {-0.724247098, -0.689540565}, {-0.725303948, -0.688428760},
    {-0.726359129, -0.687315345}, {-0.727412641, -0.686200321}, {-0.728464365, -0.685083687},
    {-0.729514420, -0.683965385}, {-0.730562747, -0.682845533}, {-0.731609404, -0.681724072},
    {-0.732654274, -0.680601001}, {-0.733697414, -0.679476321}, {-0.734738886, -0.678350031},
    {-0.735778570, -0.677222192}, {-0.736816585, -0.676092684}, {-0.737852812, -0.674961627},
    {-0.738887310, -0.673829019}, {-0.739920080, -0.672694743}, {-0.740951121, -0.671558976},
    {-0.741980433, -0.670421541}, {-0.743007958, -0.669282615}, {-0.744033754, -0.668142021},
    {-0.745057762, -0.666999936}, {-0.746080101, -0.665856242}, {-0.747100592, -0.664710999},
    {-0.748119354, -0.663564146}, {-0.749136388, -0.662415802}, {-0.750151634, -0.661265850},
    {-0.751165152, -0.660114348}, {-0.752176821, -0.658961296}, {-0.753186822, -0.657806695},
    {-0.754194975, -0.656650543}, {-0.755201399, -0.655492842}, {-0.756205976, -0.654333591},
    {-0.757208824, -0.653172851}, {-0.758209884, -0.652010560}, {-0.759209216, -0.650846660},
    {-0.760206699, -0.649681330}, {-0.761202395, -0.648514390}, {-0.762196302, -0.647345960},
    {-0.763188422, -0.646176040}, {-0.764178753, -0.645004511}, {-0.765167236, -0.643831551},
    {-0.766153991, -0.642657042}, {-0.767138898, -0.641481042}, {-0.768122017, -0.640303493},
    {-0.769103348, -0.639124453}, {-0.770082831, -0.637943923}, {-0.771060526, -0.636761844},
    {-0.772036374, -0.635578334}, {-0.773010433, -0.634393275}, {-0.773982704, -0.633206785},
    {-0.774953127, -0.632018745}, {-0.775921702, -0.630829215}, {-0.776888490, -0.629638255},
    {-0.777853429, -0.628445745}, {-0.778816521, -0.627251804}, {-0.779777765, -0.626056373},
    {-0.780737221, -0.624859512}, {-0.781694829, -0.623661101}, {-0.782650590, -0.622461259},
    {-0.783604503, -0.621259987}, {-0.784556568, -0.620057225}, {-0.785506845, -0.618852973},
    {-0.786455214, -0.617647290}, {-0.787401736, -0.616440177}, {-0.788346410, -0.615231574},
    {-0.789289236, -0.614021540}, {-0.790230215, -0.612810075}, {-0.791169345, -0.611597180},
    {-0.792106569, -0.610382795}, {-0.793041945, -0.609167039}, {-0.793975472, -0.607949793},
    {-0.794907153, -0.606731117}, {-0.795836926, -0.605511069}, {-0.796764791, -0.604289532},
    {-0.797690868, -0.603066623}, {-0.798614979, -0.601842225}, {-0.799537241, -0.600616455},
    {-0.800457656, -0.599389315}, {-0.801376164, -0.598160684}, {-0.802292824, -0.596930683},
    {-0.803207517, -0.595699310}, {-0.804120362, -0.594466507}, {-0.805031359, -0.593232274},
    {-0.805940390, -0.591996670}, {-0.806847572, -0.590759695}, {-0.807752848, -0.589521289},
    {-0.808656156, -0.588281572}, {-0.809557617, -0.587040365}, {-0.810457170, -0.585797846},
    {-0.811354876, -0.584553957}, {-0.812250614, -0.583308637}, {-0.813144386, -0.582062006},
    {-0.814036310, -0.580813944}, {-0.814926326, -0.579564571}, {-0.815814435, -0.578313768},
    {-0.816700578, -0.577061653}, {-0.817584813, -0.575808167}, {-0.818467140, -0.574553370},
    {-0.819347501, -0.573297143}, {-0.820225954, -0.572039604}, {-0.821102500, -0.570780754},
    {-0.821977139, -0.569520533}, {-0.822849810, -0.568258941}, {-0.823720515, -0.566996038},
    {-0.824589312, -0.565731823}, {-0.825456142, -0.564466238}, {-0.826321065, -0.563199341},
    {-0.827184021, -0.561931133}, {-0.828045070, -0.560661554}, {-0.828904092, -0.559390724},
    {-0.829761207, -0.558118522}, {-0.830616415, -0.556845009}, {-0.831469595, -0.555570245},
    {-0.832320869, -0.554294109}, {-0.833170176, -0.553016722}, {-0.834017515, -0.551737964},
    {-0.834862888, -0.550457954}, {-0.835706294, -0.549176633}, {-0.836547732, -0.547894061},
    {-0.837387204, -0.546610177}, {-0.838224709, -0.545324981}, {-0.839060247, -0.544038534},
    {-0.839893818, -0.542750776}, {-0.840725362, -0.541461766}, {-0.841554999, -0.540171444},
    {-0.842382610, -0.538879931}, {-0.843208253, -0.537587047}, {-0.844031870, -0.536292970},
    {-0.844853580, -0.534997642}, {-0.845673263, -0.533701003}, {-0.846490920, -0.532403111},
    {-0.847306609, -0.531104028}, {-0.848120332, -0.529803634}, {-0.848932028, -0.528501987},
    {-0.849741757, -0.527199149}, {-0.850549459, -0.525895000}, {-0.851355195, -0.524589658},
    {-0.852158904, -0.523283124}, {-0.852960587, -0.521975279}, {-0.853760302, -0.520666242},
    {-0.854557991, -0.519356012}, {-0.855353653, -0.518044531}, {-0.856147349, -0.516731799},
    {-0.856938958, -0.515417874}, {-0.857728601, -0.514102757}, {-0.858516216, -0.512786388},
    {-0.859301805, -0.511468828}, {-0.860085368, -0.510150075}, {-0.860866964, -0.508830130},
    {-0.861646473, -0.507508993}, {-0.862423956, -0.506186664}, {-0.863199413, -0.504863083},
    {-0.863972843, -0.503538370}, {-0.864744246, -0.502212465}, {-0.865513623, -0.500885367},
    {-0.866280973, -0.499557108}, {-0.867046237, -0.498227656}, {-0.867809474, -0.496897042},
    {-0.868570685, -0.495565265}, {-0.869329870, -0.494232297}, {-0.870086968, -0.492898196},
    {-0.870842040, -0.491562903}, {-0.871595085, -0.490226477}, {-0.872346044, -0.488888890},
    {-0.873094976, -0.487550169}, {-0.873841822, -0.486210287}, {-0.874586642, -0.484869242},
    {-0.875329375, -0.483527064}, {-0.876070082, -0.482183784}, {-0.876808703, -0.480839342},
    {-0.877545297, -0.479493767}, {-0.878279805, -0.478147060}, {-0.879012227, -0.476799220},
    {-0.879742622, -0.475450277}, {-0.880470872, -0.474100202}, {-0.881197095, -0.472749025},
    {-0.881921291, -0.471396744}, {-0.882643342, -0.470043331}, {-0.883363366, -0.468688816},
    {-0.884081244, -0.467333198}, {-0.884797096, -0.465976506}, {-0.885510862, -0.464618683},
    {-0.886222541, -0.463259786}, {-0.886932135, -0.461899787}, {-0.887639642, -0.460538715},
    {-0.888345063, -0.459176540}, {-0.889048338, -0.457813293}, {-0.889749587, -0.456448972},
    {-0.890448749, -0.455083579}, {-0.891145766, -0.453717113}, {-0.891840696, -0.452349573},
    {-0.892533541, -0.450980991}, {-0.893224299, -0.449611336}, {-0.893912971, -0.448240608},
    {-0.894599497, -0.446868837}, {-0.895283937, -0.445496023}, {-0.895966232, -0.444122136},
    {-0.896646500, -0.442747235}, {-0.897324562, -0.441371262}, {-0.898000598, -0.439994276},
    {-0.898674488, -0.438616246}, {-0.899346232, -0.437237173}, {-0.900015891, -0.435857087},
    {-0.900683403, -0.434475958}, {-0.901348829, -0.433093816}, {-0.902012169, -0.431710660},
    {-0.902673304, -0.430326492}, {-0.903332353, -0.428941280}, {-0.903989315, -0.427555084},
    {-0.904644072, -0.426167876}, {-0.905296743, -0.424779683}, {-0.905947268, -0.423390478},
    {-0.906595707, -0.422000259}, {-0.907242000, -0.420609087}, {-0.907886088, -0.419216901},
    {-0.908528090, -0.417823702}, {-0.909168005, -0.416429549}, {-0.909805715, -0.415034413},
    {-0.910441279, -0.413638324}, {-0.911074758, -0.412241220}, {-0.911706030, -0.410843164},
    {-0.912335157, -0.409444153}, {-0.912962198, -0.408044159}, {-0.913587034, -0.406643212},
    {-0.914209783, -0.405241311}, {-0.914830327, -0.403838456}, {-0.915448725, -0.402434647},
    {-0.916064978, -0.401029885}, {-0.916679084, -0.399624199}, {-0.917290986, -0.398217559},
    {-0.917900801, -0.396809995}, {-0.918508410, -0.395401478}, {-0.919113874, -0.393992037},
    {-0.919717133, -0.392581671}, {-0.920318305, -0.391170382}, {-0.920917213, -0.389758170},
    {-0.921514034, -0.388345033}, {-0.922108650, -0.386931002}, {-0.922701120, -0.385516047},
    {-0.923291445, -0.384100199}, {-0.923879504, -0.382683426}, {-0.924465477, -0.381265759},
    {-0.925049245, -0.379847199}, {-0.925630808, -0.378427744}, {-0.926210225, -0.377007425},
    {-0.926787496, -0.375586182}, {-0.927362502, -0.374164075}, {-0.927935421, -0.372741073},
    {-0.928506076, -0.371317208}, {-0.929074585, -0.369892448}, {-0.929640889, -0.368466824},
    {-0.930205047, -0.367040336}, {-0.930766940, -0.365612984}, {-0.931326687, -0.364184797},
    {-0.931884289, -0.362755716}, {-0.932439625, -0.361325800}, {-0.932992816, -0.359895051},
    {-0.933543801, -0.358463407}, {-0.934092522, -0.357030958}, {-0.934639156, -0.355597675},
    {-0.935183525, -0.354163527}, {-0.935725689, -0.352728546}, {-0.936265647, -0.351292759},
    {-0.936803460, -0.349856138}, {-0.937339008, -0.348418683}, {-0.937872350, -0.346980423},
    {-0.938403547, -0.345541328}, {-0.938932478, -0.344101429}, {-0.939459205, -0.342660725},
    {-0.939983726, -0.341219217}, {-0.940506041, -0.339776874}, {-0.941026151, -0.338333756},
    {-0.941544056, -0.336889863}, {-0.942059755, -0.335445136}, {-0.942573190, -0.333999664},
    {-0.943084419, -0.332553357}, {-0.943593442, -0.331106305}, {-0.944100261, -0.329658449},
    {-0.944604814, -0.328209847}, {-0.945107222, -0.326760441}, {-0.945607305, -0.325310290},
    {-0.946105242, -0.323859364}, {-0.946600914, -0.322407693}, {-0.947094381, -0.320955247},
    {-0.947585583, -0.319502026}, {-0.948074579, -0.318048090}, {-0.948561370, -0.316593379},
    {-0.949045897, -0.315137923}, {-0.949528158, -0.313681751}, {-0.950008273, -0.312224805},
    {-0.950486064, -0.310767144}, {-0.950961649, -0.309308767}, {-0.951435030, -0.307849646},
    {-0.951906145, -0.306389809}, {-0.952374995, -0.304929227}, {-0.952841640, -0.303467959},
    {-0.953306019, -0.302005947}, {-0.953768194, -0.300543249}, {-0.954228103, -0.299079835},
    {-0.954685748, -0.297615707}, {-0.955141187, -0.296150893}, {-0.955594361, -0.294685364},
    {-0.956045270, -0.293219149}, {-0.956493914, -0.291752249}, {-0.956940353, -0.290284663},
    {-0.957384527, -0.288816422}, {-0.957826436, -0.287347466}, {-0.958266079, -0.285877824},
    {-0.958703458, -0.284407526}, {-0.959138632, -0.282936573}, {-0.959571540, -0.281464934},
    {-0.960002124, -0.279992640}, {-0.960430503, -0.278519690}, {-0.960856616, -0.277046084},
    {-0.961280465, -0.275571823}, {-0.961702049, -0.274096906}, {-0.962121427, -0.272621363},
    {-0.962538481, -0.271145165}, {-0.962953269, -0.269668311}, {-0.963365793, -0.268190861},
    {-0.963776052, -0.266712755}, {-0.964184046, -0.265234023}, {-0.964589775, -0.263754666},
    {-0.964993238, -0.262274712}, {-0.965394437, -0.260794103}, {-0.965793371, -0.259312928},
    {-0.966189981, -0.257831097}, {-0.966584384, -0.256348670}, {-0.966976464, -0.254865646},
    {-0.967366278, -0.253382027}, {-0.967753828, -0.251897812}, {-0.968139112, -0.250413001},
    {-0.968522072, -0.248927608}, {-0.968902826, -0.247441620}, {-0.969281256, -0.245955050},
    {-0.969657362, -0.244467899}, {-0.970031261, -0.242980182}, {-0.970402837, -0.241491884},
    {-0.970772147, -0.240003020}, {-0.971139133, -0.238513589}, {-0.971503913, -0.237023607},
    {-0.971866310, -0.235533059}, {-0.972226501, -0.234041959}, {-0.972584367, -0.232550308},
    {-0.972939968, -0.231058106}, {-0.973293245, -0.229565367}, {-0.973644257, -0.228072077},
    {-0.973992944, -0.226578265}, {-0.974339366, -0.225083917}, {-0.974683523, -0.223589033},
    {-0.975025356, -0.222093627}, {-0.975364864, -0.220597684}, {-0.975702107, -0.219101235},
    {-0.976037085, -0.217604280}, {-0.976369739, -0.216106802}, {-0.976700068, -0.214608818},
    {-0.977028131, -0.213110313}, {-0.977353871, -0.211611331}, {-0.977677345, -0.210111842},
    {-0.977998495, -0.208611846}, {-0.978317380, -0.207111374}, {-0.978633940, -0.205610409},
    {-0.978948176, -0.204108968}, {-0.979260147, -0.202607036}, {-0.979569793, -0.201104641},
    {-0.979877114, -0.199601755}, {-0.980182111, -0.198098406}, {-0.980484843, -0.196594596},
    {-0.980785251, -0.195090324}, {-0.981083393, -0.193585590}, {-0.981379211, -0.192080393},
    {-0.981672704, -0.190574750}, {-0.981963873, -0.189068660}, {-0.982252717, -0.187562123},
    {-0.982539296, -0.186055154}, {-0.982823551, -0.184547737}, {-0.983105481, -0.183039889},
    {-0.983385086, -0.181531608}, {-0.983662426, -0.180022895}, {-0.983937442, -0.178513765},
    {-0.984210074, -0.177004218}, {-0.984480441, -0.175494254}, {-0.984748483, -0.173983872},
    {-0.985014260, -0.172473088}, {-0.985277653, -0.170961887}, {-0.985538721, -0.169450298},
    {-0.985797524, -0.167938292}, {-0.986053944, -0.166425899}, {-0.986308098, -0.164913118},
    {-0.986559927, -0.163399950}, {-0.986809373, -0.161886394}, {-0.987056553, -0.160372451},
    {-0.987301409, -0.158858150}, {-0.987543941, -0.157343462}, {-0.987784147, -0.155828401},
    {-0.988022029, -0.154312968}, {-0.988257587, -0.152797192}, {-0.988490820, -0.151281044},
    {-0.988721669, -0.149764538}, {-0.988950253, -0.148247674}, {-0.989176512, -0.146730468},
    {-0.989400446, -0.145212919}, {-0.989621997, -0.143695027}, {-0.989841282, -0.142176807},
    {-0.990058184, -0.140658244}, {-0.990272820, -0.139139339}, {-0.990485072, -0.137620121},
    {-0.990695000, -0.136100575}, {-0.990902662, -0.134580702}, {-0.991107941, -0.133060530},
    {-0.991310835, -0.131540030}, {-0.991511464, -0.130019218}, {-0.991709769, -0.128498107},
    {-0.991905689, -0.126976699}, {-0.992099285, -0.125454977}, {-0.992290616, -0.123932973},
    {-0.992479563, -0.122410677}, {-0.992666125, -0.120888084}, {-0.992850423, -0.119365215},
    {-0.993032336, -0.117842063}, {-0.993211925, -0.116318628}, {-0.993389189, -0.114794925},
    {-0.993564129, -0.113270953}, {-0.993736744, -0.111746714}, {-0.993906975, -0.110222206},
    {-0.994074881, -0.108697444}, {-0.994240463, -0.107172422}, {-0.994403660, -0.105647154},
    {-0.994564593, -0.104121633}, {-0.994723141, -0.102595866}, {-0.994879305, -0.101069860},
    {-0.995033205, -0.099543616}, {-0.995184720, -0.098017141}, {-0.995333910, -0.096490428},
    {-0.995480776, -0.094963498}, {-0.995625257, -0.093436338}, {-0.995767415, -0.091908954},
    {-0.995907247, -0.090381362}, {-0.996044695, -0.088853553}, {-0.996179819, -0.087325536},
    {-0.996312618, -0.085797310}, {-0.996443033, -0.084268890}, {-0.996571124, -0.082740262},
    {-0.996696889, -0.081211448}, {-0.996820271, -0.079682440}, {-0.996941328, -0.078153245},
    {-0.997060061, -0.076623864}, {-0.997176409, -0.075094298}, {-0.997290432, -0.073564567},
    {-0.997402132, -0.072034650}, {-0.997511446, -0.070504576}, {-0.997618437, -0.068974331},
    {-0.997723043, -0.067443922}, {-0.997825325, -0.065913349}, {-0.997925282, -0.064382628},
    {-0.998022854, -0.062851757}, {-0.998118103, -0.061320737}, {-0.998211026, -0.059789572},
    {-0.998301566, -0.058258265}, {-0.998389721, -0.056726821}, {-0.998475552, -0.055195246},
    {-0.998559058, -0.053663537}, {-0.998640239, -0.052131705}, {-0.998719037, -0.050599750},
    {-0.998795450, -0.049067676}, {-0.998869538, -0.047535483}, {-0.998941302, -0.046003181},
    {-0.999010682, -0.044470772}, {-0.999077737, -0.042938258}, {-0.999142408, -0.041405641},
    {-0.999204755, -0.039872926}, {-0.999264777, -0.038340122}, {-0.999322355, -0.036807224},
    {-0.999377668, -0.035274237}, {-0.999430597, -0.033741172}, {-0.999481201, -0.032208025},
    {-0.999529421, -0.030674804}, {-0.999575317, -0.029141508}, {-0.999618828, -0.027608145},
    {-0.999660015, -0.026074719}, {-0.999698818, -0.024541229}, {-0.999735296, -0.023007682},
    {-0.999769390, -0.021474080}, {-0.999801159, -0.019940428}, {-0.999830604, -0.018406730},
    {-0.999857664, -0.016872987}, {-0.999882340, -0.015339206}, {-0.999904692, -0.013805388},
    {-0.999924719, -0.012271538}, {-0.999942362, -0.010737659}, {-0.999957621, -0.009203754},
    {-0.999970615, -0.007669829}, {-0.999981165, -0.006135885}, {-0.999989390, -0.004601926},
    {-0.999995291, -0.003067957}, {-0.999998808, -0.001533980}};
alignas(__ALIGN_BYTE_SIZE__) const cfloat fft_lut_tw1024_cfloat[1024] = {
    {1.000000000, -0.000000000},  {0.999995291, -0.003067957},  {0.999981165, -0.006135885},
    {0.999957621, -0.009203754},  {0.999924719, -0.012271538},  {0.999882340, -0.015339206},
    {0.999830604, -0.018406730},  {0.999769390, -0.021474080},  {0.999698818, -0.024541229},
    {0.999618828, -0.027608145},  {0.999529421, -0.030674804},  {0.999430597, -0.033741172},
    {0.999322355, -0.036807224},  {0.999204755, -0.039872926},  {0.999077737, -0.042938258},
    {0.998941302, -0.046003181},  {0.998795450, -0.049067676},  {0.998640239, -0.052131705},
    {0.998475552, -0.055195246},  {0.998301566, -0.058258265},  {0.998118103, -0.061320737},
    {0.997925282, -0.064382628},  {0.997723043, -0.067443922},  {0.997511446, -0.070504576},
    {0.997290432, -0.073564567},  {0.997060061, -0.076623864},  {0.996820271, -0.079682440},
    {0.996571124, -0.082740262},  {0.996312618, -0.085797310},  {0.996044695, -0.088853553},
    {0.995767415, -0.091908954},  {0.995480776, -0.094963498},  {0.995184720, -0.098017141},
    {0.994879305, -0.101069860},  {0.994564593, -0.104121633},  {0.994240463, -0.107172422},
    {0.993906975, -0.110222206},  {0.993564129, -0.113270953},  {0.993211925, -0.116318628},
    {0.992850423, -0.119365215},  {0.992479563, -0.122410677},  {0.992099285, -0.125454977},
    {0.991709769, -0.128498107},  {0.991310835, -0.131540030},  {0.990902662, -0.134580702},
    {0.990485072, -0.137620121},  {0.990058184, -0.140658244},  {0.989621997, -0.143695027},
    {0.989176512, -0.146730468},  {0.988721669, -0.149764538},  {0.988257587, -0.152797192},
    {0.987784147, -0.155828401},  {0.987301409, -0.158858150},  {0.986809373, -0.161886394},
    {0.986308098, -0.164913118},  {0.985797524, -0.167938292},  {0.985277653, -0.170961887},
    {0.984748483, -0.173983872},  {0.984210074, -0.177004218},  {0.983662426, -0.180022895},
    {0.983105481, -0.183039889},  {0.982539296, -0.186055154},  {0.981963873, -0.189068660},
    {0.981379211, -0.192080393},  {0.980785251, -0.195090324},  {0.980182111, -0.198098406},
    {0.979569793, -0.201104641},  {0.978948176, -0.204108968},  {0.978317380, -0.207111374},
    {0.977677345, -0.210111842},  {0.977028131, -0.213110313},  {0.976369739, -0.216106802},
    {0.975702107, -0.219101235},  {0.975025356, -0.222093627},  {0.974339366, -0.225083917},
    {0.973644257, -0.228072077},  {0.972939968, -0.231058106},  {0.972226501, -0.234041959},
    {0.971503913, -0.237023607},  {0.970772147, -0.240003020},  {0.970031261, -0.242980182},
    {0.969281256, -0.245955050},  {0.968522072, -0.248927608},  {0.967753828, -0.251897812},
    {0.966976464, -0.254865646},  {0.966189981, -0.257831097},  {0.965394437, -0.260794103},
    {0.964589775, -0.263754666},  {0.963776052, -0.266712755},  {0.962953269, -0.269668311},
    {0.962121427, -0.272621363},  {0.961280465, -0.275571823},  {0.960430503, -0.278519690},
    {0.959571540, -0.281464934},  {0.958703458, -0.284407526},  {0.957826436, -0.287347466},
    {0.956940353, -0.290284663},  {0.956045270, -0.293219149},  {0.955141187, -0.296150893},
    {0.954228103, -0.299079835},  {0.953306019, -0.302005947},  {0.952374995, -0.304929227},
    {0.951435030, -0.307849646},  {0.950486064, -0.310767144},  {0.949528158, -0.313681751},
    {0.948561370, -0.316593379},  {0.947585583, -0.319502026},  {0.946600914, -0.322407693},
    {0.945607305, -0.325310290},  {0.944604814, -0.328209847},  {0.943593442, -0.331106305},
    {0.942573190, -0.333999664},  {0.941544056, -0.336889863},  {0.940506041, -0.339776874},
    {0.939459205, -0.342660725},  {0.938403547, -0.345541328},  {0.937339008, -0.348418683},
    {0.936265647, -0.351292759},  {0.935183525, -0.354163527},  {0.934092522, -0.357030958},
    {0.932992816, -0.359895051},  {0.931884289, -0.362755716},  {0.930766940, -0.365612984},
    {0.929640889, -0.368466824},  {0.928506076, -0.371317208},  {0.927362502, -0.374164075},
    {0.926210225, -0.377007425},  {0.925049245, -0.379847199},  {0.923879504, -0.382683426},
    {0.922701120, -0.385516047},  {0.921514034, -0.388345033},  {0.920318305, -0.391170382},
    {0.919113874, -0.393992037},  {0.917900801, -0.396809995},  {0.916679084, -0.399624199},
    {0.915448725, -0.402434647},  {0.914209783, -0.405241311},  {0.912962198, -0.408044159},
    {0.911706030, -0.410843164},  {0.910441279, -0.413638324},  {0.909168005, -0.416429549},
    {0.907886088, -0.419216901},  {0.906595707, -0.422000259},  {0.905296743, -0.424779683},
    {0.903989315, -0.427555084},  {0.902673304, -0.430326492},  {0.901348829, -0.433093816},
    {0.900015891, -0.435857087},  {0.898674488, -0.438616246},  {0.897324562, -0.441371262},
    {0.895966232, -0.444122136},  {0.894599497, -0.446868837},  {0.893224299, -0.449611336},
    {0.891840696, -0.452349573},  {0.890448749, -0.455083579},  {0.889048338, -0.457813293},
    {0.887639642, -0.460538715},  {0.886222541, -0.463259786},  {0.884797096, -0.465976506},
    {0.883363366, -0.468688816},  {0.881921291, -0.471396744},  {0.880470872, -0.474100202},
    {0.879012227, -0.476799220},  {0.877545297, -0.479493767},  {0.876070082, -0.482183784},
    {0.874586642, -0.484869242},  {0.873094976, -0.487550169},  {0.871595085, -0.490226477},
    {0.870086968, -0.492898196},  {0.868570685, -0.495565265},  {0.867046237, -0.498227656},
    {0.865513623, -0.500885367},  {0.863972843, -0.503538370},  {0.862423956, -0.506186664},
    {0.860866964, -0.508830130},  {0.859301805, -0.511468828},  {0.857728601, -0.514102757},
    {0.856147349, -0.516731799},  {0.854557991, -0.519356012},  {0.852960587, -0.521975279},
    {0.851355195, -0.524589658},  {0.849741757, -0.527199149},  {0.848120332, -0.529803634},
    {0.846490920, -0.532403111},  {0.844853580, -0.534997642},  {0.843208253, -0.537587047},
    {0.841554999, -0.540171444},  {0.839893818, -0.542750776},  {0.838224709, -0.545324981},
    {0.836547732, -0.547894061},  {0.834862888, -0.550457954},  {0.833170176, -0.553016722},
    {0.831469595, -0.555570245},  {0.829761207, -0.558118522},  {0.828045070, -0.560661554},
    {0.826321065, -0.563199341},  {0.824589312, -0.565731823},  {0.822849810, -0.568258941},
    {0.821102500, -0.570780754},  {0.819347501, -0.573297143},  {0.817584813, -0.575808167},
    {0.815814435, -0.578313768},  {0.814036310, -0.580813944},  {0.812250614, -0.583308637},
    {0.810457170, -0.585797846},  {0.808656156, -0.588281572},  {0.806847572, -0.590759695},
    {0.805031359, -0.593232274},  {0.803207517, -0.595699310},  {0.801376164, -0.598160684},
    {0.799537241, -0.600616455},  {0.797690868, -0.603066623},  {0.795836926, -0.605511069},
    {0.793975472, -0.607949793},  {0.792106569, -0.610382795},  {0.790230215, -0.612810075},
    {0.788346410, -0.615231574},  {0.786455214, -0.617647290},  {0.784556568, -0.620057225},
    {0.782650590, -0.622461259},  {0.780737221, -0.624859512},  {0.778816521, -0.627251804},
    {0.776888490, -0.629638255},  {0.774953127, -0.632018745},  {0.773010433, -0.634393275},
    {0.771060526, -0.636761844},  {0.769103348, -0.639124453},  {0.767138898, -0.641481042},
    {0.765167236, -0.643831551},  {0.763188422, -0.646176040},  {0.761202395, -0.648514390},
    {0.759209216, -0.650846660},  {0.757208824, -0.653172851},  {0.755201399, -0.655492842},
    {0.753186822, -0.657806695},  {0.751165152, -0.660114348},  {0.749136388, -0.662415802},
    {0.747100592, -0.664710999},  {0.745057762, -0.666999936},  {0.743007958, -0.669282615},
    {0.740951121, -0.671558976},  {0.738887310, -0.673829019},  {0.736816585, -0.676092684},
    {0.734738886, -0.678350031},  {0.732654274, -0.680601001},  {0.730562747, -0.682845533},
    {0.728464365, -0.685083687},  {0.726359129, -0.687315345},  {0.724247098, -0.689540565},
    {0.722128212, -0.691759229},  {0.720002532, -0.693971455},  {0.717870057, -0.696177125},
    {0.715730846, -0.698376238},  {0.713584840, -0.700568795},  {0.711432219, -0.702754736},
    {0.709272802, -0.704934061},  {0.707106769, -0.707106769},  {0.704934061, -0.709272802},
    {0.702754736, -0.711432219},  {0.700568795, -0.713584840},  {0.698376238, -0.715730846},
    {0.696177125, -0.717870057},  {0.693971455, -0.720002532},  {0.691759229, -0.722128212},
    {0.689540565, -0.724247098},  {0.687315345, -0.726359129},  {0.685083687, -0.728464365},
    {0.682845533, -0.730562747},  {0.680601001, -0.732654274},  {0.678350031, -0.734738886},
    {0.676092684, -0.736816585},  {0.673829019, -0.738887310},  {0.671558976, -0.740951121},
    {0.669282615, -0.743007958},  {0.666999936, -0.745057762},  {0.664710999, -0.747100592},
    {0.662415802, -0.749136388},  {0.660114348, -0.751165152},  {0.657806695, -0.753186822},
    {0.655492842, -0.755201399},  {0.653172851, -0.757208824},  {0.650846660, -0.759209216},
    {0.648514390, -0.761202395},  {0.646176040, -0.763188422},  {0.643831551, -0.765167236},
    {0.641481042, -0.767138898},  {0.639124453, -0.769103348},  {0.636761844, -0.771060526},
    {0.634393275, -0.773010433},  {0.632018745, -0.774953127},  {0.629638255, -0.776888490},
    {0.627251804, -0.778816521},  {0.624859512, -0.780737221},  {0.622461259, -0.782650590},
    {0.620057225, -0.784556568},  {0.617647290, -0.786455214},  {0.615231574, -0.788346410},
    {0.612810075, -0.790230215},  {0.610382795, -0.792106569},  {0.607949793, -0.793975472},
    {0.605511069, -0.795836926},  {0.603066623, -0.797690868},  {0.600616455, -0.799537241},
    {0.598160684, -0.801376164},  {0.595699310, -0.803207517},  {0.593232274, -0.805031359},
    {0.590759695, -0.806847572},  {0.588281572, -0.808656156},  {0.585797846, -0.810457170},
    {0.583308637, -0.812250614},  {0.580813944, -0.814036310},  {0.578313768, -0.815814435},
    {0.575808167, -0.817584813},  {0.573297143, -0.819347501},  {0.570780754, -0.821102500},
    {0.568258941, -0.822849810},  {0.565731823, -0.824589312},  {0.563199341, -0.826321065},
    {0.560661554, -0.828045070},  {0.558118522, -0.829761207},  {0.555570245, -0.831469595},
    {0.553016722, -0.833170176},  {0.550457954, -0.834862888},  {0.547894061, -0.836547732},
    {0.545324981, -0.838224709},  {0.542750776, -0.839893818},  {0.540171444, -0.841554999},
    {0.537587047, -0.843208253},  {0.534997642, -0.844853580},  {0.532403111, -0.846490920},
    {0.529803634, -0.848120332},  {0.527199149, -0.849741757},  {0.524589658, -0.851355195},
    {0.521975279, -0.852960587},  {0.519356012, -0.854557991},  {0.516731799, -0.856147349},
    {0.514102757, -0.857728601},  {0.511468828, -0.859301805},  {0.508830130, -0.860866964},
    {0.506186664, -0.862423956},  {0.503538370, -0.863972843},  {0.500885367, -0.865513623},
    {0.498227656, -0.867046237},  {0.495565265, -0.868570685},  {0.492898196, -0.870086968},
    {0.490226477, -0.871595085},  {0.487550169, -0.873094976},  {0.484869242, -0.874586642},
    {0.482183784, -0.876070082},  {0.479493767, -0.877545297},  {0.476799220, -0.879012227},
    {0.474100202, -0.880470872},  {0.471396744, -0.881921291},  {0.468688816, -0.883363366},
    {0.465976506, -0.884797096},  {0.463259786, -0.886222541},  {0.460538715, -0.887639642},
    {0.457813293, -0.889048338},  {0.455083579, -0.890448749},  {0.452349573, -0.891840696},
    {0.449611336, -0.893224299},  {0.446868837, -0.894599497},  {0.444122136, -0.895966232},
    {0.441371262, -0.897324562},  {0.438616246, -0.898674488},  {0.435857087, -0.900015891},
    {0.433093816, -0.901348829},  {0.430326492, -0.902673304},  {0.427555084, -0.903989315},
    {0.424779683, -0.905296743},  {0.422000259, -0.906595707},  {0.419216901, -0.907886088},
    {0.416429549, -0.909168005},  {0.413638324, -0.910441279},  {0.410843164, -0.911706030},
    {0.408044159, -0.912962198},  {0.405241311, -0.914209783},  {0.402434647, -0.915448725},
    {0.399624199, -0.916679084},  {0.396809995, -0.917900801},  {0.393992037, -0.919113874},
    {0.391170382, -0.920318305},  {0.388345033, -0.921514034},  {0.385516047, -0.922701120},
    {0.382683426, -0.923879504},  {0.379847199, -0.925049245},  {0.377007425, -0.926210225},
    {0.374164075, -0.927362502},  {0.371317208, -0.928506076},  {0.368466824, -0.929640889},
    {0.365612984, -0.930766940},  {0.362755716, -0.931884289},  {0.359895051, -0.932992816},
    {0.357030958, -0.934092522},  {0.354163527, -0.935183525},  {0.351292759, -0.936265647},
    {0.348418683, -0.937339008},  {0.345541328, -0.938403547},  {0.342660725, -0.939459205},
    {0.339776874, -0.940506041},  {0.336889863, -0.941544056},  {0.333999664, -0.942573190},
    {0.331106305, -0.943593442},  {0.328209847, -0.944604814},  {0.325310290, -0.945607305},
    {0.322407693, -0.946600914},  {0.319502026, -0.947585583},  {0.316593379, -0.948561370},
    {0.313681751, -0.949528158},  {0.310767144, -0.950486064},  {0.307849646, -0.951435030},
    {0.304929227, -0.952374995},  {0.302005947, -0.953306019},  {0.299079835, -0.954228103},
    {0.296150893, -0.955141187},  {0.293219149, -0.956045270},  {0.290284663, -0.956940353},
    {0.287347466, -0.957826436},  {0.284407526, -0.958703458},  {0.281464934, -0.959571540},
    {0.278519690, -0.960430503},  {0.275571823, -0.961280465},  {0.272621363, -0.962121427},
    {0.269668311, -0.962953269},  {0.266712755, -0.963776052},  {0.263754666, -0.964589775},
    {0.260794103, -0.965394437},  {0.257831097, -0.966189981},  {0.254865646, -0.966976464},
    {0.251897812, -0.967753828},  {0.248927608, -0.968522072},  {0.245955050, -0.969281256},
    {0.242980182, -0.970031261},  {0.240003020, -0.970772147},  {0.237023607, -0.971503913},
    {0.234041959, -0.972226501},  {0.231058106, -0.972939968},  {0.228072077, -0.973644257},
    {0.225083917, -0.974339366},  {0.222093627, -0.975025356},  {0.219101235, -0.975702107},
    {0.216106802, -0.976369739},  {0.213110313, -0.977028131},  {0.210111842, -0.977677345},
    {0.207111374, -0.978317380},  {0.204108968, -0.978948176},  {0.201104641, -0.979569793},
    {0.198098406, -0.980182111},  {0.195090324, -0.980785251},  {0.192080393, -0.981379211},
    {0.189068660, -0.981963873},  {0.186055154, -0.982539296},  {0.183039889, -0.983105481},
    {0.180022895, -0.983662426},  {0.177004218, -0.984210074},  {0.173983872, -0.984748483},
    {0.170961887, -0.985277653},  {0.167938292, -0.985797524},  {0.164913118, -0.986308098},
    {0.161886394, -0.986809373},  {0.158858150, -0.987301409},  {0.155828401, -0.987784147},
    {0.152797192, -0.988257587},  {0.149764538, -0.988721669},  {0.146730468, -0.989176512},
    {0.143695027, -0.989621997},  {0.140658244, -0.990058184},  {0.137620121, -0.990485072},
    {0.134580702, -0.990902662},  {0.131540030, -0.991310835},  {0.128498107, -0.991709769},
    {0.125454977, -0.992099285},  {0.122410677, -0.992479563},  {0.119365215, -0.992850423},
    {0.116318628, -0.993211925},  {0.113270953, -0.993564129},  {0.110222206, -0.993906975},
    {0.107172422, -0.994240463},  {0.104121633, -0.994564593},  {0.101069860, -0.994879305},
    {0.098017141, -0.995184720},  {0.094963498, -0.995480776},  {0.091908954, -0.995767415},
    {0.088853553, -0.996044695},  {0.085797310, -0.996312618},  {0.082740262, -0.996571124},
    {0.079682440, -0.996820271},  {0.076623864, -0.997060061},  {0.073564567, -0.997290432},
    {0.070504576, -0.997511446},  {0.067443922, -0.997723043},  {0.064382628, -0.997925282},
    {0.061320737, -0.998118103},  {0.058258265, -0.998301566},  {0.055195246, -0.998475552},
    {0.052131705, -0.998640239},  {0.049067676, -0.998795450},  {0.046003181, -0.998941302},
    {0.042938258, -0.999077737},  {0.039872926, -0.999204755},  {0.036807224, -0.999322355},
    {0.033741172, -0.999430597},  {0.030674804, -0.999529421},  {0.027608145, -0.999618828},
    {0.024541229, -0.999698818},  {0.021474080, -0.999769390},  {0.018406730, -0.999830604},
    {0.015339206, -0.999882340},  {0.012271538, -0.999924719},  {0.009203754, -0.999957621},
    {0.006135885, -0.999981165},  {0.003067957, -0.999995291},  {0.000000000, -1.000000000},
    {-0.003067957, -0.999995291}, {-0.006135885, -0.999981165}, {-0.009203754, -0.999957621},
    {-0.012271538, -0.999924719}, {-0.015339206, -0.999882340}, {-0.018406730, -0.999830604},
    {-0.021474080, -0.999769390}, {-0.024541229, -0.999698818}, {-0.027608145, -0.999618828},
    {-0.030674804, -0.999529421}, {-0.033741172, -0.999430597}, {-0.036807224, -0.999322355},
    {-0.039872926, -0.999204755}, {-0.042938258, -0.999077737}, {-0.046003181, -0.998941302},
    {-0.049067676, -0.998795450}, {-0.052131705, -0.998640239}, {-0.055195246, -0.998475552},
    {-0.058258265, -0.998301566}, {-0.061320737, -0.998118103}, {-0.064382628, -0.997925282},
    {-0.067443922, -0.997723043}, {-0.070504576, -0.997511446}, {-0.073564567, -0.997290432},
    {-0.076623864, -0.997060061}, {-0.079682440, -0.996820271}, {-0.082740262, -0.996571124},
    {-0.085797310, -0.996312618}, {-0.088853553, -0.996044695}, {-0.091908954, -0.995767415},
    {-0.094963498, -0.995480776}, {-0.098017141, -0.995184720}, {-0.101069860, -0.994879305},
    {-0.104121633, -0.994564593}, {-0.107172422, -0.994240463}, {-0.110222206, -0.993906975},
    {-0.113270953, -0.993564129}, {-0.116318628, -0.993211925}, {-0.119365215, -0.992850423},
    {-0.122410677, -0.992479563}, {-0.125454977, -0.992099285}, {-0.128498107, -0.991709769},
    {-0.131540030, -0.991310835}, {-0.134580702, -0.990902662}, {-0.137620121, -0.990485072},
    {-0.140658244, -0.990058184}, {-0.143695027, -0.989621997}, {-0.146730468, -0.989176512},
    {-0.149764538, -0.988721669}, {-0.152797192, -0.988257587}, {-0.155828401, -0.987784147},
    {-0.158858150, -0.987301409}, {-0.161886394, -0.986809373}, {-0.164913118, -0.986308098},
    {-0.167938292, -0.985797524}, {-0.170961887, -0.985277653}, {-0.173983872, -0.984748483},
    {-0.177004218, -0.984210074}, {-0.180022895, -0.983662426}, {-0.183039889, -0.983105481},
    {-0.186055154, -0.982539296}, {-0.189068660, -0.981963873}, {-0.192080393, -0.981379211},
    {-0.195090324, -0.980785251}, {-0.198098406, -0.980182111}, {-0.201104641, -0.979569793},
    {-0.204108968, -0.978948176}, {-0.207111374, -0.978317380}, {-0.210111842, -0.977677345},
    {-0.213110313, -0.977028131}, {-0.216106802, -0.976369739}, {-0.219101235, -0.975702107},
    {-0.222093627, -0.975025356}, {-0.225083917, -0.974339366}, {-0.228072077, -0.973644257},
    {-0.231058106, -0.972939968}, {-0.234041959, -0.972226501}, {-0.237023607, -0.971503913},
    {-0.240003020, -0.970772147}, {-0.242980182, -0.970031261}, {-0.245955050, -0.969281256},
    {-0.248927608, -0.968522072}, {-0.251897812, -0.967753828}, {-0.254865646, -0.966976464},
    {-0.257831097, -0.966189981}, {-0.260794103, -0.965394437}, {-0.263754666, -0.964589775},
    {-0.266712755, -0.963776052}, {-0.269668311, -0.962953269}, {-0.272621363, -0.962121427},
    {-0.275571823, -0.961280465}, {-0.278519690, -0.960430503}, {-0.281464934, -0.959571540},
    {-0.284407526, -0.958703458}, {-0.287347466, -0.957826436}, {-0.290284663, -0.956940353},
    {-0.293219149, -0.956045270}, {-0.296150893, -0.955141187}, {-0.299079835, -0.954228103},
    {-0.302005947, -0.953306019}, {-0.304929227, -0.952374995}, {-0.307849646, -0.951435030},
    {-0.310767144, -0.950486064}, {-0.313681751, -0.949528158}, {-0.316593379, -0.948561370},
    {-0.319502026, -0.947585583}, {-0.322407693, -0.946600914}, {-0.325310290, -0.945607305},
    {-0.328209847, -0.944604814}, {-0.331106305, -0.943593442}, {-0.333999664, -0.942573190},
    {-0.336889863, -0.941544056}, {-0.339776874, -0.940506041}, {-0.342660725, -0.939459205},
    {-0.345541328, -0.938403547}, {-0.348418683, -0.937339008}, {-0.351292759, -0.936265647},
    {-0.354163527, -0.935183525}, {-0.357030958, -0.934092522}, {-0.359895051, -0.932992816},
    {-0.362755716, -0.931884289}, {-0.365612984, -0.930766940}, {-0.368466824, -0.929640889},
    {-0.371317208, -0.928506076}, {-0.374164075, -0.927362502}, {-0.377007425, -0.926210225},
    {-0.379847199, -0.925049245}, {-0.382683426, -0.923879504}, {-0.385516047, -0.922701120},
    {-0.388345033, -0.921514034}, {-0.391170382, -0.920318305}, {-0.393992037, -0.919113874},
    {-0.396809995, -0.917900801}, {-0.399624199, -0.916679084}, {-0.402434647, -0.915448725},
    {-0.405241311, -0.914209783}, {-0.408044159, -0.912962198}, {-0.410843164, -0.911706030},
    {-0.413638324, -0.910441279}, {-0.416429549, -0.909168005}, {-0.419216901, -0.907886088},
    {-0.422000259, -0.906595707}, {-0.424779683, -0.905296743}, {-0.427555084, -0.903989315},
    {-0.430326492, -0.902673304}, {-0.433093816, -0.901348829}, {-0.435857087, -0.900015891},
    {-0.438616246, -0.898674488}, {-0.441371262, -0.897324562}, {-0.444122136, -0.895966232},
    {-0.446868837, -0.894599497}, {-0.449611336, -0.893224299}, {-0.452349573, -0.891840696},
    {-0.455083579, -0.890448749}, {-0.457813293, -0.889048338}, {-0.460538715, -0.887639642},
    {-0.463259786, -0.886222541}, {-0.465976506, -0.884797096}, {-0.468688816, -0.883363366},
    {-0.471396744, -0.881921291}, {-0.474100202, -0.880470872}, {-0.476799220, -0.879012227},
    {-0.479493767, -0.877545297}, {-0.482183784, -0.876070082}, {-0.484869242, -0.874586642},
    {-0.487550169, -0.873094976}, {-0.490226477, -0.871595085}, {-0.492898196, -0.870086968},
    {-0.495565265, -0.868570685}, {-0.498227656, -0.867046237}, {-0.500885367, -0.865513623},
    {-0.503538370, -0.863972843}, {-0.506186664, -0.862423956}, {-0.508830130, -0.860866964},
    {-0.511468828, -0.859301805}, {-0.514102757, -0.857728601}, {-0.516731799, -0.856147349},
    {-0.519356012, -0.854557991}, {-0.521975279, -0.852960587}, {-0.524589658, -0.851355195},
    {-0.527199149, -0.849741757}, {-0.529803634, -0.848120332}, {-0.532403111, -0.846490920},
    {-0.534997642, -0.844853580}, {-0.537587047, -0.843208253}, {-0.540171444, -0.841554999},
    {-0.542750776, -0.839893818}, {-0.545324981, -0.838224709}, {-0.547894061, -0.836547732},
    {-0.550457954, -0.834862888}, {-0.553016722, -0.833170176}, {-0.555570245, -0.831469595},
    {-0.558118522, -0.829761207}, {-0.560661554, -0.828045070}, {-0.563199341, -0.826321065},
    {-0.565731823, -0.824589312}, {-0.568258941, -0.822849810}, {-0.570780754, -0.821102500},
    {-0.573297143, -0.819347501}, {-0.575808167, -0.817584813}, {-0.578313768, -0.815814435},
    {-0.580813944, -0.814036310}, {-0.583308637, -0.812250614}, {-0.585797846, -0.810457170},
    {-0.588281572, -0.808656156}, {-0.590759695, -0.806847572}, {-0.593232274, -0.805031359},
    {-0.595699310, -0.803207517}, {-0.598160684, -0.801376164}, {-0.600616455, -0.799537241},
    {-0.603066623, -0.797690868}, {-0.605511069, -0.795836926}, {-0.607949793, -0.793975472},
    {-0.610382795, -0.792106569}, {-0.612810075, -0.790230215}, {-0.615231574, -0.788346410},
    {-0.617647290, -0.786455214}, {-0.620057225, -0.784556568}, {-0.622461259, -0.782650590},
    {-0.624859512, -0.780737221}, {-0.627251804, -0.778816521}, {-0.629638255, -0.776888490},
    {-0.632018745, -0.774953127}, {-0.634393275, -0.773010433}, {-0.636761844, -0.771060526},
    {-0.639124453, -0.769103348}, {-0.641481042, -0.767138898}, {-0.643831551, -0.765167236},
    {-0.646176040, -0.763188422}, {-0.648514390, -0.761202395}, {-0.650846660, -0.759209216},
    {-0.653172851, -0.757208824}, {-0.655492842, -0.755201399}, {-0.657806695, -0.753186822},
    {-0.660114348, -0.751165152}, {-0.662415802, -0.749136388}, {-0.664710999, -0.747100592},
    {-0.666999936, -0.745057762}, {-0.669282615, -0.743007958}, {-0.671558976, -0.740951121},
    {-0.673829019, -0.738887310}, {-0.676092684, -0.736816585}, {-0.678350031, -0.734738886},
    {-0.680601001, -0.732654274}, {-0.682845533, -0.730562747}, {-0.685083687, -0.728464365},
    {-0.687315345, -0.726359129}, {-0.689540565, -0.724247098}, {-0.691759229, -0.722128212},
    {-0.693971455, -0.720002532}, {-0.696177125, -0.717870057}, {-0.698376238, -0.715730846},
    {-0.700568795, -0.713584840}, {-0.702754736, -0.711432219}, {-0.704934061, -0.709272802},
    {-0.707106769, -0.707106769}, {-0.709272802, -0.704934061}, {-0.711432219, -0.702754736},
    {-0.713584840, -0.700568795}, {-0.715730846, -0.698376238}, {-0.717870057, -0.696177125},
    {-0.720002532, -0.693971455}, {-0.722128212, -0.691759229}, {-0.724247098, -0.689540565},
    {-0.726359129, -0.687315345}, {-0.728464365, -0.685083687}, {-0.730562747, -0.682845533},
    {-0.732654274, -0.680601001}, {-0.734738886, -0.678350031}, {-0.736816585, -0.676092684},
    {-0.738887310, -0.673829019}, {-0.740951121, -0.671558976}, {-0.743007958, -0.669282615},
    {-0.745057762, -0.666999936}, {-0.747100592, -0.664710999}, {-0.749136388, -0.662415802},
    {-0.751165152, -0.660114348}, {-0.753186822, -0.657806695}, {-0.755201399, -0.655492842},
    {-0.757208824, -0.653172851}, {-0.759209216, -0.650846660}, {-0.761202395, -0.648514390},
    {-0.763188422, -0.646176040}, {-0.765167236, -0.643831551}, {-0.767138898, -0.641481042},
    {-0.769103348, -0.639124453}, {-0.771060526, -0.636761844}, {-0.773010433, -0.634393275},
    {-0.774953127, -0.632018745}, {-0.776888490, -0.629638255}, {-0.778816521, -0.627251804},
    {-0.780737221, -0.624859512}, {-0.782650590, -0.622461259}, {-0.784556568, -0.620057225},
    {-0.786455214, -0.617647290}, {-0.788346410, -0.615231574}, {-0.790230215, -0.612810075},
    {-0.792106569, -0.610382795}, {-0.793975472, -0.607949793}, {-0.795836926, -0.605511069},
    {-0.797690868, -0.603066623}, {-0.799537241, -0.600616455}, {-0.801376164, -0.598160684},
    {-0.803207517, -0.595699310}, {-0.805031359, -0.593232274}, {-0.806847572, -0.590759695},
    {-0.808656156, -0.588281572}, {-0.810457170, -0.585797846}, {-0.812250614, -0.583308637},
    {-0.814036310, -0.580813944}, {-0.815814435, -0.578313768}, {-0.817584813, -0.575808167},
    {-0.819347501, -0.573297143}, {-0.821102500, -0.570780754}, {-0.822849810, -0.568258941},
    {-0.824589312, -0.565731823}, {-0.826321065, -0.563199341}, {-0.828045070, -0.560661554},
    {-0.829761207, -0.558118522}, {-0.831469595, -0.555570245}, {-0.833170176, -0.553016722},
    {-0.834862888, -0.550457954}, {-0.836547732, -0.547894061}, {-0.838224709, -0.545324981},
    {-0.839893818, -0.542750776}, {-0.841554999, -0.540171444}, {-0.843208253, -0.537587047},
    {-0.844853580, -0.534997642}, {-0.846490920, -0.532403111}, {-0.848120332, -0.529803634},
    {-0.849741757, -0.527199149}, {-0.851355195, -0.524589658}, {-0.852960587, -0.521975279},
    {-0.854557991, -0.519356012}, {-0.856147349, -0.516731799}, {-0.857728601, -0.514102757},
    {-0.859301805, -0.511468828}, {-0.860866964, -0.508830130}, {-0.862423956, -0.506186664},
    {-0.863972843, -0.503538370}, {-0.865513623, -0.500885367}, {-0.867046237, -0.498227656},
    {-0.868570685, -0.495565265}, {-0.870086968, -0.492898196}, {-0.871595085, -0.490226477},
    {-0.873094976, -0.487550169}, {-0.874586642, -0.484869242}, {-0.876070082, -0.482183784},
    {-0.877545297, -0.479493767}, {-0.879012227, -0.476799220}, {-0.880470872, -0.474100202},
    {-0.881921291, -0.471396744}, {-0.883363366, -0.468688816}, {-0.884797096, -0.465976506},
    {-0.886222541, -0.463259786}, {-0.887639642, -0.460538715}, {-0.889048338, -0.457813293},
    {-0.890448749, -0.455083579}, {-0.891840696, -0.452349573}, {-0.893224299, -0.449611336},
    {-0.894599497, -0.446868837}, {-0.895966232, -0.444122136}, {-0.897324562, -0.441371262},
    {-0.898674488, -0.438616246}, {-0.900015891, -0.435857087}, {-0.901348829, -0.433093816},
    {-0.902673304, -0.430326492}, {-0.903989315, -0.427555084}, {-0.905296743, -0.424779683},
    {-0.906595707, -0.422000259}, {-0.907886088, -0.419216901}, {-0.909168005, -0.416429549},
    {-0.910441279, -0.413638324}, {-0.911706030, -0.410843164}, {-0.912962198, -0.408044159},
    {-0.914209783, -0.405241311}, {-0.915448725, -0.402434647}, {-0.916679084, -0.399624199},
    {-0.917900801, -0.396809995}, {-0.919113874, -0.393992037}, {-0.920318305, -0.391170382},
    {-0.921514034, -0.388345033}, {-0.922701120, -0.385516047}, {-0.923879504, -0.382683426},
    {-0.925049245, -0.379847199}, {-0.926210225, -0.377007425}, {-0.927362502, -0.374164075},
    {-0.928506076, -0.371317208}, {-0.929640889, -0.368466824}, {-0.930766940, -0.365612984},
    {-0.931884289, -0.362755716}, {-0.932992816, -0.359895051}, {-0.934092522, -0.357030958},
    {-0.935183525, -0.354163527}, {-0.936265647, -0.351292759}, {-0.937339008, -0.348418683},
    {-0.938403547, -0.345541328}, {-0.939459205, -0.342660725}, {-0.940506041, -0.339776874},
    {-0.941544056, -0.336889863}, {-0.942573190, -0.333999664}, {-0.943593442, -0.331106305},
    {-0.944604814, -0.328209847}, {-0.945607305, -0.325310290}, {-0.946600914, -0.322407693},
    {-0.947585583, -0.319502026}, {-0.948561370, -0.316593379}, {-0.949528158, -0.313681751},
    {-0.950486064, -0.310767144}, {-0.951435030, -0.307849646}, {-0.952374995, -0.304929227},
    {-0.953306019, -0.302005947}, {-0.954228103, -0.299079835}, {-0.955141187, -0.296150893},
    {-0.956045270, -0.293219149}, {-0.956940353, -0.290284663}, {-0.957826436, -0.287347466},
    {-0.958703458, -0.284407526}, {-0.959571540, -0.281464934}, {-0.960430503, -0.278519690},
    {-0.961280465, -0.275571823}, {-0.962121427, -0.272621363}, {-0.962953269, -0.269668311},
    {-0.963776052, -0.266712755}, {-0.964589775, -0.263754666}, {-0.965394437, -0.260794103},
    {-0.966189981, -0.257831097}, {-0.966976464, -0.254865646}, {-0.967753828, -0.251897812},
    {-0.968522072, -0.248927608}, {-0.969281256, -0.245955050}, {-0.970031261, -0.242980182},
    {-0.970772147, -0.240003020}, {-0.971503913, -0.237023607}, {-0.972226501, -0.234041959},
    {-0.972939968, -0.231058106}, {-0.973644257, -0.228072077}, {-0.974339366, -0.225083917},
    {-0.975025356, -0.222093627}, {-0.975702107, -0.219101235}, {-0.976369739, -0.216106802},
    {-0.977028131, -0.213110313}, {-0.977677345, -0.210111842}, {-0.978317380, -0.207111374},
    {-0.978948176, -0.204108968}, {-0.979569793, -0.201104641}, {-0.980182111, -0.198098406},
    {-0.980785251, -0.195090324}, {-0.981379211, -0.192080393}, {-0.981963873, -0.189068660},
    {-0.982539296, -0.186055154}, {-0.983105481, -0.183039889}, {-0.983662426, -0.180022895},
    {-0.984210074, -0.177004218}, {-0.984748483, -0.173983872}, {-0.985277653, -0.170961887},
    {-0.985797524, -0.167938292}, {-0.986308098, -0.164913118}, {-0.986809373, -0.161886394},
    {-0.987301409, -0.158858150}, {-0.987784147, -0.155828401}, {-0.988257587, -0.152797192},
    {-0.988721669, -0.149764538}, {-0.989176512, -0.146730468}, {-0.989621997, -0.143695027},
    {-0.990058184, -0.140658244}, {-0.990485072, -0.137620121}, {-0.990902662, -0.134580702},
    {-0.991310835, -0.131540030}, {-0.991709769, -0.128498107}, {-0.992099285, -0.125454977},
    {-0.992479563, -0.122410677}, {-0.992850423, -0.119365215}, {-0.993211925, -0.116318628},
    {-0.993564129, -0.113270953}, {-0.993906975, -0.110222206}, {-0.994240463, -0.107172422},
    {-0.994564593, -0.104121633}, {-0.994879305, -0.101069860}, {-0.995184720, -0.098017141},
    {-0.995480776, -0.094963498}, {-0.995767415, -0.091908954}, {-0.996044695, -0.088853553},
    {-0.996312618, -0.085797310}, {-0.996571124, -0.082740262}, {-0.996820271, -0.079682440},
    {-0.997060061, -0.076623864}, {-0.997290432, -0.073564567}, {-0.997511446, -0.070504576},
    {-0.997723043, -0.067443922}, {-0.997925282, -0.064382628}, {-0.998118103, -0.061320737},
    {-0.998301566, -0.058258265}, {-0.998475552, -0.055195246}, {-0.998640239, -0.052131705},
    {-0.998795450, -0.049067676}, {-0.998941302, -0.046003181}, {-0.999077737, -0.042938258},
    {-0.999204755, -0.039872926}, {-0.999322355, -0.036807224}, {-0.999430597, -0.033741172},
    {-0.999529421, -0.030674804}, {-0.999618828, -0.027608145}, {-0.999698818, -0.024541229},
    {-0.999769390, -0.021474080}, {-0.999830604, -0.018406730}, {-0.999882340, -0.015339206},
    {-0.999924719, -0.012271538}, {-0.999957621, -0.009203754}, {-0.999981165, -0.006135885},
    {-0.999995291, -0.003067957}};
alignas(__ALIGN_BYTE_SIZE__) const cfloat fft_lut_tw512_cfloat[512] = {
    {1.000000000, -0.000000000},  {0.999981165, -0.006135885},  {0.999924719, -0.012271538},
    {0.999830604, -0.018406730},  {0.999698818, -0.024541229},  {0.999529421, -0.030674804},
    {0.999322355, -0.036807224},  {0.999077737, -0.042938258},  {0.998795450, -0.049067676},
    {0.998475552, -0.055195246},  {0.998118103, -0.061320737},  {0.997723043, -0.067443922},
    {0.997290432, -0.073564567},  {0.996820271, -0.079682440},  {0.996312618, -0.085797310},
    {0.995767415, -0.091908954},  {0.995184720, -0.098017141},  {0.994564593, -0.104121633},
    {0.993906975, -0.110222206},  {0.993211925, -0.116318628},  {0.992479563, -0.122410677},
    {0.991709769, -0.128498107},  {0.990902662, -0.134580702},  {0.990058184, -0.140658244},
    {0.989176512, -0.146730468},  {0.988257587, -0.152797192},  {0.987301409, -0.158858150},
    {0.986308098, -0.164913118},  {0.985277653, -0.170961887},  {0.984210074, -0.177004218},
    {0.983105481, -0.183039889},  {0.981963873, -0.189068660},  {0.980785251, -0.195090324},
    {0.979569793, -0.201104641},  {0.978317380, -0.207111374},  {0.977028131, -0.213110313},
    {0.975702107, -0.219101235},  {0.974339366, -0.225083917},  {0.972939968, -0.231058106},
    {0.971503913, -0.237023607},  {0.970031261, -0.242980182},  {0.968522072, -0.248927608},
    {0.966976464, -0.254865646},  {0.965394437, -0.260794103},  {0.963776052, -0.266712755},
    {0.962121427, -0.272621363},  {0.960430503, -0.278519690},  {0.958703458, -0.284407526},
    {0.956940353, -0.290284663},  {0.955141187, -0.296150893},  {0.953306019, -0.302005947},
    {0.951435030, -0.307849646},  {0.949528158, -0.313681751},  {0.947585583, -0.319502026},
    {0.945607305, -0.325310290},  {0.943593442, -0.331106305},  {0.941544056, -0.336889863},
    {0.939459205, -0.342660725},  {0.937339008, -0.348418683},  {0.935183525, -0.354163527},
    {0.932992816, -0.359895051},  {0.930766940, -0.365612984},  {0.928506076, -0.371317208},
    {0.926210225, -0.377007425},  {0.923879504, -0.382683426},  {0.921514034, -0.388345033},
    {0.919113874, -0.393992037},  {0.916679084, -0.399624199},  {0.914209783, -0.405241311},
    {0.911706030, -0.410843164},  {0.909168005, -0.416429549},  {0.906595707, -0.422000259},
    {0.903989315, -0.427555084},  {0.901348829, -0.433093816},  {0.898674488, -0.438616246},
    {0.895966232, -0.444122136},  {0.893224299, -0.449611336},  {0.890448749, -0.455083579},
    {0.887639642, -0.460538715},  {0.884797096, -0.465976506},  {0.881921291, -0.471396744},
    {0.879012227, -0.476799220},  {0.876070082, -0.482183784},  {0.873094976, -0.487550169},
    {0.870086968, -0.492898196},  {0.867046237, -0.498227656},  {0.863972843, -0.503538370},
    {0.860866964, -0.508830130},  {0.857728601, -0.514102757},  {0.854557991, -0.519356012},
    {0.851355195, -0.524589658},  {0.848120332, -0.529803634},  {0.844853580, -0.534997642},
    {0.841554999, -0.540171444},  {0.838224709, -0.545324981},  {0.834862888, -0.550457954},
    {0.831469595, -0.555570245},  {0.828045070, -0.560661554},  {0.824589312, -0.565731823},
    {0.821102500, -0.570780754},  {0.817584813, -0.575808167},  {0.814036310, -0.580813944},
    {0.810457170, -0.585797846},  {0.806847572, -0.590759695},  {0.803207517, -0.595699310},
    {0.799537241, -0.600616455},  {0.795836926, -0.605511069},  {0.792106569, -0.610382795},
    {0.788346410, -0.615231574},  {0.784556568, -0.620057225},  {0.780737221, -0.624859512},
    {0.776888490, -0.629638255},  {0.773010433, -0.634393275},  {0.769103348, -0.639124453},
    {0.765167236, -0.643831551},  {0.761202395, -0.648514390},  {0.757208824, -0.653172851},
    {0.753186822, -0.657806695},  {0.749136388, -0.662415802},  {0.745057762, -0.666999936},
    {0.740951121, -0.671558976},  {0.736816585, -0.676092684},  {0.732654274, -0.680601001},
    {0.728464365, -0.685083687},  {0.724247098, -0.689540565},  {0.720002532, -0.693971455},
    {0.715730846, -0.698376238},  {0.711432219, -0.702754736},  {0.707106769, -0.707106769},
    {0.702754736, -0.711432219},  {0.698376238, -0.715730846},  {0.693971455, -0.720002532},
    {0.689540565, -0.724247098},  {0.685083687, -0.728464365},  {0.680601001, -0.732654274},
    {0.676092684, -0.736816585},  {0.671558976, -0.740951121},  {0.666999936, -0.745057762},
    {0.662415802, -0.749136388},  {0.657806695, -0.753186822},  {0.653172851, -0.757208824},
    {0.648514390, -0.761202395},  {0.643831551, -0.765167236},  {0.639124453, -0.769103348},
    {0.634393275, -0.773010433},  {0.629638255, -0.776888490},  {0.624859512, -0.780737221},
    {0.620057225, -0.784556568},  {0.615231574, -0.788346410},  {0.610382795, -0.792106569},
    {0.605511069, -0.795836926},  {0.600616455, -0.799537241},  {0.595699310, -0.803207517},
    {0.590759695, -0.806847572},  {0.585797846, -0.810457170},  {0.580813944, -0.814036310},
    {0.575808167, -0.817584813},  {0.570780754, -0.821102500},  {0.565731823, -0.824589312},
    {0.560661554, -0.828045070},  {0.555570245, -0.831469595},  {0.550457954, -0.834862888},
    {0.545324981, -0.838224709},  {0.540171444, -0.841554999},  {0.534997642, -0.844853580},
    {0.529803634, -0.848120332},  {0.524589658, -0.851355195},  {0.519356012, -0.854557991},
    {0.514102757, -0.857728601},  {0.508830130, -0.860866964},  {0.503538370, -0.863972843},
    {0.498227656, -0.867046237},  {0.492898196, -0.870086968},  {0.487550169, -0.873094976},
    {0.482183784, -0.876070082},  {0.476799220, -0.879012227},  {0.471396744, -0.881921291},
    {0.465976506, -0.884797096},  {0.460538715, -0.887639642},  {0.455083579, -0.890448749},
    {0.449611336, -0.893224299},  {0.444122136, -0.895966232},  {0.438616246, -0.898674488},
    {0.433093816, -0.901348829},  {0.427555084, -0.903989315},  {0.422000259, -0.906595707},
    {0.416429549, -0.909168005},  {0.410843164, -0.911706030},  {0.405241311, -0.914209783},
    {0.399624199, -0.916679084},  {0.393992037, -0.919113874},  {0.388345033, -0.921514034},
    {0.382683426, -0.923879504},  {0.377007425, -0.926210225},  {0.371317208, -0.928506076},
    {0.365612984, -0.930766940},  {0.359895051, -0.932992816},  {0.354163527, -0.935183525},
    {0.348418683, -0.937339008},  {0.342660725, -0.939459205},  {0.336889863, -0.941544056},
    {0.331106305, -0.943593442},  {0.325310290, -0.945607305},  {0.319502026, -0.947585583},
    {0.313681751, -0.949528158},  {0.307849646, -0.951435030},  {0.302005947, -0.953306019},
    {0.296150893, -0.955141187},  {0.290284663, -0.956940353},  {0.284407526, -0.958703458},
    {0.278519690, -0.960430503},  {0.272621363, -0.962121427},  {0.266712755, -0.963776052},
    {0.260794103, -0.965394437},  {0.254865646, -0.966976464},  {0.248927608, -0.968522072},
    {0.242980182, -0.970031261},  {0.237023607, -0.971503913},  {0.231058106, -0.972939968},
    {0.225083917, -0.974339366},  {0.219101235, -0.975702107},  {0.213110313, -0.977028131},
    {0.207111374, -0.978317380},  {0.201104641, -0.979569793},  {0.195090324, -0.980785251},
    {0.189068660, -0.981963873},  {0.183039889, -0.983105481},  {0.177004218, -0.984210074},
    {0.170961887, -0.985277653},  {0.164913118, -0.986308098},  {0.158858150, -0.987301409},
    {0.152797192, -0.988257587},  {0.146730468, -0.989176512},  {0.140658244, -0.990058184},
    {0.134580702, -0.990902662},  {0.128498107, -0.991709769},  {0.122410677, -0.992479563},
    {0.116318628, -0.993211925},  {0.110222206, -0.993906975},  {0.104121633, -0.994564593},
    {0.098017141, -0.995184720},  {0.091908954, -0.995767415},  {0.085797310, -0.996312618},
    {0.079682440, -0.996820271},  {0.073564567, -0.997290432},  {0.067443922, -0.997723043},
    {0.061320737, -0.998118103},  {0.055195246, -0.998475552},  {0.049067676, -0.998795450},
    {0.042938258, -0.999077737},  {0.036807224, -0.999322355},  {0.030674804, -0.999529421},
    {0.024541229, -0.999698818},  {0.018406730, -0.999830604},  {0.012271538, -0.999924719},
    {0.006135885, -0.999981165},  {0.000000000, -1.000000000},  {-0.006135885, -0.999981165},
    {-0.012271538, -0.999924719}, {-0.018406730, -0.999830604}, {-0.024541229, -0.999698818},
    {-0.030674804, -0.999529421}, {-0.036807224, -0.999322355}, {-0.042938258, -0.999077737},
    {-0.049067676, -0.998795450}, {-0.055195246, -0.998475552}, {-0.061320737, -0.998118103},
    {-0.067443922, -0.997723043}, {-0.073564567, -0.997290432}, {-0.079682440, -0.996820271},
    {-0.085797310, -0.996312618}, {-0.091908954, -0.995767415}, {-0.098017141, -0.995184720},
    {-0.104121633, -0.994564593}, {-0.110222206, -0.993906975}, {-0.116318628, -0.993211925},
    {-0.122410677, -0.992479563}, {-0.128498107, -0.991709769}, {-0.134580702, -0.990902662},
    {-0.140658244, -0.990058184}, {-0.146730468, -0.989176512}, {-0.152797192, -0.988257587},
    {-0.158858150, -0.987301409}, {-0.164913118, -0.986308098}, {-0.170961887, -0.985277653},
    {-0.177004218, -0.984210074}, {-0.183039889, -0.983105481}, {-0.189068660, -0.981963873},
    {-0.195090324, -0.980785251}, {-0.201104641, -0.979569793}, {-0.207111374, -0.978317380},
    {-0.213110313, -0.977028131}, {-0.219101235, -0.975702107}, {-0.225083917, -0.974339366},
    {-0.231058106, -0.972939968}, {-0.237023607, -0.971503913}, {-0.242980182, -0.970031261},
    {-0.248927608, -0.968522072}, {-0.254865646, -0.966976464}, {-0.260794103, -0.965394437},
    {-0.266712755, -0.963776052}, {-0.272621363, -0.962121427}, {-0.278519690, -0.960430503},
    {-0.284407526, -0.958703458}, {-0.290284663, -0.956940353}, {-0.296150893, -0.955141187},
    {-0.302005947, -0.953306019}, {-0.307849646, -0.951435030}, {-0.313681751, -0.949528158},
    {-0.319502026, -0.947585583}, {-0.325310290, -0.945607305}, {-0.331106305, -0.943593442},
    {-0.336889863, -0.941544056}, {-0.342660725, -0.939459205}, {-0.348418683, -0.937339008},
    {-0.354163527, -0.935183525}, {-0.359895051, -0.932992816}, {-0.365612984, -0.930766940},
    {-0.371317208, -0.928506076}, {-0.377007425, -0.926210225}, {-0.382683426, -0.923879504},
    {-0.388345033, -0.921514034}, {-0.393992037, -0.919113874}, {-0.399624199, -0.916679084},
    {-0.405241311, -0.914209783}, {-0.410843164, -0.911706030}, {-0.416429549, -0.909168005},
    {-0.422000259, -0.906595707}, {-0.427555084, -0.903989315}, {-0.433093816, -0.901348829},
    {-0.438616246, -0.898674488}, {-0.444122136, -0.895966232}, {-0.449611336, -0.893224299},
    {-0.455083579, -0.890448749}, {-0.460538715, -0.887639642}, {-0.465976506, -0.884797096},
    {-0.471396744, -0.881921291}, {-0.476799220, -0.879012227}, {-0.482183784, -0.876070082},
    {-0.487550169, -0.873094976}, {-0.492898196, -0.870086968}, {-0.498227656, -0.867046237},
    {-0.503538370, -0.863972843}, {-0.508830130, -0.860866964}, {-0.514102757, -0.857728601},
    {-0.519356012, -0.854557991}, {-0.524589658, -0.851355195}, {-0.529803634, -0.848120332},
    {-0.534997642, -0.844853580}, {-0.540171444, -0.841554999}, {-0.545324981, -0.838224709},
    {-0.550457954, -0.834862888}, {-0.555570245, -0.831469595}, {-0.560661554, -0.828045070},
    {-0.565731823, -0.824589312}, {-0.570780754, -0.821102500}, {-0.575808167, -0.817584813},
    {-0.580813944, -0.814036310}, {-0.585797846, -0.810457170}, {-0.590759695, -0.806847572},
    {-0.595699310, -0.803207517}, {-0.600616455, -0.799537241}, {-0.605511069, -0.795836926},
    {-0.610382795, -0.792106569}, {-0.615231574, -0.788346410}, {-0.620057225, -0.784556568},
    {-0.624859512, -0.780737221}, {-0.629638255, -0.776888490}, {-0.634393275, -0.773010433},
    {-0.639124453, -0.769103348}, {-0.643831551, -0.765167236}, {-0.648514390, -0.761202395},
    {-0.653172851, -0.757208824}, {-0.657806695, -0.753186822}, {-0.662415802, -0.749136388},
    {-0.666999936, -0.745057762}, {-0.671558976, -0.740951121}, {-0.676092684, -0.736816585},
    {-0.680601001, -0.732654274}, {-0.685083687, -0.728464365}, {-0.689540565, -0.724247098},
    {-0.693971455, -0.720002532}, {-0.698376238, -0.715730846}, {-0.702754736, -0.711432219},
    {-0.707106769, -0.707106769}, {-0.711432219, -0.702754736}, {-0.715730846, -0.698376238},
    {-0.720002532, -0.693971455}, {-0.724247098, -0.689540565}, {-0.728464365, -0.685083687},
    {-0.732654274, -0.680601001}, {-0.736816585, -0.676092684}, {-0.740951121, -0.671558976},
    {-0.745057762, -0.666999936}, {-0.749136388, -0.662415802}, {-0.753186822, -0.657806695},
    {-0.757208824, -0.653172851}, {-0.761202395, -0.648514390}, {-0.765167236, -0.643831551},
    {-0.769103348, -0.639124453}, {-0.773010433, -0.634393275}, {-0.776888490, -0.629638255},
    {-0.780737221, -0.624859512}, {-0.784556568, -0.620057225}, {-0.788346410, -0.615231574},
    {-0.792106569, -0.610382795}, {-0.795836926, -0.605511069}, {-0.799537241, -0.600616455},
    {-0.803207517, -0.595699310}, {-0.806847572, -0.590759695}, {-0.810457170, -0.585797846},
    {-0.814036310, -0.580813944}, {-0.817584813, -0.575808167}, {-0.821102500, -0.570780754},
    {-0.824589312, -0.565731823}, {-0.828045070, -0.560661554}, {-0.831469595, -0.555570245},
    {-0.834862888, -0.550457954}, {-0.838224709, -0.545324981}, {-0.841554999, -0.540171444},
    {-0.844853580, -0.534997642}, {-0.848120332, -0.529803634}, {-0.851355195, -0.524589658},
    {-0.854557991, -0.519356012}, {-0.857728601, -0.514102757}, {-0.860866964, -0.508830130},
    {-0.863972843, -0.503538370}, {-0.867046237, -0.498227656}, {-0.870086968, -0.492898196},
    {-0.873094976, -0.487550169}, {-0.876070082, -0.482183784}, {-0.879012227, -0.476799220},
    {-0.881921291, -0.471396744}, {-0.884797096, -0.465976506}, {-0.887639642, -0.460538715},
    {-0.890448749, -0.455083579}, {-0.893224299, -0.449611336}, {-0.895966232, -0.444122136},
    {-0.898674488, -0.438616246}, {-0.901348829, -0.433093816}, {-0.903989315, -0.427555084},
    {-0.906595707, -0.422000259}, {-0.909168005, -0.416429549}, {-0.911706030, -0.410843164},
    {-0.914209783, -0.405241311}, {-0.916679084, -0.399624199}, {-0.919113874, -0.393992037},
    {-0.921514034, -0.388345033}, {-0.923879504, -0.382683426}, {-0.926210225, -0.377007425},
    {-0.928506076, -0.371317208}, {-0.930766940, -0.365612984}, {-0.932992816, -0.359895051},
    {-0.935183525, -0.354163527}, {-0.937339008, -0.348418683}, {-0.939459205, -0.342660725},
    {-0.941544056, -0.336889863}, {-0.943593442, -0.331106305}, {-0.945607305, -0.325310290},
    {-0.947585583, -0.319502026}, {-0.949528158, -0.313681751}, {-0.951435030, -0.307849646},
    {-0.953306019, -0.302005947}, {-0.955141187, -0.296150893}, {-0.956940353, -0.290284663},
    {-0.958703458, -0.284407526}, {-0.960430503, -0.278519690}, {-0.962121427, -0.272621363},
    {-0.963776052, -0.266712755}, {-0.965394437, -0.260794103}, {-0.966976464, -0.254865646},
    {-0.968522072, -0.248927608}, {-0.970031261, -0.242980182}, {-0.971503913, -0.237023607},
    {-0.972939968, -0.231058106}, {-0.974339366, -0.225083917}, {-0.975702107, -0.219101235},
    {-0.977028131, -0.213110313}, {-0.978317380, -0.207111374}, {-0.979569793, -0.201104641},
    {-0.980785251, -0.195090324}, {-0.981963873, -0.189068660}, {-0.983105481, -0.183039889},
    {-0.984210074, -0.177004218}, {-0.985277653, -0.170961887}, {-0.986308098, -0.164913118},
    {-0.987301409, -0.158858150}, {-0.988257587, -0.152797192}, {-0.989176512, -0.146730468},
    {-0.990058184, -0.140658244}, {-0.990902662, -0.134580702}, {-0.991709769, -0.128498107},
    {-0.992479563, -0.122410677}, {-0.993211925, -0.116318628}, {-0.993906975, -0.110222206},
    {-0.994564593, -0.104121633}, {-0.995184720, -0.098017141}, {-0.995767415, -0.091908954},
    {-0.996312618, -0.085797310}, {-0.996820271, -0.079682440}, {-0.997290432, -0.073564567},
    {-0.997723043, -0.067443922}, {-0.998118103, -0.061320737}, {-0.998475552, -0.055195246},
    {-0.998795450, -0.049067676}, {-0.999077737, -0.042938258}, {-0.999322355, -0.036807224},
    {-0.999529421, -0.030674804}, {-0.999698818, -0.024541229}, {-0.999830604, -0.018406730},
    {-0.999924719, -0.012271538}, {-0.999981165, -0.006135885}};
alignas(__ALIGN_BYTE_SIZE__) const cfloat fft_lut_tw256_cfloat[256] = {
    {1.000000000, -0.000000000},  {0.999924719, -0.012271538},  {0.999698818, -0.024541229},
    {0.999322355, -0.036807224},  {0.998795450, -0.049067676},  {0.998118103, -0.061320737},
    {0.997290432, -0.073564567},  {0.996312618, -0.085797310},  {0.995184720, -0.098017141},
    {0.993906975, -0.110222206},  {0.992479563, -0.122410677},  {0.990902662, -0.134580702},
    {0.989176512, -0.146730468},  {0.987301409, -0.158858150},  {0.985277653, -0.170961887},
    {0.983105481, -0.183039889},  {0.980785251, -0.195090324},  {0.978317380, -0.207111374},
    {0.975702107, -0.219101235},  {0.972939968, -0.231058106},  {0.970031261, -0.242980182},
    {0.966976464, -0.254865646},  {0.963776052, -0.266712755},  {0.960430503, -0.278519690},
    {0.956940353, -0.290284663},  {0.953306019, -0.302005947},  {0.949528158, -0.313681751},
    {0.945607305, -0.325310290},  {0.941544056, -0.336889863},  {0.937339008, -0.348418683},
    {0.932992816, -0.359895051},  {0.928506076, -0.371317208},  {0.923879504, -0.382683426},
    {0.919113874, -0.393992037},  {0.914209783, -0.405241311},  {0.909168005, -0.416429549},
    {0.903989315, -0.427555084},  {0.898674488, -0.438616246},  {0.893224299, -0.449611336},
    {0.887639642, -0.460538715},  {0.881921291, -0.471396744},  {0.876070082, -0.482183784},
    {0.870086968, -0.492898196},  {0.863972843, -0.503538370},  {0.857728601, -0.514102757},
    {0.851355195, -0.524589658},  {0.844853580, -0.534997642},  {0.838224709, -0.545324981},
    {0.831469595, -0.555570245},  {0.824589312, -0.565731823},  {0.817584813, -0.575808167},
    {0.810457170, -0.585797846},  {0.803207517, -0.595699310},  {0.795836926, -0.605511069},
    {0.788346410, -0.615231574},  {0.780737221, -0.624859512},  {0.773010433, -0.634393275},
    {0.765167236, -0.643831551},  {0.757208824, -0.653172851},  {0.749136388, -0.662415802},
    {0.740951121, -0.671558976},  {0.732654274, -0.680601001},  {0.724247098, -0.689540565},
    {0.715730846, -0.698376238},  {0.707106769, -0.707106769},  {0.698376238, -0.715730846},
    {0.689540565, -0.724247098},  {0.680601001, -0.732654274},  {0.671558976, -0.740951121},
    {0.662415802, -0.749136388},  {0.653172851, -0.757208824},  {0.643831551, -0.765167236},
    {0.634393275, -0.773010433},  {0.624859512, -0.780737221},  {0.615231574, -0.788346410},
    {0.605511069, -0.795836926},  {0.595699310, -0.803207517},  {0.585797846, -0.810457170},
    {0.575808167, -0.817584813},  {0.565731823, -0.824589312},  {0.555570245, -0.831469595},
    {0.545324981, -0.838224709},  {0.534997642, -0.844853580},  {0.524589658, -0.851355195},
    {0.514102757, -0.857728601},  {0.503538370, -0.863972843},  {0.492898196, -0.870086968},
    {0.482183784, -0.876070082},  {0.471396744, -0.881921291},  {0.460538715, -0.887639642},
    {0.449611336, -0.893224299},  {0.438616246, -0.898674488},  {0.427555084, -0.903989315},
    {0.416429549, -0.909168005},  {0.405241311, -0.914209783},  {0.393992037, -0.919113874},
    {0.382683426, -0.923879504},  {0.371317208, -0.928506076},  {0.359895051, -0.932992816},
    {0.348418683, -0.937339008},  {0.336889863, -0.941544056},  {0.325310290, -0.945607305},
    {0.313681751, -0.949528158},  {0.302005947, -0.953306019},  {0.290284663, -0.956940353},
    {0.278519690, -0.960430503},  {0.266712755, -0.963776052},  {0.254865646, -0.966976464},
    {0.242980182, -0.970031261},  {0.231058106, -0.972939968},  {0.219101235, -0.975702107},
    {0.207111374, -0.978317380},  {0.195090324, -0.980785251},  {0.183039889, -0.983105481},
    {0.170961887, -0.985277653},  {0.158858150, -0.987301409},  {0.146730468, -0.989176512},
    {0.134580702, -0.990902662},  {0.122410677, -0.992479563},  {0.110222206, -0.993906975},
    {0.098017141, -0.995184720},  {0.085797310, -0.996312618},  {0.073564567, -0.997290432},
    {0.061320737, -0.998118103},  {0.049067676, -0.998795450},  {0.036807224, -0.999322355},
    {0.024541229, -0.999698818},  {0.012271538, -0.999924719},  {0.000000000, -1.000000000},
    {-0.012271538, -0.999924719}, {-0.024541229, -0.999698818}, {-0.036807224, -0.999322355},
    {-0.049067676, -0.998795450}, {-0.061320737, -0.998118103}, {-0.073564567, -0.997290432},
    {-0.085797310, -0.996312618}, {-0.098017141, -0.995184720}, {-0.110222206, -0.993906975},
    {-0.122410677, -0.992479563}, {-0.134580702, -0.990902662}, {-0.146730468, -0.989176512},
    {-0.158858150, -0.987301409}, {-0.170961887, -0.985277653}, {-0.183039889, -0.983105481},
    {-0.195090324, -0.980785251}, {-0.207111374, -0.978317380}, {-0.219101235, -0.975702107},
    {-0.231058106, -0.972939968}, {-0.242980182, -0.970031261}, {-0.254865646, -0.966976464},
    {-0.266712755, -0.963776052}, {-0.278519690, -0.960430503}, {-0.290284663, -0.956940353},
    {-0.302005947, -0.953306019}, {-0.313681751, -0.949528158}, {-0.325310290, -0.945607305},
    {-0.336889863, -0.941544056}, {-0.348418683, -0.937339008}, {-0.359895051, -0.932992816},
    {-0.371317208, -0.928506076}, {-0.382683426, -0.923879504}, {-0.393992037, -0.919113874},
    {-0.405241311, -0.914209783}, {-0.416429549, -0.909168005}, {-0.427555084, -0.903989315},
    {-0.438616246, -0.898674488}, {-0.449611336, -0.893224299}, {-0.460538715, -0.887639642},
    {-0.471396744, -0.881921291}, {-0.482183784, -0.876070082}, {-0.492898196, -0.870086968},
    {-0.503538370, -0.863972843}, {-0.514102757, -0.857728601}, {-0.524589658, -0.851355195},
    {-0.534997642, -0.844853580}, {-0.545324981, -0.838224709}, {-0.555570245, -0.831469595},
    {-0.565731823, -0.824589312}, {-0.575808167, -0.817584813}, {-0.585797846, -0.810457170},
    {-0.595699310, -0.803207517}, {-0.605511069, -0.795836926}, {-0.615231574, -0.788346410},
    {-0.624859512, -0.780737221}, {-0.634393275, -0.773010433}, {-0.643831551, -0.765167236},
    {-0.653172851, -0.757208824}, {-0.662415802, -0.749136388}, {-0.671558976, -0.740951121},
    {-0.680601001, -0.732654274}, {-0.689540565, -0.724247098}, {-0.698376238, -0.715730846},
    {-0.707106769, -0.707106769}, {-0.715730846, -0.698376238}, {-0.724247098, -0.689540565},
    {-0.732654274, -0.680601001}, {-0.740951121, -0.671558976}, {-0.749136388, -0.662415802},
    {-0.757208824, -0.653172851}, {-0.765167236, -0.643831551}, {-0.773010433, -0.634393275},
    {-0.780737221, -0.624859512}, {-0.788346410, -0.615231574}, {-0.795836926, -0.605511069},
    {-0.803207517, -0.595699310}, {-0.810457170, -0.585797846}, {-0.817584813, -0.575808167},
    {-0.824589312, -0.565731823}, {-0.831469595, -0.555570245}, {-0.838224709, -0.545324981},
    {-0.844853580, -0.534997642}, {-0.851355195, -0.524589658}, {-0.857728601, -0.514102757},
    {-0.863972843, -0.503538370}, {-0.870086968, -0.492898196}, {-0.876070082, -0.482183784},
    {-0.881921291, -0.471396744}, {-0.887639642, -0.460538715}, {-0.893224299, -0.449611336},
    {-0.898674488, -0.438616246}, {-0.903989315, -0.427555084}, {-0.909168005, -0.416429549},
    {-0.914209783, -0.405241311}, {-0.919113874, -0.393992037}, {-0.923879504, -0.382683426},
    {-0.928506076, -0.371317208}, {-0.932992816, -0.359895051}, {-0.937339008, -0.348418683},
    {-0.941544056, -0.336889863}, {-0.945607305, -0.325310290}, {-0.949528158, -0.313681751},
    {-0.953306019, -0.302005947}, {-0.956940353, -0.290284663}, {-0.960430503, -0.278519690},
    {-0.963776052, -0.266712755}, {-0.966976464, -0.254865646}, {-0.970031261, -0.242980182},
    {-0.972939968, -0.231058106}, {-0.975702107, -0.219101235}, {-0.978317380, -0.207111374},
    {-0.980785251, -0.195090324}, {-0.983105481, -0.183039889}, {-0.985277653, -0.170961887},
    {-0.987301409, -0.158858150}, {-0.989176512, -0.146730468}, {-0.990902662, -0.134580702},
    {-0.992479563, -0.122410677}, {-0.993906975, -0.110222206}, {-0.995184720, -0.098017141},
    {-0.996312618, -0.085797310}, {-0.997290432, -0.073564567}, {-0.998118103, -0.061320737},
    {-0.998795450, -0.049067676}, {-0.999322355, -0.036807224}, {-0.999698818, -0.024541229},
    {-0.999924719, -0.012271538}};
alignas(__ALIGN_BYTE_SIZE__) const cfloat fft_lut_tw128_cfloat[128] = {
    {1.000000000, -0.000000000},  {0.999698818, -0.024541229},  {0.998795450, -0.049067676},
    {0.997290432, -0.073564567},  {0.995184720, -0.098017141},  {0.992479563, -0.122410677},
    {0.989176512, -0.146730468},  {0.985277653, -0.170961887},  {0.980785251, -0.195090324},
    {0.975702107, -0.219101235},  {0.970031261, -0.242980182},  {0.963776052, -0.266712755},
    {0.956940353, -0.290284663},  {0.949528158, -0.313681751},  {0.941544056, -0.336889863},
    {0.932992816, -0.359895051},  {0.923879504, -0.382683426},  {0.914209783, -0.405241311},
    {0.903989315, -0.427555084},  {0.893224299, -0.449611336},  {0.881921291, -0.471396744},
    {0.870086968, -0.492898196},  {0.857728601, -0.514102757},  {0.844853580, -0.534997642},
    {0.831469595, -0.555570245},  {0.817584813, -0.575808167},  {0.803207517, -0.595699310},
    {0.788346410, -0.615231574},  {0.773010433, -0.634393275},  {0.757208824, -0.653172851},
    {0.740951121, -0.671558976},  {0.724247098, -0.689540565},  {0.707106769, -0.707106769},
    {0.689540565, -0.724247098},  {0.671558976, -0.740951121},  {0.653172851, -0.757208824},
    {0.634393275, -0.773010433},  {0.615231574, -0.788346410},  {0.595699310, -0.803207517},
    {0.575808167, -0.817584813},  {0.555570245, -0.831469595},  {0.534997642, -0.844853580},
    {0.514102757, -0.857728601},  {0.492898196, -0.870086968},  {0.471396744, -0.881921291},
    {0.449611336, -0.893224299},  {0.427555084, -0.903989315},  {0.405241311, -0.914209783},
    {0.382683426, -0.923879504},  {0.359895051, -0.932992816},  {0.336889863, -0.941544056},
    {0.313681751, -0.949528158},  {0.290284663, -0.956940353},  {0.266712755, -0.963776052},
    {0.242980182, -0.970031261},  {0.219101235, -0.975702107},  {0.195090324, -0.980785251},
    {0.170961887, -0.985277653},  {0.146730468, -0.989176512},  {0.122410677, -0.992479563},
    {0.098017141, -0.995184720},  {0.073564567, -0.997290432},  {0.049067676, -0.998795450},
    {0.024541229, -0.999698818},  {0.000000000, -1.000000000},  {-0.024541229, -0.999698818},
    {-0.049067676, -0.998795450}, {-0.073564567, -0.997290432}, {-0.098017141, -0.995184720},
    {-0.122410677, -0.992479563}, {-0.146730468, -0.989176512}, {-0.170961887, -0.985277653},
    {-0.195090324, -0.980785251}, {-0.219101235, -0.975702107}, {-0.242980182, -0.970031261},
    {-0.266712755, -0.963776052}, {-0.290284663, -0.956940353}, {-0.313681751, -0.949528158},
    {-0.336889863, -0.941544056}, {-0.359895051, -0.932992816}, {-0.382683426, -0.923879504},
    {-0.405241311, -0.914209783}, {-0.427555084, -0.903989315}, {-0.449611336, -0.893224299},
    {-0.471396744, -0.881921291}, {-0.492898196, -0.870086968}, {-0.514102757, -0.857728601},
    {-0.534997642, -0.844853580}, {-0.555570245, -0.831469595}, {-0.575808167, -0.817584813},
    {-0.595699310, -0.803207517}, {-0.615231574, -0.788346410}, {-0.634393275, -0.773010433},
    {-0.653172851, -0.757208824}, {-0.671558976, -0.740951121}, {-0.689540565, -0.724247098},
    {-0.707106769, -0.707106769}, {-0.724247098, -0.689540565}, {-0.740951121, -0.671558976},
    {-0.757208824, -0.653172851}, {-0.773010433, -0.634393275}, {-0.788346410, -0.615231574},
    {-0.803207517, -0.595699310}, {-0.817584813, -0.575808167}, {-0.831469595, -0.555570245},
    {-0.844853580, -0.534997642}, {-0.857728601, -0.514102757}, {-0.870086968, -0.492898196},
    {-0.881921291, -0.471396744}, {-0.893224299, -0.449611336}, {-0.903989315, -0.427555084},
    {-0.914209783, -0.405241311}, {-0.923879504, -0.382683426}, {-0.932992816, -0.359895051},
    {-0.941544056, -0.336889863}, {-0.949528158, -0.313681751}, {-0.956940353, -0.290284663},
    {-0.963776052, -0.266712755}, {-0.970031261, -0.242980182}, {-0.975702107, -0.219101235},
    {-0.980785251, -0.195090324}, {-0.985277653, -0.170961887}, {-0.989176512, -0.146730468},
    {-0.992479563, -0.122410677}, {-0.995184720, -0.098017141}, {-0.997290432, -0.073564567},
    {-0.998795450, -0.049067676}, {-0.999698818, -0.024541229}};
alignas(__ALIGN_BYTE_SIZE__) const cfloat fft_lut_tw64_cfloat[64] = {
    {1.000000000, -0.000000000},  {0.998795450, -0.049067676},  {0.995184720, -0.098017141},
    {0.989176512, -0.146730468},  {0.980785251, -0.195090324},  {0.970031261, -0.242980182},
    {0.956940353, -0.290284663},  {0.941544056, -0.336889863},  {0.923879504, -0.382683426},
    {0.903989315, -0.427555084},  {0.881921291, -0.471396744},  {0.857728601, -0.514102757},
    {0.831469595, -0.555570245},  {0.803207517, -0.595699310},  {0.773010433, -0.634393275},
    {0.740951121, -0.671558976},  {0.707106769, -0.707106769},  {0.671558976, -0.740951121},
    {0.634393275, -0.773010433},  {0.595699310, -0.803207517},  {0.555570245, -0.831469595},
    {0.514102757, -0.857728601},  {0.471396744, -0.881921291},  {0.427555084, -0.903989315},
    {0.382683426, -0.923879504},  {0.336889863, -0.941544056},  {0.290284663, -0.956940353},
    {0.242980182, -0.970031261},  {0.195090324, -0.980785251},  {0.146730468, -0.989176512},
    {0.098017141, -0.995184720},  {0.049067676, -0.998795450},  {0.000000000, -1.000000000},
    {-0.049067676, -0.998795450}, {-0.098017141, -0.995184720}, {-0.146730468, -0.989176512},
    {-0.195090324, -0.980785251}, {-0.242980182, -0.970031261}, {-0.290284663, -0.956940353},
    {-0.336889863, -0.941544056}, {-0.382683426, -0.923879504}, {-0.427555084, -0.903989315},
    {-0.471396744, -0.881921291}, {-0.514102757, -0.857728601}, {-0.555570245, -0.831469595},
    {-0.595699310, -0.803207517}, {-0.634393275, -0.773010433}, {-0.671558976, -0.740951121},
    {-0.707106769, -0.707106769}, {-0.740951121, -0.671558976}, {-0.773010433, -0.634393275},
    {-0.803207517, -0.595699310}, {-0.831469595, -0.555570245}, {-0.857728601, -0.514102757},
    {-0.881921291, -0.471396744}, {-0.903989315, -0.427555084}, {-0.923879504, -0.382683426},
    {-0.941544056, -0.336889863}, {-0.956940353, -0.290284663}, {-0.970031261, -0.242980182},
    {-0.980785251, -0.195090324}, {-0.989176512, -0.146730468}, {-0.995184720, -0.098017141},
    {-0.998795450, -0.049067676}};
alignas(__ALIGN_BYTE_SIZE__) const cfloat fft_lut_tw32_cfloat[32] = {
    {1.000000000, -0.000000000},  {0.995184720, -0.098017141},  {0.980785251, -0.195090324},
    {0.956940353, -0.290284663},  {0.923879504, -0.382683426},  {0.881921291, -0.471396744},
    {0.831469595, -0.555570245},  {0.773010433, -0.634393275},  {0.707106769, -0.707106769},
    {0.634393275, -0.773010433},  {0.555570245, -0.831469595},  {0.471396744, -0.881921291},
    {0.382683426, -0.923879504},  {0.290284663, -0.956940353},  {0.195090324, -0.980785251},
    {0.098017141, -0.995184720},  {0.000000000, -1.000000000},  {-0.098017141, -0.995184720},
    {-0.195090324, -0.980785251}, {-0.290284663, -0.956940353}, {-0.382683426, -0.923879504},
    {-0.471396744, -0.881921291}, {-0.555570245, -0.831469595}, {-0.634393275, -0.773010433},
    {-0.707106769, -0.707106769}, {-0.773010433, -0.634393275}, {-0.831469595, -0.555570245},
    {-0.881921291, -0.471396744}, {-0.923879504, -0.382683426}, {-0.956940353, -0.290284663},
    {-0.980785251, -0.195090324}, {-0.995184720, -0.098017141}};
alignas(__ALIGN_BYTE_SIZE__) const cfloat fft_lut_tw16_cfloat[16] = {
    {1.000000000, -0.000000000},  {0.980785251, -0.195090324},  {0.923879504, -0.382683426},
    {0.831469595, -0.555570245},  {0.707106769, -0.707106769},  {0.555570245, -0.831469595},
    {0.382683426, -0.923879504},  {0.195090324, -0.980785251},  {0.000000000, -1.000000000},
    {-0.195090324, -0.980785251}, {-0.382683426, -0.923879504}, {-0.555570245, -0.831469595},
    {-0.707106769, -0.707106769}, {-0.831469595, -0.555570245}, {-0.923879504, -0.382683426},
    {-0.980785251, -0.195090324}};
alignas(__ALIGN_BYTE_SIZE__) const cfloat fft_lut_tw8_cfloat[8] = {
    {1.000000000, -0.000000000},  {0.923879504, -0.382683426}, {0.707106769, -0.707106769},
    {0.382683426, -0.923879504},  {0.000000000, -1.000000000}, {-0.382683426, -0.923879504},
    {-0.707106769, -0.707106769}, {-0.923879504, -0.382683426}};
alignas(__ALIGN_BYTE_SIZE__) const cfloat fft_lut_tw4_cfloat[4] = {{1.000000000, -0.000000000},
                                                                   {0.707106769, -0.707106769},
                                                                   {0.000000000, -1.000000000},
                                                                   {-0.707106769, -0.707106769}};
alignas(__ALIGN_BYTE_SIZE__) const cfloat fft_lut_tw2_cfloat[2] = {{1.000000000, -0.000000000},
                                                                   {0.000000000, -1.000000000}};
alignas(__ALIGN_BYTE_SIZE__) const cfloat fft_lut_tw1_cfloat[1] = {{1.000000000, -0.000000000}};
#endif //__FFT_TWIDDLE_LUT_DIT_CFLOAT_H__
