/*
 * Copyright (C) 2019-2022, Xilinx, Inc.
 * Copyright (C) 2022-2025, Advanced Micro Devices, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __MRFFT_DYN_TWIDDLE_LUT_DIT_H__
#define __MRFFT_DYN_TWIDDLE_LUT_DIT_H__

static constexpr int kMaxR2Stages = 9;
static constexpr int kMaxR3Stages = 6;
static constexpr int kMaxR5Stages = 4;

static constexpr int kFanVectorLength_cint16 = 16;
static constexpr int kStepVectorLength_cint16 = 132;

static constexpr int kFanVectorLength_cfloat = 8;
static constexpr int kStepVectorLength_cfloat = 66;

static constexpr int kNumValidPointSizes = 62;

const std::array<std::array<std::array<int16, kMaxR5Stages>, kMaxR3Stages>, kMaxR2Stages> sincosLUT_indices = {
    {{{{0, 4, 15, 36}, {2, 10, 28, 58}, {7, 21, 47, -1}, {16, 38, -1, -1}, {30, 61, -1, -1}, {49, -1, -1, -1}}},
     {{{1, 8, 23, 50}, {5, 17, 40, -1}, {12, 31, -1, -1}, {24, 52, -1, -1}, {42, -1, -1, -1}, {-1, -1, -1, -1}}},
     {{{3, 13, 33, -1}, {9, 25, 54, -1}, {19, 43, -1, -1}, {34, -1, -1, -1}, {56, -1, -1, -1}, {-1, -1, -1, -1}}},
     {{{6, 20, 45, -1}, {14, 35, -1, -1}, {27, 57, -1, -1}, {46, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}}},
     {{{11, 29, 60, -1}, {22, 48, -1, -1}, {39, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}}},
     {{{18, 41, -1, -1}, {32, -1, -1, -1}, {53, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}}},
     {{{26, 55, -1, -1}, {44, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}}},
     {{{37, -1, -1, -1}, {59, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}}},
     {{{51, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}}}}};

const std::array<std::array<cint16, kFanVectorLength_cint16>, kNumValidPointSizes> sincosLUTcint16_fan16 = {{
    {{{32767, 0},
      {23170, -23170},
      {0, -32768},
      {-23170, -23170},
      {-32768, 0},
      {-23170, 23170},
      {0, 32767},
      {23170, 23170},
      {32767, 0},
      {23170, -23170},
      {0, -32768},
      {-23170, -23170},
      {-32768, 0},
      {-23170, 23170},
      {0, 32767},
      {23170, 23170}}},
    {{{32767, 0},
      {30274, -12540},
      {23170, -23170},
      {12540, -30274},
      {0, -32768},
      {-12540, -30274},
      {-23170, -23170},
      {-30274, -12540},
      {-32768, 0},
      {-30274, 12540},
      {-23170, 23170},
      {-12540, 30274},
      {0, 32767},
      {12540, 30274},
      {23170, 23170},
      {30274, 12540}}},
    {{{-16384, 28378},
      {31651, -8481},
      {28378, -16384},
      {23170, -23170},
      {16384, -28378},
      {8481, -31651},
      {0, -32768},
      {-8481, -31651},
      {-16384, -28378},
      {-23170, -23170},
      {-28378, -16384},
      {-31651, -8481},
      {-32768, 0},
      {-31651, 8481},
      {-28378, 16384},
      {-23170, 23170}}},
    {{{-32768, 0},
      {32138, -6393},
      {30274, -12540},
      {27246, -18205},
      {23170, -23170},
      {18205, -27246},
      {12540, -30274},
      {6393, -32138},
      {0, -32768},
      {-6393, -32138},
      {-12540, -30274},
      {-18205, -27246},
      {-23170, -23170},
      {-27246, -18205},
      {-30274, -12540},
      {-32138, -6393}}},
    {{{-26510, -19261},
      {32365, -5126},
      {31164, -10126},
      {29197, -14876},
      {26510, -19261},
      {23170, -23170},
      {19261, -26510},
      {14876, -29197},
      {10126, -31164},
      {5126, -32365},
      {0, -32768},
      {-5126, -32365},
      {-10126, -31164},
      {-14876, -29197},
      {-19261, -26510},
      {-23170, -23170}}},
    {{{-16384, -28378},
      {32488, -4277},
      {31651, -8481},
      {30274, -12540},
      {28378, -16384},
      {25997, -19948},
      {23170, -23170},
      {19948, -25997},
      {16384, -28378},
      {12540, -30274},
      {8481, -31651},
      {4277, -32488},
      {0, -32768},
      {-4277, -32488},
      {-8481, -31651},
      {-12540, -30274}}},
    {{{0, -32768},
      {32610, -3212},
      {32138, -6393},
      {31357, -9512},
      {30274, -12540},
      {28899, -15447},
      {27246, -18205},
      {25330, -20788},
      {23170, -23170},
      {20788, -25330},
      {18205, -27246},
      {15447, -28899},
      {12540, -30274},
      {9512, -31357},
      {6393, -32138},
      {3212, -32610}}},
    {{{5690, -32270},
      {32643, -2856},
      {32270, -5690},
      {31651, -8481},
      {30792, -11207},
      {29698, -13848},
      {28378, -16384},
      {26842, -18795},
      {25102, -21063},
      {23170, -23170},
      {21063, -25102},
      {18795, -26842},
      {16384, -28378},
      {13848, -29698},
      {11207, -30792},
      {8481, -31651}}},
    {{{10126, -31164},
      {32667, -2571},
      {32365, -5126},
      {31863, -7650},
      {31164, -10126},
      {30274, -12540},
      {29197, -14876},
      {27939, -17121},
      {26510, -19261},
      {24917, -21281},
      {23170, -23170},
      {21281, -24917},
      {19261, -26510},
      {17121, -27939},
      {14876, -29197},
      {12540, -30274}}},
    {{{16384, -28378},
      {32698, -2143},
      {32488, -4277},
      {32138, -6393},
      {31651, -8481},
      {31029, -10533},
      {30274, -12540},
      {29389, -14493},
      {28378, -16384},
      {27246, -18205},
      {25997, -19948},
      {24636, -21605},
      {23170, -23170},
      {21605, -24636},
      {19948, -25997},
      {18205, -27246}}},
    {{{21926, -24351},
      {32723, -1715},
      {32588, -3425},
      {32365, -5126},
      {32052, -6813},
      {31651, -8481},
      {31164, -10126},
      {30592, -11743},
      {29935, -13328},
      {29197, -14876},
      {28378, -16384},
      {27482, -17847},
      {26510, -19261},
      {25466, -20622},
      {24351, -21926},
      {23170, -23170}}},
    {{{23170, -23170},
      {32729, -1608},
      {32610, -3212},
      {32413, -4808},
      {32138, -6393},
      {31786, -7962},
      {31357, -9512},
      {30853, -11039},
      {30274, -12540},
      {29622, -14010},
      {28899, -15447},
      {28106, -16846},
      {27246, -18205},
      {26320, -19520},
      {25330, -20788},
      {24279, -22006}}},
    {{{25102, -21063},
      {32737, -1429},
      {32643, -2856},
      {32488, -4277},
      {32270, -5690},
      {31991, -7092},
      {31651, -8481},
      {31251, -9854},
      {30792, -11207},
      {30274, -12540},
      {29698, -13848},
      {29066, -15131},
      {28378, -16384},
      {27636, -17606},
      {26842, -18795},
      {25997, -19948}}},
    {{{26510, -19261},
      {32743, -1286},
      {32667, -2571},
      {32541, -3851},
      {32365, -5126},
      {32138, -6393},
      {31863, -7650},
      {31538, -8895},
      {31164, -10126},
      {30743, -11342},
      {30274, -12540},
      {29758, -13719},
      {29197, -14876},
      {28590, -16011},
      {27939, -17121},
      {27246, -18205}}},
    {{{28378, -16384},
      {32750, -1072},
      {32698, -2143},
      {32610, -3212},
      {32488, -4277},
      {32330, -5338},
      {32138, -6393},
      {31912, -7441},
      {31651, -8481},
      {31357, -9512},
      {31029, -10533},
      {30668, -11543},
      {30274, -12540},
      {29847, -13524},
      {29389, -14493},
      {28899, -15447}}},
    {{{28715, -15786},
      {32752, -1029},
      {32703, -2058},
      {32623, -3084},
      {32510, -4107},
      {32365, -5126},
      {32188, -6140},
      {31979, -7148},
      {31739, -8149},
      {31467, -9142},
      {31164, -10126},
      {30831, -11100},
      {30467, -12063},
      {30073, -13014},
      {29649, -13952},
      {29197, -14876}}},
    {{{29283, -14706},
      {32754, -953},
      {32713, -1905},
      {32643, -2856},
      {32546, -3804},
      {32422, -4749},
      {32270, -5690},
      {32091, -6626},
      {31885, -7557},
      {31651, -8481},
      {31391, -9398},
      {31105, -10307},
      {30792, -11207},
      {30453, -12098},
      {30088, -12979},
      {29698, -13848}}},
    {{{29935, -13328},
      {32757, -858},
      {32723, -1715},
      {32667, -2571},
      {32588, -3425},
      {32488, -4277},
      {32365, -5126},
      {32219, -5971},
      {32052, -6813},
      {31863, -7650},
      {31651, -8481},
      {31419, -9307},
      {31164, -10126},
      {30888, -10938},
      {30592, -11743},
      {30274, -12540}}},
    {{{30274, -12540},
      {32758, -804},
      {32729, -1608},
      {32679, -2411},
      {32610, -3212},
      {32522, -4011},
      {32413, -4808},
      {32286, -5602},
      {32138, -6393},
      {31972, -7180},
      {31786, -7962},
      {31581, -8740},
      {31357, -9512},
      {31114, -10279},
      {30853, -11039},
      {30572, -11793}}},
    {{{30792, -11207},
      {32760, -715},
      {32737, -1429},
      {32698, -2143},
      {32643, -2856},
      {32573, -3567},
      {32488, -4277},
      {32387, -4985},
      {32270, -5690},
      {32138, -6393},
      {31991, -7092},
      {31829, -7788},
      {31651, -8481},
      {31459, -9169},
      {31251, -9854},
      {31029, -10533}}},
    {{{31164, -10126},
      {32762, -643},
      {32743, -1286},
      {32711, -1929},
      {32667, -2571},
      {32610, -3212},
      {32541, -3851},
      {32459, -4490},
      {32365, -5126},
      {32258, -5760},
      {32138, -6393},
      {32007, -7022},
      {31863, -7650},
      {31706, -8274},
      {31538, -8895},
      {31357, -9512}}},
    {{{31499, -9032},
      {32763, -572},
      {32748, -1144},
      {32723, -1715},
      {32688, -2286},
      {32643, -2856},
      {32588, -3425},
      {32524, -3993},
      {32449, -4560},
      {32365, -5126},
      {32270, -5690},
      {32166, -6252},
      {32052, -6813},
      {31928, -7371},
      {31795, -7927},
      {31651, -8481}}},
    {{{31651, -8481},
      {32764, -536},
      {32750, -1072},
      {32729, -1608},
      {32698, -2143},
      {32658, -2678},
      {32610, -3212},
      {32553, -3745},
      {32488, -4277},
      {32413, -4808},
      {32330, -5338},
      {32239, -5866},
      {32138, -6393},
      {32029, -6918},
      {31912, -7441},
      {31786, -7962}}},
    {{{31739, -8149},
      {32764, -515},
      {32752, -1029},
      {32732, -1544},
      {32703, -2058},
      {32667, -2571},
      {32623, -3084},
      {32570, -3596},
      {32510, -4107},
      {32441, -4617},
      {32365, -5126},
      {32280, -5634},
      {32188, -6140},
      {32087, -6645},
      {31979, -7148},
      {31863, -7650}}},
    {{{31885, -7557},
      {32765, -477},
      {32754, -953},
      {32737, -1429},
      {32713, -1905},
      {32681, -2381},
      {32643, -2856},
      {32598, -3330},
      {32546, -3804},
      {32488, -4277},
      {32422, -4749},
      {32350, -5220},
      {32270, -5690},
      {32184, -6159},
      {32091, -6626},
      {31991, -7092}}},
    {{{32052, -6813},
      {32765, -429},
      {32757, -858},
      {32743, -1286},
      {32723, -1715},
      {32698, -2143},
      {32667, -2571},
      {32631, -2998},
      {32588, -3425},
      {32541, -3851},
      {32488, -4277},
      {32429, -4702},
      {32365, -5126},
      {32295, -5549},
      {32219, -5971},
      {32138, -6393}}},
    {{{32138, -6393},
      {32766, -402},
      {32758, -804},
      {32746, -1206},
      {32729, -1608},
      {32706, -2009},
      {32679, -2411},
      {32647, -2811},
      {32610, -3212},
      {32568, -3612},
      {32522, -4011},
      {32470, -4410},
      {32413, -4808},
      {32352, -5205},
      {32286, -5602},
      {32214, -5998}}},
    {{{32270, -5690},
      {32766, -357},
      {32760, -715},
      {32750, -1072},
      {32737, -1429},
      {32719, -1786},
      {32698, -2143},
      {32673, -2500},
      {32643, -2856},
      {32610, -3212},
      {32573, -3567},
      {32532, -3922},
      {32488, -4277},
      {32439, -4631},
      {32387, -4985},
      {32330, -5338}}},
    {{{32309, -5465},
      {32766, -343},
      {32761, -686},
      {32752, -1029},
      {32739, -1372},
      {32723, -1715},
      {32703, -2058},
      {32680, -2400},
      {32653, -2742},
      {32623, -3084},
      {32588, -3425},
      {32551, -3766},
      {32510, -4107},
      {32465, -4447},
      {32416, -4787},
      {32365, -5126}}},
    {{{32365, -5126},
      {32766, -322},
      {32762, -643},
      {32754, -965},
      {32743, -1286},
      {32729, -1608},
      {32711, -1929},
      {32691, -2250},
      {32667, -2571},
      {32640, -2892},
      {32610, -3212},
      {32577, -3532},
      {32541, -3851},
      {32501, -4171},
      {32459, -4490},
      {32413, -4808}}},
    {{{32374, -5063},
      {32766, -318},
      {32762, -635},
      {32754, -953},
      {32743, -1271},
      {32729, -1588},
      {32713, -1905},
      {32693, -2222},
      {32669, -2539},
      {32643, -2856},
      {32614, -3172},
      {32582, -3488},
      {32546, -3804},
      {32508, -4120},
      {32467, -4435},
      {32422, -4749}}},
    {{{32449, -4560},
      {32767, -286},
      {32763, -572},
      {32757, -858},
      {32748, -1144},
      {32737, -1429},
      {32723, -1715},
      {32707, -2000},
      {32688, -2286},
      {32667, -2571},
      {32643, -2856},
      {32617, -3141},
      {32588, -3425},
      {32557, -3709},
      {32524, -3993},
      {32488, -4277}}},
    {{{32488, -4277},
      {32767, -268},
      {32764, -536},
      {32758, -804},
      {32750, -1072},
      {32741, -1340},
      {32729, -1608},
      {32714, -1876},
      {32698, -2143},
      {32679, -2411},
      {32658, -2678},
      {32635, -2945},
      {32610, -3212},
      {32583, -3479},
      {32553, -3745},
      {32522, -4011}}},
    {{{32510, -4107},
      {32767, -257},
      {32764, -515},
      {32759, -772},
      {32752, -1029},
      {32743, -1286},
      {32732, -1544},
      {32718, -1801},
      {32703, -2058},
      {32686, -2314},
      {32667, -2571},
      {32646, -2827},
      {32623, -3084},
      {32597, -3340},
      {32570, -3596},
      {32541, -3851}}},
    {{{32546, -3804},
      {32767, -238},
      {32765, -477},
      {32760, -715},
      {32754, -953},
      {32746, -1191},
      {32737, -1429},
      {32726, -1667},
      {32713, -1905},
      {32698, -2143},
      {32681, -2381},
      {32663, -2618},
      {32643, -2856},
      {32622, -3093},
      {32598, -3330},
      {32573, -3567}}},
    {{{32588, -3425},
      {32767, -214},
      {32765, -429},
      {32762, -643},
      {32757, -858},
      {32750, -1072},
      {32743, -1286},
      {32734, -1501},
      {32723, -1715},
      {32711, -1929},
      {32698, -2143},
      {32683, -2357},
      {32667, -2571},
      {32649, -2785},
      {32631, -2998},
      {32610, -3212}}},
    {{{32603, -3289},
      {32767, -206},
      {32765, -412},
      {32762, -618},
      {32758, -823},
      {32752, -1029},
      {32745, -1235},
      {32736, -1441},
      {32727, -1646},
      {32716, -1852},
      {32703, -2058},
      {32690, -2263},
      {32675, -2468},
      {32659, -2674},
      {32641, -2879},
      {32623, -3084}}},
    {{{32610, -3212},
      {32767, -201},
      {32766, -402},
      {32762, -603},
      {32758, -804},
      {32753, -1005},
      {32746, -1206},
      {32738, -1407},
      {32729, -1608},
      {32718, -1809},
      {32706, -2009},
      {32693, -2210},
      {32679, -2411},
      {32664, -2611},
      {32647, -2811},
      {32629, -3012}}},
    {{{32626, -3046},
      {32767, -191},
      {32766, -381},
      {32763, -572},
      {32759, -762},
      {32754, -953},
      {32748, -1144},
      {32741, -1334},
      {32733, -1525},
      {32723, -1715},
      {32713, -1905},
      {32701, -2096},
      {32688, -2286},
      {32674, -2476},
      {32659, -2666},
      {32643, -2856}}},
    {{{32643, -2856},
      {32767, -179},
      {32766, -357},
      {32764, -536},
      {32760, -715},
      {32756, -893},
      {32750, -1072},
      {32744, -1251},
      {32737, -1429},
      {32729, -1608},
      {32719, -1786},
      {32709, -1965},
      {32698, -2143},
      {32686, -2321},
      {32673, -2500},
      {32658, -2678}}},
    {{{32653, -2742},
      {32767, -172},
      {32766, -343},
      {32764, -515},
      {32761, -686},
      {32757, -858},
      {32752, -1029},
      {32746, -1201},
      {32739, -1372},
      {32732, -1544},
      {32723, -1715},
      {32714, -1886},
      {32703, -2058},
      {32692, -2229},
      {32680, -2400},
      {32667, -2571}}},
    {{{32667, -2571},
      {32767, -161},
      {32766, -322},
      {32764, -483},
      {32762, -643},
      {32758, -804},
      {32754, -965},
      {32749, -1126},
      {32743, -1286},
      {32736, -1447},
      {32729, -1608},
      {32720, -1768},
      {32711, -1929},
      {32701, -2090},
      {32691, -2250},
      {32679, -2411}}},
    {{{32669, -2539},
      {32767, -159},
      {32766, -318},
      {32765, -477},
      {32762, -635},
      {32758, -794},
      {32754, -953},
      {32749, -1112},
      {32743, -1271},
      {32737, -1429},
      {32729, -1588},
      {32721, -1747},
      {32713, -1905},
      {32703, -2064},
      {32693, -2222},
      {32681, -2381}}},
    {{{32688, -2286},
      {32767, -143},
      {32767, -286},
      {32765, -429},
      {32763, -572},
      {32760, -715},
      {32757, -858},
      {32753, -1001},
      {32748, -1144},
      {32743, -1286},
      {32737, -1429},
      {32730, -1572},
      {32723, -1715},
      {32715, -1858},
      {32707, -2000},
      {32698, -2143}}},
    {{{32698, -2143},
      {32767, -134},
      {32767, -268},
      {32766, -402},
      {32764, -536},
      {32761, -670},
      {32758, -804},
      {32755, -938},
      {32750, -1072},
      {32746, -1206},
      {32741, -1340},
      {32735, -1474},
      {32729, -1608},
      {32722, -1742},
      {32714, -1876},
      {32706, -2009}}},
    {{{32703, -2058},
      {32767, -129},
      {32767, -257},
      {32766, -386},
      {32764, -515},
      {32762, -643},
      {32759, -772},
      {32756, -901},
      {32752, -1029},
      {32748, -1158},
      {32743, -1286},
      {32737, -1415},
      {32732, -1544},
      {32725, -1672},
      {32718, -1801},
      {32711, -1929}}},
    {{{32713, -1905},
      {32767, -119},
      {32767, -238},
      {32766, -357},
      {32765, -477},
      {32763, -596},
      {32760, -715},
      {32757, -834},
      {32754, -953},
      {32750, -1072},
      {32746, -1191},
      {32742, -1310},
      {32737, -1429},
      {32731, -1548},
      {32726, -1667},
      {32719, -1786}}},
    {{{32717, -1829},
      {32767, -114},
      {32767, -229},
      {32766, -343},
      {32765, -458},
      {32763, -572},
      {32761, -686},
      {32758, -801},
      {32755, -915},
      {32752, -1029},
      {32748, -1144},
      {32744, -1258},
      {32739, -1372},
      {32734, -1486},
      {32729, -1601},
      {32723, -1715}}},
    {{{32723, -1715},
      {32767, -107},
      {32767, -214},
      {32766, -322},
      {32765, -429},
      {32764, -536},
      {32762, -643},
      {32759, -751},
      {32757, -858},
      {32754, -965},
      {32750, -1072},
      {32747, -1179},
      {32743, -1286},
      {32738, -1394},
      {32734, -1501},
      {32729, -1608}}},
    {{{32724, -1694},
      {32767, -106},
      {32767, -212},
      {32766, -318},
      {32765, -424},
      {32764, -530},
      {32762, -635},
      {32760, -741},
      {32757, -847},
      {32754, -953},
      {32751, -1059},
      {32747, -1165},
      {32743, -1271},
      {32739, -1376},
      {32734, -1482},
      {32729, -1588}}},
    {{{32727, -1646},
      {32767, -103},
      {32767, -206},
      {32767, -309},
      {32765, -412},
      {32764, -515},
      {32762, -618},
      {32760, -721},
      {32758, -823},
      {32755, -926},
      {32752, -1029},
      {32748, -1132},
      {32745, -1235},
      {32741, -1338},
      {32736, -1441},
      {32732, -1544}}},
    {{{32729, -1608},
      {32767, -101},
      {32767, -201},
      {32767, -302},
      {32766, -402},
      {32764, -503},
      {32762, -603},
      {32760, -704},
      {32758, -804},
      {32756, -905},
      {32753, -1005},
      {32749, -1106},
      {32746, -1206},
      {32742, -1307},
      {32738, -1407},
      {32733, -1507}}},
    {{{32733, -1525},
      {32767, -95},
      {32767, -191},
      {32767, -286},
      {32766, -381},
      {32765, -477},
      {32763, -572},
      {32761, -667},
      {32759, -762},
      {32757, -858},
      {32754, -953},
      {32751, -1048},
      {32748, -1144},
      {32745, -1239},
      {32741, -1334},
      {32737, -1429}}},
    {{{32737, -1429},
      {32767, -89},
      {32767, -179},
      {32767, -268},
      {32766, -357},
      {32765, -447},
      {32764, -536},
      {32762, -625},
      {32760, -715},
      {32758, -804},
      {32756, -893},
      {32753, -983},
      {32750, -1072},
      {32747, -1161},
      {32744, -1251},
      {32741, -1340}}},
    {{{32739, -1372},
      {32767, -86},
      {32767, -172},
      {32767, -257},
      {32766, -343},
      {32765, -429},
      {32764, -515},
      {32762, -600},
      {32761, -686},
      {32759, -772},
      {32757, -858},
      {32754, -944},
      {32752, -1029},
      {32749, -1115},
      {32746, -1201},
      {32743, -1286}}},
    {{{32743, -1286},
      {32767, -80},
      {32767, -161},
      {32767, -241},
      {32766, -322},
      {32766, -402},
      {32764, -483},
      {32763, -563},
      {32762, -643},
      {32760, -724},
      {32758, -804},
      {32756, -885},
      {32754, -965},
      {32751, -1045},
      {32749, -1126},
      {32746, -1206}}},
    {{{32743, -1271},
      {32767, -79},
      {32767, -159},
      {32767, -238},
      {32766, -318},
      {32766, -397},
      {32765, -477},
      {32763, -556},
      {32762, -635},
      {32760, -715},
      {32758, -794},
      {32756, -874},
      {32754, -953},
      {32752, -1032},
      {32749, -1112},
      {32746, -1191}}},
    {{{32748, -1144},
      {32767, -71},
      {32767, -143},
      {32767, -214},
      {32767, -286},
      {32766, -357},
      {32765, -429},
      {32764, -500},
      {32763, -572},
      {32762, -643},
      {32760, -715},
      {32759, -786},
      {32757, -858},
      {32755, -929},
      {32753, -1001},
      {32750, -1072}}},
    {{{32750, -1098},
      {32767, -69},
      {32767, -137},
      {32767, -206},
      {32767, -275},
      {32766, -343},
      {32765, -412},
      {32764, -480},
      {32763, -549},
      {32762, -618},
      {32761, -686},
      {32759, -755},
      {32758, -823},
      {32756, -892},
      {32754, -961},
      {32752, -1029}}},
    {{{32750, -1072},
      {32767, -67},
      {32767, -134},
      {32767, -201},
      {32767, -268},
      {32766, -335},
      {32766, -402},
      {32765, -469},
      {32764, -536},
      {32762, -603},
      {32761, -670},
      {32760, -737},
      {32758, -804},
      {32756, -871},
      {32755, -938},
      {32753, -1005}}},
    {{{32752, -1029},
      {32767, -64},
      {32767, -129},
      {32767, -193},
      {32767, -257},
      {32766, -322},
      {32766, -386},
      {32765, -450},
      {32764, -515},
      {32763, -579},
      {32762, -643},
      {32760, -708},
      {32759, -772},
      {32757, -836},
      {32756, -901},
      {32754, -965}}},
    {{{32752, -1017},
      {32767, -64},
      {32767, -127},
      {32767, -191},
      {32767, -254},
      {32766, -318},
      {32766, -381},
      {32765, -445},
      {32764, -508},
      {32763, -572},
      {32762, -635},
      {32761, -699},
      {32759, -762},
      {32758, -826},
      {32756, -890},
      {32754, -953}}},
}};

const std::array<std::array<cint16, kStepVectorLength_cint16>, kNumValidPointSizes> sincosLUTcint16_step16 = {{
    {{{32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}}},
    {{{32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}}},
    {{{-16384, 28378}, {-16384, -28378}, {32767, 0}, {-16384, 28378}, {-16384, -28378}, {32767, 0},
      {-16384, 28378}, {-16384, -28378}, {32767, 0}, {-16384, 28378}, {-16384, -28378}, {32767, 0},
      {-16384, 28378}, {-16384, -28378}, {32767, 0}, {-16384, 28378}, {-16384, -28378}, {32767, 0},
      {-16384, 28378}, {-16384, -28378}, {32767, 0}, {-16384, 28378}, {-16384, -28378}, {32767, 0},
      {-16384, 28378}, {-16384, -28378}, {32767, 0}, {-16384, 28378}, {-16384, -28378}, {32767, 0},
      {-16384, 28378}, {-16384, -28378}, {32767, 0}, {-16384, 28378}, {-16384, -28378}, {32767, 0},
      {-16384, 28378}, {-16384, -28378}, {32767, 0}, {-16384, 28378}, {-16384, -28378}, {32767, 0},
      {-16384, 28378}, {-16384, -28378}, {32767, 0}, {-16384, 28378}, {-16384, -28378}, {32767, 0},
      {-16384, 28378}, {-16384, -28378}, {32767, 0}, {-16384, 28378}, {-16384, -28378}, {32767, 0},
      {-16384, 28378}, {-16384, -28378}, {32767, 0}, {-16384, 28378}, {-16384, -28378}, {32767, 0},
      {-16384, 28378}, {-16384, -28378}, {32767, 0}, {-16384, 28378}, {-16384, -28378}, {32767, 0},
      {-16384, 28378}, {-16384, -28378}, {32767, 0}, {-16384, 28378}, {-16384, -28378}, {32767, 0},
      {-16384, 28378}, {-16384, -28378}, {32767, 0}, {-16384, 28378}, {-16384, -28378}, {32767, 0},
      {-16384, 28378}, {-16384, -28378}, {32767, 0}, {-16384, 28378}, {-16384, -28378}, {32767, 0},
      {-16384, 28378}, {-16384, -28378}, {32767, 0}, {-16384, 28378}, {-16384, -28378}, {32767, 0},
      {-16384, 28378}, {-16384, -28378}, {32767, 0}, {-16384, 28378}, {-16384, -28378}, {32767, 0},
      {-16384, 28378}, {-16384, -28378}, {32767, 0}, {-16384, 28378}, {-16384, -28378}, {32767, 0},
      {-16384, 28378}, {-16384, -28378}, {32767, 0}, {-16384, 28378}, {-16384, -28378}, {32767, 0},
      {-16384, 28378}, {-16384, -28378}, {32767, 0}, {-16384, 28378}, {-16384, -28378}, {32767, 0},
      {-16384, 28378}, {-16384, -28378}, {32767, 0}, {-16384, 28378}, {-16384, -28378}, {32767, 0},
      {-16384, 28378}, {-16384, -28378}, {32767, 0}, {-16384, 28378}, {-16384, -28378}, {32767, 0},
      {-16384, 28378}, {-16384, -28378}, {32767, 0}, {-16384, 28378}, {-16384, -28378}, {32767, 0}}},
    {{{-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0},
      {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0},
      {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0},
      {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0},
      {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0},
      {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0},
      {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0},
      {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0},
      {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0},
      {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0},
      {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0},
      {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0},
      {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0},
      {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0},
      {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0},
      {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0},
      {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}}},
    {{{-26510, -19261}, {10126, 31164},   {10126, -31164},  {-26510, 19261},  {32767, 0},       {-26510, -19261},
      {10126, 31164},   {10126, -31164},  {-26510, 19261},  {32767, 0},       {-26510, -19261}, {10126, 31164},
      {10126, -31164},  {-26510, 19261},  {32767, 0},       {-26510, -19261}, {10126, 31164},   {10126, -31164},
      {-26510, 19261},  {32767, 0},       {-26510, -19261}, {10126, 31164},   {10126, -31164},  {-26510, 19261},
      {32767, 0},       {-26510, -19261}, {10126, 31164},   {10126, -31164},  {-26510, 19261},  {32767, 0},
      {-26510, -19261}, {10126, 31164},   {10126, -31164},  {-26510, 19261},  {32767, 0},       {-26510, -19261},
      {10126, 31164},   {10126, -31164},  {-26510, 19261},  {32767, 0},       {-26510, -19261}, {10126, 31164},
      {10126, -31164},  {-26510, 19261},  {32767, 0},       {-26510, -19261}, {10126, 31164},   {10126, -31164},
      {-26510, 19261},  {32767, 0},       {-26510, -19261}, {10126, 31164},   {10126, -31164},  {-26510, 19261},
      {32767, 0},       {-26510, -19261}, {10126, 31164},   {10126, -31164},  {-26510, 19261},  {32767, 0},
      {-26510, -19261}, {10126, 31164},   {10126, -31164},  {-26510, 19261},  {32767, 0},       {-26510, -19261},
      {10126, 31164},   {10126, -31164},  {-26510, 19261},  {32767, 0},       {-26510, -19261}, {10126, 31164},
      {10126, -31164},  {-26510, 19261},  {32767, 0},       {-26510, -19261}, {10126, 31164},   {10126, -31164},
      {-26510, 19261},  {32767, 0},       {-26510, -19261}, {10126, 31164},   {10126, -31164},  {-26510, 19261},
      {32767, 0},       {-26510, -19261}, {10126, 31164},   {10126, -31164},  {-26510, 19261},  {32767, 0},
      {-26510, -19261}, {10126, 31164},   {10126, -31164},  {-26510, 19261},  {32767, 0},       {-26510, -19261},
      {10126, 31164},   {10126, -31164},  {-26510, 19261},  {32767, 0},       {-26510, -19261}, {10126, 31164},
      {10126, -31164},  {-26510, 19261},  {32767, 0},       {-26510, -19261}, {10126, 31164},   {10126, -31164},
      {-26510, 19261},  {32767, 0},       {-26510, -19261}, {10126, 31164},   {10126, -31164},  {-26510, 19261},
      {32767, 0},       {-26510, -19261}, {10126, 31164},   {10126, -31164},  {-26510, 19261},  {32767, 0},
      {-26510, -19261}, {10126, 31164},   {10126, -31164},  {-26510, 19261},  {32767, 0},       {-26510, -19261},
      {10126, 31164},   {10126, -31164},  {-26510, 19261},  {32767, 0},       {-26510, -19261}, {10126, 31164}}},
    {{{-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0}}},
    {{{0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0}, {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0},
      {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0}, {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0},
      {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0}, {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0},
      {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0}, {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0},
      {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0}, {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0},
      {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0}, {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0},
      {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0}, {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0},
      {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0}, {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0},
      {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0}, {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0},
      {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0}, {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0},
      {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0}, {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0},
      {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0}, {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0},
      {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0}, {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0},
      {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0}, {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0},
      {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0}, {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0},
      {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0}, {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0},
      {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0}}},
    {{{5690, -32270},  {-30792, -11207}, {-16384, 28378},  {25102, 21063},  {25102, -21063},  {-16384, -28378},
      {-30792, 11207}, {5690, 32270},    {32767, 0},       {5690, -32270},  {-30792, -11207}, {-16384, 28378},
      {25102, 21063},  {25102, -21063},  {-16384, -28378}, {-30792, 11207}, {5690, 32270},    {32767, 0},
      {5690, -32270},  {-30792, -11207}, {-16384, 28378},  {25102, 21063},  {25102, -21063},  {-16384, -28378},
      {-30792, 11207}, {5690, 32270},    {32767, 0},       {5690, -32270},  {-30792, -11207}, {-16384, 28378},
      {25102, 21063},  {25102, -21063},  {-16384, -28378}, {-30792, 11207}, {5690, 32270},    {32767, 0},
      {5690, -32270},  {-30792, -11207}, {-16384, 28378},  {25102, 21063},  {25102, -21063},  {-16384, -28378},
      {-30792, 11207}, {5690, 32270},    {32767, 0},       {5690, -32270},  {-30792, -11207}, {-16384, 28378},
      {25102, 21063},  {25102, -21063},  {-16384, -28378}, {-30792, 11207}, {5690, 32270},    {32767, 0},
      {5690, -32270},  {-30792, -11207}, {-16384, 28378},  {25102, 21063},  {25102, -21063},  {-16384, -28378},
      {-30792, 11207}, {5690, 32270},    {32767, 0},       {5690, -32270},  {-30792, -11207}, {-16384, 28378},
      {25102, 21063},  {25102, -21063},  {-16384, -28378}, {-30792, 11207}, {5690, 32270},    {32767, 0},
      {5690, -32270},  {-30792, -11207}, {-16384, 28378},  {25102, 21063},  {25102, -21063},  {-16384, -28378},
      {-30792, 11207}, {5690, 32270},    {32767, 0},       {5690, -32270},  {-30792, -11207}, {-16384, 28378},
      {25102, 21063},  {25102, -21063},  {-16384, -28378}, {-30792, 11207}, {5690, 32270},    {32767, 0},
      {5690, -32270},  {-30792, -11207}, {-16384, 28378},  {25102, 21063},  {25102, -21063},  {-16384, -28378},
      {-30792, 11207}, {5690, 32270},    {32767, 0},       {5690, -32270},  {-30792, -11207}, {-16384, 28378},
      {25102, 21063},  {25102, -21063},  {-16384, -28378}, {-30792, 11207}, {5690, 32270},    {32767, 0},
      {5690, -32270},  {-30792, -11207}, {-16384, 28378},  {25102, 21063},  {25102, -21063},  {-16384, -28378},
      {-30792, 11207}, {5690, 32270},    {32767, 0},       {5690, -32270},  {-30792, -11207}, {-16384, 28378},
      {25102, 21063},  {25102, -21063},  {-16384, -28378}, {-30792, 11207}, {5690, 32270},    {32767, 0},
      {5690, -32270},  {-30792, -11207}, {-16384, 28378},  {25102, 21063},  {25102, -21063},  {-16384, -28378}}},
    {{{10126, -31164},  {-26510, -19261}, {-26510, 19261},  {10126, 31164},   {32767, 0},       {10126, -31164},
      {-26510, -19261}, {-26510, 19261},  {10126, 31164},   {32767, 0},       {10126, -31164},  {-26510, -19261},
      {-26510, 19261},  {10126, 31164},   {32767, 0},       {10126, -31164},  {-26510, -19261}, {-26510, 19261},
      {10126, 31164},   {32767, 0},       {10126, -31164},  {-26510, -19261}, {-26510, 19261},  {10126, 31164},
      {32767, 0},       {10126, -31164},  {-26510, -19261}, {-26510, 19261},  {10126, 31164},   {32767, 0},
      {10126, -31164},  {-26510, -19261}, {-26510, 19261},  {10126, 31164},   {32767, 0},       {10126, -31164},
      {-26510, -19261}, {-26510, 19261},  {10126, 31164},   {32767, 0},       {10126, -31164},  {-26510, -19261},
      {-26510, 19261},  {10126, 31164},   {32767, 0},       {10126, -31164},  {-26510, -19261}, {-26510, 19261},
      {10126, 31164},   {32767, 0},       {10126, -31164},  {-26510, -19261}, {-26510, 19261},  {10126, 31164},
      {32767, 0},       {10126, -31164},  {-26510, -19261}, {-26510, 19261},  {10126, 31164},   {32767, 0},
      {10126, -31164},  {-26510, -19261}, {-26510, 19261},  {10126, 31164},   {32767, 0},       {10126, -31164},
      {-26510, -19261}, {-26510, 19261},  {10126, 31164},   {32767, 0},       {10126, -31164},  {-26510, -19261},
      {-26510, 19261},  {10126, 31164},   {32767, 0},       {10126, -31164},  {-26510, -19261}, {-26510, 19261},
      {10126, 31164},   {32767, 0},       {10126, -31164},  {-26510, -19261}, {-26510, 19261},  {10126, 31164},
      {32767, 0},       {10126, -31164},  {-26510, -19261}, {-26510, 19261},  {10126, 31164},   {32767, 0},
      {10126, -31164},  {-26510, -19261}, {-26510, 19261},  {10126, 31164},   {32767, 0},       {10126, -31164},
      {-26510, -19261}, {-26510, 19261},  {10126, 31164},   {32767, 0},       {10126, -31164},  {-26510, -19261},
      {-26510, 19261},  {10126, 31164},   {32767, 0},       {10126, -31164},  {-26510, -19261}, {-26510, 19261},
      {10126, 31164},   {32767, 0},       {10126, -31164},  {-26510, -19261}, {-26510, 19261},  {10126, 31164},
      {32767, 0},       {10126, -31164},  {-26510, -19261}, {-26510, 19261},  {10126, 31164},   {32767, 0},
      {10126, -31164},  {-26510, -19261}, {-26510, 19261},  {10126, 31164},   {32767, 0},       {10126, -31164},
      {-26510, -19261}, {-26510, 19261},  {10126, 31164},   {32767, 0},       {10126, -31164},  {-26510, -19261}}},
    {{{16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0}}},
    {{{21926, -24351},  {-3425, -32588}, {-26510, -19261}, {-32052, 6813},   {-16384, 28378}, {10126, 31164},
      {29935, 13328},   {29935, -13328}, {10126, -31164},  {-16384, -28378}, {-32052, -6813}, {-26510, 19261},
      {-3425, 32588},   {21926, 24351},  {32767, 0},       {21926, -24351},  {-3425, -32588}, {-26510, -19261},
      {-32052, 6813},   {-16384, 28378}, {10126, 31164},   {29935, 13328},   {29935, -13328}, {10126, -31164},
      {-16384, -28378}, {-32052, -6813}, {-26510, 19261},  {-3425, 32588},   {21926, 24351},  {32767, 0},
      {21926, -24351},  {-3425, -32588}, {-26510, -19261}, {-32052, 6813},   {-16384, 28378}, {10126, 31164},
      {29935, 13328},   {29935, -13328}, {10126, -31164},  {-16384, -28378}, {-32052, -6813}, {-26510, 19261},
      {-3425, 32588},   {21926, 24351},  {32767, 0},       {21926, -24351},  {-3425, -32588}, {-26510, -19261},
      {-32052, 6813},   {-16384, 28378}, {10126, 31164},   {29935, 13328},   {29935, -13328}, {10126, -31164},
      {-16384, -28378}, {-32052, -6813}, {-26510, 19261},  {-3425, 32588},   {21926, 24351},  {32767, 0},
      {21926, -24351},  {-3425, -32588}, {-26510, -19261}, {-32052, 6813},   {-16384, 28378}, {10126, 31164},
      {29935, 13328},   {29935, -13328}, {10126, -31164},  {-16384, -28378}, {-32052, -6813}, {-26510, 19261},
      {-3425, 32588},   {21926, 24351},  {32767, 0},       {21926, -24351},  {-3425, -32588}, {-26510, -19261},
      {-32052, 6813},   {-16384, 28378}, {10126, 31164},   {29935, 13328},   {29935, -13328}, {10126, -31164},
      {-16384, -28378}, {-32052, -6813}, {-26510, 19261},  {-3425, 32588},   {21926, 24351},  {32767, 0},
      {21926, -24351},  {-3425, -32588}, {-26510, -19261}, {-32052, 6813},   {-16384, 28378}, {10126, 31164},
      {29935, 13328},   {29935, -13328}, {10126, -31164},  {-16384, -28378}, {-32052, -6813}, {-26510, 19261},
      {-3425, 32588},   {21926, 24351},  {32767, 0},       {21926, -24351},  {-3425, -32588}, {-26510, -19261},
      {-32052, 6813},   {-16384, 28378}, {10126, 31164},   {29935, 13328},   {29935, -13328}, {10126, -31164},
      {-16384, -28378}, {-32052, -6813}, {-26510, 19261},  {-3425, 32588},   {21926, 24351},  {32767, 0},
      {21926, -24351},  {-3425, -32588}, {-26510, -19261}, {-32052, 6813},   {-16384, 28378}, {10126, 31164},
      {29935, 13328},   {29935, -13328}, {10126, -31164},  {-16384, -28378}, {-32052, -6813}, {-26510, 19261}}},
    {{{23170, -23170},  {0, -32768}, {-23170, -23170}, {-32768, 0}, {-23170, 23170},  {0, 32767},
      {23170, 23170},   {32767, 0},  {23170, -23170},  {0, -32768}, {-23170, -23170}, {-32768, 0},
      {-23170, 23170},  {0, 32767},  {23170, 23170},   {32767, 0},  {23170, -23170},  {0, -32768},
      {-23170, -23170}, {-32768, 0}, {-23170, 23170},  {0, 32767},  {23170, 23170},   {32767, 0},
      {23170, -23170},  {0, -32768}, {-23170, -23170}, {-32768, 0}, {-23170, 23170},  {0, 32767},
      {23170, 23170},   {32767, 0},  {23170, -23170},  {0, -32768}, {-23170, -23170}, {-32768, 0},
      {-23170, 23170},  {0, 32767},  {23170, 23170},   {32767, 0},  {23170, -23170},  {0, -32768},
      {-23170, -23170}, {-32768, 0}, {-23170, 23170},  {0, 32767},  {23170, 23170},   {32767, 0},
      {23170, -23170},  {0, -32768}, {-23170, -23170}, {-32768, 0}, {-23170, 23170},  {0, 32767},
      {23170, 23170},   {32767, 0},  {23170, -23170},  {0, -32768}, {-23170, -23170}, {-32768, 0},
      {-23170, 23170},  {0, 32767},  {23170, 23170},   {32767, 0},  {23170, -23170},  {0, -32768},
      {-23170, -23170}, {-32768, 0}, {-23170, 23170},  {0, 32767},  {23170, 23170},   {32767, 0},
      {23170, -23170},  {0, -32768}, {-23170, -23170}, {-32768, 0}, {-23170, 23170},  {0, 32767},
      {23170, 23170},   {32767, 0},  {23170, -23170},  {0, -32768}, {-23170, -23170}, {-32768, 0},
      {-23170, 23170},  {0, 32767},  {23170, 23170},   {32767, 0},  {23170, -23170},  {0, -32768},
      {-23170, -23170}, {-32768, 0}, {-23170, 23170},  {0, 32767},  {23170, 23170},   {32767, 0},
      {23170, -23170},  {0, -32768}, {-23170, -23170}, {-32768, 0}, {-23170, 23170},  {0, 32767},
      {23170, 23170},   {32767, 0},  {23170, -23170},  {0, -32768}, {-23170, -23170}, {-32768, 0},
      {-23170, 23170},  {0, 32767},  {23170, 23170},   {32767, 0},  {23170, -23170},  {0, -32768},
      {-23170, -23170}, {-32768, 0}, {-23170, 23170},  {0, 32767},  {23170, 23170},   {32767, 0},
      {23170, -23170},  {0, -32768}, {-23170, -23170}, {-32768, 0}, {-23170, 23170},  {0, 32767},
      {23170, 23170},   {32767, 0},  {23170, -23170},  {0, -32768}, {-23170, -23170}, {-32768, 0}}},
    {{{25102, -21063},  {5690, -32270},  {-16384, -28378}, {-30792, -11207}, {-30792, 11207}, {-16384, 28378},
      {5690, 32270},    {25102, 21063},  {32767, 0},       {25102, -21063},  {5690, -32270},  {-16384, -28378},
      {-30792, -11207}, {-30792, 11207}, {-16384, 28378},  {5690, 32270},    {25102, 21063},  {32767, 0},
      {25102, -21063},  {5690, -32270},  {-16384, -28378}, {-30792, -11207}, {-30792, 11207}, {-16384, 28378},
      {5690, 32270},    {25102, 21063},  {32767, 0},       {25102, -21063},  {5690, -32270},  {-16384, -28378},
      {-30792, -11207}, {-30792, 11207}, {-16384, 28378},  {5690, 32270},    {25102, 21063},  {32767, 0},
      {25102, -21063},  {5690, -32270},  {-16384, -28378}, {-30792, -11207}, {-30792, 11207}, {-16384, 28378},
      {5690, 32270},    {25102, 21063},  {32767, 0},       {25102, -21063},  {5690, -32270},  {-16384, -28378},
      {-30792, -11207}, {-30792, 11207}, {-16384, 28378},  {5690, 32270},    {25102, 21063},  {32767, 0},
      {25102, -21063},  {5690, -32270},  {-16384, -28378}, {-30792, -11207}, {-30792, 11207}, {-16384, 28378},
      {5690, 32270},    {25102, 21063},  {32767, 0},       {25102, -21063},  {5690, -32270},  {-16384, -28378},
      {-30792, -11207}, {-30792, 11207}, {-16384, 28378},  {5690, 32270},    {25102, 21063},  {32767, 0},
      {25102, -21063},  {5690, -32270},  {-16384, -28378}, {-30792, -11207}, {-30792, 11207}, {-16384, 28378},
      {5690, 32270},    {25102, 21063},  {32767, 0},       {25102, -21063},  {5690, -32270},  {-16384, -28378},
      {-30792, -11207}, {-30792, 11207}, {-16384, 28378},  {5690, 32270},    {25102, 21063},  {32767, 0},
      {25102, -21063},  {5690, -32270},  {-16384, -28378}, {-30792, -11207}, {-30792, 11207}, {-16384, 28378},
      {5690, 32270},    {25102, 21063},  {32767, 0},       {25102, -21063},  {5690, -32270},  {-16384, -28378},
      {-30792, -11207}, {-30792, 11207}, {-16384, 28378},  {5690, 32270},    {25102, 21063},  {32767, 0},
      {25102, -21063},  {5690, -32270},  {-16384, -28378}, {-30792, -11207}, {-30792, 11207}, {-16384, 28378},
      {5690, 32270},    {25102, 21063},  {32767, 0},       {25102, -21063},  {5690, -32270},  {-16384, -28378},
      {-30792, -11207}, {-30792, 11207}, {-16384, 28378},  {5690, 32270},    {25102, 21063},  {32767, 0},
      {25102, -21063},  {5690, -32270},  {-16384, -28378}, {-30792, -11207}, {-30792, 11207}, {-16384, 28378}}},
    {{{26510, -19261},  {10126, -31164},  {-10126, -31164}, {-26510, -19261}, {-32768, 0},      {-26510, 19261},
      {-10126, 31164},  {10126, 31164},   {26510, 19261},   {32767, 0},       {26510, -19261},  {10126, -31164},
      {-10126, -31164}, {-26510, -19261}, {-32768, 0},      {-26510, 19261},  {-10126, 31164},  {10126, 31164},
      {26510, 19261},   {32767, 0},       {26510, -19261},  {10126, -31164},  {-10126, -31164}, {-26510, -19261},
      {-32768, 0},      {-26510, 19261},  {-10126, 31164},  {10126, 31164},   {26510, 19261},   {32767, 0},
      {26510, -19261},  {10126, -31164},  {-10126, -31164}, {-26510, -19261}, {-32768, 0},      {-26510, 19261},
      {-10126, 31164},  {10126, 31164},   {26510, 19261},   {32767, 0},       {26510, -19261},  {10126, -31164},
      {-10126, -31164}, {-26510, -19261}, {-32768, 0},      {-26510, 19261},  {-10126, 31164},  {10126, 31164},
      {26510, 19261},   {32767, 0},       {26510, -19261},  {10126, -31164},  {-10126, -31164}, {-26510, -19261},
      {-32768, 0},      {-26510, 19261},  {-10126, 31164},  {10126, 31164},   {26510, 19261},   {32767, 0},
      {26510, -19261},  {10126, -31164},  {-10126, -31164}, {-26510, -19261}, {-32768, 0},      {-26510, 19261},
      {-10126, 31164},  {10126, 31164},   {26510, 19261},   {32767, 0},       {26510, -19261},  {10126, -31164},
      {-10126, -31164}, {-26510, -19261}, {-32768, 0},      {-26510, 19261},  {-10126, 31164},  {10126, 31164},
      {26510, 19261},   {32767, 0},       {26510, -19261},  {10126, -31164},  {-10126, -31164}, {-26510, -19261},
      {-32768, 0},      {-26510, 19261},  {-10126, 31164},  {10126, 31164},   {26510, 19261},   {32767, 0},
      {26510, -19261},  {10126, -31164},  {-10126, -31164}, {-26510, -19261}, {-32768, 0},      {-26510, 19261},
      {-10126, 31164},  {10126, 31164},   {26510, 19261},   {32767, 0},       {26510, -19261},  {10126, -31164},
      {-10126, -31164}, {-26510, -19261}, {-32768, 0},      {-26510, 19261},  {-10126, 31164},  {10126, 31164},
      {26510, 19261},   {32767, 0},       {26510, -19261},  {10126, -31164},  {-10126, -31164}, {-26510, -19261},
      {-32768, 0},      {-26510, 19261},  {-10126, 31164},  {10126, 31164},   {26510, 19261},   {32767, 0},
      {26510, -19261},  {10126, -31164},  {-10126, -31164}, {-26510, -19261}, {-32768, 0},      {-26510, 19261},
      {-10126, 31164},  {10126, 31164},   {26510, 19261},   {32767, 0},       {26510, -19261},  {10126, -31164}}},
    {{{28378, -16384}, {16384, -28378}, {0, -32768}, {-16384, -28378}, {-28378, -16384}, {-32768, 0},
      {-28378, 16384}, {-16384, 28378}, {0, 32767},  {16384, 28378},   {28378, 16384},   {32767, 0},
      {28378, -16384}, {16384, -28378}, {0, -32768}, {-16384, -28378}, {-28378, -16384}, {-32768, 0},
      {-28378, 16384}, {-16384, 28378}, {0, 32767},  {16384, 28378},   {28378, 16384},   {32767, 0},
      {28378, -16384}, {16384, -28378}, {0, -32768}, {-16384, -28378}, {-28378, -16384}, {-32768, 0},
      {-28378, 16384}, {-16384, 28378}, {0, 32767},  {16384, 28378},   {28378, 16384},   {32767, 0},
      {28378, -16384}, {16384, -28378}, {0, -32768}, {-16384, -28378}, {-28378, -16384}, {-32768, 0},
      {-28378, 16384}, {-16384, 28378}, {0, 32767},  {16384, 28378},   {28378, 16384},   {32767, 0},
      {28378, -16384}, {16384, -28378}, {0, -32768}, {-16384, -28378}, {-28378, -16384}, {-32768, 0},
      {-28378, 16384}, {-16384, 28378}, {0, 32767},  {16384, 28378},   {28378, 16384},   {32767, 0},
      {28378, -16384}, {16384, -28378}, {0, -32768}, {-16384, -28378}, {-28378, -16384}, {-32768, 0},
      {-28378, 16384}, {-16384, 28378}, {0, 32767},  {16384, 28378},   {28378, 16384},   {32767, 0},
      {28378, -16384}, {16384, -28378}, {0, -32768}, {-16384, -28378}, {-28378, -16384}, {-32768, 0},
      {-28378, 16384}, {-16384, 28378}, {0, 32767},  {16384, 28378},   {28378, 16384},   {32767, 0},
      {28378, -16384}, {16384, -28378}, {0, -32768}, {-16384, -28378}, {-28378, -16384}, {-32768, 0},
      {-28378, 16384}, {-16384, 28378}, {0, 32767},  {16384, 28378},   {28378, 16384},   {32767, 0},
      {28378, -16384}, {16384, -28378}, {0, -32768}, {-16384, -28378}, {-28378, -16384}, {-32768, 0},
      {-28378, 16384}, {-16384, 28378}, {0, 32767},  {16384, 28378},   {28378, 16384},   {32767, 0},
      {28378, -16384}, {16384, -28378}, {0, -32768}, {-16384, -28378}, {-28378, -16384}, {-32768, 0},
      {-28378, 16384}, {-16384, 28378}, {0, 32767},  {16384, 28378},   {28378, 16384},   {32767, 0},
      {28378, -16384}, {16384, -28378}, {0, -32768}, {-16384, -28378}, {-28378, -16384}, {-32768, 0},
      {-28378, 16384}, {-16384, 28378}, {0, 32767},  {16384, 28378},   {28378, 16384},   {32767, 0}}},
    {{{28715, -15786},  {17558, -27667},  {2058, -32703},   {-13952, -29649}, {-26510, -19261}, {-32510, -4107},
      {-30467, 12063},  {-20887, 25248},  {-6140, 32188},   {10126, 31164},   {23887, 22431},   {31739, 8149},
      {31739, -8149},   {23887, -22431},  {10126, -31164},  {-6140, -32188},  {-20887, -25248}, {-30467, -12063},
      {-32510, 4107},   {-26510, 19261},  {-13952, 29649},  {2058, 32703},    {17558, 27667},   {28715, 15786},
      {32767, 0},       {28715, -15786},  {17558, -27667},  {2058, -32703},   {-13952, -29649}, {-26510, -19261},
      {-32510, -4107},  {-30467, 12063},  {-20887, 25248},  {-6140, 32188},   {10126, 31164},   {23887, 22431},
      {31739, 8149},    {31739, -8149},   {23887, -22431},  {10126, -31164},  {-6140, -32188},  {-20887, -25248},
      {-30467, -12063}, {-32510, 4107},   {-26510, 19261},  {-13952, 29649},  {2058, 32703},    {17558, 27667},
      {28715, 15786},   {32767, 0},       {28715, -15786},  {17558, -27667},  {2058, -32703},   {-13952, -29649},
      {-26510, -19261}, {-32510, -4107},  {-30467, 12063},  {-20887, 25248},  {-6140, 32188},   {10126, 31164},
      {23887, 22431},   {31739, 8149},    {31739, -8149},   {23887, -22431},  {10126, -31164},  {-6140, -32188},
      {-20887, -25248}, {-30467, -12063}, {-32510, 4107},   {-26510, 19261},  {-13952, 29649},  {2058, 32703},
      {17558, 27667},   {28715, 15786},   {32767, 0},       {28715, -15786},  {17558, -27667},  {2058, -32703},
      {-13952, -29649}, {-26510, -19261}, {-32510, -4107},  {-30467, 12063},  {-20887, 25248},  {-6140, 32188},
      {10126, 31164},   {23887, 22431},   {31739, 8149},    {31739, -8149},   {23887, -22431},  {10126, -31164},
      {-6140, -32188},  {-20887, -25248}, {-30467, -12063}, {-32510, 4107},   {-26510, 19261},  {-13952, 29649},
      {2058, 32703},    {17558, 27667},   {28715, 15786},   {32767, 0},       {28715, -15786},  {17558, -27667},
      {2058, -32703},   {-13952, -29649}, {-26510, -19261}, {-32510, -4107},  {-30467, 12063},  {-20887, 25248},
      {-6140, 32188},   {10126, 31164},   {23887, 22431},   {31739, 8149},    {31739, -8149},   {23887, -22431},
      {10126, -31164},  {-6140, -32188},  {-20887, -25248}, {-30467, -12063}, {-32510, 4107},   {-26510, 19261},
      {-13952, 29649},  {2058, 32703},    {17558, 27667},   {28715, 15786},   {32767, 0},       {28715, -15786},
      {17558, -27667},  {2058, -32703},   {-13952, -29649}, {-26510, -19261}, {-32510, -4107},  {-30467, 12063}}},
    {{{29283, -14706},  {19568, -26284},  {5690, -32270},   {-9398, -31391},  {-22487, -23835}, {-30792, -11207},
      {-32546, 3804},   {-27377, 18006},  {-16384, 28378},  {-1905, 32713},   {12979, 30088},   {25102, 21063},
      {31885, 7557},    {31885, -7557},   {25102, -21063},  {12979, -30088},  {-1905, -32713},  {-16384, -28378},
      {-27377, -18006}, {-32546, -3804},  {-30792, 11207},  {-22487, 23835},  {-9398, 31391},   {5690, 32270},
      {19568, 26284},   {29283, 14706},   {32767, 0},       {29283, -14706},  {19568, -26284},  {5690, -32270},
      {-9398, -31391},  {-22487, -23835}, {-30792, -11207}, {-32546, 3804},   {-27377, 18006},  {-16384, 28378},
      {-1905, 32713},   {12979, 30088},   {25102, 21063},   {31885, 7557},    {31885, -7557},   {25102, -21063},
      {12979, -30088},  {-1905, -32713},  {-16384, -28378}, {-27377, -18006}, {-32546, -3804},  {-30792, 11207},
      {-22487, 23835},  {-9398, 31391},   {5690, 32270},    {19568, 26284},   {29283, 14706},   {32767, 0},
      {29283, -14706},  {19568, -26284},  {5690, -32270},   {-9398, -31391},  {-22487, -23835}, {-30792, -11207},
      {-32546, 3804},   {-27377, 18006},  {-16384, 28378},  {-1905, 32713},   {12979, 30088},   {25102, 21063},
      {31885, 7557},    {31885, -7557},   {25102, -21063},  {12979, -30088},  {-1905, -32713},  {-16384, -28378},
      {-27377, -18006}, {-32546, -3804},  {-30792, 11207},  {-22487, 23835},  {-9398, 31391},   {5690, 32270},
      {19568, 26284},   {29283, 14706},   {32767, 0},       {29283, -14706},  {19568, -26284},  {5690, -32270},
      {-9398, -31391},  {-22487, -23835}, {-30792, -11207}, {-32546, 3804},   {-27377, 18006},  {-16384, 28378},
      {-1905, 32713},   {12979, 30088},   {25102, 21063},   {31885, 7557},    {31885, -7557},   {25102, -21063},
      {12979, -30088},  {-1905, -32713},  {-16384, -28378}, {-27377, -18006}, {-32546, -3804},  {-30792, 11207},
      {-22487, 23835},  {-9398, 31391},   {5690, 32270},    {19568, 26284},   {29283, 14706},   {32767, 0},
      {29283, -14706},  {19568, -26284},  {5690, -32270},   {-9398, -31391},  {-22487, -23835}, {-30792, -11207},
      {-32546, 3804},   {-27377, 18006},  {-16384, 28378},  {-1905, 32713},   {12979, 30088},   {25102, 21063},
      {31885, 7557},    {31885, -7557},   {25102, -21063},  {12979, -30088},  {-1905, -32713},  {-16384, -28378},
      {-27377, -18006}, {-32546, -3804},  {-30792, 11207},  {-22487, 23835},  {-9398, 31391},   {5690, 32270}}},
    {{{29935, -13328}, {21926, -24351},  {10126, -31164},  {-3425, -32588}, {-16384, -28378}, {-26510, -19261},
      {-32052, -6813}, {-32052, 6813},   {-26510, 19261},  {-16384, 28378}, {-3425, 32588},   {10126, 31164},
      {21926, 24351},  {29935, 13328},   {32767, 0},       {29935, -13328}, {21926, -24351},  {10126, -31164},
      {-3425, -32588}, {-16384, -28378}, {-26510, -19261}, {-32052, -6813}, {-32052, 6813},   {-26510, 19261},
      {-16384, 28378}, {-3425, 32588},   {10126, 31164},   {21926, 24351},  {29935, 13328},   {32767, 0},
      {29935, -13328}, {21926, -24351},  {10126, -31164},  {-3425, -32588}, {-16384, -28378}, {-26510, -19261},
      {-32052, -6813}, {-32052, 6813},   {-26510, 19261},  {-16384, 28378}, {-3425, 32588},   {10126, 31164},
      {21926, 24351},  {29935, 13328},   {32767, 0},       {29935, -13328}, {21926, -24351},  {10126, -31164},
      {-3425, -32588}, {-16384, -28378}, {-26510, -19261}, {-32052, -6813}, {-32052, 6813},   {-26510, 19261},
      {-16384, 28378}, {-3425, 32588},   {10126, 31164},   {21926, 24351},  {29935, 13328},   {32767, 0},
      {29935, -13328}, {21926, -24351},  {10126, -31164},  {-3425, -32588}, {-16384, -28378}, {-26510, -19261},
      {-32052, -6813}, {-32052, 6813},   {-26510, 19261},  {-16384, 28378}, {-3425, 32588},   {10126, 31164},
      {21926, 24351},  {29935, 13328},   {32767, 0},       {29935, -13328}, {21926, -24351},  {10126, -31164},
      {-3425, -32588}, {-16384, -28378}, {-26510, -19261}, {-32052, -6813}, {-32052, 6813},   {-26510, 19261},
      {-16384, 28378}, {-3425, 32588},   {10126, 31164},   {21926, 24351},  {29935, 13328},   {32767, 0},
      {29935, -13328}, {21926, -24351},  {10126, -31164},  {-3425, -32588}, {-16384, -28378}, {-26510, -19261},
      {-32052, -6813}, {-32052, 6813},   {-26510, 19261},  {-16384, 28378}, {-3425, 32588},   {10126, 31164},
      {21926, 24351},  {29935, 13328},   {32767, 0},       {29935, -13328}, {21926, -24351},  {10126, -31164},
      {-3425, -32588}, {-16384, -28378}, {-26510, -19261}, {-32052, -6813}, {-32052, 6813},   {-26510, 19261},
      {-16384, 28378}, {-3425, 32588},   {10126, 31164},   {21926, 24351},  {29935, 13328},   {32767, 0},
      {29935, -13328}, {21926, -24351},  {10126, -31164},  {-3425, -32588}, {-16384, -28378}, {-26510, -19261},
      {-32052, -6813}, {-32052, 6813},   {-26510, 19261},  {-16384, 28378}, {-3425, 32588},   {10126, 31164}}},
    {{{30274, -12540},  {23170, -23170},  {12540, -30274},  {0, -32768},      {-12540, -30274}, {-23170, -23170},
      {-30274, -12540}, {-32768, 0},      {-30274, 12540},  {-23170, 23170},  {-12540, 30274},  {0, 32767},
      {12540, 30274},   {23170, 23170},   {30274, 12540},   {32767, 0},       {30274, -12540},  {23170, -23170},
      {12540, -30274},  {0, -32768},      {-12540, -30274}, {-23170, -23170}, {-30274, -12540}, {-32768, 0},
      {-30274, 12540},  {-23170, 23170},  {-12540, 30274},  {0, 32767},       {12540, 30274},   {23170, 23170},
      {30274, 12540},   {32767, 0},       {30274, -12540},  {23170, -23170},  {12540, -30274},  {0, -32768},
      {-12540, -30274}, {-23170, -23170}, {-30274, -12540}, {-32768, 0},      {-30274, 12540},  {-23170, 23170},
      {-12540, 30274},  {0, 32767},       {12540, 30274},   {23170, 23170},   {30274, 12540},   {32767, 0},
      {30274, -12540},  {23170, -23170},  {12540, -30274},  {0, -32768},      {-12540, -30274}, {-23170, -23170},
      {-30274, -12540}, {-32768, 0},      {-30274, 12540},  {-23170, 23170},  {-12540, 30274},  {0, 32767},
      {12540, 30274},   {23170, 23170},   {30274, 12540},   {32767, 0},       {30274, -12540},  {23170, -23170},
      {12540, -30274},  {0, -32768},      {-12540, -30274}, {-23170, -23170}, {-30274, -12540}, {-32768, 0},
      {-30274, 12540},  {-23170, 23170},  {-12540, 30274},  {0, 32767},       {12540, 30274},   {23170, 23170},
      {30274, 12540},   {32767, 0},       {30274, -12540},  {23170, -23170},  {12540, -30274},  {0, -32768},
      {-12540, -30274}, {-23170, -23170}, {-30274, -12540}, {-32768, 0},      {-30274, 12540},  {-23170, 23170},
      {-12540, 30274},  {0, 32767},       {12540, 30274},   {23170, 23170},   {30274, 12540},   {32767, 0},
      {30274, -12540},  {23170, -23170},  {12540, -30274},  {0, -32768},      {-12540, -30274}, {-23170, -23170},
      {-30274, -12540}, {-32768, 0},      {-30274, 12540},  {-23170, 23170},  {-12540, 30274},  {0, 32767},
      {12540, 30274},   {23170, 23170},   {30274, 12540},   {32767, 0},       {30274, -12540},  {23170, -23170},
      {12540, -30274},  {0, -32768},      {-12540, -30274}, {-23170, -23170}, {-30274, -12540}, {-32768, 0},
      {-30274, 12540},  {-23170, 23170},  {-12540, 30274},  {0, 32767},       {12540, 30274},   {23170, 23170},
      {30274, 12540},   {32767, 0},       {30274, -12540},  {23170, -23170},  {12540, -30274},  {0, -32768}}},
    {{{30792, -11207},  {25102, -21063},  {16384, -28378}, {5690, -32270},  {-5690, -32270}, {-16384, -28378},
      {-25102, -21063}, {-30792, -11207}, {-32768, 0},     {-30792, 11207}, {-25102, 21063}, {-16384, 28378},
      {-5690, 32270},   {5690, 32270},    {16384, 28378},  {25102, 21063},  {30792, 11207},  {32767, 0},
      {30792, -11207},  {25102, -21063},  {16384, -28378}, {5690, -32270},  {-5690, -32270}, {-16384, -28378},
      {-25102, -21063}, {-30792, -11207}, {-32768, 0},     {-30792, 11207}, {-25102, 21063}, {-16384, 28378},
      {-5690, 32270},   {5690, 32270},    {16384, 28378},  {25102, 21063},  {30792, 11207},  {32767, 0},
      {30792, -11207},  {25102, -21063},  {16384, -28378}, {5690, -32270},  {-5690, -32270}, {-16384, -28378},
      {-25102, -21063}, {-30792, -11207}, {-32768, 0},     {-30792, 11207}, {-25102, 21063}, {-16384, 28378},
      {-5690, 32270},   {5690, 32270},    {16384, 28378},  {25102, 21063},  {30792, 11207},  {32767, 0},
      {30792, -11207},  {25102, -21063},  {16384, -28378}, {5690, -32270},  {-5690, -32270}, {-16384, -28378},
      {-25102, -21063}, {-30792, -11207}, {-32768, 0},     {-30792, 11207}, {-25102, 21063}, {-16384, 28378},
      {-5690, 32270},   {5690, 32270},    {16384, 28378},  {25102, 21063},  {30792, 11207},  {32767, 0},
      {30792, -11207},  {25102, -21063},  {16384, -28378}, {5690, -32270},  {-5690, -32270}, {-16384, -28378},
      {-25102, -21063}, {-30792, -11207}, {-32768, 0},     {-30792, 11207}, {-25102, 21063}, {-16384, 28378},
      {-5690, 32270},   {5690, 32270},    {16384, 28378},  {25102, 21063},  {30792, 11207},  {32767, 0},
      {30792, -11207},  {25102, -21063},  {16384, -28378}, {5690, -32270},  {-5690, -32270}, {-16384, -28378},
      {-25102, -21063}, {-30792, -11207}, {-32768, 0},     {-30792, 11207}, {-25102, 21063}, {-16384, 28378},
      {-5690, 32270},   {5690, 32270},    {16384, 28378},  {25102, 21063},  {30792, 11207},  {32767, 0},
      {30792, -11207},  {25102, -21063},  {16384, -28378}, {5690, -32270},  {-5690, -32270}, {-16384, -28378},
      {-25102, -21063}, {-30792, -11207}, {-32768, 0},     {-30792, 11207}, {-25102, 21063}, {-16384, 28378},
      {-5690, 32270},   {5690, 32270},    {16384, 28378},  {25102, 21063},  {30792, 11207},  {32767, 0},
      {30792, -11207},  {25102, -21063},  {16384, -28378}, {5690, -32270},  {-5690, -32270}, {-16384, -28378}}},
    {{{31164, -10126},  {26510, -19261},  {19261, -26510},  {10126, -31164},  {0, -32768},      {-10126, -31164},
      {-19261, -26510}, {-26510, -19261}, {-31164, -10126}, {-32768, 0},      {-31164, 10126},  {-26510, 19261},
      {-19261, 26510},  {-10126, 31164},  {0, 32767},       {10126, 31164},   {19261, 26510},   {26510, 19261},
      {31164, 10126},   {32767, 0},       {31164, -10126},  {26510, -19261},  {19261, -26510},  {10126, -31164},
      {0, -32768},      {-10126, -31164}, {-19261, -26510}, {-26510, -19261}, {-31164, -10126}, {-32768, 0},
      {-31164, 10126},  {-26510, 19261},  {-19261, 26510},  {-10126, 31164},  {0, 32767},       {10126, 31164},
      {19261, 26510},   {26510, 19261},   {31164, 10126},   {32767, 0},       {31164, -10126},  {26510, -19261},
      {19261, -26510},  {10126, -31164},  {0, -32768},      {-10126, -31164}, {-19261, -26510}, {-26510, -19261},
      {-31164, -10126}, {-32768, 0},      {-31164, 10126},  {-26510, 19261},  {-19261, 26510},  {-10126, 31164},
      {0, 32767},       {10126, 31164},   {19261, 26510},   {26510, 19261},   {31164, 10126},   {32767, 0},
      {31164, -10126},  {26510, -19261},  {19261, -26510},  {10126, -31164},  {0, -32768},      {-10126, -31164},
      {-19261, -26510}, {-26510, -19261}, {-31164, -10126}, {-32768, 0},      {-31164, 10126},  {-26510, 19261},
      {-19261, 26510},  {-10126, 31164},  {0, 32767},       {10126, 31164},   {19261, 26510},   {26510, 19261},
      {31164, 10126},   {32767, 0},       {31164, -10126},  {26510, -19261},  {19261, -26510},  {10126, -31164},
      {0, -32768},      {-10126, -31164}, {-19261, -26510}, {-26510, -19261}, {-31164, -10126}, {-32768, 0},
      {-31164, 10126},  {-26510, 19261},  {-19261, 26510},  {-10126, 31164},  {0, 32767},       {10126, 31164},
      {19261, 26510},   {26510, 19261},   {31164, 10126},   {32767, 0},       {31164, -10126},  {26510, -19261},
      {19261, -26510},  {10126, -31164},  {0, -32768},      {-10126, -31164}, {-19261, -26510}, {-26510, -19261},
      {-31164, -10126}, {-32768, 0},      {-31164, 10126},  {-26510, 19261},  {-19261, 26510},  {-10126, 31164},
      {0, 32767},       {10126, 31164},   {19261, 26510},   {26510, 19261},   {31164, 10126},   {32767, 0},
      {31164, -10126},  {26510, -19261},  {19261, -26510},  {10126, -31164},  {0, -32768},      {-10126, -31164},
      {-19261, -26510}, {-26510, -19261}, {-31164, -10126}, {-32768, 0},      {-31164, 10126},  {-26510, 19261}}},
    {{{31499, -9032},   {27789, -17364},  {21926, -24351},  {14365, -29452},  {5690, -32270},   {-3425, -32588},
      {-12275, -30382}, {-20174, -25822}, {-26510, -19261}, {-30792, -11207}, {-32688, -2286},  {-32052, 6813},
      {-28932, 15384},  {-23571, 22763},  {-16384, 28378},  {-7927, 31795},   {1144, 32748},    {10126, 31164},
      {18324, 27166},   {25102, 21063},   {29935, 13328},   {32449, 4560},    {32449, -4560},   {29935, -13328},
      {25102, -21063},  {18324, -27166},  {10126, -31164},  {1144, -32748},   {-7927, -31795},  {-16384, -28378},
      {-23571, -22763}, {-28932, -15384}, {-32052, -6813},  {-32688, 2286},   {-30792, 11207},  {-26510, 19261},
      {-20174, 25822},  {-12275, 30382},  {-3425, 32588},   {5690, 32270},    {14365, 29452},   {21926, 24351},
      {27789, 17364},   {31499, 9032},    {32767, 0},       {31499, -9032},   {27789, -17364},  {21926, -24351},
      {14365, -29452},  {5690, -32270},   {-3425, -32588},  {-12275, -30382}, {-20174, -25822}, {-26510, -19261},
      {-30792, -11207}, {-32688, -2286},  {-32052, 6813},   {-28932, 15384},  {-23571, 22763},  {-16384, 28378},
      {-7927, 31795},   {1144, 32748},    {10126, 31164},   {18324, 27166},   {25102, 21063},   {29935, 13328},
      {32449, 4560},    {32449, -4560},   {29935, -13328},  {25102, -21063},  {18324, -27166},  {10126, -31164},
      {1144, -32748},   {-7927, -31795},  {-16384, -28378}, {-23571, -22763}, {-28932, -15384}, {-32052, -6813},
      {-32688, 2286},   {-30792, 11207},  {-26510, 19261},  {-20174, 25822},  {-12275, 30382},  {-3425, 32588},
      {5690, 32270},    {14365, 29452},   {21926, 24351},   {27789, 17364},   {31499, 9032},    {32767, 0},
      {31499, -9032},   {27789, -17364},  {21926, -24351},  {14365, -29452},  {5690, -32270},   {-3425, -32588},
      {-12275, -30382}, {-20174, -25822}, {-26510, -19261}, {-30792, -11207}, {-32688, -2286},  {-32052, 6813},
      {-28932, 15384},  {-23571, 22763},  {-16384, 28378},  {-7927, 31795},   {1144, 32748},    {10126, 31164},
      {18324, 27166},   {25102, 21063},   {29935, 13328},   {32449, 4560},    {32449, -4560},   {29935, -13328},
      {25102, -21063},  {18324, -27166},  {10126, -31164},  {1144, -32748},   {-7927, -31795},  {-16384, -28378},
      {-23571, -22763}, {-28932, -15384}, {-32052, -6813},  {-32688, 2286},   {-30792, 11207},  {-26510, 19261},
      {-20174, 25822},  {-12275, 30382},  {-3425, 32588},   {5690, 32270},    {14365, 29452},   {21926, 24351}}},
    {{{31651, -8481},  {28378, -16384},  {23170, -23170},  {16384, -28378},  {8481, -31651},  {0, -32768},
      {-8481, -31651}, {-16384, -28378}, {-23170, -23170}, {-28378, -16384}, {-31651, -8481}, {-32768, 0},
      {-31651, 8481},  {-28378, 16384},  {-23170, 23170},  {-16384, 28378},  {-8481, 31651},  {0, 32767},
      {8481, 31651},   {16384, 28378},   {23170, 23170},   {28378, 16384},   {31651, 8481},   {32767, 0},
      {31651, -8481},  {28378, -16384},  {23170, -23170},  {16384, -28378},  {8481, -31651},  {0, -32768},
      {-8481, -31651}, {-16384, -28378}, {-23170, -23170}, {-28378, -16384}, {-31651, -8481}, {-32768, 0},
      {-31651, 8481},  {-28378, 16384},  {-23170, 23170},  {-16384, 28378},  {-8481, 31651},  {0, 32767},
      {8481, 31651},   {16384, 28378},   {23170, 23170},   {28378, 16384},   {31651, 8481},   {32767, 0},
      {31651, -8481},  {28378, -16384},  {23170, -23170},  {16384, -28378},  {8481, -31651},  {0, -32768},
      {-8481, -31651}, {-16384, -28378}, {-23170, -23170}, {-28378, -16384}, {-31651, -8481}, {-32768, 0},
      {-31651, 8481},  {-28378, 16384},  {-23170, 23170},  {-16384, 28378},  {-8481, 31651},  {0, 32767},
      {8481, 31651},   {16384, 28378},   {23170, 23170},   {28378, 16384},   {31651, 8481},   {32767, 0},
      {31651, -8481},  {28378, -16384},  {23170, -23170},  {16384, -28378},  {8481, -31651},  {0, -32768},
      {-8481, -31651}, {-16384, -28378}, {-23170, -23170}, {-28378, -16384}, {-31651, -8481}, {-32768, 0},
      {-31651, 8481},  {-28378, 16384},  {-23170, 23170},  {-16384, 28378},  {-8481, 31651},  {0, 32767},
      {8481, 31651},   {16384, 28378},   {23170, 23170},   {28378, 16384},   {31651, 8481},   {32767, 0},
      {31651, -8481},  {28378, -16384},  {23170, -23170},  {16384, -28378},  {8481, -31651},  {0, -32768},
      {-8481, -31651}, {-16384, -28378}, {-23170, -23170}, {-28378, -16384}, {-31651, -8481}, {-32768, 0},
      {-31651, 8481},  {-28378, 16384},  {-23170, 23170},  {-16384, 28378},  {-8481, 31651},  {0, 32767},
      {8481, 31651},   {16384, 28378},   {23170, 23170},   {28378, 16384},   {31651, 8481},   {32767, 0},
      {31651, -8481},  {28378, -16384},  {23170, -23170},  {16384, -28378},  {8481, -31651},  {0, -32768},
      {-8481, -31651}, {-16384, -28378}, {-23170, -23170}, {-28378, -16384}, {-31651, -8481}, {-32768, 0}}},
    {{{31739, -8149},   {28715, -15786},  {23887, -22431},  {17558, -27667},  {10126, -31164},  {2058, -32703},
      {-6140, -32188},  {-13952, -29649}, {-20887, -25248}, {-26510, -19261}, {-30467, -12063}, {-32510, -4107},
      {-32510, 4107},   {-30467, 12063},  {-26510, 19261},  {-20887, 25248},  {-13952, 29649},  {-6140, 32188},
      {2058, 32703},    {10126, 31164},   {17558, 27667},   {23887, 22431},   {28715, 15786},   {31739, 8149},
      {32767, 0},       {31739, -8149},   {28715, -15786},  {23887, -22431},  {17558, -27667},  {10126, -31164},
      {2058, -32703},   {-6140, -32188},  {-13952, -29649}, {-20887, -25248}, {-26510, -19261}, {-30467, -12063},
      {-32510, -4107},  {-32510, 4107},   {-30467, 12063},  {-26510, 19261},  {-20887, 25248},  {-13952, 29649},
      {-6140, 32188},   {2058, 32703},    {10126, 31164},   {17558, 27667},   {23887, 22431},   {28715, 15786},
      {31739, 8149},    {32767, 0},       {31739, -8149},   {28715, -15786},  {23887, -22431},  {17558, -27667},
      {10126, -31164},  {2058, -32703},   {-6140, -32188},  {-13952, -29649}, {-20887, -25248}, {-26510, -19261},
      {-30467, -12063}, {-32510, -4107},  {-32510, 4107},   {-30467, 12063},  {-26510, 19261},  {-20887, 25248},
      {-13952, 29649},  {-6140, 32188},   {2058, 32703},    {10126, 31164},   {17558, 27667},   {23887, 22431},
      {28715, 15786},   {31739, 8149},    {32767, 0},       {31739, -8149},   {28715, -15786},  {23887, -22431},
      {17558, -27667},  {10126, -31164},  {2058, -32703},   {-6140, -32188},  {-13952, -29649}, {-20887, -25248},
      {-26510, -19261}, {-30467, -12063}, {-32510, -4107},  {-32510, 4107},   {-30467, 12063},  {-26510, 19261},
      {-20887, 25248},  {-13952, 29649},  {-6140, 32188},   {2058, 32703},    {10126, 31164},   {17558, 27667},
      {23887, 22431},   {28715, 15786},   {31739, 8149},    {32767, 0},       {31739, -8149},   {28715, -15786},
      {23887, -22431},  {17558, -27667},  {10126, -31164},  {2058, -32703},   {-6140, -32188},  {-13952, -29649},
      {-20887, -25248}, {-26510, -19261}, {-30467, -12063}, {-32510, -4107},  {-32510, 4107},   {-30467, 12063},
      {-26510, 19261},  {-20887, 25248},  {-13952, 29649},  {-6140, 32188},   {2058, 32703},    {10126, 31164},
      {17558, 27667},   {23887, 22431},   {28715, 15786},   {31739, 8149},    {32767, 0},       {31739, -8149},
      {28715, -15786},  {23887, -22431},  {17558, -27667},  {10126, -31164},  {2058, -32703},   {-6140, -32188}}},
    {{{31885, -7557},   {29283, -14706},  {25102, -21063},  {19568, -26284},  {12979, -30088},  {5690, -32270},
      {-1905, -32713},  {-9398, -31391},  {-16384, -28378}, {-22487, -23835}, {-27377, -18006}, {-30792, -11207},
      {-32546, -3804},  {-32546, 3804},   {-30792, 11207},  {-27377, 18006},  {-22487, 23835},  {-16384, 28378},
      {-9398, 31391},   {-1905, 32713},   {5690, 32270},    {12979, 30088},   {19568, 26284},   {25102, 21063},
      {29283, 14706},   {31885, 7557},    {32767, 0},       {31885, -7557},   {29283, -14706},  {25102, -21063},
      {19568, -26284},  {12979, -30088},  {5690, -32270},   {-1905, -32713},  {-9398, -31391},  {-16384, -28378},
      {-22487, -23835}, {-27377, -18006}, {-30792, -11207}, {-32546, -3804},  {-32546, 3804},   {-30792, 11207},
      {-27377, 18006},  {-22487, 23835},  {-16384, 28378},  {-9398, 31391},   {-1905, 32713},   {5690, 32270},
      {12979, 30088},   {19568, 26284},   {25102, 21063},   {29283, 14706},   {31885, 7557},    {32767, 0},
      {31885, -7557},   {29283, -14706},  {25102, -21063},  {19568, -26284},  {12979, -30088},  {5690, -32270},
      {-1905, -32713},  {-9398, -31391},  {-16384, -28378}, {-22487, -23835}, {-27377, -18006}, {-30792, -11207},
      {-32546, -3804},  {-32546, 3804},   {-30792, 11207},  {-27377, 18006},  {-22487, 23835},  {-16384, 28378},
      {-9398, 31391},   {-1905, 32713},   {5690, 32270},    {12979, 30088},   {19568, 26284},   {25102, 21063},
      {29283, 14706},   {31885, 7557},    {32767, 0},       {31885, -7557},   {29283, -14706},  {25102, -21063},
      {19568, -26284},  {12979, -30088},  {5690, -32270},   {-1905, -32713},  {-9398, -31391},  {-16384, -28378},
      {-22487, -23835}, {-27377, -18006}, {-30792, -11207}, {-32546, -3804},  {-32546, 3804},   {-30792, 11207},
      {-27377, 18006},  {-22487, 23835},  {-16384, 28378},  {-9398, 31391},   {-1905, 32713},   {5690, 32270},
      {12979, 30088},   {19568, 26284},   {25102, 21063},   {29283, 14706},   {31885, 7557},    {32767, 0},
      {31885, -7557},   {29283, -14706},  {25102, -21063},  {19568, -26284},  {12979, -30088},  {5690, -32270},
      {-1905, -32713},  {-9398, -31391},  {-16384, -28378}, {-22487, -23835}, {-27377, -18006}, {-30792, -11207},
      {-32546, -3804},  {-32546, 3804},   {-30792, 11207},  {-27377, 18006},  {-22487, 23835},  {-16384, 28378},
      {-9398, 31391},   {-1905, 32713},   {5690, 32270},    {12979, 30088},   {19568, 26284},   {25102, 21063}}},
    {{{32052, -6813},   {29935, -13328}, {26510, -19261},  {21926, -24351},  {16384, -28378},  {10126, -31164},
      {3425, -32588},   {-3425, -32588}, {-10126, -31164}, {-16384, -28378}, {-21926, -24351}, {-26510, -19261},
      {-29935, -13328}, {-32052, -6813}, {-32768, 0},      {-32052, 6813},   {-29935, 13328},  {-26510, 19261},
      {-21926, 24351},  {-16384, 28378}, {-10126, 31164},  {-3425, 32588},   {3425, 32588},    {10126, 31164},
      {16384, 28378},   {21926, 24351},  {26510, 19261},   {29935, 13328},   {32052, 6813},    {32767, 0},
      {32052, -6813},   {29935, -13328}, {26510, -19261},  {21926, -24351},  {16384, -28378},  {10126, -31164},
      {3425, -32588},   {-3425, -32588}, {-10126, -31164}, {-16384, -28378}, {-21926, -24351}, {-26510, -19261},
      {-29935, -13328}, {-32052, -6813}, {-32768, 0},      {-32052, 6813},   {-29935, 13328},  {-26510, 19261},
      {-21926, 24351},  {-16384, 28378}, {-10126, 31164},  {-3425, 32588},   {3425, 32588},    {10126, 31164},
      {16384, 28378},   {21926, 24351},  {26510, 19261},   {29935, 13328},   {32052, 6813},    {32767, 0},
      {32052, -6813},   {29935, -13328}, {26510, -19261},  {21926, -24351},  {16384, -28378},  {10126, -31164},
      {3425, -32588},   {-3425, -32588}, {-10126, -31164}, {-16384, -28378}, {-21926, -24351}, {-26510, -19261},
      {-29935, -13328}, {-32052, -6813}, {-32768, 0},      {-32052, 6813},   {-29935, 13328},  {-26510, 19261},
      {-21926, 24351},  {-16384, 28378}, {-10126, 31164},  {-3425, 32588},   {3425, 32588},    {10126, 31164},
      {16384, 28378},   {21926, 24351},  {26510, 19261},   {29935, 13328},   {32052, 6813},    {32767, 0},
      {32052, -6813},   {29935, -13328}, {26510, -19261},  {21926, -24351},  {16384, -28378},  {10126, -31164},
      {3425, -32588},   {-3425, -32588}, {-10126, -31164}, {-16384, -28378}, {-21926, -24351}, {-26510, -19261},
      {-29935, -13328}, {-32052, -6813}, {-32768, 0},      {-32052, 6813},   {-29935, 13328},  {-26510, 19261},
      {-21926, 24351},  {-16384, 28378}, {-10126, 31164},  {-3425, 32588},   {3425, 32588},    {10126, 31164},
      {16384, 28378},   {21926, 24351},  {26510, 19261},   {29935, 13328},   {32052, 6813},    {32767, 0},
      {32052, -6813},   {29935, -13328}, {26510, -19261},  {21926, -24351},  {16384, -28378},  {10126, -31164},
      {3425, -32588},   {-3425, -32588}, {-10126, -31164}, {-16384, -28378}, {-21926, -24351}, {-26510, -19261}}},
    {{{32138, -6393},   {30274, -12540},  {27246, -18205},  {23170, -23170},  {18205, -27246},  {12540, -30274},
      {6393, -32138},   {0, -32768},      {-6393, -32138},  {-12540, -30274}, {-18205, -27246}, {-23170, -23170},
      {-27246, -18205}, {-30274, -12540}, {-32138, -6393},  {-32768, 0},      {-32138, 6393},   {-30274, 12540},
      {-27246, 18205},  {-23170, 23170},  {-18205, 27246},  {-12540, 30274},  {-6393, 32138},   {0, 32767},
      {6393, 32138},    {12540, 30274},   {18205, 27246},   {23170, 23170},   {27246, 18205},   {30274, 12540},
      {32138, 6393},    {32767, 0},       {32138, -6393},   {30274, -12540},  {27246, -18205},  {23170, -23170},
      {18205, -27246},  {12540, -30274},  {6393, -32138},   {0, -32768},      {-6393, -32138},  {-12540, -30274},
      {-18205, -27246}, {-23170, -23170}, {-27246, -18205}, {-30274, -12540}, {-32138, -6393},  {-32768, 0},
      {-32138, 6393},   {-30274, 12540},  {-27246, 18205},  {-23170, 23170},  {-18205, 27246},  {-12540, 30274},
      {-6393, 32138},   {0, 32767},       {6393, 32138},    {12540, 30274},   {18205, 27246},   {23170, 23170},
      {27246, 18205},   {30274, 12540},   {32138, 6393},    {32767, 0},       {32138, -6393},   {30274, -12540},
      {27246, -18205},  {23170, -23170},  {18205, -27246},  {12540, -30274},  {6393, -32138},   {0, -32768},
      {-6393, -32138},  {-12540, -30274}, {-18205, -27246}, {-23170, -23170}, {-27246, -18205}, {-30274, -12540},
      {-32138, -6393},  {-32768, 0},      {-32138, 6393},   {-30274, 12540},  {-27246, 18205},  {-23170, 23170},
      {-18205, 27246},  {-12540, 30274},  {-6393, 32138},   {0, 32767},       {6393, 32138},    {12540, 30274},
      {18205, 27246},   {23170, 23170},   {27246, 18205},   {30274, 12540},   {32138, 6393},    {32767, 0},
      {32138, -6393},   {30274, -12540},  {27246, -18205},  {23170, -23170},  {18205, -27246},  {12540, -30274},
      {6393, -32138},   {0, -32768},      {-6393, -32138},  {-12540, -30274}, {-18205, -27246}, {-23170, -23170},
      {-27246, -18205}, {-30274, -12540}, {-32138, -6393},  {-32768, 0},      {-32138, 6393},   {-30274, 12540},
      {-27246, 18205},  {-23170, 23170},  {-18205, 27246},  {-12540, 30274},  {-6393, 32138},   {0, 32767},
      {6393, 32138},    {12540, 30274},   {18205, 27246},   {23170, 23170},   {27246, 18205},   {30274, 12540},
      {32138, 6393},    {32767, 0},       {32138, -6393},   {30274, -12540},  {27246, -18205},  {23170, -23170}}},
    {{{32270, -5690},   {30792, -11207},  {28378, -16384},  {25102, -21063},  {21063, -25102},  {16384, -28378},
      {11207, -30792},  {5690, -32270},   {0, -32768},      {-5690, -32270},  {-11207, -30792}, {-16384, -28378},
      {-21063, -25102}, {-25102, -21063}, {-28378, -16384}, {-30792, -11207}, {-32270, -5690},  {-32768, 0},
      {-32270, 5690},   {-30792, 11207},  {-28378, 16384},  {-25102, 21063},  {-21063, 25102},  {-16384, 28378},
      {-11207, 30792},  {-5690, 32270},   {0, 32767},       {5690, 32270},    {11207, 30792},   {16384, 28378},
      {21063, 25102},   {25102, 21063},   {28378, 16384},   {30792, 11207},   {32270, 5690},    {32767, 0},
      {32270, -5690},   {30792, -11207},  {28378, -16384},  {25102, -21063},  {21063, -25102},  {16384, -28378},
      {11207, -30792},  {5690, -32270},   {0, -32768},      {-5690, -32270},  {-11207, -30792}, {-16384, -28378},
      {-21063, -25102}, {-25102, -21063}, {-28378, -16384}, {-30792, -11207}, {-32270, -5690},  {-32768, 0},
      {-32270, 5690},   {-30792, 11207},  {-28378, 16384},  {-25102, 21063},  {-21063, 25102},  {-16384, 28378},
      {-11207, 30792},  {-5690, 32270},   {0, 32767},       {5690, 32270},    {11207, 30792},   {16384, 28378},
      {21063, 25102},   {25102, 21063},   {28378, 16384},   {30792, 11207},   {32270, 5690},    {32767, 0},
      {32270, -5690},   {30792, -11207},  {28378, -16384},  {25102, -21063},  {21063, -25102},  {16384, -28378},
      {11207, -30792},  {5690, -32270},   {0, -32768},      {-5690, -32270},  {-11207, -30792}, {-16384, -28378},
      {-21063, -25102}, {-25102, -21063}, {-28378, -16384}, {-30792, -11207}, {-32270, -5690},  {-32768, 0},
      {-32270, 5690},   {-30792, 11207},  {-28378, 16384},  {-25102, 21063},  {-21063, 25102},  {-16384, 28378},
      {-11207, 30792},  {-5690, 32270},   {0, 32767},       {5690, 32270},    {11207, 30792},   {16384, 28378},
      {21063, 25102},   {25102, 21063},   {28378, 16384},   {30792, 11207},   {32270, 5690},    {32767, 0},
      {32270, -5690},   {30792, -11207},  {28378, -16384},  {25102, -21063},  {21063, -25102},  {16384, -28378},
      {11207, -30792},  {5690, -32270},   {0, -32768},      {-5690, -32270},  {-11207, -30792}, {-16384, -28378},
      {-21063, -25102}, {-25102, -21063}, {-28378, -16384}, {-30792, -11207}, {-32270, -5690},  {-32768, 0},
      {-32270, 5690},   {-30792, 11207},  {-28378, 16384},  {-25102, 21063},  {-21063, 25102},  {-16384, 28378}}},
    {{{32309, -5465},   {30945, -10776},  {28715, -15786},  {25680, -20354},  {21926, -24351},  {17558, -27667},
      {12698, -30208},  {7483, -31902},   {2058, -32703},   {-3425, -32588},  {-8812, -31561},  {-13952, -29649},
      {-18701, -26907}, {-22927, -23412}, {-26510, -19261}, {-29351, -14570}, {-31369, -9471},  {-32510, -4107},
      {-32739, 1372},   {-32052, 6813},   {-30467, 12063},  {-28029, 16975},  {-24805, 21411},  {-20887, 25248},
      {-16384, 28378},  {-11422, 30713},  {-6140, 32188},   {-686, 32761},    {4787, 32416},    {10126, 31164},
      {15181, 29039},   {19812, 26101},   {23887, 22431},   {27293, 18134},   {29935, 13328},   {31739, 8149},
      {32653, 2742},    {32653, -2742},   {31739, -8149},   {29935, -13328},  {27293, -18134},  {23887, -22431},
      {19812, -26101},  {15181, -29039},  {10126, -31164},  {4787, -32416},   {-686, -32761},   {-6140, -32188},
      {-11422, -30713}, {-16384, -28378}, {-20887, -25248}, {-24805, -21411}, {-28029, -16975}, {-30467, -12063},
      {-32052, -6813},  {-32739, -1372},  {-32510, 4107},   {-31369, 9471},   {-29351, 14570},  {-26510, 19261},
      {-22927, 23412},  {-18701, 26907},  {-13952, 29649},  {-8812, 31561},   {-3425, 32588},   {2058, 32703},
      {7483, 31902},    {12698, 30208},   {17558, 27667},   {21926, 24351},   {25680, 20354},   {28715, 15786},
      {30945, 10776},   {32309, 5465},    {32767, 0},       {32309, -5465},   {30945, -10776},  {28715, -15786},
      {25680, -20354},  {21926, -24351},  {17558, -27667},  {12698, -30208},  {7483, -31902},   {2058, -32703},
      {-3425, -32588},  {-8812, -31561},  {-13952, -29649}, {-18701, -26907}, {-22927, -23412}, {-26510, -19261},
      {-29351, -14570}, {-31369, -9471},  {-32510, -4107},  {-32739, 1372},   {-32052, 6813},   {-30467, 12063},
      {-28029, 16975},  {-24805, 21411},  {-20887, 25248},  {-16384, 28378},  {-11422, 30713},  {-6140, 32188},
      {-686, 32761},    {4787, 32416},    {10126, 31164},   {15181, 29039},   {19812, 26101},   {23887, 22431},
      {27293, 18134},   {29935, 13328},   {31739, 8149},    {32653, 2742},    {32653, -2742},   {31739, -8149},
      {29935, -13328},  {27293, -18134},  {23887, -22431},  {19812, -26101},  {15181, -29039},  {10126, -31164},
      {4787, -32416},   {-686, -32761},   {-6140, -32188},  {-11422, -30713}, {-16384, -28378}, {-20887, -25248},
      {-24805, -21411}, {-28029, -16975}, {-30467, -12063}, {-32052, -6813},  {-32739, -1372},  {-32510, 4107}}},
    {{{32365, -5126},   {31164, -10126},  {29197, -14876},  {26510, -19261},  {23170, -23170},  {19261, -26510},
      {14876, -29197},  {10126, -31164},  {5126, -32365},   {0, -32768},      {-5126, -32365},  {-10126, -31164},
      {-14876, -29197}, {-19261, -26510}, {-23170, -23170}, {-26510, -19261}, {-29197, -14876}, {-31164, -10126},
      {-32365, -5126},  {-32768, 0},      {-32365, 5126},   {-31164, 10126},  {-29197, 14876},  {-26510, 19261},
      {-23170, 23170},  {-19261, 26510},  {-14876, 29197},  {-10126, 31164},  {-5126, 32365},   {0, 32767},
      {5126, 32365},    {10126, 31164},   {14876, 29197},   {19261, 26510},   {23170, 23170},   {26510, 19261},
      {29197, 14876},   {31164, 10126},   {32365, 5126},    {32767, 0},       {32365, -5126},   {31164, -10126},
      {29197, -14876},  {26510, -19261},  {23170, -23170},  {19261, -26510},  {14876, -29197},  {10126, -31164},
      {5126, -32365},   {0, -32768},      {-5126, -32365},  {-10126, -31164}, {-14876, -29197}, {-19261, -26510},
      {-23170, -23170}, {-26510, -19261}, {-29197, -14876}, {-31164, -10126}, {-32365, -5126},  {-32768, 0},
      {-32365, 5126},   {-31164, 10126},  {-29197, 14876},  {-26510, 19261},  {-23170, 23170},  {-19261, 26510},
      {-14876, 29197},  {-10126, 31164},  {-5126, 32365},   {0, 32767},       {5126, 32365},    {10126, 31164},
      {14876, 29197},   {19261, 26510},   {23170, 23170},   {26510, 19261},   {29197, 14876},   {31164, 10126},
      {32365, 5126},    {32767, 0},       {32365, -5126},   {31164, -10126},  {29197, -14876},  {26510, -19261},
      {23170, -23170},  {19261, -26510},  {14876, -29197},  {10126, -31164},  {5126, -32365},   {0, -32768},
      {-5126, -32365},  {-10126, -31164}, {-14876, -29197}, {-19261, -26510}, {-23170, -23170}, {-26510, -19261},
      {-29197, -14876}, {-31164, -10126}, {-32365, -5126},  {-32768, 0},      {-32365, 5126},   {-31164, 10126},
      {-29197, 14876},  {-26510, 19261},  {-23170, 23170},  {-19261, 26510},  {-14876, 29197},  {-10126, 31164},
      {-5126, 32365},   {0, 32767},       {5126, 32365},    {10126, 31164},   {14876, 29197},   {19261, 26510},
      {23170, 23170},   {26510, 19261},   {29197, 14876},   {31164, 10126},   {32365, 5126},    {32767, 0},
      {32365, -5126},   {31164, -10126},  {29197, -14876},  {26510, -19261},  {23170, -23170},  {19261, -26510},
      {14876, -29197},  {10126, -31164},  {5126, -32365},   {0, -32768},      {-5126, -32365},  {-10126, -31164}}},
    {{{32374, -5063},   {31203, -10005},  {29283, -14706},  {26658, -19054},  {23394, -22945},  {19568, -26284},
      {15271, -28992},  {10608, -31003},  {5690, -32270},   {635, -32762},    {-4435, -32467},  {-9398, -31391},
      {-14136, -29562}, {-18534, -27023}, {-22487, -23835}, {-25900, -20074}, {-28690, -15831}, {-30792, -11207},
      {-32154, -6315},  {-32743, -1271},  {-32546, 3804},   {-31568, 8787},   {-29831, 13560},  {-27377, 18006},
      {-24266, 22020},  {-20572, 25505},  {-16384, 28378},  {-11802, 30569},  {-6937, 32025},   {-1905, 32713},
      {3172, 32614},    {8174, 31732},    {12979, 30088},   {17472, 27721},   {21546, 24689},   {25102, 21063},
      {28055, 16931},   {30334, 12393},   {31885, 7557},    {32669, 2539},    {32669, -2539},   {31885, -7557},
      {30334, -12393},  {28055, -16931},  {25102, -21063},  {21546, -24689},  {17472, -27721},  {12979, -30088},
      {8174, -31732},   {3172, -32614},   {-1905, -32713},  {-6937, -32025},  {-11802, -30569}, {-16384, -28378},
      {-20572, -25505}, {-24266, -22020}, {-27377, -18006}, {-29831, -13560}, {-31568, -8787},  {-32546, -3804},
      {-32743, 1271},   {-32154, 6315},   {-30792, 11207},  {-28690, 15831},  {-25900, 20074},  {-22487, 23835},
      {-18534, 27023},  {-14136, 29562},  {-9398, 31391},   {-4435, 32467},   {635, 32762},     {5690, 32270},
      {10608, 31003},   {15271, 28992},   {19568, 26284},   {23394, 22945},   {26658, 19054},   {29283, 14706},
      {31203, 10005},   {32374, 5063},    {32767, 0},       {32374, -5063},   {31203, -10005},  {29283, -14706},
      {26658, -19054},  {23394, -22945},  {19568, -26284},  {15271, -28992},  {10608, -31003},  {5690, -32270},
      {635, -32762},    {-4435, -32467},  {-9398, -31391},  {-14136, -29562}, {-18534, -27023}, {-22487, -23835},
      {-25900, -20074}, {-28690, -15831}, {-30792, -11207}, {-32154, -6315},  {-32743, -1271},  {-32546, 3804},
      {-31568, 8787},   {-29831, 13560},  {-27377, 18006},  {-24266, 22020},  {-20572, 25505},  {-16384, 28378},
      {-11802, 30569},  {-6937, 32025},   {-1905, 32713},   {3172, 32614},    {8174, 31732},    {12979, 30088},
      {17472, 27721},   {21546, 24689},   {25102, 21063},   {28055, 16931},   {30334, 12393},   {31885, 7557},
      {32669, 2539},    {32669, -2539},   {31885, -7557},   {30334, -12393},  {28055, -16931},  {25102, -21063},
      {21546, -24689},  {17472, -27721},  {12979, -30088},  {8174, -31732},   {3172, -32614},   {-1905, -32713}}},
    {{{32449, -4560},   {31499, -9032},   {29935, -13328},  {27789, -17364},  {25102, -21063},  {21926, -24351},
      {18324, -27166},  {14365, -29452},  {10126, -31164},  {5690, -32270},   {1144, -32748},   {-3425, -32588},
      {-7927, -31795},  {-12275, -30382}, {-16384, -28378}, {-20174, -25822}, {-23571, -22763}, {-26510, -19261},
      {-28932, -15384}, {-30792, -11207}, {-32052, -6813},  {-32688, -2286},  {-32688, 2286},   {-32052, 6813},
      {-30792, 11207},  {-28932, 15384},  {-26510, 19261},  {-23571, 22763},  {-20174, 25822},  {-16384, 28378},
      {-12275, 30382},  {-7927, 31795},   {-3425, 32588},   {1144, 32748},    {5690, 32270},    {10126, 31164},
      {14365, 29452},   {18324, 27166},   {21926, 24351},   {25102, 21063},   {27789, 17364},   {29935, 13328},
      {31499, 9032},    {32449, 4560},    {32767, 0},       {32449, -4560},   {31499, -9032},   {29935, -13328},
      {27789, -17364},  {25102, -21063},  {21926, -24351},  {18324, -27166},  {14365, -29452},  {10126, -31164},
      {5690, -32270},   {1144, -32748},   {-3425, -32588},  {-7927, -31795},  {-12275, -30382}, {-16384, -28378},
      {-20174, -25822}, {-23571, -22763}, {-26510, -19261}, {-28932, -15384}, {-30792, -11207}, {-32052, -6813},
      {-32688, -2286},  {-32688, 2286},   {-32052, 6813},   {-30792, 11207},  {-28932, 15384},  {-26510, 19261},
      {-23571, 22763},  {-20174, 25822},  {-16384, 28378},  {-12275, 30382},  {-7927, 31795},   {-3425, 32588},
      {1144, 32748},    {5690, 32270},    {10126, 31164},   {14365, 29452},   {18324, 27166},   {21926, 24351},
      {25102, 21063},   {27789, 17364},   {29935, 13328},   {31499, 9032},    {32449, 4560},    {32767, 0},
      {32449, -4560},   {31499, -9032},   {29935, -13328},  {27789, -17364},  {25102, -21063},  {21926, -24351},
      {18324, -27166},  {14365, -29452},  {10126, -31164},  {5690, -32270},   {1144, -32748},   {-3425, -32588},
      {-7927, -31795},  {-12275, -30382}, {-16384, -28378}, {-20174, -25822}, {-23571, -22763}, {-26510, -19261},
      {-28932, -15384}, {-30792, -11207}, {-32052, -6813},  {-32688, -2286},  {-32688, 2286},   {-32052, 6813},
      {-30792, 11207},  {-28932, 15384},  {-26510, 19261},  {-23571, 22763},  {-20174, 25822},  {-16384, 28378},
      {-12275, 30382},  {-7927, 31795},   {-3425, 32588},   {1144, 32748},    {5690, 32270},    {10126, 31164},
      {14365, 29452},   {18324, 27166},   {21926, 24351},   {25102, 21063},   {27789, 17364},   {29935, 13328}}},
    {{{32488, -4277},   {31651, -8481},   {30274, -12540},  {28378, -16384},  {25997, -19948},  {23170, -23170},
      {19948, -25997},  {16384, -28378},  {12540, -30274},  {8481, -31651},   {4277, -32488},   {0, -32768},
      {-4277, -32488},  {-8481, -31651},  {-12540, -30274}, {-16384, -28378}, {-19948, -25997}, {-23170, -23170},
      {-25997, -19948}, {-28378, -16384}, {-30274, -12540}, {-31651, -8481},  {-32488, -4277},  {-32768, 0},
      {-32488, 4277},   {-31651, 8481},   {-30274, 12540},  {-28378, 16384},  {-25997, 19948},  {-23170, 23170},
      {-19948, 25997},  {-16384, 28378},  {-12540, 30274},  {-8481, 31651},   {-4277, 32488},   {0, 32767},
      {4277, 32488},    {8481, 31651},    {12540, 30274},   {16384, 28378},   {19948, 25997},   {23170, 23170},
      {25997, 19948},   {28378, 16384},   {30274, 12540},   {31651, 8481},    {32488, 4277},    {32767, 0},
      {32488, -4277},   {31651, -8481},   {30274, -12540},  {28378, -16384},  {25997, -19948},  {23170, -23170},
      {19948, -25997},  {16384, -28378},  {12540, -30274},  {8481, -31651},   {4277, -32488},   {0, -32768},
      {-4277, -32488},  {-8481, -31651},  {-12540, -30274}, {-16384, -28378}, {-19948, -25997}, {-23170, -23170},
      {-25997, -19948}, {-28378, -16384}, {-30274, -12540}, {-31651, -8481},  {-32488, -4277},  {-32768, 0},
      {-32488, 4277},   {-31651, 8481},   {-30274, 12540},  {-28378, 16384},  {-25997, 19948},  {-23170, 23170},
      {-19948, 25997},  {-16384, 28378},  {-12540, 30274},  {-8481, 31651},   {-4277, 32488},   {0, 32767},
      {4277, 32488},    {8481, 31651},    {12540, 30274},   {16384, 28378},   {19948, 25997},   {23170, 23170},
      {25997, 19948},   {28378, 16384},   {30274, 12540},   {31651, 8481},    {32488, 4277},    {32767, 0},
      {32488, -4277},   {31651, -8481},   {30274, -12540},  {28378, -16384},  {25997, -19948},  {23170, -23170},
      {19948, -25997},  {16384, -28378},  {12540, -30274},  {8481, -31651},   {4277, -32488},   {0, -32768},
      {-4277, -32488},  {-8481, -31651},  {-12540, -30274}, {-16384, -28378}, {-19948, -25997}, {-23170, -23170},
      {-25997, -19948}, {-28378, -16384}, {-30274, -12540}, {-31651, -8481},  {-32488, -4277},  {-32768, 0},
      {-32488, 4277},   {-31651, 8481},   {-30274, 12540},  {-28378, 16384},  {-25997, 19948},  {-23170, 23170},
      {-19948, 25997},  {-16384, 28378},  {-12540, 30274},  {-8481, 31651},   {-4277, 32488},   {0, 32767}}},
    {{{32510, -4107},   {31739, -8149},   {30467, -12063},  {28715, -15786},  {26510, -19261},  {23887, -22431},
      {20887, -25248},  {17558, -27667},  {13952, -29649},  {10126, -31164},  {6140, -32188},   {2058, -32703},
      {-2058, -32703},  {-6140, -32188},  {-10126, -31164}, {-13952, -29649}, {-17558, -27667}, {-20887, -25248},
      {-23887, -22431}, {-26510, -19261}, {-28715, -15786}, {-30467, -12063}, {-31739, -8149},  {-32510, -4107},
      {-32768, 0},      {-32510, 4107},   {-31739, 8149},   {-30467, 12063},  {-28715, 15786},  {-26510, 19261},
      {-23887, 22431},  {-20887, 25248},  {-17558, 27667},  {-13952, 29649},  {-10126, 31164},  {-6140, 32188},
      {-2058, 32703},   {2058, 32703},    {6140, 32188},    {10126, 31164},   {13952, 29649},   {17558, 27667},
      {20887, 25248},   {23887, 22431},   {26510, 19261},   {28715, 15786},   {30467, 12063},   {31739, 8149},
      {32510, 4107},    {32767, 0},       {32510, -4107},   {31739, -8149},   {30467, -12063},  {28715, -15786},
      {26510, -19261},  {23887, -22431},  {20887, -25248},  {17558, -27667},  {13952, -29649},  {10126, -31164},
      {6140, -32188},   {2058, -32703},   {-2058, -32703},  {-6140, -32188},  {-10126, -31164}, {-13952, -29649},
      {-17558, -27667}, {-20887, -25248}, {-23887, -22431}, {-26510, -19261}, {-28715, -15786}, {-30467, -12063},
      {-31739, -8149},  {-32510, -4107},  {-32768, 0},      {-32510, 4107},   {-31739, 8149},   {-30467, 12063},
      {-28715, 15786},  {-26510, 19261},  {-23887, 22431},  {-20887, 25248},  {-17558, 27667},  {-13952, 29649},
      {-10126, 31164},  {-6140, 32188},   {-2058, 32703},   {2058, 32703},    {6140, 32188},    {10126, 31164},
      {13952, 29649},   {17558, 27667},   {20887, 25248},   {23887, 22431},   {26510, 19261},   {28715, 15786},
      {30467, 12063},   {31739, 8149},    {32510, 4107},    {32767, 0},       {32510, -4107},   {31739, -8149},
      {30467, -12063},  {28715, -15786},  {26510, -19261},  {23887, -22431},  {20887, -25248},  {17558, -27667},
      {13952, -29649},  {10126, -31164},  {6140, -32188},   {2058, -32703},   {-2058, -32703},  {-6140, -32188},
      {-10126, -31164}, {-13952, -29649}, {-17558, -27667}, {-20887, -25248}, {-23887, -22431}, {-26510, -19261},
      {-28715, -15786}, {-30467, -12063}, {-31739, -8149},  {-32510, -4107},  {-32768, 0},      {-32510, 4107},
      {-31739, 8149},   {-30467, 12063},  {-28715, 15786},  {-26510, 19261},  {-23887, 22431},  {-20887, 25248}}},
    {{{32546, -3804},   {31885, -7557},   {30792, -11207},  {29283, -14706},  {27377, -18006},  {25102, -21063},
      {22487, -23835},  {19568, -26284},  {16384, -28378},  {12979, -30088},  {9398, -31391},   {5690, -32270},
      {1905, -32713},   {-1905, -32713},  {-5690, -32270},  {-9398, -31391},  {-12979, -30088}, {-16384, -28378},
      {-19568, -26284}, {-22487, -23835}, {-25102, -21063}, {-27377, -18006}, {-29283, -14706}, {-30792, -11207},
      {-31885, -7557},  {-32546, -3804},  {-32768, 0},      {-32546, 3804},   {-31885, 7557},   {-30792, 11207},
      {-29283, 14706},  {-27377, 18006},  {-25102, 21063},  {-22487, 23835},  {-19568, 26284},  {-16384, 28378},
      {-12979, 30088},  {-9398, 31391},   {-5690, 32270},   {-1905, 32713},   {1905, 32713},    {5690, 32270},
      {9398, 31391},    {12979, 30088},   {16384, 28378},   {19568, 26284},   {22487, 23835},   {25102, 21063},
      {27377, 18006},   {29283, 14706},   {30792, 11207},   {31885, 7557},    {32546, 3804},    {32767, 0},
      {32546, -3804},   {31885, -7557},   {30792, -11207},  {29283, -14706},  {27377, -18006},  {25102, -21063},
      {22487, -23835},  {19568, -26284},  {16384, -28378},  {12979, -30088},  {9398, -31391},   {5690, -32270},
      {1905, -32713},   {-1905, -32713},  {-5690, -32270},  {-9398, -31391},  {-12979, -30088}, {-16384, -28378},
      {-19568, -26284}, {-22487, -23835}, {-25102, -21063}, {-27377, -18006}, {-29283, -14706}, {-30792, -11207},
      {-31885, -7557},  {-32546, -3804},  {-32768, 0},      {-32546, 3804},   {-31885, 7557},   {-30792, 11207},
      {-29283, 14706},  {-27377, 18006},  {-25102, 21063},  {-22487, 23835},  {-19568, 26284},  {-16384, 28378},
      {-12979, 30088},  {-9398, 31391},   {-5690, 32270},   {-1905, 32713},   {1905, 32713},    {5690, 32270},
      {9398, 31391},    {12979, 30088},   {16384, 28378},   {19568, 26284},   {22487, 23835},   {25102, 21063},
      {27377, 18006},   {29283, 14706},   {30792, 11207},   {31885, 7557},    {32546, 3804},    {32767, 0},
      {32546, -3804},   {31885, -7557},   {30792, -11207},  {29283, -14706},  {27377, -18006},  {25102, -21063},
      {22487, -23835},  {19568, -26284},  {16384, -28378},  {12979, -30088},  {9398, -31391},   {5690, -32270},
      {1905, -32713},   {-1905, -32713},  {-5690, -32270},  {-9398, -31391},  {-12979, -30088}, {-16384, -28378},
      {-19568, -26284}, {-22487, -23835}, {-25102, -21063}, {-27377, -18006}, {-29283, -14706}, {-30792, -11207}}},
    {{{32588, -3425},   {32052, -6813},   {31164, -10126},  {29935, -13328},  {28378, -16384},  {26510, -19261},
      {24351, -21926},  {21926, -24351},  {19261, -26510},  {16384, -28378},  {13328, -29935},  {10126, -31164},
      {6813, -32052},   {3425, -32588},   {0, -32768},      {-3425, -32588},  {-6813, -32052},  {-10126, -31164},
      {-13328, -29935}, {-16384, -28378}, {-19261, -26510}, {-21926, -24351}, {-24351, -21926}, {-26510, -19261},
      {-28378, -16384}, {-29935, -13328}, {-31164, -10126}, {-32052, -6813},  {-32588, -3425},  {-32768, 0},
      {-32588, 3425},   {-32052, 6813},   {-31164, 10126},  {-29935, 13328},  {-28378, 16384},  {-26510, 19261},
      {-24351, 21926},  {-21926, 24351},  {-19261, 26510},  {-16384, 28378},  {-13328, 29935},  {-10126, 31164},
      {-6813, 32052},   {-3425, 32588},   {0, 32767},       {3425, 32588},    {6813, 32052},    {10126, 31164},
      {13328, 29935},   {16384, 28378},   {19261, 26510},   {21926, 24351},   {24351, 21926},   {26510, 19261},
      {28378, 16384},   {29935, 13328},   {31164, 10126},   {32052, 6813},    {32588, 3425},    {32767, 0},
      {32588, -3425},   {32052, -6813},   {31164, -10126},  {29935, -13328},  {28378, -16384},  {26510, -19261},
      {24351, -21926},  {21926, -24351},  {19261, -26510},  {16384, -28378},  {13328, -29935},  {10126, -31164},
      {6813, -32052},   {3425, -32588},   {0, -32768},      {-3425, -32588},  {-6813, -32052},  {-10126, -31164},
      {-13328, -29935}, {-16384, -28378}, {-19261, -26510}, {-21926, -24351}, {-24351, -21926}, {-26510, -19261},
      {-28378, -16384}, {-29935, -13328}, {-31164, -10126}, {-32052, -6813},  {-32588, -3425},  {-32768, 0},
      {-32588, 3425},   {-32052, 6813},   {-31164, 10126},  {-29935, 13328},  {-28378, 16384},  {-26510, 19261},
      {-24351, 21926},  {-21926, 24351},  {-19261, 26510},  {-16384, 28378},  {-13328, 29935},  {-10126, 31164},
      {-6813, 32052},   {-3425, 32588},   {0, 32767},       {3425, 32588},    {6813, 32052},    {10126, 31164},
      {13328, 29935},   {16384, 28378},   {19261, 26510},   {21926, 24351},   {24351, 21926},   {26510, 19261},
      {28378, 16384},   {29935, 13328},   {31164, 10126},   {32052, 6813},    {32588, 3425},    {32767, 0},
      {32588, -3425},   {32052, -6813},   {31164, -10126},  {29935, -13328},  {28378, -16384},  {26510, -19261},
      {24351, -21926},  {21926, -24351},  {19261, -26510},  {16384, -28378},  {13328, -29935},  {10126, -31164}}},
    {{{32603, -3289},   {32108, -6544},   {31289, -9733},   {30154, -12825},  {28715, -15786},  {26986, -18588},
      {24984, -21203},  {22730, -23603},  {20246, -25765},  {17558, -27667},  {14693, -29289},  {11679, -30616},
      {8547, -31634},   {5329, -32332},   {2058, -32703},   {-1235, -32745},  {-4515, -32455},  {-7750, -31838},
      {-10906, -30900}, {-13952, -29649}, {-16857, -28099}, {-19592, -26266}, {-22129, -24167}, {-24443, -21824},
      {-26510, -19261}, {-28309, -16503}, {-29822, -13578}, {-31035, -10517}, {-31933, -7349},  {-32510, -4107},
      {-32758, -823},   {-32675, 2468},   {-32262, 5735},   {-31524, 8944},   {-30467, 12063},  {-29102, 15060},
      {-27444, 17904},  {-25509, 20568},  {-23316, 23024},  {-20887, 25248},  {-18248, 27217},  {-15424, 28911},
      {-12445, 30313},  {-9340, 31409},   {-6140, 32188},   {-2879, 32641},   {412, 32765},     {3698, 32559},
      {6947, 32023},    {10126, 31164},   {13202, 29991},   {16146, 28514},   {18926, 26750},   {21515, 24715},
      {23887, 22431},   {26017, 19921},   {27885, 17209},   {29472, 14323},   {30760, 11293},   {31739, 8149},
      {32396, 4923},    {32727, 1646},    {32727, -1646},   {32396, -4923},   {31739, -8149},   {30760, -11293},
      {29472, -14323},  {27885, -17209},  {26017, -19921},  {23887, -22431},  {21515, -24715},  {18926, -26750},
      {16146, -28514},  {13202, -29991},  {10126, -31164},  {6947, -32023},   {3698, -32559},   {412, -32765},
      {-2879, -32641},  {-6140, -32188},  {-9340, -31409},  {-12445, -30313}, {-15424, -28911}, {-18248, -27217},
      {-20887, -25248}, {-23316, -23024}, {-25509, -20568}, {-27444, -17904}, {-29102, -15060}, {-30467, -12063},
      {-31524, -8944},  {-32262, -5735},  {-32675, -2468},  {-32758, 823},    {-32510, 4107},   {-31933, 7349},
      {-31035, 10517},  {-29822, 13578},  {-28309, 16503},  {-26510, 19261},  {-24443, 21824},  {-22129, 24167},
      {-19592, 26266},  {-16857, 28099},  {-13952, 29649},  {-10906, 30900},  {-7750, 31838},   {-4515, 32455},
      {-1235, 32745},   {2058, 32703},    {5329, 32332},    {8547, 31634},    {11679, 30616},   {14693, 29289},
      {17558, 27667},   {20246, 25765},   {22730, 23603},   {24984, 21203},   {26986, 18588},   {28715, 15786},
      {30154, 12825},   {31289, 9733},    {32108, 6544},    {32603, 3289},    {32767, 0},       {32603, -3289},
      {32108, -6544},   {31289, -9733},   {30154, -12825},  {28715, -15786},  {26986, -18588},  {24984, -21203}}},
    {{{32610, -3212},   {32138, -6393},   {31357, -9512},   {30274, -12540},  {28899, -15447},  {27246, -18205},
      {25330, -20788},  {23170, -23170},  {20788, -25330},  {18205, -27246},  {15447, -28899},  {12540, -30274},
      {9512, -31357},   {6393, -32138},   {3212, -32610},   {0, -32768},      {-3212, -32610},  {-6393, -32138},
      {-9512, -31357},  {-12540, -30274}, {-15447, -28899}, {-18205, -27246}, {-20788, -25330}, {-23170, -23170},
      {-25330, -20788}, {-27246, -18205}, {-28899, -15447}, {-30274, -12540}, {-31357, -9512},  {-32138, -6393},
      {-32610, -3212},  {-32768, 0},      {-32610, 3212},   {-32138, 6393},   {-31357, 9512},   {-30274, 12540},
      {-28899, 15447},  {-27246, 18205},  {-25330, 20788},  {-23170, 23170},  {-20788, 25330},  {-18205, 27246},
      {-15447, 28899},  {-12540, 30274},  {-9512, 31357},   {-6393, 32138},   {-3212, 32610},   {0, 32767},
      {3212, 32610},    {6393, 32138},    {9512, 31357},    {12540, 30274},   {15447, 28899},   {18205, 27246},
      {20788, 25330},   {23170, 23170},   {25330, 20788},   {27246, 18205},   {28899, 15447},   {30274, 12540},
      {31357, 9512},    {32138, 6393},    {32610, 3212},    {32767, 0},       {32610, -3212},   {32138, -6393},
      {31357, -9512},   {30274, -12540},  {28899, -15447},  {27246, -18205},  {25330, -20788},  {23170, -23170},
      {20788, -25330},  {18205, -27246},  {15447, -28899},  {12540, -30274},  {9512, -31357},   {6393, -32138},
      {3212, -32610},   {0, -32768},      {-3212, -32610},  {-6393, -32138},  {-9512, -31357},  {-12540, -30274},
      {-15447, -28899}, {-18205, -27246}, {-20788, -25330}, {-23170, -23170}, {-25330, -20788}, {-27246, -18205},
      {-28899, -15447}, {-30274, -12540}, {-31357, -9512},  {-32138, -6393},  {-32610, -3212},  {-32768, 0},
      {-32610, 3212},   {-32138, 6393},   {-31357, 9512},   {-30274, 12540},  {-28899, 15447},  {-27246, 18205},
      {-25330, 20788},  {-23170, 23170},  {-20788, 25330},  {-18205, 27246},  {-15447, 28899},  {-12540, 30274},
      {-9512, 31357},   {-6393, 32138},   {-3212, 32610},   {0, 32767},       {3212, 32610},    {6393, 32138},
      {9512, 31357},    {12540, 30274},   {15447, 28899},   {18205, 27246},   {20788, 25330},   {23170, 23170},
      {25330, 20788},   {27246, 18205},   {28899, 15447},   {30274, 12540},   {31357, 9512},    {32138, 6393},
      {32610, 3212},    {32767, 0},       {32610, -3212},   {32138, -6393},   {31357, -9512},   {30274, -12540}}},
    {{{32626, -3046},   {32202, -6065},   {31499, -9032},   {30523, -11921},  {29283, -14706},  {27789, -17364},
      {26055, -19872},  {24095, -22208},  {21926, -24351},  {19568, -26284},  {17040, -27989},  {14365, -29452},
      {11565, -30659},  {8665, -31602},   {5690, -32270},   {2666, -32659},   {-381, -32766},   {-3425, -32588},
      {-6439, -32129},  {-9398, -31391},  {-12275, -30382}, {-15046, -29109}, {-17687, -27585}, {-20174, -25822},
      {-22487, -23835}, {-24605, -21641}, {-26510, -19261}, {-28185, -16713}, {-29617, -14021}, {-30792, -11207},
      {-31700, -8297},  {-32334, -5314},  {-32688, -2286},  {-32759, 762},    {-32546, 3804},   {-32052, 6813},
      {-31280, 9763},   {-30237, 12628},  {-28932, 15384},  {-27377, 18006},  {-25585, 20473},  {-23571, 22763},
      {-21354, 24855},  {-18951, 26732},  {-16384, 28378},  {-13675, 29778},  {-10848, 30920},  {-7927, 31795},
      {-4938, 32394},   {-1905, 32713},   {1144, 32748},    {4183, 32500},    {7185, 31971},    {10126, 31164},
      {12979, 30088},   {15719, 28751},   {18324, 27166},   {20769, 25345},   {23035, 23305},   {25102, 21063},
      {26951, 18638},   {28567, 16053},   {29935, 13328},   {31044, 10488},   {31885, 7557},    {32449, 4560},
      {32733, 1525},    {32733, -1525},   {32449, -4560},   {31885, -7557},   {31044, -10488},  {29935, -13328},
      {28567, -16053},  {26951, -18638},  {25102, -21063},  {23035, -23305},  {20769, -25345},  {18324, -27166},
      {15719, -28751},  {12979, -30088},  {10126, -31164},  {7185, -31971},   {4183, -32500},   {1144, -32748},
      {-1905, -32713},  {-4938, -32394},  {-7927, -31795},  {-10848, -30920}, {-13675, -29778}, {-16384, -28378},
      {-18951, -26732}, {-21354, -24855}, {-23571, -22763}, {-25585, -20473}, {-27377, -18006}, {-28932, -15384},
      {-30237, -12628}, {-31280, -9763},  {-32052, -6813},  {-32546, -3804},  {-32759, -762},   {-32688, 2286},
      {-32334, 5314},   {-31700, 8297},   {-30792, 11207},  {-29617, 14021},  {-28185, 16713},  {-26510, 19261},
      {-24605, 21641},  {-22487, 23835},  {-20174, 25822},  {-17687, 27585},  {-15046, 29109},  {-12275, 30382},
      {-9398, 31391},   {-6439, 32129},   {-3425, 32588},   {-381, 32766},    {2666, 32659},    {5690, 32270},
      {8665, 31602},    {11565, 30659},   {14365, 29452},   {17040, 27989},   {19568, 26284},   {21926, 24351},
      {24095, 22208},   {26055, 19872},   {27789, 17364},   {29283, 14706},   {30523, 11921},   {31499, 9032}}},
    {{{32643, -2856},   {32270, -5690},   {31651, -8481},   {30792, -11207},  {29698, -13848},  {28378, -16384},
      {26842, -18795},  {25102, -21063},  {23170, -23170},  {21063, -25102},  {18795, -26842},  {16384, -28378},
      {13848, -29698},  {11207, -30792},  {8481, -31651},   {5690, -32270},   {2856, -32643},   {0, -32768},
      {-2856, -32643},  {-5690, -32270},  {-8481, -31651},  {-11207, -30792}, {-13848, -29698}, {-16384, -28378},
      {-18795, -26842}, {-21063, -25102}, {-23170, -23170}, {-25102, -21063}, {-26842, -18795}, {-28378, -16384},
      {-29698, -13848}, {-30792, -11207}, {-31651, -8481},  {-32270, -5690},  {-32643, -2856},  {-32768, 0},
      {-32643, 2856},   {-32270, 5690},   {-31651, 8481},   {-30792, 11207},  {-29698, 13848},  {-28378, 16384},
      {-26842, 18795},  {-25102, 21063},  {-23170, 23170},  {-21063, 25102},  {-18795, 26842},  {-16384, 28378},
      {-13848, 29698},  {-11207, 30792},  {-8481, 31651},   {-5690, 32270},   {-2856, 32643},   {0, 32767},
      {2856, 32643},    {5690, 32270},    {8481, 31651},    {11207, 30792},   {13848, 29698},   {16384, 28378},
      {18795, 26842},   {21063, 25102},   {23170, 23170},   {25102, 21063},   {26842, 18795},   {28378, 16384},
      {29698, 13848},   {30792, 11207},   {31651, 8481},    {32270, 5690},    {32643, 2856},    {32767, 0},
      {32643, -2856},   {32270, -5690},   {31651, -8481},   {30792, -11207},  {29698, -13848},  {28378, -16384},
      {26842, -18795},  {25102, -21063},  {23170, -23170},  {21063, -25102},  {18795, -26842},  {16384, -28378},
      {13848, -29698},  {11207, -30792},  {8481, -31651},   {5690, -32270},   {2856, -32643},   {0, -32768},
      {-2856, -32643},  {-5690, -32270},  {-8481, -31651},  {-11207, -30792}, {-13848, -29698}, {-16384, -28378},
      {-18795, -26842}, {-21063, -25102}, {-23170, -23170}, {-25102, -21063}, {-26842, -18795}, {-28378, -16384},
      {-29698, -13848}, {-30792, -11207}, {-31651, -8481},  {-32270, -5690},  {-32643, -2856},  {-32768, 0},
      {-32643, 2856},   {-32270, 5690},   {-31651, 8481},   {-30792, 11207},  {-29698, 13848},  {-28378, 16384},
      {-26842, 18795},  {-25102, 21063},  {-23170, 23170},  {-21063, 25102},  {-18795, 26842},  {-16384, 28378},
      {-13848, 29698},  {-11207, 30792},  {-8481, 31651},   {-5690, 32270},   {-2856, 32643},   {0, 32767},
      {2856, 32643},    {5690, 32270},    {8481, 31651},    {11207, 30792},   {13848, 29698},   {16384, 28378}}},
    {{{32653, -2742},   {32309, -5465},   {31739, -8149},   {30945, -10776},  {29935, -13328},  {28715, -15786},
      {27293, -18134},  {25680, -20354},  {23887, -22431},  {21926, -24351},  {19812, -26101},  {17558, -27667},
      {15181, -29039},  {12698, -30208},  {10126, -31164},  {7483, -31902},   {4787, -32416},   {2058, -32703},
      {-686, -32761},   {-3425, -32588},  {-6140, -32188},  {-8812, -31561},  {-11422, -30713}, {-13952, -29649},
      {-16384, -28378}, {-18701, -26907}, {-20887, -25248}, {-22927, -23412}, {-24805, -21411}, {-26510, -19261},
      {-28029, -16975}, {-29351, -14570}, {-30467, -12063}, {-31369, -9471},  {-32052, -6813},  {-32510, -4107},
      {-32739, -1372},  {-32739, 1372},   {-32510, 4107},   {-32052, 6813},   {-31369, 9471},   {-30467, 12063},
      {-29351, 14570},  {-28029, 16975},  {-26510, 19261},  {-24805, 21411},  {-22927, 23412},  {-20887, 25248},
      {-18701, 26907},  {-16384, 28378},  {-13952, 29649},  {-11422, 30713},  {-8812, 31561},   {-6140, 32188},
      {-3425, 32588},   {-686, 32761},    {2058, 32703},    {4787, 32416},    {7483, 31902},    {10126, 31164},
      {12698, 30208},   {15181, 29039},   {17558, 27667},   {19812, 26101},   {21926, 24351},   {23887, 22431},
      {25680, 20354},   {27293, 18134},   {28715, 15786},   {29935, 13328},   {30945, 10776},   {31739, 8149},
      {32309, 5465},    {32653, 2742},    {32767, 0},       {32653, -2742},   {32309, -5465},   {31739, -8149},
      {30945, -10776},  {29935, -13328},  {28715, -15786},  {27293, -18134},  {25680, -20354},  {23887, -22431},
      {21926, -24351},  {19812, -26101},  {17558, -27667},  {15181, -29039},  {12698, -30208},  {10126, -31164},
      {7483, -31902},   {4787, -32416},   {2058, -32703},   {-686, -32761},   {-3425, -32588},  {-6140, -32188},
      {-8812, -31561},  {-11422, -30713}, {-13952, -29649}, {-16384, -28378}, {-18701, -26907}, {-20887, -25248},
      {-22927, -23412}, {-24805, -21411}, {-26510, -19261}, {-28029, -16975}, {-29351, -14570}, {-30467, -12063},
      {-31369, -9471},  {-32052, -6813},  {-32510, -4107},  {-32739, -1372},  {-32739, 1372},   {-32510, 4107},
      {-32052, 6813},   {-31369, 9471},   {-30467, 12063},  {-29351, 14570},  {-28029, 16975},  {-26510, 19261},
      {-24805, 21411},  {-22927, 23412},  {-20887, 25248},  {-18701, 26907},  {-16384, 28378},  {-13952, 29649},
      {-11422, 30713},  {-8812, 31561},   {-6140, 32188},   {-3425, 32588},   {-686, 32761},    {2058, 32703}}},
    {{{32667, -2571},   {32365, -5126},   {31863, -7650},   {31164, -10126},  {30274, -12540},  {29197, -14876},
      {27939, -17121},  {26510, -19261},  {24917, -21281},  {23170, -23170},  {21281, -24917},  {19261, -26510},
      {17121, -27939},  {14876, -29197},  {12540, -30274},  {10126, -31164},  {7650, -31863},   {5126, -32365},
      {2571, -32667},   {0, -32768},      {-2571, -32667},  {-5126, -32365},  {-7650, -31863},  {-10126, -31164},
      {-12540, -30274}, {-14876, -29197}, {-17121, -27939}, {-19261, -26510}, {-21281, -24917}, {-23170, -23170},
      {-24917, -21281}, {-26510, -19261}, {-27939, -17121}, {-29197, -14876}, {-30274, -12540}, {-31164, -10126},
      {-31863, -7650},  {-32365, -5126},  {-32667, -2571},  {-32768, 0},      {-32667, 2571},   {-32365, 5126},
      {-31863, 7650},   {-31164, 10126},  {-30274, 12540},  {-29197, 14876},  {-27939, 17121},  {-26510, 19261},
      {-24917, 21281},  {-23170, 23170},  {-21281, 24917},  {-19261, 26510},  {-17121, 27939},  {-14876, 29197},
      {-12540, 30274},  {-10126, 31164},  {-7650, 31863},   {-5126, 32365},   {-2571, 32667},   {0, 32767},
      {2571, 32667},    {5126, 32365},    {7650, 31863},    {10126, 31164},   {12540, 30274},   {14876, 29197},
      {17121, 27939},   {19261, 26510},   {21281, 24917},   {23170, 23170},   {24917, 21281},   {26510, 19261},
      {27939, 17121},   {29197, 14876},   {30274, 12540},   {31164, 10126},   {31863, 7650},    {32365, 5126},
      {32667, 2571},    {32767, 0},       {32667, -2571},   {32365, -5126},   {31863, -7650},   {31164, -10126},
      {30274, -12540},  {29197, -14876},  {27939, -17121},  {26510, -19261},  {24917, -21281},  {23170, -23170},
      {21281, -24917},  {19261, -26510},  {17121, -27939},  {14876, -29197},  {12540, -30274},  {10126, -31164},
      {7650, -31863},   {5126, -32365},   {2571, -32667},   {0, -32768},      {-2571, -32667},  {-5126, -32365},
      {-7650, -31863},  {-10126, -31164}, {-12540, -30274}, {-14876, -29197}, {-17121, -27939}, {-19261, -26510},
      {-21281, -24917}, {-23170, -23170}, {-24917, -21281}, {-26510, -19261}, {-27939, -17121}, {-29197, -14876},
      {-30274, -12540}, {-31164, -10126}, {-31863, -7650},  {-32365, -5126},  {-32667, -2571},  {-32768, 0},
      {-32667, 2571},   {-32365, 5126},   {-31863, 7650},   {-31164, 10126},  {-30274, 12540},  {-29197, 14876},
      {-27939, 17121},  {-26510, 19261},  {-24917, 21281},  {-23170, 23170},  {-21281, 24917},  {-19261, 26510}}},
    {{{32669, -2539},   {32374, -5063},   {31885, -7557},   {31203, -10005},  {30334, -12393},  {29283, -14706},
      {28055, -16931},  {26658, -19054},  {25102, -21063},  {23394, -22945},  {21546, -24689},  {19568, -26284},
      {17472, -27721},  {15271, -28992},  {12979, -30088},  {10608, -31003},  {8174, -31732},   {5690, -32270},
      {3172, -32614},   {635, -32762},    {-1905, -32713},  {-4435, -32467},  {-6937, -32025},  {-9398, -31391},
      {-11802, -30569}, {-14136, -29562}, {-16384, -28378}, {-18534, -27023}, {-20572, -25505}, {-22487, -23835},
      {-24266, -22020}, {-25900, -20074}, {-27377, -18006}, {-28690, -15831}, {-29831, -13560}, {-30792, -11207},
      {-31568, -8787},  {-32154, -6315},  {-32546, -3804},  {-32743, -1271},  {-32743, 1271},   {-32546, 3804},
      {-32154, 6315},   {-31568, 8787},   {-30792, 11207},  {-29831, 13560},  {-28690, 15831},  {-27377, 18006},
      {-25900, 20074},  {-24266, 22020},  {-22487, 23835},  {-20572, 25505},  {-18534, 27023},  {-16384, 28378},
      {-14136, 29562},  {-11802, 30569},  {-9398, 31391},   {-6937, 32025},   {-4435, 32467},   {-1905, 32713},
      {635, 32762},     {3172, 32614},    {5690, 32270},    {8174, 31732},    {10608, 31003},   {12979, 30088},
      {15271, 28992},   {17472, 27721},   {19568, 26284},   {21546, 24689},   {23394, 22945},   {25102, 21063},
      {26658, 19054},   {28055, 16931},   {29283, 14706},   {30334, 12393},   {31203, 10005},   {31885, 7557},
      {32374, 5063},    {32669, 2539},    {32767, 0},       {32669, -2539},   {32374, -5063},   {31885, -7557},
      {31203, -10005},  {30334, -12393},  {29283, -14706},  {28055, -16931},  {26658, -19054},  {25102, -21063},
      {23394, -22945},  {21546, -24689},  {19568, -26284},  {17472, -27721},  {15271, -28992},  {12979, -30088},
      {10608, -31003},  {8174, -31732},   {5690, -32270},   {3172, -32614},   {635, -32762},    {-1905, -32713},
      {-4435, -32467},  {-6937, -32025},  {-9398, -31391},  {-11802, -30569}, {-14136, -29562}, {-16384, -28378},
      {-18534, -27023}, {-20572, -25505}, {-22487, -23835}, {-24266, -22020}, {-25900, -20074}, {-27377, -18006},
      {-28690, -15831}, {-29831, -13560}, {-30792, -11207}, {-31568, -8787},  {-32154, -6315},  {-32546, -3804},
      {-32743, -1271},  {-32743, 1271},   {-32546, 3804},   {-32154, 6315},   {-31568, 8787},   {-30792, 11207},
      {-29831, 13560},  {-28690, 15831},  {-27377, 18006},  {-25900, 20074},  {-24266, 22020},  {-22487, 23835}}},
    {{{32688, -2286},   {32449, -4560},   {32052, -6813},   {31499, -9032},   {30792, -11207},  {29935, -13328},
      {28932, -15384},  {27789, -17364},  {26510, -19261},  {25102, -21063},  {23571, -22763},  {21926, -24351},
      {20174, -25822},  {18324, -27166},  {16384, -28378},  {14365, -29452},  {12275, -30382},  {10126, -31164},
      {7927, -31795},   {5690, -32270},   {3425, -32588},   {1144, -32748},   {-1144, -32748},  {-3425, -32588},
      {-5690, -32270},  {-7927, -31795},  {-10126, -31164}, {-12275, -30382}, {-14365, -29452}, {-16384, -28378},
      {-18324, -27166}, {-20174, -25822}, {-21926, -24351}, {-23571, -22763}, {-25102, -21063}, {-26510, -19261},
      {-27789, -17364}, {-28932, -15384}, {-29935, -13328}, {-30792, -11207}, {-31499, -9032},  {-32052, -6813},
      {-32449, -4560},  {-32688, -2286},  {-32768, 0},      {-32688, 2286},   {-32449, 4560},   {-32052, 6813},
      {-31499, 9032},   {-30792, 11207},  {-29935, 13328},  {-28932, 15384},  {-27789, 17364},  {-26510, 19261},
      {-25102, 21063},  {-23571, 22763},  {-21926, 24351},  {-20174, 25822},  {-18324, 27166},  {-16384, 28378},
      {-14365, 29452},  {-12275, 30382},  {-10126, 31164},  {-7927, 31795},   {-5690, 32270},   {-3425, 32588},
      {-1144, 32748},   {1144, 32748},    {3425, 32588},    {5690, 32270},    {7927, 31795},    {10126, 31164},
      {12275, 30382},   {14365, 29452},   {16384, 28378},   {18324, 27166},   {20174, 25822},   {21926, 24351},
      {23571, 22763},   {25102, 21063},   {26510, 19261},   {27789, 17364},   {28932, 15384},   {29935, 13328},
      {30792, 11207},   {31499, 9032},    {32052, 6813},    {32449, 4560},    {32688, 2286},    {32767, 0},
      {32688, -2286},   {32449, -4560},   {32052, -6813},   {31499, -9032},   {30792, -11207},  {29935, -13328},
      {28932, -15384},  {27789, -17364},  {26510, -19261},  {25102, -21063},  {23571, -22763},  {21926, -24351},
      {20174, -25822},  {18324, -27166},  {16384, -28378},  {14365, -29452},  {12275, -30382},  {10126, -31164},
      {7927, -31795},   {5690, -32270},   {3425, -32588},   {1144, -32748},   {-1144, -32748},  {-3425, -32588},
      {-5690, -32270},  {-7927, -31795},  {-10126, -31164}, {-12275, -30382}, {-14365, -29452}, {-16384, -28378},
      {-18324, -27166}, {-20174, -25822}, {-21926, -24351}, {-23571, -22763}, {-25102, -21063}, {-26510, -19261},
      {-27789, -17364}, {-28932, -15384}, {-29935, -13328}, {-30792, -11207}, {-31499, -9032},  {-32052, -6813}}},
    {{{32698, -2143},   {32488, -4277},   {32138, -6393},   {31651, -8481},   {31029, -10533},  {30274, -12540},
      {29389, -14493},  {28378, -16384},  {27246, -18205},  {25997, -19948},  {24636, -21605},  {23170, -23170},
      {21605, -24636},  {19948, -25997},  {18205, -27246},  {16384, -28378},  {14493, -29389},  {12540, -30274},
      {10533, -31029},  {8481, -31651},   {6393, -32138},   {4277, -32488},   {2143, -32698},   {0, -32768},
      {-2143, -32698},  {-4277, -32488},  {-6393, -32138},  {-8481, -31651},  {-10533, -31029}, {-12540, -30274},
      {-14493, -29389}, {-16384, -28378}, {-18205, -27246}, {-19948, -25997}, {-21605, -24636}, {-23170, -23170},
      {-24636, -21605}, {-25997, -19948}, {-27246, -18205}, {-28378, -16384}, {-29389, -14493}, {-30274, -12540},
      {-31029, -10533}, {-31651, -8481},  {-32138, -6393},  {-32488, -4277},  {-32698, -2143},  {-32768, 0},
      {-32698, 2143},   {-32488, 4277},   {-32138, 6393},   {-31651, 8481},   {-31029, 10533},  {-30274, 12540},
      {-29389, 14493},  {-28378, 16384},  {-27246, 18205},  {-25997, 19948},  {-24636, 21605},  {-23170, 23170},
      {-21605, 24636},  {-19948, 25997},  {-18205, 27246},  {-16384, 28378},  {-14493, 29389},  {-12540, 30274},
      {-10533, 31029},  {-8481, 31651},   {-6393, 32138},   {-4277, 32488},   {-2143, 32698},   {0, 32767},
      {2143, 32698},    {4277, 32488},    {6393, 32138},    {8481, 31651},    {10533, 31029},   {12540, 30274},
      {14493, 29389},   {16384, 28378},   {18205, 27246},   {19948, 25997},   {21605, 24636},   {23170, 23170},
      {24636, 21605},   {25997, 19948},   {27246, 18205},   {28378, 16384},   {29389, 14493},   {30274, 12540},
      {31029, 10533},   {31651, 8481},    {32138, 6393},    {32488, 4277},    {32698, 2143},    {32767, 0},
      {32698, -2143},   {32488, -4277},   {32138, -6393},   {31651, -8481},   {31029, -10533},  {30274, -12540},
      {29389, -14493},  {28378, -16384},  {27246, -18205},  {25997, -19948},  {24636, -21605},  {23170, -23170},
      {21605, -24636},  {19948, -25997},  {18205, -27246},  {16384, -28378},  {14493, -29389},  {12540, -30274},
      {10533, -31029},  {8481, -31651},   {6393, -32138},   {4277, -32488},   {2143, -32698},   {0, -32768},
      {-2143, -32698},  {-4277, -32488},  {-6393, -32138},  {-8481, -31651},  {-10533, -31029}, {-12540, -30274},
      {-14493, -29389}, {-16384, -28378}, {-18205, -27246}, {-19948, -25997}, {-21605, -24636}, {-23170, -23170}}},
    {{{32703, -2058},   {32510, -4107},   {32188, -6140},   {31739, -8149},   {31164, -10126},  {30467, -12063},
      {29649, -13952},  {28715, -15786},  {27667, -17558},  {26510, -19261},  {25248, -20887},  {23887, -22431},
      {22431, -23887},  {20887, -25248},  {19261, -26510},  {17558, -27667},  {15786, -28715},  {13952, -29649},
      {12063, -30467},  {10126, -31164},  {8149, -31739},   {6140, -32188},   {4107, -32510},   {2058, -32703},
      {0, -32768},      {-2058, -32703},  {-4107, -32510},  {-6140, -32188},  {-8149, -31739},  {-10126, -31164},
      {-12063, -30467}, {-13952, -29649}, {-15786, -28715}, {-17558, -27667}, {-19261, -26510}, {-20887, -25248},
      {-22431, -23887}, {-23887, -22431}, {-25248, -20887}, {-26510, -19261}, {-27667, -17558}, {-28715, -15786},
      {-29649, -13952}, {-30467, -12063}, {-31164, -10126}, {-31739, -8149},  {-32188, -6140},  {-32510, -4107},
      {-32703, -2058},  {-32768, 0},      {-32703, 2058},   {-32510, 4107},   {-32188, 6140},   {-31739, 8149},
      {-31164, 10126},  {-30467, 12063},  {-29649, 13952},  {-28715, 15786},  {-27667, 17558},  {-26510, 19261},
      {-25248, 20887},  {-23887, 22431},  {-22431, 23887},  {-20887, 25248},  {-19261, 26510},  {-17558, 27667},
      {-15786, 28715},  {-13952, 29649},  {-12063, 30467},  {-10126, 31164},  {-8149, 31739},   {-6140, 32188},
      {-4107, 32510},   {-2058, 32703},   {0, 32767},       {2058, 32703},    {4107, 32510},    {6140, 32188},
      {8149, 31739},    {10126, 31164},   {12063, 30467},   {13952, 29649},   {15786, 28715},   {17558, 27667},
      {19261, 26510},   {20887, 25248},   {22431, 23887},   {23887, 22431},   {25248, 20887},   {26510, 19261},
      {27667, 17558},   {28715, 15786},   {29649, 13952},   {30467, 12063},   {31164, 10126},   {31739, 8149},
      {32188, 6140},    {32510, 4107},    {32703, 2058},    {32767, 0},       {32703, -2058},   {32510, -4107},
      {32188, -6140},   {31739, -8149},   {31164, -10126},  {30467, -12063},  {29649, -13952},  {28715, -15786},
      {27667, -17558},  {26510, -19261},  {25248, -20887},  {23887, -22431},  {22431, -23887},  {20887, -25248},
      {19261, -26510},  {17558, -27667},  {15786, -28715},  {13952, -29649},  {12063, -30467},  {10126, -31164},
      {8149, -31739},   {6140, -32188},   {4107, -32510},   {2058, -32703},   {0, -32768},      {-2058, -32703},
      {-4107, -32510},  {-6140, -32188},  {-8149, -31739},  {-10126, -31164}, {-12063, -30467}, {-13952, -29649}}},
    {{{32713, -1905},   {32546, -3804},   {32270, -5690},   {31885, -7557},   {31391, -9398},   {30792, -11207},
      {30088, -12979},  {29283, -14706},  {28378, -16384},  {27377, -18006},  {26284, -19568},  {25102, -21063},
      {23835, -22487},  {22487, -23835},  {21063, -25102},  {19568, -26284},  {18006, -27377},  {16384, -28378},
      {14706, -29283},  {12979, -30088},  {11207, -30792},  {9398, -31391},   {7557, -31885},   {5690, -32270},
      {3804, -32546},   {1905, -32713},   {0, -32768},      {-1905, -32713},  {-3804, -32546},  {-5690, -32270},
      {-7557, -31885},  {-9398, -31391},  {-11207, -30792}, {-12979, -30088}, {-14706, -29283}, {-16384, -28378},
      {-18006, -27377}, {-19568, -26284}, {-21063, -25102}, {-22487, -23835}, {-23835, -22487}, {-25102, -21063},
      {-26284, -19568}, {-27377, -18006}, {-28378, -16384}, {-29283, -14706}, {-30088, -12979}, {-30792, -11207},
      {-31391, -9398},  {-31885, -7557},  {-32270, -5690},  {-32546, -3804},  {-32713, -1905},  {-32768, 0},
      {-32713, 1905},   {-32546, 3804},   {-32270, 5690},   {-31885, 7557},   {-31391, 9398},   {-30792, 11207},
      {-30088, 12979},  {-29283, 14706},  {-28378, 16384},  {-27377, 18006},  {-26284, 19568},  {-25102, 21063},
      {-23835, 22487},  {-22487, 23835},  {-21063, 25102},  {-19568, 26284},  {-18006, 27377},  {-16384, 28378},
      {-14706, 29283},  {-12979, 30088},  {-11207, 30792},  {-9398, 31391},   {-7557, 31885},   {-5690, 32270},
      {-3804, 32546},   {-1905, 32713},   {0, 32767},       {1905, 32713},    {3804, 32546},    {5690, 32270},
      {7557, 31885},    {9398, 31391},    {11207, 30792},   {12979, 30088},   {14706, 29283},   {16384, 28378},
      {18006, 27377},   {19568, 26284},   {21063, 25102},   {22487, 23835},   {23835, 22487},   {25102, 21063},
      {26284, 19568},   {27377, 18006},   {28378, 16384},   {29283, 14706},   {30088, 12979},   {30792, 11207},
      {31391, 9398},    {31885, 7557},    {32270, 5690},    {32546, 3804},    {32713, 1905},    {32767, 0},
      {32713, -1905},   {32546, -3804},   {32270, -5690},   {31885, -7557},   {31391, -9398},   {30792, -11207},
      {30088, -12979},  {29283, -14706},  {28378, -16384},  {27377, -18006},  {26284, -19568},  {25102, -21063},
      {23835, -22487},  {22487, -23835},  {21063, -25102},  {19568, -26284},  {18006, -27377},  {16384, -28378},
      {14706, -29283},  {12979, -30088},  {11207, -30792},  {9398, -31391},   {7557, -31885},   {5690, -32270}}},
    {{{32717, -1829},   {32564, -3653},   {32309, -5465},   {31954, -7260},   {31499, -9032},   {30945, -10776},
      {30296, -12487},  {29551, -14159},  {28715, -15786},  {27789, -17364},  {26776, -18889},  {25680, -20354},
      {24504, -21756},  {23251, -23089},  {21926, -24351},  {20533, -25537},  {19075, -26644},  {17558, -27667},
      {15986, -28604},  {14365, -29452},  {12698, -30208},  {10992, -30869},  {9252, -31435},   {7483, -31902},
      {5690, -32270},   {3880, -32537},   {2058, -32703},   {229, -32767},    {-1601, -32729},  {-3425, -32588},
      {-5239, -32346},  {-7036, -32004},  {-8812, -31561},  {-10560, -31020}, {-12275, -30382}, {-13952, -29649},
      {-15585, -28824}, {-17170, -27909}, {-18701, -26907}, {-20174, -25822}, {-21584, -24655}, {-22927, -23412},
      {-24198, -22096}, {-25393, -20710}, {-26510, -19261}, {-27544, -17751}, {-28492, -16185}, {-29351, -14570},
      {-30118, -12909}, {-30792, -11207}, {-31369, -9471},  {-31849, -7705},  {-32230, -5915},  {-32510, -4107},
      {-32688, -2286},  {-32765, -458},   {-32739, 1372},   {-32612, 3198},   {-32382, 5013},   {-32052, 6813},
      {-31622, 8591},   {-31093, 10343},  {-30467, 12063},  {-29746, 13745},  {-28932, 15384},  {-28029, 16975},
      {-27037, 18513},  {-25962, 19993},  {-24805, 21411},  {-23571, 22763},  {-22264, 24043},  {-20887, 25248},
      {-19445, 26375},  {-17943, 27419},  {-16384, 28378},  {-14774, 29248},  {-13119, 30027},  {-11422, 30713},
      {-9690, 31303},   {-7927, 31795},   {-6140, 32188},   {-4334, 32480},   {-2514, 32671},   {-686, 32761},
      {1144, 32748},    {2970, 32633},    {4787, 32416},    {6589, 32099},    {8370, 31681},    {10126, 31164},
      {11850, 30550},   {13537, 29841},   {15181, 29039},   {16779, 28146},   {18324, 27166},   {19812, 26101},
      {21238, 24954},   {22597, 23730},   {23887, 22431},   {25102, 21063},   {26238, 19629},   {27293, 18134},
      {28263, 16582},   {29144, 14978},   {29935, 13328},   {30632, 11636},   {31234, 9908},    {31739, 8149},
      {32144, 6365},    {32449, 4560},    {32653, 2742},    {32755, 915},     {32755, -915},    {32653, -2742},
      {32449, -4560},   {32144, -6365},   {31739, -8149},   {31234, -9908},   {30632, -11636},  {29935, -13328},
      {29144, -14978},  {28263, -16582},  {27293, -18134},  {26238, -19629},  {25102, -21063},  {23887, -22431},
      {22597, -23730},  {21238, -24954},  {19812, -26101},  {18324, -27166},  {16779, -28146},  {15181, -29039}}},
    {{{32723, -1715},   {32588, -3425},   {32365, -5126},   {32052, -6813},   {31651, -8481},   {31164, -10126},
      {30592, -11743},  {29935, -13328},  {29197, -14876},  {28378, -16384},  {27482, -17847},  {26510, -19261},
      {25466, -20622},  {24351, -21926},  {23170, -23170},  {21926, -24351},  {20622, -25466},  {19261, -26510},
      {17847, -27482},  {16384, -28378},  {14876, -29197},  {13328, -29935},  {11743, -30592},  {10126, -31164},
      {8481, -31651},   {6813, -32052},   {5126, -32365},   {3425, -32588},   {1715, -32723},   {0, -32768},
      {-1715, -32723},  {-3425, -32588},  {-5126, -32365},  {-6813, -32052},  {-8481, -31651},  {-10126, -31164},
      {-11743, -30592}, {-13328, -29935}, {-14876, -29197}, {-16384, -28378}, {-17847, -27482}, {-19261, -26510},
      {-20622, -25466}, {-21926, -24351}, {-23170, -23170}, {-24351, -21926}, {-25466, -20622}, {-26510, -19261},
      {-27482, -17847}, {-28378, -16384}, {-29197, -14876}, {-29935, -13328}, {-30592, -11743}, {-31164, -10126},
      {-31651, -8481},  {-32052, -6813},  {-32365, -5126},  {-32588, -3425},  {-32723, -1715},  {-32768, 0},
      {-32723, 1715},   {-32588, 3425},   {-32365, 5126},   {-32052, 6813},   {-31651, 8481},   {-31164, 10126},
      {-30592, 11743},  {-29935, 13328},  {-29197, 14876},  {-28378, 16384},  {-27482, 17847},  {-26510, 19261},
      {-25466, 20622},  {-24351, 21926},  {-23170, 23170},  {-21926, 24351},  {-20622, 25466},  {-19261, 26510},
      {-17847, 27482},  {-16384, 28378},  {-14876, 29197},  {-13328, 29935},  {-11743, 30592},  {-10126, 31164},
      {-8481, 31651},   {-6813, 32052},   {-5126, 32365},   {-3425, 32588},   {-1715, 32723},   {0, 32767},
      {1715, 32723},    {3425, 32588},    {5126, 32365},    {6813, 32052},    {8481, 31651},    {10126, 31164},
      {11743, 30592},   {13328, 29935},   {14876, 29197},   {16384, 28378},   {17847, 27482},   {19261, 26510},
      {20622, 25466},   {21926, 24351},   {23170, 23170},   {24351, 21926},   {25466, 20622},   {26510, 19261},
      {27482, 17847},   {28378, 16384},   {29197, 14876},   {29935, 13328},   {30592, 11743},   {31164, 10126},
      {31651, 8481},    {32052, 6813},    {32365, 5126},    {32588, 3425},    {32723, 1715},    {32767, 0},
      {32723, -1715},   {32588, -3425},   {32365, -5126},   {32052, -6813},   {31651, -8481},   {31164, -10126},
      {30592, -11743},  {29935, -13328},  {29197, -14876},  {28378, -16384},  {27482, -17847},  {26510, -19261}}},
    {{{32724, -1694},   {32593, -3383},   {32374, -5063},   {32069, -6730},   {31679, -8379},   {31203, -10005},
      {30644, -11604},  {30004, -13173},  {29283, -14706},  {28483, -16200},  {27608, -17651},  {26658, -19054},
      {25638, -20407},  {24549, -21705},  {23394, -22945},  {22177, -24123},  {20900, -25237},  {19568, -26284},
      {18183, -27260},  {16750, -28164},  {15271, -28992},  {13752, -29742},  {12197, -30414},  {10608, -31003},
      {8991, -31510},   {7351, -31933},   {5690, -32270},   {4014, -32521},   {2328, -32685},   {635, -32762},
      {-1059, -32751},  {-2750, -32652},  {-4435, -32467},  {-6107, -32194},  {-7763, -31835},  {-9398, -31391},
      {-11008, -30864}, {-12589, -30253}, {-14136, -29562}, {-15645, -28792}, {-17112, -27945}, {-18534, -27023},
      {-19906, -26029}, {-21225, -24965}, {-22487, -23835}, {-23689, -22640}, {-24827, -21386}, {-25900, -20074},
      {-26903, -18708}, {-27834, -17292}, {-28690, -15831}, {-29470, -14326}, {-30171, -12784}, {-30792, -11207},
      {-31330, -9601},  {-31784, -7968},  {-32154, -6315},  {-32437, -4644},  {-32634, -2961},  {-32743, -1271},
      {-32765, 424},    {-32700, 2117},   {-32546, 3804},   {-32306, 5481},   {-31980, 7144},   {-31568, 8787},
      {-31071, 10407},  {-30492, 12000},  {-29831, 13560},  {-29090, 15084},  {-28271, 16567},  {-27377, 18006},
      {-26410, 19397},  {-25372, 20737},  {-24266, 22020},  {-23095, 23245},  {-21863, 24408},  {-20572, 25505},
      {-19226, 26535},  {-17829, 27493},  {-16384, 28378},  {-14895, 29187},  {-13367, 29918},  {-11802, 30569},
      {-10206, 31138},  {-8583, 31624},   {-6937, 32025},   {-5272, 32341},   {-3594, 32570},   {-1905, 32713},
      {-212, 32767},    {1482, 32734},    {3172, 32614},    {4854, 32407},    {6523, 32112},    {8174, 31732},
      {9803, 31267},    {11406, 30719},   {12979, 30088},   {14517, 29377},   {16016, 28587},   {17472, 27721},
      {18882, 26781},   {20241, 25769},   {21546, 24689},   {22793, 23542},   {23979, 22332},   {25102, 21063},
      {26157, 19737},   {27142, 18359},   {28055, 16931},   {28893, 15458},   {29653, 13944},   {30334, 12393},
      {30934, 10808},   {31451, 9195},    {31885, 7557},    {32233, 5899},    {32495, 4225},    {32669, 2539},
      {32757, 847},     {32757, -847},    {32669, -2539},   {32495, -4225},   {32233, -5899},   {31885, -7557},
      {31451, -9195},   {30934, -10808},  {30334, -12393},  {29653, -13944},  {28893, -15458},  {28055, -16931}}},
    {{{32727, -1646},   {32603, -3289},   {32396, -4923},   {32108, -6544},   {31739, -8149},   {31289, -9733},
      {30760, -11293},  {30154, -12825},  {29472, -14323},  {28715, -15786},  {27885, -17209},  {26986, -18588},
      {26017, -19921},  {24984, -21203},  {23887, -22431},  {22730, -23603},  {21515, -24715},  {20246, -25765},
      {18926, -26750},  {17558, -27667},  {16146, -28514},  {14693, -29289},  {13202, -29991},  {11679, -30616},
      {10126, -31164},  {8547, -31634},   {6947, -32023},   {5329, -32332},   {3698, -32559},   {2058, -32703},
      {412, -32765},    {-1235, -32745},  {-2879, -32641},  {-4515, -32455},  {-6140, -32188},  {-7750, -31838},
      {-9340, -31409},  {-10906, -30900}, {-12445, -30313}, {-13952, -29649}, {-15424, -28911}, {-16857, -28099},
      {-18248, -27217}, {-19592, -26266}, {-20887, -25248}, {-22129, -24167}, {-23316, -23024}, {-24443, -21824},
      {-25509, -20568}, {-26510, -19261}, {-27444, -17904}, {-28309, -16503}, {-29102, -15060}, {-29822, -13578},
      {-30467, -12063}, {-31035, -10517}, {-31524, -8944},  {-31933, -7349},  {-32262, -5735},  {-32510, -4107},
      {-32675, -2468},  {-32758, -823},   {-32758, 823},    {-32675, 2468},   {-32510, 4107},   {-32262, 5735},
      {-31933, 7349},   {-31524, 8944},   {-31035, 10517},  {-30467, 12063},  {-29822, 13578},  {-29102, 15060},
      {-28309, 16503},  {-27444, 17904},  {-26510, 19261},  {-25509, 20568},  {-24443, 21824},  {-23316, 23024},
      {-22129, 24167},  {-20887, 25248},  {-19592, 26266},  {-18248, 27217},  {-16857, 28099},  {-15424, 28911},
      {-13952, 29649},  {-12445, 30313},  {-10906, 30900},  {-9340, 31409},   {-7750, 31838},   {-6140, 32188},
      {-4515, 32455},   {-2879, 32641},   {-1235, 32745},   {412, 32765},     {2058, 32703},    {3698, 32559},
      {5329, 32332},    {6947, 32023},    {8547, 31634},    {10126, 31164},   {11679, 30616},   {13202, 29991},
      {14693, 29289},   {16146, 28514},   {17558, 27667},   {18926, 26750},   {20246, 25765},   {21515, 24715},
      {22730, 23603},   {23887, 22431},   {24984, 21203},   {26017, 19921},   {26986, 18588},   {27885, 17209},
      {28715, 15786},   {29472, 14323},   {30154, 12825},   {30760, 11293},   {31289, 9733},    {31739, 8149},
      {32108, 6544},    {32396, 4923},    {32603, 3289},    {32727, 1646},    {32767, 0},       {32727, -1646},
      {32603, -3289},   {32396, -4923},   {32108, -6544},   {31739, -8149},   {31289, -9733},   {30760, -11293}}},
    {{{32729, -1608},   {32610, -3212},   {32413, -4808},   {32138, -6393},   {31786, -7962},   {31357, -9512},
      {30853, -11039},  {30274, -12540},  {29622, -14010},  {28899, -15447},  {28106, -16846},  {27246, -18205},
      {26320, -19520},  {25330, -20788},  {24279, -22006},  {23170, -23170},  {22006, -24279},  {20788, -25330},
      {19520, -26320},  {18205, -27246},  {16846, -28106},  {15447, -28899},  {14010, -29622},  {12540, -30274},
      {11039, -30853},  {9512, -31357},   {7962, -31786},   {6393, -32138},   {4808, -32413},   {3212, -32610},
      {1608, -32729},   {0, -32768},      {-1608, -32729},  {-3212, -32610},  {-4808, -32413},  {-6393, -32138},
      {-7962, -31786},  {-9512, -31357},  {-11039, -30853}, {-12540, -30274}, {-14010, -29622}, {-15447, -28899},
      {-16846, -28106}, {-18205, -27246}, {-19520, -26320}, {-20788, -25330}, {-22006, -24279}, {-23170, -23170},
      {-24279, -22006}, {-25330, -20788}, {-26320, -19520}, {-27246, -18205}, {-28106, -16846}, {-28899, -15447},
      {-29622, -14010}, {-30274, -12540}, {-30853, -11039}, {-31357, -9512},  {-31786, -7962},  {-32138, -6393},
      {-32413, -4808},  {-32610, -3212},  {-32729, -1608},  {-32768, 0},      {-32729, 1608},   {-32610, 3212},
      {-32413, 4808},   {-32138, 6393},   {-31786, 7962},   {-31357, 9512},   {-30853, 11039},  {-30274, 12540},
      {-29622, 14010},  {-28899, 15447},  {-28106, 16846},  {-27246, 18205},  {-26320, 19520},  {-25330, 20788},
      {-24279, 22006},  {-23170, 23170},  {-22006, 24279},  {-20788, 25330},  {-19520, 26320},  {-18205, 27246},
      {-16846, 28106},  {-15447, 28899},  {-14010, 29622},  {-12540, 30274},  {-11039, 30853},  {-9512, 31357},
      {-7962, 31786},   {-6393, 32138},   {-4808, 32413},   {-3212, 32610},   {-1608, 32729},   {0, 32767},
      {1608, 32729},    {3212, 32610},    {4808, 32413},    {6393, 32138},    {7962, 31786},    {9512, 31357},
      {11039, 30853},   {12540, 30274},   {14010, 29622},   {15447, 28899},   {16846, 28106},   {18205, 27246},
      {19520, 26320},   {20788, 25330},   {22006, 24279},   {23170, 23170},   {24279, 22006},   {25330, 20788},
      {26320, 19520},   {27246, 18205},   {28106, 16846},   {28899, 15447},   {29622, 14010},   {30274, 12540},
      {30853, 11039},   {31357, 9512},    {31786, 7962},    {32138, 6393},    {32413, 4808},    {32610, 3212},
      {32729, 1608},    {32767, 0},       {32729, -1608},   {32610, -3212},   {32413, -4808},   {32138, -6393}}},
    {{{32733, -1525},   {32626, -3046},   {32449, -4560},   {32202, -6065},   {31885, -7557},   {31499, -9032},
      {31044, -10488},  {30523, -11921},  {29935, -13328},  {29283, -14706},  {28567, -16053},  {27789, -17364},
      {26951, -18638},  {26055, -19872},  {25102, -21063},  {24095, -22208},  {23035, -23305},  {21926, -24351},
      {20769, -25345},  {19568, -26284},  {18324, -27166},  {17040, -27989},  {15719, -28751},  {14365, -29452},
      {12979, -30088},  {11565, -30659},  {10126, -31164},  {8665, -31602},   {7185, -31971},   {5690, -32270},
      {4183, -32500},   {2666, -32659},   {1144, -32748},   {-381, -32766},   {-1905, -32713},  {-3425, -32588},
      {-4938, -32394},  {-6439, -32129},  {-7927, -31795},  {-9398, -31391},  {-10848, -30920}, {-12275, -30382},
      {-13675, -29778}, {-15046, -29109}, {-16384, -28378}, {-17687, -27585}, {-18951, -26732}, {-20174, -25822},
      {-21354, -24855}, {-22487, -23835}, {-23571, -22763}, {-24605, -21641}, {-25585, -20473}, {-26510, -19261},
      {-27377, -18006}, {-28185, -16713}, {-28932, -15384}, {-29617, -14021}, {-30237, -12628}, {-30792, -11207},
      {-31280, -9763},  {-31700, -8297},  {-32052, -6813},  {-32334, -5314},  {-32546, -3804},  {-32688, -2286},
      {-32759, -762},   {-32759, 762},    {-32688, 2286},   {-32546, 3804},   {-32334, 5314},   {-32052, 6813},
      {-31700, 8297},   {-31280, 9763},   {-30792, 11207},  {-30237, 12628},  {-29617, 14021},  {-28932, 15384},
      {-28185, 16713},  {-27377, 18006},  {-26510, 19261},  {-25585, 20473},  {-24605, 21641},  {-23571, 22763},
      {-22487, 23835},  {-21354, 24855},  {-20174, 25822},  {-18951, 26732},  {-17687, 27585},  {-16384, 28378},
      {-15046, 29109},  {-13675, 29778},  {-12275, 30382},  {-10848, 30920},  {-9398, 31391},   {-7927, 31795},
      {-6439, 32129},   {-4938, 32394},   {-3425, 32588},   {-1905, 32713},   {-381, 32766},    {1144, 32748},
      {2666, 32659},    {4183, 32500},    {5690, 32270},    {7185, 31971},    {8665, 31602},    {10126, 31164},
      {11565, 30659},   {12979, 30088},   {14365, 29452},   {15719, 28751},   {17040, 27989},   {18324, 27166},
      {19568, 26284},   {20769, 25345},   {21926, 24351},   {23035, 23305},   {24095, 22208},   {25102, 21063},
      {26055, 19872},   {26951, 18638},   {27789, 17364},   {28567, 16053},   {29283, 14706},   {29935, 13328},
      {30523, 11921},   {31044, 10488},   {31499, 9032},    {31885, 7557},    {32202, 6065},    {32449, 4560}}},
    {{{32737, -1429},   {32643, -2856},   {32488, -4277},   {32270, -5690},   {31991, -7092},   {31651, -8481},
      {31251, -9854},   {30792, -11207},  {30274, -12540},  {29698, -13848},  {29066, -15131},  {28378, -16384},
      {27636, -17606},  {26842, -18795},  {25997, -19948},  {25102, -21063},  {24159, -22138},  {23170, -23170},
      {22138, -24159},  {21063, -25102},  {19948, -25997},  {18795, -26842},  {17606, -27636},  {16384, -28378},
      {15131, -29066},  {13848, -29698},  {12540, -30274},  {11207, -30792},  {9854, -31251},   {8481, -31651},
      {7092, -31991},   {5690, -32270},   {4277, -32488},   {2856, -32643},   {1429, -32737},   {0, -32768},
      {-1429, -32737},  {-2856, -32643},  {-4277, -32488},  {-5690, -32270},  {-7092, -31991},  {-8481, -31651},
      {-9854, -31251},  {-11207, -30792}, {-12540, -30274}, {-13848, -29698}, {-15131, -29066}, {-16384, -28378},
      {-17606, -27636}, {-18795, -26842}, {-19948, -25997}, {-21063, -25102}, {-22138, -24159}, {-23170, -23170},
      {-24159, -22138}, {-25102, -21063}, {-25997, -19948}, {-26842, -18795}, {-27636, -17606}, {-28378, -16384},
      {-29066, -15131}, {-29698, -13848}, {-30274, -12540}, {-30792, -11207}, {-31251, -9854},  {-31651, -8481},
      {-31991, -7092},  {-32270, -5690},  {-32488, -4277},  {-32643, -2856},  {-32737, -1429},  {-32768, 0},
      {-32737, 1429},   {-32643, 2856},   {-32488, 4277},   {-32270, 5690},   {-31991, 7092},   {-31651, 8481},
      {-31251, 9854},   {-30792, 11207},  {-30274, 12540},  {-29698, 13848},  {-29066, 15131},  {-28378, 16384},
      {-27636, 17606},  {-26842, 18795},  {-25997, 19948},  {-25102, 21063},  {-24159, 22138},  {-23170, 23170},
      {-22138, 24159},  {-21063, 25102},  {-19948, 25997},  {-18795, 26842},  {-17606, 27636},  {-16384, 28378},
      {-15131, 29066},  {-13848, 29698},  {-12540, 30274},  {-11207, 30792},  {-9854, 31251},   {-8481, 31651},
      {-7092, 31991},   {-5690, 32270},   {-4277, 32488},   {-2856, 32643},   {-1429, 32737},   {0, 32767},
      {1429, 32737},    {2856, 32643},    {4277, 32488},    {5690, 32270},    {7092, 31991},    {8481, 31651},
      {9854, 31251},    {11207, 30792},   {12540, 30274},   {13848, 29698},   {15131, 29066},   {16384, 28378},
      {17606, 27636},   {18795, 26842},   {19948, 25997},   {21063, 25102},   {22138, 24159},   {23170, 23170},
      {24159, 22138},   {25102, 21063},   {25997, 19948},   {26842, 18795},   {27636, 17606},   {28378, 16384}}},
    {{{32739, -1372},   {32653, -2742},   {32510, -4107},   {32309, -5465},   {32052, -6813},   {31739, -8149},
      {31369, -9471},   {30945, -10776},  {30467, -12063},  {29935, -13328},  {29351, -14570},  {28715, -15786},
      {28029, -16975},  {27293, -18134},  {26510, -19261},  {25680, -20354},  {24805, -21411},  {23887, -22431},
      {22927, -23412},  {21926, -24351},  {20887, -25248},  {19812, -26101},  {18701, -26907},  {17558, -27667},
      {16384, -28378},  {15181, -29039},  {13952, -29649},  {12698, -30208},  {11422, -30713},  {10126, -31164},
      {8812, -31561},   {7483, -31902},   {6140, -32188},   {4787, -32416},   {3425, -32588},   {2058, -32703},
      {686, -32761},    {-686, -32761},   {-2058, -32703},  {-3425, -32588},  {-4787, -32416},  {-6140, -32188},
      {-7483, -31902},  {-8812, -31561},  {-10126, -31164}, {-11422, -30713}, {-12698, -30208}, {-13952, -29649},
      {-15181, -29039}, {-16384, -28378}, {-17558, -27667}, {-18701, -26907}, {-19812, -26101}, {-20887, -25248},
      {-21926, -24351}, {-22927, -23412}, {-23887, -22431}, {-24805, -21411}, {-25680, -20354}, {-26510, -19261},
      {-27293, -18134}, {-28029, -16975}, {-28715, -15786}, {-29351, -14570}, {-29935, -13328}, {-30467, -12063},
      {-30945, -10776}, {-31369, -9471},  {-31739, -8149},  {-32052, -6813},  {-32309, -5465},  {-32510, -4107},
      {-32653, -2742},  {-32739, -1372},  {-32768, 0},      {-32739, 1372},   {-32653, 2742},   {-32510, 4107},
      {-32309, 5465},   {-32052, 6813},   {-31739, 8149},   {-31369, 9471},   {-30945, 10776},  {-30467, 12063},
      {-29935, 13328},  {-29351, 14570},  {-28715, 15786},  {-28029, 16975},  {-27293, 18134},  {-26510, 19261},
      {-25680, 20354},  {-24805, 21411},  {-23887, 22431},  {-22927, 23412},  {-21926, 24351},  {-20887, 25248},
      {-19812, 26101},  {-18701, 26907},  {-17558, 27667},  {-16384, 28378},  {-15181, 29039},  {-13952, 29649},
      {-12698, 30208},  {-11422, 30713},  {-10126, 31164},  {-8812, 31561},   {-7483, 31902},   {-6140, 32188},
      {-4787, 32416},   {-3425, 32588},   {-2058, 32703},   {-686, 32761},    {686, 32761},     {2058, 32703},
      {3425, 32588},    {4787, 32416},    {6140, 32188},    {7483, 31902},    {8812, 31561},    {10126, 31164},
      {11422, 30713},   {12698, 30208},   {13952, 29649},   {15181, 29039},   {16384, 28378},   {17558, 27667},
      {18701, 26907},   {19812, 26101},   {20887, 25248},   {21926, 24351},   {22927, 23412},   {23887, 22431}}},
    {{{32743, -1286},   {32667, -2571},   {32541, -3851},   {32365, -5126},   {32138, -6393},   {31863, -7650},
      {31538, -8895},   {31164, -10126},  {30743, -11342},  {30274, -12540},  {29758, -13719},  {29197, -14876},
      {28590, -16011},  {27939, -17121},  {27246, -18205},  {26510, -19261},  {25733, -20286},  {24917, -21281},
      {24062, -22243},  {23170, -23170},  {22243, -24062},  {21281, -24917},  {20286, -25733},  {19261, -26510},
      {18205, -27246},  {17121, -27939},  {16011, -28590},  {14876, -29197},  {13719, -29758},  {12540, -30274},
      {11342, -30743},  {10126, -31164},  {8895, -31538},   {7650, -31863},   {6393, -32138},   {5126, -32365},
      {3851, -32541},   {2571, -32667},   {1286, -32743},   {0, -32768},      {-1286, -32743},  {-2571, -32667},
      {-3851, -32541},  {-5126, -32365},  {-6393, -32138},  {-7650, -31863},  {-8895, -31538},  {-10126, -31164},
      {-11342, -30743}, {-12540, -30274}, {-13719, -29758}, {-14876, -29197}, {-16011, -28590}, {-17121, -27939},
      {-18205, -27246}, {-19261, -26510}, {-20286, -25733}, {-21281, -24917}, {-22243, -24062}, {-23170, -23170},
      {-24062, -22243}, {-24917, -21281}, {-25733, -20286}, {-26510, -19261}, {-27246, -18205}, {-27939, -17121},
      {-28590, -16011}, {-29197, -14876}, {-29758, -13719}, {-30274, -12540}, {-30743, -11342}, {-31164, -10126},
      {-31538, -8895},  {-31863, -7650},  {-32138, -6393},  {-32365, -5126},  {-32541, -3851},  {-32667, -2571},
      {-32743, -1286},  {-32768, 0},      {-32743, 1286},   {-32667, 2571},   {-32541, 3851},   {-32365, 5126},
      {-32138, 6393},   {-31863, 7650},   {-31538, 8895},   {-31164, 10126},  {-30743, 11342},  {-30274, 12540},
      {-29758, 13719},  {-29197, 14876},  {-28590, 16011},  {-27939, 17121},  {-27246, 18205},  {-26510, 19261},
      {-25733, 20286},  {-24917, 21281},  {-24062, 22243},  {-23170, 23170},  {-22243, 24062},  {-21281, 24917},
      {-20286, 25733},  {-19261, 26510},  {-18205, 27246},  {-17121, 27939},  {-16011, 28590},  {-14876, 29197},
      {-13719, 29758},  {-12540, 30274},  {-11342, 30743},  {-10126, 31164},  {-8895, 31538},   {-7650, 31863},
      {-6393, 32138},   {-5126, 32365},   {-3851, 32541},   {-2571, 32667},   {-1286, 32743},   {0, 32767},
      {1286, 32743},    {2571, 32667},    {3851, 32541},    {5126, 32365},    {6393, 32138},    {7650, 31863},
      {8895, 31538},    {10126, 31164},   {11342, 30743},   {12540, 30274},   {13719, 29758},   {14876, 29197}}},
    {{{32743, -1271},   {32669, -2539},   {32546, -3804},   {32374, -5063},   {32154, -6315},   {31885, -7557},
      {31568, -8787},   {31203, -10005},  {30792, -11207},  {30334, -12393},  {29831, -13560},  {29283, -14706},
      {28690, -15831},  {28055, -16931},  {27377, -18006},  {26658, -19054},  {25900, -20074},  {25102, -21063},
      {24266, -22020},  {23394, -22945},  {22487, -23835},  {21546, -24689},  {20572, -25505},  {19568, -26284},
      {18534, -27023},  {17472, -27721},  {16384, -28378},  {15271, -28992},  {14136, -29562},  {12979, -30088},
      {11802, -30569},  {10608, -31003},  {9398, -31391},   {8174, -31732},   {6937, -32025},   {5690, -32270},
      {4435, -32467},   {3172, -32614},   {1905, -32713},   {635, -32762},    {-635, -32762},   {-1905, -32713},
      {-3172, -32614},  {-4435, -32467},  {-5690, -32270},  {-6937, -32025},  {-8174, -31732},  {-9398, -31391},
      {-10608, -31003}, {-11802, -30569}, {-12979, -30088}, {-14136, -29562}, {-15271, -28992}, {-16384, -28378},
      {-17472, -27721}, {-18534, -27023}, {-19568, -26284}, {-20572, -25505}, {-21546, -24689}, {-22487, -23835},
      {-23394, -22945}, {-24266, -22020}, {-25102, -21063}, {-25900, -20074}, {-26658, -19054}, {-27377, -18006},
      {-28055, -16931}, {-28690, -15831}, {-29283, -14706}, {-29831, -13560}, {-30334, -12393}, {-30792, -11207},
      {-31203, -10005}, {-31568, -8787},  {-31885, -7557},  {-32154, -6315},  {-32374, -5063},  {-32546, -3804},
      {-32669, -2539},  {-32743, -1271},  {-32768, 0},      {-32743, 1271},   {-32669, 2539},   {-32546, 3804},
      {-32374, 5063},   {-32154, 6315},   {-31885, 7557},   {-31568, 8787},   {-31203, 10005},  {-30792, 11207},
      {-30334, 12393},  {-29831, 13560},  {-29283, 14706},  {-28690, 15831},  {-28055, 16931},  {-27377, 18006},
      {-26658, 19054},  {-25900, 20074},  {-25102, 21063},  {-24266, 22020},  {-23394, 22945},  {-22487, 23835},
      {-21546, 24689},  {-20572, 25505},  {-19568, 26284},  {-18534, 27023},  {-17472, 27721},  {-16384, 28378},
      {-15271, 28992},  {-14136, 29562},  {-12979, 30088},  {-11802, 30569},  {-10608, 31003},  {-9398, 31391},
      {-8174, 31732},   {-6937, 32025},   {-5690, 32270},   {-4435, 32467},   {-3172, 32614},   {-1905, 32713},
      {-635, 32762},    {635, 32762},     {1905, 32713},    {3172, 32614},    {4435, 32467},    {5690, 32270},
      {6937, 32025},    {8174, 31732},    {9398, 31391},    {10608, 31003},   {11802, 30569},   {12979, 30088}}},
    {{{32748, -1144},   {32688, -2286},   {32588, -3425},   {32449, -4560},   {32270, -5690},   {32052, -6813},
      {31795, -7927},   {31499, -9032},   {31164, -10126},  {30792, -11207},  {30382, -12275},  {29935, -13328},
      {29452, -14365},  {28932, -15384},  {28378, -16384},  {27789, -17364},  {27166, -18324},  {26510, -19261},
      {25822, -20174},  {25102, -21063},  {24351, -21926},  {23571, -22763},  {22763, -23571},  {21926, -24351},
      {21063, -25102},  {20174, -25822},  {19261, -26510},  {18324, -27166},  {17364, -27789},  {16384, -28378},
      {15384, -28932},  {14365, -29452},  {13328, -29935},  {12275, -30382},  {11207, -30792},  {10126, -31164},
      {9032, -31499},   {7927, -31795},   {6813, -32052},   {5690, -32270},   {4560, -32449},   {3425, -32588},
      {2286, -32688},   {1144, -32748},   {0, -32768},      {-1144, -32748},  {-2286, -32688},  {-3425, -32588},
      {-4560, -32449},  {-5690, -32270},  {-6813, -32052},  {-7927, -31795},  {-9032, -31499},  {-10126, -31164},
      {-11207, -30792}, {-12275, -30382}, {-13328, -29935}, {-14365, -29452}, {-15384, -28932}, {-16384, -28378},
      {-17364, -27789}, {-18324, -27166}, {-19261, -26510}, {-20174, -25822}, {-21063, -25102}, {-21926, -24351},
      {-22763, -23571}, {-23571, -22763}, {-24351, -21926}, {-25102, -21063}, {-25822, -20174}, {-26510, -19261},
      {-27166, -18324}, {-27789, -17364}, {-28378, -16384}, {-28932, -15384}, {-29452, -14365}, {-29935, -13328},
      {-30382, -12275}, {-30792, -11207}, {-31164, -10126}, {-31499, -9032},  {-31795, -7927},  {-32052, -6813},
      {-32270, -5690},  {-32449, -4560},  {-32588, -3425},  {-32688, -2286},  {-32748, -1144},  {-32768, 0},
      {-32748, 1144},   {-32688, 2286},   {-32588, 3425},   {-32449, 4560},   {-32270, 5690},   {-32052, 6813},
      {-31795, 7927},   {-31499, 9032},   {-31164, 10126},  {-30792, 11207},  {-30382, 12275},  {-29935, 13328},
      {-29452, 14365},  {-28932, 15384},  {-28378, 16384},  {-27789, 17364},  {-27166, 18324},  {-26510, 19261},
      {-25822, 20174},  {-25102, 21063},  {-24351, 21926},  {-23571, 22763},  {-22763, 23571},  {-21926, 24351},
      {-21063, 25102},  {-20174, 25822},  {-19261, 26510},  {-18324, 27166},  {-17364, 27789},  {-16384, 28378},
      {-15384, 28932},  {-14365, 29452},  {-13328, 29935},  {-12275, 30382},  {-11207, 30792},  {-10126, 31164},
      {-9032, 31499},   {-7927, 31795},   {-6813, 32052},   {-5690, 32270},   {-4560, 32449},   {-3425, 32588}}},
    {{{32750, -1098},   {32694, -2194},   {32603, -3289},   {32474, -4379},   {32309, -5465},   {32108, -6544},
      {31871, -7616},   {31598, -8680},   {31289, -9733},   {30945, -10776},  {30567, -11807},  {30154, -12825},
      {29708, -13828},  {29228, -14815},  {28715, -15786},  {28170, -16739},  {27593, -17674},  {26986, -18588},
      {26348, -19482},  {25680, -20354},  {24984, -21203},  {24259, -22028},  {23508, -22828},  {22730, -23603},
      {21926, -24351},  {21098, -25072},  {20246, -25765},  {19371, -26429},  {18475, -27063},  {17558, -27667},
      {16621, -28240},  {15666, -28781},  {14693, -29289},  {13703, -29765},  {12698, -30208},  {11679, -30616},
      {10647, -30990},  {9602, -31329},   {8547, -31634},   {7483, -31902},   {6410, -32135},   {5329, -32332},
      {4243, -32492},   {3152, -32616},   {2058, -32703},   {961, -32754},    {-137, -32768},   {-1235, -32745},
      {-2331, -32685},  {-3425, -32588},  {-4515, -32455},  {-5600, -32286},  {-6679, -32080},  {-7750, -31838},
      {-8812, -31561},  {-9864, -31248},  {-10906, -30900}, {-11935, -30517}, {-12951, -30100}, {-13952, -29649},
      {-14937, -29165}, {-15906, -28648}, {-16857, -28099}, {-17789, -27519}, {-18701, -26907}, {-19592, -26266},
      {-20461, -25595}, {-21307, -24895}, {-22129, -24167}, {-22927, -23412}, {-23698, -22631}, {-24443, -21824},
      {-25160, -20993}, {-25850, -20138}, {-26510, -19261}, {-27140, -18362}, {-27740, -17442}, {-28309, -16503},
      {-28846, -15545}, {-29351, -14570}, {-29822, -13578}, {-30261, -12571}, {-30665, -11551}, {-31035, -10517},
      {-31369, -9471},  {-31669, -8415},  {-31933, -7349},  {-32162, -6275},  {-32354, -5194},  {-32510, -4107},
      {-32629, -3015},  {-32712, -1921},  {-32758, -823},   {-32767, 275},    {-32739, 1372},   {-32675, 2468},
      {-32574, 3562},   {-32436, 4651},   {-32262, 5735},   {-32052, 6813},   {-31806, 7883},   {-31524, 8944},
      {-31206, 9995},   {-30854, 11035},  {-30467, 12063},  {-30046, 13077},  {-29591, 14076},  {-29102, 15060},
      {-28582, 16026},  {-28029, 16975},  {-27444, 17904},  {-26829, 18814},  {-26183, 19702},  {-25509, 20568},
      {-24805, 21411},  {-24074, 22230},  {-23316, 23024},  {-22531, 23793},  {-21721, 24534},  {-20887, 25248},
      {-20029, 25934},  {-19149, 26590},  {-18248, 27217},  {-17326, 27813},  {-16384, 28378},  {-15424, 28911},
      {-14447, 29411},  {-13453, 29879},  {-12445, 30313},  {-11422, 30713},  {-10387, 31078},  {-9340, 31409}}},
    {{{32750, -1072},   {32698, -2143},   {32610, -3212},   {32488, -4277},   {32330, -5338},   {32138, -6393},
      {31912, -7441},   {31651, -8481},   {31357, -9512},   {31029, -10533},  {30668, -11543},  {30274, -12540},
      {29847, -13524},  {29389, -14493},  {28899, -15447},  {28378, -16384},  {27827, -17304},  {27246, -18205},
      {26635, -19087},  {25997, -19948},  {25330, -20788},  {24636, -21605},  {23916, -22400},  {23170, -23170},
      {22400, -23916},  {21605, -24636},  {20788, -25330},  {19948, -25997},  {19087, -26635},  {18205, -27246},
      {17304, -27827},  {16384, -28378},  {15447, -28899},  {14493, -29389},  {13524, -29847},  {12540, -30274},
      {11543, -30668},  {10533, -31029},  {9512, -31357},   {8481, -31651},   {7441, -31912},   {6393, -32138},
      {5338, -32330},   {4277, -32488},   {3212, -32610},   {2143, -32698},   {1072, -32750},   {0, -32768},
      {-1072, -32750},  {-2143, -32698},  {-3212, -32610},  {-4277, -32488},  {-5338, -32330},  {-6393, -32138},
      {-7441, -31912},  {-8481, -31651},  {-9512, -31357},  {-10533, -31029}, {-11543, -30668}, {-12540, -30274},
      {-13524, -29847}, {-14493, -29389}, {-15447, -28899}, {-16384, -28378}, {-17304, -27827}, {-18205, -27246},
      {-19087, -26635}, {-19948, -25997}, {-20788, -25330}, {-21605, -24636}, {-22400, -23916}, {-23170, -23170},
      {-23916, -22400}, {-24636, -21605}, {-25330, -20788}, {-25997, -19948}, {-26635, -19087}, {-27246, -18205},
      {-27827, -17304}, {-28378, -16384}, {-28899, -15447}, {-29389, -14493}, {-29847, -13524}, {-30274, -12540},
      {-30668, -11543}, {-31029, -10533}, {-31357, -9512},  {-31651, -8481},  {-31912, -7441},  {-32138, -6393},
      {-32330, -5338},  {-32488, -4277},  {-32610, -3212},  {-32698, -2143},  {-32750, -1072},  {-32768, 0},
      {-32750, 1072},   {-32698, 2143},   {-32610, 3212},   {-32488, 4277},   {-32330, 5338},   {-32138, 6393},
      {-31912, 7441},   {-31651, 8481},   {-31357, 9512},   {-31029, 10533},  {-30668, 11543},  {-30274, 12540},
      {-29847, 13524},  {-29389, 14493},  {-28899, 15447},  {-28378, 16384},  {-27827, 17304},  {-27246, 18205},
      {-26635, 19087},  {-25997, 19948},  {-25330, 20788},  {-24636, 21605},  {-23916, 22400},  {-23170, 23170},
      {-22400, 23916},  {-21605, 24636},  {-20788, 25330},  {-19948, 25997},  {-19087, 26635},  {-18205, 27246},
      {-17304, 27827},  {-16384, 28378},  {-15447, 28899},  {-14493, 29389},  {-13524, 29847},  {-12540, 30274}}},
    {{{32752, -1029},   {32703, -2058},   {32623, -3084},   {32510, -4107},   {32365, -5126},   {32188, -6140},
      {31979, -7148},   {31739, -8149},   {31467, -9142},   {31164, -10126},  {30831, -11100},  {30467, -12063},
      {30073, -13014},  {29649, -13952},  {29197, -14876},  {28715, -15786},  {28205, -16680},  {27667, -17558},
      {27102, -18418},  {26510, -19261},  {25892, -20084},  {25248, -20887},  {24580, -21670},  {23887, -22431},
      {23170, -23170},  {22431, -23887},  {21670, -24580},  {20887, -25248},  {20084, -25892},  {19261, -26510},
      {18418, -27102},  {17558, -27667},  {16680, -28205},  {15786, -28715},  {14876, -29197},  {13952, -29649},
      {13014, -30073},  {12063, -30467},  {11100, -30831},  {10126, -31164},  {9142, -31467},   {8149, -31739},
      {7148, -31979},   {6140, -32188},   {5126, -32365},   {4107, -32510},   {3084, -32623},   {2058, -32703},
      {1029, -32752},   {0, -32768},      {-1029, -32752},  {-2058, -32703},  {-3084, -32623},  {-4107, -32510},
      {-5126, -32365},  {-6140, -32188},  {-7148, -31979},  {-8149, -31739},  {-9142, -31467},  {-10126, -31164},
      {-11100, -30831}, {-12063, -30467}, {-13014, -30073}, {-13952, -29649}, {-14876, -29197}, {-15786, -28715},
      {-16680, -28205}, {-17558, -27667}, {-18418, -27102}, {-19261, -26510}, {-20084, -25892}, {-20887, -25248},
      {-21670, -24580}, {-22431, -23887}, {-23170, -23170}, {-23887, -22431}, {-24580, -21670}, {-25248, -20887},
      {-25892, -20084}, {-26510, -19261}, {-27102, -18418}, {-27667, -17558}, {-28205, -16680}, {-28715, -15786},
      {-29197, -14876}, {-29649, -13952}, {-30073, -13014}, {-30467, -12063}, {-30831, -11100}, {-31164, -10126},
      {-31467, -9142},  {-31739, -8149},  {-31979, -7148},  {-32188, -6140},  {-32365, -5126},  {-32510, -4107},
      {-32623, -3084},  {-32703, -2058},  {-32752, -1029},  {-32768, 0},      {-32752, 1029},   {-32703, 2058},
      {-32623, 3084},   {-32510, 4107},   {-32365, 5126},   {-32188, 6140},   {-31979, 7148},   {-31739, 8149},
      {-31467, 9142},   {-31164, 10126},  {-30831, 11100},  {-30467, 12063},  {-30073, 13014},  {-29649, 13952},
      {-29197, 14876},  {-28715, 15786},  {-28205, 16680},  {-27667, 17558},  {-27102, 18418},  {-26510, 19261},
      {-25892, 20084},  {-25248, 20887},  {-24580, 21670},  {-23887, 22431},  {-23170, 23170},  {-22431, 23887},
      {-21670, 24580},  {-20887, 25248},  {-20084, 25892},  {-19261, 26510},  {-18418, 27102},  {-17558, 27667}}},
    {{{32752, -1017},   {32705, -2032},   {32626, -3046},   {32516, -4056},   {32374, -5063},   {32202, -6065},
      {31998, -7061},   {31764, -8051},   {31499, -9032},   {31203, -10005},  {30878, -10968},  {30523, -11921},
      {30138, -12862},  {29725, -13791},  {29283, -14706},  {28812, -15608},  {28314, -16494},  {27789, -17364},
      {27237, -18218},  {26658, -19054},  {26055, -19872},  {25425, -20671},  {24772, -21450},  {24095, -22208},
      {23394, -22945},  {22671, -23659},  {21926, -24351},  {21160, -25020},  {20374, -25664},  {19568, -26284},
      {18743, -26878},  {17900, -27447},  {17040, -27989},  {16163, -28504},  {15271, -28992},  {14365, -29452},
      {13444, -29883},  {12510, -30286},  {11565, -30659},  {10608, -31003},  {9641, -31318},   {8665, -31602},
      {7680, -31855},   {6688, -32078},   {5690, -32270},   {4686, -32431},   {3678, -32561},   {2666, -32659},
      {1651, -32726},   {635, -32762},    {-381, -32766},   {-1398, -32738},  {-2413, -32679},  {-3425, -32588},
      {-4435, -32467},  {-5440, -32313},  {-6439, -32129},  {-7433, -31914},  {-8420, -31668},  {-9398, -31391},
      {-10367, -31085}, {-11327, -30748}, {-12275, -30382}, {-13212, -29987}, {-14136, -29562}, {-15046, -29109},
      {-15942, -28629}, {-16822, -28120}, {-17687, -27585}, {-18534, -27023}, {-19363, -26435}, {-20174, -25822},
      {-20965, -25183}, {-21737, -24521}, {-22487, -23835}, {-23215, -23125}, {-23922, -22394}, {-24605, -21641},
      {-25264, -20868}, {-25900, -20074}, {-26510, -19261}, {-27095, -18429}, {-27653, -17579}, {-28185, -16713},
      {-28690, -15831}, {-29168, -14933}, {-29617, -14021}, {-30038, -13095}, {-30429, -12157}, {-30792, -11207},
      {-31125, -10247}, {-31428, -9276},  {-31700, -8297},  {-31942, -7309},  {-32154, -6315},  {-32334, -5314},
      {-32484, -4309},  {-32602, -3299},  {-32688, -2286},  {-32743, -1271},  {-32767, -254},   {-32759, 762},
      {-32720, 1778},   {-32649, 2793},   {-32546, 3804},   {-32413, 4812},   {-32248, 5815},   {-32052, 6813},
      {-31825, 7804},   {-31568, 8787},   {-31280, 9763},   {-30962, 10728},  {-30614, 11684},  {-30237, 12628},
      {-29831, 13560},  {-29396, 14479},  {-28932, 15384},  {-28441, 16274},  {-27923, 17148},  {-27377, 18006},
      {-26805, 18847},  {-26208, 19669},  {-25585, 20473},  {-24938, 21257},  {-24266, 22020},  {-23571, 22763},
      {-22854, 23483},  {-22114, 24181},  {-21354, 24855},  {-20572, 25505},  {-19771, 26131},  {-18951, 26732}}},
}};

const std::array<std::array<cfloat, kFanVectorLength_cfloat>, kNumValidPointSizes> sincosLUTcfloat_fan8 = {{
    {{{32767, 0},
      {23170, -23170},
      {0, -32768},
      {-23170, -23170},
      {-32768, 0},
      {-23170, 23170},
      {0, 32767},
      {23170, 23170}}},
    {{{-32768, 0},
      {30274, -12540},
      {23170, -23170},
      {12540, -30274},
      {0, -32768},
      {-12540, -30274},
      {-23170, -23170},
      {-30274, -12540}}},
    {{{-16384, -28378},
      {31651, -8481},
      {28378, -16384},
      {23170, -23170},
      {16384, -28378},
      {8481, -31651},
      {0, -32768},
      {-8481, -31651}}},
    {{{0, -32768},
      {32138, -6393},
      {30274, -12540},
      {27246, -18205},
      {23170, -23170},
      {18205, -27246},
      {12540, -30274},
      {6393, -32138}}},
    {{{10126, -31164},
      {32365, -5126},
      {31164, -10126},
      {29197, -14876},
      {26510, -19261},
      {23170, -23170},
      {19261, -26510},
      {14876, -29197}}},
    {{{16384, -28378},
      {32488, -4277},
      {31651, -8481},
      {30274, -12540},
      {28378, -16384},
      {25997, -19948},
      {23170, -23170},
      {19948, -25997}}},
    {{{23170, -23170},
      {32610, -3212},
      {32138, -6393},
      {31357, -9512},
      {30274, -12540},
      {28899, -15447},
      {27246, -18205},
      {25330, -20788}}},
    {{{25102, -21063},
      {32643, -2856},
      {32270, -5690},
      {31651, -8481},
      {30792, -11207},
      {29698, -13848},
      {28378, -16384},
      {26842, -18795}}},
    {{{26510, -19261},
      {32667, -2571},
      {32365, -5126},
      {31863, -7650},
      {31164, -10126},
      {30274, -12540},
      {29197, -14876},
      {27939, -17121}}},
    {{{28378, -16384},
      {32698, -2143},
      {32488, -4277},
      {32138, -6393},
      {31651, -8481},
      {31029, -10533},
      {30274, -12540},
      {29389, -14493}}},
    {{{29935, -13328},
      {32723, -1715},
      {32588, -3425},
      {32365, -5126},
      {32052, -6813},
      {31651, -8481},
      {31164, -10126},
      {30592, -11743}}},
    {{{30274, -12540},
      {32729, -1608},
      {32610, -3212},
      {32413, -4808},
      {32138, -6393},
      {31786, -7962},
      {31357, -9512},
      {30853, -11039}}},
    {{{30792, -11207},
      {32737, -1429},
      {32643, -2856},
      {32488, -4277},
      {32270, -5690},
      {31991, -7092},
      {31651, -8481},
      {31251, -9854}}},
    {{{31164, -10126},
      {32743, -1286},
      {32667, -2571},
      {32541, -3851},
      {32365, -5126},
      {32138, -6393},
      {31863, -7650},
      {31538, -8895}}},
    {{{31651, -8481},
      {32750, -1072},
      {32698, -2143},
      {32610, -3212},
      {32488, -4277},
      {32330, -5338},
      {32138, -6393},
      {31912, -7441}}},
    {{{31739, -8149},
      {32752, -1029},
      {32703, -2058},
      {32623, -3084},
      {32510, -4107},
      {32365, -5126},
      {32188, -6140},
      {31979, -7148}}},
    {{{31885, -7557},
      {32754, -953},
      {32713, -1905},
      {32643, -2856},
      {32546, -3804},
      {32422, -4749},
      {32270, -5690},
      {32091, -6626}}},
    {{{32052, -6813},
      {32757, -858},
      {32723, -1715},
      {32667, -2571},
      {32588, -3425},
      {32488, -4277},
      {32365, -5126},
      {32219, -5971}}},
    {{{32138, -6393},
      {32758, -804},
      {32729, -1608},
      {32679, -2411},
      {32610, -3212},
      {32522, -4011},
      {32413, -4808},
      {32286, -5602}}},
    {{{32270, -5690},
      {32760, -715},
      {32737, -1429},
      {32698, -2143},
      {32643, -2856},
      {32573, -3567},
      {32488, -4277},
      {32387, -4985}}},
    {{{32365, -5126},
      {32762, -643},
      {32743, -1286},
      {32711, -1929},
      {32667, -2571},
      {32610, -3212},
      {32541, -3851},
      {32459, -4490}}},
    {{{32449, -4560},
      {32763, -572},
      {32748, -1144},
      {32723, -1715},
      {32688, -2286},
      {32643, -2856},
      {32588, -3425},
      {32524, -3993}}},
    {{{32488, -4277},
      {32764, -536},
      {32750, -1072},
      {32729, -1608},
      {32698, -2143},
      {32658, -2678},
      {32610, -3212},
      {32553, -3745}}},
    {{{32510, -4107},
      {32764, -515},
      {32752, -1029},
      {32732, -1544},
      {32703, -2058},
      {32667, -2571},
      {32623, -3084},
      {32570, -3596}}},
    {{{32546, -3804},
      {32765, -477},
      {32754, -953},
      {32737, -1429},
      {32713, -1905},
      {32681, -2381},
      {32643, -2856},
      {32598, -3330}}},
    {{{32588, -3425},
      {32765, -429},
      {32757, -858},
      {32743, -1286},
      {32723, -1715},
      {32698, -2143},
      {32667, -2571},
      {32631, -2998}}},
    {{{32610, -3212},
      {32766, -402},
      {32758, -804},
      {32746, -1206},
      {32729, -1608},
      {32706, -2009},
      {32679, -2411},
      {32647, -2811}}},
    {{{32643, -2856},
      {32766, -357},
      {32760, -715},
      {32750, -1072},
      {32737, -1429},
      {32719, -1786},
      {32698, -2143},
      {32673, -2500}}},
    {{{32653, -2742},
      {32766, -343},
      {32761, -686},
      {32752, -1029},
      {32739, -1372},
      {32723, -1715},
      {32703, -2058},
      {32680, -2400}}},
    {{{32667, -2571},
      {32766, -322},
      {32762, -643},
      {32754, -965},
      {32743, -1286},
      {32729, -1608},
      {32711, -1929},
      {32691, -2250}}},
    {{{32669, -2539},
      {32766, -318},
      {32762, -635},
      {32754, -953},
      {32743, -1271},
      {32729, -1588},
      {32713, -1905},
      {32693, -2222}}},
    {{{32688, -2286},
      {32767, -286},
      {32763, -572},
      {32757, -858},
      {32748, -1144},
      {32737, -1429},
      {32723, -1715},
      {32707, -2000}}},
    {{{32698, -2143},
      {32767, -268},
      {32764, -536},
      {32758, -804},
      {32750, -1072},
      {32741, -1340},
      {32729, -1608},
      {32714, -1876}}},
    {{{32703, -2058},
      {32767, -257},
      {32764, -515},
      {32759, -772},
      {32752, -1029},
      {32743, -1286},
      {32732, -1544},
      {32718, -1801}}},
    {{{32713, -1905},
      {32767, -238},
      {32765, -477},
      {32760, -715},
      {32754, -953},
      {32746, -1191},
      {32737, -1429},
      {32726, -1667}}},
    {{{32723, -1715},
      {32767, -214},
      {32765, -429},
      {32762, -643},
      {32757, -858},
      {32750, -1072},
      {32743, -1286},
      {32734, -1501}}},
    {{{32727, -1646},
      {32767, -206},
      {32765, -412},
      {32762, -618},
      {32758, -823},
      {32752, -1029},
      {32745, -1235},
      {32736, -1441}}},
    {{{32729, -1608},
      {32767, -201},
      {32766, -402},
      {32762, -603},
      {32758, -804},
      {32753, -1005},
      {32746, -1206},
      {32738, -1407}}},
    {{{32733, -1525},
      {32767, -191},
      {32766, -381},
      {32763, -572},
      {32759, -762},
      {32754, -953},
      {32748, -1144},
      {32741, -1334}}},
    {{{32737, -1429},
      {32767, -179},
      {32766, -357},
      {32764, -536},
      {32760, -715},
      {32756, -893},
      {32750, -1072},
      {32744, -1251}}},
    {{{32739, -1372},
      {32767, -172},
      {32766, -343},
      {32764, -515},
      {32761, -686},
      {32757, -858},
      {32752, -1029},
      {32746, -1201}}},
    {{{32743, -1286},
      {32767, -161},
      {32766, -322},
      {32764, -483},
      {32762, -643},
      {32758, -804},
      {32754, -965},
      {32749, -1126}}},
    {{{32743, -1271},
      {32767, -159},
      {32766, -318},
      {32765, -477},
      {32762, -635},
      {32758, -794},
      {32754, -953},
      {32749, -1112}}},
    {{{32748, -1144},
      {32767, -143},
      {32767, -286},
      {32765, -429},
      {32763, -572},
      {32760, -715},
      {32757, -858},
      {32753, -1001}}},
    {{{32750, -1072},
      {32767, -134},
      {32767, -268},
      {32766, -402},
      {32764, -536},
      {32761, -670},
      {32758, -804},
      {32755, -938}}},
    {{{32752, -1029},
      {32767, -129},
      {32767, -257},
      {32766, -386},
      {32764, -515},
      {32762, -643},
      {32759, -772},
      {32756, -901}}},
    {{{32754, -953},
      {32767, -119},
      {32767, -238},
      {32766, -357},
      {32765, -477},
      {32763, -596},
      {32760, -715},
      {32757, -834}}},
    {{{32755, -915},
      {32767, -114},
      {32767, -229},
      {32766, -343},
      {32765, -458},
      {32763, -572},
      {32761, -686},
      {32758, -801}}},
    {{{32757, -858},
      {32767, -107},
      {32767, -214},
      {32766, -322},
      {32765, -429},
      {32764, -536},
      {32762, -643},
      {32759, -751}}},
    {{{32757, -847},
      {32767, -106},
      {32767, -212},
      {32766, -318},
      {32765, -424},
      {32764, -530},
      {32762, -635},
      {32760, -741}}},
    {{{32758, -823},
      {32767, -103},
      {32767, -206},
      {32767, -309},
      {32765, -412},
      {32764, -515},
      {32762, -618},
      {32760, -721}}},
    {{{32758, -804},
      {32767, -101},
      {32767, -201},
      {32767, -302},
      {32766, -402},
      {32764, -503},
      {32762, -603},
      {32760, -704}}},
    {{{32759, -762},
      {32767, -95},
      {32767, -191},
      {32767, -286},
      {32766, -381},
      {32765, -477},
      {32763, -572},
      {32761, -667}}},
    {{{32760, -715},
      {32767, -89},
      {32767, -179},
      {32767, -268},
      {32766, -357},
      {32765, -447},
      {32764, -536},
      {32762, -625}}},
    {{{32761, -686},
      {32767, -86},
      {32767, -172},
      {32767, -257},
      {32766, -343},
      {32765, -429},
      {32764, -515},
      {32762, -600}}},
    {{{32762, -643},
      {32767, -80},
      {32767, -161},
      {32767, -241},
      {32766, -322},
      {32766, -402},
      {32764, -483},
      {32763, -563}}},
    {{{32762, -635},
      {32767, -79},
      {32767, -159},
      {32767, -238},
      {32766, -318},
      {32766, -397},
      {32765, -477},
      {32763, -556}}},
    {{{32763, -572},
      {32767, -71},
      {32767, -143},
      {32767, -214},
      {32767, -286},
      {32766, -357},
      {32765, -429},
      {32764, -500}}},
    {{{32763, -549},
      {32767, -69},
      {32767, -137},
      {32767, -206},
      {32767, -275},
      {32766, -343},
      {32765, -412},
      {32764, -480}}},
    {{{32764, -536},
      {32767, -67},
      {32767, -134},
      {32767, -201},
      {32767, -268},
      {32766, -335},
      {32766, -402},
      {32765, -469}}},
    {{{32764, -515},
      {32767, -64},
      {32767, -129},
      {32767, -193},
      {32767, -257},
      {32766, -322},
      {32766, -386},
      {32765, -450}}},
    {{{32764, -508},
      {32767, -64},
      {32767, -127},
      {32767, -191},
      {32767, -254},
      {32766, -318},
      {32766, -381},
      {32765, -445}}},
}};

const std::array<std::array<cfloat, kStepVectorLength_cfloat>, kNumValidPointSizes> sincosLUTcfloat_step8 = {{
    {{{32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0}, {32767, 0},
      {32767, 0}, {32767, 0}, {32767, 0}}},
    {{{-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0},
      {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0},
      {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0},
      {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0},
      {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0},
      {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0},
      {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0},
      {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0}, {-32768, 0}, {32767, 0},
      {-32768, 0}, {32767, 0}}},
    {{{-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0},
      {-16384, -28378}, {-16384, 28378}, {32767, 0}, {-16384, -28378}, {-16384, 28378}, {32767, 0}}},
    {{{0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0}, {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0},
      {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0}, {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0},
      {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0}, {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0},
      {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0}, {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0},
      {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0}, {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0},
      {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0}, {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0},
      {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0}, {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0},
      {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0}, {0, -32768}, {-32768, 0}, {0, 32767}, {32767, 0},
      {0, -32768}, {-32768, 0}}},
    {{{10126, -31164},  {-26510, -19261}, {-26510, 19261},  {10126, 31164},   {32767, 0},       {10126, -31164},
      {-26510, -19261}, {-26510, 19261},  {10126, 31164},   {32767, 0},       {10126, -31164},  {-26510, -19261},
      {-26510, 19261},  {10126, 31164},   {32767, 0},       {10126, -31164},  {-26510, -19261}, {-26510, 19261},
      {10126, 31164},   {32767, 0},       {10126, -31164},  {-26510, -19261}, {-26510, 19261},  {10126, 31164},
      {32767, 0},       {10126, -31164},  {-26510, -19261}, {-26510, 19261},  {10126, 31164},   {32767, 0},
      {10126, -31164},  {-26510, -19261}, {-26510, 19261},  {10126, 31164},   {32767, 0},       {10126, -31164},
      {-26510, -19261}, {-26510, 19261},  {10126, 31164},   {32767, 0},       {10126, -31164},  {-26510, -19261},
      {-26510, 19261},  {10126, 31164},   {32767, 0},       {10126, -31164},  {-26510, -19261}, {-26510, 19261},
      {10126, 31164},   {32767, 0},       {10126, -31164},  {-26510, -19261}, {-26510, 19261},  {10126, 31164},
      {32767, 0},       {10126, -31164},  {-26510, -19261}, {-26510, 19261},  {10126, 31164},   {32767, 0},
      {10126, -31164},  {-26510, -19261}, {-26510, 19261},  {10126, 31164},   {32767, 0},       {10126, -31164}}},
    {{{16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0},
      {16384, -28378}, {-16384, -28378}, {-32768, 0}, {-16384, 28378}, {16384, 28378}, {32767, 0}}},
    {{{23170, -23170},  {0, -32768}, {-23170, -23170}, {-32768, 0}, {-23170, 23170},  {0, 32767},
      {23170, 23170},   {32767, 0},  {23170, -23170},  {0, -32768}, {-23170, -23170}, {-32768, 0},
      {-23170, 23170},  {0, 32767},  {23170, 23170},   {32767, 0},  {23170, -23170},  {0, -32768},
      {-23170, -23170}, {-32768, 0}, {-23170, 23170},  {0, 32767},  {23170, 23170},   {32767, 0},
      {23170, -23170},  {0, -32768}, {-23170, -23170}, {-32768, 0}, {-23170, 23170},  {0, 32767},
      {23170, 23170},   {32767, 0},  {23170, -23170},  {0, -32768}, {-23170, -23170}, {-32768, 0},
      {-23170, 23170},  {0, 32767},  {23170, 23170},   {32767, 0},  {23170, -23170},  {0, -32768},
      {-23170, -23170}, {-32768, 0}, {-23170, 23170},  {0, 32767},  {23170, 23170},   {32767, 0},
      {23170, -23170},  {0, -32768}, {-23170, -23170}, {-32768, 0}, {-23170, 23170},  {0, 32767},
      {23170, 23170},   {32767, 0},  {23170, -23170},  {0, -32768}, {-23170, -23170}, {-32768, 0},
      {-23170, 23170},  {0, 32767},  {23170, 23170},   {32767, 0},  {23170, -23170},  {0, -32768}}},
    {{{25102, -21063},  {5690, -32270},  {-16384, -28378}, {-30792, -11207}, {-30792, 11207}, {-16384, 28378},
      {5690, 32270},    {25102, 21063},  {32767, 0},       {25102, -21063},  {5690, -32270},  {-16384, -28378},
      {-30792, -11207}, {-30792, 11207}, {-16384, 28378},  {5690, 32270},    {25102, 21063},  {32767, 0},
      {25102, -21063},  {5690, -32270},  {-16384, -28378}, {-30792, -11207}, {-30792, 11207}, {-16384, 28378},
      {5690, 32270},    {25102, 21063},  {32767, 0},       {25102, -21063},  {5690, -32270},  {-16384, -28378},
      {-30792, -11207}, {-30792, 11207}, {-16384, 28378},  {5690, 32270},    {25102, 21063},  {32767, 0},
      {25102, -21063},  {5690, -32270},  {-16384, -28378}, {-30792, -11207}, {-30792, 11207}, {-16384, 28378},
      {5690, 32270},    {25102, 21063},  {32767, 0},       {25102, -21063},  {5690, -32270},  {-16384, -28378},
      {-30792, -11207}, {-30792, 11207}, {-16384, 28378},  {5690, 32270},    {25102, 21063},  {32767, 0},
      {25102, -21063},  {5690, -32270},  {-16384, -28378}, {-30792, -11207}, {-30792, 11207}, {-16384, 28378},
      {5690, 32270},    {25102, 21063},  {32767, 0},       {25102, -21063},  {5690, -32270},  {-16384, -28378}}},
    {{{26510, -19261},  {10126, -31164},  {-10126, -31164}, {-26510, -19261}, {-32768, 0},      {-26510, 19261},
      {-10126, 31164},  {10126, 31164},   {26510, 19261},   {32767, 0},       {26510, -19261},  {10126, -31164},
      {-10126, -31164}, {-26510, -19261}, {-32768, 0},      {-26510, 19261},  {-10126, 31164},  {10126, 31164},
      {26510, 19261},   {32767, 0},       {26510, -19261},  {10126, -31164},  {-10126, -31164}, {-26510, -19261},
      {-32768, 0},      {-26510, 19261},  {-10126, 31164},  {10126, 31164},   {26510, 19261},   {32767, 0},
      {26510, -19261},  {10126, -31164},  {-10126, -31164}, {-26510, -19261}, {-32768, 0},      {-26510, 19261},
      {-10126, 31164},  {10126, 31164},   {26510, 19261},   {32767, 0},       {26510, -19261},  {10126, -31164},
      {-10126, -31164}, {-26510, -19261}, {-32768, 0},      {-26510, 19261},  {-10126, 31164},  {10126, 31164},
      {26510, 19261},   {32767, 0},       {26510, -19261},  {10126, -31164},  {-10126, -31164}, {-26510, -19261},
      {-32768, 0},      {-26510, 19261},  {-10126, 31164},  {10126, 31164},   {26510, 19261},   {32767, 0},
      {26510, -19261},  {10126, -31164},  {-10126, -31164}, {-26510, -19261}, {-32768, 0},      {-26510, 19261}}},
    {{{28378, -16384}, {16384, -28378}, {0, -32768}, {-16384, -28378}, {-28378, -16384}, {-32768, 0},
      {-28378, 16384}, {-16384, 28378}, {0, 32767},  {16384, 28378},   {28378, 16384},   {32767, 0},
      {28378, -16384}, {16384, -28378}, {0, -32768}, {-16384, -28378}, {-28378, -16384}, {-32768, 0},
      {-28378, 16384}, {-16384, 28378}, {0, 32767},  {16384, 28378},   {28378, 16384},   {32767, 0},
      {28378, -16384}, {16384, -28378}, {0, -32768}, {-16384, -28378}, {-28378, -16384}, {-32768, 0},
      {-28378, 16384}, {-16384, 28378}, {0, 32767},  {16384, 28378},   {28378, 16384},   {32767, 0},
      {28378, -16384}, {16384, -28378}, {0, -32768}, {-16384, -28378}, {-28378, -16384}, {-32768, 0},
      {-28378, 16384}, {-16384, 28378}, {0, 32767},  {16384, 28378},   {28378, 16384},   {32767, 0},
      {28378, -16384}, {16384, -28378}, {0, -32768}, {-16384, -28378}, {-28378, -16384}, {-32768, 0},
      {-28378, 16384}, {-16384, 28378}, {0, 32767},  {16384, 28378},   {28378, 16384},   {32767, 0},
      {28378, -16384}, {16384, -28378}, {0, -32768}, {-16384, -28378}, {-28378, -16384}, {-32768, 0}}},
    {{{29935, -13328}, {21926, -24351},  {10126, -31164},  {-3425, -32588}, {-16384, -28378}, {-26510, -19261},
      {-32052, -6813}, {-32052, 6813},   {-26510, 19261},  {-16384, 28378}, {-3425, 32588},   {10126, 31164},
      {21926, 24351},  {29935, 13328},   {32767, 0},       {29935, -13328}, {21926, -24351},  {10126, -31164},
      {-3425, -32588}, {-16384, -28378}, {-26510, -19261}, {-32052, -6813}, {-32052, 6813},   {-26510, 19261},
      {-16384, 28378}, {-3425, 32588},   {10126, 31164},   {21926, 24351},  {29935, 13328},   {32767, 0},
      {29935, -13328}, {21926, -24351},  {10126, -31164},  {-3425, -32588}, {-16384, -28378}, {-26510, -19261},
      {-32052, -6813}, {-32052, 6813},   {-26510, 19261},  {-16384, 28378}, {-3425, 32588},   {10126, 31164},
      {21926, 24351},  {29935, 13328},   {32767, 0},       {29935, -13328}, {21926, -24351},  {10126, -31164},
      {-3425, -32588}, {-16384, -28378}, {-26510, -19261}, {-32052, -6813}, {-32052, 6813},   {-26510, 19261},
      {-16384, 28378}, {-3425, 32588},   {10126, 31164},   {21926, 24351},  {29935, 13328},   {32767, 0},
      {29935, -13328}, {21926, -24351},  {10126, -31164},  {-3425, -32588}, {-16384, -28378}, {-26510, -19261}}},
    {{{30274, -12540},  {23170, -23170},  {12540, -30274},  {0, -32768},      {-12540, -30274}, {-23170, -23170},
      {-30274, -12540}, {-32768, 0},      {-30274, 12540},  {-23170, 23170},  {-12540, 30274},  {0, 32767},
      {12540, 30274},   {23170, 23170},   {30274, 12540},   {32767, 0},       {30274, -12540},  {23170, -23170},
      {12540, -30274},  {0, -32768},      {-12540, -30274}, {-23170, -23170}, {-30274, -12540}, {-32768, 0},
      {-30274, 12540},  {-23170, 23170},  {-12540, 30274},  {0, 32767},       {12540, 30274},   {23170, 23170},
      {30274, 12540},   {32767, 0},       {30274, -12540},  {23170, -23170},  {12540, -30274},  {0, -32768},
      {-12540, -30274}, {-23170, -23170}, {-30274, -12540}, {-32768, 0},      {-30274, 12540},  {-23170, 23170},
      {-12540, 30274},  {0, 32767},       {12540, 30274},   {23170, 23170},   {30274, 12540},   {32767, 0},
      {30274, -12540},  {23170, -23170},  {12540, -30274},  {0, -32768},      {-12540, -30274}, {-23170, -23170},
      {-30274, -12540}, {-32768, 0},      {-30274, 12540},  {-23170, 23170},  {-12540, 30274},  {0, 32767},
      {12540, 30274},   {23170, 23170},   {30274, 12540},   {32767, 0},       {30274, -12540},  {23170, -23170}}},
    {{{30792, -11207},  {25102, -21063},  {16384, -28378}, {5690, -32270},  {-5690, -32270}, {-16384, -28378},
      {-25102, -21063}, {-30792, -11207}, {-32768, 0},     {-30792, 11207}, {-25102, 21063}, {-16384, 28378},
      {-5690, 32270},   {5690, 32270},    {16384, 28378},  {25102, 21063},  {30792, 11207},  {32767, 0},
      {30792, -11207},  {25102, -21063},  {16384, -28378}, {5690, -32270},  {-5690, -32270}, {-16384, -28378},
      {-25102, -21063}, {-30792, -11207}, {-32768, 0},     {-30792, 11207}, {-25102, 21063}, {-16384, 28378},
      {-5690, 32270},   {5690, 32270},    {16384, 28378},  {25102, 21063},  {30792, 11207},  {32767, 0},
      {30792, -11207},  {25102, -21063},  {16384, -28378}, {5690, -32270},  {-5690, -32270}, {-16384, -28378},
      {-25102, -21063}, {-30792, -11207}, {-32768, 0},     {-30792, 11207}, {-25102, 21063}, {-16384, 28378},
      {-5690, 32270},   {5690, 32270},    {16384, 28378},  {25102, 21063},  {30792, 11207},  {32767, 0},
      {30792, -11207},  {25102, -21063},  {16384, -28378}, {5690, -32270},  {-5690, -32270}, {-16384, -28378},
      {-25102, -21063}, {-30792, -11207}, {-32768, 0},     {-30792, 11207}, {-25102, 21063}, {-16384, 28378}}},
    {{{31164, -10126},  {26510, -19261},  {19261, -26510},  {10126, -31164},  {0, -32768},      {-10126, -31164},
      {-19261, -26510}, {-26510, -19261}, {-31164, -10126}, {-32768, 0},      {-31164, 10126},  {-26510, 19261},
      {-19261, 26510},  {-10126, 31164},  {0, 32767},       {10126, 31164},   {19261, 26510},   {26510, 19261},
      {31164, 10126},   {32767, 0},       {31164, -10126},  {26510, -19261},  {19261, -26510},  {10126, -31164},
      {0, -32768},      {-10126, -31164}, {-19261, -26510}, {-26510, -19261}, {-31164, -10126}, {-32768, 0},
      {-31164, 10126},  {-26510, 19261},  {-19261, 26510},  {-10126, 31164},  {0, 32767},       {10126, 31164},
      {19261, 26510},   {26510, 19261},   {31164, 10126},   {32767, 0},       {31164, -10126},  {26510, -19261},
      {19261, -26510},  {10126, -31164},  {0, -32768},      {-10126, -31164}, {-19261, -26510}, {-26510, -19261},
      {-31164, -10126}, {-32768, 0},      {-31164, 10126},  {-26510, 19261},  {-19261, 26510},  {-10126, 31164},
      {0, 32767},       {10126, 31164},   {19261, 26510},   {26510, 19261},   {31164, 10126},   {32767, 0},
      {31164, -10126},  {26510, -19261},  {19261, -26510},  {10126, -31164},  {0, -32768},      {-10126, -31164}}},
    {{{31651, -8481},  {28378, -16384},  {23170, -23170},  {16384, -28378},  {8481, -31651},  {0, -32768},
      {-8481, -31651}, {-16384, -28378}, {-23170, -23170}, {-28378, -16384}, {-31651, -8481}, {-32768, 0},
      {-31651, 8481},  {-28378, 16384},  {-23170, 23170},  {-16384, 28378},  {-8481, 31651},  {0, 32767},
      {8481, 31651},   {16384, 28378},   {23170, 23170},   {28378, 16384},   {31651, 8481},   {32767, 0},
      {31651, -8481},  {28378, -16384},  {23170, -23170},  {16384, -28378},  {8481, -31651},  {0, -32768},
      {-8481, -31651}, {-16384, -28378}, {-23170, -23170}, {-28378, -16384}, {-31651, -8481}, {-32768, 0},
      {-31651, 8481},  {-28378, 16384},  {-23170, 23170},  {-16384, 28378},  {-8481, 31651},  {0, 32767},
      {8481, 31651},   {16384, 28378},   {23170, 23170},   {28378, 16384},   {31651, 8481},   {32767, 0},
      {31651, -8481},  {28378, -16384},  {23170, -23170},  {16384, -28378},  {8481, -31651},  {0, -32768},
      {-8481, -31651}, {-16384, -28378}, {-23170, -23170}, {-28378, -16384}, {-31651, -8481}, {-32768, 0},
      {-31651, 8481},  {-28378, 16384},  {-23170, 23170},  {-16384, 28378},  {-8481, 31651},  {0, 32767}}},
    {{{31739, -8149},   {28715, -15786},  {23887, -22431},  {17558, -27667},  {10126, -31164},  {2058, -32703},
      {-6140, -32188},  {-13952, -29649}, {-20887, -25248}, {-26510, -19261}, {-30467, -12063}, {-32510, -4107},
      {-32510, 4107},   {-30467, 12063},  {-26510, 19261},  {-20887, 25248},  {-13952, 29649},  {-6140, 32188},
      {2058, 32703},    {10126, 31164},   {17558, 27667},   {23887, 22431},   {28715, 15786},   {31739, 8149},
      {32767, 0},       {31739, -8149},   {28715, -15786},  {23887, -22431},  {17558, -27667},  {10126, -31164},
      {2058, -32703},   {-6140, -32188},  {-13952, -29649}, {-20887, -25248}, {-26510, -19261}, {-30467, -12063},
      {-32510, -4107},  {-32510, 4107},   {-30467, 12063},  {-26510, 19261},  {-20887, 25248},  {-13952, 29649},
      {-6140, 32188},   {2058, 32703},    {10126, 31164},   {17558, 27667},   {23887, 22431},   {28715, 15786},
      {31739, 8149},    {32767, 0},       {31739, -8149},   {28715, -15786},  {23887, -22431},  {17558, -27667},
      {10126, -31164},  {2058, -32703},   {-6140, -32188},  {-13952, -29649}, {-20887, -25248}, {-26510, -19261},
      {-30467, -12063}, {-32510, -4107},  {-32510, 4107},   {-30467, 12063},  {-26510, 19261},  {-20887, 25248}}},
    {{{31885, -7557},   {29283, -14706},  {25102, -21063},  {19568, -26284},  {12979, -30088},  {5690, -32270},
      {-1905, -32713},  {-9398, -31391},  {-16384, -28378}, {-22487, -23835}, {-27377, -18006}, {-30792, -11207},
      {-32546, -3804},  {-32546, 3804},   {-30792, 11207},  {-27377, 18006},  {-22487, 23835},  {-16384, 28378},
      {-9398, 31391},   {-1905, 32713},   {5690, 32270},    {12979, 30088},   {19568, 26284},   {25102, 21063},
      {29283, 14706},   {31885, 7557},    {32767, 0},       {31885, -7557},   {29283, -14706},  {25102, -21063},
      {19568, -26284},  {12979, -30088},  {5690, -32270},   {-1905, -32713},  {-9398, -31391},  {-16384, -28378},
      {-22487, -23835}, {-27377, -18006}, {-30792, -11207}, {-32546, -3804},  {-32546, 3804},   {-30792, 11207},
      {-27377, 18006},  {-22487, 23835},  {-16384, 28378},  {-9398, 31391},   {-1905, 32713},   {5690, 32270},
      {12979, 30088},   {19568, 26284},   {25102, 21063},   {29283, 14706},   {31885, 7557},    {32767, 0},
      {31885, -7557},   {29283, -14706},  {25102, -21063},  {19568, -26284},  {12979, -30088},  {5690, -32270},
      {-1905, -32713},  {-9398, -31391},  {-16384, -28378}, {-22487, -23835}, {-27377, -18006}, {-30792, -11207}}},
    {{{32052, -6813},   {29935, -13328}, {26510, -19261},  {21926, -24351},  {16384, -28378},  {10126, -31164},
      {3425, -32588},   {-3425, -32588}, {-10126, -31164}, {-16384, -28378}, {-21926, -24351}, {-26510, -19261},
      {-29935, -13328}, {-32052, -6813}, {-32768, 0},      {-32052, 6813},   {-29935, 13328},  {-26510, 19261},
      {-21926, 24351},  {-16384, 28378}, {-10126, 31164},  {-3425, 32588},   {3425, 32588},    {10126, 31164},
      {16384, 28378},   {21926, 24351},  {26510, 19261},   {29935, 13328},   {32052, 6813},    {32767, 0},
      {32052, -6813},   {29935, -13328}, {26510, -19261},  {21926, -24351},  {16384, -28378},  {10126, -31164},
      {3425, -32588},   {-3425, -32588}, {-10126, -31164}, {-16384, -28378}, {-21926, -24351}, {-26510, -19261},
      {-29935, -13328}, {-32052, -6813}, {-32768, 0},      {-32052, 6813},   {-29935, 13328},  {-26510, 19261},
      {-21926, 24351},  {-16384, 28378}, {-10126, 31164},  {-3425, 32588},   {3425, 32588},    {10126, 31164},
      {16384, 28378},   {21926, 24351},  {26510, 19261},   {29935, 13328},   {32052, 6813},    {32767, 0},
      {32052, -6813},   {29935, -13328}, {26510, -19261},  {21926, -24351},  {16384, -28378},  {10126, -31164}}},
    {{{32138, -6393},   {30274, -12540},  {27246, -18205},  {23170, -23170},  {18205, -27246},  {12540, -30274},
      {6393, -32138},   {0, -32768},      {-6393, -32138},  {-12540, -30274}, {-18205, -27246}, {-23170, -23170},
      {-27246, -18205}, {-30274, -12540}, {-32138, -6393},  {-32768, 0},      {-32138, 6393},   {-30274, 12540},
      {-27246, 18205},  {-23170, 23170},  {-18205, 27246},  {-12540, 30274},  {-6393, 32138},   {0, 32767},
      {6393, 32138},    {12540, 30274},   {18205, 27246},   {23170, 23170},   {27246, 18205},   {30274, 12540},
      {32138, 6393},    {32767, 0},       {32138, -6393},   {30274, -12540},  {27246, -18205},  {23170, -23170},
      {18205, -27246},  {12540, -30274},  {6393, -32138},   {0, -32768},      {-6393, -32138},  {-12540, -30274},
      {-18205, -27246}, {-23170, -23170}, {-27246, -18205}, {-30274, -12540}, {-32138, -6393},  {-32768, 0},
      {-32138, 6393},   {-30274, 12540},  {-27246, 18205},  {-23170, 23170},  {-18205, 27246},  {-12540, 30274},
      {-6393, 32138},   {0, 32767},       {6393, 32138},    {12540, 30274},   {18205, 27246},   {23170, 23170},
      {27246, 18205},   {30274, 12540},   {32138, 6393},    {32767, 0},       {32138, -6393},   {30274, -12540}}},
    {{{32270, -5690},   {30792, -11207},  {28378, -16384},  {25102, -21063},  {21063, -25102},  {16384, -28378},
      {11207, -30792},  {5690, -32270},   {0, -32768},      {-5690, -32270},  {-11207, -30792}, {-16384, -28378},
      {-21063, -25102}, {-25102, -21063}, {-28378, -16384}, {-30792, -11207}, {-32270, -5690},  {-32768, 0},
      {-32270, 5690},   {-30792, 11207},  {-28378, 16384},  {-25102, 21063},  {-21063, 25102},  {-16384, 28378},
      {-11207, 30792},  {-5690, 32270},   {0, 32767},       {5690, 32270},    {11207, 30792},   {16384, 28378},
      {21063, 25102},   {25102, 21063},   {28378, 16384},   {30792, 11207},   {32270, 5690},    {32767, 0},
      {32270, -5690},   {30792, -11207},  {28378, -16384},  {25102, -21063},  {21063, -25102},  {16384, -28378},
      {11207, -30792},  {5690, -32270},   {0, -32768},      {-5690, -32270},  {-11207, -30792}, {-16384, -28378},
      {-21063, -25102}, {-25102, -21063}, {-28378, -16384}, {-30792, -11207}, {-32270, -5690},  {-32768, 0},
      {-32270, 5690},   {-30792, 11207},  {-28378, 16384},  {-25102, 21063},  {-21063, 25102},  {-16384, 28378},
      {-11207, 30792},  {-5690, 32270},   {0, 32767},       {5690, 32270},    {11207, 30792},   {16384, 28378}}},
    {{{32365, -5126},   {31164, -10126},  {29197, -14876},  {26510, -19261},  {23170, -23170},  {19261, -26510},
      {14876, -29197},  {10126, -31164},  {5126, -32365},   {0, -32768},      {-5126, -32365},  {-10126, -31164},
      {-14876, -29197}, {-19261, -26510}, {-23170, -23170}, {-26510, -19261}, {-29197, -14876}, {-31164, -10126},
      {-32365, -5126},  {-32768, 0},      {-32365, 5126},   {-31164, 10126},  {-29197, 14876},  {-26510, 19261},
      {-23170, 23170},  {-19261, 26510},  {-14876, 29197},  {-10126, 31164},  {-5126, 32365},   {0, 32767},
      {5126, 32365},    {10126, 31164},   {14876, 29197},   {19261, 26510},   {23170, 23170},   {26510, 19261},
      {29197, 14876},   {31164, 10126},   {32365, 5126},    {32767, 0},       {32365, -5126},   {31164, -10126},
      {29197, -14876},  {26510, -19261},  {23170, -23170},  {19261, -26510},  {14876, -29197},  {10126, -31164},
      {5126, -32365},   {0, -32768},      {-5126, -32365},  {-10126, -31164}, {-14876, -29197}, {-19261, -26510},
      {-23170, -23170}, {-26510, -19261}, {-29197, -14876}, {-31164, -10126}, {-32365, -5126},  {-32768, 0},
      {-32365, 5126},   {-31164, 10126},  {-29197, 14876},  {-26510, 19261},  {-23170, 23170},  {-19261, 26510}}},
    {{{32449, -4560},   {31499, -9032},   {29935, -13328},  {27789, -17364},  {25102, -21063},  {21926, -24351},
      {18324, -27166},  {14365, -29452},  {10126, -31164},  {5690, -32270},   {1144, -32748},   {-3425, -32588},
      {-7927, -31795},  {-12275, -30382}, {-16384, -28378}, {-20174, -25822}, {-23571, -22763}, {-26510, -19261},
      {-28932, -15384}, {-30792, -11207}, {-32052, -6813},  {-32688, -2286},  {-32688, 2286},   {-32052, 6813},
      {-30792, 11207},  {-28932, 15384},  {-26510, 19261},  {-23571, 22763},  {-20174, 25822},  {-16384, 28378},
      {-12275, 30382},  {-7927, 31795},   {-3425, 32588},   {1144, 32748},    {5690, 32270},    {10126, 31164},
      {14365, 29452},   {18324, 27166},   {21926, 24351},   {25102, 21063},   {27789, 17364},   {29935, 13328},
      {31499, 9032},    {32449, 4560},    {32767, 0},       {32449, -4560},   {31499, -9032},   {29935, -13328},
      {27789, -17364},  {25102, -21063},  {21926, -24351},  {18324, -27166},  {14365, -29452},  {10126, -31164},
      {5690, -32270},   {1144, -32748},   {-3425, -32588},  {-7927, -31795},  {-12275, -30382}, {-16384, -28378},
      {-20174, -25822}, {-23571, -22763}, {-26510, -19261}, {-28932, -15384}, {-30792, -11207}, {-32052, -6813}}},
    {{{32488, -4277},   {31651, -8481},   {30274, -12540},  {28378, -16384},  {25997, -19948},  {23170, -23170},
      {19948, -25997},  {16384, -28378},  {12540, -30274},  {8481, -31651},   {4277, -32488},   {0, -32768},
      {-4277, -32488},  {-8481, -31651},  {-12540, -30274}, {-16384, -28378}, {-19948, -25997}, {-23170, -23170},
      {-25997, -19948}, {-28378, -16384}, {-30274, -12540}, {-31651, -8481},  {-32488, -4277},  {-32768, 0},
      {-32488, 4277},   {-31651, 8481},   {-30274, 12540},  {-28378, 16384},  {-25997, 19948},  {-23170, 23170},
      {-19948, 25997},  {-16384, 28378},  {-12540, 30274},  {-8481, 31651},   {-4277, 32488},   {0, 32767},
      {4277, 32488},    {8481, 31651},    {12540, 30274},   {16384, 28378},   {19948, 25997},   {23170, 23170},
      {25997, 19948},   {28378, 16384},   {30274, 12540},   {31651, 8481},    {32488, 4277},    {32767, 0},
      {32488, -4277},   {31651, -8481},   {30274, -12540},  {28378, -16384},  {25997, -19948},  {23170, -23170},
      {19948, -25997},  {16384, -28378},  {12540, -30274},  {8481, -31651},   {4277, -32488},   {0, -32768},
      {-4277, -32488},  {-8481, -31651},  {-12540, -30274}, {-16384, -28378}, {-19948, -25997}, {-23170, -23170}}},
    {{{32510, -4107},   {31739, -8149},   {30467, -12063},  {28715, -15786},  {26510, -19261},  {23887, -22431},
      {20887, -25248},  {17558, -27667},  {13952, -29649},  {10126, -31164},  {6140, -32188},   {2058, -32703},
      {-2058, -32703},  {-6140, -32188},  {-10126, -31164}, {-13952, -29649}, {-17558, -27667}, {-20887, -25248},
      {-23887, -22431}, {-26510, -19261}, {-28715, -15786}, {-30467, -12063}, {-31739, -8149},  {-32510, -4107},
      {-32768, 0},      {-32510, 4107},   {-31739, 8149},   {-30467, 12063},  {-28715, 15786},  {-26510, 19261},
      {-23887, 22431},  {-20887, 25248},  {-17558, 27667},  {-13952, 29649},  {-10126, 31164},  {-6140, 32188},
      {-2058, 32703},   {2058, 32703},    {6140, 32188},    {10126, 31164},   {13952, 29649},   {17558, 27667},
      {20887, 25248},   {23887, 22431},   {26510, 19261},   {28715, 15786},   {30467, 12063},   {31739, 8149},
      {32510, 4107},    {32767, 0},       {32510, -4107},   {31739, -8149},   {30467, -12063},  {28715, -15786},
      {26510, -19261},  {23887, -22431},  {20887, -25248},  {17558, -27667},  {13952, -29649},  {10126, -31164},
      {6140, -32188},   {2058, -32703},   {-2058, -32703},  {-6140, -32188},  {-10126, -31164}, {-13952, -29649}}},
    {{{32546, -3804},   {31885, -7557},   {30792, -11207},  {29283, -14706},  {27377, -18006},  {25102, -21063},
      {22487, -23835},  {19568, -26284},  {16384, -28378},  {12979, -30088},  {9398, -31391},   {5690, -32270},
      {1905, -32713},   {-1905, -32713},  {-5690, -32270},  {-9398, -31391},  {-12979, -30088}, {-16384, -28378},
      {-19568, -26284}, {-22487, -23835}, {-25102, -21063}, {-27377, -18006}, {-29283, -14706}, {-30792, -11207},
      {-31885, -7557},  {-32546, -3804},  {-32768, 0},      {-32546, 3804},   {-31885, 7557},   {-30792, 11207},
      {-29283, 14706},  {-27377, 18006},  {-25102, 21063},  {-22487, 23835},  {-19568, 26284},  {-16384, 28378},
      {-12979, 30088},  {-9398, 31391},   {-5690, 32270},   {-1905, 32713},   {1905, 32713},    {5690, 32270},
      {9398, 31391},    {12979, 30088},   {16384, 28378},   {19568, 26284},   {22487, 23835},   {25102, 21063},
      {27377, 18006},   {29283, 14706},   {30792, 11207},   {31885, 7557},    {32546, 3804},    {32767, 0},
      {32546, -3804},   {31885, -7557},   {30792, -11207},  {29283, -14706},  {27377, -18006},  {25102, -21063},
      {22487, -23835},  {19568, -26284},  {16384, -28378},  {12979, -30088},  {9398, -31391},   {5690, -32270}}},
    {{{32588, -3425},   {32052, -6813},   {31164, -10126},  {29935, -13328},  {28378, -16384},  {26510, -19261},
      {24351, -21926},  {21926, -24351},  {19261, -26510},  {16384, -28378},  {13328, -29935},  {10126, -31164},
      {6813, -32052},   {3425, -32588},   {0, -32768},      {-3425, -32588},  {-6813, -32052},  {-10126, -31164},
      {-13328, -29935}, {-16384, -28378}, {-19261, -26510}, {-21926, -24351}, {-24351, -21926}, {-26510, -19261},
      {-28378, -16384}, {-29935, -13328}, {-31164, -10126}, {-32052, -6813},  {-32588, -3425},  {-32768, 0},
      {-32588, 3425},   {-32052, 6813},   {-31164, 10126},  {-29935, 13328},  {-28378, 16384},  {-26510, 19261},
      {-24351, 21926},  {-21926, 24351},  {-19261, 26510},  {-16384, 28378},  {-13328, 29935},  {-10126, 31164},
      {-6813, 32052},   {-3425, 32588},   {0, 32767},       {3425, 32588},    {6813, 32052},    {10126, 31164},
      {13328, 29935},   {16384, 28378},   {19261, 26510},   {21926, 24351},   {24351, 21926},   {26510, 19261},
      {28378, 16384},   {29935, 13328},   {31164, 10126},   {32052, 6813},    {32588, 3425},    {32767, 0},
      {32588, -3425},   {32052, -6813},   {31164, -10126},  {29935, -13328},  {28378, -16384},  {26510, -19261}}},
    {{{32610, -3212},   {32138, -6393},   {31357, -9512},   {30274, -12540},  {28899, -15447},  {27246, -18205},
      {25330, -20788},  {23170, -23170},  {20788, -25330},  {18205, -27246},  {15447, -28899},  {12540, -30274},
      {9512, -31357},   {6393, -32138},   {3212, -32610},   {0, -32768},      {-3212, -32610},  {-6393, -32138},
      {-9512, -31357},  {-12540, -30274}, {-15447, -28899}, {-18205, -27246}, {-20788, -25330}, {-23170, -23170},
      {-25330, -20788}, {-27246, -18205}, {-28899, -15447}, {-30274, -12540}, {-31357, -9512},  {-32138, -6393},
      {-32610, -3212},  {-32768, 0},      {-32610, 3212},   {-32138, 6393},   {-31357, 9512},   {-30274, 12540},
      {-28899, 15447},  {-27246, 18205},  {-25330, 20788},  {-23170, 23170},  {-20788, 25330},  {-18205, 27246},
      {-15447, 28899},  {-12540, 30274},  {-9512, 31357},   {-6393, 32138},   {-3212, 32610},   {0, 32767},
      {3212, 32610},    {6393, 32138},    {9512, 31357},    {12540, 30274},   {15447, 28899},   {18205, 27246},
      {20788, 25330},   {23170, 23170},   {25330, 20788},   {27246, 18205},   {28899, 15447},   {30274, 12540},
      {31357, 9512},    {32138, 6393},    {32610, 3212},    {32767, 0},       {32610, -3212},   {32138, -6393}}},
    {{{32643, -2856},   {32270, -5690},   {31651, -8481},   {30792, -11207},  {29698, -13848},  {28378, -16384},
      {26842, -18795},  {25102, -21063},  {23170, -23170},  {21063, -25102},  {18795, -26842},  {16384, -28378},
      {13848, -29698},  {11207, -30792},  {8481, -31651},   {5690, -32270},   {2856, -32643},   {0, -32768},
      {-2856, -32643},  {-5690, -32270},  {-8481, -31651},  {-11207, -30792}, {-13848, -29698}, {-16384, -28378},
      {-18795, -26842}, {-21063, -25102}, {-23170, -23170}, {-25102, -21063}, {-26842, -18795}, {-28378, -16384},
      {-29698, -13848}, {-30792, -11207}, {-31651, -8481},  {-32270, -5690},  {-32643, -2856},  {-32768, 0},
      {-32643, 2856},   {-32270, 5690},   {-31651, 8481},   {-30792, 11207},  {-29698, 13848},  {-28378, 16384},
      {-26842, 18795},  {-25102, 21063},  {-23170, 23170},  {-21063, 25102},  {-18795, 26842},  {-16384, 28378},
      {-13848, 29698},  {-11207, 30792},  {-8481, 31651},   {-5690, 32270},   {-2856, 32643},   {0, 32767},
      {2856, 32643},    {5690, 32270},    {8481, 31651},    {11207, 30792},   {13848, 29698},   {16384, 28378},
      {18795, 26842},   {21063, 25102},   {23170, 23170},   {25102, 21063},   {26842, 18795},   {28378, 16384}}},
    {{{32653, -2742},   {32309, -5465},   {31739, -8149},   {30945, -10776},  {29935, -13328},  {28715, -15786},
      {27293, -18134},  {25680, -20354},  {23887, -22431},  {21926, -24351},  {19812, -26101},  {17558, -27667},
      {15181, -29039},  {12698, -30208},  {10126, -31164},  {7483, -31902},   {4787, -32416},   {2058, -32703},
      {-686, -32761},   {-3425, -32588},  {-6140, -32188},  {-8812, -31561},  {-11422, -30713}, {-13952, -29649},
      {-16384, -28378}, {-18701, -26907}, {-20887, -25248}, {-22927, -23412}, {-24805, -21411}, {-26510, -19261},
      {-28029, -16975}, {-29351, -14570}, {-30467, -12063}, {-31369, -9471},  {-32052, -6813},  {-32510, -4107},
      {-32739, -1372},  {-32739, 1372},   {-32510, 4107},   {-32052, 6813},   {-31369, 9471},   {-30467, 12063},
      {-29351, 14570},  {-28029, 16975},  {-26510, 19261},  {-24805, 21411},  {-22927, 23412},  {-20887, 25248},
      {-18701, 26907},  {-16384, 28378},  {-13952, 29649},  {-11422, 30713},  {-8812, 31561},   {-6140, 32188},
      {-3425, 32588},   {-686, 32761},    {2058, 32703},    {4787, 32416},    {7483, 31902},    {10126, 31164},
      {12698, 30208},   {15181, 29039},   {17558, 27667},   {19812, 26101},   {21926, 24351},   {23887, 22431}}},
    {{{32667, -2571},   {32365, -5126},   {31863, -7650},   {31164, -10126},  {30274, -12540},  {29197, -14876},
      {27939, -17121},  {26510, -19261},  {24917, -21281},  {23170, -23170},  {21281, -24917},  {19261, -26510},
      {17121, -27939},  {14876, -29197},  {12540, -30274},  {10126, -31164},  {7650, -31863},   {5126, -32365},
      {2571, -32667},   {0, -32768},      {-2571, -32667},  {-5126, -32365},  {-7650, -31863},  {-10126, -31164},
      {-12540, -30274}, {-14876, -29197}, {-17121, -27939}, {-19261, -26510}, {-21281, -24917}, {-23170, -23170},
      {-24917, -21281}, {-26510, -19261}, {-27939, -17121}, {-29197, -14876}, {-30274, -12540}, {-31164, -10126},
      {-31863, -7650},  {-32365, -5126},  {-32667, -2571},  {-32768, 0},      {-32667, 2571},   {-32365, 5126},
      {-31863, 7650},   {-31164, 10126},  {-30274, 12540},  {-29197, 14876},  {-27939, 17121},  {-26510, 19261},
      {-24917, 21281},  {-23170, 23170},  {-21281, 24917},  {-19261, 26510},  {-17121, 27939},  {-14876, 29197},
      {-12540, 30274},  {-10126, 31164},  {-7650, 31863},   {-5126, 32365},   {-2571, 32667},   {0, 32767},
      {2571, 32667},    {5126, 32365},    {7650, 31863},    {10126, 31164},   {12540, 30274},   {14876, 29197}}},
    {{{32669, -2539},   {32374, -5063},   {31885, -7557},   {31203, -10005},  {30334, -12393},  {29283, -14706},
      {28055, -16931},  {26658, -19054},  {25102, -21063},  {23394, -22945},  {21546, -24689},  {19568, -26284},
      {17472, -27721},  {15271, -28992},  {12979, -30088},  {10608, -31003},  {8174, -31732},   {5690, -32270},
      {3172, -32614},   {635, -32762},    {-1905, -32713},  {-4435, -32467},  {-6937, -32025},  {-9398, -31391},
      {-11802, -30569}, {-14136, -29562}, {-16384, -28378}, {-18534, -27023}, {-20572, -25505}, {-22487, -23835},
      {-24266, -22020}, {-25900, -20074}, {-27377, -18006}, {-28690, -15831}, {-29831, -13560}, {-30792, -11207},
      {-31568, -8787},  {-32154, -6315},  {-32546, -3804},  {-32743, -1271},  {-32743, 1271},   {-32546, 3804},
      {-32154, 6315},   {-31568, 8787},   {-30792, 11207},  {-29831, 13560},  {-28690, 15831},  {-27377, 18006},
      {-25900, 20074},  {-24266, 22020},  {-22487, 23835},  {-20572, 25505},  {-18534, 27023},  {-16384, 28378},
      {-14136, 29562},  {-11802, 30569},  {-9398, 31391},   {-6937, 32025},   {-4435, 32467},   {-1905, 32713},
      {635, 32762},     {3172, 32614},    {5690, 32270},    {8174, 31732},    {10608, 31003},   {12979, 30088}}},
    {{{32688, -2286},   {32449, -4560},   {32052, -6813},   {31499, -9032},   {30792, -11207},  {29935, -13328},
      {28932, -15384},  {27789, -17364},  {26510, -19261},  {25102, -21063},  {23571, -22763},  {21926, -24351},
      {20174, -25822},  {18324, -27166},  {16384, -28378},  {14365, -29452},  {12275, -30382},  {10126, -31164},
      {7927, -31795},   {5690, -32270},   {3425, -32588},   {1144, -32748},   {-1144, -32748},  {-3425, -32588},
      {-5690, -32270},  {-7927, -31795},  {-10126, -31164}, {-12275, -30382}, {-14365, -29452}, {-16384, -28378},
      {-18324, -27166}, {-20174, -25822}, {-21926, -24351}, {-23571, -22763}, {-25102, -21063}, {-26510, -19261},
      {-27789, -17364}, {-28932, -15384}, {-29935, -13328}, {-30792, -11207}, {-31499, -9032},  {-32052, -6813},
      {-32449, -4560},  {-32688, -2286},  {-32768, 0},      {-32688, 2286},   {-32449, 4560},   {-32052, 6813},
      {-31499, 9032},   {-30792, 11207},  {-29935, 13328},  {-28932, 15384},  {-27789, 17364},  {-26510, 19261},
      {-25102, 21063},  {-23571, 22763},  {-21926, 24351},  {-20174, 25822},  {-18324, 27166},  {-16384, 28378},
      {-14365, 29452},  {-12275, 30382},  {-10126, 31164},  {-7927, 31795},   {-5690, 32270},   {-3425, 32588}}},
    {{{32698, -2143},   {32488, -4277},   {32138, -6393},   {31651, -8481},   {31029, -10533},  {30274, -12540},
      {29389, -14493},  {28378, -16384},  {27246, -18205},  {25997, -19948},  {24636, -21605},  {23170, -23170},
      {21605, -24636},  {19948, -25997},  {18205, -27246},  {16384, -28378},  {14493, -29389},  {12540, -30274},
      {10533, -31029},  {8481, -31651},   {6393, -32138},   {4277, -32488},   {2143, -32698},   {0, -32768},
      {-2143, -32698},  {-4277, -32488},  {-6393, -32138},  {-8481, -31651},  {-10533, -31029}, {-12540, -30274},
      {-14493, -29389}, {-16384, -28378}, {-18205, -27246}, {-19948, -25997}, {-21605, -24636}, {-23170, -23170},
      {-24636, -21605}, {-25997, -19948}, {-27246, -18205}, {-28378, -16384}, {-29389, -14493}, {-30274, -12540},
      {-31029, -10533}, {-31651, -8481},  {-32138, -6393},  {-32488, -4277},  {-32698, -2143},  {-32768, 0},
      {-32698, 2143},   {-32488, 4277},   {-32138, 6393},   {-31651, 8481},   {-31029, 10533},  {-30274, 12540},
      {-29389, 14493},  {-28378, 16384},  {-27246, 18205},  {-25997, 19948},  {-24636, 21605},  {-23170, 23170},
      {-21605, 24636},  {-19948, 25997},  {-18205, 27246},  {-16384, 28378},  {-14493, 29389},  {-12540, 30274}}},
    {{{32703, -2058},   {32510, -4107},   {32188, -6140},   {31739, -8149},   {31164, -10126},  {30467, -12063},
      {29649, -13952},  {28715, -15786},  {27667, -17558},  {26510, -19261},  {25248, -20887},  {23887, -22431},
      {22431, -23887},  {20887, -25248},  {19261, -26510},  {17558, -27667},  {15786, -28715},  {13952, -29649},
      {12063, -30467},  {10126, -31164},  {8149, -31739},   {6140, -32188},   {4107, -32510},   {2058, -32703},
      {0, -32768},      {-2058, -32703},  {-4107, -32510},  {-6140, -32188},  {-8149, -31739},  {-10126, -31164},
      {-12063, -30467}, {-13952, -29649}, {-15786, -28715}, {-17558, -27667}, {-19261, -26510}, {-20887, -25248},
      {-22431, -23887}, {-23887, -22431}, {-25248, -20887}, {-26510, -19261}, {-27667, -17558}, {-28715, -15786},
      {-29649, -13952}, {-30467, -12063}, {-31164, -10126}, {-31739, -8149},  {-32188, -6140},  {-32510, -4107},
      {-32703, -2058},  {-32768, 0},      {-32703, 2058},   {-32510, 4107},   {-32188, 6140},   {-31739, 8149},
      {-31164, 10126},  {-30467, 12063},  {-29649, 13952},  {-28715, 15786},  {-27667, 17558},  {-26510, 19261},
      {-25248, 20887},  {-23887, 22431},  {-22431, 23887},  {-20887, 25248},  {-19261, 26510},  {-17558, 27667}}},
    {{{32713, -1905},   {32546, -3804},   {32270, -5690},   {31885, -7557},   {31391, -9398},   {30792, -11207},
      {30088, -12979},  {29283, -14706},  {28378, -16384},  {27377, -18006},  {26284, -19568},  {25102, -21063},
      {23835, -22487},  {22487, -23835},  {21063, -25102},  {19568, -26284},  {18006, -27377},  {16384, -28378},
      {14706, -29283},  {12979, -30088},  {11207, -30792},  {9398, -31391},   {7557, -31885},   {5690, -32270},
      {3804, -32546},   {1905, -32713},   {0, -32768},      {-1905, -32713},  {-3804, -32546},  {-5690, -32270},
      {-7557, -31885},  {-9398, -31391},  {-11207, -30792}, {-12979, -30088}, {-14706, -29283}, {-16384, -28378},
      {-18006, -27377}, {-19568, -26284}, {-21063, -25102}, {-22487, -23835}, {-23835, -22487}, {-25102, -21063},
      {-26284, -19568}, {-27377, -18006}, {-28378, -16384}, {-29283, -14706}, {-30088, -12979}, {-30792, -11207},
      {-31391, -9398},  {-31885, -7557},  {-32270, -5690},  {-32546, -3804},  {-32713, -1905},  {-32768, 0},
      {-32713, 1905},   {-32546, 3804},   {-32270, 5690},   {-31885, 7557},   {-31391, 9398},   {-30792, 11207},
      {-30088, 12979},  {-29283, 14706},  {-28378, 16384},  {-27377, 18006},  {-26284, 19568},  {-25102, 21063}}},
    {{{32723, -1715},   {32588, -3425},   {32365, -5126},   {32052, -6813},   {31651, -8481},   {31164, -10126},
      {30592, -11743},  {29935, -13328},  {29197, -14876},  {28378, -16384},  {27482, -17847},  {26510, -19261},
      {25466, -20622},  {24351, -21926},  {23170, -23170},  {21926, -24351},  {20622, -25466},  {19261, -26510},
      {17847, -27482},  {16384, -28378},  {14876, -29197},  {13328, -29935},  {11743, -30592},  {10126, -31164},
      {8481, -31651},   {6813, -32052},   {5126, -32365},   {3425, -32588},   {1715, -32723},   {0, -32768},
      {-1715, -32723},  {-3425, -32588},  {-5126, -32365},  {-6813, -32052},  {-8481, -31651},  {-10126, -31164},
      {-11743, -30592}, {-13328, -29935}, {-14876, -29197}, {-16384, -28378}, {-17847, -27482}, {-19261, -26510},
      {-20622, -25466}, {-21926, -24351}, {-23170, -23170}, {-24351, -21926}, {-25466, -20622}, {-26510, -19261},
      {-27482, -17847}, {-28378, -16384}, {-29197, -14876}, {-29935, -13328}, {-30592, -11743}, {-31164, -10126},
      {-31651, -8481},  {-32052, -6813},  {-32365, -5126},  {-32588, -3425},  {-32723, -1715},  {-32768, 0},
      {-32723, 1715},   {-32588, 3425},   {-32365, 5126},   {-32052, 6813},   {-31651, 8481},   {-31164, 10126}}},
    {{{32727, -1646},   {32603, -3289},   {32396, -4923},   {32108, -6544},   {31739, -8149},   {31289, -9733},
      {30760, -11293},  {30154, -12825},  {29472, -14323},  {28715, -15786},  {27885, -17209},  {26986, -18588},
      {26017, -19921},  {24984, -21203},  {23887, -22431},  {22730, -23603},  {21515, -24715},  {20246, -25765},
      {18926, -26750},  {17558, -27667},  {16146, -28514},  {14693, -29289},  {13202, -29991},  {11679, -30616},
      {10126, -31164},  {8547, -31634},   {6947, -32023},   {5329, -32332},   {3698, -32559},   {2058, -32703},
      {412, -32765},    {-1235, -32745},  {-2879, -32641},  {-4515, -32455},  {-6140, -32188},  {-7750, -31838},
      {-9340, -31409},  {-10906, -30900}, {-12445, -30313}, {-13952, -29649}, {-15424, -28911}, {-16857, -28099},
      {-18248, -27217}, {-19592, -26266}, {-20887, -25248}, {-22129, -24167}, {-23316, -23024}, {-24443, -21824},
      {-25509, -20568}, {-26510, -19261}, {-27444, -17904}, {-28309, -16503}, {-29102, -15060}, {-29822, -13578},
      {-30467, -12063}, {-31035, -10517}, {-31524, -8944},  {-31933, -7349},  {-32262, -5735},  {-32510, -4107},
      {-32675, -2468},  {-32758, -823},   {-32758, 823},    {-32675, 2468},   {-32510, 4107},   {-32262, 5735}}},
    {{{32729, -1608},   {32610, -3212},   {32413, -4808},   {32138, -6393},   {31786, -7962},   {31357, -9512},
      {30853, -11039},  {30274, -12540},  {29622, -14010},  {28899, -15447},  {28106, -16846},  {27246, -18205},
      {26320, -19520},  {25330, -20788},  {24279, -22006},  {23170, -23170},  {22006, -24279},  {20788, -25330},
      {19520, -26320},  {18205, -27246},  {16846, -28106},  {15447, -28899},  {14010, -29622},  {12540, -30274},
      {11039, -30853},  {9512, -31357},   {7962, -31786},   {6393, -32138},   {4808, -32413},   {3212, -32610},
      {1608, -32729},   {0, -32768},      {-1608, -32729},  {-3212, -32610},  {-4808, -32413},  {-6393, -32138},
      {-7962, -31786},  {-9512, -31357},  {-11039, -30853}, {-12540, -30274}, {-14010, -29622}, {-15447, -28899},
      {-16846, -28106}, {-18205, -27246}, {-19520, -26320}, {-20788, -25330}, {-22006, -24279}, {-23170, -23170},
      {-24279, -22006}, {-25330, -20788}, {-26320, -19520}, {-27246, -18205}, {-28106, -16846}, {-28899, -15447},
      {-29622, -14010}, {-30274, -12540}, {-30853, -11039}, {-31357, -9512},  {-31786, -7962},  {-32138, -6393},
      {-32413, -4808},  {-32610, -3212},  {-32729, -1608},  {-32768, 0},      {-32729, 1608},   {-32610, 3212}}},
    {{{32733, -1525},   {32626, -3046},   {32449, -4560},   {32202, -6065},   {31885, -7557},   {31499, -9032},
      {31044, -10488},  {30523, -11921},  {29935, -13328},  {29283, -14706},  {28567, -16053},  {27789, -17364},
      {26951, -18638},  {26055, -19872},  {25102, -21063},  {24095, -22208},  {23035, -23305},  {21926, -24351},
      {20769, -25345},  {19568, -26284},  {18324, -27166},  {17040, -27989},  {15719, -28751},  {14365, -29452},
      {12979, -30088},  {11565, -30659},  {10126, -31164},  {8665, -31602},   {7185, -31971},   {5690, -32270},
      {4183, -32500},   {2666, -32659},   {1144, -32748},   {-381, -32766},   {-1905, -32713},  {-3425, -32588},
      {-4938, -32394},  {-6439, -32129},  {-7927, -31795},  {-9398, -31391},  {-10848, -30920}, {-12275, -30382},
      {-13675, -29778}, {-15046, -29109}, {-16384, -28378}, {-17687, -27585}, {-18951, -26732}, {-20174, -25822},
      {-21354, -24855}, {-22487, -23835}, {-23571, -22763}, {-24605, -21641}, {-25585, -20473}, {-26510, -19261},
      {-27377, -18006}, {-28185, -16713}, {-28932, -15384}, {-29617, -14021}, {-30237, -12628}, {-30792, -11207},
      {-31280, -9763},  {-31700, -8297},  {-32052, -6813},  {-32334, -5314},  {-32546, -3804},  {-32688, -2286}}},
    {{{32737, -1429},   {32643, -2856},   {32488, -4277},   {32270, -5690},   {31991, -7092},   {31651, -8481},
      {31251, -9854},   {30792, -11207},  {30274, -12540},  {29698, -13848},  {29066, -15131},  {28378, -16384},
      {27636, -17606},  {26842, -18795},  {25997, -19948},  {25102, -21063},  {24159, -22138},  {23170, -23170},
      {22138, -24159},  {21063, -25102},  {19948, -25997},  {18795, -26842},  {17606, -27636},  {16384, -28378},
      {15131, -29066},  {13848, -29698},  {12540, -30274},  {11207, -30792},  {9854, -31251},   {8481, -31651},
      {7092, -31991},   {5690, -32270},   {4277, -32488},   {2856, -32643},   {1429, -32737},   {0, -32768},
      {-1429, -32737},  {-2856, -32643},  {-4277, -32488},  {-5690, -32270},  {-7092, -31991},  {-8481, -31651},
      {-9854, -31251},  {-11207, -30792}, {-12540, -30274}, {-13848, -29698}, {-15131, -29066}, {-16384, -28378},
      {-17606, -27636}, {-18795, -26842}, {-19948, -25997}, {-21063, -25102}, {-22138, -24159}, {-23170, -23170},
      {-24159, -22138}, {-25102, -21063}, {-25997, -19948}, {-26842, -18795}, {-27636, -17606}, {-28378, -16384},
      {-29066, -15131}, {-29698, -13848}, {-30274, -12540}, {-30792, -11207}, {-31251, -9854},  {-31651, -8481}}},
    {{{32739, -1372},   {32653, -2742},   {32510, -4107},   {32309, -5465},   {32052, -6813},   {31739, -8149},
      {31369, -9471},   {30945, -10776},  {30467, -12063},  {29935, -13328},  {29351, -14570},  {28715, -15786},
      {28029, -16975},  {27293, -18134},  {26510, -19261},  {25680, -20354},  {24805, -21411},  {23887, -22431},
      {22927, -23412},  {21926, -24351},  {20887, -25248},  {19812, -26101},  {18701, -26907},  {17558, -27667},
      {16384, -28378},  {15181, -29039},  {13952, -29649},  {12698, -30208},  {11422, -30713},  {10126, -31164},
      {8812, -31561},   {7483, -31902},   {6140, -32188},   {4787, -32416},   {3425, -32588},   {2058, -32703},
      {686, -32761},    {-686, -32761},   {-2058, -32703},  {-3425, -32588},  {-4787, -32416},  {-6140, -32188},
      {-7483, -31902},  {-8812, -31561},  {-10126, -31164}, {-11422, -30713}, {-12698, -30208}, {-13952, -29649},
      {-15181, -29039}, {-16384, -28378}, {-17558, -27667}, {-18701, -26907}, {-19812, -26101}, {-20887, -25248},
      {-21926, -24351}, {-22927, -23412}, {-23887, -22431}, {-24805, -21411}, {-25680, -20354}, {-26510, -19261},
      {-27293, -18134}, {-28029, -16975}, {-28715, -15786}, {-29351, -14570}, {-29935, -13328}, {-30467, -12063}}},
    {{{32743, -1286},   {32667, -2571},   {32541, -3851},   {32365, -5126},   {32138, -6393},   {31863, -7650},
      {31538, -8895},   {31164, -10126},  {30743, -11342},  {30274, -12540},  {29758, -13719},  {29197, -14876},
      {28590, -16011},  {27939, -17121},  {27246, -18205},  {26510, -19261},  {25733, -20286},  {24917, -21281},
      {24062, -22243},  {23170, -23170},  {22243, -24062},  {21281, -24917},  {20286, -25733},  {19261, -26510},
      {18205, -27246},  {17121, -27939},  {16011, -28590},  {14876, -29197},  {13719, -29758},  {12540, -30274},
      {11342, -30743},  {10126, -31164},  {8895, -31538},   {7650, -31863},   {6393, -32138},   {5126, -32365},
      {3851, -32541},   {2571, -32667},   {1286, -32743},   {0, -32768},      {-1286, -32743},  {-2571, -32667},
      {-3851, -32541},  {-5126, -32365},  {-6393, -32138},  {-7650, -31863},  {-8895, -31538},  {-10126, -31164},
      {-11342, -30743}, {-12540, -30274}, {-13719, -29758}, {-14876, -29197}, {-16011, -28590}, {-17121, -27939},
      {-18205, -27246}, {-19261, -26510}, {-20286, -25733}, {-21281, -24917}, {-22243, -24062}, {-23170, -23170},
      {-24062, -22243}, {-24917, -21281}, {-25733, -20286}, {-26510, -19261}, {-27246, -18205}, {-27939, -17121}}},
    {{{32743, -1271},   {32669, -2539},   {32546, -3804},   {32374, -5063},   {32154, -6315},   {31885, -7557},
      {31568, -8787},   {31203, -10005},  {30792, -11207},  {30334, -12393},  {29831, -13560},  {29283, -14706},
      {28690, -15831},  {28055, -16931},  {27377, -18006},  {26658, -19054},  {25900, -20074},  {25102, -21063},
      {24266, -22020},  {23394, -22945},  {22487, -23835},  {21546, -24689},  {20572, -25505},  {19568, -26284},
      {18534, -27023},  {17472, -27721},  {16384, -28378},  {15271, -28992},  {14136, -29562},  {12979, -30088},
      {11802, -30569},  {10608, -31003},  {9398, -31391},   {8174, -31732},   {6937, -32025},   {5690, -32270},
      {4435, -32467},   {3172, -32614},   {1905, -32713},   {635, -32762},    {-635, -32762},   {-1905, -32713},
      {-3172, -32614},  {-4435, -32467},  {-5690, -32270},  {-6937, -32025},  {-8174, -31732},  {-9398, -31391},
      {-10608, -31003}, {-11802, -30569}, {-12979, -30088}, {-14136, -29562}, {-15271, -28992}, {-16384, -28378},
      {-17472, -27721}, {-18534, -27023}, {-19568, -26284}, {-20572, -25505}, {-21546, -24689}, {-22487, -23835},
      {-23394, -22945}, {-24266, -22020}, {-25102, -21063}, {-25900, -20074}, {-26658, -19054}, {-27377, -18006}}},
    {{{32748, -1144},   {32688, -2286},   {32588, -3425},   {32449, -4560},   {32270, -5690},   {32052, -6813},
      {31795, -7927},   {31499, -9032},   {31164, -10126},  {30792, -11207},  {30382, -12275},  {29935, -13328},
      {29452, -14365},  {28932, -15384},  {28378, -16384},  {27789, -17364},  {27166, -18324},  {26510, -19261},
      {25822, -20174},  {25102, -21063},  {24351, -21926},  {23571, -22763},  {22763, -23571},  {21926, -24351},
      {21063, -25102},  {20174, -25822},  {19261, -26510},  {18324, -27166},  {17364, -27789},  {16384, -28378},
      {15384, -28932},  {14365, -29452},  {13328, -29935},  {12275, -30382},  {11207, -30792},  {10126, -31164},
      {9032, -31499},   {7927, -31795},   {6813, -32052},   {5690, -32270},   {4560, -32449},   {3425, -32588},
      {2286, -32688},   {1144, -32748},   {0, -32768},      {-1144, -32748},  {-2286, -32688},  {-3425, -32588},
      {-4560, -32449},  {-5690, -32270},  {-6813, -32052},  {-7927, -31795},  {-9032, -31499},  {-10126, -31164},
      {-11207, -30792}, {-12275, -30382}, {-13328, -29935}, {-14365, -29452}, {-15384, -28932}, {-16384, -28378},
      {-17364, -27789}, {-18324, -27166}, {-19261, -26510}, {-20174, -25822}, {-21063, -25102}, {-21926, -24351}}},
    {{{32750, -1072},   {32698, -2143},   {32610, -3212},   {32488, -4277},   {32330, -5338},   {32138, -6393},
      {31912, -7441},   {31651, -8481},   {31357, -9512},   {31029, -10533},  {30668, -11543},  {30274, -12540},
      {29847, -13524},  {29389, -14493},  {28899, -15447},  {28378, -16384},  {27827, -17304},  {27246, -18205},
      {26635, -19087},  {25997, -19948},  {25330, -20788},  {24636, -21605},  {23916, -22400},  {23170, -23170},
      {22400, -23916},  {21605, -24636},  {20788, -25330},  {19948, -25997},  {19087, -26635},  {18205, -27246},
      {17304, -27827},  {16384, -28378},  {15447, -28899},  {14493, -29389},  {13524, -29847},  {12540, -30274},
      {11543, -30668},  {10533, -31029},  {9512, -31357},   {8481, -31651},   {7441, -31912},   {6393, -32138},
      {5338, -32330},   {4277, -32488},   {3212, -32610},   {2143, -32698},   {1072, -32750},   {0, -32768},
      {-1072, -32750},  {-2143, -32698},  {-3212, -32610},  {-4277, -32488},  {-5338, -32330},  {-6393, -32138},
      {-7441, -31912},  {-8481, -31651},  {-9512, -31357},  {-10533, -31029}, {-11543, -30668}, {-12540, -30274},
      {-13524, -29847}, {-14493, -29389}, {-15447, -28899}, {-16384, -28378}, {-17304, -27827}, {-18205, -27246}}},
    {{{32752, -1029},   {32703, -2058},   {32623, -3084},   {32510, -4107},   {32365, -5126},   {32188, -6140},
      {31979, -7148},   {31739, -8149},   {31467, -9142},   {31164, -10126},  {30831, -11100},  {30467, -12063},
      {30073, -13014},  {29649, -13952},  {29197, -14876},  {28715, -15786},  {28205, -16680},  {27667, -17558},
      {27102, -18418},  {26510, -19261},  {25892, -20084},  {25248, -20887},  {24580, -21670},  {23887, -22431},
      {23170, -23170},  {22431, -23887},  {21670, -24580},  {20887, -25248},  {20084, -25892},  {19261, -26510},
      {18418, -27102},  {17558, -27667},  {16680, -28205},  {15786, -28715},  {14876, -29197},  {13952, -29649},
      {13014, -30073},  {12063, -30467},  {11100, -30831},  {10126, -31164},  {9142, -31467},   {8149, -31739},
      {7148, -31979},   {6140, -32188},   {5126, -32365},   {4107, -32510},   {3084, -32623},   {2058, -32703},
      {1029, -32752},   {0, -32768},      {-1029, -32752},  {-2058, -32703},  {-3084, -32623},  {-4107, -32510},
      {-5126, -32365},  {-6140, -32188},  {-7148, -31979},  {-8149, -31739},  {-9142, -31467},  {-10126, -31164},
      {-11100, -30831}, {-12063, -30467}, {-13014, -30073}, {-13952, -29649}, {-14876, -29197}, {-15786, -28715}}},
    {{{32754, -953},   {32713, -1905},  {32643, -2856},  {32546, -3804},  {32422, -4749},   {32270, -5690},
      {32091, -6626},  {31885, -7557},  {31651, -8481},  {31391, -9398},  {31105, -10307},  {30792, -11207},
      {30453, -12098}, {30088, -12979}, {29698, -13848}, {29283, -14706}, {28842, -15552},  {28378, -16384},
      {27889, -17202}, {27377, -18006}, {26842, -18795}, {26284, -19568}, {25704, -20324},  {25102, -21063},
      {24479, -21784}, {23835, -22487}, {23170, -23170}, {22487, -23835}, {21784, -24479},  {21063, -25102},
      {20324, -25704}, {19568, -26284}, {18795, -26842}, {18006, -27377}, {17202, -27889},  {16384, -28378},
      {15552, -28842}, {14706, -29283}, {13848, -29698}, {12979, -30088}, {12098, -30453},  {11207, -30792},
      {10307, -31105}, {9398, -31391},  {8481, -31651},  {7557, -31885},  {6626, -32091},   {5690, -32270},
      {4749, -32422},  {3804, -32546},  {2856, -32643},  {1905, -32713},  {953, -32754},    {0, -32768},
      {-953, -32754},  {-1905, -32713}, {-2856, -32643}, {-3804, -32546}, {-4749, -32422},  {-5690, -32270},
      {-6626, -32091}, {-7557, -31885}, {-8481, -31651}, {-9398, -31391}, {-10307, -31105}, {-11207, -30792}}},
    {{{32755, -915},   {32717, -1829},  {32653, -2742},  {32564, -3653},  {32449, -4560},  {32309, -5465},
      {32144, -6365},  {31954, -7260},  {31739, -8149},  {31499, -9032},  {31234, -9908},  {30945, -10776},
      {30632, -11636}, {30296, -12487}, {29935, -13328}, {29551, -14159}, {29144, -14978}, {28715, -15786},
      {28263, -16582}, {27789, -17364}, {27293, -18134}, {26776, -18889}, {26238, -19629}, {25680, -20354},
      {25102, -21063}, {24504, -21756}, {23887, -22431}, {23251, -23089}, {22597, -23730}, {21926, -24351},
      {21238, -24954}, {20533, -25537}, {19812, -26101}, {19075, -26644}, {18324, -27166}, {17558, -27667},
      {16779, -28146}, {15986, -28604}, {15181, -29039}, {14365, -29452}, {13537, -29841}, {12698, -30208},
      {11850, -30550}, {10992, -30869}, {10126, -31164}, {9252, -31435},  {8370, -31681},  {7483, -31902},
      {6589, -32099},  {5690, -32270},  {4787, -32416},  {3880, -32537},  {2970, -32633},  {2058, -32703},
      {1144, -32748},  {229, -32767},   {-686, -32761},  {-1601, -32729}, {-2514, -32671}, {-3425, -32588},
      {-4334, -32480}, {-5239, -32346}, {-6140, -32188}, {-7036, -32004}, {-7927, -31795}, {-8812, -31561}}},
    {{{32757, -858},   {32723, -1715},  {32667, -2571},  {32588, -3425},  {32488, -4277},  {32365, -5126},
      {32219, -5971},  {32052, -6813},  {31863, -7650},  {31651, -8481},  {31419, -9307},  {31164, -10126},
      {30888, -10938}, {30592, -11743}, {30274, -12540}, {29935, -13328}, {29576, -14107}, {29197, -14876},
      {28797, -15636}, {28378, -16384}, {27939, -17121}, {27482, -17847}, {27005, -18560}, {26510, -19261},
      {25997, -19948}, {25466, -20622}, {24917, -21281}, {24351, -21926}, {23769, -22556}, {23170, -23170},
      {22556, -23769}, {21926, -24351}, {21281, -24917}, {20622, -25466}, {19948, -25997}, {19261, -26510},
      {18560, -27005}, {17847, -27482}, {17121, -27939}, {16384, -28378}, {15636, -28797}, {14876, -29197},
      {14107, -29576}, {13328, -29935}, {12540, -30274}, {11743, -30592}, {10938, -30888}, {10126, -31164},
      {9307, -31419},  {8481, -31651},  {7650, -31863},  {6813, -32052},  {5971, -32219},  {5126, -32365},
      {4277, -32488},  {3425, -32588},  {2571, -32667},  {1715, -32723},  {858, -32757},   {0, -32768},
      {-858, -32757},  {-1715, -32723}, {-2571, -32667}, {-3425, -32588}, {-4277, -32488}, {-5126, -32365}}},
    {{{32757, -847},   {32724, -1694},  {32669, -2539},  {32593, -3383},  {32495, -4225},  {32374, -5063},
      {32233, -5899},  {32069, -6730},  {31885, -7557},  {31679, -8379},  {31451, -9195},  {31203, -10005},
      {30934, -10808}, {30644, -11604}, {30334, -12393}, {30004, -13173}, {29653, -13944}, {29283, -14706},
      {28893, -15458}, {28483, -16200}, {28055, -16931}, {27608, -17651}, {27142, -18359}, {26658, -19054},
      {26157, -19737}, {25638, -20407}, {25102, -21063}, {24549, -21705}, {23979, -22332}, {23394, -22945},
      {22793, -23542}, {22177, -24123}, {21546, -24689}, {20900, -25237}, {20241, -25769}, {19568, -26284},
      {18882, -26781}, {18183, -27260}, {17472, -27721}, {16750, -28164}, {16016, -28587}, {15271, -28992},
      {14517, -29377}, {13752, -29742}, {12979, -30088}, {12197, -30414}, {11406, -30719}, {10608, -31003},
      {9803, -31267},  {8991, -31510},  {8174, -31732},  {7351, -31933},  {6523, -32112},  {5690, -32270},
      {4854, -32407},  {4014, -32521},  {3172, -32614},  {2328, -32685},  {1482, -32734},  {635, -32762},
      {-212, -32767},  {-1059, -32751}, {-1905, -32713}, {-2750, -32652}, {-3594, -32570}, {-4435, -32467}}},
    {{{32758, -823},   {32727, -1646},  {32675, -2468},  {32603, -3289},  {32510, -4107},  {32396, -4923},
      {32262, -5735},  {32108, -6544},  {31933, -7349},  {31739, -8149},  {31524, -8944},  {31289, -9733},
      {31035, -10517}, {30760, -11293}, {30467, -12063}, {30154, -12825}, {29822, -13578}, {29472, -14323},
      {29102, -15060}, {28715, -15786}, {28309, -16503}, {27885, -17209}, {27444, -17904}, {26986, -18588},
      {26510, -19261}, {26017, -19921}, {25509, -20568}, {24984, -21203}, {24443, -21824}, {23887, -22431},
      {23316, -23024}, {22730, -23603}, {22129, -24167}, {21515, -24715}, {20887, -25248}, {20246, -25765},
      {19592, -26266}, {18926, -26750}, {18248, -27217}, {17558, -27667}, {16857, -28099}, {16146, -28514},
      {15424, -28911}, {14693, -29289}, {13952, -29649}, {13202, -29991}, {12445, -30313}, {11679, -30616},
      {10906, -30900}, {10126, -31164}, {9340, -31409},  {8547, -31634},  {7750, -31838},  {6947, -32023},
      {6140, -32188},  {5329, -32332},  {4515, -32455},  {3698, -32559},  {2879, -32641},  {2058, -32703},
      {1235, -32745},  {412, -32765},   {-412, -32765},  {-1235, -32745}, {-2058, -32703}, {-2879, -32641}}},
    {{{32758, -804},   {32729, -1608},  {32679, -2411},  {32610, -3212},  {32522, -4011},  {32413, -4808},
      {32286, -5602},  {32138, -6393},  {31972, -7180},  {31786, -7962},  {31581, -8740},  {31357, -9512},
      {31114, -10279}, {30853, -11039}, {30572, -11793}, {30274, -12540}, {29957, -13279}, {29622, -14010},
      {29269, -14733}, {28899, -15447}, {28511, -16151}, {28106, -16846}, {27684, -17531}, {27246, -18205},
      {26791, -18868}, {26320, -19520}, {25833, -20160}, {25330, -20788}, {24812, -21403}, {24279, -22006},
      {23732, -22595}, {23170, -23170}, {22595, -23732}, {22006, -24279}, {21403, -24812}, {20788, -25330},
      {20160, -25833}, {19520, -26320}, {18868, -26791}, {18205, -27246}, {17531, -27684}, {16846, -28106},
      {16151, -28511}, {15447, -28899}, {14733, -29269}, {14010, -29622}, {13279, -29957}, {12540, -30274},
      {11793, -30572}, {11039, -30853}, {10279, -31114}, {9512, -31357},  {8740, -31581},  {7962, -31786},
      {7180, -31972},  {6393, -32138},  {5602, -32286},  {4808, -32413},  {4011, -32522},  {3212, -32610},
      {2411, -32679},  {1608, -32729},  {804, -32758},   {0, -32768},     {-804, -32758},  {-1608, -32729}}},
    {{{32759, -762},   {32733, -1525},  {32688, -2286},  {32626, -3046},  {32546, -3804},  {32449, -4560},
      {32334, -5314},  {32202, -6065},  {32052, -6813},  {31885, -7557},  {31700, -8297},  {31499, -9032},
      {31280, -9763},  {31044, -10488}, {30792, -11207}, {30523, -11921}, {30237, -12628}, {29935, -13328},
      {29617, -14021}, {29283, -14706}, {28932, -15384}, {28567, -16053}, {28185, -16713}, {27789, -17364},
      {27377, -18006}, {26951, -18638}, {26510, -19261}, {26055, -19872}, {25585, -20473}, {25102, -21063},
      {24605, -21641}, {24095, -22208}, {23571, -22763}, {23035, -23305}, {22487, -23835}, {21926, -24351},
      {21354, -24855}, {20769, -25345}, {20174, -25822}, {19568, -26284}, {18951, -26732}, {18324, -27166},
      {17687, -27585}, {17040, -27989}, {16384, -28378}, {15719, -28751}, {15046, -29109}, {14365, -29452},
      {13675, -29778}, {12979, -30088}, {12275, -30382}, {11565, -30659}, {10848, -30920}, {10126, -31164},
      {9398, -31391},  {8665, -31602},  {7927, -31795},  {7185, -31971},  {6439, -32129},  {5690, -32270},
      {4938, -32394},  {4183, -32500},  {3425, -32588},  {2666, -32659},  {1905, -32713},  {1144, -32748}}},
    {{{32760, -715},   {32737, -1429},  {32698, -2143},  {32643, -2856},  {32573, -3567},  {32488, -4277},
      {32387, -4985},  {32270, -5690},  {32138, -6393},  {31991, -7092},  {31829, -7788},  {31651, -8481},
      {31459, -9169},  {31251, -9854},  {31029, -10533}, {30792, -11207}, {30540, -11876}, {30274, -12540},
      {29993, -13197}, {29698, -13848}, {29389, -14493}, {29066, -15131}, {28729, -15761}, {28378, -16384},
      {28014, -16999}, {27636, -17606}, {27246, -18205}, {26842, -18795}, {26426, -19376}, {25997, -19948},
      {25555, -20510}, {25102, -21063}, {24636, -21605}, {24159, -22138}, {23670, -22659}, {23170, -23170},
      {22659, -23670}, {22138, -24159}, {21605, -24636}, {21063, -25102}, {20510, -25555}, {19948, -25997},
      {19376, -26426}, {18795, -26842}, {18205, -27246}, {17606, -27636}, {16999, -28014}, {16384, -28378},
      {15761, -28729}, {15131, -29066}, {14493, -29389}, {13848, -29698}, {13197, -29993}, {12540, -30274},
      {11876, -30540}, {11207, -30792}, {10533, -31029}, {9854, -31251},  {9169, -31459},  {8481, -31651},
      {7788, -31829},  {7092, -31991},  {6393, -32138},  {5690, -32270},  {4985, -32387},  {4277, -32488}}},
    {{{32761, -686},   {32739, -1372},  {32703, -2058},  {32653, -2742},  {32588, -3425},  {32510, -4107},
      {32416, -4787},  {32309, -5465},  {32188, -6140},  {32052, -6813},  {31902, -7483},  {31739, -8149},
      {31561, -8812},  {31369, -9471},  {31164, -10126}, {30945, -10776}, {30713, -11422}, {30467, -12063},
      {30208, -12698}, {29935, -13328}, {29649, -13952}, {29351, -14570}, {29039, -15181}, {28715, -15786},
      {28378, -16384}, {28029, -16975}, {27667, -17558}, {27293, -18134}, {26907, -18701}, {26510, -19261},
      {26101, -19812}, {25680, -20354}, {25248, -20887}, {24805, -21411}, {24351, -21926}, {23887, -22431},
      {23412, -22927}, {22927, -23412}, {22431, -23887}, {21926, -24351}, {21411, -24805}, {20887, -25248},
      {20354, -25680}, {19812, -26101}, {19261, -26510}, {18701, -26907}, {18134, -27293}, {17558, -27667},
      {16975, -28029}, {16384, -28378}, {15786, -28715}, {15181, -29039}, {14570, -29351}, {13952, -29649},
      {13328, -29935}, {12698, -30208}, {12063, -30467}, {11422, -30713}, {10776, -30945}, {10126, -31164},
      {9471, -31369},  {8812, -31561},  {8149, -31739},  {7483, -31902},  {6813, -32052},  {6140, -32188}}},
    {{{32762, -643},   {32743, -1286},  {32711, -1929},  {32667, -2571},  {32610, -3212},  {32541, -3851},
      {32459, -4490},  {32365, -5126},  {32258, -5760},  {32138, -6393},  {32007, -7022},  {31863, -7650},
      {31706, -8274},  {31538, -8895},  {31357, -9512},  {31164, -10126}, {30959, -10736}, {30743, -11342},
      {30514, -11943}, {30274, -12540}, {30022, -13132}, {29758, -13719}, {29483, -14300}, {29197, -14876},
      {28899, -15447}, {28590, -16011}, {28270, -16569}, {27939, -17121}, {27598, -17666}, {27246, -18205},
      {26883, -18736}, {26510, -19261}, {26127, -19777}, {25733, -20286}, {25330, -20788}, {24917, -21281},
      {24494, -21766}, {24062, -22243}, {23621, -22711}, {23170, -23170}, {22711, -23621}, {22243, -24062},
      {21766, -24494}, {21281, -24917}, {20788, -25330}, {20286, -25733}, {19777, -26127}, {19261, -26510},
      {18736, -26883}, {18205, -27246}, {17666, -27598}, {17121, -27939}, {16569, -28270}, {16011, -28590},
      {15447, -28899}, {14876, -29197}, {14300, -29483}, {13719, -29758}, {13132, -30022}, {12540, -30274},
      {11943, -30514}, {11342, -30743}, {10736, -30959}, {10126, -31164}, {9512, -31357},  {8895, -31538}}},
    {{{32762, -635},   {32743, -1271},  {32713, -1905},  {32669, -2539},  {32614, -3172},  {32546, -3804},
      {32467, -4435},  {32374, -5063},  {32270, -5690},  {32154, -6315},  {32025, -6937},  {31885, -7557},
      {31732, -8174},  {31568, -8787},  {31391, -9398},  {31203, -10005}, {31003, -10608}, {30792, -11207},
      {30569, -11802}, {30334, -12393}, {30088, -12979}, {29831, -13560}, {29562, -14136}, {29283, -14706},
      {28992, -15271}, {28690, -15831}, {28378, -16384}, {28055, -16931}, {27721, -17472}, {27377, -18006},
      {27023, -18534}, {26658, -19054}, {26284, -19568}, {25900, -20074}, {25505, -20572}, {25102, -21063},
      {24689, -21546}, {24266, -22020}, {23835, -22487}, {23394, -22945}, {22945, -23394}, {22487, -23835},
      {22020, -24266}, {21546, -24689}, {21063, -25102}, {20572, -25505}, {20074, -25900}, {19568, -26284},
      {19054, -26658}, {18534, -27023}, {18006, -27377}, {17472, -27721}, {16931, -28055}, {16384, -28378},
      {15831, -28690}, {15271, -28992}, {14706, -29283}, {14136, -29562}, {13560, -29831}, {12979, -30088},
      {12393, -30334}, {11802, -30569}, {11207, -30792}, {10608, -31003}, {10005, -31203}, {9398, -31391}}},
    {{{32763, -572},   {32748, -1144},  {32723, -1715},  {32688, -2286},  {32643, -2856},  {32588, -3425},
      {32524, -3993},  {32449, -4560},  {32365, -5126},  {32270, -5690},  {32166, -6252},  {32052, -6813},
      {31928, -7371},  {31795, -7927},  {31651, -8481},  {31499, -9032},  {31336, -9580},  {31164, -10126},
      {30983, -10668}, {30792, -11207}, {30592, -11743}, {30382, -12275}, {30163, -12803}, {29935, -13328},
      {29698, -13848}, {29452, -14365}, {29197, -14876}, {28932, -15384}, {28660, -15886}, {28378, -16384},
      {28088, -16877}, {27789, -17364}, {27482, -17847}, {27166, -18324}, {26842, -18795}, {26510, -19261},
      {26170, -19720}, {25822, -20174}, {25466, -20622}, {25102, -21063}, {24730, -21498}, {24351, -21926},
      {23965, -22348}, {23571, -22763}, {23170, -23170}, {22763, -23571}, {22348, -23965}, {21926, -24351},
      {21498, -24730}, {21063, -25102}, {20622, -25466}, {20174, -25822}, {19720, -26170}, {19261, -26510},
      {18795, -26842}, {18324, -27166}, {17847, -27482}, {17364, -27789}, {16877, -28088}, {16384, -28378},
      {15886, -28660}, {15384, -28932}, {14876, -29197}, {14365, -29452}, {13848, -29698}, {13328, -29935}}},
    {{{32763, -549},   {32750, -1098},  {32727, -1646},  {32694, -2194},  {32653, -2742},  {32603, -3289},
      {32543, -3834},  {32474, -4379},  {32396, -4923},  {32309, -5465},  {32213, -6005},  {32108, -6544},
      {31994, -7081},  {31871, -7616},  {31739, -8149},  {31598, -8680},  {31448, -9208},  {31289, -9733},
      {31122, -10256}, {30945, -10776}, {30760, -11293}, {30567, -11807}, {30365, -12318}, {30154, -12825},
      {29935, -13328}, {29708, -13828}, {29472, -14323}, {29228, -14815}, {28975, -15303}, {28715, -15786},
      {28446, -16265}, {28170, -16739}, {27885, -17209}, {27593, -17674}, {27293, -18134}, {26986, -18588},
      {26670, -19038}, {26348, -19482}, {26017, -19921}, {25680, -20354}, {25335, -20781}, {24984, -21203},
      {24625, -21618}, {24259, -22028}, {23887, -22431}, {23508, -22828}, {23122, -23219}, {22730, -23603},
      {22331, -23981}, {21926, -24351}, {21515, -24715}, {21098, -25072}, {20675, -25422}, {20246, -25765},
      {19812, -26101}, {19371, -26429}, {18926, -26750}, {18475, -27063}, {18019, -27369}, {17558, -27667},
      {17092, -27957}, {16621, -28240}, {16146, -28514}, {15666, -28781}, {15181, -29039}, {14693, -29289}}},
    {{{32764, -536},   {32750, -1072},  {32729, -1608},  {32698, -2143},  {32658, -2678},  {32610, -3212},
      {32553, -3745},  {32488, -4277},  {32413, -4808},  {32330, -5338},  {32239, -5866},  {32138, -6393},
      {32029, -6918},  {31912, -7441},  {31786, -7962},  {31651, -8481},  {31508, -8998},  {31357, -9512},
      {31197, -10024}, {31029, -10533}, {30853, -11039}, {30668, -11543}, {30475, -12043}, {30274, -12540},
      {30064, -13033}, {29847, -13524}, {29622, -14010}, {29389, -14493}, {29148, -14972}, {28899, -15447},
      {28642, -15917}, {28378, -16384}, {28106, -16846}, {27827, -17304}, {27540, -17757}, {27246, -18205},
      {26944, -18648}, {26635, -19087}, {26320, -19520}, {25997, -19948}, {25667, -20371}, {25330, -20788},
      {24986, -21199}, {24636, -21605}, {24279, -22006}, {23916, -22400}, {23546, -22788}, {23170, -23170},
      {22788, -23546}, {22400, -23916}, {22006, -24279}, {21605, -24636}, {21199, -24986}, {20788, -25330},
      {20371, -25667}, {19948, -25997}, {19520, -26320}, {19087, -26635}, {18648, -26944}, {18205, -27246},
      {17757, -27540}, {17304, -27827}, {16846, -28106}, {16384, -28378}, {15917, -28642}, {15447, -28899}}},
    {{{32764, -515},   {32752, -1029},  {32732, -1544},  {32703, -2058},  {32667, -2571},  {32623, -3084},
      {32570, -3596},  {32510, -4107},  {32441, -4617},  {32365, -5126},  {32280, -5634},  {32188, -6140},
      {32087, -6645},  {31979, -7148},  {31863, -7650},  {31739, -8149},  {31607, -8647},  {31467, -9142},
      {31319, -9635},  {31164, -10126}, {31001, -10614}, {30831, -11100}, {30653, -11583}, {30467, -12063},
      {30274, -12540}, {30073, -13014}, {29865, -13485}, {29649, -13952}, {29427, -14416}, {29197, -14876},
      {28959, -15333}, {28715, -15786}, {28463, -16235}, {28205, -16680}, {27939, -17121}, {27667, -17558},
      {27388, -17990}, {27102, -18418}, {26809, -18842}, {26510, -19261}, {26204, -19675}, {25892, -20084},
      {25573, -20488}, {25248, -20887}, {24917, -21281}, {24580, -21670}, {24236, -22053}, {23887, -22431},
      {23532, -22804}, {23170, -23170}, {22804, -23532}, {22431, -23887}, {22053, -24236}, {21670, -24580},
      {21281, -24917}, {20887, -25248}, {20488, -25573}, {20084, -25892}, {19675, -26204}, {19261, -26510},
      {18842, -26809}, {18418, -27102}, {17990, -27388}, {17558, -27667}, {17121, -27939}, {16680, -28205}}},
    {{{32764, -508},   {32752, -1017},  {32733, -1525},  {32705, -2032},  {32669, -2539},  {32626, -3046},
      {32575, -3552},  {32516, -4056},  {32449, -4560},  {32374, -5063},  {32292, -5565},  {32202, -6065},
      {32104, -6564},  {31998, -7061},  {31885, -7557},  {31764, -8051},  {31635, -8542},  {31499, -9032},
      {31355, -9520},  {31203, -10005}, {31044, -10488}, {30878, -10968}, {30704, -11446}, {30523, -11921},
      {30334, -12393}, {30138, -12862}, {29935, -13328}, {29725, -13791}, {29507, -14250}, {29283, -14706},
      {29051, -15159}, {28812, -15608}, {28567, -16053}, {28314, -16494}, {28055, -16931}, {27789, -17364},
      {27516, -17793}, {27237, -18218}, {26951, -18638}, {26658, -19054}, {26360, -19466}, {26055, -19872},
      {25743, -20274}, {25425, -20671}, {25102, -21063}, {24772, -21450}, {24436, -21831}, {24095, -22208},
      {23747, -22579}, {23394, -22945}, {23035, -23305}, {22671, -23659}, {22301, -24008}, {21926, -24351},
      {21546, -24689}, {21160, -25020}, {20769, -25345}, {20374, -25664}, {19973, -25977}, {19568, -26284},
      {19158, -26584}, {18743, -26878}, {18324, -27166}, {17900, -27447}, {17472, -27721}, {17040, -27989}}},
}};

#endif // __MRFFT_DYN_TWIDDLE_LUT_DIT_H__
