/*
 * Copyright (C) 2019-2022, Xilinx, Inc.
 * Copyright (C) 2022-2025, Advanced Micro Devices, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef __FFT_TWIDDLE_LUT_DIT_ALL_H__
#define __FFT_TWIDDLE_LUT_DIT_ALL_H__
#include "device_defs.h" //for _SUPPORTS_CBFLOAT_
#include "fft_com_inc.h"
// DO NOT HAND EDIT THIS FILE. IT WAS CREATED using ../tests/inc/twiddle_32.c

const cfloat twiddle_master_cfloat[2048] = {{1.000000, -0.000000},  {0.999999, -0.001534},  {0.999995, -0.003068},
                                            {0.999989, -0.004602},  {0.999981, -0.006136},  {0.999971, -0.007670},
                                            {0.999958, -0.009204},  {0.999942, -0.010738},

                                            {0.999925, -0.012272},  {0.999905, -0.013805},  {0.999882, -0.015339},
                                            {0.999858, -0.016873},  {0.999831, -0.018407},  {0.999801, -0.019940},
                                            {0.999769, -0.021474},  {0.999735, -0.023008},

                                            {0.999699, -0.024541},  {0.999660, -0.026075},  {0.999619, -0.027608},
                                            {0.999575, -0.029142},  {0.999529, -0.030675},  {0.999481, -0.032208},
                                            {0.999431, -0.033741},  {0.999378, -0.035274},

                                            {0.999322, -0.036807},  {0.999265, -0.038340},  {0.999205, -0.039873},
                                            {0.999142, -0.041406},  {0.999078, -0.042938},  {0.999011, -0.044471},
                                            {0.998941, -0.046003},  {0.998870, -0.047535},

                                            {0.998795, -0.049068},  {0.998719, -0.050600},  {0.998640, -0.052132},
                                            {0.998559, -0.053664},  {0.998476, -0.055195},  {0.998390, -0.056727},
                                            {0.998302, -0.058258},  {0.998211, -0.059790},

                                            {0.998118, -0.061321},  {0.998023, -0.062852},  {0.997925, -0.064383},
                                            {0.997825, -0.065913},  {0.997723, -0.067444},  {0.997618, -0.068974},
                                            {0.997511, -0.070505},  {0.997402, -0.072035},

                                            {0.997290, -0.073565},  {0.997176, -0.075094},  {0.997060, -0.076624},
                                            {0.996941, -0.078153},  {0.996820, -0.079682},  {0.996697, -0.081211},
                                            {0.996571, -0.082740},  {0.996443, -0.084269},

                                            {0.996313, -0.085797},  {0.996180, -0.087326},  {0.996045, -0.088854},
                                            {0.995907, -0.090381},  {0.995767, -0.091909},  {0.995625, -0.093436},
                                            {0.995481, -0.094963},  {0.995334, -0.096490},

                                            {0.995185, -0.098017},  {0.995033, -0.099544},  {0.994879, -0.101070},
                                            {0.994723, -0.102596},  {0.994565, -0.104122},  {0.994404, -0.105647},
                                            {0.994240, -0.107172},  {0.994075, -0.108697},

                                            {0.993907, -0.110222},  {0.993737, -0.111747},  {0.993564, -0.113271},
                                            {0.993389, -0.114795},  {0.993212, -0.116319},  {0.993032, -0.117842},
                                            {0.992850, -0.119365},  {0.992666, -0.120888},

                                            {0.992480, -0.122411},  {0.992291, -0.123933},  {0.992099, -0.125455},
                                            {0.991906, -0.126977},  {0.991710, -0.128498},  {0.991511, -0.130019},
                                            {0.991311, -0.131540},  {0.991108, -0.133061},

                                            {0.990903, -0.134581},  {0.990695, -0.136101},  {0.990485, -0.137620},
                                            {0.990273, -0.139139},  {0.990058, -0.140658},  {0.989841, -0.142177},
                                            {0.989622, -0.143695},  {0.989400, -0.145213},

                                            {0.989177, -0.146730},  {0.988950, -0.148248},  {0.988722, -0.149765},
                                            {0.988491, -0.151281},  {0.988258, -0.152797},  {0.988022, -0.154313},
                                            {0.987784, -0.155828},  {0.987544, -0.157343},

                                            {0.987301, -0.158858},  {0.987057, -0.160372},  {0.986809, -0.161886},
                                            {0.986560, -0.163400},  {0.986308, -0.164913},  {0.986054, -0.166426},
                                            {0.985798, -0.167938},  {0.985539, -0.169450},

                                            {0.985278, -0.170962},  {0.985014, -0.172473},  {0.984748, -0.173984},
                                            {0.984480, -0.175494},  {0.984210, -0.177004},  {0.983937, -0.178514},
                                            {0.983662, -0.180023},  {0.983385, -0.181532},

                                            {0.983105, -0.183040},  {0.982824, -0.184548},  {0.982539, -0.186055},
                                            {0.982253, -0.187562},  {0.981964, -0.189069},  {0.981673, -0.190575},
                                            {0.981379, -0.192080},  {0.981083, -0.193586},

                                            {0.980785, -0.195090},  {0.980485, -0.196595},  {0.980182, -0.198098},
                                            {0.979877, -0.199602},  {0.979570, -0.201105},  {0.979260, -0.202607},
                                            {0.978948, -0.204109},  {0.978634, -0.205610},

                                            {0.978317, -0.207111},  {0.977998, -0.208612},  {0.977677, -0.210112},
                                            {0.977354, -0.211611},  {0.977028, -0.213110},  {0.976700, -0.214609},
                                            {0.976370, -0.216107},  {0.976037, -0.217604},

                                            {0.975702, -0.219101},  {0.975365, -0.220598},  {0.975025, -0.222094},
                                            {0.974684, -0.223589},  {0.974339, -0.225084},  {0.973993, -0.226578},
                                            {0.973644, -0.228072},  {0.973293, -0.229565},

                                            {0.972940, -0.231058},  {0.972584, -0.232550},  {0.972227, -0.234042},
                                            {0.971866, -0.235533},  {0.971504, -0.237024},  {0.971139, -0.238514},
                                            {0.970772, -0.240003},  {0.970403, -0.241492},

                                            {0.970031, -0.242980},  {0.969657, -0.244468},  {0.969281, -0.245955},
                                            {0.968903, -0.247442},  {0.968522, -0.248928},  {0.968139, -0.250413},
                                            {0.967754, -0.251898},  {0.967366, -0.253382},

                                            {0.966976, -0.254866},  {0.966584, -0.256349},  {0.966190, -0.257831},
                                            {0.965793, -0.259313},  {0.965394, -0.260794},  {0.964993, -0.262275},
                                            {0.964590, -0.263755},  {0.964184, -0.265234},

                                            {0.963776, -0.266713},  {0.963366, -0.268191},  {0.962953, -0.269668},
                                            {0.962538, -0.271145},  {0.962121, -0.272621},  {0.961702, -0.274097},
                                            {0.961280, -0.275572},  {0.960857, -0.277046},

                                            {0.960431, -0.278520},  {0.960002, -0.279993},  {0.959572, -0.281465},
                                            {0.959139, -0.282937},  {0.958703, -0.284408},  {0.958266, -0.285878},
                                            {0.957826, -0.287347},  {0.957385, -0.288816},

                                            {0.956940, -0.290285},  {0.956494, -0.291752},  {0.956045, -0.293219},
                                            {0.955594, -0.294685},  {0.955141, -0.296151},  {0.954686, -0.297616},
                                            {0.954228, -0.299080},  {0.953768, -0.300543},

                                            {0.953306, -0.302006},  {0.952842, -0.303468},  {0.952375, -0.304929},
                                            {0.951906, -0.306390},  {0.951435, -0.307850},  {0.950962, -0.309309},
                                            {0.950486, -0.310767},  {0.950008, -0.312225},

                                            {0.949528, -0.313682},  {0.949046, -0.315138},  {0.948561, -0.316593},
                                            {0.948075, -0.318048},  {0.947586, -0.319502},  {0.947094, -0.320955},
                                            {0.946601, -0.322408},  {0.946105, -0.323859},

                                            {0.945607, -0.325310},  {0.945107, -0.326760},  {0.944605, -0.328210},
                                            {0.944100, -0.329658},  {0.943593, -0.331106},  {0.943084, -0.332553},
                                            {0.942573, -0.334000},  {0.942060, -0.335445},

                                            {0.941544, -0.336890},  {0.941026, -0.338334},  {0.940506, -0.339777},
                                            {0.939984, -0.341219},  {0.939459, -0.342661},  {0.938932, -0.344101},
                                            {0.938404, -0.345541},  {0.937872, -0.346980},

                                            {0.937339, -0.348419},  {0.936803, -0.349856},  {0.936266, -0.351293},
                                            {0.935726, -0.352729},  {0.935184, -0.354164},  {0.934639, -0.355598},
                                            {0.934093, -0.357031},  {0.933544, -0.358463},

                                            {0.932993, -0.359895},  {0.932440, -0.361326},  {0.931884, -0.362756},
                                            {0.931327, -0.364185},  {0.930767, -0.365613},  {0.930205, -0.367040},
                                            {0.929641, -0.368467},  {0.929075, -0.369892},

                                            {0.928506, -0.371317},  {0.927935, -0.372741},  {0.927363, -0.374164},
                                            {0.926787, -0.375586},  {0.926210, -0.377007},  {0.925631, -0.378428},
                                            {0.925049, -0.379847},  {0.924465, -0.381266},

                                            {0.923880, -0.382683},  {0.923291, -0.384100},  {0.922701, -0.385516},
                                            {0.922109, -0.386931},  {0.921514, -0.388345},  {0.920917, -0.389758},
                                            {0.920318, -0.391170},  {0.919717, -0.392582},

                                            {0.919114, -0.393992},  {0.918508, -0.395401},  {0.917901, -0.396810},
                                            {0.917291, -0.398218},  {0.916679, -0.399624},  {0.916065, -0.401030},
                                            {0.915449, -0.402435},  {0.914830, -0.403838},

                                            {0.914210, -0.405241},  {0.913587, -0.406643},  {0.912962, -0.408044},
                                            {0.912335, -0.409444},  {0.911706, -0.410843},  {0.911075, -0.412241},
                                            {0.910441, -0.413638},  {0.909806, -0.415034},

                                            {0.909168, -0.416430},  {0.908528, -0.417824},  {0.907886, -0.419217},
                                            {0.907242, -0.420609},  {0.906596, -0.422000},  {0.905947, -0.423390},
                                            {0.905297, -0.424780},  {0.904644, -0.426168},

                                            {0.903989, -0.427555},  {0.903332, -0.428941},  {0.902673, -0.430326},
                                            {0.902012, -0.431711},  {0.901349, -0.433094},  {0.900683, -0.434476},
                                            {0.900016, -0.435857},  {0.899346, -0.437237},

                                            {0.898674, -0.438616},  {0.898001, -0.439994},  {0.897325, -0.441371},
                                            {0.896646, -0.442747},  {0.895966, -0.444122},  {0.895284, -0.445496},
                                            {0.894599, -0.446869},  {0.893913, -0.448241},

                                            {0.893224, -0.449611},  {0.892534, -0.450981},  {0.891841, -0.452350},
                                            {0.891146, -0.453717},  {0.890449, -0.455084},  {0.889750, -0.456449},
                                            {0.889048, -0.457813},  {0.888345, -0.459177},

                                            {0.887640, -0.460539},  {0.886932, -0.461900},  {0.886223, -0.463260},
                                            {0.885511, -0.464619},  {0.884797, -0.465977},  {0.884081, -0.467333},
                                            {0.883363, -0.468689},  {0.882643, -0.470043},

                                            {0.881921, -0.471397},  {0.881197, -0.472749},  {0.880471, -0.474100},
                                            {0.879743, -0.475450},  {0.879012, -0.476799},  {0.878280, -0.478147},
                                            {0.877545, -0.479494},  {0.876809, -0.480839},

                                            {0.876070, -0.482184},  {0.875329, -0.483527},  {0.874587, -0.484869},
                                            {0.873842, -0.486210},  {0.873095, -0.487550},  {0.872346, -0.488889},
                                            {0.871595, -0.490226},  {0.870842, -0.491563},

                                            {0.870087, -0.492898},  {0.869330, -0.494232},  {0.868571, -0.495565},
                                            {0.867809, -0.496897},  {0.867046, -0.498228},  {0.866281, -0.499557},
                                            {0.865514, -0.500885},  {0.864744, -0.502212},

                                            {0.863973, -0.503538},  {0.863199, -0.504863},  {0.862424, -0.506187},
                                            {0.861646, -0.507509},  {0.860867, -0.508830},  {0.860085, -0.510150},
                                            {0.859302, -0.511469},  {0.858516, -0.512786},

                                            {0.857729, -0.514103},  {0.856939, -0.515418},  {0.856147, -0.516732},
                                            {0.855354, -0.518045},  {0.854558, -0.519356},  {0.853760, -0.520666},
                                            {0.852961, -0.521975},  {0.852159, -0.523283},

                                            {0.851355, -0.524590},  {0.850549, -0.525895},  {0.849742, -0.527199},
                                            {0.848932, -0.528502},  {0.848120, -0.529804},  {0.847307, -0.531104},
                                            {0.846491, -0.532403},  {0.845673, -0.533701},

                                            {0.844854, -0.534998},  {0.844032, -0.536293},  {0.843208, -0.537587},
                                            {0.842383, -0.538880},  {0.841555, -0.540171},  {0.840725, -0.541462},
                                            {0.839894, -0.542751},  {0.839060, -0.544039},

                                            {0.838225, -0.545325},  {0.837387, -0.546610},  {0.836548, -0.547894},
                                            {0.835706, -0.549177},  {0.834863, -0.550458},  {0.834018, -0.551738},
                                            {0.833170, -0.553017},  {0.832321, -0.554294},

                                            {0.831470, -0.555570},  {0.830616, -0.556845},  {0.829761, -0.558119},
                                            {0.828904, -0.559391},  {0.828045, -0.560662},  {0.827184, -0.561931},
                                            {0.826321, -0.563199},  {0.825456, -0.564466},

                                            {0.824589, -0.565732},  {0.823721, -0.566996},  {0.822850, -0.568259},
                                            {0.821977, -0.569521},  {0.821102, -0.570781},  {0.820226, -0.572040},
                                            {0.819348, -0.573297},  {0.818467, -0.574553},

                                            {0.817585, -0.575808},  {0.816701, -0.577062},  {0.815814, -0.578314},
                                            {0.814926, -0.579565},  {0.814036, -0.580814},  {0.813144, -0.582062},
                                            {0.812251, -0.583309},  {0.811355, -0.584554},

                                            {0.810457, -0.585798},  {0.809558, -0.587040},  {0.808656, -0.588282},
                                            {0.807753, -0.589521},  {0.806848, -0.590760},  {0.805940, -0.591997},
                                            {0.805031, -0.593232},  {0.804120, -0.594467},

                                            {0.803208, -0.595699},  {0.802293, -0.596931},  {0.801376, -0.598161},
                                            {0.800458, -0.599389},  {0.799537, -0.600616},  {0.798615, -0.601842},
                                            {0.797691, -0.603067},  {0.796765, -0.604290},

                                            {0.795837, -0.605511},  {0.794907, -0.606731},  {0.793975, -0.607950},
                                            {0.793042, -0.609167},  {0.792107, -0.610383},  {0.791169, -0.611597},
                                            {0.790230, -0.612810},  {0.789289, -0.614022},

                                            {0.788346, -0.615232},  {0.787402, -0.616440},  {0.786455, -0.617647},
                                            {0.785507, -0.618853},  {0.784557, -0.620057},  {0.783605, -0.621260},
                                            {0.782651, -0.622461},  {0.781695, -0.623661},

                                            {0.780737, -0.624860},  {0.779778, -0.626056},  {0.778817, -0.627252},
                                            {0.777853, -0.628446},  {0.776888, -0.629638},  {0.775922, -0.630829},
                                            {0.774953, -0.632019},  {0.773983, -0.633207},

                                            {0.773010, -0.634393},  {0.772036, -0.635578},  {0.771061, -0.636762},
                                            {0.770083, -0.637944},  {0.769103, -0.639124},  {0.768122, -0.640303},
                                            {0.767139, -0.641481},  {0.766154, -0.642657},

                                            {0.765167, -0.643832},  {0.764179, -0.645005},  {0.763188, -0.646176},
                                            {0.762196, -0.647346},  {0.761202, -0.648514},  {0.760207, -0.649681},
                                            {0.759209, -0.650847},  {0.758210, -0.652011},

                                            {0.757209, -0.653173},  {0.756206, -0.654334},  {0.755201, -0.655493},
                                            {0.754195, -0.656651},  {0.753187, -0.657807},  {0.752177, -0.658961},
                                            {0.751165, -0.660114},  {0.750152, -0.661266},

                                            {0.749136, -0.662416},  {0.748119, -0.663564},  {0.747101, -0.664711},
                                            {0.746080, -0.665856},  {0.745058, -0.667000},  {0.744034, -0.668142},
                                            {0.743008, -0.669283},  {0.741980, -0.670422},

                                            {0.740951, -0.671559},  {0.739920, -0.672695},  {0.738887, -0.673829},
                                            {0.737853, -0.674962},  {0.736817, -0.676093},  {0.735779, -0.677222},
                                            {0.734739, -0.678350},  {0.733697, -0.679476},

                                            {0.732654, -0.680601},  {0.731609, -0.681724},  {0.730563, -0.682846},
                                            {0.729514, -0.683965},  {0.728464, -0.685084},  {0.727413, -0.686200},
                                            {0.726359, -0.687315},  {0.725304, -0.688429},

                                            {0.724247, -0.689541},  {0.723188, -0.690651},  {0.722128, -0.691759},
                                            {0.721066, -0.692866},  {0.720003, -0.693971},  {0.718937, -0.695075},
                                            {0.717870, -0.696177},  {0.716801, -0.697277},

                                            {0.715731, -0.698376},  {0.714659, -0.699473},  {0.713585, -0.700569},
                                            {0.712509, -0.701663},  {0.711432, -0.702755},  {0.710353, -0.703845},
                                            {0.709273, -0.704934},  {0.708191, -0.706021},

                                            {0.707107, -0.707107},  {0.706021, -0.708191},  {0.704934, -0.709273},
                                            {0.703845, -0.710353},  {0.702755, -0.711432},  {0.701663, -0.712509},
                                            {0.700569, -0.713585},  {0.699473, -0.714659},

                                            {0.698376, -0.715731},  {0.697277, -0.716801},  {0.696177, -0.717870},
                                            {0.695075, -0.718937},  {0.693971, -0.720003},  {0.692866, -0.721066},
                                            {0.691759, -0.722128},  {0.690651, -0.723188},

                                            {0.689541, -0.724247},  {0.688429, -0.725304},  {0.687315, -0.726359},
                                            {0.686200, -0.727413},  {0.685084, -0.728464},  {0.683965, -0.729514},
                                            {0.682846, -0.730563},  {0.681724, -0.731609},

                                            {0.680601, -0.732654},  {0.679476, -0.733697},  {0.678350, -0.734739},
                                            {0.677222, -0.735779},  {0.676093, -0.736817},  {0.674962, -0.737853},
                                            {0.673829, -0.738887},  {0.672695, -0.739920},

                                            {0.671559, -0.740951},  {0.670422, -0.741980},  {0.669283, -0.743008},
                                            {0.668142, -0.744034},  {0.667000, -0.745058},  {0.665856, -0.746080},
                                            {0.664711, -0.747101},  {0.663564, -0.748119},

                                            {0.662416, -0.749136},  {0.661266, -0.750152},  {0.660114, -0.751165},
                                            {0.658961, -0.752177},  {0.657807, -0.753187},  {0.656651, -0.754195},
                                            {0.655493, -0.755201},  {0.654334, -0.756206},

                                            {0.653173, -0.757209},  {0.652011, -0.758210},  {0.650847, -0.759209},
                                            {0.649681, -0.760207},  {0.648514, -0.761202},  {0.647346, -0.762196},
                                            {0.646176, -0.763188},  {0.645005, -0.764179},

                                            {0.643832, -0.765167},  {0.642657, -0.766154},  {0.641481, -0.767139},
                                            {0.640303, -0.768122},  {0.639124, -0.769103},  {0.637944, -0.770083},
                                            {0.636762, -0.771061},  {0.635578, -0.772036},

                                            {0.634393, -0.773010},  {0.633207, -0.773983},  {0.632019, -0.774953},
                                            {0.630829, -0.775922},  {0.629638, -0.776888},  {0.628446, -0.777853},
                                            {0.627252, -0.778817},  {0.626056, -0.779778},

                                            {0.624860, -0.780737},  {0.623661, -0.781695},  {0.622461, -0.782651},
                                            {0.621260, -0.783605},  {0.620057, -0.784557},  {0.618853, -0.785507},
                                            {0.617647, -0.786455},  {0.616440, -0.787402},

                                            {0.615232, -0.788346},  {0.614022, -0.789289},  {0.612810, -0.790230},
                                            {0.611597, -0.791169},  {0.610383, -0.792107},  {0.609167, -0.793042},
                                            {0.607950, -0.793975},  {0.606731, -0.794907},

                                            {0.605511, -0.795837},  {0.604290, -0.796765},  {0.603067, -0.797691},
                                            {0.601842, -0.798615},  {0.600616, -0.799537},  {0.599389, -0.800458},
                                            {0.598161, -0.801376},  {0.596931, -0.802293},

                                            {0.595699, -0.803208},  {0.594467, -0.804120},  {0.593232, -0.805031},
                                            {0.591997, -0.805940},  {0.590760, -0.806848},  {0.589521, -0.807753},
                                            {0.588282, -0.808656},  {0.587040, -0.809558},

                                            {0.585798, -0.810457},  {0.584554, -0.811355},  {0.583309, -0.812251},
                                            {0.582062, -0.813144},  {0.580814, -0.814036},  {0.579565, -0.814926},
                                            {0.578314, -0.815814},  {0.577062, -0.816701},

                                            {0.575808, -0.817585},  {0.574553, -0.818467},  {0.573297, -0.819348},
                                            {0.572040, -0.820226},  {0.570781, -0.821102},  {0.569521, -0.821977},
                                            {0.568259, -0.822850},  {0.566996, -0.823721},

                                            {0.565732, -0.824589},  {0.564466, -0.825456},  {0.563199, -0.826321},
                                            {0.561931, -0.827184},  {0.560662, -0.828045},  {0.559391, -0.828904},
                                            {0.558119, -0.829761},  {0.556845, -0.830616},

                                            {0.555570, -0.831470},  {0.554294, -0.832321},  {0.553017, -0.833170},
                                            {0.551738, -0.834018},  {0.550458, -0.834863},  {0.549177, -0.835706},
                                            {0.547894, -0.836548},  {0.546610, -0.837387},

                                            {0.545325, -0.838225},  {0.544039, -0.839060},  {0.542751, -0.839894},
                                            {0.541462, -0.840725},  {0.540171, -0.841555},  {0.538880, -0.842383},
                                            {0.537587, -0.843208},  {0.536293, -0.844032},

                                            {0.534998, -0.844854},  {0.533701, -0.845673},  {0.532403, -0.846491},
                                            {0.531104, -0.847307},  {0.529804, -0.848120},  {0.528502, -0.848932},
                                            {0.527199, -0.849742},  {0.525895, -0.850549},

                                            {0.524590, -0.851355},  {0.523283, -0.852159},  {0.521975, -0.852961},
                                            {0.520666, -0.853760},  {0.519356, -0.854558},  {0.518045, -0.855354},
                                            {0.516732, -0.856147},  {0.515418, -0.856939},

                                            {0.514103, -0.857729},  {0.512786, -0.858516},  {0.511469, -0.859302},
                                            {0.510150, -0.860085},  {0.508830, -0.860867},  {0.507509, -0.861646},
                                            {0.506187, -0.862424},  {0.504863, -0.863199},

                                            {0.503538, -0.863973},  {0.502212, -0.864744},  {0.500885, -0.865514},
                                            {0.499557, -0.866281},  {0.498228, -0.867046},  {0.496897, -0.867809},
                                            {0.495565, -0.868571},  {0.494232, -0.869330},

                                            {0.492898, -0.870087},  {0.491563, -0.870842},  {0.490226, -0.871595},
                                            {0.488889, -0.872346},  {0.487550, -0.873095},  {0.486210, -0.873842},
                                            {0.484869, -0.874587},  {0.483527, -0.875329},

                                            {0.482184, -0.876070},  {0.480839, -0.876809},  {0.479494, -0.877545},
                                            {0.478147, -0.878280},  {0.476799, -0.879012},  {0.475450, -0.879743},
                                            {0.474100, -0.880471},  {0.472749, -0.881197},

                                            {0.471397, -0.881921},  {0.470043, -0.882643},  {0.468689, -0.883363},
                                            {0.467333, -0.884081},  {0.465977, -0.884797},  {0.464619, -0.885511},
                                            {0.463260, -0.886223},  {0.461900, -0.886932},

                                            {0.460539, -0.887640},  {0.459177, -0.888345},  {0.457813, -0.889048},
                                            {0.456449, -0.889750},  {0.455084, -0.890449},  {0.453717, -0.891146},
                                            {0.452350, -0.891841},  {0.450981, -0.892534},

                                            {0.449611, -0.893224},  {0.448241, -0.893913},  {0.446869, -0.894599},
                                            {0.445496, -0.895284},  {0.444122, -0.895966},  {0.442747, -0.896646},
                                            {0.441371, -0.897325},  {0.439994, -0.898001},

                                            {0.438616, -0.898674},  {0.437237, -0.899346},  {0.435857, -0.900016},
                                            {0.434476, -0.900683},  {0.433094, -0.901349},  {0.431711, -0.902012},
                                            {0.430326, -0.902673},  {0.428941, -0.903332},

                                            {0.427555, -0.903989},  {0.426168, -0.904644},  {0.424780, -0.905297},
                                            {0.423390, -0.905947},  {0.422000, -0.906596},  {0.420609, -0.907242},
                                            {0.419217, -0.907886},  {0.417824, -0.908528},

                                            {0.416430, -0.909168},  {0.415034, -0.909806},  {0.413638, -0.910441},
                                            {0.412241, -0.911075},  {0.410843, -0.911706},  {0.409444, -0.912335},
                                            {0.408044, -0.912962},  {0.406643, -0.913587},

                                            {0.405241, -0.914210},  {0.403838, -0.914830},  {0.402435, -0.915449},
                                            {0.401030, -0.916065},  {0.399624, -0.916679},  {0.398218, -0.917291},
                                            {0.396810, -0.917901},  {0.395401, -0.918508},

                                            {0.393992, -0.919114},  {0.392582, -0.919717},  {0.391170, -0.920318},
                                            {0.389758, -0.920917},  {0.388345, -0.921514},  {0.386931, -0.922109},
                                            {0.385516, -0.922701},  {0.384100, -0.923291},

                                            {0.382683, -0.923880},  {0.381266, -0.924465},  {0.379847, -0.925049},
                                            {0.378428, -0.925631},  {0.377007, -0.926210},  {0.375586, -0.926787},
                                            {0.374164, -0.927363},  {0.372741, -0.927935},

                                            {0.371317, -0.928506},  {0.369892, -0.929075},  {0.368467, -0.929641},
                                            {0.367040, -0.930205},  {0.365613, -0.930767},  {0.364185, -0.931327},
                                            {0.362756, -0.931884},  {0.361326, -0.932440},

                                            {0.359895, -0.932993},  {0.358463, -0.933544},  {0.357031, -0.934093},
                                            {0.355598, -0.934639},  {0.354164, -0.935184},  {0.352729, -0.935726},
                                            {0.351293, -0.936266},  {0.349856, -0.936803},

                                            {0.348419, -0.937339},  {0.346980, -0.937872},  {0.345541, -0.938404},
                                            {0.344101, -0.938932},  {0.342661, -0.939459},  {0.341219, -0.939984},
                                            {0.339777, -0.940506},  {0.338334, -0.941026},

                                            {0.336890, -0.941544},  {0.335445, -0.942060},  {0.334000, -0.942573},
                                            {0.332553, -0.943084},  {0.331106, -0.943593},  {0.329658, -0.944100},
                                            {0.328210, -0.944605},  {0.326760, -0.945107},

                                            {0.325310, -0.945607},  {0.323859, -0.946105},  {0.322408, -0.946601},
                                            {0.320955, -0.947094},  {0.319502, -0.947586},  {0.318048, -0.948075},
                                            {0.316593, -0.948561},  {0.315138, -0.949046},

                                            {0.313682, -0.949528},  {0.312225, -0.950008},  {0.310767, -0.950486},
                                            {0.309309, -0.950962},  {0.307850, -0.951435},  {0.306390, -0.951906},
                                            {0.304929, -0.952375},  {0.303468, -0.952842},

                                            {0.302006, -0.953306},  {0.300543, -0.953768},  {0.299080, -0.954228},
                                            {0.297616, -0.954686},  {0.296151, -0.955141},  {0.294685, -0.955594},
                                            {0.293219, -0.956045},  {0.291752, -0.956494},

                                            {0.290285, -0.956940},  {0.288816, -0.957385},  {0.287347, -0.957826},
                                            {0.285878, -0.958266},  {0.284408, -0.958703},  {0.282937, -0.959139},
                                            {0.281465, -0.959572},  {0.279993, -0.960002},

                                            {0.278520, -0.960431},  {0.277046, -0.960857},  {0.275572, -0.961280},
                                            {0.274097, -0.961702},  {0.272621, -0.962121},  {0.271145, -0.962538},
                                            {0.269668, -0.962953},  {0.268191, -0.963366},

                                            {0.266713, -0.963776},  {0.265234, -0.964184},  {0.263755, -0.964590},
                                            {0.262275, -0.964993},  {0.260794, -0.965394},  {0.259313, -0.965793},
                                            {0.257831, -0.966190},  {0.256349, -0.966584},

                                            {0.254866, -0.966976},  {0.253382, -0.967366},  {0.251898, -0.967754},
                                            {0.250413, -0.968139},  {0.248928, -0.968522},  {0.247442, -0.968903},
                                            {0.245955, -0.969281},  {0.244468, -0.969657},

                                            {0.242980, -0.970031},  {0.241492, -0.970403},  {0.240003, -0.970772},
                                            {0.238514, -0.971139},  {0.237024, -0.971504},  {0.235533, -0.971866},
                                            {0.234042, -0.972227},  {0.232550, -0.972584},

                                            {0.231058, -0.972940},  {0.229565, -0.973293},  {0.228072, -0.973644},
                                            {0.226578, -0.973993},  {0.225084, -0.974339},  {0.223589, -0.974684},
                                            {0.222094, -0.975025},  {0.220598, -0.975365},

                                            {0.219101, -0.975702},  {0.217604, -0.976037},  {0.216107, -0.976370},
                                            {0.214609, -0.976700},  {0.213110, -0.977028},  {0.211611, -0.977354},
                                            {0.210112, -0.977677},  {0.208612, -0.977998},

                                            {0.207111, -0.978317},  {0.205610, -0.978634},  {0.204109, -0.978948},
                                            {0.202607, -0.979260},  {0.201105, -0.979570},  {0.199602, -0.979877},
                                            {0.198098, -0.980182},  {0.196595, -0.980485},

                                            {0.195090, -0.980785},  {0.193586, -0.981083},  {0.192080, -0.981379},
                                            {0.190575, -0.981673},  {0.189069, -0.981964},  {0.187562, -0.982253},
                                            {0.186055, -0.982539},  {0.184548, -0.982824},

                                            {0.183040, -0.983105},  {0.181532, -0.983385},  {0.180023, -0.983662},
                                            {0.178514, -0.983937},  {0.177004, -0.984210},  {0.175494, -0.984480},
                                            {0.173984, -0.984748},  {0.172473, -0.985014},

                                            {0.170962, -0.985278},  {0.169450, -0.985539},  {0.167938, -0.985798},
                                            {0.166426, -0.986054},  {0.164913, -0.986308},  {0.163400, -0.986560},
                                            {0.161886, -0.986809},  {0.160372, -0.987057},

                                            {0.158858, -0.987301},  {0.157343, -0.987544},  {0.155828, -0.987784},
                                            {0.154313, -0.988022},  {0.152797, -0.988258},  {0.151281, -0.988491},
                                            {0.149765, -0.988722},  {0.148248, -0.988950},

                                            {0.146730, -0.989177},  {0.145213, -0.989400},  {0.143695, -0.989622},
                                            {0.142177, -0.989841},  {0.140658, -0.990058},  {0.139139, -0.990273},
                                            {0.137620, -0.990485},  {0.136101, -0.990695},

                                            {0.134581, -0.990903},  {0.133061, -0.991108},  {0.131540, -0.991311},
                                            {0.130019, -0.991511},  {0.128498, -0.991710},  {0.126977, -0.991906},
                                            {0.125455, -0.992099},  {0.123933, -0.992291},

                                            {0.122411, -0.992480},  {0.120888, -0.992666},  {0.119365, -0.992850},
                                            {0.117842, -0.993032},  {0.116319, -0.993212},  {0.114795, -0.993389},
                                            {0.113271, -0.993564},  {0.111747, -0.993737},

                                            {0.110222, -0.993907},  {0.108697, -0.994075},  {0.107172, -0.994240},
                                            {0.105647, -0.994404},  {0.104122, -0.994565},  {0.102596, -0.994723},
                                            {0.101070, -0.994879},  {0.099544, -0.995033},

                                            {0.098017, -0.995185},  {0.096490, -0.995334},  {0.094963, -0.995481},
                                            {0.093436, -0.995625},  {0.091909, -0.995767},  {0.090381, -0.995907},
                                            {0.088854, -0.996045},  {0.087326, -0.996180},

                                            {0.085797, -0.996313},  {0.084269, -0.996443},  {0.082740, -0.996571},
                                            {0.081211, -0.996697},  {0.079682, -0.996820},  {0.078153, -0.996941},
                                            {0.076624, -0.997060},  {0.075094, -0.997176},

                                            {0.073565, -0.997290},  {0.072035, -0.997402},  {0.070505, -0.997511},
                                            {0.068974, -0.997618},  {0.067444, -0.997723},  {0.065913, -0.997825},
                                            {0.064383, -0.997925},  {0.062852, -0.998023},

                                            {0.061321, -0.998118},  {0.059790, -0.998211},  {0.058258, -0.998302},
                                            {0.056727, -0.998390},  {0.055195, -0.998476},  {0.053664, -0.998559},
                                            {0.052132, -0.998640},  {0.050600, -0.998719},

                                            {0.049068, -0.998795},  {0.047535, -0.998870},  {0.046003, -0.998941},
                                            {0.044471, -0.999011},  {0.042938, -0.999078},  {0.041406, -0.999142},
                                            {0.039873, -0.999205},  {0.038340, -0.999265},

                                            {0.036807, -0.999322},  {0.035274, -0.999378},  {0.033741, -0.999431},
                                            {0.032208, -0.999481},  {0.030675, -0.999529},  {0.029142, -0.999575},
                                            {0.027608, -0.999619},  {0.026075, -0.999660},

                                            {0.024541, -0.999699},  {0.023008, -0.999735},  {0.021474, -0.999769},
                                            {0.019940, -0.999801},  {0.018407, -0.999831},  {0.016873, -0.999858},
                                            {0.015339, -0.999882},  {0.013805, -0.999905},

                                            {0.012272, -0.999925},  {0.010738, -0.999942},  {0.009204, -0.999958},
                                            {0.007670, -0.999971},  {0.006136, -0.999981},  {0.004602, -0.999989},
                                            {0.003068, -0.999995},  {0.001534, -0.999999},

                                            {0.000000, -1.000000},  {-0.001534, -0.999999}, {-0.003068, -0.999995},
                                            {-0.004602, -0.999989}, {-0.006136, -0.999981}, {-0.007670, -0.999971},
                                            {-0.009204, -0.999958}, {-0.010738, -0.999942},

                                            {-0.012272, -0.999925}, {-0.013805, -0.999905}, {-0.015339, -0.999882},
                                            {-0.016873, -0.999858}, {-0.018407, -0.999831}, {-0.019940, -0.999801},
                                            {-0.021474, -0.999769}, {-0.023008, -0.999735},

                                            {-0.024541, -0.999699}, {-0.026075, -0.999660}, {-0.027608, -0.999619},
                                            {-0.029142, -0.999575}, {-0.030675, -0.999529}, {-0.032208, -0.999481},
                                            {-0.033741, -0.999431}, {-0.035274, -0.999378},

                                            {-0.036807, -0.999322}, {-0.038340, -0.999265}, {-0.039873, -0.999205},
                                            {-0.041406, -0.999142}, {-0.042938, -0.999078}, {-0.044471, -0.999011},
                                            {-0.046003, -0.998941}, {-0.047535, -0.998870},

                                            {-0.049068, -0.998795}, {-0.050600, -0.998719}, {-0.052132, -0.998640},
                                            {-0.053664, -0.998559}, {-0.055195, -0.998476}, {-0.056727, -0.998390},
                                            {-0.058258, -0.998302}, {-0.059790, -0.998211},

                                            {-0.061321, -0.998118}, {-0.062852, -0.998023}, {-0.064383, -0.997925},
                                            {-0.065913, -0.997825}, {-0.067444, -0.997723}, {-0.068974, -0.997618},
                                            {-0.070505, -0.997511}, {-0.072035, -0.997402},

                                            {-0.073565, -0.997290}, {-0.075094, -0.997176}, {-0.076624, -0.997060},
                                            {-0.078153, -0.996941}, {-0.079682, -0.996820}, {-0.081211, -0.996697},
                                            {-0.082740, -0.996571}, {-0.084269, -0.996443},

                                            {-0.085797, -0.996313}, {-0.087326, -0.996180}, {-0.088854, -0.996045},
                                            {-0.090381, -0.995907}, {-0.091909, -0.995767}, {-0.093436, -0.995625},
                                            {-0.094963, -0.995481}, {-0.096490, -0.995334},

                                            {-0.098017, -0.995185}, {-0.099544, -0.995033}, {-0.101070, -0.994879},
                                            {-0.102596, -0.994723}, {-0.104122, -0.994565}, {-0.105647, -0.994404},
                                            {-0.107172, -0.994240}, {-0.108697, -0.994075},

                                            {-0.110222, -0.993907}, {-0.111747, -0.993737}, {-0.113271, -0.993564},
                                            {-0.114795, -0.993389}, {-0.116319, -0.993212}, {-0.117842, -0.993032},
                                            {-0.119365, -0.992850}, {-0.120888, -0.992666},

                                            {-0.122411, -0.992480}, {-0.123933, -0.992291}, {-0.125455, -0.992099},
                                            {-0.126977, -0.991906}, {-0.128498, -0.991710}, {-0.130019, -0.991511},
                                            {-0.131540, -0.991311}, {-0.133061, -0.991108},

                                            {-0.134581, -0.990903}, {-0.136101, -0.990695}, {-0.137620, -0.990485},
                                            {-0.139139, -0.990273}, {-0.140658, -0.990058}, {-0.142177, -0.989841},
                                            {-0.143695, -0.989622}, {-0.145213, -0.989400},

                                            {-0.146730, -0.989177}, {-0.148248, -0.988950}, {-0.149765, -0.988722},
                                            {-0.151281, -0.988491}, {-0.152797, -0.988258}, {-0.154313, -0.988022},
                                            {-0.155828, -0.987784}, {-0.157343, -0.987544},

                                            {-0.158858, -0.987301}, {-0.160372, -0.987057}, {-0.161886, -0.986809},
                                            {-0.163400, -0.986560}, {-0.164913, -0.986308}, {-0.166426, -0.986054},
                                            {-0.167938, -0.985798}, {-0.169450, -0.985539},

                                            {-0.170962, -0.985278}, {-0.172473, -0.985014}, {-0.173984, -0.984748},
                                            {-0.175494, -0.984480}, {-0.177004, -0.984210}, {-0.178514, -0.983937},
                                            {-0.180023, -0.983662}, {-0.181532, -0.983385},

                                            {-0.183040, -0.983105}, {-0.184548, -0.982824}, {-0.186055, -0.982539},
                                            {-0.187562, -0.982253}, {-0.189069, -0.981964}, {-0.190575, -0.981673},
                                            {-0.192080, -0.981379}, {-0.193586, -0.981083},

                                            {-0.195090, -0.980785}, {-0.196595, -0.980485}, {-0.198098, -0.980182},
                                            {-0.199602, -0.979877}, {-0.201105, -0.979570}, {-0.202607, -0.979260},
                                            {-0.204109, -0.978948}, {-0.205610, -0.978634},

                                            {-0.207111, -0.978317}, {-0.208612, -0.977998}, {-0.210112, -0.977677},
                                            {-0.211611, -0.977354}, {-0.213110, -0.977028}, {-0.214609, -0.976700},
                                            {-0.216107, -0.976370}, {-0.217604, -0.976037},

                                            {-0.219101, -0.975702}, {-0.220598, -0.975365}, {-0.222094, -0.975025},
                                            {-0.223589, -0.974684}, {-0.225084, -0.974339}, {-0.226578, -0.973993},
                                            {-0.228072, -0.973644}, {-0.229565, -0.973293},

                                            {-0.231058, -0.972940}, {-0.232550, -0.972584}, {-0.234042, -0.972227},
                                            {-0.235533, -0.971866}, {-0.237024, -0.971504}, {-0.238514, -0.971139},
                                            {-0.240003, -0.970772}, {-0.241492, -0.970403},

                                            {-0.242980, -0.970031}, {-0.244468, -0.969657}, {-0.245955, -0.969281},
                                            {-0.247442, -0.968903}, {-0.248928, -0.968522}, {-0.250413, -0.968139},
                                            {-0.251898, -0.967754}, {-0.253382, -0.967366},

                                            {-0.254866, -0.966976}, {-0.256349, -0.966584}, {-0.257831, -0.966190},
                                            {-0.259313, -0.965793}, {-0.260794, -0.965394}, {-0.262275, -0.964993},
                                            {-0.263755, -0.964590}, {-0.265234, -0.964184},

                                            {-0.266713, -0.963776}, {-0.268191, -0.963366}, {-0.269668, -0.962953},
                                            {-0.271145, -0.962538}, {-0.272621, -0.962121}, {-0.274097, -0.961702},
                                            {-0.275572, -0.961280}, {-0.277046, -0.960857},

                                            {-0.278520, -0.960431}, {-0.279993, -0.960002}, {-0.281465, -0.959572},
                                            {-0.282937, -0.959139}, {-0.284408, -0.958703}, {-0.285878, -0.958266},
                                            {-0.287347, -0.957826}, {-0.288816, -0.957385},

                                            {-0.290285, -0.956940}, {-0.291752, -0.956494}, {-0.293219, -0.956045},
                                            {-0.294685, -0.955594}, {-0.296151, -0.955141}, {-0.297616, -0.954686},
                                            {-0.299080, -0.954228}, {-0.300543, -0.953768},

                                            {-0.302006, -0.953306}, {-0.303468, -0.952842}, {-0.304929, -0.952375},
                                            {-0.306390, -0.951906}, {-0.307850, -0.951435}, {-0.309309, -0.950962},
                                            {-0.310767, -0.950486}, {-0.312225, -0.950008},

                                            {-0.313682, -0.949528}, {-0.315138, -0.949046}, {-0.316593, -0.948561},
                                            {-0.318048, -0.948075}, {-0.319502, -0.947586}, {-0.320955, -0.947094},
                                            {-0.322408, -0.946601}, {-0.323859, -0.946105},

                                            {-0.325310, -0.945607}, {-0.326760, -0.945107}, {-0.328210, -0.944605},
                                            {-0.329658, -0.944100}, {-0.331106, -0.943593}, {-0.332553, -0.943084},
                                            {-0.334000, -0.942573}, {-0.335445, -0.942060},

                                            {-0.336890, -0.941544}, {-0.338334, -0.941026}, {-0.339777, -0.940506},
                                            {-0.341219, -0.939984}, {-0.342661, -0.939459}, {-0.344101, -0.938932},
                                            {-0.345541, -0.938404}, {-0.346980, -0.937872},

                                            {-0.348419, -0.937339}, {-0.349856, -0.936803}, {-0.351293, -0.936266},
                                            {-0.352729, -0.935726}, {-0.354164, -0.935184}, {-0.355598, -0.934639},
                                            {-0.357031, -0.934093}, {-0.358463, -0.933544},

                                            {-0.359895, -0.932993}, {-0.361326, -0.932440}, {-0.362756, -0.931884},
                                            {-0.364185, -0.931327}, {-0.365613, -0.930767}, {-0.367040, -0.930205},
                                            {-0.368467, -0.929641}, {-0.369892, -0.929075},

                                            {-0.371317, -0.928506}, {-0.372741, -0.927935}, {-0.374164, -0.927363},
                                            {-0.375586, -0.926787}, {-0.377007, -0.926210}, {-0.378428, -0.925631},
                                            {-0.379847, -0.925049}, {-0.381266, -0.924465},

                                            {-0.382683, -0.923880}, {-0.384100, -0.923291}, {-0.385516, -0.922701},
                                            {-0.386931, -0.922109}, {-0.388345, -0.921514}, {-0.389758, -0.920917},
                                            {-0.391170, -0.920318}, {-0.392582, -0.919717},

                                            {-0.393992, -0.919114}, {-0.395401, -0.918508}, {-0.396810, -0.917901},
                                            {-0.398218, -0.917291}, {-0.399624, -0.916679}, {-0.401030, -0.916065},
                                            {-0.402435, -0.915449}, {-0.403838, -0.914830},

                                            {-0.405241, -0.914210}, {-0.406643, -0.913587}, {-0.408044, -0.912962},
                                            {-0.409444, -0.912335}, {-0.410843, -0.911706}, {-0.412241, -0.911075},
                                            {-0.413638, -0.910441}, {-0.415034, -0.909806},

                                            {-0.416430, -0.909168}, {-0.417824, -0.908528}, {-0.419217, -0.907886},
                                            {-0.420609, -0.907242}, {-0.422000, -0.906596}, {-0.423390, -0.905947},
                                            {-0.424780, -0.905297}, {-0.426168, -0.904644},

                                            {-0.427555, -0.903989}, {-0.428941, -0.903332}, {-0.430326, -0.902673},
                                            {-0.431711, -0.902012}, {-0.433094, -0.901349}, {-0.434476, -0.900683},
                                            {-0.435857, -0.900016}, {-0.437237, -0.899346},

                                            {-0.438616, -0.898674}, {-0.439994, -0.898001}, {-0.441371, -0.897325},
                                            {-0.442747, -0.896646}, {-0.444122, -0.895966}, {-0.445496, -0.895284},
                                            {-0.446869, -0.894599}, {-0.448241, -0.893913},

                                            {-0.449611, -0.893224}, {-0.450981, -0.892534}, {-0.452350, -0.891841},
                                            {-0.453717, -0.891146}, {-0.455084, -0.890449}, {-0.456449, -0.889750},
                                            {-0.457813, -0.889048}, {-0.459177, -0.888345},

                                            {-0.460539, -0.887640}, {-0.461900, -0.886932}, {-0.463260, -0.886223},
                                            {-0.464619, -0.885511}, {-0.465977, -0.884797}, {-0.467333, -0.884081},
                                            {-0.468689, -0.883363}, {-0.470043, -0.882643},

                                            {-0.471397, -0.881921}, {-0.472749, -0.881197}, {-0.474100, -0.880471},
                                            {-0.475450, -0.879743}, {-0.476799, -0.879012}, {-0.478147, -0.878280},
                                            {-0.479494, -0.877545}, {-0.480839, -0.876809},

                                            {-0.482184, -0.876070}, {-0.483527, -0.875329}, {-0.484869, -0.874587},
                                            {-0.486210, -0.873842}, {-0.487550, -0.873095}, {-0.488889, -0.872346},
                                            {-0.490226, -0.871595}, {-0.491563, -0.870842},

                                            {-0.492898, -0.870087}, {-0.494232, -0.869330}, {-0.495565, -0.868571},
                                            {-0.496897, -0.867809}, {-0.498228, -0.867046}, {-0.499557, -0.866281},
                                            {-0.500885, -0.865514}, {-0.502212, -0.864744},

                                            {-0.503538, -0.863973}, {-0.504863, -0.863199}, {-0.506187, -0.862424},
                                            {-0.507509, -0.861646}, {-0.508830, -0.860867}, {-0.510150, -0.860085},
                                            {-0.511469, -0.859302}, {-0.512786, -0.858516},

                                            {-0.514103, -0.857729}, {-0.515418, -0.856939}, {-0.516732, -0.856147},
                                            {-0.518045, -0.855354}, {-0.519356, -0.854558}, {-0.520666, -0.853760},
                                            {-0.521975, -0.852961}, {-0.523283, -0.852159},

                                            {-0.524590, -0.851355}, {-0.525895, -0.850549}, {-0.527199, -0.849742},
                                            {-0.528502, -0.848932}, {-0.529804, -0.848120}, {-0.531104, -0.847307},
                                            {-0.532403, -0.846491}, {-0.533701, -0.845673},

                                            {-0.534998, -0.844854}, {-0.536293, -0.844032}, {-0.537587, -0.843208},
                                            {-0.538880, -0.842383}, {-0.540171, -0.841555}, {-0.541462, -0.840725},
                                            {-0.542751, -0.839894}, {-0.544039, -0.839060},

                                            {-0.545325, -0.838225}, {-0.546610, -0.837387}, {-0.547894, -0.836548},
                                            {-0.549177, -0.835706}, {-0.550458, -0.834863}, {-0.551738, -0.834018},
                                            {-0.553017, -0.833170}, {-0.554294, -0.832321},

                                            {-0.555570, -0.831470}, {-0.556845, -0.830616}, {-0.558119, -0.829761},
                                            {-0.559391, -0.828904}, {-0.560662, -0.828045}, {-0.561931, -0.827184},
                                            {-0.563199, -0.826321}, {-0.564466, -0.825456},

                                            {-0.565732, -0.824589}, {-0.566996, -0.823721}, {-0.568259, -0.822850},
                                            {-0.569521, -0.821977}, {-0.570781, -0.821102}, {-0.572040, -0.820226},
                                            {-0.573297, -0.819348}, {-0.574553, -0.818467},

                                            {-0.575808, -0.817585}, {-0.577062, -0.816701}, {-0.578314, -0.815814},
                                            {-0.579565, -0.814926}, {-0.580814, -0.814036}, {-0.582062, -0.813144},
                                            {-0.583309, -0.812251}, {-0.584554, -0.811355},

                                            {-0.585798, -0.810457}, {-0.587040, -0.809558}, {-0.588282, -0.808656},
                                            {-0.589521, -0.807753}, {-0.590760, -0.806848}, {-0.591997, -0.805940},
                                            {-0.593232, -0.805031}, {-0.594467, -0.804120},

                                            {-0.595699, -0.803208}, {-0.596931, -0.802293}, {-0.598161, -0.801376},
                                            {-0.599389, -0.800458}, {-0.600616, -0.799537}, {-0.601842, -0.798615},
                                            {-0.603067, -0.797691}, {-0.604290, -0.796765},

                                            {-0.605511, -0.795837}, {-0.606731, -0.794907}, {-0.607950, -0.793975},
                                            {-0.609167, -0.793042}, {-0.610383, -0.792107}, {-0.611597, -0.791169},
                                            {-0.612810, -0.790230}, {-0.614022, -0.789289},

                                            {-0.615232, -0.788346}, {-0.616440, -0.787402}, {-0.617647, -0.786455},
                                            {-0.618853, -0.785507}, {-0.620057, -0.784557}, {-0.621260, -0.783605},
                                            {-0.622461, -0.782651}, {-0.623661, -0.781695},

                                            {-0.624860, -0.780737}, {-0.626056, -0.779778}, {-0.627252, -0.778817},
                                            {-0.628446, -0.777853}, {-0.629638, -0.776888}, {-0.630829, -0.775922},
                                            {-0.632019, -0.774953}, {-0.633207, -0.773983},

                                            {-0.634393, -0.773010}, {-0.635578, -0.772036}, {-0.636762, -0.771061},
                                            {-0.637944, -0.770083}, {-0.639124, -0.769103}, {-0.640303, -0.768122},
                                            {-0.641481, -0.767139}, {-0.642657, -0.766154},

                                            {-0.643832, -0.765167}, {-0.645005, -0.764179}, {-0.646176, -0.763188},
                                            {-0.647346, -0.762196}, {-0.648514, -0.761202}, {-0.649681, -0.760207},
                                            {-0.650847, -0.759209}, {-0.652011, -0.758210},

                                            {-0.653173, -0.757209}, {-0.654334, -0.756206}, {-0.655493, -0.755201},
                                            {-0.656651, -0.754195}, {-0.657807, -0.753187}, {-0.658961, -0.752177},
                                            {-0.660114, -0.751165}, {-0.661266, -0.750152},

                                            {-0.662416, -0.749136}, {-0.663564, -0.748119}, {-0.664711, -0.747101},
                                            {-0.665856, -0.746080}, {-0.667000, -0.745058}, {-0.668142, -0.744034},
                                            {-0.669283, -0.743008}, {-0.670422, -0.741980},

                                            {-0.671559, -0.740951}, {-0.672695, -0.739920}, {-0.673829, -0.738887},
                                            {-0.674962, -0.737853}, {-0.676093, -0.736817}, {-0.677222, -0.735779},
                                            {-0.678350, -0.734739}, {-0.679476, -0.733697},

                                            {-0.680601, -0.732654}, {-0.681724, -0.731609}, {-0.682846, -0.730563},
                                            {-0.683965, -0.729514}, {-0.685084, -0.728464}, {-0.686200, -0.727413},
                                            {-0.687315, -0.726359}, {-0.688429, -0.725304},

                                            {-0.689541, -0.724247}, {-0.690651, -0.723188}, {-0.691759, -0.722128},
                                            {-0.692866, -0.721066}, {-0.693971, -0.720003}, {-0.695075, -0.718937},
                                            {-0.696177, -0.717870}, {-0.697277, -0.716801},

                                            {-0.698376, -0.715731}, {-0.699473, -0.714659}, {-0.700569, -0.713585},
                                            {-0.701663, -0.712509}, {-0.702755, -0.711432}, {-0.703845, -0.710353},
                                            {-0.704934, -0.709273}, {-0.706021, -0.708191},

                                            {-0.707107, -0.707107}, {-0.708191, -0.706021}, {-0.709273, -0.704934},
                                            {-0.710353, -0.703845}, {-0.711432, -0.702755}, {-0.712509, -0.701663},
                                            {-0.713585, -0.700569}, {-0.714659, -0.699473},

                                            {-0.715731, -0.698376}, {-0.716801, -0.697277}, {-0.717870, -0.696177},
                                            {-0.718937, -0.695075}, {-0.720003, -0.693971}, {-0.721066, -0.692866},
                                            {-0.722128, -0.691759}, {-0.723188, -0.690651},

                                            {-0.724247, -0.689541}, {-0.725304, -0.688429}, {-0.726359, -0.687315},
                                            {-0.727413, -0.686200}, {-0.728464, -0.685084}, {-0.729514, -0.683965},
                                            {-0.730563, -0.682846}, {-0.731609, -0.681724},

                                            {-0.732654, -0.680601}, {-0.733697, -0.679476}, {-0.734739, -0.678350},
                                            {-0.735779, -0.677222}, {-0.736817, -0.676093}, {-0.737853, -0.674962},
                                            {-0.738887, -0.673829}, {-0.739920, -0.672695},

                                            {-0.740951, -0.671559}, {-0.741980, -0.670422}, {-0.743008, -0.669283},
                                            {-0.744034, -0.668142}, {-0.745058, -0.667000}, {-0.746080, -0.665856},
                                            {-0.747101, -0.664711}, {-0.748119, -0.663564},

                                            {-0.749136, -0.662416}, {-0.750152, -0.661266}, {-0.751165, -0.660114},
                                            {-0.752177, -0.658961}, {-0.753187, -0.657807}, {-0.754195, -0.656651},
                                            {-0.755201, -0.655493}, {-0.756206, -0.654334},

                                            {-0.757209, -0.653173}, {-0.758210, -0.652011}, {-0.759209, -0.650847},
                                            {-0.760207, -0.649681}, {-0.761202, -0.648514}, {-0.762196, -0.647346},
                                            {-0.763188, -0.646176}, {-0.764179, -0.645005},

                                            {-0.765167, -0.643832}, {-0.766154, -0.642657}, {-0.767139, -0.641481},
                                            {-0.768122, -0.640303}, {-0.769103, -0.639124}, {-0.770083, -0.637944},
                                            {-0.771061, -0.636762}, {-0.772036, -0.635578},

                                            {-0.773010, -0.634393}, {-0.773983, -0.633207}, {-0.774953, -0.632019},
                                            {-0.775922, -0.630829}, {-0.776888, -0.629638}, {-0.777853, -0.628446},
                                            {-0.778817, -0.627252}, {-0.779778, -0.626056},

                                            {-0.780737, -0.624860}, {-0.781695, -0.623661}, {-0.782651, -0.622461},
                                            {-0.783605, -0.621260}, {-0.784557, -0.620057}, {-0.785507, -0.618853},
                                            {-0.786455, -0.617647}, {-0.787402, -0.616440},

                                            {-0.788346, -0.615232}, {-0.789289, -0.614022}, {-0.790230, -0.612810},
                                            {-0.791169, -0.611597}, {-0.792107, -0.610383}, {-0.793042, -0.609167},
                                            {-0.793975, -0.607950}, {-0.794907, -0.606731},

                                            {-0.795837, -0.605511}, {-0.796765, -0.604290}, {-0.797691, -0.603067},
                                            {-0.798615, -0.601842}, {-0.799537, -0.600616}, {-0.800458, -0.599389},
                                            {-0.801376, -0.598161}, {-0.802293, -0.596931},

                                            {-0.803208, -0.595699}, {-0.804120, -0.594467}, {-0.805031, -0.593232},
                                            {-0.805940, -0.591997}, {-0.806848, -0.590760}, {-0.807753, -0.589521},
                                            {-0.808656, -0.588282}, {-0.809558, -0.587040},

                                            {-0.810457, -0.585798}, {-0.811355, -0.584554}, {-0.812251, -0.583309},
                                            {-0.813144, -0.582062}, {-0.814036, -0.580814}, {-0.814926, -0.579565},
                                            {-0.815814, -0.578314}, {-0.816701, -0.577062},

                                            {-0.817585, -0.575808}, {-0.818467, -0.574553}, {-0.819348, -0.573297},
                                            {-0.820226, -0.572040}, {-0.821102, -0.570781}, {-0.821977, -0.569521},
                                            {-0.822850, -0.568259}, {-0.823721, -0.566996},

                                            {-0.824589, -0.565732}, {-0.825456, -0.564466}, {-0.826321, -0.563199},
                                            {-0.827184, -0.561931}, {-0.828045, -0.560662}, {-0.828904, -0.559391},
                                            {-0.829761, -0.558119}, {-0.830616, -0.556845},

                                            {-0.831470, -0.555570}, {-0.832321, -0.554294}, {-0.833170, -0.553017},
                                            {-0.834018, -0.551738}, {-0.834863, -0.550458}, {-0.835706, -0.549177},
                                            {-0.836548, -0.547894}, {-0.837387, -0.546610},

                                            {-0.838225, -0.545325}, {-0.839060, -0.544039}, {-0.839894, -0.542751},
                                            {-0.840725, -0.541462}, {-0.841555, -0.540171}, {-0.842383, -0.538880},
                                            {-0.843208, -0.537587}, {-0.844032, -0.536293},

                                            {-0.844854, -0.534998}, {-0.845673, -0.533701}, {-0.846491, -0.532403},
                                            {-0.847307, -0.531104}, {-0.848120, -0.529804}, {-0.848932, -0.528502},
                                            {-0.849742, -0.527199}, {-0.850549, -0.525895},

                                            {-0.851355, -0.524590}, {-0.852159, -0.523283}, {-0.852961, -0.521975},
                                            {-0.853760, -0.520666}, {-0.854558, -0.519356}, {-0.855354, -0.518045},
                                            {-0.856147, -0.516732}, {-0.856939, -0.515418},

                                            {-0.857729, -0.514103}, {-0.858516, -0.512786}, {-0.859302, -0.511469},
                                            {-0.860085, -0.510150}, {-0.860867, -0.508830}, {-0.861646, -0.507509},
                                            {-0.862424, -0.506187}, {-0.863199, -0.504863},

                                            {-0.863973, -0.503538}, {-0.864744, -0.502212}, {-0.865514, -0.500885},
                                            {-0.866281, -0.499557}, {-0.867046, -0.498228}, {-0.867809, -0.496897},
                                            {-0.868571, -0.495565}, {-0.869330, -0.494232},

                                            {-0.870087, -0.492898}, {-0.870842, -0.491563}, {-0.871595, -0.490226},
                                            {-0.872346, -0.488889}, {-0.873095, -0.487550}, {-0.873842, -0.486210},
                                            {-0.874587, -0.484869}, {-0.875329, -0.483527},

                                            {-0.876070, -0.482184}, {-0.876809, -0.480839}, {-0.877545, -0.479494},
                                            {-0.878280, -0.478147}, {-0.879012, -0.476799}, {-0.879743, -0.475450},
                                            {-0.880471, -0.474100}, {-0.881197, -0.472749},

                                            {-0.881921, -0.471397}, {-0.882643, -0.470043}, {-0.883363, -0.468689},
                                            {-0.884081, -0.467333}, {-0.884797, -0.465977}, {-0.885511, -0.464619},
                                            {-0.886223, -0.463260}, {-0.886932, -0.461900},

                                            {-0.887640, -0.460539}, {-0.888345, -0.459177}, {-0.889048, -0.457813},
                                            {-0.889750, -0.456449}, {-0.890449, -0.455084}, {-0.891146, -0.453717},
                                            {-0.891841, -0.452350}, {-0.892534, -0.450981},

                                            {-0.893224, -0.449611}, {-0.893913, -0.448241}, {-0.894599, -0.446869},
                                            {-0.895284, -0.445496}, {-0.895966, -0.444122}, {-0.896646, -0.442747},
                                            {-0.897325, -0.441371}, {-0.898001, -0.439994},

                                            {-0.898674, -0.438616}, {-0.899346, -0.437237}, {-0.900016, -0.435857},
                                            {-0.900683, -0.434476}, {-0.901349, -0.433094}, {-0.902012, -0.431711},
                                            {-0.902673, -0.430326}, {-0.903332, -0.428941},

                                            {-0.903989, -0.427555}, {-0.904644, -0.426168}, {-0.905297, -0.424780},
                                            {-0.905947, -0.423390}, {-0.906596, -0.422000}, {-0.907242, -0.420609},
                                            {-0.907886, -0.419217}, {-0.908528, -0.417824},

                                            {-0.909168, -0.416430}, {-0.909806, -0.415034}, {-0.910441, -0.413638},
                                            {-0.911075, -0.412241}, {-0.911706, -0.410843}, {-0.912335, -0.409444},
                                            {-0.912962, -0.408044}, {-0.913587, -0.406643},

                                            {-0.914210, -0.405241}, {-0.914830, -0.403838}, {-0.915449, -0.402435},
                                            {-0.916065, -0.401030}, {-0.916679, -0.399624}, {-0.917291, -0.398218},
                                            {-0.917901, -0.396810}, {-0.918508, -0.395401},

                                            {-0.919114, -0.393992}, {-0.919717, -0.392582}, {-0.920318, -0.391170},
                                            {-0.920917, -0.389758}, {-0.921514, -0.388345}, {-0.922109, -0.386931},
                                            {-0.922701, -0.385516}, {-0.923291, -0.384100},

                                            {-0.923880, -0.382683}, {-0.924465, -0.381266}, {-0.925049, -0.379847},
                                            {-0.925631, -0.378428}, {-0.926210, -0.377007}, {-0.926787, -0.375586},
                                            {-0.927363, -0.374164}, {-0.927935, -0.372741},

                                            {-0.928506, -0.371317}, {-0.929075, -0.369892}, {-0.929641, -0.368467},
                                            {-0.930205, -0.367040}, {-0.930767, -0.365613}, {-0.931327, -0.364185},
                                            {-0.931884, -0.362756}, {-0.932440, -0.361326},

                                            {-0.932993, -0.359895}, {-0.933544, -0.358463}, {-0.934093, -0.357031},
                                            {-0.934639, -0.355598}, {-0.935184, -0.354164}, {-0.935726, -0.352729},
                                            {-0.936266, -0.351293}, {-0.936803, -0.349856},

                                            {-0.937339, -0.348419}, {-0.937872, -0.346980}, {-0.938404, -0.345541},
                                            {-0.938932, -0.344101}, {-0.939459, -0.342661}, {-0.939984, -0.341219},
                                            {-0.940506, -0.339777}, {-0.941026, -0.338334},

                                            {-0.941544, -0.336890}, {-0.942060, -0.335445}, {-0.942573, -0.334000},
                                            {-0.943084, -0.332553}, {-0.943593, -0.331106}, {-0.944100, -0.329658},
                                            {-0.944605, -0.328210}, {-0.945107, -0.326760},

                                            {-0.945607, -0.325310}, {-0.946105, -0.323859}, {-0.946601, -0.322408},
                                            {-0.947094, -0.320955}, {-0.947586, -0.319502}, {-0.948075, -0.318048},
                                            {-0.948561, -0.316593}, {-0.949046, -0.315138},

                                            {-0.949528, -0.313682}, {-0.950008, -0.312225}, {-0.950486, -0.310767},
                                            {-0.950962, -0.309309}, {-0.951435, -0.307850}, {-0.951906, -0.306390},
                                            {-0.952375, -0.304929}, {-0.952842, -0.303468},

                                            {-0.953306, -0.302006}, {-0.953768, -0.300543}, {-0.954228, -0.299080},
                                            {-0.954686, -0.297616}, {-0.955141, -0.296151}, {-0.955594, -0.294685},
                                            {-0.956045, -0.293219}, {-0.956494, -0.291752},

                                            {-0.956940, -0.290285}, {-0.957385, -0.288816}, {-0.957826, -0.287347},
                                            {-0.958266, -0.285878}, {-0.958703, -0.284408}, {-0.959139, -0.282937},
                                            {-0.959572, -0.281465}, {-0.960002, -0.279993},

                                            {-0.960431, -0.278520}, {-0.960857, -0.277046}, {-0.961280, -0.275572},
                                            {-0.961702, -0.274097}, {-0.962121, -0.272621}, {-0.962538, -0.271145},
                                            {-0.962953, -0.269668}, {-0.963366, -0.268191},

                                            {-0.963776, -0.266713}, {-0.964184, -0.265234}, {-0.964590, -0.263755},
                                            {-0.964993, -0.262275}, {-0.965394, -0.260794}, {-0.965793, -0.259313},
                                            {-0.966190, -0.257831}, {-0.966584, -0.256349},

                                            {-0.966976, -0.254866}, {-0.967366, -0.253382}, {-0.967754, -0.251898},
                                            {-0.968139, -0.250413}, {-0.968522, -0.248928}, {-0.968903, -0.247442},
                                            {-0.969281, -0.245955}, {-0.969657, -0.244468},

                                            {-0.970031, -0.242980}, {-0.970403, -0.241492}, {-0.970772, -0.240003},
                                            {-0.971139, -0.238514}, {-0.971504, -0.237024}, {-0.971866, -0.235533},
                                            {-0.972227, -0.234042}, {-0.972584, -0.232550},

                                            {-0.972940, -0.231058}, {-0.973293, -0.229565}, {-0.973644, -0.228072},
                                            {-0.973993, -0.226578}, {-0.974339, -0.225084}, {-0.974684, -0.223589},
                                            {-0.975025, -0.222094}, {-0.975365, -0.220598},

                                            {-0.975702, -0.219101}, {-0.976037, -0.217604}, {-0.976370, -0.216107},
                                            {-0.976700, -0.214609}, {-0.977028, -0.213110}, {-0.977354, -0.211611},
                                            {-0.977677, -0.210112}, {-0.977998, -0.208612},

                                            {-0.978317, -0.207111}, {-0.978634, -0.205610}, {-0.978948, -0.204109},
                                            {-0.979260, -0.202607}, {-0.979570, -0.201105}, {-0.979877, -0.199602},
                                            {-0.980182, -0.198098}, {-0.980485, -0.196595},

                                            {-0.980785, -0.195090}, {-0.981083, -0.193586}, {-0.981379, -0.192080},
                                            {-0.981673, -0.190575}, {-0.981964, -0.189069}, {-0.982253, -0.187562},
                                            {-0.982539, -0.186055}, {-0.982824, -0.184548},

                                            {-0.983105, -0.183040}, {-0.983385, -0.181532}, {-0.983662, -0.180023},
                                            {-0.983937, -0.178514}, {-0.984210, -0.177004}, {-0.984480, -0.175494},
                                            {-0.984748, -0.173984}, {-0.985014, -0.172473},

                                            {-0.985278, -0.170962}, {-0.985539, -0.169450}, {-0.985798, -0.167938},
                                            {-0.986054, -0.166426}, {-0.986308, -0.164913}, {-0.986560, -0.163400},
                                            {-0.986809, -0.161886}, {-0.987057, -0.160372},

                                            {-0.987301, -0.158858}, {-0.987544, -0.157343}, {-0.987784, -0.155828},
                                            {-0.988022, -0.154313}, {-0.988258, -0.152797}, {-0.988491, -0.151281},
                                            {-0.988722, -0.149765}, {-0.988950, -0.148248},

                                            {-0.989177, -0.146730}, {-0.989400, -0.145213}, {-0.989622, -0.143695},
                                            {-0.989841, -0.142177}, {-0.990058, -0.140658}, {-0.990273, -0.139139},
                                            {-0.990485, -0.137620}, {-0.990695, -0.136101},

                                            {-0.990903, -0.134581}, {-0.991108, -0.133061}, {-0.991311, -0.131540},
                                            {-0.991511, -0.130019}, {-0.991710, -0.128498}, {-0.991906, -0.126977},
                                            {-0.992099, -0.125455}, {-0.992291, -0.123933},

                                            {-0.992480, -0.122411}, {-0.992666, -0.120888}, {-0.992850, -0.119365},
                                            {-0.993032, -0.117842}, {-0.993212, -0.116319}, {-0.993389, -0.114795},
                                            {-0.993564, -0.113271}, {-0.993737, -0.111747},

                                            {-0.993907, -0.110222}, {-0.994075, -0.108697}, {-0.994240, -0.107172},
                                            {-0.994404, -0.105647}, {-0.994565, -0.104122}, {-0.994723, -0.102596},
                                            {-0.994879, -0.101070}, {-0.995033, -0.099544},

                                            {-0.995185, -0.098017}, {-0.995334, -0.096490}, {-0.995481, -0.094963},
                                            {-0.995625, -0.093436}, {-0.995767, -0.091909}, {-0.995907, -0.090381},
                                            {-0.996045, -0.088854}, {-0.996180, -0.087326},

                                            {-0.996313, -0.085797}, {-0.996443, -0.084269}, {-0.996571, -0.082740},
                                            {-0.996697, -0.081211}, {-0.996820, -0.079682}, {-0.996941, -0.078153},
                                            {-0.997060, -0.076624}, {-0.997176, -0.075094},

                                            {-0.997290, -0.073565}, {-0.997402, -0.072035}, {-0.997511, -0.070505},
                                            {-0.997618, -0.068974}, {-0.997723, -0.067444}, {-0.997825, -0.065913},
                                            {-0.997925, -0.064383}, {-0.998023, -0.062852},

                                            {-0.998118, -0.061321}, {-0.998211, -0.059790}, {-0.998302, -0.058258},
                                            {-0.998390, -0.056727}, {-0.998476, -0.055195}, {-0.998559, -0.053664},
                                            {-0.998640, -0.052132}, {-0.998719, -0.050600},

                                            {-0.998795, -0.049068}, {-0.998870, -0.047535}, {-0.998941, -0.046003},
                                            {-0.999011, -0.044471}, {-0.999078, -0.042938}, {-0.999142, -0.041406},
                                            {-0.999205, -0.039873}, {-0.999265, -0.038340},

                                            {-0.999322, -0.036807}, {-0.999378, -0.035274}, {-0.999431, -0.033741},
                                            {-0.999481, -0.032208}, {-0.999529, -0.030675}, {-0.999575, -0.029142},
                                            {-0.999619, -0.027608}, {-0.999660, -0.026075},

                                            {-0.999699, -0.024541}, {-0.999735, -0.023008}, {-0.999769, -0.021474},
                                            {-0.999801, -0.019940}, {-0.999831, -0.018407}, {-0.999858, -0.016873},
                                            {-0.999882, -0.015339}, {-0.999905, -0.013805},

                                            {-0.999925, -0.012272}, {-0.999942, -0.010738}, {-0.999958, -0.009204},
                                            {-0.999971, -0.007670}, {-0.999981, -0.006136}, {-0.999989, -0.004602},
                                            {-0.999995, -0.003068}, {-0.999999, -0.001534}

};

#ifdef _SUPPORTS_CBFLOAT16_

const cbfloat16 twiddle_master_cbfloat16[2048] = {
    {1.000000, -0.000000},  {0.999999, -0.001534},  {0.999995, -0.003068},
    {0.999989, -0.004602},  {0.999981, -0.006136},  {0.999971, -0.007670},
    {0.999958, -0.009204},  {0.999942, -0.010738},

    {0.999925, -0.012272},  {0.999905, -0.013805},  {0.999882, -0.015339},
    {0.999858, -0.016873},  {0.999831, -0.018407},  {0.999801, -0.019940},
    {0.999769, -0.021474},  {0.999735, -0.023008},

    {0.999699, -0.024541},  {0.999660, -0.026075},  {0.999619, -0.027608},
    {0.999575, -0.029142},  {0.999529, -0.030675},  {0.999481, -0.032208},
    {0.999431, -0.033741},  {0.999378, -0.035274},

    {0.999322, -0.036807},  {0.999265, -0.038340},  {0.999205, -0.039873},
    {0.999142, -0.041406},  {0.999078, -0.042938},  {0.999011, -0.044471},
    {0.998941, -0.046003},  {0.998870, -0.047535},

    {0.998795, -0.049068},  {0.998719, -0.050600},  {0.998640, -0.052132},
    {0.998559, -0.053664},  {0.998476, -0.055195},  {0.998390, -0.056727},
    {0.998302, -0.058258},  {0.998211, -0.059790},

    {0.998118, -0.061321},  {0.998023, -0.062852},  {0.997925, -0.064383},
    {0.997825, -0.065913},  {0.997723, -0.067444},  {0.997618, -0.068974},
    {0.997511, -0.070505},  {0.997402, -0.072035},

    {0.997290, -0.073565},  {0.997176, -0.075094},  {0.997060, -0.076624},
    {0.996941, -0.078153},  {0.996820, -0.079682},  {0.996697, -0.081211},
    {0.996571, -0.082740},  {0.996443, -0.084269},

    {0.996313, -0.085797},  {0.996180, -0.087326},  {0.996045, -0.088854},
    {0.995907, -0.090381},  {0.995767, -0.091909},  {0.995625, -0.093436},
    {0.995481, -0.094963},  {0.995334, -0.096490},

    {0.995185, -0.098017},  {0.995033, -0.099544},  {0.994879, -0.101070},
    {0.994723, -0.102596},  {0.994565, -0.104122},  {0.994404, -0.105647},
    {0.994240, -0.107172},  {0.994075, -0.108697},

    {0.993907, -0.110222},  {0.993737, -0.111747},  {0.993564, -0.113271},
    {0.993389, -0.114795},  {0.993212, -0.116319},  {0.993032, -0.117842},
    {0.992850, -0.119365},  {0.992666, -0.120888},

    {0.992480, -0.122411},  {0.992291, -0.123933},  {0.992099, -0.125455},
    {0.991906, -0.126977},  {0.991710, -0.128498},  {0.991511, -0.130019},
    {0.991311, -0.131540},  {0.991108, -0.133061},

    {0.990903, -0.134581},  {0.990695, -0.136101},  {0.990485, -0.137620},
    {0.990273, -0.139139},  {0.990058, -0.140658},  {0.989841, -0.142177},
    {0.989622, -0.143695},  {0.989400, -0.145213},

    {0.989177, -0.146730},  {0.988950, -0.148248},  {0.988722, -0.149765},
    {0.988491, -0.151281},  {0.988258, -0.152797},  {0.988022, -0.154313},
    {0.987784, -0.155828},  {0.987544, -0.157343},

    {0.987301, -0.158858},  {0.987057, -0.160372},  {0.986809, -0.161886},
    {0.986560, -0.163400},  {0.986308, -0.164913},  {0.986054, -0.166426},
    {0.985798, -0.167938},  {0.985539, -0.169450},

    {0.985278, -0.170962},  {0.985014, -0.172473},  {0.984748, -0.173984},
    {0.984480, -0.175494},  {0.984210, -0.177004},  {0.983937, -0.178514},
    {0.983662, -0.180023},  {0.983385, -0.181532},

    {0.983105, -0.183040},  {0.982824, -0.184548},  {0.982539, -0.186055},
    {0.982253, -0.187562},  {0.981964, -0.189069},  {0.981673, -0.190575},
    {0.981379, -0.192080},  {0.981083, -0.193586},

    {0.980785, -0.195090},  {0.980485, -0.196595},  {0.980182, -0.198098},
    {0.979877, -0.199602},  {0.979570, -0.201105},  {0.979260, -0.202607},
    {0.978948, -0.204109},  {0.978634, -0.205610},

    {0.978317, -0.207111},  {0.977998, -0.208612},  {0.977677, -0.210112},
    {0.977354, -0.211611},  {0.977028, -0.213110},  {0.976700, -0.214609},
    {0.976370, -0.216107},  {0.976037, -0.217604},

    {0.975702, -0.219101},  {0.975365, -0.220598},  {0.975025, -0.222094},
    {0.974684, -0.223589},  {0.974339, -0.225084},  {0.973993, -0.226578},
    {0.973644, -0.228072},  {0.973293, -0.229565},

    {0.972940, -0.231058},  {0.972584, -0.232550},  {0.972227, -0.234042},
    {0.971866, -0.235533},  {0.971504, -0.237024},  {0.971139, -0.238514},
    {0.970772, -0.240003},  {0.970403, -0.241492},

    {0.970031, -0.242980},  {0.969657, -0.244468},  {0.969281, -0.245955},
    {0.968903, -0.247442},  {0.968522, -0.248928},  {0.968139, -0.250413},
    {0.967754, -0.251898},  {0.967366, -0.253382},

    {0.966976, -0.254866},  {0.966584, -0.256349},  {0.966190, -0.257831},
    {0.965793, -0.259313},  {0.965394, -0.260794},  {0.964993, -0.262275},
    {0.964590, -0.263755},  {0.964184, -0.265234},

    {0.963776, -0.266713},  {0.963366, -0.268191},  {0.962953, -0.269668},
    {0.962538, -0.271145},  {0.962121, -0.272621},  {0.961702, -0.274097},
    {0.961280, -0.275572},  {0.960857, -0.277046},

    {0.960431, -0.278520},  {0.960002, -0.279993},  {0.959572, -0.281465},
    {0.959139, -0.282937},  {0.958703, -0.284408},  {0.958266, -0.285878},
    {0.957826, -0.287347},  {0.957385, -0.288816},

    {0.956940, -0.290285},  {0.956494, -0.291752},  {0.956045, -0.293219},
    {0.955594, -0.294685},  {0.955141, -0.296151},  {0.954686, -0.297616},
    {0.954228, -0.299080},  {0.953768, -0.300543},

    {0.953306, -0.302006},  {0.952842, -0.303468},  {0.952375, -0.304929},
    {0.951906, -0.306390},  {0.951435, -0.307850},  {0.950962, -0.309309},
    {0.950486, -0.310767},  {0.950008, -0.312225},

    {0.949528, -0.313682},  {0.949046, -0.315138},  {0.948561, -0.316593},
    {0.948075, -0.318048},  {0.947586, -0.319502},  {0.947094, -0.320955},
    {0.946601, -0.322408},  {0.946105, -0.323859},

    {0.945607, -0.325310},  {0.945107, -0.326760},  {0.944605, -0.328210},
    {0.944100, -0.329658},  {0.943593, -0.331106},  {0.943084, -0.332553},
    {0.942573, -0.334000},  {0.942060, -0.335445},

    {0.941544, -0.336890},  {0.941026, -0.338334},  {0.940506, -0.339777},
    {0.939984, -0.341219},  {0.939459, -0.342661},  {0.938932, -0.344101},
    {0.938404, -0.345541},  {0.937872, -0.346980},

    {0.937339, -0.348419},  {0.936803, -0.349856},  {0.936266, -0.351293},
    {0.935726, -0.352729},  {0.935184, -0.354164},  {0.934639, -0.355598},
    {0.934093, -0.357031},  {0.933544, -0.358463},

    {0.932993, -0.359895},  {0.932440, -0.361326},  {0.931884, -0.362756},
    {0.931327, -0.364185},  {0.930767, -0.365613},  {0.930205, -0.367040},
    {0.929641, -0.368467},  {0.929075, -0.369892},

    {0.928506, -0.371317},  {0.927935, -0.372741},  {0.927363, -0.374164},
    {0.926787, -0.375586},  {0.926210, -0.377007},  {0.925631, -0.378428},
    {0.925049, -0.379847},  {0.924465, -0.381266},

    {0.923880, -0.382683},  {0.923291, -0.384100},  {0.922701, -0.385516},
    {0.922109, -0.386931},  {0.921514, -0.388345},  {0.920917, -0.389758},
    {0.920318, -0.391170},  {0.919717, -0.392582},

    {0.919114, -0.393992},  {0.918508, -0.395401},  {0.917901, -0.396810},
    {0.917291, -0.398218},  {0.916679, -0.399624},  {0.916065, -0.401030},
    {0.915449, -0.402435},  {0.914830, -0.403838},

    {0.914210, -0.405241},  {0.913587, -0.406643},  {0.912962, -0.408044},
    {0.912335, -0.409444},  {0.911706, -0.410843},  {0.911075, -0.412241},
    {0.910441, -0.413638},  {0.909806, -0.415034},

    {0.909168, -0.416430},  {0.908528, -0.417824},  {0.907886, -0.419217},
    {0.907242, -0.420609},  {0.906596, -0.422000},  {0.905947, -0.423390},
    {0.905297, -0.424780},  {0.904644, -0.426168},

    {0.903989, -0.427555},  {0.903332, -0.428941},  {0.902673, -0.430326},
    {0.902012, -0.431711},  {0.901349, -0.433094},  {0.900683, -0.434476},
    {0.900016, -0.435857},  {0.899346, -0.437237},

    {0.898674, -0.438616},  {0.898001, -0.439994},  {0.897325, -0.441371},
    {0.896646, -0.442747},  {0.895966, -0.444122},  {0.895284, -0.445496},
    {0.894599, -0.446869},  {0.893913, -0.448241},

    {0.893224, -0.449611},  {0.892534, -0.450981},  {0.891841, -0.452350},
    {0.891146, -0.453717},  {0.890449, -0.455084},  {0.889750, -0.456449},
    {0.889048, -0.457813},  {0.888345, -0.459177},

    {0.887640, -0.460539},  {0.886932, -0.461900},  {0.886223, -0.463260},
    {0.885511, -0.464619},  {0.884797, -0.465977},  {0.884081, -0.467333},
    {0.883363, -0.468689},  {0.882643, -0.470043},

    {0.881921, -0.471397},  {0.881197, -0.472749},  {0.880471, -0.474100},
    {0.879743, -0.475450},  {0.879012, -0.476799},  {0.878280, -0.478147},
    {0.877545, -0.479494},  {0.876809, -0.480839},

    {0.876070, -0.482184},  {0.875329, -0.483527},  {0.874587, -0.484869},
    {0.873842, -0.486210},  {0.873095, -0.487550},  {0.872346, -0.488889},
    {0.871595, -0.490226},  {0.870842, -0.491563},

    {0.870087, -0.492898},  {0.869330, -0.494232},  {0.868571, -0.495565},
    {0.867809, -0.496897},  {0.867046, -0.498228},  {0.866281, -0.499557},
    {0.865514, -0.500885},  {0.864744, -0.502212},

    {0.863973, -0.503538},  {0.863199, -0.504863},  {0.862424, -0.506187},
    {0.861646, -0.507509},  {0.860867, -0.508830},  {0.860085, -0.510150},
    {0.859302, -0.511469},  {0.858516, -0.512786},

    {0.857729, -0.514103},  {0.856939, -0.515418},  {0.856147, -0.516732},
    {0.855354, -0.518045},  {0.854558, -0.519356},  {0.853760, -0.520666},
    {0.852961, -0.521975},  {0.852159, -0.523283},

    {0.851355, -0.524590},  {0.850549, -0.525895},  {0.849742, -0.527199},
    {0.848932, -0.528502},  {0.848120, -0.529804},  {0.847307, -0.531104},
    {0.846491, -0.532403},  {0.845673, -0.533701},

    {0.844854, -0.534998},  {0.844032, -0.536293},  {0.843208, -0.537587},
    {0.842383, -0.538880},  {0.841555, -0.540171},  {0.840725, -0.541462},
    {0.839894, -0.542751},  {0.839060, -0.544039},

    {0.838225, -0.545325},  {0.837387, -0.546610},  {0.836548, -0.547894},
    {0.835706, -0.549177},  {0.834863, -0.550458},  {0.834018, -0.551738},
    {0.833170, -0.553017},  {0.832321, -0.554294},

    {0.831470, -0.555570},  {0.830616, -0.556845},  {0.829761, -0.558119},
    {0.828904, -0.559391},  {0.828045, -0.560662},  {0.827184, -0.561931},
    {0.826321, -0.563199},  {0.825456, -0.564466},

    {0.824589, -0.565732},  {0.823721, -0.566996},  {0.822850, -0.568259},
    {0.821977, -0.569521},  {0.821102, -0.570781},  {0.820226, -0.572040},
    {0.819348, -0.573297},  {0.818467, -0.574553},

    {0.817585, -0.575808},  {0.816701, -0.577062},  {0.815814, -0.578314},
    {0.814926, -0.579565},  {0.814036, -0.580814},  {0.813144, -0.582062},
    {0.812251, -0.583309},  {0.811355, -0.584554},

    {0.810457, -0.585798},  {0.809558, -0.587040},  {0.808656, -0.588282},
    {0.807753, -0.589521},  {0.806848, -0.590760},  {0.805940, -0.591997},
    {0.805031, -0.593232},  {0.804120, -0.594467},

    {0.803208, -0.595699},  {0.802293, -0.596931},  {0.801376, -0.598161},
    {0.800458, -0.599389},  {0.799537, -0.600616},  {0.798615, -0.601842},
    {0.797691, -0.603067},  {0.796765, -0.604290},

    {0.795837, -0.605511},  {0.794907, -0.606731},  {0.793975, -0.607950},
    {0.793042, -0.609167},  {0.792107, -0.610383},  {0.791169, -0.611597},
    {0.790230, -0.612810},  {0.789289, -0.614022},

    {0.788346, -0.615232},  {0.787402, -0.616440},  {0.786455, -0.617647},
    {0.785507, -0.618853},  {0.784557, -0.620057},  {0.783605, -0.621260},
    {0.782651, -0.622461},  {0.781695, -0.623661},

    {0.780737, -0.624860},  {0.779778, -0.626056},  {0.778817, -0.627252},
    {0.777853, -0.628446},  {0.776888, -0.629638},  {0.775922, -0.630829},
    {0.774953, -0.632019},  {0.773983, -0.633207},

    {0.773010, -0.634393},  {0.772036, -0.635578},  {0.771061, -0.636762},
    {0.770083, -0.637944},  {0.769103, -0.639124},  {0.768122, -0.640303},
    {0.767139, -0.641481},  {0.766154, -0.642657},

    {0.765167, -0.643832},  {0.764179, -0.645005},  {0.763188, -0.646176},
    {0.762196, -0.647346},  {0.761202, -0.648514},  {0.760207, -0.649681},
    {0.759209, -0.650847},  {0.758210, -0.652011},

    {0.757209, -0.653173},  {0.756206, -0.654334},  {0.755201, -0.655493},
    {0.754195, -0.656651},  {0.753187, -0.657807},  {0.752177, -0.658961},
    {0.751165, -0.660114},  {0.750152, -0.661266},

    {0.749136, -0.662416},  {0.748119, -0.663564},  {0.747101, -0.664711},
    {0.746080, -0.665856},  {0.745058, -0.667000},  {0.744034, -0.668142},
    {0.743008, -0.669283},  {0.741980, -0.670422},

    {0.740951, -0.671559},  {0.739920, -0.672695},  {0.738887, -0.673829},
    {0.737853, -0.674962},  {0.736817, -0.676093},  {0.735779, -0.677222},
    {0.734739, -0.678350},  {0.733697, -0.679476},

    {0.732654, -0.680601},  {0.731609, -0.681724},  {0.730563, -0.682846},
    {0.729514, -0.683965},  {0.728464, -0.685084},  {0.727413, -0.686200},
    {0.726359, -0.687315},  {0.725304, -0.688429},

    {0.724247, -0.689541},  {0.723188, -0.690651},  {0.722128, -0.691759},
    {0.721066, -0.692866},  {0.720003, -0.693971},  {0.718937, -0.695075},
    {0.717870, -0.696177},  {0.716801, -0.697277},

    {0.715731, -0.698376},  {0.714659, -0.699473},  {0.713585, -0.700569},
    {0.712509, -0.701663},  {0.711432, -0.702755},  {0.710353, -0.703845},
    {0.709273, -0.704934},  {0.708191, -0.706021},

    {0.707107, -0.707107},  {0.706021, -0.708191},  {0.704934, -0.709273},
    {0.703845, -0.710353},  {0.702755, -0.711432},  {0.701663, -0.712509},
    {0.700569, -0.713585},  {0.699473, -0.714659},

    {0.698376, -0.715731},  {0.697277, -0.716801},  {0.696177, -0.717870},
    {0.695075, -0.718937},  {0.693971, -0.720003},  {0.692866, -0.721066},
    {0.691759, -0.722128},  {0.690651, -0.723188},

    {0.689541, -0.724247},  {0.688429, -0.725304},  {0.687315, -0.726359},
    {0.686200, -0.727413},  {0.685084, -0.728464},  {0.683965, -0.729514},
    {0.682846, -0.730563},  {0.681724, -0.731609},

    {0.680601, -0.732654},  {0.679476, -0.733697},  {0.678350, -0.734739},
    {0.677222, -0.735779},  {0.676093, -0.736817},  {0.674962, -0.737853},
    {0.673829, -0.738887},  {0.672695, -0.739920},

    {0.671559, -0.740951},  {0.670422, -0.741980},  {0.669283, -0.743008},
    {0.668142, -0.744034},  {0.667000, -0.745058},  {0.665856, -0.746080},
    {0.664711, -0.747101},  {0.663564, -0.748119},

    {0.662416, -0.749136},  {0.661266, -0.750152},  {0.660114, -0.751165},
    {0.658961, -0.752177},  {0.657807, -0.753187},  {0.656651, -0.754195},
    {0.655493, -0.755201},  {0.654334, -0.756206},

    {0.653173, -0.757209},  {0.652011, -0.758210},  {0.650847, -0.759209},
    {0.649681, -0.760207},  {0.648514, -0.761202},  {0.647346, -0.762196},
    {0.646176, -0.763188},  {0.645005, -0.764179},

    {0.643832, -0.765167},  {0.642657, -0.766154},  {0.641481, -0.767139},
    {0.640303, -0.768122},  {0.639124, -0.769103},  {0.637944, -0.770083},
    {0.636762, -0.771061},  {0.635578, -0.772036},

    {0.634393, -0.773010},  {0.633207, -0.773983},  {0.632019, -0.774953},
    {0.630829, -0.775922},  {0.629638, -0.776888},  {0.628446, -0.777853},
    {0.627252, -0.778817},  {0.626056, -0.779778},

    {0.624860, -0.780737},  {0.623661, -0.781695},  {0.622461, -0.782651},
    {0.621260, -0.783605},  {0.620057, -0.784557},  {0.618853, -0.785507},
    {0.617647, -0.786455},  {0.616440, -0.787402},

    {0.615232, -0.788346},  {0.614022, -0.789289},  {0.612810, -0.790230},
    {0.611597, -0.791169},  {0.610383, -0.792107},  {0.609167, -0.793042},
    {0.607950, -0.793975},  {0.606731, -0.794907},

    {0.605511, -0.795837},  {0.604290, -0.796765},  {0.603067, -0.797691},
    {0.601842, -0.798615},  {0.600616, -0.799537},  {0.599389, -0.800458},
    {0.598161, -0.801376},  {0.596931, -0.802293},

    {0.595699, -0.803208},  {0.594467, -0.804120},  {0.593232, -0.805031},
    {0.591997, -0.805940},  {0.590760, -0.806848},  {0.589521, -0.807753},
    {0.588282, -0.808656},  {0.587040, -0.809558},

    {0.585798, -0.810457},  {0.584554, -0.811355},  {0.583309, -0.812251},
    {0.582062, -0.813144},  {0.580814, -0.814036},  {0.579565, -0.814926},
    {0.578314, -0.815814},  {0.577062, -0.816701},

    {0.575808, -0.817585},  {0.574553, -0.818467},  {0.573297, -0.819348},
    {0.572040, -0.820226},  {0.570781, -0.821102},  {0.569521, -0.821977},
    {0.568259, -0.822850},  {0.566996, -0.823721},

    {0.565732, -0.824589},  {0.564466, -0.825456},  {0.563199, -0.826321},
    {0.561931, -0.827184},  {0.560662, -0.828045},  {0.559391, -0.828904},
    {0.558119, -0.829761},  {0.556845, -0.830616},

    {0.555570, -0.831470},  {0.554294, -0.832321},  {0.553017, -0.833170},
    {0.551738, -0.834018},  {0.550458, -0.834863},  {0.549177, -0.835706},
    {0.547894, -0.836548},  {0.546610, -0.837387},

    {0.545325, -0.838225},  {0.544039, -0.839060},  {0.542751, -0.839894},
    {0.541462, -0.840725},  {0.540171, -0.841555},  {0.538880, -0.842383},
    {0.537587, -0.843208},  {0.536293, -0.844032},

    {0.534998, -0.844854},  {0.533701, -0.845673},  {0.532403, -0.846491},
    {0.531104, -0.847307},  {0.529804, -0.848120},  {0.528502, -0.848932},
    {0.527199, -0.849742},  {0.525895, -0.850549},

    {0.524590, -0.851355},  {0.523283, -0.852159},  {0.521975, -0.852961},
    {0.520666, -0.853760},  {0.519356, -0.854558},  {0.518045, -0.855354},
    {0.516732, -0.856147},  {0.515418, -0.856939},

    {0.514103, -0.857729},  {0.512786, -0.858516},  {0.511469, -0.859302},
    {0.510150, -0.860085},  {0.508830, -0.860867},  {0.507509, -0.861646},
    {0.506187, -0.862424},  {0.504863, -0.863199},

    {0.503538, -0.863973},  {0.502212, -0.864744},  {0.500885, -0.865514},
    {0.499557, -0.866281},  {0.498228, -0.867046},  {0.496897, -0.867809},
    {0.495565, -0.868571},  {0.494232, -0.869330},

    {0.492898, -0.870087},  {0.491563, -0.870842},  {0.490226, -0.871595},
    {0.488889, -0.872346},  {0.487550, -0.873095},  {0.486210, -0.873842},
    {0.484869, -0.874587},  {0.483527, -0.875329},

    {0.482184, -0.876070},  {0.480839, -0.876809},  {0.479494, -0.877545},
    {0.478147, -0.878280},  {0.476799, -0.879012},  {0.475450, -0.879743},
    {0.474100, -0.880471},  {0.472749, -0.881197},

    {0.471397, -0.881921},  {0.470043, -0.882643},  {0.468689, -0.883363},
    {0.467333, -0.884081},  {0.465977, -0.884797},  {0.464619, -0.885511},
    {0.463260, -0.886223},  {0.461900, -0.886932},

    {0.460539, -0.887640},  {0.459177, -0.888345},  {0.457813, -0.889048},
    {0.456449, -0.889750},  {0.455084, -0.890449},  {0.453717, -0.891146},
    {0.452350, -0.891841},  {0.450981, -0.892534},

    {0.449611, -0.893224},  {0.448241, -0.893913},  {0.446869, -0.894599},
    {0.445496, -0.895284},  {0.444122, -0.895966},  {0.442747, -0.896646},
    {0.441371, -0.897325},  {0.439994, -0.898001},

    {0.438616, -0.898674},  {0.437237, -0.899346},  {0.435857, -0.900016},
    {0.434476, -0.900683},  {0.433094, -0.901349},  {0.431711, -0.902012},
    {0.430326, -0.902673},  {0.428941, -0.903332},

    {0.427555, -0.903989},  {0.426168, -0.904644},  {0.424780, -0.905297},
    {0.423390, -0.905947},  {0.422000, -0.906596},  {0.420609, -0.907242},
    {0.419217, -0.907886},  {0.417824, -0.908528},

    {0.416430, -0.909168},  {0.415034, -0.909806},  {0.413638, -0.910441},
    {0.412241, -0.911075},  {0.410843, -0.911706},  {0.409444, -0.912335},
    {0.408044, -0.912962},  {0.406643, -0.913587},

    {0.405241, -0.914210},  {0.403838, -0.914830},  {0.402435, -0.915449},
    {0.401030, -0.916065},  {0.399624, -0.916679},  {0.398218, -0.917291},
    {0.396810, -0.917901},  {0.395401, -0.918508},

    {0.393992, -0.919114},  {0.392582, -0.919717},  {0.391170, -0.920318},
    {0.389758, -0.920917},  {0.388345, -0.921514},  {0.386931, -0.922109},
    {0.385516, -0.922701},  {0.384100, -0.923291},

    {0.382683, -0.923880},  {0.381266, -0.924465},  {0.379847, -0.925049},
    {0.378428, -0.925631},  {0.377007, -0.926210},  {0.375586, -0.926787},
    {0.374164, -0.927363},  {0.372741, -0.927935},

    {0.371317, -0.928506},  {0.369892, -0.929075},  {0.368467, -0.929641},
    {0.367040, -0.930205},  {0.365613, -0.930767},  {0.364185, -0.931327},
    {0.362756, -0.931884},  {0.361326, -0.932440},

    {0.359895, -0.932993},  {0.358463, -0.933544},  {0.357031, -0.934093},
    {0.355598, -0.934639},  {0.354164, -0.935184},  {0.352729, -0.935726},
    {0.351293, -0.936266},  {0.349856, -0.936803},

    {0.348419, -0.937339},  {0.346980, -0.937872},  {0.345541, -0.938404},
    {0.344101, -0.938932},  {0.342661, -0.939459},  {0.341219, -0.939984},
    {0.339777, -0.940506},  {0.338334, -0.941026},

    {0.336890, -0.941544},  {0.335445, -0.942060},  {0.334000, -0.942573},
    {0.332553, -0.943084},  {0.331106, -0.943593},  {0.329658, -0.944100},
    {0.328210, -0.944605},  {0.326760, -0.945107},

    {0.325310, -0.945607},  {0.323859, -0.946105},  {0.322408, -0.946601},
    {0.320955, -0.947094},  {0.319502, -0.947586},  {0.318048, -0.948075},
    {0.316593, -0.948561},  {0.315138, -0.949046},

    {0.313682, -0.949528},  {0.312225, -0.950008},  {0.310767, -0.950486},
    {0.309309, -0.950962},  {0.307850, -0.951435},  {0.306390, -0.951906},
    {0.304929, -0.952375},  {0.303468, -0.952842},

    {0.302006, -0.953306},  {0.300543, -0.953768},  {0.299080, -0.954228},
    {0.297616, -0.954686},  {0.296151, -0.955141},  {0.294685, -0.955594},
    {0.293219, -0.956045},  {0.291752, -0.956494},

    {0.290285, -0.956940},  {0.288816, -0.957385},  {0.287347, -0.957826},
    {0.285878, -0.958266},  {0.284408, -0.958703},  {0.282937, -0.959139},
    {0.281465, -0.959572},  {0.279993, -0.960002},

    {0.278520, -0.960431},  {0.277046, -0.960857},  {0.275572, -0.961280},
    {0.274097, -0.961702},  {0.272621, -0.962121},  {0.271145, -0.962538},
    {0.269668, -0.962953},  {0.268191, -0.963366},

    {0.266713, -0.963776},  {0.265234, -0.964184},  {0.263755, -0.964590},
    {0.262275, -0.964993},  {0.260794, -0.965394},  {0.259313, -0.965793},
    {0.257831, -0.966190},  {0.256349, -0.966584},

    {0.254866, -0.966976},  {0.253382, -0.967366},  {0.251898, -0.967754},
    {0.250413, -0.968139},  {0.248928, -0.968522},  {0.247442, -0.968903},
    {0.245955, -0.969281},  {0.244468, -0.969657},

    {0.242980, -0.970031},  {0.241492, -0.970403},  {0.240003, -0.970772},
    {0.238514, -0.971139},  {0.237024, -0.971504},  {0.235533, -0.971866},
    {0.234042, -0.972227},  {0.232550, -0.972584},

    {0.231058, -0.972940},  {0.229565, -0.973293},  {0.228072, -0.973644},
    {0.226578, -0.973993},  {0.225084, -0.974339},  {0.223589, -0.974684},
    {0.222094, -0.975025},  {0.220598, -0.975365},

    {0.219101, -0.975702},  {0.217604, -0.976037},  {0.216107, -0.976370},
    {0.214609, -0.976700},  {0.213110, -0.977028},  {0.211611, -0.977354},
    {0.210112, -0.977677},  {0.208612, -0.977998},

    {0.207111, -0.978317},  {0.205610, -0.978634},  {0.204109, -0.978948},
    {0.202607, -0.979260},  {0.201105, -0.979570},  {0.199602, -0.979877},
    {0.198098, -0.980182},  {0.196595, -0.980485},

    {0.195090, -0.980785},  {0.193586, -0.981083},  {0.192080, -0.981379},
    {0.190575, -0.981673},  {0.189069, -0.981964},  {0.187562, -0.982253},
    {0.186055, -0.982539},  {0.184548, -0.982824},

    {0.183040, -0.983105},  {0.181532, -0.983385},  {0.180023, -0.983662},
    {0.178514, -0.983937},  {0.177004, -0.984210},  {0.175494, -0.984480},
    {0.173984, -0.984748},  {0.172473, -0.985014},

    {0.170962, -0.985278},  {0.169450, -0.985539},  {0.167938, -0.985798},
    {0.166426, -0.986054},  {0.164913, -0.986308},  {0.163400, -0.986560},
    {0.161886, -0.986809},  {0.160372, -0.987057},

    {0.158858, -0.987301},  {0.157343, -0.987544},  {0.155828, -0.987784},
    {0.154313, -0.988022},  {0.152797, -0.988258},  {0.151281, -0.988491},
    {0.149765, -0.988722},  {0.148248, -0.988950},

    {0.146730, -0.989177},  {0.145213, -0.989400},  {0.143695, -0.989622},
    {0.142177, -0.989841},  {0.140658, -0.990058},  {0.139139, -0.990273},
    {0.137620, -0.990485},  {0.136101, -0.990695},

    {0.134581, -0.990903},  {0.133061, -0.991108},  {0.131540, -0.991311},
    {0.130019, -0.991511},  {0.128498, -0.991710},  {0.126977, -0.991906},
    {0.125455, -0.992099},  {0.123933, -0.992291},

    {0.122411, -0.992480},  {0.120888, -0.992666},  {0.119365, -0.992850},
    {0.117842, -0.993032},  {0.116319, -0.993212},  {0.114795, -0.993389},
    {0.113271, -0.993564},  {0.111747, -0.993737},

    {0.110222, -0.993907},  {0.108697, -0.994075},  {0.107172, -0.994240},
    {0.105647, -0.994404},  {0.104122, -0.994565},  {0.102596, -0.994723},
    {0.101070, -0.994879},  {0.099544, -0.995033},

    {0.098017, -0.995185},  {0.096490, -0.995334},  {0.094963, -0.995481},
    {0.093436, -0.995625},  {0.091909, -0.995767},  {0.090381, -0.995907},
    {0.088854, -0.996045},  {0.087326, -0.996180},

    {0.085797, -0.996313},  {0.084269, -0.996443},  {0.082740, -0.996571},
    {0.081211, -0.996697},  {0.079682, -0.996820},  {0.078153, -0.996941},
    {0.076624, -0.997060},  {0.075094, -0.997176},

    {0.073565, -0.997290},  {0.072035, -0.997402},  {0.070505, -0.997511},
    {0.068974, -0.997618},  {0.067444, -0.997723},  {0.065913, -0.997825},
    {0.064383, -0.997925},  {0.062852, -0.998023},

    {0.061321, -0.998118},  {0.059790, -0.998211},  {0.058258, -0.998302},
    {0.056727, -0.998390},  {0.055195, -0.998476},  {0.053664, -0.998559},
    {0.052132, -0.998640},  {0.050600, -0.998719},

    {0.049068, -0.998795},  {0.047535, -0.998870},  {0.046003, -0.998941},
    {0.044471, -0.999011},  {0.042938, -0.999078},  {0.041406, -0.999142},
    {0.039873, -0.999205},  {0.038340, -0.999265},

    {0.036807, -0.999322},  {0.035274, -0.999378},  {0.033741, -0.999431},
    {0.032208, -0.999481},  {0.030675, -0.999529},  {0.029142, -0.999575},
    {0.027608, -0.999619},  {0.026075, -0.999660},

    {0.024541, -0.999699},  {0.023008, -0.999735},  {0.021474, -0.999769},
    {0.019940, -0.999801},  {0.018407, -0.999831},  {0.016873, -0.999858},
    {0.015339, -0.999882},  {0.013805, -0.999905},

    {0.012272, -0.999925},  {0.010738, -0.999942},  {0.009204, -0.999958},
    {0.007670, -0.999971},  {0.006136, -0.999981},  {0.004602, -0.999989},
    {0.003068, -0.999995},  {0.001534, -0.999999},

    {0.000000, -1.000000},  {-0.001534, -0.999999}, {-0.003068, -0.999995},
    {-0.004602, -0.999989}, {-0.006136, -0.999981}, {-0.007670, -0.999971},
    {-0.009204, -0.999958}, {-0.010738, -0.999942},

    {-0.012272, -0.999925}, {-0.013805, -0.999905}, {-0.015339, -0.999882},
    {-0.016873, -0.999858}, {-0.018407, -0.999831}, {-0.019940, -0.999801},
    {-0.021474, -0.999769}, {-0.023008, -0.999735},

    {-0.024541, -0.999699}, {-0.026075, -0.999660}, {-0.027608, -0.999619},
    {-0.029142, -0.999575}, {-0.030675, -0.999529}, {-0.032208, -0.999481},
    {-0.033741, -0.999431}, {-0.035274, -0.999378},

    {-0.036807, -0.999322}, {-0.038340, -0.999265}, {-0.039873, -0.999205},
    {-0.041406, -0.999142}, {-0.042938, -0.999078}, {-0.044471, -0.999011},
    {-0.046003, -0.998941}, {-0.047535, -0.998870},

    {-0.049068, -0.998795}, {-0.050600, -0.998719}, {-0.052132, -0.998640},
    {-0.053664, -0.998559}, {-0.055195, -0.998476}, {-0.056727, -0.998390},
    {-0.058258, -0.998302}, {-0.059790, -0.998211},

    {-0.061321, -0.998118}, {-0.062852, -0.998023}, {-0.064383, -0.997925},
    {-0.065913, -0.997825}, {-0.067444, -0.997723}, {-0.068974, -0.997618},
    {-0.070505, -0.997511}, {-0.072035, -0.997402},

    {-0.073565, -0.997290}, {-0.075094, -0.997176}, {-0.076624, -0.997060},
    {-0.078153, -0.996941}, {-0.079682, -0.996820}, {-0.081211, -0.996697},
    {-0.082740, -0.996571}, {-0.084269, -0.996443},

    {-0.085797, -0.996313}, {-0.087326, -0.996180}, {-0.088854, -0.996045},
    {-0.090381, -0.995907}, {-0.091909, -0.995767}, {-0.093436, -0.995625},
    {-0.094963, -0.995481}, {-0.096490, -0.995334},

    {-0.098017, -0.995185}, {-0.099544, -0.995033}, {-0.101070, -0.994879},
    {-0.102596, -0.994723}, {-0.104122, -0.994565}, {-0.105647, -0.994404},
    {-0.107172, -0.994240}, {-0.108697, -0.994075},

    {-0.110222, -0.993907}, {-0.111747, -0.993737}, {-0.113271, -0.993564},
    {-0.114795, -0.993389}, {-0.116319, -0.993212}, {-0.117842, -0.993032},
    {-0.119365, -0.992850}, {-0.120888, -0.992666},

    {-0.122411, -0.992480}, {-0.123933, -0.992291}, {-0.125455, -0.992099},
    {-0.126977, -0.991906}, {-0.128498, -0.991710}, {-0.130019, -0.991511},
    {-0.131540, -0.991311}, {-0.133061, -0.991108},

    {-0.134581, -0.990903}, {-0.136101, -0.990695}, {-0.137620, -0.990485},
    {-0.139139, -0.990273}, {-0.140658, -0.990058}, {-0.142177, -0.989841},
    {-0.143695, -0.989622}, {-0.145213, -0.989400},

    {-0.146730, -0.989177}, {-0.148248, -0.988950}, {-0.149765, -0.988722},
    {-0.151281, -0.988491}, {-0.152797, -0.988258}, {-0.154313, -0.988022},
    {-0.155828, -0.987784}, {-0.157343, -0.987544},

    {-0.158858, -0.987301}, {-0.160372, -0.987057}, {-0.161886, -0.986809},
    {-0.163400, -0.986560}, {-0.164913, -0.986308}, {-0.166426, -0.986054},
    {-0.167938, -0.985798}, {-0.169450, -0.985539},

    {-0.170962, -0.985278}, {-0.172473, -0.985014}, {-0.173984, -0.984748},
    {-0.175494, -0.984480}, {-0.177004, -0.984210}, {-0.178514, -0.983937},
    {-0.180023, -0.983662}, {-0.181532, -0.983385},

    {-0.183040, -0.983105}, {-0.184548, -0.982824}, {-0.186055, -0.982539},
    {-0.187562, -0.982253}, {-0.189069, -0.981964}, {-0.190575, -0.981673},
    {-0.192080, -0.981379}, {-0.193586, -0.981083},

    {-0.195090, -0.980785}, {-0.196595, -0.980485}, {-0.198098, -0.980182},
    {-0.199602, -0.979877}, {-0.201105, -0.979570}, {-0.202607, -0.979260},
    {-0.204109, -0.978948}, {-0.205610, -0.978634},

    {-0.207111, -0.978317}, {-0.208612, -0.977998}, {-0.210112, -0.977677},
    {-0.211611, -0.977354}, {-0.213110, -0.977028}, {-0.214609, -0.976700},
    {-0.216107, -0.976370}, {-0.217604, -0.976037},

    {-0.219101, -0.975702}, {-0.220598, -0.975365}, {-0.222094, -0.975025},
    {-0.223589, -0.974684}, {-0.225084, -0.974339}, {-0.226578, -0.973993},
    {-0.228072, -0.973644}, {-0.229565, -0.973293},

    {-0.231058, -0.972940}, {-0.232550, -0.972584}, {-0.234042, -0.972227},
    {-0.235533, -0.971866}, {-0.237024, -0.971504}, {-0.238514, -0.971139},
    {-0.240003, -0.970772}, {-0.241492, -0.970403},

    {-0.242980, -0.970031}, {-0.244468, -0.969657}, {-0.245955, -0.969281},
    {-0.247442, -0.968903}, {-0.248928, -0.968522}, {-0.250413, -0.968139},
    {-0.251898, -0.967754}, {-0.253382, -0.967366},

    {-0.254866, -0.966976}, {-0.256349, -0.966584}, {-0.257831, -0.966190},
    {-0.259313, -0.965793}, {-0.260794, -0.965394}, {-0.262275, -0.964993},
    {-0.263755, -0.964590}, {-0.265234, -0.964184},

    {-0.266713, -0.963776}, {-0.268191, -0.963366}, {-0.269668, -0.962953},
    {-0.271145, -0.962538}, {-0.272621, -0.962121}, {-0.274097, -0.961702},
    {-0.275572, -0.961280}, {-0.277046, -0.960857},

    {-0.278520, -0.960431}, {-0.279993, -0.960002}, {-0.281465, -0.959572},
    {-0.282937, -0.959139}, {-0.284408, -0.958703}, {-0.285878, -0.958266},
    {-0.287347, -0.957826}, {-0.288816, -0.957385},

    {-0.290285, -0.956940}, {-0.291752, -0.956494}, {-0.293219, -0.956045},
    {-0.294685, -0.955594}, {-0.296151, -0.955141}, {-0.297616, -0.954686},
    {-0.299080, -0.954228}, {-0.300543, -0.953768},

    {-0.302006, -0.953306}, {-0.303468, -0.952842}, {-0.304929, -0.952375},
    {-0.306390, -0.951906}, {-0.307850, -0.951435}, {-0.309309, -0.950962},
    {-0.310767, -0.950486}, {-0.312225, -0.950008},

    {-0.313682, -0.949528}, {-0.315138, -0.949046}, {-0.316593, -0.948561},
    {-0.318048, -0.948075}, {-0.319502, -0.947586}, {-0.320955, -0.947094},
    {-0.322408, -0.946601}, {-0.323859, -0.946105},

    {-0.325310, -0.945607}, {-0.326760, -0.945107}, {-0.328210, -0.944605},
    {-0.329658, -0.944100}, {-0.331106, -0.943593}, {-0.332553, -0.943084},
    {-0.334000, -0.942573}, {-0.335445, -0.942060},

    {-0.336890, -0.941544}, {-0.338334, -0.941026}, {-0.339777, -0.940506},
    {-0.341219, -0.939984}, {-0.342661, -0.939459}, {-0.344101, -0.938932},
    {-0.345541, -0.938404}, {-0.346980, -0.937872},

    {-0.348419, -0.937339}, {-0.349856, -0.936803}, {-0.351293, -0.936266},
    {-0.352729, -0.935726}, {-0.354164, -0.935184}, {-0.355598, -0.934639},
    {-0.357031, -0.934093}, {-0.358463, -0.933544},

    {-0.359895, -0.932993}, {-0.361326, -0.932440}, {-0.362756, -0.931884},
    {-0.364185, -0.931327}, {-0.365613, -0.930767}, {-0.367040, -0.930205},
    {-0.368467, -0.929641}, {-0.369892, -0.929075},

    {-0.371317, -0.928506}, {-0.372741, -0.927935}, {-0.374164, -0.927363},
    {-0.375586, -0.926787}, {-0.377007, -0.926210}, {-0.378428, -0.925631},
    {-0.379847, -0.925049}, {-0.381266, -0.924465},

    {-0.382683, -0.923880}, {-0.384100, -0.923291}, {-0.385516, -0.922701},
    {-0.386931, -0.922109}, {-0.388345, -0.921514}, {-0.389758, -0.920917},
    {-0.391170, -0.920318}, {-0.392582, -0.919717},

    {-0.393992, -0.919114}, {-0.395401, -0.918508}, {-0.396810, -0.917901},
    {-0.398218, -0.917291}, {-0.399624, -0.916679}, {-0.401030, -0.916065},
    {-0.402435, -0.915449}, {-0.403838, -0.914830},

    {-0.405241, -0.914210}, {-0.406643, -0.913587}, {-0.408044, -0.912962},
    {-0.409444, -0.912335}, {-0.410843, -0.911706}, {-0.412241, -0.911075},
    {-0.413638, -0.910441}, {-0.415034, -0.909806},

    {-0.416430, -0.909168}, {-0.417824, -0.908528}, {-0.419217, -0.907886},
    {-0.420609, -0.907242}, {-0.422000, -0.906596}, {-0.423390, -0.905947},
    {-0.424780, -0.905297}, {-0.426168, -0.904644},

    {-0.427555, -0.903989}, {-0.428941, -0.903332}, {-0.430326, -0.902673},
    {-0.431711, -0.902012}, {-0.433094, -0.901349}, {-0.434476, -0.900683},
    {-0.435857, -0.900016}, {-0.437237, -0.899346},

    {-0.438616, -0.898674}, {-0.439994, -0.898001}, {-0.441371, -0.897325},
    {-0.442747, -0.896646}, {-0.444122, -0.895966}, {-0.445496, -0.895284},
    {-0.446869, -0.894599}, {-0.448241, -0.893913},

    {-0.449611, -0.893224}, {-0.450981, -0.892534}, {-0.452350, -0.891841},
    {-0.453717, -0.891146}, {-0.455084, -0.890449}, {-0.456449, -0.889750},
    {-0.457813, -0.889048}, {-0.459177, -0.888345},

    {-0.460539, -0.887640}, {-0.461900, -0.886932}, {-0.463260, -0.886223},
    {-0.464619, -0.885511}, {-0.465977, -0.884797}, {-0.467333, -0.884081},
    {-0.468689, -0.883363}, {-0.470043, -0.882643},

    {-0.471397, -0.881921}, {-0.472749, -0.881197}, {-0.474100, -0.880471},
    {-0.475450, -0.879743}, {-0.476799, -0.879012}, {-0.478147, -0.878280},
    {-0.479494, -0.877545}, {-0.480839, -0.876809},

    {-0.482184, -0.876070}, {-0.483527, -0.875329}, {-0.484869, -0.874587},
    {-0.486210, -0.873842}, {-0.487550, -0.873095}, {-0.488889, -0.872346},
    {-0.490226, -0.871595}, {-0.491563, -0.870842},

    {-0.492898, -0.870087}, {-0.494232, -0.869330}, {-0.495565, -0.868571},
    {-0.496897, -0.867809}, {-0.498228, -0.867046}, {-0.499557, -0.866281},
    {-0.500885, -0.865514}, {-0.502212, -0.864744},

    {-0.503538, -0.863973}, {-0.504863, -0.863199}, {-0.506187, -0.862424},
    {-0.507509, -0.861646}, {-0.508830, -0.860867}, {-0.510150, -0.860085},
    {-0.511469, -0.859302}, {-0.512786, -0.858516},

    {-0.514103, -0.857729}, {-0.515418, -0.856939}, {-0.516732, -0.856147},
    {-0.518045, -0.855354}, {-0.519356, -0.854558}, {-0.520666, -0.853760},
    {-0.521975, -0.852961}, {-0.523283, -0.852159},

    {-0.524590, -0.851355}, {-0.525895, -0.850549}, {-0.527199, -0.849742},
    {-0.528502, -0.848932}, {-0.529804, -0.848120}, {-0.531104, -0.847307},
    {-0.532403, -0.846491}, {-0.533701, -0.845673},

    {-0.534998, -0.844854}, {-0.536293, -0.844032}, {-0.537587, -0.843208},
    {-0.538880, -0.842383}, {-0.540171, -0.841555}, {-0.541462, -0.840725},
    {-0.542751, -0.839894}, {-0.544039, -0.839060},

    {-0.545325, -0.838225}, {-0.546610, -0.837387}, {-0.547894, -0.836548},
    {-0.549177, -0.835706}, {-0.550458, -0.834863}, {-0.551738, -0.834018},
    {-0.553017, -0.833170}, {-0.554294, -0.832321},

    {-0.555570, -0.831470}, {-0.556845, -0.830616}, {-0.558119, -0.829761},
    {-0.559391, -0.828904}, {-0.560662, -0.828045}, {-0.561931, -0.827184},
    {-0.563199, -0.826321}, {-0.564466, -0.825456},

    {-0.565732, -0.824589}, {-0.566996, -0.823721}, {-0.568259, -0.822850},
    {-0.569521, -0.821977}, {-0.570781, -0.821102}, {-0.572040, -0.820226},
    {-0.573297, -0.819348}, {-0.574553, -0.818467},

    {-0.575808, -0.817585}, {-0.577062, -0.816701}, {-0.578314, -0.815814},
    {-0.579565, -0.814926}, {-0.580814, -0.814036}, {-0.582062, -0.813144},
    {-0.583309, -0.812251}, {-0.584554, -0.811355},

    {-0.585798, -0.810457}, {-0.587040, -0.809558}, {-0.588282, -0.808656},
    {-0.589521, -0.807753}, {-0.590760, -0.806848}, {-0.591997, -0.805940},
    {-0.593232, -0.805031}, {-0.594467, -0.804120},

    {-0.595699, -0.803208}, {-0.596931, -0.802293}, {-0.598161, -0.801376},
    {-0.599389, -0.800458}, {-0.600616, -0.799537}, {-0.601842, -0.798615},
    {-0.603067, -0.797691}, {-0.604290, -0.796765},

    {-0.605511, -0.795837}, {-0.606731, -0.794907}, {-0.607950, -0.793975},
    {-0.609167, -0.793042}, {-0.610383, -0.792107}, {-0.611597, -0.791169},
    {-0.612810, -0.790230}, {-0.614022, -0.789289},

    {-0.615232, -0.788346}, {-0.616440, -0.787402}, {-0.617647, -0.786455},
    {-0.618853, -0.785507}, {-0.620057, -0.784557}, {-0.621260, -0.783605},
    {-0.622461, -0.782651}, {-0.623661, -0.781695},

    {-0.624860, -0.780737}, {-0.626056, -0.779778}, {-0.627252, -0.778817},
    {-0.628446, -0.777853}, {-0.629638, -0.776888}, {-0.630829, -0.775922},
    {-0.632019, -0.774953}, {-0.633207, -0.773983},

    {-0.634393, -0.773010}, {-0.635578, -0.772036}, {-0.636762, -0.771061},
    {-0.637944, -0.770083}, {-0.639124, -0.769103}, {-0.640303, -0.768122},
    {-0.641481, -0.767139}, {-0.642657, -0.766154},

    {-0.643832, -0.765167}, {-0.645005, -0.764179}, {-0.646176, -0.763188},
    {-0.647346, -0.762196}, {-0.648514, -0.761202}, {-0.649681, -0.760207},
    {-0.650847, -0.759209}, {-0.652011, -0.758210},

    {-0.653173, -0.757209}, {-0.654334, -0.756206}, {-0.655493, -0.755201},
    {-0.656651, -0.754195}, {-0.657807, -0.753187}, {-0.658961, -0.752177},
    {-0.660114, -0.751165}, {-0.661266, -0.750152},

    {-0.662416, -0.749136}, {-0.663564, -0.748119}, {-0.664711, -0.747101},
    {-0.665856, -0.746080}, {-0.667000, -0.745058}, {-0.668142, -0.744034},
    {-0.669283, -0.743008}, {-0.670422, -0.741980},

    {-0.671559, -0.740951}, {-0.672695, -0.739920}, {-0.673829, -0.738887},
    {-0.674962, -0.737853}, {-0.676093, -0.736817}, {-0.677222, -0.735779},
    {-0.678350, -0.734739}, {-0.679476, -0.733697},

    {-0.680601, -0.732654}, {-0.681724, -0.731609}, {-0.682846, -0.730563},
    {-0.683965, -0.729514}, {-0.685084, -0.728464}, {-0.686200, -0.727413},
    {-0.687315, -0.726359}, {-0.688429, -0.725304},

    {-0.689541, -0.724247}, {-0.690651, -0.723188}, {-0.691759, -0.722128},
    {-0.692866, -0.721066}, {-0.693971, -0.720003}, {-0.695075, -0.718937},
    {-0.696177, -0.717870}, {-0.697277, -0.716801},

    {-0.698376, -0.715731}, {-0.699473, -0.714659}, {-0.700569, -0.713585},
    {-0.701663, -0.712509}, {-0.702755, -0.711432}, {-0.703845, -0.710353},
    {-0.704934, -0.709273}, {-0.706021, -0.708191},

    {-0.707107, -0.707107}, {-0.708191, -0.706021}, {-0.709273, -0.704934},
    {-0.710353, -0.703845}, {-0.711432, -0.702755}, {-0.712509, -0.701663},
    {-0.713585, -0.700569}, {-0.714659, -0.699473},

    {-0.715731, -0.698376}, {-0.716801, -0.697277}, {-0.717870, -0.696177},
    {-0.718937, -0.695075}, {-0.720003, -0.693971}, {-0.721066, -0.692866},
    {-0.722128, -0.691759}, {-0.723188, -0.690651},

    {-0.724247, -0.689541}, {-0.725304, -0.688429}, {-0.726359, -0.687315},
    {-0.727413, -0.686200}, {-0.728464, -0.685084}, {-0.729514, -0.683965},
    {-0.730563, -0.682846}, {-0.731609, -0.681724},

    {-0.732654, -0.680601}, {-0.733697, -0.679476}, {-0.734739, -0.678350},
    {-0.735779, -0.677222}, {-0.736817, -0.676093}, {-0.737853, -0.674962},
    {-0.738887, -0.673829}, {-0.739920, -0.672695},

    {-0.740951, -0.671559}, {-0.741980, -0.670422}, {-0.743008, -0.669283},
    {-0.744034, -0.668142}, {-0.745058, -0.667000}, {-0.746080, -0.665856},
    {-0.747101, -0.664711}, {-0.748119, -0.663564},

    {-0.749136, -0.662416}, {-0.750152, -0.661266}, {-0.751165, -0.660114},
    {-0.752177, -0.658961}, {-0.753187, -0.657807}, {-0.754195, -0.656651},
    {-0.755201, -0.655493}, {-0.756206, -0.654334},

    {-0.757209, -0.653173}, {-0.758210, -0.652011}, {-0.759209, -0.650847},
    {-0.760207, -0.649681}, {-0.761202, -0.648514}, {-0.762196, -0.647346},
    {-0.763188, -0.646176}, {-0.764179, -0.645005},

    {-0.765167, -0.643832}, {-0.766154, -0.642657}, {-0.767139, -0.641481},
    {-0.768122, -0.640303}, {-0.769103, -0.639124}, {-0.770083, -0.637944},
    {-0.771061, -0.636762}, {-0.772036, -0.635578},

    {-0.773010, -0.634393}, {-0.773983, -0.633207}, {-0.774953, -0.632019},
    {-0.775922, -0.630829}, {-0.776888, -0.629638}, {-0.777853, -0.628446},
    {-0.778817, -0.627252}, {-0.779778, -0.626056},

    {-0.780737, -0.624860}, {-0.781695, -0.623661}, {-0.782651, -0.622461},
    {-0.783605, -0.621260}, {-0.784557, -0.620057}, {-0.785507, -0.618853},
    {-0.786455, -0.617647}, {-0.787402, -0.616440},

    {-0.788346, -0.615232}, {-0.789289, -0.614022}, {-0.790230, -0.612810},
    {-0.791169, -0.611597}, {-0.792107, -0.610383}, {-0.793042, -0.609167},
    {-0.793975, -0.607950}, {-0.794907, -0.606731},

    {-0.795837, -0.605511}, {-0.796765, -0.604290}, {-0.797691, -0.603067},
    {-0.798615, -0.601842}, {-0.799537, -0.600616}, {-0.800458, -0.599389},
    {-0.801376, -0.598161}, {-0.802293, -0.596931},

    {-0.803208, -0.595699}, {-0.804120, -0.594467}, {-0.805031, -0.593232},
    {-0.805940, -0.591997}, {-0.806848, -0.590760}, {-0.807753, -0.589521},
    {-0.808656, -0.588282}, {-0.809558, -0.587040},

    {-0.810457, -0.585798}, {-0.811355, -0.584554}, {-0.812251, -0.583309},
    {-0.813144, -0.582062}, {-0.814036, -0.580814}, {-0.814926, -0.579565},
    {-0.815814, -0.578314}, {-0.816701, -0.577062},

    {-0.817585, -0.575808}, {-0.818467, -0.574553}, {-0.819348, -0.573297},
    {-0.820226, -0.572040}, {-0.821102, -0.570781}, {-0.821977, -0.569521},
    {-0.822850, -0.568259}, {-0.823721, -0.566996},

    {-0.824589, -0.565732}, {-0.825456, -0.564466}, {-0.826321, -0.563199},
    {-0.827184, -0.561931}, {-0.828045, -0.560662}, {-0.828904, -0.559391},
    {-0.829761, -0.558119}, {-0.830616, -0.556845},

    {-0.831470, -0.555570}, {-0.832321, -0.554294}, {-0.833170, -0.553017},
    {-0.834018, -0.551738}, {-0.834863, -0.550458}, {-0.835706, -0.549177},
    {-0.836548, -0.547894}, {-0.837387, -0.546610},

    {-0.838225, -0.545325}, {-0.839060, -0.544039}, {-0.839894, -0.542751},
    {-0.840725, -0.541462}, {-0.841555, -0.540171}, {-0.842383, -0.538880},
    {-0.843208, -0.537587}, {-0.844032, -0.536293},

    {-0.844854, -0.534998}, {-0.845673, -0.533701}, {-0.846491, -0.532403},
    {-0.847307, -0.531104}, {-0.848120, -0.529804}, {-0.848932, -0.528502},
    {-0.849742, -0.527199}, {-0.850549, -0.525895},

    {-0.851355, -0.524590}, {-0.852159, -0.523283}, {-0.852961, -0.521975},
    {-0.853760, -0.520666}, {-0.854558, -0.519356}, {-0.855354, -0.518045},
    {-0.856147, -0.516732}, {-0.856939, -0.515418},

    {-0.857729, -0.514103}, {-0.858516, -0.512786}, {-0.859302, -0.511469},
    {-0.860085, -0.510150}, {-0.860867, -0.508830}, {-0.861646, -0.507509},
    {-0.862424, -0.506187}, {-0.863199, -0.504863},

    {-0.863973, -0.503538}, {-0.864744, -0.502212}, {-0.865514, -0.500885},
    {-0.866281, -0.499557}, {-0.867046, -0.498228}, {-0.867809, -0.496897},
    {-0.868571, -0.495565}, {-0.869330, -0.494232},

    {-0.870087, -0.492898}, {-0.870842, -0.491563}, {-0.871595, -0.490226},
    {-0.872346, -0.488889}, {-0.873095, -0.487550}, {-0.873842, -0.486210},
    {-0.874587, -0.484869}, {-0.875329, -0.483527},

    {-0.876070, -0.482184}, {-0.876809, -0.480839}, {-0.877545, -0.479494},
    {-0.878280, -0.478147}, {-0.879012, -0.476799}, {-0.879743, -0.475450},
    {-0.880471, -0.474100}, {-0.881197, -0.472749},

    {-0.881921, -0.471397}, {-0.882643, -0.470043}, {-0.883363, -0.468689},
    {-0.884081, -0.467333}, {-0.884797, -0.465977}, {-0.885511, -0.464619},
    {-0.886223, -0.463260}, {-0.886932, -0.461900},

    {-0.887640, -0.460539}, {-0.888345, -0.459177}, {-0.889048, -0.457813},
    {-0.889750, -0.456449}, {-0.890449, -0.455084}, {-0.891146, -0.453717},
    {-0.891841, -0.452350}, {-0.892534, -0.450981},

    {-0.893224, -0.449611}, {-0.893913, -0.448241}, {-0.894599, -0.446869},
    {-0.895284, -0.445496}, {-0.895966, -0.444122}, {-0.896646, -0.442747},
    {-0.897325, -0.441371}, {-0.898001, -0.439994},

    {-0.898674, -0.438616}, {-0.899346, -0.437237}, {-0.900016, -0.435857},
    {-0.900683, -0.434476}, {-0.901349, -0.433094}, {-0.902012, -0.431711},
    {-0.902673, -0.430326}, {-0.903332, -0.428941},

    {-0.903989, -0.427555}, {-0.904644, -0.426168}, {-0.905297, -0.424780},
    {-0.905947, -0.423390}, {-0.906596, -0.422000}, {-0.907242, -0.420609},
    {-0.907886, -0.419217}, {-0.908528, -0.417824},

    {-0.909168, -0.416430}, {-0.909806, -0.415034}, {-0.910441, -0.413638},
    {-0.911075, -0.412241}, {-0.911706, -0.410843}, {-0.912335, -0.409444},
    {-0.912962, -0.408044}, {-0.913587, -0.406643},

    {-0.914210, -0.405241}, {-0.914830, -0.403838}, {-0.915449, -0.402435},
    {-0.916065, -0.401030}, {-0.916679, -0.399624}, {-0.917291, -0.398218},
    {-0.917901, -0.396810}, {-0.918508, -0.395401},

    {-0.919114, -0.393992}, {-0.919717, -0.392582}, {-0.920318, -0.391170},
    {-0.920917, -0.389758}, {-0.921514, -0.388345}, {-0.922109, -0.386931},
    {-0.922701, -0.385516}, {-0.923291, -0.384100},

    {-0.923880, -0.382683}, {-0.924465, -0.381266}, {-0.925049, -0.379847},
    {-0.925631, -0.378428}, {-0.926210, -0.377007}, {-0.926787, -0.375586},
    {-0.927363, -0.374164}, {-0.927935, -0.372741},

    {-0.928506, -0.371317}, {-0.929075, -0.369892}, {-0.929641, -0.368467},
    {-0.930205, -0.367040}, {-0.930767, -0.365613}, {-0.931327, -0.364185},
    {-0.931884, -0.362756}, {-0.932440, -0.361326},

    {-0.932993, -0.359895}, {-0.933544, -0.358463}, {-0.934093, -0.357031},
    {-0.934639, -0.355598}, {-0.935184, -0.354164}, {-0.935726, -0.352729},
    {-0.936266, -0.351293}, {-0.936803, -0.349856},

    {-0.937339, -0.348419}, {-0.937872, -0.346980}, {-0.938404, -0.345541},
    {-0.938932, -0.344101}, {-0.939459, -0.342661}, {-0.939984, -0.341219},
    {-0.940506, -0.339777}, {-0.941026, -0.338334},

    {-0.941544, -0.336890}, {-0.942060, -0.335445}, {-0.942573, -0.334000},
    {-0.943084, -0.332553}, {-0.943593, -0.331106}, {-0.944100, -0.329658},
    {-0.944605, -0.328210}, {-0.945107, -0.326760},

    {-0.945607, -0.325310}, {-0.946105, -0.323859}, {-0.946601, -0.322408},
    {-0.947094, -0.320955}, {-0.947586, -0.319502}, {-0.948075, -0.318048},
    {-0.948561, -0.316593}, {-0.949046, -0.315138},

    {-0.949528, -0.313682}, {-0.950008, -0.312225}, {-0.950486, -0.310767},
    {-0.950962, -0.309309}, {-0.951435, -0.307850}, {-0.951906, -0.306390},
    {-0.952375, -0.304929}, {-0.952842, -0.303468},

    {-0.953306, -0.302006}, {-0.953768, -0.300543}, {-0.954228, -0.299080},
    {-0.954686, -0.297616}, {-0.955141, -0.296151}, {-0.955594, -0.294685},
    {-0.956045, -0.293219}, {-0.956494, -0.291752},

    {-0.956940, -0.290285}, {-0.957385, -0.288816}, {-0.957826, -0.287347},
    {-0.958266, -0.285878}, {-0.958703, -0.284408}, {-0.959139, -0.282937},
    {-0.959572, -0.281465}, {-0.960002, -0.279993},

    {-0.960431, -0.278520}, {-0.960857, -0.277046}, {-0.961280, -0.275572},
    {-0.961702, -0.274097}, {-0.962121, -0.272621}, {-0.962538, -0.271145},
    {-0.962953, -0.269668}, {-0.963366, -0.268191},

    {-0.963776, -0.266713}, {-0.964184, -0.265234}, {-0.964590, -0.263755},
    {-0.964993, -0.262275}, {-0.965394, -0.260794}, {-0.965793, -0.259313},
    {-0.966190, -0.257831}, {-0.966584, -0.256349},

    {-0.966976, -0.254866}, {-0.967366, -0.253382}, {-0.967754, -0.251898},
    {-0.968139, -0.250413}, {-0.968522, -0.248928}, {-0.968903, -0.247442},
    {-0.969281, -0.245955}, {-0.969657, -0.244468},

    {-0.970031, -0.242980}, {-0.970403, -0.241492}, {-0.970772, -0.240003},
    {-0.971139, -0.238514}, {-0.971504, -0.237024}, {-0.971866, -0.235533},
    {-0.972227, -0.234042}, {-0.972584, -0.232550},

    {-0.972940, -0.231058}, {-0.973293, -0.229565}, {-0.973644, -0.228072},
    {-0.973993, -0.226578}, {-0.974339, -0.225084}, {-0.974684, -0.223589},
    {-0.975025, -0.222094}, {-0.975365, -0.220598},

    {-0.975702, -0.219101}, {-0.976037, -0.217604}, {-0.976370, -0.216107},
    {-0.976700, -0.214609}, {-0.977028, -0.213110}, {-0.977354, -0.211611},
    {-0.977677, -0.210112}, {-0.977998, -0.208612},

    {-0.978317, -0.207111}, {-0.978634, -0.205610}, {-0.978948, -0.204109},
    {-0.979260, -0.202607}, {-0.979570, -0.201105}, {-0.979877, -0.199602},
    {-0.980182, -0.198098}, {-0.980485, -0.196595},

    {-0.980785, -0.195090}, {-0.981083, -0.193586}, {-0.981379, -0.192080},
    {-0.981673, -0.190575}, {-0.981964, -0.189069}, {-0.982253, -0.187562},
    {-0.982539, -0.186055}, {-0.982824, -0.184548},

    {-0.983105, -0.183040}, {-0.983385, -0.181532}, {-0.983662, -0.180023},
    {-0.983937, -0.178514}, {-0.984210, -0.177004}, {-0.984480, -0.175494},
    {-0.984748, -0.173984}, {-0.985014, -0.172473},

    {-0.985278, -0.170962}, {-0.985539, -0.169450}, {-0.985798, -0.167938},
    {-0.986054, -0.166426}, {-0.986308, -0.164913}, {-0.986560, -0.163400},
    {-0.986809, -0.161886}, {-0.987057, -0.160372},

    {-0.987301, -0.158858}, {-0.987544, -0.157343}, {-0.987784, -0.155828},
    {-0.988022, -0.154313}, {-0.988258, -0.152797}, {-0.988491, -0.151281},
    {-0.988722, -0.149765}, {-0.988950, -0.148248},

    {-0.989177, -0.146730}, {-0.989400, -0.145213}, {-0.989622, -0.143695},
    {-0.989841, -0.142177}, {-0.990058, -0.140658}, {-0.990273, -0.139139},
    {-0.990485, -0.137620}, {-0.990695, -0.136101},

    {-0.990903, -0.134581}, {-0.991108, -0.133061}, {-0.991311, -0.131540},
    {-0.991511, -0.130019}, {-0.991710, -0.128498}, {-0.991906, -0.126977},
    {-0.992099, -0.125455}, {-0.992291, -0.123933},

    {-0.992480, -0.122411}, {-0.992666, -0.120888}, {-0.992850, -0.119365},
    {-0.993032, -0.117842}, {-0.993212, -0.116319}, {-0.993389, -0.114795},
    {-0.993564, -0.113271}, {-0.993737, -0.111747},

    {-0.993907, -0.110222}, {-0.994075, -0.108697}, {-0.994240, -0.107172},
    {-0.994404, -0.105647}, {-0.994565, -0.104122}, {-0.994723, -0.102596},
    {-0.994879, -0.101070}, {-0.995033, -0.099544},

    {-0.995185, -0.098017}, {-0.995334, -0.096490}, {-0.995481, -0.094963},
    {-0.995625, -0.093436}, {-0.995767, -0.091909}, {-0.995907, -0.090381},
    {-0.996045, -0.088854}, {-0.996180, -0.087326},

    {-0.996313, -0.085797}, {-0.996443, -0.084269}, {-0.996571, -0.082740},
    {-0.996697, -0.081211}, {-0.996820, -0.079682}, {-0.996941, -0.078153},
    {-0.997060, -0.076624}, {-0.997176, -0.075094},

    {-0.997290, -0.073565}, {-0.997402, -0.072035}, {-0.997511, -0.070505},
    {-0.997618, -0.068974}, {-0.997723, -0.067444}, {-0.997825, -0.065913},
    {-0.997925, -0.064383}, {-0.998023, -0.062852},

    {-0.998118, -0.061321}, {-0.998211, -0.059790}, {-0.998302, -0.058258},
    {-0.998390, -0.056727}, {-0.998476, -0.055195}, {-0.998559, -0.053664},
    {-0.998640, -0.052132}, {-0.998719, -0.050600},

    {-0.998795, -0.049068}, {-0.998870, -0.047535}, {-0.998941, -0.046003},
    {-0.999011, -0.044471}, {-0.999078, -0.042938}, {-0.999142, -0.041406},
    {-0.999205, -0.039873}, {-0.999265, -0.038340},

    {-0.999322, -0.036807}, {-0.999378, -0.035274}, {-0.999431, -0.033741},
    {-0.999481, -0.032208}, {-0.999529, -0.030675}, {-0.999575, -0.029142},
    {-0.999619, -0.027608}, {-0.999660, -0.026075},

    {-0.999699, -0.024541}, {-0.999735, -0.023008}, {-0.999769, -0.021474},
    {-0.999801, -0.019940}, {-0.999831, -0.018407}, {-0.999858, -0.016873},
    {-0.999882, -0.015339}, {-0.999905, -0.013805},

    {-0.999925, -0.012272}, {-0.999942, -0.010738}, {-0.999958, -0.009204},
    {-0.999971, -0.007670}, {-0.999981, -0.006136}, {-0.999989, -0.004602},
    {-0.999995, -0.003068}, {-0.999999, -0.001534}

};
#endif //_SUPPORTS_CBFLOAT16_

const cint32 twiddle_master_cint32[2048] = {{2147483647, 0},
                                            {2147481121, -3294197},
                                            {2147473542, -6588387},
                                            {2147460908, -9882561},
                                            {2147443222, -13176712},
                                            {2147420483, -16470832},
                                            {2147392690, -19764913},
                                            {2147359845, -23058947},

                                            {2147321946, -26352928},
                                            {2147278995, -29646846},
                                            {2147230991, -32940695},
                                            {2147177934, -36234466},
                                            {2147119825, -39528151},
                                            {2147056664, -42821744},
                                            {2146988450, -46115236},
                                            {2146915184, -49408620},

                                            {2146836866, -52701887},
                                            {2146753497, -55995030},
                                            {2146665076, -59288042},
                                            {2146571603, -62580914},
                                            {2146473080, -65873638},
                                            {2146369505, -69166208},
                                            {2146260881, -72458615},
                                            {2146147205, -75750851},

                                            {2146028480, -79042909},
                                            {2145904705, -82334782},
                                            {2145775880, -85626460},
                                            {2145642006, -88917937},
                                            {2145503083, -92209205},
                                            {2145359112, -95500255},
                                            {2145210092, -98791081},
                                            {2145056025, -102081675},

                                            {2144896910, -105372028},
                                            {2144732748, -108662134},
                                            {2144563539, -111951983},
                                            {2144389283, -115241570},
                                            {2144209982, -118530885},
                                            {2144025635, -121819921},
                                            {2143836244, -125108670},
                                            {2143641807, -128397125},

                                            {2143442326, -131685278},
                                            {2143237802, -134973122},
                                            {2143028234, -138260647},
                                            {2142813624, -141547847},
                                            {2142593971, -144834714},
                                            {2142369276, -148121241},
                                            {2142139541, -151407418},
                                            {2141904764, -154693240},

                                            {2141664948, -157978697},
                                            {2141420092, -161263783},
                                            {2141170197, -164548489},
                                            {2140915264, -167832808},
                                            {2140655293, -171116733},
                                            {2140390284, -174400254},
                                            {2140120240, -177683365},
                                            {2139845159, -180966058},

                                            {2139565043, -184248325},
                                            {2139279892, -187530159},
                                            {2138989708, -190811551},
                                            {2138694490, -194092495},
                                            {2138394240, -197372981},
                                            {2138088958, -200653003},
                                            {2137778644, -203932553},
                                            {2137463301, -207211624},

                                            {2137142927, -210490206},
                                            {2136817525, -213768293},
                                            {2136487095, -217045878},
                                            {2136151637, -220322951},
                                            {2135811153, -223599506},
                                            {2135465642, -226875535},
                                            {2135115107, -230151030},
                                            {2134759548, -233425984},

                                            {2134398966, -236700388},
                                            {2134033361, -239974235},
                                            {2133662734, -243247518},
                                            {2133287087, -246520228},
                                            {2132906420, -249792358},
                                            {2132520734, -253063900},
                                            {2132130030, -256334847},
                                            {2131734309, -259605191},

                                            {2131333572, -262874923},
                                            {2130927819, -266144038},
                                            {2130517052, -269412525},
                                            {2130101272, -272680379},
                                            {2129680480, -275947592},
                                            {2129254676, -279214155},
                                            {2128823862, -282480061},
                                            {2128388038, -285745302},

                                            {2127947206, -289009871},
                                            {2127501367, -292273760},
                                            {2127050522, -295536961},
                                            {2126594672, -298799466},
                                            {2126133817, -302061269},
                                            {2125667960, -305322361},
                                            {2125197100, -308582734},
                                            {2124721240, -311842381},

                                            {2124240380, -315101295},
                                            {2123754522, -318359466},
                                            {2123263666, -321616889},
                                            {2122767814, -324873555},
                                            {2122266967, -328129457},
                                            {2121761126, -331384586},
                                            {2121250292, -334638936},
                                            {2120734467, -337892498},

                                            {2120213651, -341145265},
                                            {2119687847, -344397230},
                                            {2119157054, -347648383},
                                            {2118621275, -350898719},
                                            {2118080511, -354148230},
                                            {2117534762, -357396906},
                                            {2116984031, -360644742},
                                            {2116428319, -363891730},

                                            {2115867626, -367137861},
                                            {2115301954, -370383128},
                                            {2114731305, -373627523},
                                            {2114155680, -376871039},
                                            {2113575080, -380113669},
                                            {2112989506, -383355404},
                                            {2112398960, -386596237},
                                            {2111803444, -389836160},

                                            {2111202959, -393075166},
                                            {2110597505, -396313247},
                                            {2109987085, -399550396},
                                            {2109371700, -402786604},
                                            {2108751352, -406021865},
                                            {2108126041, -409256170},
                                            {2107495770, -412489512},
                                            {2106860540, -415721883},

                                            {2106220352, -418953276},
                                            {2105575208, -422183684},
                                            {2104925109, -425413098},
                                            {2104270057, -428641511},
                                            {2103610054, -431868915},
                                            {2102945101, -435095303},
                                            {2102275199, -438320667},
                                            {2101600350, -441545000},

                                            {2100920556, -444768294},
                                            {2100235819, -447990541},
                                            {2099546139, -451211734},
                                            {2098851519, -454431865},
                                            {2098151960, -457650927},
                                            {2097447464, -460868912},
                                            {2096738032, -464085813},
                                            {2096023667, -467301622},

                                            {2095304370, -470516330},
                                            {2094580142, -473729932},
                                            {2093850985, -476942419},
                                            {2093116901, -480153784},
                                            {2092377892, -483364019},
                                            {2091633960, -486573117},
                                            {2090885105, -489781069},
                                            {2090131331, -492987869},

                                            {2089372638, -496193509},
                                            {2088609029, -499397982},
                                            {2087840505, -502601279},
                                            {2087067068, -505803394},
                                            {2086288720, -509004318},
                                            {2085505463, -512204045},
                                            {2084717298, -515402566},
                                            {2083924228, -518599875},

                                            {2083126254, -521795963},
                                            {2082323379, -524990824},
                                            {2081515603, -528184449},
                                            {2080702930, -531376831},
                                            {2079885360, -534567963},
                                            {2079062896, -537757837},
                                            {2078235540, -540946445},
                                            {2077403294, -544133781},

                                            {2076566160, -547319836},
                                            {2075724139, -550504604},
                                            {2074877233, -553688076},
                                            {2074025446, -556870245},
                                            {2073168777, -560051104},
                                            {2072307231, -563230645},
                                            {2071440808, -566408860},
                                            {2070569511, -569585743},

                                            {2069693342, -572761285},
                                            {2068812302, -575935480},
                                            {2067926394, -579108320},
                                            {2067035621, -582279796},
                                            {2066139983, -585449903},
                                            {2065239484, -588618632},
                                            {2064334124, -591785976},
                                            {2063423908, -594951927},

                                            {2062508835, -598116479},
                                            {2061588910, -601279623},
                                            {2060664133, -604441352},
                                            {2059734508, -607601658},
                                            {2058800036, -610760536},
                                            {2057860719, -613917975},
                                            {2056916560, -617073971},
                                            {2055967560, -620228514},

                                            {2055013723, -623381598},
                                            {2054055050, -626533215},
                                            {2053091544, -629683357},
                                            {2052123207, -632832018},
                                            {2051150040, -635979190},
                                            {2050172048, -639124865},
                                            {2049189231, -642269036},
                                            {2048201592, -645411696},

                                            {2047209133, -648552838},
                                            {2046211857, -651692453},
                                            {2045209767, -654830535},
                                            {2044202863, -657967075},
                                            {2043191150, -661102068},
                                            {2042174628, -664235505},
                                            {2041153301, -667367379},
                                            {2040127172, -670497682},

                                            {2039096241, -673626408},
                                            {2038060512, -676753549},
                                            {2037019988, -679879097},
                                            {2035974670, -683003045},
                                            {2034924562, -686125387},
                                            {2033869665, -689246113},
                                            {2032809982, -692365218},
                                            {2031745516, -695482694},

                                            {2030676269, -698598533},
                                            {2029602243, -701712728},
                                            {2028523442, -704825272},
                                            {2027439867, -707936158},
                                            {2026351522, -711045377},
                                            {2025258408, -714152924},
                                            {2024160529, -717258790},
                                            {2023057887, -720362968},

                                            {2021950484, -723465451},
                                            {2020838323, -726566232},
                                            {2019721407, -729665303},
                                            {2018599739, -732762657},
                                            {2017473321, -735858287},
                                            {2016342155, -738952186},
                                            {2015206245, -742044345},
                                            {2014065592, -745134758},

                                            {2012920201, -748223418},
                                            {2011770073, -751310318},
                                            {2010615210, -754395449},
                                            {2009455617, -757478806},
                                            {2008291295, -760560380},
                                            {2007122248, -763640164},
                                            {2005948478, -766718151},
                                            {2004769987, -769794334},

                                            {2003586779, -772868706},
                                            {2002398857, -775941259},
                                            {2001206222, -779011986},
                                            {2000008879, -782080880},
                                            {1998806829, -785147934},
                                            {1997600076, -788213141},
                                            {1996388622, -791276492},
                                            {1995172471, -794337982},

                                            {1993951625, -797397602},
                                            {1992726087, -800455346},
                                            {1991495860, -803511207},
                                            {1990260946, -806565177},
                                            {1989021350, -809617249},
                                            {1987777073, -812667415},
                                            {1986528118, -815715670},
                                            {1985274489, -818762005},

                                            {1984016189, -821806413},
                                            {1982753220, -824848888},
                                            {1981485585, -827889422},
                                            {1980213288, -830928007},
                                            {1978936331, -833964638},
                                            {1977654717, -836999305},
                                            {1976368450, -840032004},
                                            {1975077532, -843062726},

                                            {1973781967, -846091463},
                                            {1972481757, -849118210},
                                            {1971176906, -852142959},
                                            {1969867417, -855165703},
                                            {1968553292, -858186435},
                                            {1967234535, -861205147},
                                            {1965911148, -864221832},
                                            {1964583136, -867236484},

                                            {1963250501, -870249095},
                                            {1961913246, -873259659},
                                            {1960571375, -876268167},
                                            {1959224890, -879274614},
                                            {1957873796, -882278992},
                                            {1956518093, -885281293},
                                            {1955157788, -888281512},
                                            {1953792881, -891279640},

                                            {1952423377, -894275671},
                                            {1951049279, -897269597},
                                            {1949670589, -900261413},
                                            {1948287312, -903251110},
                                            {1946899451, -906238681},
                                            {1945507008, -909224120},
                                            {1944109987, -912207419},
                                            {1942708392, -915188572},

                                            {1941302225, -918167572},
                                            {1939891490, -921144411},
                                            {1938476190, -924119082},
                                            {1937056329, -927091579},
                                            {1935631910, -930061894},
                                            {1934202936, -933030021},
                                            {1932769411, -935995952},
                                            {1931331338, -938959681},

                                            {1929888720, -941921200},
                                            {1928441561, -944880503},
                                            {1926989864, -947837582},
                                            {1925533633, -950792431},
                                            {1924072871, -953745043},
                                            {1922607581, -956695411},
                                            {1921137767, -959643527},
                                            {1919663432, -962589385},

                                            {1918184581, -965532978},
                                            {1916701216, -968474300},
                                            {1915213340, -971413342},
                                            {1913720958, -974350098},
                                            {1912224073, -977284562},
                                            {1910722688, -980216726},
                                            {1909216806, -983146583},
                                            {1907706433, -986074127},

                                            {1906191570, -988999351},
                                            {1904672222, -991922248},
                                            {1903148392, -994842810},
                                            {1901620084, -997761031},
                                            {1900087301, -1000676905},
                                            {1898550047, -1003590424},
                                            {1897008325, -1006501581},
                                            {1895462140, -1009410370},

                                            {1893911494, -1012316784},
                                            {1892356392, -1015220816},
                                            {1890796837, -1018122458},
                                            {1889232832, -1021021705},
                                            {1887664383, -1023918550},
                                            {1886091491, -1026812985},
                                            {1884514161, -1029705004},
                                            {1882932397, -1032594600},

                                            {1881346202, -1035481766},
                                            {1879755580, -1038366495},
                                            {1878160535, -1041248781},
                                            {1876561070, -1044128617},
                                            {1874957189, -1047005996},
                                            {1873348897, -1049880912},
                                            {1871736196, -1052753357},
                                            {1870119091, -1055623324},

                                            {1868497586, -1058490808},
                                            {1866871683, -1061355801},
                                            {1865241388, -1064218296},
                                            {1863606704, -1067078288},
                                            {1861967634, -1069935768},
                                            {1860324183, -1072790730},
                                            {1858676355, -1075643169},
                                            {1857024153, -1078493076},

                                            {1855367581, -1081340445},
                                            {1853706643, -1084185270},
                                            {1852041343, -1087027544},
                                            {1850371686, -1089867259},
                                            {1848697674, -1092704411},
                                            {1847019312, -1095538991},
                                            {1845336604, -1098370993},
                                            {1843649553, -1101200410},

                                            {1841958164, -1104027237},
                                            {1840262441, -1106851465},
                                            {1838562388, -1109673089},
                                            {1836858008, -1112492101},
                                            {1835149306, -1115308496},
                                            {1833436286, -1118122267},
                                            {1831718951, -1120933406},
                                            {1829997307, -1123741908},

                                            {1828271356, -1126547765},
                                            {1826541103, -1129350972},
                                            {1824806552, -1132151521},
                                            {1823067707, -1134949406},
                                            {1821324572, -1137744621},
                                            {1819577151, -1140537158},
                                            {1817825449, -1143327011},
                                            {1816069469, -1146114174},

                                            {1814309216, -1148898640},
                                            {1812544694, -1151680403},
                                            {1810775906, -1154459456},
                                            {1809002858, -1157235792},
                                            {1807225553, -1160009405},
                                            {1805443995, -1162780288},
                                            {1803658189, -1165548435},
                                            {1801868139, -1168313840},

                                            {1800073849, -1171076495},
                                            {1798275323, -1173836395},
                                            {1796472565, -1176593533},
                                            {1794665580, -1179347902},
                                            {1792854372, -1182099496},
                                            {1791038946, -1184848308},
                                            {1789219305, -1187594332},
                                            {1787395453, -1190337562},

                                            {1785567396, -1193077991},
                                            {1783735137, -1195815612},
                                            {1781898681, -1198550419},
                                            {1780058032, -1201282407},
                                            {1778213194, -1204011567},
                                            {1776364172, -1206737894},
                                            {1774510970, -1209461382},
                                            {1772653593, -1212182024},

                                            {1770792044, -1214899813},
                                            {1768926328, -1217614743},
                                            {1767056450, -1220326809},
                                            {1765182414, -1223036002},
                                            {1763304224, -1225742318},
                                            {1761421885, -1228445750},
                                            {1759535401, -1231146291},
                                            {1757644777, -1233843935},

                                            {1755750017, -1236538675},
                                            {1753851126, -1239230506},
                                            {1751948107, -1241919421},
                                            {1750040966, -1244605414},
                                            {1748129707, -1247288478},
                                            {1746214334, -1249968606},
                                            {1744294853, -1252645794},
                                            {1742371267, -1255320034},

                                            {1740443581, -1257991320},
                                            {1738511799, -1260659646},
                                            {1736575927, -1263325005},
                                            {1734635968, -1265987392},
                                            {1732691928, -1268646800},
                                            {1730743810, -1271303222},
                                            {1728791620, -1273956653},
                                            {1726835361, -1276607086},

                                            {1724875040, -1279254516},
                                            {1722910659, -1281898935},
                                            {1720942225, -1284540337},
                                            {1718969740, -1287178717},
                                            {1716993211, -1289814068},
                                            {1715012642, -1292446384},
                                            {1713028037, -1295075659},
                                            {1711039401, -1297701886},

                                            {1709046739, -1300325060},
                                            {1707050055, -1302945174},
                                            {1705049355, -1305562222},
                                            {1703044642, -1308176198},
                                            {1701035922, -1310787095},
                                            {1699023199, -1313394909},
                                            {1697006479, -1315999631},
                                            {1694985765, -1318601257},

                                            {1692961062, -1321199781},
                                            {1690932376, -1323795195},
                                            {1688899711, -1326387494},
                                            {1686863072, -1328976672},
                                            {1684822463, -1331562723},
                                            {1682777890, -1334145641},
                                            {1680729357, -1336725419},
                                            {1678676870, -1339302052},

                                            {1676620432, -1341875533},
                                            {1674560049, -1344445857},
                                            {1672495725, -1347013017},
                                            {1670427466, -1349577007},
                                            {1668355276, -1352137822},
                                            {1666279161, -1354695455},
                                            {1664199124, -1357249901},
                                            {1662115172, -1359801152},

                                            {1660027308, -1362349204},
                                            {1657935539, -1364894050},
                                            {1655839867, -1367435685},
                                            {1653740300, -1369974101},
                                            {1651636841, -1372509294},
                                            {1649529496, -1375041258},
                                            {1647418269, -1377569986},
                                            {1645303166, -1380095472},

                                            {1643184191, -1382617710},
                                            {1641061349, -1385136696},
                                            {1638934646, -1387652422},
                                            {1636804087, -1390164882},
                                            {1634669676, -1392674072},
                                            {1632531418, -1395179984},
                                            {1630389319, -1397682613},
                                            {1628243383, -1400181954},

                                            {1626093616, -1402678000},
                                            {1623940023, -1405170745},
                                            {1621782608, -1407660183},
                                            {1619621377, -1410146309},
                                            {1617456335, -1412629117},
                                            {1615287487, -1415108601},
                                            {1613114838, -1417584755},
                                            {1610938393, -1420057574},

                                            {1608758157, -1422527051},
                                            {1606574136, -1424993180},
                                            {1604386335, -1427455956},
                                            {1602194758, -1429915374},
                                            {1599999411, -1432371426},
                                            {1597800299, -1434824109},
                                            {1595597428, -1437273414},
                                            {1593390801, -1439719338},

                                            {1591180426, -1442161874},
                                            {1588966306, -1444601017},
                                            {1586748447, -1447036760},
                                            {1584526854, -1449469098},
                                            {1582301533, -1451898025},
                                            {1580072489, -1454323536},
                                            {1577839726, -1456745625},
                                            {1575603251, -1459164286},

                                            {1573363068, -1461579514},
                                            {1571119183, -1463991302},
                                            {1568871601, -1466399645},
                                            {1566620327, -1468804538},
                                            {1564365367, -1471205974},
                                            {1562106725, -1473603949},
                                            {1559844408, -1475998456},
                                            {1557578421, -1478389489},

                                            {1555308768, -1480777044},
                                            {1553035455, -1483161115},
                                            {1550758488, -1485541696},
                                            {1548477872, -1487918781},
                                            {1546193612, -1490292364},
                                            {1543905714, -1492662441},
                                            {1541614183, -1495029006},
                                            {1539319024, -1497392053},

                                            {1537020244, -1499751576},
                                            {1534717846, -1502107570},
                                            {1532411837, -1504460029},
                                            {1530102222, -1506808949},
                                            {1527789007, -1509154322},
                                            {1525472197, -1511496145},
                                            {1523151797, -1513834411},
                                            {1520827813, -1516169114},

                                            {1518500250, -1518500250},
                                            {1516169114, -1520827813},
                                            {1513834411, -1523151797},
                                            {1511496145, -1525472197},
                                            {1509154322, -1527789007},
                                            {1506808949, -1530102222},
                                            {1504460029, -1532411837},
                                            {1502107570, -1534717846},

                                            {1499751576, -1537020244},
                                            {1497392053, -1539319024},
                                            {1495029006, -1541614183},
                                            {1492662441, -1543905714},
                                            {1490292364, -1546193612},
                                            {1487918781, -1548477872},
                                            {1485541696, -1550758488},
                                            {1483161115, -1553035455},

                                            {1480777044, -1555308768},
                                            {1478389489, -1557578421},
                                            {1475998456, -1559844408},
                                            {1473603949, -1562106725},
                                            {1471205974, -1564365367},
                                            {1468804538, -1566620327},
                                            {1466399645, -1568871601},
                                            {1463991302, -1571119183},

                                            {1461579514, -1573363068},
                                            {1459164286, -1575603251},
                                            {1456745625, -1577839726},
                                            {1454323536, -1580072489},
                                            {1451898025, -1582301533},
                                            {1449469098, -1584526854},
                                            {1447036760, -1586748447},
                                            {1444601017, -1588966306},

                                            {1442161874, -1591180426},
                                            {1439719338, -1593390801},
                                            {1437273414, -1595597428},
                                            {1434824109, -1597800299},
                                            {1432371426, -1599999411},
                                            {1429915374, -1602194758},
                                            {1427455956, -1604386335},
                                            {1424993180, -1606574136},

                                            {1422527051, -1608758157},
                                            {1420057574, -1610938393},
                                            {1417584755, -1613114838},
                                            {1415108601, -1615287487},
                                            {1412629117, -1617456335},
                                            {1410146309, -1619621377},
                                            {1407660183, -1621782608},
                                            {1405170745, -1623940023},

                                            {1402678000, -1626093616},
                                            {1400181954, -1628243383},
                                            {1397682613, -1630389319},
                                            {1395179984, -1632531418},
                                            {1392674072, -1634669676},
                                            {1390164882, -1636804087},
                                            {1387652422, -1638934646},
                                            {1385136696, -1641061349},

                                            {1382617710, -1643184191},
                                            {1380095472, -1645303166},
                                            {1377569986, -1647418269},
                                            {1375041258, -1649529496},
                                            {1372509294, -1651636841},
                                            {1369974101, -1653740300},
                                            {1367435685, -1655839867},
                                            {1364894050, -1657935539},

                                            {1362349204, -1660027308},
                                            {1359801152, -1662115172},
                                            {1357249901, -1664199124},
                                            {1354695455, -1666279161},
                                            {1352137822, -1668355276},
                                            {1349577007, -1670427466},
                                            {1347013017, -1672495725},
                                            {1344445857, -1674560049},

                                            {1341875533, -1676620432},
                                            {1339302052, -1678676870},
                                            {1336725419, -1680729357},
                                            {1334145641, -1682777890},
                                            {1331562723, -1684822463},
                                            {1328976672, -1686863072},
                                            {1326387494, -1688899711},
                                            {1323795195, -1690932376},

                                            {1321199781, -1692961062},
                                            {1318601257, -1694985765},
                                            {1315999631, -1697006479},
                                            {1313394909, -1699023199},
                                            {1310787095, -1701035922},
                                            {1308176198, -1703044642},
                                            {1305562222, -1705049355},
                                            {1302945174, -1707050055},

                                            {1300325060, -1709046739},
                                            {1297701886, -1711039401},
                                            {1295075659, -1713028037},
                                            {1292446384, -1715012642},
                                            {1289814068, -1716993211},
                                            {1287178717, -1718969740},
                                            {1284540337, -1720942225},
                                            {1281898935, -1722910659},

                                            {1279254516, -1724875040},
                                            {1276607086, -1726835361},
                                            {1273956653, -1728791620},
                                            {1271303222, -1730743810},
                                            {1268646800, -1732691928},
                                            {1265987392, -1734635968},
                                            {1263325005, -1736575927},
                                            {1260659646, -1738511799},

                                            {1257991320, -1740443581},
                                            {1255320034, -1742371267},
                                            {1252645794, -1744294853},
                                            {1249968606, -1746214334},
                                            {1247288478, -1748129707},
                                            {1244605414, -1750040966},
                                            {1241919421, -1751948107},
                                            {1239230506, -1753851126},

                                            {1236538675, -1755750017},
                                            {1233843935, -1757644777},
                                            {1231146291, -1759535401},
                                            {1228445750, -1761421885},
                                            {1225742318, -1763304224},
                                            {1223036002, -1765182414},
                                            {1220326809, -1767056450},
                                            {1217614743, -1768926328},

                                            {1214899813, -1770792044},
                                            {1212182024, -1772653593},
                                            {1209461382, -1774510970},
                                            {1206737894, -1776364172},
                                            {1204011567, -1778213194},
                                            {1201282407, -1780058032},
                                            {1198550419, -1781898681},
                                            {1195815612, -1783735137},

                                            {1193077991, -1785567396},
                                            {1190337562, -1787395453},
                                            {1187594332, -1789219305},
                                            {1184848308, -1791038946},
                                            {1182099496, -1792854372},
                                            {1179347902, -1794665580},
                                            {1176593533, -1796472565},
                                            {1173836395, -1798275323},

                                            {1171076495, -1800073849},
                                            {1168313840, -1801868139},
                                            {1165548435, -1803658189},
                                            {1162780288, -1805443995},
                                            {1160009405, -1807225553},
                                            {1157235792, -1809002858},
                                            {1154459456, -1810775906},
                                            {1151680403, -1812544694},

                                            {1148898640, -1814309216},
                                            {1146114174, -1816069469},
                                            {1143327011, -1817825449},
                                            {1140537158, -1819577151},
                                            {1137744621, -1821324572},
                                            {1134949406, -1823067707},
                                            {1132151521, -1824806552},
                                            {1129350972, -1826541103},

                                            {1126547765, -1828271356},
                                            {1123741908, -1829997307},
                                            {1120933406, -1831718951},
                                            {1118122267, -1833436286},
                                            {1115308496, -1835149306},
                                            {1112492101, -1836858008},
                                            {1109673089, -1838562388},
                                            {1106851465, -1840262441},

                                            {1104027237, -1841958164},
                                            {1101200410, -1843649553},
                                            {1098370993, -1845336604},
                                            {1095538991, -1847019312},
                                            {1092704411, -1848697674},
                                            {1089867259, -1850371686},
                                            {1087027544, -1852041343},
                                            {1084185270, -1853706643},

                                            {1081340445, -1855367581},
                                            {1078493076, -1857024153},
                                            {1075643169, -1858676355},
                                            {1072790730, -1860324183},
                                            {1069935768, -1861967634},
                                            {1067078288, -1863606704},
                                            {1064218296, -1865241388},
                                            {1061355801, -1866871683},

                                            {1058490808, -1868497586},
                                            {1055623324, -1870119091},
                                            {1052753357, -1871736196},
                                            {1049880912, -1873348897},
                                            {1047005996, -1874957189},
                                            {1044128617, -1876561070},
                                            {1041248781, -1878160535},
                                            {1038366495, -1879755580},

                                            {1035481766, -1881346202},
                                            {1032594600, -1882932397},
                                            {1029705004, -1884514161},
                                            {1026812985, -1886091491},
                                            {1023918550, -1887664383},
                                            {1021021705, -1889232832},
                                            {1018122458, -1890796837},
                                            {1015220816, -1892356392},

                                            {1012316784, -1893911494},
                                            {1009410370, -1895462140},
                                            {1006501581, -1897008325},
                                            {1003590424, -1898550047},
                                            {1000676905, -1900087301},
                                            {997761031, -1901620084},
                                            {994842810, -1903148392},
                                            {991922248, -1904672222},

                                            {988999351, -1906191570},
                                            {986074127, -1907706433},
                                            {983146583, -1909216806},
                                            {980216726, -1910722688},
                                            {977284562, -1912224073},
                                            {974350098, -1913720958},
                                            {971413342, -1915213340},
                                            {968474300, -1916701216},

                                            {965532978, -1918184581},
                                            {962589385, -1919663432},
                                            {959643527, -1921137767},
                                            {956695411, -1922607581},
                                            {953745043, -1924072871},
                                            {950792431, -1925533633},
                                            {947837582, -1926989864},
                                            {944880503, -1928441561},

                                            {941921200, -1929888720},
                                            {938959681, -1931331338},
                                            {935995952, -1932769411},
                                            {933030021, -1934202936},
                                            {930061894, -1935631910},
                                            {927091579, -1937056329},
                                            {924119082, -1938476190},
                                            {921144411, -1939891490},

                                            {918167572, -1941302225},
                                            {915188572, -1942708392},
                                            {912207419, -1944109987},
                                            {909224120, -1945507008},
                                            {906238681, -1946899451},
                                            {903251110, -1948287312},
                                            {900261413, -1949670589},
                                            {897269597, -1951049279},

                                            {894275671, -1952423377},
                                            {891279640, -1953792881},
                                            {888281512, -1955157788},
                                            {885281293, -1956518093},
                                            {882278992, -1957873796},
                                            {879274614, -1959224890},
                                            {876268167, -1960571375},
                                            {873259659, -1961913246},

                                            {870249095, -1963250501},
                                            {867236484, -1964583136},
                                            {864221832, -1965911148},
                                            {861205147, -1967234535},
                                            {858186435, -1968553292},
                                            {855165703, -1969867417},
                                            {852142959, -1971176906},
                                            {849118210, -1972481757},

                                            {846091463, -1973781967},
                                            {843062726, -1975077532},
                                            {840032004, -1976368450},
                                            {836999305, -1977654717},
                                            {833964638, -1978936331},
                                            {830928007, -1980213288},
                                            {827889422, -1981485585},
                                            {824848888, -1982753220},

                                            {821806413, -1984016189},
                                            {818762005, -1985274489},
                                            {815715670, -1986528118},
                                            {812667415, -1987777073},
                                            {809617249, -1989021350},
                                            {806565177, -1990260946},
                                            {803511207, -1991495860},
                                            {800455346, -1992726087},

                                            {797397602, -1993951625},
                                            {794337982, -1995172471},
                                            {791276492, -1996388622},
                                            {788213141, -1997600076},
                                            {785147934, -1998806829},
                                            {782080880, -2000008879},
                                            {779011986, -2001206222},
                                            {775941259, -2002398857},

                                            {772868706, -2003586779},
                                            {769794334, -2004769987},
                                            {766718151, -2005948478},
                                            {763640164, -2007122248},
                                            {760560380, -2008291295},
                                            {757478806, -2009455617},
                                            {754395449, -2010615210},
                                            {751310318, -2011770073},

                                            {748223418, -2012920201},
                                            {745134758, -2014065592},
                                            {742044345, -2015206245},
                                            {738952186, -2016342155},
                                            {735858287, -2017473321},
                                            {732762657, -2018599739},
                                            {729665303, -2019721407},
                                            {726566232, -2020838323},

                                            {723465451, -2021950484},
                                            {720362968, -2023057887},
                                            {717258790, -2024160529},
                                            {714152924, -2025258408},
                                            {711045377, -2026351522},
                                            {707936158, -2027439867},
                                            {704825272, -2028523442},
                                            {701712728, -2029602243},

                                            {698598533, -2030676269},
                                            {695482694, -2031745516},
                                            {692365218, -2032809982},
                                            {689246113, -2033869665},
                                            {686125387, -2034924562},
                                            {683003045, -2035974670},
                                            {679879097, -2037019988},
                                            {676753549, -2038060512},

                                            {673626408, -2039096241},
                                            {670497682, -2040127172},
                                            {667367379, -2041153301},
                                            {664235505, -2042174628},
                                            {661102068, -2043191150},
                                            {657967075, -2044202863},
                                            {654830535, -2045209767},
                                            {651692453, -2046211857},

                                            {648552838, -2047209133},
                                            {645411696, -2048201592},
                                            {642269036, -2049189231},
                                            {639124865, -2050172048},
                                            {635979190, -2051150040},
                                            {632832018, -2052123207},
                                            {629683357, -2053091544},
                                            {626533215, -2054055050},

                                            {623381598, -2055013723},
                                            {620228514, -2055967560},
                                            {617073971, -2056916560},
                                            {613917975, -2057860719},
                                            {610760536, -2058800036},
                                            {607601658, -2059734508},
                                            {604441352, -2060664133},
                                            {601279623, -2061588910},

                                            {598116479, -2062508835},
                                            {594951927, -2063423908},
                                            {591785976, -2064334124},
                                            {588618632, -2065239484},
                                            {585449903, -2066139983},
                                            {582279796, -2067035621},
                                            {579108320, -2067926394},
                                            {575935480, -2068812302},

                                            {572761285, -2069693342},
                                            {569585743, -2070569511},
                                            {566408860, -2071440808},
                                            {563230645, -2072307231},
                                            {560051104, -2073168777},
                                            {556870245, -2074025446},
                                            {553688076, -2074877233},
                                            {550504604, -2075724139},

                                            {547319836, -2076566160},
                                            {544133781, -2077403294},
                                            {540946445, -2078235540},
                                            {537757837, -2079062896},
                                            {534567963, -2079885360},
                                            {531376831, -2080702930},
                                            {528184449, -2081515603},
                                            {524990824, -2082323379},

                                            {521795963, -2083126254},
                                            {518599875, -2083924228},
                                            {515402566, -2084717298},
                                            {512204045, -2085505463},
                                            {509004318, -2086288720},
                                            {505803394, -2087067068},
                                            {502601279, -2087840505},
                                            {499397982, -2088609029},

                                            {496193509, -2089372638},
                                            {492987869, -2090131331},
                                            {489781069, -2090885105},
                                            {486573117, -2091633960},
                                            {483364019, -2092377892},
                                            {480153784, -2093116901},
                                            {476942419, -2093850985},
                                            {473729932, -2094580142},

                                            {470516330, -2095304370},
                                            {467301622, -2096023667},
                                            {464085813, -2096738032},
                                            {460868912, -2097447464},
                                            {457650927, -2098151960},
                                            {454431865, -2098851519},
                                            {451211734, -2099546139},
                                            {447990541, -2100235819},

                                            {444768294, -2100920556},
                                            {441545000, -2101600350},
                                            {438320667, -2102275199},
                                            {435095303, -2102945101},
                                            {431868915, -2103610054},
                                            {428641511, -2104270057},
                                            {425413098, -2104925109},
                                            {422183684, -2105575208},

                                            {418953276, -2106220352},
                                            {415721883, -2106860540},
                                            {412489512, -2107495770},
                                            {409256170, -2108126041},
                                            {406021865, -2108751352},
                                            {402786604, -2109371700},
                                            {399550396, -2109987085},
                                            {396313247, -2110597505},

                                            {393075166, -2111202959},
                                            {389836160, -2111803444},
                                            {386596237, -2112398960},
                                            {383355404, -2112989506},
                                            {380113669, -2113575080},
                                            {376871039, -2114155680},
                                            {373627523, -2114731305},
                                            {370383128, -2115301954},

                                            {367137861, -2115867626},
                                            {363891730, -2116428319},
                                            {360644742, -2116984031},
                                            {357396906, -2117534762},
                                            {354148230, -2118080511},
                                            {350898719, -2118621275},
                                            {347648383, -2119157054},
                                            {344397230, -2119687847},

                                            {341145265, -2120213651},
                                            {337892498, -2120734467},
                                            {334638936, -2121250292},
                                            {331384586, -2121761126},
                                            {328129457, -2122266967},
                                            {324873555, -2122767814},
                                            {321616889, -2123263666},
                                            {318359466, -2123754522},

                                            {315101295, -2124240380},
                                            {311842381, -2124721240},
                                            {308582734, -2125197100},
                                            {305322361, -2125667960},
                                            {302061269, -2126133817},
                                            {298799466, -2126594672},
                                            {295536961, -2127050522},
                                            {292273760, -2127501367},

                                            {289009871, -2127947206},
                                            {285745302, -2128388038},
                                            {282480061, -2128823862},
                                            {279214155, -2129254676},
                                            {275947592, -2129680480},
                                            {272680379, -2130101272},
                                            {269412525, -2130517052},
                                            {266144038, -2130927819},

                                            {262874923, -2131333572},
                                            {259605191, -2131734309},
                                            {256334847, -2132130030},
                                            {253063900, -2132520734},
                                            {249792358, -2132906420},
                                            {246520228, -2133287087},
                                            {243247518, -2133662734},
                                            {239974235, -2134033361},

                                            {236700388, -2134398966},
                                            {233425984, -2134759548},
                                            {230151030, -2135115107},
                                            {226875535, -2135465642},
                                            {223599506, -2135811153},
                                            {220322951, -2136151637},
                                            {217045878, -2136487095},
                                            {213768293, -2136817525},

                                            {210490206, -2137142927},
                                            {207211624, -2137463301},
                                            {203932553, -2137778644},
                                            {200653003, -2138088958},
                                            {197372981, -2138394240},
                                            {194092495, -2138694490},
                                            {190811551, -2138989708},
                                            {187530159, -2139279892},

                                            {184248325, -2139565043},
                                            {180966058, -2139845159},
                                            {177683365, -2140120240},
                                            {174400254, -2140390284},
                                            {171116733, -2140655293},
                                            {167832808, -2140915264},
                                            {164548489, -2141170197},
                                            {161263783, -2141420092},

                                            {157978697, -2141664948},
                                            {154693240, -2141904764},
                                            {151407418, -2142139541},
                                            {148121241, -2142369276},
                                            {144834714, -2142593971},
                                            {141547847, -2142813624},
                                            {138260647, -2143028234},
                                            {134973122, -2143237802},

                                            {131685278, -2143442326},
                                            {128397125, -2143641807},
                                            {125108670, -2143836244},
                                            {121819921, -2144025635},
                                            {118530885, -2144209982},
                                            {115241570, -2144389283},
                                            {111951983, -2144563539},
                                            {108662134, -2144732748},

                                            {105372028, -2144896910},
                                            {102081675, -2145056025},
                                            {98791081, -2145210092},
                                            {95500255, -2145359112},
                                            {92209205, -2145503083},
                                            {88917937, -2145642006},
                                            {85626460, -2145775880},
                                            {82334782, -2145904705},

                                            {79042909, -2146028480},
                                            {75750851, -2146147205},
                                            {72458615, -2146260881},
                                            {69166208, -2146369505},
                                            {65873638, -2146473080},
                                            {62580914, -2146571603},
                                            {59288042, -2146665076},
                                            {55995030, -2146753497},

                                            {52701887, -2146836866},
                                            {49408620, -2146915184},
                                            {46115236, -2146988450},
                                            {42821744, -2147056664},
                                            {39528151, -2147119825},
                                            {36234466, -2147177934},
                                            {32940695, -2147230991},
                                            {29646846, -2147278995},

                                            {26352928, -2147321946},
                                            {23058947, -2147359845},
                                            {19764913, -2147392690},
                                            {16470832, -2147420483},
                                            {13176712, -2147443222},
                                            {9882561, -2147460908},
                                            {6588387, -2147473542},
                                            {3294197, -2147481121},

                                            {0, -2147483648},
                                            {-3294197, -2147481121},
                                            {-6588387, -2147473542},
                                            {-9882561, -2147460908},
                                            {-13176712, -2147443222},
                                            {-16470832, -2147420483},
                                            {-19764913, -2147392690},
                                            {-23058947, -2147359845},

                                            {-26352928, -2147321946},
                                            {-29646846, -2147278995},
                                            {-32940695, -2147230991},
                                            {-36234466, -2147177934},
                                            {-39528151, -2147119825},
                                            {-42821744, -2147056664},
                                            {-46115236, -2146988450},
                                            {-49408620, -2146915184},

                                            {-52701887, -2146836866},
                                            {-55995030, -2146753497},
                                            {-59288042, -2146665076},
                                            {-62580914, -2146571603},
                                            {-65873638, -2146473080},
                                            {-69166208, -2146369505},
                                            {-72458615, -2146260881},
                                            {-75750851, -2146147205},

                                            {-79042909, -2146028480},
                                            {-82334782, -2145904705},
                                            {-85626460, -2145775880},
                                            {-88917937, -2145642006},
                                            {-92209205, -2145503083},
                                            {-95500255, -2145359112},
                                            {-98791081, -2145210092},
                                            {-102081675, -2145056025},

                                            {-105372028, -2144896910},
                                            {-108662134, -2144732748},
                                            {-111951983, -2144563539},
                                            {-115241570, -2144389283},
                                            {-118530885, -2144209982},
                                            {-121819921, -2144025635},
                                            {-125108670, -2143836244},
                                            {-128397125, -2143641807},

                                            {-131685278, -2143442326},
                                            {-134973122, -2143237802},
                                            {-138260647, -2143028234},
                                            {-141547847, -2142813624},
                                            {-144834714, -2142593971},
                                            {-148121241, -2142369276},
                                            {-151407418, -2142139541},
                                            {-154693240, -2141904764},

                                            {-157978697, -2141664948},
                                            {-161263783, -2141420092},
                                            {-164548489, -2141170197},
                                            {-167832808, -2140915264},
                                            {-171116733, -2140655293},
                                            {-174400254, -2140390284},
                                            {-177683365, -2140120240},
                                            {-180966058, -2139845159},

                                            {-184248325, -2139565043},
                                            {-187530159, -2139279892},
                                            {-190811551, -2138989708},
                                            {-194092495, -2138694490},
                                            {-197372981, -2138394240},
                                            {-200653003, -2138088958},
                                            {-203932553, -2137778644},
                                            {-207211624, -2137463301},

                                            {-210490206, -2137142927},
                                            {-213768293, -2136817525},
                                            {-217045878, -2136487095},
                                            {-220322951, -2136151637},
                                            {-223599506, -2135811153},
                                            {-226875535, -2135465642},
                                            {-230151030, -2135115107},
                                            {-233425984, -2134759548},

                                            {-236700388, -2134398966},
                                            {-239974235, -2134033361},
                                            {-243247518, -2133662734},
                                            {-246520228, -2133287087},
                                            {-249792358, -2132906420},
                                            {-253063900, -2132520734},
                                            {-256334847, -2132130030},
                                            {-259605191, -2131734309},

                                            {-262874923, -2131333572},
                                            {-266144038, -2130927819},
                                            {-269412525, -2130517052},
                                            {-272680379, -2130101272},
                                            {-275947592, -2129680480},
                                            {-279214155, -2129254676},
                                            {-282480061, -2128823862},
                                            {-285745302, -2128388038},

                                            {-289009871, -2127947206},
                                            {-292273760, -2127501367},
                                            {-295536961, -2127050522},
                                            {-298799466, -2126594672},
                                            {-302061269, -2126133817},
                                            {-305322361, -2125667960},
                                            {-308582734, -2125197100},
                                            {-311842381, -2124721240},

                                            {-315101295, -2124240380},
                                            {-318359466, -2123754522},
                                            {-321616889, -2123263666},
                                            {-324873555, -2122767814},
                                            {-328129457, -2122266967},
                                            {-331384586, -2121761126},
                                            {-334638936, -2121250292},
                                            {-337892498, -2120734467},

                                            {-341145265, -2120213651},
                                            {-344397230, -2119687847},
                                            {-347648383, -2119157054},
                                            {-350898719, -2118621275},
                                            {-354148230, -2118080511},
                                            {-357396906, -2117534762},
                                            {-360644742, -2116984031},
                                            {-363891730, -2116428319},

                                            {-367137861, -2115867626},
                                            {-370383128, -2115301954},
                                            {-373627523, -2114731305},
                                            {-376871039, -2114155680},
                                            {-380113669, -2113575080},
                                            {-383355404, -2112989506},
                                            {-386596237, -2112398960},
                                            {-389836160, -2111803444},

                                            {-393075166, -2111202959},
                                            {-396313247, -2110597505},
                                            {-399550396, -2109987085},
                                            {-402786604, -2109371700},
                                            {-406021865, -2108751352},
                                            {-409256170, -2108126041},
                                            {-412489512, -2107495770},
                                            {-415721883, -2106860540},

                                            {-418953276, -2106220352},
                                            {-422183684, -2105575208},
                                            {-425413098, -2104925109},
                                            {-428641511, -2104270057},
                                            {-431868915, -2103610054},
                                            {-435095303, -2102945101},
                                            {-438320667, -2102275199},
                                            {-441545000, -2101600350},

                                            {-444768294, -2100920556},
                                            {-447990541, -2100235819},
                                            {-451211734, -2099546139},
                                            {-454431865, -2098851519},
                                            {-457650927, -2098151960},
                                            {-460868912, -2097447464},
                                            {-464085813, -2096738032},
                                            {-467301622, -2096023667},

                                            {-470516330, -2095304370},
                                            {-473729932, -2094580142},
                                            {-476942419, -2093850985},
                                            {-480153784, -2093116901},
                                            {-483364019, -2092377892},
                                            {-486573117, -2091633960},
                                            {-489781069, -2090885105},
                                            {-492987869, -2090131331},

                                            {-496193509, -2089372638},
                                            {-499397982, -2088609029},
                                            {-502601279, -2087840505},
                                            {-505803394, -2087067068},
                                            {-509004318, -2086288720},
                                            {-512204045, -2085505463},
                                            {-515402566, -2084717298},
                                            {-518599875, -2083924228},

                                            {-521795963, -2083126254},
                                            {-524990824, -2082323379},
                                            {-528184449, -2081515603},
                                            {-531376831, -2080702930},
                                            {-534567963, -2079885360},
                                            {-537757837, -2079062896},
                                            {-540946445, -2078235540},
                                            {-544133781, -2077403294},

                                            {-547319836, -2076566160},
                                            {-550504604, -2075724139},
                                            {-553688076, -2074877233},
                                            {-556870245, -2074025446},
                                            {-560051104, -2073168777},
                                            {-563230645, -2072307231},
                                            {-566408860, -2071440808},
                                            {-569585743, -2070569511},

                                            {-572761285, -2069693342},
                                            {-575935480, -2068812302},
                                            {-579108320, -2067926394},
                                            {-582279796, -2067035621},
                                            {-585449903, -2066139983},
                                            {-588618632, -2065239484},
                                            {-591785976, -2064334124},
                                            {-594951927, -2063423908},

                                            {-598116479, -2062508835},
                                            {-601279623, -2061588910},
                                            {-604441352, -2060664133},
                                            {-607601658, -2059734508},
                                            {-610760536, -2058800036},
                                            {-613917975, -2057860719},
                                            {-617073971, -2056916560},
                                            {-620228514, -2055967560},

                                            {-623381598, -2055013723},
                                            {-626533215, -2054055050},
                                            {-629683357, -2053091544},
                                            {-632832018, -2052123207},
                                            {-635979190, -2051150040},
                                            {-639124865, -2050172048},
                                            {-642269036, -2049189231},
                                            {-645411696, -2048201592},

                                            {-648552838, -2047209133},
                                            {-651692453, -2046211857},
                                            {-654830535, -2045209767},
                                            {-657967075, -2044202863},
                                            {-661102068, -2043191150},
                                            {-664235505, -2042174628},
                                            {-667367379, -2041153301},
                                            {-670497682, -2040127172},

                                            {-673626408, -2039096241},
                                            {-676753549, -2038060512},
                                            {-679879097, -2037019988},
                                            {-683003045, -2035974670},
                                            {-686125387, -2034924562},
                                            {-689246113, -2033869665},
                                            {-692365218, -2032809982},
                                            {-695482694, -2031745516},

                                            {-698598533, -2030676269},
                                            {-701712728, -2029602243},
                                            {-704825272, -2028523442},
                                            {-707936158, -2027439867},
                                            {-711045377, -2026351522},
                                            {-714152924, -2025258408},
                                            {-717258790, -2024160529},
                                            {-720362968, -2023057887},

                                            {-723465451, -2021950484},
                                            {-726566232, -2020838323},
                                            {-729665303, -2019721407},
                                            {-732762657, -2018599739},
                                            {-735858287, -2017473321},
                                            {-738952186, -2016342155},
                                            {-742044345, -2015206245},
                                            {-745134758, -2014065592},

                                            {-748223418, -2012920201},
                                            {-751310318, -2011770073},
                                            {-754395449, -2010615210},
                                            {-757478806, -2009455617},
                                            {-760560380, -2008291295},
                                            {-763640164, -2007122248},
                                            {-766718151, -2005948478},
                                            {-769794334, -2004769987},

                                            {-772868706, -2003586779},
                                            {-775941259, -2002398857},
                                            {-779011986, -2001206222},
                                            {-782080880, -2000008879},
                                            {-785147934, -1998806829},
                                            {-788213141, -1997600076},
                                            {-791276492, -1996388622},
                                            {-794337982, -1995172471},

                                            {-797397602, -1993951625},
                                            {-800455346, -1992726087},
                                            {-803511207, -1991495860},
                                            {-806565177, -1990260946},
                                            {-809617249, -1989021350},
                                            {-812667415, -1987777073},
                                            {-815715670, -1986528118},
                                            {-818762005, -1985274489},

                                            {-821806413, -1984016189},
                                            {-824848888, -1982753220},
                                            {-827889422, -1981485585},
                                            {-830928007, -1980213288},
                                            {-833964638, -1978936331},
                                            {-836999305, -1977654717},
                                            {-840032004, -1976368450},
                                            {-843062726, -1975077532},

                                            {-846091463, -1973781967},
                                            {-849118210, -1972481757},
                                            {-852142959, -1971176906},
                                            {-855165703, -1969867417},
                                            {-858186435, -1968553292},
                                            {-861205147, -1967234535},
                                            {-864221832, -1965911148},
                                            {-867236484, -1964583136},

                                            {-870249095, -1963250501},
                                            {-873259659, -1961913246},
                                            {-876268167, -1960571375},
                                            {-879274614, -1959224890},
                                            {-882278992, -1957873796},
                                            {-885281293, -1956518093},
                                            {-888281512, -1955157788},
                                            {-891279640, -1953792881},

                                            {-894275671, -1952423377},
                                            {-897269597, -1951049279},
                                            {-900261413, -1949670589},
                                            {-903251110, -1948287312},
                                            {-906238681, -1946899451},
                                            {-909224120, -1945507008},
                                            {-912207419, -1944109987},
                                            {-915188572, -1942708392},

                                            {-918167572, -1941302225},
                                            {-921144411, -1939891490},
                                            {-924119082, -1938476190},
                                            {-927091579, -1937056329},
                                            {-930061894, -1935631910},
                                            {-933030021, -1934202936},
                                            {-935995952, -1932769411},
                                            {-938959681, -1931331338},

                                            {-941921200, -1929888720},
                                            {-944880503, -1928441561},
                                            {-947837582, -1926989864},
                                            {-950792431, -1925533633},
                                            {-953745043, -1924072871},
                                            {-956695411, -1922607581},
                                            {-959643527, -1921137767},
                                            {-962589385, -1919663432},

                                            {-965532978, -1918184581},
                                            {-968474300, -1916701216},
                                            {-971413342, -1915213340},
                                            {-974350098, -1913720958},
                                            {-977284562, -1912224073},
                                            {-980216726, -1910722688},
                                            {-983146583, -1909216806},
                                            {-986074127, -1907706433},

                                            {-988999351, -1906191570},
                                            {-991922248, -1904672222},
                                            {-994842810, -1903148392},
                                            {-997761031, -1901620084},
                                            {-1000676905, -1900087301},
                                            {-1003590424, -1898550047},
                                            {-1006501581, -1897008325},
                                            {-1009410370, -1895462140},

                                            {-1012316784, -1893911494},
                                            {-1015220816, -1892356392},
                                            {-1018122458, -1890796837},
                                            {-1021021705, -1889232832},
                                            {-1023918550, -1887664383},
                                            {-1026812985, -1886091491},
                                            {-1029705004, -1884514161},
                                            {-1032594600, -1882932397},

                                            {-1035481766, -1881346202},
                                            {-1038366495, -1879755580},
                                            {-1041248781, -1878160535},
                                            {-1044128617, -1876561070},
                                            {-1047005996, -1874957189},
                                            {-1049880912, -1873348897},
                                            {-1052753357, -1871736196},
                                            {-1055623324, -1870119091},

                                            {-1058490808, -1868497586},
                                            {-1061355801, -1866871683},
                                            {-1064218296, -1865241388},
                                            {-1067078288, -1863606704},
                                            {-1069935768, -1861967634},
                                            {-1072790730, -1860324183},
                                            {-1075643169, -1858676355},
                                            {-1078493076, -1857024153},

                                            {-1081340445, -1855367581},
                                            {-1084185270, -1853706643},
                                            {-1087027544, -1852041343},
                                            {-1089867259, -1850371686},
                                            {-1092704411, -1848697674},
                                            {-1095538991, -1847019312},
                                            {-1098370993, -1845336604},
                                            {-1101200410, -1843649553},

                                            {-1104027237, -1841958164},
                                            {-1106851465, -1840262441},
                                            {-1109673089, -1838562388},
                                            {-1112492101, -1836858008},
                                            {-1115308496, -1835149306},
                                            {-1118122267, -1833436286},
                                            {-1120933406, -1831718951},
                                            {-1123741908, -1829997307},

                                            {-1126547765, -1828271356},
                                            {-1129350972, -1826541103},
                                            {-1132151521, -1824806552},
                                            {-1134949406, -1823067707},
                                            {-1137744621, -1821324572},
                                            {-1140537158, -1819577151},
                                            {-1143327011, -1817825449},
                                            {-1146114174, -1816069469},

                                            {-1148898640, -1814309216},
                                            {-1151680403, -1812544694},
                                            {-1154459456, -1810775906},
                                            {-1157235792, -1809002858},
                                            {-1160009405, -1807225553},
                                            {-1162780288, -1805443995},
                                            {-1165548435, -1803658189},
                                            {-1168313840, -1801868139},

                                            {-1171076495, -1800073849},
                                            {-1173836395, -1798275323},
                                            {-1176593533, -1796472565},
                                            {-1179347902, -1794665580},
                                            {-1182099496, -1792854372},
                                            {-1184848308, -1791038946},
                                            {-1187594332, -1789219305},
                                            {-1190337562, -1787395453},

                                            {-1193077991, -1785567396},
                                            {-1195815612, -1783735137},
                                            {-1198550419, -1781898681},
                                            {-1201282407, -1780058032},
                                            {-1204011567, -1778213194},
                                            {-1206737894, -1776364172},
                                            {-1209461382, -1774510970},
                                            {-1212182024, -1772653593},

                                            {-1214899813, -1770792044},
                                            {-1217614743, -1768926328},
                                            {-1220326809, -1767056450},
                                            {-1223036002, -1765182414},
                                            {-1225742318, -1763304224},
                                            {-1228445750, -1761421885},
                                            {-1231146291, -1759535401},
                                            {-1233843935, -1757644777},

                                            {-1236538675, -1755750017},
                                            {-1239230506, -1753851126},
                                            {-1241919421, -1751948107},
                                            {-1244605414, -1750040966},
                                            {-1247288478, -1748129707},
                                            {-1249968606, -1746214334},
                                            {-1252645794, -1744294853},
                                            {-1255320034, -1742371267},

                                            {-1257991320, -1740443581},
                                            {-1260659646, -1738511799},
                                            {-1263325005, -1736575927},
                                            {-1265987392, -1734635968},
                                            {-1268646800, -1732691928},
                                            {-1271303222, -1730743810},
                                            {-1273956653, -1728791620},
                                            {-1276607086, -1726835361},

                                            {-1279254516, -1724875040},
                                            {-1281898935, -1722910659},
                                            {-1284540337, -1720942225},
                                            {-1287178717, -1718969740},
                                            {-1289814068, -1716993211},
                                            {-1292446384, -1715012642},
                                            {-1295075659, -1713028037},
                                            {-1297701886, -1711039401},

                                            {-1300325060, -1709046739},
                                            {-1302945174, -1707050055},
                                            {-1305562222, -1705049355},
                                            {-1308176198, -1703044642},
                                            {-1310787095, -1701035922},
                                            {-1313394909, -1699023199},
                                            {-1315999631, -1697006479},
                                            {-1318601257, -1694985765},

                                            {-1321199781, -1692961062},
                                            {-1323795195, -1690932376},
                                            {-1326387494, -1688899711},
                                            {-1328976672, -1686863072},
                                            {-1331562723, -1684822463},
                                            {-1334145641, -1682777890},
                                            {-1336725419, -1680729357},
                                            {-1339302052, -1678676870},

                                            {-1341875533, -1676620432},
                                            {-1344445857, -1674560049},
                                            {-1347013017, -1672495725},
                                            {-1349577007, -1670427466},
                                            {-1352137822, -1668355276},
                                            {-1354695455, -1666279161},
                                            {-1357249901, -1664199124},
                                            {-1359801152, -1662115172},

                                            {-1362349204, -1660027308},
                                            {-1364894050, -1657935539},
                                            {-1367435685, -1655839867},
                                            {-1369974101, -1653740300},
                                            {-1372509294, -1651636841},
                                            {-1375041258, -1649529496},
                                            {-1377569986, -1647418269},
                                            {-1380095472, -1645303166},

                                            {-1382617710, -1643184191},
                                            {-1385136696, -1641061349},
                                            {-1387652422, -1638934646},
                                            {-1390164882, -1636804087},
                                            {-1392674072, -1634669676},
                                            {-1395179984, -1632531418},
                                            {-1397682613, -1630389319},
                                            {-1400181954, -1628243383},

                                            {-1402678000, -1626093616},
                                            {-1405170745, -1623940023},
                                            {-1407660183, -1621782608},
                                            {-1410146309, -1619621377},
                                            {-1412629117, -1617456335},
                                            {-1415108601, -1615287487},
                                            {-1417584755, -1613114838},
                                            {-1420057574, -1610938393},

                                            {-1422527051, -1608758157},
                                            {-1424993180, -1606574136},
                                            {-1427455956, -1604386335},
                                            {-1429915374, -1602194758},
                                            {-1432371426, -1599999411},
                                            {-1434824109, -1597800299},
                                            {-1437273414, -1595597428},
                                            {-1439719338, -1593390801},

                                            {-1442161874, -1591180426},
                                            {-1444601017, -1588966306},
                                            {-1447036760, -1586748447},
                                            {-1449469098, -1584526854},
                                            {-1451898025, -1582301533},
                                            {-1454323536, -1580072489},
                                            {-1456745625, -1577839726},
                                            {-1459164286, -1575603251},

                                            {-1461579514, -1573363068},
                                            {-1463991302, -1571119183},
                                            {-1466399645, -1568871601},
                                            {-1468804538, -1566620327},
                                            {-1471205974, -1564365367},
                                            {-1473603949, -1562106725},
                                            {-1475998456, -1559844408},
                                            {-1478389489, -1557578421},

                                            {-1480777044, -1555308768},
                                            {-1483161115, -1553035455},
                                            {-1485541696, -1550758488},
                                            {-1487918781, -1548477872},
                                            {-1490292364, -1546193612},
                                            {-1492662441, -1543905714},
                                            {-1495029006, -1541614183},
                                            {-1497392053, -1539319024},

                                            {-1499751576, -1537020244},
                                            {-1502107570, -1534717846},
                                            {-1504460029, -1532411837},
                                            {-1506808949, -1530102222},
                                            {-1509154322, -1527789007},
                                            {-1511496145, -1525472197},
                                            {-1513834411, -1523151797},
                                            {-1516169114, -1520827813},

                                            {-1518500250, -1518500250},
                                            {-1520827813, -1516169114},
                                            {-1523151797, -1513834411},
                                            {-1525472197, -1511496145},
                                            {-1527789007, -1509154322},
                                            {-1530102222, -1506808949},
                                            {-1532411837, -1504460029},
                                            {-1534717846, -1502107570},

                                            {-1537020244, -1499751576},
                                            {-1539319024, -1497392053},
                                            {-1541614183, -1495029006},
                                            {-1543905714, -1492662441},
                                            {-1546193612, -1490292364},
                                            {-1548477872, -1487918781},
                                            {-1550758488, -1485541696},
                                            {-1553035455, -1483161115},

                                            {-1555308768, -1480777044},
                                            {-1557578421, -1478389489},
                                            {-1559844408, -1475998456},
                                            {-1562106725, -1473603949},
                                            {-1564365367, -1471205974},
                                            {-1566620327, -1468804538},
                                            {-1568871601, -1466399645},
                                            {-1571119183, -1463991302},

                                            {-1573363068, -1461579514},
                                            {-1575603251, -1459164286},
                                            {-1577839726, -1456745625},
                                            {-1580072489, -1454323536},
                                            {-1582301533, -1451898025},
                                            {-1584526854, -1449469098},
                                            {-1586748447, -1447036760},
                                            {-1588966306, -1444601017},

                                            {-1591180426, -1442161874},
                                            {-1593390801, -1439719338},
                                            {-1595597428, -1437273414},
                                            {-1597800299, -1434824109},
                                            {-1599999411, -1432371426},
                                            {-1602194758, -1429915374},
                                            {-1604386335, -1427455956},
                                            {-1606574136, -1424993180},

                                            {-1608758157, -1422527051},
                                            {-1610938393, -1420057574},
                                            {-1613114838, -1417584755},
                                            {-1615287487, -1415108601},
                                            {-1617456335, -1412629117},
                                            {-1619621377, -1410146309},
                                            {-1621782608, -1407660183},
                                            {-1623940023, -1405170745},

                                            {-1626093616, -1402678000},
                                            {-1628243383, -1400181954},
                                            {-1630389319, -1397682613},
                                            {-1632531418, -1395179984},
                                            {-1634669676, -1392674072},
                                            {-1636804087, -1390164882},
                                            {-1638934646, -1387652422},
                                            {-1641061349, -1385136696},

                                            {-1643184191, -1382617710},
                                            {-1645303166, -1380095472},
                                            {-1647418269, -1377569986},
                                            {-1649529496, -1375041258},
                                            {-1651636841, -1372509294},
                                            {-1653740300, -1369974101},
                                            {-1655839867, -1367435685},
                                            {-1657935539, -1364894050},

                                            {-1660027308, -1362349204},
                                            {-1662115172, -1359801152},
                                            {-1664199124, -1357249901},
                                            {-1666279161, -1354695455},
                                            {-1668355276, -1352137822},
                                            {-1670427466, -1349577007},
                                            {-1672495725, -1347013017},
                                            {-1674560049, -1344445857},

                                            {-1676620432, -1341875533},
                                            {-1678676870, -1339302052},
                                            {-1680729357, -1336725419},
                                            {-1682777890, -1334145641},
                                            {-1684822463, -1331562723},
                                            {-1686863072, -1328976672},
                                            {-1688899711, -1326387494},
                                            {-1690932376, -1323795195},

                                            {-1692961062, -1321199781},
                                            {-1694985765, -1318601257},
                                            {-1697006479, -1315999631},
                                            {-1699023199, -1313394909},
                                            {-1701035922, -1310787095},
                                            {-1703044642, -1308176198},
                                            {-1705049355, -1305562222},
                                            {-1707050055, -1302945174},

                                            {-1709046739, -1300325060},
                                            {-1711039401, -1297701886},
                                            {-1713028037, -1295075659},
                                            {-1715012642, -1292446384},
                                            {-1716993211, -1289814068},
                                            {-1718969740, -1287178717},
                                            {-1720942225, -1284540337},
                                            {-1722910659, -1281898935},

                                            {-1724875040, -1279254516},
                                            {-1726835361, -1276607086},
                                            {-1728791620, -1273956653},
                                            {-1730743810, -1271303222},
                                            {-1732691928, -1268646800},
                                            {-1734635968, -1265987392},
                                            {-1736575927, -1263325005},
                                            {-1738511799, -1260659646},

                                            {-1740443581, -1257991320},
                                            {-1742371267, -1255320034},
                                            {-1744294853, -1252645794},
                                            {-1746214334, -1249968606},
                                            {-1748129707, -1247288478},
                                            {-1750040966, -1244605414},
                                            {-1751948107, -1241919421},
                                            {-1753851126, -1239230506},

                                            {-1755750017, -1236538675},
                                            {-1757644777, -1233843935},
                                            {-1759535401, -1231146291},
                                            {-1761421885, -1228445750},
                                            {-1763304224, -1225742318},
                                            {-1765182414, -1223036002},
                                            {-1767056450, -1220326809},
                                            {-1768926328, -1217614743},

                                            {-1770792044, -1214899813},
                                            {-1772653593, -1212182024},
                                            {-1774510970, -1209461382},
                                            {-1776364172, -1206737894},
                                            {-1778213194, -1204011567},
                                            {-1780058032, -1201282407},
                                            {-1781898681, -1198550419},
                                            {-1783735137, -1195815612},

                                            {-1785567396, -1193077991},
                                            {-1787395453, -1190337562},
                                            {-1789219305, -1187594332},
                                            {-1791038946, -1184848308},
                                            {-1792854372, -1182099496},
                                            {-1794665580, -1179347902},
                                            {-1796472565, -1176593533},
                                            {-1798275323, -1173836395},

                                            {-1800073849, -1171076495},
                                            {-1801868139, -1168313840},
                                            {-1803658189, -1165548435},
                                            {-1805443995, -1162780288},
                                            {-1807225553, -1160009405},
                                            {-1809002858, -1157235792},
                                            {-1810775906, -1154459456},
                                            {-1812544694, -1151680403},

                                            {-1814309216, -1148898640},
                                            {-1816069469, -1146114174},
                                            {-1817825449, -1143327011},
                                            {-1819577151, -1140537158},
                                            {-1821324572, -1137744621},
                                            {-1823067707, -1134949406},
                                            {-1824806552, -1132151521},
                                            {-1826541103, -1129350972},

                                            {-1828271356, -1126547765},
                                            {-1829997307, -1123741908},
                                            {-1831718951, -1120933406},
                                            {-1833436286, -1118122267},
                                            {-1835149306, -1115308496},
                                            {-1836858008, -1112492101},
                                            {-1838562388, -1109673089},
                                            {-1840262441, -1106851465},

                                            {-1841958164, -1104027237},
                                            {-1843649553, -1101200410},
                                            {-1845336604, -1098370993},
                                            {-1847019312, -1095538991},
                                            {-1848697674, -1092704411},
                                            {-1850371686, -1089867259},
                                            {-1852041343, -1087027544},
                                            {-1853706643, -1084185270},

                                            {-1855367581, -1081340445},
                                            {-1857024153, -1078493076},
                                            {-1858676355, -1075643169},
                                            {-1860324183, -1072790730},
                                            {-1861967634, -1069935768},
                                            {-1863606704, -1067078288},
                                            {-1865241388, -1064218296},
                                            {-1866871683, -1061355801},

                                            {-1868497586, -1058490808},
                                            {-1870119091, -1055623324},
                                            {-1871736196, -1052753357},
                                            {-1873348897, -1049880912},
                                            {-1874957189, -1047005996},
                                            {-1876561070, -1044128617},
                                            {-1878160535, -1041248781},
                                            {-1879755580, -1038366495},

                                            {-1881346202, -1035481766},
                                            {-1882932397, -1032594600},
                                            {-1884514161, -1029705004},
                                            {-1886091491, -1026812985},
                                            {-1887664383, -1023918550},
                                            {-1889232832, -1021021705},
                                            {-1890796837, -1018122458},
                                            {-1892356392, -1015220816},

                                            {-1893911494, -1012316784},
                                            {-1895462140, -1009410370},
                                            {-1897008325, -1006501581},
                                            {-1898550047, -1003590424},
                                            {-1900087301, -1000676905},
                                            {-1901620084, -997761031},
                                            {-1903148392, -994842810},
                                            {-1904672222, -991922248},

                                            {-1906191570, -988999351},
                                            {-1907706433, -986074127},
                                            {-1909216806, -983146583},
                                            {-1910722688, -980216726},
                                            {-1912224073, -977284562},
                                            {-1913720958, -974350098},
                                            {-1915213340, -971413342},
                                            {-1916701216, -968474300},

                                            {-1918184581, -965532978},
                                            {-1919663432, -962589385},
                                            {-1921137767, -959643527},
                                            {-1922607581, -956695411},
                                            {-1924072871, -953745043},
                                            {-1925533633, -950792431},
                                            {-1926989864, -947837582},
                                            {-1928441561, -944880503},

                                            {-1929888720, -941921200},
                                            {-1931331338, -938959681},
                                            {-1932769411, -935995952},
                                            {-1934202936, -933030021},
                                            {-1935631910, -930061894},
                                            {-1937056329, -927091579},
                                            {-1938476190, -924119082},
                                            {-1939891490, -921144411},

                                            {-1941302225, -918167572},
                                            {-1942708392, -915188572},
                                            {-1944109987, -912207419},
                                            {-1945507008, -909224120},
                                            {-1946899451, -906238681},
                                            {-1948287312, -903251110},
                                            {-1949670589, -900261413},
                                            {-1951049279, -897269597},

                                            {-1952423377, -894275671},
                                            {-1953792881, -891279640},
                                            {-1955157788, -888281512},
                                            {-1956518093, -885281293},
                                            {-1957873796, -882278992},
                                            {-1959224890, -879274614},
                                            {-1960571375, -876268167},
                                            {-1961913246, -873259659},

                                            {-1963250501, -870249095},
                                            {-1964583136, -867236484},
                                            {-1965911148, -864221832},
                                            {-1967234535, -861205147},
                                            {-1968553292, -858186435},
                                            {-1969867417, -855165703},
                                            {-1971176906, -852142959},
                                            {-1972481757, -849118210},

                                            {-1973781967, -846091463},
                                            {-1975077532, -843062726},
                                            {-1976368450, -840032004},
                                            {-1977654717, -836999305},
                                            {-1978936331, -833964638},
                                            {-1980213288, -830928007},
                                            {-1981485585, -827889422},
                                            {-1982753220, -824848888},

                                            {-1984016189, -821806413},
                                            {-1985274489, -818762005},
                                            {-1986528118, -815715670},
                                            {-1987777073, -812667415},
                                            {-1989021350, -809617249},
                                            {-1990260946, -806565177},
                                            {-1991495860, -803511207},
                                            {-1992726087, -800455346},

                                            {-1993951625, -797397602},
                                            {-1995172471, -794337982},
                                            {-1996388622, -791276492},
                                            {-1997600076, -788213141},
                                            {-1998806829, -785147934},
                                            {-2000008879, -782080880},
                                            {-2001206222, -779011986},
                                            {-2002398857, -775941259},

                                            {-2003586779, -772868706},
                                            {-2004769987, -769794334},
                                            {-2005948478, -766718151},
                                            {-2007122248, -763640164},
                                            {-2008291295, -760560380},
                                            {-2009455617, -757478806},
                                            {-2010615210, -754395449},
                                            {-2011770073, -751310318},

                                            {-2012920201, -748223418},
                                            {-2014065592, -745134758},
                                            {-2015206245, -742044345},
                                            {-2016342155, -738952186},
                                            {-2017473321, -735858287},
                                            {-2018599739, -732762657},
                                            {-2019721407, -729665303},
                                            {-2020838323, -726566232},

                                            {-2021950484, -723465451},
                                            {-2023057887, -720362968},
                                            {-2024160529, -717258790},
                                            {-2025258408, -714152924},
                                            {-2026351522, -711045377},
                                            {-2027439867, -707936158},
                                            {-2028523442, -704825272},
                                            {-2029602243, -701712728},

                                            {-2030676269, -698598533},
                                            {-2031745516, -695482694},
                                            {-2032809982, -692365218},
                                            {-2033869665, -689246113},
                                            {-2034924562, -686125387},
                                            {-2035974670, -683003045},
                                            {-2037019988, -679879097},
                                            {-2038060512, -676753549},

                                            {-2039096241, -673626408},
                                            {-2040127172, -670497682},
                                            {-2041153301, -667367379},
                                            {-2042174628, -664235505},
                                            {-2043191150, -661102068},
                                            {-2044202863, -657967075},
                                            {-2045209767, -654830535},
                                            {-2046211857, -651692453},

                                            {-2047209133, -648552838},
                                            {-2048201592, -645411696},
                                            {-2049189231, -642269036},
                                            {-2050172048, -639124865},
                                            {-2051150040, -635979190},
                                            {-2052123207, -632832018},
                                            {-2053091544, -629683357},
                                            {-2054055050, -626533215},

                                            {-2055013723, -623381598},
                                            {-2055967560, -620228514},
                                            {-2056916560, -617073971},
                                            {-2057860719, -613917975},
                                            {-2058800036, -610760536},
                                            {-2059734508, -607601658},
                                            {-2060664133, -604441352},
                                            {-2061588910, -601279623},

                                            {-2062508835, -598116479},
                                            {-2063423908, -594951927},
                                            {-2064334124, -591785976},
                                            {-2065239484, -588618632},
                                            {-2066139983, -585449903},
                                            {-2067035621, -582279796},
                                            {-2067926394, -579108320},
                                            {-2068812302, -575935480},

                                            {-2069693342, -572761285},
                                            {-2070569511, -569585743},
                                            {-2071440808, -566408860},
                                            {-2072307231, -563230645},
                                            {-2073168777, -560051104},
                                            {-2074025446, -556870245},
                                            {-2074877233, -553688076},
                                            {-2075724139, -550504604},

                                            {-2076566160, -547319836},
                                            {-2077403294, -544133781},
                                            {-2078235540, -540946445},
                                            {-2079062896, -537757837},
                                            {-2079885360, -534567963},
                                            {-2080702930, -531376831},
                                            {-2081515603, -528184449},
                                            {-2082323379, -524990824},

                                            {-2083126254, -521795963},
                                            {-2083924228, -518599875},
                                            {-2084717298, -515402566},
                                            {-2085505463, -512204045},
                                            {-2086288720, -509004318},
                                            {-2087067068, -505803394},
                                            {-2087840505, -502601279},
                                            {-2088609029, -499397982},

                                            {-2089372638, -496193509},
                                            {-2090131331, -492987869},
                                            {-2090885105, -489781069},
                                            {-2091633960, -486573117},
                                            {-2092377892, -483364019},
                                            {-2093116901, -480153784},
                                            {-2093850985, -476942419},
                                            {-2094580142, -473729932},

                                            {-2095304370, -470516330},
                                            {-2096023667, -467301622},
                                            {-2096738032, -464085813},
                                            {-2097447464, -460868912},
                                            {-2098151960, -457650927},
                                            {-2098851519, -454431865},
                                            {-2099546139, -451211734},
                                            {-2100235819, -447990541},

                                            {-2100920556, -444768294},
                                            {-2101600350, -441545000},
                                            {-2102275199, -438320667},
                                            {-2102945101, -435095303},
                                            {-2103610054, -431868915},
                                            {-2104270057, -428641511},
                                            {-2104925109, -425413098},
                                            {-2105575208, -422183684},

                                            {-2106220352, -418953276},
                                            {-2106860540, -415721883},
                                            {-2107495770, -412489512},
                                            {-2108126041, -409256170},
                                            {-2108751352, -406021865},
                                            {-2109371700, -402786604},
                                            {-2109987085, -399550396},
                                            {-2110597505, -396313247},

                                            {-2111202959, -393075166},
                                            {-2111803444, -389836160},
                                            {-2112398960, -386596237},
                                            {-2112989506, -383355404},
                                            {-2113575080, -380113669},
                                            {-2114155680, -376871039},
                                            {-2114731305, -373627523},
                                            {-2115301954, -370383128},

                                            {-2115867626, -367137861},
                                            {-2116428319, -363891730},
                                            {-2116984031, -360644742},
                                            {-2117534762, -357396906},
                                            {-2118080511, -354148230},
                                            {-2118621275, -350898719},
                                            {-2119157054, -347648383},
                                            {-2119687847, -344397230},

                                            {-2120213651, -341145265},
                                            {-2120734467, -337892498},
                                            {-2121250292, -334638936},
                                            {-2121761126, -331384586},
                                            {-2122266967, -328129457},
                                            {-2122767814, -324873555},
                                            {-2123263666, -321616889},
                                            {-2123754522, -318359466},

                                            {-2124240380, -315101295},
                                            {-2124721240, -311842381},
                                            {-2125197100, -308582734},
                                            {-2125667960, -305322361},
                                            {-2126133817, -302061269},
                                            {-2126594672, -298799466},
                                            {-2127050522, -295536961},
                                            {-2127501367, -292273760},

                                            {-2127947206, -289009871},
                                            {-2128388038, -285745302},
                                            {-2128823862, -282480061},
                                            {-2129254676, -279214155},
                                            {-2129680480, -275947592},
                                            {-2130101272, -272680379},
                                            {-2130517052, -269412525},
                                            {-2130927819, -266144038},

                                            {-2131333572, -262874923},
                                            {-2131734309, -259605191},
                                            {-2132130030, -256334847},
                                            {-2132520734, -253063900},
                                            {-2132906420, -249792358},
                                            {-2133287087, -246520228},
                                            {-2133662734, -243247518},
                                            {-2134033361, -239974235},

                                            {-2134398966, -236700388},
                                            {-2134759548, -233425984},
                                            {-2135115107, -230151030},
                                            {-2135465642, -226875535},
                                            {-2135811153, -223599506},
                                            {-2136151637, -220322951},
                                            {-2136487095, -217045878},
                                            {-2136817525, -213768293},

                                            {-2137142927, -210490206},
                                            {-2137463301, -207211624},
                                            {-2137778644, -203932553},
                                            {-2138088958, -200653003},
                                            {-2138394240, -197372981},
                                            {-2138694490, -194092495},
                                            {-2138989708, -190811551},
                                            {-2139279892, -187530159},

                                            {-2139565043, -184248325},
                                            {-2139845159, -180966058},
                                            {-2140120240, -177683365},
                                            {-2140390284, -174400254},
                                            {-2140655293, -171116733},
                                            {-2140915264, -167832808},
                                            {-2141170197, -164548489},
                                            {-2141420092, -161263783},

                                            {-2141664948, -157978697},
                                            {-2141904764, -154693240},
                                            {-2142139541, -151407418},
                                            {-2142369276, -148121241},
                                            {-2142593971, -144834714},
                                            {-2142813624, -141547847},
                                            {-2143028234, -138260647},
                                            {-2143237802, -134973122},

                                            {-2143442326, -131685278},
                                            {-2143641807, -128397125},
                                            {-2143836244, -125108670},
                                            {-2144025635, -121819921},
                                            {-2144209982, -118530885},
                                            {-2144389283, -115241570},
                                            {-2144563539, -111951983},
                                            {-2144732748, -108662134},

                                            {-2144896910, -105372028},
                                            {-2145056025, -102081675},
                                            {-2145210092, -98791081},
                                            {-2145359112, -95500255},
                                            {-2145503083, -92209205},
                                            {-2145642006, -88917937},
                                            {-2145775880, -85626460},
                                            {-2145904705, -82334782},

                                            {-2146028480, -79042909},
                                            {-2146147205, -75750851},
                                            {-2146260881, -72458615},
                                            {-2146369505, -69166208},
                                            {-2146473080, -65873638},
                                            {-2146571603, -62580914},
                                            {-2146665076, -59288042},
                                            {-2146753497, -55995030},

                                            {-2146836866, -52701887},
                                            {-2146915184, -49408620},
                                            {-2146988450, -46115236},
                                            {-2147056664, -42821744},
                                            {-2147119825, -39528151},
                                            {-2147177934, -36234466},
                                            {-2147230991, -32940695},
                                            {-2147278995, -29646846},

                                            {-2147321946, -26352928},
                                            {-2147359845, -23058947},
                                            {-2147392690, -19764913},
                                            {-2147420483, -16470832},
                                            {-2147443222, -13176712},
                                            {-2147460908, -9882561},
                                            {-2147473542, -6588387},
                                            {-2147481121, -3294197}

};

const cint32 twiddle_master_cint31[2048] = {
    {1073741824, 0},           {1073740561, -1647099},    {1073736771, -3294193},
    {1073730454, -4941281},    {1073721611, -6588356},    {1073710241, -8235416},
    {1073696345, -9882456},    {1073679922, -11529474},

    {1073660973, -13176464},   {1073639498, -14823423},   {1073615496, -16470347},
    {1073588967, -18117233},   {1073559913, -19764076},   {1073528332, -21410872},
    {1073494225, -23057618},   {1073457592, -24704310},

    {1073418433, -26350943},   {1073376748, -27997515},   {1073332538, -29644021},
    {1073285802, -31290457},   {1073236540, -32936819},   {1073184753, -34583104},
    {1073130440, -36229307},   {1073073603, -37875426},

    {1073014240, -39521455},   {1072952352, -41167391},   {1072887940, -42813230},
    {1072821003, -44458968},   {1072751542, -46104602},   {1072679556, -47750128},
    {1072605046, -49395541},   {1072528012, -51040837},

    {1072448455, -52686014},   {1072366374, -54331067},   {1072281769, -55975992},
    {1072194642, -57620785},   {1072104991, -59265442},   {1072012818, -60909960},
    {1071918122, -62554335},   {1071820903, -64198563},

    {1071721163, -65842639},   {1071618901, -67486561},   {1071514117, -69130324},
    {1071406812, -70773924},   {1071296985, -72417357},   {1071184638, -74060620},
    {1071069770, -75703709},   {1070952382, -77346620},

    {1070832474, -78989349},   {1070710046, -80631892},   {1070585099, -82274245},
    {1070457632, -83916404},   {1070327646, -85558366},   {1070195142, -87200127},
    {1070060120, -88841683},   {1069922579, -90483029},

    {1069782521, -92124163},   {1069639946, -93765079},   {1069494854, -95405776},
    {1069347245, -97046247},   {1069197120, -98686491},   {1069044479, -100326502},
    {1068889322, -101966277},  {1068731650, -103605812},

    {1068571464, -105245103},  {1068408763, -106884147},  {1068243547, -108522939},
    {1068075818, -110161476},  {1067905576, -111799753},  {1067732821, -113437768},
    {1067557554, -115075515},  {1067379774, -116712992},

    {1067199483, -118350194},  {1067016680, -119987118},  {1066831367, -121623759},
    {1066643544, -123260114},  {1066453210, -124896179},  {1066260367, -126531950},
    {1066065015, -128167423},  {1065867154, -129802595},

    {1065666786, -131437462},  {1065463909, -133072019},  {1065258526, -134706263},
    {1065050636, -136340190},  {1064840240, -137973796},  {1064627338, -139607077},
    {1064411931, -141240030},  {1064194019, -142872651},

    {1063973603, -144504935},  {1063750684, -146136880},  {1063525261, -147768480},
    {1063297336, -149399733},  {1063066909, -151030634},  {1062833980, -152661180},
    {1062598550, -154291367},  {1062360620, -155921191},

    {1062120190, -157550647},  {1061877261, -159179733},  {1061631833, -160808445},
    {1061383907, -162436778},  {1061133483, -164064728},  {1060880563, -165692293},
    {1060625146, -167319468},  {1060367233, -168946249},

    {1060106826, -170572633},  {1059843923, -172198615},  {1059578527, -173824192},
    {1059310638, -175449360},  {1059040255, -177074115},  {1058767381, -178698453},
    {1058492016, -180322371},  {1058214159, -181945865},

    {1057933813, -183568930},  {1057650977, -185191564},  {1057365653, -186813762},
    {1057077840, -188435520},  {1056787540, -190056834},  {1056494753, -191677702},
    {1056199480, -193298119},  {1055901722, -194918080},

    {1055601479, -196537583},  {1055298753, -198156624},  {1054993543, -199775198},
    {1054685850, -201393302},  {1054375676, -203010932},  {1054063021, -204628085},
    {1053747885, -206244756},  {1053430270, -207860942},

    {1053110176, -209476638},  {1052787604, -211091842},  {1052462555, -212706549},
    {1052135029, -214320755},  {1051805027, -215934457},  {1051472550, -217547651},
    {1051137599, -219160334},  {1050800175, -220772500},

    {1050460278, -222384147},  {1050117909, -223995270},  {1049773069, -225605867},
    {1049425759, -227215933},  {1049075980, -228825464},  {1048723732, -230434456},
    {1048369016, -232042906},  {1048011834, -233650811},

    {1047652185, -235258165},  {1047290071, -236864966},  {1046925492, -238471210},
    {1046558451, -240076892},  {1046188946, -241682010},  {1045816980, -243286558},
    {1045442553, -244890535},  {1045065665, -246493935},

    {1044686319, -248096755},  {1044304514, -249698991},  {1043920252, -251300640},
    {1043533534, -252901697},  {1043144360, -254502159},  {1042752731, -256102022},
    {1042358649, -257701283},  {1041962114, -259299937},

    {1041563127, -260897982},  {1041161689, -262495412},  {1040757802, -264092224},
    {1040351465, -265688415},  {1039942680, -267283981},  {1039531448, -268878918},
    {1039117770, -270473223},  {1038701647, -272066891},

    {1038283080, -273659918},  {1037862069, -275252302},  {1037438617, -276844038},
    {1037012723, -278435122},  {1036584389, -280025552},  {1036153615, -281615322},
    {1035720404, -283204430},  {1035284755, -284792871},

    {1034846671, -286380643},  {1034406151, -287967740},  {1033963197, -289554160},
    {1033517810, -291139898},  {1033069992, -292724951},  {1032619742, -294309316},
    {1032167062, -295892988},  {1031711954, -297475964},

    {1031254418, -299058239},  {1030794455, -300639811},  {1030332067, -302220676},
    {1029867254, -303800829},  {1029400018, -305380268},  {1028930359, -306958988},
    {1028458280, -308536985},  {1027983780, -310114257},

    {1027506862, -311690799},  {1027027525, -313266607},  {1026545772, -314841679},
    {1026061603, -316416009},  {1025575020, -317989595},  {1025086024, -319562433},
    {1024594615, -321134518},  {1024100796, -322705848},

    {1023604567, -324276419},  {1023105929, -325846226},  {1022604883, -327415267},
    {1022101432, -328983538},  {1021595575, -330551034},  {1021087314, -332117752},
    {1020576651, -333683689},  {1020063586, -335248841},

    {1019548121, -336813204},  {1019030256, -338376774},  {1018509994, -339939549},
    {1017987335, -341501523},  {1017462281, -343062693},  {1016934832, -344623057},
    {1016404991, -346182609},  {1015872758, -347741347},

    {1015338134, -349299266},  {1014801122, -350856364},  {1014261721, -352412636},
    {1013719934, -353968079},  {1013175761, -355522689},  {1012629204, -357076462},
    {1012080264, -358629395},  {1011528943, -360181484},

    {1010975242, -361732726},  {1010419162, -363283116},  {1009860704, -364832652},
    {1009299870, -366381329},  {1008736660, -367929144},  {1008171077, -369476093},
    {1007603122, -371022173},  {1007032796, -372567379},

    {1006460100, -374111709},  {1005885036, -375655159},  {1005307605, -377197725},
    {1004727809, -378739403},  {1004145648, -380280190},  {1003561124, -381820082},
    {1002974239, -383359076},  {1002384994, -384897167},

    {1001793390, -386434353},  {1001199428, -387970630},  {1000603111, -389505993},
    {1000004439, -391040440},  {999403415, -392573967},   {998800038, -394106570},
    {998194311, -395638246},   {997586236, -397168991},

    {996975812, -398698801},   {996363043, -400227673},   {995747930, -401755603},
    {995130473, -403282588},   {994510675, -404808624},   {993888536, -406333708},
    {993264059, -407857835},   {992637245, -409381002},

    {992008094, -410903207},   {991376610, -412424444},   {990742793, -413944711},
    {990106644, -415464004},   {989468165, -416982319},   {988827359, -418499653},
    {988184225, -420016002},   {987538766, -421531363},

    {986890984, -423045732},   {986240879, -424559105},   {985588453, -426071480},
    {984933708, -427582852},   {984276646, -429093217},   {983617267, -430602573},
    {982955574, -432110916},   {982291568, -433618242},

    {981625251, -435124548},   {980956623, -436629829},   {980285688, -438134084},
    {979612445, -439637307},   {978936898, -441139496},   {978259047, -442640647},
    {977578894, -444140756},   {976896441, -445639820},

    {976211688, -447137835},   {975524639, -448634799},   {974835295, -450130706},
    {974143656, -451625555},   {973449725, -453119340},   {972753504, -454612060},
    {972054994, -456103710},   {971354196, -457594286},

    {970651112, -459083786},   {969945745, -460572205},   {969238095, -462059541},
    {968528165, -463545789},   {967815955, -465030947},   {967101468, -466515010},
    {966384706, -467997976},   {965665669, -469479840},

    {964944360, -470960600},   {964220780, -472440251},   {963494932, -473918791},
    {962766816, -475396216},   {962036435, -476872522},   {961303790, -478347705},
    {960568883, -479821764},   {959831716, -481294693},

    {959092290, -482766489},   {958350608, -484237150},   {957606670, -485706671},
    {956860479, -487175049},   {956112036, -488642281},   {955361344, -490108363},
    {954608403, -491573292},   {953853216, -493037064},

    {953095785, -494499676},   {952336111, -495961124},   {951574196, -497421405},
    {950810042, -498880516},   {950043650, -500338453},   {949275023, -501795212},
    {948504163, -503250791},   {947731070, -504705185},

    {946955747, -506158392},   {946178196, -507610408},   {945398418, -509061229},
    {944616416, -510510853},   {943832191, -511959275},   {943045745, -513406493},
    {942257081, -514852502},   {941466198, -516297300},

    {940673101, -517740883},   {939877790, -519183248},   {939080267, -520624391},
    {938280535, -522064309},   {937478595, -523502998},   {936674448, -524940456},
    {935868098, -526376678},   {935059546, -527811662},

    {934248793, -529245404},   {933435842, -530677900},   {932620694, -532109148},
    {931803352, -533539144},   {930983817, -534967884},   {930162092, -536395365},
    {929338177, -537821584},   {928512076, -539246538},

    {927683790, -540670223},   {926853322, -542092635},   {926020672, -543513772},
    {925185843, -544933630},   {924348837, -546352205},   {923509656, -547769495},
    {922668302, -549185496},   {921824777, -550600205},

    {920979082, -552013618},   {920131221, -553425732},   {919281194, -554836544},
    {918429004, -556246051},   {917574653, -557654248},   {916718143, -559061133},
    {915859476, -560466703},   {914998653, -561870954},

    {914135678, -563273883},   {913270551, -564675486},   {912403276, -566075761},
    {911533853, -567474703},   {910662286, -568872310},   {909788576, -570268579},
    {908912725, -571663506},   {908034735, -573057087},

    {907154608, -574449320},   {906272347, -575840202},   {905387953, -577229728},
    {904501429, -578617896},   {903612776, -580004702},   {902721998, -581390144},
    {901829095, -582774218},   {900934069, -584156920},

    {900036924, -585538248},   {899137661, -586918198},   {898236282, -588296766},
    {897332790, -589673951},   {896427186, -591049748},   {895519473, -592424154},
    {894609652, -593797166},   {893697727, -595168781},

    {892783698, -596538995},   {891867569, -597907806},   {890949341, -599275210},
    {890029016, -600641203},   {889106597, -602005783},   {888182086, -603368947},
    {887255485, -604730691},   {886326796, -606091012},

    {885396022, -607449906},   {884463164, -608807372},   {883528225, -610163404},
    {882591207, -611518001},   {881652112, -612871159},   {880710943, -614222875},
    {879767701, -615573145},   {878822389, -616921967},

    {877875009, -618269338},   {876925563, -619615253},   {875974054, -620959711},
    {875020483, -622302707},   {874064853, -623644239},   {873107167, -624984303},
    {872147426, -626322897},   {871185633, -627660017},

    {870221790, -628995660},   {869255900, -630329823},   {868287963, -631662503},
    {867317984, -632993696},   {866345964, -634323400},   {865371905, -635651611},
    {864395810, -636978327},   {863417681, -638303543},

    {862437520, -639627258},   {861455330, -640949467},   {860471112, -642270169},
    {859484870, -643589359},   {858496606, -644907034},   {857506321, -646223192},
    {856514019, -647537830},   {855519701, -648850943},

    {854523370, -650162530},   {853525028, -651472587},   {852524677, -652781111},
    {851522321, -654088099},   {850517961, -655393548},   {849511600, -656697454},
    {848503239, -657999816},   {847492882, -659300629},

    {846480531, -660599890},   {845466188, -661897597},   {844449856, -663193747},
    {843431536, -664488336},   {842411232, -665781362},   {841388945, -667072820},
    {840364679, -668362709},   {839338435, -669651026},

    {838310216, -670937767},   {837280024, -672222928},   {836247863, -673506508},
    {835213733, -674788504},   {834177638, -676068911},   {833139580, -677347728},
    {832099562, -678624950},   {831057586, -679900576},

    {830013654, -681174602},   {828967769, -682447025},   {827919934, -683717842},
    {826870150, -684987051},   {825818421, -686254647},   {824764748, -687520629},
    {823709135, -688784993},   {822651583, -690047736},

    {821592095, -691308855},   {820530675, -692568348},   {819467323, -693826211},
    {818402043, -695082441},   {817334838, -696337036},   {816265709, -697589992},
    {815194659, -698841307},   {814121692, -700090977},

    {813046808, -701339000},   {811970011, -702585372},   {810891304, -703830092},
    {809810688, -705073155},   {808728167, -706314559},   {807643743, -707554301},
    {806557419, -708792378},   {805469196, -710028787},

    {804379079, -711263525},   {803287068, -712496590},   {802193167, -713727978},
    {801097379, -714957687},   {799999706, -716185713},   {798900150, -717412054},
    {797798714, -718636707},   {796695401, -719859669},

    {795590213, -721080937},   {794483153, -722300508},   {793374223, -723518380},
    {792263427, -724734549},   {791150767, -725949013},   {790036244, -727161768},
    {788919863, -728372813},   {787801625, -729582143},

    {786681534, -730789757},   {785559591, -731995651},   {784435800, -733199822},
    {783310163, -734402269},   {782182683, -735602987},   {781053363, -736801974},
    {779922204, -737999228},   {778789210, -739194745},

    {777654384, -740388522},   {776517728, -741580558},   {775379244, -742770848},
    {774238936, -743959390},   {773096806, -745146182},   {771952857, -746331221},
    {770807092, -747514503},   {769659512, -748696026},

    {768510122, -749875788},   {767358923, -751053785},   {766205919, -752230015},
    {765051111, -753404474},   {763894504, -754577161},   {762736098, -755748072},
    {761575898, -756917205},   {760413906, -758084557},

    {759250125, -759250125},   {758084557, -760413906},   {756917205, -761575898},
    {755748072, -762736098},   {754577161, -763894504},   {753404474, -765051111},
    {752230015, -766205919},   {751053785, -767358923},

    {749875788, -768510122},   {748696026, -769659512},   {747514503, -770807092},
    {746331221, -771952857},   {745146182, -773096806},   {743959390, -774238936},
    {742770848, -775379244},   {741580558, -776517728},

    {740388522, -777654384},   {739194745, -778789210},   {737999228, -779922204},
    {736801974, -781053363},   {735602987, -782182683},   {734402269, -783310163},
    {733199822, -784435800},   {731995651, -785559591},

    {730789757, -786681534},   {729582143, -787801625},   {728372813, -788919863},
    {727161768, -790036244},   {725949013, -791150767},   {724734549, -792263427},
    {723518380, -793374223},   {722300508, -794483153},

    {721080937, -795590213},   {719859669, -796695401},   {718636707, -797798714},
    {717412054, -798900150},   {716185713, -799999706},   {714957687, -801097379},
    {713727978, -802193167},   {712496590, -803287068},

    {711263525, -804379079},   {710028787, -805469196},   {708792378, -806557419},
    {707554301, -807643743},   {706314559, -808728167},   {705073155, -809810688},
    {703830092, -810891304},   {702585372, -811970011},

    {701339000, -813046808},   {700090977, -814121692},   {698841307, -815194659},
    {697589992, -816265709},   {696337036, -817334838},   {695082441, -818402043},
    {693826211, -819467323},   {692568348, -820530675},

    {691308855, -821592095},   {690047736, -822651583},   {688784993, -823709135},
    {687520629, -824764748},   {686254647, -825818421},   {684987051, -826870150},
    {683717842, -827919934},   {682447025, -828967769},

    {681174602, -830013654},   {679900576, -831057586},   {678624950, -832099562},
    {677347728, -833139580},   {676068911, -834177638},   {674788504, -835213733},
    {673506508, -836247863},   {672222928, -837280024},

    {670937767, -838310216},   {669651026, -839338435},   {668362709, -840364679},
    {667072820, -841388945},   {665781362, -842411232},   {664488336, -843431536},
    {663193747, -844449856},   {661897597, -845466188},

    {660599890, -846480531},   {659300629, -847492882},   {657999816, -848503239},
    {656697454, -849511600},   {655393548, -850517961},   {654088099, -851522321},
    {652781111, -852524677},   {651472587, -853525028},

    {650162530, -854523370},   {648850943, -855519701},   {647537830, -856514019},
    {646223192, -857506321},   {644907034, -858496606},   {643589359, -859484870},
    {642270169, -860471112},   {640949467, -861455330},

    {639627258, -862437520},   {638303543, -863417681},   {636978327, -864395810},
    {635651611, -865371905},   {634323400, -866345964},   {632993696, -867317984},
    {631662503, -868287963},   {630329823, -869255900},

    {628995660, -870221790},   {627660017, -871185633},   {626322897, -872147426},
    {624984303, -873107167},   {623644239, -874064853},   {622302707, -875020483},
    {620959711, -875974054},   {619615253, -876925563},

    {618269338, -877875009},   {616921967, -878822389},   {615573145, -879767701},
    {614222875, -880710943},   {612871159, -881652112},   {611518001, -882591207},
    {610163404, -883528225},   {608807372, -884463164},

    {607449906, -885396022},   {606091012, -886326796},   {604730691, -887255485},
    {603368947, -888182086},   {602005783, -889106597},   {600641203, -890029016},
    {599275210, -890949341},   {597907806, -891867569},

    {596538995, -892783698},   {595168781, -893697727},   {593797166, -894609652},
    {592424154, -895519473},   {591049748, -896427186},   {589673951, -897332790},
    {588296766, -898236282},   {586918198, -899137661},

    {585538248, -900036924},   {584156920, -900934069},   {582774218, -901829095},
    {581390144, -902721998},   {580004702, -903612776},   {578617896, -904501429},
    {577229728, -905387953},   {575840202, -906272347},

    {574449320, -907154608},   {573057087, -908034735},   {571663506, -908912725},
    {570268579, -909788576},   {568872310, -910662286},   {567474703, -911533853},
    {566075761, -912403276},   {564675486, -913270551},

    {563273883, -914135678},   {561870954, -914998653},   {560466703, -915859476},
    {559061133, -916718143},   {557654248, -917574653},   {556246051, -918429004},
    {554836544, -919281194},   {553425732, -920131221},

    {552013618, -920979082},   {550600205, -921824777},   {549185496, -922668302},
    {547769495, -923509656},   {546352205, -924348837},   {544933630, -925185843},
    {543513772, -926020672},   {542092635, -926853322},

    {540670223, -927683790},   {539246538, -928512076},   {537821584, -929338177},
    {536395365, -930162092},   {534967884, -930983817},   {533539144, -931803352},
    {532109148, -932620694},   {530677900, -933435842},

    {529245404, -934248793},   {527811662, -935059546},   {526376678, -935868098},
    {524940456, -936674448},   {523502998, -937478595},   {522064309, -938280535},
    {520624391, -939080267},   {519183248, -939877790},

    {517740883, -940673101},   {516297300, -941466198},   {514852502, -942257081},
    {513406493, -943045745},   {511959275, -943832191},   {510510853, -944616416},
    {509061229, -945398418},   {507610408, -946178196},

    {506158392, -946955747},   {504705185, -947731070},   {503250791, -948504163},
    {501795212, -949275023},   {500338453, -950043650},   {498880516, -950810042},
    {497421405, -951574196},   {495961124, -952336111},

    {494499676, -953095785},   {493037064, -953853216},   {491573292, -954608403},
    {490108363, -955361344},   {488642281, -956112036},   {487175049, -956860479},
    {485706671, -957606670},   {484237150, -958350608},

    {482766489, -959092290},   {481294693, -959831716},   {479821764, -960568883},
    {478347705, -961303790},   {476872522, -962036435},   {475396216, -962766816},
    {473918791, -963494932},   {472440251, -964220780},

    {470960600, -964944360},   {469479840, -965665669},   {467997976, -966384706},
    {466515010, -967101468},   {465030947, -967815955},   {463545789, -968528165},
    {462059541, -969238095},   {460572205, -969945745},

    {459083786, -970651112},   {457594286, -971354196},   {456103710, -972054994},
    {454612060, -972753504},   {453119340, -973449725},   {451625555, -974143656},
    {450130706, -974835295},   {448634799, -975524639},

    {447137835, -976211688},   {445639820, -976896441},   {444140756, -977578894},
    {442640647, -978259047},   {441139496, -978936898},   {439637307, -979612445},
    {438134084, -980285688},   {436629829, -980956623},

    {435124548, -981625251},   {433618242, -982291568},   {432110916, -982955574},
    {430602573, -983617267},   {429093217, -984276646},   {427582852, -984933708},
    {426071480, -985588453},   {424559105, -986240879},

    {423045732, -986890984},   {421531363, -987538766},   {420016002, -988184225},
    {418499653, -988827359},   {416982319, -989468165},   {415464004, -990106644},
    {413944711, -990742793},   {412424444, -991376610},

    {410903207, -992008094},   {409381002, -992637245},   {407857835, -993264059},
    {406333708, -993888536},   {404808624, -994510675},   {403282588, -995130473},
    {401755603, -995747930},   {400227673, -996363043},

    {398698801, -996975812},   {397168991, -997586236},   {395638246, -998194311},
    {394106570, -998800038},   {392573967, -999403415},   {391040440, -1000004439},
    {389505993, -1000603111},  {387970630, -1001199428},

    {386434353, -1001793390},  {384897167, -1002384994},  {383359076, -1002974239},
    {381820082, -1003561124},  {380280190, -1004145648},  {378739403, -1004727809},
    {377197725, -1005307605},  {375655159, -1005885036},

    {374111709, -1006460100},  {372567379, -1007032796},  {371022173, -1007603122},
    {369476093, -1008171077},  {367929144, -1008736660},  {366381329, -1009299870},
    {364832652, -1009860704},  {363283116, -1010419162},

    {361732726, -1010975242},  {360181484, -1011528943},  {358629395, -1012080264},
    {357076462, -1012629204},  {355522689, -1013175761},  {353968079, -1013719934},
    {352412636, -1014261721},  {350856364, -1014801122},

    {349299266, -1015338134},  {347741347, -1015872758},  {346182609, -1016404991},
    {344623057, -1016934832},  {343062693, -1017462281},  {341501523, -1017987335},
    {339939549, -1018509994},  {338376774, -1019030256},

    {336813204, -1019548121},  {335248841, -1020063586},  {333683689, -1020576651},
    {332117752, -1021087314},  {330551034, -1021595575},  {328983538, -1022101432},
    {327415267, -1022604883},  {325846226, -1023105929},

    {324276419, -1023604567},  {322705848, -1024100796},  {321134518, -1024594615},
    {319562433, -1025086024},  {317989595, -1025575020},  {316416009, -1026061603},
    {314841679, -1026545772},  {313266607, -1027027525},

    {311690799, -1027506862},  {310114257, -1027983780},  {308536985, -1028458280},
    {306958988, -1028930359},  {305380268, -1029400018},  {303800829, -1029867254},
    {302220676, -1030332067},  {300639811, -1030794455},

    {299058239, -1031254418},  {297475964, -1031711954},  {295892988, -1032167062},
    {294309316, -1032619742},  {292724951, -1033069992},  {291139898, -1033517810},
    {289554160, -1033963197},  {287967740, -1034406151},

    {286380643, -1034846671},  {284792871, -1035284755},  {283204430, -1035720404},
    {281615322, -1036153615},  {280025552, -1036584389},  {278435122, -1037012723},
    {276844038, -1037438617},  {275252302, -1037862069},

    {273659918, -1038283080},  {272066891, -1038701647},  {270473223, -1039117770},
    {268878918, -1039531448},  {267283981, -1039942680},  {265688415, -1040351465},
    {264092224, -1040757802},  {262495412, -1041161689},

    {260897982, -1041563127},  {259299937, -1041962114},  {257701283, -1042358649},
    {256102022, -1042752731},  {254502159, -1043144360},  {252901697, -1043533534},
    {251300640, -1043920252},  {249698991, -1044304514},

    {248096755, -1044686319},  {246493935, -1045065665},  {244890535, -1045442553},
    {243286558, -1045816980},  {241682010, -1046188946},  {240076892, -1046558451},
    {238471210, -1046925492},  {236864966, -1047290071},

    {235258165, -1047652185},  {233650811, -1048011834},  {232042906, -1048369016},
    {230434456, -1048723732},  {228825464, -1049075980},  {227215933, -1049425759},
    {225605867, -1049773069},  {223995270, -1050117909},

    {222384147, -1050460278},  {220772500, -1050800175},  {219160334, -1051137599},
    {217547651, -1051472550},  {215934457, -1051805027},  {214320755, -1052135029},
    {212706549, -1052462555},  {211091842, -1052787604},

    {209476638, -1053110176},  {207860942, -1053430270},  {206244756, -1053747885},
    {204628085, -1054063021},  {203010932, -1054375676},  {201393302, -1054685850},
    {199775198, -1054993543},  {198156624, -1055298753},

    {196537583, -1055601479},  {194918080, -1055901722},  {193298119, -1056199480},
    {191677702, -1056494753},  {190056834, -1056787540},  {188435520, -1057077840},
    {186813762, -1057365653},  {185191564, -1057650977},

    {183568930, -1057933813},  {181945865, -1058214159},  {180322371, -1058492016},
    {178698453, -1058767381},  {177074115, -1059040255},  {175449360, -1059310638},
    {173824192, -1059578527},  {172198615, -1059843923},

    {170572633, -1060106826},  {168946249, -1060367233},  {167319468, -1060625146},
    {165692293, -1060880563},  {164064728, -1061133483},  {162436778, -1061383907},
    {160808445, -1061631833},  {159179733, -1061877261},

    {157550647, -1062120190},  {155921191, -1062360620},  {154291367, -1062598550},
    {152661180, -1062833980},  {151030634, -1063066909},  {149399733, -1063297336},
    {147768480, -1063525261},  {146136880, -1063750684},

    {144504935, -1063973603},  {142872651, -1064194019},  {141240030, -1064411931},
    {139607077, -1064627338},  {137973796, -1064840240},  {136340190, -1065050636},
    {134706263, -1065258526},  {133072019, -1065463909},

    {131437462, -1065666786},  {129802595, -1065867154},  {128167423, -1066065015},
    {126531950, -1066260367},  {124896179, -1066453210},  {123260114, -1066643544},
    {121623759, -1066831367},  {119987118, -1067016680},

    {118350194, -1067199483},  {116712992, -1067379774},  {115075515, -1067557554},
    {113437768, -1067732821},  {111799753, -1067905576},  {110161476, -1068075818},
    {108522939, -1068243547},  {106884147, -1068408763},

    {105245103, -1068571464},  {103605812, -1068731650},  {101966277, -1068889322},
    {100326502, -1069044479},  {98686491, -1069197120},   {97046247, -1069347245},
    {95405776, -1069494854},   {93765079, -1069639946},

    {92124163, -1069782521},   {90483029, -1069922579},   {88841683, -1070060120},
    {87200127, -1070195142},   {85558366, -1070327646},   {83916404, -1070457632},
    {82274245, -1070585099},   {80631892, -1070710046},

    {78989349, -1070832474},   {77346620, -1070952382},   {75703709, -1071069770},
    {74060620, -1071184638},   {72417357, -1071296985},   {70773924, -1071406812},
    {69130324, -1071514117},   {67486561, -1071618901},

    {65842639, -1071721163},   {64198563, -1071820903},   {62554335, -1071918122},
    {60909960, -1072012818},   {59265442, -1072104991},   {57620785, -1072194642},
    {55975992, -1072281769},   {54331067, -1072366374},

    {52686014, -1072448455},   {51040837, -1072528012},   {49395541, -1072605046},
    {47750128, -1072679556},   {46104602, -1072751542},   {44458968, -1072821003},
    {42813230, -1072887940},   {41167391, -1072952352},

    {39521455, -1073014240},   {37875426, -1073073603},   {36229307, -1073130440},
    {34583104, -1073184753},   {32936819, -1073236540},   {31290457, -1073285802},
    {29644021, -1073332538},   {27997515, -1073376748},

    {26350943, -1073418433},   {24704310, -1073457592},   {23057618, -1073494225},
    {21410872, -1073528332},   {19764076, -1073559913},   {18117233, -1073588967},
    {16470347, -1073615496},   {14823423, -1073639498},

    {13176464, -1073660973},   {11529474, -1073679922},   {9882456, -1073696345},
    {8235416, -1073710241},    {6588356, -1073721611},    {4941281, -1073730454},
    {3294193, -1073736771},    {1647099, -1073740561},

    {0, -1073741824},          {-1647099, -1073740561},   {-3294193, -1073736771},
    {-4941281, -1073730454},   {-6588356, -1073721611},   {-8235416, -1073710241},
    {-9882456, -1073696345},   {-11529474, -1073679922},

    {-13176464, -1073660973},  {-14823423, -1073639498},  {-16470347, -1073615496},
    {-18117233, -1073588967},  {-19764076, -1073559913},  {-21410872, -1073528332},
    {-23057618, -1073494225},  {-24704310, -1073457592},

    {-26350943, -1073418433},  {-27997515, -1073376748},  {-29644021, -1073332538},
    {-31290457, -1073285802},  {-32936819, -1073236540},  {-34583104, -1073184753},
    {-36229307, -1073130440},  {-37875426, -1073073603},

    {-39521455, -1073014240},  {-41167391, -1072952352},  {-42813230, -1072887940},
    {-44458968, -1072821003},  {-46104602, -1072751542},  {-47750128, -1072679556},
    {-49395541, -1072605046},  {-51040837, -1072528012},

    {-52686014, -1072448455},  {-54331067, -1072366374},  {-55975992, -1072281769},
    {-57620785, -1072194642},  {-59265442, -1072104991},  {-60909960, -1072012818},
    {-62554335, -1071918122},  {-64198563, -1071820903},

    {-65842639, -1071721163},  {-67486561, -1071618901},  {-69130324, -1071514117},
    {-70773924, -1071406812},  {-72417357, -1071296985},  {-74060620, -1071184638},
    {-75703709, -1071069770},  {-77346620, -1070952382},

    {-78989349, -1070832474},  {-80631892, -1070710046},  {-82274245, -1070585099},
    {-83916404, -1070457632},  {-85558366, -1070327646},  {-87200127, -1070195142},
    {-88841683, -1070060120},  {-90483029, -1069922579},

    {-92124163, -1069782521},  {-93765079, -1069639946},  {-95405776, -1069494854},
    {-97046247, -1069347245},  {-98686491, -1069197120},  {-100326502, -1069044479},
    {-101966277, -1068889322}, {-103605812, -1068731650},

    {-105245103, -1068571464}, {-106884147, -1068408763}, {-108522939, -1068243547},
    {-110161476, -1068075818}, {-111799753, -1067905576}, {-113437768, -1067732821},
    {-115075515, -1067557554}, {-116712992, -1067379774},

    {-118350194, -1067199483}, {-119987118, -1067016680}, {-121623759, -1066831367},
    {-123260114, -1066643544}, {-124896179, -1066453210}, {-126531950, -1066260367},
    {-128167423, -1066065015}, {-129802595, -1065867154},

    {-131437462, -1065666786}, {-133072019, -1065463909}, {-134706263, -1065258526},
    {-136340190, -1065050636}, {-137973796, -1064840240}, {-139607077, -1064627338},
    {-141240030, -1064411931}, {-142872651, -1064194019},

    {-144504935, -1063973603}, {-146136880, -1063750684}, {-147768480, -1063525261},
    {-149399733, -1063297336}, {-151030634, -1063066909}, {-152661180, -1062833980},
    {-154291367, -1062598550}, {-155921191, -1062360620},

    {-157550647, -1062120190}, {-159179733, -1061877261}, {-160808445, -1061631833},
    {-162436778, -1061383907}, {-164064728, -1061133483}, {-165692293, -1060880563},
    {-167319468, -1060625146}, {-168946249, -1060367233},

    {-170572633, -1060106826}, {-172198615, -1059843923}, {-173824192, -1059578527},
    {-175449360, -1059310638}, {-177074115, -1059040255}, {-178698453, -1058767381},
    {-180322371, -1058492016}, {-181945865, -1058214159},

    {-183568930, -1057933813}, {-185191564, -1057650977}, {-186813762, -1057365653},
    {-188435520, -1057077840}, {-190056834, -1056787540}, {-191677702, -1056494753},
    {-193298119, -1056199480}, {-194918080, -1055901722},

    {-196537583, -1055601479}, {-198156624, -1055298753}, {-199775198, -1054993543},
    {-201393302, -1054685850}, {-203010932, -1054375676}, {-204628085, -1054063021},
    {-206244756, -1053747885}, {-207860942, -1053430270},

    {-209476638, -1053110176}, {-211091842, -1052787604}, {-212706549, -1052462555},
    {-214320755, -1052135029}, {-215934457, -1051805027}, {-217547651, -1051472550},
    {-219160334, -1051137599}, {-220772500, -1050800175},

    {-222384147, -1050460278}, {-223995270, -1050117909}, {-225605867, -1049773069},
    {-227215933, -1049425759}, {-228825464, -1049075980}, {-230434456, -1048723732},
    {-232042906, -1048369016}, {-233650811, -1048011834},

    {-235258165, -1047652185}, {-236864966, -1047290071}, {-238471210, -1046925492},
    {-240076892, -1046558451}, {-241682010, -1046188946}, {-243286558, -1045816980},
    {-244890535, -1045442553}, {-246493935, -1045065665},

    {-248096755, -1044686319}, {-249698991, -1044304514}, {-251300640, -1043920252},
    {-252901697, -1043533534}, {-254502159, -1043144360}, {-256102022, -1042752731},
    {-257701283, -1042358649}, {-259299937, -1041962114},

    {-260897982, -1041563127}, {-262495412, -1041161689}, {-264092224, -1040757802},
    {-265688415, -1040351465}, {-267283981, -1039942680}, {-268878918, -1039531448},
    {-270473223, -1039117770}, {-272066891, -1038701647},

    {-273659918, -1038283080}, {-275252302, -1037862069}, {-276844038, -1037438617},
    {-278435122, -1037012723}, {-280025552, -1036584389}, {-281615322, -1036153615},
    {-283204430, -1035720404}, {-284792871, -1035284755},

    {-286380643, -1034846671}, {-287967740, -1034406151}, {-289554160, -1033963197},
    {-291139898, -1033517810}, {-292724951, -1033069992}, {-294309316, -1032619742},
    {-295892988, -1032167062}, {-297475964, -1031711954},

    {-299058239, -1031254418}, {-300639811, -1030794455}, {-302220676, -1030332067},
    {-303800829, -1029867254}, {-305380268, -1029400018}, {-306958988, -1028930359},
    {-308536985, -1028458280}, {-310114257, -1027983780},

    {-311690799, -1027506862}, {-313266607, -1027027525}, {-314841679, -1026545772},
    {-316416009, -1026061603}, {-317989595, -1025575020}, {-319562433, -1025086024},
    {-321134518, -1024594615}, {-322705848, -1024100796},

    {-324276419, -1023604567}, {-325846226, -1023105929}, {-327415267, -1022604883},
    {-328983538, -1022101432}, {-330551034, -1021595575}, {-332117752, -1021087314},
    {-333683689, -1020576651}, {-335248841, -1020063586},

    {-336813204, -1019548121}, {-338376774, -1019030256}, {-339939549, -1018509994},
    {-341501523, -1017987335}, {-343062693, -1017462281}, {-344623057, -1016934832},
    {-346182609, -1016404991}, {-347741347, -1015872758},

    {-349299266, -1015338134}, {-350856364, -1014801122}, {-352412636, -1014261721},
    {-353968079, -1013719934}, {-355522689, -1013175761}, {-357076462, -1012629204},
    {-358629395, -1012080264}, {-360181484, -1011528943},

    {-361732726, -1010975242}, {-363283116, -1010419162}, {-364832652, -1009860704},
    {-366381329, -1009299870}, {-367929144, -1008736660}, {-369476093, -1008171077},
    {-371022173, -1007603122}, {-372567379, -1007032796},

    {-374111709, -1006460100}, {-375655159, -1005885036}, {-377197725, -1005307605},
    {-378739403, -1004727809}, {-380280190, -1004145648}, {-381820082, -1003561124},
    {-383359076, -1002974239}, {-384897167, -1002384994},

    {-386434353, -1001793390}, {-387970630, -1001199428}, {-389505993, -1000603111},
    {-391040440, -1000004439}, {-392573967, -999403415},  {-394106570, -998800038},
    {-395638246, -998194311},  {-397168991, -997586236},

    {-398698801, -996975812},  {-400227673, -996363043},  {-401755603, -995747930},
    {-403282588, -995130473},  {-404808624, -994510675},  {-406333708, -993888536},
    {-407857835, -993264059},  {-409381002, -992637245},

    {-410903207, -992008094},  {-412424444, -991376610},  {-413944711, -990742793},
    {-415464004, -990106644},  {-416982319, -989468165},  {-418499653, -988827359},
    {-420016002, -988184225},  {-421531363, -987538766},

    {-423045732, -986890984},  {-424559105, -986240879},  {-426071480, -985588453},
    {-427582852, -984933708},  {-429093217, -984276646},  {-430602573, -983617267},
    {-432110916, -982955574},  {-433618242, -982291568},

    {-435124548, -981625251},  {-436629829, -980956623},  {-438134084, -980285688},
    {-439637307, -979612445},  {-441139496, -978936898},  {-442640647, -978259047},
    {-444140756, -977578894},  {-445639820, -976896441},

    {-447137835, -976211688},  {-448634799, -975524639},  {-450130706, -974835295},
    {-451625555, -974143656},  {-453119340, -973449725},  {-454612060, -972753504},
    {-456103710, -972054994},  {-457594286, -971354196},

    {-459083786, -970651112},  {-460572205, -969945745},  {-462059541, -969238095},
    {-463545789, -968528165},  {-465030947, -967815955},  {-466515010, -967101468},
    {-467997976, -966384706},  {-469479840, -965665669},

    {-470960600, -964944360},  {-472440251, -964220780},  {-473918791, -963494932},
    {-475396216, -962766816},  {-476872522, -962036435},  {-478347705, -961303790},
    {-479821764, -960568883},  {-481294693, -959831716},

    {-482766489, -959092290},  {-484237150, -958350608},  {-485706671, -957606670},
    {-487175049, -956860479},  {-488642281, -956112036},  {-490108363, -955361344},
    {-491573292, -954608403},  {-493037064, -953853216},

    {-494499676, -953095785},  {-495961124, -952336111},  {-497421405, -951574196},
    {-498880516, -950810042},  {-500338453, -950043650},  {-501795212, -949275023},
    {-503250791, -948504163},  {-504705185, -947731070},

    {-506158392, -946955747},  {-507610408, -946178196},  {-509061229, -945398418},
    {-510510853, -944616416},  {-511959275, -943832191},  {-513406493, -943045745},
    {-514852502, -942257081},  {-516297300, -941466198},

    {-517740883, -940673101},  {-519183248, -939877790},  {-520624391, -939080267},
    {-522064309, -938280535},  {-523502998, -937478595},  {-524940456, -936674448},
    {-526376678, -935868098},  {-527811662, -935059546},

    {-529245404, -934248793},  {-530677900, -933435842},  {-532109148, -932620694},
    {-533539144, -931803352},  {-534967884, -930983817},  {-536395365, -930162092},
    {-537821584, -929338177},  {-539246538, -928512076},

    {-540670223, -927683790},  {-542092635, -926853322},  {-543513772, -926020672},
    {-544933630, -925185843},  {-546352205, -924348837},  {-547769495, -923509656},
    {-549185496, -922668302},  {-550600205, -921824777},

    {-552013618, -920979082},  {-553425732, -920131221},  {-554836544, -919281194},
    {-556246051, -918429004},  {-557654248, -917574653},  {-559061133, -916718143},
    {-560466703, -915859476},  {-561870954, -914998653},

    {-563273883, -914135678},  {-564675486, -913270551},  {-566075761, -912403276},
    {-567474703, -911533853},  {-568872310, -910662286},  {-570268579, -909788576},
    {-571663506, -908912725},  {-573057087, -908034735},

    {-574449320, -907154608},  {-575840202, -906272347},  {-577229728, -905387953},
    {-578617896, -904501429},  {-580004702, -903612776},  {-581390144, -902721998},
    {-582774218, -901829095},  {-584156920, -900934069},

    {-585538248, -900036924},  {-586918198, -899137661},  {-588296766, -898236282},
    {-589673951, -897332790},  {-591049748, -896427186},  {-592424154, -895519473},
    {-593797166, -894609652},  {-595168781, -893697727},

    {-596538995, -892783698},  {-597907806, -891867569},  {-599275210, -890949341},
    {-600641203, -890029016},  {-602005783, -889106597},  {-603368947, -888182086},
    {-604730691, -887255485},  {-606091012, -886326796},

    {-607449906, -885396022},  {-608807372, -884463164},  {-610163404, -883528225},
    {-611518001, -882591207},  {-612871159, -881652112},  {-614222875, -880710943},
    {-615573145, -879767701},  {-616921967, -878822389},

    {-618269338, -877875009},  {-619615253, -876925563},  {-620959711, -875974054},
    {-622302707, -875020483},  {-623644239, -874064853},  {-624984303, -873107167},
    {-626322897, -872147426},  {-627660017, -871185633},

    {-628995660, -870221790},  {-630329823, -869255900},  {-631662503, -868287963},
    {-632993696, -867317984},  {-634323400, -866345964},  {-635651611, -865371905},
    {-636978327, -864395810},  {-638303543, -863417681},

    {-639627258, -862437520},  {-640949467, -861455330},  {-642270169, -860471112},
    {-643589359, -859484870},  {-644907034, -858496606},  {-646223192, -857506321},
    {-647537830, -856514019},  {-648850943, -855519701},

    {-650162530, -854523370},  {-651472587, -853525028},  {-652781111, -852524677},
    {-654088099, -851522321},  {-655393548, -850517961},  {-656697454, -849511600},
    {-657999816, -848503239},  {-659300629, -847492882},

    {-660599890, -846480531},  {-661897597, -845466188},  {-663193747, -844449856},
    {-664488336, -843431536},  {-665781362, -842411232},  {-667072820, -841388945},
    {-668362709, -840364679},  {-669651026, -839338435},

    {-670937767, -838310216},  {-672222928, -837280024},  {-673506508, -836247863},
    {-674788504, -835213733},  {-676068911, -834177638},  {-677347728, -833139580},
    {-678624950, -832099562},  {-679900576, -831057586},

    {-681174602, -830013654},  {-682447025, -828967769},  {-683717842, -827919934},
    {-684987051, -826870150},  {-686254647, -825818421},  {-687520629, -824764748},
    {-688784993, -823709135},  {-690047736, -822651583},

    {-691308855, -821592095},  {-692568348, -820530675},  {-693826211, -819467323},
    {-695082441, -818402043},  {-696337036, -817334838},  {-697589992, -816265709},
    {-698841307, -815194659},  {-700090977, -814121692},

    {-701339000, -813046808},  {-702585372, -811970011},  {-703830092, -810891304},
    {-705073155, -809810688},  {-706314559, -808728167},  {-707554301, -807643743},
    {-708792378, -806557419},  {-710028787, -805469196},

    {-711263525, -804379079},  {-712496590, -803287068},  {-713727978, -802193167},
    {-714957687, -801097379},  {-716185713, -799999706},  {-717412054, -798900150},
    {-718636707, -797798714},  {-719859669, -796695401},

    {-721080937, -795590213},  {-722300508, -794483153},  {-723518380, -793374223},
    {-724734549, -792263427},  {-725949013, -791150767},  {-727161768, -790036244},
    {-728372813, -788919863},  {-729582143, -787801625},

    {-730789757, -786681534},  {-731995651, -785559591},  {-733199822, -784435800},
    {-734402269, -783310163},  {-735602987, -782182683},  {-736801974, -781053363},
    {-737999228, -779922204},  {-739194745, -778789210},

    {-740388522, -777654384},  {-741580558, -776517728},  {-742770848, -775379244},
    {-743959390, -774238936},  {-745146182, -773096806},  {-746331221, -771952857},
    {-747514503, -770807092},  {-748696026, -769659512},

    {-749875788, -768510122},  {-751053785, -767358923},  {-752230015, -766205919},
    {-753404474, -765051111},  {-754577161, -763894504},  {-755748072, -762736098},
    {-756917205, -761575898},  {-758084557, -760413906},

    {-759250125, -759250125},  {-760413906, -758084557},  {-761575898, -756917205},
    {-762736098, -755748072},  {-763894504, -754577161},  {-765051111, -753404474},
    {-766205919, -752230015},  {-767358923, -751053785},

    {-768510122, -749875788},  {-769659512, -748696026},  {-770807092, -747514503},
    {-771952857, -746331221},  {-773096806, -745146182},  {-774238936, -743959390},
    {-775379244, -742770848},  {-776517728, -741580558},

    {-777654384, -740388522},  {-778789210, -739194745},  {-779922204, -737999228},
    {-781053363, -736801974},  {-782182683, -735602987},  {-783310163, -734402269},
    {-784435800, -733199822},  {-785559591, -731995651},

    {-786681534, -730789757},  {-787801625, -729582143},  {-788919863, -728372813},
    {-790036244, -727161768},  {-791150767, -725949013},  {-792263427, -724734549},
    {-793374223, -723518380},  {-794483153, -722300508},

    {-795590213, -721080937},  {-796695401, -719859669},  {-797798714, -718636707},
    {-798900150, -717412054},  {-799999706, -716185713},  {-801097379, -714957687},
    {-802193167, -713727978},  {-803287068, -712496590},

    {-804379079, -711263525},  {-805469196, -710028787},  {-806557419, -708792378},
    {-807643743, -707554301},  {-808728167, -706314559},  {-809810688, -705073155},
    {-810891304, -703830092},  {-811970011, -702585372},

    {-813046808, -701339000},  {-814121692, -700090977},  {-815194659, -698841307},
    {-816265709, -697589992},  {-817334838, -696337036},  {-818402043, -695082441},
    {-819467323, -693826211},  {-820530675, -692568348},

    {-821592095, -691308855},  {-822651583, -690047736},  {-823709135, -688784993},
    {-824764748, -687520629},  {-825818421, -686254647},  {-826870150, -684987051},
    {-827919934, -683717842},  {-828967769, -682447025},

    {-830013654, -681174602},  {-831057586, -679900576},  {-832099562, -678624950},
    {-833139580, -677347728},  {-834177638, -676068911},  {-835213733, -674788504},
    {-836247863, -673506508},  {-837280024, -672222928},

    {-838310216, -670937767},  {-839338435, -669651026},  {-840364679, -668362709},
    {-841388945, -667072820},  {-842411232, -665781362},  {-843431536, -664488336},
    {-844449856, -663193747},  {-845466188, -661897597},

    {-846480531, -660599890},  {-847492882, -659300629},  {-848503239, -657999816},
    {-849511600, -656697454},  {-850517961, -655393548},  {-851522321, -654088099},
    {-852524677, -652781111},  {-853525028, -651472587},

    {-854523370, -650162530},  {-855519701, -648850943},  {-856514019, -647537830},
    {-857506321, -646223192},  {-858496606, -644907034},  {-859484870, -643589359},
    {-860471112, -642270169},  {-861455330, -640949467},

    {-862437520, -639627258},  {-863417681, -638303543},  {-864395810, -636978327},
    {-865371905, -635651611},  {-866345964, -634323400},  {-867317984, -632993696},
    {-868287963, -631662503},  {-869255900, -630329823},

    {-870221790, -628995660},  {-871185633, -627660017},  {-872147426, -626322897},
    {-873107167, -624984303},  {-874064853, -623644239},  {-875020483, -622302707},
    {-875974054, -620959711},  {-876925563, -619615253},

    {-877875009, -618269338},  {-878822389, -616921967},  {-879767701, -615573145},
    {-880710943, -614222875},  {-881652112, -612871159},  {-882591207, -611518001},
    {-883528225, -610163404},  {-884463164, -608807372},

    {-885396022, -607449906},  {-886326796, -606091012},  {-887255485, -604730691},
    {-888182086, -603368947},  {-889106597, -602005783},  {-890029016, -600641203},
    {-890949341, -599275210},  {-891867569, -597907806},

    {-892783698, -596538995},  {-893697727, -595168781},  {-894609652, -593797166},
    {-895519473, -592424154},  {-896427186, -591049748},  {-897332790, -589673951},
    {-898236282, -588296766},  {-899137661, -586918198},

    {-900036924, -585538248},  {-900934069, -584156920},  {-901829095, -582774218},
    {-902721998, -581390144},  {-903612776, -580004702},  {-904501429, -578617896},
    {-905387953, -577229728},  {-906272347, -575840202},

    {-907154608, -574449320},  {-908034735, -573057087},  {-908912725, -571663506},
    {-909788576, -570268579},  {-910662286, -568872310},  {-911533853, -567474703},
    {-912403276, -566075761},  {-913270551, -564675486},

    {-914135678, -563273883},  {-914998653, -561870954},  {-915859476, -560466703},
    {-916718143, -559061133},  {-917574653, -557654248},  {-918429004, -556246051},
    {-919281194, -554836544},  {-920131221, -553425732},

    {-920979082, -552013618},  {-921824777, -550600205},  {-922668302, -549185496},
    {-923509656, -547769495},  {-924348837, -546352205},  {-925185843, -544933630},
    {-926020672, -543513772},  {-926853322, -542092635},

    {-927683790, -540670223},  {-928512076, -539246538},  {-929338177, -537821584},
    {-930162092, -536395365},  {-930983817, -534967884},  {-931803352, -533539144},
    {-932620694, -532109148},  {-933435842, -530677900},

    {-934248793, -529245404},  {-935059546, -527811662},  {-935868098, -526376678},
    {-936674448, -524940456},  {-937478595, -523502998},  {-938280535, -522064309},
    {-939080267, -520624391},  {-939877790, -519183248},

    {-940673101, -517740883},  {-941466198, -516297300},  {-942257081, -514852502},
    {-943045745, -513406493},  {-943832191, -511959275},  {-944616416, -510510853},
    {-945398418, -509061229},  {-946178196, -507610408},

    {-946955747, -506158392},  {-947731070, -504705185},  {-948504163, -503250791},
    {-949275023, -501795212},  {-950043650, -500338453},  {-950810042, -498880516},
    {-951574196, -497421405},  {-952336111, -495961124},

    {-953095785, -494499676},  {-953853216, -493037064},  {-954608403, -491573292},
    {-955361344, -490108363},  {-956112036, -488642281},  {-956860479, -487175049},
    {-957606670, -485706671},  {-958350608, -484237150},

    {-959092290, -482766489},  {-959831716, -481294693},  {-960568883, -479821764},
    {-961303790, -478347705},  {-962036435, -476872522},  {-962766816, -475396216},
    {-963494932, -473918791},  {-964220780, -472440251},

    {-964944360, -470960600},  {-965665669, -469479840},  {-966384706, -467997976},
    {-967101468, -466515010},  {-967815955, -465030947},  {-968528165, -463545789},
    {-969238095, -462059541},  {-969945745, -460572205},

    {-970651112, -459083786},  {-971354196, -457594286},  {-972054994, -456103710},
    {-972753504, -454612060},  {-973449725, -453119340},  {-974143656, -451625555},
    {-974835295, -450130706},  {-975524639, -448634799},

    {-976211688, -447137835},  {-976896441, -445639820},  {-977578894, -444140756},
    {-978259047, -442640647},  {-978936898, -441139496},  {-979612445, -439637307},
    {-980285688, -438134084},  {-980956623, -436629829},

    {-981625251, -435124548},  {-982291568, -433618242},  {-982955574, -432110916},
    {-983617267, -430602573},  {-984276646, -429093217},  {-984933708, -427582852},
    {-985588453, -426071480},  {-986240879, -424559105},

    {-986890984, -423045732},  {-987538766, -421531363},  {-988184225, -420016002},
    {-988827359, -418499653},  {-989468165, -416982319},  {-990106644, -415464004},
    {-990742793, -413944711},  {-991376610, -412424444},

    {-992008094, -410903207},  {-992637245, -409381002},  {-993264059, -407857835},
    {-993888536, -406333708},  {-994510675, -404808624},  {-995130473, -403282588},
    {-995747930, -401755603},  {-996363043, -400227673},

    {-996975812, -398698801},  {-997586236, -397168991},  {-998194311, -395638246},
    {-998800038, -394106570},  {-999403415, -392573967},  {-1000004439, -391040440},
    {-1000603111, -389505993}, {-1001199428, -387970630},

    {-1001793390, -386434353}, {-1002384994, -384897167}, {-1002974239, -383359076},
    {-1003561124, -381820082}, {-1004145648, -380280190}, {-1004727809, -378739403},
    {-1005307605, -377197725}, {-1005885036, -375655159},

    {-1006460100, -374111709}, {-1007032796, -372567379}, {-1007603122, -371022173},
    {-1008171077, -369476093}, {-1008736660, -367929144}, {-1009299870, -366381329},
    {-1009860704, -364832652}, {-1010419162, -363283116},

    {-1010975242, -361732726}, {-1011528943, -360181484}, {-1012080264, -358629395},
    {-1012629204, -357076462}, {-1013175761, -355522689}, {-1013719934, -353968079},
    {-1014261721, -352412636}, {-1014801122, -350856364},

    {-1015338134, -349299266}, {-1015872758, -347741347}, {-1016404991, -346182609},
    {-1016934832, -344623057}, {-1017462281, -343062693}, {-1017987335, -341501523},
    {-1018509994, -339939549}, {-1019030256, -338376774},

    {-1019548121, -336813204}, {-1020063586, -335248841}, {-1020576651, -333683689},
    {-1021087314, -332117752}, {-1021595575, -330551034}, {-1022101432, -328983538},
    {-1022604883, -327415267}, {-1023105929, -325846226},

    {-1023604567, -324276419}, {-1024100796, -322705848}, {-1024594615, -321134518},
    {-1025086024, -319562433}, {-1025575020, -317989595}, {-1026061603, -316416009},
    {-1026545772, -314841679}, {-1027027525, -313266607},

    {-1027506862, -311690799}, {-1027983780, -310114257}, {-1028458280, -308536985},
    {-1028930359, -306958988}, {-1029400018, -305380268}, {-1029867254, -303800829},
    {-1030332067, -302220676}, {-1030794455, -300639811},

    {-1031254418, -299058239}, {-1031711954, -297475964}, {-1032167062, -295892988},
    {-1032619742, -294309316}, {-1033069992, -292724951}, {-1033517810, -291139898},
    {-1033963197, -289554160}, {-1034406151, -287967740},

    {-1034846671, -286380643}, {-1035284755, -284792871}, {-1035720404, -283204430},
    {-1036153615, -281615322}, {-1036584389, -280025552}, {-1037012723, -278435122},
    {-1037438617, -276844038}, {-1037862069, -275252302},

    {-1038283080, -273659918}, {-1038701647, -272066891}, {-1039117770, -270473223},
    {-1039531448, -268878918}, {-1039942680, -267283981}, {-1040351465, -265688415},
    {-1040757802, -264092224}, {-1041161689, -262495412},

    {-1041563127, -260897982}, {-1041962114, -259299937}, {-1042358649, -257701283},
    {-1042752731, -256102022}, {-1043144360, -254502159}, {-1043533534, -252901697},
    {-1043920252, -251300640}, {-1044304514, -249698991},

    {-1044686319, -248096755}, {-1045065665, -246493935}, {-1045442553, -244890535},
    {-1045816980, -243286558}, {-1046188946, -241682010}, {-1046558451, -240076892},
    {-1046925492, -238471210}, {-1047290071, -236864966},

    {-1047652185, -235258165}, {-1048011834, -233650811}, {-1048369016, -232042906},
    {-1048723732, -230434456}, {-1049075980, -228825464}, {-1049425759, -227215933},
    {-1049773069, -225605867}, {-1050117909, -223995270},

    {-1050460278, -222384147}, {-1050800175, -220772500}, {-1051137599, -219160334},
    {-1051472550, -217547651}, {-1051805027, -215934457}, {-1052135029, -214320755},
    {-1052462555, -212706549}, {-1052787604, -211091842},

    {-1053110176, -209476638}, {-1053430270, -207860942}, {-1053747885, -206244756},
    {-1054063021, -204628085}, {-1054375676, -203010932}, {-1054685850, -201393302},
    {-1054993543, -199775198}, {-1055298753, -198156624},

    {-1055601479, -196537583}, {-1055901722, -194918080}, {-1056199480, -193298119},
    {-1056494753, -191677702}, {-1056787540, -190056834}, {-1057077840, -188435520},
    {-1057365653, -186813762}, {-1057650977, -185191564},

    {-1057933813, -183568930}, {-1058214159, -181945865}, {-1058492016, -180322371},
    {-1058767381, -178698453}, {-1059040255, -177074115}, {-1059310638, -175449360},
    {-1059578527, -173824192}, {-1059843923, -172198615},

    {-1060106826, -170572633}, {-1060367233, -168946249}, {-1060625146, -167319468},
    {-1060880563, -165692293}, {-1061133483, -164064728}, {-1061383907, -162436778},
    {-1061631833, -160808445}, {-1061877261, -159179733},

    {-1062120190, -157550647}, {-1062360620, -155921191}, {-1062598550, -154291367},
    {-1062833980, -152661180}, {-1063066909, -151030634}, {-1063297336, -149399733},
    {-1063525261, -147768480}, {-1063750684, -146136880},

    {-1063973603, -144504935}, {-1064194019, -142872651}, {-1064411931, -141240030},
    {-1064627338, -139607077}, {-1064840240, -137973796}, {-1065050636, -136340190},
    {-1065258526, -134706263}, {-1065463909, -133072019},

    {-1065666786, -131437462}, {-1065867154, -129802595}, {-1066065015, -128167423},
    {-1066260367, -126531950}, {-1066453210, -124896179}, {-1066643544, -123260114},
    {-1066831367, -121623759}, {-1067016680, -119987118},

    {-1067199483, -118350194}, {-1067379774, -116712992}, {-1067557554, -115075515},
    {-1067732821, -113437768}, {-1067905576, -111799753}, {-1068075818, -110161476},
    {-1068243547, -108522939}, {-1068408763, -106884147},

    {-1068571464, -105245103}, {-1068731650, -103605812}, {-1068889322, -101966277},
    {-1069044479, -100326502}, {-1069197120, -98686491},  {-1069347245, -97046247},
    {-1069494854, -95405776},  {-1069639946, -93765079},

    {-1069782521, -92124163},  {-1069922579, -90483029},  {-1070060120, -88841683},
    {-1070195142, -87200127},  {-1070327646, -85558366},  {-1070457632, -83916404},
    {-1070585099, -82274245},  {-1070710046, -80631892},

    {-1070832474, -78989349},  {-1070952382, -77346620},  {-1071069770, -75703709},
    {-1071184638, -74060620},  {-1071296985, -72417357},  {-1071406812, -70773924},
    {-1071514117, -69130324},  {-1071618901, -67486561},

    {-1071721163, -65842639},  {-1071820903, -64198563},  {-1071918122, -62554335},
    {-1072012818, -60909960},  {-1072104991, -59265442},  {-1072194642, -57620785},
    {-1072281769, -55975992},  {-1072366374, -54331067},

    {-1072448455, -52686014},  {-1072528012, -51040837},  {-1072605046, -49395541},
    {-1072679556, -47750128},  {-1072751542, -46104602},  {-1072821003, -44458968},
    {-1072887940, -42813230},  {-1072952352, -41167391},

    {-1073014240, -39521455},  {-1073073603, -37875426},  {-1073130440, -36229307},
    {-1073184753, -34583104},  {-1073236540, -32936819},  {-1073285802, -31290457},
    {-1073332538, -29644021},  {-1073376748, -27997515},

    {-1073418433, -26350943},  {-1073457592, -24704310},  {-1073494225, -23057618},
    {-1073528332, -21410872},  {-1073559913, -19764076},  {-1073588967, -18117233},
    {-1073615496, -16470347},  {-1073639498, -14823423},

    {-1073660973, -13176464},  {-1073679922, -11529474},  {-1073696345, -9882456},
    {-1073710241, -8235416},   {-1073721611, -6588356},   {-1073730454, -4941281},
    {-1073736771, -3294193},   {-1073740561, -1647099}

};
const cint16 twiddle_master_cint16[2048] = {
    {32767, 0},       {32767, -50},     {32767, -101},    {32767, -151},    {32767, -201},    {32767, -251},
    {32767, -302},    {32766, -352},    {32766, -402},    {32765, -452},    {32764, -503},    {32763, -553},
    {32762, -603},    {32761, -653},    {32760, -704},    {32759, -754},    {32758, -804},    {32757, -854},
    {32756, -905},    {32754, -955},    {32753, -1005},   {32751, -1055},   {32749, -1106},   {32748, -1156},
    {32746, -1206},   {32744, -1256},   {32742, -1307},   {32740, -1357},   {32738, -1407},   {32736, -1457},
    {32733, -1507},   {32731, -1558},   {32729, -1608},   {32726, -1658},   {32723, -1708},   {32721, -1758},
    {32718, -1809},   {32715, -1859},   {32712, -1909},   {32709, -1959},   {32706, -2009},   {32703, -2060},
    {32700, -2110},   {32697, -2160},   {32693, -2210},   {32690, -2260},   {32686, -2310},   {32683, -2360},
    {32679, -2411},   {32675, -2461},   {32672, -2511},   {32668, -2561},   {32664, -2611},   {32660, -2661},
    {32656, -2711},   {32651, -2761},   {32647, -2811},   {32643, -2861},   {32638, -2912},   {32634, -2962},
    {32629, -3012},   {32625, -3062},   {32620, -3112},   {32615, -3162},   {32610, -3212},   {32605, -3262},
    {32600, -3312},   {32595, -3362},   {32590, -3412},   {32585, -3462},   {32579, -3512},   {32574, -3562},
    {32568, -3612},   {32563, -3662},   {32557, -3712},   {32551, -3762},   {32546, -3812},   {32540, -3861},
    {32534, -3911},   {32528, -3961},   {32522, -4011},   {32515, -4061},   {32509, -4111},   {32503, -4161},
    {32496, -4211},   {32490, -4260},   {32483, -4310},   {32477, -4360},   {32470, -4410},   {32463, -4460},
    {32456, -4510},   {32449, -4559},   {32442, -4609},   {32435, -4659},   {32428, -4709},   {32421, -4758},
    {32413, -4808},   {32406, -4858},   {32398, -4907},   {32391, -4957},   {32383, -5007},   {32376, -5057},
    {32368, -5106},   {32360, -5156},   {32352, -5205},   {32344, -5255},   {32336, -5305},   {32328, -5354},
    {32319, -5404},   {32311, -5453},   {32303, -5503},   {32294, -5553},   {32286, -5602},   {32277, -5652},
    {32268, -5701},   {32259, -5751},   {32251, -5800},   {32242, -5850},   {32233, -5899},   {32224, -5948},
    {32214, -5998},   {32205, -6047},   {32196, -6097},   {32186, -6146},   {32177, -6195},   {32167, -6245},
    {32158, -6294},   {32148, -6343},   {32138, -6393},   {32129, -6442},   {32119, -6491},   {32109, -6541},
    {32099, -6590},   {32088, -6639},   {32078, -6688},   {32068, -6737},   {32058, -6787},   {32047, -6836},
    {32037, -6885},   {32026, -6934},   {32015, -6983},   {32005, -7032},   {31994, -7081},   {31983, -7130},
    {31972, -7180},   {31961, -7229},   {31950, -7278},   {31938, -7327},   {31927, -7376},   {31916, -7425},
    {31904, -7473},   {31893, -7522},   {31881, -7571},   {31870, -7620},   {31858, -7669},   {31846, -7718},
    {31834, -7767},   {31822, -7816},   {31810, -7864},   {31798, -7913},   {31786, -7962},   {31774, -8011},
    {31761, -8059},   {31749, -8108},   {31737, -8157},   {31724, -8206},   {31711, -8254},   {31699, -8303},
    {31686, -8351},   {31673, -8400},   {31660, -8449},   {31647, -8497},   {31634, -8546},   {31621, -8594},
    {31608, -8643},   {31594, -8691},   {31581, -8740},   {31568, -8788},   {31554, -8836},   {31540, -8885},
    {31527, -8933},   {31513, -8982},   {31499, -9030},   {31485, -9078},   {31471, -9127},   {31457, -9175},
    {31443, -9223},   {31429, -9271},   {31415, -9319},   {31400, -9368},   {31386, -9416},   {31372, -9464},
    {31357, -9512},   {31342, -9560},   {31328, -9608},   {31313, -9656},   {31298, -9704},   {31283, -9752},
    {31268, -9800},   {31253, -9848},   {31238, -9896},   {31223, -9944},   {31207, -9992},   {31192, -10040},
    {31177, -10088},  {31161, -10135},  {31146, -10183},  {31130, -10231},  {31114, -10279},  {31098, -10326},
    {31082, -10374},  {31067, -10422},  {31050, -10469},  {31034, -10517},  {31018, -10565},  {31002, -10612},
    {30986, -10660},  {30969, -10707},  {30953, -10755},  {30936, -10802},  {30920, -10850},  {30903, -10897},
    {30886, -10945},  {30869, -10992},  {30853, -11039},  {30836, -11087},  {30819, -11134},  {30801, -11181},
    {30784, -11228},  {30767, -11276},  {30750, -11323},  {30732, -11370},  {30715, -11417},  {30697, -11464},
    {30680, -11511},  {30662, -11558},  {30644, -11605},  {30626, -11652},  {30608, -11699},  {30590, -11746},
    {30572, -11793},  {30554, -11840},  {30536, -11887},  {30518, -11934},  {30499, -11980},  {30481, -12027},
    {30462, -12074},  {30444, -12121},  {30425, -12167},  {30407, -12214},  {30388, -12261},  {30369, -12307},
    {30350, -12354},  {30331, -12400},  {30312, -12447},  {30293, -12493},  {30274, -12540},  {30254, -12586},
    {30235, -12633},  {30216, -12679},  {30196, -12725},  {30177, -12772},  {30157, -12818},  {30137, -12864},
    {30118, -12910},  {30098, -12957},  {30078, -13003},  {30058, -13049},  {30038, -13095},  {30018, -13141},
    {29997, -13187},  {29977, -13233},  {29957, -13279},  {29936, -13325},  {29916, -13371},  {29895, -13417},
    {29875, -13463},  {29854, -13508},  {29833, -13554},  {29813, -13600},  {29792, -13646},  {29771, -13691},
    {29750, -13737},  {29729, -13783},  {29707, -13828},  {29686, -13874},  {29665, -13919},  {29643, -13965},
    {29622, -14010},  {29600, -14056},  {29579, -14101},  {29557, -14146},  {29535, -14192},  {29514, -14237},
    {29492, -14282},  {29470, -14327},  {29448, -14373},  {29426, -14418},  {29404, -14463},  {29381, -14508},
    {29359, -14553},  {29337, -14598},  {29314, -14643},  {29292, -14688},  {29269, -14733},  {29247, -14778},
    {29224, -14823},  {29201, -14867},  {29178, -14912},  {29155, -14957},  {29132, -15002},  {29109, -15046},
    {29086, -15091},  {29063, -15136},  {29040, -15180},  {29016, -15225},  {28993, -15269},  {28970, -15314},
    {28946, -15358},  {28922, -15402},  {28899, -15447},  {28875, -15491},  {28851, -15535},  {28827, -15580},
    {28803, -15624},  {28779, -15668},  {28755, -15712},  {28731, -15756},  {28707, -15800},  {28683, -15844},
    {28658, -15888},  {28634, -15932},  {28610, -15976},  {28585, -16020},  {28560, -16064},  {28536, -16108},
    {28511, -16151},  {28486, -16195},  {28461, -16239},  {28436, -16282},  {28411, -16326},  {28386, -16369},
    {28361, -16413},  {28336, -16456},  {28311, -16500},  {28285, -16543},  {28260, -16587},  {28234, -16630},
    {28209, -16673},  {28183, -16717},  {28158, -16760},  {28132, -16803},  {28106, -16846},  {28080, -16889},
    {28054, -16932},  {28028, -16975},  {28002, -17018},  {27976, -17061},  {27950, -17104},  {27924, -17147},
    {27897, -17190},  {27871, -17233},  {27844, -17275},  {27818, -17318},  {27791, -17361},  {27765, -17403},
    {27738, -17446},  {27711, -17488},  {27684, -17531},  {27657, -17573},  {27630, -17616},  {27603, -17658},
    {27576, -17700},  {27549, -17743},  {27522, -17785},  {27494, -17827},  {27467, -17869},  {27440, -17911},
    {27412, -17953},  {27384, -17995},  {27357, -18037},  {27329, -18079},  {27301, -18121},  {27273, -18163},
    {27246, -18205},  {27218, -18247},  {27190, -18288},  {27162, -18330},  {27133, -18372},  {27105, -18413},
    {27077, -18455},  {27049, -18496},  {27020, -18538},  {26992, -18579},  {26963, -18621},  {26935, -18662},
    {26906, -18703},  {26877, -18745},  {26848, -18786},  {26820, -18827},  {26791, -18868},  {26762, -18909},
    {26733, -18950},  {26704, -18991},  {26674, -19032},  {26645, -19073},  {26616, -19114},  {26586, -19155},
    {26557, -19195},  {26528, -19236},  {26498, -19277},  {26468, -19317},  {26439, -19358},  {26409, -19399},
    {26379, -19439},  {26349, -19479},  {26320, -19520},  {26290, -19560},  {26259, -19601},  {26229, -19641},
    {26199, -19681},  {26169, -19721},  {26139, -19761},  {26108, -19801},  {26078, -19841},  {26048, -19881},
    {26017, -19921},  {25986, -19961},  {25956, -20001},  {25925, -20041},  {25894, -20081},  {25863, -20120},
    {25833, -20160},  {25802, -20200},  {25771, -20239},  {25739, -20279},  {25708, -20318},  {25677, -20357},
    {25646, -20397},  {25615, -20436},  {25583, -20475},  {25552, -20515},  {25520, -20554},  {25489, -20593},
    {25457, -20632},  {25425, -20671},  {25394, -20710},  {25362, -20749},  {25330, -20788},  {25298, -20827},
    {25266, -20865},  {25234, -20904},  {25202, -20943},  {25170, -20981},  {25138, -21020},  {25105, -21059},
    {25073, -21097},  {25041, -21136},  {25008, -21174},  {24976, -21212},  {24943, -21251},  {24910, -21289},
    {24878, -21327},  {24845, -21365},  {24812, -21403},  {24779, -21441},  {24746, -21479},  {24713, -21517},
    {24680, -21555},  {24647, -21593},  {24614, -21631},  {24581, -21668},  {24548, -21706},  {24514, -21744},
    {24481, -21781},  {24448, -21819},  {24414, -21856},  {24380, -21894},  {24347, -21931},  {24313, -21968},
    {24279, -22006},  {24246, -22043},  {24212, -22080},  {24178, -22117},  {24144, -22154},  {24110, -22191},
    {24076, -22228},  {24042, -22265},  {24008, -22302},  {23973, -22339},  {23939, -22375},  {23905, -22412},
    {23870, -22449},  {23836, -22485},  {23801, -22522},  {23767, -22558},  {23732, -22595},  {23697, -22631},
    {23663, -22668},  {23628, -22704},  {23593, -22740},  {23558, -22776},  {23523, -22812},  {23488, -22848},
    {23453, -22884},  {23418, -22920},  {23383, -22956},  {23348, -22992},  {23312, -23028},  {23277, -23064},
    {23241, -23099},  {23206, -23135},  {23170, -23170},  {23135, -23206},  {23099, -23241},  {23064, -23277},
    {23028, -23312},  {22992, -23348},  {22956, -23383},  {22920, -23418},  {22884, -23453},  {22848, -23488},
    {22812, -23523},  {22776, -23558},  {22740, -23593},  {22704, -23628},  {22668, -23663},  {22631, -23697},
    {22595, -23732},  {22558, -23767},  {22522, -23801},  {22485, -23836},  {22449, -23870},  {22412, -23905},
    {22375, -23939},  {22339, -23973},  {22302, -24008},  {22265, -24042},  {22228, -24076},  {22191, -24110},
    {22154, -24144},  {22117, -24178},  {22080, -24212},  {22043, -24246},  {22006, -24279},  {21968, -24313},
    {21931, -24347},  {21894, -24380},  {21856, -24414},  {21819, -24448},  {21781, -24481},  {21744, -24514},
    {21706, -24548},  {21668, -24581},  {21631, -24614},  {21593, -24647},  {21555, -24680},  {21517, -24713},
    {21479, -24746},  {21441, -24779},  {21403, -24812},  {21365, -24845},  {21327, -24878},  {21289, -24910},
    {21251, -24943},  {21212, -24976},  {21174, -25008},  {21136, -25041},  {21097, -25073},  {21059, -25105},
    {21020, -25138},  {20981, -25170},  {20943, -25202},  {20904, -25234},  {20865, -25266},  {20827, -25298},
    {20788, -25330},  {20749, -25362},  {20710, -25394},  {20671, -25425},  {20632, -25457},  {20593, -25489},
    {20554, -25520},  {20515, -25552},  {20475, -25583},  {20436, -25615},  {20397, -25646},  {20357, -25677},
    {20318, -25708},  {20279, -25739},  {20239, -25771},  {20200, -25802},  {20160, -25833},  {20120, -25863},
    {20081, -25894},  {20041, -25925},  {20001, -25956},  {19961, -25986},  {19921, -26017},  {19881, -26048},
    {19841, -26078},  {19801, -26108},  {19761, -26139},  {19721, -26169},  {19681, -26199},  {19641, -26229},
    {19601, -26259},  {19560, -26290},  {19520, -26320},  {19479, -26349},  {19439, -26379},  {19399, -26409},
    {19358, -26439},  {19317, -26468},  {19277, -26498},  {19236, -26528},  {19195, -26557},  {19155, -26586},
    {19114, -26616},  {19073, -26645},  {19032, -26674},  {18991, -26704},  {18950, -26733},  {18909, -26762},
    {18868, -26791},  {18827, -26820},  {18786, -26848},  {18745, -26877},  {18703, -26906},  {18662, -26935},
    {18621, -26963},  {18579, -26992},  {18538, -27020},  {18496, -27049},  {18455, -27077},  {18413, -27105},
    {18372, -27133},  {18330, -27162},  {18288, -27190},  {18247, -27218},  {18205, -27246},  {18163, -27273},
    {18121, -27301},  {18079, -27329},  {18037, -27357},  {17995, -27384},  {17953, -27412},  {17911, -27440},
    {17869, -27467},  {17827, -27494},  {17785, -27522},  {17743, -27549},  {17700, -27576},  {17658, -27603},
    {17616, -27630},  {17573, -27657},  {17531, -27684},  {17488, -27711},  {17446, -27738},  {17403, -27765},
    {17361, -27791},  {17318, -27818},  {17275, -27844},  {17233, -27871},  {17190, -27897},  {17147, -27924},
    {17104, -27950},  {17061, -27976},  {17018, -28002},  {16975, -28028},  {16932, -28054},  {16889, -28080},
    {16846, -28106},  {16803, -28132},  {16760, -28158},  {16717, -28183},  {16673, -28209},  {16630, -28234},
    {16587, -28260},  {16543, -28285},  {16500, -28311},  {16456, -28336},  {16413, -28361},  {16369, -28386},
    {16326, -28411},  {16282, -28436},  {16239, -28461},  {16195, -28486},  {16151, -28511},  {16108, -28536},
    {16064, -28560},  {16020, -28585},  {15976, -28610},  {15932, -28634},  {15888, -28658},  {15844, -28683},
    {15800, -28707},  {15756, -28731},  {15712, -28755},  {15668, -28779},  {15624, -28803},  {15580, -28827},
    {15535, -28851},  {15491, -28875},  {15447, -28899},  {15402, -28922},  {15358, -28946},  {15314, -28970},
    {15269, -28993},  {15225, -29016},  {15180, -29040},  {15136, -29063},  {15091, -29086},  {15046, -29109},
    {15002, -29132},  {14957, -29155},  {14912, -29178},  {14867, -29201},  {14823, -29224},  {14778, -29247},
    {14733, -29269},  {14688, -29292},  {14643, -29314},  {14598, -29337},  {14553, -29359},  {14508, -29381},
    {14463, -29404},  {14418, -29426},  {14373, -29448},  {14327, -29470},  {14282, -29492},  {14237, -29514},
    {14192, -29535},  {14146, -29557},  {14101, -29579},  {14056, -29600},  {14010, -29622},  {13965, -29643},
    {13919, -29665},  {13874, -29686},  {13828, -29707},  {13783, -29729},  {13737, -29750},  {13691, -29771},
    {13646, -29792},  {13600, -29813},  {13554, -29833},  {13508, -29854},  {13463, -29875},  {13417, -29895},
    {13371, -29916},  {13325, -29936},  {13279, -29957},  {13233, -29977},  {13187, -29997},  {13141, -30018},
    {13095, -30038},  {13049, -30058},  {13003, -30078},  {12957, -30098},  {12910, -30118},  {12864, -30137},
    {12818, -30157},  {12772, -30177},  {12725, -30196},  {12679, -30216},  {12633, -30235},  {12586, -30254},
    {12540, -30274},  {12493, -30293},  {12447, -30312},  {12400, -30331},  {12354, -30350},  {12307, -30369},
    {12261, -30388},  {12214, -30407},  {12167, -30425},  {12121, -30444},  {12074, -30462},  {12027, -30481},
    {11980, -30499},  {11934, -30518},  {11887, -30536},  {11840, -30554},  {11793, -30572},  {11746, -30590},
    {11699, -30608},  {11652, -30626},  {11605, -30644},  {11558, -30662},  {11511, -30680},  {11464, -30697},
    {11417, -30715},  {11370, -30732},  {11323, -30750},  {11276, -30767},  {11228, -30784},  {11181, -30801},
    {11134, -30819},  {11087, -30836},  {11039, -30853},  {10992, -30869},  {10945, -30886},  {10897, -30903},
    {10850, -30920},  {10802, -30936},  {10755, -30953},  {10707, -30969},  {10660, -30986},  {10612, -31002},
    {10565, -31018},  {10517, -31034},  {10469, -31050},  {10422, -31067},  {10374, -31082},  {10326, -31098},
    {10279, -31114},  {10231, -31130},  {10183, -31146},  {10135, -31161},  {10088, -31177},  {10040, -31192},
    {9992, -31207},   {9944, -31223},   {9896, -31238},   {9848, -31253},   {9800, -31268},   {9752, -31283},
    {9704, -31298},   {9656, -31313},   {9608, -31328},   {9560, -31342},   {9512, -31357},   {9464, -31372},
    {9416, -31386},   {9368, -31400},   {9319, -31415},   {9271, -31429},   {9223, -31443},   {9175, -31457},
    {9127, -31471},   {9078, -31485},   {9030, -31499},   {8982, -31513},   {8933, -31527},   {8885, -31540},
    {8836, -31554},   {8788, -31568},   {8740, -31581},   {8691, -31594},   {8643, -31608},   {8594, -31621},
    {8546, -31634},   {8497, -31647},   {8449, -31660},   {8400, -31673},   {8351, -31686},   {8303, -31699},
    {8254, -31711},   {8206, -31724},   {8157, -31737},   {8108, -31749},   {8059, -31761},   {8011, -31774},
    {7962, -31786},   {7913, -31798},   {7864, -31810},   {7816, -31822},   {7767, -31834},   {7718, -31846},
    {7669, -31858},   {7620, -31870},   {7571, -31881},   {7522, -31893},   {7473, -31904},   {7425, -31916},
    {7376, -31927},   {7327, -31938},   {7278, -31950},   {7229, -31961},   {7180, -31972},   {7130, -31983},
    {7081, -31994},   {7032, -32005},   {6983, -32015},   {6934, -32026},   {6885, -32037},   {6836, -32047},
    {6787, -32058},   {6737, -32068},   {6688, -32078},   {6639, -32088},   {6590, -32099},   {6541, -32109},
    {6491, -32119},   {6442, -32129},   {6393, -32138},   {6343, -32148},   {6294, -32158},   {6245, -32167},
    {6195, -32177},   {6146, -32186},   {6097, -32196},   {6047, -32205},   {5998, -32214},   {5948, -32224},
    {5899, -32233},   {5850, -32242},   {5800, -32251},   {5751, -32259},   {5701, -32268},   {5652, -32277},
    {5602, -32286},   {5553, -32294},   {5503, -32303},   {5453, -32311},   {5404, -32319},   {5354, -32328},
    {5305, -32336},   {5255, -32344},   {5205, -32352},   {5156, -32360},   {5106, -32368},   {5057, -32376},
    {5007, -32383},   {4957, -32391},   {4907, -32398},   {4858, -32406},   {4808, -32413},   {4758, -32421},
    {4709, -32428},   {4659, -32435},   {4609, -32442},   {4559, -32449},   {4510, -32456},   {4460, -32463},
    {4410, -32470},   {4360, -32477},   {4310, -32483},   {4260, -32490},   {4211, -32496},   {4161, -32503},
    {4111, -32509},   {4061, -32515},   {4011, -32522},   {3961, -32528},   {3911, -32534},   {3861, -32540},
    {3812, -32546},   {3762, -32551},   {3712, -32557},   {3662, -32563},   {3612, -32568},   {3562, -32574},
    {3512, -32579},   {3462, -32585},   {3412, -32590},   {3362, -32595},   {3312, -32600},   {3262, -32605},
    {3212, -32610},   {3162, -32615},   {3112, -32620},   {3062, -32625},   {3012, -32629},   {2962, -32634},
    {2912, -32638},   {2861, -32643},   {2811, -32647},   {2761, -32651},   {2711, -32656},   {2661, -32660},
    {2611, -32664},   {2561, -32668},   {2511, -32672},   {2461, -32675},   {2411, -32679},   {2360, -32683},
    {2310, -32686},   {2260, -32690},   {2210, -32693},   {2160, -32697},   {2110, -32700},   {2060, -32703},
    {2009, -32706},   {1959, -32709},   {1909, -32712},   {1859, -32715},   {1809, -32718},   {1758, -32721},
    {1708, -32723},   {1658, -32726},   {1608, -32729},   {1558, -32731},   {1507, -32733},   {1457, -32736},
    {1407, -32738},   {1357, -32740},   {1307, -32742},   {1256, -32744},   {1206, -32746},   {1156, -32748},
    {1106, -32749},   {1055, -32751},   {1005, -32753},   {955, -32754},    {905, -32756},    {854, -32757},
    {804, -32758},    {754, -32759},    {704, -32760},    {653, -32761},    {603, -32762},    {553, -32763},
    {503, -32764},    {452, -32765},    {402, -32766},    {352, -32766},    {302, -32767},    {251, -32767},
    {201, -32767},    {151, -32768},    {101, -32768},    {50, -32768},     {0, -32768},      {-50, -32768},
    {-101, -32768},   {-151, -32768},   {-201, -32767},   {-251, -32767},   {-302, -32767},   {-352, -32766},
    {-402, -32766},   {-452, -32765},   {-503, -32764},   {-553, -32763},   {-603, -32762},   {-653, -32761},
    {-704, -32760},   {-754, -32759},   {-804, -32758},   {-854, -32757},   {-905, -32756},   {-955, -32754},
    {-1005, -32753},  {-1055, -32751},  {-1106, -32749},  {-1156, -32748},  {-1206, -32746},  {-1256, -32744},
    {-1307, -32742},  {-1357, -32740},  {-1407, -32738},  {-1457, -32736},  {-1507, -32733},  {-1558, -32731},
    {-1608, -32729},  {-1658, -32726},  {-1708, -32723},  {-1758, -32721},  {-1809, -32718},  {-1859, -32715},
    {-1909, -32712},  {-1959, -32709},  {-2009, -32706},  {-2060, -32703},  {-2110, -32700},  {-2160, -32697},
    {-2210, -32693},  {-2260, -32690},  {-2310, -32686},  {-2360, -32683},  {-2411, -32679},  {-2461, -32675},
    {-2511, -32672},  {-2561, -32668},  {-2611, -32664},  {-2661, -32660},  {-2711, -32656},  {-2761, -32651},
    {-2811, -32647},  {-2861, -32643},  {-2912, -32638},  {-2962, -32634},  {-3012, -32629},  {-3062, -32625},
    {-3112, -32620},  {-3162, -32615},  {-3212, -32610},  {-3262, -32605},  {-3312, -32600},  {-3362, -32595},
    {-3412, -32590},  {-3462, -32585},  {-3512, -32579},  {-3562, -32574},  {-3612, -32568},  {-3662, -32563},
    {-3712, -32557},  {-3762, -32551},  {-3812, -32546},  {-3861, -32540},  {-3911, -32534},  {-3961, -32528},
    {-4011, -32522},  {-4061, -32515},  {-4111, -32509},  {-4161, -32503},  {-4211, -32496},  {-4260, -32490},
    {-4310, -32483},  {-4360, -32477},  {-4410, -32470},  {-4460, -32463},  {-4510, -32456},  {-4559, -32449},
    {-4609, -32442},  {-4659, -32435},  {-4709, -32428},  {-4758, -32421},  {-4808, -32413},  {-4858, -32406},
    {-4907, -32398},  {-4957, -32391},  {-5007, -32383},  {-5057, -32376},  {-5106, -32368},  {-5156, -32360},
    {-5205, -32352},  {-5255, -32344},  {-5305, -32336},  {-5354, -32328},  {-5404, -32319},  {-5453, -32311},
    {-5503, -32303},  {-5553, -32294},  {-5602, -32286},  {-5652, -32277},  {-5701, -32268},  {-5751, -32259},
    {-5800, -32251},  {-5850, -32242},  {-5899, -32233},  {-5948, -32224},  {-5998, -32214},  {-6047, -32205},
    {-6097, -32196},  {-6146, -32186},  {-6195, -32177},  {-6245, -32167},  {-6294, -32158},  {-6343, -32148},
    {-6393, -32138},  {-6442, -32129},  {-6491, -32119},  {-6541, -32109},  {-6590, -32099},  {-6639, -32088},
    {-6688, -32078},  {-6737, -32068},  {-6787, -32058},  {-6836, -32047},  {-6885, -32037},  {-6934, -32026},
    {-6983, -32015},  {-7032, -32005},  {-7081, -31994},  {-7130, -31983},  {-7180, -31972},  {-7229, -31961},
    {-7278, -31950},  {-7327, -31938},  {-7376, -31927},  {-7425, -31916},  {-7473, -31904},  {-7522, -31893},
    {-7571, -31881},  {-7620, -31870},  {-7669, -31858},  {-7718, -31846},  {-7767, -31834},  {-7816, -31822},
    {-7864, -31810},  {-7913, -31798},  {-7962, -31786},  {-8011, -31774},  {-8059, -31761},  {-8108, -31749},
    {-8157, -31737},  {-8206, -31724},  {-8254, -31711},  {-8303, -31699},  {-8351, -31686},  {-8400, -31673},
    {-8449, -31660},  {-8497, -31647},  {-8546, -31634},  {-8594, -31621},  {-8643, -31608},  {-8691, -31594},
    {-8740, -31581},  {-8788, -31568},  {-8836, -31554},  {-8885, -31540},  {-8933, -31527},  {-8982, -31513},
    {-9030, -31499},  {-9078, -31485},  {-9127, -31471},  {-9175, -31457},  {-9223, -31443},  {-9271, -31429},
    {-9319, -31415},  {-9368, -31400},  {-9416, -31386},  {-9464, -31372},  {-9512, -31357},  {-9560, -31342},
    {-9608, -31328},  {-9656, -31313},  {-9704, -31298},  {-9752, -31283},  {-9800, -31268},  {-9848, -31253},
    {-9896, -31238},  {-9944, -31223},  {-9992, -31207},  {-10040, -31192}, {-10088, -31177}, {-10135, -31161},
    {-10183, -31146}, {-10231, -31130}, {-10279, -31114}, {-10326, -31098}, {-10374, -31082}, {-10422, -31067},
    {-10469, -31050}, {-10517, -31034}, {-10565, -31018}, {-10612, -31002}, {-10660, -30986}, {-10707, -30969},
    {-10755, -30953}, {-10802, -30936}, {-10850, -30920}, {-10897, -30903}, {-10945, -30886}, {-10992, -30869},
    {-11039, -30853}, {-11087, -30836}, {-11134, -30819}, {-11181, -30801}, {-11228, -30784}, {-11276, -30767},
    {-11323, -30750}, {-11370, -30732}, {-11417, -30715}, {-11464, -30697}, {-11511, -30680}, {-11558, -30662},
    {-11605, -30644}, {-11652, -30626}, {-11699, -30608}, {-11746, -30590}, {-11793, -30572}, {-11840, -30554},
    {-11887, -30536}, {-11934, -30518}, {-11980, -30499}, {-12027, -30481}, {-12074, -30462}, {-12121, -30444},
    {-12167, -30425}, {-12214, -30407}, {-12261, -30388}, {-12307, -30369}, {-12354, -30350}, {-12400, -30331},
    {-12447, -30312}, {-12493, -30293}, {-12540, -30274}, {-12586, -30254}, {-12633, -30235}, {-12679, -30216},
    {-12725, -30196}, {-12772, -30177}, {-12818, -30157}, {-12864, -30137}, {-12910, -30118}, {-12957, -30098},
    {-13003, -30078}, {-13049, -30058}, {-13095, -30038}, {-13141, -30018}, {-13187, -29997}, {-13233, -29977},
    {-13279, -29957}, {-13325, -29936}, {-13371, -29916}, {-13417, -29895}, {-13463, -29875}, {-13508, -29854},
    {-13554, -29833}, {-13600, -29813}, {-13646, -29792}, {-13691, -29771}, {-13737, -29750}, {-13783, -29729},
    {-13828, -29707}, {-13874, -29686}, {-13919, -29665}, {-13965, -29643}, {-14010, -29622}, {-14056, -29600},
    {-14101, -29579}, {-14146, -29557}, {-14192, -29535}, {-14237, -29514}, {-14282, -29492}, {-14327, -29470},
    {-14373, -29448}, {-14418, -29426}, {-14463, -29404}, {-14508, -29381}, {-14553, -29359}, {-14598, -29337},
    {-14643, -29314}, {-14688, -29292}, {-14733, -29269}, {-14778, -29247}, {-14823, -29224}, {-14867, -29201},
    {-14912, -29178}, {-14957, -29155}, {-15002, -29132}, {-15046, -29109}, {-15091, -29086}, {-15136, -29063},
    {-15180, -29040}, {-15225, -29016}, {-15269, -28993}, {-15314, -28970}, {-15358, -28946}, {-15402, -28922},
    {-15447, -28899}, {-15491, -28875}, {-15535, -28851}, {-15580, -28827}, {-15624, -28803}, {-15668, -28779},
    {-15712, -28755}, {-15756, -28731}, {-15800, -28707}, {-15844, -28683}, {-15888, -28658}, {-15932, -28634},
    {-15976, -28610}, {-16020, -28585}, {-16064, -28560}, {-16108, -28536}, {-16151, -28511}, {-16195, -28486},
    {-16239, -28461}, {-16282, -28436}, {-16326, -28411}, {-16369, -28386}, {-16413, -28361}, {-16456, -28336},
    {-16500, -28311}, {-16543, -28285}, {-16587, -28260}, {-16630, -28234}, {-16673, -28209}, {-16717, -28183},
    {-16760, -28158}, {-16803, -28132}, {-16846, -28106}, {-16889, -28080}, {-16932, -28054}, {-16975, -28028},
    {-17018, -28002}, {-17061, -27976}, {-17104, -27950}, {-17147, -27924}, {-17190, -27897}, {-17233, -27871},
    {-17275, -27844}, {-17318, -27818}, {-17361, -27791}, {-17403, -27765}, {-17446, -27738}, {-17488, -27711},
    {-17531, -27684}, {-17573, -27657}, {-17616, -27630}, {-17658, -27603}, {-17700, -27576}, {-17743, -27549},
    {-17785, -27522}, {-17827, -27494}, {-17869, -27467}, {-17911, -27440}, {-17953, -27412}, {-17995, -27384},
    {-18037, -27357}, {-18079, -27329}, {-18121, -27301}, {-18163, -27273}, {-18205, -27246}, {-18247, -27218},
    {-18288, -27190}, {-18330, -27162}, {-18372, -27133}, {-18413, -27105}, {-18455, -27077}, {-18496, -27049},
    {-18538, -27020}, {-18579, -26992}, {-18621, -26963}, {-18662, -26935}, {-18703, -26906}, {-18745, -26877},
    {-18786, -26848}, {-18827, -26820}, {-18868, -26791}, {-18909, -26762}, {-18950, -26733}, {-18991, -26704},
    {-19032, -26674}, {-19073, -26645}, {-19114, -26616}, {-19155, -26586}, {-19195, -26557}, {-19236, -26528},
    {-19277, -26498}, {-19317, -26468}, {-19358, -26439}, {-19399, -26409}, {-19439, -26379}, {-19479, -26349},
    {-19520, -26320}, {-19560, -26290}, {-19601, -26259}, {-19641, -26229}, {-19681, -26199}, {-19721, -26169},
    {-19761, -26139}, {-19801, -26108}, {-19841, -26078}, {-19881, -26048}, {-19921, -26017}, {-19961, -25986},
    {-20001, -25956}, {-20041, -25925}, {-20081, -25894}, {-20120, -25863}, {-20160, -25833}, {-20200, -25802},
    {-20239, -25771}, {-20279, -25739}, {-20318, -25708}, {-20357, -25677}, {-20397, -25646}, {-20436, -25615},
    {-20475, -25583}, {-20515, -25552}, {-20554, -25520}, {-20593, -25489}, {-20632, -25457}, {-20671, -25425},
    {-20710, -25394}, {-20749, -25362}, {-20788, -25330}, {-20827, -25298}, {-20865, -25266}, {-20904, -25234},
    {-20943, -25202}, {-20981, -25170}, {-21020, -25138}, {-21059, -25105}, {-21097, -25073}, {-21136, -25041},
    {-21174, -25008}, {-21212, -24976}, {-21251, -24943}, {-21289, -24910}, {-21327, -24878}, {-21365, -24845},
    {-21403, -24812}, {-21441, -24779}, {-21479, -24746}, {-21517, -24713}, {-21555, -24680}, {-21593, -24647},
    {-21631, -24614}, {-21668, -24581}, {-21706, -24548}, {-21744, -24514}, {-21781, -24481}, {-21819, -24448},
    {-21856, -24414}, {-21894, -24380}, {-21931, -24347}, {-21968, -24313}, {-22006, -24279}, {-22043, -24246},
    {-22080, -24212}, {-22117, -24178}, {-22154, -24144}, {-22191, -24110}, {-22228, -24076}, {-22265, -24042},
    {-22302, -24008}, {-22339, -23973}, {-22375, -23939}, {-22412, -23905}, {-22449, -23870}, {-22485, -23836},
    {-22522, -23801}, {-22558, -23767}, {-22595, -23732}, {-22631, -23697}, {-22668, -23663}, {-22704, -23628},
    {-22740, -23593}, {-22776, -23558}, {-22812, -23523}, {-22848, -23488}, {-22884, -23453}, {-22920, -23418},
    {-22956, -23383}, {-22992, -23348}, {-23028, -23312}, {-23064, -23277}, {-23099, -23241}, {-23135, -23206},
    {-23170, -23170}, {-23206, -23135}, {-23241, -23099}, {-23277, -23064}, {-23312, -23028}, {-23348, -22992},
    {-23383, -22956}, {-23418, -22920}, {-23453, -22884}, {-23488, -22848}, {-23523, -22812}, {-23558, -22776},
    {-23593, -22740}, {-23628, -22704}, {-23663, -22668}, {-23697, -22631}, {-23732, -22595}, {-23767, -22558},
    {-23801, -22522}, {-23836, -22485}, {-23870, -22449}, {-23905, -22412}, {-23939, -22375}, {-23973, -22339},
    {-24008, -22302}, {-24042, -22265}, {-24076, -22228}, {-24110, -22191}, {-24144, -22154}, {-24178, -22117},
    {-24212, -22080}, {-24246, -22043}, {-24279, -22006}, {-24313, -21968}, {-24347, -21931}, {-24380, -21894},
    {-24414, -21856}, {-24448, -21819}, {-24481, -21781}, {-24514, -21744}, {-24548, -21706}, {-24581, -21668},
    {-24614, -21631}, {-24647, -21593}, {-24680, -21555}, {-24713, -21517}, {-24746, -21479}, {-24779, -21441},
    {-24812, -21403}, {-24845, -21365}, {-24878, -21327}, {-24910, -21289}, {-24943, -21251}, {-24976, -21212},
    {-25008, -21174}, {-25041, -21136}, {-25073, -21097}, {-25105, -21059}, {-25138, -21020}, {-25170, -20981},
    {-25202, -20943}, {-25234, -20904}, {-25266, -20865}, {-25298, -20827}, {-25330, -20788}, {-25362, -20749},
    {-25394, -20710}, {-25425, -20671}, {-25457, -20632}, {-25489, -20593}, {-25520, -20554}, {-25552, -20515},
    {-25583, -20475}, {-25615, -20436}, {-25646, -20397}, {-25677, -20357}, {-25708, -20318}, {-25739, -20279},
    {-25771, -20239}, {-25802, -20200}, {-25833, -20160}, {-25863, -20120}, {-25894, -20081}, {-25925, -20041},
    {-25956, -20001}, {-25986, -19961}, {-26017, -19921}, {-26048, -19881}, {-26078, -19841}, {-26108, -19801},
    {-26139, -19761}, {-26169, -19721}, {-26199, -19681}, {-26229, -19641}, {-26259, -19601}, {-26290, -19560},
    {-26320, -19520}, {-26349, -19479}, {-26379, -19439}, {-26409, -19399}, {-26439, -19358}, {-26468, -19317},
    {-26498, -19277}, {-26528, -19236}, {-26557, -19195}, {-26586, -19155}, {-26616, -19114}, {-26645, -19073},
    {-26674, -19032}, {-26704, -18991}, {-26733, -18950}, {-26762, -18909}, {-26791, -18868}, {-26820, -18827},
    {-26848, -18786}, {-26877, -18745}, {-26906, -18703}, {-26935, -18662}, {-26963, -18621}, {-26992, -18579},
    {-27020, -18538}, {-27049, -18496}, {-27077, -18455}, {-27105, -18413}, {-27133, -18372}, {-27162, -18330},
    {-27190, -18288}, {-27218, -18247}, {-27246, -18205}, {-27273, -18163}, {-27301, -18121}, {-27329, -18079},
    {-27357, -18037}, {-27384, -17995}, {-27412, -17953}, {-27440, -17911}, {-27467, -17869}, {-27494, -17827},
    {-27522, -17785}, {-27549, -17743}, {-27576, -17700}, {-27603, -17658}, {-27630, -17616}, {-27657, -17573},
    {-27684, -17531}, {-27711, -17488}, {-27738, -17446}, {-27765, -17403}, {-27791, -17361}, {-27818, -17318},
    {-27844, -17275}, {-27871, -17233}, {-27897, -17190}, {-27924, -17147}, {-27950, -17104}, {-27976, -17061},
    {-28002, -17018}, {-28028, -16975}, {-28054, -16932}, {-28080, -16889}, {-28106, -16846}, {-28132, -16803},
    {-28158, -16760}, {-28183, -16717}, {-28209, -16673}, {-28234, -16630}, {-28260, -16587}, {-28285, -16543},
    {-28311, -16500}, {-28336, -16456}, {-28361, -16413}, {-28386, -16369}, {-28411, -16326}, {-28436, -16282},
    {-28461, -16239}, {-28486, -16195}, {-28511, -16151}, {-28536, -16108}, {-28560, -16064}, {-28585, -16020},
    {-28610, -15976}, {-28634, -15932}, {-28658, -15888}, {-28683, -15844}, {-28707, -15800}, {-28731, -15756},
    {-28755, -15712}, {-28779, -15668}, {-28803, -15624}, {-28827, -15580}, {-28851, -15535}, {-28875, -15491},
    {-28899, -15447}, {-28922, -15402}, {-28946, -15358}, {-28970, -15314}, {-28993, -15269}, {-29016, -15225},
    {-29040, -15180}, {-29063, -15136}, {-29086, -15091}, {-29109, -15046}, {-29132, -15002}, {-29155, -14957},
    {-29178, -14912}, {-29201, -14867}, {-29224, -14823}, {-29247, -14778}, {-29269, -14733}, {-29292, -14688},
    {-29314, -14643}, {-29337, -14598}, {-29359, -14553}, {-29381, -14508}, {-29404, -14463}, {-29426, -14418},
    {-29448, -14373}, {-29470, -14327}, {-29492, -14282}, {-29514, -14237}, {-29535, -14192}, {-29557, -14146},
    {-29579, -14101}, {-29600, -14056}, {-29622, -14010}, {-29643, -13965}, {-29665, -13919}, {-29686, -13874},
    {-29707, -13828}, {-29729, -13783}, {-29750, -13737}, {-29771, -13691}, {-29792, -13646}, {-29813, -13600},
    {-29833, -13554}, {-29854, -13508}, {-29875, -13463}, {-29895, -13417}, {-29916, -13371}, {-29936, -13325},
    {-29957, -13279}, {-29977, -13233}, {-29997, -13187}, {-30018, -13141}, {-30038, -13095}, {-30058, -13049},
    {-30078, -13003}, {-30098, -12957}, {-30118, -12910}, {-30137, -12864}, {-30157, -12818}, {-30177, -12772},
    {-30196, -12725}, {-30216, -12679}, {-30235, -12633}, {-30254, -12586}, {-30274, -12540}, {-30293, -12493},
    {-30312, -12447}, {-30331, -12400}, {-30350, -12354}, {-30369, -12307}, {-30388, -12261}, {-30407, -12214},
    {-30425, -12167}, {-30444, -12121}, {-30462, -12074}, {-30481, -12027}, {-30499, -11980}, {-30518, -11934},
    {-30536, -11887}, {-30554, -11840}, {-30572, -11793}, {-30590, -11746}, {-30608, -11699}, {-30626, -11652},
    {-30644, -11605}, {-30662, -11558}, {-30680, -11511}, {-30697, -11464}, {-30715, -11417}, {-30732, -11370},
    {-30750, -11323}, {-30767, -11276}, {-30784, -11228}, {-30801, -11181}, {-30819, -11134}, {-30836, -11087},
    {-30853, -11039}, {-30869, -10992}, {-30886, -10945}, {-30903, -10897}, {-30920, -10850}, {-30936, -10802},
    {-30953, -10755}, {-30969, -10707}, {-30986, -10660}, {-31002, -10612}, {-31018, -10565}, {-31034, -10517},
    {-31050, -10469}, {-31067, -10422}, {-31082, -10374}, {-31098, -10326}, {-31114, -10279}, {-31130, -10231},
    {-31146, -10183}, {-31161, -10135}, {-31177, -10088}, {-31192, -10040}, {-31207, -9992},  {-31223, -9944},
    {-31238, -9896},  {-31253, -9848},  {-31268, -9800},  {-31283, -9752},  {-31298, -9704},  {-31313, -9656},
    {-31328, -9608},  {-31342, -9560},  {-31357, -9512},  {-31372, -9464},  {-31386, -9416},  {-31400, -9368},
    {-31415, -9319},  {-31429, -9271},  {-31443, -9223},  {-31457, -9175},  {-31471, -9127},  {-31485, -9078},
    {-31499, -9030},  {-31513, -8982},  {-31527, -8933},  {-31540, -8885},  {-31554, -8836},  {-31568, -8788},
    {-31581, -8740},  {-31594, -8691},  {-31608, -8643},  {-31621, -8594},  {-31634, -8546},  {-31647, -8497},
    {-31660, -8449},  {-31673, -8400},  {-31686, -8351},  {-31699, -8303},  {-31711, -8254},  {-31724, -8206},
    {-31737, -8157},  {-31749, -8108},  {-31761, -8059},  {-31774, -8011},  {-31786, -7962},  {-31798, -7913},
    {-31810, -7864},  {-31822, -7816},  {-31834, -7767},  {-31846, -7718},  {-31858, -7669},  {-31870, -7620},
    {-31881, -7571},  {-31893, -7522},  {-31904, -7473},  {-31916, -7425},  {-31927, -7376},  {-31938, -7327},
    {-31950, -7278},  {-31961, -7229},  {-31972, -7180},  {-31983, -7130},  {-31994, -7081},  {-32005, -7032},
    {-32015, -6983},  {-32026, -6934},  {-32037, -6885},  {-32047, -6836},  {-32058, -6787},  {-32068, -6737},
    {-32078, -6688},  {-32088, -6639},  {-32099, -6590},  {-32109, -6541},  {-32119, -6491},  {-32129, -6442},
    {-32138, -6393},  {-32148, -6343},  {-32158, -6294},  {-32167, -6245},  {-32177, -6195},  {-32186, -6146},
    {-32196, -6097},  {-32205, -6047},  {-32214, -5998},  {-32224, -5948},  {-32233, -5899},  {-32242, -5850},
    {-32251, -5800},  {-32259, -5751},  {-32268, -5701},  {-32277, -5652},  {-32286, -5602},  {-32294, -5553},
    {-32303, -5503},  {-32311, -5453},  {-32319, -5404},  {-32328, -5354},  {-32336, -5305},  {-32344, -5255},
    {-32352, -5205},  {-32360, -5156},  {-32368, -5106},  {-32376, -5057},  {-32383, -5007},  {-32391, -4957},
    {-32398, -4907},  {-32406, -4858},  {-32413, -4808},  {-32421, -4758},  {-32428, -4709},  {-32435, -4659},
    {-32442, -4609},  {-32449, -4559},  {-32456, -4510},  {-32463, -4460},  {-32470, -4410},  {-32477, -4360},
    {-32483, -4310},  {-32490, -4260},  {-32496, -4211},  {-32503, -4161},  {-32509, -4111},  {-32515, -4061},
    {-32522, -4011},  {-32528, -3961},  {-32534, -3911},  {-32540, -3861},  {-32546, -3812},  {-32551, -3762},
    {-32557, -3712},  {-32563, -3662},  {-32568, -3612},  {-32574, -3562},  {-32579, -3512},  {-32585, -3462},
    {-32590, -3412},  {-32595, -3362},  {-32600, -3312},  {-32605, -3262},  {-32610, -3212},  {-32615, -3162},
    {-32620, -3112},  {-32625, -3062},  {-32629, -3012},  {-32634, -2962},  {-32638, -2912},  {-32643, -2861},
    {-32647, -2811},  {-32651, -2761},  {-32656, -2711},  {-32660, -2661},  {-32664, -2611},  {-32668, -2561},
    {-32672, -2511},  {-32675, -2461},  {-32679, -2411},  {-32683, -2360},  {-32686, -2310},  {-32690, -2260},
    {-32693, -2210},  {-32697, -2160},  {-32700, -2110},  {-32703, -2060},  {-32706, -2009},  {-32709, -1959},
    {-32712, -1909},  {-32715, -1859},  {-32718, -1809},  {-32721, -1758},  {-32723, -1708},  {-32726, -1658},
    {-32729, -1608},  {-32731, -1558},  {-32733, -1507},  {-32736, -1457},  {-32738, -1407},  {-32740, -1357},
    {-32742, -1307},  {-32744, -1256},  {-32746, -1206},  {-32748, -1156},  {-32749, -1106},  {-32751, -1055},
    {-32753, -1005},  {-32754, -955},   {-32756, -905},   {-32757, -854},   {-32758, -804},   {-32759, -754},
    {-32760, -704},   {-32761, -653},   {-32762, -603},   {-32763, -553},   {-32764, -503},   {-32765, -452},
    {-32766, -402},   {-32766, -352},   {-32767, -302},   {-32767, -251},   {-32767, -201},   {-32768, -151},
    {-32768, -101},   {-32768, -50}};
const cint16 twiddle_master_cint15[2048] = {
    {16384, 0},       {16384, -25},     {16384, -50},     {16384, -75},     {16384, -101},    {16384, -126},
    {16383, -151},    {16383, -176},    {16383, -201},    {16382, -226},    {16382, -251},    {16382, -276},
    {16381, -302},    {16381, -327},    {16380, -352},    {16380, -377},    {16379, -402},    {16378, -427},
    {16378, -452},    {16377, -477},    {16376, -503},    {16375, -528},    {16375, -553},    {16374, -578},
    {16373, -603},    {16372, -628},    {16371, -653},    {16370, -678},    {16369, -704},    {16368, -729},
    {16367, -754},    {16365, -779},    {16364, -804},    {16363, -829},    {16362, -854},    {16360, -879},
    {16359, -904},    {16358, -929},    {16356, -955},    {16355, -980},    {16353, -1005},   {16352, -1030},
    {16350, -1055},   {16348, -1080},   {16347, -1105},   {16345, -1130},   {16343, -1155},   {16341, -1180},
    {16340, -1205},   {16338, -1230},   {16336, -1255},   {16334, -1280},   {16332, -1306},   {16330, -1331},
    {16328, -1356},   {16326, -1381},   {16324, -1406},   {16321, -1431},   {16319, -1456},   {16317, -1481},
    {16315, -1506},   {16312, -1531},   {16310, -1556},   {16308, -1581},   {16305, -1606},   {16303, -1631},
    {16300, -1656},   {16298, -1681},   {16295, -1706},   {16292, -1731},   {16290, -1756},   {16287, -1781},
    {16284, -1806},   {16281, -1831},   {16279, -1856},   {16276, -1881},   {16273, -1906},   {16270, -1931},
    {16267, -1956},   {16264, -1981},   {16261, -2006},   {16258, -2031},   {16255, -2055},   {16251, -2080},
    {16248, -2105},   {16245, -2130},   {16242, -2155},   {16238, -2180},   {16235, -2205},   {16232, -2230},
    {16228, -2255},   {16225, -2280},   {16221, -2305},   {16218, -2329},   {16214, -2354},   {16210, -2379},
    {16207, -2404},   {16203, -2429},   {16199, -2454},   {16195, -2479},   {16192, -2503},   {16188, -2528},
    {16184, -2553},   {16180, -2578},   {16176, -2603},   {16172, -2628},   {16168, -2652},   {16164, -2677},
    {16160, -2702},   {16156, -2727},   {16151, -2752},   {16147, -2776},   {16143, -2801},   {16138, -2826},
    {16134, -2851},   {16130, -2875},   {16125, -2900},   {16121, -2925},   {16116, -2949},   {16112, -2974},
    {16107, -2999},   {16103, -3024},   {16098, -3048},   {16093, -3073},   {16088, -3098},   {16084, -3122},
    {16079, -3147},   {16074, -3172},   {16069, -3196},   {16064, -3221},   {16059, -3246},   {16054, -3270},
    {16049, -3295},   {16044, -3320},   {16039, -3344},   {16034, -3369},   {16029, -3393},   {16024, -3418},
    {16018, -3442},   {16013, -3467},   {16008, -3492},   {16002, -3516},   {15997, -3541},   {15991, -3565},
    {15986, -3590},   {15980, -3614},   {15975, -3639},   {15969, -3663},   {15964, -3688},   {15958, -3712},
    {15952, -3737},   {15946, -3761},   {15941, -3786},   {15935, -3810},   {15929, -3835},   {15923, -3859},
    {15917, -3883},   {15911, -3908},   {15905, -3932},   {15899, -3957},   {15893, -3981},   {15887, -4005},
    {15881, -4030},   {15875, -4054},   {15868, -4078},   {15862, -4103},   {15856, -4127},   {15849, -4151},
    {15843, -4176},   {15837, -4200},   {15830, -4224},   {15824, -4249},   {15817, -4273},   {15810, -4297},
    {15804, -4321},   {15797, -4346},   {15791, -4370},   {15784, -4394},   {15777, -4418},   {15770, -4442},
    {15763, -4467},   {15757, -4491},   {15750, -4515},   {15743, -4539},   {15736, -4563},   {15729, -4587},
    {15722, -4612},   {15715, -4636},   {15707, -4660},   {15700, -4684},   {15693, -4708},   {15686, -4732},
    {15679, -4756},   {15671, -4780},   {15664, -4804},   {15656, -4828},   {15649, -4852},   {15642, -4876},
    {15634, -4900},   {15627, -4924},   {15619, -4948},   {15611, -4972},   {15604, -4996},   {15596, -5020},
    {15588, -5044},   {15581, -5068},   {15573, -5092},   {15565, -5115},   {15557, -5139},   {15549, -5163},
    {15541, -5187},   {15533, -5211},   {15525, -5235},   {15517, -5259},   {15509, -5282},   {15501, -5306},
    {15493, -5330},   {15485, -5354},   {15476, -5377},   {15468, -5401},   {15460, -5425},   {15451, -5449},
    {15443, -5472},   {15435, -5496},   {15426, -5520},   {15418, -5543},   {15409, -5567},   {15401, -5591},
    {15392, -5614},   {15383, -5638},   {15375, -5661},   {15366, -5685},   {15357, -5708},   {15349, -5732},
    {15340, -5756},   {15331, -5779},   {15322, -5803},   {15313, -5826},   {15304, -5850},   {15295, -5873},
    {15286, -5897},   {15277, -5920},   {15268, -5943},   {15259, -5967},   {15250, -5990},   {15240, -6014},
    {15231, -6037},   {15222, -6060},   {15213, -6084},   {15203, -6107},   {15194, -6130},   {15184, -6154},
    {15175, -6177},   {15166, -6200},   {15156, -6223},   {15146, -6247},   {15137, -6270},   {15127, -6293},
    {15118, -6316},   {15108, -6339},   {15098, -6363},   {15088, -6386},   {15078, -6409},   {15069, -6432},
    {15059, -6455},   {15049, -6478},   {15039, -6501},   {15029, -6524},   {15019, -6547},   {15009, -6570},
    {14999, -6593},   {14989, -6616},   {14978, -6639},   {14968, -6662},   {14958, -6685},   {14948, -6708},
    {14937, -6731},   {14927, -6754},   {14917, -6777},   {14906, -6800},   {14896, -6823},   {14885, -6846},
    {14875, -6868},   {14864, -6891},   {14854, -6914},   {14843, -6937},   {14832, -6960},   {14822, -6982},
    {14811, -7005},   {14800, -7028},   {14789, -7050},   {14779, -7073},   {14768, -7096},   {14757, -7118},
    {14746, -7141},   {14735, -7164},   {14724, -7186},   {14713, -7209},   {14702, -7231},   {14691, -7254},
    {14680, -7276},   {14668, -7299},   {14657, -7321},   {14646, -7344},   {14635, -7366},   {14623, -7389},
    {14612, -7411},   {14601, -7434},   {14589, -7456},   {14578, -7478},   {14566, -7501},   {14555, -7523},
    {14543, -7545},   {14531, -7568},   {14520, -7590},   {14508, -7612},   {14497, -7635},   {14485, -7657},
    {14473, -7679},   {14461, -7701},   {14449, -7723},   {14438, -7746},   {14426, -7768},   {14414, -7790},
    {14402, -7812},   {14390, -7834},   {14378, -7856},   {14366, -7878},   {14354, -7900},   {14341, -7922},
    {14329, -7944},   {14317, -7966},   {14305, -7988},   {14293, -8010},   {14280, -8032},   {14268, -8054},
    {14256, -8076},   {14243, -8098},   {14231, -8119},   {14218, -8141},   {14206, -8163},   {14193, -8185},
    {14181, -8207},   {14168, -8228},   {14155, -8250},   {14143, -8272},   {14130, -8293},   {14117, -8315},
    {14104, -8337},   {14092, -8358},   {14079, -8380},   {14066, -8401},   {14053, -8423},   {14040, -8445},
    {14027, -8466},   {14014, -8488},   {14001, -8509},   {13988, -8531},   {13975, -8552},   {13962, -8573},
    {13949, -8595},   {13935, -8616},   {13922, -8638},   {13909, -8659},   {13896, -8680},   {13882, -8702},
    {13869, -8723},   {13856, -8744},   {13842, -8765},   {13829, -8787},   {13815, -8808},   {13802, -8829},
    {13788, -8850},   {13774, -8871},   {13761, -8892},   {13747, -8914},   {13733, -8935},   {13720, -8956},
    {13706, -8977},   {13692, -8998},   {13678, -9019},   {13665, -9040},   {13651, -9061},   {13637, -9082},
    {13623, -9102},   {13609, -9123},   {13595, -9144},   {13581, -9165},   {13567, -9186},   {13553, -9207},
    {13538, -9227},   {13524, -9248},   {13510, -9269},   {13496, -9290},   {13482, -9310},   {13467, -9331},
    {13453, -9352},   {13439, -9372},   {13424, -9393},   {13410, -9413},   {13395, -9434},   {13381, -9455},
    {13366, -9475},   {13352, -9496},   {13337, -9516},   {13323, -9537},   {13308, -9557},   {13293, -9577},
    {13279, -9598},   {13264, -9618},   {13249, -9638},   {13234, -9659},   {13219, -9679},   {13205, -9699},
    {13190, -9720},   {13175, -9740},   {13160, -9760},   {13145, -9780},   {13130, -9800},   {13115, -9820},
    {13100, -9841},   {13085, -9861},   {13069, -9881},   {13054, -9901},   {13039, -9921},   {13024, -9941},
    {13008, -9961},   {12993, -9981},   {12978, -10001},  {12963, -10020},  {12947, -10040},  {12932, -10060},
    {12916, -10080},  {12901, -10100},  {12885, -10120},  {12870, -10139},  {12854, -10159},  {12839, -10179},
    {12823, -10198},  {12807, -10218},  {12792, -10238},  {12776, -10257},  {12760, -10277},  {12744, -10296},
    {12729, -10316},  {12713, -10336},  {12697, -10355},  {12681, -10374},  {12665, -10394},  {12649, -10413},
    {12633, -10433},  {12617, -10452},  {12601, -10471},  {12585, -10491},  {12569, -10510},  {12553, -10529},
    {12537, -10549},  {12520, -10568},  {12504, -10587},  {12488, -10606},  {12472, -10625},  {12455, -10644},
    {12439, -10663},  {12423, -10683},  {12406, -10702},  {12390, -10721},  {12373, -10740},  {12357, -10759},
    {12340, -10778},  {12324, -10796},  {12307, -10815},  {12290, -10834},  {12274, -10853},  {12257, -10872},
    {12240, -10891},  {12224, -10909},  {12207, -10928},  {12190, -10947},  {12173, -10966},  {12157, -10984},
    {12140, -11003},  {12123, -11021},  {12106, -11040},  {12089, -11059},  {12072, -11077},  {12055, -11096},
    {12038, -11114},  {12021, -11133},  {12004, -11151},  {11987, -11169},  {11970, -11188},  {11952, -11206},
    {11935, -11224},  {11918, -11243},  {11901, -11261},  {11883, -11279},  {11866, -11297},  {11849, -11316},
    {11831, -11334},  {11814, -11352},  {11797, -11370},  {11779, -11388},  {11762, -11406},  {11744, -11424},
    {11727, -11442},  {11709, -11460},  {11691, -11478},  {11674, -11496},  {11656, -11514},  {11638, -11532},
    {11621, -11550},  {11603, -11567},  {11585, -11585},  {11567, -11603},  {11550, -11621},  {11532, -11638},
    {11514, -11656},  {11496, -11674},  {11478, -11691},  {11460, -11709},  {11442, -11727},  {11424, -11744},
    {11406, -11762},  {11388, -11779},  {11370, -11797},  {11352, -11814},  {11334, -11831},  {11316, -11849},
    {11297, -11866},  {11279, -11883},  {11261, -11901},  {11243, -11918},  {11224, -11935},  {11206, -11952},
    {11188, -11970},  {11169, -11987},  {11151, -12004},  {11133, -12021},  {11114, -12038},  {11096, -12055},
    {11077, -12072},  {11059, -12089},  {11040, -12106},  {11021, -12123},  {11003, -12140},  {10984, -12157},
    {10966, -12173},  {10947, -12190},  {10928, -12207},  {10909, -12224},  {10891, -12240},  {10872, -12257},
    {10853, -12274},  {10834, -12290},  {10815, -12307},  {10796, -12324},  {10778, -12340},  {10759, -12357},
    {10740, -12373},  {10721, -12390},  {10702, -12406},  {10683, -12423},  {10663, -12439},  {10644, -12455},
    {10625, -12472},  {10606, -12488},  {10587, -12504},  {10568, -12520},  {10549, -12537},  {10529, -12553},
    {10510, -12569},  {10491, -12585},  {10471, -12601},  {10452, -12617},  {10433, -12633},  {10413, -12649},
    {10394, -12665},  {10374, -12681},  {10355, -12697},  {10336, -12713},  {10316, -12729},  {10296, -12744},
    {10277, -12760},  {10257, -12776},  {10238, -12792},  {10218, -12807},  {10198, -12823},  {10179, -12839},
    {10159, -12854},  {10139, -12870},  {10120, -12885},  {10100, -12901},  {10080, -12916},  {10060, -12932},
    {10040, -12947},  {10020, -12963},  {10001, -12978},  {9981, -12993},   {9961, -13008},   {9941, -13024},
    {9921, -13039},   {9901, -13054},   {9881, -13069},   {9861, -13085},   {9841, -13100},   {9820, -13115},
    {9800, -13130},   {9780, -13145},   {9760, -13160},   {9740, -13175},   {9720, -13190},   {9699, -13205},
    {9679, -13219},   {9659, -13234},   {9638, -13249},   {9618, -13264},   {9598, -13279},   {9577, -13293},
    {9557, -13308},   {9537, -13323},   {9516, -13337},   {9496, -13352},   {9475, -13366},   {9455, -13381},
    {9434, -13395},   {9413, -13410},   {9393, -13424},   {9372, -13439},   {9352, -13453},   {9331, -13467},
    {9310, -13482},   {9290, -13496},   {9269, -13510},   {9248, -13524},   {9227, -13538},   {9207, -13553},
    {9186, -13567},   {9165, -13581},   {9144, -13595},   {9123, -13609},   {9102, -13623},   {9082, -13637},
    {9061, -13651},   {9040, -13665},   {9019, -13678},   {8998, -13692},   {8977, -13706},   {8956, -13720},
    {8935, -13733},   {8914, -13747},   {8892, -13761},   {8871, -13774},   {8850, -13788},   {8829, -13802},
    {8808, -13815},   {8787, -13829},   {8765, -13842},   {8744, -13856},   {8723, -13869},   {8702, -13882},
    {8680, -13896},   {8659, -13909},   {8638, -13922},   {8616, -13935},   {8595, -13949},   {8573, -13962},
    {8552, -13975},   {8531, -13988},   {8509, -14001},   {8488, -14014},   {8466, -14027},   {8445, -14040},
    {8423, -14053},   {8401, -14066},   {8380, -14079},   {8358, -14092},   {8337, -14104},   {8315, -14117},
    {8293, -14130},   {8272, -14143},   {8250, -14155},   {8228, -14168},   {8207, -14181},   {8185, -14193},
    {8163, -14206},   {8141, -14218},   {8119, -14231},   {8098, -14243},   {8076, -14256},   {8054, -14268},
    {8032, -14280},   {8010, -14293},   {7988, -14305},   {7966, -14317},   {7944, -14329},   {7922, -14341},
    {7900, -14354},   {7878, -14366},   {7856, -14378},   {7834, -14390},   {7812, -14402},   {7790, -14414},
    {7768, -14426},   {7746, -14438},   {7723, -14449},   {7701, -14461},   {7679, -14473},   {7657, -14485},
    {7635, -14497},   {7612, -14508},   {7590, -14520},   {7568, -14531},   {7545, -14543},   {7523, -14555},
    {7501, -14566},   {7478, -14578},   {7456, -14589},   {7434, -14601},   {7411, -14612},   {7389, -14623},
    {7366, -14635},   {7344, -14646},   {7321, -14657},   {7299, -14668},   {7276, -14680},   {7254, -14691},
    {7231, -14702},   {7209, -14713},   {7186, -14724},   {7164, -14735},   {7141, -14746},   {7118, -14757},
    {7096, -14768},   {7073, -14779},   {7050, -14789},   {7028, -14800},   {7005, -14811},   {6982, -14822},
    {6960, -14832},   {6937, -14843},   {6914, -14854},   {6891, -14864},   {6868, -14875},   {6846, -14885},
    {6823, -14896},   {6800, -14906},   {6777, -14917},   {6754, -14927},   {6731, -14937},   {6708, -14948},
    {6685, -14958},   {6662, -14968},   {6639, -14978},   {6616, -14989},   {6593, -14999},   {6570, -15009},
    {6547, -15019},   {6524, -15029},   {6501, -15039},   {6478, -15049},   {6455, -15059},   {6432, -15069},
    {6409, -15078},   {6386, -15088},   {6363, -15098},   {6339, -15108},   {6316, -15118},   {6293, -15127},
    {6270, -15137},   {6247, -15146},   {6223, -15156},   {6200, -15166},   {6177, -15175},   {6154, -15184},
    {6130, -15194},   {6107, -15203},   {6084, -15213},   {6060, -15222},   {6037, -15231},   {6014, -15240},
    {5990, -15250},   {5967, -15259},   {5943, -15268},   {5920, -15277},   {5897, -15286},   {5873, -15295},
    {5850, -15304},   {5826, -15313},   {5803, -15322},   {5779, -15331},   {5756, -15340},   {5732, -15349},
    {5708, -15357},   {5685, -15366},   {5661, -15375},   {5638, -15383},   {5614, -15392},   {5591, -15401},
    {5567, -15409},   {5543, -15418},   {5520, -15426},   {5496, -15435},   {5472, -15443},   {5449, -15451},
    {5425, -15460},   {5401, -15468},   {5377, -15476},   {5354, -15485},   {5330, -15493},   {5306, -15501},
    {5282, -15509},   {5259, -15517},   {5235, -15525},   {5211, -15533},   {5187, -15541},   {5163, -15549},
    {5139, -15557},   {5115, -15565},   {5092, -15573},   {5068, -15581},   {5044, -15588},   {5020, -15596},
    {4996, -15604},   {4972, -15611},   {4948, -15619},   {4924, -15627},   {4900, -15634},   {4876, -15642},
    {4852, -15649},   {4828, -15656},   {4804, -15664},   {4780, -15671},   {4756, -15679},   {4732, -15686},
    {4708, -15693},   {4684, -15700},   {4660, -15707},   {4636, -15715},   {4612, -15722},   {4587, -15729},
    {4563, -15736},   {4539, -15743},   {4515, -15750},   {4491, -15757},   {4467, -15763},   {4442, -15770},
    {4418, -15777},   {4394, -15784},   {4370, -15791},   {4346, -15797},   {4321, -15804},   {4297, -15810},
    {4273, -15817},   {4249, -15824},   {4224, -15830},   {4200, -15837},   {4176, -15843},   {4151, -15849},
    {4127, -15856},   {4103, -15862},   {4078, -15868},   {4054, -15875},   {4030, -15881},   {4005, -15887},
    {3981, -15893},   {3957, -15899},   {3932, -15905},   {3908, -15911},   {3883, -15917},   {3859, -15923},
    {3835, -15929},   {3810, -15935},   {3786, -15941},   {3761, -15946},   {3737, -15952},   {3712, -15958},
    {3688, -15964},   {3663, -15969},   {3639, -15975},   {3614, -15980},   {3590, -15986},   {3565, -15991},
    {3541, -15997},   {3516, -16002},   {3492, -16008},   {3467, -16013},   {3442, -16018},   {3418, -16024},
    {3393, -16029},   {3369, -16034},   {3344, -16039},   {3320, -16044},   {3295, -16049},   {3270, -16054},
    {3246, -16059},   {3221, -16064},   {3196, -16069},   {3172, -16074},   {3147, -16079},   {3122, -16084},
    {3098, -16088},   {3073, -16093},   {3048, -16098},   {3024, -16103},   {2999, -16107},   {2974, -16112},
    {2949, -16116},   {2925, -16121},   {2900, -16125},   {2875, -16130},   {2851, -16134},   {2826, -16138},
    {2801, -16143},   {2776, -16147},   {2752, -16151},   {2727, -16156},   {2702, -16160},   {2677, -16164},
    {2652, -16168},   {2628, -16172},   {2603, -16176},   {2578, -16180},   {2553, -16184},   {2528, -16188},
    {2503, -16192},   {2479, -16195},   {2454, -16199},   {2429, -16203},   {2404, -16207},   {2379, -16210},
    {2354, -16214},   {2329, -16218},   {2305, -16221},   {2280, -16225},   {2255, -16228},   {2230, -16232},
    {2205, -16235},   {2180, -16238},   {2155, -16242},   {2130, -16245},   {2105, -16248},   {2080, -16251},
    {2055, -16255},   {2031, -16258},   {2006, -16261},   {1981, -16264},   {1956, -16267},   {1931, -16270},
    {1906, -16273},   {1881, -16276},   {1856, -16279},   {1831, -16281},   {1806, -16284},   {1781, -16287},
    {1756, -16290},   {1731, -16292},   {1706, -16295},   {1681, -16298},   {1656, -16300},   {1631, -16303},
    {1606, -16305},   {1581, -16308},   {1556, -16310},   {1531, -16312},   {1506, -16315},   {1481, -16317},
    {1456, -16319},   {1431, -16321},   {1406, -16324},   {1381, -16326},   {1356, -16328},   {1331, -16330},
    {1306, -16332},   {1280, -16334},   {1255, -16336},   {1230, -16338},   {1205, -16340},   {1180, -16341},
    {1155, -16343},   {1130, -16345},   {1105, -16347},   {1080, -16348},   {1055, -16350},   {1030, -16352},
    {1005, -16353},   {980, -16355},    {955, -16356},    {929, -16358},    {904, -16359},    {879, -16360},
    {854, -16362},    {829, -16363},    {804, -16364},    {779, -16365},    {754, -16367},    {729, -16368},
    {704, -16369},    {678, -16370},    {653, -16371},    {628, -16372},    {603, -16373},    {578, -16374},
    {553, -16375},    {528, -16375},    {503, -16376},    {477, -16377},    {452, -16378},    {427, -16378},
    {402, -16379},    {377, -16380},    {352, -16380},    {327, -16381},    {302, -16381},    {276, -16382},
    {251, -16382},    {226, -16382},    {201, -16383},    {176, -16383},    {151, -16383},    {126, -16384},
    {101, -16384},    {75, -16384},     {50, -16384},     {25, -16384},     {0, -16384},      {-25, -16384},
    {-50, -16384},    {-75, -16384},    {-101, -16384},   {-126, -16384},   {-151, -16383},   {-176, -16383},
    {-201, -16383},   {-226, -16382},   {-251, -16382},   {-276, -16382},   {-302, -16381},   {-327, -16381},
    {-352, -16380},   {-377, -16380},   {-402, -16379},   {-427, -16378},   {-452, -16378},   {-477, -16377},
    {-503, -16376},   {-528, -16375},   {-553, -16375},   {-578, -16374},   {-603, -16373},   {-628, -16372},
    {-653, -16371},   {-678, -16370},   {-704, -16369},   {-729, -16368},   {-754, -16367},   {-779, -16365},
    {-804, -16364},   {-829, -16363},   {-854, -16362},   {-879, -16360},   {-904, -16359},   {-929, -16358},
    {-955, -16356},   {-980, -16355},   {-1005, -16353},  {-1030, -16352},  {-1055, -16350},  {-1080, -16348},
    {-1105, -16347},  {-1130, -16345},  {-1155, -16343},  {-1180, -16341},  {-1205, -16340},  {-1230, -16338},
    {-1255, -16336},  {-1280, -16334},  {-1306, -16332},  {-1331, -16330},  {-1356, -16328},  {-1381, -16326},
    {-1406, -16324},  {-1431, -16321},  {-1456, -16319},  {-1481, -16317},  {-1506, -16315},  {-1531, -16312},
    {-1556, -16310},  {-1581, -16308},  {-1606, -16305},  {-1631, -16303},  {-1656, -16300},  {-1681, -16298},
    {-1706, -16295},  {-1731, -16292},  {-1756, -16290},  {-1781, -16287},  {-1806, -16284},  {-1831, -16281},
    {-1856, -16279},  {-1881, -16276},  {-1906, -16273},  {-1931, -16270},  {-1956, -16267},  {-1981, -16264},
    {-2006, -16261},  {-2031, -16258},  {-2055, -16255},  {-2080, -16251},  {-2105, -16248},  {-2130, -16245},
    {-2155, -16242},  {-2180, -16238},  {-2205, -16235},  {-2230, -16232},  {-2255, -16228},  {-2280, -16225},
    {-2305, -16221},  {-2329, -16218},  {-2354, -16214},  {-2379, -16210},  {-2404, -16207},  {-2429, -16203},
    {-2454, -16199},  {-2479, -16195},  {-2503, -16192},  {-2528, -16188},  {-2553, -16184},  {-2578, -16180},
    {-2603, -16176},  {-2628, -16172},  {-2652, -16168},  {-2677, -16164},  {-2702, -16160},  {-2727, -16156},
    {-2752, -16151},  {-2776, -16147},  {-2801, -16143},  {-2826, -16138},  {-2851, -16134},  {-2875, -16130},
    {-2900, -16125},  {-2925, -16121},  {-2949, -16116},  {-2974, -16112},  {-2999, -16107},  {-3024, -16103},
    {-3048, -16098},  {-3073, -16093},  {-3098, -16088},  {-3122, -16084},  {-3147, -16079},  {-3172, -16074},
    {-3196, -16069},  {-3221, -16064},  {-3246, -16059},  {-3270, -16054},  {-3295, -16049},  {-3320, -16044},
    {-3344, -16039},  {-3369, -16034},  {-3393, -16029},  {-3418, -16024},  {-3442, -16018},  {-3467, -16013},
    {-3492, -16008},  {-3516, -16002},  {-3541, -15997},  {-3565, -15991},  {-3590, -15986},  {-3614, -15980},
    {-3639, -15975},  {-3663, -15969},  {-3688, -15964},  {-3712, -15958},  {-3737, -15952},  {-3761, -15946},
    {-3786, -15941},  {-3810, -15935},  {-3835, -15929},  {-3859, -15923},  {-3883, -15917},  {-3908, -15911},
    {-3932, -15905},  {-3957, -15899},  {-3981, -15893},  {-4005, -15887},  {-4030, -15881},  {-4054, -15875},
    {-4078, -15868},  {-4103, -15862},  {-4127, -15856},  {-4151, -15849},  {-4176, -15843},  {-4200, -15837},
    {-4224, -15830},  {-4249, -15824},  {-4273, -15817},  {-4297, -15810},  {-4321, -15804},  {-4346, -15797},
    {-4370, -15791},  {-4394, -15784},  {-4418, -15777},  {-4442, -15770},  {-4467, -15763},  {-4491, -15757},
    {-4515, -15750},  {-4539, -15743},  {-4563, -15736},  {-4587, -15729},  {-4612, -15722},  {-4636, -15715},
    {-4660, -15707},  {-4684, -15700},  {-4708, -15693},  {-4732, -15686},  {-4756, -15679},  {-4780, -15671},
    {-4804, -15664},  {-4828, -15656},  {-4852, -15649},  {-4876, -15642},  {-4900, -15634},  {-4924, -15627},
    {-4948, -15619},  {-4972, -15611},  {-4996, -15604},  {-5020, -15596},  {-5044, -15588},  {-5068, -15581},
    {-5092, -15573},  {-5115, -15565},  {-5139, -15557},  {-5163, -15549},  {-5187, -15541},  {-5211, -15533},
    {-5235, -15525},  {-5259, -15517},  {-5282, -15509},  {-5306, -15501},  {-5330, -15493},  {-5354, -15485},
    {-5377, -15476},  {-5401, -15468},  {-5425, -15460},  {-5449, -15451},  {-5472, -15443},  {-5496, -15435},
    {-5520, -15426},  {-5543, -15418},  {-5567, -15409},  {-5591, -15401},  {-5614, -15392},  {-5638, -15383},
    {-5661, -15375},  {-5685, -15366},  {-5708, -15357},  {-5732, -15349},  {-5756, -15340},  {-5779, -15331},
    {-5803, -15322},  {-5826, -15313},  {-5850, -15304},  {-5873, -15295},  {-5897, -15286},  {-5920, -15277},
    {-5943, -15268},  {-5967, -15259},  {-5990, -15250},  {-6014, -15240},  {-6037, -15231},  {-6060, -15222},
    {-6084, -15213},  {-6107, -15203},  {-6130, -15194},  {-6154, -15184},  {-6177, -15175},  {-6200, -15166},
    {-6223, -15156},  {-6247, -15146},  {-6270, -15137},  {-6293, -15127},  {-6316, -15118},  {-6339, -15108},
    {-6363, -15098},  {-6386, -15088},  {-6409, -15078},  {-6432, -15069},  {-6455, -15059},  {-6478, -15049},
    {-6501, -15039},  {-6524, -15029},  {-6547, -15019},  {-6570, -15009},  {-6593, -14999},  {-6616, -14989},
    {-6639, -14978},  {-6662, -14968},  {-6685, -14958},  {-6708, -14948},  {-6731, -14937},  {-6754, -14927},
    {-6777, -14917},  {-6800, -14906},  {-6823, -14896},  {-6846, -14885},  {-6868, -14875},  {-6891, -14864},
    {-6914, -14854},  {-6937, -14843},  {-6960, -14832},  {-6982, -14822},  {-7005, -14811},  {-7028, -14800},
    {-7050, -14789},  {-7073, -14779},  {-7096, -14768},  {-7118, -14757},  {-7141, -14746},  {-7164, -14735},
    {-7186, -14724},  {-7209, -14713},  {-7231, -14702},  {-7254, -14691},  {-7276, -14680},  {-7299, -14668},
    {-7321, -14657},  {-7344, -14646},  {-7366, -14635},  {-7389, -14623},  {-7411, -14612},  {-7434, -14601},
    {-7456, -14589},  {-7478, -14578},  {-7501, -14566},  {-7523, -14555},  {-7545, -14543},  {-7568, -14531},
    {-7590, -14520},  {-7612, -14508},  {-7635, -14497},  {-7657, -14485},  {-7679, -14473},  {-7701, -14461},
    {-7723, -14449},  {-7746, -14438},  {-7768, -14426},  {-7790, -14414},  {-7812, -14402},  {-7834, -14390},
    {-7856, -14378},  {-7878, -14366},  {-7900, -14354},  {-7922, -14341},  {-7944, -14329},  {-7966, -14317},
    {-7988, -14305},  {-8010, -14293},  {-8032, -14280},  {-8054, -14268},  {-8076, -14256},  {-8098, -14243},
    {-8119, -14231},  {-8141, -14218},  {-8163, -14206},  {-8185, -14193},  {-8207, -14181},  {-8228, -14168},
    {-8250, -14155},  {-8272, -14143},  {-8293, -14130},  {-8315, -14117},  {-8337, -14104},  {-8358, -14092},
    {-8380, -14079},  {-8401, -14066},  {-8423, -14053},  {-8445, -14040},  {-8466, -14027},  {-8488, -14014},
    {-8509, -14001},  {-8531, -13988},  {-8552, -13975},  {-8573, -13962},  {-8595, -13949},  {-8616, -13935},
    {-8638, -13922},  {-8659, -13909},  {-8680, -13896},  {-8702, -13882},  {-8723, -13869},  {-8744, -13856},
    {-8765, -13842},  {-8787, -13829},  {-8808, -13815},  {-8829, -13802},  {-8850, -13788},  {-8871, -13774},
    {-8892, -13761},  {-8914, -13747},  {-8935, -13733},  {-8956, -13720},  {-8977, -13706},  {-8998, -13692},
    {-9019, -13678},  {-9040, -13665},  {-9061, -13651},  {-9082, -13637},  {-9102, -13623},  {-9123, -13609},
    {-9144, -13595},  {-9165, -13581},  {-9186, -13567},  {-9207, -13553},  {-9227, -13538},  {-9248, -13524},
    {-9269, -13510},  {-9290, -13496},  {-9310, -13482},  {-9331, -13467},  {-9352, -13453},  {-9372, -13439},
    {-9393, -13424},  {-9413, -13410},  {-9434, -13395},  {-9455, -13381},  {-9475, -13366},  {-9496, -13352},
    {-9516, -13337},  {-9537, -13323},  {-9557, -13308},  {-9577, -13293},  {-9598, -13279},  {-9618, -13264},
    {-9638, -13249},  {-9659, -13234},  {-9679, -13219},  {-9699, -13205},  {-9720, -13190},  {-9740, -13175},
    {-9760, -13160},  {-9780, -13145},  {-9800, -13130},  {-9820, -13115},  {-9841, -13100},  {-9861, -13085},
    {-9881, -13069},  {-9901, -13054},  {-9921, -13039},  {-9941, -13024},  {-9961, -13008},  {-9981, -12993},
    {-10001, -12978}, {-10020, -12963}, {-10040, -12947}, {-10060, -12932}, {-10080, -12916}, {-10100, -12901},
    {-10120, -12885}, {-10139, -12870}, {-10159, -12854}, {-10179, -12839}, {-10198, -12823}, {-10218, -12807},
    {-10238, -12792}, {-10257, -12776}, {-10277, -12760}, {-10296, -12744}, {-10316, -12729}, {-10336, -12713},
    {-10355, -12697}, {-10374, -12681}, {-10394, -12665}, {-10413, -12649}, {-10433, -12633}, {-10452, -12617},
    {-10471, -12601}, {-10491, -12585}, {-10510, -12569}, {-10529, -12553}, {-10549, -12537}, {-10568, -12520},
    {-10587, -12504}, {-10606, -12488}, {-10625, -12472}, {-10644, -12455}, {-10663, -12439}, {-10683, -12423},
    {-10702, -12406}, {-10721, -12390}, {-10740, -12373}, {-10759, -12357}, {-10778, -12340}, {-10796, -12324},
    {-10815, -12307}, {-10834, -12290}, {-10853, -12274}, {-10872, -12257}, {-10891, -12240}, {-10909, -12224},
    {-10928, -12207}, {-10947, -12190}, {-10966, -12173}, {-10984, -12157}, {-11003, -12140}, {-11021, -12123},
    {-11040, -12106}, {-11059, -12089}, {-11077, -12072}, {-11096, -12055}, {-11114, -12038}, {-11133, -12021},
    {-11151, -12004}, {-11169, -11987}, {-11188, -11970}, {-11206, -11952}, {-11224, -11935}, {-11243, -11918},
    {-11261, -11901}, {-11279, -11883}, {-11297, -11866}, {-11316, -11849}, {-11334, -11831}, {-11352, -11814},
    {-11370, -11797}, {-11388, -11779}, {-11406, -11762}, {-11424, -11744}, {-11442, -11727}, {-11460, -11709},
    {-11478, -11691}, {-11496, -11674}, {-11514, -11656}, {-11532, -11638}, {-11550, -11621}, {-11567, -11603},
    {-11585, -11585}, {-11603, -11567}, {-11621, -11550}, {-11638, -11532}, {-11656, -11514}, {-11674, -11496},
    {-11691, -11478}, {-11709, -11460}, {-11727, -11442}, {-11744, -11424}, {-11762, -11406}, {-11779, -11388},
    {-11797, -11370}, {-11814, -11352}, {-11831, -11334}, {-11849, -11316}, {-11866, -11297}, {-11883, -11279},
    {-11901, -11261}, {-11918, -11243}, {-11935, -11224}, {-11952, -11206}, {-11970, -11188}, {-11987, -11169},
    {-12004, -11151}, {-12021, -11133}, {-12038, -11114}, {-12055, -11096}, {-12072, -11077}, {-12089, -11059},
    {-12106, -11040}, {-12123, -11021}, {-12140, -11003}, {-12157, -10984}, {-12173, -10966}, {-12190, -10947},
    {-12207, -10928}, {-12224, -10909}, {-12240, -10891}, {-12257, -10872}, {-12274, -10853}, {-12290, -10834},
    {-12307, -10815}, {-12324, -10796}, {-12340, -10778}, {-12357, -10759}, {-12373, -10740}, {-12390, -10721},
    {-12406, -10702}, {-12423, -10683}, {-12439, -10663}, {-12455, -10644}, {-12472, -10625}, {-12488, -10606},
    {-12504, -10587}, {-12520, -10568}, {-12537, -10549}, {-12553, -10529}, {-12569, -10510}, {-12585, -10491},
    {-12601, -10471}, {-12617, -10452}, {-12633, -10433}, {-12649, -10413}, {-12665, -10394}, {-12681, -10374},
    {-12697, -10355}, {-12713, -10336}, {-12729, -10316}, {-12744, -10296}, {-12760, -10277}, {-12776, -10257},
    {-12792, -10238}, {-12807, -10218}, {-12823, -10198}, {-12839, -10179}, {-12854, -10159}, {-12870, -10139},
    {-12885, -10120}, {-12901, -10100}, {-12916, -10080}, {-12932, -10060}, {-12947, -10040}, {-12963, -10020},
    {-12978, -10001}, {-12993, -9981},  {-13008, -9961},  {-13024, -9941},  {-13039, -9921},  {-13054, -9901},
    {-13069, -9881},  {-13085, -9861},  {-13100, -9841},  {-13115, -9820},  {-13130, -9800},  {-13145, -9780},
    {-13160, -9760},  {-13175, -9740},  {-13190, -9720},  {-13205, -9699},  {-13219, -9679},  {-13234, -9659},
    {-13249, -9638},  {-13264, -9618},  {-13279, -9598},  {-13293, -9577},  {-13308, -9557},  {-13323, -9537},
    {-13337, -9516},  {-13352, -9496},  {-13366, -9475},  {-13381, -9455},  {-13395, -9434},  {-13410, -9413},
    {-13424, -9393},  {-13439, -9372},  {-13453, -9352},  {-13467, -9331},  {-13482, -9310},  {-13496, -9290},
    {-13510, -9269},  {-13524, -9248},  {-13538, -9227},  {-13553, -9207},  {-13567, -9186},  {-13581, -9165},
    {-13595, -9144},  {-13609, -9123},  {-13623, -9102},  {-13637, -9082},  {-13651, -9061},  {-13665, -9040},
    {-13678, -9019},  {-13692, -8998},  {-13706, -8977},  {-13720, -8956},  {-13733, -8935},  {-13747, -8914},
    {-13761, -8892},  {-13774, -8871},  {-13788, -8850},  {-13802, -8829},  {-13815, -8808},  {-13829, -8787},
    {-13842, -8765},  {-13856, -8744},  {-13869, -8723},  {-13882, -8702},  {-13896, -8680},  {-13909, -8659},
    {-13922, -8638},  {-13935, -8616},  {-13949, -8595},  {-13962, -8573},  {-13975, -8552},  {-13988, -8531},
    {-14001, -8509},  {-14014, -8488},  {-14027, -8466},  {-14040, -8445},  {-14053, -8423},  {-14066, -8401},
    {-14079, -8380},  {-14092, -8358},  {-14104, -8337},  {-14117, -8315},  {-14130, -8293},  {-14143, -8272},
    {-14155, -8250},  {-14168, -8228},  {-14181, -8207},  {-14193, -8185},  {-14206, -8163},  {-14218, -8141},
    {-14231, -8119},  {-14243, -8098},  {-14256, -8076},  {-14268, -8054},  {-14280, -8032},  {-14293, -8010},
    {-14305, -7988},  {-14317, -7966},  {-14329, -7944},  {-14341, -7922},  {-14354, -7900},  {-14366, -7878},
    {-14378, -7856},  {-14390, -7834},  {-14402, -7812},  {-14414, -7790},  {-14426, -7768},  {-14438, -7746},
    {-14449, -7723},  {-14461, -7701},  {-14473, -7679},  {-14485, -7657},  {-14497, -7635},  {-14508, -7612},
    {-14520, -7590},  {-14531, -7568},  {-14543, -7545},  {-14555, -7523},  {-14566, -7501},  {-14578, -7478},
    {-14589, -7456},  {-14601, -7434},  {-14612, -7411},  {-14623, -7389},  {-14635, -7366},  {-14646, -7344},
    {-14657, -7321},  {-14668, -7299},  {-14680, -7276},  {-14691, -7254},  {-14702, -7231},  {-14713, -7209},
    {-14724, -7186},  {-14735, -7164},  {-14746, -7141},  {-14757, -7118},  {-14768, -7096},  {-14779, -7073},
    {-14789, -7050},  {-14800, -7028},  {-14811, -7005},  {-14822, -6982},  {-14832, -6960},  {-14843, -6937},
    {-14854, -6914},  {-14864, -6891},  {-14875, -6868},  {-14885, -6846},  {-14896, -6823},  {-14906, -6800},
    {-14917, -6777},  {-14927, -6754},  {-14937, -6731},  {-14948, -6708},  {-14958, -6685},  {-14968, -6662},
    {-14978, -6639},  {-14989, -6616},  {-14999, -6593},  {-15009, -6570},  {-15019, -6547},  {-15029, -6524},
    {-15039, -6501},  {-15049, -6478},  {-15059, -6455},  {-15069, -6432},  {-15078, -6409},  {-15088, -6386},
    {-15098, -6363},  {-15108, -6339},  {-15118, -6316},  {-15127, -6293},  {-15137, -6270},  {-15146, -6247},
    {-15156, -6223},  {-15166, -6200},  {-15175, -6177},  {-15184, -6154},  {-15194, -6130},  {-15203, -6107},
    {-15213, -6084},  {-15222, -6060},  {-15231, -6037},  {-15240, -6014},  {-15250, -5990},  {-15259, -5967},
    {-15268, -5943},  {-15277, -5920},  {-15286, -5897},  {-15295, -5873},  {-15304, -5850},  {-15313, -5826},
    {-15322, -5803},  {-15331, -5779},  {-15340, -5756},  {-15349, -5732},  {-15357, -5708},  {-15366, -5685},
    {-15375, -5661},  {-15383, -5638},  {-15392, -5614},  {-15401, -5591},  {-15409, -5567},  {-15418, -5543},
    {-15426, -5520},  {-15435, -5496},  {-15443, -5472},  {-15451, -5449},  {-15460, -5425},  {-15468, -5401},
    {-15476, -5377},  {-15485, -5354},  {-15493, -5330},  {-15501, -5306},  {-15509, -5282},  {-15517, -5259},
    {-15525, -5235},  {-15533, -5211},  {-15541, -5187},  {-15549, -5163},  {-15557, -5139},  {-15565, -5115},
    {-15573, -5092},  {-15581, -5068},  {-15588, -5044},  {-15596, -5020},  {-15604, -4996},  {-15611, -4972},
    {-15619, -4948},  {-15627, -4924},  {-15634, -4900},  {-15642, -4876},  {-15649, -4852},  {-15656, -4828},
    {-15664, -4804},  {-15671, -4780},  {-15679, -4756},  {-15686, -4732},  {-15693, -4708},  {-15700, -4684},
    {-15707, -4660},  {-15715, -4636},  {-15722, -4612},  {-15729, -4587},  {-15736, -4563},  {-15743, -4539},
    {-15750, -4515},  {-15757, -4491},  {-15763, -4467},  {-15770, -4442},  {-15777, -4418},  {-15784, -4394},
    {-15791, -4370},  {-15797, -4346},  {-15804, -4321},  {-15810, -4297},  {-15817, -4273},  {-15824, -4249},
    {-15830, -4224},  {-15837, -4200},  {-15843, -4176},  {-15849, -4151},  {-15856, -4127},  {-15862, -4103},
    {-15868, -4078},  {-15875, -4054},  {-15881, -4030},  {-15887, -4005},  {-15893, -3981},  {-15899, -3957},
    {-15905, -3932},  {-15911, -3908},  {-15917, -3883},  {-15923, -3859},  {-15929, -3835},  {-15935, -3810},
    {-15941, -3786},  {-15946, -3761},  {-15952, -3737},  {-15958, -3712},  {-15964, -3688},  {-15969, -3663},
    {-15975, -3639},  {-15980, -3614},  {-15986, -3590},  {-15991, -3565},  {-15997, -3541},  {-16002, -3516},
    {-16008, -3492},  {-16013, -3467},  {-16018, -3442},  {-16024, -3418},  {-16029, -3393},  {-16034, -3369},
    {-16039, -3344},  {-16044, -3320},  {-16049, -3295},  {-16054, -3270},  {-16059, -3246},  {-16064, -3221},
    {-16069, -3196},  {-16074, -3172},  {-16079, -3147},  {-16084, -3122},  {-16088, -3098},  {-16093, -3073},
    {-16098, -3048},  {-16103, -3024},  {-16107, -2999},  {-16112, -2974},  {-16116, -2949},  {-16121, -2925},
    {-16125, -2900},  {-16130, -2875},  {-16134, -2851},  {-16138, -2826},  {-16143, -2801},  {-16147, -2776},
    {-16151, -2752},  {-16156, -2727},  {-16160, -2702},  {-16164, -2677},  {-16168, -2652},  {-16172, -2628},
    {-16176, -2603},  {-16180, -2578},  {-16184, -2553},  {-16188, -2528},  {-16192, -2503},  {-16195, -2479},
    {-16199, -2454},  {-16203, -2429},  {-16207, -2404},  {-16210, -2379},  {-16214, -2354},  {-16218, -2329},
    {-16221, -2305},  {-16225, -2280},  {-16228, -2255},  {-16232, -2230},  {-16235, -2205},  {-16238, -2180},
    {-16242, -2155},  {-16245, -2130},  {-16248, -2105},  {-16251, -2080},  {-16255, -2055},  {-16258, -2031},
    {-16261, -2006},  {-16264, -1981},  {-16267, -1956},  {-16270, -1931},  {-16273, -1906},  {-16276, -1881},
    {-16279, -1856},  {-16281, -1831},  {-16284, -1806},  {-16287, -1781},  {-16290, -1756},  {-16292, -1731},
    {-16295, -1706},  {-16298, -1681},  {-16300, -1656},  {-16303, -1631},  {-16305, -1606},  {-16308, -1581},
    {-16310, -1556},  {-16312, -1531},  {-16315, -1506},  {-16317, -1481},  {-16319, -1456},  {-16321, -1431},
    {-16324, -1406},  {-16326, -1381},  {-16328, -1356},  {-16330, -1331},  {-16332, -1306},  {-16334, -1280},
    {-16336, -1255},  {-16338, -1230},  {-16340, -1205},  {-16341, -1180},  {-16343, -1155},  {-16345, -1130},
    {-16347, -1105},  {-16348, -1080},  {-16350, -1055},  {-16352, -1030},  {-16353, -1005},  {-16355, -980},
    {-16356, -955},   {-16358, -929},   {-16359, -904},   {-16360, -879},   {-16362, -854},   {-16363, -829},
    {-16364, -804},   {-16365, -779},   {-16367, -754},   {-16368, -729},   {-16369, -704},   {-16370, -678},
    {-16371, -653},   {-16372, -628},   {-16373, -603},   {-16374, -578},   {-16375, -553},   {-16375, -528},
    {-16376, -503},   {-16377, -477},   {-16378, -452},   {-16378, -427},   {-16379, -402},   {-16380, -377},
    {-16380, -352},   {-16381, -327},   {-16381, -302},   {-16382, -276},   {-16382, -251},   {-16382, -226},
    {-16383, -201},   {-16383, -176},   {-16383, -151},   {-16384, -126},   {-16384, -101},   {-16384, -75},
    {-16384, -50},    {-16384, -25}};

#endif //__FFT_TWIDDLE_LUT_DIT_ALL_H__
