//<copyright-disclaimer-start>
//  **************************************************************************************************************
//  * © 2026 Advanced Micro Devices, Inc. All rights reserved.                                                   *
//  * DISCLAIMER                                                                                                 *
//  * The information contained herein is for informational purposes only, and is subject to change              *
//  * without notice. While every precaution has been taken in the preparation of this document, it              *
//  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
//  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
//  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
//  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
//  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
//  * hardware, software or other products described herein.  No license, including implied or                   *
//  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
//  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
//  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
//  *                                                                                                            *
//  **************************************************************************************************************
//<copyright-disclaimer-end>

#include <adf.h>
#include "kernels.h"

using namespace adf;

class simpleGraph : public adf::graph {
private:
  kernel first;     
  parameter lut0;

public:
  input_plio in0, in1;
  input_port vectorInput, factorInput; 
  inout_port vectorOutput, factorOutput;
  output_plio out0, out1;
  simpleGraph()
  {
    in0 = input_plio::create(plio_32_bits, "../src/data/input_1.txt");
    in1 = input_plio::create(plio_32_bits, "../src/data/input_1.txt");

    out0 = output_plio::create(plio_32_bits, "data/output_1.txt");
    out1 = output_plio::create(plio_32_bits, "data/output_2.txt");
    
    first = kernel::create(vitis_single_node_templates);
    connect(in0.out[0], first.in[0]); 
    dimensions(first.in[0]) = { 8 };
    //single_buffer(first.in[0]);               //uncomment for single buffer, by default double buffer will be used.
    connect(first.out[0], out0.in[0]);
    dimensions(first.out[0]) = { 8 };

    lut0 = parameter::array (LUT);
    connect<> (lut0, first);

    connect<stream> net2 (in1.out[0], first.in[1]);  //net connections for stream-stream 
    connect<stream> net3 (first.out[1], out1.in[0]);
    
    connect<parameter> (vectorInput, first.in[2]);    //connection for RTP_array
    connect<parameter> (sync(first.inout[0]), vectorOutput);
    
    connect<parameter> (factorInput, first.in[3]);
    connect<parameter> (sync(first.inout[1]), factorOutput);
    
    source(first) = "../src/vitis_single_node_templates.cc";
    
    runtime<ratio>(first) = 0.1;
    }
};

