%//<copyright-disclaimer-start>
%//  **************************************************************************************************************
%//  * © 2026 Advanced Micro Devices, Inc. All rights reserved.                                                   *
%//  * DISCLAIMER                                                                                                 *
%//  * The information contained herein is for informational purposes only, and is subject to change              *
%//  * without notice. While every precaution has been taken in the preparation of this document, it              *
%//  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
%//  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
%//  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
%//  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
%//  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
%//  * hardware, software or other products described herein.  No license, including implied or                   *
%//  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
%//  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
%//  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
%//  *                                                                                                            *
%//  **************************************************************************************************************
%//<copyright-disclaimer-end>

function regression(x86,do_plot)
   if     (nargin == 0) x86 = 1; do_plot = 0;
   elseif (nargin == 1)          do_plot = 0;
   elseif (nargin ~= 2)          error('Incorrect');
   end
   if (x86)
     fir_a = load_aiesim('x86simulator_output/data/fir_o.txt','int',1);
     fft_a = load_aiesim('x86simulator_output/data/fft_o.txt','int',1);
   else
     fir_a = load_aiesim('aiesimulator_output/data/fir_o.txt','int',1);
     fft_a = load_aiesim('aiesimulator_output/data/fft_o.txt','int',1);
   end
   fir_g = load_aiesim('data/fir_o.txt','int',1);
   fft_g = load_aiesim('data/fft_o.txt','int',1);
   if (do_plot == 1)
     if (x86 == 1) tag='x86sim'; else tag='aiesim'; end
     figure;
     A = 2^15*0.6;
     subplot(2,2,1); plot(real(fir_g),'b.-'); hold on; plot(real(fir_a),'r.--'); hold off; axis([1,128,-A,A]);
     xlabel('Sample Index'); ylabel('Real');
     title(sprintf('Filter #1 ''%s'' Output',tag));
     legend('Gold','Actual');
     subplot(2,2,3); plot(imag(fir_g),'b.-'); hold on; plot(imag(fir_a),'r.--'); hold off; axis([1,128,-A,A]);
     xlabel('Sample Index'); ylabel('Imag');
     legend('Gold','Actual');
     subplot(2,2,[2,4]); plot(abs(fft_g),'b.-'); hold on; plot(abs(fft_a),'r.--'); hold off;
     v = axis; axis([1,1024,v(3),v(4)]);
     xlabel('Sample Index'); ylabel('Magnitude');
     title('Spectrum');
     legend('Gold','Actual');
     saveas(gcf,'png/fir1_result.png');
   end
   err_fir = fir_a - fir_g;
   err_fft = fft_a - fft_g(1:numel(fft_a));
   
   if ( max(abs(real(err_fir))) <= 1 && max(abs(imag(err_fir))) <= 1 && ...
        max(abs(real(err_fft))) <= 1 && max(abs(imag(err_fft))) <= 1 )
     fprintf(1,'--- PASSED ---\n');
   else
     fprintf(1,'*** FAILED ***\n');
   end
end

% ------------------------------------------------------------
% Load AIE simulation output file
% ------------------------------------------------------------

function [data] = load_aiesim( fname, dtype, is_complex )

   fid = fopen(fname,'r');
   done = 0;
   data = [];
   while ( done == 0 )
     line = fgets(fid);
     if ( line == -1 )
       done = 1;
     elseif ( strcmp(line(1),'T') == 0 )
       switch dtype
        case 'int',
         if ( is_complex == 1 )
           [X] = sscanf(line,'%d');
           data = [data;complex(X(1:2:end),X(2:2:end))];
         else
            [val] = sscanf(line,'%d');
            data = [data;val];
         end
        case 'double',
         if ( is_complex == 1 )
            [X] = sscanf(line,'%lf');
            data = [data;complex(X(1:2:end),X(2:2:end))];
         else
            [val] = sscanf(line,'%lf');
            data = [data;val];
         end
        otherwise,
         error(sprintf('Unsupported %s',dtype));
       end
     end
   end
end

