# This script will form the basis of a repeatable, scripted build process
# that can be used to generate complete projects. 
#
# While completely scripted, the end result is an Vivado project that can be
# viewed and even manipulated by the Vivado IDE.
#
# This script will
#   - Create a new directory for the build
#      - the name will be build_YYMMDD_HHMMSS where YYMMDD_HHMMSS is the 
#        current time
#   - Change directory into that directory
#   - Create a new Vivado project
#   - Set the main project properties for the target device
#   - Load all the # source files
#   - Set appropriate process properties
#   - Implement the design   
#

# Get the current date/time. The result is a machine readable version of the 
# the date/time (number of seconds since the epoch started)

set time_raw [clock seconds];

# Format the raw time to a date string

set date_string [clock format $time_raw -format "%y%m%d_%H%M%S"]

# Set the directory name to be build_YYMMDD_HHMMSS
set proj_dir "build_$date_string"

# Create the new build directory
puts "Creating build directory $proj_dir"
file mkdir $proj_dir

# The remaining TCL scripts live in this directory. Remember
# the path before we change directories
set script_dir [pwd]
set src_dir    [pwd]/wave_gen/src
set core_dir   [pwd]/wave_gen/cores
set xdc_dir    [pwd]/wave_gen/constraints


# Change directories to the new build directory
puts "Changing directory to $proj_dir"
cd $proj_dir

# Source the script that will create the new project
# source $script_dir/create_proj.tcl

# Source the script that will imports all the files required for the build
# source $script_dir/load_files.tcl

# Source the script that will set all the process properties necessary
# source $script_dir/set_props.tcl

# Source the script that will regenerate the cores and run the implementation
# process
# source $script_dir/implement.tcl
# exit

#<copyright-disclaimer-start>
#  **************************************************************************************************************
#  * © 2026 Advanced Micro Devices, Inc. All rights reserved.                                                   *
#  * DISCLAIMER                                                                                                 *
#  * The information contained herein is for informational purposes only, and is subject to change              *
#  * without notice. While every precaution has been taken in the preparation of this document, it              *
#  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
#  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
#  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
#  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
#  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
#  * hardware, software or other products described herein.  No license, including implied or                   *
#  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
#  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
#  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
#  *                                                                                                            *
#  **************************************************************************************************************
#<copyright-disclaimer-end>
