#
# Constraints for the FPGA.
# KCU105  - Based on: http://xinc/sites/hwcp/board_files/Shared%20Documents/UltraScale/HW-U1-KCU105/REVB/0381556_HW-U1-KCU105_REVB_SCHEMATIC_12092013.PDF

# Inputs:
# Clock input FPGA on SYSCLK_P/N.
#
# MMCM locked, pass, to LEDs
#

# ---------- Inputs ----------

# Oscillator clock inputs
#
create_clock -period 3.33 -name sys_clk_in_p -add [get_ports sys_clk_in_p]
set_property IOSTANDARD LVDS [get_ports sys_clk_in_p]
set_property IOSTANDARD LVDS [get_ports sys_clk_in_n]
set_property PACKAGE_PIN AK16 [get_ports sys_clk_in_n]
set_property PACKAGE_PIN AK17 [get_ports sys_clk_in_p]

# ---------- Outputs ----------
# Pass output
#
set_property IOSTANDARD LVCMOS18 [get_ports gpio_out_pass]
set_property PACKAGE_PIN H27 [get_ports gpio_out_pass]

# leds
#
set_property IOSTANDARD LVCMOS18 [get_ports led]
set_property PACKAGE_PIN P25 [get_ports led]


#--------------------------------------------------------
# FMC outputs
#--------------------------------------------------------
set_property PACKAGE_PIN V26 [get_ports {fmc_out[0]}]
set_property IOSTANDARD LVCMOS18 [get_ports {fmc_out[0]}]

set_property PACKAGE_PIN W26 [get_ports {fmc_out[1]}]
set_property IOSTANDARD LVCMOS18 [get_ports {fmc_out[1]}]


#<copyright-disclaimer-start>
#  **************************************************************************************************************
#  * © 2026 Advanced Micro Devices, Inc. All rights reserved.                                                   *
#  * DISCLAIMER                                                                                                 *
#  * The information contained herein is for informational purposes only, and is subject to change              *
#  * without notice. While every precaution has been taken in the preparation of this document, it              *
#  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
#  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
#  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
#  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
#  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
#  * hardware, software or other products described herein.  No license, including implied or                   *
#  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
#  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
#  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
#  *                                                                                                            *
#  **************************************************************************************************************
#<copyright-disclaimer-end>
