`timescale 1ns/1ps

module testbench ;
   
   parameter WATCHDOG = 100000;
   
   reg sys_clk_p;
   wire sys_clk_n;
   wire  led;
   wire       pass;
   
   initial begin
      sys_clk_p = 1'b0;
      forever sys_clk_p = #1.6665 ~sys_clk_p;
   end
   
   assign sys_clk_n = ~sys_clk_p;
   
`ifdef VCD
   initial begin
      $dumpvars;
   end
`endif
   
   initial begin
      repeat (WATCHDOG) @ (posedge sys_clk_p);
      $display ($time, " Watch dog timer expired...exiting simulation\n");
      $stop;
   end
   
   always @(pass)
     $strobe("Time = %0d ns, PASS = %b" , $time, pass);
   
   dut_fpga dut_fpga(
		// Inputs
		.sys_clk_in_p(sys_clk_p), 
		.sys_clk_in_n(sys_clk_n),
		// Outputs
		.gpio_out_pass(pass), 
		.led(led),
		     .fmc_out()
		);
   
endmodule // testbench


//<copyright-disclaimer-start>
//  **************************************************************************************************************
//  * © 2026 Advanced Micro Devices, Inc. All rights reserved.                                                   *
//  * DISCLAIMER                                                                                                 *
//  * The information contained herein is for informational purposes only, and is subject to change              *
//  * without notice. While every precaution has been taken in the preparation of this document, it              *
//  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
//  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
//  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
//  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
//  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
//  * hardware, software or other products described herein.  No license, including implied or                   *
//  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
//  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
//  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
//  *                                                                                                            *
//  **************************************************************************************************************
//<copyright-disclaimer-end>
