(* DONT_TOUCH = "TRUE" *)
module bram_tdp_cas #(
		  parameter DW=36,
		  parameter AW=12
		  ) (
		     input 	     clkA, clkB,rstA, rstB,
		     input [AW-1:0]  addrA, addrB,
		     input [DW-1:0]  dinA, dinB,
		     input  	     enA, enB, weA, weB,
		     output reg [DW-1:0] doutA, doutB
		     );
(* ram_style = "block" *)
   reg [DW-1:0] mem [0:(1<<AW)-1];

reg [DW-1:0] doutA_1;
reg [DW-1:0] doutB_1;

   always @(posedge clkA) begin
     if (rstA)
	doutA <= 0;
     else if(enA && weA)
     begin
        mem[addrA] <= dinA;
        doutA_1 <= mem[addrA];
        doutA <= doutA_1;
     end
   end

   always @(posedge clkB) begin
     if (rstB)
	doutB <= 0;
     else if(enB && weB)
     begin
        mem[addrB] <= dinB;
        doutB_1 <= mem[addrB];
        doutB <= doutB_1;
     end
   end


endmodule // bram_tdp

//<copyright-disclaimer-start>
//  **************************************************************************************************************
//  * © 2026 Advanced Micro Devices, Inc. All rights reserved.                                                   *
//  * DISCLAIMER                                                                                                 *
//  * The information contained herein is for informational purposes only, and is subject to change              *
//  * without notice. While every precaution has been taken in the preparation of this document, it              *
//  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
//  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
//  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
//  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
//  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
//  * hardware, software or other products described herein.  No license, including implied or                   *
//  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
//  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
//  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
//  *                                                                                                            *
//  **************************************************************************************************************
//<copyright-disclaimer-end>
