###########################################################################
## Custom IP Completer Script
###########################################################################

# load the standard helper file
source -quiet ../../fpgaSupport_scripts/script1.tcl
source -quiet ../../fpgaSupport_scripts/script2.tcl
# project constants
set verbose 	1
set tcName 	Custom_IP
set demoOrLab 	completed
set projName 	wave_gen


 ## *********** Step 1 : Copying the project ***********
proc copyProject {} {

variable platform
variable language
variable tcName
variable demoOrLab 
variable projName 
variable TRAINING_PATH

# Set variables for source and destination paths
set sourcePath $TRAINING_PATH/$tcName/lab/$platform
set destPath $TRAINING_PATH/$tcName/completed/$platform

# Create the destination directories if they don't exist
file mkdir $destPath

# Copy the zip file to the destination directory
file copy -force $sourcePath/$language.zip $destPath
puts "sourcePath: $sourcePath"
puts "destPath: $destPath"

exec unzip $TRAINING_PATH/$tcName/completed/$platform/$language.zip -d $TRAINING_PATH/$tcName/completed/$platform/$language
}

 ## *********** Step 2 : Opening a project ***********
 proc openProject {} {
variable platform
variable language
variable tcName
variable demoOrLab 
variable projName 
variable TRAINING_PATH

# Add the platform combination that you want 
set isPlatNotSelected [string compare -nocase $platform "undefined"]
set isLangNotSelected [string compare -nocase $language "undefined"]

   
if {!$isPlatNotSelected} {
      puts "Please type: use KCU105 | KC705"
      puts "   then rerun the projectCreate"	
	  } elseif {!$isLangNotSelected} {
      puts "Please type: use VHDL | Verilog"
      puts "   then rerun the projectCreate"
	} 
   
# Open a project 
set projName.xpr {append $projName .xpr}
open_project $TRAINING_PATH/$tcName/$demoOrLab/$platform/$language/$projName.xpr
update_compile_order -fileset sources_1
}

 ## *********** Step 3 : Packaging the IP ***********

proc pckgIP {} {
variable platform
variable language
variable tcName
variable demoOrLab 
variable projName 
variable TRAINING_PATH

set_property top uart_tx [current_fileset]
update_compile_order -fileset sources_1
ipx::package_project -root_dir $TRAINING_PATH/$tcName/amdtrng_ip_repo/uart_tx -vendor user.org -library user -taxonomy /UserIP -import_files
set_property vendor amdtrng.com [ipx::current_core]
set_property library ip [ipx::current_core]
set_property description {UART transmitter with FIFO interface} [ipx::current_core]
set_property vendor_display_name {AMD Training} [ipx::current_core]
ipx::remove_file src/wave_gen_timing_Custom_IP.xdc [ipx::get_file_groups xilinx_anylanguagesynthesis -of_objects [ipx::current_core]]
ipx::remove_file src/wave_gen_pins_Custom_IP.xdc [ipx::get_file_groups xilinx_anylanguagesynthesis -of_objects [ipx::current_core]]
ipx::remove_file src/tb_cmd_gen_Custom_IP.v [ipx::get_file_groups xilinx_testbench -of_objects [ipx::current_core]]
ipx::remove_file src/tb_fifo.v [ipx::get_file_groups xilinx_testbench -of_objects [ipx::current_core]]
ipx::remove_file src/tb_ram_Custom_IP.v [ipx::get_file_groups xilinx_testbench -of_objects [ipx::current_core]]
ipx::remove_file src/tb_resetgen.v [ipx::get_file_groups xilinx_testbench -of_objects [ipx::current_core]]
ipx::remove_file src/tb_resp_checker_Custom_IP.v [ipx::get_file_groups xilinx_testbench -of_objects [ipx::current_core]]
ipx::remove_file src/tb_uart_driver_Custom_IP.v [ipx::get_file_groups xilinx_testbench -of_objects [ipx::current_core]]
ipx::remove_file src/tb_uart_monitor.v [ipx::get_file_groups xilinx_testbench -of_objects [ipx::current_core]]
ipx::remove_file src/tb_wave_gen.v [ipx::get_file_groups xilinx_testbench -of_objects [ipx::current_core]]
set_property name sim/uart_baud_gen.v [ipx::get_files src/uart_baud_gen.v -of_objects [ipx::get_file_groups xilinx_anylanguagebehavioralsimulation -of_objects [ipx::current_core]]]
set_property name src/uart_baud_gen.v [ipx::get_files sim/uart_baud_gen.v -of_objects [ipx::get_file_groups xilinx_anylanguagebehavioralsimulation -of_objects [ipx::current_core]]]
ipx::add_bus_interface uart_fifo_if [ipx::current_core]
set_property abstraction_type_vlnv xilinx.com:interface:fifo_read_rtl:1.0 [ipx::get_bus_interfaces uart_fifo_if -of_objects [ipx::current_core]]
set_property bus_type_vlnv xilinx.com:interface:fifo_read:1.0 [ipx::get_bus_interfaces uart_fifo_if -of_objects [ipx::current_core]]
set_property interface_mode master [ipx::get_bus_interfaces uart_fifo_if -of_objects [ipx::current_core]]
set_property display_name uart_fifo_if [ipx::get_bus_interfaces uart_fifo_if -of_objects [ipx::current_core]]
set_property description {UART FIFO INTERFACE} [ipx::get_bus_interfaces uart_fifo_if -of_objects [ipx::current_core]]
ipx::add_port_map RD_DATA [ipx::get_bus_interfaces uart_fifo_if -of_objects [ipx::current_core]]
set_property physical_name char_fifo_dout [ipx::get_port_maps RD_DATA -of_objects [ipx::get_bus_interfaces uart_fifo_if -of_objects [ipx::current_core]]]
ipx::add_port_map RD_EN [ipx::get_bus_interfaces uart_fifo_if -of_objects [ipx::current_core]]
set_property physical_name char_fifo_rd_en [ipx::get_port_maps RD_EN -of_objects [ipx::get_bus_interfaces uart_fifo_if -of_objects [ipx::current_core]]]
ipx::add_port_map EMPTY [ipx::get_bus_interfaces uart_fifo_if -of_objects [ipx::current_core]]
set_property physical_name char_fifo_empty [ipx::get_port_maps EMPTY -of_objects [ipx::get_bus_interfaces uart_fifo_if -of_objects [ipx::current_core]]]
ipx::update_checksums [ipx::current_core]
ipx::save_core [ipx::current_core]
set_property core_revision 2 [ipx::current_core]
ipx::create_xgui_files [ipx::current_core]
ipx::update_checksums [ipx::current_core]
ipx::check_integrity [ipx::current_core]
ipx::save_core [ipx::current_core]
set_property  ip_repo_paths  /home/amd/training/Custom_IP/amdtrng_ip_repo/uart_tx [current_project]
update_ip_catalog
create_ip -name uart_tx -vendor amdtrng.com -library ip -version 1.0 -module_name uart_tx_0
set_property CONFIG.CLOCK_RATE {166667000} [get_ips uart_tx_0]
generate_target {instantiation_template} [get_files $TRAINING_PATH/$tcName/$demoOrLab/$platform/$language/wave_gen.srcs/sources_1/ip/uart_tx_0/uart_tx_0.xci]
generate_target all [get_files  $TRAINING_PATH/$tcName/$demoOrLab/$platform/$language/wave_gen.srcs/sources_1/ip/uart_tx_0/uart_tx_0.xci]
catch { config_ip_cache -export [get_ips -all uart_tx_0] }
export_ip_user_files -of_objects [get_files $TRAINING_PATH/$tcName/$demoOrLab/$platform/$language/wave_gen.srcs/sources_1/ip/uart_tx_0/uart_tx_0.xci] -no_script -sync -force -quiet
create_ip_run [get_files -of_objects [get_fileset sources_1] $TRAINING_PATH/$tcName/$demoOrLab/$platform/$language/wave_gen.srcs/sources_1/ip/uart_tx_0/uart_tx_0.xci]
launch_runs uart_tx_0_synth_1 -jobs 8
wait_on_run uart_tx_0_synth_1
export_simulation -of_objects [get_files $TRAINING_PATH/$tcName/$demoOrLab/$platform/$language/wave_gen.srcs/sources_1/ip/uart_tx_0/uart_tx_0.xci] -directory $TRAINING_PATH/$tcName/$demoOrLab/$platform/$language/wave_gen.ip_user_files/sim_scripts -ip_user_files_dir $TRAINING_PATH/$tcName/$demoOrLab/$platform/$language/wave_gen.ip_user_files -ipstatic_source_dir $TRAINING_PATH/$tcName/$demoOrLab/$platform/$language/wave_gen.ip_user_files/ipstatic -lib_map_path [list {modelsim=$TRAINING_PATH/$tcName/$demoOrLab/$platform/$language/wave_gen.cache/compile_simlib/modelsim} {questa=$TRAINING_PATH/$tcName/$demoOrLab/$platform/$language/wave_gen.cache/compile_simlib/questa} {xcelium=$TRAINING_PATH/$tcName/$demoOrLab/$platform/$language/wave_gen.cache/compile_simlib/xcelium} {vcs=$TRAINING_PATH/$tcName/$demoOrLab/$platform/$language/wave_gen.cache/compile_simlib/vcs} {riviera=$TRAINING_PATH/$tcName/$demoOrLab/$platform/$language/wave_gen.cache/compile_simlib/riviera}] -use_ip_compiled_libs -force -quiet

}

 ## *********** Step 5 : Using the Custom IP in a Block Design ***********

proc usingCustomIP {} {
variable platform
variable language
variable tcName
variable demoOrLab 
variable projName 
variable TRAINING_PATH

set_property top wave_gen [current_fileset]

update_files -from_files $TRAINING_PATH/$tcName/support/completed_files/wave_gen_Custom_IP.v -to_files $TRAINING_PATH/$tcName/$demoOrLab/$platform/$language/wave_gen.srcs/sources_1/imports/Custom_IP/wave_gen_Custom_IP.v -filesets [get_filesets *]

update_compile_order -fileset sources_1
launch_runs impl_1 -jobs 8
wait_on_run impl_1
create_bd_design "uart_and_fifo"
update_compile_order -fileset sources_1
startgroup
create_bd_cell -type ip -vlnv amdtrng.com:ip:uart_tx:1.0 uart_tx_0
endgroup
startgroup
create_bd_cell -type ip -vlnv xilinx.com:ip:fifo_generator:13.2 fifo_generator_0
endgroup
set_property -dict [list \
  CONFIG.BAUD_RATE {115200} \
  CONFIG.CLOCK_RATE {166667000} \
] [get_bd_cells uart_tx_0]
set_property -dict [list \
  CONFIG.Fifo_Implementation {Independent_Clocks_Builtin_FIFO} \
  CONFIG.Input_Data_Width {8} \
  CONFIG.Performance_Options {First_Word_Fall_Through} \
  CONFIG.Read_Clock_Frequency {166} \
  CONFIG.Write_Clock_Frequency {200} \
] [get_bd_cells fifo_generator_0]
connect_bd_intf_net [get_bd_intf_pins uart_tx_0/uart_fifo_if] [get_bd_intf_pins fifo_generator_0/FIFO_READ]
startgroup
make_bd_pins_external  [get_bd_pins uart_tx_0/rst_clk_tx] [get_bd_pins uart_tx_0/clk_tx] [get_bd_pins uart_tx_0/txd_tx] [get_bd_pins fifo_generator_0/srst] [get_bd_pins fifo_generator_0/wr_clk]
make_bd_intf_pins_external  [get_bd_intf_pins fifo_generator_0/FIFO_WRITE]
endgroup
connect_bd_net [get_bd_ports clk_tx_0] [get_bd_pins fifo_generator_0/rd_clk]
validate_bd_design
regenerate_bd_layout
save_bd_design
}


## ********** Running only the steps that are required with Make **************

proc make {stopAt} {

   puts "Running until the step $stopAt"
   #set steps [list S1_openProject S2_observeReport S3_addPriConstr S4_addGenConstr S5_genReport]
   set limit [string tolower $stopAt]
   switch $limit {
      step1  { copyProject }
      step2  { make step1; openProject }
	  step3  { make step2; pckgIP }
      step4  { make step3; usingCustomIP}
	  all    { make step4 }
      default { 
         puts "Call the make proc, Should be make step*" 
			  }	
	}	
}

#<copyright-disclaimer-start>
#  **************************************************************************************************************
#  * © 2026 Advanced Micro Devices, Inc. All rights reserved.                                                   *
#  * DISCLAIMER                                                                                                 *
#  * The information contained herein is for informational purposes only, and is subject to change              *
#  * without notice. While every precaution has been taken in the preparation of this document, it              *
#  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
#  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
#  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
#  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
#  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
#  * hardware, software or other products described herein.  No license, including implied or                   *
#  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
#  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
#  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
#  *                                                                                                            *
#  **************************************************************************************************************
#<copyright-disclaimer-end>
