###########################################################################
## HDL Instantiation Flow Completer Script
###########################################################################

# load the standard helper file
source -quiet ../../fpgaSupport_scripts/script1.tcl
source -quiet ../../fpgaSupport_scripts/script2.tcl

# project constants
set verbose 	1
set tcName 	HDLInst_Flow
set demoOrLab 	completed
set projName 	uart_led

 ## *********** Step 1 : Copying the project ***********
proc copyProject {} {

variable platform
variable language
variable tcName
variable demoOrLab 
variable projName 
variable TRAINING_PATH

# Set variables for source and destination paths
set sourcePath $TRAINING_PATH/$tcName/lab/$platform
set destPath $TRAINING_PATH/$tcName/completed/$platform

# Create the destination directories if they don't exist
file mkdir $destPath

# Copy the zip file to the destination directory
file copy -force $sourcePath/$language.zip $destPath
puts "sourcePath: $sourcePath"
puts "destPath: $destPath"

exec unzip $TRAINING_PATH/$tcName/completed/$platform/$language.zip -d $TRAINING_PATH/$tcName/completed/$platform/$language
}

##########################################################
## Step 2: Opening the project and adding VIO debug core 
##########################################################
proc openProject {} {
 variable platform
 variable language
 variable tcName
 variable demoOrLab 
 variable projName 
 variable TRAINING_PATH
 set projName.srcs {append $projName .srcs}
 set projName.xpr {append $projName .xpr}

 # Add the platform and language combination that you want 
 set isLangNotSelected [string compare -nocase $language "undefined"]
 set isPlatNotSelected [string compare -nocase $platform "undefined"]
   
 if {$isLangNotSelected} {
      puts "Please type: use Verilog"
      puts "   then rerun the projectCreate"
   } elseif {$isPlatNotSelected} {
      puts "Please type: use KCU105 | KC705 | KC7xx | ZCU104"
      puts "   then rerun the projectCreate"
   }

 # Open a project
 open_project $TRAINING_PATH/$tcName/$demoOrLab/$platform/$language/$projName.xpr
 # creating the directory for new IP
 file mkdir $TRAINING_PATH/$tcName/$demoOrLab/$platform/$language/$projName.srcs/sources_1/ip
}
 
##########################################################
## Step 3: Instantiating the core 
##########################################################
proc copyCompletedSourceCode {} {
   variable platform
   variable language
   variable tcName
   variable demoOrLab 
   variable projName 
   variable fileName
   variable TRAINING_PATH

 #Generating the VIO core and customizing
 create_ip -name vio -vendor xilinx.com -library ip -version 3.0 -module_name VIO_LED_BUTT -dir $TRAINING_PATH/$tcName/$demoOrLab/$platform/$language/$projName.srcs/sources_1/ip
 set_property -dict [list CONFIG.C_PROBE_IN0_WIDTH {8}] [get_ips VIO_LED_BUTT]
 
 #create_ip -name vio -vendor xilinx.com -library ip -version 3.0 -module_name VIO_LED_BUTT
 #set_property -dict [list CONFIG.C_PROBE_IN0_WIDTH {8} CONFIG.Component_Name {VIO_LED_BUTT}] [get_ips VIO_LED_BUTT]

 generate_target all [get_files  $TRAINING_PATH/$tcName/$demoOrLab/$platform/$language/$projName.srcs/sources_1/ip/VIO_LED_BUTT/VIO_LED_BUTT.xci]
 create_ip_run [get_files -of_objects [get_fileset sources_1] $TRAINING_PATH/$tcName/$demoOrLab/$platform/$language/$projName.srcs/sources_1/ip/VIO_LED_BUTT/VIO_LED_BUTT.xci]
 launch_runs -jobs 8 VIO_LED_BUTT_synth_1
 wait_on_run VIO_LED_BUTT_synth_1

 markLastStep VIOCoreGenerated



   set completedfilePath $TRAINING_PATH/$tcName/support/completed_files              
   set projName.srcs {append $projName .srcs}
   set path $TRAINING_PATH/$tcName/$demoOrLab/$platform/$language/$projName.srcs/sources_1/imports              
  
  # load all the completed file as the working file              
  if {$platform == "ZCU104"} {
  if {$language == "vhdl"} { 
    file copy -force $completedfilePath/uart_led.vhd $path/uart_led.vhd
	puts "i am inside VHDL"
  } elseif {$language == "verilog" } { 
   file copy -force $completedfilePath/uart_led.v $path/uart_led.v
  } 
  } 
  markLastStep VIOCoreInstantiated
}

### REFRESH THE HIERARCHY MANUALLY

##########################################################
## Step 4: Implementing and Analyzing the Design
##########################################################

proc ImplAnalyze {} {
 variable tcName
 variable platform
 variable demoOrLab
 variable language
 variable verbose
 variable projName 
 variable TRAINING_PATH
 
 launch_runs synth_1 -jobs 8;
 
 #launch_runs impl_1 -jobs 8;
 # wait_on_run impl_1
 #launch_runs impl_1 -to_step write_bitstream -jobs 8;
 }

##########################################################
# Running through the steps that are required, with make
##########################################################
proc make {stopAt} {
   puts "Running until the step $stopAt"
   set limit [string tolower $stopAt]
   switch $limit {
      step1  { copyProject }
	  step2  { make step1; openProject }
      step3  { make step2; copyCompletedSourceCode }
	       all    { make step3 }
      
      default { 
         puts "Call the make proc, Should be make step*" 
			  }	
	}	
}

#<copyright-disclaimer-start>
#  **************************************************************************************************************
#  * © 2026 Advanced Micro Devices, Inc. All rights reserved.                                                   *
#  * DISCLAIMER                                                                                                 *
#  * The information contained herein is for informational purposes only, and is subject to change              *
#  * without notice. While every precaution has been taken in the preparation of this document, it              *
#  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
#  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
#  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
#  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
#  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
#  * hardware, software or other products described herein.  No license, including implied or                   *
#  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
#  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
#  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
#  *                                                                                                            *
#  **************************************************************************************************************
#<copyright-disclaimer-end>
