###########################################################################
## Resets Completer Script
###########################################################################

# load the standard helper file
source -quiet ../../fpgaSupport_scripts/script1.tcl
source -quiet ../../fpgaSupport_scripts/script2.tcl

# project constants
set verbose 	1
set tcName 		Reset
set demoOrLab 	completed

 ## *********** Step 1 : Copying the project ***********
proc copyProject_async_reset {} {

variable platform
variable language
variable tcName
variable demoOrLab 
variable projName 
variable TRAINING_PATH

set projName 	async_reset

# Set variables for source and destination paths
set sourcePath $TRAINING_PATH/$tcName/lab/$platform
set destPath $TRAINING_PATH/$tcName/completed/$platform

# Create the destination directories if they don't exist
file mkdir $destPath

# Copy the zip file to the destination directory
file copy -force $sourcePath/$projName.zip $destPath
puts "sourcePath: $sourcePath"
puts "destPath: $destPath"

exec unzip $TRAINING_PATH/$tcName/completed/$platform/$projName.zip -d $TRAINING_PATH/$tcName/completed/$platform/$projName
}


 ## *********** Step 2 : Opening async_reset project and examine ***********

proc openProj_async_reset {} {
variable platform
variable language
variable tcName
variable demoOrLab 
variable projName 
variable TRAINING_PATH

set projName 	async_reset

# Add the platform and language combination that you want 
set isLangNotSelected [string compare -nocase $language "undefined"]
set isPlatNotSelected [string compare -nocase $platform "undefined"]
   
if {$isPlatNotSelected} {
      puts "Please type: use KCU105 | KC705 | KC7xx"
      puts "   then rerun the projectCreate"
}   

# Open a project
set projName.xpr {append $projName .xpr}
open_project $TRAINING_PATH/$tcName/$demoOrLab/$platform/$projName/$projName.xpr


# Calling the proc which runs implementation
synthesisRun

select [get_cells SysRst_L*]
report_timing_summary -delay_type min_max -report_unconstrained -check_timing_verbose -max_paths 10 -input_pins -name timing_1
report_timing -from [get_ports {SysRst_L}] -max_paths 100 -name async_timing_paths
get_property INIT [get_cells *count_reg[0][0]]
get_property INIT [get_cells sload_in_reg]
report_high_fanout_nets
select [get_nets async_reset_L]
close_design


# Calling the proc which runs implementation
implementationRun

report_high_fanout_nets
select [get_nets async_reset_L]
join [get_pins -of [get_nets async_reset_L]] \n
llength [get_pins -of [get_nets async_reset_L]]

close_design

close_project
}


 ## *********** Step 3 : Copying the project ***********
proc copyProject_no_reset {} {

variable platform
variable language
variable tcName
variable demoOrLab 
variable projName 
variable TRAINING_PATH

set projName 	no_reset

# Set variables for source and destination paths
set sourcePath $TRAINING_PATH/$tcName/lab/$platform
set destPath $TRAINING_PATH/$tcName/completed/$platform

# Create the destination directories if they don't exist
file mkdir $destPath

# Copy the zip file to the destination directory
file copy -force $sourcePath/$projName.zip $destPath
puts "sourcePath: $sourcePath"
puts "destPath: $destPath"

exec unzip $TRAINING_PATH/$tcName/completed/$platform/$projName.zip -d $TRAINING_PATH/$tcName/completed/$platform/$projName
}


 ## *********** Step 4 : Opening no_reset project and examine ***********

proc openProj_no_reset {} {
variable platform
variable language
variable tcName
variable demoOrLab 
variable projName 
variable TRAINING_PATH

set projName 	no_reset

# Add the platform and language combination that you want 
set isLangNotSelected [string compare -nocase $language "undefined"]
set isPlatNotSelected [string compare -nocase $platform "undefined"]
   
if {$isPlatNotSelected} {
      puts "Please type: use KCU105 | KC705 | KC7xx"
      puts "   then rerun the projectCreate"
}   

# Open a project
set projName.xpr {append $projName .xpr}
open_project $TRAINING_PATH/$tcName/$demoOrLab/$platform/$projName/$projName.xpr

	
# Calling the proc which runs implementation
synthesisRun

report_timing_summary -delay_type min_max -report_unconstrained -check_timing_verbose -max_paths 10 -input_pins -name timing_1
get_property INIT [get_cells sload_in_reg*]
close_design

# Calling the proc which runs implementation
implementationRun

select [get_cells sload_in_reg]
report_high_fanout_nets
close_design
close_project
}

 ## *********** Step 5 : Copying the project ***********
proc copyProject_sync_reset {} {

variable platform
variable language
variable tcName
variable demoOrLab 
variable projName 
variable TRAINING_PATH

set projName 	sync_reset

# Set variables for source and destination paths
set sourcePath $TRAINING_PATH/$tcName/lab/$platform
set destPath $TRAINING_PATH/$tcName/completed/$platform

# Create the destination directories if they don't exist
file mkdir $destPath

# Copy the zip file to the destination directory
file copy -force $sourcePath/$projName.zip $destPath
puts "sourcePath: $sourcePath"
puts "destPath: $destPath"

exec unzip $TRAINING_PATH/$tcName/completed/$platform/$projName.zip -d $TRAINING_PATH/$tcName/completed/$platform/$projName
}

 ## *********** Step 6 : Opening sync_reset project and examine ***********

proc openProj_sync_reset {} {
variable platform
variable language
variable tcName
variable demoOrLab 
variable projName 
variable TRAINING_PATH


set projName 	sync_reset

# Add the platform and language combination that you want 
set isLangNotSelected [string compare -nocase $language "undefined"]
set isPlatNotSelected [string compare -nocase $platform "undefined"]
   
if {$isPlatNotSelected} {
      puts "Please type: use KCU105 | KC705 | KC7xx"
      puts "   then rerun the projectCreate"
}   

# Open a project
set projName.xpr {append $projName .xpr}
open_project $TRAINING_PATH/$tcName/$demoOrLab/$platform/$projName/$projName.xpr


synth_design -rtl -name rtl_1

select [get_cells RESET_BRIDGE_100]
close_design

# Calling the proc which runs implementation
synthesisRun

report_timing_summary -delay_type min_max -report_unconstrained -check_timing_verbose -max_paths 10 -input_pins -name timing_1
report_high_fanout_nets
all_fanout -endpoints_only -flat [get_nets RESET_BRIDGE_100/sync_reset_out]
llength [all_fanout -endpoints_only -flat [get_nets RESET_BRIDGE_100/sync_reset_out]]
report_timing -through [get_nets {RESET_BRIDGE_100/sync_reset_out}] -name reset_timing_paths -max_paths 10
close_design
}


 ## *********** Step 7 : Moving high fan out signal ***********

proc move_highfanout_signal {} {

set_property verilog_define SYNC_RESET_ON_BUFG=1 [current_fileset]
reset_run synth_1

# Calling the proc which runs implementation
synthesisRun

report_high_fanout_nets
select [get_cells RESET_BRIDGE_100]
report_timing -through [get_nets {reset_clk100}] -name reset_timing_paths -max_paths 10
close_design
close_project
}


 ## ********** Running only the steps that are required with Make **************

proc make {stopAt} {

   puts "Running until the step $stopAt"
   set limit [string tolower $stopAt]
   switch $limit {
      step1  { copyProject_async_reset }
	  step2  { make step1; openProj_async_reset }
      step3  { make step2; copyProject_no_reset }
      step4  { make step3; openProj_no_reset }
	  step5  { make step4; copyProject_sync_reset }
	  step6  { make step5; openProj_sync_reset }
      step7  { make step6; move_highfanout_signal }
      all    { make step7 }
      default { 
         puts "Call the make proc, Should be make step*" 
			  }	
	}	
}

#<copyright-disclaimer-start>
#  **************************************************************************************************************
#  * © 2026 Advanced Micro Devices, Inc. All rights reserved.                                                   *
#  * DISCLAIMER                                                                                                 *
#  * The information contained herein is for informational purposes only, and is subject to change              *
#  * without notice. While every precaution has been taken in the preparation of this document, it              *
#  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
#  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
#  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
#  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
#  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
#  * hardware, software or other products described herein.  No license, including implied or                   *
#  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
#  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
#  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
#  *                                                                                                            *
#  **************************************************************************************************************
#<copyright-disclaimer-end>
