###########################################################################
#Scripting_ProjectFlow Completer Script
###########################################################################

# load the standard helper file
#source $trainingPath/training/completer_helper_script/helper.tcl
#source $trainingPath/training/completer_helper_script/completer_helper.tcl

source -quiet ../../fpgaSupport_scripts/script1.tcl
source -quiet ../../fpgaSupport_scripts/script2.tcl

# project constants
set verbose 1
set tcName Scripting_ProjectFlow
set demoOrLab completed
set projName wave_gen

## *********** Step 1 : Copying the project ***********
proc copyProject {} {

variable platform
variable language
variable tcName
variable demoOrLab 
variable projName 
variable TRAINING_PATH

# Set variables for source and destination paths
set sourcePath $TRAINING_PATH/$tcName/lab/$platform
set destPath $TRAINING_PATH/$tcName/completed/$platform

# Create the destination directories if they don't exist
file mkdir $destPath

# Copy the zip file to the destination directory
file copy -force $sourcePath/$language.zip $destPath
puts "sourcePath: $sourcePath"
puts "destPath: $destPath"

exec unzip $TRAINING_PATH/$tcName/completed/$platform/$language.zip -d $TRAINING_PATH/$tcName/completed/$platform/$language
}
#########################################################
#Step 1 : Creating a new project
#########################################################
proc createProj {} {
 variable language
 variable platform
 variable sourceList
 variable tcName
 variable demoOrLab
 variable projName
 variable TRAINING_PATH
 set time_raw [clock seconds];
 set date_string [clock format $time_raw -format "%y%m%d_%H%M%S"]
 set proj_dir "build_$date_string"
 cd $TRAINING_PATH/$tcName/$demoOrLab/$platform/$language
 puts "Creating build directory $proj_dir"
 file mkdir $proj_dir
 puts "Changing directory to $proj_dir"
 cd $proj_dir
# Creating the project
 
   create_project $projName -part xcku040-ffva1156-2-e
 
 if {$language == "Verilog"} {
   set_property target_language Verilog [current_project]
 } elseif {$platform == "vhdl"} {
   set_property target_language VHDL [current_project] 
 }
 close_project
}

##########################################
#Step 2 : Adding source files
##########################################
proc addSourceFiles {} {
 variable tcName
 variable language
 variable platform
 variable verbose
 variable demoOrLab
 variable projName
 variable TRAINING_PATH
 set time_raw [clock seconds];
 set date_string [clock format $time_raw -format "%y%m%d_%H%M%S"]
 set proj_dir "build_$date_string"
 set script_dir $TRAINING_PATH/$tcName/$demoOrLab/$platform/$language
 set src_dir    $script_dir/wave_gen/src
 set core_dir   $script_dir/wave_gen/cores
 set xdc_dir    $script_dir/wave_gen/constraints
 
 cd $TRAINING_PATH/$tcName/$demoOrLab/$platform/$language
 file mkdir $proj_dir
 cd $proj_dir
 
 # Creating the project
   create_project $projName -part xcku040-ffva1156-2-e
 
 if {$language == "Verilog"} {
   set_property target_language Verilog [current_project]
 } elseif {$language == "vhdl"} {
   set_property target_language VHDL [current_project] 
 }
 
 #Imports RTL files
 import_files [glob $src_dir/*]
 if {$language == "vhdl"} {
 set_property library utilities_lib [get_files string_utilities_synth_pkg.vhd]
 }
 #Imports constraint file
 if {$language == "Verilog"} {
import_files -fileset [get_filesets constrs_1] $xdc_dir/wave_gen_timing_Scripting_ProjectFlow_v.xdc
} elseif {$platform == "vhdl"} {
import_files -fileset [get_filesets constrs_1] $xdc_dir/wave_gen_timing_Scripting_ProjectFlow_vhd.xdc
}

 #Import IPs
 import_ip -files $core_dir/char_fifo.xci -name char_fifo
 create_ip -name clk_wiz -vendor xilinx.com -library ip -module_name clk_core

   set_property -dict [list CONFIG.Component_Name {clk_core} CONFIG.PRIM_SOURCE {Differential_clock_capable_pin} CONFIG.PRIM_IN_FREQ {300.000} CONFIG.CLKOUT2_USED {true} CONFIG.CLKOUT1_REQUESTED_OUT_FREQ {200.000} CONFIG.CLKOUT2_REQUESTED_OUT_FREQ {193.750}] [get_ips clk_core]
 
 close_project
 markLastStep sourcesFilesAdded
}

##########################################
#Step 3: Setting process properties
##########################################
proc setProperty {} {
 variable tcName
 variable language
 variable platform
 variable verbose
 variable demoOrLab
 variable projName
 variable TRAINING_PATH
 set time_raw [clock seconds];
 set date_string [clock format $time_raw -format "%y%m%d_%H%M%S"]
 set proj_dir "build_$date_string"
 set script_dir $TRAINING_PATH/$tcName/$demoOrLab/$platform/$language
 set src_dir    $script_dir/wave_gen/src
 set core_dir   $script_dir/wave_gen/cores
 set xdc_dir    $script_dir/wave_gen/constraints
 
 cd $TRAINING_PATH/$tcName/$demoOrLab/$platform/$language
 file mkdir $proj_dir
 cd $proj_dir
 
 # Creating the project
  
   create_project $projName -part xcku040-ffva1156-2-e
  
  if {$language == "Verilog"} {
   set_property target_language Verilog [current_project]
  } elseif {$platform == "vhdl"} {
   set_property target_language VHDL [current_project] 
  }
 #Imports RTL files
 import_files [glob $src_dir/*]
  if {$language == "vhdl"} {
   set_property library utilities_lib [get_files string_utilities_synth_pkg.vhd]
  }
 #Imports constraint file
 if {$language == "Verilog"} {
import_files -fileset [get_filesets constrs_1] $xdc_dir/wave_gen_timing_Scripting_ProjectFlow_v.xdc
} elseif {$platform == "vhdl"} {
import_files -fileset [get_filesets constrs_1] $xdc_dir/wave_gen_timing_Scripting_ProjectFlow_vhd.xdc
}
 #Import IPs
 import_ip -files $core_dir/char_fifo.xci -name char_fifo
 create_ip -name clk_wiz -vendor xilinx.com -library ip -module_name clk_core 
 
 set_property -dict [list CONFIG.Component_Name {clk_core} CONFIG.PRIM_SOURCE {Differential_clock_capable_pin} CONFIG.PRIM_IN_FREQ {300.000} CONFIG.CLKOUT2_USED {true} CONFIG.CLKOUT1_REQUESTED_OUT_FREQ {200.000} CONFIG.CLKOUT2_REQUESTED_OUT_FREQ {193.750}] [get_ips clk_core]

 
 ## Setting Synthesis and Implementation properties
  set_property steps.synth_design.args.flatten_hierarchy none [get_runs synth_1]
  set_property steps.power_opt_design.is_enabled true [get_runs impl_1]
 close_project
 markLastStep propertiesSet
}

##########################################
#Step 4: Implementing the design
##########################################
proc implDesign {} {
 variable tcName
 variable language
 variable platform
 variable verbose
 variable demoOrLab
 variable projName
 variable TRAINING_PATH
 set time_raw [clock seconds];
 set date_string [clock format $time_raw -format "%y%m%d_%H%M%S"]
 set proj_dir "build_$date_string"
 set script_dir $TRAINING_PATH/$tcName/$demoOrLab/$platform/$language
 set src_dir    $script_dir/wave_gen/src
 set core_dir   $script_dir/wave_gen/cores
 set xdc_dir    $script_dir/wave_gen/constraints
 
 cd $TRAINING_PATH/$tcName/$demoOrLab/$platform/$language
 file mkdir $proj_dir
 cd $proj_dir
 #****************************** Need to run step 1 to 3 again to proceed with step4 ********************************
 # Creating the project
  
   create_project $projName -part xcku040-ffva1156-2-e
  
  if {$language == "Verilog"} {
   set_property target_language Verilog [current_project]
  } elseif {$platform == "VHDL"} {
   set_property target_language VHDL [current_project] 
  }
 #Imports RTL files
 import_files [glob $src_dir/*]
  if {$language == "vhdl"} {
   set_property library utilities_lib [get_files string_utilities_synth_pkg.vhd]
  }
 #Imports constraint file
if {$language == "Verilog"} {
import_files -fileset [get_filesets constrs_1] $xdc_dir/wave_gen_timing_Scripting_ProjectFlow_v.xdc
} elseif {$platform == "vhdl"} {
import_files -fileset [get_filesets constrs_1] $xdc_dir/wave_gen_timing_Scripting_ProjectFlow_vhd.xdc
}
 #Import IPs
 import_ip -files $core_dir/char_fifo.xci -name char_fifo
 create_ip -name clk_wiz -vendor xilinx.com -library ip -module_name clk_core 
 
  set_property -dict [list CONFIG.Component_Name {clk_core} CONFIG.PRIM_SOURCE {Differential_clock_capable_pin} CONFIG.PRIM_IN_FREQ {300.000} CONFIG.CLKOUT2_USED {true} CONFIG.CLKOUT1_REQUESTED_OUT_FREQ {200.000} CONFIG.CLKOUT2_REQUESTED_OUT_FREQ {193.750}] [get_ips clk_core]
 
 
 ## Setting Synthesis and Implementation properties
  set_property steps.synth_design.args.flatten_hierarchy none [get_runs synth_1]
  set_property steps.power_opt_design.is_enabled true [get_runs impl_1]
 #***************************************step 3 end here************************************************ 
 
 #Synthesizing and Implementing the design 
 launch_runs synth_1
 wait_on_run synth_1
 
 launch_runs impl_1
 wait_on_run impl_1
 
 markLastStep implComplete
 }
 
##########################################################
# Running through the steps that are required, with make
##########################################################
proc make {stopAt} {
   puts "Running until the step $stopAt"
   set limit [string tolower $stopAt]
   switch $limit {
      step1  { copyProject }
	  step2  { make step1; createProj }
      step3  { make step2; addSourceFiles }
      step4  { make step3; setProperty }
	  step5  { make step4; implDesign }
      all    { make step5 }
      
      default { 
         puts "Call the make proc, Should be make step*" 
			  }	
	}	
}

#<copyright-disclaimer-start>
#  **************************************************************************************************************
#  * © 2026 Advanced Micro Devices, Inc. All rights reserved.                                                   *
#  * DISCLAIMER                                                                                                 *
#  * The information contained herein is for informational purposes only, and is subject to change              *
#  * without notice. While every precaution has been taken in the preparation of this document, it              *
#  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
#  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
#  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
#  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
#  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
#  * hardware, software or other products described herein.  No license, including implied or                   *
#  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
#  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
#  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
#  *                                                                                                            *
#  **************************************************************************************************************
#<copyright-disclaimer-end>
