create_clock -period 3.333 -name clk_pin_p -waveform {0.000 1.666} [get_ports clk_pin_p]
set_input_jitter [get_clocks clk_pin_p] 0.00
create_generated_clock -name spi_clk -source [get_pins dac_spi_i0/out_ddr_flop_spi_clk_i0/ODDR_inst/C] -divide_by 1 -invert [get_ports spi_clk_pin]
set_clock_groups -asynchronous -group [get_clocks -filter { NAME =~  "*clk_out1*" }] -group [get_clocks -filter { NAME =~  "*clk_out2*" }]
set_input_delay  -clock clk_pin_p            0.8   [get_ports {rst_pin}]
set_input_delay  -clock clk_pin_p      -min 0.5 [get_ports {rst_pin}]
create_clock -period 5.161 -name clk_tx_virtual -waveform {0.000 2.580}
set_input_delay  -clock clk_tx_virtual       1   [get_ports {lb_sel_pin}]
set_input_delay  -clock clk_tx_virtual -min 0.5 [get_ports {lb_sel_pin}]
create_clock -period 5.000 -name clk_rx_virtual -waveform {0.000 2.500}
set_input_delay  -clock clk_rx_virtual            1   [get_ports {rxd_pin}]
set_input_delay  -clock clk_rx_virtual      -min 0.5 [get_ports {rxd_pin}]
set_output_delay -clock [get_clocks clk_tx_virtual] 0.000 [get_ports {led_pins[0] led_pins[1] led_pins[2] led_pins[3] led_pins[4] led_pins[5] led_pins[6] led_pins[7] txd_pin}]
set_output_delay -clock [get_clocks spi_clk] -max  1 [get_ports {spi_mosi_pin dac_cs_n_pin dac_clr_n_pin}]
set_output_delay -clock [get_clocks spi_clk] -min 0.2 [get_ports {spi_mosi_pin dac_cs_n_pin dac_clr_n_pin}]
create_generated_clock -name clk_samp -source [get_pins {clk_gen_i0/BUFGCE_clk_samp_i0/I}] -divide_by 32 [get_pins {clk_gen_i0/BUFGCE_clk_samp_i0/O}]


#//<copyright-disclaimer-start>
#  **************************************************************************************************************
#  * © 2026 Advanced Micro Devices, Inc. All rights reserved.                                                   *
#  * DISCLAIMER                                                                                                 *
#  * The information contained herein is for informational purposes only, and is subject to change              *
#  * without notice. While every precaution has been taken in the preparation of this document, it              *
#  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
#  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
#  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
#  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
#  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
#  * hardware, software or other products described herein.  No license, including implied or                   *
#  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
#  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
#  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
#  *                                                                                                            *
#  **************************************************************************************************************
#<copyright-disclaimer-end>
