# Setup design sources and constraints

set src_dir    ./wave_gen/src  
set xdc_dir    ./wave_gen/constraints
set core_dir   ./wave_gen/cores     
set output_dir ./wave_gen_output

puts "Removing existing output directories"
file delete -force $output_dir

puts "Creating output directory for Wavegen FPGA RTL"
file mkdir $output_dir

puts "Creating an in-memory project with xcku040-ffva1156-2-e so that IP outputs generation consider this as the project part"
set device xcku040-ffva1156-2-e
create_project -part $device -name wave_gen
set_property board_part xilinx.com:KCU105:part0:1.7 [current_project]

puts "Reading RTL source files"
# Insert the command to read the RTL files form $src_dir here 



puts "Importing XDC files to the project"
# Insert the commands to read bot XDC files from $xdc_dir here 


puts "Reading char_fifo and clk_core IP from IP location"

# Insert the command to Import the char_fifo IP and clk_core from $core_dir

upgrade_ip [get_ips {char_fifo}]
upgrade_ip [get_ips {clk_core}]
# Insert the command to synthesize the IPs





# The IPs could also be read as design check points (dcp), if the IP has been synthesized separatly as in this case.
# read_checkpoint $core_dir/char_fifo/char_fifo.dcp
# read_checkpoint $core_dir/clk_core/clk_core.dcp

# Run synthesis, report utilization, timing estimate, write design checkpoint
puts "Running Synthesis"
# Insert the command to synthesize the design using $device part here


puts "Writing post synthesis design checkpoint"
# Insert the command to write checkpoint in $output_dir directory here


puts "Creating Report Utilization"
# Insert the command to generate utilization report here


puts "Creating Timing Report"
report_timing -sort_by group -max_paths 5 -path_type summary -file $output_dir/post_synth_timing.rpt

#<copyright-disclaimer-start>
#  **************************************************************************************************************
#  * © 2026 Advanced Micro Devices, Inc. All rights reserved.                                                   *
#  * DISCLAIMER                                                                                                 *
#  * The information contained herein is for informational purposes only, and is subject to change              *
#  * without notice. While every precaution has been taken in the preparation of this document, it              *
#  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
#  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
#  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
#  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
#  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
#  * hardware, software or other products described herein.  No license, including implied or                   *
#  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
#  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
#  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
#  *                                                                                                            *
#  **************************************************************************************************************
#<copyright-disclaimer-end>
