# Run placement, logic optimization, report utilization and timing estimates

set output_dir ./wave_gen_output

puts "Open Post Synthesis Design Checkpoint"
# Insert command to open post_synth.dcp here


puts "Logical optimization"
opt_design

puts "Power Optimization"
power_opt_design

puts "Run Placer"
# Insert command to run placement here


puts "Physical Optimization"
phys_opt_design

puts "Writing post placement design checkpoint"
write_checkpoint -force $output_dir/post_place

puts "Creating Clock Utilization Report"
report_clock_utilization -file $output_dir/clock_util.rpt

puts "Creating Utilization Report"
report_utilization -file $output_dir/post_place_util.rpt

puts "Creating Timing Report"
report_timing -sort_by group -max_paths 5 -path_type summary -file $output_dir/post_place_timing.rpt

#<copyright-disclaimer-start>
#  **************************************************************************************************************
#  * © 2026 Advanced Micro Devices, Inc. All rights reserved.                                                   *
#  * DISCLAIMER                                                                                                 *
#  * The information contained herein is for informational purposes only, and is subject to change              *
#  * without notice. While every precaution has been taken in the preparation of this document, it              *
#  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
#  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
#  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
#  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
#  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
#  * hardware, software or other products described herein.  No license, including implied or                   *
#  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
#  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
#  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
#  *                                                                                                            *
#  **************************************************************************************************************
#<copyright-disclaimer-end>
