set output_dir ./wave_gen_output

#Run router, report actual utilization and timing, write checkpoint, run DRCs

puts "Open Post Place Design Checkpoint"
open_checkpoint ./wave_gen_output/post_place.dcp

puts "Routing Design"
# Insert command to open run router here 


puts "Writing post Route Design Checkpoint"
write_checkpoint -force $output_dir/post_route

puts "Creating a Actual Timing Report"
# Insert command to Create Post Route Timing Summary Report here 



puts "Creating a Device Utilization Report"
report_utilization -file $output_dir/post_route_util.rpt

puts "Creating a Power Report"
report_power -file $output_dir/post_route_power.rpt

puts "Run Design-Rule Checks"
report_drc -file $output_dir/post_imp_drc.rpt

puts "Writing Verilog netlist"
write_verilog -file $output_dir/wave_gen_impl_netlist.v

puts "Writing XDC"
write_xdc -no_fixed_only -force $output_dir/wave_gen_impl.xdc

#<copyright-disclaimer-start>
#  **************************************************************************************************************
#  * © 2026 Advanced Micro Devices, Inc. All rights reserved.                                                   *
#  * DISCLAIMER                                                                                                 *
#  * The information contained herein is for informational purposes only, and is subject to change              *
#  * without notice. While every precaution has been taken in the preparation of this document, it              *
#  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
#  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
#  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
#  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
#  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
#  * hardware, software or other products described herein.  No license, including implied or                   *
#  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
#  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
#  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
#  *                                                                                                            *
#  **************************************************************************************************************
#<copyright-disclaimer-end>
