
//------------------------------------------------------------------------------
`timescale 1 ns/1 ps

module control_logic #(parameter DATA_WIDTH = 8,DSP_DELAY = 3, OUTPUT_REG_DELAY = 1)  
  (clk_i,rst_i,ce_i,load_shift_o,dv_o);
/**********************************************************************************/
/* Input/Output Ports */
/**********************************************************************************/
input clk_i,rst_i,ce_i;
output load_shift_o;
output dv_o;
/**********************************************************************************/
/* Internal Parameters */
/**********************************************************************************/
localparam STATE_WIDTH = 2;
localparam IDLE = 2'b00;
localparam RUN = 2'b01;
localparam LOAD_REG = 2'b11;
localparam COUNTER_DELAY_WIDTH = $clog2(DSP_DELAY+OUTPUT_REG_DELAY);
localparam COUNTER_DATA_WIDTH = $clog2(DATA_WIDTH);
/**********************************************************************************/
/* Internal Signals */
/**********************************************************************************/
reg [STATE_WIDTH-1:0] state = IDLE;
reg [COUNTER_DELAY_WIDTH-1:0] counter_delay = 0;
reg [COUNTER_DATA_WIDTH-1:0] counter_data = 0;
reg load_shift = 1'b0;
reg dv = 1'b0;
/**********************************************************************************/
/* Instances */
/**********************************************************************************/
// - State machine
always @ (posedge clk_i) begin
  if(rst_i) begin
    state <= IDLE;
    counter_data <= 0;
    load_shift <= 1'b0;
    dv <= 1'b0;
  end else begin
    case(state)
      IDLE :  begin
                if(ce_i) begin
                  state <= RUN;  
                  load_shift <= 1'b0;
                  dv <= 1'b0;
                end else begin
                  state <= IDLE;
                  load_shift <= 1'b0;
                  dv <= 1'b0;
                end
              end
      RUN : begin
              if(counter_delay == (DSP_DELAY+OUTPUT_REG_DELAY)-1) begin
                state <= LOAD_REG;
                load_shift <= 1'b1;
                dv <= 1'b0;
              end else begin
                state <= RUN;
                load_shift <= 1'b0; 
                dv <= 1'b0; 
              end
            end
      LOAD_REG :  begin
                    if(counter_data == DATA_WIDTH-1) begin
                      state <= IDLE;
                      counter_data <= 0;
                      load_shift <= 1'b1; 
                      dv <= 1'b1;
                    end else begin
                      state <= RUN;
                      counter_data <= counter_data + 1'b1;
                      load_shift <= 1'b0; 
                      dv <= 1'b0;
                    end
                  end
      default : begin
                  state <= IDLE;
                  counter_data <= 0;
                  load_shift <= 1'b0;
                  dv <= 1'b0;
                end
    endcase
  end
end

always @ (posedge clk_i) begin
  if(rst_i) begin
    counter_delay <= 0;
  end else if(~dv) begin
    if(counter_delay == (DSP_DELAY+OUTPUT_REG_DELAY)-1) 
      counter_delay <= 0;
    else
      counter_delay <= counter_delay + 1'b1;
  end 
end

assign load_shift_o = load_shift;
assign dv_o = dv;

endmodule

//<copyright-disclaimer-start>
//  **************************************************************************************************************
//  * © 2026 Advanced Micro Devices, Inc. All rights reserved.                                                   *
//  * DISCLAIMER                                                                                                 *
//  * The information contained herein is for informational purposes only, and is subject to change              *
//  * without notice. While every precaution has been taken in the preparation of this document, it              *
//  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
//  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
//  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
//  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
//  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
//  * hardware, software or other products described herein.  No license, including implied or                   *
//  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
//  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
//  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
//  *                                                                                                            *
//  **************************************************************************************************************
//<copyright-disclaimer-end>
