//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
//<copyright-disclaimer-start>
//  **************************************************************************************************************
//  * © 2026 Advanced Micro Devices, Inc. All rights reserved.                                                   *
//  * DISCLAIMER                                                                                                 *
//  * The information contained herein is for informational purposes only, and is subject to change              *
//  * without notice. While every precaution has been taken in the preparation of this document, it              *
//  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
//  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
//  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
//  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
//  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
//  * hardware, software or other products described herein.  No license, including implied or                   *
//  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
//  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
//  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
//  *                                                                                                            *
//  **************************************************************************************************************
//<copyright-disclaimer-end>












`timescale 1 ns/1 ps

(* USE_DSP = "YES" *)
module dsp	#(parameter DATA_WIDTH = 8)				
	(clk_i,rst_i,ce_c_i,a_i,c_i,patterndetect_o);
/**********************************************************************************/
/* Internal Parameters */
/**********************************************************************************/	

/**********************************************************************************/
/* Input/Output Ports */
/**********************************************************************************/
input clk_i,rst_i,ce_c_i;
input [DATA_WIDTH-1:0] a_i;
input [(2*DATA_WIDTH)-1:0] c_i;
output patterndetect_o;
/**********************************************************************************/
/* Internal signals */
/**********************************************************************************/
reg [DATA_WIDTH-1:0] a_ff_0 = 0;
reg [DATA_WIDTH-1:0] a_ff_1 = 0;
reg [(2*DATA_WIDTH)-1:0] c_ff = 0;
reg [(2*DATA_WIDTH)-1:0] mult_ff = 0;
wire signed [((2*DATA_WIDTH)+1)-1:0] p;
reg patterndetect_ff = 1'b0;
wire pattern = 1'b0;
/**********************************************************************************/
/* DSP */
/**********************************************************************************/
always @ (posedge clk_i) begin
    if(rst_i) begin
        a_ff_0 <= 0;
        a_ff_1 <= 0;
        c_ff <= 0;
        mult_ff <= 0;
        patterndetect_ff <= 0;
    end else begin 
        a_ff_0 <= a_i;
        a_ff_1 <= a_ff_0;
        if(ce_c_i)
            c_ff <= c_i;
        mult_ff <= a_ff_1 * a_ff_1;
        patterndetect_ff <= p[((2*DATA_WIDTH)+1)-1] == pattern;       
    end
end

assign p = c_ff - mult_ff;
assign patterndetect_o = patterndetect_ff;

endmodule


