

//------------------------------------------------------------------------------
`timescale 1 ns/1 ps

(* DONT_TOUCH = "YES" *)
module top #(parameter DATA_WIDTH = 8, DSP_DELAY = 4, OUTPUT_REG_DELAY = 1)	
	(clk_i,rst_i,ce_i,data_i,data_o,dv_o);
/**********************************************************************************/
/* Input/Output Ports */
/**********************************************************************************/
input clk_i,rst_i,ce_i;
input [DATA_WIDTH-1:0] data_i;
output [DATA_WIDTH-1:0] data_o;
output dv_o;
/**********************************************************************************/
/* Internal Parameters */
/**********************************************************************************/
localparam [DATA_WIDTH-1:0] REG_INIT_VALUE = {1'b1,{(DATA_WIDTH-1){1'b0}}};
localparam [(DATA_WIDTH+1)-1:0] PATTERN1 = {1'b1,{DATA_WIDTH{1'b0}}};
localparam [(DATA_WIDTH+1)-1:0] PATTERN2 = {2'b01,{(DATA_WIDTH-1){1'b0}}};
/**********************************************************************************/
/* Internal Signals */
/**********************************************************************************/
// - Control Logic
wire load_shift;
wire dv;
// - Fabric
wire [DATA_WIDTH-1:0] output_reg;
// - SRL
wire [(DATA_WIDTH+1)-1:0] pattern1, pattern2;
// - DSP
wire patterndetect;
/**********************************************************************************/
/* Instances */
/**********************************************************************************/
// - Control Logic
control_logic #(.DATA_WIDTH(DATA_WIDTH), .DSP_DELAY(DSP_DELAY), .OUTPUT_REG_DELAY(OUTPUT_REG_DELAY))  
  control_logic_inst(
                      .clk_i(clk_i), .rst_i(rst_i), .ce_i(ce_i), 
                      .load_shift_o(load_shift), .dv_o(dv)
                    );

// -  Register Result
fabric #(.DATA_WIDTH(DATA_WIDTH), .INIT_VALUE(REG_INIT_VALUE))       
  fabric_inst (
                .clk_i(clk_i), .rst_i(rst_i|dv), .ce_i(load_shift),
                .pattern1_i(pattern1[(DATA_WIDTH+1)-1:1]), .pattern2_i(pattern2[(DATA_WIDTH+1)-1:1]), .patterndetect_i(patterndetect), 
                .data_o(output_reg)
              );
// - Circular SRL
srl #(.DATA_WIDTH(DATA_WIDTH+1), .INIT_VALUE(PATTERN1))  
  pattern1_inst(
                  .clk_i(clk_i), .ce_i(load_shift), 
                  .data_o(pattern1)
                );

srl #(.DATA_WIDTH(DATA_WIDTH+1), .INIT_VALUE(PATTERN2))  
  pattern2_inst(
                  .clk_i(clk_i), .ce_i(load_shift), 
                  .data_o(pattern2)
                );
// - DSP
dsp  #(.DATA_WIDTH(DATA_WIDTH))       
  dsp_inst (
              .clk_i(clk_i), .rst_i(rst_i), .ce_c_i(ce_i),
              .a_i(output_reg), .c_i({data_i,{(DATA_WIDTH){1'b0}}}),  
              .patterndetect_o(patterndetect)
            );

assign data_o = output_reg;
assign dv_o = dv;
endmodule


//<copyright-disclaimer-start>
//  **************************************************************************************************************
//  * © 2026 Advanced Micro Devices, Inc. All rights reserved.                                                   *
//  * DISCLAIMER                                                                                                 *
//  * The information contained herein is for informational purposes only, and is subject to change              *
//  * without notice. While every precaution has been taken in the preparation of this document, it              *
//  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
//  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
//  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
//  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
//  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
//  * hardware, software or other products described herein.  No license, including implied or                   *
//  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
//  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
//  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
//  *                                                                                                            *
//  **************************************************************************************************************
//<copyright-disclaimer-end>

