#
###########################################################################################
#
#cd $TRAINING_PATH/versal_boot_config/support;chmod 777 versal_boot_config_QemuRun.sh;./versal_boot_config_QemuRun.sh < r5 or a72>
# 
# History:
#    2024/05/29 - RS    - 2024.2 - Created this file based on appRun.sh file from FreeRTOS lab 
###########################################################################################
#

##############             Modify below this         ########################

#Only the next two lines need to be modified if using this file for another lab. 
TC_NAME=versal_boot_config
APP_NAME=bootConfig_app
BOARD=VCK190

# the VITIS_PATH variable points to the installation directory for the current version of Vitis. 
# the following paths are valid for the CustEd VM and CloudShare environments. If you are using
# this on another platform, you will need to modify the following line of code to point to the installation
VITIS_PATH=/opt/amd/2025.2/Vitis
TOOLS=$TRAINING_PATH/tools

##############              No need to modify below this              ########################

# in case this is a new terminal, we need to load the settings64 script
source $VITIS_PATH/settings64.sh
# point to the location of the QEMU binaries
QEMU_ZYNQMP=$VITIS_PATH/data/emulation/qemu/comp/qemu/sysroots/x86_64-petalinux-linux/usr/bin/qemu-system-aarch64
# point to the executable
ELF=$TRAINING_PATH/$TC_NAME/lab/$BOARD/app/$APP_NAME/build/$APP_NAME.elf
#Reading the arguement used along with sourcing the file to find the processor
PROC=$1

if [ $PROC == "a53" ]
then
    echo $PROC
    $QEMU_ZYNQMP -M arm-generic-fdt -nographic \
      -dtb $TOOLS/zynqmp-qemu-arm.dtb \
      -device loader,file=$ELF,cpu-num=1 \
      -device loader,addr=0xfd1a0104,data=0x8000000e,data-len=4
elif [ $PROC == "a72" ]
then
    echo $PROC
    $QEMU_ZYNQMP -M arm-generic-fdt -nographic -serial null -serial null -serial mon:stdio -serial null \
      -dtb $TOOLS/versal-qemu-ps.dtb \
      -device loader,file=$ELF,cpu-num=0 \
      -device loader,addr=0xfd1a0300,data=0x8000000e,data-len=4 
elif [ $PROC == "r5" ]
then
    echo $PROC
    $QEMU_ZYNQMP -M arm-generic-fdt -nographic \
      -dtb $TOOLS/zynqmp-qemu-arm.dtb \
      -device loader,file=$ELF,cpu-num=4 \
      -device loader,addr=0xff5e023c,data=0x80008fde,data-len=4 \
      -device loader,addr=0xff9a0000,data=0x80000218,data-len=4 
else 
    echo $1
    echo "Invalid Processor"
fi
# run the emulator with the arguments

# DONE

#<copyright-disclaimer-start>
#  **************************************************************************************************************
#  * © 2026 Advanced Micro Devices, Inc. All rights reserved.                                                   *
#  * DISCLAIMER                                                                                                 *
#  * The information contained herein is for informational purposes only, and is subject to change              *
#  * without notice. While every precaution has been taken in the preparation of this document, it              *
#  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
#  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
#  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
#  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
#  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
#  * hardware, software or other products described herein.  No license, including implied or                   *
#  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
#  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
#  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
#  *                                                                                                            *
#  **************************************************************************************************************
#<copyright-disclaimer-end>
