/*
 * Decompiled with CFR 0.152.
 */
package directededitor;

import directededitor.ArrayListViewer;
import directededitor.cMessage;
import directededitor.cUtilities;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DirectedEditor {
    protected String version = "1.61";
    protected String verDate = "11 FEB 2023";
    private final String errorIcon = "..\\icons\\Red X Mark.png";
    private final String successIcon = "..\\icons\\Green Check Mark.png";
    private File fileToEdit;
    private File commandFile;
    private boolean debugMode;
    private final ArrayList<String> buf = new ArrayList();
    private ArrayList<commandStructure> cmds;
    private ArrayListViewer debugPortal;
    private String outputFileName;
    private String commentTarget = "";
    private int internalLineMarker = -1;
    private final List<String> llistOfFluffWords = Arrays.asList("with", "on", "to", "new", "line", "lines", "out", "blank", "all", "occurrences", "instances", "this", "the", "at", "through", "-", ":", "then", "of", "every", "each", "from");
    private final ArrayList<String> listOfFluffWords = new ArrayList<String>(this.llistOfFluffWords);
    private final List<String> llistOfCommands = Arrays.asList("replace", "remove", "substitute", "next", "blot", "set", "insert", "append", "add", "prepend", "comment", "uncomment", "find", "delete", "erase", "start");
    private final ArrayList<String> listOfCommands = new ArrayList<String>(this.llistOfCommands);

    public DirectedEditor() {
    }

    public DirectedEditor(File f, File cmdFile) {
        boolean ok = this.fileCheck(f, "source");
        if (!(ok &= this.fileCheck(cmdFile, "ded script"))) {
            System.err.println("File not found, cannot continue...");
            return;
        }
        this.fileToEdit = f;
        this.commandFile = cmdFile;
        this.cmds = new ArrayList();
        this.debugMode = false;
        this.setCommentTypeBasedOnExentsion(f.getName());
    }

    public DirectedEditor(File f, File cmdFile, boolean debug) {
        boolean ok = this.fileCheck(f, "source");
        if (!(ok &= this.fileCheck(cmdFile, "ded script"))) {
            System.err.println("File not found, cannot continue...");
            return;
        }
        this.fileToEdit = f;
        this.commandFile = cmdFile;
        this.cmds = new ArrayList();
        this.debugMode = debug;
        if (this.debugMode) {
            String fName = cmdFile.getName();
            String title = "Array List View for Directed Editor: " + fName;
            this.debugPortal = new ArrayListViewer(title, this.buf, this.version, this.verDate);
            this.debugPortal.setVisible(true);
        }
        this.setCommentTypeBasedOnExentsion(f.getName());
    }

    public DirectedEditor(File f, File cmdFile, File outFile, boolean debug) {
        boolean ok = this.fileCheck(f, "source");
        if (!(ok &= this.fileCheck(cmdFile, "ded script"))) {
            System.err.println("File not found, cannot continue...");
            return;
        }
        this.fileToEdit = f;
        this.commandFile = cmdFile;
        this.cmds = new ArrayList();
        this.debugMode = debug;
        if (this.debugMode) {
            String fName = cmdFile.getName();
            String title = "Array List View for Directed Editor: " + fName;
            this.debugPortal = new ArrayListViewer(title, this.buf, this.version, this.verDate);
            this.debugPortal.setVisible(true);
        }
        this.setCommentTypeBasedOnExentsion(f.getName());
    }

    private boolean fileCheck(File f, String t) {
        if (!f.exists()) {
            System.err.println("Cannot find the " + t + " file: " + f.getAbsolutePath());
            return false;
        }
        return true;
    }

    private void setCommentTypeBasedOnExentsion(String fileName) {
        int pos = fileName.lastIndexOf(46);
        String extension = "";
        if (pos != -1) {
            extension = fileName.substring(pos + 1, fileName.length());
        }
        if (extension.compareToIgnoreCase("VHDL") == 0) {
            this.commentTarget = "--";
        } else if (extension.compareToIgnoreCase("vhd") == 0) {
            this.commentTarget = "--";
        } else if (extension.compareToIgnoreCase("Verilog") == 0) {
            this.commentTarget = "//";
        } else if (extension.compareToIgnoreCase("v") == 0) {
            this.commentTarget = "//";
        } else if (extension.compareToIgnoreCase("Tcl") == 0) {
            this.commentTarget = "#";
        } else if (extension.compareToIgnoreCase("batch") == 0) {
            this.commentTarget = "@Rem ";
        } else if (extension.compareToIgnoreCase("bat") == 0) {
            this.commentTarget = "@Rem ";
        } else if (extension.compareToIgnoreCase("UCF") == 0) {
            this.commentTarget = "#";
        } else if (extension.compareToIgnoreCase("a") == 0) {
            this.commentTarget = ";";
        } else if (extension.compareToIgnoreCase("c") == 0) {
            this.commentTarget = "//";
        } else if (extension.compareToIgnoreCase("h") == 0) {
            this.commentTarget = "//";
        } else if (extension.compareToIgnoreCase("cpp") == 0) {
            this.commentTarget = "//";
        } else if (extension.compareToIgnoreCase("sv") == 0) {
            this.commentTarget = "//";
        } else if (extension.compareToIgnoreCase("py") == 0) {
            this.commentTarget = "#";
        } else if (this.debugMode) {
            this.debugPortal.addToDisplayArea("unable to set comment style due to an unsupported extension");
        }
    }

    private void dumpCommands() {
        for (int i = 0; i < this.cmds.size(); ++i) {
            commandStructure c = this.cmds.get(i);
            System.out.println(c.getCommandOnLineNumber() + ": " + c.getCommand() + " " + c.getTarget() + " " + c.getText() + " " + c.getStartingLineNumber() + ":" + c.getEndingLineNumber());
        }
    }

    private ArrayList<String> prepCommandLine(String line) {
        int i;
        String cleansedLine = line.trim();
        ArrayList<String> listOfWords = null;
        int hashPos = cleansedLine.indexOf("#");
        ArrayList<Integer> quoteLocs = new ArrayList<Integer>();
        int quoteLoc = cleansedLine.indexOf(34);
        while (quoteLoc != -1) {
            if (quoteLoc > 0 && cleansedLine.charAt(quoteLoc - 1) != '\\' || quoteLoc == 0) {
                quoteLocs.add(quoteLoc);
            }
            quoteLoc = cleansedLine.indexOf(34, quoteLoc + 1);
        }
        if (hashPos > -1) {
            if (quoteLocs.isEmpty()) {
                cleansedLine = cleansedLine.substring(0, hashPos);
            } else {
                for (int i2 = 0; i2 < quoteLocs.size(); i2 += 2) {
                    int openingQuote = (Integer)quoteLocs.get(i2);
                    int closingQuote = (Integer)quoteLocs.get(i2 + 1);
                    if (hashPos < openingQuote) {
                        cleansedLine = cleansedLine.substring(0, hashPos);
                        continue;
                    }
                    if (hashPos <= openingQuote || hashPos >= closingQuote) continue;
                    hashPos = cleansedLine.indexOf(35, hashPos + 1);
                }
            }
        }
        cleansedLine = cleansedLine.trim();
        while (cleansedLine.contains("\t")) {
            cleansedLine = cleansedLine.replace('\t', ' ');
        }
        for (int spacePos = 0; spacePos < cleansedLine.length() - 1; ++spacePos) {
            if (!this.isWhiteSpace(cleansedLine.charAt(spacePos)) || !this.isWhiteSpace(cleansedLine.charAt(spacePos + 1))) continue;
            cleansedLine = cleansedLine.substring(0, spacePos) + " " + cleansedLine.substring(spacePos + 2, cleansedLine.length());
        }
        quoteLocs = new ArrayList();
        quoteLoc = cleansedLine.indexOf(34);
        while (quoteLoc != -1) {
            if (quoteLoc > 0 && cleansedLine.charAt(quoteLoc - 1) != '\\' || quoteLoc == 0) {
                quoteLocs.add(quoteLoc);
            }
            quoteLoc = cleansedLine.indexOf(34, quoteLoc + 1);
        }
        for (i = 0; i < quoteLocs.size(); i += 2) {
            int openingQuote = (Integer)quoteLocs.get(i);
            int closingQuote = (Integer)quoteLocs.get(i + 1);
            int spaceLoc = cleansedLine.indexOf(32, openingQuote);
            if (spaceLoc == -1 || spaceLoc <= openingQuote || spaceLoc >= closingQuote || (spaceLoc = (cleansedLine = cleansedLine.substring(0, spaceLoc) + "~" + cleansedLine.substring(spaceLoc + 1, cleansedLine.length())).indexOf(32, spaceLoc + 1)) >= closingQuote) continue;
            i -= 2;
        }
        if (cleansedLine.length() > 0) {
            int delimiterPos = 0;
            int lastDelimiterPos = 0;
            listOfWords = new ArrayList<String>();
            while (delimiterPos < cleansedLine.length()) {
                delimiterPos = cleansedLine.indexOf(" ", lastDelimiterPos);
                if (delimiterPos == -1) {
                    delimiterPos = cleansedLine.length();
                }
                listOfWords.add(cleansedLine.substring(lastDelimiterPos, delimiterPos));
                lastDelimiterPos = delimiterPos + 1;
            }
        }
        if (listOfWords != null) {
            for (i = 0; i < listOfWords.size(); ++i) {
                if (((String)listOfWords.get(i)).length() != 0) continue;
                listOfWords.remove(i);
                --i;
            }
        }
        if (listOfWords != null) {
            for (i = 0; i < listOfWords.size(); ++i) {
                if (((String)listOfWords.get(i)).charAt(0) != '\"' || ((String)listOfWords.get(i)).length() <= 1 || ((String)listOfWords.get(i)).charAt(((String)listOfWords.get(i)).length() - 1) != '\"') continue;
                String replacementString = ((String)listOfWords.get(i)).substring(1, ((String)listOfWords.get(i)).length() - 1);
                replacementString = replacementString.replace('~', ' ');
                listOfWords.set(i, replacementString);
            }
        }
        return listOfWords;
    }

    private void removeFluffWords(ArrayList<String> listOfWords) {
        if (listOfWords == null) {
            return;
        }
        for (int i = 0; i < listOfWords.size(); ++i) {
            String thisWord = listOfWords.get(i);
            if (!this.isFluffWord(thisWord)) continue;
            listOfWords.remove(i--);
        }
    }

    private boolean advLoadCommandsV2() {
        try {
            BufferedReader commandSource = new BufferedReader(new FileReader(this.commandFile.getAbsolutePath()));
            int commandLineNumber = 0;
            while (commandSource.ready()) {
                String line;
                String rawLine = line = commandSource.readLine();
                ++commandLineNumber;
                ArrayList<String> listOfWords = this.prepCommandLine(line);
                if (listOfWords == null || listOfWords.isEmpty()) continue;
                this.removeFluffWords(listOfWords);
                commandStructure cs = new commandStructure();
                cs.setSourceLine(rawLine);
                cs.setCommandNumber(commandLineNumber);
                for (int i = 0; i < listOfWords.size(); ++i) {
                    if (this.isNumber(listOfWords.get(i))) {
                        if (cs.getCommand().compareToIgnoreCase("replace") == 0 && cs.getTarget() == null) {
                            cs.setTarget(listOfWords.get(i));
                            continue;
                        }
                        if (cs.getCommand().compareToIgnoreCase("replace") == 0 && cs.getTarget() != null) {
                            cs.setReplacement(listOfWords.get(i));
                            continue;
                        }
                        if (cs.getCommand().compareToIgnoreCase("substitute") == 0 && cs.getTarget() == null) {
                            cs.setTarget(listOfWords.get(i));
                            continue;
                        }
                        if (cs.getCommand().compareToIgnoreCase("substitute") == 0 && cs.getText() == null) {
                            cs.setText(listOfWords.get(i));
                            continue;
                        }
                        if (cs.startingLine == -1) {
                            cs.startingLine = this.getNumber(listOfWords.get(i));
                            continue;
                        }
                        cs.endingLine = this.getNumber(listOfWords.get(i));
                        continue;
                    }
                    if (this.isCommandWord(listOfWords.get(i))) {
                        cs.setCommand(listOfWords.get(i));
                        continue;
                    }
                    if (listOfWords.get(i).compareToIgnoreCase("dump") == 0) {
                        cs.setShow(true);
                        continue;
                    }
                    if (cs.getTarget() == null) {
                        String cleanTarget = listOfWords.get(i).replace('~', ' ');
                        cleanTarget = cleanTarget.replace("\\\"", "\"");
                        cs.setTarget(cleanTarget);
                        continue;
                    }
                    if (cs.getCommand().compareToIgnoreCase("replace") == 0 && cs.getTarget() != null) {
                        String cleanReplacement = listOfWords.get(i).replace('~', ' ');
                        cleanReplacement = cleanReplacement.replace("\\\"", "\"");
                        cs.setReplacement(cleanReplacement);
                        continue;
                    }
                    cs.setText(listOfWords.get(i).replace('~', ' '));
                }
                if (cs.getStartingLineNumber() > cs.getEndingLineNumber()) {
                    int tempLine = cs.getStartingLineNumber();
                    cs.setStartingLineNumber(cs.getEndingLineNumber());
                    cs.setEndingLineNumber(tempLine);
                }
                this.cmds.add(cs);
            }
        }
        catch (IOException e) {
            if (this.debugMode) {
                this.debugPortal.addToDisplayArea("problem loading commands" + e.toString());
            } else {
                System.err.println("problem loading commands" + e.toString());
            }
            return false;
        }
        return true;
    }

    private boolean isCommandWord(String s) {
        String thisCommand = s.toLowerCase();
        return this.listOfCommands.contains(thisCommand);
    }

    private boolean isFluffWord(String s) {
        for (int i = 0; i < this.listOfFluffWords.size(); ++i) {
            if (s.compareToIgnoreCase(this.listOfFluffWords.get(i)) != 0) continue;
            return true;
        }
        return false;
    }

    private boolean loadCommands() {
        try {
            BufferedReader commandSource = new BufferedReader(new FileReader(this.commandFile.getAbsolutePath()));
            int commandLineNumber = 0;
            while (commandSource.ready()) {
                String line;
                String rawLine = line = commandSource.readLine();
                ++commandLineNumber;
                int pos = (line = line.trim()).indexOf("#");
                if (pos == 0) {
                    line = "";
                    continue;
                }
                if (pos != -1) {
                    line = line.substring(0, pos - 1);
                }
                line = line.trim();
                while (line.contains("\t")) {
                    line = line.replace('\t', ' ');
                }
                for (pos = 0; pos < line.length() - 1; ++pos) {
                    if (!this.isWhiteSpace(line.charAt(pos)) || !this.isWhiteSpace(line.charAt(pos + 1))) continue;
                    line = line.substring(0, pos) + " " + line.substring(pos + 2, line.length());
                }
                pos = line.indexOf("\"");
                while (pos != -1) {
                    int closingQuote = line.indexOf("\"", pos + 1);
                    if (closingQuote == -1) {
                        closingQuote = line.length();
                    }
                    for (int j = pos + 1; j < closingQuote; ++j) {
                        if (line.charAt(j) != ' ') continue;
                        line = line.substring(0, j) + "~" + line.substring(j + 1, line.length());
                    }
                    pos = line.indexOf("\"", closingQuote + 1);
                }
                pos = 0;
                int lastPos = 0;
                ArrayList<String> listOfWords = new ArrayList<String>();
                while (pos < line.length()) {
                    pos = line.indexOf(" ", lastPos);
                    if (pos == -1) {
                        pos = line.length();
                    }
                    if (line.charAt(lastPos) == '\"') {
                        listOfWords.add(line.substring(lastPos + 1, pos - 1));
                    } else {
                        listOfWords.add(line.substring(lastPos, pos));
                    }
                    lastPos = pos + 1;
                }
                for (int i = 0; i < listOfWords.size(); ++i) {
                    String thisWord = (String)listOfWords.get(i);
                    if (!this.isFluffWord(thisWord)) continue;
                    listOfWords.remove(i--);
                }
                if (listOfWords.isEmpty()) continue;
                int fieldNumber = 0;
                commandStructure cs = new commandStructure();
                for (int wordNumber = 0; wordNumber < listOfWords.size(); ++wordNumber) {
                    String word = (String)listOfWords.get(wordNumber);
                    if (this.isNumber(word)) {
                        cs.setStartingLineNumber(this.getNumber(word));
                    } else {
                        switch (fieldNumber) {
                            case 0: {
                                cs.setCommand(word);
                                cs.setCommandOnLineNumber(commandLineNumber);
                                cs.setSourceLine(rawLine);
                                break;
                            }
                            case 1: {
                                if (cs.getCommand() == null) {
                                    if (this.debugMode) {
                                        this.debugPortal.addToDisplayArea("Command missing from line " + commandLineNumber);
                                        break;
                                    }
                                    System.err.println("Command missing from line " + commandLineNumber);
                                    break;
                                }
                                if (cs.getCommand().compareToIgnoreCase("replace") == 0) {
                                    cs.setTarget(word);
                                    break;
                                }
                                if (cs.getCommand().compareToIgnoreCase("set") == 0) {
                                    cs.setTarget(word);
                                    break;
                                }
                                if (this.debugMode) {
                                    this.debugPortal.addToDisplayArea("Unknwon word: " + word + " in command sequence on line " + commandLineNumber);
                                }
                                System.err.println("Unknown word: " + word + " in command sequence on line " + commandLineNumber);
                                break;
                            }
                            case 2: {
                                if (cs.getCommand().compareToIgnoreCase("replace") == 0) {
                                    cs.setText(word);
                                    break;
                                }
                                if (cs.getCommand().compareToIgnoreCase("set") == 0) {
                                    cs.setText(word);
                                    break;
                                }
                                if (cs.getCommand().compareToIgnoreCase("add") == 0 || cs.getCommand().compareToIgnoreCase("insert") == 0 || cs.getCommand().compareToIgnoreCase("prepend") == 0 || cs.getCommand().compareToIgnoreCase("append") == 0) {
                                    word = word.replace('~', ' ');
                                    cs.setText(word);
                                    break;
                                }
                                if (!this.isNumber(word)) break;
                                cs.setText(word);
                                break;
                            }
                            default: {
                                if (this.debugMode) {
                                    this.debugPortal.addToDisplayArea("Unknwon word: " + word);
                                    break;
                                }
                                System.err.println("Unknown word: " + word);
                            }
                        }
                    }
                    ++fieldNumber;
                }
                this.cmds.add(cs);
            }
        }
        catch (IOException e) {
            if (this.debugMode) {
                this.debugPortal.addToDisplayArea("problem loading commands " + e.toString());
            }
            System.err.println("problem loading commands " + e.toString());
            return false;
        }
        return true;
    }

    private boolean isWhiteSpace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    private boolean isNumber(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private int getNumber(String s) {
        try {
            int value = Integer.parseInt(s);
            return value;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private boolean writeTo(File f, String s) {
        try {
            FileOutputStream mergedFileStream = new FileOutputStream(f.getAbsolutePath());
            PrintStream mergedFileOutput = new PrintStream(mergedFileStream);
            mergedFileOutput.println(s);
            mergedFileOutput.close();
            mergedFileStream.close();
        }
        catch (IOException e) {
            if (this.debugMode) {
                this.debugPortal.addToDisplayArea("Error opening the output file: " + e.toString());
            } else {
                System.err.println("Error opening the output file: " + e.toString());
            }
            return false;
        }
        return true;
    }

    public void doEdit() {
        this.internalLineMarker = 0;
        for (int cmdNumber = 0; cmdNumber < this.cmds.size(); ++cmdNumber) {
            block117: {
                commandStructure thisCommand = this.cmds.get(cmdNumber);
                if (this.debugMode) {
                    this.debugPortal.setNextCommand(thisCommand.getSourceLine());
                    this.debugPortal.updateBuffer(this.buf);
                    if (!this.debugPortal.getRunAllButtonPushed()) {
                        while (!this.debugPortal.getNextPushed() && !this.debugPortal.getRunAllButtonPushed()) {
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                }
                int bufLineNumber = thisCommand.getStartingLineNumber() - 1;
                if (thisCommand.getCommand() == null) {
                    if (this.debugMode) {
                        this.debugPortal.addToDisplayArea("invalid command: " + thisCommand.getSourceLine());
                    } else {
                        System.err.println("invalid command: " + thisCommand.getSourceLine());
                    }
                } else if (thisCommand.getCommand().compareToIgnoreCase("replace") == 0) {
                    if (thisCommand.getStartingLineNumber() >= 0) {
                        if (bufLineNumber < this.buf.size()) {
                            String line = this.buf.get(bufLineNumber);
                            line = line.replace(thisCommand.getTarget(), thisCommand.getText());
                            this.buf.set(bufLineNumber, line);
                        } else if (this.debugMode) {
                            this.debugPortal.addToDisplayArea(thisCommand.getCommand() + " has a line number outside of file range");
                        } else {
                            System.err.println(thisCommand.getCommand() + " has a line number outside of file range");
                        }
                    } else {
                        for (int i = 0; i < this.buf.size(); ++i) {
                            String line = this.buf.get(i).replace(thisCommand.getTarget(), thisCommand.getReplacement());
                            this.buf.set(i, line);
                        }
                    }
                } else if (thisCommand.getCommand().compareToIgnoreCase("find") == 0) {
                    if (thisCommand.getText() == null) {
                        thisCommand.setText("start");
                    }
                    if (thisCommand.getText().compareToIgnoreCase("here") == 0) {
                        int startFrom = this.internalLineMarker;
                        if (this.internalLineMarker < 0) {
                            startFrom = 0;
                        }
                        for (int i = startFrom; i < this.buf.size(); ++i) {
                            String line = this.buf.get(i);
                            int positionInLine = line.indexOf(thisCommand.getTarget());
                            if (positionInLine <= -1) continue;
                            this.internalLineMarker = i;
                            if (thisCommand.getShow()) {
                                if (this.debugMode) {
                                    this.debugPortal.addToDisplayArea(i + 1 + ": " + line);
                                } else {
                                    System.out.println(i + 1 + ": " + line);
                                }
                            }
                            break;
                        }
                    } else if (thisCommand.getText().compareToIgnoreCase("end") == 0) {
                        for (int i = this.buf.size() - 1; i >= 0; --i) {
                            String line = this.buf.get(i);
                            int positionInLine = line.indexOf(thisCommand.getTarget());
                            if (positionInLine <= -1) continue;
                            this.internalLineMarker = i;
                            if (thisCommand.getShow()) {
                                if (this.debugMode) {
                                    this.debugPortal.addToDisplayArea(i + 1 + ": " + line);
                                } else {
                                    System.out.println(i + 1 + ": " + line);
                                }
                            }
                            break;
                        }
                    } else {
                        boolean somethingFound = false;
                        for (int i = 0; i < this.buf.size(); ++i) {
                            String line = this.buf.get(i);
                            int positionInLine = line.indexOf(thisCommand.getTarget());
                            if (positionInLine <= -1) continue;
                            somethingFound = true;
                            this.internalLineMarker = i;
                            if (!thisCommand.getShow()) break;
                            if (this.debugMode) {
                                this.debugPortal.addToDisplayArea(i + 1 + ": " + line);
                                break;
                            }
                            System.out.println(i + 1 + ": " + line);
                            break;
                        }
                        if (!somethingFound) {
                            cMessage msg = new cMessage(null, true, "DirectedEditor", "..\\icons\\Red X Mark.png", "Could not locate the target of the FIND command (ded script command #" + thisCommand.getCommandOnLineNumber() + "): \"" + thisCommand.getTarget() + "\"\n Since this will likely cause everything after this point to fail, DirectedEditor will abort now...");
                            System.exit(1);
                        }
                    }
                } else if (thisCommand.getCommand().compareToIgnoreCase("start") == 0) {
                    this.internalLineMarker = thisCommand.getStartingLineNumber() - 1;
                } else if (thisCommand.getCommand().compareToIgnoreCase("Next") == 0) {
                    this.internalLineMarker = thisCommand.getStartingLineNumber() != -1 ? (this.internalLineMarker += thisCommand.getStartingLineNumber()) : ++this.internalLineMarker;
                } else if (thisCommand.getCommand().compareToIgnoreCase("substitute") == 0) {
                    String target = thisCommand.getTarget();
                    String replacement = thisCommand.getText();
                    int lineNumber = this.internalLineMarker;
                    if (thisCommand.getStartingLineNumber() != -1) {
                        lineNumber = thisCommand.getStartingLineNumber() - 1;
                    }
                    if (this.buf.size() > lineNumber) {
                        String thisLine = this.buf.get(lineNumber);
                        thisLine = thisLine.replace(target, replacement);
                        this.buf.set(lineNumber, thisLine);
                    }
                } else if (thisCommand.getCommand().compareToIgnoreCase("blot") == 0) {
                    String target = thisCommand.getTarget();
                    int lineNumber = thisCommand.getStartingLineNumber() - 1;
                    if (this.buf.size() > lineNumber) {
                        String thisLine = this.buf.get(lineNumber);
                        thisLine = thisLine.replace(target, "");
                        this.buf.set(lineNumber, thisLine);
                    }
                } else if (thisCommand.getCommand().compareToIgnoreCase("delete") == 0 || thisCommand.getCommand().compareToIgnoreCase("erase") == 0) {
                    int stopAt;
                    int startAt = thisCommand.getStartingLineNumber() - 1;
                    if (thisCommand.getStartingLineNumber() == -1) {
                        startAt = this.internalLineMarker;
                    }
                    if ((stopAt = thisCommand.getEndingLineNumber()) < 0) {
                        stopAt = startAt;
                    }
                    for (int i = startAt; i < stopAt + 1; ++i) {
                        if (this.buf.size() <= startAt) continue;
                        this.buf.remove(startAt);
                    }
                } else if (thisCommand.getCommand().compareToIgnoreCase("remove") == 0) {
                    int startAt = this.internalLineMarker;
                    int nLinesToDelete = thisCommand.getStartingLineNumber();
                    for (int i = 0; i < nLinesToDelete; ++i) {
                        this.buf.remove(startAt);
                    }
                } else if (thisCommand.getCommand().compareToIgnoreCase("insert") == 0) {
                    File fileToInsert = new File(thisCommand.getTarget());
                    try {
                        BufferedReader commandSource = new BufferedReader(new FileReader(fileToInsert));
                        int lineNumber = thisCommand.getStartingLineNumber();
                        if (lineNumber > this.buf.size()) {
                            lineNumber = this.buf.size() + 1;
                        }
                        while (commandSource.ready()) {
                            this.buf.add(lineNumber - 1, commandSource.readLine());
                            ++lineNumber;
                        }
                        commandSource.close();
                    }
                    catch (IOException e) {
                        if (this.debugMode) {
                            this.debugPortal.addToDisplayArea("Cannot open " + thisCommand.getTarget() + " to insert");
                            break block117;
                        }
                        System.err.println("Cannot open " + thisCommand.getTarget() + " to insert");
                    }
                } else if (thisCommand.getCommand().compareToIgnoreCase("add") == 0) {
                    int insertAt = thisCommand.getStartingLineNumber() == -1 ? this.internalLineMarker : (bufLineNumber >= this.buf.size() ? this.buf.size() : thisCommand.getStartingLineNumber() - 1);
                    if (thisCommand.getTarget() != null) {
                        this.buf.add(insertAt, thisCommand.getTarget());
                    }
                } else if (thisCommand.getCommand().compareToIgnoreCase("append") == 0) {
                    if (bufLineNumber < this.buf.size()) {
                        String replacementString = this.buf.get(bufLineNumber);
                        replacementString = replacementString + thisCommand.getTarget().replace('~', ' ');
                        this.buf.set(bufLineNumber, replacementString);
                    } else if (this.debugMode) {
                        this.debugPortal.addToDisplayArea("Warning! cannot append text since line specified is outside the file boundary");
                    } else {
                        System.err.println("Warning! cannot append text since line specified is outside the file boundary");
                    }
                } else if (thisCommand.getCommand().compareToIgnoreCase("prepend") == 0) {
                    if (bufLineNumber < this.buf.size()) {
                        String replacementString = this.buf.get(bufLineNumber);
                        replacementString = thisCommand.getText() + replacementString;
                        this.buf.set(bufLineNumber, replacementString);
                    } else if (this.debugMode) {
                        this.debugPortal.addToDisplayArea("Warning! cannot append text since line specified is outside the file boundary");
                    } else {
                        System.err.println("Warning! cannot append text since line specified is outside the file boundary");
                    }
                } else if (thisCommand.getCommand().compareToIgnoreCase("set") == 0) {
                    if (thisCommand.getTarget().compareToIgnoreCase("language") == 0) {
                        if (thisCommand.getText().compareToIgnoreCase("VHDL") == 0) {
                            this.commentTarget = "--";
                        } else if (thisCommand.getText().compareToIgnoreCase("Verilog") == 0) {
                            this.commentTarget = "//";
                        } else if (thisCommand.getText().compareToIgnoreCase("Tcl") == 0) {
                            this.commentTarget = "#";
                        } else if (thisCommand.getText().compareToIgnoreCase("batch") == 0) {
                            this.commentTarget = "@Rem ";
                        } else if (thisCommand.getText().compareToIgnoreCase("UCF") == 0) {
                            this.commentTarget = "#";
                        } else if (this.debugMode) {
                            this.debugPortal.addToDisplayArea("Unknown language option");
                        } else {
                            System.err.println("Unknown language option");
                        }
                    } else if (thisCommand.getTarget().compareToIgnoreCase("output") == 0) {
                        this.outputFileName = thisCommand.getText();
                    } else if (thisCommand.getTarget().compareToIgnoreCase("flush") == 0) {
                        this.buf.clear();
                    }
                } else if (thisCommand.getCommand().compareToIgnoreCase("comment") == 0) {
                    int startCommentingAt = thisCommand.getStartingLineNumber();
                    int stopCommentingAt = thisCommand.getEndingLineNumber();
                    if (startCommentingAt == -1 && stopCommentingAt == -1) {
                        startCommentingAt = stopCommentingAt = this.internalLineMarker + 1;
                    } else {
                        if (startCommentingAt < 1) {
                            startCommentingAt = 1;
                        }
                        if (stopCommentingAt < 1) {
                            stopCommentingAt = startCommentingAt;
                        }
                        if (stopCommentingAt > this.buf.size()) {
                            stopCommentingAt = this.buf.size() - 1;
                        }
                    }
                    for (bufLineNumber = startCommentingAt - 1; bufLineNumber < stopCommentingAt; ++bufLineNumber) {
                        String replacementString = this.commentTarget + this.buf.get(bufLineNumber);
                        this.buf.set(bufLineNumber, replacementString);
                    }
                } else if (thisCommand.getCommand().compareToIgnoreCase("uncomment") == 0) {
                    int startCommentingAt = thisCommand.getStartingLineNumber();
                    int stopCommentingAt = thisCommand.getEndingLineNumber();
                    if (startCommentingAt == -1 && stopCommentingAt == -1) {
                        startCommentingAt = stopCommentingAt = this.internalLineMarker + 1;
                    } else {
                        if (startCommentingAt < 1) {
                            startCommentingAt = 1;
                        }
                        if (stopCommentingAt < 1) {
                            stopCommentingAt = startCommentingAt;
                        }
                        if (stopCommentingAt > this.buf.size()) {
                            stopCommentingAt = this.buf.size() - 1;
                        }
                    }
                    for (bufLineNumber = startCommentingAt - 1; bufLineNumber < stopCommentingAt; ++bufLineNumber) {
                        String replacementString = this.buf.get(bufLineNumber);
                        if (!replacementString.contains(this.commentTarget)) continue;
                        this.buf.set(bufLineNumber, replacementString.replaceFirst(this.commentTarget, ""));
                    }
                } else if (this.debugMode) {
                    this.debugPortal.addToDisplayArea("Unknown command in command file: " + thisCommand.getCommand() + " on line " + thisCommand.getCommandOnLineNumber());
                } else {
                    System.err.println("Unknown command in command file: " + thisCommand.getCommand() + " on line " + thisCommand.getCommandOnLineNumber());
                }
            }
            if (!this.debugMode) continue;
            this.debugPortal.setLineNumber(this.internalLineMarker + 1);
        }
        if (this.debugMode) {
            this.debugPortal.setNextCommand("Command List Complete");
            this.debugPortal.updateBuffer(this.buf);
        }
    }

    private void dumpBuffer() {
        for (int i = 0; i < this.buf.size(); ++i) {
            System.out.println(i + 1 + ": " + this.buf.get(i));
        }
    }

    public boolean loadBuffer() {
        BufferedReader fileToEditSource = null;
        try {
            if (this.fileToEdit.getName().compareToIgnoreCase("null") == 0) {
                return true;
            }
            fileToEditSource = new BufferedReader(new FileReader(this.fileToEdit.getAbsolutePath()));
            while (fileToEditSource.ready()) {
                String line = fileToEditSource.readLine();
                this.buf.add(line);
            }
        }
        catch (IOException e) {
            if (this.debugMode) {
                this.debugPortal.addToDisplayArea("problem loading buffer with file to edit: " + e.toString());
            } else {
                System.err.println("problem loading buffer with file to edit: " + e.toString());
            }
            return false;
        }
        return true;
    }

    public String getBuffer() {
        String returnString = "";
        for (int i = 0; i < this.buf.size(); ++i) {
            returnString = returnString + this.buf.get(i) + "\n";
        }
        return returnString;
    }

    public static void main(String[] args) {
        boolean bl;
        boolean argVerbose = false;
        ArrayList<Object> argList = new ArrayList();
        StringBuilder sb = new StringBuilder();
        for (String thisArg : args) {
            sb.append(thisArg).append("~");
        }
        String allArgs = sb.toString();
        int nQuotes = new cUtilities().nOccurrences(allArgs, "\"");
        int nCommas = new cUtilities().nOccurrences(allArgs, ",");
        if (nQuotes <= 0 || nCommas > 0) {
            // empty if block
        }
        if (nCommas > 0) {
            argList = new cUtilities().stringToList(allArgs, ",");
        }
        for (int index = 0; index < argList.size(); ++index) {
            String string = (String)argList.get(index);
            argList.set(index, string.replaceAll("~", " ").trim());
        }
        if (argVerbose) {
            System.out.println("perceived argument list: ");
        }
        for (String string : argList) {
            if (!argVerbose) continue;
            System.out.println("   " + string);
        }
        if (argVerbose) {
            System.out.println("");
        }
        boolean badArgumentConfiguration = false;
        boolean bl2 = false;
        if (argList.size() > 1 && (((String)argList.get(1)).startsWith("{") || ((String)argList.get(1)).startsWith("*"))) {
            bl = true;
            String tdStamp = new cUtilities().getTimeDateStamp();
            String dedFileName = "~temp" + tdStamp + ".ded";
            String dedCmd = (String)argList.get(1);
            if (((String)argList.get(1)).startsWith("{")) {
                dedCmd = dedCmd.substring(1, dedCmd.length() - 1);
            } else if (((String)argList.get(1)).startsWith("*")) {
                dedCmd = dedCmd.substring(1, dedCmd.length());
            }
            argList.set(1, dedFileName);
            try {
                FileWriter fOutputStream = new FileWriter(dedFileName, false);
                BufferedWriter fileOutput = new BufferedWriter(fOutputStream);
                fileOutput.write(dedCmd);
                fileOutput.close();
            }
            catch (IOException e) {
                System.err.println("Could not openForWriting file named: " + dedFileName + "\n " + e.toString());
            }
        }
        boolean debugMode = false;
        if (argList.size() > 0 && "debug".compareToIgnoreCase((String)argList.get(argList.size() - 1)) == 0) {
            debugMode = true;
        }
        String sourceFileName = "";
        String commandFileName = "";
        String resultFileName = "";
        if (argList.size() >= 1) {
            sourceFileName = (String)argList.get(0);
            if ("null".compareToIgnoreCase(sourceFileName) == 0) {
                System.err.println("Source file name (first argument) cannot be null!");
                badArgumentConfiguration = true;
            } else if (argVerbose) {
                System.err.println("Source file identified as: " + sourceFileName);
            }
        } else {
            badArgumentConfiguration = true;
        }
        if (argVerbose) {
            System.err.println("Issue with first argument slot: " + badArgumentConfiguration);
        }
        if (argList.size() >= 2) {
            commandFileName = (String)argList.get(1);
            if ("null".compareToIgnoreCase(commandFileName) == 0) {
                System.err.println("Command file name (second argument) cannot be null!");
                badArgumentConfiguration = true;
            } else if (argVerbose) {
                System.err.println("Command or command file identified as: " + commandFileName);
            }
        } else {
            badArgumentConfiguration = true;
        }
        if (argVerbose) {
            System.err.println("Issue with second argument slot: " + badArgumentConfiguration);
        }
        if (argList.size() >= 3) {
            if ("debug".compareToIgnoreCase((String)argList.get(2)) != 0) {
                resultFileName = (String)argList.get(2);
                if ("null".compareToIgnoreCase(resultFileName) == 0) {
                    System.err.println("Results file name (third argument) cannot be null!");
                    badArgumentConfiguration = true;
                } else if (argVerbose) {
                    System.err.println("Result (output) file identified as: " + resultFileName);
                }
            } else if (argVerbose) {
                System.err.println("Debug was the third argument so debug mode is enabled, but the result file is undefined");
            }
        }
        if (argVerbose) {
            System.err.println("Issue with third argument slot: " + badArgumentConfiguration);
        }
        if (resultFileName.length() == 0) {
            resultFileName = sourceFileName;
            if (argVerbose) {
                System.err.println("Result file name was not specified, so we're going to use: " + resultFileName);
            }
        }
        DirectedEditor de = new DirectedEditor();
        if (badArgumentConfiguration) {
            System.out.println("directedEditor - " + de.version + " " + de.verDate);
            System.out.println("usage: directedEditor <fileToEdit>,<*instruction|{instruction}>,[<output file>]");
            System.out.println("usage: directedEditor <fileToEdit> <command script> [<output file>]");
            System.out.println("usage: directedEditor <fileToEdit>,<command script>[,<output file>][,<debug>]  (no spaces between args)");
            System.exit(0);
        }
        de = new DirectedEditor(new File(sourceFileName), new File(commandFileName), debugMode);
        boolean bufferLoaded = de.loadBuffer();
        boolean cmdLoaded = de.advLoadCommandsV2();
        if (bufferLoaded && cmdLoaded) {
            de.doEdit();
            String buffer = de.getBuffer();
            de.writeTo(new File(resultFileName), buffer);
        }
        if (bl) {
            new File(commandFileName).delete();
            if (argVerbose) {
                System.err.println("Deleting temporary file: " + commandFileName);
            }
        }
    }

    private class commandStructure {
        private String sourceLine;
        private String command;
        private int cmdNumber;
        private int startingLine = -1;
        private int endingLine = -1;
        public String target;
        private String replacement;
        private String text;
        private int onLine;
        private boolean show = false;

        public void setCommandNumber(int n) {
            this.cmdNumber = n;
        }

        public int getCommandNumber() {
            return this.cmdNumber;
        }

        public void setCommand(String s) {
            this.command = s;
        }

        public void setStartingLineNumber(int i) {
            this.startingLine = i;
        }

        public void setEndingLineNumber(int i) {
            this.startingLine = i;
        }

        public void setTarget(String s) {
            this.target = s;
        }

        public void setReplacement(String s) {
            this.replacement = s;
        }

        public void setText(String s) {
            this.text = s;
        }

        public void setSourceLine(String s) {
            this.sourceLine = s;
        }

        public void setCommandOnLineNumber(int l) {
            this.onLine = l;
        }

        public String getCommand() {
            return this.command;
        }

        public int getStartingLineNumber() {
            return this.startingLine;
        }

        public int getEndingLineNumber() {
            return this.endingLine;
        }

        public String getTarget() {
            return this.target;
        }

        public String getReplacement() {
            return this.replacement;
        }

        public String getText() {
            return this.text;
        }

        public int getCommandOnLineNumber() {
            return this.onLine;
        }

        public String getSourceLine() {
            return this.sourceLine;
        }

        public void setShow(boolean b) {
            this.show = b;
        }

        public boolean getShow() {
            return this.show;
        }
    }
}

