/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi;

import org.apache.poi.POIXMLDocument;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.openxml4j.opc.internal.PackagePropertiesPart;
import org.openxmlformats.schemas.officeDocument.x2006.customProperties.CTProperties;
import org.openxmlformats.schemas.officeDocument.x2006.customProperties.CTProperty;

public class POIXMLPropertiesTextExtractor
extends POIXMLTextExtractor {
    public POIXMLPropertiesTextExtractor(POIXMLDocument doc) {
        super(doc);
    }

    public POIXMLPropertiesTextExtractor(POIXMLTextExtractor otherExtractor) {
        super(otherExtractor.getDocument());
    }

    public String getCorePropertiesText() {
        StringBuffer text = new StringBuffer();
        PackagePropertiesPart props = this.getDocument().getProperties().getCoreProperties().getUnderlyingProperties();
        text.append("Category = " + props.getCategoryProperty().getValue() + "\n");
        text.append("ContentStatus = " + props.getContentStatusProperty().getValue() + "\n");
        text.append("ContentType = " + props.getContentTypeProperty().getValue() + "\n");
        text.append("Created = " + props.getCreatedProperty().getValue() + "\n");
        text.append("CreatedString = " + props.getCreatedPropertyString() + "\n");
        text.append("Creator = " + props.getCreatorProperty().getValue() + "\n");
        text.append("Description = " + props.getDescriptionProperty().getValue() + "\n");
        text.append("Identifier = " + props.getIdentifierProperty().getValue() + "\n");
        text.append("Keywords = " + props.getKeywordsProperty().getValue() + "\n");
        text.append("Language = " + props.getLanguageProperty().getValue() + "\n");
        text.append("LastModifiedBy = " + props.getLastModifiedByProperty().getValue() + "\n");
        text.append("LastPrinted = " + props.getLastPrintedProperty().getValue() + "\n");
        text.append("LastPrintedString = " + props.getLastPrintedPropertyString() + "\n");
        text.append("Modified = " + props.getModifiedProperty().getValue() + "\n");
        text.append("ModifiedString = " + props.getModifiedPropertyString() + "\n");
        text.append("Revision = " + props.getRevisionProperty().getValue() + "\n");
        text.append("Subject = " + props.getSubjectProperty().getValue() + "\n");
        text.append("Title = " + props.getTitleProperty().getValue() + "\n");
        text.append("Version = " + props.getVersionProperty().getValue() + "\n");
        return text.toString();
    }

    public String getExtendedPropertiesText() {
        StringBuffer text = new StringBuffer();
        org.openxmlformats.schemas.officeDocument.x2006.extendedProperties.CTProperties props = this.getDocument().getProperties().getExtendedProperties().getUnderlyingProperties();
        text.append("Application = " + props.getApplication() + "\n");
        text.append("AppVersion = " + props.getAppVersion() + "\n");
        text.append("Characters = " + props.getCharacters() + "\n");
        text.append("CharactersWithSpaces = " + props.getCharactersWithSpaces() + "\n");
        text.append("Company = " + props.getCompany() + "\n");
        text.append("HyperlinkBase = " + props.getHyperlinkBase() + "\n");
        text.append("HyperlinksChanged = " + props.getHyperlinksChanged() + "\n");
        text.append("Lines = " + props.getLines() + "\n");
        text.append("LinksUpToDate = " + props.getLinksUpToDate() + "\n");
        text.append("Manager = " + props.getManager() + "\n");
        text.append("Pages = " + props.getPages() + "\n");
        text.append("Paragraphs = " + props.getParagraphs() + "\n");
        text.append("PresentationFormat = " + props.getPresentationFormat() + "\n");
        text.append("Template = " + props.getTemplate() + "\n");
        text.append("TotalTime = " + props.getTotalTime() + "\n");
        return text.toString();
    }

    public String getCustomPropertiesText() {
        StringBuffer text = new StringBuffer();
        CTProperties props = this.getDocument().getProperties().getCustomProperties().getUnderlyingProperties();
        CTProperty[] properties = props.getPropertyArray();
        for (int i = 0; i < properties.length; ++i) {
            String val = "(not implemented!)";
            text.append(properties[i].getName() + " = " + val + "\n");
        }
        return text.toString();
    }

    public String getText() {
        try {
            return this.getCorePropertiesText() + this.getExtendedPropertiesText() + this.getCustomPropertiesText();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public POIXMLPropertiesTextExtractor getMetadataTextExtractor() {
        throw new IllegalStateException("You already have the Metadata Text Extractor, not recursing!");
    }
}

