//
// Copyright (C) 2026, Advanced Micro Devices, Inc. All rights reserved.
// SPDX-License-Identifier: X11
//

`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date: 09/14/2023 11:48:30 AM
// Design Name: 
// Module Name: pl_slave
// Project Name: 
// Target Devices: 
// Tool Versions: 
// Description: 
// 
// Dependencies: 
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
//////////////////////////////////////////////////////////////////////////////////


module pl_slave_from_cips #(
   parameter S0_AXI_AWADDR_WIDTH = 48,
   parameter S0_AXI_AWLEN_WIDTH = 8,
   parameter S0_AXI_AWSIZE_WIDTH = 3,
   parameter S0_AXI_AWBURST_WIDTH = 2,
   parameter S0_AXI_AWCACHE_WIDTH = 4,
   parameter S0_AXI_AWPROT_WIDTH = 3,
   parameter S0_AXI_AWREGION_WIDTH = 4,
   parameter S0_AXI_AWQOS_WIDTH = 4,
   parameter S0_AXI_WDATA_WIDTH = 512,
   parameter S0_AXI_WSTRB_WIDTH = 64,
   parameter S0_AXI_BRESP_WIDTH = 2,
   parameter S0_AXI_ARADDR_WIDTH = 48,
   parameter S0_AXI_ARLEN_WIDTH = 8,
   parameter S0_AXI_ARSIZE_WIDTH = 3,
   parameter S0_AXI_ARBURST_WIDTH = 2,
   parameter S0_AXI_ARCACHE_WIDTH = 4,
   parameter S0_AXI_ARPROT_WIDTH = 3,
   parameter S0_AXI_ARREGION_WIDTH = 4,
   parameter S0_AXI_ARQOS_WIDTH = 4,
   parameter S0_AXI_RDATA_WIDTH = 512,
   parameter S0_AXI_RRESP_WIDTH = 2,
   parameter S0_AXI_ARID_WIDTH = 2,
   parameter S0_AXI_AWID_WIDTH = 2,
   parameter S0_AXI_BID_WIDTH = 2,
   parameter S0_AXI_RID_WIDTH = 2  
)(
    input clk,
    input rstn
    );

  wire [S0_AXI_AWADDR_WIDTH-1 : 0] s_axi_awaddr;
  wire [S0_AXI_AWLEN_WIDTH-1 : 0] s_axi_awlen;
  wire [S0_AXI_AWSIZE_WIDTH-1 : 0] s_axi_awsize;
  wire [S0_AXI_AWBURST_WIDTH-1 : 0] s_axi_awburst;
  wire s_axi_awlock;
  wire [S0_AXI_AWCACHE_WIDTH-1 : 0] s_axi_awcache;
  wire [S0_AXI_AWPROT_WIDTH-1 : 0] s_axi_awprot;
  wire s_axi_awvalid;
  wire s_axi_awready;
  wire [S0_AXI_WDATA_WIDTH-1 : 0] s_axi_wdata;
  wire [S0_AXI_WSTRB_WIDTH-1 : 0] s_axi_wstrb;
  wire s_axi_wlast;
  wire s_axi_wvalid;
  wire s_axi_wready;
  wire [S0_AXI_BRESP_WIDTH-1 : 0] s_axi_bresp;
  wire s_axi_bvalid;
  wire s_axi_bready;
  wire [S0_AXI_ARADDR_WIDTH-1 : 0] s_axi_araddr;
  wire [S0_AXI_ARLEN_WIDTH-1 : 0] s_axi_arlen;
  wire [S0_AXI_ARSIZE_WIDTH-1 : 0] s_axi_arsize;
  wire [S0_AXI_ARBURST_WIDTH-1 : 0] s_axi_arburst;
  wire s_axi_arlock;
  wire [S0_AXI_ARCACHE_WIDTH-1 : 0] s_axi_arcache;
  wire [S0_AXI_ARPROT_WIDTH-1 : 0] s_axi_arprot;
  wire s_axi_arvalid;
  wire s_axi_arready;
  wire [S0_AXI_RDATA_WIDTH-1 : 0] s_axi_rdata;
  wire [S0_AXI_RRESP_WIDTH-1 : 0] s_axi_rresp;
  wire s_axi_rlast;
  wire s_axi_rvalid;
  wire s_axi_rready;
  wire [S0_AXI_AWID_WIDTH-1:0 ] s_axi_awid;
  wire [S0_AXI_BID_WIDTH-1:0 ] s_axi_bid;
  wire [S0_AXI_ARID_WIDTH-1:0 ] s_axi_arid;
  wire [S0_AXI_RID_WIDTH-1:0 ] s_axi_rid;



axi_bram_ctrl_pl_slave_from_ps axi_bram_ctrl_pl_slave_from_cips_inst (
  .s_axi_aclk(clk),        // input wire s_axi_aclk
  .s_axi_aresetn(rstn),  // input wire s_axi_aresetn
  .s_axi_awid(s_axi_awid),        // input wire [1 : 0] s_axi_awid
  .s_axi_awaddr(s_axi_awaddr),    // input wire [15 : 0] s_axi_awaddr
  .s_axi_awlen(s_axi_awlen),      // input wire [7 : 0] s_axi_awlen
  .s_axi_awsize(s_axi_awsize),    // input wire [2 : 0] s_axi_awsize
  .s_axi_awburst(s_axi_awburst),  // input wire [1 : 0] s_axi_awburst
  .s_axi_awlock(s_axi_awlock),    // input wire s_axi_awlock
  .s_axi_awcache(s_axi_awcache),  // input wire [3 : 0] s_axi_awcache
  .s_axi_awprot(s_axi_awprot),    // input wire [2 : 0] s_axi_awprot
  .s_axi_awvalid(s_axi_awvalid),  // input wire s_axi_awvalid
  .s_axi_awready(s_axi_awready),  // output wire s_axi_awready
  .s_axi_wdata(s_axi_wdata),      // input wire [511 : 0] s_axi_wdata
  .s_axi_wstrb(s_axi_wstrb),      // input wire [63 : 0] s_axi_wstrb
  .s_axi_wlast(s_axi_wlast),      // input wire s_axi_wlast
  .s_axi_wvalid(s_axi_wvalid),    // input wire s_axi_wvalid
  .s_axi_wready(s_axi_wready),    // output wire s_axi_wready
  .s_axi_bid(s_axi_bid),          // output wire [1 : 0] s_axi_bid
  .s_axi_bresp(s_axi_bresp),      // output wire [1 : 0] s_axi_bresp
  .s_axi_bvalid(s_axi_bvalid),    // output wire s_axi_bvalid
  .s_axi_bready(s_axi_bready),    // input wire s_axi_bready
  .s_axi_arid(s_axi_arid),        // input wire [1 : 0] s_axi_arid
  .s_axi_araddr(s_axi_araddr),    // input wire [15 : 0] s_axi_araddr
  .s_axi_arlen(s_axi_arlen),      // input wire [7 : 0] s_axi_arlen
  .s_axi_arsize(s_axi_arsize),    // input wire [2 : 0] s_axi_arsize
  .s_axi_arburst(s_axi_arburst),  // input wire [1 : 0] s_axi_arburst
  .s_axi_arlock(s_axi_arlock),    // input wire s_axi_arlock
  .s_axi_arcache(s_axi_arcache),  // input wire [3 : 0] s_axi_arcache
  .s_axi_arprot(s_axi_arprot),    // input wire [2 : 0] s_axi_arprot
  .s_axi_arvalid(s_axi_arvalid),  // input wire s_axi_arvalid
  .s_axi_arready(s_axi_arready),  // output wire s_axi_arready
  .s_axi_rid(s_axi_rid),          // output wire [1 : 0] s_axi_rid
  .s_axi_rdata(s_axi_rdata),      // output wire [511 : 0] s_axi_rdata
  .s_axi_rresp(s_axi_rresp),      // output wire [1 : 0] s_axi_rresp
  .s_axi_rlast(s_axi_rlast),      // output wire s_axi_rlast
  .s_axi_rvalid(s_axi_rvalid),    // output wire s_axi_rvalid
  .s_axi_rready(s_axi_rready)    // input wire s_axi_rready
);

//"Instantiate xpm_nsu_mm here" 

   xpm_nsu_mm #(
      .ADDR_WIDTH(S0_AXI_AWADDR_WIDTH),                // DECIMAL
      .AUSER_WIDTH(16),               // DECIMAL
      .DATA_WIDTH(S0_AXI_WDATA_WIDTH),               // DECIMAL
      .DUSER_WIDTH(0),              // DECIMAL
      .ENABLE_FIREWALL("false"),      // STRING
      .ENABLE_USR_INTERRUPT("false"), // STRING
      .ID_WIDTH(2),                   // DECIMAL
      .NOC_FABRIC("VNOC"),            // STRING
      .SIDEBAND_PINS("false")         // STRING
   )
   xpm_nsu_mm_pl_slave_from_cips (
      .m_axi_araddr(s_axi_araddr),                 // ADDR_WIDTH-bit output: ARADDR: The read address bus gives the initial address of a read burst
                                                   // transaction. Only the start address of the burst is provided and the control signals that are
                                                   // issued alongside the address detail how the address is calculated for the remaining transfers
                                                   // in the burst.

      .m_axi_arburst(s_axi_arburst),               // 2-bit output: ARBURST: The burst type, coupled with the size information, details how the
                                                   // address for each transfer within the burst is calculated.

      .m_axi_arcache(s_axi_arcache),               // 4-bit output: ARCACHE: Indicates the bufferable, cacheable, write-through, write-back, and
                                                   // allocate attributes of the transaction.

      .m_axi_arid(s_axi_arid),                     // ID_WIDTH-bit output: ARID: The data stream identifier that indicates different streams of data.
      .m_axi_arlen(s_axi_arlen),                   // 4-bit output: ARLEN: The burst length gives the exact number of transfers in a burst. This
                                                   // information determines the number of data transfers associated with the address.

      .m_axi_arlock(s_axi_arlock),                 // 1-bit output: ARLOCK: This signal provides additional information about the atomic
                                                   // characteristics of the transfer.

      .m_axi_arprot(s_axi_arprot),                 // 3-bit output: ARPROT: Indicates the normal, privileged, or secure protection level of the
                                                   // transaction and whether the transaction is a data access or an instruction access.

      .m_axi_arqos(s_axi_arqos),                   // 4-bit output: ARQOS: Quality of Service (QoS) sent on the write address channel for each write
                                                   // transaction.

      .m_axi_arregion(s_axi_arregion),             // 4-bit output: ARREGION: Region identifier. Permits a single physical interface on a subordinate
                                                   // to be used for multiple logical interfaces.

      .m_axi_arsize(s_axi_arsize),                 // 3-bit output: ARSIZE: Indicates the size of each transfer in the burst. Byte lane strobes
                                                   // indicate exactly which byte lanes to update.

      .m_axi_aruser(s_axi_aruser),                 // AUSER_WIDTH-bit output: ARUSER: User signal. Optional User-defined signal in the read address
                                                   // channel.

      .m_axi_arvalid(s_axi_arvalid),               // 1-bit output: ARVALID: Indicates that the master is driving a valid transfer. A transfer takes
                                                   // place when both ARVALID and ARREADY are asserted

      .m_axi_awaddr(s_axi_awaddr),                 // ADDR_WIDTH-bit output: AWADDR: The write address bus gives the address of the first transfer in
                                                   // a write burst transaction. The associated control signals are used to determine the addresses
                                                   // of the remaining transfers in the burst.

      .m_axi_awburst(s_axi_awburst),               // 2-bit output: AWBURST: The burst type, coupled with the size information, details how the
                                                   // address for each transfer within the burst is calculated.

      .m_axi_awcache(s_axi_awcache),               // 4-bit output: AWCACHE: Indicates the bufferable, cacheable, write-through, write-back, and
                                                   // allocate attributes of the transaction.

      .m_axi_awid(s_axi_awid),                     // ID_WIDTH-bit output: AWID: Identification tag for the write address group of signals.
      .m_axi_awlen(s_axi_awlen),                   // 8-bit output: AWLEN: The burst length gives the exact number of transfers in a burst. This
                                                   // information determines the number of data transfers associated with the address.

      .m_axi_awlock(s_axi_awlock),                 // 1-bit output: AWLOCK: This signal provides additional information about the atomic
                                                   // characteristics of the transfer.

      .m_axi_awprot(s_axi_awprot),                 // 3-bit output: AWPROT: Indicates the normal, privileged, or secure protection level of the
                                                   // transaction and whether the transaction is a data access or an instruction access.

      .m_axi_awqos(s_axi_awqos),                   // 4-bit output: AWQOS: Quality of Service (QoS) sent on the write address channel for each write
                                                   // transaction.

      .m_axi_awregion(s_axi_awregion),             // 4-bit output: AWREGION: Permits a single physical interface on a subordinate to be used for
                                                   // multiple logical interfaces.

      .m_axi_awsize(s_axi_awsize),                 // 3-bit output: AWSIZE: Indicates the size of each transfer in the burst. Byte lane strobes
                                                   // indicate exactly which byte lanes to update.

      .m_axi_awuser(s_axi_awuser),                 // AUSER_WIDTH-bit output: AWUSER: Optional User-defined signal in the write address channel.
      .m_axi_awvalid(s_axi_awvalid),               // 1-bit output: AWVALID: Indicates that the master is driving a valid transfer. A transfer takes
                                                   // place when both AWVALID and AWREADY are asserted

      .m_axi_bready(s_axi_bready),                 // 1-bit output: BREADY: Indicates that the slave can accept a transfer in the current cycle.
      .m_axi_out(),                       // 1-bit output: AXI ouput signal
      .m_axi_rready(s_axi_rready),                 // 1-bit output: RREADY: Indicates that the slave can accept a transfer in the current cycle.
      .m_axi_wdata(s_axi_wdata),                   // DATA_WIDTH-bit output: WDATA: The primary payload that is used to provide the data that is
                                                   // passing across the interface. The width of the data payload is an integer number of bytes.

      .m_axi_wlast(s_axi_wlast),                   // 1-bit output: WLAST: Indicates the boundary of a packet.
      .m_axi_wstrb(s_axi_wstrb),                   // DATA_WIDTH/8-bit output: WSTRB: The byte qualifier that indicates whether the content of the
                                                   // associated byte of TDATA is processed as a data byte or a position byte. For a 64-bit DATA, bit
                                                   // 0 corresponds to the least significant byte on DATA, and bit 0 corresponds to the least
                                                   // significant byte on DATA, and bit 7 corresponds to the most significant byte. For example:
                                                   // STROBE[0] = 1b, DATA[7:0] is valid STROBE[7] = 0b, DATA[63:56] is not valid

      .m_axi_wuser(s_axi_wuser),                   // DUSER_WIDTH-bit output: WUSER: User signal. Optional User-defined signal in the write data
                                                   // channel.

      .m_axi_wvalid(s_axi_wvalid),                 // 1-bit output: WVALID: Indicates that the master is driving a valid transfer. A transfer takes
                                                   // place when both WVALID and WREADY are asserted

      .nsu_firewall_err(nsu_firewall_err),         // 1-bit output: Indicates that firewall error occured during write or read transaction
      .m_axi_aclk(clk),                     // 1-bit input: Master Interface Clock: All signals on slave interface are sampled on the rising
                                                   // edge of this clock.

      .m_axi_arready(s_axi_arready),               // 1-bit input: ARREADY: Indicates that the slave can accept a transfer in the current cycle.
      .m_axi_awready(s_axi_awready),               // 1-bit input: AWREADY: Indicates that the slave can accept a transfer in the current cycle.
      .m_axi_bid(s_axi_bid),                       // ID_WIDTH-bit input: BID: The data stream identifier that indicates different streams of data.
      .m_axi_bresp(s_axi_bresp),                   // 2-bit input: BRESP: Indicates the status of the write transaction. The allowable responses are
                                                   // OKAY, EXOKAY, SLVERR, and DECERR.

      .m_axi_buser(s_axi_buser),                   // 2-bit input: BUSER: Optional User-defined signal in the write response channel.
      .m_axi_bvalid(s_axi_bvalid),                 // 1-bit input: BVALID: Indicates that the master is driving a valid transfer. A transfer takes
                                                   // place when both BVALID and BREADY are asserted

      .m_axi_rdata(s_axi_rdata),                   // DATA_WIDTH-bit input: RDATA: The primary payload that is used to provide the data that is
                                                   // passing across the interface. The width of the data payload is an integer number of bytes.

      .m_axi_rid(s_axi_rid),                       // ID_WIDTH-bit input: RID: The data stream identifier that indicates different streams of data.
      .m_axi_rlast(s_axi_rlast),                   // 1-bit input: RLAST: Indicates the boundary of a packet.
      .m_axi_rresp(s_axi_rresp),                   // 2-bit input: RRESP: Indicates the status of the read transfer. The allowable responses are
                                                   // OKAY, EXOKAY, SLVERR, and DECERR.

      .m_axi_ruser(s_axi_ruser),                   // DUSER_WIDTH-bit input: RUSER: User signal. Optional User-defined signal in the read data
                                                   // channel.

      .m_axi_rvalid(s_axi_rvalid),                 // 1-bit input: RVALID: Indicates that the master is driving a valid transfer. A transfer takes
                                                   // place when both RVALID and RREADY are asserted

      .m_axi_wready(s_axi_wready),                 // 1-bit input: WREADY: Indicates that the slave can accept a transfer in the current cycle.
      .nsu_usr_interrupt_in(4'b0)  // 4-bit input: User interrupt signal
   );
// End of xpm_nsu_mm_inst instantiation
	

endmodule

