// Copyright 1986-2022 Xilinx, Inc. All Rights Reserved.
// Copyright 2022-2025 Advanced Micro Devices, Inc. All Rights Reserved.
// -------------------------------------------------------------------------------
// This file contains confidential and proprietary information
// of AMD and is protected under U.S. and international copyright
// and other intellectual property laws.
//
// DISCLAIMER
// This disclaimer is not a license and does not grant any
// rights to the materials distributed herewith. Except as
// otherwise provided in a valid license issued to you by
// AMD, and to the maximum extent permitted by applicable
// law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
// WITH ALL FAULTS, AND AMD HEREBY DISCLAIMS ALL WARRANTIES
// AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
// BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
// INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
// (2) AMD shall not be liable (whether in contract or tort,
// including negligence, or under any other theory of
// liability) for any loss or damage of any kind or nature
// related to, arising under or in connection with these
// materials, including for any direct, or any indirect,
// special, incidental, or consequential loss or damage
// (including loss of data, profits, goodwill, or any type of
// loss or damage suffered as a result of any action brought
// by a third party) even if such damage or loss was
// reasonably foreseeable or AMD had been advised of the
// possibility of the same.
//
// CRITICAL APPLICATIONS
// AMD products are not designed or intended to be fail-
// safe, or for use in any application requiring fail-safe
// performance, such as life-support or safety devices or
// systems, Class III medical devices, nuclear facilities,
// applications related to the deployment of airbags, or any
// other applications that could lead to death, personal
// injury, or severe property or environmental damage
// (individually and collectively, "Critical
// Applications"). Customer assumes the sole risk and
// liability of any use of AMD products in Critical
// Applications, subject only to applicable laws and
// regulations governing limitations on product liability.
//
// THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
// PART OF THIS FILE AT ALL TIMES.
//
// DO NOT MODIFY THIS FILE.

// MODULE VLNV: xilinx.com:ip:perf_axi_tg:1.0

`timescale 1ps / 1ps

`include "vivado_interfaces.svh"

module perf_axi_tg_pl_master_to_ddr_sv (
  (* X_INTERFACE_INFO = "xilinx.com:interface:aximm:1.0 M_AXI" *)
  (* X_INTERFACE_MODE = "master M_AXI" *)
  (* X_INTERFACE_PARAMETER = "XIL_INTERFACENAME M_AXI, DATA_WIDTH 512, PROTOCOL AXI4, FREQ_HZ 100000000, ID_WIDTH 1, ADDR_WIDTH 48, AWUSER_WIDTH 16, ARUSER_WIDTH 16, WUSER_WIDTH 16, RUSER_WIDTH 16, BUSER_WIDTH 16, READ_WRITE_MODE READ_WRITE, HAS_BURST 1, HAS_LOCK 1, HAS_PROT 1, HAS_CACHE 1, HAS_QOS 1, HAS_REGION 1, HAS_WSTRB 1, HAS_BRESP 1, HAS_RRESP 1, SUPPORTS_NARROW_BURST 1, NUM_READ_OUTSTANDING 2, NUM_WRITE_OUTSTANDING 2, MAX_BURST_LENGTH 256, PHASE 0.0, NUM_READ_THREADS 1, NUM_WRITE_THREADS 1, RUSER_BITS_PER_BYTE 0, WUSER_BITS_PER_BYTE 0, INSERT_VIP 0" *)
  vivado_aximm_v1_0.master M_AXI,
  (* X_INTERFACE_IGNORE = "true" *)
  input wire clk,
  (* X_INTERFACE_IGNORE = "true" *)
  input wire tg_rst_n,
  (* X_INTERFACE_IGNORE = "true" *)
  input wire axi_tg_start,
  (* X_INTERFACE_IGNORE = "true" *)
  output wire axi_tg_done,
  (* X_INTERFACE_IGNORE = "true" *)
  output wire axi_tg_error
);

  // interface wire assignments
  assign M_AXI.WID = 0;

  perf_axi_tg_pl_master_to_ddr inst (
    .clk(clk),
    .tg_rst_n(tg_rst_n),
    .axi_awid(M_AXI.AWID),
    .axi_awaddr(M_AXI.AWADDR),
    .axi_awlen(M_AXI.AWLEN),
    .axi_awsize(M_AXI.AWSIZE),
    .axi_awburst(M_AXI.AWBURST),
    .axi_awlock(M_AXI.AWLOCK),
    .axi_awcache(M_AXI.AWCACHE),
    .axi_awprot(M_AXI.AWPROT),
    .axi_awregion(M_AXI.AWREGION),
    .axi_awqos(M_AXI.AWQOS),
    .axi_awuser(M_AXI.AWUSER),
    .axi_awvalid(M_AXI.AWVALID),
    .axi_awready(M_AXI.AWREADY),
    .axi_wdata(M_AXI.WDATA),
    .axi_wstrb(M_AXI.WSTRB),
    .axi_wlast(M_AXI.WLAST),
    .axi_wuser(M_AXI.WUSER),
    .axi_wvalid(M_AXI.WVALID),
    .axi_wready(M_AXI.WREADY),
    .axi_bid(M_AXI.BID),
    .axi_bresp(M_AXI.BRESP),
    .axi_buser(M_AXI.BUSER),
    .axi_bvalid(M_AXI.BVALID),
    .axi_bready(M_AXI.BREADY),
    .axi_arid(M_AXI.ARID),
    .axi_araddr(M_AXI.ARADDR),
    .axi_arlen(M_AXI.ARLEN),
    .axi_arsize(M_AXI.ARSIZE),
    .axi_arburst(M_AXI.ARBURST),
    .axi_arlock(M_AXI.ARLOCK),
    .axi_arcache(M_AXI.ARCACHE),
    .axi_arprot(M_AXI.ARPROT),
    .axi_arregion(M_AXI.ARREGION),
    .axi_arqos(M_AXI.ARQOS),
    .axi_aruser(M_AXI.ARUSER),
    .axi_arvalid(M_AXI.ARVALID),
    .axi_arready(M_AXI.ARREADY),
    .axi_rid(M_AXI.RID),
    .axi_rdata(M_AXI.RDATA),
    .axi_rresp(M_AXI.RRESP),
    .axi_rlast(M_AXI.RLAST),
    .axi_ruser(M_AXI.RUSER),
    .axi_rvalid(M_AXI.RVALID),
    .axi_rready(M_AXI.RREADY),
    .axi_tg_start(axi_tg_start),
    .axi_tg_done(axi_tg_done),
    .axi_tg_error(axi_tg_error)
  );

endmodule
