
module NOC_NMU512_SPP #(

  // SPP - additional parameters
  parameter C_SPP_NOCNMU_TO_CORE_WIDTH = 2000,
  parameter C_SPP_NOCNMU_FROM_CORE_WIDTH = 2000,
`ifdef XIL_TIMING
  parameter LOC = "UNPLACED",
`endif
  parameter [15:0] REG_ADDR_DST0 = 16'h0000,
  parameter [15:0] REG_ADDR_DST1 = 16'h0000,
  parameter [15:0] REG_ADDR_DST10 = 16'h0000,
  parameter [15:0] REG_ADDR_DST11 = 16'h0000,
  parameter [15:0] REG_ADDR_DST12 = 16'h0000,
  parameter [15:0] REG_ADDR_DST13 = 16'h0000,
  parameter [15:0] REG_ADDR_DST14 = 16'h0000,
  parameter [15:0] REG_ADDR_DST15 = 16'h0000,
  parameter [15:0] REG_ADDR_DST2 = 16'h0000,
  parameter [15:0] REG_ADDR_DST3 = 16'h0000,
  parameter [15:0] REG_ADDR_DST4 = 16'h0000,
  parameter [15:0] REG_ADDR_DST5 = 16'h0000,
  parameter [15:0] REG_ADDR_DST6 = 16'h0000,
  parameter [15:0] REG_ADDR_DST7 = 16'h0000,
  parameter [15:0] REG_ADDR_DST8 = 16'h0000,
  parameter [15:0] REG_ADDR_DST9 = 16'h0000,
  parameter [15:0] REG_ADDR_ENABLE = 16'h0000,
  parameter [31:0] REG_ADDR_MADDR0 = 32'h00000000,
  parameter [31:0] REG_ADDR_MADDR1 = 32'h00000000,
  parameter [31:0] REG_ADDR_MADDR10 = 32'h00000000,
  parameter [31:0] REG_ADDR_MADDR11 = 32'h00000000,
  parameter [31:0] REG_ADDR_MADDR12 = 32'h00000000,
  parameter [31:0] REG_ADDR_MADDR13 = 32'h00000000,
  parameter [31:0] REG_ADDR_MADDR14 = 32'h00000000,
  parameter [31:0] REG_ADDR_MADDR15 = 32'h00000000,
  parameter [31:0] REG_ADDR_MADDR2 = 32'h00000000,
  parameter [31:0] REG_ADDR_MADDR3 = 32'h00000000,
  parameter [31:0] REG_ADDR_MADDR4 = 32'h00000000,
  parameter [31:0] REG_ADDR_MADDR5 = 32'h00000000,
  parameter [31:0] REG_ADDR_MADDR6 = 32'h00000000,
  parameter [31:0] REG_ADDR_MADDR7 = 32'h00000000,
  parameter [31:0] REG_ADDR_MADDR8 = 32'h00000000,
  parameter [31:0] REG_ADDR_MADDR9 = 32'h00000000,
  parameter [31:0] REG_ADDR_MASK0 = 32'h00000000,
  parameter [31:0] REG_ADDR_MASK1 = 32'h00000000,
  parameter [31:0] REG_ADDR_MASK10 = 32'h00000000,
  parameter [31:0] REG_ADDR_MASK11 = 32'h00000000,
  parameter [31:0] REG_ADDR_MASK12 = 32'h00000000,
  parameter [31:0] REG_ADDR_MASK13 = 32'h00000000,
  parameter [31:0] REG_ADDR_MASK14 = 32'h00000000,
  parameter [31:0] REG_ADDR_MASK15 = 32'h00000000,
  parameter [31:0] REG_ADDR_MASK2 = 32'h00000000,
  parameter [31:0] REG_ADDR_MASK3 = 32'h00000000,
  parameter [31:0] REG_ADDR_MASK4 = 32'h00000000,
  parameter [31:0] REG_ADDR_MASK5 = 32'h00000000,
  parameter [31:0] REG_ADDR_MASK6 = 32'h00000000,
  parameter [31:0] REG_ADDR_MASK7 = 32'h00000000,
  parameter [31:0] REG_ADDR_MASK8 = 32'h00000000,
  parameter [31:0] REG_ADDR_MASK9 = 32'h00000000,
  parameter [15:0] REG_ADDR_REMAP = 16'h0000,
  parameter [31:0] REG_ADDR_RPADDR0 = 32'h00000000,
  parameter [31:0] REG_ADDR_RPADDR1 = 32'h00000000,
  parameter [31:0] REG_ADDR_RPADDR10 = 32'h00000000,
  parameter [31:0] REG_ADDR_RPADDR11 = 32'h00000000,
  parameter [31:0] REG_ADDR_RPADDR12 = 32'h00000000,
  parameter [31:0] REG_ADDR_RPADDR13 = 32'h00000000,
  parameter [31:0] REG_ADDR_RPADDR14 = 32'h00000000,
  parameter [31:0] REG_ADDR_RPADDR15 = 32'h00000000,
  parameter [31:0] REG_ADDR_RPADDR2 = 32'h00000000,
  parameter [31:0] REG_ADDR_RPADDR3 = 32'h00000000,
  parameter [31:0] REG_ADDR_RPADDR4 = 32'h00000000,
  parameter [31:0] REG_ADDR_RPADDR5 = 32'h00000000,
  parameter [31:0] REG_ADDR_RPADDR6 = 32'h00000000,
  parameter [31:0] REG_ADDR_RPADDR7 = 32'h00000000,
  parameter [31:0] REG_ADDR_RPADDR8 = 32'h00000000,
  parameter [31:0] REG_ADDR_RPADDR9 = 32'h00000000,
  parameter [11:0] REG_ADR_MAP_CPM = 12'h000,
  parameter [11:0] REG_ADR_MAP_FPD_AFI_0 = 12'h000,
  parameter [11:0] REG_ADR_MAP_FPD_AFI_1 = 12'h000,
  parameter [11:0] REG_ADR_MAP_LPD_AFI_FS = 12'h000,
  parameter [11:0] REG_ADR_MAP_ME_ARRAY_0 = 12'h000,
  parameter [11:0] REG_ADR_MAP_ME_ARRAY_1 = 12'h000,
  parameter [11:0] REG_ADR_MAP_ME_ARRAY_2 = 12'h000,
  parameter [11:0] REG_ADR_MAP_ME_ARRAY_3 = 12'h000,
  parameter [11:0] REG_ADR_MAP_PCIE = 12'h000,
  parameter [11:0] REG_ADR_MAP_PMC = 12'h000,
  parameter [11:0] REG_ADR_MAP_PMC_ALIAS_0 = 12'h000,
  parameter [11:0] REG_ADR_MAP_PMC_ALIAS_1 = 12'h000,
  parameter [11:0] REG_ADR_MAP_PMC_ALIAS_2 = 12'h000,
  parameter [11:0] REG_ADR_MAP_PMC_ALIAS_3 = 12'h000,
  parameter [11:0] REG_ADR_MAP_QSPI = 12'h000,
  parameter [11:0] REG_ADR_MAP_STM_GIC = 12'h000,
  parameter [11:0] REG_ADR_MAP_XPDS = 12'h000,
  parameter [0:0] REG_AXI_NON_MOD_DISABLE = 1'h0,
  parameter [0:0] REG_AXI_PAR_CHK = 1'h0,
  parameter [3:0] REG_CHOPSIZE = 4'hA,
  parameter [14:0] REG_DDR_ADR_MAP0 = 15'h1000,
  parameter [14:0] REG_DDR_ADR_MAP1 = 15'h1000,
  parameter [14:0] REG_DDR_ADR_MAP2 = 15'h1000,
  parameter [14:0] REG_DDR_ADR_MAP3 = 15'h1000,
  parameter [14:0] REG_DDR_ADR_MAP4 = 15'h1000,
  parameter [14:0] REG_DDR_ADR_MAP5 = 15'h1000,
  parameter [14:0] REG_DDR_ADR_MAP6 = 15'h1000,
  parameter [11:0] REG_DDR_DST_MAP0 = 12'h000,
  parameter [11:0] REG_DDR_DST_MAP1 = 12'h000,
  parameter [11:0] REG_DDR_DST_MAP2 = 12'h000,
  parameter [11:0] REG_DDR_DST_MAP3 = 12'h000,
  parameter [11:0] REG_DDR_DST_MAP4 = 12'h000,
  parameter [11:0] REG_DDR_DST_MAP5 = 12'h000,
  parameter [11:0] REG_DDR_DST_MAP6 = 12'h000,
  parameter [11:0] REG_DDR_DST_MAP7 = 12'h000,
  parameter [2:0] REG_DWIDTH = 3'h4,
  parameter [0:0] REG_ECC_CHK_EN = 1'h1,
  parameter [11:0] REG_HBM_MAP_T0_CH0 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T0_CH1 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T0_CH10 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T0_CH11 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T0_CH12 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T0_CH13 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T0_CH14 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T0_CH15 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T0_CH2 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T0_CH3 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T0_CH4 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T0_CH5 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T0_CH6 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T0_CH7 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T0_CH8 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T0_CH9 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T1_CH0 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T1_CH1 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T1_CH10 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T1_CH11 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T1_CH12 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T1_CH13 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T1_CH14 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T1_CH15 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T1_CH2 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T1_CH3 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T1_CH4 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T1_CH5 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T1_CH6 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T1_CH7 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T1_CH8 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T1_CH9 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T2_CH0 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T2_CH1 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T2_CH10 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T2_CH11 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T2_CH12 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T2_CH13 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T2_CH14 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T2_CH15 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T2_CH2 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T2_CH3 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T2_CH4 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T2_CH5 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T2_CH6 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T2_CH7 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T2_CH8 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T2_CH9 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T3_CH0 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T3_CH1 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T3_CH10 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T3_CH11 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T3_CH12 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T3_CH13 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T3_CH14 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T3_CH15 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T3_CH2 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T3_CH3 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T3_CH4 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T3_CH5 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T3_CH6 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T3_CH7 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T3_CH8 = 12'h000,
  parameter [11:0] REG_HBM_MAP_T3_CH9 = 12'h000,
  parameter [15:0] REG_MODE_SELECT = 16'h0000,
  parameter [6:0] REG_OUTSTANDING_RD_TXN = 7'h40,
  parameter [6:0] REG_OUTSTANDING_WR_TXN = 7'h40,
  parameter [7:0] REG_PERF_MON_TBASE = 8'h03,
  parameter [1:0] REG_PRIORITY = 2'h0,
  parameter [5:0] REG_RD_AXPROT_SEL = 6'h00,
  parameter [9:0] REG_RD_RATE_CREDIT_DROP = 10'h005,
  parameter [12:0] REG_RD_RATE_CREDIT_LIMIT = 13'h0100,
  parameter [7:0] REG_RD_VCA_TOKEN0 = 8'h10,
  parameter [0:0] REG_RPOISON_TO_SLVERR = 1'h0,
  parameter [8:0] REG_RROB_RAM_SETTING = 9'h012,
  parameter [19:0] REG_SMID_SEL = 20'h00000,
  parameter [11:0] REG_SRC = 12'h000,
  parameter [3:0] REG_TBASE_AXI_TIMEOUT = 4'h1,
  parameter [2:0] REG_TBASE_MODE_RLIMIT_RD = 3'h2,
  parameter [2:0] REG_TBASE_MODE_RLIMIT_WR = 3'h2,
  parameter [3:0] REG_TBASE_TRK_TIMEOUT = 4'h1,
  parameter [11:0] REG_VC_MAP = 12'h688,
  parameter [5:0] REG_WBUF_LAUNCH_SIZE = 6'h10,
  parameter [8:0] REG_WBUF_RAM_SETTING = 9'h012,
  parameter [5:0] REG_WR_AXPROT_SEL = 6'h00,
  parameter [9:0] REG_WR_RATE_CREDIT_DROP = 10'h005,
  parameter [12:0] REG_WR_RATE_CREDIT_LIMIT = 13'h0100,
  parameter [7:0] REG_WR_VCA_TOKEN0 = 8'h10
)(
  output IF_NOC_AXI_ARREADY,
  output IF_NOC_AXI_AWREADY,
  output [15:0] IF_NOC_AXI_BID,
  output [1:0] IF_NOC_AXI_BRESP,
  output [15:0] IF_NOC_AXI_BUSER,
  output IF_NOC_AXI_BVALID,
  output [511:0] IF_NOC_AXI_RDATA,
  output [63:0] IF_NOC_AXI_RDATA_PAR,
  output [15:0] IF_NOC_AXI_RID,
  output [0:0] IF_NOC_AXI_RLAST,
  output IF_NOC_AXI_RPOISON,
  output [1:0] IF_NOC_AXI_RRESP,
  output [15:0] IF_NOC_AXI_RUSER,
  output IF_NOC_AXI_RVALID,
  output IF_NOC_AXI_WREADY,
  output [7:0] IF_NOC_NPP_IN_NOC_CREDIT_RETURN,
  output IF_NOC_NPP_IN_NOC_CREDIT_RETURN_EN,
  output IF_NOC_NPP_OUT_NOC_CREDIT_RDY,
  output [181:0] IF_NOC_NPP_OUT_NOC_FLIT,
  output IF_NOC_NPP_OUT_NOC_FLIT_EN,
  output [7:0] IF_NOC_NPP_OUT_NOC_VALID,
  output IF_NOC_NPP_OUT_NOC_VALID_EN,

  input CLK,
  input [63:0] IF_NOC_AXI_ARADDR,
  input [7:0] IF_NOC_AXI_ARADDR_PAR,
  input [1:0] IF_NOC_AXI_ARBURST,
  input [3:0] IF_NOC_AXI_ARCACHE,
  input [15:0] IF_NOC_AXI_ARID,
  input [7:0] IF_NOC_AXI_ARLEN,
  input [0:0] IF_NOC_AXI_ARLOCK,
  input [2:0] IF_NOC_AXI_ARPROT,
  input [3:0] IF_NOC_AXI_ARQOS,
  input [3:0] IF_NOC_AXI_ARREGION,
  input [2:0] IF_NOC_AXI_ARSIZE,
  input [15:0] IF_NOC_AXI_ARUSER,
  input IF_NOC_AXI_ARVALID,
  input [63:0] IF_NOC_AXI_AWADDR,
  input [7:0] IF_NOC_AXI_AWADDR_PAR,
  input [1:0] IF_NOC_AXI_AWBURST,
  input [3:0] IF_NOC_AXI_AWCACHE,
  input [15:0] IF_NOC_AXI_AWID,
  input [7:0] IF_NOC_AXI_AWLEN,
  input [0:0] IF_NOC_AXI_AWLOCK,
  input [2:0] IF_NOC_AXI_AWPROT,
  input [3:0] IF_NOC_AXI_AWQOS,
  input [3:0] IF_NOC_AXI_AWREGION,
  input [2:0] IF_NOC_AXI_AWSIZE,
  input [15:0] IF_NOC_AXI_AWUSER,
  input IF_NOC_AXI_AWVALID,
  input IF_NOC_AXI_BREADY,
  input IF_NOC_AXI_RREADY,
  input [9:0] IF_NOC_AXI_TDEST,
  input [511:0] IF_NOC_AXI_WDATA,
  input [63:0] IF_NOC_AXI_WDATA_PAR,
  input [15:0] IF_NOC_AXI_WID,
  input [0:0] IF_NOC_AXI_WLAST,
  input IF_NOC_AXI_WPOISON,
  input [63:0] IF_NOC_AXI_WSTRB,
  input [15:0] IF_NOC_AXI_WUSER,
  input IF_NOC_AXI_WVALID,
  input IF_NOC_NPP_IN_NOC_CREDIT_RDY,
  input [181:0] IF_NOC_NPP_IN_NOC_FLIT,
  input IF_NOC_NPP_IN_NOC_FLIT_EN,
  input [7:0] IF_NOC_NPP_IN_NOC_VALID,
  input IF_NOC_NPP_IN_NOC_VALID_EN,
  input [7:0] IF_NOC_NPP_OUT_NOC_CREDIT_RETURN,
  input IF_NOC_NPP_OUT_NOC_CREDIT_RETURN_EN,
  input NMU_RD_DEST_MODE,
  input [11:0] NMU_RD_USR_DST,
  input [3:0] NMU_USR_INTERRUPT_IN,
  input NMU_WR_DEST_MODE,
  input [11:0] NMU_WR_USR_DST

  // SPP - additional ports
  ,
  output [C_SPP_NOCNMU_TO_CORE_WIDTH-1:0] NOCNMUTOCORE,
  input  [C_SPP_NOCNMU_FROM_CORE_WIDTH-1:0] NOCNMUFROMCORE
);

  // SPP - pass through inputs

  assign NOCNMUTOCORE = {
    CLK,
    IF_NOC_AXI_ARADDR,
    IF_NOC_AXI_ARADDR_PAR,
    IF_NOC_AXI_ARBURST,
    IF_NOC_AXI_ARCACHE,
    IF_NOC_AXI_ARID,
    IF_NOC_AXI_ARLEN,
    IF_NOC_AXI_ARLOCK,
    IF_NOC_AXI_ARPROT,
    IF_NOC_AXI_ARQOS,
    IF_NOC_AXI_ARREGION,
    IF_NOC_AXI_ARSIZE,
    IF_NOC_AXI_ARUSER,
    IF_NOC_AXI_ARVALID,
    IF_NOC_AXI_AWADDR,
    IF_NOC_AXI_AWADDR_PAR,
    IF_NOC_AXI_AWBURST,
    IF_NOC_AXI_AWCACHE,
    IF_NOC_AXI_AWID,
    IF_NOC_AXI_AWLEN,
    IF_NOC_AXI_AWLOCK,
    IF_NOC_AXI_AWPROT,
    IF_NOC_AXI_AWQOS,
    IF_NOC_AXI_AWREGION,
    IF_NOC_AXI_AWSIZE,
    IF_NOC_AXI_AWUSER,
    IF_NOC_AXI_AWVALID,
    IF_NOC_AXI_BREADY,
    IF_NOC_AXI_RREADY,
    IF_NOC_AXI_TDEST,
    IF_NOC_AXI_WDATA,
    IF_NOC_AXI_WDATA_PAR,
    IF_NOC_AXI_WID,
    IF_NOC_AXI_WLAST,
    IF_NOC_AXI_WPOISON,
    IF_NOC_AXI_WSTRB,
    IF_NOC_AXI_WUSER,
    IF_NOC_AXI_WVALID,
    IF_NOC_NPP_IN_NOC_CREDIT_RDY,
    IF_NOC_NPP_IN_NOC_FLIT,
    IF_NOC_NPP_IN_NOC_FLIT_EN,
    IF_NOC_NPP_IN_NOC_VALID,
    IF_NOC_NPP_IN_NOC_VALID_EN,
    IF_NOC_NPP_OUT_NOC_CREDIT_RETURN,
    IF_NOC_NPP_OUT_NOC_CREDIT_RETURN_EN,
    NMU_RD_DEST_MODE,
    NMU_RD_USR_DST,
    NMU_USR_INTERRUPT_IN,
    NMU_WR_DEST_MODE,
    NMU_WR_USR_DST
    };
   
  // SPP - pass through outputs

  assign {
    IF_NOC_AXI_ARREADY,
    IF_NOC_AXI_AWREADY,
    IF_NOC_AXI_BID,
    IF_NOC_AXI_BRESP,
    IF_NOC_AXI_BUSER,
    IF_NOC_AXI_BVALID,
    IF_NOC_AXI_RDATA,
    IF_NOC_AXI_RDATA_PAR,
    IF_NOC_AXI_RID,
    IF_NOC_AXI_RLAST,
    IF_NOC_AXI_RPOISON,
    IF_NOC_AXI_RRESP,
    IF_NOC_AXI_RUSER,
    IF_NOC_AXI_RVALID,
    IF_NOC_AXI_WREADY,
    IF_NOC_NPP_IN_NOC_CREDIT_RETURN,
    IF_NOC_NPP_IN_NOC_CREDIT_RETURN_EN,
    IF_NOC_NPP_OUT_NOC_CREDIT_RDY,
    IF_NOC_NPP_OUT_NOC_FLIT,
    IF_NOC_NPP_OUT_NOC_FLIT_EN,
    IF_NOC_NPP_OUT_NOC_VALID,
    IF_NOC_NPP_OUT_NOC_VALID_EN
    } = NOCNMUFROMCORE;
   
endmodule

