
module NOC_NSU512_SPP #(

  // SPP - additional parameters
  parameter C_SPP_NOCNSU_TO_CORE_WIDTH = 2000,
  parameter C_SPP_NOCNSU_FROM_CORE_WIDTH = 2000,
`ifdef XIL_TIMING
  parameter LOC = "UNPLACED",
`endif
  parameter [1:0] REG_AXI_LOOPBACK = 2'h0,
  parameter [4:0] REG_COMP_ID_INDEX0 = 5'h00,
  parameter [4:0] REG_COMP_ID_INDEX1 = 5'h01,
  parameter [0:0] REG_COMP_ID_MODE = 1'h0,
  parameter [0:0] REG_DISABLE_EX_MON = 1'h1,
  parameter [2:0] REG_DWIDTH = 3'h4,
  parameter [0:0] REG_ECC_CHK_EN = 1'h1,
  parameter [1:0] REG_FIXED_COMP_ID = 2'h0,
  parameter [1:0] REG_MODE_SELECT = 2'h0,
  parameter [0:0] REG_ODISABLE_AXI_RESP = 1'h0,
  parameter [5:0] REG_OUTSTANDING_RD_TXN = 6'h20,
  parameter [5:0] REG_OUTSTANDING_WR_TXN = 6'h20,
  parameter [0:0] REG_PAR_CHK = 1'h0,
  parameter [7:0] REG_RDTRK_VCA_TOKEN0 = 8'h10,
  parameter [7:0] REG_RDTRK_VCA_TOKEN1 = 8'h10,
  parameter [2:0] REG_RD_REQ_VC_MAP0 = 3'h0,
  parameter [2:0] REG_RD_REQ_VC_MAP1 = 3'h4,
  parameter [2:0] REG_RD_RESP_VC_MAP0 = 3'h2,
  parameter [2:0] REG_RD_RESP_VC_MAP1 = 3'h6,
  parameter [7:0] REG_RD_VCA_TOKEN0 = 8'h10,
  parameter [7:0] REG_RD_VCA_TOKEN1 = 8'h10,
  parameter [11:0] REG_SRC = 12'h000,
  parameter [3:0] REG_TBASE_AXI_TIMEOUT = 4'h2,
  parameter [3:0] REG_TBASE_TRK_TIMEOUT = 4'h2,
  parameter [7:0] REG_VMAP_OUT_RD_TOKEN0 = 8'h10,
  parameter [7:0] REG_VMAP_OUT_RD_TOKEN1 = 8'h10,
  parameter [7:0] REG_VMAP_OUT_WR_TOKEN0 = 8'h10,
  parameter [7:0] REG_VMAP_OUT_WR_TOKEN1 = 8'h10,
  parameter [7:0] REG_WRTRK_VCA_TOKEN0 = 8'h10,
  parameter [7:0] REG_WRTRK_VCA_TOKEN1 = 8'h10,
  parameter [2:0] REG_WR_REQ_VC_MAP0 = 3'h1,
  parameter [2:0] REG_WR_REQ_VC_MAP1 = 3'h5,
  parameter [2:0] REG_WR_RESP_VC_MAP0 = 3'h3,
  parameter [2:0] REG_WR_RESP_VC_MAP1 = 3'h7,
  parameter [7:0] REG_WR_VCA_TOKEN0 = 8'h10,
  parameter [7:0] REG_WR_VCA_TOKEN1 = 8'h10
)(
  output [63:0] IF_NOC_AXI_ARADDR,
  output [7:0] IF_NOC_AXI_ARADDR_PAR,
  output [1:0] IF_NOC_AXI_ARBURST,
  output [3:0] IF_NOC_AXI_ARCACHE,
  output [1:0] IF_NOC_AXI_ARCID,
  output [15:0] IF_NOC_AXI_ARID_INFO,
  output [7:0] IF_NOC_AXI_ARLEN,
  output [0:0] IF_NOC_AXI_ARLOCK,
  output [2:0] IF_NOC_AXI_ARPROT,
  output [3:0] IF_NOC_AXI_ARQOS,
  output [3:0] IF_NOC_AXI_ARREGION,
  output [2:0] IF_NOC_AXI_ARSIZE,
  output [11:0] IF_NOC_AXI_ARSRC_INFO,
  output [15:0] IF_NOC_AXI_ARUSER,
  output IF_NOC_AXI_ARVALID,
  output [63:0] IF_NOC_AXI_AWADDR,
  output [7:0] IF_NOC_AXI_AWADDR_PAR,
  output [1:0] IF_NOC_AXI_AWBURST,
  output [3:0] IF_NOC_AXI_AWCACHE,
  output [1:0] IF_NOC_AXI_AWCID,
  output [15:0] IF_NOC_AXI_AWID_INFO,
  output [7:0] IF_NOC_AXI_AWLEN,
  output [0:0] IF_NOC_AXI_AWLOCK,
  output [2:0] IF_NOC_AXI_AWPROT,
  output [3:0] IF_NOC_AXI_AWQOS,
  output [3:0] IF_NOC_AXI_AWREGION,
  output [2:0] IF_NOC_AXI_AWSIZE,
  output [11:0] IF_NOC_AXI_AWSRC_INFO,
  output [15:0] IF_NOC_AXI_AWUSER,
  output IF_NOC_AXI_AWVALID,
  output IF_NOC_AXI_BREADY,
  output IF_NOC_AXI_RREADY,
  output [9:0] IF_NOC_AXI_TDEST,
  output [5:0] IF_NOC_AXI_WCID,
  output [511:0] IF_NOC_AXI_WDATA,
  output [63:0] IF_NOC_AXI_WDATA_PAR,
  output [15:0] IF_NOC_AXI_WID_INFO,
  output [0:0] IF_NOC_AXI_WLAST,
  output IF_NOC_AXI_WPOISON,
  output [11:0] IF_NOC_AXI_WSRC_INFO,
  output [63:0] IF_NOC_AXI_WSTRB,
  output [15:0] IF_NOC_AXI_WUSER,
  output IF_NOC_AXI_WVALID,
  output [7:0] IF_NOC_NPP_IN_NOC_CREDIT_RETURN,
  output IF_NOC_NPP_IN_NOC_CREDIT_RETURN_EN,
  output IF_NOC_NPP_OUT_NOC_CREDIT_RDY,
  output [181:0] IF_NOC_NPP_OUT_NOC_FLIT,
  output IF_NOC_NPP_OUT_NOC_FLIT_EN,
  output [7:0] IF_NOC_NPP_OUT_NOC_VALID,
  output IF_NOC_NPP_OUT_NOC_VALID_EN,

  input CLK,
  input IF_NOC_AXI_ARREADY,
  input IF_NOC_AXI_AWREADY,
  input [1:0] IF_NOC_AXI_BCID,
  input [1:0] IF_NOC_AXI_BRESP,
  input [15:0] IF_NOC_AXI_BUSER,
  input IF_NOC_AXI_BVALID,
  input [1:0] IF_NOC_AXI_RCID,
  input [511:0] IF_NOC_AXI_RDATA,
  input [63:0] IF_NOC_AXI_RDATA_PAR,
  input [0:0] IF_NOC_AXI_RLAST,
  input IF_NOC_AXI_RPOISON,
  input [1:0] IF_NOC_AXI_RRESP,
  input [15:0] IF_NOC_AXI_RUSER,
  input IF_NOC_AXI_RVALID,
  input IF_NOC_AXI_WREADY,
  input IF_NOC_NPP_IN_NOC_CREDIT_RDY,
  input [181:0] IF_NOC_NPP_IN_NOC_FLIT,
  input IF_NOC_NPP_IN_NOC_FLIT_EN,
  input [7:0] IF_NOC_NPP_IN_NOC_VALID,
  input IF_NOC_NPP_IN_NOC_VALID_EN,
  input [7:0] IF_NOC_NPP_OUT_NOC_CREDIT_RETURN,
  input IF_NOC_NPP_OUT_NOC_CREDIT_RETURN_EN,
  input [3:0] NSU_USR_INTERRUPT_IN

  // SPP - additional ports
  ,
  output [C_SPP_NOCNSU_TO_CORE_WIDTH-1:0] NOCNSUTOCORE,
  input  [C_SPP_NOCNSU_FROM_CORE_WIDTH-1:0] NOCNSUFROMCORE
);

  // SPP - pass through inputs

  assign NOCNSUTOCORE = {
    CLK,
    IF_NOC_AXI_ARREADY,
    IF_NOC_AXI_AWREADY,
    IF_NOC_AXI_BCID,
    IF_NOC_AXI_BRESP,
    IF_NOC_AXI_BUSER,
    IF_NOC_AXI_BVALID,
    IF_NOC_AXI_RCID,
    IF_NOC_AXI_RDATA,
    IF_NOC_AXI_RDATA_PAR,
    IF_NOC_AXI_RLAST,
    IF_NOC_AXI_RPOISON,
    IF_NOC_AXI_RRESP,
    IF_NOC_AXI_RUSER,
    IF_NOC_AXI_RVALID,
    IF_NOC_AXI_WREADY,
    IF_NOC_NPP_IN_NOC_CREDIT_RDY,
    IF_NOC_NPP_IN_NOC_FLIT,
    IF_NOC_NPP_IN_NOC_FLIT_EN,
    IF_NOC_NPP_IN_NOC_VALID,
    IF_NOC_NPP_IN_NOC_VALID_EN,
    IF_NOC_NPP_OUT_NOC_CREDIT_RETURN,
    IF_NOC_NPP_OUT_NOC_CREDIT_RETURN_EN,
    NSU_USR_INTERRUPT_IN
    };
   
  // SPP - pass through outputs

  assign {
    IF_NOC_AXI_ARADDR,
    IF_NOC_AXI_ARADDR_PAR,
    IF_NOC_AXI_ARBURST,
    IF_NOC_AXI_ARCACHE,
    IF_NOC_AXI_ARCID,
    IF_NOC_AXI_ARID_INFO,
    IF_NOC_AXI_ARLEN,
    IF_NOC_AXI_ARLOCK,
    IF_NOC_AXI_ARPROT,
    IF_NOC_AXI_ARQOS,
    IF_NOC_AXI_ARREGION,
    IF_NOC_AXI_ARSIZE,
    IF_NOC_AXI_ARSRC_INFO,
    IF_NOC_AXI_ARUSER,
    IF_NOC_AXI_ARVALID,
    IF_NOC_AXI_AWADDR,
    IF_NOC_AXI_AWADDR_PAR,
    IF_NOC_AXI_AWBURST,
    IF_NOC_AXI_AWCACHE,
    IF_NOC_AXI_AWCID,
    IF_NOC_AXI_AWID_INFO,
    IF_NOC_AXI_AWLEN,
    IF_NOC_AXI_AWLOCK,
    IF_NOC_AXI_AWPROT,
    IF_NOC_AXI_AWQOS,
    IF_NOC_AXI_AWREGION,
    IF_NOC_AXI_AWSIZE,
    IF_NOC_AXI_AWSRC_INFO,
    IF_NOC_AXI_AWUSER,
    IF_NOC_AXI_AWVALID,
    IF_NOC_AXI_BREADY,
    IF_NOC_AXI_RREADY,
    IF_NOC_AXI_TDEST,
    IF_NOC_AXI_WCID,
    IF_NOC_AXI_WDATA,
    IF_NOC_AXI_WDATA_PAR,
    IF_NOC_AXI_WID_INFO,
    IF_NOC_AXI_WLAST,
    IF_NOC_AXI_WPOISON,
    IF_NOC_AXI_WSRC_INFO,
    IF_NOC_AXI_WSTRB,
    IF_NOC_AXI_WUSER,
    IF_NOC_AXI_WVALID,
    IF_NOC_NPP_IN_NOC_CREDIT_RETURN,
    IF_NOC_NPP_IN_NOC_CREDIT_RETURN_EN,
    IF_NOC_NPP_OUT_NOC_CREDIT_RDY,
    IF_NOC_NPP_OUT_NOC_FLIT,
    IF_NOC_NPP_OUT_NOC_FLIT_EN,
    IF_NOC_NPP_OUT_NOC_VALID,
    IF_NOC_NPP_OUT_NOC_VALID_EN
    } = NOCNSUFROMCORE;

endmodule
