#!/usr/bin/env bash
#**********************************************************************************************************
# Vivado (TM) v2025.2 (64-bit)
#
# Script generated by Vivado on Tue Dec 30 17:11:32 IST 2025
# SW Build 6299465 on Fri Nov 14 12:34:56 MST 2025
#
# Copyright 1986-2022 Xilinx, Inc. All Rights Reserved.
# Copyright 2022-2025 Advanced Micro Devices, Inc. All Rights Reserved. 
#
# Filename     : axi_switch_0.sh
# Simulator    : Cadence Xcelium Parallel Simulator
# Description  : Simulation script generated by export_simulation Tcl command
# Purpose      : Run 'compile', 'elaborate', 'simulate' steps for compiling, elaborating and simulating the
#                design. The script will copy the library mapping file from the compiled library directory,
#                create design library directories and library mappings in the mapping file.
#
# Usage        : axi_switch_0.sh
#                axi_switch_0.sh [-lib_map_path] [-step] [-keep_index] [-noclean_files]*
#                axi_switch_0.sh [-rerun]
#                axi_switch_0.sh [-reset_run]
#                axi_switch_0.sh [-clean]
#                axi_switch_0.sh [-reset_log]
#                axi_switch_0.sh [-help]
#
#               * The -noclean_files switch is deprecated and will not peform any function (by default, the
#                 simulator generated files will not be removed unless -reset_run switch is used)
#
# Prerequisite : Before running export_simulation, you must first compile the AMD simulation library
#                using the 'compile_simlib' Tcl command (for more information, run 'compile_simlib -help'
#                command in the Vivado Tcl shell). After compiling the library, specify the -lib_map_path
#                switch with the directory path where the library is created while generating the script
#                with export_simulation.
#
#                Alternatively, you can set the library path by setting the following project property:-
#
#                 set_property compxlib.<simulator>_compiled_library_dir <path> [current_project]
#
#                You can also point to the simulation library by either setting the 'lib_map_path' global
#                variable in this script or specify it with the '-lib_map_path' switch while executing this
#                script (type 'axi_switch_0.sh -help' for more information).
#
#                Note: For pure RTL based designs, the -lib_map_path switch can be specified later with the
#                generated script, but if design is targetted for system simulation containing SystemC/C++/C
#                sources, then the library path MUST be specified upfront when calling export_simulation.
#
#                For more information, refer 'Vivado Design Suite User Guide:Logic simulation (UG900)'
#
#**********************************************************************************************************
export SIM_VER_XCELIUM=
export GCC_VER_XCELIUM=

# catch pipeline exit status
set -Eeuo pipefail

# set xmvhdl compile options
xmvhdl_opts="-64bit -messages -relax -logfile .tmp_log -update"

# set xmvlog compile options
xmvlog_opts="-64bit -messages -logfile .tmp_log -update"

# set xmelab elaboration options
xmelab_opts="-64bit -relax -access +r -namemap_mixgen -messages -logfile elaborate.log"

# set xmsim simulation options
xmsim_opts="-64bit -logfile simulate.log"

# set design libraries for elaboration
design_libs_elab="-libname xilinx_vip -libname noc_nmu_sim_v1_0_0 -libname noc_hbm_nmu_sim_v1_0_0 -libname noc_nsu_sim_v1_0_1 -libname noc2_nmu_sim_v1_0_0 -libname noc2_nsu_sim_v1_0_1 -libname xpm -libname xpm_noc -libname smartconnect_v1_0 -libname proc_sys_reset_v5_0_17 -libname axi_infrastructure_v1_1_0 -libname axi_register_slice_v2_1_36 -libname axi_vip_v1_1_22 -libname axi_switch_v1_0_1 -libname xil_defaultlib -libname xilinx_vip -libname unisims_ver -libname unimacro_ver -libname secureip"

# set design libraries
design_libs=(simprims_ver xilinx_vip xpm xpm_noc smartconnect_v1_0 proc_sys_reset_v5_0_17 axi_infrastructure_v1_1_0 axi_register_slice_v2_1_36 axi_vip_v1_1_22 axi_switch_v1_0_1 xil_defaultlib)

# simulation root library directory
sim_lib_dir="xcelium_lib"

# script info
echo -e "axi_switch_0.sh - Script generated by export_simulation (Vivado v2025.2 (64-bit)-id)\n"

# main steps
run()
{
  check_args $*
  setup
  if [[ ($b_step == 1) ]]; then
    case $step in
      "compile" )
       init_lib
       compile
      ;;
      "elaborate" )
       elaborate
      ;;
      "simulate" )
       simulate
      ;;
      * )
        echo -e "ERROR: Invalid or missing step '$step' (type \"./axi_switch_0.sh -help\" for more information)\n"
        exit 1
      esac
  else
    init_lib
    compile
    elaborate
    simulate
  fi
}

# RUN_STEP: <compile>
compile()
{
  xmvlog -work xilinx_vip $xmvlog_opts -sv +incdir+"../../../ipstatic/hdl/verilog" +incdir+"../../../ipstatic/hdl" +incdir+"../../../../../../../../../opt/amd/2025.2/data/rsb/busdef" +incdir+"/opt/amd/2025.2/data/xilinx_vip/include" \
  "/opt/amd/2025.2/data/xilinx_vip/hdl/axi4stream_vip_axi4streampc.sv" \
  "/opt/amd/2025.2/data/xilinx_vip/hdl/axi_vip_axi4pc.sv" \
  "/opt/amd/2025.2/data/xilinx_vip/hdl/xil_common_vip_pkg.sv" \
  "/opt/amd/2025.2/data/xilinx_vip/hdl/axi4stream_vip_pkg.sv" \
  "/opt/amd/2025.2/data/xilinx_vip/hdl/axi_vip_pkg.sv" \
  "/opt/amd/2025.2/data/xilinx_vip/hdl/axi4stream_vip_if.sv" \
  "/opt/amd/2025.2/data/xilinx_vip/hdl/axi_vip_if.sv" \
  "/opt/amd/2025.2/data/xilinx_vip/hdl/clk_vip_if.sv" \
  "/opt/amd/2025.2/data/xilinx_vip/hdl/rst_vip_if.sv" \
  2>&1 | tee compile.log; cat .tmp_log > xmvlog.log 2>/dev/null

  xmvlog -work xpm $xmvlog_opts -sv +incdir+"../../../ipstatic/hdl/verilog" +incdir+"../../../ipstatic/hdl" +incdir+"../../../../../../../../../opt/amd/2025.2/data/rsb/busdef" +incdir+"/opt/amd/2025.2/data/xilinx_vip/include" \
  "/opt/amd/2025.2/data/ip/xpm/xpm_cdc/hdl/xpm_cdc.sv" \
  "/opt/amd/2025.2/data/ip/xpm/xpm_fifo/hdl/xpm_fifo.sv" \
  "/opt/amd/2025.2/data/ip/xpm/xpm_memory/hdl/xpm_memory.sv" \
  2>&1 | tee -a compile.log; cat .tmp_log >> xmvlog.log 2>/dev/null

  xmvhdl -work xpm -V93 $xmvhdl_opts \
  "/opt/amd/2025.2/data/ip/xpm/xpm_VCOMP.vhd" \
  2>&1 | tee -a compile.log; cat .tmp_log > xmvhdl.log 2>/dev/null

  xmvlog -work xpm_noc $xmvlog_opts -sv +incdir+"../../../ipstatic/hdl/verilog" +incdir+"../../../ipstatic/hdl" +incdir+"../../../../../../../../../opt/amd/2025.2/data/rsb/busdef" +incdir+"/opt/amd/2025.2/data/xilinx_vip/include" \
  "/opt/amd/2025.2/data/ip/xpm/xpm_noc/hdl/xpm_nmu_mm.sv" \
  "/opt/amd/2025.2/data/ip/xpm/xpm_noc/hdl/xpm_nsu_mm.sv" \
  "/opt/amd/2025.2/data/ip/xpm/xpm_noc/hdl/xpm_nmu_strm.sv" \
  "/opt/amd/2025.2/data/ip/xpm/xpm_noc/hdl/xpm_nsu_strm.sv" \
  2>&1 | tee -a compile.log; cat .tmp_log >> xmvlog.log 2>/dev/null

  xmvlog -work smartconnect_v1_0 $xmvlog_opts -sv +incdir+"../../../ipstatic/hdl/verilog" +incdir+"../../../ipstatic/hdl" +incdir+"../../../../../../../../../opt/amd/2025.2/data/rsb/busdef" +incdir+"/opt/amd/2025.2/data/xilinx_vip/include" \
  "../../../ipstatic/hdl/sc_util_v1_0_vl_rfs.sv" \
  "../../../ipstatic/hdl/sc_mmu_v1_0_vl_rfs.sv" \
  2>&1 | tee -a compile.log; cat .tmp_log >> xmvlog.log 2>/dev/null

  xmvhdl -work proc_sys_reset_v5_0_17 -V93 $xmvhdl_opts \
  "../../../ipstatic/hdl/proc_sys_reset_v5_0_vh_rfs.vhd" \
  2>&1 | tee -a compile.log; cat .tmp_log >> xmvhdl.log 2>/dev/null

  xmvhdl -work smartconnect_v1_0 -V93 $xmvhdl_opts \
  "../../../ipstatic/hdl/sc_ultralite_v1_0_rfs.vhd" \
  2>&1 | tee -a compile.log; cat .tmp_log >> xmvhdl.log 2>/dev/null

  xmvlog -work smartconnect_v1_0 $xmvlog_opts -sv +incdir+"../../../ipstatic/hdl/verilog" +incdir+"../../../ipstatic/hdl" +incdir+"../../../../../../../../../opt/amd/2025.2/data/rsb/busdef" +incdir+"/opt/amd/2025.2/data/xilinx_vip/include" \
  "../../../ipstatic/hdl/sc_ultralite_v1_0_rfs.sv" \
  "../../../ipstatic/hdl/sc_transaction_regulator_v1_0_vl_rfs.sv" \
  "../../../ipstatic/hdl/sc_si_converter_v1_0_vl_rfs.sv" \
  "../../../ipstatic/hdl/sc_node_v1_0_vl_rfs.sv" \
  "../../../ipstatic/hdl/sc_switchboard_v1_0_vl_rfs.sv" \
  "../../../ipstatic/hdl/sc_axi2sc_v1_0_vl_rfs.sv" \
  "../../../ipstatic/hdl/sc_sc2axi_v1_0_vl_rfs.sv" \
  "../../../ipstatic/hdl/sc_exit_v1_0_vl_rfs.sv" \
  2>&1 | tee -a compile.log; cat .tmp_log >> xmvlog.log 2>/dev/null

  xmvlog -work axi_infrastructure_v1_1_0 $xmvlog_opts +incdir+"../../../ipstatic/hdl/verilog" +incdir+"../../../ipstatic/hdl" +incdir+"../../../../../../../../../opt/amd/2025.2/data/rsb/busdef" +incdir+"/opt/amd/2025.2/data/xilinx_vip/include" \
  "../../../ipstatic/hdl/axi_infrastructure_v1_1_vl_rfs.v" \
  2>&1 | tee -a compile.log; cat .tmp_log >> xmvlog.log 2>/dev/null

  xmvlog -work axi_register_slice_v2_1_36 $xmvlog_opts +incdir+"../../../ipstatic/hdl/verilog" +incdir+"../../../ipstatic/hdl" +incdir+"../../../../../../../../../opt/amd/2025.2/data/rsb/busdef" +incdir+"/opt/amd/2025.2/data/xilinx_vip/include" \
  "../../../ipstatic/hdl/axi_register_slice_v2_1_vl_rfs.v" \
  2>&1 | tee -a compile.log; cat .tmp_log >> xmvlog.log 2>/dev/null

  xmvlog -work axi_vip_v1_1_22 $xmvlog_opts -sv +incdir+"../../../ipstatic/hdl/verilog" +incdir+"../../../ipstatic/hdl" +incdir+"../../../../../../../../../opt/amd/2025.2/data/rsb/busdef" +incdir+"/opt/amd/2025.2/data/xilinx_vip/include" \
  "../../../ipstatic/hdl/axi_vip_v1_1_vl_rfs.sv" \
  2>&1 | tee -a compile.log; cat .tmp_log >> xmvlog.log 2>/dev/null

  xmvhdl -work axi_switch_v1_0_1 -V93 $xmvhdl_opts \
  "../../../ipstatic/hdl/axi_switch_v1_0_rfs.vhd" \
  2>&1 | tee -a compile.log; cat .tmp_log >> xmvhdl.log 2>/dev/null

  xmvlog -work axi_switch_v1_0_1 $xmvlog_opts -sv +incdir+"../../../ipstatic/hdl/verilog" +incdir+"../../../ipstatic/hdl" +incdir+"../../../../../../../../../opt/amd/2025.2/data/rsb/busdef" +incdir+"/opt/amd/2025.2/data/xilinx_vip/include" \
  "../../../ipstatic/hdl/axi_switch_v1_0_rfs.sv" \
  2>&1 | tee -a compile.log; cat .tmp_log >> xmvlog.log 2>/dev/null

  xmvlog -work xil_defaultlib $xmvlog_opts -sv +incdir+"../../../ipstatic/hdl/verilog" +incdir+"../../../ipstatic/hdl" +incdir+"../../../../../../../../../opt/amd/2025.2/data/rsb/busdef" +incdir+"/opt/amd/2025.2/data/xilinx_vip/include" \
  "../../../../mod_noc.gen/sources_1/ip/axi_switch_0/sim/axi_switch_0.sv" \
  2>&1 | tee -a compile.log; cat .tmp_log >> xmvlog.log 2>/dev/null

  xmvlog -work xil_defaultlib $xmvlog_opts \
  glbl.v \
  2>&1 | tee -a compile.log; cat .tmp_log >> xmvlog.log 2>/dev/null
}

# RUN_STEP: <elaborate>
elaborate()
{
  xmelab $xmelab_opts $design_libs_elab xil_defaultlib.axi_switch_0 xil_defaultlib.glbl
}

# RUN_STEP: <simulate>
simulate()
{
  xmsim $xmsim_opts xil_defaultlib.axi_switch_0 -input simulate.do
}

# STEP: setup
setup()
{
  # delete previous files for a clean rerun
  if [[ ($b_reset_run == 1) ]]; then
    reset_run
    echo -e "INFO: Simulation run files deleted.\n"
    exit 0
  fi

  # delete previous design library generated data
  if [[ ($b_clean == 1) ]]; then
    clean
    echo -e "INFO: Design library generated data deleted.\n"
    exit 0
  fi

  # delete previous log files
  if [[ ($b_reset_log == 1) ]]; then
    reset_log
    echo -e "INFO: Simulation run log files deleted.\n"
    exit 0
  fi

  # add any setup/initialization commands here:-

  # <user specific commands>

}

# simulator index file/library directory processing
init_lib()
{
  if [[ ($b_rerun == 1) ]]; then
    # keep previous state for incremental run
    return 0
  fi

  if [[ ($b_keep_index == 1) ]]; then
    # keep previous design library mappings
    true
  else
    # define design library mappings
    create_lib_mappings
  fi

  if [[ ($b_keep_index == 1) ]]; then
    # do not recreate design library directories
    true
  else
    # create design library directories
    create_lib_dir
  fi
}

# define design library mappings
create_lib_mappings()
{
  file="hdl.var"
  touch $file

  file="cds.lib"
  if [[ -e $file ]]; then
    if [[ ($lib_map_path == "") ]]; then
      return
    else
      rm -rf $file
    fi
  fi

  touch $file

  if [[ ($lib_map_path == "") ]]; then
    lib_map_path="/home/amd/training/modular_noc/lab/mod_noc.cache/compile_simlib/xcelium"
  fi

  if [[ ($lib_map_path != "") ]]; then
    incl_ref="INCLUDE $lib_map_path/cds.lib"
    echo $incl_ref >> $file
  fi

  for (( i=0; i<${#design_libs[*]}; i++ )); do
    lib="${design_libs[i]}"
    mapping="DEFINE $lib $sim_lib_dir/$lib"
    echo $mapping >> $file
  done
}

# create design library directory
create_lib_dir()
{
  if [[ -e $sim_lib_dir ]]; then
    rm -rf $sim_lib_dir
  fi
  for (( i=0; i<${#design_libs[*]}; i++ )); do
    lib="${design_libs[i]}"
    lib_dir="$sim_lib_dir/$lib"
    if [[ ! -e $lib_dir ]]; then
      mkdir -p $lib_dir
    fi
  done
}

# delete generated data from the previous run
reset_run()
{
  files_to_remove=(xmvlog.log xmvhdl.log xmsc.log compile.log elaborate.log simulate.log diag_report.log xsc_report.log axi_switch_0_sc.so .tmp_log xcelium_lib waves.shm c.obj)
  for (( i=0; i<${#files_to_remove[*]}; i++ )); do
    file="${files_to_remove[i]}"
    if [[ -e $file ]]; then
      rm -rf $file
    fi
  done
}

# delete generated design library data from the previous run
clean()
{
  files_to_remove=("${design_libs[@]}")
  for (( i=0; i<${#files_to_remove[*]}; i++ )); do
    file="$sim_lib_dir/${files_to_remove[i]}"
    if [[ -e $file ]]; then
      rm -rf $file
    fi
  done

  # delete design library directory
  rm -rf $sim_lib_dir
}

# delete generated log files from the previous run
reset_log()
{
  files_to_remove=(xmvlog.log xmvhdl.log xmsc.log compile.log elaborate.log simulate.log diag_report.log xsc_report.log .tmp_log)
  for (( i=0; i<${#files_to_remove[*]}; i++ )); do
    file="${files_to_remove[i]}"
    if [[ -e $file ]]; then
      rm -rf $file
    fi
  done
}

# check switch argument value
check_arg_value()
{
  if [[ ($1 == "-step") && (($2 != "compile") && ($2 != "elaborate") && ($2 != "simulate")) ]];then
    echo -e "ERROR: Invalid or missing step '$2' (type \"./top.sh -help\" for more information)\n"
    exit 1
  fi

  if [[ ($1 == "-lib_map_path") && ($2 == "") ]];then
    echo -e "ERROR: Simulation library directory path not specified (type \"./axi_switch_0.sh -help\" for more information)\n"
    exit 1
  fi
}

# check command line arguments
check_args()
{
  arg_count=$#
  if [[ ("$#" == 1) && (("$1" == "-help") || ("$1" == "-h")) ]]; then
    usage
  fi
  while [[ "$#" -gt 0 ]]; do
    case $1 in
      -step)          check_arg_value $1 $2;step=$2;         b_step=1;         shift;;
      -lib_map_path)  check_arg_value $1 $2;lib_map_path=$2; b_lib_map_path=1; shift;;
      -gen_bypass)    b_gen_bypass=1    ;;
      -rerun)         b_rerun=1         ;;
      -reset_run)     b_reset_run=1     ;;
      -clean)         b_clean=1         ;;
      -reset_log)     b_reset_log=1     ;;
      -keep_index)    b_keep_index=1    ;;
      -noclean_files) b_noclean_files=1 ;;
      -help|-h)       ;;
      *) echo -e "ERROR: Invalid option specified '$1' (type "./top.sh -help" for more information)\n"; exit 1 ;;
    esac
     shift
  done

  # -reset_run is not applicable with other switches
  if [[ ("$arg_count" -gt 1) && ($b_reset_run == 1) ]]; then
    echo -e "ERROR: -reset_run switch is not applicable with other switches (type \"./top.sh -help\" for more information)\n"
    exit 1
  fi

  # -clean is not applicable with other switches
  if [[ ("$arg_count" -gt 1) && ($b_clean == 1) ]]; then
    echo -e "ERROR: -clean switch is not applicable with other switches (type \"./top.sh -help\" for more information)\n"
    exit 1
  fi

  # -reset_log is not applicable with other switches
  if [[ ("$arg_count" -gt 1) && ($b_reset_log == 1) ]]; then
    echo -e "ERROR: -reset_log switch is not applicable with other switches (type \"./top.sh -help\" for more information)\n"
    exit 1
  fi

  # -keep_index is not applicable with other switches
  if [[ ("$arg_count" -gt 1) && ($b_keep_index == 1) ]]; then
    echo -e "ERROR: -keep_index switch is not applicable with other switches (type \"./top.sh -help\" for more information)\n"
    exit 1
  fi

  # -noclean_files is not applicable with other switches
  if [[ ("$arg_count" -gt 1) && ($b_noclean_files == 1) ]]; then
    echo -e "ERROR: -noclean_files switch is not applicable with other switches (type \"./top.sh -help\" for more information)\n"
    exit 1
  fi
}

# script usage
usage()
{
  msg="Usage: axi_switch_0.sh [-help]\n\
Usage: axi_switch_0.sh [-step]\n\
Usage: axi_switch_0.sh [-lib_map_path]\n\
Usage: axi_switch_0.sh [-rerun]\n\
Usage: axi_switch_0.sh [-reset_run]\n\
Usage: axi_switch_0.sh [-clean]\n\
Usage: axi_switch_0.sh [-reset_log]\n\
Usage: axi_switch_0.sh [-keep_index]\n\
Usage: axi_switch_0.sh [-noclean_files]\n\n\
[-help] -- Print help information for this script\n\n\
[-step <name>] -- Execute specified step (simulate)\n\n\
[-lib_map_path <path>] -- Compiled simulation library directory path. The simulation library is compiled\n\
using the compile_simlib tcl command. Please see 'compile_simlib -help' for more information.\n\n\
[-rerun] -- Rerun step(s) in incremental mode (data generated from the previous run will be retained).\n\
To rerun a specific step, pass the -step <name> switch in addition to -rerun switch.\n\n\
[-reset_run] -- Delete simulator generated data files from the previous run and recreate simulator setup\n\
file/library mappings for a clean run. This switch will not execute steps defined in the script.\n\n\
NOTE: To keep simulator index file settings from the previous run, use the -keep_index switch\n\
NOTE: To regenerate simulator index file but keep the simulator generated files, use the -noclean_files switch\n\n\
[-clean] -- Delete simulator generated design library data from the previous run. This switch will not\n\
execute steps defined in the script.\n\n\
[-reset_log] -- Delete simulator generated log files from the previous run\n\n\
[-keep_index] -- Keep simulator index file settings from the previous run\n\n\
[-noclean_files] -- Reset previous run, but do not remove simulator generated files from the previous run\n"
  echo -e $msg
  exit 0
}

# initialize globals
step=""
lib_map_path=""
b_step=0
b_lib_map_path=0
b_gen_bypass=0
b_rerun=0
b_reset_run=0
b_clean=0
b_reset_log=0
b_keep_index=0
b_noclean_files=0

# launch script
run $*
