/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.formula.PlainValueCellCacheEntry;

final class PlainCellCache {
    private Map<Loc, PlainValueCellCacheEntry> _plainValueEntriesByLoc = new HashMap<Loc, PlainValueCellCacheEntry>();

    public void put(Loc key, PlainValueCellCacheEntry cce) {
        this._plainValueEntriesByLoc.put(key, cce);
    }

    public void clear() {
        this._plainValueEntriesByLoc.clear();
    }

    public PlainValueCellCacheEntry get(Loc key) {
        return this._plainValueEntriesByLoc.get(key);
    }

    public void remove(Loc key) {
        this._plainValueEntriesByLoc.remove(key);
    }

    public static final class Loc {
        private final int _bookSheetColumn;
        private final int _rowIndex;

        public Loc(int bookIndex, int sheetIndex, int rowIndex, int columnIndex) {
            this._bookSheetColumn = Loc.toBookSheetColumn(bookIndex, sheetIndex, columnIndex);
            this._rowIndex = rowIndex;
        }

        public static int toBookSheetColumn(int bookIndex, int sheetIndex, int columnIndex) {
            return ((bookIndex & 0xFF) << 24) + ((sheetIndex & 0xFF) << 16) + ((columnIndex & 0xFFFF) << 0);
        }

        public Loc(int bookSheetColumn, int rowIndex) {
            this._bookSheetColumn = bookSheetColumn;
            this._rowIndex = rowIndex;
        }

        public int hashCode() {
            return this._bookSheetColumn + 17 * this._rowIndex;
        }

        public boolean equals(Object obj) {
            assert (obj instanceof Loc) : "these package-private cache key instances are only compared to themselves";
            Loc other = (Loc)obj;
            return this._bookSheetColumn == other._bookSheetColumn && this._rowIndex == other._rowIndex;
        }

        public int getRowIndex() {
            return this._rowIndex;
        }

        public int getColumnIndex() {
            return this._bookSheetColumn & 0xFFFF;
        }
    }
}

