
#
#**************************************************************************************
#
# NoCintro.tcl
#
# History
#    2024/06/07 - OB - initial cut, removed all other tcl script dependencies

#**************************************************************************************
#

proc projectCreate {} {

create_project NoCintro $::env(TRAINING_PATH)/NoCintro/lab -part xcvc1902-vsva2197-2MP-e-S
set_property board_part xilinx.com:vck190:part0:3.4 [current_project]
set_property target_language VHDL [current_project]
}

proc blockDesignCreate {} {

create_bd_design "blkdsgn"

}

proc addStuff {} {
 
   # add CIPS
   
create_bd_cell -type ip -vlnv xilinx.com:ip:versal_cips:3.4 versal_cips_0
   
   # removed processorConfigure and added the configuration for cips in this completer file, this is a lab specific script that is different from the processorConfigure proc used in the completer_helper file
   apply_bd_automation -rule xilinx.com:bd_rule:cips -config { board_preset {Yes} boot_config {Custom} configure_noc {Add new AXI NoC} debug_config {JTAG} design_flow {Full System} mc_type {None} num_mc {1} pl_clocks {1} pl_resets {1}}  [get_bd_cells versal_cips_0]
   
   
   set_property -dict [list CONFIG.CLOCK_MODE {Custom} CONFIG.DEBUG_MODE {JTAG} CONFIG.PS_BOARD_INTERFACE {ps_pmc_fixed_io} CONFIG.PS_PMC_CONFIG { CLOCK_MODE {Custom} DEBUG_MODE {JTAG} DESIGN_MODE {1}  PMC_GPIO0_MIO_PERIPHERAL {{ENABLE 1} {IO {PMC_MIO 0 .. 25}}} PMC_GPIO1_MIO_PERIPHERAL {{ENABLE 1} {IO {PMC_MIO 26 .. 51}}} PMC_MIO37 {{AUX_IO 0} {DIRECTION out} {DRIVE_STRENGTH 8mA} {OUTPUT_DATA high} {PULL pullup} {SCHMITT 0} {SLEW slow} {USAGE GPIO}} PMC_OSPI_PERIPHERAL {{ENABLE 0} {IO {PMC_MIO 0 .. 11}} {MODE Single}} PMC_QSPI_COHERENCY {0} PMC_QSPI_FBCLK {{ENABLE 1} {IO {PMC_MIO 6}}} PMC_QSPI_PERIPHERAL_DATA_MODE {x4} PMC_QSPI_PERIPHERAL_ENABLE {1} PMC_QSPI_PERIPHERAL_MODE {Dual Parallel} PMC_REF_CLK_FREQMHZ {33.3333} PMC_SD1 {{CD_ENABLE 1} {CD_IO {PMC_MIO 28}} {POW_ENABLE 1} {POW_IO {PMC_MIO 51}} {RESET_ENABLE 0} {RESET_IO {PMC_MIO 12}} {WP_ENABLE 0} {WP_IO {PMC_MIO 1}}} PMC_SD1_COHERENCY {0} PMC_SD1_DATA_TRANSFER_MODE {8Bit} PMC_SD1_PERIPHERAL {{CLK_100_SDR_OTAP_DLY 0x3} {CLK_200_SDR_OTAP_DLY 0x2} {CLK_50_DDR_ITAP_DLY 0x36} {CLK_50_DDR_OTAP_DLY 0x3} {CLK_50_SDR_ITAP_DLY 0x2C} {CLK_50_SDR_OTAP_DLY 0x4} {ENABLE 1} {IO {PMC_MIO 26 .. 36}}} PMC_SD1_SLOT_TYPE {SD 3.0} PS_BOARD_INTERFACE {ps_pmc_fixed_io} PS_CAN1_PERIPHERAL {{ENABLE 1} {IO {PMC_MIO 40 .. 41}}} PS_CRL_CAN1_REF_CTRL_FREQMHZ {160} PS_ENET0_MDIO {{ENABLE 1} {IO {PS_MIO 24 .. 25}}} PS_ENET0_PERIPHERAL {{ENABLE 1} {IO {PS_MIO 0 .. 11}}} PS_ENET1_PERIPHERAL {{ENABLE 1} {IO {PS_MIO 12 .. 23}}} PS_GEN_IPI0_ENABLE {1} PS_GEN_IPI0_MASTER {A72} PS_GEN_IPI1_ENABLE {1} PS_GEN_IPI2_ENABLE {1} PS_GEN_IPI3_ENABLE {1} PS_GEN_IPI4_ENABLE {1} PS_GEN_IPI5_ENABLE {1} PS_GEN_IPI6_ENABLE {1} PS_HSDP_EGRESS_TRAFFIC {JTAG} PS_HSDP_INGRESS_TRAFFIC {JTAG} PS_HSDP_MODE {NONE} PS_I2C0_PERIPHERAL {{ENABLE 1} {IO {PMC_MIO 46 .. 47}}} PS_I2C1_PERIPHERAL {{ENABLE 1} {IO {PMC_MIO 44 .. 45}}} PS_MIO19 {{AUX_IO 0} {DIRECTION in} {DRIVE_STRENGTH 8mA} {OUTPUT_DATA default} {PULL disable} {SCHMITT 0} {SLEW slow} {USAGE Reserved}} PS_MIO21 {{AUX_IO 0} {DIRECTION in} {DRIVE_STRENGTH 8mA} {OUTPUT_DATA default} {PULL disable} {SCHMITT 0} {SLEW slow} {USAGE Reserved}} PS_MIO7 {{AUX_IO 0} {DIRECTION in} {DRIVE_STRENGTH 8mA} {OUTPUT_DATA default} {PULL disable} {SCHMITT 0} {SLEW slow} {USAGE Reserved}} PS_MIO9 {{AUX_IO 0} {DIRECTION in} {DRIVE_STRENGTH 8mA} {OUTPUT_DATA default} {PULL disable} {SCHMITT 0} {SLEW slow} {USAGE Reserved}} PS_NUM_FABRIC_RESETS {1} PS_PCIE_EP_RESET1_IO {PMC_MIO 38} PS_PCIE_EP_RESET2_IO {PMC_MIO 39} PS_PCIE_RESET {ENABLE 1} PS_UART0_PERIPHERAL {{ENABLE 1} {IO {PMC_MIO 42 .. 43}}} PS_USB3_PERIPHERAL {{ENABLE 1} {IO {PMC_MIO 13 .. 25}}} PS_USE_FPD_AXI_NOC0 {1} PS_USE_PMCPL_CLK0 {1} SMON_ALARMS {Set_Alarms_On} SMON_ENABLE_TEMP_AVERAGING {0} SMON_TEMP_AVERAGING_SAMPLES {0} 
  } ] [get_bd_cells versal_cips_0]
   
   
   
   # add two traffic generators
   create_bd_cell -type ip -vlnv xilinx.com:ip:perf_axi_tg:1.0 noc_axi_tg_0;
   create_bd_cell -type ip -vlnv xilinx.com:ip:perf_axi_tg:1.0 noc_axi_tg_1;
   
   
   # add two BRAMs
   create_bd_cell -type ip -vlnv xilinx.com:ip:axi_bram_ctrl:4.1 axi_bram_ctrl_0;
   apply_bd_automation -rule xilinx.com:bd_rule:bram_cntlr -config {BRAM "Auto" }  [get_bd_intf_pins axi_bram_ctrl_0/BRAM_PORTA];
   apply_bd_automation -rule xilinx.com:bd_rule:bram_cntlr -config {BRAM "Auto" }  [get_bd_intf_pins axi_bram_ctrl_0/BRAM_PORTB];
   create_bd_cell -type ip -vlnv xilinx.com:ip:axi_bram_ctrl:4.1 axi_bram_ctrl_1;
   apply_bd_automation -rule xilinx.com:bd_rule:bram_cntlr -config {BRAM "Auto" }  [get_bd_intf_pins axi_bram_ctrl_1/BRAM_PORTA];
   apply_bd_automation -rule xilinx.com:bd_rule:bram_cntlr -config {BRAM "Auto" }  [get_bd_intf_pins axi_bram_ctrl_1/BRAM_PORTB];
   
   puts "addStuff complete!";
}

proc tgEnable {} {

   delete_bd_objs [get_bd_nets -quiet xlconstant*]; # get rid of the old connections
   set IPtoRemove [get_bd_cells -quiet {xlconstant*}];
   delete_bd_objs -quiet $IPtoRemove;  

   create_bd_cell -type ip -vlnv xilinx.com:ip:xlconstant:1.1 xlconstant_0;
   
   connect_bd_net [get_bd_pins xlconstant_0/dout] [get_bd_pins noc_axi_tg_0/trigger_in];
   connect_bd_net [get_bd_pins xlconstant_0/dout] [get_bd_pins noc_axi_tg_1/trigger_in];
   connect_bd_net [get_bd_pins xlconstant_0/dout] [get_bd_pins noc_axi_tg_0/axi_tg_start];
   connect_bd_net [get_bd_pins xlconstant_0/dout] [get_bd_pins noc_axi_tg_1/axi_tg_start];
}

#<copyright-disclaimer-start>
#  **************************************************************************************************************
#  * © 2026 Advanced Micro Devices, Inc. All rights reserved.                                                   *
#  * DISCLAIMER                                                                                                 *
#  * The information contained herein is for informational purposes only, and is subject to change              *
#  * without notice. While every precaution has been taken in the preparation of this document, it              *
#  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
#  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
#  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
#  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
#  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
#  * hardware, software or other products described herein.  No license, including implied or                   *
#  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
#  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
#  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
#  *                                                                                                            *
#  **************************************************************************************************************
#<copyright-disclaimer-end>
