/********************************************* Disclaimer *********************************************/
/* This file is generated by aiecompiler . */
/* Changes to this file may cause incorrect behavior and will be lost if aiecompiler is invoked again.*/

/************************** Constants/Macros *****************************/
#define HW_GEN                   XAIE_DEV_GEN_AIE
#define XAIE_NUM_ROWS            9
#define XAIE_NUM_COLS            50
#define XAIE_BASE_ADDR           0x20000000000
#define XAIE_COL_SHIFT           23
#define XAIE_ROW_SHIFT           18
#define XAIE_SHIM_ROW            0
#define XAIE_MEM_TILE_ROW_START  0
#define XAIE_MEM_TILE_NUM_ROWS   0
#define XAIE_AIE_TILE_ROW_START  1
#define XAIE_AIE_TILE_NUM_ROWS   8
#define FOR_WRITE                0
#define FOR_READ                 1
#define XAIE_PARTITION_BASE_ADDR (XAIE_BASE_ADDR + (0 << 23))

/***************************** Includes *********************************/
#include <fstream>
#include <adf.h>
extern "C"
{
  #include <xaiengine.h>
}

#if defined(__CDO__) || defined(__AIECONTROLCODE__)
#include "adf/adf_api/common_layer/fal_util.h"
#endif

#include "adf/adf_api/AIEControlConfig.h"

XAie_InstDeclare(DevInst, &ConfigPtr);   // Declare global device instance


/************************** Functions/APIs *****************************/
  adf::return_code broadcastConfigForCoreEnable()
  {
	if(!adf::reserveBroadcastchannelForEnablingCores())
	{
		std::cerr << "ERROR: Failed to reserve Broadcast channels for enabling core.\n";
		return adf::return_code::aie_driver_error;
	}

	int driverStatus = AieRC::XAIE_OK;
	driverStatus |= XAie_EventBroadcast(&DevInst, XAie_TileLoc(24, 0), XAIE_PL_MOD, 7, XAIE_EVENT_BROADCAST_A_8_PL);
	driverStatus |= XAie_EventBroadcastBlockDir(&DevInst, XAie_TileLoc(24, 0), XAIE_PL_MOD, XAIE_EVENT_SWITCH_A, 7, XAIE_EVENT_BROADCAST_SOUTH | XAIE_EVENT_BROADCAST_WEST | XAIE_EVENT_BROADCAST_EAST);
	driverStatus |= XAie_EventBroadcastBlockDir(&DevInst, XAie_TileLoc(24, 0), XAIE_PL_MOD, XAIE_EVENT_SWITCH_A, 8, XAIE_EVENT_BROADCAST_SOUTH | XAIE_EVENT_BROADCAST_WEST | XAIE_EVENT_BROADCAST_NORTH);
	driverStatus |= XAie_EventBroadcastBlockDir(&DevInst, XAie_TileLoc(24, 0), XAIE_PL_MOD, XAIE_EVENT_SWITCH_B, 8, XAIE_EVENT_BROADCAST_SOUTH | XAIE_EVENT_BROADCAST_WEST | XAIE_EVENT_BROADCAST_NORTH);
	driverStatus |= XAie_EventBroadcast(&DevInst, XAie_TileLoc(25, 0), XAIE_PL_MOD, 7, XAIE_EVENT_BROADCAST_A_8_PL);
	driverStatus |= XAie_EventBroadcastBlockDir(&DevInst, XAie_TileLoc(25, 0), XAIE_PL_MOD, XAIE_EVENT_SWITCH_A, 7, XAIE_EVENT_BROADCAST_SOUTH | XAIE_EVENT_BROADCAST_WEST | XAIE_EVENT_BROADCAST_EAST);
	driverStatus |= XAie_EventBroadcastBlockDir(&DevInst, XAie_TileLoc(25, 0), XAIE_PL_MOD, XAIE_EVENT_SWITCH_A, 8, XAIE_EVENT_BROADCAST_SOUTH | XAIE_EVENT_BROADCAST_WEST | XAIE_EVENT_BROADCAST_NORTH);
	driverStatus |= XAie_EventBroadcastBlockDir(&DevInst, XAie_TileLoc(25, 0), XAIE_PL_MOD, XAIE_EVENT_SWITCH_B, 8, XAIE_EVENT_BROADCAST_SOUTH | XAIE_EVENT_BROADCAST_WEST | XAIE_EVENT_BROADCAST_NORTH);
	driverStatus |= XAie_EventBroadcastBlockDir(&DevInst, XAie_TileLoc(24, 1), XAIE_CORE_MOD, XAIE_EVENT_SWITCH_A, 7, XAIE_EVENT_BROADCAST_SOUTH | XAIE_EVENT_BROADCAST_WEST | XAIE_EVENT_BROADCAST_EAST);
	driverStatus |= XAie_EventBroadcastBlockDir(&DevInst, XAie_TileLoc(24, 1), XAIE_MEM_MOD, XAIE_EVENT_SWITCH_A, 7, XAIE_EVENT_BROADCAST_ALL);
	driverStatus |= XAie_EventBroadcastBlockDir(&DevInst, XAie_TileLoc(24, 2), XAIE_CORE_MOD, XAIE_EVENT_SWITCH_A, 7, XAIE_EVENT_BROADCAST_SOUTH | XAIE_EVENT_BROADCAST_WEST | XAIE_EVENT_BROADCAST_EAST);
	driverStatus |= XAie_EventBroadcastBlockDir(&DevInst, XAie_TileLoc(24, 2), XAIE_MEM_MOD, XAIE_EVENT_SWITCH_A, 7, XAIE_EVENT_BROADCAST_ALL);
	driverStatus |= XAie_EventBroadcastBlockDir(&DevInst, XAie_TileLoc(25, 1), XAIE_CORE_MOD, XAIE_EVENT_SWITCH_A, 7, XAIE_EVENT_BROADCAST_SOUTH | XAIE_EVENT_BROADCAST_WEST | XAIE_EVENT_BROADCAST_EAST);
	driverStatus |= XAie_EventBroadcastBlockDir(&DevInst, XAie_TileLoc(25, 1), XAIE_MEM_MOD, XAIE_EVENT_SWITCH_A, 7, XAIE_EVENT_BROADCAST_ALL);
	driverStatus |= XAie_EventBroadcastBlockDir(&DevInst, XAie_TileLoc(25, 2), XAIE_CORE_MOD, XAIE_EVENT_SWITCH_A, 7, XAIE_EVENT_BROADCAST_SOUTH | XAIE_EVENT_BROADCAST_WEST | XAIE_EVENT_BROADCAST_EAST);
	driverStatus |= XAie_EventBroadcastBlockDir(&DevInst, XAie_TileLoc(25, 2), XAIE_MEM_MOD, XAIE_EVENT_SWITCH_A, 7, XAIE_EVENT_BROADCAST_ALL);
	driverStatus |= XAie_EventBroadcast(&DevInst, XAie_TileLoc(0, 0), XAIE_PL_MOD, 8, XAIE_EVENT_BROADCAST_A_8_PL);
	return (driverStatus == AieRC::XAIE_OK) ? adf::return_code::ok : adf::aie_driver_error;
  }

  bool clipgraph_load_elf(const std::string& work_path, std::vector<std::string>& elfInfoPath)
  {
	#ifdef __PS_INIT_AIE__

	std::string work_dir = (work_path.empty() ?  "/home/amd/training/system_simulation/lab/sys_project/aie_component/build/hw/./Work" : work_path);
	std::cout<<"Loading elfs of graph clipgraph..."<<std::endl;
	if(XAie_LoadElf(&DevInst, XAie_TileLoc(24, 1), (work_dir + "/aie/24_0/Release/24_0").c_str(), XAIE_ENABLE)!=XAIE_OK)
	{
		std::cerr << "ERROR: Failed to load elf for core(24,0)" << std::endl;
		return false;
	}
	if(XAie_LoadElf(&DevInst, XAie_TileLoc(24, 2), (work_dir + "/aie/24_1/Release/24_1").c_str(), XAIE_ENABLE)!=XAIE_OK)
	{
		std::cerr << "ERROR: Failed to load elf for core(24,1)" << std::endl;
		return false;
	}
	if(XAie_LoadElf(&DevInst, XAie_TileLoc(25, 1), (work_dir + "/aie/25_0/Release/25_0").c_str(), XAIE_ENABLE)!=XAIE_OK)
	{
		std::cerr << "ERROR: Failed to load elf for core(25,0)" << std::endl;
		return false;
	}
	#endif

	return true;
  }

  adf::return_code clipgraph_init(const std::string& work_path)
  {

	std::cout<<"Initializing graph clipgraph..."<<std::endl;

	int driverStatus = AieRC::XAIE_OK;

    #ifdef __PS_INIT_AIE__

	std::string work_dir = (work_path.empty() ?  "/home/amd/training/system_simulation/lab/sys_project/aie_component/build/hw/./Work" : work_path);
	// S_AIE_OUT_ch0_C24_R1 M_SOUTH_ch3_C24_R1 net2

	driverStatus |= XAie_StrmConnCctEnable(&DevInst, XAie_TileLoc(24, 2), CORE, 0, SOUTH, 3);

	// S_EAST_ch3_C24_R1 M_AIE_IN_ch0_C24_R1 net1

	driverStatus |= XAie_StrmConnCctEnable(&DevInst, XAie_TileLoc(24, 2), EAST, 3, CORE, 0);

	// S_MM2S_DMA_ch0_C24_R0 M_SOUTH_ch3_C24_R0 net3

	driverStatus |= XAie_StrmConnCctEnable(&DevInst, XAie_TileLoc(24, 1), DMA, 0, SOUTH, 3);

	// S_MM2S_DMA_ch0_C25_R1 M_WEST_ch3_C25_R1 net1

	driverStatus |= XAie_StrmConnCctEnable(&DevInst, XAie_TileLoc(25, 2), DMA, 0, WEST, 3);

	// S_NORTH_ch3_C24_R0 M_AIE_IN_ch0_C24_R0 net2

	driverStatus |= XAie_StrmConnCctEnable(&DevInst, XAie_TileLoc(24, 1), NORTH, 3, CORE, 0);

	// S_SHIM_NORTH_ch3_C24 M_SHIM_SOUTH_ch0_C24 net3

	driverStatus |= XAie_StrmConnCctEnable(&DevInst, XAie_TileLoc(24, 0), NORTH, 3, SOUTH, 0);

	// S_SHIM_SOUTH_ch0_C25 M_SHIM_NORTH_ch5_C25 net0

	driverStatus |= XAie_StrmConnCctEnable(&DevInst, XAie_TileLoc(25, 0), SOUTH, 0, NORTH, 5);

	// S_SOUTH_ch5_C25_R0 M_S2MM_DMA_ch0_C25_R0 net0

	driverStatus |= XAie_StrmConnCctEnable(&DevInst, XAie_TileLoc(25, 1), SOUTH, 5, DMA, 0);


	std::cout<<"Resetting cores of graph clipgraph..."<<std::endl;
	driverStatus |= XAie_CoreReset(&DevInst, XAie_TileLoc(24, 1));
	driverStatus |= XAie_CoreUnreset(&DevInst, XAie_TileLoc(24, 1));
	driverStatus |= XAie_CoreConfigureDone(&DevInst, XAie_TileLoc(24, 1));
	driverStatus |= XAie_CoreReset(&DevInst, XAie_TileLoc(24, 2));
	driverStatus |= XAie_CoreUnreset(&DevInst, XAie_TileLoc(24, 2));
	driverStatus |= XAie_CoreConfigureDone(&DevInst, XAie_TileLoc(24, 2));
	driverStatus |= XAie_CoreReset(&DevInst, XAie_TileLoc(25, 1));
	driverStatus |= XAie_CoreUnreset(&DevInst, XAie_TileLoc(25, 1));
	driverStatus |= XAie_CoreConfigureDone(&DevInst, XAie_TileLoc(25, 1));

	std::cout<<"Configuring DMAs of graph clipgraph..."<<std::endl;

	//Setting buffer buf0 of clipgraph.interpolator.in[0]
	{
		XAie_DmaDesc DmaInst;
		driverStatus |= XAie_DmaDescInit(&DevInst, &DmaInst, XAie_TileLoc(25, 1));
		driverStatus |= XAie_DmaSetAddrLen(&DmaInst, 0x4040, 512);
		driverStatus |= XAie_DmaSetLock(&DmaInst, XAie_LockInit(0, 0), XAie_LockInit(0, 1));
		driverStatus |= XAie_DmaSetNextBd(&DmaInst, 1, XAIE_ENABLE);
		driverStatus |= XAie_DmaEnableBd(&DmaInst);
		driverStatus |= XAie_DmaWriteBd(&DevInst, &DmaInst, XAie_TileLoc(25, 1), 0);
	}

	//Setting buffer buf0d of clipgraph.interpolator.in[0]
	{
		XAie_DmaDesc DmaInst;
		driverStatus |= XAie_DmaDescInit(&DevInst, &DmaInst, XAie_TileLoc(25, 1));
		driverStatus |= XAie_DmaSetAddrLen(&DmaInst, 0x6040, 512);
		driverStatus |= XAie_DmaSetLock(&DmaInst, XAie_LockInit(1, 0), XAie_LockInit(1, 1));
		driverStatus |= XAie_DmaSetNextBd(&DmaInst, 0, XAIE_ENABLE);
		driverStatus |= XAie_DmaEnableBd(&DmaInst);
		driverStatus |= XAie_DmaWriteBd(&DevInst, &DmaInst, XAie_TileLoc(25, 1), 1);
	}

	driverStatus |= XAie_DmaChannelPushBdToQueue(&DevInst, XAie_TileLoc(25, 1), 0, DMA_S2MM, 0);
	driverStatus |= XAie_DmaChannelEnable(&DevInst, XAie_TileLoc(25, 1), 0, DMA_S2MM);

	//Setting buffer buf1 of clipgraph.interpolator.out[0]
	{
		XAie_DmaDesc DmaInst;
		driverStatus |= XAie_DmaDescInit(&DevInst, &DmaInst, XAie_TileLoc(25, 2));
		driverStatus |= XAie_DmaSetAddrLen(&DmaInst, 0x0, 1024);
		driverStatus |= XAie_DmaSetLock(&DmaInst, XAie_LockInit(0, 1), XAie_LockInit(0, 0));
		driverStatus |= XAie_DmaSetNextBd(&DmaInst, 1, XAIE_ENABLE);
		driverStatus |= XAie_DmaEnableBd(&DmaInst);
		driverStatus |= XAie_DmaWriteBd(&DevInst, &DmaInst, XAie_TileLoc(25, 2), 0);
	}

	//Setting buffer buf1d of clipgraph.interpolator.out[0]
	{
		XAie_DmaDesc DmaInst;
		driverStatus |= XAie_DmaDescInit(&DevInst, &DmaInst, XAie_TileLoc(25, 2));
		driverStatus |= XAie_DmaSetAddrLen(&DmaInst, 0x2000, 1024);
		driverStatus |= XAie_DmaSetLock(&DmaInst, XAie_LockInit(1, 1), XAie_LockInit(1, 0));
		driverStatus |= XAie_DmaSetNextBd(&DmaInst, 0, XAIE_ENABLE);
		driverStatus |= XAie_DmaEnableBd(&DmaInst);
		driverStatus |= XAie_DmaWriteBd(&DevInst, &DmaInst, XAie_TileLoc(25, 2), 1);
	}

	driverStatus |= XAie_DmaChannelPushBdToQueue(&DevInst, XAie_TileLoc(25, 2), 0, DMA_MM2S, 0);
	driverStatus |= XAie_DmaChannelEnable(&DevInst, XAie_TileLoc(25, 2), 0, DMA_MM2S);

	//Setting buffer buf2 of clipgraph.classify.out[0]
	{
		XAie_DmaDesc DmaInst;
		driverStatus |= XAie_DmaDescInit(&DevInst, &DmaInst, XAie_TileLoc(24, 1));
		driverStatus |= XAie_DmaSetAddrLen(&DmaInst, 0x33a0, 1024);
		driverStatus |= XAie_DmaSetLock(&DmaInst, XAie_LockInit(0, 1), XAie_LockInit(0, 0));
		driverStatus |= XAie_DmaSetNextBd(&DmaInst, 1, XAIE_ENABLE);
		driverStatus |= XAie_DmaEnableBd(&DmaInst);
		driverStatus |= XAie_DmaWriteBd(&DevInst, &DmaInst, XAie_TileLoc(24, 1), 0);
	}

	//Setting buffer buf2d of clipgraph.classify.out[0]
	{
		XAie_DmaDesc DmaInst;
		driverStatus |= XAie_DmaDescInit(&DevInst, &DmaInst, XAie_TileLoc(24, 1));
		driverStatus |= XAie_DmaSetAddrLen(&DmaInst, 0x1800, 1024);
		driverStatus |= XAie_DmaSetLock(&DmaInst, XAie_LockInit(1, 1), XAie_LockInit(1, 0));
		driverStatus |= XAie_DmaSetNextBd(&DmaInst, 0, XAIE_ENABLE);
		driverStatus |= XAie_DmaEnableBd(&DmaInst);
		driverStatus |= XAie_DmaWriteBd(&DevInst, &DmaInst, XAie_TileLoc(24, 1), 1);
	}

	driverStatus |= XAie_DmaChannelPushBdToQueue(&DevInst, XAie_TileLoc(24, 1), 0, DMA_MM2S, 0);
	driverStatus |= XAie_DmaChannelEnable(&DevInst, XAie_TileLoc(24, 1), 0, DMA_MM2S);

	std::cout<<"Configuring PL-Interface for graph clipgraph..."<<std::endl;
	driverStatus |= XAie_PlIfBliBypassDisable(&DevInst, XAie_TileLoc(25, 0), 0);
	driverStatus |= XAie_PlToAieIntfEnable (&DevInst, XAie_TileLoc(25, 0), 0, PLIF_WIDTH_32);
	driverStatus |= XAie_AieToPlIntfEnable (&DevInst, XAie_TileLoc(24, 0), 0, PLIF_WIDTH_32);


    #endif
	if(driverStatus != AieRC::XAIE_OK)
	{
		return adf::aie_driver_error;
	}

	return adf::ok;
  }

 void clipgraph_core_debug_halt()
  {
	printf("Putting core(s) of graph clipgraph on halt state for debugging...\n");
	XAie_CoreDebugHalt(&DevInst, XAie_TileLoc(24, 1));
	XAie_CoreDebugHalt(&DevInst, XAie_TileLoc(24, 2));
	XAie_CoreDebugHalt(&DevInst, XAie_TileLoc(25, 1));
	return;
  }

  void clipgraph_core_enable()
  {
	printf("Enabling core(s) of graph clipgraph...\n");
	XAie_CoreEnable(&DevInst, XAie_TileLoc(24,1 ));
	XAie_CoreEnable(&DevInst, XAie_TileLoc(24,2 ));
	XAie_CoreEnable(&DevInst, XAie_TileLoc(25,1 ));
	return;
  }

/************************** Graph Configurations  *****************************/

  adf::GraphConfig GraphConfigurations[] = {
  //{id, name, graphLoadElfFunc, graphInitFunc, graphDebugHalt, coreColumns, coreRows, iterMemColumns, iterMemRows, iterMemAddrs, triggered, plKernelInstanceNames, plAxiLiteModes, plDriverStartFuncs, plDriverCheckIPDoneFuncs}
    {0, "clipgraph", &clipgraph_load_elf, &clipgraph_init, &clipgraph_core_debug_halt, {24, 24, 25}, {0, 1, 0}, {24, 24, 25}, {0, 1, 0}, {0x6004, 0x4, 0x2004}, {0, 0, 0}, {}, {}, {}, {},  }, 
  };
  const int NUM_GRAPH = 1;

/************************** PLIO Configurations  *****************************/

  adf::PLIOConfig PLIOConfigurations[] = {
  //{id, name, loginal_name, shim_column, slaveOrMaster, streamId}
    {0, "clipgraph.in", "DataIn1", 25, 0, 0},
    {1, "clipgraph.out", "DataOut1", 24, 1, 0},
  };
  const int NUM_PLIO = 2;


/************************** AIE driver and ADF API initializer *****************************/

  class InitializeAIEControl
  {
  public:
    InitializeAIEControl()
    {
      printf("Initializing AIE driver...\n");
      XAie_SetupConfig(ConfigPtr, HW_GEN, XAIE_BASE_ADDR, XAIE_COL_SHIFT,
                       XAIE_ROW_SHIFT, XAIE_NUM_COLS, XAIE_NUM_ROWS,
                       XAIE_SHIM_ROW, XAIE_MEM_TILE_ROW_START,
                       XAIE_MEM_TILE_NUM_ROWS, XAIE_AIE_TILE_ROW_START,
                       XAIE_AIE_TILE_NUM_ROWS);

      XAie_SetupPartitionConfig(&DevInst, XAIE_PARTITION_BASE_ADDR, 0, 50);

      XAie_CfgInitialize(&(DevInst), &ConfigPtr);

#if defined(__CDO__)
      XAie_SetIOBackend(&(DevInst), XAIE_IO_BACKEND_CDO); // Set aiengine driver library to run for CDO Mode
      XAie_UpdateNpiAddr(&(DevInst), 0xf70a0000);
#elif defined(__AIECONTROLCODE__)
      XAie_SetIOBackend(&(DevInst), XAIE_IO_BACKEND_CONTROLCODE); // Set aiengine driver library to run for CONTROLCODE Mode
      XAie_UpdateNpiAddr(&(DevInst), 0xf70a0000);
#endif

#if defined(__AIESIM__)
      XAie_TurnEccOff(&DevInst);
#endif

      printf("Initializing ADF API...\n");

#if defined(__AIESIM__)
      extern unsigned ess_debug;
#else
      unsigned ess_debug = false;
#endif

#ifdef __EXCLUDE_PL_CONTROL__
      bool exclude_pl_control = true;
#else
      bool exclude_pl_control = false;
#endif

#ifdef __CDO__
      int trace_config_stream_option = 2;
#else
      int trace_config_stream_option = 0;
#endif

      adf::initializeConfigurations(&DevInst, XAIE_NUM_COLS, XAIE_AIE_TILE_NUM_ROWS, XAIE_MEM_TILE_NUM_ROWS,
                                        GraphConfigurations, NUM_GRAPH,
                                        nullptr, 0,
                                        nullptr, 0,
                                        nullptr, 0,
                                        nullptr, 0,
                                        nullptr, 0,
                                        nullptr, 0,
                                        nullptr, 0,
                                        nullptr, 0,
                                        PLIOConfigurations, NUM_PLIO,
                                        nullptr, 0, trace_config_stream_option, nullptr,
                                        ess_debug, exclude_pl_control, true, &broadcastConfigForCoreEnable, true, 0, 2);

    }
  } initAIEControl;


#if defined(__CDO__) || defined(__AIECONTROLCODE__)

/******************* Helper Function to Request Tiles **********************/
/** used in enableErrorHandling, enableClockGating, timerSynchronization ***/

  void requestTiles()
  {
    XAie_LocType locs[6] = {XAie_TileLoc(24, 1), XAie_TileLoc(24, 2), XAie_TileLoc(25, 1), XAie_TileLoc(25, 2), XAie_TileLoc(24, 0), XAie_TileLoc(25, 0)};
    XAie_PmRequestTiles(&DevInst, locs, 6);
  }


/************************** Partition reset *****************************/

  void resetPartition()
  {
    XAie_PartInitOpts opts;
    opts.Locs = nullptr;
    opts.NumUseTiles = 0;
    opts.InitOpts = XAIE_PART_INIT_OPT_COLUMN_RST | XAIE_PART_INIT_OPT_SHIM_RST | XAIE_PART_INIT_OPT_BLOCK_NOCAXIMMERR;
    XAie_DevicePartInfo partitionInfo;
    partitionInfo.StartCol = 0;
    partitionInfo.NumCols = 50;
    partitionInfo.BaseAddr = XAIE_BASE_ADDR;
    XAie_SoftPartitionInitialize(&DevInst, &opts, &partitionInfo);
  }

/************************ Device partition reset ***************************/

  void resetDevicePartition()
  {
      #if defined(__CDO__)
      XAie_SetupConfig(DevicePartitionCfgPtr, HW_GEN, XAIE_BASE_ADDR, XAIE_COL_SHIFT,
                       XAIE_ROW_SHIFT, XAIE_NUM_COLS, XAIE_NUM_ROWS,
                       XAIE_SHIM_ROW, XAIE_MEM_TILE_ROW_START,
                       XAIE_MEM_TILE_NUM_ROWS, XAIE_AIE_TILE_ROW_START,
                       XAIE_AIE_TILE_NUM_ROWS);

      XAie_InstDeclare(DevicePartitionDevInst, &DevicePartitionCfgPtr);

      XAie_SetupPartitionConfig(&DevicePartitionDevInst, (XAIE_BASE_ADDR + (0 << 23)), 0, 50);

      XAie_CfgInitialize(&(DevicePartitionDevInst), &DevicePartitionCfgPtr);

      XAie_SetIOBackend(&(DevicePartitionDevInst), XAIE_IO_BACKEND_CDO);

      XAie_UpdateNpiAddr(&(DevicePartitionDevInst), 0xf70a0000);

      XAie_PartitionInitialize(&DevicePartitionDevInst, nullptr);

      #endif
  }


/************************** Error handling *****************************/

  void enableErrorHandling()
  {
    requestTiles();
    auto spXAieDev = fal_util::get_spXAieDev();
    if (spXAieDev == nullptr)
    {
        printf("s_pXAieDev is null, enableErrorHandling failed\n");
        return;
    }
    spXAieDev->reserveErrorHandling();
    XAie_ErrorHandlingInit(&DevInst);
  }


/************************** Clock gating *****************************/

  void enableClockGating()
  {
    requestTiles();
    auto spXAieDev = fal_util::get_spXAieDev();
    if (spXAieDev == nullptr)
    {
        printf("s_pXAieDev is null, enableClockGating failed\n");
        return;
    }
    spXAieDev->reserveEcc();
    XAie_TurnEccOn(&DevInst);
  }


/************************** Clear Partition Memories *****************************/

  void clearPartitionMems()
  {
    XAie_ClearPartitionMems(&DevInst);
  }
#endif

#if defined(__CDO__) || defined(__AIECONTROLCODE__)
/************************** Collect Statically Allocated Resources *****************************/

  void dumpAllocatedRscsToFile(const std::string aieRscsFilePath)
  {
    auto spXAieDev = fal_util::get_spXAieDev();
    if (spXAieDev == nullptr)
    {
        printf("s_pXAieDev is null, dumpAllocatedRscsToFile failed\n");
        return;
    }
    spXAieDev->saveAllocatedRscsToFile(aieRscsFilePath);
  }
#endif



#if defined(__AIESIM__) || defined(__PS_BARE_METAL__)

  using namespace adf;

// Kernel Stub Definition

#include "kernel_stubs.h"
#endif
