#include "gen_cdo.h"
#include <iostream> 
extern "C" {
#include "cdo_driver.h"
}

int main(int argc, char** argv) {
	std::string workDirPath;
	bool AXIdebug = false;
	bool endianness = byte_ordering::Little_Endian;

	for (int i = 1; i <argc; i++)
	{
		std::string args = argv[i];
		if (args == "-h" || args == "--help") {
			std::cout << "\n******************************************************************************************************************************* \n\n\t";
			std::cout << "\n This script is used in AI Engine Compiler to generate CDO files and record statically allocated resources. Files generated by this script are:\n\n"
				"\t\t\t >> aie_cdo_init.bin            : Initial Configurations. Stream Switch, DMA, SHIM etc...\n"
				"\t\t\t >> aie_cdo_enable.bin          : Core Enable\n"
				"\t\t\t >> aie_cdo_debug.bin           : Core Debug Halt\n"
				"\t\t\t >> aie_cdo_reset.bin           : Partition Reset\n"
				"\t\t\t >> aie_cdo_mem_clear.bin       : Partition DM/PM clearing\n"
				"\t\t\t >> aie_cdo_error_handling.bin  : Error Handling\n"
				"\t\t\t >> aie_cdo_clock_gating.bin    : Clock Gating\n"
				"\t\t\t >> aie_cdo_elfs.bin            : AIE ELF (Default ECC-scrubbing enabled)\n"
				"\t\t\t >> aie_resources.bin           : Statically allocated resource file";
			std::cout << "\n******************************************************************************************************************************* \n\n\t";
			std::cout << "\nAccepted options are :\n\n\t"
			"1) --help or -h: Displays list of options accepted by executable.(Usage: --help) \n\n\t"
			"2) --aximm-dump or -a: Generates AXI-MM Dump helpful for debugging.(Usage: --aximm-dump)\n\n\t"
			"3) --big-endian-cdo or -b: Generates files in big endian format, default is little-endian (Usage: --big-endian-cdo) \n\n  ";
			return EXIT_SUCCESS;
		} else if (args == "-a" || args == "--aximm-dump") {
			AXIdebug = true;
		} else if (args == "-b" || args == "--big-endian-cdo") {
			endianness = byte_ordering::Big_Endian;
		} else if (args == "-w" || args == "--work-dir-path") {
			if (i == argc -1) {
				std::cout << "--work-dir-path is not specified " << std::endl;
				return EXIT_FAILURE;
			}
			workDirPath = std::string(argv[++i]);
		} else {
			std::cout << argv[i] << " unknown option." << std::endl;
			return EXIT_FAILURE;
		}
	}

	if (workDirPath.empty()) {
		std::cout << "--work-dir-path provided without any directory path: ";
		int i = 1;
		while (i <argc)
			std::cout << argv[i++];
		std::cout << "\n";
		return EXIT_FAILURE;
	}

	initializeGenerator(AXIdebug, endianness);
	generateFilesSeparately(workDirPath, AXIdebug) ;
	return EXIT_SUCCESS;
}
