#include "systemc.h"
#include <map>
#include <unordered_map>
#include <thread>
#include <variant>
#include "adf/new_frontend/adf.h"
#include "adf/x86sim/x86sim.h"
#include "adf/x86sim/x86simStreamHelper.h"
#include "adf/io_buffer/io_buffer.h"
#include "adf/adf_api/X86SimConfig.h"
// adf::headers of all kernels
#include "include.h"

////// Kernel function Wrapper declarations //////
void b2_kernel_wrapper(x86sim::stream_internal *, adf::io_buffer<int, adf::direction::out, adf::io_buffer_config<>> &__restrict);
void b0_kernel_wrapper(adf::io_buffer<cint16, adf::direction::in, adf::io_buffer_config<adf::extents<4294967295>, adf::locking::sync, adf::addressing::linear, adf::margin<16>>> &__restrict, adf::io_buffer<cint16, adf::direction::out, adf::io_buffer_config<>> &__restrict);
void b1_kernel_wrapper(x86sim::stream_internal *, x86sim::stream_internal *);

////// Class kernel dtor wrapper extern declaration //////

////// Class kernel ctor wrapper extern declaration //////

////// Kernel Inits extern declaration //////

namespace {
    using _Ty0 = adf::_io_buffer<cint16, adf::direction::in, adf::io_buffer_config< adf::extents<4294967295>, adf::locking::sync, adf::addressing::linear, adf::margin<16> >>;
    using _Ty1 = adf::_io_buffer<cint16, adf::direction::out, adf::io_buffer_config< adf::extents<4294967295>, adf::locking::sync, adf::addressing::linear, adf::margin<0> >>;
    using _Ty2 = adf::_io_buffer<int32, adf::direction::out, adf::io_buffer_config< adf::extents<4294967295>, adf::locking::sync, adf::addressing::linear, adf::margin<0> >>;
} // namespace
namespace x86sim
{

////// Kernel Classes //////

class Kernel_b0_fir_27t_sym_hb_2i : public IMEKernel
{
public: 
    Kernel_b0_fir_27t_sym_hb_2i(ISimulator *sim, std::string label)
    : IMEKernel(sim, label)
    {
    }

protected: 
    virtual void invokeKernel() override
    {
        b0_kernel_wrapper(
          get_input_buffer< _Ty0 >( input(0) ),
          get_output_buffer< _Ty1 >( output(0) )
        );
    }
};

class Kernel_b1_polar_clip : public IMEKernel
{
public: 
    Kernel_b1_polar_clip(ISimulator *sim, std::string label)
    : IMEKernel(sim, label)
    {
    }

protected: 
    virtual void invokeKernel() override
    {
        b1_kernel_wrapper(
          ((IStreamConnector*) input(0)) -> stream(),
          ((IStreamConnector*) output(0)) -> stream()
        );
    }
};

class Kernel_b2_classifier : public IMEKernel
{
public: 
    Kernel_b2_classifier(ISimulator *sim, std::string label)
    : IMEKernel(sim, label)
    {
    }

protected: 
    virtual void invokeKernel() override
    {
        b2_kernel_wrapper(
          ((IStreamConnector*) input(0)) -> stream(),
          get_output_buffer< _Ty2 >( output(0) )
        );
    }
};

////// Set Initial Value for input async RTP //////

static void initValue(IRtpConnector* rtp, int8_t* val, size_t bytes)
{
    updateRtp(val, bytes,rtp);
}

__attribute__ ((noinline)) static void addSnapshotMetaData(std::unordered_map<std::string, std::string> &);

__attribute__ ((noinline)) static void createMallocs(ISimulator *sim, std::unordered_map<const char*, void*> &map_void)
{
}

__attribute__ ((noinline)) static void create_wcon_i3_po0_i0_pi0(ISimulator *sim, IXmcSimulator *xmcSim, std::unordered_map<const char*, IConnector*> &map_IConnector, std::unordered_map<const char*, void*> &map_void)
{
    IWindowConnector *wcon_i3_po0_i0_pi0
        = ConnectorFactory::windowConnector(sim, "wcon_i3_po0_i0_pi0", 512, 64, nullptr, new _Ty0(128,16, 128), 0, 2);
    map_IConnector["wcon_i3_po0_i0_pi0"] = wcon_i3_po0_i0_pi0;
    sim -> addConnectorMetaData(
        {wcon_i3_po0_i0_pi0, "iobuffer", "cint16", "clipgraph.in.out[0]", "clipgraph.interpolator.in[0]", "out", "in"});
}

__attribute__ ((noinline)) static void create_wcon_i2_po0_i4_pi0(ISimulator *sim, IXmcSimulator *xmcSim, std::unordered_map<const char*, IConnector*> &map_IConnector, std::unordered_map<const char*, void*> &map_void)
{
    IWindowConnector *wcon_i2_po0_i4_pi0
        = ConnectorFactory::windowConnector(sim, "wcon_i2_po0_i4_pi0", 1024, 0, new _Ty2(256,0, 256), nullptr, 0, 2);
    map_IConnector["wcon_i2_po0_i4_pi0"] = wcon_i2_po0_i4_pi0;
    sim -> addConnectorMetaData(
        {wcon_i2_po0_i4_pi0, "iobuffer", "int32", "clipgraph.classify.out[0]", "clipgraph.out.in[0]", "out", "in"});
}

__attribute__ ((noinline)) static void create_wcon_i0_po0_i0_po0(ISimulator *sim, IXmcSimulator *xmcSim, std::unordered_map<const char*, IConnector*> &map_IConnector, std::unordered_map<const char*, void*> &map_void)
{
    IWindowConnector *wcon_i0_po0_i0_po0
        = ConnectorFactory::windowConnector(sim, "wcon_i0_po0_i0_po0", 1024, 0, new _Ty1(256,0, 256), nullptr, 0, 2);
    map_IConnector["wcon_i0_po0_i0_po0"] = wcon_i0_po0_i0_po0;
    sim -> addConnectorMetaData(
        {wcon_i0_po0_i0_po0, "iobuffer", "cint16", "clipgraph.interpolator.out[0]", "", "out", ""});
}

__attribute__ ((noinline)) static void create_scon_i1_pi0_i1_pi0(ISimulator *sim, IXmcSimulator *xmcSim, std::unordered_map<const char*, IConnector*> &map_IConnector, std::unordered_map<const char*, void*> &map_void)
{
    IStreamConnector *scon_i1_pi0_i1_pi0
        = ConnectorFactory::streamConnector(sim, "scon_i1_pi0_i1_pi0", 128, true, 0);
    map_IConnector["scon_i1_pi0_i1_pi0"] = scon_i1_pi0_i1_pi0;
    sim -> addConnectorMetaData(
        {scon_i1_pi0_i1_pi0, "stream", "cint16", "clipgraph.clip.in[0]", "clipgraph.clip.in[0]", "in", "in"});
}

__attribute__ ((noinline)) static void create_scon_i1_po0_i2_pi0(ISimulator *sim, IXmcSimulator *xmcSim, std::unordered_map<const char*, IConnector*> &map_IConnector, std::unordered_map<const char*, void*> &map_void)
{
    IStreamConnector *scon_i1_po0_i2_pi0
        = ConnectorFactory::streamConnector(sim, "scon_i1_po0_i2_pi0", 128, true, 0);
    map_IConnector["scon_i1_po0_i2_pi0"] = scon_i1_po0_i2_pi0;
    sim -> addConnectorMetaData(
        {scon_i1_po0_i2_pi0, "stream", "cint16", "clipgraph.clip.out[0]", "clipgraph.classify.in[0]", "out", "in"});
}

__attribute__ ((noinline)) static void createConnectors(ISimulator *sim, IXmcSimulator *xmcSim, std::unordered_map<const char*, IConnector*> &map_IConnector, std::unordered_map<const char*, void*> &map_void)
{
    create_wcon_i3_po0_i0_pi0(sim, xmcSim, map_IConnector, map_void);
    create_wcon_i2_po0_i4_pi0(sim, xmcSim, map_IConnector, map_void);
    create_wcon_i0_po0_i0_po0(sim, xmcSim, map_IConnector, map_void);
    create_scon_i1_pi0_i1_pi0(sim, xmcSim, map_IConnector, map_void);
    create_scon_i1_po0_i2_pi0(sim, xmcSim, map_IConnector, map_void);
}

__attribute__ ((noinline)) static void create_ker_i0(ISimulator *sim, std::unordered_map<const char*, IConnector*> &map_IConnector, std::unordered_map<const char*, DFGraph*> &map_DFGraph)
{
    Kernel_b0_fir_27t_sym_hb_2i *ker_i0
        = new Kernel_b0_fir_27t_sym_hb_2i(sim, "ker_i0");
    map_DFGraph["gr_clipgraph"] -> addKernel(ker_i0);
    ker_i0 -> addInput(map_IConnector["wcon_i3_po0_i0_pi0"]);
    ker_i0 -> addOutput(map_IConnector["wcon_i0_po0_i0_po0"]);
    sim -> addNodeMetaData({ker_i0, "clipgraph.interpolator", -1, {
        {map_IConnector["wcon_i0_po0_i0_po0"], {"out[0]"}}
        , {map_IConnector["wcon_i3_po0_i0_pi0"], {"in[0]"}}
    }});

}

__attribute__ ((noinline)) static void create_ker_i1(ISimulator *sim, std::unordered_map<const char*, IConnector*> &map_IConnector, std::unordered_map<const char*, DFGraph*> &map_DFGraph)
{
    Kernel_b1_polar_clip *ker_i1
        = new Kernel_b1_polar_clip(sim, "ker_i1");
    map_DFGraph["gr_clipgraph"] -> addKernel(ker_i1);
    ker_i1 -> addInput(map_IConnector["scon_i1_pi0_i1_pi0"]);
    ker_i1 -> addOutput(map_IConnector["scon_i1_po0_i2_pi0"]);
    sim -> addNodeMetaData({ker_i1, "clipgraph.clip", -1, {
        {map_IConnector["scon_i1_pi0_i1_pi0"], {"in[0]"}}
        , {map_IConnector["scon_i1_po0_i2_pi0"], {"out[0]"}}
    }});

}

__attribute__ ((noinline)) static void create_ker_i2(ISimulator *sim, std::unordered_map<const char*, IConnector*> &map_IConnector, std::unordered_map<const char*, DFGraph*> &map_DFGraph)
{
    Kernel_b2_classifier *ker_i2
        = new Kernel_b2_classifier(sim, "ker_i2");
    map_DFGraph["gr_clipgraph"] -> addKernel(ker_i2);
    ker_i2 -> addInput(map_IConnector["scon_i1_po0_i2_pi0"]);
    ker_i2 -> addOutput(map_IConnector["wcon_i2_po0_i4_pi0"]);
    sim -> addNodeMetaData({ker_i2, "clipgraph.classify", -1, {
        {map_IConnector["scon_i1_po0_i2_pi0"], {"in[0]"}}
        , {map_IConnector["wcon_i2_po0_i4_pi0"], {"out[0]"}}
    }});

}

__attribute__ ((noinline)) static void createKernels(ISimulator *sim, std::unordered_map<const char*, IConnector*> &map_IConnector, std::unordered_map<const char*, DFGraph*> &map_DFGraph)
{
    create_ker_i0(sim, map_IConnector, map_DFGraph);
    create_ker_i1(sim, map_IConnector, map_DFGraph);
    create_ker_i2(sim, map_IConnector, map_DFGraph);
}

__attribute__ ((noinline)) static void createSharedBuffers(ISimulator *sim, std::unordered_map<const char*, ISharedBuffer*> &map_ISharedBuffer, std::unordered_map<const char*, IConnector*> &map_IConnector, std::unordered_map<const char*, DFGraph*> &map_DFGraph)
{
}

static std::variant<IBasicSimulator*, ISwemuSimulator*, IXmcSimulator*>
createSimulatorAux(ISimulator::Kind kind,
                   ISimulatorConfig const &simConfig,
                   ISimulator *&sim,
                   IBasicSimulator *&basicSim,
                   ISwemuSimulator *&swemuSim,
                   IXmcSimulator *&xmcSim)
{
    sim = nullptr;
    basicSim = nullptr;
    swemuSim = nullptr;
    xmcSim = nullptr;
    switch (kind) {
    case ISimulator::Kind::kBasic:
        basicSim = SimulatorFactory::basicSimulator(simConfig);
        sim = basicSim;
        return basicSim;
    case ISimulator::Kind::kSwemu:
        swemuSim = SimulatorFactory::swemuSimulator(simConfig);
        sim = swemuSim;
        return swemuSim;
    case ISimulator::Kind::kXmcGraph:
        xmcSim = SimulatorFactory::xmcGraphSimulator(simConfig);
        sim = xmcSim;
        return xmcSim;
    }
    return {};
}

static std::variant<IBasicSimulator*, ISwemuSimulator*, IXmcSimulator*>
createSimulator(ISimulator::Kind kind)
{
    std::unordered_map<const char*, IConnector*> map_IConnector;
    std::unordered_map<const char*, void*> map_void;
    std::unordered_map<const char*, DFGraph*> map_DFGraph;
    std::unordered_map<const char*, ISharedBuffer*> map_ISharedBuffer;
    std::unordered_map<std::string, std::string> map_snapBufToQualName;
    ISimulatorConfig simConfig = {};
    simConfig._enableProgress = true;
    simConfig._enableEventTrace = std::getenv("X86SIM_EVENT_TRACE_ON");
    simConfig._enableEventTracePrint = std::getenv("X86SIM_EVENT_TRACE_PRINT_ON");
    simConfig._enableSnapshots = std::getenv("X86SIM_SNAPSHOTS_ON");
    if (simConfig._snapshotSize == 0)
        if (auto val = std::getenv("X86SIM_SNAPSHOT_SIZE"))
            simConfig._snapshotSize = std::atoi(val);
    if (auto val = std::getenv("X86SIM_OUTPUT_TLAST"))
        simConfig._outputTlast = std::atoi(val);
    simConfig._simTimeout = 0;
    simConfig._plWaitTime = 0;
    simConfig._meKernelIters = 0;
    simConfig._isMultiLayerFlow = false;
    simConfig._aieArch = 10;
    simConfig._verbose = std::getenv("X86SIM_VERBOSE_ON");

    if (ISimulator::Kind::kBasic == kind)
    {
        auto simParams = createSimParams();
        simParams -> meKernelIters = -1 /* aiecompiler argument value */ ;
        if (!simParams -> populate())
            std::exit(EXIT_FAILURE);
        simConfig._simTimeout = simParams->simTimeout;
        simConfig._plWaitTime = simParams->plWaitTime;
        simConfig._meKernelIters = simParams->meKernelIters;
        simConfig._enableStopOnDeadlock = std::getenv("X86SIM_STOP_ON_DEADLOCK");
        simConfig._socketIO = false;
        if (auto env = std::getenv("PACKAGEDIR")) {
            simConfig._optionsFile = env + std::string("/options/x86sim.options");
            simConfig._pkgDir = env;
            simConfig._snapshotConfigFile = env + std::string("/options/x86sim_dump.config");
        }
    }
    if (ISimulator::Kind::kXmcGraph == kind)
    {
        if (auto env = std::getenv("PACKAGEDIR")) {
            simConfig._optionsFile = env + std::string("/options/x86sim.options");
            simConfig._pkgDir = env;
            simConfig._snapshotConfigFile = env + std::string("/options/x86sim_dump.config");
        }
    }
    if (ISimulator::Kind::kSwemu == kind)
    {
        simConfig._meKernelIters = -1;
        if (auto optionFilePath = std::getenv("X86SIM_OPTIONSPATH"))
            simConfig._optionsFile = optionFilePath ;
    }
    if (simConfig._simTimeout == 0)
        if (auto val = std::getenv("X86SIM_TIMEOUT"))
            simConfig._simTimeout = std::atoi(val);

    if (!(simConfig._optionsFile).empty())
        ISimulatorOptions::processFile(simConfig);

    if (simConfig._enableSnapshots) {
        addSnapshotMetaData(map_snapBufToQualName);
        ISnapshotConfig::processFile(simConfig, map_snapBufToQualName);
    }

    if (auto inputDir = std::getenv("INPUTDIR"))
        simConfig._inputDir = inputDir;
    if (auto outputDir = std::getenv("OUTPUTDIR"))
        simConfig._outputDir = outputDir;
    if ((simConfig._inputDir).empty())
        simConfig._inputDir = ".";
    if ((simConfig._outputDir).empty())
        simConfig._outputDir = "./x86simulator_output";

    IBasicSimulator *basicSim = nullptr;
    ISwemuSimulator *swemuSim = nullptr;
    IXmcSimulator *xmcSim = nullptr;
    ISimulator *sim = nullptr;
    std::variant<IBasicSimulator*, ISwemuSimulator*, IXmcSimulator*> result 
        = createSimulatorAux(kind, simConfig, sim, basicSim, swemuSim, xmcSim);
    createMallocs(sim,map_void);
    createConnectors(sim,xmcSim,map_IConnector,map_void);
    {
        INode *winbrdcst_i0_po0
             = NodeFactory::windowBroadcaster(sim, "winbrdcst_i0_po0", static_cast<IWindowConnector*>(map_IConnector["wcon_i0_po0_i0_po0"]));
        winbrdcst_i0_po0 -> addOutput(map_IConnector["scon_i1_pi0_i1_pi0"]);

    }
    // Graph configs
    // {id, name, test-iterations, x86SimPtr}
    DFGraph *gr_clipgraph = new DFGraph(sim);
    sim->addGraphConfig({ 0, "clipgraph", -1, gr_clipgraph});
    map_DFGraph["gr_clipgraph"] = gr_clipgraph;
    createKernels(sim, map_IConnector, map_DFGraph);
    createSharedBuffers(sim, map_ISharedBuffer, map_IConnector, map_DFGraph);
    if ( !xmcSim)
    {
    }
    if (basicSim)
    {
        INode *platformIn_i3
            = NodeFactory::fileReader
            (sim, "platformIn_i3",
            simConfig._inputDir + "/data/input.txt", 
            false, CINT16, 4, false);
        platformIn_i3 -> addOutput(map_IConnector["wcon_i3_po0_i0_pi0"]);

        INode *platformOut_i4
            = NodeFactory::fileWriter
            (sim, "platformOut_i4",
            simConfig._outputDir + "/data/output.txt", 
            false, INT32, 4, false);
        platformOut_i4 -> addInput(map_IConnector["wcon_i2_po0_i4_pi0"]);


        auto configs = basicSim->getConfig();
        adf::initializeX86SimConfigurations(
            std::get<0>(configs),
            std::get<1>(configs),
            std::get<2>(configs),
            std::get<3>(configs),
            std::get<4>(configs),
            std::get<5>(configs),
            std::get<6>(configs),
            std::get<7>(configs),
            std::get<8>(configs),
            std::get<9>(configs),
            std::get<10>(configs),
            std::get<11>(configs));
    }
    if (swemuSim)
    {
        IPlatformStreamNode *platformIn_i3
            = NodeFactory::streamReader(sim, "platformIn_i3", false);
        swemuSim->registerHlsStreamNode(platformIn_i3, "DataIn1");
        platformIn_i3 -> addOutput(map_IConnector["wcon_i3_po0_i0_pi0"]);

        IPlatformStreamNode *platformOut_i4
            = NodeFactory::streamWriter(sim, "platformOut_i4", false);
        swemuSim->registerHlsStreamNode(platformOut_i4, "DataOut1");
        platformOut_i4 -> addInput(map_IConnector["wcon_i2_po0_i4_pi0"]);

        swemuSim->registerStreamHelperMakeFunc(StreamHelperBase::make);
    }
    if (xmcSim)
    {
        IPlatformBuffer * bufplatformIn_i3
            = PlatformBufferFactory::inputBuffer(sim, "bufplatformIn_i3", 32768);
        INode *platformIn_i3
            = NodeFactory::bufferReader(sim, "platformIn_i3", bufplatformIn_i3, 4, 4);
        platformIn_i3 -> addOutput(map_IConnector["wcon_i3_po0_i0_pi0"]);

        IPlatformBuffer * bufplatformOut_i4
            = PlatformBufferFactory::outputBuffer(sim, "bufplatformOut_i4", 32768);
        INode *platformOut_i4
            = NodeFactory::bufferWriter(sim, "platformOut_i4", bufplatformOut_i4, 4, 4);
        platformOut_i4 -> addInput(map_IConnector["wcon_i2_po0_i4_pi0"]);

    }
    if ( !xmcSim)
    {
        sim->start();
    }
    return result;
}

void *createBasicSimulatorInstance()
{
    static auto  g_sim = std::unique_ptr<IBasicSimulator>
        (std::get<IBasicSimulator*>(createSimulator(ISimulator::Kind::kBasic)));
    return g_sim.get();
}

void *createSwemuSimulatorInstance()
{
    static auto  g_sim = std::unique_ptr<ISwemuSimulator>
        (std::get<ISwemuSimulator*>(createSimulator(ISimulator::Kind::kSwemu)));
    return g_sim.get();
}

void *createXmcSimulator()
{
    return std::get<IXmcSimulator*>
        (createSimulator(ISimulator::Kind::kXmcGraph));
}

void addSnapshotMetaData(std::unordered_map<std::string, std::string> &map_snapBufToQualName)
{
    map_snapBufToQualName["wcon_i2_po0_i4_pi0_r"] = "clipgraph.out.in[0]";
    map_snapBufToQualName["wcon_i2_po0_i4_pi0_w"] = "clipgraph.classify.out[0]";
    map_snapBufToQualName["scon_i1_po0_i2_pi0_r"] = "clipgraph.classify.in[0]";
    map_snapBufToQualName["scon_i1_pi0_i1_pi0_r"] = "clipgraph.clip.in[0]";
    map_snapBufToQualName["wcon_i0_po0_i0_po0_w"] = "clipgraph.interpolator.out[0]";
    map_snapBufToQualName["scon_i1_po0_i2_pi0_w"] = "clipgraph.clip.out[0]";
    map_snapBufToQualName["wcon_i3_po0_i0_pi0_r"] = "clipgraph.interpolator.in[0]";
    map_snapBufToQualName["wcon_i3_po0_i0_pi0_w"] = "clipgraph.in.out[0]";
}

}  //end of x86Sim namespace


#include "adf/x86sim/symbolVisibility.h"
#include "adf/x86sim/x86simSwemuIfc.hpp"

