// ==============================================================
// Generated by Vitis HLS v2025.1
// Copyright 1986-2022 Xilinx, Inc. All Rights Reserved.
// Copyright 2022-2025 Advanced Micro Devices, Inc. All Rights Reserved.
// ==============================================================
`timescale 1ns/1ps
`default_nettype none

module mm2s_gmem_m_axi
#(parameter
    C_M_AXI_ID_WIDTH          = 1,
    C_M_AXI_ADDR_WIDTH        = 32,
    C_M_AXI_DATA_WIDTH        = 32, // power of 2 & range: 2 to 1024
    C_M_AXI_AWUSER_WIDTH      = 1,
    C_M_AXI_ARUSER_WIDTH      = 1,
    C_M_AXI_WUSER_WIDTH       = 1,
    C_M_AXI_RUSER_WIDTH       = 1,
    C_M_AXI_BUSER_WIDTH       = 1,
    C_TARGET_ADDR             = 32'h00000000,
    C_USER_VALUE              = 1'b0,
    C_PROT_VALUE              = 3'b000,
    C_CACHE_VALUE             = 4'b0011,
    CONSERVATIVE              = 0,
    MAX_READ_BURST_LENGTH     = 16,
    MAX_WRITE_BURST_LENGTH    = 16,
    NUM_READ_OUTSTANDING      = 16, // global read outstanding value
    NUM_WRITE_OUTSTANDING     = 16, // global write outstanding value
    USER_MAXREQS              = 16,
    USER_LEN_WIDTH            = 32,
    // channel configurations
    CH0_USER_DW               = 32,
    CH0_USER_AW               = 32,
    CH0_NUM_READ_OUTSTANDING  = 2,
    CH0_NUM_WRITE_OUTSTANDING = 2,
    CH0_USER_RFIFONUM_WIDTH   = 6,
    MAXI_BUFFER_IMPL          = "block"
)(
    // system signal
    input  wire                               ACLK,
    input  wire                               ARESET,
    input  wire                               ACLK_EN,
    // write address channel
    output wire [C_M_AXI_ID_WIDTH-1:0]        AWID,
    output wire [C_M_AXI_ADDR_WIDTH-1:0]      AWADDR,
    output wire [7:0]                         AWLEN,
    output wire [2:0]                         AWSIZE,
    output wire [1:0]                         AWBURST,
    output wire [1:0]                         AWLOCK,
    output wire [3:0]                         AWCACHE,
    output wire [2:0]                         AWPROT,
    output wire [3:0]                         AWQOS,
    output wire [3:0]                         AWREGION,
    output wire [C_M_AXI_AWUSER_WIDTH-1:0]    AWUSER,
    output wire                               AWVALID,
    input  wire                               AWREADY,
    // write data channel
    output wire [C_M_AXI_ID_WIDTH-1:0]        WID,
    output wire [C_M_AXI_DATA_WIDTH-1:0]      WDATA,
    output wire [C_M_AXI_DATA_WIDTH/8-1:0]    WSTRB,
    output wire                               WLAST,
    output wire [C_M_AXI_WUSER_WIDTH-1:0]     WUSER,
    output wire                               WVALID,
    input  wire                               WREADY,
    // write response channel
    input  wire [C_M_AXI_ID_WIDTH-1:0]        BID,
    input  wire [1:0]                         BRESP,
    input  wire [C_M_AXI_BUSER_WIDTH-1:0]     BUSER,
    input  wire                               BVALID,
    output wire                               BREADY,
    // read address channel
    output wire [C_M_AXI_ID_WIDTH-1:0]        ARID,
    output wire [C_M_AXI_ADDR_WIDTH-1:0]      ARADDR,
    output wire [7:0]                         ARLEN,
    output wire [2:0]                         ARSIZE,
    output wire [1:0]                         ARBURST,
    output wire [1:0]                         ARLOCK,
    output wire [3:0]                         ARCACHE,
    output wire [2:0]                         ARPROT,
    output wire [3:0]                         ARQOS,
    output wire [3:0]                         ARREGION,
    output wire [C_M_AXI_ARUSER_WIDTH-1:0]    ARUSER,
    output wire                               ARVALID,
    input  wire                               ARREADY,
    // read data channel
    input  wire [C_M_AXI_ID_WIDTH-1:0]        RID,
    input  wire [C_M_AXI_DATA_WIDTH-1:0]      RDATA,
    input  wire [1:0]                         RRESP,
    input  wire                               RLAST,
    input  wire [C_M_AXI_RUSER_WIDTH-1:0]     RUSER,
    input  wire                               RVALID,
    output wire                               RREADY,
    // multiple internal channels 
    // channel 0 --  READ-ONLY 
    input  wire [CH0_USER_AW-1:0]             I_CH0_AWADDR,
    input  wire [USER_LEN_WIDTH-1:0]          I_CH0_AWLEN,
    input  wire                               I_CH0_AWVALID,
    output wire                               I_CH0_AWREADY,
    input  wire [CH0_USER_DW-1:0]             I_CH0_WDATA,
    input  wire [CH0_USER_DW/8-1:0]           I_CH0_WSTRB,
    input  wire                               I_CH0_WVALID,
    output wire                               I_CH0_WREADY,
    output wire                               I_CH0_BVALID,
    input  wire                               I_CH0_BREADY,
    input  wire [CH0_USER_AW-1:0]             I_CH0_ARADDR,
    input  wire [USER_LEN_WIDTH-1:0]          I_CH0_ARLEN,
    input  wire                               I_CH0_ARVALID,
    output wire                               I_CH0_ARREADY,
    output wire [CH0_USER_DW-1:0]             I_CH0_RDATA,
    output wire                               I_CH0_RVALID,
    input  wire                               I_CH0_RREADY,
    output wire [CH0_USER_RFIFONUM_WIDTH-1:0] I_CH0_RFIFONUM
    );
//------------------------Parameter----------------------
    localparam
        NUM_READ_PORTS  = 1,
        NUM_WRITE_PORTS = 0;

//------------------------Local signal-------------------
    // AW/W/B channel signals 

    // AR/R channel signals 
    wire [C_M_AXI_ADDR_WIDTH-1:0]   local_CHN_ARADDR  [0 : NUM_READ_PORTS-1];
    wire [USER_LEN_WIDTH-1:0]       local_CHN_ARLEN   [0 : NUM_READ_PORTS-1];
    wire [NUM_READ_PORTS-1:0]       local_CHN_ARVALID;
    wire [NUM_READ_PORTS-1:0]       local_CHN_ARREADY;
    wire [C_M_AXI_DATA_WIDTH-1:0]   local_CHN_RDATA;
    wire [1:0]                      local_CHN_RLAST;
    wire [NUM_READ_PORTS-1:0]       local_CHN_RVALID;
    wire [NUM_READ_PORTS-1:0]       local_CHN_RREADY;

    wire [C_M_AXI_ID_WIDTH-1:0]     local_AXI_ARID;
    wire [C_M_AXI_ADDR_WIDTH-1:0]   local_AXI_ARADDR;
    wire [USER_LEN_WIDTH-1:0]       local_AXI_ARLEN;
    wire                            local_AXI_ARVALID;
    wire [C_M_AXI_ID_WIDTH-1:0]     local_AXI_RID;
    wire [C_M_AXI_DATA_WIDTH-1:0]   local_AXI_RDATA;
    wire [1:0]                      local_AXI_RLAST;

    wire [NUM_READ_PORTS-1:0]       local_AXI_ARREADY;
    wire [NUM_READ_PORTS-1:0]       local_AXI_RVALID;
    wire [NUM_READ_PORTS-1:0]       local_AXI_RREADY;
    wire [NUM_READ_PORTS-1:0]       local_BURST_RREADY;

    // flush logic 

    // AXI Ports Initialization 
    assign AWID     = {C_M_AXI_ID_WIDTH{1'b0}};
    assign AWADDR   = {C_M_AXI_ADDR_WIDTH{1'b0}};
    assign AWLEN    = 8'd0;
    assign AWSIZE   = 3'd0;
    assign AWBURST  = 2'd0;
    assign AWLOCK   = 2'd0;
    assign AWCACHE  = 4'd0;
    assign AWPROT   = 3'd0;
    assign AWQOS    = 4'd0;
    assign AWREGION = 4'd0;
    assign AWUSER   = {C_M_AXI_AWUSER_WIDTH{1'b0}};
    assign AWVALID  = 1'b0;
    assign WID      = {C_M_AXI_ID_WIDTH{1'b0}};
    assign WDATA    = {C_M_AXI_DATA_WIDTH{1'b0}};
    assign WSTRB    = {C_M_AXI_DATA_WIDTH/8{1'b0}};
    assign WLAST    = 1'b0;
    assign WUSER    = {C_M_AXI_WUSER_WIDTH{1'b0}};
    assign WVALID   = 1'b0;
    assign BREADY   = 1'b0;
    
    // Kernel Ports Initialization 
    assign I_CH0_AWREADY    = 1'b0;
    assign I_CH0_WREADY     = 1'b0;
    assign I_CH0_BVALID     = 1'b0;
    
    // Internal Ports Mapping
    assign local_AXI_ARID      = {C_M_AXI_ID_WIDTH{1'b0}};
    assign local_AXI_ARVALID   = local_CHN_ARVALID[0];
    assign local_CHN_ARREADY   = local_AXI_ARREADY;
    assign local_AXI_ARADDR    = local_CHN_ARADDR[local_AXI_ARID];
    assign local_AXI_ARLEN     = local_CHN_ARLEN[local_AXI_ARID];
    assign local_AXI_RREADY    = local_CHN_RREADY;
    assign local_CHN_RDATA     = local_AXI_RDATA;
    assign local_CHN_RLAST     = local_AXI_RLAST;
    assign local_CHN_RVALID    = local_AXI_RVALID;

    // flush logic
//------------------------Instantiation------------------
    // ================== STORE UNITS ================== 

    // ================== LOAD UNITS ================== 
    // load_unit for channel 0
    mm2s_gmem_m_axi_load #(
        .C_TARGET_ADDR          ( C_TARGET_ADDR ),
        .NUM_READ_OUTSTANDING   ( CH0_NUM_READ_OUTSTANDING ),
        .MAX_READ_BURST_LENGTH  ( MAX_READ_BURST_LENGTH ),
        .BUS_ADDR_WIDTH         ( C_M_AXI_ADDR_WIDTH ),
        .BUS_DATA_WIDTH         ( C_M_AXI_DATA_WIDTH ),
        .USER_DW                ( CH0_USER_DW ),
        .USER_AW                ( CH0_USER_AW ),
        .USER_LEN_WIDTH         ( USER_LEN_WIDTH ),
        .USER_MAXREQS           ( USER_MAXREQS ),
        .USER_RFIFONUM_WIDTH    ( CH0_USER_RFIFONUM_WIDTH ),
        .BUFFER_IMPL            ( MAXI_BUFFER_IMPL )
    ) load_unit_0 (
        .ACLK                   ( ACLK ),
        .ARESET                 ( ARESET ),
        .ACLK_EN                ( ACLK_EN ),
        .out_AXI_ARADDR         ( local_CHN_ARADDR[0]  ),
        .out_AXI_ARLEN          ( local_CHN_ARLEN[0]   ),
        .out_AXI_ARVALID        ( local_CHN_ARVALID[0] ),
        .in_AXI_ARREADY         ( local_CHN_ARREADY[0] ),
        .in_AXI_RDATA           ( local_CHN_RDATA  ),
        .in_AXI_RLAST           ( local_CHN_RLAST  ),
        .in_AXI_RVALID          ( local_CHN_RVALID[0] ),
        .out_AXI_RREADY         ( local_CHN_RREADY[0] ),
        .out_BURST_RREADY       ( local_BURST_RREADY[0] ),
        .in_HLS_ARADDR          ( I_CH0_ARADDR   ),
        .in_HLS_ARLEN           ( I_CH0_ARLEN    ),
        .in_HLS_ARVALID         ( I_CH0_ARVALID  ),
        .out_HLS_ARREADY        ( I_CH0_ARREADY  ),
        .out_HLS_RDATA          ( I_CH0_RDATA    ),
        .out_HLS_RVALID         ( I_CH0_RVALID   ),
        .in_HLS_RREADY          ( I_CH0_RREADY   ),
        .out_HLS_RFIFONUM       ( I_CH0_RFIFONUM ));

    
    // ================== AXI BUS READ/WRITE ==================
    // mm2s_gmem_m_axi_write 
    
    // mm2s_gmem_m_axi_read 
    mm2s_gmem_m_axi_read #(
        .C_M_AXI_ID_WIDTH       ( C_M_AXI_ID_WIDTH ),
        .C_M_AXI_ARUSER_WIDTH   ( C_M_AXI_ARUSER_WIDTH ),
        .C_M_AXI_RUSER_WIDTH    ( C_M_AXI_RUSER_WIDTH ),
        .C_USER_VALUE           ( C_USER_VALUE ),
        .C_PROT_VALUE           ( C_PROT_VALUE ),
        .C_CACHE_VALUE          ( C_CACHE_VALUE ),
        .BUS_ADDR_WIDTH         ( C_M_AXI_ADDR_WIDTH ),
        .BUS_DATA_WIDTH         ( C_M_AXI_DATA_WIDTH ),
        .USER_LEN_WIDTH         ( USER_LEN_WIDTH ),
        .MAX_READ_BURST_LENGTH  ( MAX_READ_BURST_LENGTH ),
        .NUM_READ_OUTSTANDING   ( NUM_READ_OUTSTANDING ),
        // outstanding control for channels
        .ID0_NUM_READ_OUTSTANDING     ( CH0_NUM_READ_OUTSTANDING ), 
        .NUM_READ_PORTS         ( NUM_READ_PORTS )
    ) bus_read (
        .ACLK                   ( ACLK ),
        .ARESET                 ( ARESET ),
        .ACLK_EN                ( ACLK_EN ),
        .out_BUS_ARID           ( ARID ),
        .out_BUS_ARADDR         ( ARADDR ),
        .out_BUS_ARLEN          ( ARLEN ),
        .out_BUS_ARSIZE         ( ARSIZE ),
        .out_BUS_ARBURST        ( ARBURST ),
        .out_BUS_ARLOCK         ( ARLOCK ),
        .out_BUS_ARCACHE        ( ARCACHE ),
        .out_BUS_ARPROT         ( ARPROT ),
        .out_BUS_ARQOS          ( ARQOS ),
        .out_BUS_ARREGION       ( ARREGION ),
        .out_BUS_ARUSER         ( ARUSER ),
        .out_BUS_ARVALID        ( ARVALID ),
        .in_BUS_ARREADY         ( ARREADY ),
        .in_BUS_RID             ( RID ),
        .in_BUS_RDATA           ( RDATA ),
        .in_BUS_RRESP           ( RRESP ),
        .in_BUS_RLAST           ( RLAST ),
        .in_BUS_RUSER           ( RUSER ),
        .in_BUS_RVALID          ( RVALID ),
        .out_BUS_RREADY         ( RREADY ),
        .in_AXI_ARID            ( local_AXI_ARID),
        .in_AXI_ARVALID         ( local_AXI_ARVALID ),
        .out_AXI_ARREADY        ( local_AXI_ARREADY ),
        .in_AXI_ARADDR          ( local_AXI_ARADDR ),
        .in_AXI_ARLEN           ( local_AXI_ARLEN ),
        .out_AXI_RVALID         ( local_AXI_RVALID ),
        .in_AXI_RREADY          ( local_AXI_RREADY ),
        .out_AXI_RDATA          ( local_AXI_RDATA ),
        .out_AXI_RLAST          ( local_AXI_RLAST ),
        .in_BURST_RREADY        ( local_BURST_RREADY )
    );


endmodule
`default_nettype wire
// 67d7842dbbe25473c3c32b93c0da8047785f30d78e8a024de1b57352245f9689
`timescale 1ns/1ps
module mm2s_gmem_m_axi_load
#(parameter
    C_TARGET_ADDR                         = 32'h00000000,
    NUM_READ_OUTSTANDING                  = 2,
    MAX_READ_BURST_LENGTH                 = 16,
    BUS_ADDR_WIDTH                        = 32,
    BUS_DATA_WIDTH                        = 32,
    USER_DW                               = 32,
    USER_AW                               = 32,
    USER_LEN_WIDTH                        = 32,
    USER_MAXREQS                          = 16,
    USER_RFIFONUM_WIDTH                   = 6,
    BUFFER_IMPL                           = "auto"
)(
    // system signal
    input  wire                           ACLK,
    input  wire                           ARESET,
    input  wire                           ACLK_EN,
    // read address channel
    output wire [BUS_ADDR_WIDTH-1:0]      out_AXI_ARADDR,
    output wire [USER_LEN_WIDTH-1:0]      out_AXI_ARLEN,
    output wire                           out_AXI_ARVALID,
    input  wire                           in_AXI_ARREADY,
    // read data channel
    input  wire [BUS_DATA_WIDTH-1:0]      in_AXI_RDATA,
    input  wire [1:0]                     in_AXI_RLAST,
    input  wire                           in_AXI_RVALID,
    output wire                           out_AXI_RREADY,
    output wire                           out_BURST_RREADY,
    // read address
    input  wire [USER_AW-1:0]             in_HLS_ARADDR,
    input  wire [USER_LEN_WIDTH-1:0]      in_HLS_ARLEN,
    input  wire                           in_HLS_ARVALID,
    output wire                           out_HLS_ARREADY,
    // read data
    output wire [USER_DW-1:0]             out_HLS_RDATA,
    output wire                           out_HLS_RVALID,
    input  wire                           in_HLS_RREADY,
    output wire [USER_RFIFONUM_WIDTH-1:0] out_HLS_RFIFONUM
);

//------------------------Parameter----------------------
    localparam
        USER_DATA_WIDTH = calc_data_width(USER_DW),
        USER_DATA_ALIGN = USER_DATA_WIDTH,
        USER_ADDR_ALIGN = log2(USER_DATA_WIDTH/8),
        RREQ_PACK_WIDTH = USER_AW + USER_LEN_WIDTH,
        BUS_ADDR_ALIGN  = log2(BUS_DATA_WIDTH/8),
        // rdata buffer size 
        RBUFF_DEPTH     = NUM_READ_OUTSTANDING * MAX_READ_BURST_LENGTH,
        PREFERRED_IMPL  = (RBUFF_DEPTH <= 32) ? "shiftreg" : BUFFER_IMPL,
        TARGET_ADDR     = C_TARGET_ADDR & (32'hffffffff << USER_ADDR_ALIGN);

//------------------------Task and function--------------
    function integer calc_data_width;
        input integer x;
        integer y;
    begin
        y = 8;
        while (y < x) y = y * 2;
        calc_data_width = y;
    end
    endfunction

    function integer log2;
        input integer x;
        integer n, m;
    begin
        n = 0;
        m = 1;
        while (m < x) begin
            n = n + 1;
            m = m * 2;
        end
        log2 = n;
    end
    endfunction

//------------------------Local signal-------------------
    wire                           next_rreq;
    wire                           ready_for_rreq;
    wire                           rreq_ready;
    wire                           rreq_valid;
    wire                           valid_length;

    wire [USER_AW-1:0]             rreq_addr;
    wire [USER_LEN_WIDTH-1:0]      rreq_len;
    reg  [BUS_ADDR_WIDTH-1:0]      tmp_addr;
    reg  [USER_LEN_WIDTH-1:0]      tmp_len;
    reg                            tmp_valid;

    wire [BUS_DATA_WIDTH-1:0]      local_AXI_RDATA;
    wire [1:0]                     local_AXI_RLAST;
    wire                           local_AXI_RVALID;
    wire                           local_AXI_RREADY;
    wire [log2(RBUFF_DEPTH):0]     local_AXI_RFIFONUM;
    reg                            ready_for_outstanding;

    wire [RREQ_PACK_WIDTH-1:0]     in_rreq_pack;
    wire [RREQ_PACK_WIDTH-1:0]     out_rreq_pack;
    // regslice io ?  no 
    // enable regslice on R channel  no 
//------------------------Instantiation------------------
    // AR channel regslice 

    // AR channel fifo
    mm2s_gmem_m_axi_fifo #(
        .DATA_WIDTH        (RREQ_PACK_WIDTH),
        .ADDR_WIDTH        (log2(USER_MAXREQS)),
        .DEPTH             (USER_MAXREQS)
    ) fifo_rreq (
        .clk               (ACLK),
        .reset             (ARESET),
        .clk_en            (ACLK_EN),
        .if_full_n         (out_HLS_ARREADY),
        .if_write          (in_HLS_ARVALID),
        .if_din            (in_rreq_pack),
        .if_empty_n        (rreq_valid),
        .if_read           (next_rreq),
        .if_dout           (out_rreq_pack),
        .if_num_data_valid ());
    // ===================================================================
    // start of ARADDR PREPROCESSOR
    assign in_rreq_pack    = {in_HLS_ARLEN, in_HLS_ARADDR};
    assign {rreq_len, rreq_addr} = out_rreq_pack;
    
    assign next_rreq       = rreq_valid && ready_for_rreq;
    assign ready_for_rreq  = ~tmp_valid || (in_AXI_ARREADY && rreq_ready);
    assign valid_length    = (rreq_len != 0) && !rreq_len[USER_LEN_WIDTH-1];

    assign out_AXI_ARLEN   = tmp_len;   // Byte length
    assign out_AXI_ARADDR  = tmp_addr;  // Byte address
    assign out_AXI_ARVALID = tmp_valid && rreq_ready;

    always @(posedge ACLK)
    begin
        if (ARESET) begin
            tmp_len  <= 0;
            tmp_addr <= 0;
        end
        else if (ACLK_EN) begin
            if(next_rreq) begin
                tmp_len  <= (rreq_len << USER_ADDR_ALIGN) - 1;            // byte length
                tmp_addr <= TARGET_ADDR + (rreq_addr << USER_ADDR_ALIGN); // byte address
            end
        end
    end
 
    always @(posedge ACLK) 
    begin
        if (ARESET)
            tmp_valid <= 1'b0;
        else if (ACLK_EN) begin
            if (next_rreq && valid_length)
                tmp_valid <= 1'b1;
            else if (in_AXI_ARREADY && rreq_ready)
                tmp_valid <= 1'b0;
        end
    end
    // end of ARADDR PREPROCESSOR
    // ===================================================================

    // R channel regslice 

    // R channel fifo
    mm2s_gmem_m_axi_fifo #(
        .MEM_STYLE         (PREFERRED_IMPL),
        .DATA_WIDTH        (BUS_DATA_WIDTH + 2),
        .ADDR_WIDTH        (log2(RBUFF_DEPTH)),
        .DEPTH             (RBUFF_DEPTH)
    ) buff_rdata (
        .clk               (ACLK),
        .reset             (ARESET),
        .clk_en            (ACLK_EN),
        .if_full_n         (out_AXI_RREADY),
        .if_write          (in_AXI_RVALID),
        .if_din            ({in_AXI_RLAST, in_AXI_RDATA}),
        .if_empty_n        (local_AXI_RVALID),
        .if_read           (local_AXI_RREADY),
        .if_dout           ({local_AXI_RLAST, local_AXI_RDATA}),
        .if_num_data_valid (local_AXI_RFIFONUM));

    // Outstanding control
    assign out_BURST_RREADY = ready_for_outstanding;
    always @(posedge ACLK) 
    begin
        if (ARESET)
            ready_for_outstanding <= 1'b0;
        else if (ACLK_EN) begin
            if (local_AXI_RREADY && local_AXI_RVALID)
                ready_for_outstanding <= local_AXI_RLAST[1];
            else
                ready_for_outstanding <= 1'b0;
        end
    end

    // ===================================================================
    // start of RDATA PREPROCESSOR
    generate
    if (USER_DATA_ALIGN == BUS_DATA_WIDTH) begin :  bus_equal_gen 

        assign rreq_ready       = 1'b1;
        // R channel regslice  disabled
        assign out_HLS_RDATA    = local_AXI_RDATA[USER_DW-1:0];
        assign out_HLS_RVALID   = local_AXI_RVALID;
        assign out_HLS_RFIFONUM = local_AXI_RFIFONUM; 
        assign local_AXI_RREADY = in_HLS_RREADY;
    end
    else if (USER_DATA_ALIGN < BUS_DATA_WIDTH) begin : bus_wide_gen

        localparam
            TOTAL_SPLIT  = BUS_DATA_WIDTH / USER_DATA_ALIGN,
            SPLIT_ALIGN  = log2(TOTAL_SPLIT);

        wire [BUS_ADDR_ALIGN-1:0]   tmp_addr_end;
        wire                        offset_full_n;
        wire                        offset_write;
        wire                        offset_valid;
        wire                        next_offset;

        wire [SPLIT_ALIGN-1:0]      start_offset;
        wire [SPLIT_ALIGN-1:0]      end_offset;
        wire [SPLIT_ALIGN-1:0]      head_offset;
        wire [SPLIT_ALIGN-1:0]      tail_offset;

        wire                        first_data;
        reg                         first_data_pred;
        wire                        last_data;
        wire                        ready_for_data;
    
        wire [BUS_DATA_WIDTH-1:0]   rdata_data;
        wire                        rdata_last;
        wire                        rdata_valid;
        wire                        next_rdata;

        reg  [BUS_DATA_WIDTH-1:0]   data_buf;
        reg                         data_valid;

        reg  [USER_RFIFONUM_WIDTH-1:0] rdata_nvalid; 
        reg  [SPLIT_ALIGN:0]        data_nvalid;
        wire [SPLIT_ALIGN:0]        split_nvalid;

        wire [SPLIT_ALIGN-1:0]      split_cnt_end;
        wire [SPLIT_ALIGN-1:0]      split_cnt;
        reg  [SPLIT_ALIGN-1:0]      split_cnt_buf;

        wire                        first_split;
        reg                         first_split_pred;
        wire                        next_split;
        wire                        last_split;
        wire                        split_valid;

        // Recording the offset of start & end address to extract the expect data from beats when USER_DW < BUS_DW.
        mm2s_gmem_m_axi_fifo #(
            .DATA_WIDTH         (2*SPLIT_ALIGN),
            .ADDR_WIDTH         (log2(NUM_READ_OUTSTANDING)),
            .DEPTH              (NUM_READ_OUTSTANDING)
        ) rreq_offset (
            .clk                (ACLK),
            .reset              (ARESET),
            .clk_en             (ACLK_EN),
            .if_full_n          (offset_full_n),
            .if_write           (offset_write),
            .if_din             ({start_offset, end_offset}),
            .if_empty_n         (offset_valid),
            .if_read            (next_offset),
            .if_dout            ({head_offset, tail_offset}),
            .if_num_data_valid  ());

        mm2s_gmem_m_axi_reg_slice #(
            .DATA_WIDTH         (BUS_DATA_WIDTH + 1)
        ) rs_rdata_int (
            .clk                (ACLK),
            .reset              (ARESET),
            .s_data             ({local_AXI_RLAST[0], local_AXI_RDATA}),
            .s_valid            (local_AXI_RVALID),
            .s_ready            (local_AXI_RREADY),
            .m_data             ({rdata_last, rdata_data}),
            .m_valid            (rdata_valid),
            .m_ready            (next_rdata));

        assign rreq_ready       = offset_full_n | ~offset_write;
        assign tmp_addr_end     = tmp_addr[BUS_ADDR_ALIGN-1:0] + tmp_len[BUS_ADDR_ALIGN-1:0];
        assign start_offset     = tmp_addr[BUS_ADDR_ALIGN-1:0] >> USER_ADDR_ALIGN;
        assign end_offset       = tmp_addr_end[BUS_ADDR_ALIGN-1:0] >> USER_ADDR_ALIGN;
        assign offset_write     = tmp_valid & in_AXI_ARREADY;
        assign next_offset      = rdata_last & next_rdata;

        // regslice io ?  no
        assign out_HLS_RDATA    = data_buf[USER_DW-1:0];
        assign out_HLS_RVALID   = data_valid;
        assign out_HLS_RFIFONUM = rdata_nvalid + data_nvalid;
        assign ready_for_data   = ~data_valid | in_HLS_RREADY; 
        assign next_rdata       = rdata_valid && last_split;
        assign first_data       = first_data_pred && split_valid;
        assign last_data        = rdata_last && split_valid;

        assign split_valid      = rdata_valid && offset_valid;
        assign next_split       = split_valid && ready_for_data;
        assign first_split      = first_split_pred && next_split;
        assign last_split       = (split_cnt == split_cnt_end) && next_split;
        assign split_cnt        = (first_data && first_split_pred) ? head_offset : split_cnt_buf;
        assign split_cnt_end    = (~last_data) ? (TOTAL_SPLIT - 1) : tail_offset;

        assign split_nvalid     = (first_data && last_data)  ? tail_offset - head_offset + 1 :
                                   first_data                ? TOTAL_SPLIT - head_offset     :
                                   last_data                 ? tail_offset + 1               :
                                   TOTAL_SPLIT;
        always @(posedge ACLK)
        begin
            if (ARESET) begin
                split_cnt_buf <= 0;
                first_split_pred <= 1'b1;
            end
            else if (ACLK_EN) begin
                if (last_split) begin
                    split_cnt_buf <= 0;
                    first_split_pred <= 1'b1;
                end
                else if (next_split) begin
                    split_cnt_buf <= split_cnt + 1;
                    first_split_pred <= 1'b0;
                end
            end
        end

        always @(posedge ACLK)
        begin
            if (ARESET)
                first_data_pred <= 1'b1;
            else if (ACLK_EN) begin
                if (next_offset)
                    first_data_pred <= 1'b1;
                else if (last_split)
                    first_data_pred <= 1'b0;
            end
        end

        always @(posedge ACLK)
        begin
            if (ACLK_EN) begin
                if (first_split & first_data)
                    data_buf <= rdata_data >> (head_offset * USER_DATA_ALIGN);
                else if (first_split)
                    data_buf <= rdata_data;
                else if (next_split)
                    data_buf <= data_buf >> USER_DATA_ALIGN;
            end
        end

        always @(posedge ACLK)
        begin
            if (ARESET)
                data_valid <= 1'b0;
            else if (ACLK_EN) begin
                if (next_split)
                    data_valid <= 1'b1;
                else if (ready_for_data)
                    data_valid <= 1'b0;
            end
        end

        always @(posedge ACLK)
        begin
            if (ARESET)
                data_nvalid <= 0;
            else if (ACLK_EN) begin
                if (first_split)
                    data_nvalid <= split_nvalid;
                else if (next_split)
                    data_nvalid <= data_nvalid - 1;
                else if (ready_for_data)
                    data_nvalid <= 0;
            end
        end

        always @(posedge ACLK)
        begin
            if (ARESET)
                rdata_nvalid <= 0;
            else if (ACLK_EN) begin
                if (~rdata_valid)
                    rdata_nvalid <= 0;
                else if (~local_AXI_RREADY)
                    rdata_nvalid <= ((local_AXI_RFIFONUM + 1) << SPLIT_ALIGN);
                else
                    rdata_nvalid <= (local_AXI_RFIFONUM << SPLIT_ALIGN);
            end
        end
        
    end
    else begin : bus_narrow_gen
        localparam
            TOTAL_PADS      = USER_DATA_ALIGN / BUS_DATA_WIDTH,
            PAD_ALIGN       = log2(TOTAL_PADS);

        reg  [USER_DATA_WIDTH-1:0]  data_buf;
        reg                         data_valid;
        reg  [PAD_ALIGN:0]          data_nvalid;
        wire                        ready_for_data;
        wire [USER_RFIFONUM_WIDTH-1:0] rdata_num_vld;

        wire [TOTAL_PADS-1:0]       pad_oh;
        reg  [TOTAL_PADS-1:0]       pad_oh_reg;

        reg                         first_pad;
        wire                        last_pad;
        wire                        next_pad;

        assign rreq_ready       = 1'b1; 
        assign local_AXI_RREADY = next_pad;
        assign rdata_num_vld    = local_AXI_RFIFONUM[log2(RBUFF_DEPTH) : PAD_ALIGN] + (local_AXI_RFIFONUM[PAD_ALIGN-1:0] + data_nvalid) >> PAD_ALIGN;
        
        // regslice io ?  no
        assign out_HLS_RDATA    = data_buf[USER_DW-1:0];
        assign out_HLS_RVALID   = data_valid;
        assign out_HLS_RFIFONUM = rdata_num_vld;
        assign ready_for_data   = ~data_valid | in_HLS_RREADY;

        assign next_pad         = local_AXI_RVALID && ready_for_data;
        assign last_pad         = pad_oh[TOTAL_PADS-1];

        always @(posedge ACLK)
        begin
            if (ARESET)
                first_pad <= 1'b1;
            else if (ACLK_EN) begin
                if (next_pad && ~last_pad)
                    first_pad <= 1'b0;
                else if (next_pad && last_pad)
                    first_pad <= 1'b1;
            end
        end

        assign pad_oh = (~local_AXI_RVALID) ?  0 :
                        (first_pad)   ?  1 :
                        pad_oh_reg;
 
        always @(posedge ACLK)
        begin
            if (ARESET)
                pad_oh_reg <= 0;
            else if (ACLK_EN) begin
                if (next_pad)
                    pad_oh_reg <= {pad_oh[TOTAL_PADS - 2:0], 1'b0};
            end
        end

        genvar  i;
        for (i = 0; i < TOTAL_PADS; i = i + 1) begin : data_gen
            always @(posedge ACLK)
            begin
                if (ACLK_EN) begin
                    if (pad_oh[i] == 1'b1 && ready_for_data)
                        data_buf[i*BUS_DATA_WIDTH +: BUS_DATA_WIDTH] <= local_AXI_RDATA;
                end
            end
        end

        always @(posedge ACLK)
        begin
            if (ARESET)
                data_valid <= 1'b0;
            else if (ACLK_EN) begin
                if (next_pad && last_pad)
                    data_valid <= 1'b1;
                else if (ready_for_data)
                    data_valid <= 1'b0;
            end
        end

        always @(posedge ACLK)
        begin
            if (ARESET)
                data_nvalid <= 0;
            else if (ACLK_EN) begin
                if (first_pad)
                    data_nvalid <= 1;
                else if (next_pad)
                    data_nvalid <= data_nvalid + 1;
            end
        end
    end
    endgenerate
    // end of RDATA PREPROCESSOR
    // ===================================================================

endmodule




// 67d7842dbbe25473c3c32b93c0da8047785f30d78e8a024de1b57352245f9689

`timescale 1ns/1ps



module mm2s_gmem_m_axi_read
#(parameter
    C_M_AXI_ID_WIDTH          = 1,
    C_M_AXI_ARUSER_WIDTH      = 1,
    C_M_AXI_RUSER_WIDTH       = 1,
    C_USER_VALUE              = 1'b0,
    C_PROT_VALUE              = 3'b000,
    C_CACHE_VALUE             = 4'b0011,
    BUS_ADDR_WIDTH            = 32,
    BUS_DATA_WIDTH            = 32,
    USER_LEN_WIDTH            = 32,
    MAX_READ_BURST_LENGTH     = 16,
    NUM_READ_OUTSTANDING      = 2,
    ID0_NUM_READ_OUTSTANDING = 2,
    NUM_READ_PORTS            = 1
)(
    // system signal
    input  wire                            ACLK,
    input  wire                            ARESET,
    input  wire                            ACLK_EN,
    // read address channel
    output wire [C_M_AXI_ID_WIDTH-1:0]     out_BUS_ARID,
    output wire [BUS_ADDR_WIDTH-1:0]       out_BUS_ARADDR,
    output wire [7:0]                      out_BUS_ARLEN,
    output wire [2:0]                      out_BUS_ARSIZE,
    output wire [1:0]                      out_BUS_ARBURST,
    output wire [1:0]                      out_BUS_ARLOCK,
    output wire [3:0]                      out_BUS_ARCACHE,
    output wire [2:0]                      out_BUS_ARPROT,
    output wire [3:0]                      out_BUS_ARQOS,
    output wire [3:0]                      out_BUS_ARREGION,
    output wire [C_M_AXI_ARUSER_WIDTH-1:0] out_BUS_ARUSER,
    output wire                            out_BUS_ARVALID,
    input  wire                            in_BUS_ARREADY,
    // read data channel
    input  wire [C_M_AXI_ID_WIDTH-1:0]     in_BUS_RID,
    input  wire [BUS_DATA_WIDTH-1:0]       in_BUS_RDATA,
    input  wire [1:0]                      in_BUS_RRESP,
    input  wire                            in_BUS_RLAST,
    input  wire [C_M_AXI_RUSER_WIDTH-1:0]  in_BUS_RUSER,
    input  wire                            in_BUS_RVALID,
    output wire                            out_BUS_RREADY,
    // internal read request channel
    input  wire [C_M_AXI_ID_WIDTH-1:0]     in_AXI_ARID,
    input  wire [BUS_ADDR_WIDTH-1:0]       in_AXI_ARADDR,
    input  wire [USER_LEN_WIDTH-1:0]       in_AXI_ARLEN,
    input  wire                            in_AXI_ARVALID,
    output wire [NUM_READ_PORTS-1:0]       out_AXI_ARREADY,
    output wire [BUS_DATA_WIDTH-1:0]       out_AXI_RDATA,
    output wire [1:0]                      out_AXI_RLAST,
    output wire [NUM_READ_PORTS-1:0]       out_AXI_RVALID,
    input  wire [NUM_READ_PORTS-1:0]       in_AXI_RREADY,
    input  wire [NUM_READ_PORTS-1:0]       in_BURST_RREADY
);

//------------------------Parameter----------------------
    localparam
        BUS_DATA_BYTES  = BUS_DATA_WIDTH / 8,
        BUS_ADDR_ALIGN  = log2(BUS_DATA_BYTES);

//------------------------Task and function--------------
    function integer log2;
        input integer x;
        integer n, m;
    begin
        n = 0;
        m = 1;
        while (m < x) begin
            n = n + 1;
            m = m * 2;
        end
        log2 = n;
    end
    endfunction

    function [NUM_READ_PORTS-1:0] bit_set;
        input [C_M_AXI_ID_WIDTH-1:0] idx;
        input                        valid;
    begin
        bit_set = {NUM_READ_PORTS{1'b0}};
        bit_set[idx] = valid;
    end
    endfunction

    function integer num_outstanding_val;
        input integer idx;
    begin
        case (idx)
            0 : num_outstanding_val = ID0_NUM_READ_OUTSTANDING;
            default : num_outstanding_val = NUM_READ_OUTSTANDING;
        endcase
    end
    endfunction

    // Convert the actual AXI ID to the ID locally used by the read module
    function [C_M_AXI_ID_WIDTH-1:0] compress_axi_id;
        input [C_M_AXI_ID_WIDTH-1:0] axi_id;
        case (axi_id)
            'd0 : compress_axi_id = 'd0;
            default : compress_axi_id = 'd0;
        endcase
    endfunction

    // Convert the ID locally used by the read module to the actual AXI ID
    function [C_M_AXI_ID_WIDTH-1:0] decompress_axi_id;
        input [C_M_AXI_ID_WIDTH-1:0] local_id;
        case (local_id)
            'd0 : decompress_axi_id = 'd0;
            default : decompress_axi_id = 'd0;
        endcase
    endfunction
//------------------------Local signal-------------------
    genvar idx;
    wire [C_M_AXI_ID_WIDTH-1:0]   local_BUS_ARID;
    wire [C_M_AXI_ID_WIDTH-1:0]   local_BUS_RID;

    wire [C_M_AXI_ID_WIDTH-1:0]   ost_ctrl_id;
    wire                          ost_ctrl_info;
    wire                          ost_ctrl_valid;
    wire [NUM_READ_PORTS-1:0]     ost_ctrl_ready;
    wire [NUM_READ_PORTS-1:0]     ost_ctrl_write;
    wire [NUM_READ_PORTS-1:0]     ost_ctrl_empty_n;
    wire [NUM_READ_PORTS-1:0]     next_ctrl;
    
    wire                          next_burst;
    wire [NUM_READ_PORTS-1:0]     ost_burst_empty_n;
    wire [NUM_READ_PORTS-1:0]     ost_burst_info;
    wire [NUM_READ_PORTS-1:0]     ost_burst_read;
    wire                          last_burst;

    wire [C_M_AXI_ID_WIDTH-1:0]   beat_id;
    wire [BUS_DATA_WIDTH-1:0]     beat_data;
    wire                          beat_last;
    wire                          beat_valid;
    wire                          beat_ready;
    wire                          last_beat;

    // regslice io ?  no 

// -----------------------BUS global config -------------
    assign out_BUS_ARID        = decompress_axi_id(local_BUS_ARID);
    assign out_BUS_ARSIZE      = BUS_ADDR_ALIGN;
    assign out_BUS_ARBURST     = 2'b01;
    assign out_BUS_ARLOCK      = 2'b00;
    assign out_BUS_ARCACHE     = C_CACHE_VALUE;
    assign out_BUS_ARPROT      = C_PROT_VALUE;
    assign out_BUS_ARUSER      = C_USER_VALUE;
    assign out_BUS_ARQOS       = 4'b0000;
    assign out_BUS_ARREGION    = 4'b0000;
//------------------------AR channel begin---------------
//------------------------Instantiation------------------
    mm2s_gmem_m_axi_burst_converter #(
        .ID_WIDTH              (C_M_AXI_ID_WIDTH),
        .DATA_WIDTH            (BUS_DATA_WIDTH),
        .ADDR_WIDTH            (BUS_ADDR_WIDTH),
        .LEN_WIDTH             (USER_LEN_WIDTH),
        .NUM_PORTS             (NUM_READ_PORTS),
        .MAX_BURST_LEN         (MAX_READ_BURST_LENGTH)
    ) rreq_burst_conv (
        .clk                   (ACLK),
        .reset                 (ARESET),
        .clk_en                (ACLK_EN),

        .in_REQ_ID             (in_AXI_ARID),
        .in_REQ_ADDR           (in_AXI_ARADDR),
        .in_REQ_LEN            (in_AXI_ARLEN),
        .in_REQ_VALID          (in_AXI_ARVALID),
        .out_REQ_READY         (out_AXI_ARREADY),
        .out_BURST_ID          (local_BUS_ARID),
        .out_BURST_ADDR        (out_BUS_ARADDR),
        .out_BURST_LEN         (out_BUS_ARLEN),
        .out_BURST_VALID       (out_BUS_ARVALID),
        .in_BURST_READY        (in_BUS_ARREADY),
        .out_CTRL_ID           (ost_ctrl_id),
        .out_CTRL_INFO         (ost_ctrl_info),
        .out_CTRL_VALID        (ost_ctrl_valid),
        .in_CTRL_READY         (ost_ctrl_ready)
    );

//------------------------Body---------------------------

//------------------------AR channel end-----------------

//------------------------R channel begin----------------
//------------------------Instantiation------------------
    mm2s_gmem_m_axi_reg_slice #(
        .DATA_WIDTH            (C_M_AXI_ID_WIDTH + BUS_DATA_WIDTH + 1)
    ) rs_rdata (
        .clk                   (ACLK),
        .reset                 (ARESET),
        .s_data                ({local_BUS_RID, in_BUS_RLAST, in_BUS_RDATA}),
        .s_valid               (in_BUS_RVALID),
        .s_ready               (out_BUS_RREADY),
        .m_data                ({beat_id, beat_last, beat_data}),
        .m_valid               (beat_valid),
        .m_ready               (beat_ready));

    generate
    for (idx = 0; idx < NUM_READ_PORTS; idx = idx + 1) begin : ost_ctrl_gen
        mm2s_gmem_m_axi_fifo #(
            .DATA_WIDTH        (1),
            .ADDR_WIDTH        (log2(num_outstanding_val(idx))),
            .DEPTH             (num_outstanding_val(idx))
        ) fifo_rctl (
            .clk               (ACLK),
            .reset             (ARESET),
            .clk_en            (ACLK_EN),
            .if_full_n         (ost_ctrl_ready[idx]),
            .if_write          (ost_ctrl_write[idx]),
            .if_din            (ost_ctrl_info),
            .if_empty_n        (ost_ctrl_empty_n[idx]),
            .if_read           (next_ctrl[idx]),
            .if_dout           (),
            .if_num_data_valid ());

        mm2s_gmem_m_axi_fifo #(
            .DATA_WIDTH        (1),
            .ADDR_WIDTH        (log2(num_outstanding_val(idx))),
            .DEPTH             (num_outstanding_val(idx))
        ) fifo_burst (
            .clk               (ACLK),
            .reset             (ARESET),
            .clk_en            (ACLK_EN),
            .if_full_n         (),
            .if_write          (ost_ctrl_write[idx]),
            .if_din            (ost_ctrl_info),
            .if_empty_n        (ost_burst_empty_n[idx]),
            .if_read           (ost_burst_read[idx]),
            .if_dout           (ost_burst_info[idx]),
            .if_num_data_valid ());
    end
    endgenerate
//------------------------Body---------------------------
    assign ost_ctrl_write   = bit_set(ost_ctrl_id, ost_ctrl_valid);
    assign ost_burst_read   = bit_set(beat_id, next_burst);

    assign next_ctrl        = in_BURST_RREADY & ost_ctrl_empty_n;
    assign next_burst       = last_beat && beat_valid && beat_ready;

    assign last_beat        = beat_last == 1'b1;
    assign last_burst       = (ost_burst_info[beat_id] == 1'b1) && (ost_burst_empty_n[beat_id] == 1'b1);

    assign out_AXI_RLAST    = {last_beat, last_beat && last_burst};
    assign out_AXI_RDATA    = beat_data;
    assign out_AXI_RVALID   = bit_set(beat_id, beat_valid);
    assign beat_ready       = (in_AXI_RREADY[beat_id] == 1'b1);

    assign local_BUS_RID    = compress_axi_id(in_BUS_RID);
//------------------------R channel end------------------
endmodule




module mm2s_gmem_m_axi_burst_converter
#(parameter
    INTERLEAVE                   = 1,
    ID_WIDTH                     = 1,
    DATA_WIDTH                   = 32,
    ADDR_WIDTH                   = 32,
    LEN_WIDTH                    = 32,
    NUM_PORTS                    = 1,
    MAX_BURST_LEN                = 16
)(
    input  wire                  clk,
    input  wire                  reset,
    input  wire                  clk_en,

    input  wire [ID_WIDTH-1:0]   in_REQ_ID,
    input  wire [ADDR_WIDTH-1:0] in_REQ_ADDR,
    input  wire [LEN_WIDTH-1:0]  in_REQ_LEN,
    input  wire                  in_REQ_VALID,
    output wire [NUM_PORTS-1:0]  out_REQ_READY,
    output wire [ID_WIDTH-1:0]   out_BURST_ID,
    output wire [ADDR_WIDTH-1:0] out_BURST_ADDR,
    output wire [7:0]            out_BURST_LEN,
    output wire                  out_BURST_VALID,
    input  wire                  in_BURST_READY,
    output wire [ID_WIDTH-1:0]   out_CTRL_ID,
    output wire                  out_CTRL_INFO,
    output wire                  out_CTRL_VALID,
    input  wire [NUM_PORTS-1:0]  in_CTRL_READY
);

    generate
    if ((INTERLEAVE == 1) && (NUM_PORTS > 1)) begin
        mm2s_gmem_m_axi_burst_interleave #(
            .ID_WIDTH          (ID_WIDTH),
            .DATA_WIDTH        (DATA_WIDTH),
            .ADDR_WIDTH        (ADDR_WIDTH),
            .LEN_WIDTH         (LEN_WIDTH),
            .NUM_PORTS         (NUM_PORTS),
            .MAX_BURST_LEN     (MAX_BURST_LEN)
        ) burst_interleave (
            .clk               (clk),
            .reset             (reset),
            .clk_en            (clk_en),
            .in_REQ_ID         (in_REQ_ID),
            .in_REQ_ADDR       (in_REQ_ADDR),
            .in_REQ_LEN        (in_REQ_LEN),
            .in_REQ_VALID      (in_REQ_VALID),
            .out_REQ_READY     (out_REQ_READY),
            .out_BURST_ID      (out_BURST_ID),
            .out_BURST_ADDR    (out_BURST_ADDR),
            .out_BURST_LEN     (out_BURST_LEN),
            .out_BURST_VALID   (out_BURST_VALID),
            .in_BURST_READY    (in_BURST_READY),
            .out_CTRL_ID       (out_CTRL_ID),
            .out_CTRL_INFO     (out_CTRL_INFO),
            .out_CTRL_VALID    (out_CTRL_VALID),
            .in_CTRL_READY     (in_CTRL_READY)
        );

    end
    else begin
        mm2s_gmem_m_axi_burst_sequential #(
            .ID_WIDTH          (ID_WIDTH),
            .DATA_WIDTH        (DATA_WIDTH),
            .ADDR_WIDTH        (ADDR_WIDTH),
            .LEN_WIDTH         (LEN_WIDTH),
            .NUM_PORTS         (NUM_PORTS),
            .MAX_BURST_LEN     (MAX_BURST_LEN)
        ) burst_sequential (
            .clk               (clk),
            .reset             (reset),
            .clk_en            (clk_en),
            .in_REQ_ID         (in_REQ_ID),
            .in_REQ_ADDR       (in_REQ_ADDR),
            .in_REQ_LEN        (in_REQ_LEN),
            .in_REQ_VALID      (in_REQ_VALID),
            .out_REQ_READY     (out_REQ_READY),
            .out_BURST_ID      (out_BURST_ID),
            .out_BURST_ADDR    (out_BURST_ADDR),
            .out_BURST_LEN     (out_BURST_LEN),
            .out_BURST_VALID   (out_BURST_VALID),
            .in_BURST_READY    (in_BURST_READY),
            .out_CTRL_ID       (out_CTRL_ID),
            .out_CTRL_INFO     (out_CTRL_INFO),
            .out_CTRL_VALID    (out_CTRL_VALID),
            .in_CTRL_READY     (in_CTRL_READY)
        );

    end
    endgenerate

endmodule


module mm2s_gmem_m_axi_burst_interleave
#(parameter
    ID_WIDTH                     = 1,
    DATA_WIDTH                   = 32,
    ADDR_WIDTH                   = 32,
    LEN_WIDTH                    = 32,
    NUM_PORTS                    = 1,
    MAX_BURST_LEN                = 16
)(
    input  wire                  clk,
    input  wire                  reset,
    input  wire                  clk_en,
    input  wire [ID_WIDTH-1:0]   in_REQ_ID,
    input  wire [ADDR_WIDTH-1:0] in_REQ_ADDR,
    input  wire [LEN_WIDTH-1:0]  in_REQ_LEN,
    input  wire                  in_REQ_VALID,
    output wire [NUM_PORTS-1:0]  out_REQ_READY,
    output wire [ID_WIDTH-1:0]   out_BURST_ID,
    output wire [ADDR_WIDTH-1:0] out_BURST_ADDR,
    output wire [7:0]            out_BURST_LEN,
    output wire                  out_BURST_VALID,
    input  wire                  in_BURST_READY,
    output wire [ID_WIDTH-1:0]   out_CTRL_ID,
    output wire                  out_CTRL_INFO,
    output wire                  out_CTRL_VALID,
    input  wire [NUM_PORTS-1:0]  in_CTRL_READY
);
//------------------------Parameter----------------------
    localparam
        PACK_WIDTH      = ID_WIDTH+ADDR_WIDTH+LEN_WIDTH,
        DATA_BYTES      = DATA_WIDTH / 8,
        ADDR_ALIGN      = log2(DATA_BYTES),
        BOUNDARY_BEATS  = {12-ADDR_ALIGN{1'b1}},
        NUM_BEAT_WIDTH  = log2(MAX_BURST_LEN);
//------------------------Task and function--------------
    function integer log2;
        input integer x;
        integer n, m;
        begin
            n = 0;
            m = 1;
            while (m < x) begin
                n = n + 1;
                m = m * 2;
            end
            log2 = n;
        end
    endfunction
//------------------------Local signal-------------------
    wire [PACK_WIDTH-1:0]       req_pack_in;
    wire [PACK_WIDTH-1:0]       req_pack_out;
    wire [ID_WIDTH-1:0]         req_id_tmp;
    wire [ADDR_WIDTH-1:0]       req_addr_tmp;
    wire [LEN_WIDTH-1:0]        req_len_tmp;

    wire                        req_full_n;
    wire                        req_empty_n;
    wire                        write_req;
    wire                        read_req;
    reg  [NUM_PORTS-1:0]        req_ready;
    wire                        next_req;

    reg  [ADDR_WIDTH - 1:0]     start_addr;
    wire [ADDR_WIDTH - 1:0]     sect_addr;
    reg  [ADDR_WIDTH - 1:0]     sect_addr_buf;
    reg  [ID_WIDTH-1:0]         req_id;
    reg  [ID_WIDTH-1:0]         req_id_buf;
    reg                         req_handling;

    reg  [11 - ADDR_ALIGN:0]    start_to_4k;
    reg  [11 - ADDR_ALIGN:0]    end_from_4k;
    wire [11 - ADDR_ALIGN:0]    sect_len;
    reg  [11 - ADDR_ALIGN:0]    sect_len_buf;
    reg  [LEN_WIDTH-1:0]        beat_len;
    reg  [LEN_WIDTH-1:0]        beat_len_buf;

    reg  [ADDR_WIDTH-13:0]      sect_cnt;
    reg  [LEN_WIDTH-13:0]       sect_total;
    reg  [LEN_WIDTH-13:0]       sect_total_buf;
    wire [LEN_WIDTH-13:0]       sect_total_tmp;
    wire                        ready_for_sect;

    wire                        single_sect;
    reg                         first_sect;
    reg                         last_sect;
    wire                        last_sect_tmp;
    reg                         last_sect_buf;
    wire                        next_sect;

    reg                         burst_valid;

    wire [ID_WIDTH-1:0]         ost_ctrl_id;
    wire                        ost_ctrl_info;
    wire                        ost_ctrl_valid;
    wire                        ost_ctrl_ready;

    wire [PACK_WIDTH-1:0]       rem_req_pack;
    reg                         rem_req_valid;
    reg  [ID_WIDTH-1:0]         rem_req_id;
    reg  [ADDR_WIDTH-1:0]       rem_req_addr;
    reg  [LEN_WIDTH-1:0]        rem_req_len;
    wire [ADDR_WIDTH-1:0]       rem_req_addr_pred;
    wire [LEN_WIDTH-1:0]        rem_req_len_pred;

//------------------------Instantiation------------------
    generate 
    if (NUM_PORTS > 2) begin
        mm2s_gmem_m_axi_fifo #(
            .DATA_WIDTH        (PACK_WIDTH),
            .ADDR_WIDTH        (log2(NUM_PORTS)),
            .DEPTH             (NUM_PORTS)
        ) req_buffer (
            .clk               (clk),
            .reset             (reset),
            .clk_en            (clk_en),
            .if_full_n         (req_full_n),
            .if_write          (write_req),
            .if_din            (req_pack_in),
            .if_empty_n        (req_empty_n),
            .if_read           (read_req),
            .if_dout           (req_pack_out),
            .if_num_data_valid ());
    end
    else begin
        mm2s_gmem_m_axi_reg_slice #(
            .DATA_WIDTH     (PACK_WIDTH)
        ) rs_req (
            .clk            (clk),
            .reset          (reset),
            .s_ready        (req_full_n),
            .s_valid        (write_req),
            .s_data         (req_pack_in),
            .m_valid        (req_empty_n),
            .m_ready        (read_req),
            .m_data         (req_pack_out));
    end
    endgenerate
        
//------------------------Body--------------------------- 
    assign out_REQ_READY = (req_full_n && ~rem_req_valid) ? req_ready : {NUM_PORTS{1'b0}};
    assign req_pack_in   = rem_req_valid ? rem_req_pack  : {in_REQ_ID, in_REQ_LEN, in_REQ_ADDR};
    assign write_req     = rem_req_valid || in_REQ_VALID;
    
    always @(posedge clk) 
    begin
        if (reset)
            req_ready <= {NUM_PORTS{1'b1}};
        else if (clk_en) begin
            if (in_REQ_VALID && req_full_n && ~rem_req_valid)
                req_ready[in_REQ_ID] = 1'b0;
            if (ost_ctrl_info && ost_ctrl_valid)
                req_ready[ost_ctrl_id] = 1'b1;
        end
    end

    assign req_id_tmp    = req_pack_out[PACK_WIDTH-1 : ADDR_WIDTH+LEN_WIDTH];
    assign req_len_tmp   = req_pack_out[ADDR_WIDTH+LEN_WIDTH-1 : ADDR_WIDTH];
    assign req_addr_tmp  = req_pack_out[ADDR_WIDTH-1 : 0];

    assign next_req      = read_req && req_empty_n;

    always @(posedge clk)
    begin
        if (reset) begin
            req_id      <= 0;
            start_addr  <= 0;
            sect_total  <= 0;
            end_from_4k <= 0;
            start_to_4k <= 0;
        end
        else if (clk_en) begin
            if(next_req) begin
                req_id      <= req_id_tmp;
                start_addr  <= {req_addr_tmp[ADDR_WIDTH-1:ADDR_ALIGN], {ADDR_ALIGN{1'b0}}}; // addr align
                sect_total  <= (req_len_tmp + req_addr_tmp[11:0]) >> 12;
                end_from_4k <= (req_addr_tmp[11:0] + req_len_tmp[11:0]) >> ADDR_ALIGN;
                start_to_4k <= BOUNDARY_BEATS - req_addr_tmp[11:ADDR_ALIGN];
            end
        end
    end

    always @(posedge clk)
    begin
        if (reset)
            req_handling <= 1'b0;
        else if (clk_en) begin
            if (next_req)
                req_handling <= 1'b1;
            else if (~req_empty_n && last_sect_tmp && next_sect)
                req_handling <= 1'b0;
        end
    end

    // 4k boundary
    assign last_sect_tmp  = single_sect || last_sect;

    assign sect_total_tmp = first_sect ? sect_total : sect_total_buf;

    assign single_sect  = (sect_total == 0);

    assign sect_addr  = (first_sect)? start_addr : {sect_cnt, {12{1'b0}}};
    assign sect_len   = single_sect                ? beat_len[11-ADDR_ALIGN:0] :
                        ( first_sect && ~last_sect)? start_to_4k :
                        (~first_sect &&  last_sect)? end_from_4k :
                                                     BOUNDARY_BEATS;
   always @(posedge clk)
    begin
        if (reset) begin
            first_sect <= 1'b0;
            last_sect <= 1'b0;
            sect_cnt <= 0;
            beat_len <= 0;
        end
        else if (clk_en) begin
            if (next_req) begin
                first_sect <= 1'b1;
                last_sect <= 1'b0;
                sect_cnt <= req_addr_tmp[ADDR_WIDTH-1:12];
                beat_len <= (req_len_tmp + req_addr_tmp[ADDR_ALIGN-1:0]) >> ADDR_ALIGN;  // beat align
            end
            else if (next_sect) begin
                first_sect <= 1'b0;
                last_sect <= (sect_total_tmp == 1);
                sect_cnt <= sect_cnt + 1;
                beat_len <= beat_len - sect_len - 1;
            end
        end
    end

    always @(posedge clk)
    begin
        if (reset) begin
            req_id_buf     <= 0;
            sect_addr_buf  <= 0;
            sect_len_buf   <= 0;
            last_sect_buf  <= 1'b0;
            beat_len_buf   <= 0;
            sect_total_buf <= 0;
        end
        else if (clk_en) begin
            if (next_sect) begin
                req_id_buf     <= req_id;
                sect_addr_buf  <= sect_addr;
                sect_len_buf   <= sect_len;
                last_sect_buf  <= last_sect_tmp;
                beat_len_buf   <= beat_len;
                sect_total_buf <= sect_total_tmp - 1;
            end
        end
    end

    assign out_CTRL_VALID     = ost_ctrl_valid;
    assign out_CTRL_INFO      = ost_ctrl_info;
    assign out_CTRL_ID        = ost_ctrl_id;

    generate
    if (DATA_BYTES >= 4096/MAX_BURST_LEN) begin : must_one_burst
        wire                      read_sect;

        assign out_BURST_ADDR     = sect_addr_buf;
        assign out_BURST_LEN      = sect_len_buf;
        assign out_BURST_VALID    = burst_valid;
        assign out_BURST_ID       = req_id_buf;

        assign ost_ctrl_valid     = next_sect;
        assign ost_ctrl_info      = last_sect_tmp;
        assign ost_ctrl_id        = req_id;
        assign ost_ctrl_ready     = in_CTRL_READY[req_id];

        assign next_sect          = read_sect && ost_ctrl_ready;
        assign ready_for_sect     = ~(burst_valid && ~in_BURST_READY) && req_full_n && |in_CTRL_READY;
        assign read_sect          = req_handling & ready_for_sect;
        assign read_req           = ~req_handling || ready_for_sect;

        always @(posedge clk)
        begin
            if (reset)
                burst_valid <= 1'b0;
            else if (clk_en) begin
                if (next_sect)
                    burst_valid <= 1'b1;
                else if (in_BURST_READY)
                    burst_valid <= 1'b0;
            end
        end

        // calculate remaining request, for interleaved burst handling.
        assign rem_req_pack      = {rem_req_id, {rem_req_len[LEN_WIDTH-ADDR_ALIGN-1:0], {ADDR_ALIGN{1'b1}}}, rem_req_addr};
        assign rem_req_addr_pred = ost_ctrl_ready ? {sect_cnt+1, {12{1'b0}}}  : sect_addr;
        assign rem_req_len_pred  = ost_ctrl_ready ? (beat_len - sect_len - 1) : beat_len;

        always @(posedge clk)
        begin
            if (reset) begin
                rem_req_id   <= 0;
                rem_req_addr <= 0;
                rem_req_len <= 0;
            end
            else if (clk_en) begin
                if (read_sect) begin
                    rem_req_id   <= req_id;
                    rem_req_addr <= rem_req_addr_pred;
                    rem_req_len  <= rem_req_len_pred;
                end
            end
        end

        always @(posedge clk)
        begin
            if (reset)
                rem_req_valid <= 1'b0;
            else if (clk_en) begin
                if (next_sect && last_sect_tmp)
                    rem_req_valid <= 1'b0;
                else if (req_empty_n && read_sect)
                    rem_req_valid <= 1'b1;
                else if (req_full_n)
                    rem_req_valid <= 1'b0;
            end
        end
    end
    else begin : could_multi_bursts
        reg  [ID_WIDTH-1:0]                       burst_id;
        reg  [ADDR_WIDTH - 1:0]                   burst_addr;
        wire [ADDR_WIDTH - 1:0]                   burst_addr_next;
        reg  [ADDR_WIDTH - 1:0]                   burst_addr_pred;
        reg  [7:0]                                burst_len;
        reg  [7:0]                                burst_len_pred;
        reg  [8:0]                                burst_len_pred_plus1;

        reg                                       next_req_ready;
        reg                                       sect_handling;
        reg  [11 - NUM_BEAT_WIDTH - ADDR_ALIGN:0] loop_cnt;
        reg                                       first_loop;
        reg                                       last_loop;
        wire                                      next_loop;
        wire                                      read_loop;
        wire                                      ready_for_loop;

        wire                                      last_loop_when_next_loop;
        wire                                      last_loop_when_next_sect;
        wire [7:0]                                burst_len_when_next_loop;
        wire [7:0]                                burst_len_when_next_sect;

        assign out_BURST_ADDR  = burst_addr;
        assign out_BURST_LEN   = burst_len;
        assign out_BURST_VALID = burst_valid;
        assign out_BURST_ID    = burst_id;

        assign ost_ctrl_valid  = next_loop;
        assign ost_ctrl_info   = last_loop && last_sect_buf;
        assign ost_ctrl_id     = req_id_buf;
        assign ost_ctrl_ready  = in_CTRL_READY[req_id_buf];

        assign ready_for_loop  = ~(burst_valid && ~in_BURST_READY) && req_full_n && |in_CTRL_READY; 
        assign read_loop       = sect_handling && ready_for_loop;
        assign next_loop       = read_loop & ost_ctrl_ready;

        assign next_sect       = req_handling & ready_for_sect;
        assign ready_for_sect  = ~sect_handling  || (read_loop && next_req_ready) || (next_loop && last_loop);
        assign read_req        = ~next_req_ready || ready_for_sect;

        always @(posedge clk)
        begin
            if (reset)
                burst_valid <= 1'b0;
            else if (clk_en) begin
                if (next_loop)
                    burst_valid <= 1'b1;
                else if (in_BURST_READY)
                    burst_valid <= 1'b0;
            end
        end

        always @(posedge clk)
        begin
            if (reset)
                sect_handling <= 1'b0;
            else if (clk_en) begin
                if (req_handling && ~sect_handling)
                    sect_handling <= 1'b1;
                else if (~req_handling && last_loop && next_loop)
                    sect_handling <= 1'b0;
            end
        end

        always @(posedge clk)
        begin
            if (reset) begin
                first_loop <= 1'b0;
                last_loop  <= 1'b0;
                loop_cnt   <= 0;
            end
            else if (clk_en) begin
                if (next_sect) begin
                    first_loop <= 1'b1;
                    last_loop  <= last_loop_when_next_sect;
                    loop_cnt   <= sect_len[11 - ADDR_ALIGN : NUM_BEAT_WIDTH];
                end
                else if (next_loop) begin
                    first_loop <= 1'b0;
                    last_loop  <= last_loop_when_next_loop;
                    loop_cnt   <= loop_cnt - 1;
                end
            end
        end

        assign last_loop_when_next_sect = (sect_len[11 - ADDR_ALIGN : NUM_BEAT_WIDTH] == 0); 
        assign last_loop_when_next_loop = (loop_cnt == 1);

        assign burst_addr_next = first_loop ? sect_addr_buf  : burst_addr_pred;
        assign burst_len_when_next_sect = (NUM_BEAT_WIDTH == 0)    ? 0 :
                                          last_loop_when_next_sect ? sect_len[NUM_BEAT_WIDTH - 1:0] :
                                                                     {NUM_BEAT_WIDTH{1'b1} };
        assign burst_len_when_next_loop = (NUM_BEAT_WIDTH == 0)    ? 0 :
                                          last_loop_when_next_loop ? sect_len_buf[NUM_BEAT_WIDTH - 1:0] :
                                                                     {NUM_BEAT_WIDTH{1'b1} };

        assign rem_req_pack = {rem_req_id, {rem_req_len[LEN_WIDTH-ADDR_ALIGN-1:0], {ADDR_ALIGN{1'b1}}}, rem_req_addr};

        assign rem_req_addr_pred = ost_ctrl_ready &  first_loop ? sect_addr_buf   + (burst_len_pred_plus1 << ADDR_ALIGN) :
                                   ost_ctrl_ready & ~first_loop ? burst_addr_pred + (burst_len_pred_plus1 << ADDR_ALIGN) :
                                  ~ost_ctrl_ready &  first_loop ? sect_addr_buf : 
                                                                  burst_addr_pred;

        assign rem_req_len_pred  = ost_ctrl_ready &  first_loop ? beat_len_buf - burst_len_pred_plus1 :
                                   ost_ctrl_ready & ~first_loop ? rem_req_len  - burst_len_pred_plus1 :
                                  ~ost_ctrl_ready &  first_loop ? beat_len_buf :
                                                                  rem_req_len;
    
        always @(posedge clk)
        begin
            if (reset) begin
                burst_len_pred       <= 2**NUM_BEAT_WIDTH - 1;
                burst_len_pred_plus1 <= 2**NUM_BEAT_WIDTH;
            end
            else if (clk_en) begin
                if (next_sect) begin
                    burst_len_pred       <= burst_len_when_next_sect;
                    burst_len_pred_plus1 <= burst_len_when_next_sect + 1;
                end
                else if (next_loop) begin
                    burst_len_pred       <= burst_len_when_next_loop;
                    burst_len_pred_plus1 <= burst_len_when_next_loop + 1;
                end
            end
        end

        always @(posedge clk)
        begin
            if (reset) begin
                burst_id    <= 0;
                burst_addr  <= 0;
                burst_len   <= 0;
                burst_addr_pred <= 0;
            end
            else if (clk_en) begin
                if (next_loop) begin
                    burst_id    <= req_id_buf;
                    burst_addr  <= burst_addr_next;
                    burst_len   <= burst_len_pred;
                    burst_addr_pred <= burst_addr_next + (burst_len_pred_plus1 << ADDR_ALIGN);
                end
            end
        end

        always @(posedge clk)
        begin
            if (reset) begin
                rem_req_id   <= 0;
                rem_req_addr <= 0;
                rem_req_len  <= 0;
            end
            else if (clk_en) begin
                if (read_loop) begin
                    rem_req_id   <= req_id_buf;
                    rem_req_addr <= rem_req_addr_pred;
                    rem_req_len  <= rem_req_len_pred;
                end
            end
        end

        always @(posedge clk)
        begin
            if (reset)
                next_req_ready <= 1'b0;
            else if (clk_en) begin
                if (next_req)
                    next_req_ready <= 1'b1;
                else if (next_sect)
                    next_req_ready <= 1'b0;
            end
        end

        always @(posedge clk)
        begin
            if (reset)
                rem_req_valid <= 1'b0;
            else if (clk_en) begin
                if (next_loop && last_loop && last_sect_buf)
                    rem_req_valid <= 1'b0;
                else if (next_req_ready && read_loop)
                    rem_req_valid <= 1'b1;
                else if (req_full_n)
                    rem_req_valid <= 1'b0;
            end
        end
    end
    endgenerate

endmodule

module mm2s_gmem_m_axi_burst_sequential
#(parameter
    ID_WIDTH                     = 1,
    DATA_WIDTH                   = 32,
    ADDR_WIDTH                   = 32,
    LEN_WIDTH                    = 32,
    NUM_PORTS                    = 1,
    MAX_BURST_LEN                = 16
)(
    input  wire                  clk,
    input  wire                  reset,
    input  wire                  clk_en,
    input  wire [ID_WIDTH-1:0]   in_REQ_ID,
    input  wire [ADDR_WIDTH-1:0] in_REQ_ADDR,
    input  wire [LEN_WIDTH-1:0]  in_REQ_LEN,
    input  wire                  in_REQ_VALID,
    output wire [NUM_PORTS-1:0]  out_REQ_READY,
    output wire [ID_WIDTH-1:0]   out_BURST_ID,
    output wire [ADDR_WIDTH-1:0] out_BURST_ADDR,
    output wire [7:0]            out_BURST_LEN,
    output wire                  out_BURST_VALID,
    input  wire                  in_BURST_READY,
    output wire [ID_WIDTH-1:0]   out_CTRL_ID,
    output wire                  out_CTRL_INFO,
    output wire                  out_CTRL_VALID,
    input  wire [NUM_PORTS-1:0]  in_CTRL_READY
);
//------------------------Parameter----------------------
    localparam
        PACK_WIDTH      = ID_WIDTH+ADDR_WIDTH+LEN_WIDTH,
        DATA_BYTES      = DATA_WIDTH / 8,
        ADDR_ALIGN      = log2(DATA_BYTES),
        BOUNDARY_BEATS  = {12-ADDR_ALIGN{1'b1}},
        NUM_BEAT_WIDTH  = log2(MAX_BURST_LEN);
//------------------------Task and function--------------
    function integer log2;
        input integer x;
        integer n, m;
        begin
            n = 0;
            m = 1;
            while (m < x) begin
                n = n + 1;
                m = m * 2;
            end
            log2 = n;
        end
    endfunction
//------------------------Local signal-------------------
    wire [PACK_WIDTH-1:0]       req_pack_in;
    wire [PACK_WIDTH-1:0]       req_pack_out;
    wire [ID_WIDTH-1:0]         req_id_tmp;
    wire [ADDR_WIDTH-1:0]       req_addr_tmp;
    wire [LEN_WIDTH-1:0]        req_len_tmp;

    wire                        req_full_n;
    wire                        req_empty_n;
    wire                        write_req;
    wire                        read_req;
    wire                        next_req;

    reg  [ADDR_WIDTH - 1:0]     start_addr;
    wire [ADDR_WIDTH - 1:0]     sect_addr;
    reg  [ADDR_WIDTH - 1:0]     sect_addr_buf;
    reg  [ID_WIDTH-1:0]         req_id;
    reg  [ID_WIDTH-1:0]         req_id_buf;
    reg                         req_handling;

    reg  [11 - ADDR_ALIGN:0]    start_to_4k;
    reg  [11 - ADDR_ALIGN:0]    end_from_4k;
    wire [11 - ADDR_ALIGN:0]    sect_len;
    reg  [11 - ADDR_ALIGN:0]    sect_len_buf;
    reg  [11 - ADDR_ALIGN:0]    beat_len;
    
    reg  [ADDR_WIDTH-13:0]      sect_cnt;
    reg  [LEN_WIDTH-13:0]       sect_total;
    reg  [LEN_WIDTH-13:0]       sect_total_buf;
    wire [LEN_WIDTH-13:0]       sect_total_tmp;
    wire                        ready_for_sect;
    
    wire                        single_sect;
    reg                         first_sect;
    reg                         last_sect;
    wire                        last_sect_tmp;
    reg                         last_sect_buf;
    wire                        next_sect;

    reg                         burst_valid;

    wire [ID_WIDTH-1:0]         ost_ctrl_id;
    wire                        ost_ctrl_info;
    wire                        ost_ctrl_valid;
    wire                        ost_ctrl_ready;

//------------------------Instantiation------------------
    mm2s_gmem_m_axi_reg_slice #(
        .DATA_WIDTH     (PACK_WIDTH)
    ) rs_req (
        .clk            (clk),
        .reset          (reset),
        .s_data         (req_pack_in),
        .s_valid        (write_req),
        .s_ready        (req_full_n),
        .m_data         (req_pack_out),
        .m_valid        (req_empty_n),
        .m_ready        (read_req));
    
//------------------------Body--------------------------- 

    assign out_REQ_READY = {NUM_PORTS{req_full_n}};
    assign req_pack_in   = {in_REQ_ID, in_REQ_LEN, in_REQ_ADDR};
    assign write_req     = in_REQ_VALID;

    assign req_id_tmp    = req_pack_out[PACK_WIDTH-1  : ADDR_WIDTH+LEN_WIDTH];
    assign req_len_tmp   = req_pack_out[ADDR_WIDTH+LEN_WIDTH-1 : ADDR_WIDTH];
    assign req_addr_tmp  = req_pack_out[ADDR_WIDTH-1  : 0];

    assign read_req      = last_sect_tmp & next_sect | ~req_handling;
    assign next_req      = read_req & req_empty_n;

    always @(posedge clk)
    begin
        if (reset) begin
            req_id      <= 0;
            start_addr  <= 0;
            beat_len    <= 0;
            sect_total  <= 0;
            end_from_4k <= 0;
            start_to_4k <= 0;
        end
        else if (clk_en) begin
            if (next_req) begin
                req_id      <= req_id_tmp;
                start_addr  <= {req_addr_tmp[ADDR_WIDTH-1:ADDR_ALIGN], {ADDR_ALIGN{1'b0}}};
                beat_len    <= (req_len_tmp[11:0] + req_addr_tmp[ADDR_ALIGN-1:0]) >> ADDR_ALIGN;
                sect_total  <= (req_len_tmp + req_addr_tmp[11:0]) >> 12;
                end_from_4k <= (req_addr_tmp[11:0] + req_len_tmp[11:0]) >> ADDR_ALIGN;
                start_to_4k <= BOUNDARY_BEATS - req_addr_tmp[11:ADDR_ALIGN];
            end
        end
    end

    always @(posedge clk)
    begin
        if (reset)
            req_handling <= 1'b0;
        else if (clk_en) begin
            if (next_req)
                req_handling <= 1'b1;
            else if (~req_empty_n && last_sect_tmp & next_sect)
                req_handling <= 1'b0;
        end
    end

    // 4k boundary
    assign last_sect_tmp  = single_sect || last_sect;

    assign sect_total_tmp = first_sect ? sect_total : sect_total_buf;
    
    assign single_sect  = (sect_total == 0);

    //assign next_sect  = req_handling && ready_for_sect;

    assign sect_addr  = (first_sect)? start_addr : {sect_cnt, {12{1'b0}}};
    
    assign sect_len   = single_sect              ? beat_len :
                        ( first_sect && ~last_sect)? start_to_4k :
                        (~first_sect &&  last_sect)? end_from_4k :
                                                     BOUNDARY_BEATS;

   always @(posedge clk)
    begin
        if (reset) begin
            first_sect <= 1'b0;
            last_sect <= 1'b0;
            sect_cnt <= 0;
        end
        else if (clk_en) begin
            if (next_req) begin
                first_sect <= 1'b1;
                last_sect <= 1'b0;
                sect_cnt <= req_addr_tmp[ADDR_WIDTH-1:12];
            end
            else if (next_sect) begin
                first_sect <= 1'b0;
                last_sect <= (sect_total_tmp == 1);
                sect_cnt <= sect_cnt + 1;
            end
        end
    end

    always @(posedge clk)
    begin
        if (reset) begin
            req_id_buf     <= 0;
            sect_addr_buf  <= 0;
            sect_len_buf   <= 0;
            last_sect_buf  <= 1'b0;
            sect_total_buf <= 0;
        end
        else if (clk_en) begin
            if (next_sect) begin
                req_id_buf     <= req_id;
                sect_addr_buf  <= sect_addr;
                sect_len_buf   <= sect_len;
                last_sect_buf  <= last_sect_tmp;
                sect_total_buf <= sect_total_tmp - 1;
            end
        end
    end

    assign out_CTRL_VALID     = ost_ctrl_valid;
    assign out_CTRL_INFO      = ost_ctrl_info;
    assign out_CTRL_ID        = ost_ctrl_id;

    generate
    if (DATA_BYTES >= 4096/MAX_BURST_LEN) begin : must_one_burst
        wire                   read_sect;

        assign out_BURST_ADDR  = sect_addr_buf;
        assign out_BURST_LEN   = sect_len_buf;
        assign out_BURST_VALID = burst_valid;
        assign out_BURST_ID    = req_id_buf;

        assign ost_ctrl_valid  = next_sect;
        assign ost_ctrl_info   = last_sect_tmp;
        assign ost_ctrl_id     = req_id;
        assign ost_ctrl_ready  = in_CTRL_READY[req_id];

        assign next_sect       = read_sect && ost_ctrl_ready;
        assign read_sect       = req_handling && ready_for_sect;
        assign ready_for_sect  = ~(burst_valid && ~in_BURST_READY);

        always @(posedge clk)
        begin
            if (reset)
                burst_valid <= 1'b0;
            else if (clk_en) begin
                if (next_sect)
                    burst_valid <= 1'b1;
                else if (in_BURST_READY)
                    burst_valid <= 1'b0;
            end
        end
    
    end
    else begin : could_multi_bursts
        reg  [ID_WIDTH-1:0]                       burst_id;
        reg  [ADDR_WIDTH - 1:0]                   burst_addr;
        wire [ADDR_WIDTH - 1:0]                   burst_addr_next;
        reg  [7:0]                                burst_len;
        reg  [8:0]                                burst_len_plus1;
        wire [7:0]                                burst_len_next;

        reg                                       sect_handling;
        reg  [11 - NUM_BEAT_WIDTH - ADDR_ALIGN:0] loop_cnt;
        reg                                       first_loop;
        reg                                       last_loop;
        wire                                      next_loop;
        wire                                      read_loop;
        wire                                      ready_for_loop;

        assign out_BURST_ADDR  = burst_addr;
        assign out_BURST_LEN   = burst_len;
        assign out_BURST_VALID = burst_valid;
        assign out_BURST_ID    = burst_id;

        assign ost_ctrl_valid  = next_loop;
        assign ost_ctrl_info   = last_loop && last_sect_buf;
        assign ost_ctrl_id     = req_id_buf;
        assign ost_ctrl_ready  = in_CTRL_READY[req_id_buf];
        
        assign ready_for_loop  = ~(burst_valid && ~in_BURST_READY);
        assign read_loop       = sect_handling && ready_for_loop;
        assign next_loop       = read_loop && ost_ctrl_ready;

        assign next_sect       = req_handling && ready_for_sect;
        assign ready_for_sect  = ~sect_handling || (last_loop && next_loop);

        always @(posedge clk)
        begin
            if (reset)
                burst_valid <= 1'b0;
            else if (clk_en) begin
                if (next_loop)
                    burst_valid <= 1'b1;
                else if (in_BURST_READY)
                    burst_valid <= 1'b0;
            end
        end

        always @(posedge clk)
        begin
            if (reset)
                sect_handling <= 1'b0;
            else if (clk_en) begin
                if (req_handling && ~sect_handling)
                    sect_handling <= 1'b1;
                else if (~req_handling && last_loop && next_loop)
                    sect_handling <= 1'b0;
            end
        end

        always @(posedge clk)
        begin
            if (reset) begin
                first_loop <= 1'b0;
                last_loop <= 1'b0;
                loop_cnt <= 0;
            end
            else if (clk_en) begin
                if (next_sect) begin
                    first_loop <= 1'b1;
                    last_loop <= (sect_len[11 - ADDR_ALIGN : NUM_BEAT_WIDTH] == 0);
                    loop_cnt <= sect_len[11 - ADDR_ALIGN : NUM_BEAT_WIDTH];
                end
                else if (next_loop) begin
                    first_loop <= 1'b0;
                    last_loop <= (loop_cnt == 1);
                    loop_cnt <= loop_cnt - 1;
                end
            end
        end

        assign burst_addr_next = first_loop ? sect_addr_buf : (burst_addr + (burst_len_plus1 << ADDR_ALIGN));
        assign burst_len_next  = (NUM_BEAT_WIDTH == 0) ? 0 :
                                 last_loop             ? sect_len_buf[NUM_BEAT_WIDTH - 1:0] :
                                                         { NUM_BEAT_WIDTH{1'b1} };

        always @(posedge clk)
        begin
            if (reset) begin
                burst_id   <= 0;
                burst_addr <= 0;
                burst_len  <= 0;
                burst_len_plus1 <= 0;
            end
            else if (clk_en) begin
                if (next_loop) begin
                    burst_id   <= req_id_buf;
                    burst_addr <= burst_addr_next;
                    burst_len  <= burst_len_next;
                    burst_len_plus1 <= burst_len_next + 1;
                end
            end
        end

    end
    endgenerate

endmodule




module mm2s_gmem_m_axi_reg_slice
#(parameter
    DATA_WIDTH = 8
) (
    // system signals
    input  wire                  clk,
    input  wire                  reset,
    // slave side
    input  wire [DATA_WIDTH-1:0] s_data,
    input  wire                  s_valid,
    output wire                  s_ready,
    // master side
    output wire [DATA_WIDTH-1:0] m_data,
    output wire                  m_valid,
    input  wire                  m_ready
);
//------------------------Parameter----------------------
    // state
    localparam [1:0]
        ZERO = 2'b10,
        ONE  = 2'b11,
        TWO  = 2'b01;
//------------------------Local signal-------------------
    reg  [DATA_WIDTH-1:0] data_p1;
    reg  [DATA_WIDTH-1:0] data_p2;
    wire         load_p1;
    wire         load_p2;
    wire         load_p1_from_p2;
    reg          s_ready_t;
    reg  [1:0]   state;
    reg  [1:0]   next;
//------------------------Body---------------------------
    assign s_ready = s_ready_t;
    assign m_data  = data_p1;
    assign m_valid = state[0];

    assign load_p1 = (state == ZERO && s_valid) ||
                    (state == ONE && s_valid && m_ready) ||
                    (state == TWO && m_ready);
    assign load_p2 = s_valid & s_ready;
    assign load_p1_from_p2 = (state == TWO);

    // data_p1
    always @(posedge clk) begin
        if (load_p1) begin
            if (load_p1_from_p2)
                data_p1 <= data_p2;
            else
                data_p1 <= s_data;
        end
    end

    // data_p2
    always @(posedge clk) begin
        if (load_p2) data_p2 <= s_data;
    end

    // s_ready_t
    always @(posedge clk) begin
        if (reset)
            s_ready_t <= 1'b0;
        else if (state == ZERO)
            s_ready_t <= 1'b1;
        else if (state == ONE && next == TWO)
            s_ready_t <= 1'b0;
        else if (state == TWO && next == ONE)
            s_ready_t <= 1'b1;
    end

    // state
    always @(posedge clk) begin
        if (reset)
            state <= ZERO;
        else
            state <= next;
    end

    // next
    always @(*) begin
        case (state)
            ZERO:
                if (s_valid & s_ready)
                    next = ONE;
                else
                    next = ZERO;
            ONE:
                if (~s_valid & m_ready)
                    next = ZERO;
                else if (s_valid & ~m_ready)
                    next = TWO;
                else
                    next = ONE;
            TWO:
                if (m_ready)
                    next = ONE;
                else
                    next = TWO;
            default:
                next = ZERO;
        endcase
    end
endmodule


module mm2s_gmem_m_axi_fifo
#(parameter
    MEM_STYLE   = "shiftreg",
    DATA_WIDTH = 32,
    ADDR_WIDTH = 5,
    DEPTH      = 32
) (
    // system signal
    input  wire                  clk,
    input  wire                  reset,
    input  wire                  clk_en,
    // write
    output wire                  if_full_n,
    input  wire                  if_write,
    input  wire [DATA_WIDTH-1:0] if_din,
    // read
    output wire                  if_empty_n,
    input  wire                  if_read,
    output wire [DATA_WIDTH-1:0] if_dout,
    output wire [ADDR_WIDTH:0]   if_num_data_valid);

//------------------------Local signal-------------------

    wire                  push;
    wire                  pop;
    reg                   full_n = 1'b1;
    reg                   empty_n = 1'b0;
    reg                   dout_vld = 1'b0;
//------------------------Body---------------------------

    generate if (DEPTH == 0) begin
        assign if_num_data_valid = if_write;
        assign if_full_n  = if_read;
        assign if_empty_n = if_write;
        assign if_dout = if_din;

    end else if (DEPTH == 1) begin
        reg [DATA_WIDTH-1:0] dout_reg;

        assign if_num_data_valid = dout_vld;
        assign if_full_n  = !dout_vld;
        assign if_empty_n = dout_vld;
        assign if_dout = dout_reg;
        assign push = !dout_vld & if_write;
        assign pop  = dout_vld & if_read;

        always @(posedge clk)
        begin
            if (reset == 1'b1)
                dout_reg <= 0;
            else if (clk_en) begin
                if (push)
                    dout_reg <= if_din;
            end
        end

        // dout_vld
        always @(posedge clk) begin
            if (reset == 1'b1)
                dout_vld <= 1'b0;
            else if (clk_en)
                if (push)
                    dout_vld <= 1'b1;
                else if (pop)
                    dout_vld <= 1'b0;
        end
    
    end else if (DEPTH > 1) begin
        reg  [ADDR_WIDTH-1:0] raddr = {ADDR_WIDTH{1'b0}};
        reg  [ADDR_WIDTH-1:0] waddr = {ADDR_WIDTH{1'b0}};
        reg  [ADDR_WIDTH:0]   mOutPtr = {ADDR_WIDTH+1{1'b0}};
        reg  [ADDR_WIDTH:0]   num_data_cnt = {ADDR_WIDTH+1{1'b0}};
        wire                  pop_dout;

        assign if_num_data_valid = dout_vld ? num_data_cnt : {ADDR_WIDTH+1{1'b0}};
        assign if_full_n  = full_n;
        assign if_empty_n = dout_vld;
        assign push = full_n & if_write;
        assign pop  = empty_n & (if_read | ~dout_vld);
        assign pop_dout = dout_vld & if_read;

        if (MEM_STYLE == "shiftreg") begin
            mm2s_gmem_m_axi_srl
            #(  .DATA_WIDTH     (DATA_WIDTH),
                .ADDR_WIDTH     (ADDR_WIDTH),
                .DEPTH          (DEPTH))
            U_fifo_srl(
                .clk            (clk),
                .reset          (reset),
                .clk_en         (clk_en),
                .we             (push),
                .din            (if_din),
                .raddr          (raddr),
                .re             (pop),
                .dout           (if_dout)
            );
            // raddr
            always @(posedge clk) begin
                if (reset == 1'b1)
                    raddr <= {ADDR_WIDTH+1{1'b0}};
                else if (clk_en) begin
                    if (push & ~pop & empty_n)
                        raddr <= raddr + 1'b1;
                    else if (~push & pop && raddr != 0)
                        raddr <= raddr - 1'b1;
                end
            end
        end else begin
            wire [ADDR_WIDTH-1:0] wnext;
            wire [ADDR_WIDTH-1:0] rnext;

            mm2s_gmem_m_axi_mem
            #(  .MEM_STYLE      (MEM_STYLE),
                .DATA_WIDTH     (DATA_WIDTH),
                .ADDR_WIDTH     (ADDR_WIDTH),
                .DEPTH          (DEPTH))
            U_fifo_mem(
                .clk            (clk),
                .reset          (reset),
                .clk_en         (clk_en),
                .we             (push),
                .waddr          (waddr),
                .din            (if_din),
                .raddr          (raddr),
                .re             (pop),
                .dout           (if_dout)
            );

            assign wnext =  !push                ? waddr :
                            (waddr == DEPTH - 2) ? 1'b0  :
                            waddr + 1'b1;
            assign rnext =  !pop                 ? raddr :
                            (raddr == DEPTH - 2) ? 1'b0  :
                            raddr + 1'b1;

            // waddr
            always @(posedge clk) begin
                if (reset == 1'b1)
                    waddr <= {ADDR_WIDTH{1'b0}};
                else if (clk_en)
                    waddr <= wnext;
            end

            // raddr
            always @(posedge clk) begin
                if (reset == 1'b1)
                    raddr <= {ADDR_WIDTH{1'b0}};
                else if (clk_en)
                    raddr <= rnext;
            end
        end

        // mOutPtr
        always @(posedge clk) begin
            if (reset == 1'b1)
                mOutPtr <= {ADDR_WIDTH+1{1'b0}};
            else if (clk_en)
                if (push & ~pop)
                    mOutPtr <= mOutPtr + 1'b1;
                else if (~push & pop)
                    mOutPtr <= mOutPtr - 1'b1;
        end

        // num_data_cnt
        always @(posedge clk) begin
            if (reset == 1'b1)
                num_data_cnt <= {ADDR_WIDTH+1{1'b0}};
            else if (clk_en)
                if ( push & ~pop_dout)
                    num_data_cnt <= num_data_cnt + 1'b1;
                else if (~push & pop_dout)
                    num_data_cnt <= num_data_cnt - 1'b1;
        end

        // full_n
        always @(posedge clk) begin
            if (reset == 1'b1)
                full_n <= 1'b1;
            else if (clk_en)
                if ((push & ~pop_dout) && (num_data_cnt == DEPTH - 1))
                    full_n <= 1'b0;
                else if (~push & pop_dout)
                    full_n <= 1'b1;
        end

        // empty_n
        always @(posedge clk)
        begin
            if (reset == 1'b1)
                empty_n <= 1'b0;
            else if (clk_en) begin
                if (push & ~pop)
                    empty_n <= 1'b1;
                else if ((~push & pop) && (mOutPtr == 1))
                    empty_n <= 1'b0;
            end
        end

        // dout_vld
        always @(posedge clk) begin
            if (reset == 1'b1)
                dout_vld <= 1'b0;
            else if (clk_en)
                if (pop)
                    dout_vld <= 1'b1;
                else if (pop_dout)
                    dout_vld <= 1'b0;
        end
    end
    endgenerate

endmodule

module mm2s_gmem_m_axi_srl
#(parameter
        DATA_WIDTH  = 32,
        ADDR_WIDTH  = 6,
        DEPTH       = 63
    )(
        input  wire                  clk,
        input  wire                  reset,
        input  wire                  clk_en,
        input  wire                  we,
        input  wire [DATA_WIDTH-1:0] din,
        input  wire [ADDR_WIDTH-1:0] raddr,
        input  wire                  re,
        output reg  [DATA_WIDTH-1:0] dout
    );

    reg  [DATA_WIDTH-1:0] mem[0:DEPTH-2];

    integer i;
    always @(posedge clk)
    begin
        if (clk_en & we) begin
            for (i = 0; i < DEPTH - 2; i = i + 1) begin
                mem[i+1] <= mem[i];
            end
            mem[0] <= din;
        end
    end

    always @(posedge clk)
    begin
        if (reset)
            dout <= 0;
        else if (clk_en & re) begin
            dout <= mem[raddr];
        end
    end

endmodule

module mm2s_gmem_m_axi_mem
#(parameter
    MEM_STYLE   = "auto",
    DATA_WIDTH  = 32,
    ADDR_WIDTH  = 6,
    DEPTH       = 63
)(
    input  wire                  clk,
    input  wire                  reset,
    input  wire                  clk_en,
    input  wire                  we,
    input  wire [ADDR_WIDTH-1:0] waddr,
    input  wire [DATA_WIDTH-1:0] din,
    input  wire [ADDR_WIDTH-1:0] raddr,
    input  wire                  re,
    output reg  [DATA_WIDTH-1:0] dout);

    (* ram_style = MEM_STYLE *)
    reg  [DATA_WIDTH-1:0] mem[0:DEPTH-2];

    //write to ram
    always @(posedge clk) begin
        if (clk_en & we)
            mem[waddr] <= din;
    end

    //read from ram
    always @(posedge clk) begin
        if (reset)
            dout <= 0;
        else if (clk_en & re)
            dout <= mem[raddr];
    end
endmodule
