-- ==============================================================
-- Generated by Vitis HLS v2025.1
-- Copyright 1986-2022 Xilinx, Inc. All Rights Reserved.
-- Copyright 2022-2025 Advanced Micro Devices, Inc. All Rights Reserved.
-- ==============================================================

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity mm2s is
generic (
    C_M_AXI_GMEM_ADDR_WIDTH : INTEGER := 64;
    C_M_AXI_GMEM_ID_WIDTH : INTEGER := 1;
    C_M_AXI_GMEM_AWUSER_WIDTH : INTEGER := 1;
    C_M_AXI_GMEM_DATA_WIDTH : INTEGER := 32;
    C_M_AXI_GMEM_WUSER_WIDTH : INTEGER := 1;
    C_M_AXI_GMEM_ARUSER_WIDTH : INTEGER := 1;
    C_M_AXI_GMEM_RUSER_WIDTH : INTEGER := 1;
    C_M_AXI_GMEM_BUSER_WIDTH : INTEGER := 1;
    C_S_AXI_CONTROL_ADDR_WIDTH : INTEGER := 6;
    C_S_AXI_CONTROL_DATA_WIDTH : INTEGER := 32;
    C_M_AXI_GMEM_USER_VALUE : INTEGER := 0;
    C_M_AXI_GMEM_PROT_VALUE : INTEGER := 0;
    C_M_AXI_GMEM_CACHE_VALUE : INTEGER := 3 );
port (
    ap_clk : IN STD_LOGIC;
    ap_rst_n : IN STD_LOGIC;
    s_TREADY : IN STD_LOGIC;
    m_axi_gmem_AWVALID : OUT STD_LOGIC;
    m_axi_gmem_AWREADY : IN STD_LOGIC;
    m_axi_gmem_AWADDR : OUT STD_LOGIC_VECTOR (C_M_AXI_GMEM_ADDR_WIDTH-1 downto 0);
    m_axi_gmem_AWID : OUT STD_LOGIC_VECTOR (C_M_AXI_GMEM_ID_WIDTH-1 downto 0);
    m_axi_gmem_AWLEN : OUT STD_LOGIC_VECTOR (7 downto 0);
    m_axi_gmem_AWSIZE : OUT STD_LOGIC_VECTOR (2 downto 0);
    m_axi_gmem_AWBURST : OUT STD_LOGIC_VECTOR (1 downto 0);
    m_axi_gmem_AWLOCK : OUT STD_LOGIC_VECTOR (1 downto 0);
    m_axi_gmem_AWCACHE : OUT STD_LOGIC_VECTOR (3 downto 0);
    m_axi_gmem_AWPROT : OUT STD_LOGIC_VECTOR (2 downto 0);
    m_axi_gmem_AWQOS : OUT STD_LOGIC_VECTOR (3 downto 0);
    m_axi_gmem_AWREGION : OUT STD_LOGIC_VECTOR (3 downto 0);
    m_axi_gmem_AWUSER : OUT STD_LOGIC_VECTOR (C_M_AXI_GMEM_AWUSER_WIDTH-1 downto 0);
    m_axi_gmem_WVALID : OUT STD_LOGIC;
    m_axi_gmem_WREADY : IN STD_LOGIC;
    m_axi_gmem_WDATA : OUT STD_LOGIC_VECTOR (C_M_AXI_GMEM_DATA_WIDTH-1 downto 0);
    m_axi_gmem_WSTRB : OUT STD_LOGIC_VECTOR (C_M_AXI_GMEM_DATA_WIDTH/8-1 downto 0);
    m_axi_gmem_WLAST : OUT STD_LOGIC;
    m_axi_gmem_WID : OUT STD_LOGIC_VECTOR (C_M_AXI_GMEM_ID_WIDTH-1 downto 0);
    m_axi_gmem_WUSER : OUT STD_LOGIC_VECTOR (C_M_AXI_GMEM_WUSER_WIDTH-1 downto 0);
    m_axi_gmem_ARVALID : OUT STD_LOGIC;
    m_axi_gmem_ARREADY : IN STD_LOGIC;
    m_axi_gmem_ARADDR : OUT STD_LOGIC_VECTOR (C_M_AXI_GMEM_ADDR_WIDTH-1 downto 0);
    m_axi_gmem_ARID : OUT STD_LOGIC_VECTOR (C_M_AXI_GMEM_ID_WIDTH-1 downto 0);
    m_axi_gmem_ARLEN : OUT STD_LOGIC_VECTOR (7 downto 0);
    m_axi_gmem_ARSIZE : OUT STD_LOGIC_VECTOR (2 downto 0);
    m_axi_gmem_ARBURST : OUT STD_LOGIC_VECTOR (1 downto 0);
    m_axi_gmem_ARLOCK : OUT STD_LOGIC_VECTOR (1 downto 0);
    m_axi_gmem_ARCACHE : OUT STD_LOGIC_VECTOR (3 downto 0);
    m_axi_gmem_ARPROT : OUT STD_LOGIC_VECTOR (2 downto 0);
    m_axi_gmem_ARQOS : OUT STD_LOGIC_VECTOR (3 downto 0);
    m_axi_gmem_ARREGION : OUT STD_LOGIC_VECTOR (3 downto 0);
    m_axi_gmem_ARUSER : OUT STD_LOGIC_VECTOR (C_M_AXI_GMEM_ARUSER_WIDTH-1 downto 0);
    m_axi_gmem_RVALID : IN STD_LOGIC;
    m_axi_gmem_RREADY : OUT STD_LOGIC;
    m_axi_gmem_RDATA : IN STD_LOGIC_VECTOR (C_M_AXI_GMEM_DATA_WIDTH-1 downto 0);
    m_axi_gmem_RLAST : IN STD_LOGIC;
    m_axi_gmem_RID : IN STD_LOGIC_VECTOR (C_M_AXI_GMEM_ID_WIDTH-1 downto 0);
    m_axi_gmem_RUSER : IN STD_LOGIC_VECTOR (C_M_AXI_GMEM_RUSER_WIDTH-1 downto 0);
    m_axi_gmem_RRESP : IN STD_LOGIC_VECTOR (1 downto 0);
    m_axi_gmem_BVALID : IN STD_LOGIC;
    m_axi_gmem_BREADY : OUT STD_LOGIC;
    m_axi_gmem_BRESP : IN STD_LOGIC_VECTOR (1 downto 0);
    m_axi_gmem_BID : IN STD_LOGIC_VECTOR (C_M_AXI_GMEM_ID_WIDTH-1 downto 0);
    m_axi_gmem_BUSER : IN STD_LOGIC_VECTOR (C_M_AXI_GMEM_BUSER_WIDTH-1 downto 0);
    s_TDATA : OUT STD_LOGIC_VECTOR (31 downto 0);
    s_TVALID : OUT STD_LOGIC;
    s_TKEEP : OUT STD_LOGIC_VECTOR (3 downto 0);
    s_TSTRB : OUT STD_LOGIC_VECTOR (3 downto 0);
    s_TLAST : OUT STD_LOGIC_VECTOR (0 downto 0);
    s_axi_control_AWVALID : IN STD_LOGIC;
    s_axi_control_AWREADY : OUT STD_LOGIC;
    s_axi_control_AWADDR : IN STD_LOGIC_VECTOR (C_S_AXI_CONTROL_ADDR_WIDTH-1 downto 0);
    s_axi_control_WVALID : IN STD_LOGIC;
    s_axi_control_WREADY : OUT STD_LOGIC;
    s_axi_control_WDATA : IN STD_LOGIC_VECTOR (C_S_AXI_CONTROL_DATA_WIDTH-1 downto 0);
    s_axi_control_WSTRB : IN STD_LOGIC_VECTOR (C_S_AXI_CONTROL_DATA_WIDTH/8-1 downto 0);
    s_axi_control_ARVALID : IN STD_LOGIC;
    s_axi_control_ARREADY : OUT STD_LOGIC;
    s_axi_control_ARADDR : IN STD_LOGIC_VECTOR (C_S_AXI_CONTROL_ADDR_WIDTH-1 downto 0);
    s_axi_control_RVALID : OUT STD_LOGIC;
    s_axi_control_RREADY : IN STD_LOGIC;
    s_axi_control_RDATA : OUT STD_LOGIC_VECTOR (C_S_AXI_CONTROL_DATA_WIDTH-1 downto 0);
    s_axi_control_RRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
    s_axi_control_BVALID : OUT STD_LOGIC;
    s_axi_control_BREADY : IN STD_LOGIC;
    s_axi_control_BRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
    interrupt : OUT STD_LOGIC );
end;


architecture behav of mm2s is 
    attribute CORE_GENERATION_INFO : STRING;
    attribute CORE_GENERATION_INFO of behav : architecture is
    "mm2s_mm2s,hls_ip_2025_1,{HLS_INPUT_TYPE=cxx,HLS_INPUT_FLOAT=0,HLS_INPUT_FIXED=0,HLS_INPUT_PART=xcvc1902-vsva2197-2MP-e-S,HLS_INPUT_CLOCK=8.000000,HLS_INPUT_ARCH=others,HLS_SYN_CLOCK=7.040000,HLS_SYN_LAT=-1,HLS_SYN_TPT=none,HLS_SYN_MEM=1,HLS_SYN_DSP=0,HLS_SYN_FF=1419,HLS_SYN_LUT=1416,HLS_VERSION=2025_1}";
    constant ap_const_logic_1 : STD_LOGIC := '1';
    constant ap_const_logic_0 : STD_LOGIC := '0';
    constant ap_ST_fsm_pp0_stage0 : STD_LOGIC_VECTOR (0 downto 0) := "1";
    constant ap_const_lv32_0 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000000000";
    constant ap_const_boolean_1 : BOOLEAN := true;
    constant ap_const_lv1_1 : STD_LOGIC_VECTOR (0 downto 0) := "1";
    constant ap_const_boolean_0 : BOOLEAN := false;
    constant ap_const_lv1_0 : STD_LOGIC_VECTOR (0 downto 0) := "0";
    constant C_S_AXI_DATA_WIDTH : INTEGER := 32;
    constant C_M_AXI_DATA_WIDTH : INTEGER := 32;
    constant ap_const_lv4_0 : STD_LOGIC_VECTOR (3 downto 0) := "0000";
    constant ap_const_lv31_0 : STD_LOGIC_VECTOR (30 downto 0) := "0000000000000000000000000000000";
    constant ap_const_lv31_1 : STD_LOGIC_VECTOR (30 downto 0) := "0000000000000000000000000000001";
    constant ap_const_lv32_2 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000000010";
    constant ap_const_lv32_3F : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000111111";
    constant ap_const_lv64_0 : STD_LOGIC_VECTOR (63 downto 0) := "0000000000000000000000000000000000000000000000000000000000000000";

attribute shreg_extract : string;
    signal ap_rst_reg_2 : STD_LOGIC := '1';
attribute shreg_extract of ap_rst_reg_2 : signal is "no";
    signal ap_rst_reg_1 : STD_LOGIC := '1';
attribute shreg_extract of ap_rst_reg_1 : signal is "no";
    signal ap_rst_n_inv : STD_LOGIC := '1';
attribute shreg_extract of ap_rst_n_inv : signal is "no";
    signal ap_start : STD_LOGIC;
    signal ap_done : STD_LOGIC;
    signal ap_continue : STD_LOGIC;
    signal ap_idle : STD_LOGIC;
    signal ap_CS_fsm : STD_LOGIC_VECTOR (0 downto 0) := "1";
    attribute fsm_encoding : string;
    attribute fsm_encoding of ap_CS_fsm : signal is "none";
    signal ap_CS_fsm_pp0_stage0 : STD_LOGIC;
    attribute fsm_encoding of ap_CS_fsm_pp0_stage0 : signal is "none";
    signal ap_enable_reg_pp0_iter0 : STD_LOGIC;
    signal ap_enable_reg_pp0_iter1 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter2 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter3 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter4 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter5 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter6 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter7 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter8 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter9 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter10 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter11 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter12 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter13 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter14 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter15 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter16 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter17 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter18 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter19 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter20 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter21 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter22 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter23 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter24 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter25 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter26 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter27 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter28 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter29 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter30 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter31 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter32 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter33 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter34 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter35 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter36 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter37 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter38 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter39 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter40 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter41 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter42 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter43 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter44 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter45 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter46 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter47 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter48 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter49 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter50 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter51 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter52 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter53 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter54 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter55 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter56 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter57 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter58 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter59 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter60 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter61 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter62 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter63 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter64 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter65 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter66 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter67 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter68 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter69 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter70 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter71 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter72 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter73 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter74 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter75 : STD_LOGIC := '0';
    signal ap_enable_reg_pp0_iter76 : STD_LOGIC := '0';
    signal ap_idle_pp0 : STD_LOGIC;
    signal ap_ready : STD_LOGIC;
    signal gmem_0_AWREADY : STD_LOGIC;
    signal gmem_0_WREADY : STD_LOGIC;
    signal gmem_0_ARVALID : STD_LOGIC;
    signal gmem_0_ARREADY : STD_LOGIC;
    signal gmem_0_ARLEN : STD_LOGIC_VECTOR (31 downto 0);
    signal gmem_0_RVALID : STD_LOGIC;
    signal gmem_0_RREADY : STD_LOGIC;
    signal gmem_0_RDATA : STD_LOGIC_VECTOR (31 downto 0);
    signal gmem_0_RFIFONUM : STD_LOGIC_VECTOR (8 downto 0);
    signal gmem_0_BVALID : STD_LOGIC;
    signal ap_done_reg : STD_LOGIC := '0';
    signal ap_block_state1_pp0_stage0_iter0 : BOOLEAN;
    signal first_iter_0_reg_147 : STD_LOGIC_VECTOR (0 downto 0);
    signal ap_block_state2_io_grp1 : BOOLEAN;
    signal ap_block_pp0_stage0_subdone_grp1_done_reg : BOOLEAN := false;
    signal ap_block_pp0_stage0_subdone_grp1 : BOOLEAN;
    signal ap_block_pp0_stage0_subdone : BOOLEAN;
    signal icmp_ln37_1_reg_257 : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter74_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal ap_block_state76_pp0_stage0_iter75_grp1 : BOOLEAN;
    signal regslice_both_s_V_data_V_U_apdone_blk : STD_LOGIC;
    signal icmp_ln37_1_reg_257_pp0_iter75_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal ap_block_state77_pp0_stage0_iter76_grp1 : BOOLEAN;
    signal ap_loop_exit_ready : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter75_reg : STD_LOGIC;
    signal icmp_ln37_1_fu_193_p2 : STD_LOGIC_VECTOR (0 downto 0);
    signal ap_condition_exit_pp0_iter0_stage0 : STD_LOGIC;
    signal ap_ready_int : STD_LOGIC;
    signal mem : STD_LOGIC_VECTOR (63 downto 0);
    signal size : STD_LOGIC_VECTOR (31 downto 0);
    signal gmem_blk_n_AR : STD_LOGIC;
    signal ap_block_pp0_stage0_grp1 : BOOLEAN;
    signal gmem_blk_n_R : STD_LOGIC;
    signal s_TDATA_blk_n : STD_LOGIC;
    signal ap_block_pp0_stage0_11001 : BOOLEAN;
    signal mem_read_reg_246 : STD_LOGIC_VECTOR (63 downto 0);
    signal ap_block_pp0_stage0_11001_grp1 : BOOLEAN;
    signal ap_block_pp0_stage0_subdone_grp1_done_reg_iter0 : BOOLEAN := false;
    signal zext_ln37_fu_177_p1 : STD_LOGIC_VECTOR (63 downto 0);
    signal zext_ln37_reg_251 : STD_LOGIC_VECTOR (63 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter1_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter2_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter3_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter4_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter5_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter6_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter7_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter8_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter9_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter10_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter11_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter12_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter13_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter14_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter15_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter16_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter17_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter18_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter19_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter20_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter21_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter22_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter23_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter24_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter25_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter26_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter27_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter28_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter29_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter30_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter31_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter32_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter33_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter34_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter35_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter36_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter37_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter38_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter39_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter40_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter41_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter42_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter43_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter44_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter45_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter46_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter47_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter48_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter49_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter50_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter51_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter52_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter53_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter54_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter55_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter56_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter57_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter58_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter59_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter60_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter61_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter62_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter63_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter64_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter65_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter66_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter67_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter68_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter69_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter70_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter71_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter72_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln37_1_reg_257_pp0_iter73_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal ap_block_pp0_stage0 : BOOLEAN;
    signal ap_loop_init : STD_LOGIC;
    signal sext_ln37_fu_219_p1 : STD_LOGIC_VECTOR (63 downto 0);
    signal i_fu_100 : STD_LOGIC_VECTOR (30 downto 0) := "0000000000000000000000000000000";
    signal add_ln37_fu_199_p2 : STD_LOGIC_VECTOR (30 downto 0);
    signal ap_sig_allocacmp_i_load : STD_LOGIC_VECTOR (30 downto 0);
    signal ap_block_pp0_stage0_01001_grp1 : BOOLEAN;
    signal icmp_ln37_fu_159_p2 : STD_LOGIC_VECTOR (0 downto 0);
    signal trunc_ln37_fu_165_p1 : STD_LOGIC_VECTOR (30 downto 0);
    signal empty_fu_169_p3 : STD_LOGIC_VECTOR (30 downto 0);
    signal i_cast_fu_189_p1 : STD_LOGIC_VECTOR (31 downto 0);
    signal trunc_ln_fu_210_p4 : STD_LOGIC_VECTOR (61 downto 0);
    signal ap_continue_int : STD_LOGIC;
    signal ap_done_int : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter1_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter2_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter3_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter4_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter5_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter6_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter7_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter8_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter9_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter10_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter11_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter12_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter13_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter14_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter15_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter16_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter17_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter18_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter19_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter20_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter21_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter22_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter23_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter24_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter25_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter26_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter27_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter28_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter29_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter30_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter31_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter32_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter33_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter34_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter35_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter36_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter37_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter38_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter39_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter40_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter41_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter42_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter43_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter44_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter45_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter46_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter47_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter48_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter49_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter50_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter51_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter52_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter53_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter54_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter55_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter56_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter57_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter58_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter59_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter60_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter61_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter62_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter63_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter64_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter65_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter66_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter67_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter68_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter69_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter70_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter71_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter72_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter73_reg : STD_LOGIC;
    signal ap_loop_exit_ready_pp0_iter74_reg : STD_LOGIC;
    signal ap_NS_fsm : STD_LOGIC_VECTOR (0 downto 0);
    signal ap_enable_pp0 : STD_LOGIC;
    signal ap_start_int : STD_LOGIC;
    signal ap_ready_sig : STD_LOGIC;
    signal ap_done_sig : STD_LOGIC;
    signal s_TVALID_int_regslice : STD_LOGIC;
    signal s_TREADY_int_regslice : STD_LOGIC;
    signal regslice_both_s_V_data_V_U_vld_out : STD_LOGIC;
    signal regslice_both_s_V_keep_V_U_apdone_blk : STD_LOGIC;
    signal s_TKEEP_int_regslice : STD_LOGIC_VECTOR (3 downto 0);
    signal regslice_both_s_V_keep_V_U_ack_in_dummy : STD_LOGIC;
    signal regslice_both_s_V_keep_V_U_vld_out : STD_LOGIC;
    signal regslice_both_s_V_strb_V_U_apdone_blk : STD_LOGIC;
    signal s_TSTRB_int_regslice : STD_LOGIC_VECTOR (3 downto 0);
    signal regslice_both_s_V_strb_V_U_ack_in_dummy : STD_LOGIC;
    signal regslice_both_s_V_strb_V_U_vld_out : STD_LOGIC;
    signal regslice_both_s_V_last_V_U_apdone_blk : STD_LOGIC;
    signal s_TLAST_int_regslice : STD_LOGIC_VECTOR (0 downto 0);
    signal regslice_both_s_V_last_V_U_ack_in_dummy : STD_LOGIC;
    signal regslice_both_s_V_last_V_U_vld_out : STD_LOGIC;
    signal ap_condition_1139 : BOOLEAN;
    signal ap_condition_869 : BOOLEAN;
    signal ap_ce_reg : STD_LOGIC;

    component mm2s_control_s_axi IS
    generic (
        C_S_AXI_ADDR_WIDTH : INTEGER;
        C_S_AXI_DATA_WIDTH : INTEGER );
    port (
        AWVALID : IN STD_LOGIC;
        AWREADY : OUT STD_LOGIC;
        AWADDR : IN STD_LOGIC_VECTOR (C_S_AXI_ADDR_WIDTH-1 downto 0);
        WVALID : IN STD_LOGIC;
        WREADY : OUT STD_LOGIC;
        WDATA : IN STD_LOGIC_VECTOR (C_S_AXI_DATA_WIDTH-1 downto 0);
        WSTRB : IN STD_LOGIC_VECTOR (C_S_AXI_DATA_WIDTH/8-1 downto 0);
        ARVALID : IN STD_LOGIC;
        ARREADY : OUT STD_LOGIC;
        ARADDR : IN STD_LOGIC_VECTOR (C_S_AXI_ADDR_WIDTH-1 downto 0);
        RVALID : OUT STD_LOGIC;
        RREADY : IN STD_LOGIC;
        RDATA : OUT STD_LOGIC_VECTOR (C_S_AXI_DATA_WIDTH-1 downto 0);
        RRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
        BVALID : OUT STD_LOGIC;
        BREADY : IN STD_LOGIC;
        BRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
        ACLK : IN STD_LOGIC;
        ARESET : IN STD_LOGIC;
        ACLK_EN : IN STD_LOGIC;
        mem : OUT STD_LOGIC_VECTOR (63 downto 0);
        size : OUT STD_LOGIC_VECTOR (31 downto 0);
        ap_start : OUT STD_LOGIC;
        interrupt : OUT STD_LOGIC;
        ap_ready : IN STD_LOGIC;
        ap_done : IN STD_LOGIC;
        ap_continue : OUT STD_LOGIC;
        ap_idle : IN STD_LOGIC );
    end component;


    component mm2s_gmem_m_axi IS
    generic (
        CONSERVATIVE : INTEGER;
        USER_MAXREQS : INTEGER;
        MAX_READ_BURST_LENGTH : INTEGER;
        MAX_WRITE_BURST_LENGTH : INTEGER;
        C_M_AXI_ID_WIDTH : INTEGER;
        C_M_AXI_ADDR_WIDTH : INTEGER;
        C_M_AXI_DATA_WIDTH : INTEGER;
        C_M_AXI_AWUSER_WIDTH : INTEGER;
        C_M_AXI_ARUSER_WIDTH : INTEGER;
        C_M_AXI_WUSER_WIDTH : INTEGER;
        C_M_AXI_RUSER_WIDTH : INTEGER;
        C_M_AXI_BUSER_WIDTH : INTEGER;
        C_USER_VALUE : INTEGER;
        C_PROT_VALUE : INTEGER;
        C_CACHE_VALUE : INTEGER;
        CH0_NUM_READ_OUTSTANDING : INTEGER;
        CH0_NUM_WRITE_OUTSTANDING : INTEGER;
        CH0_USER_RFIFONUM_WIDTH : INTEGER;
        CH0_USER_DW : INTEGER;
        CH0_USER_AW : INTEGER;
        NUM_READ_OUTSTANDING : INTEGER;
        NUM_WRITE_OUTSTANDING : INTEGER );
    port (
        AWVALID : OUT STD_LOGIC;
        AWREADY : IN STD_LOGIC;
        AWADDR : OUT STD_LOGIC_VECTOR (C_M_AXI_ADDR_WIDTH-1 downto 0);
        AWID : OUT STD_LOGIC_VECTOR (C_M_AXI_ID_WIDTH-1 downto 0);
        AWLEN : OUT STD_LOGIC_VECTOR (7 downto 0);
        AWSIZE : OUT STD_LOGIC_VECTOR (2 downto 0);
        AWBURST : OUT STD_LOGIC_VECTOR (1 downto 0);
        AWLOCK : OUT STD_LOGIC_VECTOR (1 downto 0);
        AWCACHE : OUT STD_LOGIC_VECTOR (3 downto 0);
        AWPROT : OUT STD_LOGIC_VECTOR (2 downto 0);
        AWQOS : OUT STD_LOGIC_VECTOR (3 downto 0);
        AWREGION : OUT STD_LOGIC_VECTOR (3 downto 0);
        AWUSER : OUT STD_LOGIC_VECTOR (C_M_AXI_AWUSER_WIDTH-1 downto 0);
        WVALID : OUT STD_LOGIC;
        WREADY : IN STD_LOGIC;
        WDATA : OUT STD_LOGIC_VECTOR (C_M_AXI_DATA_WIDTH-1 downto 0);
        WSTRB : OUT STD_LOGIC_VECTOR (C_M_AXI_DATA_WIDTH/8-1 downto 0);
        WLAST : OUT STD_LOGIC;
        WID : OUT STD_LOGIC_VECTOR (C_M_AXI_ID_WIDTH-1 downto 0);
        WUSER : OUT STD_LOGIC_VECTOR (C_M_AXI_WUSER_WIDTH-1 downto 0);
        ARVALID : OUT STD_LOGIC;
        ARREADY : IN STD_LOGIC;
        ARADDR : OUT STD_LOGIC_VECTOR (C_M_AXI_ADDR_WIDTH-1 downto 0);
        ARID : OUT STD_LOGIC_VECTOR (C_M_AXI_ID_WIDTH-1 downto 0);
        ARLEN : OUT STD_LOGIC_VECTOR (7 downto 0);
        ARSIZE : OUT STD_LOGIC_VECTOR (2 downto 0);
        ARBURST : OUT STD_LOGIC_VECTOR (1 downto 0);
        ARLOCK : OUT STD_LOGIC_VECTOR (1 downto 0);
        ARCACHE : OUT STD_LOGIC_VECTOR (3 downto 0);
        ARPROT : OUT STD_LOGIC_VECTOR (2 downto 0);
        ARQOS : OUT STD_LOGIC_VECTOR (3 downto 0);
        ARREGION : OUT STD_LOGIC_VECTOR (3 downto 0);
        ARUSER : OUT STD_LOGIC_VECTOR (C_M_AXI_ARUSER_WIDTH-1 downto 0);
        RVALID : IN STD_LOGIC;
        RREADY : OUT STD_LOGIC;
        RDATA : IN STD_LOGIC_VECTOR (C_M_AXI_DATA_WIDTH-1 downto 0);
        RLAST : IN STD_LOGIC;
        RID : IN STD_LOGIC_VECTOR (C_M_AXI_ID_WIDTH-1 downto 0);
        RUSER : IN STD_LOGIC_VECTOR (C_M_AXI_RUSER_WIDTH-1 downto 0);
        RRESP : IN STD_LOGIC_VECTOR (1 downto 0);
        BVALID : IN STD_LOGIC;
        BREADY : OUT STD_LOGIC;
        BRESP : IN STD_LOGIC_VECTOR (1 downto 0);
        BID : IN STD_LOGIC_VECTOR (C_M_AXI_ID_WIDTH-1 downto 0);
        BUSER : IN STD_LOGIC_VECTOR (C_M_AXI_BUSER_WIDTH-1 downto 0);
        ACLK : IN STD_LOGIC;
        ARESET : IN STD_LOGIC;
        ACLK_EN : IN STD_LOGIC;
        I_CH0_ARVALID : IN STD_LOGIC;
        I_CH0_ARREADY : OUT STD_LOGIC;
        I_CH0_ARADDR : IN STD_LOGIC_VECTOR (63 downto 0);
        I_CH0_ARLEN : IN STD_LOGIC_VECTOR (31 downto 0);
        I_CH0_RVALID : OUT STD_LOGIC;
        I_CH0_RREADY : IN STD_LOGIC;
        I_CH0_RDATA : OUT STD_LOGIC_VECTOR (31 downto 0);
        I_CH0_RFIFONUM : OUT STD_LOGIC_VECTOR (8 downto 0);
        I_CH0_AWVALID : IN STD_LOGIC;
        I_CH0_AWREADY : OUT STD_LOGIC;
        I_CH0_AWADDR : IN STD_LOGIC_VECTOR (63 downto 0);
        I_CH0_AWLEN : IN STD_LOGIC_VECTOR (31 downto 0);
        I_CH0_WVALID : IN STD_LOGIC;
        I_CH0_WREADY : OUT STD_LOGIC;
        I_CH0_WDATA : IN STD_LOGIC_VECTOR (31 downto 0);
        I_CH0_WSTRB : IN STD_LOGIC_VECTOR (3 downto 0);
        I_CH0_BVALID : OUT STD_LOGIC;
        I_CH0_BREADY : IN STD_LOGIC );
    end component;


    component mm2s_flow_control_loop_pipe IS
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        ap_start : IN STD_LOGIC;
        ap_ready : OUT STD_LOGIC;
        ap_done : OUT STD_LOGIC;
        ap_start_int : OUT STD_LOGIC;
        ap_loop_init : OUT STD_LOGIC;
        ap_ready_int : IN STD_LOGIC;
        ap_loop_exit_ready : IN STD_LOGIC;
        ap_loop_exit_done : IN STD_LOGIC;
        ap_continue_int : OUT STD_LOGIC;
        ap_done_int : IN STD_LOGIC;
        ap_continue : IN STD_LOGIC );
    end component;


    component mm2s_regslice_both IS
    generic (
        DataWidth : INTEGER );
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        data_in : IN STD_LOGIC_VECTOR (DataWidth-1 downto 0);
        vld_in : IN STD_LOGIC;
        ack_in : OUT STD_LOGIC;
        data_out : OUT STD_LOGIC_VECTOR (DataWidth-1 downto 0);
        vld_out : OUT STD_LOGIC;
        ack_out : IN STD_LOGIC;
        apdone_blk : OUT STD_LOGIC );
    end component;



begin
    control_s_axi_U : component mm2s_control_s_axi
    generic map (
        C_S_AXI_ADDR_WIDTH => C_S_AXI_CONTROL_ADDR_WIDTH,
        C_S_AXI_DATA_WIDTH => C_S_AXI_CONTROL_DATA_WIDTH)
    port map (
        AWVALID => s_axi_control_AWVALID,
        AWREADY => s_axi_control_AWREADY,
        AWADDR => s_axi_control_AWADDR,
        WVALID => s_axi_control_WVALID,
        WREADY => s_axi_control_WREADY,
        WDATA => s_axi_control_WDATA,
        WSTRB => s_axi_control_WSTRB,
        ARVALID => s_axi_control_ARVALID,
        ARREADY => s_axi_control_ARREADY,
        ARADDR => s_axi_control_ARADDR,
        RVALID => s_axi_control_RVALID,
        RREADY => s_axi_control_RREADY,
        RDATA => s_axi_control_RDATA,
        RRESP => s_axi_control_RRESP,
        BVALID => s_axi_control_BVALID,
        BREADY => s_axi_control_BREADY,
        BRESP => s_axi_control_BRESP,
        ACLK => ap_clk,
        ARESET => ap_rst_n_inv,
        ACLK_EN => ap_const_logic_1,
        mem => mem,
        size => size,
        ap_start => ap_start,
        interrupt => interrupt,
        ap_ready => ap_ready,
        ap_done => ap_done,
        ap_continue => ap_continue,
        ap_idle => ap_idle);

    gmem_m_axi_U : component mm2s_gmem_m_axi
    generic map (
        CONSERVATIVE => 1,
        USER_MAXREQS => 73,
        MAX_READ_BURST_LENGTH => 16,
        MAX_WRITE_BURST_LENGTH => 16,
        C_M_AXI_ID_WIDTH => C_M_AXI_GMEM_ID_WIDTH,
        C_M_AXI_ADDR_WIDTH => C_M_AXI_GMEM_ADDR_WIDTH,
        C_M_AXI_DATA_WIDTH => C_M_AXI_GMEM_DATA_WIDTH,
        C_M_AXI_AWUSER_WIDTH => C_M_AXI_GMEM_AWUSER_WIDTH,
        C_M_AXI_ARUSER_WIDTH => C_M_AXI_GMEM_ARUSER_WIDTH,
        C_M_AXI_WUSER_WIDTH => C_M_AXI_GMEM_WUSER_WIDTH,
        C_M_AXI_RUSER_WIDTH => C_M_AXI_GMEM_RUSER_WIDTH,
        C_M_AXI_BUSER_WIDTH => C_M_AXI_GMEM_BUSER_WIDTH,
        C_USER_VALUE => C_M_AXI_GMEM_USER_VALUE,
        C_PROT_VALUE => C_M_AXI_GMEM_PROT_VALUE,
        C_CACHE_VALUE => C_M_AXI_GMEM_CACHE_VALUE,
        CH0_NUM_READ_OUTSTANDING => 16,
        CH0_NUM_WRITE_OUTSTANDING => 16,
        CH0_USER_RFIFONUM_WIDTH => 9,
        CH0_USER_DW => 32,
        CH0_USER_AW => 64,
        NUM_READ_OUTSTANDING => 16,
        NUM_WRITE_OUTSTANDING => 0)
    port map (
        AWVALID => m_axi_gmem_AWVALID,
        AWREADY => m_axi_gmem_AWREADY,
        AWADDR => m_axi_gmem_AWADDR,
        AWID => m_axi_gmem_AWID,
        AWLEN => m_axi_gmem_AWLEN,
        AWSIZE => m_axi_gmem_AWSIZE,
        AWBURST => m_axi_gmem_AWBURST,
        AWLOCK => m_axi_gmem_AWLOCK,
        AWCACHE => m_axi_gmem_AWCACHE,
        AWPROT => m_axi_gmem_AWPROT,
        AWQOS => m_axi_gmem_AWQOS,
        AWREGION => m_axi_gmem_AWREGION,
        AWUSER => m_axi_gmem_AWUSER,
        WVALID => m_axi_gmem_WVALID,
        WREADY => m_axi_gmem_WREADY,
        WDATA => m_axi_gmem_WDATA,
        WSTRB => m_axi_gmem_WSTRB,
        WLAST => m_axi_gmem_WLAST,
        WID => m_axi_gmem_WID,
        WUSER => m_axi_gmem_WUSER,
        ARVALID => m_axi_gmem_ARVALID,
        ARREADY => m_axi_gmem_ARREADY,
        ARADDR => m_axi_gmem_ARADDR,
        ARID => m_axi_gmem_ARID,
        ARLEN => m_axi_gmem_ARLEN,
        ARSIZE => m_axi_gmem_ARSIZE,
        ARBURST => m_axi_gmem_ARBURST,
        ARLOCK => m_axi_gmem_ARLOCK,
        ARCACHE => m_axi_gmem_ARCACHE,
        ARPROT => m_axi_gmem_ARPROT,
        ARQOS => m_axi_gmem_ARQOS,
        ARREGION => m_axi_gmem_ARREGION,
        ARUSER => m_axi_gmem_ARUSER,
        RVALID => m_axi_gmem_RVALID,
        RREADY => m_axi_gmem_RREADY,
        RDATA => m_axi_gmem_RDATA,
        RLAST => m_axi_gmem_RLAST,
        RID => m_axi_gmem_RID,
        RUSER => m_axi_gmem_RUSER,
        RRESP => m_axi_gmem_RRESP,
        BVALID => m_axi_gmem_BVALID,
        BREADY => m_axi_gmem_BREADY,
        BRESP => m_axi_gmem_BRESP,
        BID => m_axi_gmem_BID,
        BUSER => m_axi_gmem_BUSER,
        ACLK => ap_clk,
        ARESET => ap_rst_n_inv,
        ACLK_EN => ap_const_logic_1,
        I_CH0_ARVALID => gmem_0_ARVALID,
        I_CH0_ARREADY => gmem_0_ARREADY,
        I_CH0_ARADDR => sext_ln37_fu_219_p1,
        I_CH0_ARLEN => gmem_0_ARLEN,
        I_CH0_RVALID => gmem_0_RVALID,
        I_CH0_RREADY => gmem_0_RREADY,
        I_CH0_RDATA => gmem_0_RDATA,
        I_CH0_RFIFONUM => gmem_0_RFIFONUM,
        I_CH0_AWVALID => ap_const_logic_0,
        I_CH0_AWREADY => gmem_0_AWREADY,
        I_CH0_AWADDR => ap_const_lv64_0,
        I_CH0_AWLEN => ap_const_lv32_0,
        I_CH0_WVALID => ap_const_logic_0,
        I_CH0_WREADY => gmem_0_WREADY,
        I_CH0_WDATA => ap_const_lv32_0,
        I_CH0_WSTRB => ap_const_lv4_0,
        I_CH0_BVALID => gmem_0_BVALID,
        I_CH0_BREADY => ap_const_logic_0);

    flow_control_loop_pipe_U : component mm2s_flow_control_loop_pipe
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        ap_start => ap_start,
        ap_ready => ap_ready_sig,
        ap_done => ap_done_sig,
        ap_start_int => ap_start_int,
        ap_loop_init => ap_loop_init,
        ap_ready_int => ap_ready_int,
        ap_loop_exit_ready => ap_condition_exit_pp0_iter0_stage0,
        ap_loop_exit_done => ap_done_int,
        ap_continue_int => ap_continue_int,
        ap_done_int => ap_done_int,
        ap_continue => ap_continue);

    regslice_both_s_V_data_V_U : component mm2s_regslice_both
    generic map (
        DataWidth => 32)
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        data_in => gmem_0_RDATA,
        vld_in => s_TVALID_int_regslice,
        ack_in => s_TREADY_int_regslice,
        data_out => s_TDATA,
        vld_out => regslice_both_s_V_data_V_U_vld_out,
        ack_out => s_TREADY,
        apdone_blk => regslice_both_s_V_data_V_U_apdone_blk);

    regslice_both_s_V_keep_V_U : component mm2s_regslice_both
    generic map (
        DataWidth => 4)
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        data_in => s_TKEEP_int_regslice,
        vld_in => s_TVALID_int_regslice,
        ack_in => regslice_both_s_V_keep_V_U_ack_in_dummy,
        data_out => s_TKEEP,
        vld_out => regslice_both_s_V_keep_V_U_vld_out,
        ack_out => s_TREADY,
        apdone_blk => regslice_both_s_V_keep_V_U_apdone_blk);

    regslice_both_s_V_strb_V_U : component mm2s_regslice_both
    generic map (
        DataWidth => 4)
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        data_in => s_TSTRB_int_regslice,
        vld_in => s_TVALID_int_regslice,
        ack_in => regslice_both_s_V_strb_V_U_ack_in_dummy,
        data_out => s_TSTRB,
        vld_out => regslice_both_s_V_strb_V_U_vld_out,
        ack_out => s_TREADY,
        apdone_blk => regslice_both_s_V_strb_V_U_apdone_blk);

    regslice_both_s_V_last_V_U : component mm2s_regslice_both
    generic map (
        DataWidth => 1)
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        data_in => s_TLAST_int_regslice,
        vld_in => s_TVALID_int_regslice,
        ack_in => regslice_both_s_V_last_V_U_ack_in_dummy,
        data_out => s_TLAST,
        vld_out => regslice_both_s_V_last_V_U_vld_out,
        ack_out => s_TREADY,
        apdone_blk => regslice_both_s_V_last_V_U_apdone_blk);





    ap_CS_fsm_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_CS_fsm <= ap_ST_fsm_pp0_stage0;
            else
                ap_CS_fsm <= ap_NS_fsm;
            end if;
        end if;
    end process;


    ap_block_pp0_stage0_subdone_grp1_done_reg_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_block_pp0_stage0_subdone_grp1_done_reg <= ap_const_boolean_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_block_pp0_stage0_subdone_grp1_done_reg <= ap_const_boolean_0;
                elsif ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone_grp1)) then 
                    ap_block_pp0_stage0_subdone_grp1_done_reg <= ap_const_boolean_1;
                end if; 
            end if;
        end if;
    end process;


    ap_block_pp0_stage0_subdone_grp1_done_reg_iter0_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_block_pp0_stage0_subdone_grp1_done_reg_iter0 <= ap_const_boolean_0;
            else
                if ((ap_start_int = ap_const_logic_1)) then
                    if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                        ap_block_pp0_stage0_subdone_grp1_done_reg_iter0 <= ap_const_boolean_0;
                    elsif ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone_grp1)) then 
                        ap_block_pp0_stage0_subdone_grp1_done_reg_iter0 <= ap_const_boolean_1;
                    end if;
                end if; 
            end if;
        end if;
    end process;


    ap_done_reg_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_done_reg <= ap_const_logic_0;
            else
                if ((ap_continue_int = ap_const_logic_1)) then 
                    ap_done_reg <= ap_const_logic_0;
                elsif (((ap_loop_exit_ready_pp0_iter75_reg = ap_const_logic_1) and (ap_const_boolean_0 = ap_block_pp0_stage0_subdone))) then 
                    ap_done_reg <= ap_const_logic_1;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter1_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter1 <= ap_const_logic_0;
            else
                if ((ap_const_logic_1 = ap_condition_exit_pp0_iter0_stage0)) then 
                    ap_enable_reg_pp0_iter1 <= ap_const_logic_0;
                elsif (((ap_const_boolean_0 = ap_block_pp0_stage0_subdone) and (ap_const_logic_1 = ap_CS_fsm_pp0_stage0))) then 
                    ap_enable_reg_pp0_iter1 <= ap_start_int;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter10_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter10 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter10 <= ap_enable_reg_pp0_iter9;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter11_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter11 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter11 <= ap_enable_reg_pp0_iter10;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter12_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter12 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter12 <= ap_enable_reg_pp0_iter11;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter13_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter13 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter13 <= ap_enable_reg_pp0_iter12;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter14_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter14 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter14 <= ap_enable_reg_pp0_iter13;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter15_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter15 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter15 <= ap_enable_reg_pp0_iter14;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter16_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter16 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter16 <= ap_enable_reg_pp0_iter15;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter17_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter17 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter17 <= ap_enable_reg_pp0_iter16;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter18_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter18 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter18 <= ap_enable_reg_pp0_iter17;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter19_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter19 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter19 <= ap_enable_reg_pp0_iter18;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter2_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter2 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter2 <= ap_enable_reg_pp0_iter1;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter20_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter20 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter20 <= ap_enable_reg_pp0_iter19;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter21_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter21 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter21 <= ap_enable_reg_pp0_iter20;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter22_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter22 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter22 <= ap_enable_reg_pp0_iter21;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter23_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter23 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter23 <= ap_enable_reg_pp0_iter22;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter24_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter24 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter24 <= ap_enable_reg_pp0_iter23;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter25_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter25 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter25 <= ap_enable_reg_pp0_iter24;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter26_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter26 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter26 <= ap_enable_reg_pp0_iter25;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter27_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter27 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter27 <= ap_enable_reg_pp0_iter26;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter28_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter28 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter28 <= ap_enable_reg_pp0_iter27;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter29_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter29 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter29 <= ap_enable_reg_pp0_iter28;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter3_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter3 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter3 <= ap_enable_reg_pp0_iter2;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter30_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter30 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter30 <= ap_enable_reg_pp0_iter29;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter31_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter31 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter31 <= ap_enable_reg_pp0_iter30;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter32_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter32 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter32 <= ap_enable_reg_pp0_iter31;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter33_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter33 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter33 <= ap_enable_reg_pp0_iter32;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter34_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter34 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter34 <= ap_enable_reg_pp0_iter33;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter35_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter35 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter35 <= ap_enable_reg_pp0_iter34;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter36_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter36 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter36 <= ap_enable_reg_pp0_iter35;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter37_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter37 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter37 <= ap_enable_reg_pp0_iter36;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter38_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter38 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter38 <= ap_enable_reg_pp0_iter37;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter39_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter39 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter39 <= ap_enable_reg_pp0_iter38;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter4_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter4 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter4 <= ap_enable_reg_pp0_iter3;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter40_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter40 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter40 <= ap_enable_reg_pp0_iter39;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter41_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter41 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter41 <= ap_enable_reg_pp0_iter40;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter42_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter42 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter42 <= ap_enable_reg_pp0_iter41;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter43_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter43 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter43 <= ap_enable_reg_pp0_iter42;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter44_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter44 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter44 <= ap_enable_reg_pp0_iter43;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter45_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter45 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter45 <= ap_enable_reg_pp0_iter44;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter46_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter46 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter46 <= ap_enable_reg_pp0_iter45;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter47_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter47 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter47 <= ap_enable_reg_pp0_iter46;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter48_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter48 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter48 <= ap_enable_reg_pp0_iter47;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter49_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter49 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter49 <= ap_enable_reg_pp0_iter48;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter5_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter5 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter5 <= ap_enable_reg_pp0_iter4;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter50_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter50 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter50 <= ap_enable_reg_pp0_iter49;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter51_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter51 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter51 <= ap_enable_reg_pp0_iter50;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter52_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter52 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter52 <= ap_enable_reg_pp0_iter51;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter53_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter53 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter53 <= ap_enable_reg_pp0_iter52;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter54_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter54 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter54 <= ap_enable_reg_pp0_iter53;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter55_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter55 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter55 <= ap_enable_reg_pp0_iter54;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter56_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter56 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter56 <= ap_enable_reg_pp0_iter55;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter57_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter57 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter57 <= ap_enable_reg_pp0_iter56;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter58_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter58 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter58 <= ap_enable_reg_pp0_iter57;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter59_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter59 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter59 <= ap_enable_reg_pp0_iter58;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter6_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter6 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter6 <= ap_enable_reg_pp0_iter5;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter60_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter60 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter60 <= ap_enable_reg_pp0_iter59;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter61_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter61 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter61 <= ap_enable_reg_pp0_iter60;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter62_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter62 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter62 <= ap_enable_reg_pp0_iter61;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter63_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter63 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter63 <= ap_enable_reg_pp0_iter62;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter64_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter64 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter64 <= ap_enable_reg_pp0_iter63;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter65_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter65 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter65 <= ap_enable_reg_pp0_iter64;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter66_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter66 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter66 <= ap_enable_reg_pp0_iter65;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter67_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter67 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter67 <= ap_enable_reg_pp0_iter66;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter68_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter68 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter68 <= ap_enable_reg_pp0_iter67;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter69_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter69 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter69 <= ap_enable_reg_pp0_iter68;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter7_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter7 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter7 <= ap_enable_reg_pp0_iter6;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter70_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter70 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter70 <= ap_enable_reg_pp0_iter69;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter71_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter71 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter71 <= ap_enable_reg_pp0_iter70;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter72_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter72 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter72 <= ap_enable_reg_pp0_iter71;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter73_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter73 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter73 <= ap_enable_reg_pp0_iter72;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter74_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter74 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter74 <= ap_enable_reg_pp0_iter73;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter75_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter75 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter75 <= ap_enable_reg_pp0_iter74;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter76_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter76 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter76 <= ap_enable_reg_pp0_iter75;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter8_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter8 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter8 <= ap_enable_reg_pp0_iter7;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter9_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_enable_reg_pp0_iter9 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter9 <= ap_enable_reg_pp0_iter8;
                end if; 
            end if;
        end if;
    end process;


    ap_rst_n_inv_assign_proc : process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            ap_rst_n_inv <= ap_rst_reg_1;
        end if;
    end process;

    ap_rst_reg_1_assign_proc : process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            ap_rst_reg_1 <= ap_rst_reg_2;
        end if;
    end process;

    ap_rst_reg_2_assign_proc : process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
                        ap_rst_reg_2 <= not(ap_rst_n);
        end if;
    end process;

    first_iter_0_reg_147_assign_proc : process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if ((ap_const_logic_1 = ap_CS_fsm_pp0_stage0)) then
                if (((ap_loop_init = ap_const_logic_1) and (ap_const_boolean_0 = ap_block_pp0_stage0_subdone))) then 
                    first_iter_0_reg_147 <= ap_const_lv1_1;
                elsif ((ap_const_boolean_1 = ap_condition_1139)) then 
                    first_iter_0_reg_147 <= ap_const_lv1_0;
                end if;
            end if; 
        end if;
    end process;

    i_fu_100_assign_proc : process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if ((ap_const_boolean_1 = ap_condition_869)) then
                if ((icmp_ln37_1_fu_193_p2 = ap_const_lv1_1)) then 
                    i_fu_100 <= add_ln37_fu_199_p2;
                elsif ((ap_loop_init = ap_const_logic_1)) then 
                    i_fu_100 <= ap_const_lv31_0;
                end if;
            end if; 
        end if;
    end process;
    process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if ((ap_const_boolean_0 = ap_block_pp0_stage0_11001)) then
                ap_loop_exit_ready_pp0_iter10_reg <= ap_loop_exit_ready_pp0_iter9_reg;
                ap_loop_exit_ready_pp0_iter11_reg <= ap_loop_exit_ready_pp0_iter10_reg;
                ap_loop_exit_ready_pp0_iter12_reg <= ap_loop_exit_ready_pp0_iter11_reg;
                ap_loop_exit_ready_pp0_iter13_reg <= ap_loop_exit_ready_pp0_iter12_reg;
                ap_loop_exit_ready_pp0_iter14_reg <= ap_loop_exit_ready_pp0_iter13_reg;
                ap_loop_exit_ready_pp0_iter15_reg <= ap_loop_exit_ready_pp0_iter14_reg;
                ap_loop_exit_ready_pp0_iter16_reg <= ap_loop_exit_ready_pp0_iter15_reg;
                ap_loop_exit_ready_pp0_iter17_reg <= ap_loop_exit_ready_pp0_iter16_reg;
                ap_loop_exit_ready_pp0_iter18_reg <= ap_loop_exit_ready_pp0_iter17_reg;
                ap_loop_exit_ready_pp0_iter19_reg <= ap_loop_exit_ready_pp0_iter18_reg;
                ap_loop_exit_ready_pp0_iter20_reg <= ap_loop_exit_ready_pp0_iter19_reg;
                ap_loop_exit_ready_pp0_iter21_reg <= ap_loop_exit_ready_pp0_iter20_reg;
                ap_loop_exit_ready_pp0_iter22_reg <= ap_loop_exit_ready_pp0_iter21_reg;
                ap_loop_exit_ready_pp0_iter23_reg <= ap_loop_exit_ready_pp0_iter22_reg;
                ap_loop_exit_ready_pp0_iter24_reg <= ap_loop_exit_ready_pp0_iter23_reg;
                ap_loop_exit_ready_pp0_iter25_reg <= ap_loop_exit_ready_pp0_iter24_reg;
                ap_loop_exit_ready_pp0_iter26_reg <= ap_loop_exit_ready_pp0_iter25_reg;
                ap_loop_exit_ready_pp0_iter27_reg <= ap_loop_exit_ready_pp0_iter26_reg;
                ap_loop_exit_ready_pp0_iter28_reg <= ap_loop_exit_ready_pp0_iter27_reg;
                ap_loop_exit_ready_pp0_iter29_reg <= ap_loop_exit_ready_pp0_iter28_reg;
                ap_loop_exit_ready_pp0_iter30_reg <= ap_loop_exit_ready_pp0_iter29_reg;
                ap_loop_exit_ready_pp0_iter31_reg <= ap_loop_exit_ready_pp0_iter30_reg;
                ap_loop_exit_ready_pp0_iter32_reg <= ap_loop_exit_ready_pp0_iter31_reg;
                ap_loop_exit_ready_pp0_iter33_reg <= ap_loop_exit_ready_pp0_iter32_reg;
                ap_loop_exit_ready_pp0_iter34_reg <= ap_loop_exit_ready_pp0_iter33_reg;
                ap_loop_exit_ready_pp0_iter35_reg <= ap_loop_exit_ready_pp0_iter34_reg;
                ap_loop_exit_ready_pp0_iter36_reg <= ap_loop_exit_ready_pp0_iter35_reg;
                ap_loop_exit_ready_pp0_iter37_reg <= ap_loop_exit_ready_pp0_iter36_reg;
                ap_loop_exit_ready_pp0_iter38_reg <= ap_loop_exit_ready_pp0_iter37_reg;
                ap_loop_exit_ready_pp0_iter39_reg <= ap_loop_exit_ready_pp0_iter38_reg;
                ap_loop_exit_ready_pp0_iter3_reg <= ap_loop_exit_ready_pp0_iter2_reg;
                ap_loop_exit_ready_pp0_iter40_reg <= ap_loop_exit_ready_pp0_iter39_reg;
                ap_loop_exit_ready_pp0_iter41_reg <= ap_loop_exit_ready_pp0_iter40_reg;
                ap_loop_exit_ready_pp0_iter42_reg <= ap_loop_exit_ready_pp0_iter41_reg;
                ap_loop_exit_ready_pp0_iter43_reg <= ap_loop_exit_ready_pp0_iter42_reg;
                ap_loop_exit_ready_pp0_iter44_reg <= ap_loop_exit_ready_pp0_iter43_reg;
                ap_loop_exit_ready_pp0_iter45_reg <= ap_loop_exit_ready_pp0_iter44_reg;
                ap_loop_exit_ready_pp0_iter46_reg <= ap_loop_exit_ready_pp0_iter45_reg;
                ap_loop_exit_ready_pp0_iter47_reg <= ap_loop_exit_ready_pp0_iter46_reg;
                ap_loop_exit_ready_pp0_iter48_reg <= ap_loop_exit_ready_pp0_iter47_reg;
                ap_loop_exit_ready_pp0_iter49_reg <= ap_loop_exit_ready_pp0_iter48_reg;
                ap_loop_exit_ready_pp0_iter4_reg <= ap_loop_exit_ready_pp0_iter3_reg;
                ap_loop_exit_ready_pp0_iter50_reg <= ap_loop_exit_ready_pp0_iter49_reg;
                ap_loop_exit_ready_pp0_iter51_reg <= ap_loop_exit_ready_pp0_iter50_reg;
                ap_loop_exit_ready_pp0_iter52_reg <= ap_loop_exit_ready_pp0_iter51_reg;
                ap_loop_exit_ready_pp0_iter53_reg <= ap_loop_exit_ready_pp0_iter52_reg;
                ap_loop_exit_ready_pp0_iter54_reg <= ap_loop_exit_ready_pp0_iter53_reg;
                ap_loop_exit_ready_pp0_iter55_reg <= ap_loop_exit_ready_pp0_iter54_reg;
                ap_loop_exit_ready_pp0_iter56_reg <= ap_loop_exit_ready_pp0_iter55_reg;
                ap_loop_exit_ready_pp0_iter57_reg <= ap_loop_exit_ready_pp0_iter56_reg;
                ap_loop_exit_ready_pp0_iter58_reg <= ap_loop_exit_ready_pp0_iter57_reg;
                ap_loop_exit_ready_pp0_iter59_reg <= ap_loop_exit_ready_pp0_iter58_reg;
                ap_loop_exit_ready_pp0_iter5_reg <= ap_loop_exit_ready_pp0_iter4_reg;
                ap_loop_exit_ready_pp0_iter60_reg <= ap_loop_exit_ready_pp0_iter59_reg;
                ap_loop_exit_ready_pp0_iter61_reg <= ap_loop_exit_ready_pp0_iter60_reg;
                ap_loop_exit_ready_pp0_iter62_reg <= ap_loop_exit_ready_pp0_iter61_reg;
                ap_loop_exit_ready_pp0_iter63_reg <= ap_loop_exit_ready_pp0_iter62_reg;
                ap_loop_exit_ready_pp0_iter64_reg <= ap_loop_exit_ready_pp0_iter63_reg;
                ap_loop_exit_ready_pp0_iter65_reg <= ap_loop_exit_ready_pp0_iter64_reg;
                ap_loop_exit_ready_pp0_iter66_reg <= ap_loop_exit_ready_pp0_iter65_reg;
                ap_loop_exit_ready_pp0_iter67_reg <= ap_loop_exit_ready_pp0_iter66_reg;
                ap_loop_exit_ready_pp0_iter68_reg <= ap_loop_exit_ready_pp0_iter67_reg;
                ap_loop_exit_ready_pp0_iter69_reg <= ap_loop_exit_ready_pp0_iter68_reg;
                ap_loop_exit_ready_pp0_iter6_reg <= ap_loop_exit_ready_pp0_iter5_reg;
                ap_loop_exit_ready_pp0_iter70_reg <= ap_loop_exit_ready_pp0_iter69_reg;
                ap_loop_exit_ready_pp0_iter71_reg <= ap_loop_exit_ready_pp0_iter70_reg;
                ap_loop_exit_ready_pp0_iter72_reg <= ap_loop_exit_ready_pp0_iter71_reg;
                ap_loop_exit_ready_pp0_iter73_reg <= ap_loop_exit_ready_pp0_iter72_reg;
                ap_loop_exit_ready_pp0_iter74_reg <= ap_loop_exit_ready_pp0_iter73_reg;
                ap_loop_exit_ready_pp0_iter75_reg <= ap_loop_exit_ready_pp0_iter74_reg;
                ap_loop_exit_ready_pp0_iter7_reg <= ap_loop_exit_ready_pp0_iter6_reg;
                ap_loop_exit_ready_pp0_iter8_reg <= ap_loop_exit_ready_pp0_iter7_reg;
                ap_loop_exit_ready_pp0_iter9_reg <= ap_loop_exit_ready_pp0_iter8_reg;
                icmp_ln37_1_reg_257_pp0_iter10_reg <= icmp_ln37_1_reg_257_pp0_iter9_reg;
                icmp_ln37_1_reg_257_pp0_iter11_reg <= icmp_ln37_1_reg_257_pp0_iter10_reg;
                icmp_ln37_1_reg_257_pp0_iter12_reg <= icmp_ln37_1_reg_257_pp0_iter11_reg;
                icmp_ln37_1_reg_257_pp0_iter13_reg <= icmp_ln37_1_reg_257_pp0_iter12_reg;
                icmp_ln37_1_reg_257_pp0_iter14_reg <= icmp_ln37_1_reg_257_pp0_iter13_reg;
                icmp_ln37_1_reg_257_pp0_iter15_reg <= icmp_ln37_1_reg_257_pp0_iter14_reg;
                icmp_ln37_1_reg_257_pp0_iter16_reg <= icmp_ln37_1_reg_257_pp0_iter15_reg;
                icmp_ln37_1_reg_257_pp0_iter17_reg <= icmp_ln37_1_reg_257_pp0_iter16_reg;
                icmp_ln37_1_reg_257_pp0_iter18_reg <= icmp_ln37_1_reg_257_pp0_iter17_reg;
                icmp_ln37_1_reg_257_pp0_iter19_reg <= icmp_ln37_1_reg_257_pp0_iter18_reg;
                icmp_ln37_1_reg_257_pp0_iter20_reg <= icmp_ln37_1_reg_257_pp0_iter19_reg;
                icmp_ln37_1_reg_257_pp0_iter21_reg <= icmp_ln37_1_reg_257_pp0_iter20_reg;
                icmp_ln37_1_reg_257_pp0_iter22_reg <= icmp_ln37_1_reg_257_pp0_iter21_reg;
                icmp_ln37_1_reg_257_pp0_iter23_reg <= icmp_ln37_1_reg_257_pp0_iter22_reg;
                icmp_ln37_1_reg_257_pp0_iter24_reg <= icmp_ln37_1_reg_257_pp0_iter23_reg;
                icmp_ln37_1_reg_257_pp0_iter25_reg <= icmp_ln37_1_reg_257_pp0_iter24_reg;
                icmp_ln37_1_reg_257_pp0_iter26_reg <= icmp_ln37_1_reg_257_pp0_iter25_reg;
                icmp_ln37_1_reg_257_pp0_iter27_reg <= icmp_ln37_1_reg_257_pp0_iter26_reg;
                icmp_ln37_1_reg_257_pp0_iter28_reg <= icmp_ln37_1_reg_257_pp0_iter27_reg;
                icmp_ln37_1_reg_257_pp0_iter29_reg <= icmp_ln37_1_reg_257_pp0_iter28_reg;
                icmp_ln37_1_reg_257_pp0_iter2_reg <= icmp_ln37_1_reg_257_pp0_iter1_reg;
                icmp_ln37_1_reg_257_pp0_iter30_reg <= icmp_ln37_1_reg_257_pp0_iter29_reg;
                icmp_ln37_1_reg_257_pp0_iter31_reg <= icmp_ln37_1_reg_257_pp0_iter30_reg;
                icmp_ln37_1_reg_257_pp0_iter32_reg <= icmp_ln37_1_reg_257_pp0_iter31_reg;
                icmp_ln37_1_reg_257_pp0_iter33_reg <= icmp_ln37_1_reg_257_pp0_iter32_reg;
                icmp_ln37_1_reg_257_pp0_iter34_reg <= icmp_ln37_1_reg_257_pp0_iter33_reg;
                icmp_ln37_1_reg_257_pp0_iter35_reg <= icmp_ln37_1_reg_257_pp0_iter34_reg;
                icmp_ln37_1_reg_257_pp0_iter36_reg <= icmp_ln37_1_reg_257_pp0_iter35_reg;
                icmp_ln37_1_reg_257_pp0_iter37_reg <= icmp_ln37_1_reg_257_pp0_iter36_reg;
                icmp_ln37_1_reg_257_pp0_iter38_reg <= icmp_ln37_1_reg_257_pp0_iter37_reg;
                icmp_ln37_1_reg_257_pp0_iter39_reg <= icmp_ln37_1_reg_257_pp0_iter38_reg;
                icmp_ln37_1_reg_257_pp0_iter3_reg <= icmp_ln37_1_reg_257_pp0_iter2_reg;
                icmp_ln37_1_reg_257_pp0_iter40_reg <= icmp_ln37_1_reg_257_pp0_iter39_reg;
                icmp_ln37_1_reg_257_pp0_iter41_reg <= icmp_ln37_1_reg_257_pp0_iter40_reg;
                icmp_ln37_1_reg_257_pp0_iter42_reg <= icmp_ln37_1_reg_257_pp0_iter41_reg;
                icmp_ln37_1_reg_257_pp0_iter43_reg <= icmp_ln37_1_reg_257_pp0_iter42_reg;
                icmp_ln37_1_reg_257_pp0_iter44_reg <= icmp_ln37_1_reg_257_pp0_iter43_reg;
                icmp_ln37_1_reg_257_pp0_iter45_reg <= icmp_ln37_1_reg_257_pp0_iter44_reg;
                icmp_ln37_1_reg_257_pp0_iter46_reg <= icmp_ln37_1_reg_257_pp0_iter45_reg;
                icmp_ln37_1_reg_257_pp0_iter47_reg <= icmp_ln37_1_reg_257_pp0_iter46_reg;
                icmp_ln37_1_reg_257_pp0_iter48_reg <= icmp_ln37_1_reg_257_pp0_iter47_reg;
                icmp_ln37_1_reg_257_pp0_iter49_reg <= icmp_ln37_1_reg_257_pp0_iter48_reg;
                icmp_ln37_1_reg_257_pp0_iter4_reg <= icmp_ln37_1_reg_257_pp0_iter3_reg;
                icmp_ln37_1_reg_257_pp0_iter50_reg <= icmp_ln37_1_reg_257_pp0_iter49_reg;
                icmp_ln37_1_reg_257_pp0_iter51_reg <= icmp_ln37_1_reg_257_pp0_iter50_reg;
                icmp_ln37_1_reg_257_pp0_iter52_reg <= icmp_ln37_1_reg_257_pp0_iter51_reg;
                icmp_ln37_1_reg_257_pp0_iter53_reg <= icmp_ln37_1_reg_257_pp0_iter52_reg;
                icmp_ln37_1_reg_257_pp0_iter54_reg <= icmp_ln37_1_reg_257_pp0_iter53_reg;
                icmp_ln37_1_reg_257_pp0_iter55_reg <= icmp_ln37_1_reg_257_pp0_iter54_reg;
                icmp_ln37_1_reg_257_pp0_iter56_reg <= icmp_ln37_1_reg_257_pp0_iter55_reg;
                icmp_ln37_1_reg_257_pp0_iter57_reg <= icmp_ln37_1_reg_257_pp0_iter56_reg;
                icmp_ln37_1_reg_257_pp0_iter58_reg <= icmp_ln37_1_reg_257_pp0_iter57_reg;
                icmp_ln37_1_reg_257_pp0_iter59_reg <= icmp_ln37_1_reg_257_pp0_iter58_reg;
                icmp_ln37_1_reg_257_pp0_iter5_reg <= icmp_ln37_1_reg_257_pp0_iter4_reg;
                icmp_ln37_1_reg_257_pp0_iter60_reg <= icmp_ln37_1_reg_257_pp0_iter59_reg;
                icmp_ln37_1_reg_257_pp0_iter61_reg <= icmp_ln37_1_reg_257_pp0_iter60_reg;
                icmp_ln37_1_reg_257_pp0_iter62_reg <= icmp_ln37_1_reg_257_pp0_iter61_reg;
                icmp_ln37_1_reg_257_pp0_iter63_reg <= icmp_ln37_1_reg_257_pp0_iter62_reg;
                icmp_ln37_1_reg_257_pp0_iter64_reg <= icmp_ln37_1_reg_257_pp0_iter63_reg;
                icmp_ln37_1_reg_257_pp0_iter65_reg <= icmp_ln37_1_reg_257_pp0_iter64_reg;
                icmp_ln37_1_reg_257_pp0_iter66_reg <= icmp_ln37_1_reg_257_pp0_iter65_reg;
                icmp_ln37_1_reg_257_pp0_iter67_reg <= icmp_ln37_1_reg_257_pp0_iter66_reg;
                icmp_ln37_1_reg_257_pp0_iter68_reg <= icmp_ln37_1_reg_257_pp0_iter67_reg;
                icmp_ln37_1_reg_257_pp0_iter69_reg <= icmp_ln37_1_reg_257_pp0_iter68_reg;
                icmp_ln37_1_reg_257_pp0_iter6_reg <= icmp_ln37_1_reg_257_pp0_iter5_reg;
                icmp_ln37_1_reg_257_pp0_iter70_reg <= icmp_ln37_1_reg_257_pp0_iter69_reg;
                icmp_ln37_1_reg_257_pp0_iter71_reg <= icmp_ln37_1_reg_257_pp0_iter70_reg;
                icmp_ln37_1_reg_257_pp0_iter72_reg <= icmp_ln37_1_reg_257_pp0_iter71_reg;
                icmp_ln37_1_reg_257_pp0_iter73_reg <= icmp_ln37_1_reg_257_pp0_iter72_reg;
                icmp_ln37_1_reg_257_pp0_iter74_reg <= icmp_ln37_1_reg_257_pp0_iter73_reg;
                icmp_ln37_1_reg_257_pp0_iter75_reg <= icmp_ln37_1_reg_257_pp0_iter74_reg;
                icmp_ln37_1_reg_257_pp0_iter7_reg <= icmp_ln37_1_reg_257_pp0_iter6_reg;
                icmp_ln37_1_reg_257_pp0_iter8_reg <= icmp_ln37_1_reg_257_pp0_iter7_reg;
                icmp_ln37_1_reg_257_pp0_iter9_reg <= icmp_ln37_1_reg_257_pp0_iter8_reg;
            end if;
        end if;
    end process;
    process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if (((ap_const_boolean_0 = ap_block_pp0_stage0_11001) and (ap_const_logic_1 = ap_CS_fsm_pp0_stage0))) then
                ap_loop_exit_ready_pp0_iter1_reg <= ap_loop_exit_ready;
                ap_loop_exit_ready_pp0_iter2_reg <= ap_loop_exit_ready_pp0_iter1_reg;
                icmp_ln37_1_reg_257 <= icmp_ln37_1_fu_193_p2;
                icmp_ln37_1_reg_257_pp0_iter1_reg <= icmp_ln37_1_reg_257;
                    zext_ln37_reg_251(30 downto 0) <= zext_ln37_fu_177_p1(30 downto 0);
            end if;
        end if;
    end process;
    process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if (((ap_const_boolean_0 = ap_block_pp0_stage0_subdone_grp1_done_reg_iter0) and (ap_const_boolean_0 = ap_block_pp0_stage0_11001_grp1) and (ap_const_logic_1 = ap_CS_fsm_pp0_stage0))) then
                mem_read_reg_246 <= mem;
            end if;
        end if;
    end process;
    zext_ln37_reg_251(63 downto 31) <= "000000000000000000000000000000000";

    ap_NS_fsm_assign_proc : process (ap_CS_fsm)
    begin
        case ap_CS_fsm is
            when ap_ST_fsm_pp0_stage0 => 
                ap_NS_fsm <= ap_ST_fsm_pp0_stage0;
            when others =>  
                ap_NS_fsm <= "X";
        end case;
    end process;
    add_ln37_fu_199_p2 <= std_logic_vector(unsigned(ap_sig_allocacmp_i_load) + unsigned(ap_const_lv31_1));
    ap_CS_fsm_pp0_stage0 <= ap_CS_fsm(0);
        ap_block_pp0_stage0 <= not((ap_const_boolean_1 = ap_const_boolean_1));

    ap_block_pp0_stage0_01001_grp1_assign_proc : process(ap_enable_reg_pp0_iter75, ap_enable_reg_pp0_iter76, ap_done_reg, ap_block_state1_pp0_stage0_iter0, ap_block_pp0_stage0_subdone_grp1_done_reg, ap_block_state76_pp0_stage0_iter75_grp1, regslice_both_s_V_data_V_U_apdone_blk, ap_block_state77_pp0_stage0_iter76_grp1, ap_loop_exit_ready_pp0_iter75_reg, ap_start_int)
    begin
                ap_block_pp0_stage0_01001_grp1 <= ((ap_done_reg = ap_const_logic_1) or ((ap_loop_exit_ready_pp0_iter75_reg = ap_const_logic_1) and (regslice_both_s_V_data_V_U_apdone_blk = ap_const_logic_1)) or ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone_grp1_done_reg) and (ap_enable_reg_pp0_iter76 = ap_const_logic_1) and (ap_const_boolean_1 = ap_block_state77_pp0_stage0_iter76_grp1)) or ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone_grp1_done_reg) and (ap_enable_reg_pp0_iter75 = ap_const_logic_1) and (ap_const_boolean_1 = ap_block_state76_pp0_stage0_iter75_grp1)) or ((ap_start_int = ap_const_logic_1) and (ap_const_boolean_1 = ap_block_state1_pp0_stage0_iter0)));
    end process;


    ap_block_pp0_stage0_11001_assign_proc : process(ap_enable_reg_pp0_iter1, ap_enable_reg_pp0_iter75, ap_enable_reg_pp0_iter76, ap_done_reg, ap_block_state1_pp0_stage0_iter0, ap_block_state2_io_grp1, ap_block_pp0_stage0_subdone_grp1_done_reg, ap_block_state76_pp0_stage0_iter75_grp1, regslice_both_s_V_data_V_U_apdone_blk, ap_block_state77_pp0_stage0_iter76_grp1, ap_loop_exit_ready_pp0_iter75_reg, ap_start_int)
    begin
                ap_block_pp0_stage0_11001 <= ((ap_done_reg = ap_const_logic_1) or ((ap_loop_exit_ready_pp0_iter75_reg = ap_const_logic_1) and (regslice_both_s_V_data_V_U_apdone_blk = ap_const_logic_1)) or ((ap_enable_reg_pp0_iter75 = ap_const_logic_1) and ((regslice_both_s_V_data_V_U_apdone_blk = ap_const_logic_1) or ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone_grp1_done_reg) and (ap_const_boolean_1 = ap_block_state76_pp0_stage0_iter75_grp1)))) or ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone_grp1_done_reg) and (ap_enable_reg_pp0_iter76 = ap_const_logic_1) and (ap_const_boolean_1 = ap_block_state77_pp0_stage0_iter76_grp1)) or ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone_grp1_done_reg) and (ap_enable_reg_pp0_iter1 = ap_const_logic_1) and (ap_const_boolean_1 = ap_block_state2_io_grp1)) or ((ap_start_int = ap_const_logic_1) and (ap_const_boolean_1 = ap_block_state1_pp0_stage0_iter0)));
    end process;


    ap_block_pp0_stage0_11001_grp1_assign_proc : process(ap_enable_reg_pp0_iter1, ap_enable_reg_pp0_iter75, ap_enable_reg_pp0_iter76, ap_done_reg, ap_block_state1_pp0_stage0_iter0, ap_block_state2_io_grp1, ap_block_pp0_stage0_subdone_grp1_done_reg, ap_block_state76_pp0_stage0_iter75_grp1, regslice_both_s_V_data_V_U_apdone_blk, ap_block_state77_pp0_stage0_iter76_grp1, ap_loop_exit_ready_pp0_iter75_reg, ap_start_int)
    begin
                ap_block_pp0_stage0_11001_grp1 <= ((ap_done_reg = ap_const_logic_1) or ((ap_loop_exit_ready_pp0_iter75_reg = ap_const_logic_1) and (regslice_both_s_V_data_V_U_apdone_blk = ap_const_logic_1)) or ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone_grp1_done_reg) and (ap_enable_reg_pp0_iter76 = ap_const_logic_1) and (ap_const_boolean_1 = ap_block_state77_pp0_stage0_iter76_grp1)) or ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone_grp1_done_reg) and (ap_enable_reg_pp0_iter75 = ap_const_logic_1) and (ap_const_boolean_1 = ap_block_state76_pp0_stage0_iter75_grp1)) or ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone_grp1_done_reg) and (ap_enable_reg_pp0_iter1 = ap_const_logic_1) and (ap_const_boolean_1 = ap_block_state2_io_grp1)) or ((ap_start_int = ap_const_logic_1) and (ap_const_boolean_1 = ap_block_state1_pp0_stage0_iter0)));
    end process;

        ap_block_pp0_stage0_grp1 <= not((ap_const_boolean_1 = ap_const_boolean_1));

    ap_block_pp0_stage0_subdone_assign_proc : process(ap_enable_reg_pp0_iter1, ap_enable_reg_pp0_iter75, ap_enable_reg_pp0_iter76, ap_done_reg, ap_block_state1_pp0_stage0_iter0, ap_block_state2_io_grp1, ap_block_pp0_stage0_subdone_grp1_done_reg, ap_block_state76_pp0_stage0_iter75_grp1, regslice_both_s_V_data_V_U_apdone_blk, ap_block_state77_pp0_stage0_iter76_grp1, ap_loop_exit_ready_pp0_iter75_reg, ap_start_int)
    begin
                ap_block_pp0_stage0_subdone <= ((ap_done_reg = ap_const_logic_1) or ((ap_loop_exit_ready_pp0_iter75_reg = ap_const_logic_1) and (regslice_both_s_V_data_V_U_apdone_blk = ap_const_logic_1)) or ((ap_enable_reg_pp0_iter75 = ap_const_logic_1) and ((regslice_both_s_V_data_V_U_apdone_blk = ap_const_logic_1) or ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone_grp1_done_reg) and (ap_const_boolean_1 = ap_block_state76_pp0_stage0_iter75_grp1)))) or ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone_grp1_done_reg) and (ap_enable_reg_pp0_iter76 = ap_const_logic_1) and (ap_const_boolean_1 = ap_block_state77_pp0_stage0_iter76_grp1)) or ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone_grp1_done_reg) and (ap_enable_reg_pp0_iter1 = ap_const_logic_1) and (ap_const_boolean_1 = ap_block_state2_io_grp1)) or ((ap_start_int = ap_const_logic_1) and (ap_const_boolean_1 = ap_block_state1_pp0_stage0_iter0)));
    end process;


    ap_block_pp0_stage0_subdone_grp1_assign_proc : process(ap_enable_reg_pp0_iter1, ap_enable_reg_pp0_iter75, ap_enable_reg_pp0_iter76, ap_done_reg, ap_block_state1_pp0_stage0_iter0, ap_block_state2_io_grp1, ap_block_pp0_stage0_subdone_grp1_done_reg, ap_block_state76_pp0_stage0_iter75_grp1, regslice_both_s_V_data_V_U_apdone_blk, ap_block_state77_pp0_stage0_iter76_grp1, ap_loop_exit_ready_pp0_iter75_reg, ap_start_int)
    begin
                ap_block_pp0_stage0_subdone_grp1 <= ((ap_done_reg = ap_const_logic_1) or ((ap_loop_exit_ready_pp0_iter75_reg = ap_const_logic_1) and (regslice_both_s_V_data_V_U_apdone_blk = ap_const_logic_1)) or ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone_grp1_done_reg) and (ap_enable_reg_pp0_iter76 = ap_const_logic_1) and (ap_const_boolean_1 = ap_block_state77_pp0_stage0_iter76_grp1)) or ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone_grp1_done_reg) and (ap_enable_reg_pp0_iter75 = ap_const_logic_1) and (ap_const_boolean_1 = ap_block_state76_pp0_stage0_iter75_grp1)) or ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone_grp1_done_reg) and (ap_enable_reg_pp0_iter1 = ap_const_logic_1) and (ap_const_boolean_1 = ap_block_state2_io_grp1)) or ((ap_start_int = ap_const_logic_1) and (ap_const_boolean_1 = ap_block_state1_pp0_stage0_iter0)));
    end process;


    ap_block_state1_pp0_stage0_iter0_assign_proc : process(ap_done_reg)
    begin
                ap_block_state1_pp0_stage0_iter0 <= (ap_done_reg = ap_const_logic_1);
    end process;


    ap_block_state2_io_grp1_assign_proc : process(gmem_0_ARREADY, first_iter_0_reg_147)
    begin
                ap_block_state2_io_grp1 <= ((first_iter_0_reg_147 = ap_const_lv1_1) and (gmem_0_ARREADY = ap_const_logic_0));
    end process;


    ap_block_state76_pp0_stage0_iter75_grp1_assign_proc : process(gmem_0_RVALID, icmp_ln37_1_reg_257_pp0_iter74_reg, s_TREADY_int_regslice)
    begin
                ap_block_state76_pp0_stage0_iter75_grp1 <= (((icmp_ln37_1_reg_257_pp0_iter74_reg = ap_const_lv1_1) and (gmem_0_RVALID = ap_const_logic_0)) or ((icmp_ln37_1_reg_257_pp0_iter74_reg = ap_const_lv1_1) and (s_TREADY_int_regslice = ap_const_logic_0)));
    end process;


    ap_block_state77_pp0_stage0_iter76_grp1_assign_proc : process(icmp_ln37_1_reg_257_pp0_iter75_reg, s_TREADY_int_regslice)
    begin
                ap_block_state77_pp0_stage0_iter76_grp1 <= ((icmp_ln37_1_reg_257_pp0_iter75_reg = ap_const_lv1_1) and (s_TREADY_int_regslice = ap_const_logic_0));
    end process;


    ap_condition_1139_assign_proc : process(ap_enable_reg_pp0_iter1, icmp_ln37_1_reg_257, ap_block_pp0_stage0_11001)
    begin
                ap_condition_1139 <= ((icmp_ln37_1_reg_257 = ap_const_lv1_1) and (ap_const_boolean_0 = ap_block_pp0_stage0_11001) and (ap_enable_reg_pp0_iter1 = ap_const_logic_1));
    end process;


    ap_condition_869_assign_proc : process(ap_CS_fsm_pp0_stage0, ap_block_pp0_stage0_11001, ap_start_int)
    begin
                ap_condition_869 <= ((ap_const_boolean_0 = ap_block_pp0_stage0_11001) and (ap_start_int = ap_const_logic_1) and (ap_const_logic_1 = ap_CS_fsm_pp0_stage0));
    end process;


    ap_condition_exit_pp0_iter0_stage0_assign_proc : process(ap_CS_fsm_pp0_stage0, ap_block_pp0_stage0_subdone, icmp_ln37_1_fu_193_p2, ap_start_int)
    begin
        if (((icmp_ln37_1_fu_193_p2 = ap_const_lv1_0) and (ap_const_boolean_0 = ap_block_pp0_stage0_subdone) and (ap_start_int = ap_const_logic_1) and (ap_const_logic_1 = ap_CS_fsm_pp0_stage0))) then 
            ap_condition_exit_pp0_iter0_stage0 <= ap_const_logic_1;
        else 
            ap_condition_exit_pp0_iter0_stage0 <= ap_const_logic_0;
        end if; 
    end process;

    ap_done <= ap_done_sig;

    ap_done_int_assign_proc : process(ap_done_reg, ap_block_pp0_stage0_subdone, ap_loop_exit_ready_pp0_iter75_reg)
    begin
        if (((ap_loop_exit_ready_pp0_iter75_reg = ap_const_logic_1) and (ap_const_boolean_0 = ap_block_pp0_stage0_subdone))) then 
            ap_done_int <= ap_const_logic_1;
        else 
            ap_done_int <= ap_done_reg;
        end if; 
    end process;

    ap_enable_pp0 <= (ap_idle_pp0 xor ap_const_logic_1);
    ap_enable_reg_pp0_iter0 <= ap_start_int;

    ap_idle_assign_proc : process(ap_CS_fsm_pp0_stage0, ap_idle_pp0, ap_start_int)
    begin
        if (((ap_idle_pp0 = ap_const_logic_1) and (ap_const_logic_1 = ap_CS_fsm_pp0_stage0) and (ap_start_int = ap_const_logic_0))) then 
            ap_idle <= ap_const_logic_1;
        else 
            ap_idle <= ap_const_logic_0;
        end if; 
    end process;


    ap_idle_pp0_assign_proc : process(ap_enable_reg_pp0_iter0, ap_enable_reg_pp0_iter1, ap_enable_reg_pp0_iter2, ap_enable_reg_pp0_iter3, ap_enable_reg_pp0_iter4, ap_enable_reg_pp0_iter5, ap_enable_reg_pp0_iter6, ap_enable_reg_pp0_iter7, ap_enable_reg_pp0_iter8, ap_enable_reg_pp0_iter9, ap_enable_reg_pp0_iter10, ap_enable_reg_pp0_iter11, ap_enable_reg_pp0_iter12, ap_enable_reg_pp0_iter13, ap_enable_reg_pp0_iter14, ap_enable_reg_pp0_iter15, ap_enable_reg_pp0_iter16, ap_enable_reg_pp0_iter17, ap_enable_reg_pp0_iter18, ap_enable_reg_pp0_iter19, ap_enable_reg_pp0_iter20, ap_enable_reg_pp0_iter21, ap_enable_reg_pp0_iter22, ap_enable_reg_pp0_iter23, ap_enable_reg_pp0_iter24, ap_enable_reg_pp0_iter25, ap_enable_reg_pp0_iter26, ap_enable_reg_pp0_iter27, ap_enable_reg_pp0_iter28, ap_enable_reg_pp0_iter29, ap_enable_reg_pp0_iter30, ap_enable_reg_pp0_iter31, ap_enable_reg_pp0_iter32, ap_enable_reg_pp0_iter33, ap_enable_reg_pp0_iter34, ap_enable_reg_pp0_iter35, ap_enable_reg_pp0_iter36, ap_enable_reg_pp0_iter37, ap_enable_reg_pp0_iter38, ap_enable_reg_pp0_iter39, ap_enable_reg_pp0_iter40, ap_enable_reg_pp0_iter41, ap_enable_reg_pp0_iter42, ap_enable_reg_pp0_iter43, ap_enable_reg_pp0_iter44, ap_enable_reg_pp0_iter45, ap_enable_reg_pp0_iter46, ap_enable_reg_pp0_iter47, ap_enable_reg_pp0_iter48, ap_enable_reg_pp0_iter49, ap_enable_reg_pp0_iter50, ap_enable_reg_pp0_iter51, ap_enable_reg_pp0_iter52, ap_enable_reg_pp0_iter53, ap_enable_reg_pp0_iter54, ap_enable_reg_pp0_iter55, ap_enable_reg_pp0_iter56, ap_enable_reg_pp0_iter57, ap_enable_reg_pp0_iter58, ap_enable_reg_pp0_iter59, ap_enable_reg_pp0_iter60, ap_enable_reg_pp0_iter61, ap_enable_reg_pp0_iter62, ap_enable_reg_pp0_iter63, ap_enable_reg_pp0_iter64, ap_enable_reg_pp0_iter65, ap_enable_reg_pp0_iter66, ap_enable_reg_pp0_iter67, ap_enable_reg_pp0_iter68, ap_enable_reg_pp0_iter69, ap_enable_reg_pp0_iter70, ap_enable_reg_pp0_iter71, ap_enable_reg_pp0_iter72, ap_enable_reg_pp0_iter73, ap_enable_reg_pp0_iter74, ap_enable_reg_pp0_iter75, ap_enable_reg_pp0_iter76)
    begin
        if (((ap_enable_reg_pp0_iter25 = ap_const_logic_0) and (ap_enable_reg_pp0_iter24 = ap_const_logic_0) and (ap_enable_reg_pp0_iter23 = ap_const_logic_0) and (ap_enable_reg_pp0_iter22 = ap_const_logic_0) and (ap_enable_reg_pp0_iter21 = ap_const_logic_0) and (ap_enable_reg_pp0_iter20 = ap_const_logic_0) and (ap_enable_reg_pp0_iter19 = ap_const_logic_0) and (ap_enable_reg_pp0_iter18 = ap_const_logic_0) and (ap_enable_reg_pp0_iter17 = ap_const_logic_0) and (ap_enable_reg_pp0_iter16 = ap_const_logic_0) and (ap_enable_reg_pp0_iter15 = ap_const_logic_0) and (ap_enable_reg_pp0_iter14 = ap_const_logic_0) and (ap_enable_reg_pp0_iter13 = ap_const_logic_0) and (ap_enable_reg_pp0_iter12 = ap_const_logic_0) and (ap_enable_reg_pp0_iter11 = ap_const_logic_0) and (ap_enable_reg_pp0_iter10 = ap_const_logic_0) and (ap_enable_reg_pp0_iter9 = ap_const_logic_0) and (ap_enable_reg_pp0_iter8 = ap_const_logic_0) and (ap_enable_reg_pp0_iter7 = ap_const_logic_0) and (ap_enable_reg_pp0_iter6 = ap_const_logic_0) and (ap_enable_reg_pp0_iter5 = ap_const_logic_0) 
    and (ap_enable_reg_pp0_iter4 = ap_const_logic_0) and (ap_enable_reg_pp0_iter3 = ap_const_logic_0) and (ap_enable_reg_pp0_iter2 = ap_const_logic_0) and (ap_enable_reg_pp0_iter1 = ap_const_logic_0) and (ap_enable_reg_pp0_iter0 = ap_const_logic_0) and (ap_enable_reg_pp0_iter76 = ap_const_logic_0) and (ap_enable_reg_pp0_iter75 = ap_const_logic_0) and (ap_enable_reg_pp0_iter74 = ap_const_logic_0) and (ap_enable_reg_pp0_iter73 = ap_const_logic_0) and (ap_enable_reg_pp0_iter72 = ap_const_logic_0) and (ap_enable_reg_pp0_iter71 = ap_const_logic_0) and (ap_enable_reg_pp0_iter70 = ap_const_logic_0) and (ap_enable_reg_pp0_iter69 = ap_const_logic_0) and (ap_enable_reg_pp0_iter68 = ap_const_logic_0) and (ap_enable_reg_pp0_iter67 = ap_const_logic_0) and (ap_enable_reg_pp0_iter66 = ap_const_logic_0) and (ap_enable_reg_pp0_iter65 = ap_const_logic_0) and (ap_enable_reg_pp0_iter64 = ap_const_logic_0) and (ap_enable_reg_pp0_iter63 = ap_const_logic_0) and (ap_enable_reg_pp0_iter62 = ap_const_logic_0) and (ap_enable_reg_pp0_iter61 
    = ap_const_logic_0) and (ap_enable_reg_pp0_iter60 = ap_const_logic_0) and (ap_enable_reg_pp0_iter59 = ap_const_logic_0) and (ap_enable_reg_pp0_iter58 = ap_const_logic_0) and (ap_enable_reg_pp0_iter57 = ap_const_logic_0) and (ap_enable_reg_pp0_iter56 = ap_const_logic_0) and (ap_enable_reg_pp0_iter55 = ap_const_logic_0) and (ap_enable_reg_pp0_iter54 = ap_const_logic_0) and (ap_enable_reg_pp0_iter53 = ap_const_logic_0) and (ap_enable_reg_pp0_iter52 = ap_const_logic_0) and (ap_enable_reg_pp0_iter51 = ap_const_logic_0) and (ap_enable_reg_pp0_iter50 = ap_const_logic_0) and (ap_enable_reg_pp0_iter49 = ap_const_logic_0) and (ap_enable_reg_pp0_iter48 = ap_const_logic_0) and (ap_enable_reg_pp0_iter47 = ap_const_logic_0) and (ap_enable_reg_pp0_iter46 = ap_const_logic_0) and (ap_enable_reg_pp0_iter45 = ap_const_logic_0) and (ap_enable_reg_pp0_iter44 = ap_const_logic_0) and (ap_enable_reg_pp0_iter43 = ap_const_logic_0) and (ap_enable_reg_pp0_iter42 = ap_const_logic_0) and (ap_enable_reg_pp0_iter41 = ap_const_logic_0) and (ap_enable_reg_pp0_iter40 
    = ap_const_logic_0) and (ap_enable_reg_pp0_iter39 = ap_const_logic_0) and (ap_enable_reg_pp0_iter38 = ap_const_logic_0) and (ap_enable_reg_pp0_iter37 = ap_const_logic_0) and (ap_enable_reg_pp0_iter36 = ap_const_logic_0) and (ap_enable_reg_pp0_iter35 = ap_const_logic_0) and (ap_enable_reg_pp0_iter34 = ap_const_logic_0) and (ap_enable_reg_pp0_iter33 = ap_const_logic_0) and (ap_enable_reg_pp0_iter32 = ap_const_logic_0) and (ap_enable_reg_pp0_iter31 = ap_const_logic_0) and (ap_enable_reg_pp0_iter30 = ap_const_logic_0) and (ap_enable_reg_pp0_iter29 = ap_const_logic_0) and (ap_enable_reg_pp0_iter28 = ap_const_logic_0) and (ap_enable_reg_pp0_iter27 = ap_const_logic_0) and (ap_enable_reg_pp0_iter26 = ap_const_logic_0))) then 
            ap_idle_pp0 <= ap_const_logic_1;
        else 
            ap_idle_pp0 <= ap_const_logic_0;
        end if; 
    end process;

    ap_loop_exit_ready <= ap_condition_exit_pp0_iter0_stage0;
    ap_ready <= ap_ready_sig;

    ap_ready_int_assign_proc : process(ap_CS_fsm_pp0_stage0, ap_block_pp0_stage0_subdone, ap_start_int)
    begin
        if (((ap_const_boolean_0 = ap_block_pp0_stage0_subdone) and (ap_start_int = ap_const_logic_1) and (ap_const_logic_1 = ap_CS_fsm_pp0_stage0))) then 
            ap_ready_int <= ap_const_logic_1;
        else 
            ap_ready_int <= ap_const_logic_0;
        end if; 
    end process;


    ap_sig_allocacmp_i_load_assign_proc : process(ap_CS_fsm_pp0_stage0, ap_block_pp0_stage0, ap_loop_init, i_fu_100, ap_start_int)
    begin
        if (((ap_loop_init = ap_const_logic_1) and (ap_const_boolean_0 = ap_block_pp0_stage0) and (ap_start_int = ap_const_logic_1) and (ap_const_logic_1 = ap_CS_fsm_pp0_stage0))) then 
            ap_sig_allocacmp_i_load <= ap_const_lv31_0;
        else 
            ap_sig_allocacmp_i_load <= i_fu_100;
        end if; 
    end process;

    empty_fu_169_p3 <= 
        trunc_ln37_fu_165_p1 when (icmp_ln37_fu_159_p2(0) = '1') else 
        ap_const_lv31_0;
    gmem_0_ARLEN <= zext_ln37_reg_251(32 - 1 downto 0);

    gmem_0_ARVALID_assign_proc : process(ap_CS_fsm_pp0_stage0, ap_enable_reg_pp0_iter1, first_iter_0_reg_147, ap_block_pp0_stage0_subdone_grp1_done_reg, ap_block_pp0_stage0_11001_grp1)
    begin
        if (((ap_const_boolean_0 = ap_block_pp0_stage0_11001_grp1) and (ap_const_boolean_0 = ap_block_pp0_stage0_subdone_grp1_done_reg) and (first_iter_0_reg_147 = ap_const_lv1_1) and (ap_enable_reg_pp0_iter1 = ap_const_logic_1) and (ap_const_logic_1 = ap_CS_fsm_pp0_stage0))) then 
            gmem_0_ARVALID <= ap_const_logic_1;
        else 
            gmem_0_ARVALID <= ap_const_logic_0;
        end if; 
    end process;


    gmem_0_RREADY_assign_proc : process(ap_enable_reg_pp0_iter75, ap_block_pp0_stage0_subdone_grp1_done_reg, icmp_ln37_1_reg_257_pp0_iter74_reg, ap_block_pp0_stage0_11001_grp1)
    begin
        if (((icmp_ln37_1_reg_257_pp0_iter74_reg = ap_const_lv1_1) and (ap_const_boolean_0 = ap_block_pp0_stage0_11001_grp1) and (ap_const_boolean_0 = ap_block_pp0_stage0_subdone_grp1_done_reg) and (ap_enable_reg_pp0_iter75 = ap_const_logic_1))) then 
            gmem_0_RREADY <= ap_const_logic_1;
        else 
            gmem_0_RREADY <= ap_const_logic_0;
        end if; 
    end process;


    gmem_blk_n_AR_assign_proc : process(ap_CS_fsm_pp0_stage0, ap_enable_reg_pp0_iter1, first_iter_0_reg_147, ap_block_pp0_stage0_subdone_grp1_done_reg, m_axi_gmem_ARREADY, ap_block_pp0_stage0_grp1)
    begin
        if (((ap_const_boolean_0 = ap_block_pp0_stage0_grp1) and (ap_const_boolean_0 = ap_block_pp0_stage0_subdone_grp1_done_reg) and (first_iter_0_reg_147 = ap_const_lv1_1) and (ap_enable_reg_pp0_iter1 = ap_const_logic_1) and (ap_const_logic_1 = ap_CS_fsm_pp0_stage0))) then 
            gmem_blk_n_AR <= m_axi_gmem_ARREADY;
        else 
            gmem_blk_n_AR <= ap_const_logic_1;
        end if; 
    end process;


    gmem_blk_n_R_assign_proc : process(ap_enable_reg_pp0_iter75, ap_block_pp0_stage0_subdone_grp1_done_reg, icmp_ln37_1_reg_257_pp0_iter74_reg, m_axi_gmem_RVALID, ap_block_pp0_stage0_grp1)
    begin
        if (((icmp_ln37_1_reg_257_pp0_iter74_reg = ap_const_lv1_1) and (ap_const_boolean_0 = ap_block_pp0_stage0_grp1) and (ap_const_boolean_0 = ap_block_pp0_stage0_subdone_grp1_done_reg) and (ap_enable_reg_pp0_iter75 = ap_const_logic_1))) then 
            gmem_blk_n_R <= m_axi_gmem_RVALID;
        else 
            gmem_blk_n_R <= ap_const_logic_1;
        end if; 
    end process;

    i_cast_fu_189_p1 <= std_logic_vector(IEEE.numeric_std.resize(unsigned(ap_sig_allocacmp_i_load),32));
    icmp_ln37_1_fu_193_p2 <= "1" when (signed(i_cast_fu_189_p1) < signed(size)) else "0";
    icmp_ln37_fu_159_p2 <= "1" when (signed(size) > signed(ap_const_lv32_0)) else "0";

    s_TDATA_blk_n_assign_proc : process(ap_enable_reg_pp0_iter75, ap_enable_reg_pp0_iter76, ap_block_pp0_stage0_subdone_grp1_done_reg, icmp_ln37_1_reg_257_pp0_iter74_reg, icmp_ln37_1_reg_257_pp0_iter75_reg, ap_block_pp0_stage0_grp1, s_TREADY_int_regslice)
    begin
        if ((((icmp_ln37_1_reg_257_pp0_iter75_reg = ap_const_lv1_1) and (ap_const_boolean_0 = ap_block_pp0_stage0_grp1) and (ap_const_boolean_0 = ap_block_pp0_stage0_subdone_grp1_done_reg) and (ap_enable_reg_pp0_iter76 = ap_const_logic_1)) or ((icmp_ln37_1_reg_257_pp0_iter74_reg = ap_const_lv1_1) and (ap_const_boolean_0 = ap_block_pp0_stage0_grp1) and (ap_const_boolean_0 = ap_block_pp0_stage0_subdone_grp1_done_reg) and (ap_enable_reg_pp0_iter75 = ap_const_logic_1)))) then 
            s_TDATA_blk_n <= s_TREADY_int_regslice;
        else 
            s_TDATA_blk_n <= ap_const_logic_1;
        end if; 
    end process;

    s_TKEEP_int_regslice <= "XXXX";
    s_TLAST_int_regslice <= "X";
    s_TSTRB_int_regslice <= "XXXX";
    s_TVALID <= regslice_both_s_V_data_V_U_vld_out;

    s_TVALID_int_regslice_assign_proc : process(ap_enable_reg_pp0_iter75, ap_block_pp0_stage0_subdone_grp1_done_reg, icmp_ln37_1_reg_257_pp0_iter74_reg, ap_block_pp0_stage0_11001_grp1)
    begin
        if (((icmp_ln37_1_reg_257_pp0_iter74_reg = ap_const_lv1_1) and (ap_const_boolean_0 = ap_block_pp0_stage0_11001_grp1) and (ap_const_boolean_0 = ap_block_pp0_stage0_subdone_grp1_done_reg) and (ap_enable_reg_pp0_iter75 = ap_const_logic_1))) then 
            s_TVALID_int_regslice <= ap_const_logic_1;
        else 
            s_TVALID_int_regslice <= ap_const_logic_0;
        end if; 
    end process;

        sext_ln37_fu_219_p1 <= std_logic_vector(IEEE.numeric_std.resize(signed(trunc_ln_fu_210_p4),64));

    trunc_ln37_fu_165_p1 <= size(31 - 1 downto 0);
    trunc_ln_fu_210_p4 <= mem_read_reg_246(63 downto 2);
    zext_ln37_fu_177_p1 <= std_logic_vector(IEEE.numeric_std.resize(unsigned(empty_fu_169_p3),64));
end behav;
