#!/usr/bin/env bash
# ****************************************************************************
# Vivado (TM) v2025.1 (64-bit)
#
# Filename    : run.sh
# Simulator   : AMD Vivado Simulator
# Description : Script to compile, link/elaborate and simulate the design
#
# Generated by Vivado on Mon Aug 25 15:43:51 IST 2025
# SW Build 6140274 on Wed May 21 22:58:25 MDT 2025
#
# Copyright 1986-2022 Xilinx, Inc. All Rights Reserved.
# Copyright 2022-2025 Advanced Micro Devices, Inc. All Rights Reserved.
#
# usage: run.sh
#
# ****************************************************************************

# Script usage
usage()
{
  echo -e "Script to compile, link/elaborate and simulate the design\n"
  echo -e "Usage: run.sh [-help] [-reset_run]\n"
  echo -e "[-help]      -- Print help"
  echo -e "[-reset_run] -- Delete generated data from the previous run before executing the steps\n"
  exit 1
}

# Delete generated files (if any)
reset_run()
{
  files_to_remove=(compile.log xvlog.log xvhdl.log xsc.log elaborate.log simulate.log)
  for (( i=0; i<${#files_to_remove[*]}; i++ )); do
    file="${files_to_remove[i]}"
    if [[ -e $file ]]; then
      rm -rf $file
    fi
  done
  rm -rf ./xsim.dir
  mkdir xsim.dir
}

# Compile design
compile()
{
  ./compile.sh
}

# Link/Elaborate design
elaborate()
{
  ./elaborate.sh
}

# Simulate design
simulate()
{
  ./simulate.sh
}

# Execute steps
run()
{
  case $1 in
    "-reset_run" )
      reset_run
      echo -e "INFO: Simulation generated data deleted.\n"
    ;;
    * )
    ;;
  esac

  # Exit on step error
  set -Eeuo pipefail
  compile
  elaborate
  simulate
}

# Check command line args
if [[ $# > 1 ]]; then
  echo -e "error: invalid number of arguments specified (for more information type "run.sh -h[elp]")"
  exit 1
fi
if [[ ($# == 1 ) && ($1 != "-reset_run" && $1 != "-help" && $1 != "-h") ]]; then
  echo -e "error: unknown argument '$1' (for more information type "run.sh -h[elp]")"
  exit 1
fi
if [[ ($1 == "-help" || $1 == "-h") ]]; then
  usage
fi

# Launch script
run $1
