-- ==============================================================
-- Generated by Vitis HLS v2025.1
-- Copyright 1986-2022 Xilinx, Inc. All Rights Reserved.
-- Copyright 2022-2025 Advanced Micro Devices, Inc. All Rights Reserved.
-- ==============================================================

library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.NUMERIC_STD.all;

entity mm2s_gmem_m_axi is
    generic (
        C_M_AXI_ID_WIDTH          : INTEGER := 1;
        C_M_AXI_ADDR_WIDTH        : INTEGER := 32;
        C_M_AXI_DATA_WIDTH        : INTEGER := 32;
        C_M_AXI_AWUSER_WIDTH      : INTEGER := 1;
        C_M_AXI_ARUSER_WIDTH      : INTEGER := 1;
        C_M_AXI_WUSER_WIDTH       : INTEGER := 1;
        C_M_AXI_RUSER_WIDTH       : INTEGER := 1;
        C_M_AXI_BUSER_WIDTH       : INTEGER := 1;
        C_TARGET_ADDR             : INTEGER := 16#00000000#;
        C_USER_VALUE              : INTEGER := 0;
        C_PROT_VALUE              : INTEGER := 2#000#;
        C_CACHE_VALUE             : INTEGER := 2#0011#;
        CONSERVATIVE              : INTEGER := 0;
        MAX_READ_BURST_LENGTH     : INTEGER := 16;
        MAX_WRITE_BURST_LENGTH    : INTEGER := 16;
        NUM_READ_OUTSTANDING      : INTEGER := 2;
        NUM_WRITE_OUTSTANDING     : INTEGER := 2;
        USER_MAXREQS              : INTEGER := 16;
        USER_LEN_WIDTH            : INTEGER := 32;
        -- channel configurations 
        CH0_USER_DW               : INTEGER := 32;
        CH0_USER_AW               : INTEGER := 32;
        CH0_NUM_READ_OUTSTANDING  : INTEGER := 2;
        CH0_NUM_WRITE_OUTSTANDING : INTEGER := 2;
        CH0_USER_RFIFONUM_WIDTH   : INTEGER := 6;
        MAXI_BUFFER_IMPL          : STRING  := "block");
    port (
        -- system signal
        ACLK            : in  STD_LOGIC;
        ARESET          : in  STD_LOGIC;
        ACLK_EN         : in  STD_LOGIC;
        -- write address channel
        AWID            : out STD_LOGIC_VECTOR(C_M_AXI_ID_WIDTH-1 downto 0);
        AWADDR          : out STD_LOGIC_VECTOR(C_M_AXI_ADDR_WIDTH-1 downto 0);
        AWLEN           : out STD_LOGIC_VECTOR(7 downto 0);
        AWSIZE          : out STD_LOGIC_VECTOR(2 downto 0);
        AWBURST         : out STD_LOGIC_VECTOR(1 downto 0);
        AWLOCK          : out STD_LOGIC_VECTOR(1 downto 0);
        AWCACHE         : out STD_LOGIC_VECTOR(3 downto 0);
        AWPROT          : out STD_LOGIC_VECTOR(2 downto 0);
        AWQOS           : out STD_LOGIC_VECTOR(3 downto 0);
        AWREGION        : out STD_LOGIC_VECTOR(3 downto 0);
        AWUSER          : out STD_LOGIC_VECTOR(C_M_AXI_AWUSER_WIDTH-1 downto 0);
        AWVALID         : out STD_LOGIC;
        AWREADY         : in  STD_LOGIC;
        -- write data channel
        WID             : out STD_LOGIC_VECTOR(C_M_AXI_ID_WIDTH-1 downto 0);
        WDATA           : out STD_LOGIC_VECTOR(C_M_AXI_DATA_WIDTH-1 downto 0);
        WSTRB           : out STD_LOGIC_VECTOR(C_M_AXI_DATA_WIDTH/8-1 downto 0);
        WLAST           : out STD_LOGIC;
        WUSER           : out STD_LOGIC_VECTOR(C_M_AXI_WUSER_WIDTH-1 downto 0);
        WVALID          : out STD_LOGIC;
        WREADY          : in  STD_LOGIC;
        -- write response channel
        BID             : in  STD_LOGIC_VECTOR(C_M_AXI_ID_WIDTH-1 downto 0);
        BRESP           : in  STD_LOGIC_VECTOR(1 downto 0);
        BUSER           : in  STD_LOGIC_VECTOR(C_M_AXI_BUSER_WIDTH-1 downto 0);
        BVALID          : in  STD_LOGIC;
        BREADY          : out STD_LOGIC;
        -- read address channel
        ARID            : out STD_LOGIC_VECTOR(C_M_AXI_ID_WIDTH-1 downto 0);
        ARADDR          : out STD_LOGIC_VECTOR(C_M_AXI_ADDR_WIDTH-1 downto 0);
        ARLEN           : out STD_LOGIC_VECTOR(7 downto 0);
        ARSIZE          : out STD_LOGIC_VECTOR(2 downto 0);
        ARBURST         : out STD_LOGIC_VECTOR(1 downto 0);
        ARLOCK          : out STD_LOGIC_VECTOR(1 downto 0);
        ARCACHE         : out STD_LOGIC_VECTOR(3 downto 0);
        ARPROT          : out STD_LOGIC_VECTOR(2 downto 0);
        ARQOS           : out STD_LOGIC_VECTOR(3 downto 0);
        ARREGION        : out STD_LOGIC_VECTOR(3 downto 0);
        ARUSER          : out STD_LOGIC_VECTOR(C_M_AXI_ARUSER_WIDTH-1 downto 0);
        ARVALID         : out STD_LOGIC;
        ARREADY         : in  STD_LOGIC;
        -- read data channel
        RID             : in  STD_LOGIC_VECTOR(C_M_AXI_ID_WIDTH-1 downto 0);
        RDATA           : in  STD_LOGIC_VECTOR(C_M_AXI_DATA_WIDTH-1 downto 0);
        RRESP           : in  STD_LOGIC_VECTOR(1 downto 0);
        RLAST           : in  STD_LOGIC;
        RUSER           : in  STD_LOGIC_VECTOR(C_M_AXI_RUSER_WIDTH-1 downto 0);
        RVALID          : in  STD_LOGIC;
        RREADY          : out STD_LOGIC;
        -- multiple internal channels 
        -- channel 0 --  READ-ONLY 
        I_CH0_AWADDR    : in  STD_LOGIC_VECTOR(CH0_USER_AW-1 downto 0);
        I_CH0_AWLEN     : in  STD_LOGIC_VECTOR(USER_LEN_WIDTH-1 downto 0);
        I_CH0_AWVALID   : in  STD_LOGIC;
        I_CH0_AWREADY   : out STD_LOGIC;
        I_CH0_WDATA     : in  STD_LOGIC_VECTOR(CH0_USER_DW-1 downto 0);
        I_CH0_WSTRB     : in  STD_LOGIC_VECTOR(CH0_USER_DW/8-1 downto 0);
        I_CH0_WVALID    : in  STD_LOGIC;
        I_CH0_WREADY    : out STD_LOGIC;
        I_CH0_BVALID    : out STD_LOGIC;
        I_CH0_BREADY    : in  STD_LOGIC;
        I_CH0_ARADDR    : in  STD_LOGIC_VECTOR(CH0_USER_AW-1 downto 0);
        I_CH0_ARLEN     : in  STD_LOGIC_VECTOR(USER_LEN_WIDTH-1 downto 0);
        I_CH0_ARVALID   : in  STD_LOGIC;
        I_CH0_ARREADY   : out STD_LOGIC;
        I_CH0_RDATA     : out STD_LOGIC_VECTOR(CH0_USER_DW-1 downto 0);
        I_CH0_RFIFONUM  : out STD_LOGIC_VECTOR(CH0_USER_RFIFONUM_WIDTH-1 downto 0);
        I_CH0_RVALID    : out STD_LOGIC;
        I_CH0_RREADY    : in  STD_LOGIC
        );
end entity mm2s_gmem_m_axi;

architecture behave of mm2s_gmem_m_axi is
    --========================Constant========================
    constant NUM_READ_PORTS  : INTEGER := 1;
    constant NUM_WRITE_PORTS : INTEGER := 0;
    --========================Component======================== 
    component mm2s_gmem_m_axi_load is
        generic (
            C_TARGET_ADDR          : INTEGER := 16#00000000#;
            NUM_READ_OUTSTANDING   : INTEGER := 2;
            MAX_READ_BURST_LENGTH  : INTEGER := 16;
            BUS_ADDR_WIDTH         : INTEGER := 32;
            BUS_DATA_WIDTH         : INTEGER := 32;
            USER_DW                : INTEGER := 16;
            USER_AW                : INTEGER := 32;
            USER_LEN_WIDTH         : INTEGER := 32;
            USER_MAXREQS           : INTEGER := 16;
            USER_RFIFONUM_WIDTH    : INTEGER := 6;
            BUFFER_IMPL            : STRING  := "auto");
        port (
            ACLK                   : in  STD_LOGIC;
            ARESET                 : in  STD_LOGIC;
            ACLK_EN                : in  STD_LOGIC;
            out_AXI_ARADDR         : out UNSIGNED(BUS_ADDR_WIDTH-1 downto 0);
            out_AXI_ARLEN          : out UNSIGNED(USER_LEN_WIDTH-1 downto 0);
            out_AXI_ARVALID        : out STD_LOGIC;
            in_AXI_ARREADY         : in  STD_LOGIC;
            in_AXI_RDATA           : in  UNSIGNED(BUS_DATA_WIDTH-1 downto 0);
            in_AXI_RLAST           : in  UNSIGNED(1 downto 0);
            in_AXI_RVALID          : in  STD_LOGIC;
            out_AXI_RREADY         : out STD_LOGIC;
            out_BURST_RREADY       : out STD_LOGIC;
            in_HLS_ARADDR          : in  UNSIGNED(USER_AW-1 downto 0);
            in_HLS_ARLEN           : in  UNSIGNED(USER_LEN_WIDTH-1 downto 0);
            in_HLS_ARVALID         : in  STD_LOGIC;
            out_HLS_ARREADY        : out STD_LOGIC;
            out_HLS_RDATA          : out UNSIGNED(USER_DW-1 downto 0);
            out_HLS_RVALID         : out STD_LOGIC;
            in_HLS_RREADY          : in  STD_LOGIC;
            out_HLS_RFIFONUM       : out UNSIGNED(USER_RFIFONUM_WIDTH-1 downto 0));
    end component mm2s_gmem_m_axi_load;
    component mm2s_gmem_m_axi_read is
        generic (
            C_M_AXI_ID_WIDTH       : INTEGER := 1;
            C_M_AXI_ARUSER_WIDTH   : INTEGER := 1;
            C_M_AXI_RUSER_WIDTH    : INTEGER := 1;
            C_USER_VALUE           : INTEGER := 0;
            C_PROT_VALUE           : INTEGER := 0;
            C_CACHE_VALUE          : INTEGER := 2#0011#;
            BUS_ADDR_WIDTH         : INTEGER := 32;
            BUS_DATA_WIDTH         : INTEGER := 32;
            USER_LEN_WIDTH         : INTEGER := 32;
            MAX_READ_BURST_LENGTH  : INTEGER := 1;
            NUM_READ_OUTSTANDING   : INTEGER := 2;
            ID0_NUM_READ_OUTSTANDING : INTEGER := 2;
            NUM_READ_PORTS         : INTEGER := 1);
        port (
            ACLK                   : in  STD_LOGIC;
            ARESET                 : in  STD_LOGIC;
            ACLK_EN                : in  STD_LOGIC;
            out_BUS_ARID           : out UNSIGNED(C_M_AXI_ID_WIDTH-1 downto 0);
            out_BUS_ARADDR         : out UNSIGNED(BUS_ADDR_WIDTH-1 downto 0);
            out_BUS_ARLEN          : out UNSIGNED(7 downto 0);
            out_BUS_ARSIZE         : out UNSIGNED(2 downto 0);
            out_BUS_ARBURST        : out UNSIGNED(1 downto 0);
            out_BUS_ARLOCK         : out UNSIGNED(1 downto 0);
            out_BUS_ARCACHE        : out UNSIGNED(3 downto 0);
            out_BUS_ARPROT         : out UNSIGNED(2 downto 0);
            out_BUS_ARQOS          : out UNSIGNED(3 downto 0);
            out_BUS_ARREGION       : out UNSIGNED(3 downto 0);
            out_BUS_ARUSER         : out UNSIGNED(C_M_AXI_ARUSER_WIDTH-1 downto 0);
            out_BUS_ARVALID        : out STD_LOGIC;
            in_BUS_ARREADY         : in  STD_LOGIC;
            in_BUS_RID             : in  UNSIGNED(C_M_AXI_ID_WIDTH-1 downto 0);
            in_BUS_RDATA           : in  UNSIGNED(BUS_DATA_WIDTH-1 downto 0);
            in_BUS_RRESP           : in  UNSIGNED(1 downto 0);
            in_BUS_RLAST           : in  STD_LOGIC;
            in_BUS_RUSER           : in  UNSIGNED(C_M_AXI_RUSER_WIDTH-1 downto 0);
            in_BUS_RVALID          : in  STD_LOGIC;
            out_BUS_RREADY         : out STD_LOGIC;
            in_AXI_ARID            : in  UNSIGNED(C_M_AXI_ID_WIDTH-1 downto 0);
            in_AXI_ARADDR          : in  UNSIGNED(BUS_ADDR_WIDTH-1 downto 0);
            in_AXI_ARLEN           : in  UNSIGNED(USER_LEN_WIDTH-1 downto 0);
            in_AXI_ARVALID         : in  STD_LOGIC;
            out_AXI_ARREADY        : out UNSIGNED(NUM_READ_PORTS-1 downto 0);
            out_AXI_RDATA          : out UNSIGNED(BUS_DATA_WIDTH-1 downto 0);
            out_AXI_RLAST          : out UNSIGNED(1 downto 0);
            out_AXI_RVALID         : out UNSIGNED(NUM_READ_PORTS-1 downto 0);
            in_AXI_RREADY          : in  UNSIGNED(NUM_READ_PORTS-1 downto 0);
            in_BURST_RREADY        : in  UNSIGNED(NUM_READ_PORTS-1 downto 0));
    end component mm2s_gmem_m_axi_read;
    --========================Local Signals===================
    -- AW/W/B channel signals 

    -- AR/R channel signals 
    type ARID_ARRAY   is array (0 to NUM_READ_PORTS-1) of UNSIGNED(C_M_AXI_ID_WIDTH-1 downto 0);
    type ARADDR_ARRAY is array (0 to NUM_READ_PORTS-1) of UNSIGNED(C_M_AXI_ADDR_WIDTH-1 downto 0);
    type ARLEN_ARRAY  is array (0 to NUM_READ_PORTS-1) of UNSIGNED(USER_LEN_WIDTH-1 downto 0);

    signal local_CHN_ARADDR        : ARADDR_ARRAY;
    signal local_CHN_ARLEN         : ARLEN_ARRAY;
    signal local_CHN_ARVALID       : UNSIGNED(NUM_READ_PORTS-1 downto 0);
    signal local_CHN_ARREADY       : UNSIGNED(NUM_READ_PORTS-1 downto 0);
    signal local_CHN_RDATA         : UNSIGNED(C_M_AXI_DATA_WIDTH-1 downto 0);
    signal local_CHN_RLAST         : UNSIGNED(1 downto 0);
    signal local_CHN_RVALID        : UNSIGNED(NUM_READ_PORTS-1 downto 0);
    signal local_CHN_RREADY        : UNSIGNED(NUM_READ_PORTS-1 downto 0);

    signal local_AXI_ARID          : UNSIGNED(C_M_AXI_ID_WIDTH-1 downto 0);
    signal local_AXI_ARADDR        : UNSIGNED(C_M_AXI_ADDR_WIDTH-1 downto 0);
    signal local_AXI_ARLEN         : UNSIGNED(USER_LEN_WIDTH-1 downto 0);
    signal local_AXI_ARVALID       : STD_LOGIC;
    signal local_AXI_RDATA         : UNSIGNED(C_M_AXI_DATA_WIDTH-1 downto 0);
    signal local_AXI_RLAST         : UNSIGNED(1 downto 0);
    
    signal local_AXI_ARREADY       : UNSIGNED(NUM_READ_PORTS-1 downto 0);
    signal local_AXI_RVALID        : UNSIGNED(NUM_READ_PORTS-1 downto 0);
    signal local_AXI_RREADY        : UNSIGNED(NUM_READ_PORTS-1 downto 0);
    signal local_BURST_RREADY      : UNSIGNED(NUM_READ_PORTS-1 downto 0);

    -- flush logic 
begin
    -- AXI Ports Initialization
    AWID     <= (others=>'0');
    AWADDR   <= (others=>'0');
    AWLEN    <= (others=>'0');
    AWSIZE   <= (others=>'0');
    AWBURST  <= (others=>'0');
    AWLOCK   <= (others=>'0');
    AWCACHE  <= (others=>'0');
    AWPROT   <= (others=>'0');
    AWQOS    <= (others=>'0');
    AWREGION <= (others=>'0');
    AWUSER   <= (others=>'0');
    AWVALID  <= '0';
    WID      <= (others=>'0');
    WDATA    <= (others=>'0');
    WSTRB    <= (others=>'0');
    WLAST    <= '0';
    WUSER    <= (others=>'0');
    WVALID   <= '0';
    BREADY   <= '0';

    -- Kernel Ports Initialization
    I_CH0_AWREADY   <= '0';
    I_CH0_WREADY    <= '0';
    I_CH0_BVALID    <= '0';

    -- Internal Ports Mapping
    local_AXI_ARID        <= (others=>'0');
    local_CHN_ARREADY     <= local_AXI_ARREADY;
    local_AXI_ARVALID     <= local_CHN_ARVALID(0);
    local_AXI_ARADDR      <= local_CHN_ARADDR(TO_INTEGER(local_AXI_ARID));
    local_AXI_ARLEN       <= local_CHN_ARLEN(TO_INTEGER(local_AXI_ARID));
    local_AXI_RREADY      <= local_CHN_RREADY;
    local_CHN_RDATA       <= local_AXI_RDATA;
    local_CHN_RLAST       <= local_AXI_RLAST;
    local_CHN_RVALID      <= local_AXI_RVALID;

    -- flush logic 
    --========================Instantiation========================
    -- ++++++++++++++++++++++ STORE UNITS ++++++++++++++++++++++ 
    -- ++++++++++++++++++++++ LOAD UNITS ++++++++++++++++++++++
    -- load_unit for channel 0
    load_unit_0 : mm2s_gmem_m_axi_load
    generic map(
        C_TARGET_ADDR          => C_TARGET_ADDR,
        NUM_READ_OUTSTANDING   => CH0_NUM_READ_OUTSTANDING,
        MAX_READ_BURST_LENGTH  => MAX_READ_BURST_LENGTH,
        BUS_ADDR_WIDTH         => C_M_AXI_ADDR_WIDTH,
        BUS_DATA_WIDTH         => C_M_AXI_DATA_WIDTH,
        USER_DW                => CH0_USER_DW,
        USER_AW                => CH0_USER_AW,
        USER_LEN_WIDTH         => USER_LEN_WIDTH,
        USER_MAXREQS           => USER_MAXREQS,
        USER_RFIFONUM_WIDTH    => CH0_USER_RFIFONUM_WIDTH,
        BUFFER_IMPL            => MAXI_BUFFER_IMPL
        )
    port map(
        ACLK                   => ACLK,
        ARESET                 => ARESET,
        ACLK_EN                => ACLK_EN,
        out_AXI_ARADDR         => local_CHN_ARADDR(0),
        out_AXI_ARLEN          => local_CHN_ARLEN(0),
        out_AXI_ARVALID        => local_CHN_ARVALID(0),
        in_AXI_ARREADY         => local_CHN_ARREADY(0),
        in_AXI_RDATA           => local_CHN_RDATA,
        in_AXI_RLAST           => local_CHN_RLAST,
        in_AXI_RVALID          => local_CHN_RVALID(0),
        out_AXI_RREADY         => local_CHN_RREADY(0),
        out_BURST_RREADY       => local_BURST_RREADY(0),
        in_HLS_ARADDR          => UNSIGNED(I_CH0_ARADDR),
        in_HLS_ARLEN           => UNSIGNED(I_CH0_ARLEN),
        in_HLS_ARVALID         => I_CH0_ARVALID,
        out_HLS_ARREADY        => I_CH0_ARREADY,
        out_HLS_RVALID         => I_CH0_RVALID,
        in_HLS_RREADY          => I_CH0_RREADY,
        STD_LOGIC_VECTOR(out_HLS_RDATA)    => I_CH0_RDATA,
        STD_LOGIC_VECTOR(out_HLS_RFIFONUM) => I_CH0_RFIFONUM );



    -- ++++++++++++++++++++++ AXI BUS READ/WRITE ++++++++++++++++++++++
    -- mm2s_gmem_m_axi_write 

    -- mm2s_gmem_m_axi_read 
    bus_read : mm2s_gmem_m_axi_read
    generic map (
        C_M_AXI_ID_WIDTH                   => C_M_AXI_ID_WIDTH,
        C_M_AXI_ARUSER_WIDTH               => C_M_AXI_ARUSER_WIDTH,
        C_M_AXI_RUSER_WIDTH                => C_M_AXI_RUSER_WIDTH,
        C_USER_VALUE                       => C_USER_VALUE,
        C_PROT_VALUE                       => C_PROT_VALUE,
        C_CACHE_VALUE                      => C_CACHE_VALUE,
        BUS_ADDR_WIDTH                     => C_M_AXI_ADDR_WIDTH,
        BUS_DATA_WIDTH                     => C_M_AXI_DATA_WIDTH,
        USER_LEN_WIDTH                     => USER_LEN_WIDTH,
        MAX_READ_BURST_LENGTH              => MAX_READ_BURST_LENGTH,
        NUM_READ_OUTSTANDING               => NUM_READ_OUTSTANDING,
        -- outstanding control for channels
        ID0_NUM_READ_OUTSTANDING           => CH0_NUM_READ_OUTSTANDING,
        NUM_READ_PORTS                     =>  NUM_READ_PORTS )
    port map (
        ACLK                               => ACLK,
        ARESET                             => ARESET,
        ACLK_EN                            => ACLK_EN,
        STD_LOGIC_VECTOR(out_BUS_ARID)     => ARID,
        STD_LOGIC_VECTOR(out_BUS_ARADDR)   => ARADDR,
        STD_LOGIC_VECTOR(out_BUS_ARLEN)    => ARLEN,
        STD_LOGIC_VECTOR(out_BUS_ARSIZE)   => ARSIZE,
        STD_LOGIC_VECTOR(out_BUS_ARBURST)  => ARBURST,
        STD_LOGIC_VECTOR(out_BUS_ARLOCK)   => ARLOCK,
        STD_LOGIC_VECTOR(out_BUS_ARCACHE)  => ARCACHE,
        STD_LOGIC_VECTOR(out_BUS_ARPROT)   => ARPROT,
        STD_LOGIC_VECTOR(out_BUS_ARQOS)    => ARQOS,
        STD_LOGIC_VECTOR(out_BUS_ARREGION) => ARREGION,
        STD_LOGIC_VECTOR(out_BUS_ARUSER)   => ARUSER,
        out_BUS_ARVALID                    => ARVALID ,
        in_BUS_ARREADY                     => ARREADY,
        in_BUS_RID                         => UNSIGNED(RID),
        in_BUS_RDATA                       => UNSIGNED(RDATA),
        in_BUS_RRESP                       => UNSIGNED(RRESP),
        in_BUS_RLAST                       => RLAST,
        in_BUS_RUSER                       => UNSIGNED(RUSER),
        in_BUS_RVALID                      => RVALID,
        out_BUS_RREADY                     => RREADY,
        in_AXI_ARID                        => local_AXI_ARID,
        in_AXI_ARVALID                     => local_AXI_ARVALID,
        out_AXI_ARREADY                    => local_AXI_ARREADY,
        in_AXI_ARADDR                      => local_AXI_ARADDR,
        in_AXI_ARLEN                       => local_AXI_ARLEN,
        out_AXI_RVALID                     => local_AXI_RVALID,
        in_AXI_RREADY                      => local_AXI_RREADY,
        out_AXI_RDATA                      => local_AXI_RDATA,
        out_AXI_RLAST                      => local_AXI_RLAST,
        in_BURST_RREADY                    => local_BURST_RREADY
    );

end architecture behave;

-- 67d7842dbbe25473c3c32b93c0da8047785f30d78e8a024de1b57352245f9689
library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.NUMERIC_STD.all;

entity mm2s_gmem_m_axi_load is
    generic (
        C_TARGET_ADDR         : INTEGER := 16#00000000#;
        NUM_READ_OUTSTANDING  : INTEGER := 2;
        MAX_READ_BURST_LENGTH : INTEGER := 16;
        BUS_ADDR_WIDTH        : INTEGER := 32;
        BUS_DATA_WIDTH        : INTEGER := 32;
        USER_DW               : INTEGER := 16;
        USER_AW               : INTEGER := 32;
        USER_LEN_WIDTH        : INTEGER := 32;
        USER_MAXREQS          : INTEGER := 16;
        USER_RFIFONUM_WIDTH   : INTEGER := 6;
        BUFFER_IMPL           : STRING  := "auto");
    port (
        ACLK                  : in  STD_LOGIC;
        ARESET                : in  STD_LOGIC;
        ACLK_EN               : in  STD_LOGIC;
        out_AXI_ARADDR        : out UNSIGNED(BUS_ADDR_WIDTH-1 downto 0);
        out_AXI_ARLEN         : out UNSIGNED(USER_LEN_WIDTH-1 downto 0);
        out_AXI_ARVALID       : out STD_LOGIC;
        in_AXI_ARREADY        : in  STD_LOGIC;
        in_AXI_RDATA          : in  UNSIGNED(BUS_DATA_WIDTH-1 downto 0);
        in_AXI_RLAST          : in  UNSIGNED(1 downto 0);
        in_AXI_RVALID         : in  STD_LOGIC;
        out_AXI_RREADY        : out STD_LOGIC;
        out_BURST_RREADY      : out STD_LOGIC;
        in_HLS_ARADDR         : in  UNSIGNED(USER_AW-1 downto 0);
        in_HLS_ARLEN          : in  UNSIGNED(USER_LEN_WIDTH-1 downto 0);
        in_HLS_ARVALID        : in  STD_LOGIC;
        out_HLS_ARREADY       : out STD_LOGIC;
        out_HLS_RDATA         : out UNSIGNED(USER_DW-1 downto 0);
        out_HLS_RVALID        : out STD_LOGIC;
        in_HLS_RREADY         : in  STD_LOGIC;
        out_HLS_RFIFONUM      : out UNSIGNED(USER_RFIFONUM_WIDTH-1 downto 0));
end entity mm2s_gmem_m_axi_load;

architecture behave of mm2s_gmem_m_axi_load is
    ------------------------Task and function--------------
    function calc_data_width (x : INTEGER) return INTEGER is
        variable y : INTEGER;
    begin
        y := 8;
        while y < x loop
            y := y * 2;
        end loop;
        return y;
    end function calc_data_width;

    function log2 (x : INTEGER) return INTEGER is
        variable n, m : INTEGER;
    begin
        n := 0;
        m := 1;
        while m < x loop
            n := n + 1;
            m := m * 2;
        end loop;
        return n;
    end function log2;
    ------------------------Parameter----------------------
    constant USER_DATA_WIDTH  : INTEGER := calc_data_width(USER_DW);
    constant USER_DATA_ALIGN  : INTEGER := USER_DATA_WIDTH;
    constant USER_ADDR_ALIGN  : INTEGER := log2(USER_DATA_WIDTH/8);
    constant RREQ_PACK_WIDTH  : INTEGER := USER_AW + USER_LEN_WIDTH;
    constant BUS_ADDR_ALIGN   : INTEGER := log2(BUS_DATA_WIDTH/8);
    -- rdata buffer size 
    constant RBUFF_DEPTH      : INTEGER := MAX_READ_BURST_LENGTH * NUM_READ_OUTSTANDING;
    constant PREFERRED_IMPL   : STRING  := "shiftreg" when (RBUFF_DEPTH <= 32) else BUFFER_IMPL;
    constant TARGET_ADDR      : INTEGER := (C_TARGET_ADDR/(2**USER_ADDR_ALIGN))*(2**USER_ADDR_ALIGN);
    ------------------------Local signal-------------------
    signal next_rreq        : STD_LOGIC;
    signal ready_for_rreq   : STD_LOGIC;
    signal rreq_ready       : STD_LOGIC;
    signal rreq_valid       : STD_LOGIC;
    signal valid_length     : STD_LOGIC;
    
    signal rreq_addr        : UNSIGNED(USER_AW-1 downto 0);
    signal rreq_len         : UNSIGNED(USER_LEN_WIDTH-1 downto 0);
    signal tmp_addr         : UNSIGNED(BUS_ADDR_WIDTH-1 downto 0);
    signal tmp_len          : UNSIGNED(USER_LEN_WIDTH-1 downto 0);
    signal tmp_valid        : STD_LOGIC;

    signal local_AXI_RVALID : STD_LOGIC;
    signal local_AXI_RREADY : STD_LOGIC;
    signal local_AXI_RDATA  : UNSIGNED(BUS_DATA_WIDTH-1 downto 0);
    signal local_AXI_RLAST  : UNSIGNED(1 downto 0);
    signal in_AXI_RDATA_PACK  : UNSIGNED(BUS_DATA_WIDTH+1 downto 0);
    signal out_AXI_RDATA_PACK : UNSIGNED(BUS_DATA_WIDTH+1 downto 0);
    signal local_AXI_RFIFONUM : UNSIGNED(log2(RBUFF_DEPTH) downto 0);
    signal ready_for_outstanding : STD_LOGIC; 

    signal in_rreq_pack     : UNSIGNED(RREQ_PACK_WIDTH-1 downto 0);
    signal out_rreq_pack    : UNSIGNED(RREQ_PACK_WIDTH-1 downto 0);
    -- regslice io ?  no 
    -- enable regslice on R channel  no 

    component mm2s_gmem_m_axi_fifo is
        generic (
            MEM_STYLE         : STRING  := "shiftreg";
            DATA_WIDTH        : INTEGER := 8;
            ADDR_WIDTH        : INTEGER := 4;
            DEPTH             : INTEGER := 16);
        port (
            clk               : in  STD_LOGIC;
            reset             : in  STD_LOGIC;
            clk_en            : in  STD_LOGIC;
            if_full_n         : out STD_LOGIC;
            if_write          : in  STD_LOGIC;
            if_din            : in  UNSIGNED(DATA_WIDTH-1 downto 0);
            if_empty_n        : out STD_LOGIC;
            if_read           : in  STD_LOGIC;
            if_dout           : out UNSIGNED(DATA_WIDTH-1 downto 0);
            if_num_data_valid : out UNSIGNED(ADDR_WIDTH downto 0));
    end component mm2s_gmem_m_axi_fifo;

    component mm2s_gmem_m_axi_reg_slice is
        generic (
            DATA_WIDTH  : INTEGER := 8);
        port (
            clk         : in  STD_LOGIC;
            reset       : in  STD_LOGIC;
            s_data      : in  UNSIGNED(DATA_WIDTH-1 downto 0);
            s_valid     : in  STD_LOGIC;
            s_ready     : out STD_LOGIC;
            m_data      : out UNSIGNED(DATA_WIDTH-1 downto 0);
            m_valid     : out STD_LOGIC;
            m_ready     : in  STD_LOGIC);
    end component mm2s_gmem_m_axi_reg_slice;

begin

    -- Instantiation
    
    fifo_rreq : mm2s_gmem_m_axi_fifo
    generic map (
        DATA_WIDTH        => RREQ_PACK_WIDTH,
        ADDR_WIDTH        => log2(USER_MAXREQS),
        DEPTH             => USER_MAXREQS)
    port map (
        clk               => ACLK,
        reset             => ARESET,
        clk_en            => ACLK_EN,
        if_full_n         => out_HLS_ARREADY,
        if_write          => in_HLS_ARVALID,
        if_din            => in_rreq_pack,
        if_empty_n        => rreq_valid,
        if_read           => next_rreq,
        if_dout           => out_rreq_pack,
        if_num_data_valid => open);

    -- ===================================================================
    -- start of ARADDR PREPROCESSOR
    in_rreq_pack    <= in_HLS_ARLEN & in_HLS_ARADDR;
    rreq_len        <= out_rreq_pack(USER_AW + USER_LEN_WIDTH-1 downto USER_AW);
    rreq_addr       <= out_rreq_pack(USER_AW - 1 downto 0);

    next_rreq       <= rreq_valid and ready_for_rreq;
    ready_for_rreq  <= (not tmp_valid) or (in_AXI_ARREADY and rreq_ready);
    valid_length    <= '1' when rreq_len /= 0 and rreq_len(USER_LEN_WIDTH-1) = '0' else '0';

    out_AXI_ARLEN   <= tmp_len;   -- Byte length
    out_AXI_ARADDR  <= tmp_addr;  -- Byte address
    out_AXI_ARVALID <= tmp_valid and rreq_ready;

    process (ACLK)
    begin
        if (ACLK'event and ACLK = '1') then
            if (ARESET = '1') then
                tmp_addr  <= (others => '0');
                tmp_len   <= (others => '0');
            elsif ACLK_EN = '1' then
                if (next_rreq = '1') then
                    tmp_addr  <= TARGET_ADDR + SHIFT_LEFT(RESIZE(rreq_addr, BUS_ADDR_WIDTH), USER_ADDR_ALIGN);
                    tmp_len   <= SHIFT_LEFT(rreq_len, USER_ADDR_ALIGN) - 1;
                end if;
            end if;
        end if;
    end process;

    process (ACLK)
    begin
        if (ACLK'event and ACLK = '1') then
            if (ARESET = '1') then
                tmp_valid  <= '0';
            elsif ACLK_EN = '1' then
                if (next_rreq and valid_length) = '1' then
                    tmp_valid <= '1';
                elsif (in_AXI_ARREADY and rreq_ready) = '1' then
                    tmp_valid <= '0';
                end if;
            end if;
        end if;
    end process;

    -- end of ARADDR PREPROCESSOR
    -- ===================================================================
    
    -- R channel regslice 

    -- R channel fifo
    buff_rdata : mm2s_gmem_m_axi_fifo
    generic map (
        MEM_STYLE         => PREFERRED_IMPL,
        DATA_WIDTH        => BUS_DATA_WIDTH + 2,
        ADDR_WIDTH        => log2(RBUFF_DEPTH),
        DEPTH             => RBUFF_DEPTH)
    port map (
        clk               => ACLK,
        reset             => ARESET,
        clk_en            => ACLK_EN,
        if_full_n         => out_AXI_RREADY,
        if_write          => in_AXI_RVALID,
        if_din            => in_AXI_RDATA_PACK,
        if_empty_n        => local_AXI_RVALID,
        if_read           => local_AXI_RREADY,
        if_dout           => out_AXI_RDATA_PACK,
        if_num_data_valid => local_AXI_RFIFONUM);

    in_AXI_RDATA_PACK     <= in_AXI_RLAST & in_AXI_RDATA;
    local_AXI_RDATA       <= out_AXI_RDATA_PACK(BUS_DATA_WIDTH-1 downto 0);
    local_AXI_RLAST       <= out_AXI_RDATA_PACK(BUS_DATA_WIDTH+1 downto BUS_DATA_WIDTH);

    -- Outstanding control
    out_BURST_RREADY      <= ready_for_outstanding;
    process (ACLK)
    begin
        if (ACLK'event and ACLK = '1') then
            if (ARESET = '1') then
                ready_for_outstanding  <= '1';
            elsif ACLK_EN = '1' then
                if (local_AXI_RREADY = '1' and local_AXI_RVALID = '1') then
                    ready_for_outstanding <= local_AXI_RLAST(1);
                else
                    ready_for_outstanding <= '0';
                end if;
            end if;
        end if;
    end process;

    -- ===================================================================
    -- start of RDATA PREPROCESSOR
    bus_equal_gen : if (USER_DATA_ALIGN = BUS_DATA_WIDTH) generate
    begin
        rreq_ready       <= '1';
        -- R channel regslice ?  disabled
        local_AXI_RREADY <= in_HLS_RREADY;
        out_HLS_RDATA    <= local_AXI_RDATA(USER_DW-1 downto 0);
        out_HLS_RVALID   <= local_AXI_RVALID;
        out_HLS_RFIFONUM <= RESIZE(local_AXI_RFIFONUM, USER_RFIFONUM_WIDTH); 

    end generate bus_equal_gen;

    bus_wide_gen : if (USER_DATA_ALIGN < BUS_DATA_WIDTH) generate
        constant TOTAL_SPLIT    : INTEGER := BUS_DATA_WIDTH / USER_DATA_ALIGN;
        constant SPLIT_ALIGN    : INTEGER := log2(TOTAL_SPLIT);

        signal  tmp_addr_end    : UNSIGNED(BUS_ADDR_ALIGN-1 downto 0);
        signal  offset_full_n   : STD_LOGIC;
        signal  offset_write    : STD_LOGIC;
        signal  offset_valid    : STD_LOGIC;
        signal  next_offset     : STD_LOGIC;

        signal  start_offset    : UNSIGNED(SPLIT_ALIGN-1 downto 0);
        signal  end_offset      : UNSIGNED(SPLIT_ALIGN-1 downto 0);
        signal  head_offset     : UNSIGNED(SPLIT_ALIGN-1 downto 0);
        signal  tail_offset     : UNSIGNED(SPLIT_ALIGN-1 downto 0);
        signal  offset_pack_in  : UNSIGNED(2*SPLIT_ALIGN-1 downto 0);
        signal  offset_pack_out : UNSIGNED(2*SPLIT_ALIGN-1 downto 0);

        signal  rdata_pack      : UNSIGNED(BUS_DATA_WIDTH downto 0);
        signal  rdata_data      : UNSIGNED(BUS_DATA_WIDTH-1 downto 0);
        signal  rdata_last      : STD_LOGIC;
        signal  rdata_valid     : STD_LOGIC;
        signal  next_rdata      : STD_LOGIC;
        signal  data_buf        : UNSIGNED(BUS_DATA_WIDTH-1 downto 0);
        signal  data_valid      : STD_LOGIC;

        signal  rdata_nvalid    : UNSIGNED(USER_RFIFONUM_WIDTH-1 downto 0);
        signal  data_nvalid     : UNSIGNED(SPLIT_ALIGN downto 0);
        signal  split_nvalid    : UNSIGNED(SPLIT_ALIGN downto 0);

        signal  split_cnt_end   : UNSIGNED(SPLIT_ALIGN-1 downto 0);
        signal  split_cnt       : UNSIGNED(SPLIT_ALIGN-1 downto 0);
        signal  split_cnt_buf   : UNSIGNED(SPLIT_ALIGN-1 downto 0);

        signal  ready_for_data  : BOOLEAN;
        signal  first_data_pred : BOOLEAN;
        signal  first_data      : BOOLEAN;
        signal  last_data       : BOOLEAN;
        
        signal  split_valid     : BOOLEAN;
        signal  first_split     : BOOLEAN;
        signal  first_split_pred : BOOLEAN;
        signal  next_split      : BOOLEAN;
        signal  last_split      : BOOLEAN;

    begin

        rreq_offset : mm2s_gmem_m_axi_fifo
        generic map (
            DATA_WIDTH        => 2*SPLIT_ALIGN,
            ADDR_WIDTH        => log2(NUM_READ_OUTSTANDING),
            DEPTH             => NUM_READ_OUTSTANDING)
        port map (
            clk               => ACLK,
            reset             => ARESET,
            clk_en            => ACLK_EN,
            if_full_n         => offset_full_n,
            if_write          => offset_write,
            if_din            => offset_pack_in,
            if_empty_n        => offset_valid,
            if_read           => next_offset,
            if_dout           => offset_pack_out,
            if_num_data_valid => open);

        rs_rdata_int : mm2s_gmem_m_axi_reg_slice
        generic map (
            DATA_WIDTH        => BUS_DATA_WIDTH + 1)
        port map (
            clk               => ACLK,
            reset             => ARESET,
            s_data            => out_AXI_RDATA_PACK(BUS_DATA_WIDTH downto 0),
            s_valid           => local_AXI_RVALID,
            s_ready           => local_AXI_RREADY,
            m_data            => rdata_pack,
            m_valid           => rdata_valid,
            m_ready           => next_rdata);

        rreq_ready       <= '1' when offset_full_n = '1' or offset_write = '0' else '0';
        tmp_addr_end     <= tmp_addr(BUS_ADDR_ALIGN-1 downto 0) + tmp_len(BUS_ADDR_ALIGN-1 downto 0);
        start_offset     <= tmp_addr(BUS_ADDR_ALIGN-1 downto USER_ADDR_ALIGN);
        end_offset       <= tmp_addr_end(BUS_ADDR_ALIGN-1 downto USER_ADDR_ALIGN);
        offset_write     <= tmp_valid and in_AXI_ARREADY;
        next_offset      <= rdata_last and next_rdata;

        offset_pack_in   <= start_offset & end_offset;
        head_offset      <= offset_pack_out(2*SPLIT_ALIGN-1 downto SPLIT_ALIGN);
        tail_offset      <= offset_pack_out(SPLIT_ALIGN-1 downto 0);

        -- regslice io ?  no
        out_HLS_RDATA    <= data_buf(USER_DW-1 downto 0);
        out_HLS_RVALID   <= data_valid;
        out_HLS_RFIFONUM <= rdata_nvalid + data_nvalid;
        ready_for_data   <= data_valid = '0' or in_HLS_RREADY = '1';

        next_rdata       <= '1' when (rdata_valid = '1') and last_split else '0';
        rdata_last       <= rdata_pack(BUS_DATA_WIDTH);
        rdata_data       <= rdata_pack(BUS_DATA_WIDTH-1 downto 0);
        first_data       <= first_data_pred and split_valid;
        last_data        <= (rdata_last = '1') and split_valid;

        split_valid      <= (rdata_valid and offset_valid) = '1';
        next_split       <= split_valid and ready_for_data;

        first_split      <= first_split_pred and next_split;
        last_split       <= (split_cnt = split_cnt_end) and next_split;

        split_cnt        <= head_offset when first_data and first_split_pred else
                            split_cnt_buf;
        split_cnt_end    <= tail_offset when last_data else
                            TO_UNSIGNED(TOTAL_SPLIT - 1, SPLIT_ALIGN);

        split_nvalid     <= RESIZE(tail_offset, SPLIT_ALIGN+1) - head_offset + 1  when first_data and last_data else
                            RESIZE(tail_offset, SPLIT_ALIGN+1) + 1                when last_data                else
                            TO_UNSIGNED(TOTAL_SPLIT, SPLIT_ALIGN+1) - head_offset when first_data               else
                            TO_UNSIGNED(TOTAL_SPLIT, SPLIT_ALIGN+1);

        process (ACLK)
        begin
            if (ACLK'event and ACLK = '1') then
                if (ARESET = '1') then
                    first_data_pred <= true;
                elsif ACLK_EN = '1' then
                    if next_offset = '1' then
                        first_data_pred <= true;
                    elsif (last_split) then
                        first_data_pred <= false;
                    end if;
                end if;
            end if;
        end process;

        process (ACLK)
        begin
            if (ACLK'event and ACLK = '1') then
                if (ARESET = '1') then
                    first_split_pred <= true;
                    split_cnt_buf <= (others => '0');
                elsif ACLK_EN = '1' then
                    if last_split then
                        first_split_pred <= true;
                        split_cnt_buf <= (others => '0');
                    elsif next_split then
                        first_split_pred <= false;
                        split_cnt_buf <= split_cnt + 1;
                    end if;
                end if;
            end if;
        end process;

        process (ACLK)
        begin
            if (ACLK'event and ACLK = '1') then
                if ACLK_EN = '1' then
                    if first_split and first_data then
                        data_buf <= SHIFT_RIGHT(rdata_data, to_integer(head_offset)*USER_DATA_WIDTH);
                    elsif first_split then
                        data_buf <= rdata_data;
                    elsif next_split then
                        data_buf <= SHIFT_RIGHT(data_buf, USER_DATA_WIDTH);
                    end if;
                end if;
            end if;
        end process;

        process (ACLK)
        begin
            if (ACLK'event and ACLK = '1') then
                if (ARESET = '1') then
                    data_valid <= '0';
                elsif ACLK_EN = '1' then
                    if next_split then
                        data_valid <= '1';
                    elsif ready_for_data then
                        data_valid <= '0';
                    end if;
                end if;
            end if;
        end process;

        process (ACLK)
        begin
            if (ACLK'event and ACLK = '1') then
                if (ARESET = '1') then
                    data_nvalid <= (others=>'0');
                elsif ACLK_EN = '1' then
                    if first_split then
                        data_nvalid <= split_nvalid;
                    elsif next_split then
                        data_nvalid <= data_nvalid - 1;
                    elsif ready_for_data then
                        data_nvalid <= (others=>'0');
                    end if;
                end if;
            end if;
        end process;

        process (ACLK)
        begin
            if (ACLK'event and ACLK = '1') then
                if (ARESET = '1') then
                    rdata_nvalid <= (others=>'0');
                elsif ACLK_EN = '1' then
                    if rdata_valid = '0' then
                        rdata_nvalid <= (others=>'0');
                    elsif local_AXI_RREADY = '0' then 
                        rdata_nvalid <= SHIFT_LEFT(RESIZE(local_AXI_RFIFONUM+1, USER_RFIFONUM_WIDTH), SPLIT_ALIGN);
                    else
                        rdata_nvalid <= SHIFT_LEFT(RESIZE(local_AXI_RFIFONUM, USER_RFIFONUM_WIDTH), SPLIT_ALIGN);
                    end if;
                end if;
            end if;
        end process;

    end generate bus_wide_gen; 

    bus_narrow_gen : if (USER_DATA_ALIGN > BUS_DATA_WIDTH) generate
        constant TOTAL_PADS     : INTEGER := USER_DATA_ALIGN / BUS_DATA_WIDTH;
        constant PAD_ALIGN      : INTEGER := log2(TOTAL_PADS);

        signal  data_buf        : UNSIGNED(USER_DATA_WIDTH-1 downto 0);
        signal  data_nvalid     : UNSIGNED(PAD_ALIGN downto 0);
        signal  data_valid      : STD_LOGIC;
        signal  pad_oh          : UNSIGNED(TOTAL_PADS - 1 downto 0);
        signal  pad_oh_reg      : UNSIGNED(TOTAL_PADS - 1 downto 0);
       
        signal  rdata_num_vld   : UNSIGNED(USER_RFIFONUM_WIDTH - 1 downto 0);
        signal  ready_for_data  : BOOLEAN;
        signal  next_pad        : BOOLEAN;
        signal  first_pad       : BOOLEAN;
        signal  last_pad        : BOOLEAN;
    begin

        rreq_ready       <= '1';
        local_AXI_RREADY <= '1' when next_pad else '0';
        rdata_num_vld    <= RESIZE(local_AXI_RFIFONUM(log2(RBUFF_DEPTH) downto PAD_ALIGN), RBUFF_DEPTH) + SHIFT_RIGHT(local_AXI_RFIFONUM(PAD_ALIGN-1 downto 0) + data_nvalid, PAD_ALIGN);

        -- regslice io ?  no
        out_HLS_RDATA    <= data_buf(USER_DW-1 downto 0);
        out_HLS_RVALID   <= data_valid;
        out_HLS_RFIFONUM <= rdata_num_vld;
        ready_for_data   <= data_valid = '0' or in_HLS_RREADY = '1';

        next_pad         <= local_AXI_RVALID = '1' and ready_for_data;
        last_pad         <= pad_oh(TOTAL_PADS - 1) = '1';

        pad_oh           <= (others => '0')            when local_AXI_RVALID = '0' else
                            TO_UNSIGNED(1, TOTAL_PADS) when first_pad      else
                            pad_oh_reg;

        process (ACLK)
        begin
            if (ACLK'event and ACLK = '1') then
                if (ARESET = '1') then
                    pad_oh_reg <= (others => '0');
                elsif ACLK_EN = '1' then
                    if next_pad then
                        pad_oh_reg <= pad_oh(TOTAL_PADS - 2 downto 0) & '0';
                    end if;
                end if;
            end if;
        end process;

        process (ACLK)
        begin
            if (ACLK'event and ACLK = '1') then
                if (ARESET = '1') then
                    first_pad <= true;
                elsif ACLK_EN = '1' then
                    if next_pad and not last_pad then
                        first_pad <= false;
                    elsif next_pad and last_pad then
                        first_pad <= true;
                    end if;
                end if;
            end if;
        end process;

        data_gen : for i in 0 to TOTAL_PADS-1 generate
        begin
            process (ACLK)
            begin
                if (ACLK'event and ACLK = '1') then
                    if ACLK_EN = '1' then
                        if pad_oh(i) = '1' and ready_for_data then
                            data_buf((i+1)*BUS_DATA_WIDTH - 1 downto i*BUS_DATA_WIDTH) <= local_AXI_RDATA;
                        end if;
                    end if;
                end if;
            end process;
        end generate data_gen;

        process (ACLK)
        begin
            if (ACLK'event and ACLK = '1') then
                if (ARESET = '1') then
                    data_valid <= '0';
                elsif ACLK_EN = '1' then
                    if next_pad and last_pad then
                        data_valid <= '1';
                    elsif ready_for_data then
                        data_valid <= '0';
                    end if;
                end if;
            end if;
        end process;

        process (ACLK)
        begin
            if (ACLK'event and ACLK = '1') then
                if (ARESET = '1') then
                    data_nvalid <= (others=>'0');
                elsif ACLK_EN = '1' then
                    if first_pad then
                        data_nvalid <= TO_UNSIGNED(1,PAD_ALIGN+1);
                    elsif next_pad then
                        data_nvalid <= data_nvalid + 1;
                    end if;
                end if;
            end if;
        end process;
    
    end generate bus_narrow_gen;

    -- end of RDATA PREPROCESSOR
    -- ==================================================================
end architecture behave;




-- 67d7842dbbe25473c3c32b93c0da8047785f30d78e8a024de1b57352245f9689


library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.NUMERIC_STD.all;

entity mm2s_gmem_m_axi_read is
    generic (
        C_M_AXI_ID_WIDTH        : INTEGER := 1;
        C_M_AXI_ARUSER_WIDTH    : INTEGER := 1;
        C_M_AXI_RUSER_WIDTH     : INTEGER := 1;
        C_USER_VALUE            : INTEGER := 0;
        C_PROT_VALUE            : INTEGER := 0;
        C_CACHE_VALUE           : INTEGER := 2#0011#;
        BUS_ADDR_WIDTH          : INTEGER := 32;
        BUS_DATA_WIDTH          : INTEGER := 32;
        USER_LEN_WIDTH          : INTEGER := 32;
        MAX_READ_BURST_LENGTH   : INTEGER := 16;
        NUM_READ_OUTSTANDING    : INTEGER := 2;
        ID0_NUM_READ_OUTSTANDING : INTEGER := 2;
        NUM_READ_PORTS          : INTEGER := 1);
    port (
        ACLK                    : in  STD_LOGIC;
        ARESET                  : in  STD_LOGIC;
        ACLK_EN                 : in  STD_LOGIC;
        out_BUS_ARID            : out UNSIGNED(C_M_AXI_ID_WIDTH-1 downto 0);
        out_BUS_ARADDR          : out UNSIGNED(BUS_ADDR_WIDTH-1 downto 0);
        out_BUS_ARLEN           : out UNSIGNED(7 downto 0);
        out_BUS_ARSIZE          : out UNSIGNED(2 downto 0);
        out_BUS_ARBURST         : out UNSIGNED(1 downto 0);
        out_BUS_ARLOCK          : out UNSIGNED(1 downto 0);
        out_BUS_ARCACHE         : out UNSIGNED(3 downto 0);
        out_BUS_ARPROT          : out UNSIGNED(2 downto 0);
        out_BUS_ARQOS           : out UNSIGNED(3 downto 0);
        out_BUS_ARREGION        : out UNSIGNED(3 downto 0);
        out_BUS_ARUSER          : out UNSIGNED(C_M_AXI_ARUSER_WIDTH-1 downto 0);
        out_BUS_ARVALID         : out STD_LOGIC;
        in_BUS_ARREADY          : in  STD_LOGIC;
        in_BUS_RID              : in  UNSIGNED(C_M_AXI_ID_WIDTH-1 downto 0);
        in_BUS_RDATA            : in  UNSIGNED(BUS_DATA_WIDTH-1 downto 0);
        in_BUS_RRESP            : in  UNSIGNED(1 downto 0);
        in_BUS_RLAST            : in  STD_LOGIC;
        in_BUS_RUSER            : in  UNSIGNED(C_M_AXI_RUSER_WIDTH-1 downto 0);
        in_BUS_RVALID           : in  STD_LOGIC;
        out_BUS_RREADY          : out STD_LOGIC;
        in_AXI_ARID             : in  UNSIGNED(C_M_AXI_ID_WIDTH-1 downto 0);
        in_AXI_ARADDR           : in  UNSIGNED(BUS_ADDR_WIDTH-1 downto 0);
        in_AXI_ARLEN            : in  UNSIGNED(USER_LEN_WIDTH-1 downto 0);
        in_AXI_ARVALID          : in  STD_LOGIC;
        out_AXI_ARREADY         : out UNSIGNED(NUM_READ_PORTS-1 downto 0);
        out_AXI_RDATA           : out UNSIGNED(BUS_DATA_WIDTH-1 downto 0);
        out_AXI_RLAST           : out UNSIGNED(1 downto 0);
        out_AXI_RVALID          : out UNSIGNED(NUM_READ_PORTS-1 downto 0);
        in_AXI_RREADY           : in  UNSIGNED(NUM_READ_PORTS-1 downto 0);
        in_BURST_RREADY         : in  UNSIGNED(NUM_READ_PORTS-1 downto 0));
end entity mm2s_gmem_m_axi_read;

architecture behave of mm2s_gmem_m_axi_read is

    function log2 (x : INTEGER) return INTEGER is
        variable n, m : INTEGER;
    begin
        n := 0;
        m := 1;
        while m < x loop
            n := n + 1;
            m := m * 2;
        end loop;
        return n;
    end function log2;

    function bit_set (idx : UNSIGNED(C_M_AXI_ID_WIDTH-1 downto 0); valid : STD_LOGIC)
    return UNSIGNED is
        variable ret : UNSIGNED(NUM_READ_PORTS-1 downto 0);
    begin
        ret := (others=>'0');
        ret(TO_INTEGER(idx)) := valid;
        return ret;
    end function bit_set;

    function num_outstanding_val (idx : INTEGER)
    return INTEGER is
        variable ret : INTEGER;
    begin
        case (idx) is
            when 0 => ret := ID0_NUM_READ_OUTSTANDING;
            when others => ret := NUM_READ_OUTSTANDING;
        end case;
        return ret;
    end function num_outstanding_val;

    -- Convert the actual AXI ID to the ID locally used by the read module
    function compress_axi_id (axi_id : UNSIGNED(C_M_AXI_ID_WIDTH-1 downto 0))
    return UNSIGNED is
        variable local_id : INTEGER;
    begin
        case TO_INTEGER(axi_id) is
            when 0 => local_id := 0;
            when others => local_id := 0;
        end case;
        return TO_UNSIGNED(local_id, C_M_AXI_ID_WIDTH);
    end function compress_axi_id;

    -- Convert the ID locally used by the read module to the actual AXI ID
    function decompress_axi_id (local_id : UNSIGNED(C_M_AXI_ID_WIDTH-1 downto 0))
    return UNSIGNED is
        variable axi_id : INTEGER;
    begin
        case TO_INTEGER(local_id) is
            when 0 => axi_id := 0;
            when others => axi_id := 0;
        end case;
        return TO_UNSIGNED(axi_id, C_M_AXI_ID_WIDTH);
    end function decompress_axi_id;

    --common
    constant BUS_DATA_BYTES       : INTEGER := BUS_DATA_WIDTH / 8;
    constant BUS_ADDR_ALIGN       : INTEGER := log2(BUS_DATA_BYTES);

    signal  local_BUS_ARID        : UNSIGNED(C_M_AXI_ID_WIDTH-1 downto 0);
    signal  local_BUS_RID         : UNSIGNED(C_M_AXI_ID_WIDTH-1 downto 0);

    signal  ost_ctrl_id           : UNSIGNED(C_M_AXI_ID_WIDTH-1 downto 0);
    signal  ost_ctrl_info         : UNSIGNED(0 downto 0);
    signal  ost_ctrl_valid        : STD_LOGIC;
    signal  ost_ctrl_ready        : UNSIGNED(NUM_READ_PORTS-1 downto 0);
    signal  ost_ctrl_write        : UNSIGNED(NUM_READ_PORTS-1 downto 0);
    signal  ost_ctrl_empty_n      : UNSIGNED(NUM_READ_PORTS-1 downto 0);
    signal  next_ctrl             : UNSIGNED(NUM_READ_PORTS-1 downto 0);

    signal  ost_burst_read        : UNSIGNED(NUM_READ_PORTS-1 downto 0);
    signal  ost_burst_empty_n     : UNSIGNED(NUM_READ_PORTS-1 downto 0);
    signal  ost_burst_info        : UNSIGNED(NUM_READ_PORTS-1 downto 0);
    signal  next_burst            : STD_LOGIC;
    signal  last_burst            : STD_LOGIC;

    signal  data_pack_in          : UNSIGNED(C_M_AXI_ID_WIDTH + BUS_DATA_WIDTH downto 0);
    signal  data_pack_out         : UNSIGNED(C_M_AXI_ID_WIDTH + BUS_DATA_WIDTH downto 0);
    signal  beat_id               : UNSIGNED(C_M_AXI_ID_WIDTH-1 downto 0);
    signal  beat_data             : UNSIGNED(BUS_DATA_WIDTH-1 downto 0);
    signal  beat_last             : STD_LOGIC;
    signal  beat_valid            : STD_LOGIC;
    signal  beat_ready            : STD_LOGIC;
    signal  last_beat             : STD_LOGIC;

    -- regslice io ? 

    -- component
    component mm2s_gmem_m_axi_burst_converter is
        generic (
            INTERLEAVE        : INTEGER := 1;
            ID_WIDTH          : INTEGER := 1;
            DATA_WIDTH        : INTEGER := 32;
            ADDR_WIDTH        : INTEGER := 32;
            LEN_WIDTH         : INTEGER := 32;
            MAX_BURST_LENGTH  : INTEGER := 16;
            NUM_PORTS         : INTEGER := 1);
        port (
            clk               : in  STD_LOGIC;
            reset             : in  STD_LOGIC;
            clk_en            : in  STD_LOGIC;
            in_REQ_ID         : in  UNSIGNED(ID_WIDTH-1 downto 0);
            in_REQ_ADDR       : in  UNSIGNED(ADDR_WIDTH-1 downto 0);
            in_REQ_LEN        : in  UNSIGNED(LEN_WIDTH-1 downto 0);
            in_REQ_VALID      : in  STD_LOGIC;
            out_REQ_READY     : out UNSIGNED(NUM_PORTS-1 downto 0); 
            out_BURST_ID      : out UNSIGNED(ID_WIDTH-1 downto 0);
            out_BURST_ADDR    : out UNSIGNED(ADDR_WIDTH-1 downto 0);
            out_BURST_LEN     : out UNSIGNED(7 downto 0);
            out_BURST_VALID   : out STD_LOGIC;
            in_BURST_READY    : in  STD_LOGIC;
            out_CTRL_ID       : out UNSIGNED(ID_WIDTH-1 downto 0);
            out_CTRL_INFO     : out UNSIGNED(0 downto 0);
            out_CTRL_VALID    : out STD_LOGIC;
            in_CTRL_READY     : in  UNSIGNED(NUM_PORTS-1 downto 0));
    end component mm2s_gmem_m_axi_burst_converter;

    component mm2s_gmem_m_axi_fifo is
        generic (
            MEM_STYLE         : STRING  := "shiftreg";
            DATA_WIDTH        : INTEGER := 8;
            ADDR_WIDTH        : INTEGER := 4;
            DEPTH             : INTEGER := 16);
        port (
            clk               : in  STD_LOGIC;
            reset             : in  STD_LOGIC;
            clk_en            : in  STD_LOGIC;
            if_full_n         : out STD_LOGIC;
            if_write          : in  STD_LOGIC;
            if_din            : in  UNSIGNED(DATA_WIDTH-1 downto 0);
            if_empty_n        : out STD_LOGIC;
            if_read           : in  STD_LOGIC;
            if_dout           : out UNSIGNED(DATA_WIDTH-1 downto 0);
            if_num_data_valid : out UNSIGNED(ADDR_WIDTH downto 0));
    end component mm2s_gmem_m_axi_fifo;

    component mm2s_gmem_m_axi_reg_slice is
        generic (
            DATA_WIDTH  : INTEGER := 8);
        port (
            clk        : in  STD_LOGIC;
            reset       : in  STD_LOGIC;
            s_data      : in  UNSIGNED(DATA_WIDTH-1 downto 0);
            s_valid     : in  STD_LOGIC;
            s_ready     : out STD_LOGIC;
            m_data      : out UNSIGNED(DATA_WIDTH-1 downto 0);
            m_valid     : out STD_LOGIC;
            m_ready     : in  STD_LOGIC);
    end component mm2s_gmem_m_axi_reg_slice;

begin
    --------------------------- BUS global config ----------------------------------
    out_BUS_ARID      <= decompress_axi_id(local_BUS_ARID);
    out_BUS_ARSIZE    <= TO_UNSIGNED(BUS_ADDR_ALIGN, out_BUS_ARSIZE'length);
    out_BUS_ARBURST   <= "01";
    out_BUS_ARLOCK    <= "00";
    out_BUS_ARCACHE   <= TO_UNSIGNED(C_CACHE_VALUE, out_BUS_ARCACHE'length);
    out_BUS_ARPROT    <= TO_UNSIGNED(C_PROT_VALUE, out_BUS_ARPROT'length);
    out_BUS_ARUSER    <= TO_UNSIGNED(C_USER_VALUE, out_BUS_ARUSER'length);
    out_BUS_ARQOS     <= "0000";
    out_BUS_ARREGION  <= "0000";
    --------------------------- AR channel begin -----------------------------------
    -- Instantiation
    rreq_burst_conv : mm2s_gmem_m_axi_burst_converter
    generic map (
        ID_WIDTH         => C_M_AXI_ID_WIDTH,
        DATA_WIDTH       => BUS_DATA_WIDTH,
        ADDR_WIDTH       => BUS_ADDR_WIDTH,
        LEN_WIDTH        => USER_LEN_WIDTH,
        MAX_BURST_LENGTH => MAX_READ_BURST_LENGTH,
        NUM_PORTS        => NUM_READ_PORTS)
    port map (
        clk              => ACLK,
        reset            => ARESET,
        clk_en           => ACLK_EN,
        in_REQ_ID        => in_AXI_ARID,
        in_REQ_ADDR      => in_AXI_ARADDR,
        in_REQ_LEN       => in_AXI_ARLEN,
        in_REQ_VALID     => in_AXI_ARVALID,
        out_REQ_READY    => out_AXI_ARREADY,
        out_BURST_ID     => local_BUS_ARID,
        out_BURST_ADDR   => out_BUS_ARADDR ,
        out_BURST_LEN    => out_BUS_ARLEN,
        out_BURST_VALID  => out_BUS_ARVALID,
        in_BURST_READY   => in_BUS_ARREADY,
        out_CTRL_ID      => ost_ctrl_id,
        out_CTRL_INFO    => ost_ctrl_info,
        out_CTRL_VALID   => ost_ctrl_valid,
        in_CTRL_READY    => ost_ctrl_ready);
    
    --------------------------- AR channel end -------------------------------------

    --------------------------- R channel begin ------------------------------------
    -- Instantiation
    rs_rdata : mm2s_gmem_m_axi_reg_slice
        generic map (
            DATA_WIDTH        => C_M_AXI_ID_WIDTH + BUS_DATA_WIDTH + 1)
        port map (
            clk               => ACLK,
            reset             => ARESET,
            s_data            => data_pack_in,
            s_valid           => in_BUS_RVALID,
            s_ready           => out_BUS_RREADY,
            m_data            => data_pack_out,
            m_valid           => beat_valid,
            m_ready           => beat_ready);

    ost_ctrl_gen : for idx in 0 to NUM_READ_PORTS-1 generate
        fifo_rctl : mm2s_gmem_m_axi_fifo
        generic map (
            DATA_WIDTH        => 1,
            ADDR_WIDTH        => log2(num_outstanding_val(idx)),
            DEPTH             => num_outstanding_val(idx))
        port map (
            clk               => ACLK,
            reset             => ARESET,
            clk_en            => ACLK_EN,
            if_full_n         => ost_ctrl_ready(idx),
            if_write          => ost_ctrl_write(idx),
            if_din            => ost_ctrl_info,
            if_empty_n        => ost_ctrl_empty_n(idx),
            if_read           => next_ctrl(idx),
            if_dout           => open,
            if_num_data_valid => open);
    
        fifo_burst : mm2s_gmem_m_axi_fifo
        generic map (
            DATA_WIDTH        => 1,
            ADDR_WIDTH        => log2(num_outstanding_val(idx)),
            DEPTH             => num_outstanding_val(idx))
        port map (
            clk               => ACLK,
            reset             => ARESET,
            clk_en            => ACLK_EN,
            if_full_n         => open,
            if_write          => ost_ctrl_write(idx),
            if_din            => ost_ctrl_info,
            if_empty_n        => ost_burst_empty_n(idx),
            if_read           => ost_burst_read(idx),
            if_dout           => ost_burst_info(idx downto idx),
            if_num_data_valid => open);
    end generate ost_ctrl_gen;

    data_pack_in   <= local_BUS_RID & in_BUS_RLAST & in_BUS_RDATA;
    beat_data      <= data_pack_out(BUS_DATA_WIDTH-1 downto 0);
    beat_last      <= data_pack_out(BUS_DATA_WIDTH);
    beat_id        <= data_pack_out(C_M_AXI_ID_WIDTH + BUS_DATA_WIDTH downto BUS_DATA_WIDTH+1);

    ost_ctrl_write <= bit_set(ost_ctrl_id, ost_ctrl_valid);
    ost_burst_read <= bit_set(beat_id, next_burst);

    next_ctrl      <= in_BURST_RREADY and ost_ctrl_empty_n;
    next_burst     <= last_beat and beat_valid and beat_ready;

    last_beat      <= '1' when beat_last = '1' else '0';
    last_burst     <= '1' when ost_burst_info(TO_INTEGER(beat_id)) = '1' and ost_burst_empty_n(TO_INTEGER(beat_id)) = '1' else '0';
    beat_ready     <= '1' when in_AXI_RREADY(TO_INTEGER(beat_id)) = '1' else '0';

    out_AXI_RDATA  <= beat_data;
    out_AXI_RVALID <= bit_set(beat_id, beat_valid);
    out_AXI_RLAST  <= last_beat & ( last_beat and last_burst );
    local_BUS_RID  <= compress_axi_id(in_BUS_RID);
--------------------------- R channel end --------------------------------------
end architecture behave;




library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.NUMERIC_STD.all;

entity mm2s_gmem_m_axi_burst_converter is
    generic (
        INTERLEAVE        : INTEGER := 1;
        ID_WIDTH          : INTEGER := 1;
        DATA_WIDTH        : INTEGER := 32;
        ADDR_WIDTH        : INTEGER := 32;
        LEN_WIDTH         : INTEGER := 32;
        MAX_BURST_LENGTH  : INTEGER := 16;
        NUM_PORTS         : INTEGER := 1);
    port (
        clk               : in  STD_LOGIC;
        reset             : in  STD_LOGIC;
        clk_en            : in  STD_LOGIC;
        in_REQ_ID         : in  UNSIGNED(ID_WIDTH-1 downto 0);
        in_REQ_ADDR       : in  UNSIGNED(ADDR_WIDTH-1 downto 0);
        in_REQ_LEN        : in  UNSIGNED(LEN_WIDTH-1 downto 0);
        in_REQ_VALID      : in  STD_LOGIC;
        out_REQ_READY     : out UNSIGNED(NUM_PORTS-1 downto 0);
        out_BURST_ID      : out UNSIGNED(ID_WIDTH-1 downto 0);
        out_BURST_ADDR    : out UNSIGNED(ADDR_WIDTH-1 downto 0);
        out_BURST_LEN     : out UNSIGNED(7 downto 0);
        out_BURST_VALID   : out STD_LOGIC;
        in_BURST_READY    : in  STD_LOGIC;
        out_CTRL_ID       : out UNSIGNED(ID_WIDTH-1 downto 0);
        out_CTRL_INFO     : out UNSIGNED(0 downto 0);
        out_CTRL_VALID    : out STD_LOGIC;
        in_CTRL_READY     : in  UNSIGNED(NUM_PORTS-1 downto 0));

end entity mm2s_gmem_m_axi_burst_converter;

architecture behave of mm2s_gmem_m_axi_burst_converter is

    -- component
    component mm2s_gmem_m_axi_burst_interleave is
        generic (
            ID_WIDTH          : INTEGER := 1;
            DATA_WIDTH        : INTEGER := 32;
            ADDR_WIDTH        : INTEGER := 32;
            LEN_WIDTH         : INTEGER := 32;
            MAX_BURST_LENGTH  : INTEGER := 16;
            NUM_PORTS         : INTEGER := 1);
        port (
            clk               : in  STD_LOGIC;
            reset             : in  STD_LOGIC;
            clk_en            : in  STD_LOGIC;
            in_REQ_ID         : in  UNSIGNED(ID_WIDTH-1 downto 0);
            in_REQ_ADDR       : in  UNSIGNED(ADDR_WIDTH-1 downto 0);
            in_REQ_LEN        : in  UNSIGNED(LEN_WIDTH-1 downto 0);
            in_REQ_VALID      : in  STD_LOGIC;
            out_REQ_READY     : out UNSIGNED(NUM_PORTS-1 downto 0); 
            out_BURST_ID      : out UNSIGNED(ID_WIDTH-1 downto 0);
            out_BURST_ADDR    : out UNSIGNED(ADDR_WIDTH-1 downto 0);
            out_BURST_LEN     : out UNSIGNED(7 downto 0);
            out_BURST_VALID   : out STD_LOGIC;
            in_BURST_READY    : in  STD_LOGIC;
            out_CTRL_ID       : out UNSIGNED(ID_WIDTH-1 downto 0);
            out_CTRL_INFO     : out UNSIGNED(0 downto 0);
            out_CTRL_VALID    : out STD_LOGIC;
            in_CTRL_READY     : in  UNSIGNED(NUM_PORTS-1 downto 0));
    end component mm2s_gmem_m_axi_burst_interleave;

    component mm2s_gmem_m_axi_burst_sequential is
        generic (
            ID_WIDTH          : INTEGER := 1;
            DATA_WIDTH        : INTEGER := 32;
            ADDR_WIDTH        : INTEGER := 32;
            LEN_WIDTH         : INTEGER := 32;
            MAX_BURST_LENGTH  : INTEGER := 16;
            NUM_PORTS         : INTEGER := 1);
        port (
            clk               : in  STD_LOGIC;
            reset             : in  STD_LOGIC;
            clk_en            : in  STD_LOGIC;
            in_REQ_ID         : in  UNSIGNED(ID_WIDTH-1 downto 0);
            in_REQ_ADDR       : in  UNSIGNED(ADDR_WIDTH-1 downto 0);
            in_REQ_LEN        : in  UNSIGNED(LEN_WIDTH-1 downto 0);
            in_REQ_VALID      : in  STD_LOGIC;
            out_REQ_READY     : out UNSIGNED(NUM_PORTS-1 downto 0); 
            out_BURST_ID      : out UNSIGNED(ID_WIDTH-1 downto 0);
            out_BURST_ADDR    : out UNSIGNED(ADDR_WIDTH-1 downto 0);
            out_BURST_LEN     : out UNSIGNED(7 downto 0);
            out_BURST_VALID   : out STD_LOGIC;
            in_BURST_READY    : in  STD_LOGIC;
            out_CTRL_ID       : out UNSIGNED(ID_WIDTH-1 downto 0);
            out_CTRL_INFO     : out UNSIGNED(0 downto 0);
            out_CTRL_VALID    : out STD_LOGIC;
            in_CTRL_READY     : in  UNSIGNED(NUM_PORTS-1 downto 0));
    end component mm2s_gmem_m_axi_burst_sequential;

begin
    -- Instantiation 
    interleaved_bursts : if ((INTERLEAVE = 1) and (NUM_PORTS /= 1)) generate
    begin
        burst_interleave : mm2s_gmem_m_axi_burst_interleave
        generic map (
            ID_WIDTH         => ID_WIDTH,
            DATA_WIDTH       => DATA_WIDTH,
            ADDR_WIDTH       => ADDR_WIDTH,
            LEN_WIDTH        => LEN_WIDTH,
            MAX_BURST_LENGTH => MAX_BURST_LENGTH,
            NUM_PORTS        => NUM_PORTS)
        port map (
            clk              => clk,
            reset            => reset,
            clk_en           => clk_en,
            in_REQ_ID        => in_REQ_ID,
            in_REQ_ADDR      => in_REQ_ADDR,
            in_REQ_LEN       => in_REQ_LEN,
            in_REQ_VALID     => in_REQ_VALID,
            out_REQ_READY    => out_REQ_READY,
            out_BURST_ID     => out_BURST_ID,
            out_BURST_ADDR   => out_BURST_ADDR ,
            out_BURST_LEN    => out_BURST_LEN,
            out_BURST_VALID  => out_BURST_VALID,
            in_BURST_READY   => in_BURST_READY,
            out_CTRL_ID      => out_CTRL_ID,
            out_CTRL_INFO    => out_CTRL_INFO,
            out_CTRL_VALID   => out_CTRL_VALID,
            in_CTRL_READY    => in_CTRL_READY);
    end generate interleaved_bursts;

    sequential_bursts : if ((INTERLEAVE /= 1) or (NUM_PORTS = 1)) generate
    begin
        burst_sequential : mm2s_gmem_m_axi_burst_sequential
        generic map (
            ID_WIDTH         => ID_WIDTH,
            DATA_WIDTH       => DATA_WIDTH,
            ADDR_WIDTH       => ADDR_WIDTH,
            LEN_WIDTH        => LEN_WIDTH,
            MAX_BURST_LENGTH => MAX_BURST_LENGTH,
            NUM_PORTS        => NUM_PORTS)
        port map (
            clk              => clk,
            reset            => reset,
            clk_en           => clk_en,
            in_REQ_ID        => in_REQ_ID,
            in_REQ_ADDR      => in_REQ_ADDR,
            in_REQ_LEN       => in_REQ_LEN,
            in_REQ_VALID     => in_REQ_VALID,
            out_REQ_READY    => out_REQ_READY,
            out_BURST_ID     => out_BURST_ID,
            out_BURST_ADDR   => out_BURST_ADDR ,
            out_BURST_LEN    => out_BURST_LEN,
            out_BURST_VALID  => out_BURST_VALID,
            in_BURST_READY   => in_BURST_READY,
            out_CTRL_ID      => out_CTRL_ID,
            out_CTRL_INFO    => out_CTRL_INFO,
            out_CTRL_VALID   => out_CTRL_VALID,
            in_CTRL_READY    => in_CTRL_READY);
    end generate sequential_bursts;
end architecture behave;


library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.NUMERIC_STD.all;

entity mm2s_gmem_m_axi_burst_interleave is
    generic (
        ID_WIDTH          : INTEGER := 1;
        DATA_WIDTH        : INTEGER := 32;
        ADDR_WIDTH        : INTEGER := 32;
        LEN_WIDTH         : INTEGER := 32;
        MAX_BURST_LENGTH  : INTEGER := 16;
        NUM_PORTS         : INTEGER := 1);
    port (
        clk               : in  STD_LOGIC;
        reset             : in  STD_LOGIC;
        clk_en            : in  STD_LOGIC;
        in_REQ_ID         : in  UNSIGNED(ID_WIDTH-1 downto 0);
        in_REQ_ADDR       : in  UNSIGNED(ADDR_WIDTH-1 downto 0);
        in_REQ_LEN        : in  UNSIGNED(LEN_WIDTH-1 downto 0);
        in_REQ_VALID      : in  STD_LOGIC;
        out_REQ_READY     : out UNSIGNED(NUM_PORTS-1 downto 0);
        out_BURST_ID      : out UNSIGNED(ID_WIDTH-1 downto 0);
        out_BURST_ADDR    : out UNSIGNED(ADDR_WIDTH-1 downto 0);
        out_BURST_LEN     : out UNSIGNED(7 downto 0);
        out_BURST_VALID   : out STD_LOGIC;
        in_BURST_READY    : in  STD_LOGIC;
        out_CTRL_ID       : out UNSIGNED(ID_WIDTH-1 downto 0);
        out_CTRL_INFO     : out UNSIGNED(0 downto 0);
        out_CTRL_VALID    : out STD_LOGIC;
        in_CTRL_READY     : in  UNSIGNED(NUM_PORTS-1 downto 0));

end entity mm2s_gmem_m_axi_burst_interleave;

architecture behave of mm2s_gmem_m_axi_burst_interleave is

    function or_reduce(a : UNSIGNED(NUM_PORTS-1 downto 0)) return STD_LOGIC is
        variable ret : STD_LOGIC := '0';
    begin
        for i in a'range loop
            ret := ret or a(i);
        end loop;
    
        return ret;
    end function or_reduce;

    function log2 (x : INTEGER) return INTEGER is
        variable n, m : INTEGER;
    begin
        n := 0;
        m := 1;
        while m < x loop
            n := n + 1;
            m := m * 2;
        end loop;
        return n;
    end function log2;

    --common
    constant PACK_WIDTH           : INTEGER := ID_WIDTH + ADDR_WIDTH + LEN_WIDTH;
    constant DATA_BYTES           : INTEGER := DATA_WIDTH / 8;
    constant ADDR_ALIGN           : INTEGER := log2(DATA_BYTES);
    constant BOUNDARY_BEATS       : UNSIGNED(11-ADDR_ALIGN downto 0) := (others => '1');
    constant NUM_BEAT_WIDTH       : INTEGER := log2(MAX_BURST_LENGTH);

    --local signals
    signal  req_pack_in           : UNSIGNED(PACK_WIDTH-1 downto 0);
    signal  req_pack_out          : UNSIGNED(PACK_WIDTH-1 downto 0);
    signal  req_id_tmp            : UNSIGNED(ID_WIDTH-1 downto 0);
    signal  req_addr_tmp          : UNSIGNED(ADDR_WIDTH-1 downto 0);
    signal  req_len_tmp           : UNSIGNED(LEN_WIDTH-1 downto 0);
    signal  req_ready             : UNSIGNED(NUM_PORTS-1 downto 0);
    
    signal  req_full_n            : STD_LOGIC;
    signal  req_empty_n           : STD_LOGIC;
    signal  write_req             : STD_LOGIC;
    signal  read_req              : STD_LOGIC;
    signal  next_req              : STD_LOGIC;

    signal  start_addr            : UNSIGNED(ADDR_WIDTH-1 downto 0);
    signal  sect_addr             : UNSIGNED(ADDR_WIDTH-1 downto 0);
    signal  sect_addr_buf         : UNSIGNED(ADDR_WIDTH-1 downto 0);
    signal  req_id                : UNSIGNED(ID_WIDTH-1 downto 0);
    signal  req_id_buf            : UNSIGNED(ID_WIDTH-1 downto 0);

    signal  beat_len              : UNSIGNED(LEN_WIDTH-1 downto 0);
    signal  beat_len_buf          : UNSIGNED(LEN_WIDTH-1 downto 0);
    signal  start_to_4k           : UNSIGNED(11-ADDR_ALIGN downto 0);
    signal  end_from_4k           : UNSIGNED(11-ADDR_ALIGN downto 0);
    signal  sect_len              : UNSIGNED(11-ADDR_ALIGN downto 0);
    signal  sect_len_buf          : UNSIGNED(11-ADDR_ALIGN downto 0);
    signal  sect_cnt              : UNSIGNED(ADDR_WIDTH-13 downto 0);
    signal  sect_total            : UNSIGNED(LEN_WIDTH-13 downto 0);
    signal  sect_total_buf        : UNSIGNED(LEN_WIDTH-13 downto 0);
    signal  sect_total_tmp        : UNSIGNED(LEN_WIDTH-13 downto 0);

    signal  req_handling          : BOOLEAN;
    signal  single_sect           : BOOLEAN;
    signal  first_sect            : BOOLEAN;
    signal  last_sect             : BOOLEAN;
    signal  last_sect_buf         : BOOLEAN;
    signal  last_sect_tmp         : BOOLEAN;
    signal  ready_for_sect        : BOOLEAN;
    signal  next_sect             : BOOLEAN;

    signal  burst_valid           : STD_LOGIC;

    signal  ost_ctrl_id           : UNSIGNED(ID_WIDTH-1 downto 0);
    signal  ost_ctrl_info         : UNSIGNED(0 downto 0);
    signal  ost_ctrl_valid        : STD_LOGIC;
    signal  ost_ctrl_ready        : STD_LOGIC;

    signal  rem_req_pack          : UNSIGNED(PACK_WIDTH-1 downto 0);
    signal  rem_req_valid         : STD_LOGIC;
    signal  rem_req_id            : UNSIGNED(ID_WIDTH-1 downto 0);
    signal  rem_req_addr          : UNSIGNED(ADDR_WIDTH-1 downto 0);
    signal  rem_req_len           : UNSIGNED(LEN_WIDTH-1 downto 0);
    signal  rem_req_addr_pred     : UNSIGNED(ADDR_WIDTH-1 downto 0);
    signal  rem_req_len_pred      : UNSIGNED(LEN_WIDTH-1 downto 0);

    component mm2s_gmem_m_axi_fifo is
        generic (
            MEM_STYLE         : STRING  := "shiftreg";
            DATA_WIDTH        : INTEGER := 8;
            ADDR_WIDTH        : INTEGER := 4;
            DEPTH             : INTEGER := 16);
        port (
            clk               : in  STD_LOGIC;
            reset             : in  STD_LOGIC;
            clk_en            : in  STD_LOGIC;
            if_full_n         : out STD_LOGIC;
            if_write          : in  STD_LOGIC;
            if_din            : in  UNSIGNED(DATA_WIDTH-1 downto 0);
            if_empty_n        : out STD_LOGIC;
            if_read           : in  STD_LOGIC;
            if_dout           : out UNSIGNED(DATA_WIDTH-1 downto 0);
            if_num_data_valid : out UNSIGNED(ADDR_WIDTH downto 0));
    end component mm2s_gmem_m_axi_fifo;

    component mm2s_gmem_m_axi_reg_slice is
        generic (
            DATA_WIDTH  : INTEGER := 8);
        port (
            clk         : in  STD_LOGIC;
            reset       : in  STD_LOGIC;
            s_data      : in  UNSIGNED(DATA_WIDTH-1 downto 0);
            s_valid     : in  STD_LOGIC;
            s_ready     : out STD_LOGIC;
            m_data      : out UNSIGNED(DATA_WIDTH-1 downto 0);
            m_valid     : out STD_LOGIC;
            m_ready     : in  STD_LOGIC);
    end component mm2s_gmem_m_axi_reg_slice;

begin
    --------------------------- AR channel begin -----------------------------------
    -- Instantiation
    num_ports_gt2 : if (NUM_PORTS > 2) generate 
        req_buffer : mm2s_gmem_m_axi_fifo
        generic map (
            DATA_WIDTH => PACK_WIDTH,
            DEPTH      => NUM_PORTS,
            ADDR_WIDTH => log2(NUM_PORTS))
        port map (
            clk        => clk,
            reset      => reset,
            clk_en     => clk_en,
            if_full_n  => req_full_n,
            if_write   => write_req,
            if_din     => req_pack_in,
            if_empty_n => req_empty_n,
            if_read    => read_req,
            if_dout    => req_pack_out,
            if_num_data_valid => open);
    end generate num_ports_gt2;
    
    num_ports_ngt2 : if (NUM_PORTS <= 2) generate 
        rs_req : mm2s_gmem_m_axi_reg_slice
        generic map (
            DATA_WIDTH =>  PACK_WIDTH)
        port map (
            clk        =>  clk,
            reset      =>  reset,
            s_data     =>  req_pack_in,
            s_valid    =>  write_req,
            s_ready    =>  req_full_n,
            m_data     =>  req_pack_out,
            m_valid    =>  req_empty_n,
            m_ready    =>  read_req);
    end generate num_ports_ngt2;

    out_REQ_READY      <= req_ready    when req_full_n = '1' and rem_req_valid = '0'   else (others=>'0');
    req_pack_in        <= rem_req_pack when rem_req_valid = '1' else (in_REQ_ID & in_REQ_LEN & in_REQ_ADDR);
    write_req          <= rem_req_valid or in_REQ_VALID;

    process (clk)
    begin
        if (clk'event and clk = '1') then
            if (reset = '1') then
                req_ready <= (others=>'1');
            elsif clk_en = '1' then
                if in_REQ_VALID = '1' and req_full_n = '1' and rem_req_valid = '0' then
                    req_ready(TO_INTEGER(in_REQ_ID)) <= '0';
                end if;
                if ost_ctrl_info = "1" and ost_ctrl_valid = '1' then
                    req_ready(TO_INTEGER(ost_ctrl_id)) <= '1';
                end if;
            end if;
        end if;
    end process;    

    req_addr_tmp       <= req_pack_out(ADDR_WIDTH-1  downto 0);
    req_len_tmp        <= req_pack_out(ADDR_WIDTH+LEN_WIDTH-1 downto ADDR_WIDTH);
    req_id_tmp         <= req_pack_out(PACK_WIDTH-1  downto ADDR_WIDTH+LEN_WIDTH);
    next_req           <= read_req and req_empty_n;

    process (clk)
    begin
        if (clk'event and clk = '1') then
            if (reset = '1') then
                req_id      <= (others => '0');
                start_addr  <= (others => '0');
                start_to_4k <= (others => '0');
                end_from_4k <= (others => '0');
                sect_total  <= (others => '0');
            elsif clk_en = '1' then
                if next_req = '1' then
                    req_id      <= req_id_tmp;
                    start_addr  <= req_addr_tmp(ADDR_WIDTH-1 downto ADDR_ALIGN) & (ADDR_ALIGN-1 downto 0 => '0');
                    start_to_4k <= BOUNDARY_BEATS - req_addr_tmp(11 downto ADDR_ALIGN);
                    end_from_4k <= RESIZE(SHIFT_RIGHT(req_len_tmp(11 downto 0) + req_addr_tmp(11 downto 0) , ADDR_ALIGN), 12-ADDR_ALIGN);
                    sect_total  <= RESIZE(SHIFT_RIGHT(req_len_tmp + req_addr_tmp(11 downto 0) , 12), LEN_WIDTH-12);
                end if;
            end if;
        end if;
    end process;

    process (clk)
    begin
        if (clk'event and clk = '1') then
            if (reset = '1') then
                req_handling <= false;
            elsif clk_en = '1' then
                if next_req = '1' then
                    req_handling <= true;
                elsif req_empty_n = '0' and last_sect_tmp and next_sect then
                    req_handling <= false;
                end if;
            end if;
        end if;
    end process;

    -- 4k boundary section
    last_sect_tmp  <= single_sect or last_sect;

    sect_total_tmp <= sect_total when first_sect else sect_total_buf;

    single_sect <= (sect_total = 0);

    sect_addr  <= start_addr when first_sect else
                  sect_cnt & (11 downto 0 => '0');
    sect_len   <= beat_len(11-ADDR_ALIGN downto 0) when     single_sect else
                  start_to_4k                      when     first_sect and not last_sect else
                  end_from_4k                      when not first_sect and     last_sect else
                  BOUNDARY_BEATS;
                          
    process (clk)
    begin
        if (clk'event and clk = '1') then
            if (reset = '1') then
                first_sect <= false;
                last_sect <= false;
                sect_cnt <= (others => '0');
                beat_len <= (others => '0');
            elsif clk_en = '1' then
                if next_req = '1' then
                    first_sect <= true;
                    last_sect <= false;
                    sect_cnt <= req_addr_tmp(ADDR_WIDTH - 1 downto 12);
                    beat_len <= SHIFT_RIGHT(req_len_tmp + req_addr_tmp(ADDR_ALIGN-1 downto 0), ADDR_ALIGN);
                elsif next_sect then
                    first_sect <= false;
                    last_sect <= (sect_total_tmp = 1);
                    sect_cnt <= sect_cnt + 1;
                    beat_len <= beat_len - sect_len - 1;
                end if;
            end if;
        end if;
    end process;

    process (clk)
    begin
        if (clk'event and clk = '1') then
            if (reset = '1') then
                req_id_buf    <= (others => '0');
                sect_addr_buf <= (others => '0');
                sect_len_buf  <= (others => '0');
                last_sect_buf <= false;
                beat_len_buf  <= (others => '0');
                sect_total_buf<= (others => '0');
            elsif clk_en = '1' then
                if next_sect then
                    req_id_buf    <= req_id;
                    sect_addr_buf <= sect_addr;
                    sect_len_buf  <= sect_len;
                    last_sect_buf <= last_sect_tmp;
                    beat_len_buf  <= beat_len;
                    sect_total_buf<= sect_total_tmp - 1;
                end if;
            end if;
        end if;
    end process; 

    out_CTRL_VALID      <= ost_ctrl_valid;
    out_CTRL_ID         <= ost_ctrl_id;
    out_CTRL_INFO       <= ost_ctrl_info;

    must_one_burst : if (DATA_BYTES >= 4096/MAX_BURST_LENGTH) generate
        signal  read_sect    : BOOLEAN;
    begin
        out_BURST_ID    <= req_id_buf;
        out_BURST_ADDR  <= sect_addr_buf;
        out_BURST_LEN   <= RESIZE(sect_len_buf, 8);
        out_BURST_VALID <= burst_valid;

        ost_ctrl_id     <= req_id;
        ost_ctrl_info   <= "1" when last_sect_tmp else "0";
        ost_ctrl_valid  <= '1' when next_sect else '0';
        ost_ctrl_ready  <= in_CTRL_READY(TO_INTEGER(req_id));

        next_sect       <= read_sect and ost_ctrl_ready = '1';
        ready_for_sect  <= not (burst_valid = '1' and in_BURST_READY = '0') and req_full_n = '1' and or_reduce(in_CTRL_READY) = '1';
        read_sect       <= req_handling and ready_for_sect;
        read_req        <= '1' when not req_handling or ready_for_sect else '0';

        process (clk)
        begin
            if (clk'event and clk = '1') then
                if (reset = '1') then
                    burst_valid <= '0';
                elsif clk_en = '1' then
                    if next_sect then
                        burst_valid <= '1';
                    elsif in_BURST_READY = '1' then
                        burst_valid <= '0';
                    end if;
                end if;
            end if;
        end process;

        -- calculate remaining request, for interleaved burst handling.
        rem_req_pack  <= rem_req_id & (rem_req_len(LEN_WIDTH-ADDR_ALIGN-1 downto 0) & (ADDR_ALIGN-1 downto 0 => '1')) & rem_req_addr;
        rem_req_addr_pred <= ((sect_cnt+1) & (11 downto 0 => '0')) when ost_ctrl_ready = '1' else sect_addr;
        rem_req_len_pred  <= (beat_len - sect_len - 1) when ost_ctrl_ready = '1' else beat_len;

        process (clk)
        begin
            if (clk'event and clk = '1') then
                if (reset = '1') then
                    rem_req_id   <= (others => '0'); 
                    rem_req_addr <= (others => '0');
                    rem_req_len  <= (others => '0');
                elsif clk_en = '1' then
                    if read_sect then
                        rem_req_id   <= req_id;
                        rem_req_addr <= rem_req_addr_pred;
                        rem_req_len  <= rem_req_len_pred;
                    end if;
                end if;
            end if;
        end process;

        process (clk)
        begin
            if (clk'event and clk = '1') then
                if (reset = '1') then
                    rem_req_valid <= '0';
                elsif clk_en = '1' then
                    if next_sect and last_sect_tmp then
                        rem_req_valid <= '0';
                    elsif req_empty_n = '1' and read_sect then
                        rem_req_valid <= '1';
                    elsif req_full_n = '1' then
                        rem_req_valid <= '0';
                    end if;
                end if;
            end if;
        end process;
    end generate must_one_burst;

    could_multi_bursts : if (DATA_BYTES < 4096/MAX_BURST_LENGTH) generate
        signal  burst_id        : UNSIGNED(ID_WIDTH-1 downto 0); 
        signal  burst_addr      : UNSIGNED(ADDR_WIDTH - 1 downto 0);
        signal  burst_addr_next : UNSIGNED(ADDR_WIDTH - 1 downto 0);
        signal  burst_addr_pred : UNSIGNED(ADDR_WIDTH - 1 downto 0);
        signal  burst_len       : UNSIGNED(7 downto 0);
        signal  burst_len_pred  : UNSIGNED(7 downto 0);
        signal  burst_len_pred_plus1 : UNSIGNED(8 downto 0);

        signal  loop_cnt        : UNSIGNED(11 - NUM_BEAT_WIDTH - ADDR_ALIGN downto 0);
        signal  first_loop      : BOOLEAN;
        signal  last_loop       : BOOLEAN;
        signal  next_loop       : BOOLEAN;
        signal  read_loop       : BOOLEAN;
        signal  ready_for_loop  : BOOLEAN;
        signal  sect_handling   : BOOLEAN;
        signal  next_req_ready  : BOOLEAN;

        signal  last_loop_when_next_loop : BOOLEAN;
        signal  last_loop_when_next_sect : BOOLEAN;
        signal  burst_len_when_next_loop : UNSIGNED(7 downto 0); 
        signal  burst_len_when_next_sect : UNSIGNED(7 downto 0); 
    begin
        out_BURST_ID    <= burst_id;
        out_BURST_ADDR  <= burst_addr;
        out_BURST_LEN   <= burst_len;
        out_BURST_VALID <= burst_valid;

        ost_ctrl_id     <= req_id_buf;
        ost_ctrl_info   <= "1" when last_sect_buf and last_loop else "0";
        ost_ctrl_valid  <= '1' when next_loop else '0';
        ost_ctrl_ready  <= in_CTRL_READY(TO_INTEGER(req_id_buf));
        
        read_req        <= '1' when not next_req_ready or ready_for_sect else '0';

        next_sect       <= req_handling and ready_for_sect;
        ready_for_sect  <= not sect_handling or (read_loop and next_req_ready) or (next_loop and last_loop);
        
        next_loop       <= read_loop and ost_ctrl_ready = '1';
        read_loop       <= sect_handling and ready_for_loop;
        ready_for_loop  <= not (burst_valid = '1' and in_BURST_READY = '0') and req_full_n = '1' and or_reduce(in_CTRL_READY) = '1'; 

        process (clk)
        begin
            if (clk'event and clk = '1') then
                if (reset = '1') then
                    burst_valid <= '0';
                elsif clk_en = '1' then
                    if next_loop then
                        burst_valid <= '1';
                    elsif in_BURST_READY = '1' then
                        burst_valid <= '0';
                    end if;
                end if;
            end if;
        end process;

        process (clk)
        begin
            if (clk'event and clk = '1') then
                if (reset = '1') then
                    sect_handling <= false;
                elsif clk_en = '1' then
                    if req_handling and not sect_handling then
                        sect_handling <= true;
                    elsif not req_handling and last_loop and next_loop then
                        sect_handling <= false;
                    end if;
                end if;
            end if;
        end process;

        process (clk)
        begin
            if (clk'event and clk = '1') then
                if (reset = '1') then
                    first_loop <= false;
                    last_loop  <= false;
                    loop_cnt   <= (others => '0');
                elsif clk_en = '1' then
                    if next_sect then
                        first_loop <= true;
                        last_loop  <= last_loop_when_next_sect;
                        loop_cnt   <= sect_len(11 - ADDR_ALIGN downto NUM_BEAT_WIDTH);
                    elsif next_loop then
                        first_loop <= false;
                        last_loop  <= last_loop_when_next_loop;
                        loop_cnt   <= loop_cnt - 1;
                    end if;
                end if;
            end if;
        end process;

        last_loop_when_next_sect <= (sect_len(11 - ADDR_ALIGN downto NUM_BEAT_WIDTH) = 0);
        last_loop_when_next_loop <= (loop_cnt = 1);

        burst_addr_next          <= sect_addr_buf when first_loop else burst_addr_pred;
        burst_len_when_next_sect <= (others => '0')                                  when (NUM_BEAT_WIDTH = 0)     else
                                    RESIZE(sect_len(NUM_BEAT_WIDTH-1 downto 0), 8)   when last_loop_when_next_sect else 
                                    TO_UNSIGNED(2**NUM_BEAT_WIDTH-1, 8);
        burst_len_when_next_loop <= (others => '0')                                    when (NUM_BEAT_WIDTH = 0)     else
                                    RESIZE(sect_len_buf(NUM_BEAT_WIDTH-1 downto 0), 8) when last_loop_when_next_loop else 
                                    TO_UNSIGNED(2**NUM_BEAT_WIDTH-1, 8);

        rem_req_pack <= rem_req_id & (rem_req_len(LEN_WIDTH-ADDR_ALIGN-1 downto 0) & (ADDR_ALIGN-1 downto 0 => '1')) & rem_req_addr;
        rem_req_addr_pred <= sect_addr_buf   + (burst_len_pred_plus1 & (ADDR_ALIGN-1 downto 0 => '0')) when ost_ctrl_ready = '1' and first_loop else
                             burst_addr_pred + (burst_len_pred_plus1 & (ADDR_ALIGN-1 downto 0 => '0')) when ost_ctrl_ready = '1' and not first_loop else
                             sect_addr_buf                                                             when ost_ctrl_ready = '0' and first_loop else
                             burst_addr_pred;
        rem_req_len_pred  <= beat_len_buf - burst_len_pred_plus1 when ost_ctrl_ready = '1' and first_loop else
                             rem_req_len  - burst_len_pred_plus1 when ost_ctrl_ready = '1' and not first_loop else
                             beat_len_buf                        when ost_ctrl_ready = '0' and first_loop else
                             rem_req_len;

        process (clk)
        begin
            if (clk'event and clk = '1') then
                if (reset = '1') then
                    burst_len_pred       <= TO_UNSIGNED(2**NUM_BEAT_WIDTH-1, 8);
                    burst_len_pred_plus1 <= TO_UNSIGNED(2**NUM_BEAT_WIDTH, 9);
                elsif clk_en = '1' then
                    if next_sect then
                        burst_len_pred       <= burst_len_when_next_sect;
                        burst_len_pred_plus1 <= ('0' & burst_len_when_next_sect) + 1;
                    elsif next_loop then
                        burst_len_pred       <= burst_len_when_next_loop;
                        burst_len_pred_plus1 <= ('0' & burst_len_when_next_loop) + 1;
                    end if;
                end if;
            end if;
        end process;

        process (clk)
        begin
            if (clk'event and clk = '1') then
                if (reset = '1') then
                    burst_id   <= (others => '0');
                    burst_addr <= (others => '0');
                    burst_len  <= (others => '0');
                    burst_addr_pred <= (others => '0');
                elsif clk_en = '1' then
                    if next_loop then
                        burst_id   <= req_id_buf;
                        burst_addr <= burst_addr_next;
                        burst_len  <= burst_len_pred;
                        burst_addr_pred <= burst_addr_next + (burst_len_pred_plus1 & (ADDR_ALIGN-1 downto 0 => '0'));
                    end if;
                end if;
            end if;
        end process;

        process (clk)
        begin
            if (clk'event and clk = '1') then
                if (reset = '1') then
                    rem_req_id   <= (others => '0');
                    rem_req_addr <= (others => '0');
                    rem_req_len  <= (others => '0');
                elsif clk_en = '1' then
                    if read_loop then
                        rem_req_id   <= req_id_buf;
                        rem_req_addr <= rem_req_addr_pred;
                        rem_req_len  <= rem_req_len_pred;
                    end if;
                end if;
            end if;
        end process;

        process (clk)
        begin
            if (clk'event and clk = '1') then
                if (reset = '1') then
                    next_req_ready   <= false;
                elsif clk_en = '1' then
                    if next_req = '1' then
                        next_req_ready   <= true;
                    elsif next_sect then
                        next_req_ready   <= false;
                    end if;
                end if;
            end if;
        end process;

        process (clk)
        begin
            if (clk'event and clk = '1') then
                if (reset = '1') then
                    rem_req_valid <= '0';
                elsif clk_en = '1' then
                    if next_loop and last_loop and last_sect_buf then
                        rem_req_valid <= '0';
                    elsif next_req_ready and read_loop then
                        rem_req_valid <= '1';
                    elsif req_full_n = '1' then
                        rem_req_valid <= '0';
                    end if;
                end if;
            end if;
        end process; 
    end generate could_multi_bursts;
end architecture behave;


library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.NUMERIC_STD.all;

entity mm2s_gmem_m_axi_burst_sequential is
    generic (
        ID_WIDTH          : INTEGER := 1;
        DATA_WIDTH        : INTEGER := 32;
        ADDR_WIDTH        : INTEGER := 32;
        LEN_WIDTH         : INTEGER := 32;
        MAX_BURST_LENGTH  : INTEGER := 16;
        NUM_PORTS         : INTEGER := 1);
    port (
        clk               : in  STD_LOGIC;
        reset             : in  STD_LOGIC;
        clk_en            : in  STD_LOGIC;
        in_REQ_ID         : in  UNSIGNED(ID_WIDTH-1 downto 0);
        in_REQ_ADDR       : in  UNSIGNED(ADDR_WIDTH-1 downto 0);
        in_REQ_LEN        : in  UNSIGNED(LEN_WIDTH-1 downto 0);
        in_REQ_VALID      : in  STD_LOGIC;
        out_REQ_READY     : out UNSIGNED(NUM_PORTS-1 downto 0);
        out_BURST_ID      : out UNSIGNED(ID_WIDTH-1 downto 0);
        out_BURST_ADDR    : out UNSIGNED(ADDR_WIDTH-1 downto 0);
        out_BURST_LEN     : out UNSIGNED(7 downto 0);
        out_BURST_VALID   : out STD_LOGIC;
        in_BURST_READY    : in  STD_LOGIC;
        out_CTRL_ID       : out UNSIGNED(ID_WIDTH-1 downto 0);
        out_CTRL_INFO     : out UNSIGNED(0 downto 0);
        out_CTRL_VALID    : out STD_LOGIC;
        in_CTRL_READY     : in  UNSIGNED(NUM_PORTS-1 downto 0));

end entity mm2s_gmem_m_axi_burst_sequential;

architecture behave of mm2s_gmem_m_axi_burst_sequential is

    function log2 (x : INTEGER) return INTEGER is
        variable n, m : INTEGER;
    begin
        n := 0;
        m := 1;
        while m < x loop
            n := n + 1;
            m := m * 2;
        end loop;
        return n;
    end function log2;

    --common
    constant PACK_WIDTH           : INTEGER := ID_WIDTH + ADDR_WIDTH + LEN_WIDTH;
    constant DATA_BYTES           : INTEGER := DATA_WIDTH / 8;
    constant ADDR_ALIGN           : INTEGER := log2(DATA_BYTES);
    constant BOUNDARY_BEATS       : UNSIGNED(11-ADDR_ALIGN downto 0) := (others => '1');
    constant NUM_BEAT_WIDTH       : INTEGER := log2(MAX_BURST_LENGTH);

    --local signals
    signal  req_pack_in           : UNSIGNED(PACK_WIDTH-1 downto 0);
    signal  req_pack_out          : UNSIGNED(PACK_WIDTH-1 downto 0);
    signal  req_id_tmp            : UNSIGNED(ID_WIDTH-1 downto 0);
    signal  req_addr_tmp          : UNSIGNED(ADDR_WIDTH-1 downto 0);
    signal  req_len_tmp           : UNSIGNED(LEN_WIDTH-1 downto 0);
    
    signal  req_full_n            : STD_LOGIC;
    signal  req_empty_n           : STD_LOGIC;
    signal  write_req             : STD_LOGIC;
    signal  read_req              : STD_LOGIC;
    signal  next_req              : STD_LOGIC;

    signal  start_addr            : UNSIGNED(ADDR_WIDTH-1 downto 0);
    signal  sect_addr             : UNSIGNED(ADDR_WIDTH-1 downto 0);
    signal  sect_addr_buf         : UNSIGNED(ADDR_WIDTH-1 downto 0);
    signal  req_id                : UNSIGNED(ID_WIDTH-1 downto 0);
    signal  req_id_buf            : UNSIGNED(ID_WIDTH-1 downto 0);

    signal  beat_len              : UNSIGNED(11-ADDR_ALIGN downto 0);
    signal  start_to_4k           : UNSIGNED(11-ADDR_ALIGN downto 0);
    signal  end_from_4k           : UNSIGNED(11-ADDR_ALIGN downto 0);
    signal  sect_len              : UNSIGNED(11-ADDR_ALIGN downto 0);
    signal  sect_len_buf          : UNSIGNED(11-ADDR_ALIGN downto 0);
    signal  sect_cnt              : UNSIGNED(ADDR_WIDTH-13 downto 0);
    signal  sect_total            : UNSIGNED(LEN_WIDTH-13 downto 0);
    signal  sect_total_buf        : UNSIGNED(LEN_WIDTH-13 downto 0);
    signal  sect_total_tmp        : UNSIGNED(LEN_WIDTH-13 downto 0);

    signal  req_handling          : BOOLEAN;
    signal  single_sect           : BOOLEAN;
    signal  first_sect            : BOOLEAN;
    signal  last_sect             : BOOLEAN;
    signal  last_sect_buf         : BOOLEAN;
    signal  last_sect_tmp         : BOOLEAN;
    signal  ready_for_sect        : BOOLEAN;
    signal  next_sect             : BOOLEAN;

    signal  burst_valid           : STD_LOGIC;
    signal  ost_ctrl_ready        : STD_LOGIC;

    component mm2s_gmem_m_axi_reg_slice is
        generic (
            DATA_WIDTH  : INTEGER := 8);
        port (
            clk         : in  STD_LOGIC;
            reset       : in  STD_LOGIC;
            s_data      : in  UNSIGNED(DATA_WIDTH-1 downto 0);
            s_valid     : in  STD_LOGIC;
            s_ready     : out STD_LOGIC;
            m_data      : out UNSIGNED(DATA_WIDTH-1 downto 0);
            m_valid     : out STD_LOGIC;
            m_ready     : in  STD_LOGIC);
    end component mm2s_gmem_m_axi_reg_slice;

begin
    --------------------------- AR channel begin -----------------------------------
    -- Instantiation
    rs_req : mm2s_gmem_m_axi_reg_slice
        generic map (
            DATA_WIDTH =>  PACK_WIDTH)
        port map (
            clk        =>  clk,
            reset      =>  reset,
            s_data     =>  req_pack_in,
            s_valid    =>  write_req,
            s_ready    =>  req_full_n,
            m_data     =>  req_pack_out,
            m_valid    =>  req_empty_n,
            m_ready    =>  read_req);

    out_REQ_READY      <= (others => req_full_n);
    req_pack_in        <= in_REQ_ID & in_REQ_LEN & in_REQ_ADDR;
    write_req          <= in_REQ_VALID;

    req_addr_tmp       <= req_pack_out(ADDR_WIDTH-1  downto 0);
    req_len_tmp        <= req_pack_out(ADDR_WIDTH+LEN_WIDTH-1 downto ADDR_WIDTH);
    req_id_tmp         <= req_pack_out(PACK_WIDTH-1  downto ADDR_WIDTH+LEN_WIDTH);

    read_req           <= '1' when not req_handling or (last_sect_tmp and next_sect) else '0';
    next_req           <= read_req and req_empty_n;

    process (clk)
    begin
        if (clk'event and clk = '1') then
            if (reset = '1') then
                req_id      <= (others => '0');
                start_addr  <= (others => '0');
                beat_len    <= (others => '0');
                start_to_4k <= (others => '0');
                end_from_4k <= (others => '0');
                sect_total  <= (others => '0');
            elsif clk_en = '1' then
                if next_req = '1' then
                    req_id      <= req_id_tmp;
                    start_addr  <= req_addr_tmp(ADDR_WIDTH-1 downto ADDR_ALIGN) & (ADDR_ALIGN-1 downto 0 => '0');
                    beat_len    <= RESIZE(SHIFT_RIGHT(req_len_tmp(11 downto 0) + req_addr_tmp(ADDR_ALIGN-1 downto 0), ADDR_ALIGN), 12-ADDR_ALIGN);
                    end_from_4k <= RESIZE(SHIFT_RIGHT(req_len_tmp(11 downto 0) + req_addr_tmp(11 downto 0)          , ADDR_ALIGN), 12-ADDR_ALIGN);
                    start_to_4k <= BOUNDARY_BEATS - req_addr_tmp(11 downto ADDR_ALIGN);
                    sect_total  <= RESIZE(SHIFT_RIGHT(req_len_tmp + req_addr_tmp(11 downto 0) , 12), LEN_WIDTH-12);
                end if;
            end if;
        end if;
    end process;

    process (clk)
    begin
        if (clk'event and clk = '1') then
            if (reset = '1') then
                req_handling <= false;
            elsif clk_en = '1' then
                if next_req = '1' then
                    req_handling <= true;
                elsif req_empty_n = '0' and last_sect_tmp and next_sect then
                    req_handling <= false;
                end if;
            end if;
        end if;
    end process;

    -- 4k boundary section
    last_sect_tmp  <= single_sect or last_sect;

    sect_total_tmp <= sect_total when first_sect else sect_total_buf;

    single_sect <= (sect_total = 0);

    -- next_sect  <= req_handling and ready_for_sect;

    sect_addr  <= start_addr when first_sect else
                  sect_cnt & (11 downto 0 => '0');
    sect_len   <= beat_len     when     single_sect else
                  start_to_4k  when     first_sect and not last_sect else
                  end_from_4k  when not first_sect and     last_sect else
                  BOUNDARY_BEATS;
    
    process (clk)
    begin
        if (clk'event and clk = '1') then
            if (reset = '1') then
                first_sect <= false;
                last_sect <= false;
                sect_cnt <= (others => '0');
            elsif clk_en = '1' then
                if next_req = '1' then
                    first_sect <= true;
                    last_sect <= false;
                    sect_cnt <= req_addr_tmp(ADDR_WIDTH - 1 downto 12);
                elsif next_sect then
                    first_sect <= false;
                    last_sect <= (sect_total_tmp = 1);
                    sect_cnt <= sect_cnt + 1;
                end if;
            end if;
        end if;
    end process;

    process (clk)
    begin
        if (clk'event and clk = '1') then
            if (reset = '1') then
                req_id_buf     <= (others=>'0');
                sect_addr_buf  <= (others => '0');
                sect_len_buf   <= (others => '0');
                last_sect_buf  <= false;
                sect_total_buf <= (others => '0');
            elsif clk_en = '1' then
                if next_sect then
                    req_id_buf     <= req_id;
                    sect_addr_buf  <= sect_addr;
                    sect_len_buf   <= sect_len;
                    last_sect_buf  <= last_sect_tmp;
                    sect_total_buf <= sect_total_tmp - 1;
                end if;
            end if;
        end if;
    end process; 

    must_one_burst : if (DATA_BYTES >= 4096/MAX_BURST_LENGTH) generate
        signal read_sect : BOOLEAN;
    begin
        out_BURST_ID    <= req_id_buf;
        out_BURST_ADDR  <= sect_addr_buf;
        out_BURST_LEN   <= RESIZE(sect_len_buf, 8);
        out_BURST_VALID <= burst_valid;

        out_CTRL_ID     <= req_id;
        out_CTRL_INFO   <= "1" when last_sect_tmp else "0";
        out_CTRL_VALID  <= '1' when next_sect else '0';
        ost_ctrl_ready  <= in_CTRL_READY(TO_INTEGER(req_id));

        next_sect       <= read_sect and (ost_ctrl_ready = '1');
        read_sect       <= req_handling and ready_for_sect;
        ready_for_sect  <= not (burst_valid = '1' and in_BURST_READY = '0');

        process (clk)
        begin
            if (clk'event and clk = '1') then
                if (reset = '1') then
                    burst_valid <= '0';
                elsif clk_en = '1' then
                    if next_sect then
                        burst_valid <= '1';
                    elsif in_BURST_READY = '1' then
                        burst_valid <= '0';
                    end if;
                end if;
            end if;
        end process;
    end generate must_one_burst;

    could_multi_bursts : if (DATA_BYTES < 4096/MAX_BURST_LENGTH) generate
        signal  burst_id        : UNSIGNED(ID_WIDTH-1 downto 0);
        signal  burst_addr      : UNSIGNED(ADDR_WIDTH - 1 downto 0);
        signal  burst_addr_next : UNSIGNED(ADDR_WIDTH - 1 downto 0);
        signal  burst_len       : UNSIGNED(7 downto 0);
        signal  burst_len_plus1 : UNSIGNED(8 downto 0);
        signal  burst_len_next  : UNSIGNED(7 downto 0);
        signal  loop_cnt        : UNSIGNED(11 - NUM_BEAT_WIDTH - ADDR_ALIGN downto 0);
        signal  first_loop      : BOOLEAN;
        signal  last_loop       : BOOLEAN;
        signal  next_loop       : BOOLEAN;
        signal  read_loop       : BOOLEAN;
        signal  ready_for_loop  : BOOLEAN;
        signal  sect_handling   : BOOLEAN;
    begin
        out_BURST_ID    <= burst_id;
        out_BURST_ADDR  <= burst_addr;
        out_BURST_LEN   <= burst_len;
        out_BURST_VALID <= burst_valid;

        out_CTRL_ID     <= req_id_buf;
        out_CTRL_INFO   <= "1" when last_sect_buf and last_loop else "0";
        out_CTRL_VALID  <= '1' when next_loop else '0';
        ost_ctrl_ready  <= in_CTRL_READY(TO_INTEGER(req_id_buf));

        next_loop       <= read_loop and (ost_ctrl_ready = '1');
        read_loop       <= sect_handling and ready_for_loop;
        ready_for_loop  <= not (burst_valid = '1' and in_BURST_READY = '0');

        next_sect       <= req_handling and ready_for_sect;
        ready_for_sect  <= not sect_handling or (last_loop and next_loop);

        process (clk)
        begin
            if (clk'event and clk = '1') then
                if (reset = '1') then
                    burst_valid <= '0';
                elsif clk_en = '1' then
                    if next_loop then
                        burst_valid <= '1';
                    elsif in_BURST_READY = '1' then
                        burst_valid <= '0';
                    end if;
                end if;
            end if;
        end process;

        process (clk)
        begin
            if (clk'event and clk = '1') then
                if (reset = '1') then
                    sect_handling <= false;
                elsif clk_en = '1' then
                    if req_handling and not sect_handling then
                        sect_handling <= true;
                    elsif not req_handling and last_loop and next_loop then
                        sect_handling <= false;
                    end if;
                end if;
            end if;
        end process;

        process (clk)
        begin
            if (clk'event and clk = '1') then
                if (reset = '1') then
                    first_loop <= false;
                    last_loop <= false;
                    loop_cnt <= (others => '0');
                elsif clk_en = '1' then
                    if next_sect then
                        first_loop <= true;
                        last_loop <= (sect_len(11 - ADDR_ALIGN downto NUM_BEAT_WIDTH) = 0);
                        loop_cnt <= sect_len(11 - ADDR_ALIGN downto NUM_BEAT_WIDTH);
                    elsif next_loop then
                        first_loop <= false;
                        last_loop <= (loop_cnt = 1);
                        loop_cnt <= loop_cnt - 1;
                    end if;
                end if;
            end if;
        end process;

        burst_addr_next <= sect_addr_buf when first_loop else (burst_addr + (burst_len_plus1 & (ADDR_ALIGN-1 downto 0 => '0')));

        burst_len_next  <= (others => '0')                                    when (NUM_BEAT_WIDTH = 0) else
                           RESIZE(sect_len_buf(NUM_BEAT_WIDTH-1 downto 0), 8) when last_loop else
                           TO_UNSIGNED(2**NUM_BEAT_WIDTH-1, 8);

        process (clk)
        begin
            if (clk'event and clk = '1') then
                if (reset = '1') then
                    burst_id   <= (others => '0');
                    burst_addr <= (others => '0');
                    burst_len  <= (others => '0');
                    burst_len_plus1 <= (others => '0');
                elsif clk_en = '1' then
                    if next_loop then
                        burst_id   <= req_id_buf;
                        burst_addr <= burst_addr_next;
                        burst_len  <= burst_len_next;
                        burst_len_plus1 <= ('0' & burst_len_next) + 1;
                    end if;
                end if;
            end if;
        end process;
    end generate could_multi_bursts;
end architecture behave;




library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.NUMERIC_STD.all;

entity mm2s_gmem_m_axi_reg_slice is
    generic (
        DATA_WIDTH  : INTEGER := 8);
    port (
        -- system signals
        clk        : in  STD_LOGIC;
        reset       : in  STD_LOGIC;
        -- slave side
        s_data      : in  UNSIGNED(DATA_WIDTH-1 downto 0);
        s_valid     : in  STD_LOGIC;
        s_ready     : out STD_LOGIC;
        -- master side
        m_data      : out UNSIGNED(DATA_WIDTH-1 downto 0);
        m_valid     : out STD_LOGIC;
        m_ready     : in  STD_LOGIC);
end entity mm2s_gmem_m_axi_reg_slice;

architecture behave of mm2s_gmem_m_axi_reg_slice is
    constant ZERO                     : UNSIGNED(1 downto 0) := "10";
    constant ONE                      : UNSIGNED(1 downto 0) := "11";
    constant TWO                      : UNSIGNED(1 downto 0) := "01";
    signal   data_p1                  : UNSIGNED(DATA_WIDTH-1 downto 0);
    signal   data_p2                  : UNSIGNED(DATA_WIDTH-1 downto 0);
    signal   load_p1                  : STD_LOGIC;
    signal   load_p2                  : STD_LOGIC;
    signal   load_p1_from_p2          : STD_LOGIC;
    signal   s_ready_t                : STD_LOGIC;
    signal   state                    : UNSIGNED(1 downto 0);
    signal   next_st                  : UNSIGNED(1 downto 0);
begin
    s_ready <= s_ready_t;
    m_data  <= data_p1;
    m_valid <= state(0);

    load_p1 <= '1' when (state = ZERO and s_valid = '1') or
                        (state = ONE  and s_valid = '1' and m_ready = '1') or
                        (state = TWO  and m_ready = '1')
               else '0';

    load_p2         <= s_valid and s_ready_t;
    load_p1_from_p2 <= '1' when state = TWO else '0';

    data_p1_proc : process (clk)
    begin
        if (clk'event and clk = '1') then
            if (load_p1 = '1') then
                if (load_p1_from_p2 = '1') then
                    data_p1 <= data_p2;
                else
                    data_p1 <= s_data;
                end if;
            end if;
        end if;
    end process;

    data_p2_proc : process (clk)
    begin
        if (clk'event and clk = '1') then
            if (load_p2 = '1') then
                data_p2 <= s_data;
            end if;
        end if;
    end process;

    s_ready_t_proc : process (clk)
    begin
        if (clk'event and clk = '1') then
            if (reset = '1') then
                s_ready_t <= '0';
            elsif (state = ZERO) then
                s_ready_t <= '1';
            elsif (state = ONE and next_st = TWO) then
                s_ready_t <= '0';
            elsif (state = TWO and next_st = ONE) then
                s_ready_t <= '1';
            end if;
        end if;
    end process;

    state_proc : process (clk)
    begin
        if (clk'event and clk = '1') then
            if (reset = '1') then
                state <= ZERO;
            else
                state <= next_st;
            end if;
        end if;
    end process;

    next_st_proc : process (state, s_valid, s_ready_t, m_ready)
    begin
        case state is
            when ZERO =>
                if (s_valid = '1' and s_ready_t = '1') then
                    next_st <= ONE;
                else
                    next_st <= ZERO;
                end if;
            when ONE =>
                if (s_valid = '0' and m_ready = '1') then
                    next_st <= ZERO;
                elsif (s_valid = '1' and m_ready = '0') then
                    next_st <= TWO;
                else
                    next_st <= ONE;
                end if;
            when TWO =>
                if (m_ready = '1') then
                    next_st <= ONE;
                else
                    next_st <= TWO;
                end if;
            when others =>
                next_st <= ZERO;
        end case;
    end process;

end architecture behave;


library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.NUMERIC_STD.all;

entity mm2s_gmem_m_axi_fifo is
    generic (
        MEM_STYLE         : STRING  := "shiftreg";
        DATA_WIDTH        : INTEGER := 8;
        ADDR_WIDTH        : INTEGER := 4;
        DEPTH             : INTEGER := 16);
    port (
        clk               : in  STD_LOGIC;
        reset             : in  STD_LOGIC;
        clk_en            : in  STD_LOGIC;
        if_full_n         : out STD_LOGIC;
        if_write          : in  STD_LOGIC;
        if_din            : in  UNSIGNED(DATA_WIDTH-1 downto 0);
        if_empty_n        : out STD_LOGIC;
        if_read           : in  STD_LOGIC;
        if_dout           : out UNSIGNED(DATA_WIDTH-1 downto 0);
        if_num_data_valid : out UNSIGNED(ADDR_WIDTH downto 0));
end entity mm2s_gmem_m_axi_fifo;

architecture behave of mm2s_gmem_m_axi_fifo is
    signal push       : std_logic;
    signal pop        : std_logic;
    signal full_n     : std_logic := '1';
    signal empty_n    : std_logic := '0';
    signal dout_vld   : std_logic := '0';
    signal mOutPtr    : UNSIGNED(ADDR_WIDTH downto 0) := (others => '0');
begin

    fifo_depth_0_gen : if (DEPTH = 0) generate
    begin
        if_num_data_valid <= TO_UNSIGNED(1, ADDR_WIDTH+1) when if_write = '1' else (others => '0');
        if_full_n         <= if_read;
        if_empty_n        <= if_write;
        if_dout           <= if_din;
    end generate fifo_depth_0_gen;
    
    fifo_depth_1_gen : if (DEPTH = 1) generate
        signal dout_reg : UNSIGNED(DATA_WIDTH-1 downto 0);
    begin
        if_num_data_valid <= TO_UNSIGNED(1, ADDR_WIDTH+1) when dout_vld = '1' else (others => '0');
        if_full_n         <= not dout_vld;
        if_empty_n        <= dout_vld;
        if_dout           <= dout_reg;
        push              <= not dout_vld and if_write;
        pop               <= dout_vld and if_read;

        process (clk) begin
            if clk'event and clk = '1' then
                if reset = '1' then
                    dout_reg <= (others => '0');
                elsif clk_en = '1' then
                    if push = '1' then
                        dout_reg <= if_din;
                    end if;
                end if;
            end if;
        end process;

        process (clk) begin
            if clk'event and clk = '1' then
                if reset = '1' then
                    dout_vld <= '0';
                elsif clk_en = '1' then
                    if push = '1' then
                        dout_vld <= '1';
                    elsif pop = '1' then
                        dout_vld <= '0';
                    end if;
                end if;
            end if;
        end process;
    end generate fifo_depth_1_gen;
    
    fifo_depth_gt1_gen : if (DEPTH > 1) generate
        signal num_data_cnt : UNSIGNED(ADDR_WIDTH downto 0) := (others => '0');
        signal mOutPtr      : UNSIGNED(ADDR_WIDTH downto 0) := (others => '0');
        signal pop_dout     : STD_LOGIC;
    begin
        if_num_data_valid <= num_data_cnt when dout_vld = '1' else (others=> '0');
        if_full_n         <= full_n;
        if_empty_n        <= dout_vld;
        push              <= full_n and if_write;
        pop               <= empty_n and (if_read or not dout_vld);
        pop_dout          <= dout_vld and if_read;

        -- mOutPtr
        process (clk) begin
            if clk'event and clk = '1' then
                if reset = '1' then
                    mOutPtr <= (others => '0');
                elsif (clk_en = '1') then
                    if push = '1' and pop = '0' then
                        mOutPtr <= mOutPtr + 1;
                    elsif push = '0' and pop = '1' then
                        mOutPtr <= mOutPtr - 1;
                    end if;
                end if;
            end if;
        end process;

        -- num_data_cnt
        process (clk) begin
            if clk'event and clk = '1' then
                if reset = '1' then
                    num_data_cnt <= (others => '0');
                elsif (clk_en = '1') then
                    if push = '1' and pop_dout = '0' then
                        num_data_cnt <= num_data_cnt + 1;
                    elsif push = '0' and pop_dout = '1' then
                        num_data_cnt <= num_data_cnt - 1;
                    end if;
                end if;
            end if;
        end process;

        -- full_n
        process (clk) begin
            if clk'event and clk = '1' then
                if reset = '1' then
                    full_n <= '1';
                elsif clk_en = '1' then
                    if push = '1' and pop_dout = '0' and (num_data_cnt = DEPTH - 1) then
                        full_n <= '0';
                    elsif push = '0' and pop_dout = '1' then
                        full_n <= '1';
                    end if;
                end if;
            end if;
        end process;

        -- empty_n
        process (clk) begin
            if clk'event and clk = '1' then
                if reset = '1' then
                    empty_n <= '0';
                elsif clk_en = '1' then
                    if push = '1' and pop = '0' then
                        empty_n <= '1';
                    elsif push = '0' and pop = '1' and (mOutPtr = 1) then
                        empty_n <= '0';
                    end if;
                end if;
            end if;
        end process;

        -- dout_vld
        process (clk) begin
            if clk'event and clk = '1' then
                if reset = '1' then
                    dout_vld <= '0';
                elsif clk_en = '1' then
                    if pop = '1' then
                        dout_vld <= '1';
                    elsif pop_dout = '1' then
                        dout_vld <= '0';
                    end if;
                end if;
            end if;
        end process;

        -- shiftreg based fifo
        fifo_srl_gen: if (MEM_STYLE = "shiftreg") generate
            component mm2s_gmem_m_axi_srl is
                generic (
                    DATA_WIDTH  : integer := 32;
                    ADDR_WIDTH  : integer := 6;
                    DEPTH       : integer := 64);
                port (
                    clk         : in  std_logic;
                    reset       : in  std_logic;
                    clk_en      : in  std_logic;
                    we          : in  std_logic;
                    din         : in  UNSIGNED(DATA_WIDTH-1 downto 0);
                    raddr       : in  UNSIGNED(ADDR_WIDTH-1 downto 0);
                    re          : in  std_logic;
                    dout        : out UNSIGNED(DATA_WIDTH-1 downto 0));
            end component;
            signal raddr      : UNSIGNED(ADDR_WIDTH - 1 downto 0) := (others => '0');
        begin
            U_ffo_srl: mm2s_gmem_m_axi_srl
            generic map (
                DATA_WIDTH  => DATA_WIDTH,
                ADDR_WIDTH  => ADDR_WIDTH,
                DEPTH       => DEPTH)
            port map (
                clk         => clk,
                reset       => reset,
                clk_en      => clk_en,
                we          => push,
                din         => if_din,
                re          => pop,
                raddr       => raddr,
                dout        => if_dout);

            process (clk) begin
                if clk'event and clk = '1' then
                    if reset = '1' then
                        raddr <= (others => '0');
                    elsif (clk_en = '1') then
                        if (push = '1' and pop = '0' and empty_n = '1') then
                            raddr <= raddr + 1;
                        elsif (push = '0' and pop = '1' and (raddr /= 0)) then
                            raddr <= raddr - 1;
                        end if;
                    end if;
                end if;
            end process;
        end generate fifo_srl_gen;

        -- mem based fifo
        fifo_mem_gen: if (MEM_STYLE /= "shiftreg") generate
            component mm2s_gmem_m_axi_mem is
                generic (
                    MEM_STYLE   : string  := "auto";
                    DATA_WIDTH  : integer := 32;
                    ADDR_WIDTH  : integer := 6;
                    DEPTH       : integer := 64);
                port (
                    clk         : in  std_logic;
                    reset       : in  std_logic;
                    clk_en      : in  std_logic;
                    we          : in  std_logic;
                    waddr       : in  UNSIGNED(ADDR_WIDTH-1 downto 0);
                    din         : in  UNSIGNED(DATA_WIDTH-1 downto 0);
                    re          : in  std_logic;
                    raddr       : in  UNSIGNED(ADDR_WIDTH-1 downto 0);
                    dout        : out UNSIGNED(DATA_WIDTH-1 downto 0));
            end component;

            signal waddr      : UNSIGNED(ADDR_WIDTH - 1 downto 0) := (others => '0');
            signal raddr      : UNSIGNED(ADDR_WIDTH - 1 downto 0) := (others => '0');
            signal wnext      : UNSIGNED(ADDR_WIDTH - 1 downto 0);
            signal rnext      : UNSIGNED(ADDR_WIDTH - 1 downto 0);
        begin
            U_ffo_mem: mm2s_gmem_m_axi_mem
            generic map (
                MEM_STYLE   => MEM_STYLE,
                DATA_WIDTH  => DATA_WIDTH,
                ADDR_WIDTH  => ADDR_WIDTH,
                DEPTH       => DEPTH)
            port map (
                clk         => clk,
                reset       => reset,
                clk_en      => clk_en,
                we          => push,
                waddr       => waddr,
                din         => if_din,
                re          => pop,
                raddr       => raddr,
                dout        => if_dout);

            wnext <= waddr           when push = '0'        else
                    (others => '0') when waddr = DEPTH - 2 else
                    waddr + 1;
            rnext <= raddr           when pop = '0'         else
                    (others => '0') when raddr = DEPTH - 2 else
                    raddr + 1;

            process (clk) begin
                if clk'event and clk = '1' then
                    if reset = '1' then
                        waddr <= (others => '0');
                    elsif (clk_en = '1') then
                        waddr <= wnext;
                    end if;
                end if;
            end process;

            process (clk) begin
                if clk'event and clk = '1' then
                    if reset = '1' then
                        raddr <= (others => '0');
                    elsif (clk_en = '1') then
                        raddr <= rnext;
                    end if;
                end if;
            end process;
        end generate fifo_mem_gen;
    end generate fifo_depth_gt1_gen;
    
end architecture behave;   

library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.NUMERIC_STD.all;

entity mm2s_gmem_m_axi_srl is
    generic (
        DATA_WIDTH  : integer := 32;
        ADDR_WIDTH  : integer := 6;
        DEPTH       : integer := 64);
    port (
        clk         : in  std_logic;
        reset       : in  std_logic;
        clk_en      : in  std_logic;
        we          : in  std_logic;
        din         : in  UNSIGNED(DATA_WIDTH-1 downto 0);
        raddr       : in  UNSIGNED(ADDR_WIDTH-1 downto 0);
        re          : in  std_logic;
        dout        : out UNSIGNED(DATA_WIDTH-1 downto 0));
end mm2s_gmem_m_axi_srl;

architecture behav of mm2s_gmem_m_axi_srl is
    type SRL_ARRAY is array (0 to DEPTH-2) of UNSIGNED(DATA_WIDTH-1 downto 0);
    signal mem : SRL_ARRAY;
begin

    process (clk)
    begin
        if (clk'event and clk = '1') then
            if clk_en = '1' and we = '1' then
                for i in 0 to DEPTH - 3 loop
                    mem(i+1) <= mem(i);
                end loop;
                mem(0) <= din;
            end if;
        end  if;
    end process;

    process (clk)
    begin
        if (clk'event and clk = '1') then
            if reset = '1' then
                dout <= (others => '0');
            elsif clk_en = '1' and re = '1' then
                dout <= mem(to_integer(raddr));
            end if;
        end if;
    end process;

end architecture behav;

library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.NUMERIC_STD.all;

entity mm2s_gmem_m_axi_mem is
    generic (
        MEM_STYLE   : string  := "auto";
        DATA_WIDTH  : integer := 32;
        ADDR_WIDTH  : integer := 6;
        DEPTH       : integer := 64);
    port (
        clk         : in  std_logic;
        reset       : in  std_logic;
        clk_en      : in  std_logic;
        we          : in  std_logic;
        waddr       : in  UNSIGNED(ADDR_WIDTH-1 downto 0);
        din         : in  UNSIGNED(DATA_WIDTH-1 downto 0);
        re          : in  std_logic;
        raddr       : in  UNSIGNED(ADDR_WIDTH-1 downto 0);
        dout        : out UNSIGNED(DATA_WIDTH-1 downto 0));
end mm2s_gmem_m_axi_mem;

architecture behav of mm2s_gmem_m_axi_mem is
    type MEM_ARRAY is array (0 to DEPTH - 2) of UNSIGNED(DATA_WIDTH - 1 downto 0);
    signal mem : MEM_ARRAY;
    attribute ram_style: string;
    attribute ram_style of mem: signal is MEM_STYLE;
begin
    process (clk) begin
        if clk'event and clk = '1' then
            if reset = '1' then
                dout <= ( others=> '0');
            elsif (clk_en = '1' and re = '1') then
                dout <= mem(to_integer(raddr));
            end if;
        end if;
    end process;

    process (clk) begin
        if clk'event and clk = '1' then
            if clk_en = '1' and we = '1' then
                mem(to_integer(waddr)) <= din;
            end if;
        end if;
    end process;
end architecture behav;
